/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.core.base;

import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.python.pydev.ast.refactoring.RefactoringInfo;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.refactoring.core.base.PyDocumentChange;
import org.python.pydev.refactoring.core.base.SynchronizedTextFileChange;
import org.python.pydev.refactoring.core.change.IChangeProcessor;
import org.python.pydev.refactoring.core.edit.AbstractTextEdit;
import org.python.pydev.refactoring.core.request.IRefactoringRequest;
import org.python.pydev.refactoring.core.request.IRequestProcessor;

public abstract class AbstractFileChangeProcessor<T extends IRefactoringRequest>
implements IChangeProcessor {
    private TextChange change;
    private MultiTextEdit multiEdit;
    private String name;
    private RefactoringInfo info;
    protected final IRequestProcessor<T> requestProcessor;

    public AbstractFileChangeProcessor(String name, RefactoringInfo info, IRequestProcessor<T> requestProcessor) {
        this.name = name;
        this.info = info;
        this.requestProcessor = requestProcessor;
    }

    protected abstract void processEdit() throws MisconfigurationException;

    @Override
    public Change createChange() throws MisconfigurationException {
        if (this.info.getSourceFile() != null) {
            this.change = new SynchronizedTextFileChange(this.name, this.info.getSourceFile());
            this.change.setTextType("py");
        } else {
            this.change = PyDocumentChange.create((String)this.name, (IDocument)this.info.getDocument());
        }
        this.multiEdit = new MultiTextEdit();
        this.change.setEdit((TextEdit)this.multiEdit);
        this.processEdit();
        return this.change;
    }

    protected void registerEdit(AbstractTextEdit edit, String message) throws MisconfigurationException {
        TextEditGroup editGroup = new TextEditGroup(message);
        this.addGroup(editGroup);
        this.registerEditInGroup(edit, editGroup);
    }

    protected void registerEdit(List<AbstractTextEdit> edits, String message) throws MisconfigurationException {
        TextEditGroup group = new TextEditGroup(message);
        this.addGroup(group);
        for (AbstractTextEdit edit : edits) {
            this.registerEditInGroup(edit, group);
        }
    }

    private void addGroup(TextEditGroup group) {
        this.change.addTextEditGroup(group);
    }

    private void registerEditInGroup(AbstractTextEdit edit, TextEditGroup editGroup) throws MisconfigurationException {
        TextEdit textEdit = edit.getEdit();
        editGroup.addTextEdit(textEdit);
        this.multiEdit.addChild(textEdit);
    }
}

