/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.ast.adapters.AbstractScopeNode;
import org.python.pydev.ast.adapters.FunctionDefAdapter;
import org.python.pydev.ast.adapters.IClassDefAdapter;
import org.python.pydev.ast.adapters.ModuleAdapter;
import org.python.pydev.ast.adapters.PropertyAdapter;
import org.python.pydev.ast.adapters.SimpleAdapter;
import org.python.pydev.ast.adapters.context.LocalAttributeVisitor;
import org.python.pydev.ast.adapters.context.PropertyVisitor;
import org.python.pydev.ast.adapters.context.ScopeAssignedVisitor;
import org.python.pydev.ast.adapters.visitors.VisitorFactory;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;

public class ClassDefAdapter
extends AbstractScopeNode<ClassDef>
implements IClassDefAdapter {
    private static final String OBJECT = "object";
    private List<SimpleAdapter> attributes = null;
    private List<PropertyAdapter> properties = null;

    public ClassDefAdapter(ModuleAdapter module, AbstractScopeNode<?> parent, ClassDef node, AdapterPrefs adapterPrefs) {
        super(module, (AbstractScopeNode<? extends SimpleNode>)parent, node, adapterPrefs);
    }

    @Override
    public List<String> getBaseClassNames() {
        return this.nodeHelper.getBaseClassName(this.getASTNode());
    }

    @Override
    public List<IClassDefAdapter> getBaseClasses() throws MisconfigurationException {
        return this.getModule().getBaseClasses(this);
    }

    @Override
    public boolean hasBaseClass() {
        return this.getBaseClassNames().size() > 0;
    }

    @Override
    public List<SimpleAdapter> getAttributes() {
        if (this.attributes == null) {
            LocalAttributeVisitor visitor = VisitorFactory.createContextVisitor(LocalAttributeVisitor.class, this.getASTNode(), this.getModule(), this);
            this.attributes = visitor.getAll();
        }
        return this.attributes;
    }

    @Override
    public List<PropertyAdapter> getProperties() {
        if (this.properties == null) {
            PropertyVisitor visitor = VisitorFactory.createContextVisitor(PropertyVisitor.class, this.getASTNode(), this.getModule(), this);
            this.properties = visitor.getAll();
        }
        return this.properties;
    }

    @Override
    public List<FunctionDefAdapter> getFunctionsInitFiltered() {
        ArrayList<FunctionDefAdapter> functionsFiltered = new ArrayList<FunctionDefAdapter>();
        for (FunctionDefAdapter adapter : this.getFunctions()) {
            if (adapter.isInit()) continue;
            functionsFiltered.add(adapter);
        }
        return functionsFiltered;
    }

    @Override
    public boolean hasFunctions() {
        return this.getFunctions().size() > 0;
    }

    @Override
    public boolean hasFunctionsInitFiltered() {
        return this.getFunctionsInitFiltered().size() > 0;
    }

    @Override
    public boolean isNested() {
        return this.nodeHelper.isFunctionOrClassDef(this.getParent().getASTNode());
    }

    @Override
    public boolean hasAttributes() {
        return this.getAttributes().size() > 0;
    }

    @Override
    public String getNodeBodyIndent() {
        ClassDef classNode = (ClassDef)this.getASTNode();
        if (classNode.body == null || classNode.body.length == 0) {
            PySelection pySelection = new PySelection(this.getModule().getDoc());
            String indentationFromLine = PySelection.getIndentationFromLine((String)pySelection.getLine(classNode.beginLine - 1));
            return indentationFromLine + DefaultIndentPrefs.get((IAdaptable)this.getAdapterPrefs().projectAdaptable).getIndentationString();
        }
        return this.getModule().getIndentationFromAst((SimpleNode)classNode.body[0]);
    }

    @Override
    public boolean hasInit() {
        return this.getFirstInit() != null;
    }

    @Override
    public FunctionDefAdapter getFirstInit() {
        for (FunctionDefAdapter func : this.getFunctions()) {
            if (!func.isInit()) continue;
            return func;
        }
        return null;
    }

    @Override
    public List<SimpleAdapter> getAssignedVariables() {
        ScopeAssignedVisitor visitor = VisitorFactory.createContextVisitor(ScopeAssignedVisitor.class, this.getASTNode(), this.getModule(), this);
        return visitor.getAll();
    }

    @Override
    public boolean isNewStyleClass() {
        for (String base : this.getBaseClassNames()) {
            if (base.compareTo(OBJECT) != 0) continue;
            return true;
        }
        return false;
    }
}

