/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.adapters;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.ast.adapters.AbstractScopeNode;
import org.python.pydev.ast.adapters.FunctionArgAdapter;
import org.python.pydev.ast.adapters.ModuleAdapter;
import org.python.pydev.ast.adapters.SimpleAdapter;
import org.python.pydev.ast.adapters.context.LocalFunctionDefVisitor;
import org.python.pydev.ast.adapters.context.ScopeAssignedVisitor;
import org.python.pydev.ast.adapters.visitors.VisitorFactory;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;

public class FunctionDefAdapter
extends AbstractScopeNode<FunctionDef> {
    private FunctionArgAdapter arguments;
    private List<FunctionDefAdapter> functions;

    public FunctionDefAdapter(ModuleAdapter module, AbstractScopeNode<?> parent, FunctionDef node, AdapterPrefs adapterPrefs) {
        super(module, (AbstractScopeNode<? extends SimpleNode>)parent, node, adapterPrefs);
        this.arguments = new FunctionArgAdapter(this.getModule(), this, ((FunctionDef)this.getASTNode()).args, adapterPrefs);
        this.functions = null;
    }

    public FunctionArgAdapter getArguments() {
        return this.arguments;
    }

    public boolean isInit() {
        return this.nodeHelper.isInit(this.getASTNode());
    }

    public boolean isDefaultInit() {
        return this.isInit() && (this.arguments.isEmptyArgument() || this.arguments.hasOnlySelf());
    }

    public String getSignature() {
        return this.arguments.getSignature();
    }

    @Override
    public String getNodeBodyIndent() {
        FunctionDef functionNode = (FunctionDef)this.getASTNode();
        if (functionNode.body == null || functionNode.body.length == 0) {
            PySelection pySelection = new PySelection(this.getModule().getDoc());
            String indentationFromLine = PySelection.getIndentationFromLine((String)pySelection.getLine(functionNode.beginLine - 1));
            return indentationFromLine + DefaultIndentPrefs.get((IAdaptable)this.getAdapterPrefs().projectAdaptable).getIndentationString();
        }
        return this.getModule().getIndentationFromAst((SimpleNode)functionNode.body[0]);
    }

    @Override
    public List<FunctionDefAdapter> getFunctions() {
        if (this.functions == null) {
            LocalFunctionDefVisitor visitor = null;
            visitor = VisitorFactory.createContextVisitor(LocalFunctionDefVisitor.class, this.getASTNode(), this.getModule(), this);
            this.functions = visitor.getAll();
        }
        return this.functions;
    }

    @Override
    public List<SimpleAdapter> getAssignedVariables() {
        ScopeAssignedVisitor visitor = VisitorFactory.createContextVisitor(ScopeAssignedVisitor.class, this.getASTNode(), this.getModule(), this);
        return visitor.getAll();
    }
}

