/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.adapters;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.python.pydev.ast.adapters.AbstractScopeNode;
import org.python.pydev.ast.adapters.ClassDefAdapterFromClassDef;
import org.python.pydev.ast.adapters.ClassDefAdapterFromTokens;
import org.python.pydev.ast.adapters.FQIdentifier;
import org.python.pydev.ast.adapters.FunctionDefAdapter;
import org.python.pydev.ast.adapters.IASTNodeAdapter;
import org.python.pydev.ast.adapters.IClassDefAdapter;
import org.python.pydev.ast.adapters.PythonModuleManager;
import org.python.pydev.ast.adapters.SimpleAdapter;
import org.python.pydev.ast.adapters.offsetstrategy.BeforeCurrentOffset;
import org.python.pydev.ast.adapters.offsetstrategy.BeginOffset;
import org.python.pydev.ast.adapters.offsetstrategy.EndOffset;
import org.python.pydev.ast.adapters.offsetstrategy.IOffsetStrategy;
import org.python.pydev.ast.adapters.offsetstrategy.InitOffset;
import org.python.pydev.ast.adapters.visitors.ImportVisitor;
import org.python.pydev.ast.codecompletion.revisited.AbstractASTManager;
import org.python.pydev.ast.codecompletion.revisited.AbstractToken;
import org.python.pydev.ast.codecompletion.revisited.CompletionCache;
import org.python.pydev.ast.codecompletion.revisited.CompletionState;
import org.python.pydev.ast.codecompletion.revisited.modules.CompiledToken;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISourceModule;
import org.python.pydev.core.IToken;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.shared_core.string.CoreTextSelection;
import org.python.pydev.shared_core.string.ICoreTextSelection;

public class ModuleAdapter
extends AbstractScopeNode<Module> {
    private List<FQIdentifier> aliasToFQIdentifier;
    private IDocument doc;
    private File file;
    private SortedMap<String, String> importedModules;
    private IOffsetStrategy offsetStrategy;
    private ISourceModule sourceModule;
    public final IPythonNature nature;

    public String getEndLineDelimiter() {
        return TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
    }

    public ModuleAdapter(PythonModuleManager pm, File file, IDocument doc, Module node, IPythonNature nature) {
        super((ModuleAdapter)null, (AbstractScopeNode<? extends SimpleNode>)null, node, new AdapterPrefs(TextUtilities.getDefaultLineDelimiter((IDocument)doc), (IGrammarVersionProvider)nature));
        this.file = file;
        this.doc = doc;
        this.aliasToFQIdentifier = null;
        this.importedModules = null;
        this.nature = nature;
    }

    public ModuleAdapter(PythonModuleManager pm, ISourceModule module, IPythonNature nature, IDocument doc) {
        this.file = module.getFile();
        this.doc = doc != null ? doc : PythonModuleManager.getDocFromFile(this.file);
        this.init(null, null, (Module)module.getAst(), new AdapterPrefs(TextUtilities.getDefaultLineDelimiter((IDocument)this.doc), (IGrammarVersionProvider)nature));
        this.sourceModule = module;
        this.aliasToFQIdentifier = null;
        this.importedModules = null;
        this.nature = nature;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ModuleAdapter) {
            ModuleAdapter other = (ModuleAdapter)obj;
            String otherPath = other.getFile().getAbsolutePath();
            return this.file.getAbsolutePath().equalsIgnoreCase(otherPath);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.file.getAbsolutePath().toLowerCase().hashCode();
    }

    public List<FQIdentifier> getAliasToIdentifier() {
        if (this.aliasToFQIdentifier == null) {
            this.initAliasList();
        }
        return this.aliasToFQIdentifier;
    }

    public List<IClassDefAdapter> getClassHierarchy(IClassDefAdapter scopeClass) throws MisconfigurationException {
        ArrayList<IClassDefAdapter> bases = new ArrayList<IClassDefAdapter>();
        this.resolveClassHierarchy(bases, scopeClass, new HashSet<String>());
        Collections.reverse(bases);
        return bases;
    }

    public String getBaseContextName(IClassDefAdapter contextClass, String originalName) {
        if ((originalName = this.resolveRealToAlias(originalName)).startsWith("__builtin__.")) {
            originalName = originalName.substring(12);
        } else if (originalName.startsWith("builtins.")) {
            originalName = originalName.substring(9);
        }
        for (String baseName : contextClass.getBaseClassNames()) {
            if (!baseName.endsWith(originalName)) continue;
            return baseName;
        }
        return originalName;
    }

    private String resolveRealToAlias(String originalName) {
        for (FQIdentifier identifier : this.getAliasToIdentifier()) {
            if (identifier.getRealName().compareTo(originalName) != 0) continue;
            originalName = identifier.getAlias();
        }
        return originalName;
    }

    private File getFile() {
        return this.file;
    }

    public List<String> getGlobalVariableNames() {
        ArrayList<String> globalNames;
        block6: {
            globalNames = new ArrayList<String>();
            if (this.sourceModule != null && this.nature != null) {
                try {
                    ICodeCompletionASTManager astManager = this.nature.getAstManager();
                    if (astManager == null) break block6;
                    TokensList tokens = astManager.getCompletionsForModule((IModule)this.sourceModule, (ICompletionState)new CompletionState(-1, -1, "", this.nature, ""));
                    for (IterTokenEntry entry : tokens) {
                        IToken token = entry.getToken();
                        globalNames.add(token.getRepresentation());
                    }
                }
                catch (CompletionRecursionException e) {
                    Log.log((Throwable)e);
                }
            } else {
                for (SimpleAdapter adapter : this.getAssignedVariables()) {
                    globalNames.add(adapter.getName());
                }
            }
        }
        return globalNames;
    }

    @Override
    public ModuleAdapter getModule() {
        return this;
    }

    @Override
    public AbstractScopeNode<?> getParent() {
        return this;
    }

    public int getOffset(IASTNodeAdapter<? extends SimpleNode> adapter, int strategy, AbstractScopeNode<?> scopeAdapter) {
        int offset = 0;
        this.setStrategy(adapter, strategy, scopeAdapter);
        try {
            offset = this.offsetStrategy.getOffset();
        }
        catch (BadLocationException e) {
            String src = this.doc.get();
            int nameIndex = src.indexOf(adapter.getName());
            return src.indexOf(":", nameIndex) + 2;
        }
        return offset;
    }

    public SortedMap<String, String> getRegularImportedModules() {
        if (this.importedModules == null) {
            this.initAliasList();
        }
        return this.importedModules;
    }

    public IClassDefAdapter getScopeClass(ICoreTextSelection selection) {
        IClassDefAdapter bestClassScope = null;
        for (IClassDefAdapter classScope : this.getClasses()) {
            if (this.isSelectionInAdapter(selection, classScope)) {
                bestClassScope = classScope;
            }
            if (classScope.getNodeFirstLine(false) > selection.getEndLine()) break;
        }
        return bestClassScope;
    }

    private void initAliasList() {
        ImportVisitor visitor = new ImportVisitor();
        try {
            ((Module)this.getASTNode()).accept((VisitorIF)visitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.importedModules = visitor.getImportedModules();
        this.aliasToFQIdentifier = visitor.getAliasToFQIdentifier();
    }

    public boolean isGlobal(String name) {
        return this.getGlobalVariableNames().contains(name);
    }

    private boolean isSelectionInAdapter(ICoreTextSelection selection, IASTNodeAdapter<? extends SimpleNode> adapter) {
        int startOffSet = selection.getOffset();
        int endOffSet = selection.getOffset() + selection.getLength();
        try {
            int lastLine = adapter.getNodeLastLine() - 1;
            int adapterStartOffset = this.doc.getLineOffset(adapter.getNodeFirstLine(false) - 1) + adapter.getNodeIndent();
            int adapterEndOffset = this.doc.getLineOffset(lastLine) + this.doc.getLineLength(lastLine);
            return adapterStartOffset <= startOffSet && adapterEndOffset >= endOffSet;
        }
        catch (BadLocationException e) {
            throw new RuntimeException("Internal error, bad location exception" + e.getMessage());
        }
    }

    private boolean isAdapterInSelection(ICoreTextSelection selection, IASTNodeAdapter<? extends SimpleNode> adapter) {
        int selectionStart = selection.getOffset();
        int selectionEnd = selection.getOffset() + selection.getLength();
        try {
            int adapterStart = this.getStartOffset(adapter);
            return adapterStart >= selectionStart && adapterStart < selectionEnd;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public int getEndOffset(IASTNodeAdapter<? extends SimpleNode> adapter, int adapterStartOffset) throws BadLocationException {
        int lastLine = adapter.getNodeLastLine() - 1;
        int adapterEndOffset = 0;
        adapterEndOffset = adapter.getASTNode() instanceof Str ? (adapterEndOffset += adapterStartOffset + adapter.getName().length()) : this.doc.getLineOffset(lastLine) + this.doc.getLineLength(lastLine);
        return adapterEndOffset;
    }

    public int getStartOffset(SimpleNode node) throws BadLocationException {
        return this.getStartOffset(new SimpleAdapter(this, (AbstractScopeNode<?>)this, node, this.getAdapterPrefs()));
    }

    public int getStartOffset(IASTNodeAdapter<? extends SimpleNode> adapter) throws BadLocationException {
        return this.doc.getLineOffset(adapter.getNodeFirstLine(false) - 1) + adapter.getNodeIndent();
    }

    public boolean isNodeInSelection(ICoreTextSelection selection, SimpleNode node) {
        return this.isAdapterInSelection(selection, new SimpleAdapter(this, (AbstractScopeNode<?>)this, node, this.getAdapterPrefs()));
    }

    private IClassDefAdapter resolveClassHierarchy(List<IClassDefAdapter> bases, IClassDefAdapter adap, Set<String> memo) throws MisconfigurationException {
        if (adap.hasBaseClass() && adap.getModule() != null) {
            List<IClassDefAdapter> baseClasses = adap.getModule().getBaseClasses(adap);
            for (IClassDefAdapter elem : baseClasses) {
                if (elem == null || memo.contains(elem.getName())) continue;
                memo.add(elem.getName());
                bases.add(this.resolveClassHierarchy(bases, elem, memo));
            }
        }
        return adap;
    }

    public List<IClassDefAdapter> getBaseClasses(IClassDefAdapter clazz) {
        Set<IClassDefAdapter> resolved;
        CompletionCache completionCache = new CompletionCache();
        List<String> baseNames = clazz.getBaseClassNames();
        HashSet<String> classesToResolve = new HashSet<String>(baseNames);
        try {
            resolved = this.resolveImportedClass(classesToResolve, completionCache);
        }
        catch (MisconfigurationException e) {
            throw new RuntimeException(e);
        }
        return new ArrayList<IClassDefAdapter>(resolved);
    }

    public IClassDefAdapter resolveClass(String name) {
        Set<IClassDefAdapter> resolved;
        CompletionCache completionCache = new CompletionCache();
        HashSet<String> toResolve = new HashSet<String>();
        toResolve.add(name);
        try {
            resolved = this.resolveImportedClass(toResolve, completionCache);
        }
        catch (MisconfigurationException e) {
            throw new RuntimeException(e);
        }
        if (toResolve.size() == 1) {
            return resolved.iterator().next();
        }
        return null;
    }

    public List<FQIdentifier> resolveFullyQualified(String aliasName) {
        ArrayList<FQIdentifier> qualifiedIdentifiers = new ArrayList<FQIdentifier>();
        String fqPrefix = "";
        String aliasIdentifier = "";
        int longestMatch = 0;
        for (String module : this.getRegularImportedModules().keySet()) {
            if (!aliasName.startsWith(module) || module.length() <= longestMatch) continue;
            fqPrefix = (String)this.getRegularImportedModules().get(module);
            longestMatch = module.length();
        }
        if (longestMatch > 0) {
            if (aliasName.length() > longestMatch) {
                aliasIdentifier = aliasName.substring(longestMatch + 1);
            }
            qualifiedIdentifiers.add(new FQIdentifier(fqPrefix, aliasIdentifier, aliasIdentifier));
            return qualifiedIdentifiers;
        }
        for (FQIdentifier identifier : this.getAliasToIdentifier()) {
            if (!aliasName.startsWith(identifier.getAlias())) continue;
            String attribute = aliasName.substring(identifier.getAlias().length());
            FQIdentifier id = new FQIdentifier(identifier.getModule(), identifier.getRealName() + attribute, identifier.getAlias() + attribute);
            qualifiedIdentifiers.add(id);
            return qualifiedIdentifiers;
        }
        for (String moduleAlias : this.getRegularImportedModules().keySet()) {
            qualifiedIdentifiers.add(new FQIdentifier((String)this.getRegularImportedModules().get(moduleAlias), aliasName, aliasName));
        }
        return qualifiedIdentifiers;
    }

    private Set<IClassDefAdapter> resolveImportedClass(Set<String> importedBase, CompletionCache completionCache) throws MisconfigurationException {
        IModule module;
        HashSet<IClassDefAdapter> bases = new HashSet<IClassDefAdapter>();
        HashSet<ClassDef> alreadyTreated = new HashSet<ClassDef>();
        try {
            module = AbstractASTManager.createModule(this.file, this.doc, this.nature);
        }
        catch (MisconfigurationException e1) {
            throw new RuntimeException(e1);
        }
        for (String baseName : importedBase) {
            CompletionState state = new CompletionState(-1, -1, baseName, this.nature, "", completionCache);
            TokensList ret = null;
            try {
                ret = this.nature.getAstManager().getCompletionsForModule(module, (ICompletionState)state);
            }
            catch (CompletionRecursionException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, ArrayList<AbstractToken>> map = new HashMap<String, ArrayList<AbstractToken>>();
            HashSet<ClassDef> classDefAsts = new HashSet<ClassDef>();
            for (IterTokenEntry iterTokenEntry : ret) {
                AbstractToken token;
                IToken tok = iterTokenEntry.getToken();
                if (tok instanceof SourceToken) {
                    ClassDef classDefAst;
                    token = (SourceToken)tok;
                    SimpleNode ast = ((SourceToken)token).getAst();
                    if (!(ast instanceof ClassDef) && !(ast instanceof FunctionDef) || !(ast.parent instanceof ClassDef) || alreadyTreated.contains(classDefAst = (ClassDef)ast.parent)) continue;
                    classDefAsts.add(classDefAst);
                    alreadyTreated.add(classDefAst);
                    continue;
                }
                if (tok instanceof CompiledToken) {
                    token = (CompiledToken)tok;
                    ArrayList<AbstractToken> toks = (ArrayList<AbstractToken>)map.get(token.getParentPackage());
                    if (toks == null) {
                        toks = new ArrayList<AbstractToken>();
                        map.put(token.getParentPackage(), toks);
                    }
                    toks.add(token);
                    continue;
                }
                throw new RuntimeException("Unexpected token:" + String.valueOf(tok.getClass()));
            }
            for (Map.Entry entry : map.entrySet()) {
                bases.add(new ClassDefAdapterFromTokens(this, (String)entry.getKey(), (List)entry.getValue(), this.getAdapterPrefs()));
            }
            for (ClassDef classDef : classDefAsts) {
                bases.add(new ClassDefAdapterFromClassDef(this, classDef, this.getAdapterPrefs()));
            }
        }
        return bases;
    }

    public void setStrategy(IASTNodeAdapter<? extends SimpleNode> adapter, int strategy, AbstractScopeNode<?> scopeAdapter) {
        switch (strategy) {
            case 1: {
                this.offsetStrategy = new InitOffset(adapter, this.doc, this.getAdapterPrefs());
                break;
            }
            case 8: {
                this.offsetStrategy = new BeforeCurrentOffset(adapter, this.doc, this.getAdapterPrefs(), scopeAdapter);
                break;
            }
            case 2: {
                this.offsetStrategy = new BeginOffset(adapter, this.doc, this.getAdapterPrefs());
                break;
            }
            case 4: {
                this.offsetStrategy = new EndOffset(adapter, this.doc, this.getAdapterPrefs());
                break;
            }
            default: {
                this.offsetStrategy = new BeginOffset(adapter, this.doc, this.getAdapterPrefs());
            }
        }
    }

    public AbstractScopeNode<?> getScopeAdapter(ICoreTextSelection selection) {
        AbstractScopeNode bestScopeNode = null;
        bestScopeNode = this.getScopeFunction(selection);
        if (bestScopeNode != null) {
            return bestScopeNode;
        }
        bestScopeNode = (AbstractScopeNode)((Object)this.getScopeClass(selection));
        if (bestScopeNode != null) {
            return bestScopeNode;
        }
        return this;
    }

    private AbstractScopeNode<?> getScopeFunction(ICoreTextSelection selection) {
        FunctionDefAdapter scopeAdapter = null;
        for (FunctionDefAdapter functionScope : this.getFunctions()) {
            if (this.isSelectionInAdapter(selection, functionScope)) {
                scopeAdapter = functionScope;
            }
            if (functionScope.getNodeFirstLine(false) > selection.getEndLine()) break;
        }
        return scopeAdapter;
    }

    @Override
    public String getNodeBodyIndent() {
        return "";
    }

    @Override
    public int getNodeIndent() {
        return 0;
    }

    public List<SimpleAdapter> getWithinSelection(ICoreTextSelection selection, List<SimpleAdapter> variables) {
        ArrayList<SimpleAdapter> withinOffsetAdapters = new ArrayList<SimpleAdapter>();
        for (SimpleAdapter adapter : variables) {
            if (!this.isAdapterInSelection(selection, adapter)) continue;
            withinOffsetAdapters.add(adapter);
        }
        return withinOffsetAdapters;
    }

    public ICoreTextSelection extendSelection(ICoreTextSelection selection, SimpleNode nodeStart, SimpleNode nodeEnd) {
        if (this.doc != null) {
            try {
                int startOffset = this.getStartOffset(nodeStart);
                int endOffset = this.getStartOffset(nodeEnd) - 1;
                if (startOffset > selection.getOffset()) {
                    startOffset = selection.getOffset();
                }
                if (endOffset < selection.getOffset() + selection.getLength()) {
                    endOffset = selection.getOffset() + selection.getLength();
                }
                selection = new CoreTextSelection(this.doc, startOffset, endOffset - startOffset);
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
        }
        return this.normalizeSelection(selection);
    }

    public ICoreTextSelection normalizeSelection(ICoreTextSelection userSelection) {
        String txt = userSelection.getText();
        while (txt != null && (txt.startsWith(" ") || txt.startsWith("\n") || txt.startsWith("\r"))) {
            userSelection = new CoreTextSelection(this.doc, userSelection.getOffset() + 1, userSelection.getLength() - 1);
            txt = userSelection.getText();
        }
        while (txt != null && (txt.endsWith(" ") || txt.endsWith("\n") || txt.endsWith("\r"))) {
            userSelection = new CoreTextSelection(this.doc, userSelection.getOffset(), userSelection.getLength() - 1);
            txt = userSelection.getText();
        }
        return userSelection;
    }

    public ICoreTextSelection extendSelectionToEnd(ICoreTextSelection selection, SimpleNode node) {
        if (this.doc != null) {
            SimpleAdapter adapter = new SimpleAdapter(this, (AbstractScopeNode<?>)this, node, this.getAdapterPrefs());
            int lastLine = adapter.getNodeLastLine() - 1;
            try {
                int adapterEndOffset = this.doc.getLineOffset(lastLine);
                selection = new CoreTextSelection(this.doc, selection.getOffset(), (adapterEndOffset += this.doc.getLineLength(lastLine)) - selection.getOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return selection;
    }

    public ICoreTextSelection extendSelection(ICoreTextSelection selection, SimpleNode node) {
        if (this.doc != null && node instanceof Str) {
            SimpleAdapter adapter = new SimpleAdapter(this, (AbstractScopeNode<?>)this, node, this.getAdapterPrefs());
            try {
                int endOffset;
                int startOffset = this.getStartOffset(adapter);
                if (startOffset > selection.getOffset()) {
                    startOffset = selection.getOffset();
                }
                if ((endOffset = startOffset + adapter.getName().length() + 2) < selection.getOffset() + selection.getLength()) {
                    endOffset = selection.getOffset() + selection.getLength();
                }
                selection = new CoreTextSelection(this.doc, startOffset, endOffset - startOffset);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return selection;
    }

    @Override
    public int getNodeFirstLine(boolean considerDecorators) {
        Module astNode = (Module)this.getASTNode();
        int i = 0;
        while (i < astNode.body.length) {
            stmtType node = astNode.body[i];
            if (!this.nodeHelper.isImport((SimpleNode)node) && !this.nodeHelper.isStr((SimpleNode)node)) {
                if (!considerDecorators) {
                    return node.beginLine;
                }
                return this.nodeHelper.getFirstLineConsideringDecorators((SimpleNode)node);
            }
            ++i;
        }
        return 1;
    }

    public boolean isImport(String name) {
        for (String module : this.getRegularImportedModules().keySet()) {
            if (module.compareTo(name) != 0) continue;
            return true;
        }
        for (FQIdentifier fq : this.getAliasToIdentifier()) {
            if (fq.getAlias().compareTo(name) != 0) continue;
            return true;
        }
        return false;
    }

    public int getStartLineBefore(int selectionOffset) throws Exception {
        int lineOfOffset = this.doc.getLineOfOffset(selectionOffset);
        return this.doc.getLineOffset(lineOfOffset);
    }

    public IDocument getDoc() {
        return this.doc;
    }

    public String getIndentationFromAst(SimpleNode node) {
        PySelection pySelection = new PySelection(this.doc);
        return PySelection.getIndentationFromLine((String)pySelection.getLine(node.beginLine - 1));
    }

    public IModule getIModule() {
        return this.sourceModule;
    }
}

