/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.adapters.visitors;

import java.io.File;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.adapters.AbstractNodeAdapter;
import org.python.pydev.ast.adapters.AbstractScopeNode;
import org.python.pydev.ast.adapters.ModuleAdapter;
import org.python.pydev.ast.adapters.PythonModuleManager;
import org.python.pydev.ast.adapters.context.AbstractContextVisitor;
import org.python.pydev.ast.adapters.visitors.CannotCreateContextRuntimeException;
import org.python.pydev.ast.adapters.visitors.FindDuplicatesVisitor;
import org.python.pydev.ast.adapters.visitors.selection.SelectionException;
import org.python.pydev.ast.adapters.visitors.selection.SelectionExtenderVisitor;
import org.python.pydev.ast.adapters.visitors.selection.SelectionValidationVisitor;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.core.BaseModuleRequest;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISourceModule;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.parsing.BaseParser;
import org.python.pydev.shared_core.string.ICoreTextSelection;

public final class VisitorFactory {
    private VisitorFactory() {
    }

    public static <T extends AbstractContextVisitor> T createContextVisitor(Class<T> visitorClass, SimpleNode root, ModuleAdapter module, AbstractNodeAdapter parent) {
        try {
            AbstractContextVisitor visitor = (AbstractContextVisitor)((Object)visitorClass.getConstructors()[0].newInstance(module, parent));
            root.accept((VisitorIF)visitor);
            return (T)((Object)visitor);
        }
        catch (Exception e) {
            throw new CannotCreateContextRuntimeException(e);
        }
    }

    public static FindDuplicatesVisitor createDuplicatesVisitor(ICoreTextSelection selection, SimpleNode nodeToVisit, exprType expression, AbstractScopeNode node, IDocument doc) {
        FindDuplicatesVisitor visitor = new FindDuplicatesVisitor(selection, expression, doc);
        try {
            nodeToVisit.accept((VisitorIF)visitor);
            visitor.finish();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return visitor;
    }

    public static <T extends VisitorIF> T createVisitor(Class<T> visitorClass, SimpleNode root) {
        VisitorIF visitor = null;
        try {
            visitor = (VisitorIF)visitorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            root.accept(visitor);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return (T)visitor;
    }

    public static ModuleAdapter createModuleAdapter(PythonModuleManager pythonModuleManager, File file, IDocument doc, IPythonNature nature, IGrammarVersionProvider versionProvider) throws Throwable {
        return VisitorFactory.createModuleAdapter(pythonModuleManager, file, doc, nature, versionProvider, false);
    }

    public static ModuleAdapter createModuleAdapter(PythonModuleManager pythonModuleManager, File file, IDocument doc, IPythonNature nature, IGrammarVersionProvider versionProvider, boolean acceptSyntaxErrors) throws Throwable {
        if (file != null && file.exists()) {
            IModule module;
            String modName;
            IModulesManager modulesManager;
            if (FileTypesPreferences.isCythonFile((String)file.getName())) {
                versionProvider = new IGrammarVersionProvider(){

                    public int getGrammarVersion() throws MisconfigurationException {
                        return 777;
                    }

                    public IGrammarVersionProvider.AdditionalGrammarVersionsToCheck getAdditionalGrammarVersions() throws MisconfigurationException {
                        return null;
                    }
                };
            }
            if (pythonModuleManager != null && (modulesManager = pythonModuleManager.getIModuleManager()) != null && (modName = modulesManager.resolveModule(FileUtils.getFileAbsolutePath((File)file))) != null && (module = modulesManager.getModule(modName, nature, true, (IModuleRequestState)new BaseModuleRequest(false))) instanceof ISourceModule) {
                SourceModule iSourceModule = (SourceModule)module;
                if (!acceptSyntaxErrors && iSourceModule.parseError != null) {
                    throw iSourceModule.parseError;
                }
                return new ModuleAdapter(pythonModuleManager, (ISourceModule)module, nature, doc);
            }
        }
        BaseParser.ParseOutput output = PyParser.parseFull((IDocument)doc, (IGrammarVersionProvider)versionProvider);
        if (!acceptSyntaxErrors && output.error != null) {
            throw output.error;
        }
        ISimpleNode module = output.ast;
        return new ModuleAdapter(pythonModuleManager, file, doc, (Module)module, nature);
    }

    public static void validateSelection(ModuleAdapter scope) throws SelectionException {
        SelectionValidationVisitor visitor = null;
        try {
            visitor = new SelectionValidationVisitor();
            ((Module)scope.getASTNode()).accept((VisitorIF)visitor);
        }
        catch (SelectionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static ICoreTextSelection createSelectionExtension(AbstractScopeNode<?> scope, ICoreTextSelection selection) {
        SelectionExtenderVisitor visitor = null;
        try {
            visitor = new SelectionExtenderVisitor(scope.getModule(), selection);
            scope.getASTNode().accept((VisitorIF)visitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return visitor.getSelection();
    }
}

