/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.assist_assign;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.python.pydev.core.IAssistProps;
import org.python.pydev.core.ICodingStd;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.PyDevCodeStylePreferences;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.core.templates.PyAddTemplateResolvers;
import org.python.pydev.core.templates.PyDocumentTemplateContext;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;

public class AssistAssign
implements IAssistProps {
    private ICodingStd std;

    public AssistAssign() {
        this(new ICodingStd(){

            public boolean localsAndAttrsCamelcase() {
                return PyDevCodeStylePreferences.useLocalsAndAttrsCamelCase();
            }
        });
    }

    public AssistAssign(ICodingStd std) {
        this.std = std;
    }

    private IImageHandle getImage(IImageCache imageCache, String c) {
        if (imageCache != null) {
            return imageCache.get(c);
        }
        return null;
    }

    public List<ICompletionProposalHandle> getProps(PySelection ps, IImageCache imageCache, File f, IPythonNature nature, IPyEdit edit, int offset) throws BadLocationException {
        return this.getProps(ps, imageCache, edit, offset, TextSelectionUtils.getLineWithoutComments((TextSelectionUtils)ps), PySelection.getFirstCharPosition((IDocument)ps.getDoc(), (int)ps.getAbsoluteCursorOffset()), nature);
    }

    public List<ICompletionProposalHandle> getProps(PySelection ps, IImageCache imageCache, IPyEdit edit, int offset, String lineWithoutComments, int firstCharAbsolutePosition, IPythonNature nature) throws BadLocationException {
        IIndentPrefs indentPrefs;
        ArrayList<ICompletionProposalHandle> l = new ArrayList<ICompletionProposalHandle>();
        if (lineWithoutComments.trim().length() == 0) {
            return l;
        }
        String callName = this.getTokToAssign(ps);
        if (callName.length() > 0) {
            if (callName.toLowerCase().startsWith("get") && callName.length() > 3) {
                callName = callName.substring(3);
            }
            callName = this.changeToCodingStd(callName);
            int i = 0;
            while (i < callName.length()) {
                char c = callName.charAt(i);
                if (c != '_') {
                    callName = TextSelectionUtils.lowerChar((String)callName, (int)i);
                    break;
                }
                ++i;
            }
        } else {
            callName = "result";
        }
        String loc = callName;
        if (loc.startsWith("_")) {
            loc = loc.substring(1);
        }
        IIndentPrefs iIndentPrefs = indentPrefs = edit != null ? edit.getIndentPrefs() : null;
        if (indentPrefs == null) {
            indentPrefs = DefaultIndentPrefs.get((IAdaptable)nature);
        }
        IImageHandle localImg = this.getImage(imageCache, "icons/new/attrpub_obj.gif");
        IImageHandle clsImage = this.getImage(imageCache, "icons/new/attrpub_obj.gif");
        l.add(CompletionProposalFactory.get().createAssistAssignCompletionProposal("${" + loc + "} = ", firstCharAbsolutePosition, 0, 0, localImg, "Assign to local (" + loc + ")", null, null, 10, edit));
        l.add(CompletionProposalFactory.get().createAssistAssignCompletionProposal("self.${" + callName + "} = ", firstCharAbsolutePosition, 0, 5, clsImage, "Assign to field (self." + callName + ")", null, null, 10, edit));
        return l;
    }

    public static TemplateContext createContext(IRegion region, IDocument document, IIndentPrefs indentPrefs) {
        TemplateContextType contextType = new TemplateContextType();
        PyAddTemplateResolvers.addDefaultResolvers(contextType);
        return new PyDocumentTemplateContext(contextType, document, region.getOffset(), region.getLength(), "", indentPrefs);
    }

    private String changeToCodingStd(String callName) {
        if (this.std.localsAndAttrsCamelcase()) {
            return StringUtils.asStyleCamelCaseFirstLower((String)callName);
        }
        return StringUtils.asStyleLowercaseUnderscores((String)callName);
    }

    public boolean isValid(PySelection ps, String sel, IPyEdit edit, int offset) {
        return this.isValid(ps.getTextSelection().getLength(), sel, offset);
    }

    public boolean isValid(int selectionLength, String lineContents, int offset) {
        if (selectionLength != 0) {
            return false;
        }
        if (lineContents.indexOf("class ") != -1 || lineContents.indexOf("def ") != -1 || lineContents.indexOf("import ") != -1) {
            return false;
        }
        String eqReplaced = lineContents.replaceAll("==", "");
        if (eqReplaced.indexOf("=") != -1) {
            if (eqReplaced.indexOf(40) == -1) {
                return false;
            }
            int i = eqReplaced.indexOf(40);
            if (eqReplaced.substring(0, i).indexOf(61) != -1) {
                return false;
            }
        }
        return true;
    }

    private static String getStringToAnalyze(PySelection ps) {
        ParsingUtils parsingUtils = ParsingUtils.create((Object)ps.getDoc());
        FastStringBuffer buf = new FastStringBuffer();
        String string = null;
        try {
            parsingUtils.getFullFlattenedLine(ps.getStartLineOffset(), buf);
            if (buf.length() > 0) {
                string = buf.toString();
            }
        }
        catch (SyntaxErrorException e) {
            Log.log((Throwable)e);
        }
        if (string == null) {
            string = TextSelectionUtils.getLineWithoutComments((TextSelectionUtils)ps);
        }
        return string.trim();
    }

    private static String getBeforeParentesisTok(String string) {
        Object callName = "";
        int i = string.lastIndexOf("(");
        if (i != -1) {
            callName = "";
            int j = i - 1;
            while (j >= 0 && TextSelectionUtils.stillInTok((String)string, (int)j)) {
                callName = string.charAt(j) + (String)callName;
                --j;
            }
        }
        return callName;
    }

    private String getTokToAssign(PySelection ps) {
        String string = AssistAssign.getStringToAnalyze(ps);
        String tokToAssign = this.getTokToAssign(string);
        if (tokToAssign == null || tokToAssign.length() == 0) {
            return "result";
        }
        return tokToAssign;
    }

    private String changeToLowerUppercaseConstant(String callName) {
        if (StringUtils.isAllUpper((String)callName)) {
            return callName.toLowerCase();
        }
        return callName;
    }

    public String getTokToAssign(String string) {
        int i;
        string = string.trim();
        Object callName = "";
        String beforeParentesisTok = AssistAssign.getBeforeParentesisTok(string);
        if (beforeParentesisTok.length() > 0) {
            callName = beforeParentesisTok;
        } else {
            i = string.lastIndexOf(".");
            if (i != -1) {
                callName = "";
                int j = i + 1;
                while (j < string.length() && TextSelectionUtils.stillInTok((String)string, (int)j)) {
                    callName = (String)callName + string.charAt(j);
                    ++j;
                }
            }
            if (((String)callName).length() == 0 && PyStringUtils.isPythonIdentifier((String)string)) {
                callName = string;
            }
        }
        callName = this.changeToLowerUppercaseConstant((String)callName);
        if (((String)callName).length() > 0) {
            if (((String)callName).toLowerCase().startsWith("get") && ((String)callName).length() > 3) {
                callName = ((String)callName).substring(3);
            } else if (((String)callName).toLowerCase().startsWith("_get") && ((String)callName).length() > 4) {
                callName = ((String)callName).substring(4);
            }
            callName = this.changeToCodingStd((String)callName);
            i = 0;
            while (i < ((String)callName).length()) {
                char c = ((String)callName).charAt(i);
                if (c != '_') {
                    callName = TextSelectionUtils.lowerChar((String)callName, (int)i);
                    break;
                }
                ++i;
            }
        } else {
            callName = null;
        }
        return callName;
    }
}

