/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.python.pydev.ast.codecompletion.revisited.DefinitionAndCompletions;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.AssignOrTypeAliasDefinition;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IToken;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.NoExceptionCloseable;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.UnpackInfo;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.BinOp;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Index;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Set;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.TypeAlias;
import org.python.pydev.parser.jython.ast.UnaryOp;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.sliceType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.TypeInfo;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.StringUtils;

public class AssignAnalysis {
    public static final Map<String, Integer> CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS = new HashMap<String, Integer>();

    static {
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("adapt".toLowerCase(), 2);
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("GetSingleton".toLowerCase(), 1);
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("GetImplementation".toLowerCase(), 1);
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("GetAdapter".toLowerCase(), 1);
        CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.put("get_adapter".toLowerCase(), 1);
    }

    public DefinitionAndCompletions getCompletionsFollowingDefinition(ICodeCompletionASTManager manager, IModule module, ICompletionState state, ILocalScope localScope) {
        state.pushAssign();
        try {
            TokensList ret = new TokensList();
            Definition[] defs = new Definition[]{};
            if (module instanceof SourceModule) {
                SourceModule sourceModule = (SourceModule)module;
                try {
                    TokensList tokens;
                    defs = sourceModule.findDefinition(state, state.getLine() + 1, state.getCol() + 1, state.getNature());
                    if (defs.length > 0) {
                        int i = 0;
                        while (i < defs.length) {
                            Definition definition = defs[i];
                            if ("TypeVar".equals(definition.value)) {
                                ret.setMapsToTypeVar(true);
                            } else {
                                TokensList completionsFromDefinition = this.getCompletionsFromDefinition(definition, state, sourceModule, manager);
                                if (completionsFromDefinition != null && completionsFromDefinition.notEmpty()) {
                                    if (definition instanceof AssignOrTypeAliasDefinition) {
                                        AssignOrTypeAliasDefinition assignDefinition = (AssignOrTypeAliasDefinition)definition;
                                        if (assignDefinition.nodeValue instanceof Call) {
                                            completionsFromDefinition.setLookingFor(ICompletionState.LookingFor.LOOKING_FOR_INSTANCED_VARIABLE);
                                        }
                                    }
                                    ret.addAll(completionsFromDefinition);
                                }
                            }
                            ++i;
                        }
                    } else if (localScope != null && (tokens = this.searchInLocalTokens(manager, state, true, state.getLine() + 1, state.getCol() + 1, module, localScope, state.getActivationToken())) != null) {
                        ret.addAll(tokens);
                    }
                }
                catch (CompletionRecursionException tokens) {
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    throw new RuntimeException("Error when getting assign completions for:" + module.getName(), e);
                }
                catch (Throwable t) {
                    throw new RuntimeException("A throwable exception has been detected " + String.valueOf(t.getClass()));
                }
            }
            DefinitionAndCompletions definitionAndCompletions = new DefinitionAndCompletions(defs, ret);
            return definitionAndCompletions;
        }
        finally {
            state.popAssign();
        }
    }

    public TokensList getCompletionsFromDefinition(Definition definition, ICompletionState state, SourceModule sourceModule, ICodeCompletionASTManager manager) throws CompletionRecursionException {
        TokensList ret = new TokensList();
        if (state.getAlreadySearchedInAssign(definition.line, definition.col, definition.module, definition.value, state.getActivationToken())) {
            return ret;
        }
        if (state.getLine() + 1 == definition.line && state.getCol() + 1 == definition.col && definition.module != null && definition.module.equals(sourceModule) && state.checkFoudSameDefinition(definition.line, definition.col, definition.module)) {
            return ret;
        }
        AssignOrTypeAliasDefinition assignDefinition = null;
        if (definition instanceof AssignOrTypeAliasDefinition) {
            assignDefinition = (AssignOrTypeAliasDefinition)definition;
        }
        boolean foundAsParamWithTypingInfo = false;
        if (definition.scope != null) {
            String fullRepresentationString;
            String rep;
            SimpleNode ast = definition.ast;
            if (ast instanceof Assign) {
                Assign assign = (Assign)ast;
                if (assign.targets != null) {
                    ast = assign.targets[0];
                }
            }
            if (ast instanceof NameTok) {
                NameTok nameTok = (NameTok)definition.ast;
                if (nameTok.ctx == 12 && definition.scope != null) {
                    ast = (SimpleNode)definition.scope.getFoundAtASTNode();
                }
            }
            if (ast instanceof TypeAlias && (rep = NodeUtils.getRepresentationString((ISimpleNode)((TypeAlias)ast).value)) != null) {
                ICompletionState cp = state.getCopyWithActTok(rep);
                ret.addAll(manager.getCompletionsForModule(definition.module, cp));
                if (ret != null && ret.size() > 0) {
                    return ret;
                }
            }
            if (NodeUtils.isParamName((SimpleNode)ast)) {
                Name name = (Name)ast;
                String scopeStackPathNames = definition.scope.getScopeStackPathNames();
                if (scopeStackPathNames != null && scopeStackPathNames.length() > 0 && !(foundAsParamWithTypingInfo = this.computeCompletionsFromParameterTypingInfo(manager, state, ret, foundAsParamWithTypingInfo, name, scopeStackPathNames, definition.module))) {
                    IModule pyiStubModule = manager.getPyiStubModule(definition.module, state);
                    foundAsParamWithTypingInfo = this.computeCompletionsFromParameterTypingInfo(manager, state, ret, foundAsParamWithTypingInfo, name, scopeStackPathNames, pyiStubModule);
                }
            } else if (NodeUtils.isSelfAttribute((SimpleNode)ast) && (fullRepresentationString = NodeUtils.getFullRepresentationString((SimpleNode)ast)).contains(".")) {
                String attributeWithoutSelf = FullRepIterable.getLastPart((String)fullRepresentationString);
                String scopeStackPathNames = definition.scope.getScopeStackPathNamesToLastClassDef();
                if (scopeStackPathNames != null && scopeStackPathNames.length() > 0 && !(foundAsParamWithTypingInfo = this.computeCompletionsFromAttributeTypingInfo(manager, state, ret, foundAsParamWithTypingInfo, attributeWithoutSelf, scopeStackPathNames, definition.module))) {
                    IModule pyiStubModule = manager.getPyiStubModule(definition.module, state);
                    foundAsParamWithTypingInfo = this.computeCompletionsFromAttributeTypingInfo(manager, state, ret, foundAsParamWithTypingInfo, attributeWithoutSelf, scopeStackPathNames, pyiStubModule);
                }
            }
        }
        ret.addAll(manager.getCompletionsUnpackingInLocalScope(state, definition.module, definition.scope));
        if (ret != null && ret.size() > 0) {
            return ret;
        }
        if (!foundAsParamWithTypingInfo) {
            if (definition.ast instanceof FunctionDef) {
                found = manager.getCompletionFromFuncDefReturn(state, definition.module, (ISimpleNode)definition.ast, false);
                ret.addAll(found);
            } else {
                found = this.getNonFunctionDefCompletionsFromAssign(manager, state, sourceModule, definition, assignDefinition);
                ret.addAll(found);
            }
        }
        return ret;
    }

    private boolean computeCompletionsFromParameterTypingInfo(ICodeCompletionASTManager manager, ICompletionState state, TokensList ret, boolean foundAsParamWithTypingInfo, Name name, String scopeStackPathNames, IModule pyiStubModule) throws CompletionRecursionException {
        TypeInfo info;
        SourceModule sourceModule;
        SimpleNode ast;
        SimpleNode nodeFromPath;
        if (pyiStubModule instanceof SourceModule && (nodeFromPath = NodeUtils.getNodeFromPath((SimpleNode)(ast = (sourceModule = (SourceModule)pyiStubModule).getAst()), (String)scopeStackPathNames)) != null && (info = NodeUtils.getTypeForParameterFromAST((String)NodeUtils.getRepresentationString((ISimpleNode)name), (SimpleNode)nodeFromPath)) != null) {
            ArrayList<TypeInfo> lookForClass = new ArrayList<TypeInfo>();
            lookForClass.add(info);
            TokensList completions = manager.getCompletionsForClassInLocalScope((IModule)sourceModule, state, true, false, lookForClass);
            if (completions != null && completions.size() > 0) {
                ret.addAll(completions);
                foundAsParamWithTypingInfo = true;
            }
        }
        return foundAsParamWithTypingInfo;
    }

    private boolean computeCompletionsFromAttributeTypingInfo(ICodeCompletionASTManager manager, ICompletionState state, TokensList ret, boolean foundAsParamWithTypingInfo, String attributeWithoutSelf, String scopeStackPathNames, IModule pyiStubModule) throws CompletionRecursionException {
        TypeInfo info;
        SourceModule sourceModule;
        SimpleNode ast;
        SimpleNode nodeFromPath;
        if (pyiStubModule instanceof SourceModule && (nodeFromPath = NodeUtils.getNodeFromPath((SimpleNode)(ast = (sourceModule = (SourceModule)pyiStubModule).getAst()), (String)scopeStackPathNames)) instanceof ClassDef && (info = NodeUtils.getTypeForClassDefAttribute((String)attributeWithoutSelf, (ClassDef)((ClassDef)nodeFromPath))) != null) {
            ArrayList<TypeInfo> lookForClass = new ArrayList<TypeInfo>();
            lookForClass.add(info);
            ret.addAll(manager.getCompletionsForClassInLocalScope((IModule)sourceModule, state, true, false, lookForClass));
            foundAsParamWithTypingInfo = true;
        }
        return foundAsParamWithTypingInfo;
    }

    private TokensList getNonFunctionDefCompletionsFromAssign(ICodeCompletionASTManager manager, ICompletionState state, SourceModule sourceModule, Definition definition, AssignOrTypeAliasDefinition assignDefinition) throws CompletionRecursionException {
        TokensList ret;
        block59: {
            ret = new TokensList();
            if (definition.ast instanceof ClassDef) {
                Throwable throwable = null;
                Object var9_10 = null;
                try (NoExceptionCloseable x = state.pushLookingFor(ICompletionState.LookingFor.LOOKING_FOR_UNBOUND_VARIABLE);){
                    ret.addAll(((SourceModule)definition.module).getClassToks(state, manager, (ClassDef)definition.ast));
                    break block59;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            boolean lookForAssign = true;
            if (assignDefinition != null && assignDefinition.ast instanceof Assign) {
                Assign assign = (Assign)assignDefinition.ast;
                if (assign.value instanceof Call) {
                    Integer parameterIndex;
                    Call call = (Call)assign.value;
                    String lastPart = FullRepIterable.getLastPart((String)assignDefinition.value);
                    if ("namedtuple".equals(lastPart) && call.args != null && call.args.length > 1) {
                        exprType args = call.args[1];
                        exprType[] elts = null;
                        if (args instanceof org.python.pydev.parser.jython.ast.List) {
                            org.python.pydev.parser.jython.ast.List list = (org.python.pydev.parser.jython.ast.List)args;
                            elts = list.elts;
                        } else if (args instanceof Tuple) {
                            Tuple tuple = (Tuple)args;
                            elts = tuple.elts;
                        } else if (args instanceof Set) {
                            Set set = (Set)args;
                            elts = set.elts;
                        }
                        if (elts != null) {
                            exprType[] exprTypeArray = elts;
                            int n = elts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                exprType exprType2 = exprTypeArray[n2];
                                if (exprType2 instanceof Str) {
                                    ret.addAll(new TokensList(new IToken[]{new SourceToken((SimpleNode)exprType2, ((Str)exprType2).s, "", "", sourceModule.getName(), sourceModule.getNature(), sourceModule)}));
                                }
                                ++n2;
                            }
                            return ret;
                        }
                        if (args instanceof Call) {
                            Call call2 = (Call)args;
                            if (call2.func instanceof Attribute) {
                                Attribute attribute = (Attribute)call2.func;
                                if ("split".equals(NodeUtils.getRepresentationString((ISimpleNode)attribute.attr)) && attribute.value instanceof Str) {
                                    Str str2 = (Str)attribute.value;
                                    if (str2.s != null) {
                                        List split = StringUtils.split((String)str2.s, (String)" ");
                                        for (String string : split) {
                                            ret.addAll(new TokensList(new IToken[]{new SourceToken((SimpleNode)str2, string, "", "", sourceModule.getName(), sourceModule.getNature(), sourceModule)}));
                                        }
                                        return ret;
                                    }
                                }
                            }
                        }
                        if (args instanceof Str) {
                            Str str = (Str)args;
                            if (str.s != null) {
                                String[] string = str.s.split("(\\s|,)+");
                                int split = string.length;
                                int str2 = 0;
                                while (str2 < split) {
                                    String s = string[str2];
                                    if (!s.isEmpty()) {
                                        ret.addAll(new TokensList(new IToken[]{new SourceToken((SimpleNode)str, s, "", "", sourceModule.getName(), sourceModule.getNature(), sourceModule)}));
                                    }
                                    ++str2;
                                }
                                return ret;
                            }
                        }
                    }
                    if ((parameterIndex = CALLS_FOR_ASSIGN_WITH_RESULTING_CLASS.get(lastPart.toLowerCase())) != null && call.args.length >= parameterIndex) {
                        String rep = NodeUtils.getFullRepresentationString((SimpleNode)call.args[parameterIndex - 1]);
                        ArrayList<TypeInfo> lookForClass = new ArrayList<TypeInfo>();
                        lookForClass.add(new TypeInfo(rep));
                        TokensList completionsForClassInLocalScope = manager.getCompletionsForClassInLocalScope((IModule)sourceModule, state, true, false, lookForClass);
                        if (completionsForClassInLocalScope.size() > 0) {
                            lookForAssign = false;
                            ret.addAll(completionsForClassInLocalScope);
                        }
                    }
                }
                if (lookForAssign && assignDefinition.unpackPos == -1) {
                    TokensList tokens = null;
                    if (assign.type != null) {
                        tokens = this.searchInLocalTokens(manager, state, lookForAssign, definition.line, definition.col, definition.module, assignDefinition.scope, assignDefinition.type);
                    } else if (assign.value != null) {
                        tokens = this.searchInLocalTokens(manager, state, lookForAssign, definition.line, definition.col, definition.module, assignDefinition.scope, assignDefinition.value);
                    }
                    if (tokens != null && tokens.size() > 0) {
                        ret.addAll(tokens);
                        lookForAssign = false;
                    }
                }
            }
            if (lookForAssign) {
                state.setLookingFor(ICompletionState.LookingFor.LOOKING_FOR_ASSIGN);
                ICompletionState copy = state.getCopy();
                if (definition.ast instanceof Attribute) {
                    copy.setActivationToken(NodeUtils.getFullRepresentationString((SimpleNode)definition.ast));
                } else if (definition.type != null && !definition.type.isEmpty()) {
                    copy.setActivationToken(definition.type);
                } else {
                    copy.setActivationToken(definition.value);
                }
                copy.setLine(definition.line - 1);
                copy.setCol(definition.col - 1);
                IModule module = definition.module;
                state.checkDefinitionMemory(module, (IDefinition)definition);
                if (assignDefinition != null) {
                    TokensList interfaceForLocal = assignDefinition.scope.getInterfaceForLocal(assignDefinition.target);
                    ret.addAll(interfaceForLocal);
                }
                int unpackPos = -1;
                boolean unpackBackwards = false;
                if (assignDefinition != null) {
                    if (assignDefinition.nodeType != null) {
                        TokensList completions = new TokensList();
                        List<String> typingUnionValues = AssignAnalysis.extractTypingUnionValues(manager, module, assignDefinition.nodeType);
                        if (typingUnionValues != null && typingUnionValues.size() > 0) {
                            typingUnionValues.add(NodeUtils.getFullRepresentationString((SimpleNode)assignDefinition.nodeType));
                            for (String value : typingUnionValues) {
                                ICompletionState customCopy = state.getCopyWithActTok(value);
                                TokensList valueComps = manager.getCompletionsForModule(module, customCopy);
                                completions.addAll(valueComps);
                            }
                        }
                        TokensList normalCompletions = manager.getCompletionsForModule(module, copy, true, true);
                        completions.addAll(normalCompletions);
                        if (completions != null && completions.size() > 0) {
                            ret.addAll(completions);
                            return ret;
                        }
                    }
                    unpackPos = assignDefinition.unpackPos;
                    if (definition.ast instanceof Assign) {
                        Assign assign = (Assign)definition.ast;
                        if (assign.value instanceof Subscript) {
                            Subscript subscript = (Subscript)assign.value;
                            if (subscript.slice instanceof Index) {
                                Index index = (Index)subscript.slice;
                                exprType indexValue = index.value;
                                if (indexValue instanceof UnaryOp) {
                                    UnaryOp unaryOp = (UnaryOp)indexValue;
                                    if (unaryOp.op == 4) {
                                        unpackBackwards = true;
                                    }
                                    indexValue = unaryOp.operand;
                                }
                                if (indexValue instanceof Num) {
                                    Num num = (Num)indexValue;
                                    String rep = NodeUtils.getRepresentationString((ISimpleNode)num);
                                    try {
                                        int subscriptIndex;
                                        unpackPos = subscriptIndex = Integer.parseInt(rep);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                }
                if (assignDefinition != null && unpackPos >= 0) {
                    tks = manager.getCompletionsUnpackingObject(module, copy, assignDefinition.scope, new UnpackInfo(false, unpackPos, unpackBackwards));
                    if (tks != null) {
                        ret.addAll(tks);
                    }
                } else {
                    tks = manager.getCompletionsForModule(module, copy, true, true);
                    ret.addAll(tks);
                }
            }
        }
        return ret;
    }

    private static List<String> extractTypingUnionValues(ICodeCompletionASTManager manager, IModule module, SimpleNode node) throws CompletionRecursionException {
        if (manager.isNodeTypingUnionSubscript(module, (Object)node)) {
            Subscript subscript = (Subscript)node;
            return NodeUtils.extractValuesFromSubscriptSlice((sliceType)subscript.slice);
        }
        if (node instanceof BinOp) {
            BinOp binOp = (BinOp)node;
            return NodeUtils.extractValuesFromBinOp((exprType)binOp, (int)9);
        }
        return null;
    }

    public TokensList searchInLocalTokens(ICodeCompletionASTManager manager, ICompletionState state, boolean lookForAssign, int line, int col, IModule module, ILocalScope scope, String activationToken) throws CompletionRecursionException {
        TokensList allLocalTokens = scope.getAllLocalTokens();
        for (IterTokenEntry entry : allLocalTokens) {
            TokensList classToks;
            SourceToken srcToken;
            SimpleNode ast;
            IToken token = entry.getToken();
            if (!token.getRepresentation().equals(activationToken) || !(token instanceof SourceToken) || !((ast = (srcToken = (SourceToken)token).getAst()) instanceof ClassDef) || !(module instanceof SourceModule) || !(classToks = ((SourceModule)module).getClassToks(state, manager, (ClassDef)ast)).notEmpty()) continue;
            return classToks;
        }
        ICompletionState copy = state.getCopy();
        copy.setLine(line);
        copy.setCol(col);
        copy.setActivationToken(activationToken);
        TokensList tokens = manager.getCompletionsFromTokenInLocalScope(module, copy, false, false, scope);
        if (tokens != null && tokens.size() > 0) {
            return tokens;
        }
        return null;
    }
}

