/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.python.pydev.ast.codecompletion.revisited.ManagerInfoToUpdate;
import org.python.pydev.ast.interpreter_managers.DefaultPathsForInterpreterInfo;
import org.python.pydev.ast.interpreter_managers.IInterpreterInfoBuilder;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.callbacks.ICallback2;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageDescriptor;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.DataAndImageTreeNode;
import org.python.pydev.shared_core.structure.OrderedSet;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.ThreadPriorityHelper;

public class SyncSystemModulesManager {
    public static final boolean DEBUG = false;
    public static boolean ALWAYS_APPLY_ALL_CHANGES_WITHOUT_ASKING = false;
    private final JobApplyChanges jobApplyChanges = new JobApplyChanges();
    public static ICallback2<List<TreeNode>, DataAndImageTreeNode, List<TreeNode>> selectElementsInDialog;
    private boolean selectingElementsInDialog = false;
    private final Object selectingElementsInDialogLock = new Object();

    public void applySelectedChangesToInterpreterInfosPythonpath(DataAndImageTreeNode root, List<TreeNode> selectElements, IProgressMonitor monitor) {
        List<IInterpreterInfo> changedInfos = this.computeChanges(root, selectElements);
        if (changedInfos.size() > 0) {
            IInterpreterManager[] allInterpreterManagers;
            IInterpreterManager[] iInterpreterManagerArray = allInterpreterManagers = InterpreterManagersAPI.getAllInterpreterManagers();
            int n = allInterpreterManagers.length;
            int n2 = 0;
            while (n2 < n) {
                IInterpreterManager manager = iInterpreterManagerArray[n2];
                if (manager != null) {
                    HashMap<String, IInterpreterInfo> changedInterpreterNameToInterpreter = new HashMap<String, IInterpreterInfo>();
                    for (IInterpreterInfo info : changedInfos) {
                        changedInterpreterNameToInterpreter.put(info.getName(), info);
                    }
                    IInterpreterInfo[] allInfos = manager.getInterpreterInfos();
                    ArrayList<IInterpreterInfo> newInfos = new ArrayList<IInterpreterInfo>(allInfos.length);
                    HashSet<String> changedNames = new HashSet<String>();
                    IInterpreterInfo[] iInterpreterInfoArray = allInfos;
                    int n3 = allInfos.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IInterpreterInfo info = iInterpreterInfoArray[n4];
                        IInterpreterInfo changedInfo = (IInterpreterInfo)changedInterpreterNameToInterpreter.remove(info.getName());
                        if (changedInfo != null) {
                            newInfos.add(changedInfo);
                            changedNames.add(changedInfo.getExecutableOrJar());
                        } else {
                            newInfos.add(info);
                        }
                        ++n4;
                    }
                    if (changedNames.size() > 0) {
                        manager.setInfos(newInfos.toArray(new IInterpreterInfo[newInfos.size()]), changedNames, monitor);
                    }
                }
                ++n2;
            }
        }
    }

    public void updateStructures(IProgressMonitor monitor, DataAndImageTreeNode root, ManagerInfoToUpdate managerToNameToInfo, CreateInterpreterInfoCallback callback) {
        IImageCache imageCache;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((imageCache = SharedCorePlugin.getImageCache()) == null) {
            imageCache = new IImageCache(){

                public IImageHandle getStringDecorated(String key, String stringToAddToDecoration) {
                    return null;
                }

                public IImageHandle getImageDecorated(String key, String decoration, int decorationLocation, String secondDecoration, int secondDecorationLocation) {
                    return null;
                }

                public IImageHandle getImageDecorated(String key, String decoration, int decorationLocation) {
                    return null;
                }

                public IImageHandle getImageDecorated(String key, String decoration) {
                    return null;
                }

                public IImageDescriptor getDescriptor(String projectIcon) {
                    return null;
                }

                public IImageHandle get(String key) {
                    return null;
                }
            };
        }
        Tuple<IInterpreterManager, IInterpreterInfo>[] tupleArray = managerToNameToInfo.getManagerAndInfos();
        int n = tupleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Tuple<IInterpreterManager, IInterpreterInfo> infos = tupleArray[n2];
            IInterpreterManager manager = (IInterpreterManager)infos.o1;
            IInterpreterInfo internalInfo = (IInterpreterInfo)infos.o2;
            String executable = internalInfo.getExecutableOrJar();
            IInterpreterInfo newInterpreterInfo = callback.createInterpreterInfo(manager, executable, monitor);
            if (newInterpreterInfo != null) {
                DefaultPathsForInterpreterInfo defaultPaths = new DefaultPathsForInterpreterInfo(false);
                OrderedSet newEntries = new OrderedSet((Collection)newInterpreterInfo.getPythonPath());
                newEntries.removeAll((Collection)internalInfo.getPythonPath());
                Iterator it = newEntries.iterator();
                while (it.hasNext()) {
                    String entryInPythonpath = (String)it.next();
                    if (defaultPaths.selectByDefault(entryInPythonpath) && DefaultPathsForInterpreterInfo.exists(entryInPythonpath)) continue;
                    it.remove();
                }
                OrderedSet removedEntries = new OrderedSet();
                List pythonPath = internalInfo.getPythonPath();
                for (String string : pythonPath) {
                    if (new File(string).exists()) continue;
                    removedEntries.add((Object)string);
                }
                if (newEntries.size() > 0 || removedEntries.size() > 0) {
                    DataAndImageTreeNode interpreterNode = new DataAndImageTreeNode(root, (Object)internalInfo, imageCache.get("icons/python_16x16.png"));
                    for (String s : newEntries) {
                        new DataAndImageTreeNode(interpreterNode, (Object)new PythonpathChange(s, true), imageCache.get("icons/jar_l_obj.gif"));
                    }
                    for (String s : removedEntries) {
                        new DataAndImageTreeNode(interpreterNode, (Object)new PythonpathChange(s, false), imageCache.get("icons/jar_remove_l_obj.gif"));
                    }
                }
            }
            ++n2;
        }
    }

    private List<IInterpreterInfo> computeChanges(DataAndImageTreeNode root, List<TreeNode> selectElements) {
        ArrayList<IInterpreterInfo> changedInfos = new ArrayList<IInterpreterInfo>();
        HashSet<TreeNode> set = new HashSet<TreeNode>(selectElements.size());
        set.addAll(selectElements);
        for (Object n : root.getChildren()) {
            DataAndImageTreeNode interpreterNode = (DataAndImageTreeNode)n;
            if (!set.contains(interpreterNode)) continue;
            IInterpreterInfo info = (IInterpreterInfo)interpreterNode.getData();
            List pythonPath = info.getPythonPath();
            boolean changed = false;
            OrderedSet newPythonPath = new OrderedSet((Collection)pythonPath);
            for (Object entryNode : interpreterNode.getChildren()) {
                DataAndImageTreeNode pythonpathNode = (DataAndImageTreeNode)entryNode;
                if (!set.contains(pythonpathNode)) continue;
                PythonpathChange change = (PythonpathChange)pythonpathNode.data;
                change.apply((OrderedSet<String>)newPythonPath);
                changed = true;
            }
            if (!changed) continue;
            InterpreterInfo copy = (InterpreterInfo)info.makeCopy();
            copy.libs.clear();
            copy.libs.addAll((Collection<String>)newPythonPath);
            changedInfos.add(copy);
        }
        return changedInfos;
    }

    public void synchronizeManagerToNameToInfoPythonpath(IProgressMonitor monitor, ManagerInfoToUpdate localManagerToNameToInfo, IInterpreterInfoBuilder builder) {
        Tuple<IInterpreterManager, IInterpreterInfo>[] managerAndInfos;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (builder == null && (builder = (IInterpreterInfoBuilder)ExtensionHelper.getParticipant((String)"org.python.pydev.pydev_interpreter_info_builder", (boolean)false)) == null) {
            Log.log((String)"Expecting at least one org.python.pydev.pydev_interpreter_info_builder.");
            return;
        }
        Tuple<IInterpreterManager, IInterpreterInfo>[] tupleArray = managerAndInfos = localManagerToNameToInfo.getManagerAndInfos();
        int n = managerAndInfos.length;
        int n2 = 0;
        while (n2 < n) {
            Tuple<IInterpreterManager, IInterpreterInfo> tuple = tupleArray[n2];
            InterpreterInfo info = (InterpreterInfo)tuple.o2;
            if (info == null) {
                Log.log((String)"Info null when synchronizing info.");
            } else {
                long initial = System.currentTimeMillis();
                builder.syncInfoToPythonPath(monitor, info);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSelectingElementsInDialog() {
        Object object = this.selectingElementsInDialogLock;
        synchronized (object) {
            return this.selectingElementsInDialog;
        }
    }

    void asyncSelectAndScheduleElementsToChangePythonpath(final DataAndImageTreeNode root, final ManagerInfoToUpdate managerToNameToInfo, final List<TreeNode> initialSelection) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block18: {
                    Object object;
                    Object object2 = SyncSystemModulesManager.this.selectingElementsInDialogLock;
                    synchronized (object2) {
                        if (SyncSystemModulesManager.this.selectingElementsInDialog) {
                            return;
                        }
                        SyncSystemModulesManager.this.selectingElementsInDialog = true;
                    }
                    try {
                        if (!managerToNameToInfo.somethingChanged()) break block18;
                        object = SyncSystemModulesManager.this.selectingElementsInDialogLock;
                    }
                    catch (Throwable throwable) {
                        Object object3 = SyncSystemModulesManager.this.selectingElementsInDialogLock;
                        synchronized (object3) {
                            SyncSystemModulesManager.this.selectingElementsInDialog = false;
                        }
                        throw throwable;
                    }
                    synchronized (object) {
                        SyncSystemModulesManager.this.selectingElementsInDialog = false;
                    }
                    return;
                }
                List selectedElements = ALWAYS_APPLY_ALL_CHANGES_WITHOUT_ASKING ? root.flattenChildren() : (List)selectElementsInDialog.call((Object)root, (Object)initialSelection);
                SyncSystemModulesManager.this.saveUnselected(root, selectedElements, PydevPrefs.getEclipsePreferences());
                if (selectedElements != null && selectedElements.size() > 0) {
                    SyncSystemModulesManager.this.jobApplyChanges.stack(root, selectedElements, managerToNameToInfo);
                } else {
                    SyncSystemModulesManager.this.jobApplyChanges.stack(managerToNameToInfo);
                }
                SyncSystemModulesManager.this.jobApplyChanges.schedule();
                Object object = SyncSystemModulesManager.this.selectingElementsInDialogLock;
                synchronized (object) {
                    SyncSystemModulesManager.this.selectingElementsInDialog = false;
                }
            }
        };
        if (ALWAYS_APPLY_ALL_CHANGES_WITHOUT_ASKING) {
            runnable.run();
        } else {
            SharedCorePlugin.asyncRunInUiThread((Runnable)runnable);
        }
    }

    public void saveUnselected(DataAndImageTreeNode root, List<TreeNode> selectedElements, IEclipsePreferences iPreferenceStore) {
        HashSet<TreeNode> selectionSet = new HashSet<TreeNode>();
        if (selectedElements != null && selectedElements.size() > 0) {
            selectionSet.addAll(selectedElements);
        }
        boolean changed = false;
        for (DataAndImageTreeNode interpreterNode : root.getChildren()) {
            HashSet<TreeNode> addToIgnore = new HashSet<TreeNode>();
            if (!selectionSet.contains(interpreterNode)) {
                addToIgnore.addAll(interpreterNode.getChildren());
            } else {
                for (TreeNode pathNode : interpreterNode.getChildren()) {
                    if (selectionSet.contains(pathNode)) continue;
                    addToIgnore.add(pathNode);
                }
            }
            if (addToIgnore.size() <= 0) continue;
            IInterpreterInfo info = (IInterpreterInfo)interpreterNode.getData();
            String key = SyncSystemModulesManager.createKeyForInfo(info);
            ArrayList<String> addToIgnorePaths = new ArrayList<String>(addToIgnore.size());
            for (TreeNode node : addToIgnore) {
                PythonpathChange data = (PythonpathChange)node.getData();
                addToIgnorePaths.add(data.path);
            }
            changed = true;
            iPreferenceStore.put(key, StringUtils.join((String)"|||", addToIgnorePaths));
        }
        if (changed) {
            try {
                iPreferenceStore.flush();
            }
            catch (BackingStoreException e) {
                Log.log((Throwable)e);
            }
        }
    }

    public static String createKeyForInfo(IInterpreterInfo info) {
        return "synch_ignore_entries_" + StringUtils.md5((String)(info.getName() + "_" + info.getExecutableOrJar()));
    }

    public List<TreeNode> createInitialSelectionForDialogConsideringPreviouslyIgnored(DataAndImageTreeNode root, IEclipsePreferences iPreferenceStore) {
        ArrayList<TreeNode> initialSelection = new ArrayList<TreeNode>();
        for (DataAndImageTreeNode interpreterNode : root.getChildren()) {
            IInterpreterInfo info = (IInterpreterInfo)interpreterNode.getData();
            String key = SyncSystemModulesManager.createKeyForInfo(info);
            String ignoredValue = iPreferenceStore.get(key, "");
            if (ignoredValue != null && ignoredValue.length() > 0) {
                HashSet previouslyIgnored = new HashSet(StringUtils.split((String)ignoredValue, (String)"|||"));
                boolean added = false;
                for (TreeNode pathNode : interpreterNode.getChildren()) {
                    if (previouslyIgnored.contains(((PythonpathChange)pathNode.data).path)) continue;
                    initialSelection.add(pathNode);
                    added = true;
                }
                if (!added) continue;
                initialSelection.add((TreeNode)interpreterNode);
                continue;
            }
            initialSelection.add((TreeNode)interpreterNode);
            initialSelection.addAll(interpreterNode.getChildren());
        }
        return initialSelection;
    }

    public static class CreateInterpreterInfoCallback {
        public IInterpreterInfo createInterpreterInfo(IInterpreterManager manager, String executable, IProgressMonitor monitor) {
            boolean askUser = false;
            try {
                return manager.createInterpreterInfo(executable, monitor, askUser);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                return null;
            }
        }
    }

    private class JobApplyChanges
    extends Job {
        private DataAndImageTreeNode root;
        private List<TreeNode> selectElements;
        private ManagerInfoToUpdate managerToNameToInfo;
        private final Object lock;

        public JobApplyChanges() {
            super("Apply PYTHONPATH changes");
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ThreadPriorityHelper priorityHelper = new ThreadPriorityHelper(this.getThread());
            priorityHelper.setMinPriority();
            try {
                ManagerInfoToUpdate localManagerToNameToInfo;
                List<TreeNode> localSelectElements;
                DataAndImageTreeNode localRoot;
                Object object = this.lock;
                synchronized (object) {
                    localRoot = this.root;
                    localSelectElements = this.selectElements;
                    localManagerToNameToInfo = this.managerToNameToInfo;
                    this.root = null;
                    this.selectElements = null;
                    this.managerToNameToInfo = null;
                }
                if (localRoot != null && localSelectElements != null) {
                    SyncSystemModulesManager.this.applySelectedChangesToInterpreterInfosPythonpath(localRoot, localSelectElements, monitor);
                } else if (localManagerToNameToInfo != null) {
                    SyncSystemModulesManager.this.synchronizeManagerToNameToInfoPythonpath(monitor, localManagerToNameToInfo, null);
                }
            }
            finally {
                priorityHelper.restoreInitialPriority();
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stack(DataAndImageTreeNode root, List<TreeNode> selectElements, ManagerInfoToUpdate managerToNameToInfo) {
            Object object = this.lock;
            synchronized (object) {
                this.root = root;
                this.selectElements = selectElements;
                this.managerToNameToInfo = managerToNameToInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stack(ManagerInfoToUpdate managerToNameToInfo) {
            Object object = this.lock;
            synchronized (object) {
                this.root = null;
                this.selectElements = null;
                this.managerToNameToInfo = managerToNameToInfo;
            }
        }
    }

    public static class PythonpathChange {
        public final String path;
        public final boolean add;

        public PythonpathChange(String path, boolean add) {
            this.path = path;
            this.add = add;
        }

        public String toString() {
            if (this.add) {
                return "Add to PYTHONPATH: " + this.path;
            }
            return "Remove from PYTHONPATH: " + this.path;
        }

        public void apply(OrderedSet<String> newPythonPath) {
            if (this.add) {
                newPythonPath.add((Object)this.path);
            } else {
                newPythonPath.remove((Object)this.path);
            }
        }
    }
}

