/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.ast.codecompletion.revisited.visitors.GlobalModelVisitor;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IToken;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Index;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;

public final class ClassDefTokensExtractor {
    private final ClassDef classDef;
    private final String classRep;
    private final SourceModule module;
    private final ICompletionState initialState;

    public ClassDefTokensExtractor(ClassDef classDef, SourceModule module, ICompletionState initialState) {
        this.classDef = classDef;
        this.classRep = NodeUtils.getFullRepresentationString((ClassDef)classDef);
        this.module = module;
        this.initialState = initialState;
    }

    public TokensList getTokens(ICodeCompletionASTManager manager) {
        List<IToken> globalModelVisitorTokens = GlobalModelVisitor.getTokens((SimpleNode)this.classDef, 16, this.module.getName(), this.initialState, false, this.module.getNature(), this.module);
        TokensList classTokens = new TokensList(globalModelVisitorTokens);
        try {
            this.initialState.pushSkipObjectBaseCompletions();
            try {
                int j = 0;
                while (j < this.classDef.bases.length) {
                    classTokens.addAll(this.getCompletionsForBase(manager, (SimpleNode)this.classDef.bases[j]));
                    ++j;
                }
            }
            finally {
                this.initialState.popSkipObjectBaseCompletions();
            }
            classTokens.addAll(this.getCompletionsForBase(manager, (SimpleNode)new Name("object", 1, false)));
            classTokens.addAll(this.getAssignmentTokens());
        }
        catch (CompletionRecursionException completionRecursionException) {
            // empty catch block
        }
        classTokens.setLookingFor(this.initialState.getLookingFor());
        return classTokens;
    }

    public TokensList getCompletionsForBase(ICodeCompletionASTManager manager, SimpleNode baseNode) throws CompletionRecursionException {
        if (baseNode instanceof Name) {
            Name n = (Name)baseNode;
            String base = n.id;
            if (this.classRep != null && this.classRep.equals(base)) {
                return null;
            }
            if (this.initialState.getSkipObjectBaseCompletions() && "object".equals(base)) {
                return null;
            }
            ICompletionState state = this.initialState.getCopy();
            state.setActivationToken(base);
            state.checkMemory((IModule)this.module, base);
            return manager.getCompletionsForModule((IModule)this.module, state);
        }
        if (baseNode instanceof Attribute) {
            Attribute attr = (Attribute)baseNode;
            String s = NodeUtils.getFullRepresentationString((SimpleNode)attr);
            if (this.classRep != null && this.classRep.equals(s)) {
                return null;
            }
            ICompletionState state = this.initialState.getCopy();
            state.setActivationToken(s);
            return manager.getCompletionsForModule((IModule)this.module, state);
        }
        if (baseNode instanceof Subscript) {
            TokensList tokens = new TokensList();
            Subscript subscript = (Subscript)baseNode;
            String subscriptValue = NodeUtils.getFullRepresentationString((SimpleNode)subscript.value);
            if (this.classRep == null || !this.classRep.equals(subscriptValue)) {
                tokens.addAll(this.getCompletionsForValue(manager, this.initialState, subscriptValue));
            }
            if (subscript.slice instanceof Index) {
                Index index = (Index)subscript.slice;
                String subscriptSlice = NodeUtils.getFullRepresentationString((SimpleNode)index.value);
                if (this.classRep == null || !this.classRep.equals(subscriptSlice)) {
                    tokens.addAll(this.getCompletionsForValue(manager, this.initialState, subscriptSlice));
                }
            }
            if (tokens.size() > 0) {
                return tokens;
            }
        }
        return null;
    }

    private TokensList getCompletionsForValue(ICodeCompletionASTManager manager, ICompletionState state, String value) throws CompletionRecursionException {
        if (value != null && !value.isEmpty()) {
            ICompletionState copiedState = state.getCopy();
            state.checkMemory((IModule)this.module, value);
            copiedState.setActivationToken(value);
            return manager.getCompletionsForModule((IModule)this.module, copiedState);
        }
        return null;
    }

    private TokensList getAssignmentTokens() {
        stmtType[] body;
        if (this.classRep == null) {
            return null;
        }
        if (this.classDef.parent != null) {
            body = NodeUtils.getBody((SimpleNode)this.classDef.parent);
        } else {
            Module moduleNode = (Module)this.module.getAst();
            body = moduleNode.body;
        }
        return this.extractTokensFromBody(body);
    }

    private TokensList extractTokensFromBody(stmtType[] body) {
        TokensList ret = new TokensList();
        ArrayList<IToken> tokensList = new ArrayList<IToken>();
        stmtType[] stmtTypeArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            Assign assign;
            Optional<IToken> optionalToken;
            stmtType node = stmtTypeArray[n2];
            if (node instanceof Assign && (optionalToken = this.extractTokenFromAssign(assign = (Assign)node)).isPresent()) {
                IToken token = optionalToken.get();
                tokensList.add(token);
            }
            ++n2;
        }
        ret.addAll(new TokensList(tokensList));
        return ret;
    }

    private Optional<IToken> extractTokenFromAssign(Assign assign) {
        exprType[] exprTypeArray = assign.targets;
        int n = assign.targets.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleNode node;
            String nodeRep;
            Attribute attribute;
            Optional<SimpleNode> optionalNode;
            exprType target = exprTypeArray[n2];
            if (target instanceof Attribute && (optionalNode = this.extractNodeFromAttribute(attribute = (Attribute)target)).isPresent() && (nodeRep = NodeUtils.getFullRepresentationString((SimpleNode)(node = optionalNode.get()))) != null) {
                SourceToken token = AbstractVisitor.makeToken(node, nodeRep, this.module.getName(), this.module.getNature(), this.module);
                return Optional.of(token);
            }
            ++n2;
        }
        return Optional.empty();
    }

    private Optional<SimpleNode> extractNodeFromAttribute(Attribute attribute) {
        List attributeParts = NodeUtils.getAttributeParts((Attribute)attribute);
        if (attributeParts.size() > 1) {
            SimpleNode first = (SimpleNode)attributeParts.get(0);
            String firstRep = NodeUtils.getFullRepresentationString((SimpleNode)first);
            if (this.classRep != null && this.classRep.equals(firstRep)) {
                return Optional.of((SimpleNode)attributeParts.get(1));
            }
        }
        return Optional.empty();
    }
}

