/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited.modules;

import org.python.pydev.ast.codecompletion.revisited.AbstractToken;
import org.python.pydev.ast.codecompletion.revisited.CompletionState;
import org.python.pydev.ast.codecompletion.revisited.modules.PredefinedSourceModule;
import org.python.pydev.ast.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.core.BaseModuleRequest;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.TypeAlias;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.model.ISimpleNode;

public class SourceToken
extends AbstractToken {
    private static final long serialVersionUID = 1L;
    private static final ICallback<String, IToken> DEFAULT_COMPUTE_DOCSTRING = token -> {
        SourceToken sourceToken;
        if (token instanceof SourceToken && (sourceToken = (SourceToken)token).getAst() != null) {
            return NodeUtils.printAst(null, (SimpleNode)sourceToken.getAst());
        }
        return "";
    };
    private static final ThreadLocal<Boolean> threadLocalPreventRecursion = new ThreadLocal();
    private static final ICallback<String, IToken> DEFAULT_COMPUTE_DOCSTRING_PREDEFINED = token -> {
        block11: {
            if (!(token instanceof SourceToken)) break block11;
            Boolean curr = threadLocalPreventRecursion.get();
            if (curr != null && curr.booleanValue()) {
                Log.log((String)"Prevented recursion when getting source token docs.");
                return "";
            }
            threadLocalPreventRecursion.set(true);
            try {
                String signatureDoc;
                block13: {
                    IToken found;
                    block12: {
                        ICodeCompletionASTManager astManager;
                        IModule realModule;
                        String qualifier;
                        SourceToken sourceToken = (SourceToken)token;
                        IPythonNature nature = sourceToken.getNature();
                        BaseModuleRequest request = new BaseModuleRequest(false);
                        SimpleNode ast = sourceToken.getAst();
                        if (ast == null) break block11;
                        signatureDoc = NodeUtils.printAst(null, (SimpleNode)ast);
                        if (nature == null || (qualifier = NodeUtils.getRepresentationString((ISimpleNode)ast)) == null || (realModule = (astManager = nature.getAstManager()).getModule(sourceToken.parentPackage, nature, false, (IModuleRequestState)request)) == null || realModule == sourceToken.module) break block13;
                        String actTok = "";
                        if (ast.parent != null) {
                            actTok = NodeUtils.getFullMethodName((SimpleNode)ast.parent);
                        }
                        CompletionState state = new CompletionState(ast.beginLine - 1, ast.beginColumn - 1, actTok, nature, "");
                        try {
                            TokensList completionsForModule = astManager.getCompletionsForModule(realModule, (ICompletionState)state);
                            found = completionsForModule.find(qualifier);
                            if (found == null) break block13;
                            if (!found.equals(token)) break block12;
                            String string = signatureDoc;
                            return string;
                        }
                        catch (CompletionRecursionException e) {
                            Log.log((Throwable)e);
                        }
                    }
                    String docStr = found.getDocStr();
                    if (docStr == null || docStr.trim().length() == 0) {
                        String string = signatureDoc;
                        return string;
                    }
                    String string = docStr + "\n\n" + signatureDoc;
                    return string;
                }
                String string = signatureDoc;
                return string;
            }
            finally {
                threadLocalPreventRecursion.set(false);
            }
        }
        return "";
    };
    private SimpleNode ast;
    private FunctionDef aliased;
    public final IModule module;
    int[] colLineEndToFirstDot;
    int[] colLineEndComplete;
    private Definition definition;
    private Assign foundInAssign;
    private Assign dummyAssignFromParam;
    private Call foundInCall;
    private TypeAlias foundInTypeAlias;

    public SourceToken(SimpleNode node, String rep, String args, String doc, String parentPackage, IPythonNature nature, IModule module) {
        super(rep, doc, args, parentPackage, SourceToken.getType(node), nature);
        this.ast = node;
        this.module = module;
        this.setDefaultComputeDocstring();
    }

    public SourceToken(SimpleNode node, String rep, String args, String doc, String parentPackage, int type, IPythonNature nature, IModule module) {
        super(rep, doc, args, parentPackage, type, nature);
        this.ast = node;
        this.module = module;
        this.setDefaultComputeDocstring();
    }

    public SourceToken(SimpleNode node, String rep, String doc, String args, String parentPackage, String originalRep, boolean originalHasRep, IPythonNature nature, IModule module) {
        super(rep, doc, args, parentPackage, SourceToken.getType(node), originalRep, originalHasRep, nature);
        this.ast = node;
        this.module = module;
        this.setDefaultComputeDocstring();
    }

    private void setDefaultComputeDocstring() {
        if (this.module instanceof PredefinedSourceModule) {
            this.computeDocstring = DEFAULT_COMPUTE_DOCSTRING_PREDEFINED;
        } else if (this.ast instanceof FunctionDef || this.ast instanceof ClassDef) {
            this.computeDocstring = DEFAULT_COMPUTE_DOCSTRING;
        }
    }

    public static int getType(SimpleNode ast) {
        if (ast instanceof ClassDef) {
            return 1;
        }
        if (ast instanceof FunctionDef) {
            return 2;
        }
        if (ast instanceof Name) {
            return 3;
        }
        if (ast instanceof Import || ast instanceof ImportFrom) {
            return 0;
        }
        if (ast instanceof keywordType || ast instanceof Attribute || ast instanceof NameTok) {
            return 3;
        }
        return -1;
    }

    public void setAst(SimpleNode ast) {
        this.ast = ast;
    }

    public SimpleNode getAst() {
        return this.ast;
    }

    @Override
    public int getLineDefinition() {
        return NodeUtils.getLineDefinition((SimpleNode)this.getRepresentationNode());
    }

    private SimpleNode getRepresentationNode() {
        if (this.ast instanceof Attribute) {
            Attribute attr = (Attribute)this.ast;
            while (attr != null) {
                String r = NodeUtils.getRepresentationString((ISimpleNode)attr);
                if (r != null && r.equals(this.rep)) {
                    return attr;
                }
                if (attr.value instanceof Attribute) {
                    attr = (Attribute)attr.value;
                    continue;
                }
                r = NodeUtils.getRepresentationString((ISimpleNode)attr.value);
                if (r == null || !r.equals(this.rep)) break;
                return attr.value;
            }
        }
        return this.ast;
    }

    @Override
    public int getColDefinition() {
        return NodeUtils.getColDefinition((SimpleNode)this.ast);
    }

    public int getLineEnd(boolean getOnlyToFirstDot) {
        if (getOnlyToFirstDot) {
            if (this.colLineEndToFirstDot == null) {
                this.colLineEndToFirstDot = NodeUtils.getColLineEnd((SimpleNode)this.getRepresentationNode(), (boolean)getOnlyToFirstDot);
            }
            return this.colLineEndToFirstDot[0];
        }
        if (this.colLineEndComplete == null) {
            this.colLineEndComplete = NodeUtils.getColLineEnd((SimpleNode)this.getRepresentationNode(), (boolean)getOnlyToFirstDot);
        }
        return this.colLineEndComplete[0];
    }

    public int getColEnd(boolean getOnlyToFirstDot) {
        if (getOnlyToFirstDot) {
            if (this.colLineEndToFirstDot == null) {
                this.colLineEndToFirstDot = NodeUtils.getColLineEnd((SimpleNode)this.getRepresentationNode(), (boolean)getOnlyToFirstDot);
            }
            return this.colLineEndToFirstDot[1];
        }
        if (this.colLineEndComplete == null) {
            this.colLineEndComplete = NodeUtils.getColLineEnd((SimpleNode)this.getRepresentationNode(), (boolean)getOnlyToFirstDot);
        }
        return this.colLineEndComplete[1];
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SourceToken)) {
            return false;
        }
        SourceToken s = (SourceToken)obj;
        if (!s.getRepresentation().equals(this.getRepresentation())) {
            return false;
        }
        if (s.getLineDefinition() != this.getLineDefinition()) {
            return false;
        }
        return s.getColDefinition() == this.getColDefinition();
    }

    @Override
    public int hashCode() {
        return 7 * this.getLineDefinition() * this.getColDefinition();
    }

    @Override
    public boolean isImport() {
        return this.ast instanceof Import || this.ast instanceof ImportFrom;
    }

    @Override
    public boolean isImportFrom() {
        return this.ast instanceof ImportFrom;
    }

    @Override
    public boolean isWildImport() {
        return this.ast instanceof ImportFrom && AbstractVisitor.isWildImport((ImportFrom)this.ast);
    }

    @Override
    public boolean isString() {
        return AbstractVisitor.isString(this.ast);
    }

    @Override
    public int[] getLineColEnd() {
        if (this.ast instanceof NameTok || this.ast instanceof Name) {
            return new int[]{this.getLineDefinition(), this.getColDefinition() + this.getRepresentation().length()};
        }
        throw new RuntimeException("Unable to get the lenght of the token:" + this.ast.getClass().getName());
    }

    public void updateAliasToken(SourceToken methodTok) {
        this.args = methodTok.getArgs();
        this.type = methodTok.getType();
        this.doc = methodTok.getDocStr();
        SimpleNode localAst = methodTok.getAst();
        this.aliased = localAst instanceof FunctionDef ? (FunctionDef)localAst : methodTok.getAliased();
    }

    public FunctionDef getAliased() {
        return this.aliased;
    }

    public void setDefinition(Definition d) {
        this.definition = d;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public void setFoundInAssign(Assign foundInAssign) {
        this.foundInAssign = foundInAssign;
    }

    public Assign getFoundInAssign() {
        return this.foundInAssign;
    }

    public void setFoundInCall(Call foundInCall) {
        this.foundInCall = foundInCall;
    }

    public Call getFoundInCall() {
        return this.foundInCall;
    }

    public void setDummyAssignFromParam(Assign dummyAssignFromParam) {
        this.dummyAssignFromParam = dummyAssignFromParam;
    }

    public Assign getDummyAssignFromParam() {
        return this.dummyAssignFromParam;
    }

    public void setFoundInTypeAlias(TypeAlias node) {
        this.foundInTypeAlias = node;
    }

    public TypeAlias getFoundInTypeAlias() {
        return this.foundInTypeAlias;
    }
}

