/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited.visitors;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.FastStack;

public class HeuristicFindAttrs
extends AbstractVisitor {
    private boolean discoverSelfAttrs = true;
    private final Map<String, SourceToken> repToTokenWithArgs;
    private FastStack<Assign> lastAssign = new FastStack(2);
    public Stack<SimpleNode> stack = new Stack();
    public static final int WHITIN_METHOD_CALL = 0;
    public static final int WHITIN_INIT = 1;
    public static final int WHITIN_ANY = 2;
    public int where = -1;
    public static final int IN_ASSIGN = 0;
    public static final int IN_KEYWORDS = 1;
    public int how = -1;
    private boolean entryPointCorrect = false;
    private boolean inAssing = false;
    private boolean inFuncDef = false;
    public String methodCall = "";

    public HeuristicFindAttrs(int where, int how, String methodCall, String moduleName, ICompletionState state, Map<String, SourceToken> repToTokenWithArgs, IPythonNature nature, IModule module) {
        super(nature, module);
        this.where = where;
        this.how = how;
        this.methodCall = methodCall;
        this.moduleName = moduleName;
        this.repToTokenWithArgs = repToTokenWithArgs;
        if (state != null && state.getLookingFor() == ICompletionState.LookingFor.LOOKING_FOR_CLASSMETHOD_VARIABLE) {
            this.discoverSelfAttrs = false;
        }
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        return null;
    }

    public void traverse(SimpleNode node) throws Exception {
        node.traverse((VisitorIF)this);
    }

    @Override
    protected SourceToken addToken(SimpleNode node) {
        SourceToken tok = super.addToken(node);
        if (tok.getArgs().length() > 0) {
            this.repToTokenWithArgs.put(tok.getRepresentation(), tok);
        }
        return tok;
    }

    public Object visitCall(Call node) throws Exception {
        if (!this.entryPointCorrect && this.methodCall.length() > 0) {
            this.entryPointCorrect = true;
            if (node.func instanceof Attribute) {
                List c = StringUtils.dotSplit((String)this.methodCall);
                Attribute func = (Attribute)node.func;
                if (((NameTok)func.attr).id.equals(c.get(1)) && func.value instanceof Name) {
                    Name name = (Name)func.value;
                    if (name.id.equals(c.get(0))) {
                        int i = 0;
                        while (i < node.keywords.length) {
                            this.addToken((SimpleNode)node.keywords[i]);
                            ++i;
                        }
                    }
                }
            }
            this.entryPointCorrect = false;
        }
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        this.stack.push((SimpleNode)node);
        if (!this.entryPointCorrect) {
            this.entryPointCorrect = true;
            this.inFuncDef = true;
            if (this.where == 2) {
                node.traverse((VisitorIF)this);
            } else if (this.where == 1 && node.name != null && ((NameTok)node.name).id.equals("__init__")) {
                node.traverse((VisitorIF)this);
            }
            this.entryPointCorrect = false;
            this.inFuncDef = false;
        }
        this.stack.pop();
        return null;
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        this.stack.push((SimpleNode)node);
        Object r = super.visitClassDef(node);
        this.stack.pop();
        return r;
    }

    public Object visitAssign(Assign node) throws Exception {
        block8: {
            this.lastAssign.push((Object)node);
            try {
                if (this.how != 0) break block8;
                this.inAssing = true;
                exprType value = node.value;
                String rep = NodeUtils.getRepresentationString((ISimpleNode)value);
                SourceToken methodTok = null;
                if (rep != null) {
                    methodTok = this.repToTokenWithArgs.get(rep);
                }
                int i = 0;
                while (i < node.targets.length) {
                    block10: {
                        block11: {
                            block9: {
                                if (!(node.targets[i] instanceof Attribute)) break block9;
                                this.visitAttribute((Attribute)node.targets[i]);
                                break block10;
                            }
                            if (!(node.targets[i] instanceof Name) || this.inFuncDef) break block11;
                            String id = ((Name)node.targets[i]).id;
                            if (id == null) break block10;
                            SourceToken added = this.addToken((SimpleNode)node.targets[i]);
                            added.setFoundInAssign(node);
                            if (methodTok == null) break block10;
                            added.updateAliasToken(methodTok);
                            break block10;
                        }
                        if (node.targets[i] instanceof Tuple && !this.inFuncDef) {
                            Tuple tuple = (Tuple)node.targets[i];
                            exprType[] exprTypeArray = tuple.elts;
                            int n = tuple.elts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String id;
                                exprType t = exprTypeArray[n2];
                                if (t instanceof Name && (id = ((Name)t).id) != null) {
                                    SourceToken added = this.addToken((SimpleNode)t);
                                    added.setFoundInAssign(node);
                                }
                                ++n2;
                            }
                        }
                    }
                    ++i;
                }
                this.inAssing = false;
            }
            finally {
                this.lastAssign.pop();
            }
        }
        return null;
    }

    public Object visitAttribute(Attribute node) throws Exception {
        String id;
        if (this.how == 0 && this.inAssing && node.value instanceof Name && (id = ((Name)node.value).id) != null) {
            SourceToken addToken = null;
            if (this.discoverSelfAttrs) {
                if (id.equals("self")) {
                    addToken = this.addToken((SimpleNode)node);
                }
            } else if (id.equals("cls")) {
                addToken = this.addToken((SimpleNode)node);
            }
            if (addToken != null && !this.lastAssign.empty()) {
                addToken.setFoundInAssign((Assign)this.lastAssign.peek());
            }
        }
        return null;
    }

    public Object visitIf(If node) throws Exception {
        node.traverse((VisitorIF)this);
        return null;
    }
}

