/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.ast.codecompletion.revisited.visitors.HeuristicFindAttrs;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ISimpleNode;

public final class InnerModelVisitor
extends AbstractVisitor {
    private final List<HeuristicFindAttrs> attrsHeuristics = new ArrayList<HeuristicFindAttrs>();
    private final Map<String, SourceToken> repToTokenWithArgs = new HashMap<String, SourceToken>();
    private final Map<String, List<SourceToken>> repsWithOverrides = new HashMap<String, List<SourceToken>>();
    private static int VISITING_NOTHING = -1;
    private static int VISITING_CLASS = 0;
    private int visiting = VISITING_NOTHING;

    @Override
    protected SourceToken addToken(SimpleNode node) {
        SourceToken tok = super.addToken(node);
        this.addToTokenWithArgs(tok);
        return tok;
    }

    private void addToTokenWithArgs(SourceToken tok) {
        if (tok.getArgs().length() > 0) {
            SourceToken curr;
            String rep = tok.getRepresentation();
            this.repToTokenWithArgs.put(rep, tok);
            if (rep != null && this.isPreferredOver(tok, curr = this.repToTokenWithArgs.get(rep))) {
                this.repToTokenWithArgs.put(rep, tok);
            }
        }
    }

    private SourceToken addTokenCheckingOverride(FunctionDef node) {
        SourceToken t = InnerModelVisitor.makeToken((SimpleNode)node, this.moduleName, this.nature, (IModule)this.module.get());
        this.addToTokenWithArgs(t);
        if (node.decs != null) {
            decoratorsType[] decoratorsTypeArray = node.decs;
            int n = node.decs.length;
            int n2 = 0;
            while (n2 < n) {
                decoratorsType dec = decoratorsTypeArray[n2];
                String decRep = NodeUtils.getRepresentationString((ISimpleNode)dec.func);
                if ("overload".equals(decRep)) {
                    String rep = t.getRepresentation();
                    List<SourceToken> list = this.repsWithOverrides.get(rep);
                    if (list == null) {
                        list = new ArrayList<SourceToken>();
                        this.repsWithOverrides.put(rep, list);
                    }
                    list.add(t);
                    return t;
                }
                ++n2;
            }
        }
        this.tokens.add(t);
        return t;
    }

    @Override
    protected void finishVisit() {
        for (Map.Entry<String, List<SourceToken>> pair : this.repsWithOverrides.entrySet()) {
            List<SourceToken> list = pair.getValue();
            SourceToken preferred = null;
            for (SourceToken t : list) {
                if (!this.isPreferredOver(t, preferred)) continue;
                preferred = t;
            }
            this.tokens.add(preferred);
        }
        super.finishVisit();
    }

    private boolean isPreferredOver(SourceToken newToken, SourceToken currentPreferred) {
        if (currentPreferred == null) {
            return true;
        }
        if (newToken.getAst() instanceof FunctionDef && currentPreferred.getAst() instanceof FunctionDef) {
            FunctionDef newFunc = (FunctionDef)newToken.getAst();
            FunctionDef currPreferredFunc = (FunctionDef)currentPreferred.getAst();
            if (newFunc.returns != null && currPreferredFunc.returns != null) {
                if (currPreferredFunc.returns instanceof Subscript) {
                    return true;
                }
                if (newFunc.returns instanceof Subscript) {
                    return false;
                }
            }
        }
        return true;
    }

    public InnerModelVisitor(String moduleName, ICompletionState state, IPythonNature nature, IModule module) {
        super(nature, module);
        this.moduleName = moduleName;
        this.attrsHeuristics.add(new HeuristicFindAttrs(0, 1, "properties.create", moduleName, state, this.repToTokenWithArgs, nature, module));
        this.attrsHeuristics.add(new HeuristicFindAttrs(2, 0, "", moduleName, state, this.repToTokenWithArgs, nature, module));
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        return null;
    }

    public void traverse(SimpleNode node) throws Exception {
        node.traverse((VisitorIF)this);
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        if (this.visiting == VISITING_NOTHING) {
            this.visiting = VISITING_CLASS;
            node.traverse((VisitorIF)this);
        } else if (this.visiting == VISITING_CLASS) {
            this.addToken((SimpleNode)node);
        }
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        if (this.visiting == VISITING_CLASS) {
            this.addTokenCheckingOverride(node);
            for (HeuristicFindAttrs element : this.attrsHeuristics) {
                element.visitFunctionDef(node);
                this.addElementTokens(element);
            }
        }
        return null;
    }

    public Object visitAssign(Assign node) throws Exception {
        if (this.visiting == VISITING_CLASS) {
            for (HeuristicFindAttrs element : this.attrsHeuristics) {
                element.visitAssign(node);
                this.addElementTokens(element);
            }
        }
        return null;
    }

    public Object visitCall(Call node) throws Exception {
        if (this.visiting == VISITING_CLASS) {
            for (HeuristicFindAttrs element : this.attrsHeuristics) {
                element.visitCall(node);
                this.addElementTokens(element);
            }
        }
        return null;
    }

    private void addElementTokens(HeuristicFindAttrs element) {
        this.tokens.addAll(element.tokens);
        element.tokens.clear();
    }
}

