/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.shell;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.ast.codecompletion.revisited.modules.CompiledToken;
import org.python.pydev.ast.codecompletion.shell.AbstractShell;
import org.python.pydev.ast.codecompletion.shell.ShellConvert;
import org.python.pydev.core.IToken;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public abstract class CompletionsShell
extends AbstractShell {
    public CompletionsShell(File scriptWithinPySrc) throws IOException, CoreException {
        super(scriptWithinPySrc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalChangePythonPath(List<String> pythonpath) throws Exception {
        String pythonpathStr;
        if (finishedForGood) {
            throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to change its dir.");
        }
        Object object = this.lockLastPythonPath;
        synchronized (object) {
            pythonpathStr = StringUtils.join((String)"|", (String[])pythonpath.toArray(new String[pythonpath.size()]));
            if (this.lastPythonPath != null && this.lastPythonPath.equals(pythonpathStr)) {
                return;
            }
            this.lastPythonPath = pythonpathStr;
        }
        try {
            this.writeAndGetResults("@@CHANGE_PYTHONPATH:", URLEncoder.encode(pythonpathStr, "UTF-8"), "\nEND@@");
        }
        catch (Exception e) {
            Log.log((String)("Error changing the pythonpath to: " + StringUtils.join((String)"\n", pythonpath)), (Throwable)e);
            throw e;
        }
    }

    public Tuple<String, List<String[]>> getImportCompletions(String str, List<String> pythonpath) throws Exception {
        FastStringBuffer read = null;
        str = URLEncoder.encode(str, "UTF-8");
        Throwable throwable = null;
        Object var5_6 = null;
        try (AutoCloseable permit = this.acquire(StringUtils.join((String)"", (Object[])new Object[]{"getImportCompletions: ", str}));){
            this.internalChangePythonPath(pythonpath);
            read = this.writeAndGetResults("@@IMPORTS:", str, "\nEND@@");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return ShellConvert.convertStringToCompletions(read);
    }

    public Tuple<String[], int[]> getLineCol(String moduleName, String token, List<String> pythonpath) throws Exception {
        FastStringBuffer read = null;
        Object str = moduleName + "." + token;
        str = URLEncoder.encode((String)str, "UTF-8");
        Throwable throwable = null;
        Object var7_8 = null;
        try (AutoCloseable permit = this.acquire("getLineCol");){
            this.internalChangePythonPath(pythonpath);
            read = this.writeAndGetResults(new String[]{"@@SEARCH", str, "\nEND@@"});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Tuple<String, List<String[]>> theCompletions = ShellConvert.convertStringToCompletions(read);
        List def = (List)theCompletions.o2;
        if (def.size() == 0) {
            return null;
        }
        String[] comps = (String[])def.get(0);
        if (comps.length == 0) {
            return null;
        }
        int line = Integer.parseInt(comps[0]);
        int col = Integer.parseInt(comps[1]);
        String foundAs = comps[2];
        return new Tuple((Object)new String[]{(String)theCompletions.o1, foundAs}, (Object)new int[]{line, col});
    }

    public List<IToken> getJediCompletions(File editorFile, PySelection ps, String charset, List<String> pythonpath) throws Exception {
        FastStringBuffer read = null;
        String str = StringUtils.join((String)"|", (String[])new String[]{String.valueOf(ps.getCursorLine()), String.valueOf(ps.getCursorColumn()), charset, FileUtils.getFileAbsolutePath((File)editorFile), StringUtils.replaceNewLines((String)ps.getDoc().get(), (String)"\n")});
        str = URLEncoder.encode(str, "UTF-8");
        Throwable throwable = null;
        Object var8_9 = null;
        try (AutoCloseable permit = this.acquire("getJediCompletions");){
            this.internalChangePythonPath(pythonpath);
            read = this.writeAndGetResults("@@MSG_JEDI:", str, "\nEND@@");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Tuple<String, List<String[]>> theCompletions = ShellConvert.convertStringToCompletions(read);
        ArrayList<IToken> lst = new ArrayList<IToken>(((List)theCompletions.o2).size());
        for (String[] s : (List)theCompletions.o2) {
            lst.add(new CompiledToken(s[0], s[1], "", "", Integer.parseInt(s[3]), null));
        }
        return lst;
    }
}

