/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.shell;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.io.ThreadStreamReader;
import org.python.pydev.shared_core.string.StringUtils;

public class ProcessCreationInfo {
    public final String[] parameters;
    public final String[] envp;
    public final File workingDir;
    private final Process process;
    private ThreadStreamReader stdReader;
    private ThreadStreamReader errReader;

    public ProcessCreationInfo(String[] parameters, String[] envp, File workingDir, Process process) {
        this.parameters = parameters;
        if (envp != null) {
            Arrays.sort(envp);
        }
        this.envp = envp;
        this.workingDir = workingDir;
        this.process = process;
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.stdReader = new ThreadStreamReader(process.getInputStream());
        this.errReader = new ThreadStreamReader(process.getErrorStream());
        this.stdReader.setName("Shell reader (stdout)");
        this.errReader.setName("Shell reader (stderr)");
        this.stdReader.start();
        this.errReader.start();
    }

    public String getProcessLog() {
        String osName;
        String joinedParams = StringUtils.join((String)" ", (String[])this.parameters);
        String environment = "EMPTY ENVIRONMENT";
        if (this.envp != null) {
            environment = StringUtils.join((String)"\n", (String[])this.envp);
        }
        String workDir = "NULL WORK DIR";
        if (this.workingDir != null) {
            workDir = this.workingDir.toString();
        }
        if ((osName = System.getProperty("os.name")) == null) {
            osName = "Unknown OS!";
        }
        String stdContents = this.stdReader != null ? this.stdReader.getContents() : "";
        String errContents = this.errReader != null ? this.errReader.getContents() : "";
        String[] splitted = new String[]{"ProcessInfo:\n\n - Executed: ", joinedParams, "\n\n - Environment:\n", environment, "\n\n - Working Dir:\n", workDir, "\n\n - OS:\n", osName, "\n\n - Std output:\n", stdContents, "\n\n - Err output:\n", errContents};
        return StringUtils.join((String)"", (String[])splitted);
    }

    public String getAndClearContents() {
        String stdContents = this.stdReader != null ? this.stdReader.getContents() : "";
        String errContents = this.errReader != null ? this.errReader.getContents() : "";
        return StringUtils.join((String)"", (Object[])new Object[]{"STDOUT: ", stdContents, "\nESTDERR: ", errContents, "\n"});
    }

    private void stopGettingOutput() {
        if (this.stdReader != null) {
            this.stdReader.stopGettingOutput();
        }
        this.stdReader = null;
        if (this.errReader != null) {
            this.errReader.stopGettingOutput();
        }
        this.errReader = null;
    }

    public void destroy() {
        this.stopGettingOutput();
        try {
            this.process.destroy();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public void clearOutput() {
        if (this.stdReader != null) {
            this.stdReader.clearContents();
        }
        if (this.errReader != null) {
            this.errReader.clearContents();
        }
    }
}

