/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.shell;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.ast.codecompletion.shell.CompletionsShell;
import org.python.pydev.ast.codecompletion.shell.ProcessCreationInfo;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.ast.runners.SimplePythonRunner;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.io.FileUtils;

public class PythonShell
extends CompletionsShell {
    public PythonShell() throws IOException, CoreException {
        super(CorePlugin.getScriptWithinPySrc((String)"pycompletionserver.py"));
    }

    @Override
    protected synchronized ProcessCreationInfo createServerProcess(IInterpreterInfo interpreter, int port) throws IOException {
        File file = new File(interpreter.getExecutableOrJar());
        if (file.isDirectory()) {
            throw new RuntimeException("The interpreter location found is a directory. " + String.valueOf(interpreter));
        }
        String[] parameters = SimplePythonRunner.preparePythonCallParameters(interpreter.getExecutableOrJar(), FileUtils.getFileAbsolutePath((File)this.serverFile), new String[]{"" + port});
        IInterpreterManager manager = InterpreterManagersAPI.getPythonInterpreterManager();
        String[] envp = null;
        try {
            envp = SimpleRunner.getEnvironment(null, interpreter, manager);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        File workingDir = this.serverFile.getParentFile();
        return new ProcessCreationInfo(parameters, envp, workingDir, SimpleRunner.createProcess(parameters, envp, workingDir));
    }
}

