/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.cython;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocumentExtension4;
import org.python.pydev.ast.codecompletion.shell.AbstractShell;
import org.python.pydev.ast.codecompletion.shell.CythonShell;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.json.eclipsesource.JsonArray;
import org.python.pydev.json.eclipsesource.JsonObject;
import org.python.pydev.json.eclipsesource.JsonValue;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.grammarcommon.CtxVisitor;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assert;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.AugAssign;
import org.python.pydev.parser.jython.ast.Await;
import org.python.pydev.parser.jython.ast.BinOp;
import org.python.pydev.parser.jython.ast.BoolOp;
import org.python.pydev.parser.jython.ast.Break;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Compare;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Continue;
import org.python.pydev.parser.jython.ast.Delete;
import org.python.pydev.parser.jython.ast.Dict;
import org.python.pydev.parser.jython.ast.DictComp;
import org.python.pydev.parser.jython.ast.Exec;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.ExtSlice;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Global;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.IfExp;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Index;
import org.python.pydev.parser.jython.ast.Lambda;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.NonLocal;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.Print;
import org.python.pydev.parser.jython.ast.Raise;
import org.python.pydev.parser.jython.ast.Repr;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.Set;
import org.python.pydev.parser.jython.ast.Slice;
import org.python.pydev.parser.jython.ast.Starred;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.Suite;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.UnaryOp;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.WithItem;
import org.python.pydev.parser.jython.ast.WithItemType;
import org.python.pydev.parser.jython.ast.Yield;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.jython.ast.factory.PyAstFactory;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.jython.ast.sliceType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.jython.ast.suiteType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.parsing.BaseParser;
import org.python.pydev.shared_core.string.StringUtils;

public class GenCythonAstImpl {
    public static final NameTok FOUND_NAME_LIST = new NameTok("found_name_list", 4);
    public static boolean IN_TESTS = false;
    private final PyParser.ParserInfo parserInfo;

    public GenCythonAstImpl(PyParser.ParserInfo parserInfo) {
        this.parserInfo = parserInfo;
    }

    private BaseParser.ParseOutput jsonToParseOutput(PyParser.ParserInfo p, String cythonJson, long modifiedTime) {
        JsonValue json = JsonValue.readFrom((String)cythonJson);
        JsonObject asObject = json.asObject();
        JsonValue errors = asObject.get("errors");
        ParseException exc = null;
        for (JsonValue v : errors.asArray()) {
            JsonObject objError = v.asObject();
            JsonValue lineValue = objError.get("line");
            JsonValue colValue = objError.get("col");
            JsonValue messageValue = objError.get("message_only");
            exc = new ParseException(messageValue.asString(), lineValue.asInt(), colValue.asInt());
        }
        JsonValue ast = asObject.get("ast");
        if (ast == null || !ast.isObject()) {
            BaseParser.ParseOutput parseOutput = new BaseParser.ParseOutput(null, exc, modifiedTime);
            parseOutput.isCython = true;
            return parseOutput;
        }
        JsonValue body = ast.asObject().get("stats");
        if (body != null && body.isArray()) {
            JsonToNodesBuilder builder = new JsonToNodesBuilder(p);
            JsonArray asArray = body.asArray();
            for (JsonValue node : asArray) {
                try {
                    builder.addStatement(node);
                }
                catch (Exception e) {
                    GenCythonAstImpl.log("Error converting cython json to ast: " + String.valueOf(node), e);
                }
            }
            ISimpleNode mod = builder.createModule();
            BaseParser.ParseOutput parseOutput = new BaseParser.ParseOutput(mod, null, modifiedTime);
            parseOutput.isCython = true;
            return parseOutput;
        }
        return null;
    }

    private static void log(String s) {
        if (IN_TESTS) {
            Log.log((String)s);
            throw new StopOnLogException(s);
        }
    }

    private static void log(Exception e) {
        if (IN_TESTS) {
            Log.log((Throwable)e);
            throw new StopOnLogException(e);
        }
    }

    private static void log(String s, Exception e) {
        if (IN_TESTS) {
            Log.log((String)s, (Throwable)e);
            throw new StopOnLogException(s, e);
        }
    }

    public BaseParser.ParseOutput genCythonAst() {
        long modifiedTime = ((IDocumentExtension4)this.parserInfo.document).getModificationStamp();
        String cythonJson = this.genCythonJson();
        return this.jsonToParseOutput(this.parserInfo, cythonJson, modifiedTime);
    }

    public String genCythonJson() {
        try {
            SystemPythonNature nature = new SystemPythonNature(InterpreterManagersAPI.getPythonInterpreterManager());
            CythonShell serverShell = (CythonShell)AbstractShell.getServerShell(nature, CompletionProposalFactory.get().getCythonShellId());
            String contents = this.parserInfo.document.get();
            String ret = serverShell.convertToJsonAst(StringUtils.replaceNewLines((String)contents, (String)"\n"));
            return ret;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class JsonToNodesBuilder {
        final List<stmtType> stmts = new ArrayList<stmtType>();
        final PyAstFactory astFactory;
        final CtxVisitor ctx = new CtxVisitor(null);

        public JsonToNodesBuilder(PyParser.ParserInfo p) {
            this.astFactory = new PyAstFactory(new AdapterPrefs("\n", (IGrammarVersionProvider)p));
        }

        public void addStatement(JsonValue jsonStmt) throws Exception {
            ISimpleNode node = this.createNode(jsonStmt);
            this.addToStmtsList(node, this.stmts);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ISimpleNode createNode(JsonValue jsonValue) {
            if (jsonValue == null) return null;
            if (jsonValue.isString() && "None".equals(jsonValue.asString())) {
                return null;
            }
            JsonObject asObject = jsonValue.asObject();
            JsonValue jsonNode = asObject.get("__node__");
            ISimpleNode node = null;
            if (jsonNode == null) return node;
            try {
                switch (jsonNode.asString()) {
                    case "Int": {
                        return this.createInt(asObject);
                    }
                    case "Float": {
                        return this.createFloat(asObject);
                    }
                    case "Name": {
                        return this.createName(asObject);
                    }
                    case "Attribute": {
                        return this.createAttribute(asObject);
                    }
                    case "StatList": {
                        return this.createStatList(asObject);
                    }
                    case "Bool": {
                        return this.createBool(asObject);
                    }
                    case "None": 
                    case "Null": {
                        return this.createNone(asObject);
                    }
                    case "IfStat": {
                        return this.createIf(asObject);
                    }
                    case "JoinedStr": {
                        return this.createFString(asObject);
                    }
                    case "String": {
                        return this.createString(asObject);
                    }
                    case "Annotation": {
                        return this.createAnnotation(asObject);
                    }
                    case "Tuple": {
                        return this.createTuple(asObject);
                    }
                    case "AsTuple": {
                        return this.createAsTuple(asObject);
                    }
                    case "IdentifierString": {
                        return this.createIdentifierString(asObject);
                    }
                    case "Ampersand": {
                        return this.createAmpersand(asObject);
                    }
                    case "Dict": {
                        return this.createDict(asObject);
                    }
                    case "MergedDict": {
                        return this.createMergedDict(asObject);
                    }
                    case "List": {
                        return this.createList(asObject);
                    }
                    case "Set": {
                        return this.createSet(asObject);
                    }
                    case "Char": 
                    case "Unicode": {
                        return this.createUnicode(asObject);
                    }
                    case "Bytes": {
                        return this.createBytes(asObject);
                    }
                    case "PassStat": {
                        return this.createPass(asObject);
                    }
                    case "ExprStat": {
                        return this.createExpr(asObject);
                    }
                    case "SimpleCall": {
                        return this.createSimpleCall(asObject);
                    }
                    case "GeneralCall": {
                        return this.createGeneralCall(asObject);
                    }
                    case "GeneratorExpression": {
                        return this.createGeneratorExpression(asObject);
                    }
                    case "Comprehension": {
                        return this.createComprehension(asObject);
                    }
                    case "YieldExpr": {
                        return this.createYieldExpr(asObject);
                    }
                    case "YieldFromExpr": {
                        return this.createYieldFromExpr(asObject);
                    }
                    case "Def": {
                        return this.createFunctionDef(asObject);
                    }
                    case "CFuncDef": {
                        return this.createCFunctionDef(asObject);
                    }
                    case "SingleAssignment": {
                        return this.createSingleAssignment(asObject);
                    }
                    case "CascadedAssignment": {
                        return this.createCascadedAssignment(asObject);
                    }
                    case "ForFromStat": {
                        return this.createForFromStat(asObject);
                    }
                    case "ForInStat": 
                    case "AsyncForStat": {
                        return this.createFor(asObject);
                    }
                    case "AwaitExpr": {
                        return this.createAwait(asObject);
                    }
                    case "CascadedCmp": {
                        return this.createCascade(asObject);
                    }
                    case "PyClassDef": {
                        return this.createClassDef(asObject);
                    }
                    case "CClassDef": {
                        return this.createCClassDef(asObject);
                    }
                    case "CppClass": {
                        return this.createCppClass(asObject);
                    }
                    case "PrimaryCmp": {
                        return this.createCompare(asObject);
                    }
                    case "BoolBinop": {
                        return this.createBoolOp(asObject);
                    }
                    case "CVarDef": {
                        return this.createCVarDef(asObject);
                    }
                    case "CondExpr": {
                        return this.createCondExpr(asObject);
                    }
                    case "WhileStat": {
                        return this.createWhile(asObject);
                    }
                    case "WithStat": {
                        return this.createWith(asObject);
                    }
                    case "AssertStat": {
                        return this.createAssert(asObject);
                    }
                    case "ReturnStat": {
                        return this.createReturn(asObject);
                    }
                    case "CFuncDeclarator": {
                        return this.createCFuncDeclarator(asObject);
                    }
                    case "CDefExtern": {
                        return this.createCDefExtern(asObject);
                    }
                    case "CStructOrUnionDef": {
                        return this.createCStructOrUnionDef(asObject);
                    }
                    case "CTypeDef": {
                        return this.createCtypeDef(asObject);
                    }
                    case "SizeofType": {
                        return this.createSizeofType(asObject);
                    }
                    case "SizeofVar": {
                        return this.createSizeofVar(asObject);
                    }
                    case "CEnumDef": {
                        return this.createCEnumDef(asObject);
                    }
                    case "InPlaceAssignment": {
                        return this.createAugAssign(asObject);
                    }
                    case "Typecast": {
                        return this.createTypecast(asObject);
                    }
                    case "Import": {
                        return this.createImport(asObject);
                    }
                    case "FromImportStat": {
                        return this.createFromImport(asObject);
                    }
                    case "MatMult": 
                    case "BitwiseOr": 
                    case "Add": 
                    case "Div": 
                    case "Mod": 
                    case "Mul": 
                    case "Pow": 
                    case "Sub": 
                    case "IntBinop": {
                        return this.createBinOp(asObject);
                    }
                    case "UnaryMinus": 
                    case "UnaryPlus": 
                    case "Tilde": {
                        return this.createUnaryOp(asObject);
                    }
                    case "Not": {
                        return this.createUnaryOp(asObject, "not");
                    }
                    case "ContinueStat": {
                        return this.createContinue(asObject);
                    }
                    case "BreakStat": {
                        return this.createBreak(asObject);
                    }
                    case "FromCImportStat": {
                        return this.createFromCImportStat(asObject);
                    }
                    case "CImportStat": {
                        return this.createCImportStat(asObject);
                    }
                    case "PrintStat": {
                        return this.createPrint(asObject);
                    }
                    case "Global": {
                        return this.createGlobal(asObject, 9, (SimpleNode)new Global(null, null));
                    }
                    case "Nonlocal": {
                        return this.createGlobal(asObject, 10, (SimpleNode)new NonLocal(null, null));
                    }
                    case "Index": {
                        return this.createIndex(asObject);
                    }
                    case "Slice": {
                        return this.createSlice(asObject);
                    }
                    case "GILStat": {
                        return this.createGILStat(asObject);
                    }
                    case "NewExpr": {
                        return this.createNewExpr(asObject);
                    }
                    case "TemplatedType": {
                        return this.createTemplatedType(asObject);
                    }
                    case "DelStat": {
                        return this.createDel(asObject);
                    }
                    case "Ellipsis": {
                        return this.createEllipsis(asObject);
                    }
                    case "TryFinallyStat": {
                        return this.createTryFinally(asObject);
                    }
                    case "TryExceptStat": {
                        return this.createTryExcept(asObject);
                    }
                    case "ReraiseStat": {
                        return this.createReraise(asObject);
                    }
                    case "RaiseStat": {
                        return this.createRaise(asObject);
                    }
                    case "Property": {
                        return this.createProperty(asObject);
                    }
                    case "FusedType": {
                        return this.createFusedType(asObject);
                    }
                    case "CSimpleBaseType": {
                        return this.createCSimpleBaseType(asObject);
                    }
                    case "SliceIndex": {
                        return this.createSliceIndex(asObject);
                    }
                    case "ComprehensionAppend": {
                        return this.createComprehensionAppend(asObject);
                    }
                    case "Lambda": {
                        return this.createLambda(asObject);
                    }
                    case "ExecStat": {
                        return this.createExec(asObject);
                    }
                    case "StarredUnpacking": {
                        return this.createStarredUnpacking(asObject);
                    }
                    case "MergedSequence": {
                        return this.createMergedSequence(asObject);
                    }
                    case "Imag": {
                        return this.createImag(asObject);
                    }
                    case "Backquote": {
                        return this.createBackquote(asObject);
                    }
                    case "DictComprehensionAppend": {
                        return this.createDictComprehensionAppend(asObject);
                    }
                    case "CythonArray": {
                        return null;
                    }
                    case "MemoryViewSliceType": {
                        return null;
                    }
                }
                String msg = "Don't know how to create statement from cython json: " + asObject.toPrettyString();
                GenCythonAstImpl.log(msg);
                return node;
            }
            catch (Exception e) {
                GenCythonAstImpl.log(e);
            }
            return node;
        }

        private ISimpleNode createDictComprehensionAppend(JsonObject asObject) {
            return null;
        }

        private ISimpleNode createBackquote(JsonObject asObject) {
            Repr repr = new Repr(this.asExpr(this.createNode(asObject.get("arg"))));
            this.setLine((SimpleNode)repr, asObject);
            return repr;
        }

        private exprType asExpr(ISimpleNode node) {
            if (node instanceof MergedDict) {
                MergedDict mergedDict = (MergedDict)node;
                node = this.convertMergedDictToDict(mergedDict);
            }
            return this.astFactory.asExpr((Object)node);
        }

        private ISimpleNode createMergedSequence(JsonObject asObject) {
            JsonValue type = asObject.get("type");
            Set node = null;
            if (type != null && type.isString()) {
                String asString = type.asString();
                if (asString.startsWith("set")) {
                    node = new Set(null);
                } else if (asString.startsWith("tuple")) {
                    node = new Tuple(null, 1, false);
                } else if (asString.startsWith("list")) {
                    node = new org.python.pydev.parser.jython.ast.List(null, 1);
                } else {
                    GenCythonAstImpl.log("Don't know how to deal with type: " + asString + " in: " + asObject.toPrettyString());
                    return null;
                }
            }
            ArrayList<JsonValue> bodyAsList = this.getBodyAsList(asObject.get("args"));
            ArrayList<Object> elts = new ArrayList<Object>();
            for (JsonValue jsonValue : bodyAsList) {
                ISimpleNode n = this.createNode(jsonValue);
                if (n == null) continue;
                if (n.getClass() == node.getClass()) {
                    exprType[] extractElts;
                    exprType[] exprTypeArray = extractElts = NodeUtils.extractElts((ISimpleNode)n);
                    int n2 = extractElts.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        exprType exprType2 = exprTypeArray[n3];
                        elts.add(exprType2);
                        ++n3;
                    }
                    continue;
                }
                Starred starred = new Starred(this.asExpr(n), 1);
                this.setLine((SimpleNode)starred, jsonValue.asObject());
                elts.add(starred);
            }
            if (node instanceof Set) {
                node.elts = elts.toArray(PyAstFactory.EMPTY_EXPR_TYPE);
            } else if (node instanceof Tuple) {
                ((Tuple)node).elts = elts.toArray(PyAstFactory.EMPTY_EXPR_TYPE);
            } else if (node instanceof org.python.pydev.parser.jython.ast.List) {
                ((org.python.pydev.parser.jython.ast.List)node).elts = elts.toArray(PyAstFactory.EMPTY_EXPR_TYPE);
            }
            return node;
        }

        private ISimpleNode createExec(JsonObject asObject) {
            exprType locals = null;
            exprType globals = null;
            exprType body = null;
            JsonValue args = asObject.get("args");
            if (args != null && args.isArray()) {
                JsonArray asArray = args.asArray();
                if (asArray.size() > 0) {
                    body = this.asExpr(this.createNode(asArray.get(0)));
                }
                if (asArray.size() > 1) {
                    globals = this.asExpr(this.createNode(asArray.get(1)));
                }
                if (asArray.size() > 2) {
                    locals = this.asExpr(this.createNode(asArray.get(2)));
                }
            }
            Exec exec = new Exec(body, globals, locals);
            this.setLine((SimpleNode)exec, asObject);
            return exec;
        }

        private ISimpleNode createStarredUnpacking(JsonObject asObject) {
            exprType value = this.asExpr(this.createNode(asObject.get("target")));
            Starred starred = new Starred(value, 1);
            this.setLine((SimpleNode)starred, asObject);
            return starred;
        }

        private ISimpleNode createComprehensionAppend(JsonObject asObject) {
            return this.createNode(asObject.get("expr"));
        }

        private ISimpleNode createProperty(JsonObject asObject) {
            Name name = this.createName(asObject);
            try {
                this.ctx.setStore((SimpleNode)name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setLine((SimpleNode)name, asObject);
            Assign assign = this.astFactory.createAssign(new exprType[]{name, this.createNone(asObject)});
            this.setLine((SimpleNode)assign, asObject);
            return assign;
        }

        private ISimpleNode createRaise(JsonObject asObject) {
            JsonValue cause;
            Raise raise = new Raise(null, null, null, null);
            JsonValue excType = asObject.get("exc_type");
            if (excType != null && excType.isObject()) {
                raise.type = this.asExpr(this.createNode(excType));
            }
            if ((cause = asObject.get("cause")) != null && cause.isObject()) {
                raise.cause = this.asExpr(this.createNode(cause));
            }
            this.setLine((SimpleNode)raise, asObject);
            return raise;
        }

        private ISimpleNode createReraise(JsonObject asObject) {
            Raise raise = new Raise(null, null, null, null);
            this.setLine((SimpleNode)raise, asObject);
            return raise;
        }

        private ISimpleNode createTryExcept(JsonObject asObject) {
            TryExcept tryExcept = new TryExcept(null, null, null);
            this.astFactory.setBody(tryExcept, this.extractStmts(asObject, "body").toArray());
            JsonValue exceptClauses = asObject.get("except_clauses");
            ArrayList<excepthandlerType> lst = new ArrayList<excepthandlerType>();
            if (exceptClauses != null && exceptClauses.isArray()) {
                JsonArray asArray = exceptClauses.asArray();
                for (JsonValue jsonValue : asArray) {
                    excepthandlerType exceptClause = this.createExceptClause(jsonValue.asObject());
                    lst.add(exceptClause);
                }
            }
            tryExcept.handlers = lst.toArray(new excepthandlerType[0]);
            this.setLine((SimpleNode)tryExcept, asObject);
            return tryExcept;
        }

        private excepthandlerType createExceptClause(JsonObject asObject) {
            JsonValue pattern;
            stmtType[] body = this.extractStmts(asObject, "body").toArray(PyAstFactory.EMPTY_STMT_TYPE);
            exprType name = null;
            exprType type = null;
            JsonValue target = asObject.get("target");
            if (target != null && target.isObject()) {
                name = this.asExpr(this.createNode(target));
                try {
                    this.ctx.setStore((SimpleNode)name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((pattern = asObject.get("pattern")) != null && pattern.isArray()) {
                ArrayList<exprType> lst = new ArrayList<exprType>();
                JsonArray asArray = pattern.asArray();
                for (JsonValue jsonValue : asArray) {
                    exprType asExpr = this.asExpr(this.createNode(jsonValue));
                    lst.add(asExpr);
                }
                if (lst.size() == 1) {
                    type = (exprType)lst.get(0);
                } else {
                    type = new Tuple(lst.toArray(PyAstFactory.EMPTY_EXPR_TYPE), 1, false);
                    this.setLine((SimpleNode)type, asArray.get(0).asObject());
                }
            }
            excepthandlerType excepthandlerType2 = new excepthandlerType(type, name, body, false);
            this.setLine((SimpleNode)excepthandlerType2, asObject);
            return excepthandlerType2;
        }

        private ISimpleNode createTryFinally(JsonObject asObject) {
            TryFinally tryFinally = new TryFinally(null, null);
            this.astFactory.setBody(tryFinally, this.extractStmts(asObject, "body").toArray());
            this.astFactory.setFinally(tryFinally, this.extractStmts(asObject, "finally_clause").toArray());
            this.setLine((SimpleNode)tryFinally, asObject);
            return tryFinally;
        }

        private ISimpleNode createEllipsis(JsonObject asObject) {
            Name name = new Name("...", 1, true);
            this.setLine((SimpleNode)name, asObject);
            return name;
        }

        private ISimpleNode createDel(JsonObject asObject) {
            ArrayList<exprType> targets = new ArrayList<exprType>();
            JsonValue args = asObject.get("args");
            if (args != null && args.isArray()) {
                JsonArray arr = args.asArray();
                for (JsonValue v : arr) {
                    ISimpleNode n = this.createNode(v);
                    if (n == null) continue;
                    targets.add(this.asExpr(n));
                }
            }
            Delete delete = new Delete(targets.toArray(PyAstFactory.EMPTY_EXPR_TYPE));
            try {
                this.ctx.setDelete((SimpleNode[])delete.targets);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setLine((SimpleNode)delete, asObject);
            return delete;
        }

        private ISimpleNode createTemplatedType(JsonObject asObject) {
            Name name = this.createNameFromBaseType(asObject);
            return name;
        }

        private ISimpleNode createNewExpr(JsonObject asObject) {
            JsonValue jsonValue = asObject.get("cppclass");
            if (jsonValue != null && jsonValue.isObject()) {
                ISimpleNode node = this.createNode(jsonValue);
                return node;
            }
            return null;
        }

        private Slice createSlice(JsonObject asObject) {
            JsonValue start = asObject.get("start");
            JsonValue stop = asObject.get("stop");
            JsonValue step = asObject.get("step");
            exprType startNode = null;
            exprType stopNode = null;
            exprType stepNode = null;
            if (start != null && start.isObject() && !this.isNone(start.asObject())) {
                startNode = this.asExpr(this.createNode(start));
            }
            if (stop != null && stop.isObject() && !this.isNone(stop.asObject())) {
                stopNode = this.asExpr(this.createNode(stop));
            }
            if (step != null && step.isObject() && !this.isNone(step.asObject())) {
                stepNode = this.asExpr(this.createNode(step));
            }
            Slice slice = new Slice(startNode, stopNode, stepNode);
            this.setLine((SimpleNode)slice, asObject);
            return slice;
        }

        private ISimpleNode createSliceIndex(JsonObject asObject) {
            JsonValue base = asObject.get("base");
            if (base != null && base.isObject()) {
                ISimpleNode subscript = this.createNode(base);
                Slice slice = this.createSlice(asObject);
                Subscript s = new Subscript(this.asExpr(subscript), (sliceType)slice, 1);
                this.setLine((SimpleNode)s, asObject);
                return s;
            }
            return null;
        }

        private boolean isNone(JsonObject asObject) {
            JsonValue node = asObject.get("__node__");
            return node != null && node.isString() && node.asString().equals("None");
        }

        private ISimpleNode createIndex(JsonObject asObject) {
            JsonValue base = asObject.get("base");
            if (base != null && base.isObject()) {
                JsonValue indexNodeType;
                ISimpleNode slice;
                ISimpleNode subscript = this.createNode(base);
                JsonValue index = asObject.get("index");
                if (index != null && index.isObject() && (slice = (indexNodeType = index.asObject().get("__node__")) != null && indexNodeType.isString() && indexNodeType.asString().equals("Tuple") ? this.createExtSliceFromTuple(index.asObject()) : this.createNode(index)) != null) {
                    if (!(slice instanceof sliceType)) {
                        Index idx = new Index(this.asExpr(slice));
                        this.setLine((SimpleNode)idx, index.asObject());
                        slice = idx;
                    }
                    Subscript s = new Subscript(this.asExpr(subscript), (sliceType)slice, 1);
                    this.setLine((SimpleNode)s, asObject);
                    return s;
                }
            }
            return null;
        }

        private ISimpleNode createExtSliceFromTuple(JsonObject asObject) {
            JsonValue jsonValue = asObject.get("args");
            ArrayList<JsonValue> bodyAsList = this.getBodyAsList(jsonValue);
            ArrayList<Object> lst = new ArrayList<Object>();
            for (JsonValue v : bodyAsList) {
                ISimpleNode bodyNode = this.createNode(v);
                if (bodyNode instanceof sliceType) {
                    lst.add((sliceType)bodyNode);
                    continue;
                }
                Index idx = new Index(this.asExpr(bodyNode));
                this.setLine((SimpleNode)idx, v.asObject());
                lst.add(idx);
            }
            ExtSlice extSlice = new ExtSlice(lst.toArray(new sliceType[0]));
            this.setLine((SimpleNode)extSlice, asObject);
            return extSlice;
        }

        private ISimpleNode createGlobal(JsonObject asObject, int flag, SimpleNode node) {
            ArrayList<NameTok> lst = new ArrayList<NameTok>();
            JsonValue names = asObject.get("names");
            if (names != null && names.isArray()) {
                JsonArray arr = names.asArray();
                for (JsonValue v : arr) {
                    if (!v.isString()) continue;
                    NameTok n = new NameTok(v.asString(), flag);
                    lst.add(n);
                    this.setLine((SimpleNode)n, asObject);
                }
                if (node instanceof Global) {
                    global = (Global)node;
                    global.names = lst.toArray(new NameTokType[0]);
                } else if (node instanceof NonLocal) {
                    global = (NonLocal)node;
                    global.names = lst.toArray(new NameTokType[0]);
                }
            }
            this.setLine(node, asObject);
            return node;
        }

        private Continue createContinue(JsonObject asObject) {
            Continue c = new Continue();
            this.setLine((SimpleNode)c, asObject);
            return c;
        }

        private Break createBreak(JsonObject asObject) {
            Break b = new Break();
            this.setLine((SimpleNode)b, asObject);
            return b;
        }

        private ISimpleNode createFromImport(JsonObject asObject) {
            ISimpleNode module;
            JsonValue moduleValue = asObject.get("module");
            if (moduleValue != null && moduleValue.isObject() && (module = this.createNode((JsonValue)moduleValue.asObject())) instanceof Import) {
                JsonValue level;
                Import imp = (Import)module;
                NameTok moduleName = (NameTok)imp.names[0].name;
                moduleName.ctx = 7;
                ImportFrom importFrom = new ImportFrom((NameTokType)moduleName, null, 0);
                this.setLine((SimpleNode)importFrom, asObject);
                JsonValue items = asObject.get("items");
                if (items.isArray()) {
                    ArrayList<aliasType> lst = new ArrayList<aliasType>();
                    JsonArray asArray = items.asArray();
                    for (JsonValue v : asArray) {
                        JsonArray arr2;
                        if (!v.isArray() || (arr2 = v.asArray()).size() != 2) continue;
                        JsonValue v0 = arr2.get(0);
                        JsonValue v2 = arr2.get(1);
                        NameTok nameTok = new NameTok(v0.asString(), 4);
                        this.setLine((SimpleNode)nameTok, v2.asObject());
                        NameTok n2 = this.createNameTok(v2.asObject(), 4);
                        if (n2 != null && n2.id != null && n2.id.equals(nameTok.id)) {
                            n2 = null;
                        }
                        if (nameTok.id.equals("*")) continue;
                        lst.add(new aliasType((NameTokType)nameTok, (NameTokType)n2));
                    }
                    importFrom.names = lst.toArray(new aliasType[0]);
                }
                if ((level = moduleValue.asObject().get("level")) != null && level.isString()) {
                    try {
                        importFrom.level = Integer.parseInt(level.asString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return importFrom;
            }
            return null;
        }

        private ISimpleNode createPrint(JsonObject asObject) {
            JsonValue jsonValue = asObject.get("arg_tuple");
            ISimpleNode args = this.createNode(jsonValue);
            if (args instanceof Tuple) {
                Tuple tuple = (Tuple)args;
                JsonValue appendNewLine = asObject.get("append_newline");
                boolean nl = appendNewLine != null && appendNewLine.isString() && appendNewLine.asString().equals("True");
                Print node = new Print(null, tuple.elts, nl);
                this.setLine((SimpleNode)node, asObject);
                return node;
            }
            return null;
        }

        private ISimpleNode createFromCImportStat(JsonObject asObject) {
            JsonValue jsonValue = asObject.get("imported_names");
            NodeList nodeList = new NodeList();
            if (jsonValue != null && jsonValue.isArray()) {
                JsonArray asArray = jsonValue.asArray();
                for (JsonValue v : asArray) {
                    if (v.isString()) {
                        String s = v.asString();
                        Name name = new Name(s, 2, false);
                        this.setLine((SimpleNode)name, asObject);
                        Assign assign = this.astFactory.createAssign(new exprType[]{name, this.createNone(asObject)});
                        this.setLine((SimpleNode)assign, asObject);
                        nodeList.nodes.add((ISimpleNode)assign);
                        continue;
                    }
                    if (!v.isArray()) continue;
                    for (JsonValue x : v.asArray()) {
                        if (!x.isString()) continue;
                        String s = x.asString();
                        Name name = new Name(s, 2, false);
                        this.setLine((SimpleNode)name, asObject);
                        Assign assign = this.astFactory.createAssign(new exprType[]{name, this.createNone(asObject)});
                        this.setLine((SimpleNode)assign, asObject);
                        nodeList.nodes.add((ISimpleNode)assign);
                    }
                }
            }
            return nodeList;
        }

        private ISimpleNode createCImportStat(JsonObject asObject) {
            JsonValue jsonValue = asObject.get("module_name");
            JsonValue asName = asObject.get("as_name");
            if (asName != null && asName.isString() && !asName.asString().equals("None")) {
                jsonValue = asName;
            }
            if (jsonValue != null && jsonValue.isString()) {
                Name name = new Name(jsonValue.asString(), 2, false);
                this.setLine((SimpleNode)name, asObject);
                Assign assign = this.astFactory.createAssign(new exprType[]{name, this.createNone(asObject)});
                this.setLine((SimpleNode)assign, asObject);
                return assign;
            }
            return null;
        }

        private ISimpleNode createImport(JsonObject asObject) {
            JsonValue jsonValue = asObject.get("module_name");
            if (jsonValue != null && jsonValue.isObject()) {
                ArrayList<aliasType> alias = new ArrayList<aliasType>();
                JsonValue nameList = asObject.get("name_list");
                NameTok foundNameList = nameList == null || nameList.isString() && nameList.asString().equals("None") ? null : FOUND_NAME_LIST;
                NameTok name = this.createNameTok(jsonValue.asObject(), 4);
                alias.add(new aliasType((NameTokType)name, (NameTokType)foundNameList));
                Import imp = new Import(alias.toArray(new aliasType[0]));
                return imp;
            }
            return null;
        }

        private ISimpleNode createTypecast(JsonObject asObject) {
            ISimpleNode operand;
            JsonValue jsonValue;
            Name name = this.createNameFromBaseType(asObject);
            if (name != null && (jsonValue = asObject.get("operand")).isObject() && (operand = this.createNode((JsonValue)jsonValue.asObject())) != null) {
                ArrayList<exprType> params = new ArrayList<exprType>();
                exprType expr = this.asExpr(operand);
                if (expr != null) {
                    params.add(expr);
                }
                Call call = this.astFactory.createCall((exprType)name, params, new keywordType[0], null, null);
                this.setLine((SimpleNode)call, asObject);
                return call;
            }
            return null;
        }

        private Tuple createTuple(JsonObject asObject) throws Exception {
            boolean endsWithComma = false;
            List<exprType> extract = this.extractExprs(asObject, "args");
            Tuple tup = new Tuple(this.astFactory.createExprArray(extract.toArray()), 1, endsWithComma);
            this.setLine((SimpleNode)tup, asObject);
            return tup;
        }

        private Tuple createAsTuple(JsonObject asObject) throws Exception {
            boolean endsWithComma = false;
            List<exprType> extract = this.extractExprs(asObject, "arg");
            Tuple tup = new Tuple(this.astFactory.createExprArray(extract.toArray()), 1, endsWithComma);
            this.setLine((SimpleNode)tup, asObject);
            return tup;
        }

        private org.python.pydev.parser.jython.ast.List createList(JsonObject asObject) throws Exception {
            List<exprType> extract = this.extractExprs(asObject, "args");
            org.python.pydev.parser.jython.ast.List tup = new org.python.pydev.parser.jython.ast.List(this.astFactory.createExprArray(extract.toArray()), 1);
            this.setLine((SimpleNode)tup, asObject);
            return tup;
        }

        private Set createSet(JsonObject asObject) throws Exception {
            List<exprType> extract = this.extractExprs(asObject, "args");
            Set tup = new Set(this.astFactory.createExprArray(extract.toArray()));
            this.setLine((SimpleNode)tup, asObject);
            return tup;
        }

        private ISimpleNode createMergedDict(JsonObject asObject) throws Exception {
            ArrayList<JsonValue> bodyAsList = this.getBodyAsList(asObject.get("keyword_args"));
            MergedDict dct = new MergedDict();
            for (JsonValue jsonValue : bodyAsList) {
                ISimpleNode n = this.createNode(jsonValue);
                if (n == null) continue;
                dct.nodes.add(n);
            }
            return dct;
        }

        private Dict createDict(JsonObject asObject) throws Exception {
            ArrayList<JsonValue> bodyAsList = this.getBodyAsList(asObject.get("key_value_pairs"));
            ArrayList<exprType> keys = new ArrayList<exprType>();
            ArrayList<exprType> values = new ArrayList<exprType>();
            for (JsonValue jsonValue : bodyAsList) {
                JsonObject itemAsObj = jsonValue.asObject();
                ISimpleNode key = this.createNode(itemAsObj.get("key"));
                ISimpleNode val = this.createNode(itemAsObj.get("value"));
                keys.add(this.asExpr(key));
                values.add(this.asExpr(val));
            }
            Dict tup = new Dict(keys.toArray(PyAstFactory.EMPTY_EXPR_TYPE), values.toArray(PyAstFactory.EMPTY_EXPR_TYPE));
            this.setLine((SimpleNode)tup, asObject);
            return tup;
        }

        private SimpleNode createString(JsonObject asObject) {
            boolean raw = false;
            boolean unicode = false;
            boolean binary = false;
            boolean fstring = false;
            int type = 3;
            String s = "";
            JsonValue value = asObject.get("unicode_value");
            if (value != null && value.isString()) {
                s = value.asString();
            }
            Str str = new Str(s, type, unicode, raw, binary, fstring, null);
            this.setLine((SimpleNode)str, asObject);
            return str;
        }

        private SimpleNode createAnnotation(JsonObject asObject) {
            JsonValue value = asObject.get("expr");
            return (SimpleNode)this.createNode(value);
        }

        private SimpleNode createFString(JsonObject asObject) throws Exception {
            boolean raw = false;
            boolean unicode = true;
            boolean binary = false;
            boolean fstring = false;
            int type = 3;
            String s = "";
            ArrayList<ISimpleNode> stmts = new ArrayList<ISimpleNode>();
            JsonValue values = asObject.get("values");
            if (values != null && values.isArray()) {
                for (JsonValue v : values.asArray()) {
                    ISimpleNode node;
                    if (!v.isObject()) continue;
                    JsonObject o = v.asObject();
                    JsonValue n = o.get("__node__");
                    if (n != null && n.isString() && n.asString().equals("FormattedValue")) {
                        node = this.createNode(o.get("value"));
                        this.addToNodesList(node, stmts);
                        continue;
                    }
                    node = this.createNode((JsonValue)o);
                    if (node == null) continue;
                    stmts.add(node);
                }
            }
            Str str = new Str(s, type, unicode, raw, binary, fstring, stmts.size() == 0 ? null : this.astFactory.createStmtArray(stmts.toArray()));
            this.setLine((SimpleNode)str, asObject);
            return str;
        }

        private void addToStmtsList(ISimpleNode node, List<stmtType> stmts) {
            if (node != null) {
                if (node instanceof NodeList) {
                    NodeList nodeList = (NodeList)node;
                    for (ISimpleNode n : nodeList.nodes) {
                        this.addToStmtsList(n, stmts);
                    }
                } else {
                    stmts.add(this.astFactory.asStmt((Object)node));
                }
            }
        }

        private void addToExprsList(ISimpleNode node, List<exprType> exprs) {
            if (node != null) {
                if (node instanceof NodeList) {
                    NodeList nodeList = (NodeList)node;
                    for (ISimpleNode n : nodeList.nodes) {
                        this.addToExprsList(n, exprs);
                    }
                } else {
                    exprs.add(this.asExpr(node));
                }
            }
        }

        private void addToNodesList(ISimpleNode node, List<ISimpleNode> lst) {
            if (node != null) {
                if (node instanceof NodeList) {
                    NodeList nodeList = (NodeList)node;
                    for (ISimpleNode n : nodeList.nodes) {
                        this.addToNodesList(n, lst);
                    }
                } else {
                    lst.add(node);
                }
            }
        }

        private SimpleNode createUnicode(JsonObject asObject) {
            boolean raw = false;
            boolean unicode = true;
            boolean binary = false;
            boolean fstring = false;
            int type = 3;
            String s = "";
            JsonValue value = asObject.get("value");
            if (value != null && value.isString()) {
                s = value.asString();
            }
            Str str = new Str(s, type, unicode, raw, binary, fstring, null);
            this.setLine((SimpleNode)str, asObject);
            return str;
        }

        private SimpleNode createBytes(JsonObject asObject) {
            boolean raw = false;
            boolean unicode = false;
            boolean binary = true;
            boolean fstring = false;
            int type = 3;
            String s = "";
            JsonValue value = asObject.get("value");
            if (value != null && value.isString()) {
                s = value.asString();
            }
            Str str = new Str(s, type, unicode, raw, binary, fstring, null);
            this.setLine((SimpleNode)str, asObject);
            return str;
        }

        private SimpleNode createComprehension(JsonObject asObject) throws Exception {
            return this.createGeneratorExpression(asObject);
        }

        private SimpleNode createGeneratorExpression(JsonObject asObject) throws Exception {
            ISimpleNode loopNode;
            JsonValue loop = asObject.get("loop");
            ListComp node = null;
            if (loop != null && loop.isObject() && (loopNode = this.createNode(loop)) instanceof For) {
                JsonValue type;
                For for1 = (For)loopNode;
                exprType iter = for1.iter;
                suiteType orelse = for1.orelse;
                exprType target = for1.target;
                stmtType[] body = for1.body;
                Comprehension generator = new Comprehension(target, iter, PyAstFactory.EMPTY_EXPR_TYPE);
                exprType exprToUse = null;
                if (body.length == 1) {
                    stmtType stmtType2 = body[0];
                    if (stmtType2 instanceof If) {
                        If if1 = (If)stmtType2;
                        if (if1.body != null && if1.body.length == 1) {
                            stmtType2 = if1.body[0];
                            generator.ifs = new exprType[]{if1.test};
                        }
                    }
                    if (stmtType2 instanceof Expr) {
                        Expr expr = (Expr)stmtType2;
                        exprToUse = expr.value;
                        if (expr.value instanceof Yield) {
                            Yield yield = (Yield)expr.value;
                            exprToUse = yield.value;
                        }
                    }
                }
                if ((type = asObject.get("type")) != null && type.isString()) {
                    if (type.asString().startsWith("dict")) {
                        JsonValue appendValue = asObject.get("append");
                        if (appendValue != null && appendValue.isObject()) {
                            JsonObject appendAsObject = appendValue.asObject();
                            node = new DictComp(this.asExpr(this.createNode(appendAsObject.get("key_expr"))), this.asExpr(this.createNode(appendAsObject.get("value_expr"))), new comprehensionType[]{generator});
                        } else {
                            node = new DictComp(null, null, new comprehensionType[]{generator});
                            GenCythonAstImpl.log("Expected append to be an object.");
                        }
                    } else {
                        node = type.asString().startsWith("list") ? new ListComp(exprToUse, new comprehensionType[]{generator}, 1) : (type.asString().startsWith("tuple") ? new ListComp(exprToUse, new comprehensionType[]{generator}, 2) : new ListComp(exprToUse, new comprehensionType[]{generator}, 3));
                    }
                } else {
                    node = new ListComp(exprToUse, new comprehensionType[]{generator}, 3);
                }
            }
            return node;
        }

        private SimpleNode createGeneralCall(JsonObject asObject) throws Exception {
            JsonObject funcAsObject;
            Name name;
            JsonValue funcJsonValue = asObject.get("function");
            if (funcJsonValue != null && funcJsonValue.isObject() && (name = this.createName(funcAsObject = funcJsonValue.asObject())) != null) {
                JsonValue jsonValueArgs = asObject.get("positional_args");
                JsonValue jsonKeywordArgs = asObject.get("keyword_args");
                ArrayList<exprType> params = new ArrayList<exprType>();
                ArrayList<keywordType> keywords = new ArrayList<keywordType>();
                exprType starargs = null;
                exprType kwargs = null;
                if (jsonValueArgs != null) {
                    if (jsonValueArgs.isArray()) {
                        for (JsonValue v : jsonValueArgs.asArray()) {
                            ISimpleNode n = this.createNode(v);
                            if (n == null) continue;
                            params.add(this.asExpr(n));
                        }
                    } else if (jsonValueArgs.isObject()) {
                        JsonValue node = jsonValueArgs.asObject().get("__node__");
                        if (node != null && node.isString() && node.asString().equals("AsTuple")) {
                            starargs = this.createStarArgsFromAsTuple(jsonValueArgs);
                        } else if (node != null && node.isString() && node.asString().equals("Add")) {
                            JsonValue op1 = jsonValueArgs.asObject().get("operand1");
                            JsonValue op2 = jsonValueArgs.asObject().get("operand2");
                            starargs = this.createStarArgsFromAsTuple(op2);
                            this.createParamsFromTuple(op1, params);
                        } else {
                            this.createParamsFromTuple(jsonValueArgs, params);
                        }
                    }
                }
                if (jsonKeywordArgs != null && jsonKeywordArgs.isObject()) {
                    ISimpleNode dictNode = this.createNode(jsonKeywordArgs);
                    if (dictNode instanceof Dict) {
                        Dict dict = (Dict)dictNode;
                        boolean afterstarargs = starargs == null;
                        this.fillKeywordsFromDict(keywords, dict, afterstarargs);
                    } else if (dictNode instanceof MergedDict) {
                        MergedDict mergedDict = (MergedDict)dictNode;
                        for (ISimpleNode node : mergedDict.nodes) {
                            if (node instanceof Dict) {
                                Dict dict = (Dict)node;
                                boolean afterstarargs = starargs == null;
                                this.fillKeywordsFromDict(keywords, dict, afterstarargs);
                                continue;
                            }
                            if (node instanceof exprType) {
                                kwargs = (exprType)node;
                                continue;
                            }
                            if (node instanceof MergedDict) {
                                kwargs = this.convertMergedDictToDict((MergedDict)node);
                                continue;
                            }
                            GenCythonAstImpl.log("Don't know how to deal with merged dict entry: " + String.valueOf(node));
                            return null;
                        }
                    } else if (dictNode instanceof exprType) {
                        kwargs = (exprType)dictNode;
                    }
                }
                Call call = this.astFactory.createCall((exprType)name, params, keywords.toArray(new keywordType[0]), starargs, kwargs);
                this.setLine((SimpleNode)call, asObject);
                return call;
            }
            return null;
        }

        private exprType convertMergedDictToDict(MergedDict node) {
            List<ISimpleNode> nodes = node.nodes;
            ArrayList<exprType> keys = new ArrayList<exprType>();
            ArrayList values = new ArrayList();
            for (ISimpleNode iSimpleNode : nodes) {
                if (iSimpleNode instanceof Dict) {
                    int n;
                    int n2;
                    exprType[] exprTypeArray;
                    Dict dict = (Dict)iSimpleNode;
                    if (dict.keys != null) {
                        exprTypeArray = dict.keys;
                        n2 = dict.keys.length;
                        n = 0;
                        while (n < n2) {
                            exprType k = exprTypeArray[n];
                            keys.add(k);
                            ++n;
                        }
                    }
                    if (dict.values == null) continue;
                    exprTypeArray = dict.values;
                    n2 = dict.values.length;
                    n = 0;
                    while (n < n2) {
                        exprType v = exprTypeArray[n];
                        keys.add(v);
                        ++n;
                    }
                    continue;
                }
                if (!(iSimpleNode instanceof exprType)) continue;
                keys.add((exprType)iSimpleNode);
            }
            return new Dict(keys.toArray(PyAstFactory.EMPTY_EXPR_TYPE), values.toArray(PyAstFactory.EMPTY_EXPR_TYPE));
        }

        private void fillKeywordsFromDict(List<keywordType> keywords, Dict dict, boolean afterstarargs) {
            int i = 0;
            while (i < dict.keys.length) {
                exprType key = dict.keys[i];
                if (key instanceof Name) {
                    Name nameKey = (Name)key;
                    NameTok nameTok = new NameTok(nameKey.id, 3);
                    nameTok.beginColumn = key.beginColumn;
                    nameTok.beginLine = key.beginLine;
                    exprType value = dict.values[i];
                    keywords.add(new keywordType((NameTokType)nameTok, value, afterstarargs));
                }
                ++i;
            }
        }

        private void createParamsFromTuple(JsonValue jsonValueArgs, List<exprType> params) {
            ISimpleNode asTupleNode = this.createNode(jsonValueArgs);
            if (asTupleNode instanceof Tuple) {
                Tuple tuple = (Tuple)asTupleNode;
                exprType[] exprTypeArray = tuple.elts;
                int n = tuple.elts.length;
                int n2 = 0;
                while (n2 < n) {
                    exprType e = exprTypeArray[n2];
                    params.add(e);
                    ++n2;
                }
            }
        }

        private exprType createStarArgsFromAsTuple(JsonValue jsonValueArgs) {
            exprType starargs = null;
            ISimpleNode asTupleNode = this.createNode(jsonValueArgs);
            if (asTupleNode instanceof Tuple) {
                Tuple tuple = (Tuple)asTupleNode;
                if (tuple.elts.length > 0) {
                    starargs = tuple.elts[0];
                }
            }
            return starargs;
        }

        private SimpleNode createSimpleCall(JsonObject asObject) throws Exception {
            JsonObject funcAsObject;
            exprType expr;
            JsonValue funcJsonValue = asObject.get("function");
            if (funcJsonValue != null && funcJsonValue.isObject() && (expr = this.asExpr(this.createNode((JsonValue)(funcAsObject = funcJsonValue.asObject())))) != null) {
                JsonValue jsonValueArgs = asObject.get("args");
                ArrayList<exprType> params = new ArrayList<exprType>();
                ArrayList keywords = new ArrayList();
                exprType starargs = null;
                exprType kwargs = null;
                if (jsonValueArgs != null && jsonValueArgs.isArray()) {
                    for (JsonValue v : jsonValueArgs.asArray()) {
                        ISimpleNode n = this.createNode(v);
                        if (n == null) continue;
                        params.add(this.asExpr(n));
                    }
                }
                Call call = this.astFactory.createCall(expr, params, keywords.toArray(new keywordType[0]), starargs, kwargs);
                this.setLine((SimpleNode)call, asObject);
                return call;
            }
            return null;
        }

        public ISimpleNode createAugAssign(JsonObject asObject) {
            AugAssign node;
            block33: {
                node = null;
                JsonValue op1 = asObject.get("lhs");
                JsonValue op2 = asObject.get("rhs");
                JsonValue operator = asObject.get("operator");
                if (op1 == null || !op1.isObject() || op2 == null || !op2.isObject() || operator == null || !operator.isString()) break block33;
                ISimpleNode left = this.createNode(op1);
                ISimpleNode right = this.createNode(op2);
                int op = 0;
                switch (operator.asString()) {
                    case "+": {
                        op = 1;
                        break;
                    }
                    case "-": {
                        op = 2;
                        break;
                    }
                    case "*": {
                        op = 3;
                        break;
                    }
                    case "/": {
                        op = 4;
                        break;
                    }
                    case "@": {
                        op = 13;
                        break;
                    }
                    case "&": {
                        op = 11;
                        break;
                    }
                    case "|": {
                        op = 9;
                        break;
                    }
                    case "^": {
                        op = 10;
                        break;
                    }
                    case "%": {
                        op = 5;
                    }
                }
                exprType leftAsExpr = this.asExpr(left);
                try {
                    this.ctx.setAugStore((SimpleNode)leftAsExpr);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                node = new AugAssign(leftAsExpr, op, this.asExpr(right));
                this.setLine((SimpleNode)node, asObject);
            }
            return node;
        }

        public ISimpleNode createUnaryOp(JsonObject asObject) {
            JsonValue operator = asObject.get("operator");
            return this.createUnaryOp(asObject, operator.asString());
        }

        public ISimpleNode createUnaryOp(JsonObject asObject, String operator) {
            JsonValue operand = asObject.get("operand");
            int op = 0;
            switch (operator) {
                case "~": {
                    op = 1;
                    break;
                }
                case "-": {
                    op = 4;
                    break;
                }
                case "+": {
                    op = 3;
                    break;
                }
                case "not": {
                    op = 2;
                }
            }
            UnaryOp node = new UnaryOp(op, this.asExpr(this.createNode(operand)));
            this.setLine((SimpleNode)node, asObject);
            return node;
        }

        public ISimpleNode createBinOp(JsonObject asObject) {
            BinOp node;
            block34: {
                node = null;
                JsonValue op1 = asObject.get("operand1");
                JsonValue op2 = asObject.get("operand2");
                JsonValue operator = asObject.get("operator");
                if (op1 == null || !op1.isObject() || op2 == null || !op2.isObject() || operator == null || !operator.isString()) break block34;
                ISimpleNode left = this.createNode(op1);
                ISimpleNode right = this.createNode(op2);
                int op = 0;
                switch (operator.asString()) {
                    case "+": {
                        op = 1;
                        break;
                    }
                    case "-": {
                        op = 2;
                        break;
                    }
                    case "*": {
                        op = 3;
                        break;
                    }
                    case "/": {
                        op = 4;
                        break;
                    }
                    case "@": {
                        op = 13;
                        break;
                    }
                    case "&": {
                        op = 11;
                        break;
                    }
                    case "|": {
                        op = 9;
                        break;
                    }
                    case "^": {
                        op = 10;
                        break;
                    }
                    case "**": {
                        op = 6;
                        break;
                    }
                    case "%": {
                        op = 5;
                        break;
                    }
                }
                node = new BinOp(this.asExpr(left), op, this.asExpr(right));
                this.setLine((SimpleNode)node, asObject);
            }
            return node;
        }

        private BoolOp createBoolOp(JsonObject asObject) {
            BoolOp node;
            block10: {
                node = null;
                JsonValue op1 = asObject.get("operand1");
                JsonValue op2 = asObject.get("operand2");
                JsonValue operator = asObject.get("operator");
                if (op1 == null || !op1.isObject() || op2 == null || !op2.isObject() || operator == null || !operator.isString()) break block10;
                ISimpleNode left = this.createNode(op1);
                ISimpleNode right = this.createNode(op2);
                int op = 0;
                switch (operator.asString()) {
                    case "or": {
                        op = 2;
                        break;
                    }
                    case "and": {
                        op = 1;
                    }
                }
                node = new BoolOp(op, new exprType[]{this.asExpr(left), this.asExpr(right)});
                this.setLine((SimpleNode)node, asObject);
            }
            return node;
        }

        private Compare createCompare(JsonObject asObject) {
            Compare node = null;
            JsonValue op1 = asObject.get("operand1");
            JsonValue op2 = asObject.get("operand2");
            JsonValue operator = asObject.get("operator");
            if (op1 != null && op1.isObject() && op2 != null && op2.isObject() && operator != null && operator.isString()) {
                ISimpleNode left = this.createNode(op1);
                ArrayList<exprType> right = new ArrayList<exprType>();
                right.add(this.asExpr(this.createNode(op2)));
                ArrayList<Integer> operators = new ArrayList<Integer>();
                operators.add(this.opToCompareOp(operator.asString()));
                JsonValue cascadeValue = asObject.get("cascade");
                if (cascadeValue != null && cascadeValue.isObject()) {
                    CascadeNode cascadeNode = (CascadeNode)this.createNode(cascadeValue);
                    while (cascadeNode != null) {
                        operators.add(this.opToCompareOp(cascadeNode.operator));
                        right.add(this.asExpr(cascadeNode.operand));
                        cascadeNode = cascadeNode.cascade;
                    }
                }
                node = new Compare(this.asExpr(left), operators.stream().mapToInt(i -> i).toArray(), right.toArray(PyAstFactory.EMPTY_EXPR_TYPE));
                this.setLine((SimpleNode)node, asObject);
            }
            return node;
        }

        private int opToCompareOp(String opStr) {
            int op = 0;
            switch (opStr) {
                case ">": {
                    op = 5;
                    break;
                }
                case "==": {
                    op = 1;
                    break;
                }
                case "!=": {
                    op = 2;
                    break;
                }
                case "<": {
                    op = 3;
                    break;
                }
                case ">=": {
                    op = 6;
                    break;
                }
                case "<=": {
                    op = 4;
                    break;
                }
                case "in": {
                    op = 9;
                    break;
                }
                case "not_in": {
                    op = 10;
                    break;
                }
                case "is": {
                    op = 7;
                    break;
                }
                case "is_not": {
                    op = 8;
                }
            }
            return op;
        }

        private ISimpleNode createCascade(JsonObject asObject) {
            JsonValue operator = asObject.get("operator");
            JsonValue operand = asObject.get("operand2");
            JsonValue cascade = asObject.get("cascade");
            return new CascadeNode(operator.asString(), this.createNode(operand), (CascadeNode)this.createNode(cascade));
        }

        private exprType createExpr(JsonObject asObject) throws Exception {
            try {
                ISimpleNode node = this.createNode(asObject.get("expr"));
                exprType expr = this.asExpr(node);
                this.setLine((SimpleNode)expr, asObject);
                return expr;
            }
            catch (Exception e) {
                GenCythonAstImpl.log(e);
                return null;
            }
        }

        private SimpleNode createAwait(JsonObject asObject) {
            try {
                exprType node = this.asExpr(this.createNode(asObject.get("arg")));
                Await await = new Await(node);
                this.setLine((SimpleNode)await, asObject);
                return await;
            }
            catch (Exception e) {
                GenCythonAstImpl.log(e);
                return null;
            }
        }

        private Pass createPass(JsonObject asObject) {
            Pass pass = this.astFactory.createPass();
            this.setLine((SimpleNode)pass, asObject);
            return pass;
        }

        private void setBases(JsonObject asObject, ClassDef classDef) {
            this.setBases(asObject, classDef, "bases");
        }

        private void setBases(JsonObject asObject, ClassDef classDef, String basesName) {
            List<exprType> bases = this.extractExprs(asObject, "bases");
            if (bases.size() == 1 && bases.get(0) instanceof Tuple) {
                Tuple tuple = (Tuple)bases.get(0);
                this.astFactory.setBases(classDef, (Object[])tuple.elts);
            } else {
                this.astFactory.setBases(classDef, bases.toArray());
            }
        }

        private ClassDef createCEnumDef(JsonObject asObject) throws Exception {
            JsonValue value = asObject.get("name");
            if (value != null && value.isString()) {
                ClassDef classDef = this.astFactory.createClassDef(value.asString());
                this.setLine((SimpleNode)classDef, asObject);
                classDef.name.beginLine = classDef.beginLine;
                classDef.name.beginColumn = classDef.beginColumn + 7;
                ArrayList<Assign> nodes = new ArrayList<Assign>();
                JsonValue items = asObject.get("items");
                if (items != null && items.isArray()) {
                    JsonArray asArray = items.asArray();
                    for (JsonValue item : asArray) {
                        Name name;
                        if (!item.isObject() || (name = this.createName(item.asObject())) == null) continue;
                        this.ctx.setStore((SimpleNode)name);
                        Num num = new Num((Object)new Integer(0), 1, "0");
                        Assign assign = this.astFactory.createAssign(new exprType[]{name, num});
                        this.setLine((SimpleNode)assign, item.asObject());
                        this.setLine((SimpleNode)num, item.asObject());
                        nodes.add(assign);
                    }
                }
                this.astFactory.setBody(classDef, nodes.toArray());
                classDef.decs = this.createDecorators(asObject, (SimpleNode)classDef);
                return classDef;
            }
            return null;
        }

        private ClassDef createClassDef(JsonObject asObject) throws Exception {
            JsonValue value = asObject.get("name");
            if (value != null && value.isString()) {
                ClassDef classDef = this.astFactory.createClassDef(value.asString());
                this.setLine((SimpleNode)classDef, asObject);
                classDef.name.beginLine = classDef.beginLine;
                classDef.name.beginColumn = classDef.beginColumn + 6;
                this.setBases(asObject, classDef);
                this.astFactory.setBody(classDef, this.extractStmts(asObject, "body").toArray());
                classDef.decs = this.createDecorators(asObject, (SimpleNode)classDef);
                return classDef;
            }
            return null;
        }

        private ISimpleNode createSizeofVar(JsonObject asObject) throws Exception {
            Call call = this.astFactory.createCall("sizeof", new String[0]);
            this.setLine((SimpleNode)call.func, asObject);
            this.setLine((SimpleNode)call, asObject);
            return call;
        }

        private ISimpleNode createSizeofType(JsonObject asObject) {
            Call call = this.astFactory.createCall("sizeof", new String[0]);
            this.setLine((SimpleNode)call.func, asObject);
            this.setLine((SimpleNode)call, asObject);
            return call;
        }

        private ISimpleNode createFusedType(JsonObject asObject) {
            Name name = this.createName(asObject);
            try {
                this.ctx.setStore((SimpleNode)name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            JsonValue jsonValue = asObject.get("types");
            if (jsonValue != null && jsonValue.isArray()) {
                JsonValue val = jsonValue.asArray().get(0);
                ISimpleNode node = this.createNode(val);
                if (node == null) {
                    node = this.astFactory.createNone();
                }
                Assign assign = this.astFactory.createAssign(new exprType[]{name, this.asExpr(node)});
                this.setLine((SimpleNode)assign, asObject);
                return assign;
            }
            return null;
        }

        private ISimpleNode createCSimpleBaseType(JsonObject asObject) {
            return this.createName(asObject);
        }

        private ISimpleNode createCtypeDef(JsonObject asObject) {
            Name name;
            JsonValue declarator = this.getDeclarator(asObject);
            if (declarator.isObject() && (name = this.createName(declarator.asObject())) != null) {
                try {
                    this.ctx.setStore((SimpleNode)name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Name nameNode = this.createNameFromBaseType(asObject);
                if (nameNode == null) {
                    nameNode = this.astFactory.createNone();
                }
                Assign assign = this.astFactory.createAssign(new exprType[]{name, nameNode});
                this.setLine((SimpleNode)assign, asObject);
                return assign;
            }
            return null;
        }

        private ISimpleNode createCStructOrUnionDef(JsonObject asObject) {
            JsonValue value = asObject.get("name");
            if (value != null && value.isString()) {
                ClassDef classDef = this.astFactory.createClassDef(value.asString());
                this.setLine((SimpleNode)classDef, asObject);
                classDef.name.beginLine = classDef.beginLine;
                classDef.name.beginColumn = classDef.beginColumn + 6;
                this.astFactory.setBody(classDef, this.extractStmts(asObject, "attributes").toArray());
                return classDef;
            }
            return null;
        }

        private ClassDef createCppClass(JsonObject asObject) throws Exception {
            JsonValue value = asObject.get("name");
            if (value != null && value.isString()) {
                ClassDef classDef = this.astFactory.createClassDef(value.asString());
                this.setLine((SimpleNode)classDef, asObject);
                classDef.name.beginLine = classDef.beginLine;
                classDef.name.beginColumn = classDef.beginColumn + 6;
                this.setBases(asObject, classDef, "base_classes");
                this.astFactory.setBody(classDef, this.extractStmts(asObject, "attributes").toArray());
                classDef.decs = this.createDecorators(asObject, (SimpleNode)classDef);
                return classDef;
            }
            return null;
        }

        private ClassDef createCClassDef(JsonObject asObject) throws Exception {
            JsonValue value = asObject.get("class_name");
            if (value != null && value.isString()) {
                ClassDef classDef = this.astFactory.createClassDef(value.asString());
                this.setLine((SimpleNode)classDef, asObject);
                classDef.name.beginLine = classDef.beginLine;
                classDef.name.beginColumn = classDef.beginColumn + 6;
                this.setBases(asObject, classDef);
                this.astFactory.setBody(classDef, this.extractStmts(asObject, "body").toArray());
                classDef.decs = this.createDecorators(asObject, (SimpleNode)classDef);
                return classDef;
            }
            return null;
        }

        private ISimpleNode createLambda(JsonObject asObject) {
            Lambda lambda = new Lambda(null, null);
            lambda.args = this.createArgs(asObject);
            lambda.body = this.asExpr(this.createNode(asObject.get("result_expr")));
            this.setLine((SimpleNode)lambda, asObject);
            return lambda;
        }

        private FunctionDef createFunctionDef(JsonObject asObject) throws Exception {
            JsonValue value = asObject.get("name");
            if (value != null && value.isString()) {
                FunctionDef funcDef = PyAstFactory.createFunctionDef((String)value.asString());
                this.setLine((SimpleNode)funcDef, asObject);
                funcDef.name.beginLine = funcDef.beginLine;
                funcDef.name.beginColumn = funcDef.beginColumn + 4;
                funcDef.args = this.createArgs(asObject);
                funcDef.decs = this.createDecorators(asObject, (SimpleNode)funcDef);
                JsonValue isAsyncDef = asObject.get("is_async_def");
                if (isAsyncDef != null && isAsyncDef.asString().equals("True")) {
                    funcDef.async = true;
                }
                this.astFactory.setBody(funcDef, this.extractStmts(asObject, "body").toArray());
                return funcDef;
            }
            return null;
        }

        private FunctionDef createCFuncDeclarator(JsonObject declarator) throws Exception {
            JsonValue name;
            FunctionDef funcDef = null;
            JsonValue baseDeclarator = declarator.asObject().get("base");
            if (baseDeclarator != null && (name = baseDeclarator.asObject().get("name")) != null) {
                NameTok nameTok = this.createNameTok(baseDeclarator.asObject(), 2);
                funcDef = PyAstFactory.createFunctionDef((NameTokType)nameTok);
                this.setLine((SimpleNode)funcDef, declarator);
                funcDef.args = this.createArgs(declarator.asObject());
            }
            return funcDef;
        }

        private FunctionDef createCFunctionDef(JsonObject asObject) throws Exception {
            JsonValue declarator = this.getDeclarator(asObject);
            if (declarator != null && declarator.isObject()) {
                FunctionDef funcDef = this.createCFuncDeclarator(declarator.asObject());
                if (funcDef != null) {
                    funcDef.decs = this.createDecorators(asObject, (SimpleNode)funcDef);
                    this.setLine((SimpleNode)funcDef, asObject);
                    this.setLine((SimpleNode)funcDef.name, asObject);
                    this.astFactory.setBody(funcDef, this.extractStmts(asObject, "body").toArray());
                }
                return funcDef;
            }
            return null;
        }

        public List<stmtType> extractStmts(JsonObject asObject, String field) {
            JsonValue jsonValue = asObject.get(field);
            ArrayList<JsonValue> bodyAsList = this.getBodyAsList(jsonValue);
            ArrayList<stmtType> lst = new ArrayList<stmtType>();
            for (JsonValue v : bodyAsList) {
                ISimpleNode bodyNode = this.createNode(v);
                this.addToStmtsList(bodyNode, lst);
            }
            return lst;
        }

        public List<exprType> extractExprs(JsonObject asObject, String field) {
            JsonValue jsonValue = asObject.get(field);
            ArrayList<JsonValue> bodyAsList = this.getBodyAsList(jsonValue);
            ArrayList<exprType> lst = new ArrayList<exprType>();
            for (JsonValue v : bodyAsList) {
                ISimpleNode bodyNode = this.createNode(v);
                this.addToExprsList(bodyNode, lst);
            }
            return lst;
        }

        private decoratorsType[] createDecorators(JsonObject asObject, SimpleNode defNode) throws Exception {
            ArrayList<decoratorsType> decs = new ArrayList<decoratorsType>();
            JsonValue jsonValue = asObject.get("decorators");
            if (jsonValue != null && jsonValue.isArray()) {
                for (JsonValue v : jsonValue.asArray()) {
                    decoratorsType dec = this.createDecorator(v);
                    if (dec == null) continue;
                    decs.add(dec);
                }
            }
            if (decs.size() == 0) {
                return null;
            }
            int maxDecLine = -1;
            for (decoratorsType dec : decs) {
                if (dec.beginLine <= maxDecLine) continue;
                maxDecLine = dec.beginLine;
            }
            if (defNode.beginLine <= maxDecLine) {
                defNode.beginLine = maxDecLine + 1;
                if (defNode instanceof FunctionDef) {
                    FunctionDef functionDef = (FunctionDef)defNode;
                    functionDef.name.beginLine = defNode.beginLine;
                } else if (defNode instanceof ClassDef) {
                    ClassDef classDef = (ClassDef)defNode;
                    classDef.name.beginLine = defNode.beginLine;
                }
            }
            return decs.toArray(new decoratorsType[0]);
        }

        private decoratorsType createDecorator(JsonValue v) throws Exception {
            JsonObject decAsObject;
            JsonValue decJsonValue;
            if (v != null && v.isObject() && (decJsonValue = (decAsObject = v.asObject()).get("decorator")) != null && decJsonValue.isObject()) {
                JsonObject asObject = decJsonValue.asObject();
                ISimpleNode func = this.createNode((JsonValue)asObject);
                decoratorsType decorator = this.astFactory.createEmptyDecoratorsType();
                if (func instanceof Call) {
                    Call call = (Call)func;
                    decorator.func = call.func;
                    decorator.args = call.args;
                    decorator.keywords = call.keywords;
                    decorator.starargs = call.starargs;
                    decorator.kwargs = call.kwargs;
                    decorator.isCall = true;
                    decorator.beginLine = call.beginLine;
                } else if (func instanceof exprType) {
                    decorator.func = (exprType)func;
                    decorator.beginLine = decorator.func.beginLine;
                } else if (func != null) {
                    GenCythonAstImpl.log("Don't know how to create decorator from: " + String.valueOf(func));
                }
                return decorator;
            }
            return null;
        }

        private argumentsType createArgs(JsonObject funcAsObject) {
            JsonValue kwArgValue;
            JsonValue starArgValue;
            argumentsType arguments = this.astFactory.createEmptyArgumentsType();
            JsonValue args = funcAsObject.get("args");
            if (args != null) {
                try {
                    ArrayList<Name> argsList = new ArrayList<Name>();
                    ArrayList<exprType> defaultsList = new ArrayList<exprType>();
                    ArrayList<exprType> annotationsList = new ArrayList<exprType>();
                    ArrayList<Name> kwOnlyArgsList = new ArrayList<Name>();
                    ArrayList<exprType> kwOnlyArgsDefaultsList = new ArrayList<exprType>();
                    ArrayList<exprType> kwOnlyArgsAnnotationsList = new ArrayList<exprType>();
                    for (JsonValue a : args.asArray()) {
                        String asString;
                        List<Name> names;
                        JsonObject asObject = a.asObject();
                        JsonValue declaratorValue = this.getDeclarator(asObject);
                        if (declaratorValue == null) continue;
                        Name nameNode = null;
                        JsonObject declaratorAsObj = declaratorValue.asObject();
                        JsonValue nameValue = declaratorAsObj.get("name");
                        if (nameValue != null && !nameValue.asString().isEmpty()) {
                            nameNode = this.createName(declaratorAsObj);
                        }
                        if (nameNode == null) {
                            nameNode = this.createNameFromBaseType(asObject);
                        }
                        if (nameNode == null && (names = this.createNamesListFromTupleBaseType(asObject.get("base_type"))) != null && names.size() > 0) {
                            for (Name n : names) {
                                this.ctx.setParam((SimpleNode)n);
                                argsList.add(n);
                                defaultsList.add(null);
                                annotationsList.add(null);
                            }
                            continue;
                        }
                        if (nameNode == null) {
                            GenCythonAstImpl.log("Unable to get arg name in: " + asObject.toPrettyString());
                            continue;
                        }
                        this.setLine((SimpleNode)nameNode, asObject);
                        boolean isKwOnly = false;
                        JsonValue kwOnlyValue = asObject.get("kw_only");
                        if (kwOnlyValue != null && kwOnlyValue.isString() && ("1".equals(asString = kwOnlyValue.asString()) || "True".equals(asString))) {
                            isKwOnly = true;
                        }
                        if (isKwOnly) {
                            this.ctx.setKwOnlyParam((SimpleNode)nameNode);
                            kwOnlyArgsList.add(nameNode);
                            kwOnlyArgsDefaultsList.add((exprType)this.createNode(asObject.get("default")));
                            kwOnlyArgsAnnotationsList.add((exprType)this.createNode(asObject.get("annotation")));
                            continue;
                        }
                        this.ctx.setParam((SimpleNode)nameNode);
                        argsList.add(nameNode);
                        defaultsList.add((exprType)this.createNode(asObject.get("default")));
                        annotationsList.add((exprType)this.createNode(asObject.get("annotation")));
                    }
                    arguments.kwonlyargs = kwOnlyArgsList.toArray(PyAstFactory.EMPTY_EXPR_TYPE);
                    arguments.kwonlyargannotation = kwOnlyArgsAnnotationsList.toArray(PyAstFactory.EMPTY_EXPR_TYPE);
                    arguments.kw_defaults = kwOnlyArgsDefaultsList.toArray(PyAstFactory.EMPTY_EXPR_TYPE);
                    arguments.args = argsList.toArray(PyAstFactory.EMPTY_EXPR_TYPE);
                    arguments.defaults = defaultsList.toArray(PyAstFactory.EMPTY_EXPR_TYPE);
                    arguments.annotation = annotationsList.toArray(PyAstFactory.EMPTY_EXPR_TYPE);
                }
                catch (Exception e) {
                    GenCythonAstImpl.log(e);
                }
            }
            if ((starArgValue = funcAsObject.get("star_arg")) != null && starArgValue.isObject()) {
                arguments.vararg = this.createNameTok(starArgValue.asObject(), 5);
            }
            if ((kwArgValue = funcAsObject.get("starstar_arg")) != null && kwArgValue.isObject()) {
                arguments.kwarg = this.createNameTok(kwArgValue.asObject(), 6);
            }
            return arguments;
        }

        private List<Name> createNamesListFromTupleBaseType(JsonValue jsonValueBaseType) {
            JsonValue components;
            JsonObject asObject;
            JsonValue node;
            ArrayList<Name> names = new ArrayList<Name>();
            if (jsonValueBaseType != null && jsonValueBaseType.isObject() && (node = (asObject = jsonValueBaseType.asObject()).get("__node__")) != null && node.isString() && node.asString().equals("CTupleBaseType") && (components = asObject.get("components")) != null && components.isArray()) {
                JsonArray asArray = components.asArray();
                for (JsonValue jsonValue : asArray) {
                    Name name;
                    if (!jsonValue.isObject() || (name = this.createNameFromBaseType(jsonValue.asObject())) == null) continue;
                    names.add(name);
                }
            }
            return names;
        }

        private Name createNameFromBaseType(JsonObject asObject) {
            JsonValue jsonValue;
            Name nameNode = null;
            JsonValue baseType = asObject.get("base_type");
            if (baseType != null && baseType.isObject()) {
                nameNode = this.createName(baseType.asObject());
                if (nameNode == null && (baseTypeNode = baseType.asObject().get("base_type_node")) != null && baseTypeNode.isObject()) {
                    nameNode = this.createName(baseTypeNode.asObject());
                }
            } else {
                baseTypeNode = asObject.get("base_type_node");
                if (baseTypeNode != null && baseTypeNode.isObject()) {
                    nameNode = this.createName(baseTypeNode.asObject());
                }
            }
            if (nameNode == null && baseType.isObject() && (jsonValue = baseType.asObject().get("base_type")) != null && jsonValue.isObject()) {
                return this.createNameFromBaseType(baseType.asObject());
            }
            return nameNode;
        }

        private ArrayList<JsonValue> getBodyAsList(JsonValue jsonValue) {
            ArrayList<JsonValue> lst = new ArrayList<JsonValue>();
            if (jsonValue == null) {
                return lst;
            }
            if (jsonValue.isArray()) {
                for (JsonValue v : jsonValue.asArray()) {
                    lst.add(v);
                }
                return lst;
            }
            if (jsonValue.isString() && jsonValue.asString().equals("None")) {
                return lst;
            }
            JsonObject asObject = jsonValue.asObject();
            JsonValue nodeType = asObject.get("__node__");
            if (nodeType != null) {
                if ("StatList".equals(nodeType.asString())) {
                    JsonValue stats = asObject.get("stats");
                    JsonArray asArray = stats.asArray();
                    for (JsonValue v : asArray) {
                        lst.add(v);
                    }
                } else {
                    lst.add(jsonValue);
                }
            }
            return lst;
        }

        private SimpleNode createForFromStat(JsonObject asObject) throws Exception {
            JsonValue jsonElse;
            exprType target = null;
            exprType iter = null;
            stmtType[] body = null;
            suiteType orelse = null;
            JsonValue jsonTarget = asObject.get("target");
            if (jsonTarget != null) {
                target = this.asExpr(this.createNode(jsonTarget));
                this.ctx.setStore((SimpleNode)target);
            }
            if ((jsonElse = asObject.get("else_clause")) != null && jsonElse.isObject()) {
                orelse = this.createSuite(jsonElse.asObject());
            }
            body = this.extractStmts(asObject, "body").toArray(PyAstFactory.EMPTY_STMT_TYPE);
            For node = new For(target, iter, body, orelse, false);
            this.setLine((SimpleNode)node, asObject);
            return node;
        }

        private SimpleNode createFor(JsonObject asObject) throws Exception {
            JsonValue jsonElse;
            JsonValue jsonIter;
            exprType target = null;
            exprType iter = null;
            stmtType[] body = null;
            suiteType orelse = null;
            JsonValue isAsyncNode = asObject.get("is_async");
            boolean async = isAsyncNode != null && "True".equals(isAsyncNode.asString());
            JsonValue jsonTarget = asObject.get("target");
            if (jsonTarget != null) {
                target = this.asExpr(this.createNode(jsonTarget));
                this.ctx.setStore((SimpleNode)target);
            }
            if ((jsonIter = asObject.get("iterator")) != null) {
                JsonValue jsonValue = jsonIter.asObject().get("sequence");
                iter = this.asExpr(this.createNode(jsonValue));
            }
            if ((jsonElse = asObject.get("else_clause")) != null && jsonElse.isObject()) {
                orelse = this.createSuite(jsonElse.asObject());
            }
            body = this.extractStmts(asObject, "body").toArray(PyAstFactory.EMPTY_STMT_TYPE);
            For node = new For(target, iter, body, orelse, async);
            this.setLine((SimpleNode)node, asObject);
            return node;
        }

        private suiteType createSuite(JsonObject asObject) {
            JsonValue jsonNode = asObject.get("__node__");
            Suite suite = null;
            if (jsonNode != null && jsonNode.asString().equals("StatList")) {
                List<stmtType> extract = this.extractStmts(asObject, "stats");
                suite = new Suite(this.astFactory.createStmtArray(extract.toArray()));
                this.setLine((SimpleNode)suite, asObject);
            } else {
                ISimpleNode node = this.createNode((JsonValue)asObject);
                if (node != null) {
                    ArrayList<stmtType> lst = new ArrayList<stmtType>();
                    this.addToStmtsList(node, lst);
                    suite = new Suite(lst.toArray(PyAstFactory.EMPTY_STMT_TYPE));
                }
            }
            return suite;
        }

        private SimpleNode createCascadedAssignment(JsonObject asObject) throws Exception {
            Assign node = null;
            JsonValue lhsList = asObject.get("lhs_list");
            JsonValue rhs = asObject.get("rhs");
            if (lhsList != null && lhsList.isArray() && rhs != null && rhs.isObject()) {
                JsonArray asArray = lhsList.asArray();
                ArrayList<exprType> targets = new ArrayList<exprType>(asArray.size());
                for (JsonValue lhs : asArray) {
                    ISimpleNode left = this.createNode(lhs);
                    this.ctx.setStore((SimpleNode)left);
                    targets.add(this.asExpr(left));
                }
                ISimpleNode right = this.createNode(rhs);
                node = new Assign(targets.toArray(PyAstFactory.EMPTY_EXPR_TYPE), this.asExpr(right), null);
                this.setLine((SimpleNode)node, asObject);
            }
            return node;
        }

        private SimpleNode createSingleAssignment(JsonObject asObject) throws Exception {
            Import node = null;
            JsonValue lhs = asObject.get("lhs");
            JsonValue rhs = asObject.get("rhs");
            if (lhs != null && lhs.isObject() && rhs != null && rhs.isObject()) {
                ISimpleNode left = this.createNode(lhs);
                this.ctx.setStore((SimpleNode)left);
                ISimpleNode right = this.createNode(rhs);
                if (right instanceof Import) {
                    node = (Import)right;
                    this.setLine((SimpleNode)node, asObject);
                    if (left instanceof Name) {
                        Name leftName = (Name)left;
                        Import importNode = (Import)right;
                        aliasType[] names = importNode.names;
                        aliasType aliasType2 = names[0];
                        if (aliasType2.asname == null) {
                            if (!(leftName == null || leftName.id == null || ((NameTok)aliasType2.name).id != null && leftName.id.equals(((NameTok)aliasType2.name).id))) {
                                aliasType2.asname = new NameTok(leftName.id, 4);
                                aliasType2.asname.beginColumn = leftName.beginColumn;
                                aliasType2.asname.beginLine = leftName.beginLine;
                            }
                        } else {
                            aliasType2.asname = new NameTok(leftName.id, 4);
                            aliasType2.asname.beginColumn = leftName.beginColumn;
                            aliasType2.asname.beginLine = leftName.beginLine;
                        }
                    }
                } else {
                    node = this.astFactory.createAssign(new exprType[]{this.asExpr(left), this.asExpr(right)});
                    this.setLine((SimpleNode)node, asObject);
                }
            }
            return node;
        }

        private JsonValue getDeclarator(JsonObject asObject) {
            JsonValue jsonValue = asObject.get("declarator");
            if (jsonValue.isObject()) {
                return this.getRemovingPtrDeclarator(jsonValue.asObject());
            }
            return jsonValue;
        }

        private JsonValue getRemovingPtrDeclarator(JsonObject asObject) {
            JsonValue base;
            JsonValue jsonValue2 = asObject.get("__node__");
            if (jsonValue2.isString() && "CPtrDeclarator".equals(jsonValue2.asString()) && (base = asObject.get("base")) != null && base.isObject()) {
                return this.getRemovingPtrDeclarator(base.asObject());
            }
            return asObject;
        }

        private ISimpleNode createCDefExtern(JsonObject asObject) throws Exception {
            NodeList nodeList = new NodeList();
            List<stmtType> extractStmts = this.extractStmts(asObject, "body");
            for (stmtType stmtType2 : extractStmts) {
                nodeList.nodes.add((ISimpleNode)stmtType2);
            }
            return nodeList;
        }

        private ISimpleNode createCVarDef(JsonObject asObject) throws Exception {
            NodeList nodeList = new NodeList();
            JsonValue declarators = asObject.get("declarators");
            if (declarators != null && declarators.isArray()) {
                for (JsonValue d : declarators.asArray()) {
                    JsonValue declaratorWithoutPtr = this.getRemovingPtrDeclarator(d.asObject());
                    if (!declaratorWithoutPtr.isObject()) continue;
                    JsonObject declaratorAsObject = declaratorWithoutPtr.asObject();
                    JsonValue nodeValue = declaratorAsObject.get("__node__");
                    if (nodeValue != null && nodeValue.isString() && nodeValue.asString().equals("CFuncDeclarator")) {
                        nodeList.nodes.add(this.createNode((JsonValue)declaratorAsObject));
                        continue;
                    }
                    Name left = this.createName(declaratorAsObject.asObject());
                    Name right = null;
                    if (left != null) {
                        JsonValue defaultJsonValue = declaratorAsObject.get("default");
                        if (defaultJsonValue == null || defaultJsonValue.isString() && defaultJsonValue.asString().equals("None")) {
                            right = this.astFactory.createNone();
                            this.setLine((SimpleNode)right, declaratorAsObject);
                        } else {
                            right = this.asExpr(this.createNode(defaultJsonValue));
                        }
                        this.ctx.setStore((SimpleNode)left);
                        if (right == null) {
                            right = this.astFactory.createNone();
                            this.setLine((SimpleNode)right, declaratorAsObject);
                        }
                        Assign node = this.astFactory.createAssign(new exprType[]{left, right});
                        this.setLine((SimpleNode)node, declaratorAsObject);
                        nodeList.nodes.add((ISimpleNode)node);
                        continue;
                    }
                    return null;
                }
            }
            return nodeList;
        }

        private With createGILStat(JsonObject asObject) {
            Name nogil = this.astFactory.createName("nogil");
            this.setLine((SimpleNode)nogil, asObject);
            stmtType[] body = this.extractStmts(asObject, "body").toArray(PyAstFactory.EMPTY_STMT_TYPE);
            Suite bodySuite = new Suite(body);
            this.setLine((SimpleNode)bodySuite, asObject);
            WithItem[] withItem = new WithItem[]{new WithItem((exprType)nogil, null)};
            this.setLine((SimpleNode)withItem[0], asObject);
            boolean async = false;
            With node = new With((WithItemType[])withItem, (suiteType)bodySuite, async);
            this.setLine((SimpleNode)node, asObject);
            return node;
        }

        private With createWith(JsonObject asObject) {
            exprType test = this.asExpr(this.createNode(asObject.get("manager")));
            exprType target = this.asExpr(this.createNode(asObject.get("target")));
            try {
                this.ctx.setStore((SimpleNode)target);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stmtType[] body = this.extractStmts(asObject, "body").toArray(PyAstFactory.EMPTY_STMT_TYPE);
            Suite bodySuite = new Suite(body);
            this.setLine((SimpleNode)bodySuite, asObject);
            WithItem[] withItem = new WithItem[]{new WithItem(test, target)};
            this.setLine((SimpleNode)withItem[0], asObject);
            boolean async = false;
            With node = new With((WithItemType[])withItem, (suiteType)bodySuite, async);
            this.setLine((SimpleNode)node, asObject);
            return node;
        }

        private While createWhile(JsonObject asObject) {
            exprType test = this.asExpr(this.createNode(asObject.get("condition")));
            stmtType[] body = this.extractStmts(asObject, "body").toArray(PyAstFactory.EMPTY_STMT_TYPE);
            Suite orelse = null;
            List<stmtType> extractStmts = this.extractStmts(asObject, "else_clause");
            if (extractStmts.size() > 0) {
                orelse = new Suite(extractStmts.toArray(PyAstFactory.EMPTY_STMT_TYPE));
            }
            While whileStmt = new While(test, body, orelse);
            this.setLine((SimpleNode)whileStmt, asObject);
            return whileStmt;
        }

        private Assert createAssert(JsonObject asObject) {
            JsonValue condition = asObject.get("cond");
            if (condition == null) {
                condition = asObject.get("condition");
            }
            exprType cond = this.asExpr(this.createNode(condition));
            exprType value = this.asExpr(this.createNode(asObject.get("value")));
            Assert assertStmt = new Assert(cond, value);
            this.setLine((SimpleNode)assertStmt, asObject);
            return assertStmt;
        }

        private Return createReturn(JsonObject asObject) {
            exprType value = this.asExpr(this.createNode(asObject.get("value")));
            Return returnStmt = new Return(value);
            this.setLine((SimpleNode)returnStmt, asObject);
            return returnStmt;
        }

        private IfExp createCondExpr(JsonObject asObject) {
            exprType test = this.asExpr(this.createNode(asObject.get("test")));
            exprType body = this.asExpr(this.createNode(asObject.get("true_val")));
            exprType orelse = this.asExpr(this.createNode(asObject.get("false_val")));
            IfExp ifNode = new IfExp(test, body, orelse);
            this.setLine((SimpleNode)ifNode, asObject);
            return ifNode;
        }

        private If createIf(JsonObject asObject) {
            JsonValue ifClauses = asObject.get("if_clauses");
            If ifNode = null;
            If lastIfNode = null;
            if (ifClauses != null && ifClauses.isArray()) {
                JsonValue jsonValue;
                for (JsonValue v : ifClauses.asArray()) {
                    JsonObject ifValueAsObject = v.asObject();
                    JsonValue conditionNodeValue = ifValueAsObject.get("condition");
                    if (conditionNodeValue == null) continue;
                    ISimpleNode conditionNode = this.createNode(conditionNodeValue);
                    suiteType orelse = null;
                    stmtType[] body = null;
                    If ifNodeTemp = new If(this.asExpr(conditionNode), body, orelse);
                    this.astFactory.setBody(ifNodeTemp, this.extractStmts(ifValueAsObject, "body").toArray());
                    this.setLine((SimpleNode)ifNodeTemp, ifValueAsObject);
                    if (ifNode == null) {
                        ifNode = ifNodeTemp;
                    } else if (lastIfNode != null) {
                        lastIfNode.orelse = new Suite(new stmtType[]{ifNodeTemp});
                    }
                    lastIfNode = ifNodeTemp;
                }
                if (lastIfNode != null && (jsonValue = asObject.get("else_clause")) != null && jsonValue.isObject()) {
                    ISimpleNode elseClause = this.createNode(jsonValue);
                    ArrayList<stmtType> elseStmts = new ArrayList<stmtType>();
                    this.addToStmtsList(elseClause, elseStmts);
                    lastIfNode.orelse = new Suite(elseStmts.toArray(PyAstFactory.EMPTY_STMT_TYPE));
                }
            }
            return ifNode;
        }

        private Name createNone(JsonObject asObject) {
            Name node = this.astFactory.createNone();
            this.setLine((SimpleNode)node, asObject);
            return node;
        }

        private SimpleNode createBool(JsonObject asObject) {
            JsonValue value = asObject.get("value");
            if (value != null && value.isString()) {
                Name node = this.astFactory.createName(value.asString());
                node.reserved = true;
                this.setLine((SimpleNode)node, asObject);
                return node;
            }
            GenCythonAstImpl.log("Unable to create bool with info: " + String.valueOf(asObject));
            return null;
        }

        private NameTok createNameTok(JsonObject asObject, int ctx) {
            NameTok node = null;
            JsonValue value = asObject.get("name");
            if (value != null) {
                node = new NameTok(value.asString(), ctx);
                this.setLine((SimpleNode)node, asObject);
            } else {
                JsonValue nodeValue = asObject.get("__node__");
                if (nodeValue.isString() && "IdentifierString".equals(nodeValue.asString()) && (value = asObject.get("value")) != null) {
                    node = new NameTok(value.asString(), ctx);
                    this.setLine((SimpleNode)node, asObject);
                }
            }
            return node;
        }

        private Attribute createAttribute(JsonObject asObject) {
            JsonValue attribute = asObject.get("attribute");
            if (attribute.isString()) {
                String attr = attribute.asString();
                JsonValue obj = asObject.get("obj");
                if (obj.isObject()) {
                    ISimpleNode objNode = this.createNode((JsonValue)obj.asObject());
                    NameTok attribName = new NameTok(attr, 8);
                    this.setLine((SimpleNode)attribName, asObject);
                    ++attribName.beginColumn;
                    Attribute attributeNode = new Attribute(this.asExpr(objNode), (NameTokType)attribName, 1);
                    this.setLine((SimpleNode)attributeNode, asObject);
                    return attributeNode;
                }
            }
            return null;
        }

        private NodeList createStatList(JsonObject asObject) {
            JsonValue stats = asObject.get("stats");
            if (stats != null && stats.isArray()) {
                JsonArray asArray = stats.asArray();
                NodeList nodeList = new NodeList();
                for (JsonValue v : asArray) {
                    ISimpleNode n = this.createNode(v);
                    nodeList.nodes.add(n);
                }
                return nodeList;
            }
            return null;
        }

        private Name createName(JsonObject asObject) {
            Name node = null;
            JsonValue value = asObject.get("name");
            if (value != null) {
                node = this.astFactory.createName(value.asString());
                this.setLine((SimpleNode)node, asObject);
            }
            return node;
        }

        private Name createIdentifierString(JsonObject asObject) {
            Name node = null;
            JsonValue value = asObject.get("value");
            if (value != null) {
                node = this.astFactory.createName(value.asString());
                this.setLine((SimpleNode)node, asObject);
            }
            return node;
        }

        private ISimpleNode createAmpersand(JsonObject asObject) {
            ISimpleNode node = null;
            JsonValue value = asObject.get("operand");
            if (value != null && value.isObject()) {
                return this.createNode((JsonValue)value.asObject());
            }
            return node;
        }

        private Yield createYieldFromExpr(JsonObject asObject) throws Exception {
            Yield yield = this.createYieldExpr(asObject);
            yield.yield_from = true;
            return yield;
        }

        private Yield createYieldExpr(JsonObject asObject) throws Exception {
            Yield node = null;
            JsonValue value = asObject.get("arg");
            if (value != null) {
                node = new Yield(this.asExpr(this.createNode(value)), false);
                this.setLine((SimpleNode)node, asObject);
            }
            return node;
        }

        private SimpleNode createInt(JsonObject asObject) {
            JsonValue value = asObject.get("value");
            if (value != null) {
                Num node;
                String asString = value.asString();
                try {
                    node = new Num((Object)new BigInteger(asString), 1, asString);
                }
                catch (Exception e) {
                    node = new Num((Object)asString, 1, asString);
                }
                this.setLine((SimpleNode)node, asObject);
                return node;
            }
            return null;
        }

        private ISimpleNode createImag(JsonObject asObject) {
            JsonValue value = asObject.get("value");
            if (value != null) {
                Num node;
                String asString = value.asString();
                try {
                    node = new Num((Object)Double.valueOf(asString), 6, asString);
                }
                catch (NumberFormatException e) {
                    node = new Num((Object)asString, 6, asString);
                }
                this.setLine((SimpleNode)node, asObject);
                return node;
            }
            return null;
        }

        private SimpleNode createFloat(JsonObject asObject) {
            JsonValue value = asObject.get("value");
            if (value != null) {
                Num node;
                String asString = value.asString();
                try {
                    node = new Num((Object)Double.valueOf(asString), 3, asString);
                }
                catch (NumberFormatException e) {
                    node = new Num((Object)asString, 3, asString);
                }
                this.setLine((SimpleNode)node, asObject);
                return node;
            }
            return null;
        }

        private void setLine(SimpleNode node, JsonObject asObject) {
            if (node != null) {
                JsonValue col;
                JsonValue line;
                JsonValue baseType = asObject.get("base_type");
                if (baseType != null && baseType.isObject() && baseType.asObject().get("col") != null) {
                    asObject = baseType.asObject();
                }
                if ((line = asObject.get("line")) != null) {
                    node.beginLine = line.asInt();
                }
                if ((col = asObject.get("col")) != null) {
                    node.beginColumn = col.asInt() + 1;
                }
            }
        }

        public ISimpleNode createModule() {
            return this.astFactory.createModule(this.stmts);
        }

        private static class CascadeNode
        implements ISimpleNode {
            public final String operator;
            public final ISimpleNode operand;
            public final CascadeNode cascade;

            public CascadeNode(String operator, ISimpleNode operand, CascadeNode cascade) {
                this.operator = operator;
                this.operand = operand;
                this.cascade = cascade;
            }
        }

        private static class MergedDict
        implements ISimpleNode {
            public List<ISimpleNode> nodes = new ArrayList<ISimpleNode>();

            private MergedDict() {
            }
        }

        private static class NodeList
        implements ISimpleNode {
            public List<ISimpleNode> nodes = new ArrayList<ISimpleNode>();

            private NodeList() {
            }
        }
    }

    public static class StopOnLogException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StopOnLogException(String s) {
            super(s);
        }

        public StopOnLogException(Exception e) {
            super(e);
        }

        public StopOnLogException(String s, Exception e) {
            super(s, e);
        }
    }
}

