/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.interpreter_managers;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Compare;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.jython.ast.factory.PyAstFactory;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.jython.ast.suiteType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.utils.PlatformUtils;

public class TypeshedLoader {
    public static void fillTypeshedFromDirInfo(Map<String, File> typeshedCache, File f, String basename) {
        Path path = Paths.get(f.toURI());
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (DirectoryStream<Path> newDirectoryStream = Files.newDirectoryStream(path);){
                for (Path path2 : newDirectoryStream) {
                    File file2 = path2.toFile();
                    String fName = file2.getName();
                    if (file2.isDirectory()) {
                        String dirname = fName;
                        if (dirname.contains("@")) continue;
                        TypeshedLoader.fillTypeshedFromDirInfo(typeshedCache, file2, basename.isEmpty() ? dirname + "." : basename + dirname + ".");
                        continue;
                    }
                    if (!fName.endsWith(".pyi")) continue;
                    String modName = fName.substring(0, fName.length() - ".pyi".length());
                    typeshedCache.put(basename + modName, file2);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Log.log((Throwable)e);
        }
    }

    public static void fixTypingAST(SimpleNode ast, ISystemModulesManager systemModulesManager, InterpreterInfo interpreterInfo) {
        if (!(ast instanceof Module)) {
            Log.logInfo((String)("Expected Module. Found: " + String.valueOf(ast.getClass())));
            return;
        }
        TypeshedLoader.fixAST(ast, systemModulesManager, interpreterInfo);
        PyAstFactory astFactory = new PyAstFactory(new AdapterPrefs("\n", (IGrammarVersionProvider)systemModulesManager.getNature()));
        stmtType[] body = NodeUtils.getBody((SimpleNode)ast);
        LinkedList<stmtType> bodyAsList = new LinkedList<stmtType>(Arrays.asList(body));
        bodyAsList.add(0, (stmtType)new Import(new aliasType[]{new aliasType((NameTokType)new NameTok("collections", 4), null)}));
        for (stmtType next : bodyAsList) {
            try {
                String targetRep;
                if (!(next instanceof Assign)) continue;
                Assign assign = (Assign)next;
                if (assign.value == null || !(assign.value instanceof Call)) continue;
                Call call = (Call)assign.value;
                String rep = NodeUtils.getRepresentationString((ISimpleNode)call.func);
                if (!"_Alias".equals(rep) || assign.targets == null || assign.targets.length <= 0) continue;
                exprType exprType2 = assign.targets[0];
                Name name = null;
                Attribute attr = null;
                switch (targetRep = NodeUtils.getRepresentationString((ISimpleNode)exprType2)) {
                    case "Dict": {
                        assign.value = astFactory.createName("dict");
                        name = assign.value;
                        break;
                    }
                    case "Set": {
                        assign.value = astFactory.createName("set");
                        name = assign.value;
                        break;
                    }
                    case "List": {
                        assign.value = astFactory.createName("list");
                        name = assign.value;
                        break;
                    }
                    case "DefaultDict": {
                        attr = astFactory.createAttribute("collections.defaultdict");
                        assign.value = attr;
                    }
                }
                if (name != null) {
                    name.beginColumn = call.func.beginColumn;
                    name.beginLine = call.func.beginLine;
                }
                if (attr == null) continue;
                Name attrName = (Name)attr.value;
                attrName.beginColumn = call.func.beginColumn;
                attrName.beginLine = call.func.beginLine;
                attr.beginColumn = call.func.beginColumn;
                attr.beginLine = call.func.beginLine;
                attr.attr.beginColumn = attrName.beginColumn + attrName.id.length() + 1;
                attr.attr.beginLine = call.func.beginLine;
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        NodeUtils.setBody((SimpleNode)ast, (stmtType[])bodyAsList.toArray(PyAstFactory.EMPTY_STMT_TYPE));
    }

    public static void fixBuiltinsAST(SimpleNode ast, ISystemModulesManager systemModulesManager, InterpreterInfo interpreterInfo) {
        if (!(ast instanceof Module)) {
            Log.logInfo((String)("Expected Module. Found: " + String.valueOf(ast.getClass())));
            return;
        }
        TypeshedLoader.fixAST(ast, systemModulesManager, interpreterInfo);
        PyAstFactory astFactory = new PyAstFactory(new AdapterPrefs("\n", (IGrammarVersionProvider)systemModulesManager.getNature()));
        stmtType[] body = NodeUtils.getBody((SimpleNode)ast);
        LinkedList<stmtType> bodyAsList = new LinkedList<stmtType>(Arrays.asList(body));
        Iterator it = bodyAsList.iterator();
        block2: while (it.hasNext()) {
            stmtType next = (stmtType)it.next();
            try {
                if (!(next instanceof ClassDef)) continue;
                ClassDef classDef = (ClassDef)next;
                if (classDef.decs == null || classDef.decs.length <= 0) continue;
                int i = 0;
                while (i < classDef.decs.length) {
                    String rep;
                    decoratorsType dec = classDef.decs[i];
                    if (dec.func != null && "type_check_only".equals(rep = NodeUtils.getRepresentationString((ISimpleNode)dec.func))) {
                        it.remove();
                        continue block2;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        bodyAsList.add((stmtType)astFactory.createAssign(new exprType[]{astFactory.createStoreName("None"), astFactory.createNone()}));
        bodyAsList.add((stmtType)astFactory.createAssign(new exprType[]{astFactory.createStoreName("False"), astFactory.createFalse()}));
        bodyAsList.add((stmtType)astFactory.createAssign(new exprType[]{astFactory.createStoreName("True"), astFactory.createTrue()}));
        bodyAsList.add((stmtType)astFactory.createAssign(new exprType[]{astFactory.createStoreName("__builtins__"), astFactory.createName("Any")}));
        NodeUtils.setBody((SimpleNode)ast, (stmtType[])bodyAsList.toArray(PyAstFactory.EMPTY_STMT_TYPE));
    }

    public static void fixAST(SimpleNode ast, ISystemModulesManager systemModulesManager, InterpreterInfo interpreterInfo) {
        stmtType[] body = NodeUtils.getBody((SimpleNode)ast);
        FastStringBuffer buf = new FastStringBuffer();
        Object version = interpreterInfo.getVersion();
        version = (String)version + ".99";
        Runtime.Version interpreterVersion = Runtime.Version.parse((String)version);
        if (body == null || body.length == 0) {
            return;
        }
        TypeshedLoader.fixBody(ast, body, interpreterVersion, buf);
    }

    private static void fixBody(SimpleNode ast, stmtType[] body, Runtime.Version interpreterVersion, FastStringBuffer buf) {
        LinkedList<stmtType> bodyAsList = new LinkedList<stmtType>(Arrays.asList(body));
        ListIterator<stmtType> it = bodyAsList.listIterator();
        boolean changed = false;
        while (it.hasNext()) {
            stmtType next = (stmtType)it.next();
            if (next == null) continue;
            try {
                exprType exprType2;
                stmtType[] body2;
                if (next instanceof ClassDef) {
                    ClassDef classDef = (ClassDef)next;
                    NameTok name = (NameTok)classDef.name;
                    if (name != null && "_SpecialForm".equals(name.id)) {
                        classDef.body = PyAstFactory.EMPTY_STMT_TYPE;
                        break;
                    }
                }
                if ((body2 = NodeUtils.getBody((SimpleNode)next)) != null && body2.length > 0) {
                    TypeshedLoader.fixBody((SimpleNode)next, body2, interpreterVersion, buf);
                }
                if (!(next instanceof If)) continue;
                If ifStmt = (If)next;
                if (!(ifStmt.test instanceof Compare)) continue;
                Compare compare = (Compare)ifStmt.test;
                if (!(compare.left instanceof Attribute)) continue;
                String fullRepresentationString = NodeUtils.getFullRepresentationString((SimpleNode)compare.left);
                if ("sys.version_info".equals(fullRepresentationString)) {
                    if (compare.ops == null || compare.ops.length != 1 || compare.comparators == null || compare.comparators.length != 1 || !((exprType2 = compare.comparators[0]) instanceof Tuple)) continue;
                    Tuple tuple = (Tuple)exprType2;
                    if (tuple.elts == null) continue;
                    buf.clear();
                    Object object = tuple.elts;
                    int n = tuple.elts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        exprType e = object[n2];
                        if (e instanceof Num) {
                            Num num = (Num)e;
                            if (!buf.isEmpty()) {
                                buf.append('.');
                            }
                            buf.append(num.num);
                        }
                        ++n2;
                    }
                    boolean remove = false;
                    Runtime.Version checkedVersion = Runtime.Version.parse(buf.toString());
                    int op = compare.ops[0];
                    switch (op) {
                        case 1: {
                            remove = true;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 5: 
                        case 6: {
                            if (interpreterVersion.compareTo(checkedVersion) >= 0) break;
                            remove = true;
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (interpreterVersion.compareTo(checkedVersion) < 0) break;
                            remove = true;
                        }
                    }
                    changed = TypeshedLoader.updateIfStatement(it, changed, ifStmt, remove);
                    continue;
                }
                if (!"sys.platform".equals(fullRepresentationString) || compare.ops == null || compare.ops.length != 1 || compare.comparators == null || compare.comparators.length != 1 || !((exprType2 = compare.comparators[0]) instanceof Str)) continue;
                Str str = (Str)exprType2;
                String expectedPlatform = str.s;
                if (expectedPlatform == null) continue;
                int op = compare.ops[0];
                boolean remove = false;
                switch (expectedPlatform) {
                    case "win32": {
                        switch (op) {
                            case 1: {
                                remove = !PlatformUtils.isWindowsPlatform();
                                break;
                            }
                            case 2: {
                                remove = PlatformUtils.isWindowsPlatform();
                            }
                        }
                        changed = TypeshedLoader.updateIfStatement(it, changed, ifStmt, remove);
                        break;
                    }
                    case "linux2": 
                    case "linux": {
                        switch (op) {
                            case 1: {
                                remove = !PlatformUtils.isLinuxPlatform();
                                break;
                            }
                            case 2: {
                                remove = PlatformUtils.isLinuxPlatform();
                            }
                        }
                        changed = TypeshedLoader.updateIfStatement(it, changed, ifStmt, remove);
                        break;
                    }
                    case "darwin": {
                        switch (op) {
                            case 1: {
                                remove = !PlatformUtils.isMacOsPlatform();
                                break;
                            }
                            case 2: {
                                remove = PlatformUtils.isMacOsPlatform();
                            }
                        }
                        changed = TypeshedLoader.updateIfStatement(it, changed, ifStmt, remove);
                    }
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        if (changed) {
            NodeUtils.setBody((SimpleNode)ast, (stmtType[])bodyAsList.toArray(PyAstFactory.EMPTY_STMT_TYPE));
        }
    }

    private static boolean updateIfStatement(ListIterator<stmtType> it, boolean changed, If ifStmt, boolean remove) {
        if (remove) {
            stmtType[] orelseBody;
            changed = true;
            it.remove();
            suiteType orelse = ifStmt.orelse;
            if (orelse != null && (orelseBody = orelse.body) != null && orelseBody.length > 0) {
                stmtType[] stmtTypeArray = orelseBody;
                int n = orelseBody.length;
                int n2 = 0;
                while (n2 < n) {
                    stmtType s = stmtTypeArray[n2];
                    if (s.specialsBefore != null) {
                        s.specialsBefore.clear();
                    }
                    it.add(s);
                    ++n2;
                }
                stmtTypeArray = orelseBody;
                n = orelseBody.length;
                n2 = 0;
                while (n2 < n) {
                    stmtType _s = stmtTypeArray[n2];
                    it.previous();
                    ++n2;
                }
            }
        } else {
            suiteType orelse = ifStmt.orelse;
            if (orelse != null && orelse.body != null && orelse.body.length > 0) {
                changed = true;
                ifStmt.orelse = null;
            }
        }
        return changed;
    }
}

