/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.refactoring;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.ast.refactoring.IPyRefactoringRequest;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.core.log.Log;

public class PyRefactoringRequest
implements IPyRefactoringRequest {
    protected final List<RefactoringRequest> requests;
    protected String inputName;
    private final Stack<IProgressMonitor> monitors = new Stack();

    public PyRefactoringRequest(RefactoringRequest ... request) {
        this.requests = Arrays.asList(request);
    }

    @Override
    public List<RefactoringRequest> getRequests() {
        return this.requests;
    }

    @Override
    public void fillActivationTokenAndQualifier() {
        for (RefactoringRequest r : this.requests) {
            r.fillActivationTokenAndQualifier();
        }
    }

    @Override
    public void setInputName(String text) {
        this.inputName = text;
        for (RefactoringRequest r : this.requests) {
            r.inputName = text;
        }
    }

    @Override
    public void setUpdateReferences(boolean selection) {
        for (RefactoringRequest r : this.requests) {
            r.setUpdateReferences(selection);
        }
    }

    @Override
    public IFile getIFileResource() {
        IFile f = null;
        for (RefactoringRequest r : this.requests) {
            if (f == null) {
                f = r.getIFileResource();
                continue;
            }
            IFile f2 = r.getIFileResource();
            if (f.equals((Object)f2)) continue;
            return null;
        }
        return f;
    }

    @Override
    public void setSimpleResourceRename(boolean simpleResourceRename) {
        for (RefactoringRequest r : this.requests) {
            r.setSimpleResourceRename(simpleResourceRename);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getSimpleResourceRename() {
        try {
            Boolean b = null;
            Iterator<RefactoringRequest> iterator = this.requests.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    if (b != null) return b;
                    return false;
                }
                RefactoringRequest r = iterator.next();
                if (b == null) {
                    b = r.getSimpleResourceRename();
                    continue;
                }
                if (b.booleanValue() != r.getSimpleResourceRename()) return false;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return false;
        }
    }

    @Override
    public void pushMonitor(IProgressMonitor pm) {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        this.monitors.push(pm);
        for (RefactoringRequest r : this.requests) {
            r.pushMonitor(pm);
        }
    }

    @Override
    public IProgressMonitor popMonitor() {
        for (RefactoringRequest r : this.requests) {
            r.popMonitor();
        }
        return this.monitors.pop();
    }

    @Override
    public IProgressMonitor getMonitor() {
        return this.monitors.peek();
    }

    @Override
    public String getInputName() {
        return this.inputName;
    }

    @Override
    public boolean isModuleRenameRefactoringRequest() {
        Boolean ret = null;
        for (RefactoringRequest r : this.requests) {
            boolean moduleRenameRefactoringRequest = r.isModuleRenameRefactoringRequest();
            if (ret == null) {
                ret = moduleRenameRefactoringRequest;
                continue;
            }
            if (ret != moduleRenameRefactoringRequest) {
                throw new AssertionError((Object)"Error: multiple request types (unexpected condition).");
            }
        }
        if (ret == null) {
            throw new AssertionError((Object)"Unable to determine (no requests available)");
        }
        return ret;
    }

    @Override
    public String getInitialName() {
        Iterator<RefactoringRequest> iterator = this.requests.iterator();
        if (iterator.hasNext()) {
            RefactoringRequest r = iterator.next();
            return r.qualifier;
        }
        throw new AssertionError((Object)"Unable to get initial name (no requests available)");
    }
}

