/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.runners;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class SimpleIronpythonRunner
extends SimpleRunner {
    public Tuple<String, String> runAndGetOutputFromPythonScript(String interpreter, String script, String[] args, File workingDir, IProject project) {
        String[] parameters = SimpleIronpythonRunner.addInterpreterToArgs(interpreter, script, args);
        return this.runAndGetOutput(parameters, workingDir, PythonNature.getPythonNature(project), (IProgressMonitor)new NullProgressMonitor(), null);
    }

    public static String[] makeExecutableCommandStr(String interpreter, String script, String[] args) {
        String[] s = SimpleIronpythonRunner.addInterpreterToArgs(interpreter, script, args);
        ArrayList<String> asList = new ArrayList<String>(Arrays.asList(s));
        asList.addAll(Arrays.asList(args));
        return asList.toArray(new String[0]);
    }

    private static String[] addInterpreterToArgs(String interpreter, String script, String[] args) {
        return SimpleIronpythonRunner.preparePythonCallParameters(interpreter, script, args, true);
    }

    public Tuple<String, String> runAndGetOutputWithInterpreter(String interpreter, String script, String[] args, File workingDir, IProject project, IProgressMonitor monitor, String encoding) {
        monitor.setTaskName("Mounting executable string...");
        monitor.worked(5);
        String[] s = SimpleIronpythonRunner.preparePythonCallParameters(interpreter, script, args, true);
        monitor.worked(1);
        return this.runAndGetOutput(s, workingDir, PythonNature.getPythonNature(project), monitor, encoding);
    }

    public static String[] preparePythonCallParameters(String interpreter, String script, String[] args, boolean scriptExists) {
        String defaultVmArgs;
        File file;
        if (scriptExists && !(file = new File(script)).exists()) {
            throw new RuntimeException("The script passed for execution (" + script + ") does not exist.");
        }
        if (SharedCorePlugin.inTestMode()) {
            defaultVmArgs = "-X:Frames -X:ExceptionDetail -X:ShowClrExceptions";
        } else {
            IEclipsePreferences preferenceStore = PydevPrefs.getEclipsePreferences();
            defaultVmArgs = preferenceStore.get("IRONPYTHON_INTERNAL_SHELL_VM_ARGS", "-X:Frames -X:ExceptionDetail -X:ShowClrExceptions");
        }
        List defaultVmArgsSplit = new ArrayList();
        if (defaultVmArgs != null) {
            defaultVmArgsSplit = StringUtils.split((String)defaultVmArgs, (char)' ');
        }
        if (args == null) {
            args = new String[]{};
        }
        ArrayList<String> call = new ArrayList<String>();
        call.add(interpreter);
        call.addAll(defaultVmArgsSplit);
        call.add(script);
        call.addAll(Arrays.asList(args));
        return call.toArray(new String[0]);
    }
}

