/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.sort_imports;

import java.io.File;
import java.util.HashSet;
import java.util.Optional;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.sort_imports.ImportArranger;
import org.python.pydev.ast.sort_imports.Pep8ImportArranger;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPyFormatStdProvider;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.imports.ImportPreferences;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.pep8.ISortRunner;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.io.PyUnsupportedEncodingException;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.utils.DocUtils;

public class SortImports {
    public void sortImports(IPythonNature pythonNature, IAdaptable projectAdaptable, File targetFile, String fileContents, IDocument doc, boolean removeUnusedImports, String endLineDelim, String indentStr, boolean automatic, IPyFormatStdProvider edit, int maxCols) throws MisconfigurationException, PythonNatureWithoutProjectException {
        HashSet<String> knownThirdParty = new HashSet<String>();
        String importEngine = ImportPreferences.getImportEngine((IAdaptable)projectAdaptable);
        if (!"IMPORT_ENGINE_ISORT".equals(importEngine) && pythonNature != null) {
            String name;
            int i;
            ModulesKey modulesKey;
            IInterpreterInfo projectInterpreter = pythonNature.getProjectInterpreter();
            ISystemModulesManager modulesManager = projectInterpreter.getModulesManager();
            ModulesKey[] onlyDirectModules = modulesManager.getOnlyDirectModules();
            HashSet<String> stdLib = new HashSet<String>();
            ModulesKey[] modulesKeyArray = onlyDirectModules;
            int n = onlyDirectModules.length;
            int n2 = 0;
            while (n2 < n) {
                modulesKey = modulesKeyArray[n2];
                if (modulesKey.file == null) {
                    i = modulesKey.name.indexOf(46);
                    name = i < 0 ? modulesKey.name : modulesKey.name.substring(0, i);
                    stdLib.add(name);
                }
                ++n2;
            }
            modulesKeyArray = onlyDirectModules;
            n = onlyDirectModules.length;
            n2 = 0;
            while (n2 < n) {
                modulesKey = modulesKeyArray[n2];
                i = modulesKey.name.indexOf(46);
                name = i < 0 ? modulesKey.name : modulesKey.name.substring(0, i);
                if (modulesKey.file != null && modulesKey.file.toString().contains("site-packages")) {
                    stdLib.remove(name);
                    knownThirdParty.add(name);
                }
                ++n2;
            }
        }
        switch (importEngine) {
            case "IMPORT_ENGINE_ISORT": {
                if (fileContents.length() <= 0) break;
                String encoding = null;
                try {
                    encoding = FileUtils.getPythonFileEncoding((IDocument)doc, null);
                }
                catch (PyUnsupportedEncodingException e) {
                    Log.log((Throwable)e);
                }
                if (encoding == null) {
                    encoding = "utf-8";
                }
                Optional executableLocation = ImportPreferences.getISortExecutable((IAdaptable)projectAdaptable);
                String[] args = ImportPreferences.getISortArguments((IAdaptable)projectAdaptable);
                String isortResult = ISortRunner.formatWithISort(targetFile, pythonNature, fileContents, encoding, targetFile.getParentFile(), args, knownThirdParty, executableLocation);
                if (isortResult == null) break;
                String delimiter = PySelection.getDelimiter((IDocument)doc);
                if (!delimiter.equals(System.lineSeparator())) {
                    isortResult = StringUtils.replaceAll((String)isortResult, (String)System.lineSeparator(), (String)delimiter);
                }
                try {
                    DocUtils.updateDocRangeWithContents((IDocument)doc, (String)fileContents, (String)isortResult.toString());
                }
                catch (Exception e) {
                    Log.log((String)StringUtils.format((String)"Error trying to apply isort result. Curr doc:\n>>>%s\n<<<.\nNew doc:\\n>>>%s\\n<<<.", (Object[])new Object[]{fileContents, isortResult.toString()}), (Throwable)e);
                }
                break;
            }
            case "IMPORT_ENGINE_REGULAR_SORT": {
                SortImports.performArrangeImports(doc, removeUnusedImports, endLineDelim, indentStr, automatic, edit, maxCols);
                break;
            }
            default: {
                SortImports.pep8PerformArrangeImports(doc, removeUnusedImports, endLineDelim, pythonNature, indentStr, automatic, edit, maxCols);
            }
        }
    }

    public static void performPep8ArrangeImports(Document doc, String endLineDelim, String indentStr, boolean automatic, IPyFormatStdProvider edit, IPythonNature nature, int maxCols) {
        SortImports.pep8PerformArrangeImports((IDocument)doc, false, endLineDelim, nature, indentStr, automatic, edit, maxCols);
    }

    public static void performArrangeImports(Document doc, String endLineDelim, String indentStr, IPyFormatStdProvider edit, int maxCols) {
        SortImports.performArrangeImports((IDocument)doc, false, endLineDelim, indentStr, false, edit, maxCols);
    }

    public static void pep8PerformArrangeImports(IDocument doc, boolean removeUnusedImports, String endLineDelim, IPythonNature nature, String indentStr, boolean automatic, IPyFormatStdProvider edit, int maxCols) {
        new Pep8ImportArranger(doc, removeUnusedImports, endLineDelim, nature, indentStr, automatic, edit, maxCols).perform();
    }

    public static void performArrangeImports(IDocument doc, boolean removeUnusedImports, String endLineDelim, String indentStr, boolean automatic, IPyFormatStdProvider edit, int maxCols) {
        new ImportArranger(doc, removeUnusedImports, endLineDelim, indentStr, automatic, edit, maxCols).perform();
    }
}

