/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.surround_with;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.python.pydev.core.IAssistProps;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.core.templates.PyAddTemplateResolvers;
import org.python.pydev.core.templates.PyDocumentTemplateContext;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public class AssistSurroundWith
implements IAssistProps {
    public static final String[] SURROUND_WITH_COMPLETIONS = new String[]{"%stry:%s%s%s%sexcept ${Exception}${cursor}:%s%s%sraise", "try..except Exception", "%stry:%s%s%s%sexcept ${Exception} as e:%s%s%s${raise}${cursor}", "try..except Exception as e", "%stry:%s%s%s%sfinally:%s%s%s${pass}", "try..finally", "%sif ${condition}:%s%s%s%selse:%s%s%s${pass}", "if..else", "%swhile ${condition}:%s%s%s%s%s", "while", "%sfor ${item} in ${collection}:%s%s%s%s%s${cursor}", "for", "%sif ${condition}:%s%s%s%s%s${cursor}", "if", "%swith ${var}:%s%s%s%s%s${cursor}", "with"};

    public static TemplateContext createContext(IRegion region, IDocument document, IIndentPrefs indentPrefs) {
        TemplateContextType contextType = new TemplateContextType();
        PyAddTemplateResolvers.addDefaultResolvers(contextType);
        return new PyDocumentTemplateContext(contextType, document, region.getOffset(), region.getLength(), "", indentPrefs);
    }

    public List<ICompletionProposalHandle> getProps(PySelection ps, IImageCache imageCache, File f, IPythonNature nature, IPyEdit edit, int offset) throws BadLocationException {
        IIndentPrefs indentPrefs;
        IIndentPrefs iIndentPrefs = indentPrefs = edit != null ? edit.getIndentPrefs() : null;
        if (indentPrefs == null) {
            indentPrefs = DefaultIndentPrefs.get((IAdaptable)nature);
        }
        ArrayList<ICompletionProposalHandle> l = new ArrayList<ICompletionProposalHandle>();
        String indentation = indentPrefs.getIndentationString();
        ps.selectCompleteLine();
        String selectedText = ps.getSelectedText();
        selectedText = selectedText.replace("$", "$$");
        List splitInLines = StringUtils.splitInLines((String)selectedText);
        int firstCharPosition = -1;
        int firstCommentCharPosition = -1;
        for (String string : splitInLines) {
            int localFirst;
            String trimmed = string.trim();
            if (trimmed.startsWith("#")) {
                localFirst = PySelection.getFirstCharPosition((String)string);
                if (firstCommentCharPosition == -1) {
                    firstCommentCharPosition = localFirst;
                    continue;
                }
                if (localFirst >= firstCommentCharPosition) continue;
                firstCommentCharPosition = localFirst;
                continue;
            }
            if (trimmed.length() <= 0) continue;
            localFirst = PySelection.getFirstCharPosition((String)string);
            if (firstCharPosition == -1) {
                firstCharPosition = localFirst;
                continue;
            }
            if (localFirst >= firstCharPosition) continue;
            firstCharPosition = localFirst;
        }
        if (firstCharPosition == -1) {
            if (firstCommentCharPosition != -1) {
                firstCharPosition = firstCommentCharPosition;
            } else {
                return l;
            }
        }
        String delimiter = ps.getEndLineDelim();
        FastStringBuffer startIndentBuffer = new FastStringBuffer(firstCharPosition + 1);
        startIndentBuffer.appendN(' ', firstCharPosition);
        String startIndent = startIndentBuffer.toString();
        Object surroundedCode = selectedText;
        surroundedCode = indentation + ((String)surroundedCode).replaceAll(delimiter, delimiter + indentation);
        IRegion region = ps.getRegion();
        TemplateContext context = AssistSurroundWith.createContext(region, ps.getDoc(), indentPrefs);
        Object[] replace0to3 = new String[]{startIndent, delimiter, surroundedCode, delimiter, startIndent, delimiter, startIndent, indentation, indentation};
        Object[] replace4toEnd = new String[]{startIndent, delimiter, surroundedCode, delimiter, startIndent, indentation};
        int iComp = 0;
        int iRep = 0;
        while (iComp < SURROUND_WITH_COMPLETIONS.length) {
            String comp = SURROUND_WITH_COMPLETIONS[iComp];
            comp = iRep < 4 ? StringUtils.format((String)comp, (Object[])replace0to3) : StringUtils.format((String)comp, (Object[])replace4toEnd);
            l.add(this.createProposal(ps, imageCache, edit, startIndent, region, iComp, comp, context));
            iComp += 2;
            ++iRep;
        }
        return l;
    }

    private ICompletionProposalHandle createProposal(PySelection ps, IImageCache imageCache, IPyEdit edit, String startIndent, IRegion region, int iComp, String comp, TemplateContext context) {
        Template t = new Template("Surround with", SURROUND_WITH_COMPLETIONS[iComp + 1], "", comp, false);
        return CompletionProposalFactory.get().createPyTemplateProposal(t, context, region, imageCache == null ? null : imageCache.get("icons/template.gif"), 0);
    }

    public boolean isValid(PySelection ps, String sel, IPyEdit edit, int offset) {
        return ps.getTextSelection().getLength() > 0;
    }
}

