/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.pep8;

import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.ast.runners.UniversalRunner;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.pep8.RunnerCommon;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.ArrayUtils;

public class ISortRunner {
    public static String formatWithISort(File targetFile, IPythonNature nature, String fileContents, String encoding, File workingDir, String[] isortArguments, Set<String> knownThirdParty, Optional<String> executableLocation) {
        try {
            String cmdarrayAsStr;
            Process process;
            if (executableLocation.isPresent() && !executableLocation.get().isEmpty() && FileUtils.enhancedIsFile((File)new File(executableLocation.get()))) {
                SimpleRunner simpleRunner = new SimpleRunner();
                String[] args = (String[])ArrayUtils.concatArrays((Object[][])new String[][]{{executableLocation.get(), "-"}, isortArguments});
                Tuple<Process, String> r = simpleRunner.run(args, workingDir, null, null);
                process = (Process)r.o1;
                cmdarrayAsStr = (String)r.o2;
            } else {
                String[] stringArray;
                String filepath;
                if (nature == null) {
                    IInterpreterManager manager = InterpreterManagersAPI.getPythonInterpreterManager();
                    try {
                        nature = new SystemPythonNature(manager);
                    }
                    catch (MisconfigurationException e) {
                        Log.log((Throwable)e);
                    }
                }
                UniversalRunner.PythonRunner pythonRunner = new UniversalRunner.PythonRunner(nature);
                String string = filepath = targetFile != null ? FileUtils.getFileAbsolutePath((File)targetFile) : null;
                if (filepath != null && filepath.length() > 0) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "--filename";
                    stringArray = stringArray2;
                    stringArray2[1] = filepath;
                } else {
                    stringArray = new String[]{};
                }
                String[] pathArgs = stringArray;
                ArrayList known = new ArrayList();
                String[] args = (String[])ArrayUtils.concatArrays((Object[][])new String[][]{pathArgs, isortArguments, known.toArray(new String[0]), {"-d", "-"}});
                Tuple<Process, String> processInfo = pythonRunner.createProcessFromModuleName("isort", args, workingDir, (IProgressMonitor)new NullProgressMonitor());
                process = (Process)processInfo.o1;
                cmdarrayAsStr = (String)processInfo.o2;
            }
            return RunnerCommon.writeContentsAndGetOutput(fileContents.getBytes(encoding), encoding, process, cmdarrayAsStr, "isort");
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
    }
}

