/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.templates;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.templates.PyDocumentTemplateContext;
import org.python.pydev.core.templates.PyTemplateVariableResolver;
import org.python.pydev.parser.fastparser.FastParser;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class PyTemplatesDefault {
    public static CallableTemplateVariableResolver IsoDate() {
        return new CallableTemplateVariableResolver("isodate", "ISO-8601 Ymd date", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date date = new Date();
            return formatter.format(date);
        }));
    }

    public static CallableTemplateVariableResolver IsoDate1() {
        return new CallableTemplateVariableResolver("isodatestr", "ISO-8601 Ymd HM date", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            Date date = new Date();
            return formatter.format(date);
        }));
    }

    public static CallableTemplateVariableResolver IsoDate2() {
        return new CallableTemplateVariableResolver("isodatestr2", "ISO-8601 Ymd HM date", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            return formatter.format(date);
        }));
    }

    public static CallableTemplateVariableResolver ModuleName() {
        return new CallableTemplateVariableResolver("module", "Current module", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> context.getModuleName()));
    }

    public static List<stmtType> getCurrentAstPath(PyDocumentTemplateContext context) {
        return PyTemplatesDefault.getCurrentAstPath(context, false);
    }

    public static List<stmtType> getCurrentAstPath(PyDocumentTemplateContext context, boolean reverse) {
        PySelection selection = context.createPySelection();
        List ret = FastParser.parseToKnowGloballyAccessiblePath((IDocument)context.getDocument(), (int)selection.getStartLineIndex());
        if (reverse) {
            Collections.reverse(ret);
        }
        return ret;
    }

    public static CallableTemplateVariableResolver QualifiedNameScope() {
        return new CallableTemplateVariableResolver("current_qualified_scope", "Current qualified scope", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> {
            List<stmtType> stmts = PyTemplatesDefault.getCurrentAstPath(context);
            FastStringBuffer buf = new FastStringBuffer();
            for (stmtType stmt : stmts) {
                if (!buf.isEmpty()) {
                    buf.append('.');
                }
                buf.append(NodeUtils.getRepresentationString((ISimpleNode)stmt));
            }
            return "";
        }));
    }

    public static ClassDef getCurrentClassStmt(PyDocumentTemplateContext context) {
        for (stmtType stmt : PyTemplatesDefault.getCurrentAstPath(context, true)) {
            if (!(stmt instanceof ClassDef)) continue;
            return (ClassDef)stmt;
        }
        return null;
    }

    public static CallableTemplateVariableResolver CurrentClass() {
        return new CallableTemplateVariableResolver("current_class", "Current class", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> {
            ClassDef stmt = PyTemplatesDefault.getCurrentClassStmt(context);
            if (stmt != null) {
                return NodeUtils.getRepresentationString((ISimpleNode)stmt);
            }
            return "";
        }));
    }

    public static CallableTemplateVariableResolver SelfOrCls() {
        return new CallableTemplateVariableResolver("self_or_cls", "Get `self` or `cls`", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> {
            String firstToken;
            PySelection selection = context.createPySelection();
            stmtType node = FastParser.firstClassOrFunction((IDocument)context.getDocument(), (int)selection.getStartLineIndex(), (boolean)false, (boolean)false);
            if (node instanceof FunctionDef && "cls".equals(firstToken = selection.getFirstInsideParentesisTok(node.beginLine - 1))) {
                return "cls";
            }
            return "self";
        }));
    }

    public static TemplateVariableResolver PydevdFileLocation() {
        return new CallableTemplateVariableResolver("pydevd_file_location", "pydevd.py File Location", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> {
            try {
                return FileUtils.getFileAbsolutePath((File)CorePlugin.getScriptWithinPySrc((String)"pydevd.py"));
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
                return "<unable to get pydevd.py location>";
            }
        }));
    }

    public static TemplateVariableResolver PydevdDirLocation() {
        return new CallableTemplateVariableResolver("pydevd_dir_location", "pydevd.py Directory Location", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> {
            try {
                return FileUtils.getFileAbsolutePath((File)CorePlugin.getScriptWithinPySrc((String)"pydevd.py").getParentFile());
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
                return "<unable to get pydevd.py directory location>";
            }
        }));
    }

    public static TemplateVariableResolver CurrentMethod() {
        return new CallableTemplateVariableResolver("current_method", "Current method", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> {
            for (stmtType stmt : PyTemplatesDefault.getCurrentAstPath(context, true)) {
                if (!(stmt instanceof FunctionDef)) continue;
                return NodeUtils.getRepresentationString((ISimpleNode)stmt);
            }
            return "";
        }));
    }

    private static String getPreviousOrNextClassOrMethod(PyDocumentTemplateContext context, boolean searchForward) {
        PySelection selection;
        int startLine;
        IDocument doc = context.getDocument();
        stmtType found = FastParser.firstClassOrFunction((IDocument)doc, (int)(startLine = (selection = context.createPySelection()).getStartLineIndex()), (boolean)searchForward, (boolean)context.isCythonFile());
        if (found != null) {
            return NodeUtils.getRepresentationString((ISimpleNode)found);
        }
        return "";
    }

    public static TemplateVariableResolver PreviousClassOrMethod() {
        return new CallableTemplateVariableResolver("prev_class_or_method", "Previous class or method", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> PyTemplatesDefault.getPreviousOrNextClassOrMethod(context, false)));
    }

    public static TemplateVariableResolver NextClassOrMethod() {
        return new CallableTemplateVariableResolver("next_class_or_method", "Next class or method", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> PyTemplatesDefault.getPreviousOrNextClassOrMethod(context, true)));
    }

    public static TemplateVariableResolver Superclass() {
        return new CallableTemplateVariableResolver("superclass", "Superclass of the current class", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> {
            PySelection selection = context.createPySelection();
            ClassDef stmt = PyTemplatesDefault.getCurrentClassStmt(context);
            if (stmt == null) {
                return "";
            }
            IDocument doc = context.getDocument();
            NameTok name = (NameTok)stmt.name;
            int nameStartOffset = selection.getAbsoluteCursorOffset(name.beginLine - 1, name.beginColumn - 1);
            nameStartOffset += name.id.length();
            boolean foundStart = false;
            int i = 0;
            FastStringBuffer contents = new FastStringBuffer();
            try {
                block2: while (true) {
                    char c = doc.get(nameStartOffset + i, 1).charAt(0);
                    ++i;
                    if (c == '(') {
                        foundStart = true;
                        continue;
                    }
                    if (c != ')' && c != ':') {
                        if (c == '\r' || c == '\n' || c == ' ' || c == '\t') continue;
                        if (c == '#') {
                            while (true) {
                                if (c == '\r' || c == '\n') continue block2;
                                c = doc.get(nameStartOffset + i, 1).charAt(0);
                                ++i;
                            }
                        }
                        if (!foundStart) continue;
                        contents.append(c);
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException e) {
                return "";
            }
            if (contents.indexOf(',') != -1) {
                ArrayList<String> ret = new ArrayList<String>();
                String[] stringArray = contents.toString().split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String param = stringArray[n2];
                    ret.add(param.trim());
                    ++n2;
                }
                return ret;
            }
            return contents.toString().trim();
        }));
    }

    public static TemplateVariableResolver Condition() {
        return new CallableTemplateVariableResolver("condition", "Condition to be matched", (ICallback<Object, PyDocumentTemplateContext>)((ICallback)context -> Arrays.asList("True", "False")));
    }

    public static class CallableTemplateVariableResolver
    extends PyTemplateVariableResolver {
        private ICallback<Object, PyDocumentTemplateContext> callable;

        public CallableTemplateVariableResolver(String type, String description, ICallback<Object, PyDocumentTemplateContext> callable) {
            super(type, description);
            this.callable = callable;
        }

        public String[] resolveAll(TemplateContext context) {
            Object obj = this.callable.call((Object)((PyDocumentTemplateContext)context));
            if (obj == null) {
                return new String[0];
            }
            if (obj instanceof String) {
                String ret = (String)obj;
                return new String[]{ret};
            }
            if (obj instanceof List) {
                List list = (List)obj;
                return list.toArray(new String[0]);
            }
            throw new RuntimeException("Error. Expected String or List<String>. Found: " + String.valueOf(obj));
        }
    }
}

