/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.IPythonNatureListener;

public class PythonNatureListenersManager {
    private static final List<WeakReference<IPythonNatureListener>> pythonNatureListeners = new ArrayList<WeakReference<IPythonNatureListener>>();
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPythonNatureListener(IPythonNatureListener listener) {
        Object object = lock;
        synchronized (object) {
            pythonNatureListeners.add(new WeakReference<IPythonNatureListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePythonNatureListener(IPythonNatureListener provider) {
        Object object = lock;
        synchronized (object) {
            Iterator<WeakReference<IPythonNatureListener>> it = pythonNatureListeners.iterator();
            while (it.hasNext()) {
                WeakReference<IPythonNatureListener> ref = it.next();
                if (ref.get() != provider) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyPythonPathRebuilt(IProject project, IPythonNature nature) {
        ArrayList<IPythonNatureListener> notifyRebuilds = new ArrayList<IPythonNatureListener>();
        Object object = lock;
        synchronized (object) {
            Iterator<WeakReference<IPythonNatureListener>> it = pythonNatureListeners.iterator();
            while (it.hasNext()) {
                WeakReference<IPythonNatureListener> ref = it.next();
                try {
                    IPythonNatureListener listener = (IPythonNatureListener)ref.get();
                    if (listener == null) {
                        it.remove();
                        continue;
                    }
                    notifyRebuilds.add(listener);
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                }
            }
        }
        for (IPythonNatureListener listener : notifyRebuilds) {
            try {
                listener.notifyPythonPathRebuilt(project, nature);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }
}

