/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.index;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.index.CodeAnalyzer;
import org.python.pydev.shared_core.index.IFields;
import org.python.pydev.shared_core.index.SearchResult;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.partitioner.IContentsScanner;
import org.python.pydev.shared_core.partitioner.IToken;
import org.python.pydev.shared_core.partitioner.ITokenScanner;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.OrderedMap;
import org.python.pydev.shared_core.utils.Timer;

public class IndexApi {
    public static final boolean DEBUG = false;
    public static final String luceneSuffix = "L481";
    private final Directory indexDir;
    private IndexWriter writer;
    private SearcherManager searchManager;
    private SearcherFactory searcherFactory;
    private int maxMatches = Integer.MAX_VALUE;
    private CodeAnalyzer analyzer;
    private final Object lock = new Object();

    protected IndexApi(Object indexDirObj, boolean applyAllDeletes) throws IOException {
        FSDirectory dir;
        java.nio.file.Path indexPath;
        File indexFile;
        Directory indexDir;
        Directory resultDir = indexDir = (Directory)indexDirObj;
        if (indexDir instanceof FSDirectory && !(indexFile = (indexPath = (dir = (FSDirectory)indexDir).getDirectory()).toFile()).getAbsolutePath().endsWith(luceneSuffix)) {
            File newIndexFile = new File(indexFile.getAbsolutePath() + luceneSuffix);
            resultDir = FSDirectory.open((java.nio.file.Path)newIndexFile.toPath());
        }
        this.indexDir = resultDir;
        this.init(applyAllDeletes);
    }

    public Object getLock() {
        return this.lock;
    }

    public IndexApi(File indexDir, boolean applyAllDeletes) throws IOException {
        this(FSDirectory.open((java.nio.file.Path)indexDir.toPath()), applyAllDeletes);
    }

    public void init(boolean applyAllDeletes) throws IOException {
        this.analyzer = new CodeAnalyzer();
        IndexWriterConfig config = new IndexWriterConfig((Analyzer)this.analyzer);
        config.setCommitOnClose(true);
        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        try {
            this.writer = new IndexWriter(this.indexDir, config);
        }
        catch (IOException e) {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            this.writer = new IndexWriter(this.indexDir, config);
        }
        this.searcherFactory = new SearcherFactory();
        this.searchManager = new SearcherManager(this.writer, applyAllDeletes, false, this.searcherFactory);
    }

    public void registerTokenizer(String fieldName, Analyzer.TokenStreamComponents tokenStream) {
        this.analyzer.registerTokenizer(fieldName, tokenStream);
    }

    public void commit() throws IOException {
        if (this.writer != null) {
            this.writer.commit();
        }
    }

    public void dispose() {
        if (this.writer != null) {
            try {
                this.writer.commit();
            }
            catch (IOException e) {
                Log.log(e);
            }
            try {
                this.writer.close();
            }
            catch (Exception e) {
                Log.log(e);
            }
            this.writer = null;
        }
        if (this.searchManager != null) {
            try {
                this.searchManager.close();
            }
            catch (Exception e) {
                Log.log(e);
            }
            this.searchManager = null;
        }
    }

    private Document createDocument(Map<String, String> fieldsToIndex) {
        Document doc = new Document();
        Set<Map.Entry<String, String>> entrySet = fieldsToIndex.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            doc.add((IndexableField)new StringField(entry.getKey(), entry.getValue(), Field.Store.YES));
        }
        return doc;
    }

    private Document createDocument(IPath filepath, long modifiedTime, Map<String, String> additionalStringFields) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("filepath", filepath.toPortableString(), Field.Store.YES));
        doc.add((IndexableField)new StringField("mod_time", String.valueOf(modifiedTime), Field.Store.YES));
        String lastSegment = filepath.removeFileExtension().lastSegment();
        if (lastSegment == null) {
            lastSegment = "";
        }
        doc.add((IndexableField)new StringField("filename", lastSegment, Field.Store.YES));
        String fileExtension = filepath.getFileExtension();
        if (fileExtension == null) {
            fileExtension = "";
        }
        if (additionalStringFields != null) {
            Set<Map.Entry<String, String>> entrySet = additionalStringFields.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                doc.add((IndexableField)new StringField(entry.getKey(), entry.getValue(), Field.Store.YES));
            }
        }
        doc.add((IndexableField)new StringField("ext", fileExtension, Field.Store.YES));
        return doc;
    }

    public void index(Path filepath, long modifiedTime, String general) throws IOException {
        this.index(filepath, modifiedTime, general, null);
    }

    public void index(Path filepath, long modifiedTime, String general, Map<String, String> additionalStringFields) throws IOException {
        this.index(filepath, modifiedTime, general, "contents", additionalStringFields);
    }

    public void index(Path filepath, long modifiedTime, String general, String fieldName, Map<String, String> additionalStringFields) throws IOException {
        if (this.writer == null) {
            return;
        }
        Document doc = this.createDocument((IPath)filepath, modifiedTime, additionalStringFields);
        doc.add((IndexableField)new TextField(fieldName, general, Field.Store.NO));
        this.writer.addDocument((Iterable)doc);
    }

    public void index(Map<String, String> fieldsToIndex, Reader reader, String fieldName) throws IOException {
        if (this.writer == null) {
            return;
        }
        Document doc = this.createDocument(fieldsToIndex);
        doc.add((IndexableField)new TextField(fieldName, reader));
        this.writer.addDocument((Iterable)doc);
    }

    public void index(IPath filepath, long modifiedTime, Reader reader, String fieldName) throws IOException {
        if (this.writer == null) {
            return;
        }
        Document doc = this.createDocument(filepath, modifiedTime, null);
        doc.add((IndexableField)new TextField(fieldName, reader));
        this.writer.addDocument((Iterable)doc);
    }

    public void index(Path filepath, long modifiedTime, ITokenScanner tokenScanner, IFields mapper) throws IOException {
        if (this.writer == null) {
            return;
        }
        IContentsScanner contentsScanner = (IContentsScanner)((Object)tokenScanner);
        Document doc = this.createDocument((IPath)filepath, modifiedTime, null);
        FastStringBuffer buf = new FastStringBuffer();
        IToken nextToken = tokenScanner.nextToken();
        while (!nextToken.isEOF()) {
            if (!nextToken.isUndefined() && !nextToken.isWhitespace()) {
                int offset = tokenScanner.getTokenOffset();
                int length = tokenScanner.getTokenLength();
                contentsScanner.getContents(offset, length, buf.clear());
                String fieldName = mapper.getTokenFieldName(nextToken);
                if (fieldName != null) {
                    doc.add((IndexableField)new TextField(fieldName, buf.toString(), Field.Store.NO));
                }
            }
            nextToken = tokenScanner.nextToken();
        }
        this.writer.addDocument((Iterable)doc);
    }

    public SearchResult searchExact(String string, String fieldName, boolean applyAllDeletes) throws IOException {
        return this.searchExact(string, fieldName, applyAllDeletes, null, new String[0]);
    }

    public SearchResult searchExact(String string, String fieldName, boolean applyAllDeletes, IDocumentsVisitor visitor, String ... fieldsToLoad) throws IOException {
        TermQuery query = new TermQuery(new Term(fieldName, string));
        return this.search((Query)query, applyAllDeletes, visitor, fieldsToLoad);
    }

    public SearchResult searchWildcard(Set<String> string, String fieldName, boolean applyAllDeletes, IDocumentsVisitor visitor, Map<String, String> translateFields, String ... fieldsToLoad) throws IOException {
        OrderedMap<String, Set<String>> fieldNameToValues = new OrderedMap<String, Set<String>>();
        fieldNameToValues.put(fieldName, string);
        return this.searchWildcard(fieldNameToValues, applyAllDeletes, visitor, translateFields, fieldsToLoad);
    }

    public SearchResult searchWildcard(OrderedMap<String, Set<String>> fieldNameToValues, boolean applyAllDeletes, IDocumentsVisitor visitor, Map<String, String> translateFields, String ... fieldsToLoad) throws IOException {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        Set entrySet = fieldNameToValues.entrySet();
        for (Map.Entry entry : entrySet) {
            String newFieldName;
            BooleanQuery.Builder fieldQueryBuilder = new BooleanQuery.Builder();
            String fieldName = (String)entry.getKey();
            if (translateFields != null && (newFieldName = translateFields.get(fieldName)) != null) {
                fieldName = newFieldName;
            }
            boolean allNegate = true;
            for (String s : (Set)entry.getValue()) {
                if (s.length() == 0) {
                    throw new RuntimeException("Unable to create term for searching empty string.");
                }
                boolean negate = false;
                if (s.startsWith("!") && IFields.FIELDS_NEGATED_WITH_EXCLAMATION.contains(fieldName)) {
                    s = s.substring(1);
                    negate = true;
                }
                if (s.length() == 0) continue;
                if (s.indexOf(42) != -1 || s.indexOf(63) != -1) {
                    if (StringUtils.containsOnlyWildCards(s)) {
                        throw new RuntimeException("Unable to create term for searching only wildcards: " + s);
                    }
                    fieldQueryBuilder.add((Query)new WildcardQuery(new Term(fieldName, s)), negate ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.SHOULD);
                } else {
                    fieldQueryBuilder.add((Query)new TermQuery(new Term(fieldName, s)), negate ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.SHOULD);
                }
                if (negate) continue;
                allNegate = false;
            }
            BooleanQuery transitiveQuery = fieldQueryBuilder.build();
            if (transitiveQuery.clauses().size() == 0) continue;
            if (allNegate) {
                fieldQueryBuilder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
            }
            booleanQueryBuilder.add((Query)fieldQueryBuilder.build(), BooleanClause.Occur.MUST);
        }
        BooleanQuery booleanQuery = booleanQueryBuilder.build();
        return this.search((Query)booleanQuery, applyAllDeletes, visitor, fieldsToLoad);
    }

    public SearchResult searchRegexp(String string, String fieldName, boolean applyAllDeletes) throws IOException {
        return this.searchRegexp(string, fieldName, applyAllDeletes, null, new String[0]);
    }

    public SearchResult searchRegexp(String string, String fieldName, boolean applyAllDeletes, IDocumentsVisitor visitor, String ... fieldsToLoad) throws IOException {
        RegexpQuery query = new RegexpQuery(new Term(fieldName, string));
        return this.search((Query)query, applyAllDeletes, visitor, fieldsToLoad);
    }

    public void visitAllDocs(IDocumentsVisitor visitor, String ... fields) throws IOException {
        boolean applyAllDeletes = true;
        Throwable throwable = null;
        Object var5_6 = null;
        try (DirectoryReader reader = DirectoryReader.open((IndexWriter)this.writer, (boolean)applyAllDeletes, (boolean)false);){
            IndexSearcher searcher = this.searcherFactory.newSearcher((IndexReader)reader, null);
            MatchAllDocsQuery query = new MatchAllDocsQuery();
            TopDocs docs = searcher.search((Query)query, Integer.MAX_VALUE);
            ScoreDoc[] scoreDocs = docs.scoreDocs;
            int length = scoreDocs.length;
            int i = 0;
            while (i < length) {
                ScoreDoc scoreDoc = scoreDocs[i];
                DocumentStoredFieldVisitor fieldVisitor = new DocumentStoredFieldVisitor(fields);
                reader.document(scoreDoc.doc, (StoredFieldVisitor)fieldVisitor);
                Document document = fieldVisitor.getDocument();
                visitor.visit(new DocumentInfo(document, scoreDoc.doc));
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public SearchResult search(Query query, boolean applyAllDeletes, IDocumentsVisitor visitor, String ... fields) throws IOException {
        try {
            this.writer.commit();
        }
        catch (Exception e) {
            Log.log(e);
        }
        Throwable throwable = null;
        Object var6_8 = null;
        try (DirectoryReader reader = DirectoryReader.open((IndexWriter)this.writer, (boolean)applyAllDeletes, (boolean)false);){
            IndexSearcher searcher = this.searcherFactory.newSearcher((IndexReader)reader, null);
            TopDocs search = searcher.search(query, this.maxMatches);
            ScoreDoc[] scoreDocs = search.scoreDocs;
            if (visitor != null) {
                int length = scoreDocs.length;
                int i = 0;
                while (i < length) {
                    ScoreDoc scoreDoc = scoreDocs[i];
                    DocumentStoredFieldVisitor fieldVisitor = new DocumentStoredFieldVisitor(fields);
                    reader.document(scoreDoc.doc, (StoredFieldVisitor)fieldVisitor);
                    Document document = fieldVisitor.getDocument();
                    visitor.visit(new DocumentInfo(document, scoreDoc.doc));
                    ++i;
                }
            }
            return new SearchResult(scoreDocs);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void removeDocs(Map<String, Collection<String>> fieldToValuesToRemove) throws IOException {
        int total = 0;
        Set<Map.Entry<String, Collection<String>>> entrySet = fieldToValuesToRemove.entrySet();
        for (Map.Entry<String, Collection<String>> entry : entrySet) {
            total += entry.getValue().size();
        }
        if (total == 0) {
            return;
        }
        ArrayList<Term> lst = new ArrayList<Term>(total);
        for (Map.Entry<String, Collection<String>> entry : entrySet) {
            String fieldName = entry.getKey();
            for (String string : entry.getValue()) {
                lst.add(new Term(fieldName, string));
            }
        }
        Term[] queries = lst.toArray(new Term[0]);
        this.writer.deleteDocuments(queries);
    }

    public void setMaxMatches(int maxMatches) {
        this.maxMatches = maxMatches;
    }

    public int getMaxMatches() {
        return this.maxMatches;
    }

    public static void main(String[] args) throws IOException {
        File f = new File("x:\\index");
        final IndexApi indexApi = new IndexApi(f, true);
        ICallback<Object, java.nio.file.Path> onFile = new ICallback<Object, java.nio.file.Path>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object call(java.nio.file.Path path) {
                String string = path.toString();
                if (!string.endsWith(".py")) return null;
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try {
                        SeekableByteChannel sbc = Files.newByteChannel(path, new OpenOption[0]);
                        try {
                            try (InputStream in = Channels.newInputStream(sbc);){
                                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                                IPath path2 = Path.fromOSString((String)string);
                                indexApi.index(path2, FileUtils.lastModified(path.toFile()), reader, "contents");
                            }
                            if (sbc == null) return null;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (sbc == null) throw throwable;
                            sbc.close();
                            throw throwable;
                        }
                        sbc.close();
                        return null;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        } else {
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    Log.log("Error parsing: " + String.valueOf(path), e);
                }
                return null;
            }
        };
        Timer timer = new Timer();
        indexApi.setMaxMatches(Integer.MAX_VALUE);
        SearchResult searchResult = indexApi.searchRegexp(".*", "contents", true);
        System.out.println("Matched: " + searchResult.getNumberOfDocumentMatches());
        timer.printDiff("Total time");
    }

    public static class DocumentInfo {
        private Document document;
        private int documentId;

        public DocumentInfo(Document document, int doc) {
            this.document = document;
            this.documentId = doc;
        }

        public String get(String field) {
            return this.document.get(field);
        }

        public int getDocId() {
            return this.documentId;
        }
    }

    public static interface IDocumentsVisitor {
        public void visit(DocumentInfo var1);
    }
}

