/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.io;

import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.PyUnsupportedEncodingException;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.utils.PlatformUtils;

public class FileUtils {
    public static boolean IN_TESTS = false;
    private static final Map<File, Set<String>> alreadyReturned = new HashMap<File, Set<String>>();
    private static Object lockTempFiles = new Object();
    public static String BOM_UTF8 = StringUtils.BOM_UTF8;
    public static String BOM_UNICODE = StringUtils.BOM_UNICODE;
    public static final Pattern ENCODING_PATTERN = Pattern.compile("coding[:=][\\s]*([-\\w.]+)");

    public static Object readFromInputStreamAndCloseIt(ICallback<Object, ObjectInputStream> readFromFileMethod, InputStream input) {
        Object o = null;
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ObjectInputStream in = new ObjectInputStream(input);){
                    o = readFromFileMethod.call(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                input.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return o;
    }

    public static void appendStrToFile(String str, String file) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileOutputStream stream = new FileOutputStream(file, true);){
                stream.write(str.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            Log.log(e);
        }
        catch (IOException e) {
            Log.log(e);
        }
    }

    public static void writeStrToFile(String str, String file) {
        FileUtils.writeStrToFile(str, new File(file));
    }

    public static void writeStrToFile(String str, File file) {
        FileUtils.writeBytesToFile(str.getBytes(), file);
    }

    public static void writeBytesToFile(byte[] bytes, File file) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileOutputStream stream = new FileOutputStream(file);){
                stream.write(bytes);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            Log.log(e);
        }
        catch (IOException e) {
            Log.log(e);
        }
    }

    public static void writeToFile(Object o, File file) {
        FileUtils.writeToFile(o, file, false);
    }

    public static void writeToFile(Object o, File file, boolean zip) {
        try {
            OutputStream out = new FileOutputStream(file);
            if (zip) {
                out = new GZIPOutputStream(out);
            }
            FileUtils.writeToStreamAndCloseIt(o, out);
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    public static void writeToStreamAndCloseIt(Object o, OutputStream out) throws IOException {
        OutputStream b = null;
        b = out instanceof BufferedOutputStream || out instanceof ByteArrayOutputStream ? out : new BufferedOutputStream(out);
        try {
            try {
                ObjectOutputStream stream = new ObjectOutputStream(b);
                stream.writeObject(o);
                stream.close();
            }
            catch (Exception e) {
                Log.log(e);
                throw new RuntimeException(e);
            }
        }
        finally {
            b.close();
        }
    }

    public static Object readFromFile(File file) {
        return FileUtils.readFromFile(file, false);
    }

    /*
     * Exception decompiling
     */
    public static Object readFromFile(File file, boolean zip) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getFileAbsolutePath(String f) {
        return FileUtils.getFileAbsolutePath(new File(f));
    }

    public static String getFileAbsolutePath(Path path) {
        try {
            if (!PlatformUtils.isWindowsPlatform()) {
                return path.toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
            }
            return path.toFile().getCanonicalPath();
        }
        catch (IOException e) {
            return path.toFile().getAbsolutePath();
        }
    }

    public static String getFileAbsolutePathNotFollowingLinks(File f) {
        try {
            if (!PlatformUtils.isWindowsPlatform()) {
                return f.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
            }
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    public static String getFileAbsolutePath(File f) {
        return FileUtils.getFileAbsolutePathNotFollowingLinks(f);
    }

    public static void copyFile(String srcFilename, String dstFilename) {
        FileUtils.copyFile(new File(srcFilename), new File(dstFilename));
    }

    public static void copyFile(File srcFilename, File dstFilename) {
        try {
            Files.copy(srcFilename.toPath(), dstFilename.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyDirectory(File srcPath, File dstPath, ICallback<Boolean, File> filter, ICallback<String, String> changeFileContents) throws IOException {
        if (srcPath.isDirectory()) {
            String[] files;
            if (filter != null && filter.call(srcPath).booleanValue()) {
                return;
            }
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            if ((files = srcPath.list()) != null) {
                int i = 0;
                while (i < files.length) {
                    FileUtils.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]), filter, changeFileContents);
                    ++i;
                }
            }
        } else if (srcPath.exists()) {
            if (filter != null && filter.call(srcPath).booleanValue()) {
                return;
            }
            if (changeFileContents == null) {
                FileUtils.copyFile(srcPath.getAbsolutePath(), dstPath.getAbsolutePath());
            } else {
                String fileContents = FileUtils.getFileContents(srcPath);
                fileContents = changeFileContents.call(fileContents);
                FileUtils.writeStrToFile(fileContents, dstPath);
            }
        }
    }

    public static FastStringBuffer fillBufferWithStream(InputStream contentStream, String encoding, IProgressMonitor monitor) throws IOException {
        return FileUtils.fillBufferWithStream(contentStream, encoding, monitor, null);
    }

    public static FastStringBuffer fillBufferWithStream(InputStream contentStream, String encoding, IProgressMonitor monitor, FastStringBuffer buffer) throws IOException {
        InputStreamReader in = null;
        try {
            if (encoding == null) {
                in = new InputStreamReader(contentStream);
            } else {
                try {
                    in = new InputStreamReader(contentStream, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    Log.log(e);
                    in = new InputStreamReader(contentStream);
                }
            }
            int BUFFER_SIZE = 2048;
            if (buffer == null) {
                int DEFAULT_FILE_SIZE = 8 * BUFFER_SIZE;
                int available = contentStream.available();
                if (DEFAULT_FILE_SIZE < available) {
                    DEFAULT_FILE_SIZE = available;
                }
                buffer = new FastStringBuffer(DEFAULT_FILE_SIZE);
            }
            char[] readBuffer = new char[BUFFER_SIZE];
            int n = in.read(readBuffer);
            while (n > 0) {
                if (monitor != null && monitor.isCanceled()) {
                    return null;
                }
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
        }
        finally {
            try {
                if (in != null) {
                    ((Reader)in).close();
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        return buffer;
    }

    public static boolean createBackupFile(File file) {
        File parent;
        if (file != null && file.isFile() && (parent = file.getParentFile()).isDirectory()) {
            String[] list = parent.list();
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(list));
            Object initialName = file.getName();
            Object name = initialName = (String)initialName + ".bak";
            int i = 0;
            while (set.contains(name)) {
                name = (String)initialName + i;
                ++i;
            }
            FileUtils.copyFile(file.getAbsolutePath(), new File(parent, (String)name).getAbsolutePath());
            return true;
        }
        return false;
    }

    public static File getTempFileAt(File parentDir, String prefix) {
        return FileUtils.getTempFileAt(parentDir, prefix, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempFileAt(File parentDir, String prefix, String extension) {
        Object object = lockTempFiles;
        synchronized (object) {
            Assert.isTrue((boolean)parentDir.isDirectory());
            Set<String> current = alreadyReturned.get(parentDir);
            if (current == null) {
                current = new HashSet<String>();
                alreadyReturned.put(parentDir, current);
            }
            current.addAll(FileUtils.getFilesStartingWith(parentDir, prefix));
            FastStringBuffer buf = new FastStringBuffer();
            long i = 0L;
            while (i < Long.MAX_VALUE) {
                File file;
                String v = buf.clear().append(prefix).append(i).append(extension).toString();
                if (!current.contains(v) && !(file = new File(parentDir, v)).exists()) {
                    current.add(file.getName());
                    return file;
                }
                ++i;
            }
            return null;
        }
    }

    public static HashSet<String> getFilesStartingWith(File parentDir, String prefix) {
        String[] list = parentDir.list();
        HashSet<String> hashSet = new HashSet<String>();
        if (list != null) {
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.startsWith(prefix)) {
                    hashSet.add(string);
                }
                ++n2;
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTempFilesAt(File parentDir, String prefix) {
        Object object = lockTempFiles;
        synchronized (object) {
            try {
                Assert.isTrue((boolean)parentDir.isDirectory());
                String[] list = parentDir.list();
                if (list != null) {
                    String[] stringArray = list;
                    int n = list.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        if (string.startsWith(prefix)) {
                            String integer = string.substring(prefix.length());
                            try {
                                Integer.parseInt(integer);
                                try {
                                    new File(parentDir, string).delete();
                                }
                                catch (Exception exception) {}
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                }
                alreadyReturned.remove(parentDir);
            }
            catch (Throwable e) {
                Log.log(e);
            }
        }
    }

    public static void deleteDirectoryTree(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (f.isDirectory()) {
                    FileUtils.deleteDirectoryTree(f);
                } else {
                    FileUtils.deleteFile(f);
                }
                ++i;
            }
        }
        if (!directory.delete()) {
            throw new IOException("Delete operation failed when deleting: " + String.valueOf(directory));
        }
    }

    public static void deleteFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.delete()) {
            throw new IOException("Delete operation failed when deleting: " + String.valueOf(file));
        }
    }

    public static void openDirectory(File dir) {
        try {
            Desktop.getDesktop().open(dir);
        }
        catch (IOException e1) {
            Log.log(e1);
        }
    }

    public static File createFileFromParts(String ... parts) {
        String part0 = parts[0];
        File f = new File(part0);
        int i = 1;
        while (i < parts.length) {
            String part = parts[i];
            f = new File(f, part);
            ++i;
        }
        return f;
    }

    public static <T> T getStreamContents(InputStream contentStream, String encoding, IProgressMonitor monitor, Class<T> returnType) throws IOException {
        FastStringBuffer buffer = FileUtils.fillBufferWithStream(contentStream, encoding, monitor);
        if (buffer == null) {
            return null;
        }
        if (returnType == null || returnType == FastStringBuffer.class) {
            return (T)buffer;
        }
        if (returnType == IDocument.class) {
            Document doc = new Document(buffer.toString());
            return (T)doc;
        }
        if (returnType == String.class) {
            return (T)buffer.toString();
        }
        throw new RuntimeException("Don't know how to handle return type: " + String.valueOf(returnType));
    }

    public static String getStreamContents(InputStream stream, String encoding, IProgressMonitor monitor) {
        try {
            String string = FileUtils.getStreamContents(stream, encoding, monitor, String.class);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
    }

    public static byte[] getFileContentsBytes(File file) throws IOException {
        return Files.readAllBytes(Paths.get(file.toURI()));
    }

    public static <T> T getFileContentsCustom(File file, String encoding, Class<T> returnType) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream stream = new FileInputStream(file);){
                return FileUtils.getStreamContents(stream, encoding, null, returnType);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getFileContentsCustom(File file, Class<T> returnType) {
        return FileUtils.getFileContentsCustom(file, null, returnType);
    }

    public static String getFileContents(File file) {
        return FileUtils.getFileContentsCustom(file, null, String.class);
    }

    public static String getPyFileContents(File file) {
        String encoding;
        try {
            encoding = FileUtils.getPythonFileEncoding(file);
        }
        catch (PyUnsupportedEncodingException e) {
            encoding = null;
        }
        return FileUtils.getFileContentsCustom(file, encoding, String.class);
    }

    public static String getPythonFileEncoding(File file) throws PyUnsupportedEncodingException {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(new FileInputStream(file)));){
                return FileUtils.getPythonFileEncoding(inputStreamReader, file.getAbsolutePath());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (PyUnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            Log.log(e);
            return null;
        }
    }

    public static String getPythonFileEncoding(String str, String location) throws PyUnsupportedEncodingException {
        StringReader inputStreamReader = new StringReader(str);
        return FileUtils.getPythonFileEncoding(inputStreamReader, location);
    }

    private static String getPythonFileEncoding(Reader inputStreamReader, String fileLocation) throws PyUnsupportedEncodingException {
        List<String> first2Lines = FileUtils.readLines(inputStreamReader, 2);
        return FileUtils.getPythonFileEncoding(first2Lines, fileLocation);
    }

    public static String getPythonFileEncoding(IDocument document, String fileLocation) throws PyUnsupportedEncodingException {
        ArrayList<String> first2Lines = new ArrayList<String>(2);
        switch (document.getNumberOfLines()) {
            case 0: {
                break;
            }
            case 1: {
                first2Lines.add(TextSelectionUtils.getLine(document, 0));
                break;
            }
            default: {
                first2Lines.add(TextSelectionUtils.getLine(document, 0));
                first2Lines.add(TextSelectionUtils.getLine(document, 1));
            }
        }
        return FileUtils.getPythonFileEncoding(first2Lines, fileLocation);
    }

    public static String getPythonFileEncoding(List<String> first2Lines, String fileLocation) throws PyUnsupportedEncodingException {
        String l1;
        String ret = null;
        int readLines = first2Lines.size();
        String lEnc = null;
        int lineNum = -1;
        int charNum = -1;
        String string = l1 = readLines > 0 ? first2Lines.get(0) : null;
        if (l1 != null) {
            if (l1.startsWith(BOM_UTF8)) {
                return "utf-8";
            }
            if (l1.indexOf("coding") != -1) {
                lEnc = l1;
                lineNum = 1;
            }
        }
        if (lEnc == null) {
            String l2;
            String string2 = l2 = readLines > 1 ? first2Lines.get(1) : null;
            if (l2 != null && l2.indexOf("coding") != -1) {
                lEnc = l2;
                lineNum = 2;
            } else {
                ret = null;
            }
        }
        if (lEnc != null) {
            Matcher matcher;
            if ((lEnc = lEnc.trim()).length() == 0) {
                ret = null;
            } else if (lEnc.charAt(0) == '#' && (matcher = ENCODING_PATTERN.matcher(lEnc)).find()) {
                ret = matcher.group(1).trim();
                charNum = matcher.start(1) + 1;
            }
        }
        try {
            ret = FileUtils.getValidEncoding(ret, fileLocation);
        }
        catch (UnsupportedEncodingException e) {
            throw new PyUnsupportedEncodingException(e.getMessage(), lineNum, charNum);
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getValidEncoding(String ret, String fileLocation) throws UnsupportedEncodingException {
        block7: {
            block8: {
                if (ret == null) {
                    return ret;
                }
                String lower = ret.trim().toLowerCase();
                if (lower.startsWith("latin") && lower.indexOf("1") != -1) {
                    return "latin1";
                }
                if (lower.equals("iso-latin-1-unix")) {
                    return "latin1";
                }
                try {
                    if (Charset.isSupported(ret)) return ret;
                    if (fileLocation == null) break block7;
                    if (!"uft-8".equals(ret) || !fileLocation.endsWith("bad_coding.py")) break block8;
                    return null;
                }
                catch (IllegalCharsetNameException ex) {
                    throw new UnsupportedEncodingException(ret);
                }
            }
            if (!"string-escape".equals(ret) || !fileLocation.endsWith("bad_coding3.py")) break block7;
            return null;
        }
        throw new UnsupportedEncodingException(ret);
    }

    public static boolean hasPythonShebang(Reader inputStreamReader) throws IllegalCharsetNameException {
        try {
            List<String> lines = FileUtils.readLines(inputStreamReader, 1);
            if (lines.size() > 0 && FileUtils.isPythonShebangLine(lines.get(0))) {
                return true;
            }
        }
        finally {
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public static boolean isPythonShebangLine(String l1) {
        return (l1 = StringUtils.removeBom(l1)).startsWith("#!") && l1.indexOf("python") != -1;
    }

    public static List<String> readLines(Reader inputStreamReader, int lines) {
        if (lines <= 0) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> ret = new ArrayList<String>(lines);
        try {
            char[] cbuf = new char[1024 * lines];
            int read = inputStreamReader.read(cbuf);
            if (read > 0) {
                for (String line : StringUtils.iterLines(new String(cbuf, 0, read))) {
                    ret.add(line);
                    if (lines != ret.size()) continue;
                    return ret;
                }
            }
        }
        catch (Exception e) {
            Log.log(e);
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    public static String getLineFromFile(File file, int lineNumber) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long getLastModifiedTimeFromDir(File file, FileFilter filesFilter, FileFilter dirFilter, int levels) {
        if (levels <= 0) {
            return 0L;
        }
        long max = 0L;
        if (file.isDirectory()) {
            Path path = Paths.get(file.toURI());
            try {
                Throwable throwable = null;
                Object var8_9 = null;
                try (DirectoryStream<Path> newDirectoryStream = Files.newDirectoryStream(path);){
                    for (Path path2 : newDirectoryStream) {
                        File file2 = path2.toFile();
                        if (file2.isDirectory()) {
                            if (!dirFilter.accept(file2)) continue;
                            max = Math.max(max, FileUtils.getLastModifiedTimeFromDir(file2, filesFilter, dirFilter, levels - 1));
                            continue;
                        }
                        if (!filesFilter.accept(file2)) continue;
                        max = Math.max(max, FileUtils.lastModified(file2));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Log.log(e);
            }
        } else if (filesFilter.accept(file)) {
            max = Math.max(max, FileUtils.lastModified(file));
        }
        return max;
    }

    public static ITextFileBuffer getBufferFromPath(IPath path) {
        try {
            ITextFileBuffer textFileBuffer;
            ITextFileBufferManager textFileBufferManager = ITextFileBufferManager.DEFAULT;
            if (textFileBufferManager != null && (textFileBuffer = textFileBufferManager.getTextFileBuffer(path, LocationKind.LOCATION)) != null) {
                return textFileBuffer;
            }
            return null;
        }
        catch (Throwable e) {
            if (!IN_TESTS) {
                Log.log("Unable to get doc from text file buffer");
            }
            return null;
        }
    }

    public static IDocument getDocFromResource(IResource resource) {
        IProject project = resource.getProject();
        if (project != null && resource instanceof IFile && resource.exists()) {
            IFile file = (IFile)resource;
            try {
                IPath path;
                IDocument doc;
                if (!file.isSynchronized(0)) {
                    file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                if ((doc = FileUtils.getDocFromPath(path = file.getFullPath())) == null) {
                    doc = FileUtils.getStreamContents(file.getContents(true), null, null, IDocument.class);
                }
                return doc;
            }
            catch (CoreException e) {
                return null;
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        return null;
    }

    public static IDocument getDocFromPath(IPath path) {
        ITextFileBuffer buffer = FileUtils.getBufferFromPath(path);
        if (buffer != null) {
            return buffer.getDocument();
        }
        return null;
    }

    public static void visitDirectory(File file, boolean recursive, ICallback<Boolean, Path> onFile) throws IOException {
        Path rootDir = Paths.get(FileUtils.getFileAbsolutePath(file), new String[0]);
        FileUtils.visitDirectory(rootDir, recursive, onFile);
    }

    public static void visitDirectory(Path rootDir, final boolean recursive, final ICallback<Boolean, Path> onFile) throws IOException {
        Files.walkFileTree(rootDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes atts) throws IOException {
                return recursive ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes mainAtts) throws IOException {
                if (!((Boolean)onFile.call(path)).booleanValue()) {
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException exc) throws IOException {
                return recursive ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                Log.log(exc);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static long lastModified(File file) {
        try {
            Path path = Paths.get(file.toURI());
            return FileUtils.lastModified(path);
        }
        catch (IOException e) {
            long lastModified = file.lastModified();
            Log.logInfo("Exception checking file: " + String.valueOf(file) + ": " + e.getMessage() + " - returning: " + lastModified);
            return lastModified;
        }
    }

    public static long lastModified(Path path) throws IOException {
        long ret = Files.getLastModifiedTime(path, new LinkOption[0]).to(TimeUnit.NANOSECONDS);
        return ret;
    }

    public static String getFileExtension(String name) {
        return StringUtils.getFileExtension(name);
    }

    public static ReadLines readLines(File file) {
        int nChars;
        byte[] cbuf;
        ArrayList<String> lines;
        block7: {
            lines = null;
            cbuf = null;
            nChars = -1;
            if (file.exists()) {
                try (FileInputStream stream = new FileInputStream(file);){
                    lines = new ArrayList<String>(2);
                    cbuf = new byte[2048];
                    nChars = stream.read(cbuf);
                    if (nChars <= 0) break block7;
                    for (String line : StringUtils.iterLines(new String(cbuf, 0, nChars))) {
                        lines.add(line);
                        if (2 != lines.size()) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
        }
        return new ReadLines(lines, cbuf, nChars);
    }

    public static String getPythonFileEncoding(byte[] buffer) throws PyUnsupportedEncodingException {
        int foundLines = 0;
        int lastByte = -1;
        int i = 0;
        while (i < buffer.length) {
            if (buffer[i] == 13) {
                if (i + 1 < buffer.length && buffer[i] + 1 == 10) {
                    ++i;
                }
                ++foundLines;
            }
            if (buffer[i] == 10) {
                ++foundLines;
            }
            if (foundLines == 2) {
                lastByte = i;
                break;
            }
            ++i;
        }
        if (lastByte == -1) {
            lastByte = buffer.length;
        }
        String s = new String(buffer, 0, lastByte);
        return FileUtils.getPythonFileEncoding(s, "");
    }

    public static void readLine(InputStream in, FastStringBuffer contents) throws IOException {
        char c;
        do {
            c = FileUtils.readChar(in);
            contents.append(c);
        } while (c != '\n');
    }

    private static char readChar(InputStream in) throws IOException {
        int i = in.read();
        if (i == -1) {
            throw new IOException("Done");
        }
        return (char)i;
    }

    public static boolean isPrefixOf(IPath thisPath, IPath anotherPath) {
        if (thisPath.getDevice() == null ? anotherPath.getDevice() != null : !thisPath.getDevice().equalsIgnoreCase(anotherPath.getDevice())) {
            return false;
        }
        if (thisPath.isEmpty() || thisPath.isRoot() && anotherPath.isAbsolute()) {
            return true;
        }
        int len = thisPath.segmentCount();
        if (len > anotherPath.segmentCount()) {
            return false;
        }
        if (PlatformUtils.isWindowsPlatform()) {
            int i = 0;
            while (i < len) {
                if (!thisPath.segment(i).equalsIgnoreCase(anotherPath.segment(i))) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (!thisPath.segment(i).equals(anotherPath.segment(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean enhancedIsFile(File file) {
        Path path = file.toPath();
        return Files.exists(path, LinkOption.NOFOLLOW_LINKS) && !Files.isDirectory(path, new LinkOption[0]);
    }

    public static class ReadLines {
        public final List<String> lines;
        private byte[] cbuf;
        private int nChars;

        public ReadLines(List<String> lines, byte[] cbuf, int nChars) {
            this.lines = lines;
            this.cbuf = cbuf;
            this.nChars = nChars;
        }

        public int size() {
            if (this.lines == null) {
                return 0;
            }
            return this.lines.size();
        }

        public boolean isBinary() {
            return this.cbuf != null ? !StringUtils.isValidTextString(this.cbuf, this.nChars) : false;
        }
    }
}

