/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.locator;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.log.Log;

public class GetContainers {
    public IContainer getContainerForLocation(IPath location, IProject project) {
        boolean stopOnFirst = true;
        IContainer[] filesForLocation = this.getContainersForLocation(location, project, stopOnFirst);
        if (filesForLocation != null && filesForLocation.length > 0) {
            return filesForLocation[0];
        }
        return null;
    }

    public IContainer[] getContainersForLocation(IPath location, IProject project, boolean stopOnFirst) {
        ArrayList<IContainer> lst = new ArrayList<IContainer>();
        HashSet<IProject> checked = new HashSet<IProject>();
        IWorkspace w = ResourcesPlugin.getWorkspace();
        if (project != null) {
            checked.add(project);
            IContainer f = this.getContainerInProject(location, project);
            if (f != null) {
                if (stopOnFirst) {
                    return new IContainer[]{f};
                }
                lst.add(f);
            }
            try {
                IProject[] referencedProjects = project.getDescription().getReferencedProjects();
                int i = 0;
                while (i < referencedProjects.length) {
                    IProject p = referencedProjects[i];
                    checked.add(p);
                    f = this.getContainerInProject(location, p);
                    if (f != null) {
                        if (stopOnFirst) {
                            return new IContainer[]{f};
                        }
                        lst.add(f);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                Log.log(e);
            }
        }
        IProject[] projects = w.getRoot().getProjects(8);
        int i = 0;
        while (i < projects.length) {
            IProject p = projects[i];
            if (!checked.contains(p)) {
                checked.add(p);
                IContainer f = this.getContainerInProject(location, p);
                if (f != null) {
                    if (stopOnFirst) {
                        return new IContainer[]{f};
                    }
                    lst.add(f);
                }
            }
            ++i;
        }
        return lst.toArray(new IContainer[lst.size()]);
    }

    public static final IContainer getContainerInContainer(IPath location, IContainer container, boolean mustExist) {
        IPath projectLocation = container.getLocation();
        if (projectLocation != null && FileUtils.isPrefixOf(projectLocation, location)) {
            int segmentsToRemove = projectLocation.segmentCount();
            IPath removeFirstSegments = location.removeFirstSegments(segmentsToRemove);
            if (removeFirstSegments.segmentCount() == 0) {
                return container;
            }
            IFolder file = container.getFolder(removeFirstSegments);
            if (!mustExist || file.exists()) {
                return file;
            }
        }
        return null;
    }

    protected IContainer getContainerInProject(IPath location, IProject project) {
        IContainer file = GetContainers.getContainerInContainer(location, (IContainer)project, true);
        if (file != null) {
            return file;
        }
        return null;
    }
}

