/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.structure.Tuple;

public class Log {
    private static final Map<Tuple<Integer, String>, Long> lastLoggedTime = new HashMap<Tuple<Integer, String>, Long>();
    private static final int DEBUG_LEVEL = 2;

    public static CoreException log(Throwable e) {
        return Log.log(4, e.getMessage() != null ? e.getMessage() : "No message gotten (null message).", e);
    }

    public static CoreException log(String msg) {
        return Log.log(4, msg, new RuntimeException(msg));
    }

    public static CoreException log(String msg, Throwable e) {
        return Log.log(4, msg, e);
    }

    public static CoreException logWarning(String msg) {
        return Log.log(2, msg, new RuntimeException(msg));
    }

    public static CoreException logInfo(Throwable e) {
        return Log.log(1, e.getMessage(), e);
    }

    public static CoreException logInfo(String msg) {
        return Log.log(1, msg, new RuntimeException(msg));
    }

    public static CoreException logInfo(String msg, Throwable e) {
        return Log.log(1, msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoreException log(int errorLevel, String message, Throwable e) {
        String id;
        if (SharedCorePlugin.inTestMode()) {
            id = "SharedCorePlugin";
        } else {
            SharedCorePlugin plugin = SharedCorePlugin.getDefault();
            id = plugin.getBundle().getSymbolicName();
        }
        Status s = new Status(errorLevel, id, errorLevel, message, errorLevel >= 4 ? e : null);
        CoreException coreException = new CoreException((IStatus)s);
        Tuple<Integer, String> key = new Tuple<Integer, String>(errorLevel, message);
        Map<Tuple<Integer, String>, Long> map = lastLoggedTime;
        synchronized (map) {
            Long lastLoggedMillis = lastLoggedTime.get(key);
            long currentTimeMillis = System.currentTimeMillis();
            if (lastLoggedMillis != null && currentTimeMillis < lastLoggedMillis + 20000L) {
                return coreException;
            }
            lastLoggedTime.put(key, currentTimeMillis);
        }
        try {
            if (SharedCorePlugin.inTestMode()) {
                if (2 <= errorLevel) {
                    System.err.println(message);
                    if (s.getException() != null) {
                        s.getException().printStackTrace();
                    }
                }
            } else {
                SharedCorePlugin plugin = SharedCorePlugin.getDefault();
                plugin.getLog().log((IStatus)s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return coreException;
    }

    public static String getExceptionStr(Exception e) {
        ByteArrayOutputStream str = new ByteArrayOutputStream();
        PrintStream prnt = new PrintStream(str);
        e.printStackTrace(prnt);
        prnt.flush();
        String msg = new String(str.toByteArray());
        return msg;
    }
}

