/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.markers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.utils.ArrayUtils;

public class PyMarkerUtils {
    public static void replaceMarkers(List<MarkerInfo> lst, IResource resource, String markerType, boolean removeUserEditable, IProgressMonitor monitor) {
        ArrayList<HashMap<String, Object>> lMap = new ArrayList<HashMap<String, Object>>(lst.size());
        for (MarkerInfo markerInfo : lst) {
            try {
                HashMap<String, Object> asMap = markerInfo.getAsMap();
                if (asMap == null) continue;
                lMap.add(asMap);
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        PyMarkerUtils.replaceMarkers(lMap.toArray(new Map[lMap.size()]), resource, markerType, removeUserEditable, monitor);
    }

    public static void replaceMarkers(final Map<String, Object>[] lst, final IResource resource, final String markerType, final boolean removeUserEditable, IProgressMonitor monitor) {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (!resource.exists()) {
                    return;
                }
                try {
                    if (removeUserEditable) {
                        resource.deleteMarkers(markerType, true, 0);
                    } else {
                        IMarker[] existingMarkers = resource.findMarkers(markerType, false, 0);
                        existingMarkers = ArrayUtils.filter(existingMarkers, new ICallback<Boolean, IMarker>(){

                            @Override
                            public Boolean call(IMarker marker) {
                                return !marker.getAttribute("userEditable", true);
                            }
                        }).toArray(new IMarker[0]);
                        ResourcesPlugin.getWorkspace().deleteMarkers(existingMarkers);
                    }
                }
                catch (Exception e1) {
                    Log.log(e1);
                }
                try {
                    Map[] mapArray = lst;
                    int n = lst.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Map asMap = mapArray[n2];
                        IMarker marker = resource.createMarker(markerType);
                        marker.setAttributes(asMap);
                        ++n2;
                    }
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
        };
        try {
            resource.getWorkspace().run(r, ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(resource), 1, monitor);
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    public static void removeMarkers(IResource resource, String markerType) {
        if (resource == null) {
            return;
        }
        try {
            resource.deleteMarkers(markerType, false, 0);
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    public static boolean showToUser(IMarker m) {
        Object severity;
        Object msg;
        if (m == null) {
            return false;
        }
        try {
            msg = m.getAttribute("message");
        }
        catch (CoreException e) {
            Log.log(e);
            return false;
        }
        if (msg == null) {
            return false;
        }
        try {
            severity = m.getAttribute("severity");
        }
        catch (CoreException e) {
            Log.log(e);
            return false;
        }
        if (severity == null || !(severity instanceof Integer) | (Integer)severity < 0) {
            return false;
        }
        return !"PyDev breakpoint".equals(msg);
    }

    public static class MarkerInfo {
        public IDocument doc;
        public String message;
        public String markerType;
        public int severity;
        public boolean userEditable;
        public boolean isTransient;
        public int lineStart;
        public int colStart;
        public int lineEnd;
        public int absoluteStart = -1;
        public int absoluteEnd = -1;
        public int colEnd;
        public Map<String, Object> additionalInfo;

        public MarkerInfo(IDocument doc, String message, String markerType, int severity, boolean userEditable, boolean isTransient, int lineStart, int colStart, int lineEnd, int colEnd, Map<String, Object> additionalInfo) {
            this.doc = doc;
            this.message = message;
            this.markerType = markerType;
            this.severity = severity;
            this.userEditable = userEditable;
            this.isTransient = isTransient;
            this.lineStart = lineStart;
            this.colStart = colStart;
            this.lineEnd = lineEnd;
            this.colEnd = colEnd;
            this.additionalInfo = additionalInfo;
        }

        public MarkerInfo(IDocument doc, String message, String markerType, int severity, boolean userEditable, boolean isTransient, int line, int absoluteStart, int absoluteEnd, Map<String, Object> additionalInfo) {
            this.doc = doc;
            this.message = message;
            this.markerType = markerType;
            this.severity = severity;
            this.userEditable = userEditable;
            this.isTransient = isTransient;
            this.lineStart = line;
            this.lineEnd = line;
            this.absoluteStart = absoluteStart;
            this.absoluteEnd = absoluteEnd;
            this.additionalInfo = additionalInfo;
        }

        public HashMap<String, Object> getAsMap() {
            if (this.lineStart < 0) {
                this.lineStart = 0;
            }
            if (this.absoluteStart == -1 || this.absoluteEnd == -1) {
                IRegion start;
                try {
                    start = this.doc.getLineInformation(this.lineStart);
                }
                catch (BadLocationException e) {
                    return null;
                }
                catch (Exception e) {
                    Log.log(4, "Could not get line: " + this.lineStart + " to add message: " + this.message, e);
                    return null;
                }
                try {
                    this.absoluteStart = start.getOffset() + this.colStart;
                    if (this.lineEnd >= 0 && this.colEnd >= 0) {
                        IRegion end = this.doc.getLineInformation(this.lineEnd);
                        this.absoluteEnd = end.getOffset() + this.colEnd;
                    } else {
                        String line = this.doc.get(start.getOffset(), start.getLength());
                        int i = line.indexOf(35);
                        FastStringBuffer buffer = i != -1 ? new FastStringBuffer(line.substring(0, i), 0) : new FastStringBuffer(line, 0);
                        while (buffer.length() > 0 && Character.isWhitespace(buffer.lastChar())) {
                            buffer.deleteLast();
                        }
                        this.absoluteEnd = start.getOffset() + buffer.length();
                    }
                }
                catch (BadLocationException e) {
                    return null;
                }
                catch (Exception e) {
                    Log.log(1, "Problem creating map for:" + this.toString(), e);
                    return null;
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("message", this.message);
            map.put("lineNumber", this.lineStart + 1);
            map.put("charStart", this.absoluteStart);
            map.put("charEnd", this.absoluteEnd);
            map.put("severity", this.severity);
            map.put("userEditable", this.userEditable);
            map.put("transient", this.isTransient);
            if (this.additionalInfo != null) {
                map.putAll(this.additionalInfo);
            }
            return map;
        }

        public String toString() {
            String NL = "\n";
            StringBuffer retValue = new StringBuffer();
            retValue.append("MarkerInfo (\n").append("doc = ").append(this.doc).append("\n").append("message = ").append(this.message).append("\n").append("markerType = ").append(this.markerType).append("\n").append("severity = ").append(this.severity).append("\n").append("userEditable = ").append(this.userEditable).append("\n").append("isTransient = ").append(this.isTransient).append("\n").append("lineStart = ").append(this.lineStart).append("\n").append("colStart = ").append(this.colStart).append("\n").append("lineEnd = ").append(this.lineEnd).append("\n").append("absoluteStart = ").append(this.absoluteStart).append("\n").append("absoluteEnd = ").append(this.absoluteEnd).append("\n").append("colEnd = ").append(this.colEnd).append("\n").append("additionalInfo = ").append(this.additionalInfo).append("\n").append(")");
            return retValue.toString();
        }
    }
}

