/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.model;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class ErrorDescription {
    public String message;
    public int errorLine;
    public int errorStart;
    public int errorEnd;

    public ErrorDescription(String message, int errorLine, int errorStart, int errorEnd) {
        this.message = message;
        this.errorLine = errorLine;
        this.errorStart = errorStart;
        if (errorEnd < errorStart) {
            errorEnd = errorStart;
        }
        this.errorEnd = errorEnd;
    }

    public int getBeginLine(IDocument doc) {
        return this.errorLine;
    }

    public int getBeginColumn(IDocument doc) {
        try {
            IRegion lineInformationOfOffset = doc.getLineInformationOfOffset(this.errorStart);
            return this.errorStart - lineInformationOfOffset.getOffset();
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public int getEndLine(IDocument doc) {
        try {
            return doc.getLineOffset(this.errorEnd);
        }
        catch (BadLocationException badLocationException) {
            return this.errorLine;
        }
    }

    public int getEndCol(IDocument doc) {
        try {
            IRegion lineInformationOfOffset = doc.getLineInformationOfOffset(this.errorEnd);
            return this.errorEnd - lineInformationOfOffset.getOffset();
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }
}

