/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.testutils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.partitioner.IToken;
import org.python.pydev.shared_core.partitioner.ITokenScanner;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class TestUtils {
    private static final Object lock = new Object();

    public static void waitForCondition(ICallback0<String> call) {
        TestUtils.waitUntilCondition(call);
    }

    public static void waitUntilCondition(ICallback0<String> call) {
        TestUtils.waitUntilCondition(call, 5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitUntilCondition(ICallback0<String> call, int timeout) {
        long currentTimeMillis = System.currentTimeMillis();
        String msg = null;
        while (System.currentTimeMillis() < currentTimeMillis + 5000L) {
            msg = call.call();
            if (msg == null) {
                return;
            }
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait(25L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        throw new AssertionError((Object)("Condition not satisfied in 2 seconds. Error message:\n" + msg + "\n"));
    }

    public static String getContentTypesAsStr(IDocument document) throws Exception {
        return TestUtils.listToExpected(TestUtils.getContentTypesAsList(document));
    }

    public static List<String> getContentTypesAsList(IDocument document) throws Exception {
        String last = null;
        ArrayList<String> found = new ArrayList<String>();
        FastStringBuffer buf = new FastStringBuffer();
        int len = document.getLength();
        int i = 0;
        while (i < len) {
            String docContentType = document.getContentType(i);
            if (last == null) {
                buf.append(docContentType + ":" + i + ":");
            } else if (!last.equals(docContentType)) {
                buf.append(i);
                found.add(buf.toString());
                buf.clear();
                buf.append(docContentType + ":" + i + ":");
            }
            last = docContentType;
            ++i;
        }
        found.add(buf.toString());
        return found;
    }

    public static String listToExpected(List expected) {
        String[] f = new String[expected.size()];
        int i = 0;
        while (i < f.length) {
            f[i] = expected.get(i).toString();
            ++i;
        }
        return TestUtils.listToExpected(f);
    }

    public static String listToExpected(String ... expected) {
        FastStringBuffer expectedBuf = new FastStringBuffer();
        int i = 0;
        while (i < expected.length) {
            String expectedToken = expected[i];
            expectedBuf.append("\"" + expectedToken + "\"");
            if (i != expected.length - 1) {
                expectedBuf.append(",\n");
            }
            ++i;
        }
        return expectedBuf.toString();
    }

    public static String scan(ITokenScanner scanner, IDocument document) {
        scanner.setRange(document, 0, document.getLength());
        ArrayList<String> found = new ArrayList<String>();
        FastStringBuffer buf = new FastStringBuffer();
        IToken token = scanner.nextToken();
        while (!token.isEOF()) {
            Object data = token.getData();
            if (data != null) {
                buf.clear();
                buf.append(data.toString()).append(":");
                buf.append(scanner.getTokenOffset()).append(":");
                buf.append(scanner.getTokenLength());
                found.add(buf.toString());
            } else {
                buf.clear();
                buf.append("null").append(":");
                buf.append(scanner.getTokenOffset()).append(":");
                buf.append(scanner.getTokenLength());
                found.add(buf.toString());
            }
            token = scanner.nextToken();
        }
        return TestUtils.listToExpected(found);
    }

    public static String arrayToExpected(byte[] bytes) {
        ArrayList<Byte> lst = new ArrayList<Byte>(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            lst.add(bytes[i]);
            ++i;
        }
        return TestUtils.listToExpected(lst);
    }

    public static String arrayToExpected(int[] ints) {
        ArrayList<Integer> lst = new ArrayList<Integer>(ints.length);
        int i = 0;
        while (i < ints.length) {
            lst.add(ints[i]);
            ++i;
        }
        return TestUtils.listToExpected(lst);
    }
}

