/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ISynchronizable;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.utils.diff_match_patch;

public class DocUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runWithDocumentSynched(IDocument document, ICallback<Object, IDocument> iCallback) {
        Object lockObject = null;
        if (document instanceof ISynchronizable) {
            ISynchronizable sync = (ISynchronizable)document;
            lockObject = sync.getLockObject();
        }
        if (lockObject != null) {
            Object object = lockObject;
            synchronized (object) {
                return iCallback.call(document);
            }
        }
        return iCallback.call(document);
    }

    public static String[] getAllDocumentContentTypes(IDocument document) throws BadPartitioningException {
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 ext = (IDocumentExtension3)document;
            String[] partitionings = ext.getPartitionings();
            HashSet<String> contentTypes = new HashSet<String>();
            contentTypes.add("__dftl_partition_content_type");
            int len = partitionings.length;
            int i = 0;
            while (i < len) {
                String[] legalContentTypes = ext.getLegalContentTypes(partitionings[i]);
                int len2 = legalContentTypes.length;
                int j = 0;
                while (j < len2) {
                    contentTypes.add(legalContentTypes[j]);
                    ++j;
                }
                contentTypes.addAll(Arrays.asList(legalContentTypes));
                ++i;
            }
            return contentTypes.toArray(new String[contentTypes.size()]);
        }
        return document.getLegalContentTypes();
    }

    public static void updateDocRangeWithContents(final IDocument doc, String docContents, String newDocContents) {
        DocUtils.updateDocRangeWithContents(new IDocumentUpdateAPI(){

            @Override
            public void set(String string) {
                doc.set(string);
            }

            @Override
            public void replace(int offset, int length, String text) throws BadLocationException {
                if (length > 0) {
                    FastStringBuffer tempBuf = new FastStringBuffer(text.length());
                    tempBuf.append(text);
                    String curr = doc.get(offset, length);
                    int initialLen = length;
                    int i = 0;
                    while (i < initialLen && tempBuf.length() > 0) {
                        if (curr.charAt(i) != tempBuf.charAt(0)) break;
                        tempBuf.deleteFirst();
                        ++offset;
                        --length;
                        ++i;
                    }
                    curr = doc.get(offset, length);
                    if (tempBuf.length() > 0) {
                        i = curr.length() - 1;
                        while (i >= 0 && tempBuf.length() > 0) {
                            if (tempBuf.lastChar() != curr.charAt(i)) break;
                            tempBuf.deleteLast();
                            --length;
                            --i;
                        }
                    }
                    text = tempBuf.toString();
                }
                doc.replace(offset, length, text);
            }
        }, doc, docContents, newDocContents);
    }

    public static void updateDocRangeWithContents(IDocumentUpdateAPI docUpdateAPI, IDocument docToUpdate, String docContents, String newDocContents) {
        diff_match_patch diff_match_patch2 = new diff_match_patch();
        diff_match_patch2.Diff_Timeout = 0.5f;
        diff_match_patch2.Match_Distance = 200;
        diff_match_patch2.Patch_Margin = (short)10;
        diff_match_patch2.Diff_EditCost = (short)8;
        LinkedList<diff_match_patch.Patch> patches = diff_match_patch2.patch_make(docContents, newDocContents);
        try {
            diff_match_patch2.patch_apply(patches, docContents, docUpdateAPI);
        }
        catch (BadLocationException e) {
            Log.log(e);
        }
    }

    public static class EmptyLinesComputer {
        private final IDocument doc;
        private Map<Integer, Boolean> lineToIsEmpty = new HashMap<Integer, Boolean>();
        private final int numberOfLines;

        public EmptyLinesComputer(IDocument doc) {
            this.doc = doc;
            this.numberOfLines = this.doc.getNumberOfLines();
        }

        public boolean isLineEmpty(int line) {
            Boolean b = this.lineToIsEmpty.get(line);
            if (b == null) {
                String lineContents = TextSelectionUtils.getLine(this.doc, line);
                if (lineContents.trim().isEmpty()) {
                    this.lineToIsEmpty.put(line, true);
                    b = true;
                } else {
                    this.lineToIsEmpty.put(line, false);
                    b = false;
                }
            }
            return b;
        }

        public void addToSetEmptyLinesCloseToLine(Set<Integer> hashSet, int line) {
            if (line < 0) {
                return;
            }
            if (line >= this.numberOfLines) {
                return;
            }
            if (this.isLineEmpty(line)) {
                hashSet.add(line);
            }
            int i = line + 1;
            while (i < this.numberOfLines) {
                if (!this.isLineEmpty(i)) break;
                hashSet.add(i);
                ++i;
            }
            i = line - 1;
            while (i >= 0 && i < this.numberOfLines) {
                if (!this.isLineEmpty(i)) break;
                hashSet.add(i);
                --i;
            }
        }
    }

    public static interface IDocumentUpdateAPI {
        public void replace(int var1, int var2, String var3) throws BadLocationException;

        public void set(String var1) throws BadLocationException;
    }
}

