/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Reflection {
    public static boolean hasAttr(Object o, String attr) {
        try {
            o.getClass().getDeclaredField(attr);
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        return true;
    }

    public static Field getAttrFromClass(Class<? extends Object> c, String attr) {
        try {
            return c.getDeclaredField(attr);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    public static Field getAttr(Object o, String attr) {
        try {
            return o.getClass().getDeclaredField(attr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Field getAttr(Object o, String attr, boolean raiseExceptionIfNotAvailable) {
        try {
            return o.getClass().getDeclaredField(attr);
        }
        catch (Exception e) {
            if (raiseExceptionIfNotAvailable) {
                throw new RuntimeException("Unable to get field: " + attr + " in: " + String.valueOf(o.getClass()), e);
            }
            return null;
        }
    }

    public static Object getAttrObj(Object o, String attr) {
        return Reflection.getAttrObj(o, attr, false);
    }

    public static Object getAttrObj(Object o, String attr, boolean raiseExceptionIfNotAvailable) {
        return Reflection.getAttrObj(o.getClass(), o, attr, raiseExceptionIfNotAvailable);
    }

    public static Object getAttrObj(Class<? extends Object> c, Object o, String attr, boolean raiseExceptionIfNotAvailable) {
        block4: {
            try {
                Field field = Reflection.getAttrFromClass(c, attr);
                if (field != null) {
                    if ((field.getModifiers() & 1) == 0) {
                        field.setAccessible(true);
                    }
                    Object obj = field.get(o);
                    return obj;
                }
            }
            catch (Exception e) {
                if (!raiseExceptionIfNotAvailable) break block4;
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Object invoke(Object obj, String name, Object ... args) {
        Method m = Reflection.findMethod(obj, name, args);
        return Reflection.invoke(obj, m, args);
    }

    public static Object invoke(Object obj, Method m, Object ... args) {
        try {
            return m.invoke(obj, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method findMethod(Object obj, String name, Object ... args) {
        return Reflection.findMethod(obj.getClass(), name, args);
    }

    public static Method findMethod(Class<? extends Object> class_, String name, Object ... args) {
        try {
            Method[] methods;
            Method[] methodArray = methods = class_.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (method.getName().equals(name) && parameterTypes.length == args.length) {
                    int i = 0;
                    Class<?>[] classArray = parameterTypes;
                    int n3 = parameterTypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Class<?> param = classArray[n4];
                        if (param.isInstance(args[i])) {
                            ++i;
                        }
                        ++n4;
                    }
                    return method;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("The method with name: " + name + " was not found (or maybe it was found but the parameters didn't match).");
    }
}

