/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.version;

import java.util.StringTokenizer;

public class Version
implements Comparable<Version> {
    private int major;
    private int minor;
    private int patch;

    public Version(String versionString) {
        StringTokenizer tokenizer = new StringTokenizer(versionString, ".");
        if (tokenizer.hasMoreTokens()) {
            this.major = Integer.parseInt(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            this.minor = Integer.parseInt(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            this.patch = Integer.parseInt(tokenizer.nextToken());
        }
    }

    @Override
    public int compareTo(Version other) {
        if (this.major != other.major) {
            return Integer.compare(this.major, other.major);
        }
        if (this.minor != other.minor) {
            return Integer.compare(this.minor, other.minor);
        }
        return Integer.compare(this.patch, other.patch);
    }

    public boolean isGreaterThanOrEqualTo(Version other) {
        return this.compareTo(other) >= 0;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }
}

