/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0000H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassValueReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "classQualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassifierQualifier;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "original", "<init>", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassifierQualifier;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassValueReceiver;)V", "getClassQualifier", "()Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassifierQualifier;", "getType", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "replaceType", "newType", "getOriginal", "frontend"})
public final class ClassValueReceiver
implements ExpressionReceiver {
    @NotNull
    private final ClassifierQualifier classQualifier;
    @NotNull
    private final KotlinType type;
    @NotNull
    private final ClassValueReceiver original;

    @JvmOverloads
    public ClassValueReceiver(@NotNull ClassifierQualifier classQualifier, @NotNull KotlinType type, @Nullable ClassValueReceiver original) {
        Intrinsics.checkNotNullParameter((Object)classQualifier, (String)"classQualifier");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.classQualifier = classQualifier;
        this.type = type;
        ClassValueReceiver classValueReceiver = original;
        if (classValueReceiver == null) {
            classValueReceiver = this;
        }
        this.original = classValueReceiver;
    }

    public /* synthetic */ ClassValueReceiver(ClassifierQualifier classifierQualifier, KotlinType kotlinType, ClassValueReceiver classValueReceiver, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            classValueReceiver = null;
        }
        this(classifierQualifier, kotlinType, classValueReceiver);
    }

    @NotNull
    public final ClassifierQualifier getClassQualifier() {
        return this.classQualifier;
    }

    @Override
    @NotNull
    public KotlinType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public KtExpression getExpression() {
        return QualifierKt.getExpression(this.classQualifier);
    }

    @Override
    @NotNull
    public ClassValueReceiver replaceType(@NotNull KotlinType newType) {
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        return new ClassValueReceiver(this.classQualifier, newType, this.original);
    }

    @Override
    @NotNull
    public ClassValueReceiver getOriginal() {
        return this.original;
    }

    @JvmOverloads
    public ClassValueReceiver(@NotNull ClassifierQualifier classQualifier, @NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter((Object)classQualifier, (String)"classQualifier");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this(classQualifier, type, null, 4, null);
    }
}

