import os

import gi

import stillCenter.AppGridView as AppGridView
import stillCenter.AppStore as AppStore
import stillCenter.AppListView as AppListView
import stillCenter.constants as constants

gi.require_version("Gtk", "4.0")
gi.require_version("Adw", "1")
from gi.repository import Gtk, Adw


category_pages = []


@Gtk.Template(filename=os.path.join(constants.UI_DIR, "CategoryPage.ui"))
class CategoryPage(Adw.NavigationPage):
    __gtype_name__ = "CategoryPage"

    category_title: Gtk.Label = Gtk.Template.Child()
    subcategory_button_box: Gtk.Box = Gtk.Template.Child()
    app_grid: AppGridView.AppGridView = Gtk.Template.Child()

    main_category_page = True
    stillCenter = None

    def __init__(self, stillCenter):
        super().__init__()
        self.stillCenter = stillCenter
        category_pages.append(self)

    def push_category(self, category, title):
        self.category_title.set_label(title)
        self.app_grid.set_store(self.stillCenter, AppStore.STORE[category])

        # Clear the subcategory buttons
        if self.main_category_page:
            # Clearing Buttons
            child = self.subcategory_button_box.get_first_child()
            while child is not None:
                self.subcategory_button_box.remove(child)
                child = self.subcategory_button_box.get_first_child()

            if category in constants.SUBCATEGORIES.keys():
                self.subcategory_button_box.set_visible(True)
                for subcategory in constants.SUBCATEGORIES[category]:
                    if subcategory[0] in AppStore.STORE.keys():
                        button = Gtk.Button(label=subcategory[1])
                        button.connect("clicked", self.on_subcategory_clicked, subcategory[0], subcategory[1])
                        self.subcategory_button_box.append(button)
            else:
                self.subcategory_button_box.set_visible(False)

        main_view = self.stillCenter.builder.get_object("main_view")
        main_view.push(self)

    def on_subcategory_clicked(self, button, subcategory, title):
        CategoryPage.push_subcategory(self.stillCenter, subcategory, title)

    @classmethod
    def push_subcategory(cls, stillCenter, category, title):
        page = cls(stillCenter)
        page.main_category_page = False
        page.push_category(category, title)
        return page
