/*!
 * Name          : steelseries.js
 * Authors       : Gerrit Grunwald, Mark Crossley
 * Last modified : 20.11.2012
 * Revision      : 0.11.14
 *
 * Copyright (c) 2011, Gerrit Grunwald, Mark Crossley
 * All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted
 *  provided that the following conditions are met:
 *
 *  # Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *  # Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided with the distribution.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 *   BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 *   SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *   OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var steelseries=(function(){var R=Math.PI*0.5,G=Math.PI*2,am=Math.PI,l=Math.PI/180,b=180/Math.PI,A=document,aC="LCDMono2Ultra,sans-serif";var V=function(cO,bt){bt=bt||{};var bP=(undefined===bt.gaugeType?steelseries.GaugeType.TYPE4:bt.gaugeType),bI=(undefined===bt.size?200:bt.size),ce=(undefined===bt.minValue?0:bt.minValue),cb=(undefined===bt.maxValue?(ce+100):bt.maxValue),bW=(undefined===bt.niceScale?true:bt.niceScale),cu=(undefined===bt.threshold?(cb-ce)/2:bt.threshold),co=(undefined===bt.section?null:bt.section),aV=(undefined===bt.area?null:bt.area),bR=(undefined===bt.titleString?"":bt.titleString),a0=(undefined===bt.unitString?"":bt.unitString),cI=(undefined===bt.frameDesign?steelseries.FrameDesign.METAL:bt.frameDesign),cC=(undefined===bt.frameVisible?true:bt.frameVisible),br=(undefined===bt.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bt.backgroundColor),cM=(undefined===bt.backgroundVisible?true:bt.backgroundVisible),cg=(undefined===bt.pointerType?steelseries.PointerType.TYPE1:bt.pointerType),cx=(undefined===bt.pointerColor?steelseries.ColorDef.RED:bt.pointerColor),cG=(undefined===bt.knobType?steelseries.KnobType.STANDARD_KNOB:bt.knobType),bU=(undefined===bt.knobStyle?steelseries.KnobStyle.SILVER:bt.knobStyle),cd=(undefined===bt.lcdColor?steelseries.LcdColor.STANDARD:bt.lcdColor),be=(undefined===bt.lcdVisible?true:bt.lcdVisible),cJ=(undefined===bt.lcdDecimals?2:bt.lcdDecimals),bp=(undefined===bt.digitalFont?false:bt.digitalFont),cr=(undefined===bt.fractionalScaleDecimals?1:bt.fractionalScaleDecimals),bv=(undefined===bt.ledColor?steelseries.LedColor.RED_LED:bt.ledColor),aZ=(undefined===bt.ledVisible?true:bt.ledVisible),cN=(undefined===bt.thresholdVisible?true:bt.thresholdVisible),bH=(undefined===bt.minMeasuredValueVisible?false:bt.minMeasuredValueVisible),bB=(undefined===bt.maxMeasuredValueVisible?false:bt.maxMeasuredValueVisible),cB=(undefined===bt.foregroundType?steelseries.ForegroundType.TYPE1:bt.foregroundType),cj=(undefined===bt.foregroundVisible?true:bt.foregroundVisible),bu=(undefined===bt.labelNumberFormat?steelseries.LabelNumberFormat.STANDARD:bt.labelNumberFormat),cF=(undefined===bt.playAlarm?false:bt.playAlarm),aX=(undefined===bt.alarmSound?false:bt.alarmSound),b0=(undefined===bt.customLayer?null:bt.customLayer),bV=(undefined===bt.tickLabelOrientation?(bP===steelseries.GaugeType.TYPE1?steelseries.TickLabelOrientation.TANGENT:steelseries.TickLabelOrientation.NORMAL):bt.tickLabelOrientation),bN=(undefined===bt.trendVisible?false:bt.trendVisible),b9=(undefined===bt.trendColors?[steelseries.LedColor.RED_LED,steelseries.LedColor.GREEN_LED,steelseries.LedColor.CYAN_LED]:bt.trendColors),a7=(undefined===bt.useOdometer?false:bt.useOdometer),cp=(undefined===bt.odometerParams?{}:bt.odometerParams),a8=(undefined===bt.odometerUseValue?false:bt.odometerUseValue);var aQ;if(cF&&aX!==false){aQ=A.createElement("audio");aQ.setAttribute("src",aX);aQ.setAttribute("preload","auto")}var bJ=ce;var ck=ce;var cq=this;var bh=cb;var bG=ce;var bn=false;var ca=0;var a5;var b6=false;var cv=steelseries.TrendState.OFF;var bF=bI*0.06;var bx=bI*0.29;var bw=bI*0.36;var cw;var cc;var bo;var cl;var ct;var by=cc+(bJ-ce)*ct;var ba=A.getElementById(cO).getContext("2d");ba.clearRect(0,0,ba.canvas.width,ba.canvas.height);ba.canvas.width=bI;ba.canvas.height=bI;var a2=bI;var cH=bI;var bk=a2/2;var bi=cH/2;var aY=0.6*a2;var aW=0.4*cH;var cs=Math.floor(a2/10);var bY=cs+"px sans-serif";var bs=cs+"px "+aC;var bl=cH*0.13;var bg=a2*0.4;var cE=(a2-bg)/2;var cD=cH*0.57;var bC,bA=cH*0.61;var bQ=a2*0.006;var aT=false;var a9=ce;var bq=cb;var a1=cb-ce;var bE=bq-a9;var bT=0;var a6=0;var bM=10;var cA=10;var bc=function bc(){if(bW){a1=g(cb-ce,false);a6=g(a1/(cA-1),true);a9=Math.floor(ce/a6)*a6;bq=Math.ceil(cb/a6)*a6;bT=g(a6/(bM-1),true);ce=a9;cb=bq;bE=cb-ce}else{a1=(cb-ce);a9=ce;bq=cb;bE=a1;a6=g(a1/(cA-1),true);bT=g(a6/(bM-1),true)}switch(bP.type){case"type1":cw=0;cc=am;bo=R;cl=R;ct=cl/bE;break;case"type2":cw=0;cc=am;bo=R;cl=am;ct=cl/bE;break;case"type3":cw=0;cc=R;bo=0;cl=1.5*am;ct=cl/bE;break;case"type4":default:cw=60*l;cc=R+(cw/2);bo=0;cl=G-cw;ct=cl/bE;break}by=cc+(bJ-ce)*ct};var b4=I(bI,bI);var bz=b4.getContext("2d");var bK=I(bI,bI);var bO=bK.getContext("2d");var ch;var bb=I(bI*0.093457,bI*0.093457);var bD=bb.getContext("2d");var bm=I(bI*0.093457,bI*0.093457);var aS=bm.getContext("2d");var b3=bm;var bf=I(Math.ceil(bI*0.028037),Math.ceil(bI*0.028037));var cy=bf.getContext("2d");var bL=I(Math.ceil(bI*0.028037),Math.ceil(bI*0.028037));var aU=bL.getContext("2d");var bS=I(bI,bI);var cL=bS.getContext("2d");var cm=I(bI,bI);var a3=cm.getContext("2d");var bZ,cf,bd,bj;var bX,b2,cz;if(a7&&be){b2=I(10,10);cz=b2.getContext("2d")}var cn=function(cP,cQ){cP.restore();cP.save();cP.textAlign="right";cP.strokeStyle=cd.textColor;cP.fillStyle=cd.textColor;if(cd===steelseries.LcdColor.STANDARD||cd===steelseries.LcdColor.STANDARD_GREEN){cP.shadowColor="gray";cP.shadowOffsetX=a2*0.007;cP.shadowOffsetY=a2*0.007;cP.shadowBlur=a2*0.007}if(bp){cP.font=bs}else{cP.font=bY}cP.fillText(cQ.toFixed(cJ),cE+bg-bg*0.05,cD+bl*0.5+cs*0.38,bg*0.9);cP.restore()};var b5=function(cP){cP.save();if("type1"===bP.type){cP.drawImage(E(Math.ceil(cH*0.037383),steelseries.KnobType.STANDARD_KNOB,bU),a2*0.523364,cH*0.130841)}if("type1"===bP.type||"type2"===bP.type){cP.drawImage(E(Math.ceil(cH*0.037383),steelseries.KnobType.STANDARD_KNOB,bU),a2*0.130841,cH*0.514018)}if("type2"===bP.type||"type3"===bP.type){cP.drawImage(E(Math.ceil(cH*0.037383),steelseries.KnobType.STANDARD_KNOB,bU),a2*0.831775,cH*0.514018)}if("type3"===bP.type){cP.drawImage(E(Math.ceil(cH*0.037383),steelseries.KnobType.STANDARD_KNOB,bU),a2*0.523364,cH*0.831775)}if("type4"===bP.type){cP.drawImage(E(Math.ceil(cH*0.037383),steelseries.KnobType.STANDARD_KNOB,bU),a2*0.336448,cH*0.803738);cP.drawImage(E(Math.ceil(cH*0.037383),steelseries.KnobType.STANDARD_KNOB,bU),a2*0.626168,cH*0.803738)}cP.restore()};var cK=function(){var cR=A.createElement("canvas");cR.width=Math.ceil(bI*0.046728);cR.height=Math.ceil(cR.width*0.9);var cQ=cR.getContext("2d");cQ.save();var cP=cQ.createLinearGradient(0,0.1,0,cR.height*0.9);cP.addColorStop(0,"#520000");cP.addColorStop(0.3,"#fc1d00");cP.addColorStop(0.59,"#fc1d00");cP.addColorStop(1,"#520000");cQ.fillStyle=cP;cQ.beginPath();cQ.moveTo(cR.width*0.5,0.1);cQ.lineTo(cR.width*0.9,cR.height*0.9);cQ.lineTo(cR.width*0.1,cR.height*0.9);cQ.lineTo(cR.width*0.5,0.1);cQ.closePath();cQ.fill();cQ.strokeStyle="#FFFFFF";cQ.stroke();cQ.restore();return cR};var aR=function(cP,cV,cS,cQ,cT){if(cV<ce){cV=ce}else{if(cV>cb){cV=cb}}if(cS<ce){cS=ce}else{if(cS>cb){cS=cb}}if(cV>=cS){return}cP.save();cP.strokeStyle=cQ;cP.fillStyle=cQ;cP.lineWidth=a2*0.035;var cR=(cl/bE*cV-cl/bE*ce);var cU=cR+(cS-cV)/(bE/cl);cP.translate(bk,bi);cP.rotate(cc);cP.beginPath();if(cT){cP.moveTo(0,0);cP.arc(0,0,a2*0.365-cP.lineWidth/2,cR,cU,false)}else{cP.arc(0,0,a2*0.365,cR,cU,false)}if(cT){cP.moveTo(0,0);cP.fill()}else{cP.stroke()}cP.translate(-bk,-bi);cP.restore()};var b1=function(c4,cX){var c5=Math.ceil(a2*0.04),cU=cc,cY=ct*bT,c0,cW=ce,c3=bM-1,cT=a2*0.38,cR=a2*0.35,cZ=a2*0.355,cQ=a2*0.36,c1=a2*0.3,cP=a2*0.1,cS=bM/2,c2=parseFloat(cb.toFixed(2)),cV;br.labelColor.setAlpha(1);c4.save();c4.textAlign="center";c4.textBaseline="middle";c4.font=c5+"px sans-serif";c4.strokeStyle=br.labelColor.getRgbaColor();c4.fillStyle=br.labelColor.getRgbaColor();c4.translate(bk,bi);c4.rotate(cc);if(bP.type==="type1"||bP.type==="type2"){cP=a2*0.035}for(cV=ce;parseFloat(cV.toFixed(2))<=c2;cV+=bT){c0=cY+R;c3++;if(c3===bM){c4.lineWidth=1.5;c4.beginPath();c4.moveTo(cT,0);c4.lineTo(cR,0);c4.closePath();c4.stroke();c4.save();c4.translate(c1,0);switch(bV.type){case"horizontal":c0=-cU;break;case"tangent":c0=(cU<=R+am?am:0);break;case"normal":default:c0=R;break}c4.rotate(c0);switch(cX.format){case"fractional":c4.fillText((cW.toFixed(cr)),0,0,cP);break;case"scientific":c4.fillText((cW.toPrecision(2)),0,0,cP);break;case"standard":default:c4.fillText((cW.toFixed(0)),0,0,cP);break}c4.translate(-c1,0);c4.restore();cW+=a6;c3=0;c4.rotate(cY);cU+=cY;continue}if(0===bM%2&&c3===(cS)){c4.lineWidth=1;c4.beginPath();c4.moveTo(cT,0);c4.lineTo(cZ,0);c4.closePath();c4.stroke()}else{c4.lineWidth=0.5;c4.beginPath();c4.moveTo(cT,0);c4.lineTo(cQ,0);c4.closePath();c4.stroke()}c4.rotate(cY);cU+=cY}c4.translate(-bk,-bi);c4.restore()};var b8=function(cY){cY=cY||{};var cZ=(undefined===cY.frame?false:cY.frame);var cQ=(undefined===cY.background?false:cY.background);var cV=(undefined===cY.led?false:cY.led);var cP=(undefined===cY.pointer?false:cY.pointer);var cX=(undefined===cY.foreground?false:cY.foreground);var cT=(undefined===cY.trend?false:cY.trend);var cR=(undefined===cY.odo?false:cY.odo);aT=true;bc();if(cZ&&cC){d(bz,cI,bk,bi,a2,cH)}if(cQ&&cM){aO(bO,br,bk,bi,a2,cH);P(bO,b0,bk,bi,a2,cH)}if(cV){bD.drawImage(ad(Math.ceil(bI*0.093457),1,bv),0,0);aS.drawImage(ad(Math.ceil(bI*0.093457),0,bv),0,0)}if(bH){cy.drawImage(v(Math.ceil(bI*0.028037),steelseries.ColorDef.BLUE.dark.getRgbaColor(),true,true),0,0)}if(bB){aU.drawImage(v(Math.ceil(bI*0.028037),steelseries.ColorDef.RED.medium.getRgbaColor(),true),0,0)}if(cQ&&cM){b5(bO);if(null!==co&&0<co.length){var cW=co.length;do{cW--;aR(bO,co[cW].start,co[cW].stop,co[cW].color,false)}while(0<cW)}if(null!==aV&&0<aV.length){var cS=aV.length;do{cS--;aR(bO,aV[cS].start,aV[cS].stop,aV[cS].color,true)}while(0<cS)}b1(bO,bu);an(bO,a2,cH,bR,a0,br,true,true)}if(cQ&&cN){bO.save();bO.translate(bk,bi);bO.rotate(cc+(cu-ce)*ct+R);bO.translate(-bk,-bi);bO.drawImage(cK(),a2*0.475,cH*0.13);bO.translate(bk,bi);bO.restore()}if(cQ&&be){if(a7&&cR){bX=new steelseries.Odometer("",{_context:cz,height:bI*0.075,decimals:cp.decimals,digits:(cp.digits===undefined?5:cp.digits),valueForeColor:cp.valueForeColor,valueBackColor:cp.valueBackColor,decimalForeColor:cp.decimalForeColor,decimalBackColor:cp.decimalBackColor,font:cp.font,value:bJ});bC=(a2-b2.width)/2}else{if(!a7){ch=U(bg,bl,cd);bO.drawImage(ch,cE,cD)}}}if(cP){D(cL,a2,cg,cx,br.labelColor)}if(cX&&cj){var cU=(cg.type==="type15"||cg.type==="type16"?false:true);z(a3,cB,a2,cH,cU,cG,bU,bP)}if(cT&&bN){bZ=af(bF,steelseries.TrendState.UP,b9);cf=af(bF,steelseries.TrendState.STEADY,b9);bd=af(bF,steelseries.TrendState.DOWN,b9);bj=af(bF,steelseries.TrendState.OFF,b9)}};var a4=function(cQ){cQ=cQ||{};var cS=(undefined===cQ.frame?false:cQ.frame);var cT=(undefined===cQ.background?false:cQ.background);var cU=(undefined===cQ.led?false:cQ.led);var cR=(undefined===cQ.pointer?false:cQ.pointer);var cP=(undefined===cQ.foreground?false:cQ.foreground);if(cS){b4.width=bI;b4.height=bI;bz=b4.getContext("2d")}if(cT){bK.width=bI;bK.height=bI;bO=bK.getContext("2d")}if(cU){bb.width=Math.ceil(bI*0.093457);bb.height=Math.ceil(bI*0.093457);bD=bb.getContext("2d");bm.width=Math.ceil(bI*0.093457);bm.height=Math.ceil(bI*0.093457);aS=bm.getContext("2d");b3=bm}if(cR){bS.width=bI;bS.height=bI;cL=bS.getContext("2d")}if(cP){cm.width=bI;cm.height=bI;a3=cm.getContext("2d")}};var ci=function(){if(aZ){if(b3===bb){b3=bm}else{b3=bb}if(!b6){b6=true;ab(cq.repaint)}}};var b7=function(cP){if(cP){ca=setInterval(ci,1000)}else{clearInterval(ca)}};this.setValue=function(cQ){cQ=parseFloat(cQ);var cP=cQ<ce?ce:(cQ>cb?cb:cQ);if(bJ!==cP){bJ=cP;if(bJ>bG){bG=bJ}if(bJ<bh){bh=bJ}if(bJ>=cu&&!bn){bn=true;b7(bn);if(cF){aQ.play()}}else{if(bJ<cu){bn=false;b7(bn);if(cF){aQ.pause()}}}this.repaint()}};this.getValue=function(){return bJ};this.setOdoValue=function(cQ){cQ=parseFloat(cQ);var cP=(cQ<0?0:cQ);if(ck!==cP){ck=cP;this.repaint()}};this.getOdoValue=function(){return ck};this.setValueAnimated=function(cR){cR=parseFloat(cR);var cP=(cR<ce?ce:(cR>cb?cb:cR)),cQ=this;if(bJ!==cP){if(undefined!==a5){if(a5.playing){a5.stop()}}a5=new Tween({},"",Tween.regularEaseInOut,bJ,cP,1);a5.onMotionChanged=function(cS){bJ=cS.target._pos;if(bJ>=cu&&!bn){bn=true;b7(bn)}else{if(bJ<cu){bn=false;b7(bn)}}if(bJ>bG){bG=bJ}if(bJ<bh){bh=bJ}if(!b6){b6=true;ab(cQ.repaint)}};a5.start()}};this.resetMinMeasuredValue=function(){bh=bJ;this.repaint()};this.resetMaxMeasuredValue=function(){bG=bJ;this.repaint()};this.setMinMeasuredValueVisible=function(cP){bH=cP;this.repaint()};this.setMaxMeasuredValueVisible=function(cP){bB=cP;this.repaint()};this.setMaxMeasuredValue=function(cQ){var cP=cQ<ce?ce:(cQ>cb?cb:cQ);bG=cP;this.repaint()};this.setMinMeasuredValue=function(cQ){var cP=cQ<ce?ce:(cQ>cb?cb:cQ);bh=cP;this.repaint()};this.setTitleString=function(cP){bR=cP;a4({background:true});b8({background:true});this.repaint()};this.setUnitString=function(cP){a0=cP;a4({background:true});b8({background:true});this.repaint()};this.setMinValue=function(cP){ce=cP;a4({frame:true,background:true});b8({frame:true,background:true});this.repaint()};this.getMinValue=function(){return ce};this.setMaxValue=function(cP){cb=cP;a4({frame:true,background:true});b8({frame:true,background:true});this.repaint()};this.getMaxValue=function(){return cb};this.setThreshold=function(cQ){cQ=parseFloat(cQ);var cP=cQ<ce?ce:(cQ>cb?cb:cQ);cu=cP;a4({background:true});b8({background:true});this.repaint()};this.setArea=function(cP){aV=cP;a4({background:true,foreground:true});b8({background:true,foreground:true});this.repaint()};this.setSection=function(cP){co=cP;a4({background:true,foreground:true});b8({background:true,foreground:true});this.repaint()};this.setThresholdVisible=function(cP){cN=cP;this.repaint()};this.setLcdDecimals=function(cP){cJ=cP;this.repaint()};this.setFrameDesign=function(cP){a4({frame:true});cI=cP;b8({frame:true});this.repaint()};this.setBackgroundColor=function(cP){a4({background:true,pointer:(cg.type==="type2"||cg.type==="type13"?true:false)});br=cP;b8({background:true,pointer:(cg.type==="type2"||cg.type==="type13"?true:false)});this.repaint()};this.setForegroundType=function(cP){a4({foreground:true});cB=cP;b8({foreground:true});this.repaint()};this.setPointerType=function(cP){a4({pointer:true,foreground:true});cg=cP;b8({pointer:true,foreground:true});this.repaint()};this.setPointerColor=function(cP){a4({pointer:true});cx=cP;b8({pointer:true});this.repaint()};this.setLedColor=function(cP){a4({led:true});bv=cP;b8({led:true});this.repaint()};this.setLcdColor=function(cP){cd=cP;a4({background:true});b8({background:true});this.repaint()};this.setTrend=function(cP){cv=cP;this.repaint()};this.setTrendVisible=function(cP){bN=cP;this.repaint()};this.setFractionalScaleDecimals=function(cP){cr=cP;a4({background:true});b8({background:true});this.repaint()};this.setLabelNumberFormat=function(cP){bu=cP;a4({background:true});b8({background:true});this.repaint()};this.repaint=function(){if(!aT){b8({frame:true,background:true,led:true,pointer:true,trend:true,foreground:true,odo:true})}ba.clearRect(0,0,bI,bI);if(cC){ba.drawImage(b4,0,0)}ba.drawImage(bK,0,0);if(be){if(a7){bX.setValue(a8?bJ:ck);ba.drawImage(b2,bC,bA)}else{cn(ba,bJ)}}if(aZ){if(bJ<cu){bn=false;b3=bm}ba.drawImage(b3,aY,aW)}if(bN){switch(cv.state){case"up":ba.drawImage(bZ,bx,bw);break;case"steady":ba.drawImage(cf,bx,bw);break;case"down":ba.drawImage(bd,bx,bw);break;case"off":ba.drawImage(bj,bx,bw);break}}if(bH){ba.save();ba.translate(bk,bi);ba.rotate(cc+R+(bh-ce)*ct);ba.translate(-bk,-bi);ba.drawImage(bf,ba.canvas.width*0.4865,ba.canvas.height*0.105);ba.restore()}if(bB){ba.save();ba.translate(bk,bi);ba.rotate(cc+R+(bG-ce)*ct);ba.translate(-bk,-bi);ba.drawImage(bL,ba.canvas.width*0.4865,ba.canvas.height*0.105);ba.restore()}by=cc+R+(bJ-ce)*ct;ba.save();ba.translate(bk,bi);ba.rotate(by);ba.translate(-bk,-bi);ba.shadowColor="rgba(0, 0, 0, 0.8)";ba.shadowOffsetX=ba.shadowOffsetY=bQ;ba.shadowBlur=bQ*2;ba.drawImage(bS,0,0);ba.restore();if(cj){ba.drawImage(cm,0,0)}b6=false};this.repaint();return this};var x=function(cC,bu){bu=bu||{};var bM=(undefined===bu.gaugeType?steelseries.GaugeType.TYPE4:bu.gaugeType),bG=(undefined===bu.size?200:bu.size),b8=(undefined===bu.minValue?0:bu.minValue),b5=(undefined===bu.maxValue?(b8+100):bu.maxValue),bS=(undefined===bu.niceScale?true:bu.niceScale),cp=(undefined===bu.threshold?(b5-b8)/2:bu.threshold),ck=(undefined===bu.section?null:bu.section),bQ=(undefined===bu.useSectionColors?false:bu.useSectionColors),bN=(undefined===bu.titleString?"":bu.titleString),a1=(undefined===bu.unitString?"":bu.unitString),cz=(undefined===bu.frameDesign?steelseries.FrameDesign.METAL:bu.frameDesign),cu=(undefined===bu.frameVisible?true:bu.frameVisible),bq=(undefined===bu.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bu.backgroundColor),cB=(undefined===bu.backgroundVisible?true:bu.backgroundVisible),bP=(undefined===bu.valueColor?steelseries.ColorDef.RED:bu.valueColor),b7=(undefined===bu.lcdColor?steelseries.LcdColor.STANDARD:bu.lcdColor),bf=(undefined===bu.lcdVisible?true:bu.lcdVisible),cA=(undefined===bu.lcdDecimals?2:bu.lcdDecimals),bo=(undefined===bu.digitalFont?false:bu.digitalFont),cm=(undefined===bu.fractionalScaleDecimals?1:bu.fractionalScaleDecimals),bW=(undefined===bu.customLayer?null:bu.customLayer),bw=(undefined===bu.ledColor?steelseries.LedColor.RED_LED:bu.ledColor),a0=(undefined===bu.ledVisible?true:bu.ledVisible),bv=(undefined===bu.labelNumberFormat?steelseries.LabelNumberFormat.STANDARD:bu.labelNumberFormat),ct=(undefined===bu.foregroundType?steelseries.ForegroundType.TYPE1:bu.foregroundType),cd=(undefined===bu.foregroundVisible?true:bu.foregroundVisible),cx=(undefined===bu.playAlarm?false:bu.playAlarm),aZ=(undefined===bu.alarmSound?false:bu.alarmSound),a2=(undefined===bu.valueGradient?null:bu.valueGradient),a9=(undefined===bu.useValueGradient?false:bu.useValueGradient),bR=(undefined===bu.tickLabelOrientation?(bM===steelseries.GaugeType.TYPE1?steelseries.TickLabelOrientation.TANGENT:steelseries.TickLabelOrientation.NORMAL):bu.tickLabelOrientation),bK=(undefined===bu.trendVisible?false:bu.trendVisible),b3=(undefined===bu.trendColors?[steelseries.LedColor.RED_LED,steelseries.LedColor.GREEN_LED,steelseries.LedColor.CYAN_LED]:bu.trendColors);if(cx&&aZ!==false){var aT=A.createElement("audio");aT.setAttribute("src",aZ);aT.setAttribute("preload","auto")}var bH=b8;var bE=b5-b8;var bm=false;var b4=0;var a7;var cl=this;var b0=false;var cr;var b6;var bA;var bn;var cg;var aW;var co;var bz;var bD=[];var aS=false;var aX=false;var bb=A.getElementById(cC).getContext("2d");bb.clearRect(0,0,bb.canvas.width,bb.canvas.height);bb.canvas.width=bG;bb.canvas.height=bG;var a4=bG;var cy=bG;var bj=a4/2;var bg=cy/2;var cn=Math.floor(a4/10);var bT=cn+"px sans-serif";var bs=cn+"px "+aC;var bk=cy*0.13;var bh=a4*0.4;var cw=(a4-bh)/2;var cv=cy/2-bk/2;var ce=a4*0.116822;var cb=a4*0.485981;var cf=Math.ceil(bG*0.093457);var aR=a4*0.53;var aQ=cy*0.61;var cq=steelseries.TrendState.OFF;var bF=bG*0.06;var by=bG*0.38;var bx=bG*0.57;switch(bM.type){case"type1":cr=0;b6=am;bA=0;bn=R;cg=R;aW=cg*b;co=cg/bE;break;case"type2":cr=0;b6=am;bA=0;bn=R;cg=am;aW=cg*b;co=cg/bE;break;case"type3":cr=0;b6=R;bA=-R;bn=0;cg=1.5*am;aW=cg*b;co=cg/bE;break;case"type4":default:cr=60*l;b6=R+(cr/2);bA=-G/6;bn=0;cg=G-cr;aW=cg*b;co=cg/bE;break}var bZ=I(bG,bG);var bB=bZ.getContext("2d");var bI=I(bG,bG);var bL=bI.getContext("2d");var ca;var cj=I(Math.ceil(bG*0.060747),Math.ceil(bG*0.023364));var aY=cj.getContext("2d");var bd=I(cf,cf);var bC=bd.getContext("2d");var bl=I(cf,cf);var aV=bl.getContext("2d");var bY=bl;var bt;var ch=I(bG,bG);var a5=ch.getContext("2d");var bV,b9,be,bi;var aU=false;var ba=b8;var bp=b5;var a3=b5-b8;bE=bp-ba;var bO=0;var a8=0;var bJ=10;var cs=10;var bc=function bc(){if(bS){a3=g(b5-b8,false);a8=g(a3/(cs-1),true);ba=Math.floor(b8/a8)*a8;bp=Math.ceil(b5/a8)*a8;bO=g(a8/(bJ-1),true);b8=ba;b5=bp;bE=b5-b8}else{a3=(b5-b8);ba=b8;bp=b5;bE=a3;a8=g(a3/(cs-1),true);bO=g(a8/(bJ-1),true)}switch(bM.type){case"type1":cr=0;b6=am;bn=R;cg=R;co=cg/bE;break;case"type2":cr=0;b6=am;bn=R;cg=am;co=cg/bE;break;case"type3":cr=0;b6=R;bn=0;cg=1.5*am;co=cg/bE;break;case"type4":default:cr=60*l;b6=R+(cr/2);bn=0;cg=G-cr;co=cg/bE;break}bz=b6+(bH-b8)*co};var b2=function(cH){cH=cH||{};var cI=(undefined===cH.frame?false:cH.frame);var cK=(undefined===cH.background?false:cH.background);var cG=(undefined===cH.led?false:cH.led);var cF=(undefined===cH.value?false:cH.value);var cD=(undefined===cH.foreground?false:cH.foreground);var cE=(undefined===cH.trend?false:cH.trend);aU=true;bc();if(cI&&cu){d(bB,cz,bj,bg,a4,cy)}if(cK&&cB){aO(bL,bq,bj,bg,a4,cy);P(bL,bW,bj,bg,a4,cy)}if(cG){bC.drawImage(ad(cf,1,bw),0,0);aV.drawImage(ad(cf,0,bw),0,0);bt=bL.getImageData(aR,aQ,cf,cf)}if(cK){bU(bL)}if(cK&&cB){bX(bL,bv);an(bL,a4,cy,bN,a1,bq,true,true)}if(cK&&bf){ca=U(bh,bk,b7);bL.drawImage(ca,cw,cv)}aS=false;if(bQ&&null!==ck&&0<ck.length){aS=true;var cJ=ck.length;bD=[];do{cJ--;bD.push({start:(((ck[cJ].start+Math.abs(b8))/(b5-b8))*aW),stop:(((ck[cJ].stop+Math.abs(b8))/(b5-b8))*aW),color:r(ck[cJ].color)})}while(0<cJ)}aX=false;if(a9&&a2!==null){aS=false;aX=true}if(cF){br(aY,bP)}if(cD&&cd){z(a5,ct,a4,cy,false)}if(cE&&bK){bV=af(bF,steelseries.TrendState.UP,b3);b9=af(bF,steelseries.TrendState.STEADY,b3);be=af(bF,steelseries.TrendState.DOWN,b3);bi=af(bF,steelseries.TrendState.OFF,b3)}};var a6=function(cF){cF=cF||{};var cG=(undefined===cF.frame?false:cF.frame);var cH=(undefined===cF.background?false:cF.background);var cI=(undefined===cF.led?false:cF.led);var cE=(undefined===cF.value?false:cF.value);var cD=(undefined===cF.foreground?false:cF.foreground);if(cG){bZ.width=bG;bZ.height=bG;bB=bZ.getContext("2d")}if(cH){bI.width=bG;bI.height=bG;bL=bI.getContext("2d")}if(cE){cj.width=Math.ceil(bG*0.060747);cj.height=Math.ceil(bG*0.023364);aY=cj.getContext("2d")}if(cI){bd.width=Math.ceil(bG*0.093457);bd.height=Math.ceil(bG*0.093457);bC=bd.getContext("2d");bl.width=Math.ceil(bG*0.093457);bl.height=Math.ceil(bG*0.093457);aV=bl.getContext("2d");bY=bl}if(cD){ch.width=bG;ch.height=bG;a5=ch.getContext("2d")}};var bU=function(cE){cE.save();cE.save();cE.lineWidth=bG*0.085;cE.beginPath();cE.translate(bj,bg);cE.rotate(b6-4*l);cE.translate(-bj,-bg);cE.arc(bj,bg,a4*0.35514,0,cg+8*l,false);cE.rotate(-b6);var cD=cE.createLinearGradient(0,0.107476*cy,0,0.897195*cy);cD.addColorStop(0,"#000000");cD.addColorStop(0.22,"#333333");cD.addColorStop(0.76,"#333333");cD.addColorStop(1,"#cccccc");cE.strokeStyle=cD;cE.stroke();cE.restore();cE.save();cE.lineWidth=bG*0.075;cE.beginPath();cE.translate(bj,bg);cE.rotate(b6-4*l);cE.translate(-bj,-bg);cE.arc(bj,bg,a4*0.35514,0,cg+8*l,false);cE.rotate(-b6);var cG=cE.createLinearGradient(0,0.112149*cy,0,0.892523*cy);cG.addColorStop(0,"#111111");cG.addColorStop(1,"#333333");cE.strokeStyle=cG;cE.stroke();cE.restore();var cJ=(a4*0.116822+a4*0.060747)/2;var cH=(a4*0.485981+a4*0.023364)/2;var cF=cE.createRadialGradient(cJ,cH,0,cJ,cH,0.030373*a4);cF.addColorStop(0,"#3c3c3c");cF.addColorStop(1,"#323232");var cI=0;for(cI=0;cI<=aW;cI+=5){cE.save();cE.translate(bj,bg);cE.rotate((cI*l)+bA);cE.translate(-bj,-bg);cE.beginPath();cE.rect(a4*0.116822,a4*0.485981,a4*0.060747,a4*0.023364);cE.closePath();cE.fillStyle=cF;cE.fill();cE.restore()}cE.restore()};var br=function(cD,cE){cD.save();cD.beginPath();cD.rect(0,0,cD.canvas.width,cD.canvas.height);cD.closePath();var cH=(cD.canvas.width/2);var cG=(cD.canvas.height/2);var cF=bb.createRadialGradient(cH,cG,0,cH,cG,cD.canvas.width/2);cF.addColorStop(0,cE.light.getRgbaColor());cF.addColorStop(1,cE.dark.getRgbaColor());cD.fillStyle=cF;cD.fill();cD.restore()};var ci=function(cD,cE){cD.save();cD.textAlign="right";cD.strokeStyle=b7.textColor;cD.fillStyle=b7.textColor;if(b7===steelseries.LcdColor.STANDARD||b7===steelseries.LcdColor.STANDARD_GREEN){cD.shadowColor="gray";cD.shadowOffsetX=a4*0.007;cD.shadowOffsetY=a4*0.007;cD.shadowBlur=a4*0.007}if(bo){cD.font=bs}else{cD.font=bT}cD.fillText(cE.toFixed(cA),cw+bh-bh*0.05,cv+bk*0.5+cn*0.38,bh*0.9);cD.restore()};var bX=function(cN,cH){var cE=b6,cI=co*bO,cJ,cO=Math.ceil(a4*0.04),cG=b8,cM=bJ-1,cK=a4*0.28,cD=a4*0.1,cL=parseFloat(b5.toFixed(2)),cF;bq.labelColor.setAlpha(1);cN.save();cN.textAlign="center";cN.textBaseline="middle";cN.font=cO+"px sans-serif";cN.strokeStyle=bq.labelColor.getRgbaColor();cN.fillStyle=bq.labelColor.getRgbaColor();cN.translate(bj,bg);cN.rotate(b6);if(bM.type==="type1"||bM.type==="type2"){cD=a4*0.0375}for(cF=b8;parseFloat(cF.toFixed(2))<=cL;cF+=bO){cJ=+cI+R;cM++;if(cM===bJ){cN.save();cN.translate(cK,0);switch(bR.type){case"horizontal":cJ=-cE;break;case"tangent":cJ=(cE<=R+am?am:0);break;case"normal":default:cJ=R;break}cN.rotate(cJ);switch(cH.format){case"fractional":cN.fillText((cG.toFixed(cm)),0,0,cD);break;case"scientific":cN.fillText((cG.toPrecision(2)),0,0,cD);break;case"standard":default:cN.fillText((cG.toFixed(0)),0,0,cD);break}cN.translate(-cK,0);cN.restore();cG+=a8;cM=0;cN.rotate(cI);cE+=cI;continue}cN.rotate(cI);cE+=cI}cN.translate(-bj,-bg);cN.restore()};var b1=function(cD){if(cD){b4=setInterval(cc,1000)}else{clearInterval(b4)}};var cc=function(){if(a0){if(bY===bd){bY=bl}else{bY=bd}if(!b0){b0=true;ab(cl.repaint)}}};this.setValue=function(cE){cE=parseFloat(cE);var cD=(cE<b8?b8:(cE>b5?b5:cE));if(bH!==cD){bH=cD;if(bH>=cp&&!bm){bm=true;b1(bm);if(cx){aT.play()}}else{if(bH<cp){bm=false;b1(bm);if(cx){aT.pause()}}}this.repaint()}};this.getValue=function(){return bH};this.setValueAnimated=function(cF){cF=parseFloat(cF);var cD=(cF<b8?b8:(cF>b5?b5:cF)),cE=this;if(bH!==cD){if(undefined!==a7){if(a7.playing){a7.stop()}}a7=new Tween({},"",Tween.regularEaseInOut,bH,cD,1);a7.onMotionChanged=function(cG){bH=cG.target._pos;if(bH>=cp&&!bm){bm=true;b1(bm)}else{if(bH<cp){bm=false;b1(bm)}}if(!b0){b0=true;ab(cE.repaint)}};a7.start()}};this.setFrameDesign=function(cD){a6({frame:true});cz=cD;b2({frame:true});this.repaint()};this.setBackgroundColor=function(cD){a6({background:true,led:true});bq=cD;b2({background:true,led:true});this.repaint()};this.setForegroundType=function(cD){a6({foreground:true});ct=cD;b2({foreground:true});this.repaint()};this.setValueColor=function(cD){a6({value:true});bP=cD;b2({value:true});this.repaint()};this.setLedColor=function(cD){a6({led:true});bw=cD;b2({led:true});this.repaint()};this.setLcdColor=function(cD){b7=cD;a6({background:true});b2({background:true});this.repaint()};this.setLcdDecimals=function(cD){cA=cD;this.repaint()};this.setSection=function(cD){ck=cD;b2();this.repaint()};this.setSectionActive=function(cD){bQ=cD;b2();this.repaint()};this.setGradient=function(cD){a2=cD;b2();this.repaint()};this.setGradientActive=function(cD){a9=cD;b2();this.repaint()};this.setMinValue=function(cD){b8=cD;a6({background:true});b2({background:true});this.repaint()};this.getMinValue=function(){return b8};this.setMaxValue=function(cD){b5=cD;a6({background:true});b2({background:true});this.repaint()};this.getMaxValue=function(){return b5};this.setThreshold=function(cE){cE=parseFloat(cE);var cD=cE<b8?b8:(cE>b5?b5:cE);cp=cD;a6({background:true});b2({background:true});this.repaint()};this.setTitleString=function(cD){bN=cD;a6({background:true});b2({background:true});this.repaint()};this.setUnitString=function(cD){a1=cD;a6({background:true});b2({background:true});this.repaint()};this.setTrend=function(cD){cq=cD;this.repaint()};this.setTrendVisible=function(cD){bK=cD;this.repaint()};this.setFractionalScaleDecimals=function(cD){cm=cD;a6({background:true});b2({background:true});this.repaint()};this.setLabelNumberFormat=function(cD){bv=cD;a6({background:true});b2({background:true});this.repaint()};this.repaint=function(){var cK=((bH+Math.abs(b8))/(b5-b8))*aW,cD,cI=bP,cJ,cE,cH,cG,cF;if(!aU){b2({frame:true,background:true,led:true,value:true,trend:true,foreground:true})}bb.clearRect(0,0,bG,bG);if(cu){bb.drawImage(bZ,0,0)}bb.drawImage(bI,0,0);for(cJ=0;cJ<=cK;cJ+=5){cD=bP;if(aX){cH=b8+(cJ/aW)*(b5-b8);cG=a2.getEnd()-a2.getStart();cF=cH/cG;cF=Math.max(Math.min(cF,1),0);cD=r(a2.getColorAt(cF).getRgbaColor())}else{if(aS){for(cE=0;cE<bD.length;cE++){if(cJ>=bD[cE].start&&cJ<bD[cE].stop){cD=bD[cE].color;break}}}}if(cI.medium.getHexColor()!==cD.medium.getHexColor()){br(aY,cD);cI=cD}bb.save();bb.translate(bj,bg);bb.rotate((cJ*l)+bA);bb.translate(-bj,-bg);bb.drawImage(cj,ce,cb);bb.restore()}if(bf){ci(bb,bH)}if(a0){if(bH<cp){bm=false;bY=bl}bb.drawImage(bY,aR,aQ)}if(bK){switch(cq.state){case"up":bb.drawImage(bV,by,bx);break;case"steady":bb.drawImage(b9,by,bx);break;case"down":bb.drawImage(be,by,bx);break;case"off":bb.drawImage(bi,by,bx);break}}if(cd){bb.drawImage(ch,0,0)}b0=false};this.repaint();return this};var ac=function(ci,bk){bk=bk||{};var bY=(undefined===bk.orientation?steelseries.Orientation.NORTH:bk.orientation),bu=(undefined===bk.size?200:bk.size),bS=(undefined===bk.minValue?0:bk.minValue),bQ=(undefined===bk.maxValue?(bS+100):bk.maxValue),bG=(undefined===bk.niceScale?true:bk.niceScale),b2=(undefined===bk.threshold?(bQ-bS)/2:bk.threshold),bZ=(undefined===bk.section?null:bk.section),aV=(undefined===bk.area?null:bk.area),bB=(undefined===bk.titleString?"":bk.titleString),a0=(undefined===bk.unitString?"":bk.unitString),cd=(undefined===bk.frameDesign?steelseries.FrameDesign.METAL:bk.frameDesign),b7=(undefined===bk.frameVisible?true:bk.frameVisible),bj=(undefined===bk.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bk.backgroundColor),cg=(undefined===bk.backgroundVisible?true:bk.backgroundVisible),bT=(undefined===bk.pointerType?steelseries.PointerType.TYPE1:bk.pointerType),b4=(undefined===bk.pointerColor?steelseries.ColorDef.RED:bk.pointerColor),ca=(undefined===bk.knobType?steelseries.KnobType.STANDARD_KNOB:bk.knobType),bF=(undefined===bk.knobStyle?steelseries.KnobStyle.SILVER:bk.knobStyle),bm=(undefined===bk.ledColor?steelseries.LedColor.RED_LED:bk.ledColor),aZ=(undefined===bk.ledVisible?true:bk.ledVisible),ch=(undefined===bk.thresholdVisible?true:bk.thresholdVisible),bt=(undefined===bk.minMeasuredValueVisible?false:bk.minMeasuredValueVisible),bp=(undefined===bk.maxMeasuredValueVisible?false:bk.maxMeasuredValueVisible),b6=(undefined===bk.foregroundType?steelseries.ForegroundType.TYPE1:bk.foregroundType),bV=(undefined===bk.foregroundVisible?true:bk.foregroundVisible),bl=(undefined===bk.labelNumberFormat?steelseries.LabelNumberFormat.STANDARD:bk.labelNumberFormat),b9=(undefined===bk.playAlarm?false:bk.playAlarm),aX=(undefined===bk.alarmSound?false:bk.alarmSound);if(b9&&aX!==false){var aQ=A.createElement("audio");aQ.setAttribute("src",aX);aQ.setAttribute("preload","auto")}var bA=steelseries.GaugeType.TYPE5;var b0=this;var bv=bS;var bc=bQ;var bs=bS;var a1=bu;var cc=bu;var bg=false;var bO=0;var a5;var bL=false;var a7=bS;var bi=bQ;var a2=bQ-bS;var br=bi-a7;var bE=0;var a6=0;var by=10;var b8=10;var b3=0;var bR=1.25*am;var bh=1.25*am;var bW=R;var b1=bW/br;var bC=a1*0.006;var cb=a1*1.17/2;var aT=false;var bn=bR+(bv-bS)*b1;var a8=A.getElementById(ci).getContext("2d");a8.clearRect(0,0,a8.canvas.width,a8.canvas.height);a8.canvas.width=bu;a8.canvas.height=bu;var be=a1/2;var bd=cc*0.733644;var aY=0.455*a1;var aW=0.51*cc;var a9=function a9(){if(bG){a2=g(bQ-bS,false);a6=g(a2/(b8-1),true);a7=Math.floor(bS/a6)*a6;bi=Math.ceil(bQ/a6)*a6;bE=g(a6/(by-1),true);bS=a7;bQ=bi;br=bQ-bS}else{a2=(bQ-bS);a7=bS;bi=bQ;br=a2;bE=1;a6=10}b3=0;bR=1.25*am;bh=1.25*am;bW=R;b1=bW/br;bn=bR+(bv-bS)*b1};var bJ=I(bu,bu);var bo=bJ.getContext("2d");var bw=I(bu,bu);var bz=bw.getContext("2d");var ba=I(bu*0.093457,bu*0.093457);var bq=ba.getContext("2d");var bf=I(bu*0.093457,bu*0.093457);var aS=bf.getContext("2d");var bI=bf;var bb=I(Math.ceil(bu*0.028037),Math.ceil(bu*0.028037));var b5=bb.getContext("2d");var bx=I(Math.ceil(bu*0.028037),Math.ceil(bu*0.028037));var aU=bx.getContext("2d");var bD=I(bu,bu);var cf=bD.getContext("2d");var bX=I(bu,bu);var a3=bX.getContext("2d");var bK=function(cj){if("type5"===bA.type){cj.save();if(bY.type==="west"){cj.drawImage(E(Math.ceil(cc*0.037383),steelseries.KnobType.STANDARD_KNOB,bF),a1*0.44,cc*0.8);cj.drawImage(E(Math.ceil(cc*0.037383),steelseries.KnobType.STANDARD_KNOB,bF),a1*0.44,cc*0.16)}else{cj.drawImage(E(Math.ceil(cc*0.037383),steelseries.KnobType.STANDARD_KNOB,bF),a1*0.2-cc*0.037383,cc*0.446666);cj.drawImage(E(Math.ceil(cc*0.037383),steelseries.KnobType.STANDARD_KNOB,bF),a1*0.8,cc*0.446666)}cj.restore()}};var ce=function(){var cl=A.createElement("canvas");cl.width=Math.ceil(bu*0.046728);cl.height=Math.ceil(cl.width*0.9);var ck=cl.getContext("2d");ck.save();var cj=ck.createLinearGradient(0,0.1,0,cl.height*0.9);cj.addColorStop(0,"#520000");cj.addColorStop(0.3,"#fc1d00");cj.addColorStop(0.59,"#fc1d00");cj.addColorStop(1,"#520000");ck.fillStyle=cj;ck.beginPath();ck.moveTo(cl.width*0.5,0.1);ck.lineTo(cl.width*0.9,cl.height*0.9);ck.lineTo(cl.width*0.1,cl.height*0.9);ck.lineTo(cl.width*0.5,0.1);ck.closePath();ck.fill();ck.strokeStyle="#FFFFFF";ck.stroke();ck.restore();return cl};var aR=function(cj,cp,cm,ck,cn){cj.save();cj.strokeStyle=ck;cj.fillStyle=ck;cj.lineWidth=a1*0.035;var cl=(bW/br*cp-bW/br*bS);var co=cl+(cm-cp)/(br/bW);cj.translate(be,bd);cj.rotate(bR);cj.beginPath();if(cn){cj.moveTo(0,0);cj.arc(0,0,a1*0.365-cj.lineWidth/2,cl,co,false)}else{cj.arc(0,0,a1*0.365,cl,co,false)}if(cn){cj.moveTo(0,0);cj.fill()}else{cj.stroke()}cj.translate(-be,-bd);cj.restore()};var bP=function(cj){var cl,ck;cj.save();cj.textAlign="left";cj.textBaseline="middle";cj.strokeStyle=bj.labelColor.getRgbaColor();cj.fillStyle=bj.labelColor.getRgbaColor();cj.font=0.046728*a1+"px sans-serif";cl=cj.measureText(bB).width;cj.fillText(bB,(a1-cl)/2,cc*0.4,a1*0.3);ck=cj.measureText(a0).width;cj.fillText(a0,(a1-ck)/2,cc*0.47,a1*0.2);cj.restore()};var bH=function(cx,cq){bj.labelColor.setAlpha(1);cx.save();if(steelseries.Orientation.WEST===bY){cx.translate(be,be);cx.rotate(-R);cx.translate(-be,-be)}cx.textAlign="center";cx.textBaseline="middle";var cy=Math.ceil(a1*0.04);cx.font=cy+"px sans-serif";cx.strokeStyle=bj.labelColor.getRgbaColor();cx.fillStyle=bj.labelColor.getRgbaColor();cx.translate(be,bd);cx.rotate(bR);var cr=b1*bE;var ct;var cp=bS;var cw=by-1;var cn=a1*0.44;var cl=a1*0.41;var cs=a1*0.415;var ck=a1*0.42;var cu=a1*0.48;var cj=a1*0.0375;var cm=by/2;var cv=parseFloat(bQ.toFixed(2));var co;for(co=bS;parseFloat(co.toFixed(2))<=cv;co+=bE){ct=+cr+R;cw++;if(cw===by){cx.lineWidth=1.5;cx.beginPath();cx.moveTo(cn,0);cx.lineTo(cl,0);cx.closePath();cx.stroke();cx.save();cx.translate(cu,0);cx.rotate(ct);switch(cq.format){case"fractional":cx.fillText((cp.toFixed(2)),0,0,cj);break;case"scientific":cx.fillText((cp.toPrecision(2)),0,0,cj);break;case"standard":default:cx.fillText((cp.toFixed(0)),0,0,cj);break}cx.translate(-cu,0);cx.restore();cp+=a6;cw=0;cx.rotate(cr);continue}if(0===by%2&&cw===(cm)){cx.lineWidth=1;cx.beginPath();cx.moveTo(cn,0);cx.lineTo(cs,0);cx.closePath();cx.stroke()}else{cx.lineWidth=0.5;cx.beginPath();cx.moveTo(cn,0);cx.lineTo(ck,0);cx.closePath();cx.stroke()}cx.rotate(cr)}cx.translate(-be,-bd);cx.restore()};var bN=function(cq){cq=cq||{};var cr=(undefined===cq.frame?false:cq.frame);var ck=(undefined===cq.background?false:cq.background);var cn=(undefined===cq.led?false:cq.led);var cj=(undefined===cq.pointer?false:cq.pointer);var cp=(undefined===cq.foreground?false:cq.foreground);aT=true;a9();if(cr&&b7){d(bo,cd,be,bu/2,a1,cc)}if(ck&&cg){aO(bz,bj,be,bu/2,a1,cc)}if(cn){bq.drawImage(ad(Math.ceil(bu*0.093457),1,bm),0,0);aS.drawImage(ad(Math.ceil(bu*0.093457),0,bm),0,0)}if(bt){b5.drawImage(v(Math.ceil(bu*0.028037),steelseries.ColorDef.BLUE.dark.getRgbaColor(),true,true),0,0);b5.restore()}if(bp){aU.drawImage(v(Math.ceil(bu*0.028037),steelseries.ColorDef.RED.medium.getRgbaColor(),true),0,0);aU.restore()}if(ck&&cg){bK(bz);if(null!==bZ&&0<bZ.length){bz.save();if(steelseries.Orientation.WEST===bY){bz.translate(be,be);bz.rotate(-R);bz.translate(-be,-be)}var co=bZ.length;do{co--;aR(bz,bZ[co].start,bZ[co].stop,bZ[co].color,false)}while(0<co);bz.restore()}if(null!==aV&&0<aV.length){if(steelseries.Orientation.WEST===bY){bz.translate(be,be);bz.rotate(-R);bz.translate(-be,-be)}var cl=aV.length;do{cl--;aR(bz,aV[cl].start,aV[cl].stop,aV[cl].color,true)}while(0<cl);bz.restore()}bH(bz,bl);bP(bz)}if(ch){bz.save();if(steelseries.Orientation.WEST===bY){bz.translate(be,be);bz.rotate(-R);bz.translate(-be,-be)}bz.translate(be,bd);bz.rotate(bR+(b2-bS)*b1+R);bz.translate(-be,-bd);bz.drawImage(ce(),a1*0.475,cc*0.32);bz.restore()}if(cj){D(cf,a1*1.17,bT,b4,bj.labelColor)}if(cp&&bV){var cm=(bT.type==="type15"||bT.type==="type16"?false:true);z(a3,b6,a1,cc,cm,ca,bF,bA,bY)}};var a4=function(ck){ck=ck||{};var cm=(undefined===ck.frame?false:ck.frame);var cn=(undefined===ck.background?false:ck.background);var co=(undefined===ck.led?false:ck.led);var cl=(undefined===ck.pointer?false:ck.pointer);var cj=(undefined===ck.foreground?false:ck.foreground);if(cm){bJ.width=bu;bJ.height=bu;bo=bJ.getContext("2d")}if(cn){bw.width=bu;bw.height=bu;bz=bw.getContext("2d")}if(co){ba.width=Math.ceil(bu*0.093457);ba.height=Math.ceil(bu*0.093457);bq=ba.getContext("2d");bf.width=Math.ceil(bu*0.093457);bf.height=Math.ceil(bu*0.093457);aS=bf.getContext("2d");bI=bf}if(cl){bD.width=bu;bD.height=bu;cf=bD.getContext("2d")}if(cj){bX.width=bu;bX.height=bu;a3=bX.getContext("2d")}};var bM=function(cj){if(cj){bO=setInterval(bU,1000)}else{clearInterval(bO)}};var bU=function(){if(aZ){if(bI===ba){bI=bf}else{bI=ba}if(!bL){bL=true;ab(b0.repaint)}}};this.setValue=function(ck){ck=parseFloat(ck);var cj=(ck<bS?bS:(ck>bQ?bQ:ck));if(bv!==cj){bv=cj;if(bv>bs){bs=bv}if(bv<bc){bc=bv}if(bv>=b2&&!bg){bg=true;bM(bg);if(b9){aQ.play()}}else{if(bv<b2){bg=false;bM(bg);if(b9){aQ.pause()}}}this.repaint()}};this.getValue=function(){return bv};this.setValueAnimated=function(cl){cl=parseFloat(cl);var cj=(cl<bS?bS:(cl>bQ?bQ:cl)),ck=this;if(bv!==cj){if(undefined!==a5){if(a5.playing){a5.stop()}}a5=new Tween({},"",Tween.regularEaseInOut,bv,cj,1);a5.onMotionChanged=function(cm){bv=cm.target._pos;if(bv>=b2&&!bg){bg=true;bM(bg)}else{if(bv<b2){bg=false;bM(bg)}}if(bv>bs){bs=bv}if(bv<bc){bc=bv}if(!bL){bL=true;ab(ck.repaint)}};a5.start()}};this.resetMinMeasuredValue=function(){bc=bv;this.repaint()};this.resetMaxMeasuredValue=function(){bs=bv;this.repaint()};this.setMinMeasuredValueVisible=function(cj){bt=cj;this.repaint()};this.setMaxMeasuredValueVisible=function(cj){bp=cj;this.repaint()};this.setThresholdVisible=function(cj){ch=cj;this.repaint()};this.setFrameDesign=function(cj){a4({frame:true});cd=cj;bN({frame:true});this.repaint()};this.setBackgroundColor=function(cj){a4({background:true,pointer:(bT.type==="type2"||bT.type==="type13"?true:false)});bj=cj;bN({background:true,pointer:(bT.type==="type2"||bT.type==="type13"?true:false)});this.repaint()};this.setForegroundType=function(cj){a4({foreground:true});b6=cj;bN({foreground:true});this.repaint()};this.setPointerType=function(cj){a4({pointer:true,foreground:true});bT=cj;bN({pointer:true,foreground:true});this.repaint()};this.setPointerColor=function(cj){a4({pointer:true});b4=cj;bN({pointer:true});this.repaint()};this.setLedColor=function(cj){a4({led:true});bm=cj;bN({led:true});this.repaint()};this.repaint=function(){if(!aT){bN({frame:true,background:true,led:true,pointer:true,foreground:true})}a8.clearRect(0,0,bu,bu);a8.save();if(b7){a8.drawImage(bJ,0,0)}a8.drawImage(bw,0,0);if(aZ){if(bv<b2){bg=false;bI=bf}a8.drawImage(bI,aY,aW)}if(steelseries.Orientation.WEST===bY){a8.translate(be,be);a8.rotate(-R);a8.translate(-be,-be)}if(bt){a8.save();a8.translate(be,bd);a8.rotate(bR+R+(bc-bS)*b1);a8.translate(-be,-bd);a8.drawImage(bb,a8.canvas.width*0.4865,a8.canvas.height*0.27);a8.restore()}if(bp){a8.save();a8.translate(be,bd);a8.rotate(bR+R+(bs-bS)*b1);a8.translate(-be,-bd);a8.drawImage(bx,a8.canvas.width*0.4865,a8.canvas.height*0.27);a8.restore()}bn=bR+R+(bv-bS)*b1;a8.save();a8.translate(be,bd);a8.rotate(bn);a8.shadowColor="rgba(0, 0, 0, 0.8)";a8.shadowOffsetX=a8.shadowOffsetY=bC;a8.shadowBlur=bC*2;a8.translate(-cb,-cb);a8.drawImage(bD,0,0);a8.restore();if(bV){if(steelseries.Orientation.WEST===bY){a8.translate(be,be);a8.rotate(R);a8.translate(-be,-be)}a8.drawImage(bX,0,0)}a8.restore();bL=false};this.repaint();return this};var L=function(cc,bm){bm=bm||{};var bA=(undefined===bm.gaugeType?steelseries.GaugeType.TYPE1:bm.gaugeType),b0=(undefined===bm.width?140:bm.width),bc=(undefined===bm.height?320:bm.height),bS=(undefined===bm.minValue?0:bm.minValue),bO=(undefined===bm.maxValue?(bS+100):bm.maxValue),bF=(undefined===bm.niceScale?true:bm.niceScale),bZ=(undefined===bm.threshold?(bO-bS)/2:bm.threshold),bB=(undefined===bm.titleString?"":bm.titleString),aY=(undefined===bm.unitString?"":bm.unitString),b6=(undefined===bm.frameDesign?steelseries.FrameDesign.METAL:bm.frameDesign),b2=(undefined===bm.frameVisible?true:bm.frameVisible),bk=(undefined===bm.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bm.backgroundColor),b9=(undefined===bm.backgroundVisible?true:bm.backgroundVisible),bE=(undefined===bm.valueColor?steelseries.ColorDef.RED:bm.valueColor),bP=(undefined===bm.lcdColor?steelseries.LcdColor.STANDARD:bm.lcdColor),bb=(undefined===bm.lcdVisible?true:bm.lcdVisible),b7=(undefined===bm.lcdDecimals?2:bm.lcdDecimals),bi=(undefined===bm.digitalFont?false:bm.digitalFont),bo=(undefined===bm.ledColor?steelseries.LedColor.RED_LED:bm.ledColor),aX=(undefined===bm.ledVisible?true:bm.ledVisible),cb=(undefined===bm.thresholdVisible?true:bm.thresholdVisible),bu=(undefined===bm.minMeasuredValueVisible?false:bm.minMeasuredValueVisible),bq=(undefined===bm.maxMeasuredValueVisible?false:bm.maxMeasuredValueVisible),bn=(undefined===bm.labelNumberFormat?steelseries.LabelNumberFormat.STANDARD:bm.labelNumberFormat),bV=(undefined===bm.foregroundVisible?true:bm.foregroundVisible),b4=(undefined===bm.playAlarm?false:bm.playAlarm),aV=(undefined===bm.alarmSound?false:bm.alarmSound);if(b4&&aV!==false){var aQ=A.createElement("audio");aQ.setAttribute("src",aV);aQ.setAttribute("preload","auto")}var bY=this;var bv=bS;var be=bO;var bt=bS;if(bA.type!=="type1"&&bA.type!=="type2"){bA=steelseries.GaugeType.TYPE1}var a4;var bh=false;var bK=false;var bN=0;var a8=A.getElementById(cc).getContext("2d");a8.clearRect(0,0,a8.canvas.width,a8.canvas.height);a8.canvas.width=b0;a8.canvas.height=bc;var aZ=b0;var b5=bc;var bf=b0<=bc;var aW;var aU;var a6=Math.round((bf?bc:b0)*0.05);var bQ=Math.round((bf?b0:bc)*0.05);var bG;var bl;if(bf){aW=aZ/2-a6/2;aU=(bA.type==="type1"?0.053:0.038)*b5;bG=Math.floor(b5/22)+"px sans-serif";bl=Math.floor(b5/22)+"px "+aC}else{aW=0.89*aZ;aU=b5/2-a6/2;bG=Math.floor(b5/10)+"px sans-serif";bl=Math.floor(b5/10)+"px "+aC}var aS=false;var a7=bS;var bj=bO;var a0=bO-bS;var bs=bj-a7;var bD=0;var a5=0;var by=10;var b3=10;var a9=function a9(){if(bF){a0=g(bO-bS,false);a5=g(a0/(b3-1),true);a7=Math.floor(bS/a5)*a5;bj=Math.ceil(bO/a5)*a5;bD=g(a5/(by-1),true);bS=a7;bO=bj;bs=bO-bS}else{a0=(bO-bS);a7=bS;bj=bO;bs=a0;bD=1;a5=10}};var bJ=I(b0,bc);var bp=bJ.getContext("2d");var bw=I(b0,bc);var bz=bw.getContext("2d");var bT;var ba=I(a6,a6);var br=ba.getContext("2d");var bg=I(a6,a6);var aR=bg.getContext("2d");var bI=bg;var bd=I(bQ,bQ);var b1=bd.getContext("2d");var bx=I(bQ,bQ);var aT=bx.getContext("2d");var bW=I(b0,bc);var a1=bW.getContext("2d");var bX=function(cd,ci,ce){cd.save();cd.textAlign="right";cd.textBaseline="middle";cd.strokeStyle=bP.textColor;cd.fillStyle=bP.textColor;if(bP===steelseries.LcdColor.STANDARD||bP===steelseries.LcdColor.STANDARD_GREEN){cd.shadowColor="gray";if(ce){cd.shadowOffsetX=b5*0.003;cd.shadowOffsetY=b5*0.003;cd.shadowBlur=b5*0.004}else{cd.shadowOffsetX=b5*0.007;cd.shadowOffsetY=b5*0.007;cd.shadowBlur=b5*0.009}}var cg;var cf;var ch;if(bi){cd.font=bl}else{cd.font=bG}if(ce){cg=(aZ-(aZ*0.571428))/2+aZ*0.571428-2;cf=b5*0.88+1+(b5*0.055-2)/2;ch=aZ*0.7-2}else{cg=(aZ*0.695)+aZ*0.18-2;cf=(b5*0.22)+1+(b5*0.15-2)/2;ch=b5*0.22-2}cd.fillText(ci.toFixed(b7),cg,cf,ch);cd.restore()};var b8=function(cd){var cg=A.createElement("canvas");cg.height=cg.width=bQ;var cf=cg.getContext("2d");cf.save();var ce=cf.createLinearGradient(0,0.1,0,cg.height*0.9);ce.addColorStop(0,"#520000");ce.addColorStop(0.3,"#fc1d00");ce.addColorStop(0.59,"#fc1d00");ce.addColorStop(1,"#520000");cf.fillStyle=ce;if(cd){cf.beginPath();cf.moveTo(0.1,cg.height*0.5);cf.lineTo(cg.width*0.9,0.1);cf.lineTo(cg.width*0.9,cg.height*0.9);cf.closePath()}else{cf.beginPath();cf.moveTo(0.1,0.1);cf.lineTo(cg.width*0.9,0.1);cf.lineTo(cg.width*0.5,cg.height*0.9);cf.closePath()}cf.fill();cf.strokeStyle="#FFFFFF";cf.stroke();cf.restore();return cg};var bH=function(cp,ch,ce){bk.labelColor.setAlpha(1);cp.save();cp.textBaseline="middle";var cm=aZ*0.1;cp.strokeStyle=bk.labelColor.getRgbaColor();cp.fillStyle=bk.labelColor.getRgbaColor();var cj=bS;var ci=by-1;var co;var cv;var cs;var cr;var ct;var cg;var cu=1;var cf;var cw;var cl;var cd;var cn;var ck;if(ce){cf=(0.34*aZ);cw=(0.36*aZ);cl=(0.33*aZ);cd=(0.36*aZ);cn=(0.32*aZ);ck=(0.36*aZ);cp.textAlign="right";cs=0;cr=b5*0.12864;ct=0;if(bA.type==="type1"){cg=(b5*0.856796-b5*0.12864)}else{cg=(b5*0.7475-b5*0.12864)}cu=cg/(bO-bS)}else{cf=(0.65*b5);cw=(0.63*b5);cl=(0.66*b5);cd=(0.63*b5);cn=(0.67*b5);ck=(0.63*b5);cp.textAlign="center";cr=0;if(bA.type==="type1"){cs=aZ*0.142857;ct=(aZ*0.871012-cs)}else{cs=aZ*0.19857;ct=(aZ*0.82-cs)}cg=0;cu=ct/(bO-bS)}var cq;for(cq=bS,co=0;cq<=bO;cq+=bD,co+=bD){if(ce){cv=cr+cg-co*cu}else{cv=cs+co*cu}ci++;if(ci===by){cp.lineWidth=1.5;ca(cp,cn,ck,cv,ce);if(ce){switch(ch.format){case"fractional":cp.fillText((cj.toFixed(2)),aZ*0.28,cv,cm);break;case"scientific":cp.fillText((cj.toPrecision(2)),aZ*0.28,cv,cm);break;case"standard":default:cp.fillText((cj.toFixed(0)),aZ*0.28,cv,cm);break}}else{switch(ch.format){case"fractional":cp.fillText((cj.toFixed(2)),cv,(b5*0.73),cm);break;case"scientific":cp.fillText((cj.toPrecision(2)),cv,(b5*0.73),cm);break;case"standard":default:cp.fillText((cj.toFixed(0)),cv,(b5*0.73),cm);break}}cj+=a5;ci=0;continue}if(0===by%2&&ci===(by/2)){cp.lineWidth=1;ca(cp,cl,cd,cv,ce)}else{cp.lineWidth=0.5;ca(cp,cf,cw,cv,ce)}}cp.restore()};var ca=function(cd,cg,ch,cf,ce){if(ce){cd.beginPath();cd.moveTo(cg,cf);cd.lineTo(ch,cf);cd.closePath();cd.stroke()}else{cd.beginPath();cd.moveTo(cf,cg);cd.lineTo(cf,ch);cd.closePath();cd.stroke()}};var bM=function(cg){cg=cg||{};var ch=(undefined===cg.frame?false:cg.frame);var ci=(undefined===cg.background?false:cg.background);var cf=(undefined===cg.led?false:cg.led);var cd=(undefined===cg.foreground?false:cg.foreground);var cj;var ck;var ce;aS=true;a9();if(ch&&b2){k(bp,b6,aZ,b5,bf)}if(ci&&b9){W(bz,bk,aZ,b5,bf)}if(ci&&bA.type==="type2"){a2(bz)}if(cf){if(bf){br.drawImage(ad(a6,1,bo),0,0);aR.drawImage(ad(a6,0,bo),0,0)}else{br.drawImage(ad(a6,1,bo),0,0);aR.drawImage(ad(a6,0,bo),0,0)}}if(bu){if(bf){b1.drawImage(v(bQ,steelseries.ColorDef.BLUE.dark.getRgbaColor(),false,bf),0,0)}else{b1.drawImage(v(bQ,steelseries.ColorDef.BLUE.dark.getRgbaColor(),false,bf),0,0)}}if(bq){if(bf){aT.drawImage(v(bQ,steelseries.ColorDef.RED.medium.getRgbaColor(),false,bf),0,0)}else{aT.drawImage(v(bQ,steelseries.ColorDef.RED.medium.getRgbaColor(),false,bf),0,0)}}if(ci&&b9){bH(bz,bn,bf);if(bf){an(bz,aZ,b5,bB,aY,bk,bf,null,bb,bA)}else{an(bz,aZ,b5,bB,aY,bk,bf,null,bb,bA)}}if(ci&&cb){bz.save();if(bf){cj=(bA.type==="type1"?0.856796:0.7475);ck=cj-0.12864;ce=b5*cj-(b5*ck)*(bZ/(bO-bS));bz.translate(aZ*0.365,ce-bQ/2)}else{cj=(bA.type==="type1"?0.871012:0.82);ck=cj-(bA.type==="type1"?0.142857:0.19857);ce=aZ*ck*bZ/(bO-bS);bz.translate(aZ*(bA.type==="type1"?0.142857:0.19857)-bQ/2+ce,b5*0.58)}bz.drawImage(b8(bf),0,0);bz.restore()}if(ci&&bb){if(bf){bT=U(aZ*0.571428,b5*0.055,bP);bz.drawImage(bT,((aZ-(aZ*0.571428))/2),b5*0.88)}else{bT=U(aZ*0.18,b5*0.15,bP);bz.drawImage(bT,aZ*0.695,b5*0.22)}}if(cd&&bA.type==="type2"){bC(a1)}if(cd&&bV){aI(a1,aZ,b5,bf,false)}};var a3=function(ce){ce=ce||{};var cf=(undefined===ce.frame?false:ce.frame);var cg=(undefined===ce.background?false:ce.background);var ch=(undefined===ce.led?false:ce.led);var cd=(undefined===ce.foreground?false:ce.foreground);if(cf){bJ.width=b0;bJ.height=bc;bp=bJ.getContext("2d")}if(cg){bw.width=b0;bw.height=bc;bz=bw.getContext("2d")}if(ch){ba.width=Math.ceil(b0*0.093457);ba.height=Math.ceil(bc*0.093457);br=ba.getContext("2d");bg.width=Math.ceil(b0*0.093457);bg.height=Math.ceil(bc*0.093457);aR=bg.getContext("2d");bI=bg}if(cd){bW.width=b0;bW.height=bc;a1=bW.getContext("2d")}};var bL=function(cd){if(cd){bN=setInterval(bU,1000)}else{clearInterval(bN)}};var bU=function(){if(aX){if(bI===ba){bI=bg}else{bI=ba}if(!bK){bK=true;ab(bY.repaint)}}};var bR=function(cz,cq,cE){var cx;var cp;var cF=bk.labelColor;var cy;var ci,cH;var co,cn,cC,cA;var cl,cj,cf,ce;var cm,ck,cw,cu;var cD,cB,cv,ct;if(bf){cx=cE*0.12864;if(bA.type==="type1"){cp=cE*0.856796}else{cp=cE*0.7475}cy=cp-cx;ci=cy*(bv-bS)/(bO-bS);cH=cp-ci;cl=0;cj=cx;cf=0;ce=cp}else{if(bA.type==="type1"){cx=cq*0.871012;cp=cq*0.142857}else{cx=cq*0.82;cp=cq*0.19857}cy=cx-cp;ci=cy*(bv-bS)/(bO-bS);cH=cp;cl=cx;cj=0;cf=cp;ce=0}if(bA.type==="type1"){var ch=(bk===steelseries.BackgroundColor.CARBON||bk===steelseries.BackgroundColor.PUNCHED_SHEET||bk===steelseries.BackgroundColor.STAINLESS||bk===steelseries.BackgroundColor.BRUSHED_STAINLESS||bk===steelseries.BackgroundColor.TURNED)?0.3:0;var cG=cz.createLinearGradient(cl,cj,cf,ce);cF.setAlpha(0.05+ch);cG.addColorStop(0,cF.getRgbaColor());cF.setAlpha(0.15+ch);cG.addColorStop(0.48,cF.getRgbaColor());cF.setAlpha(0.15+ch);cG.addColorStop(0.49,cF.getRgbaColor());cF.setAlpha(0.05+ch);cG.addColorStop(1,cF.getRgbaColor());cz.fillStyle=cG;if(bf){cz.fillRect(cq*0.435714,cx,cq*0.142857,cy)}else{cz.fillRect(cq*0.142857,cE*0.435714,cy,cE*0.142857)}if(bf){cm=0;ck=cx;cw=0;cu=cx+cy}else{cm=cq*0.142857+cy;ck=0;cw=cq*0.142857;cu=0}var cd=cz.createLinearGradient(cm,ck,cw,cu);cF.setAlpha(0.3+ch);cd.addColorStop(0,cF.getRgbaColor());cF.setAlpha(0.69);cd.addColorStop(0.48,cF.getRgbaColor());cF.setAlpha(0.7);cd.addColorStop(0.49,cF.getRgbaColor());cF.setAlpha(0.4);cd.addColorStop(1,cF.getRgbaColor());cz.fillStyle=cd;if(bf){cz.fillRect(cq*0.435714,cx,cq*0.007142,cy);cz.fillRect(cq*0.571428,cx,cq*0.007142,cy)}else{cz.fillRect(cq*0.142857,cE*0.435714,cy,cE*0.007142);cz.fillRect(cq*0.142857,cE*0.571428,cy,cE*0.007142)}}if(bf){if(bA.type==="type1"){co=cq*0.45;cn=0;cC=cq*0.45+cq*0.114285;cA=0}else{co=cq/2-cE*0.0486/2;cn=0;cC=co+cE*0.053;cA=0}}else{if(bA.type==="type1"){co=0;cn=cE*0.45;cC=0;cA=cE*0.45+cE*0.114285}else{co=0;cn=cE/2-cq*0.025;cC=0;cA=cn+cq*0.053}}var cs=cz.createLinearGradient(co,cn,cC,cA);cs.addColorStop(0,bE.medium.getRgbaColor());cs.addColorStop(1,bE.light.getRgbaColor());cz.fillStyle=cs;var cr=(bA.type==="type1"?0:(bf?cE*0.05:cq*0.05));if(bf){cz.fillRect(co,cH,cC-co,ci+cr)}else{cz.fillRect(cH-cr,cn,ci+cr,cA-cn)}if(bA.type==="type1"){if(bf){cD=cq*0.45;cB=0;cv=cD+cq*0.05;ct=0}else{cD=0;cB=cE*0.45;cv=0;ct=cB+cE*0.05}var cg=cz.createLinearGradient(cD,cB,cv,ct);cg.addColorStop(0,"rgba(255, 255, 255, 0.7)");cg.addColorStop(0.98,"rgba(255, 255, 255, 0.0)");cz.fillStyle=cg;if(bf){cz.fillRect(cD,cH,cv,ci)}else{cz.fillRect(cH,cB,ci,ct-cB)}}};var bC=function(ce){var cd=(bf?b5:aZ);ce.save();if(bf){ce.translate(aZ/2,0)}else{ce.translate(aZ/2,b5/2);ce.rotate(R);ce.translate(0,-aZ/2+aZ*0.05)}ce.beginPath();ce.moveTo(-0.049*cd,0.825*cd);ce.bezierCurveTo(-0.049*cd,0.7975*cd,-0.0264*cd,0.775*cd,0.0013*cd,0.775*cd);ce.bezierCurveTo(0.0264*cd,0.775*cd,0.049*cd,0.7975*cd,0.049*cd,0.825*cd);ce.bezierCurveTo(0.049*cd,0.85*cd,0.0264*cd,0.8725*cd,0.0013*cd,0.8725*cd);ce.bezierCurveTo(-0.0264*cd,0.8725*cd,-0.049*cd,0.85*cd,-0.049*cd,0.825*cd);ce.closePath();var cf=ce.createRadialGradient(0*cd,0.825*cd,0,0*cd,0.825*cd,0.049*cd);cf.addColorStop(0,bE.medium.getRgbaColor());cf.addColorStop(0.3,bE.medium.getRgbaColor());cf.addColorStop(1,bE.light.getRgbaColor());ce.fillStyle=cf;ce.fill();ce.beginPath();if(bf){ce.moveTo(-0.0365*cd,0.8075*cd);ce.bezierCurveTo(-0.0365*cd,0.7925*cd,-0.0214*cd,0.7875*cd,-0.0214*cd,0.7825*cd);ce.bezierCurveTo(0.0189*cd,0.785*cd,0.0365*cd,0.7925*cd,0.0365*cd,0.8075*cd);ce.bezierCurveTo(0.0365*cd,0.8175*cd,0.0214*cd,0.815*cd,0.0013*cd,0.8125*cd);ce.bezierCurveTo(-0.0189*cd,0.8125*cd,-0.0365*cd,0.8175*cd,-0.0365*cd,0.8075*cd);cf=ce.createRadialGradient(0,0.8*cd,0,0,0.8*cd,0.0377*cd)}else{ce.beginPath();ce.moveTo(-0.0214*cd,0.86*cd);ce.bezierCurveTo(-0.0365*cd,0.86*cd,-0.0415*cd,0.845*cd,-0.0465*cd,0.825*cd);ce.bezierCurveTo(-0.0465*cd,0.805*cd,-0.0365*cd,0.7875*cd,-0.0214*cd,0.7875*cd);ce.bezierCurveTo(-0.0113*cd,0.7875*cd,-0.0163*cd,0.8025*cd,-0.0163*cd,0.8225*cd);ce.bezierCurveTo(-0.0163*cd,0.8425*cd,-0.0113*cd,0.86*cd,-0.0214*cd,0.86*cd);cf=ce.createRadialGradient(-0.03*cd,0.8225*cd,0,-0.03*cd,0.8225*cd,0.0377*cd)}cf.addColorStop(0,"rgba(255, 255, 255, 0.55)");cf.addColorStop(1,"rgba(255, 255, 255, 0.05)");ce.fillStyle=cf;ce.closePath();ce.fill();ce.beginPath();ce.moveTo(-0.0214*cd,0.115*cd);ce.bezierCurveTo(-0.0214*cd,0.1075*cd,-0.0163*cd,0.1025*cd,-0.0113*cd,0.1025*cd);ce.bezierCurveTo(-0.0113*cd,0.1025*cd,-0.0113*cd,0.1025*cd,-0.0113*cd,0.1025*cd);ce.bezierCurveTo(-0.0038*cd,0.1025*cd,0.0013*cd,0.1075*cd,0.0013*cd,0.115*cd);ce.bezierCurveTo(0.0013*cd,0.115*cd,0.0013*cd,0.76*cd,0.0013*cd,0.76*cd);ce.bezierCurveTo(0.0013*cd,0.7675*cd,-0.0038*cd,0.7725*cd,-0.0113*cd,0.7725*cd);ce.bezierCurveTo(-0.0113*cd,0.7725*cd,-0.0113*cd,0.7725*cd,-0.0113*cd,0.7725*cd);ce.bezierCurveTo(-0.0163*cd,0.7725*cd,-0.0214*cd,0.7675*cd,-0.0214*cd,0.76*cd);ce.bezierCurveTo(-0.0214*cd,0.76*cd,-0.0214*cd,0.115*cd,-0.0214*cd,0.115*cd);ce.closePath();cf=ce.createLinearGradient(-0.0189*cd,0,0.0013*cd,0);cf.addColorStop(0,"rgba(255, 255, 255, 0.1)");cf.addColorStop(0.34,"rgba(255, 255, 255, 0.5)");cf.addColorStop(1,"rgba(255, 255, 255, 0.1)");ce.fillStyle=cf;ce.fill();ce.restore()};var a2=function(ce){var cd=(bf?b5:aZ);ce.save();if(bf){ce.translate(aZ/2,0)}else{ce.translate(aZ/2,b5/2);ce.rotate(R);ce.translate(0,-aZ/2+aZ*0.05)}ce.beginPath();ce.moveTo(-0.0516*cd,0.825*cd);ce.bezierCurveTo(-0.0516*cd,0.8525*cd,-0.0289*cd,0.875*cd,0.0013*cd,0.875*cd);ce.bezierCurveTo(0.0289*cd,0.875*cd,0.0516*cd,0.8525*cd,0.0516*cd,0.825*cd);ce.bezierCurveTo(0.0516*cd,0.8075*cd,0.044*cd,0.7925*cd,0.0314*cd,0.7825*cd);ce.bezierCurveTo(0.0314*cd,0.7825*cd,0.0314*cd,0.12*cd,0.0314*cd,0.12*cd);ce.bezierCurveTo(0.0314*cd,0.1025*cd,0.0189*cd,0.0875*cd,0.0013*cd,0.0875*cd);ce.bezierCurveTo(-0.0163*cd,0.0875*cd,-0.0289*cd,0.1025*cd,-0.0289*cd,0.12*cd);ce.bezierCurveTo(-0.0289*cd,0.12*cd,-0.0289*cd,0.7825*cd,-0.0289*cd,0.7825*cd);ce.bezierCurveTo(-0.0415*cd,0.79*cd,-0.0516*cd,0.805*cd,-0.0516*cd,0.825*cd);ce.closePath();var cf=ce.createLinearGradient(-0.0163*cd,0,0.0289*cd,0);cf.addColorStop(0,"rgba(226, 226, 226, 0.5)");cf.addColorStop(0.5,"rgba(226, 226, 226, 0.2)");cf.addColorStop(1,"rgba(226, 226, 226, 0.5)");ce.fillStyle=cf;ce.fill();ce.lineWidth=1;ce.strokeStyle="rgba(153, 153, 153, 0.5)";ce.stroke();ce.restore()};this.setValue=function(ce){ce=parseFloat(ce);var cd=(ce<bS?bS:(ce>bO?bO:ce));if(bv!==cd){bv=cd;if(bv>bt){bt=bv}if(bv<be){be=bv}if(bv>=bZ&&!bh){bh=true;bL(bh);if(b4){aQ.play()}}else{if(bv<bZ){bh=false;bL(bh);if(b4){aQ.pause()}}}this.repaint()}};this.getValue=function(){return bv};this.setValueAnimated=function(cf){cf=parseFloat(cf);var cd=(cf<bS?bS:(cf>bO?bO:cf));if(bv!==cd){if(undefined!==a4){if(a4.playing){a4.stop()}}a4=new Tween({},"",Tween.regularEaseInOut,bv,cd,1);var ce=this;a4.onMotionChanged=function(cg){bv=cg.target._pos;if(bv>bt){bt=bv}if(bv<be){be=bv}if(bv>=bZ&&!bh){bh=true;bL(bh);if(b4){aQ.play()}}else{if(bv<bZ){bh=false;bL(bh);if(b4){aQ.pause()}}}if(!bK){bK=true;ab(ce.repaint)}};a4.start()}};this.resetMinMeasuredValue=function(){be=bv;this.repaint()};this.resetMaxMeasuredValue=function(){bt=bv;this.repaint()};this.setMinMeasuredValueVisible=function(cd){bu=cd;this.repaint()};this.setMaxMeasuredValueVisible=function(cd){bq=cd;this.repaint()};this.setThresholdVisible=function(cd){cb=cd;this.repaint()};this.setLcdDecimals=function(cd){b7=cd;this.repaint()};this.setFrameDesign=function(cd){a3({frame:true});b6=cd;bM({frame:true});this.repaint()};this.setBackgroundColor=function(cd){a3({background:true});bk=cd;bM({background:true});this.repaint()};this.setValueColor=function(cd){a3({foreground:true});bE=cd;bM({foreground:true});this.repaint()};this.setLedColor=function(cd){a3({led:true});bo=cd;bM({led:true});this.repaint()};this.setLcdColor=function(cd){a3({background:true});bP=cd;bM({background:true});this.repaint()};this.setMaxMeasuredValue=function(cd){var ce=(cd<bS?bS:(cd>bO?bO:cd));bt=ce;this.repaint()};this.setMinMeasuredValue=function(cd){var ce=(cd<bS?bS:(cd>bO?bO:cd));be=ce;this.repaint()};this.setTitleString=function(cd){bB=cd;a3({background:true});bM({background:true});this.repaint()};this.setUnitString=function(cd){aY=cd;a3({background:true});bM({background:true});this.repaint()};this.setMinValue=function(cd){a3({background:true});bS=cd;if(be<bS){be=bS}if(bv<bS){bv=bS}bM({background:true});this.repaint()};this.getMinValue=function(){return bS};this.setMaxValue=function(cd){a3({background:true});bO=cd;if(bt>bO){bt=bO}if(bv>bO){bv=bO}bM({background:true});this.repaint()};this.getMaxValue=function(){return bO};this.setThreshold=function(cd){cd=parseFloat(cd);var ce=(cd<bS?bS:(cd>bO?bO:cd));bZ=ce;a3({background:true});bM({background:true});this.repaint()};this.repaint=function(){if(!aS){bM({frame:true,background:true,led:true,foreground:true})}a8.clearRect(0,0,a8.canvas.width,a8.canvas.height);if(b2){a8.drawImage(bJ,0,0)}a8.drawImage(bw,0,0);if(bb){bX(a8,bv,bf)}if(aX){if(bv<bZ){bh=false;bI=bg}a8.drawImage(bI,aW,aU)}var cf;var cg;var ch;var ce,cd;if(bu){if(bf){cg=(bA.type==="type1"?0.856796:0.7475);ch=(cg-0.12864);cf=b5*cg-(b5*ch)*(be/(bO-bS));ce=aZ*0.34-bd.width;cd=cf-bd.height/2}else{cg=(bA.type==="type1"?0.871012:0.82);ch=cg-(bA.type==="type1"?0.142857:0.19857);cf=(aZ*ch)*be/(bO-bS);ce=aZ*(bA.type==="type1"?0.142857:0.19857)-bd.height/2+cf;cd=b5*0.65}a8.drawImage(bd,ce,cd)}if(bq){if(bf){cf=b5*cg-(b5*ch)*(bt/(bO-bS));ce=aZ*0.34-bx.width;cd=cf-bx.height/2}else{cg=(bA.type==="type1"?0.871012:0.8);ch=cg-(bA.type==="type1"?0.14857:0.19857);cf=(aZ*ch)*bt/(bO-bS);ce=aZ*(bA.type==="type1"?0.142857:0.19857)-bx.height/2+cf;cd=b5*0.65}a8.drawImage(bx,ce,cd)}a8.save();bR(a8,aZ,b5);a8.restore();if(bV||bA.type==="type2"){a8.drawImage(bW,0,0)}bK=false};this.repaint();return this};var y=function(cm,bt){bt=bt||{};var b9=(undefined===bt.width?140:bt.width),bh=(undefined===bt.height?320:bt.height),bZ=(undefined===bt.minValue?0:bt.minValue),bV=(undefined===bt.maxValue?(bZ+100):bt.maxValue),b6=(undefined===bt.section?null:bt.section),bK=(undefined===bt.useSectionColors?false:bt.useSectionColors),bL=(undefined===bt.niceScale?true:bt.niceScale),b8=(undefined===bt.threshold?(bV-bZ)/2:bt.threshold),bH=(undefined===bt.titleString?"":bt.titleString),a2=(undefined===bt.unitString?"":bt.unitString),cg=(undefined===bt.frameDesign?steelseries.FrameDesign.METAL:bt.frameDesign),cb=(undefined===bt.frameVisible?true:bt.frameVisible),bq=(undefined===bt.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bt.backgroundColor),cj=(undefined===bt.backgroundVisible?true:bt.backgroundVisible),bJ=(undefined===bt.valueColor?steelseries.ColorDef.RED:bt.valueColor),bW=(undefined===bt.lcdColor?steelseries.LcdColor.STANDARD:bt.lcdColor),bg=(undefined===bt.lcdVisible?true:bt.lcdVisible),ch=(undefined===bt.lcdDecimals?2:bt.lcdDecimals),bn=(undefined===bt.digitalFont?false:bt.digitalFont),bv=(undefined===bt.ledColor?steelseries.LedColor.RED_LED:bt.ledColor),a1=(undefined===bt.ledVisible?true:bt.ledVisible),cl=(undefined===bt.thresholdVisible?true:bt.thresholdVisible),bB=(undefined===bt.minMeasuredValueVisible?false:bt.minMeasuredValueVisible),bx=(undefined===bt.maxMeasuredValueVisible?false:bt.maxMeasuredValueVisible),bu=(undefined===bt.labelNumberFormat?steelseries.LabelNumberFormat.STANDARD:bt.labelNumberFormat),b2=(undefined===bt.foregroundVisible?true:bt.foregroundVisible),cd=(undefined===bt.playAlarm?false:bt.playAlarm),aZ=(undefined===bt.alarmSound?false:bt.alarmSound),a3=(undefined===bt.valueGradient?null:bt.valueGradient),bb=(undefined===bt.useValueGradient?false:bt.useValueGradient);if(cd&&aZ!==false){var aR=A.createElement("audio");aR.setAttribute("src",aZ);aR.setAttribute("preload","auto")}var b7=this;var bC=bZ;var bj=bV;var bA=bZ;var a8;var bm=false;var bQ=false;var aQ=false;var aW=false;var aV=[];var bU=0;var bd=A.getElementById(cm).getContext("2d");bd.clearRect(0,0,bd.canvas.width,bd.canvas.height);bd.canvas.width=b9;bd.canvas.height=bh;var a4=bd.canvas.width;var cf=bd.canvas.height;var bk=b9<=bh;var a0;var aX;var ba=Math.round((bk?bh:b9)*0.05);var bX=Math.round((bk?b9:bh)*0.05);var bM;var bs;if(bk){a0=a4/2-ba/2;aX=0.053*cf;bM=Math.floor(cf/22)+"px sans-serif";bs=Math.floor(cf/22)+"px "+aC}else{a0=0.89*a4;aX=cf/1.95-ba/2;bM=Math.floor(cf/10)+"px sans-serif";bs=Math.floor(cf/10)+"px "+aC}var aT=false;var bc=bZ;var bp=bV;var a5=bV-bZ;var bz=bp-bc;var bI=0;var a9=0;var bF=10;var cc=10;var bf=function bf(){if(bL){a5=g(bV-bZ,false);a9=g(a5/(cc-1),true);bc=Math.floor(bZ/a9)*a9;bp=Math.ceil(bV/a9)*a9;bI=g(a9/(bF-1),true);bZ=bc;bV=bp;bz=bV-bZ}else{a5=(bV-bZ);bc=bZ;bp=bV;bz=a5;bI=1;a9=10}};var bP=I(b9,bh);var bw=bP.getContext("2d");var bD=I(b9,bh);var bG=bD.getContext("2d");var b0;var b5=A.createElement("canvas");if(bk){b5.width=a4*0.121428;b5.height=cf*0.012135}else{b5.width=a4*0.012135;b5.height=cf*0.121428}var aY=b5.getContext("2d");var bT=A.createElement("canvas");if(bk){bT.width=a4*0.121428;bT.height=cf*0.012135}else{bT.width=a4*0.012135;bT.height=cf*0.121428}var bo=bT.getContext("2d");var be=I(ba,ba);var by=be.getContext("2d");var bl=I(ba,ba);var aS=bl.getContext("2d");var bO=bl;var bi=I(bX,bX);var ca=bi.getContext("2d");var bE=I(bX,bX);var aU=bE.getContext("2d");var b3=I(b9,bh);var a6=b3.getContext("2d");var b4=function(cn,cs,co){cn.save();cn.textAlign="right";cn.textBaseline="middle";cn.strokeStyle=bW.textColor;cn.fillStyle=bW.textColor;if(bW===steelseries.LcdColor.STANDARD||bW===steelseries.LcdColor.STANDARD_GREEN){cn.shadowColor="gray";if(co){cn.shadowOffsetX=a4*0.007;cn.shadowOffsetY=a4*0.007;cn.shadowBlur=a4*0.009}else{cn.shadowOffsetX=cf*0.007;cn.shadowOffsetY=cf*0.007;cn.shadowBlur=cf*0.009}}var cq;var cp;var cr;if(bn){cn.font=bs}else{cn.font=bM}if(co){cq=(a4-(a4*0.571428))/2+1+a4*0.571428-2;cp=cf*0.88+1+(cf*0.055-2)/2;cr=a4*0.7-2}else{cq=(a4*0.695)+a4*0.18-2;cp=(cf*0.22)+1+(cf*0.15-2)/2;cr=cf*0.22-2}cn.fillText(cs.toFixed(ch),cq,cp,cr);cn.restore()};var ci=function(cn){var cq=A.createElement("canvas");cq.height=cq.width=bX;var cp=cq.getContext("2d");cp.save();var co=cp.createLinearGradient(0,0.1,0,cq.height*0.9);co.addColorStop(0,"#520000");co.addColorStop(0.3,"#fc1d00");co.addColorStop(0.59,"#fc1d00");co.addColorStop(1,"#520000");cp.fillStyle=co;if(cn){cp.beginPath();cp.moveTo(0.1,cq.height*0.5);cp.lineTo(cq.width*0.9,0.1);cp.lineTo(cq.width*0.9,cq.height*0.9);cp.closePath()}else{cp.beginPath();cp.moveTo(0.1,0.1);cp.lineTo(cq.width*0.9,0.1);cp.lineTo(cq.width*0.5,cq.height*0.9);cp.closePath()}cp.fill();cp.strokeStyle="#FFFFFF";cp.stroke();cp.restore();return cq};var bN=function(cz,cr,co){bq.labelColor.setAlpha(1);cz.save();cz.textBaseline="middle";var cw=a4*0.1;cz.strokeStyle=bq.labelColor.getRgbaColor();cz.fillStyle=bq.labelColor.getRgbaColor();var ct=bZ;var cs=bF-1;var cy;var cF;var cC;var cB;var cD;var cq;var cE=1;var cp;var cG;var cv;var cn;var cx;var cu;if(co){cp=(0.34*a4);cG=(0.36*a4);cv=(0.33*a4);cn=(0.36*a4);cx=(0.32*a4);cu=(0.36*a4);cz.textAlign="right";cC=0;cB=cf*0.12864;cD=0;cq=(cf*0.856796-cf*0.12864);cE=cq/(bV-bZ)}else{cp=(0.65*cf);cG=(0.63*cf);cv=(0.66*cf);cn=(0.63*cf);cx=(0.67*cf);cu=(0.63*cf);cz.textAlign="center";cC=a4*0.142857;cB=0;cD=(a4*0.871012-a4*0.142857);cq=0;cE=cD/(bV-bZ)}var cA;for(cA=bZ,cy=0;cA<=bV;cA+=bI,cy+=bI){if(co){cF=cB+cq-cy*cE}else{cF=cC+cy*cE}cs++;if(cs===bF){cz.lineWidth=1.5;ck(cz,cx,cu,cF,co);if(co){switch(cr.format){case"fractional":cz.fillText((ct.toFixed(2)),a4*0.28,cF,cw);break;case"scientific":cz.fillText((ct.toPrecision(2)),a4*0.28,cF,cw);break;case"standard":default:cz.fillText((ct.toFixed(0)),a4*0.28,cF,cw);break}}else{switch(cr.format){case"fractional":cz.fillText((ct.toFixed(2)),cF,(cf*0.73),cw);break;case"scientific":cz.fillText((ct.toPrecision(2)),cF,(cf*0.73),cw);break;case"standard":default:cz.fillText((ct.toFixed(0)),cF,(cf*0.73),cw);break}}ct+=a9;cs=0;continue}if(0===bF%2&&cs===(bF/2)){cz.lineWidth=1;ck(cz,cv,cn,cF,co)}else{cz.lineWidth=0.5;ck(cz,cp,cG,cF,co)}}cz.restore()};var ck=function(cn,cq,cr,cp,co){if(co){cn.beginPath();cn.moveTo(cq,cp);cn.lineTo(cr,cp);cn.closePath();cn.stroke()}else{cn.beginPath();cn.moveTo(cp,cq);cn.lineTo(cp,cr);cn.closePath();cn.stroke()}};var bS=function(cx){cx=cx||{};var cy=(undefined===cx.frame?false:cx.frame);var cq=(undefined===cx.background?false:cx.background);var cs=(undefined===cx.led?false:cx.led);var cv=(undefined===cx.foreground?false:cx.foreground);var cr=(undefined===cx.bargraphled?false:cx.bargraphled);aT=true;bf();if(cy&&cb){k(bw,cg,a4,cf,bk)}if(cq&&cj){W(bG,bq,a4,cf,bk)}if(cs){if(bk){by.drawImage(ad(ba,1,bv),0,0);aS.drawImage(ad(ba,0,bv),0,0)}else{by.drawImage(ad(ba,1,bv),0,0);aS.drawImage(ad(ba,0,bv),0,0)}}if(bB){if(bk){ca.drawImage(v(bX,steelseries.ColorDef.BLUE.dark.getRgbaColor(),false,bk),0,0)}else{ca.drawImage(v(bX,steelseries.ColorDef.BLUE.dark.getRgbaColor(),false,bk),0,0)}}if(bx){if(bk){aU.drawImage(v(bX,steelseries.ColorDef.RED.medium.getRgbaColor(),false,bk),0,0)}else{aU.drawImage(v(bX,steelseries.ColorDef.RED.medium.getRgbaColor(),false,bk),0,0)}}if(cq&&cj){var cw;bN(bG,bu,bk);if(cl){bG.save();if(bk){cw=cf*0.856796-(cf*0.728155)*(b8/(bV-bZ));bG.translate(a4*0.365,cw-bX/2)}else{cw=(a4*0.856796-a4*0.12864)*b8/(bV-bZ);bG.translate(a4*0.142857-bX/2+cw,cf*0.58)}bG.drawImage(ci(bk),0,0);bG.restore()}if(bk){an(bG,a4,cf,bH,a2,bq,bk,null,bg)}else{an(bG,a4,cf,bH,a2,bq,bk,null,bg)}}if(cq&&bg){if(bk){b0=U(a4*0.571428,cf*0.055,bW);bG.drawImage(b0,((a4-(a4*0.571428))/2),cf*0.88)}else{b0=U(a4*0.18,cf*0.15,bW);bG.drawImage(b0,a4*0.695,cf*0.22)}}if(cr){ce(bo);br(aY,bJ)}aQ=false;if(null!==b6&&0<b6.length){aQ=true;var cu=b6.length;var ct,cn,cp,co;if(bk){ct=cf*0.12864;cn=cf*0.856796;cp=cn-ct;co=0}else{ct=a4*0.856796;cn=a4*0.12864;cp=ct-cn;co=a4*0.012135/2}aV=[];do{cu--;aV.push({start:(((b6[cu].start+Math.abs(bZ))/(bV-bZ))*cp-co),stop:(((b6[cu].stop+Math.abs(bZ))/(bV-bZ))*cp-co),color:r(b6[cu].color)})}while(0<cu)}aW=false;if(bb&&a3!==null){aQ=false;aW=true}if(cv&&b2){aI(a6,a4,cf,bk,false)}};var a7=function(co){co=co||{};var cp=(undefined===co.frame?false:co.frame);var cr=(undefined===co.background?false:co.background);var cs=(undefined===co.led?false:co.led);var cq=(undefined===co.bargraphled?false:co.bargraphled);var cn=(undefined===co.foreground?false:co.foreground);if(cp){bP.width=b9;bP.height=bh;bw=bP.getContext("2d")}if(cr){bD.width=b9;bD.height=bh;bG=bD.getContext("2d")}if(cq){if(bk){b5.width=b9*0.121428;b5.height=bh*0.012135}else{b5.width=b9*0.012135;b5.height=bh*0.121428}aY=b5.getContext("2d");if(bk){bT.width=b9*0.121428;bT.height=bh*0.012135}else{bT.width=b9*0.012135;bT.height=bh*0.121428}bo=bT.getContext("2d")}if(cs){be.width=Math.ceil(b9*0.093457);be.height=Math.ceil(bh*0.093457);by=be.getContext("2d");bl.width=Math.ceil(b9*0.093457);bl.height=Math.ceil(bh*0.093457);aS=bl.getContext("2d");bO=bl}if(cn){b3.width=b9;b3.height=bh;a6=b3.getContext("2d")}};var bR=function(cn){if(cn){bU=setInterval(b1,1000)}else{clearInterval(bU)}};var b1=function(){if(a1){if(bO===be){bO=bl}else{bO=be}if(!bQ){bQ=true;ab(b7.repaint)}}};var bY=function(cH,cW,cM){var cu;var cn;var cN=bq.labelColor;var cI;var cV;var cJ;var cB;var cz;var cv;var ct;var cT;var cS;var cR;var cQ;var cy;var cL;var cE;if(bk){cu=cM*0.12864;cn=cM*0.856796;cI=cn-cu;cV=cI*(bC-bZ)/(bV-bZ);cJ=cu+cI-cV;cB=0;cz=cu;cv=0;ct=cu+cI*1.014}else{cu=cW*0.856796;cn=cW*0.12864;cI=cu-cn;cV=cI*(bC-bZ)/(bV-bZ);cJ=cn;cB=cW*0.13;cz=cM*0.435714;cv=cB+cI*1.035;ct=cz}var cD=(bq===steelseries.BackgroundColor.CARBON||bq===steelseries.BackgroundColor.PUNCHED_SHEET||bq===steelseries.BackgroundColor.STAINLESS||bq===steelseries.BackgroundColor.BRUSHED_STAINLESS||bq===steelseries.BackgroundColor.TURNED)?0.3:0;var cG=cH.createLinearGradient(cB,cz,cv,ct);cN.setAlpha(0.047058+cD);cG.addColorStop(0,cN.getRgbaColor());cN.setAlpha(0.145098+cD);cG.addColorStop(0.48,cN.getRgbaColor());cN.setAlpha(0.149019+cD);cG.addColorStop(0.49,cN.getRgbaColor());cN.setAlpha(0.047058+cD);cG.addColorStop(1,cN.getRgbaColor());cH.fillStyle=cG;if(bk){cH.fillRect(cW*0.435714,cu,cW*0.15,cI*1.014)}else{cH.fillRect(cB,cz,cI*1.035,cM*0.152857)}if(bk){cT=0;cS=cu;cR=0;cQ=cu+cI*1.014}else{cT=cB;cS=0;cR=cv;cQ=0}var cF=cH.createLinearGradient(cT,cS,cR,cQ);cN.setAlpha(0.298039+cD);cF.addColorStop(0,cN.getRgbaColor());cN.setAlpha(0.686274+cD);cF.addColorStop(0.48,cN.getRgbaColor());cN.setAlpha(0.698039+cD);cF.addColorStop(0.49,cN.getRgbaColor());cN.setAlpha(0.4+cD);cF.addColorStop(1,cN.getRgbaColor());cH.fillStyle=cF;if(bk){cH.fillRect(cW*0.435714,cu,cW*0.007142,cI*1.014);cH.fillRect(cW*0.571428,cu,cW*0.007142,cI*1.014)}else{cH.fillRect(cW*0.13,cM*0.435714,cI*1.035,cM*0.007142);cH.fillRect(cW*0.13,cM*0.571428,cI*1.035,cM*0.007142)}var cq;var cp;var cr;var cx;var cC;var cA;var cK;var cw;if(bk){cq=cW*0.45;cp=cM*0.851941;cr=cW*0.121428;cx=cM*0.012135;cC=(cq+cr)/2;cA=(cp+cx)/2}else{cq=cW*0.142857;cp=cM*0.45;cr=cW*0.012135;cx=cM*0.121428;cC=(cq+cr)/2;cA=(cp+cx)/2}var cP,cO;var cs;var co=bJ;var cU;if(bk){cw=((bV+Math.abs(bZ))/(bV-bZ))*cI;for(cO=0;cO<=cw;cO+=cx+1){cH.translate(0,-cO);cH.drawImage(bT,cq,cp);cH.translate(0,cO)}cK=((bC+Math.abs(bZ))/(bV-bZ))*cI;for(cO=0;cO<=cK;cO+=cx+1){cs=bJ;if(aW){cy=bZ+(cO/cI)*(bV-bZ);cL=a3.getEnd()-a3.getStart();cE=cy/cL;cE=Math.max(Math.min(cE,1),0);cs=r(a3.getColorAt(cE).getRgbaColor())}else{if(aQ){for(cU=0;cU<aV.length;cU++){if(cO>=aV[cU].start&&cO<aV[cU].stop){cs=aV[cU].color;break}}}}if(co.medium.getHexColor()!==cs.medium.getHexColor()){br(aY,cs);co=cs}cH.translate(0,-cO);cH.drawImage(b5,cq,cp);cH.translate(0,cO)}}else{cw=((bV+Math.abs(bZ))/(bV-bZ))*cI;for(cP=-(cr/2);cP<=cw;cP+=cr+1){cH.translate(cP,0);cH.drawImage(bT,cq,cp);cH.translate(-cP,0)}cK=((bC+Math.abs(bZ))/(bV-bZ))*cI;for(cP=-(cr/2);cP<=cK;cP+=cr+1){cs=bJ;if(aW){cy=bZ+(cP/cI)*(bV-bZ);cL=a3.getEnd()-a3.getStart();cE=cy/cL;cE=Math.max(Math.min(cE,1),0);cs=r(a3.getColorAt(cE).getRgbaColor())}else{if(aQ){for(cU=0;cU<aV.length;cU++){if(cP>=aV[cU].start&&cP<aV[cU].stop){cs=aV[cU].color;break}}}}if(co.medium.getHexColor()!==cs.medium.getHexColor()){br(aY,cs);co=cs}cH.translate(cP,0);cH.drawImage(b5,cq,cp);cH.translate(-cP,0)}}};var ce=function(cn){cn.save();cn.beginPath();cn.rect(0,0,cn.canvas.width,cn.canvas.height);cn.closePath();var cq=(cn.canvas.width/2);var cp=(cn.canvas.height/2);var co=bd.createRadialGradient(cq,cp,0,cq,cp,cn.canvas.width/2);co.addColorStop(0,"#3c3c3c");co.addColorStop(1,"#323232");cn.fillStyle=co;cn.fill();cn.restore()};var br=function(cn,co){cn.save();cn.beginPath();cn.rect(0,0,cn.canvas.width,cn.canvas.height);cn.closePath();var cs=(cn.canvas.width/2);var cr=(cn.canvas.height/2);var cp;if(bk){cp=cn.canvas.width/2}else{cp=cn.canvas.height/2}var cq=bd.createRadialGradient(cs,cr,0,cs,cr,cp);cq.addColorStop(0,co.light.getRgbaColor());cq.addColorStop(1,co.dark.getRgbaColor());cn.fillStyle=cq;cn.fill();cn.restore()};this.setValue=function(co){co=parseFloat(co);var cn=(co<bZ?bZ:(co>bV?bV:co));if(bC!==cn){bC=cn;if(bC>bA){bA=bC}if(bC<bj){bj=bC}if(bC>=b8&&!bm){bm=true;bR(bm);if(cd){aR.play()}}else{if(bC<b8){bm=false;bR(bm);if(cd){aR.pause()}}}this.repaint()}};this.getValue=function(){return bC};this.setValueAnimated=function(cp){cp=parseFloat(cp);var cn=(cp<bZ?bZ:(cp>bV?bV:cp)),co=this;if(bC!==cn){if(undefined!==a8){if(a8.playing){a8.stop()}}a8=new Tween({},"",Tween.regularEaseInOut,bC,cn,1);a8.onMotionChanged=function(cq){bC=cq.target._pos;if(bC>=b8&&!bm){bm=true;bR(bm)}else{if(bC<b8){bm=false;bR(bm)}}if(bC>bA){bA=bC}if(bC<bj){bj=bC}if(!bQ){bQ=true;ab(co.repaint)}};a8.start()}};this.resetMinMeasuredValue=function(){bj=bC;this.repaint()};this.resetMaxMeasuredValue=function(){bA=bC;this.repaint()};this.setMinMeasuredValueVisible=function(cn){bB=cn;this.repaint()};this.setMaxMeasuredValueVisible=function(cn){bx=cn;this.repaint()};this.setThresholdVisible=function(cn){cl=cn;this.repaint()};this.setLcdDecimals=function(cn){ch=cn;this.repaint()};this.setFrameDesign=function(cn){a7({frame:true});cg=cn;bS({frame:true});this.repaint()};this.setBackgroundColor=function(cn){a7({background:true});bq=cn;bS({background:true});this.repaint()};this.setValueColor=function(cn){a7({bargraphled:true});bJ=cn;bS({bargraphled:true});this.repaint()};this.setLedColor=function(cn){a7({led:true});bv=cn;bS({led:true});this.repaint()};this.setLcdColor=function(cn){bW=cn;a7({background:true});bS({background:true});this.repaint()};this.setSection=function(cn){b6=cn;bS();this.repaint()};this.setSectionActive=function(cn){bK=cn;bS();this.repaint()};this.setGradient=function(cn){a3=cn;bS();this.repaint()};this.setGradientActive=function(cn){bb=cn;bS();this.repaint()};this.setMaxMeasuredValue=function(co){var cn=(co<bZ?bZ:(co>bV?bV:co));if(bA!==cn){bA=cn;this.repaint()}};this.setMinMeasuredValue=function(co){var cn=(co<bZ?bZ:(co>bV?bV:co));if(bj!==cn){bj=cn;this.repaint()}};this.setTitleString=function(cn){bH=cn;a7({background:true});bS({background:true});this.repaint()};this.setUnitString=function(cn){a2=cn;a7({background:true});bS({background:true});this.repaint()};this.setMinValue=function(cn){bZ=cn;a7({background:true,foreground:true,pointer:true});bS({background:true,foreground:true,pointer:true});this.repaint()};this.getMinValue=function(){return bZ};this.setMaxValue=function(cn){bV=cn;a7({background:true,foreground:true,pointer:true});bS({background:true,foreground:true,pointer:true});this.repaint()};this.getMaxValue=function(){return bV};this.setThreshold=function(co){co=parseFloat(co);var cn=(co<bZ?bZ:(co>bV?bV:co));if(b8!==cn){b8=cn;a7({background:true});bS({background:true});this.repaint()}};this.repaint=function(){if(!aT){bS({frame:true,background:true,led:true,pointer:true,foreground:true,bargraphled:true})}bd.clearRect(0,0,bd.canvas.width,bd.canvas.height);if(cb){bd.drawImage(bP,0,0)}if(cj){bd.drawImage(bD,0,0)}if(bg){b4(bd,bC,bk)}if(a1){if(bC<b8){bm=false;bO=bl}bd.drawImage(bO,a0,aX)}var cp;var co,cn;if(bB){if(bk){cp=cf*0.856796-(cf*0.728155)*(bj/(bV-bZ));co=a4*0.34-bi.width;cn=cp-bi.height/2}else{cp=((a4*0.856796)-(a4*0.12864))*bj/(bV-bZ);co=a4*0.142857-bi.height/2+cp;cn=cf*0.65}bd.drawImage(bi,co,cn)}if(bx){if(bk){cp=cf*0.856796-(cf*0.728155)*(bA/(bV-bZ));co=a4*0.34-bE.width;cn=cp-bE.height/2}else{cp=((a4*0.856796)-(a4*0.12864))*bA/(bV-bZ);co=a4*0.142857-bE.height/2+cp;cn=cf*0.65}bd.drawImage(bE,co,cn)}bd.save();bY(bd,a4,cf);bd.restore();if(b2){bd.drawImage(b3,0,0)}bQ=false};this.repaint();return this};var j=function(aT,a4){a4=a4||{};var bi=(undefined===a4.width?128:a4.width),be=(undefined===a4.height?48:a4.height),bm=(undefined===a4.lcdColor?steelseries.LcdColor.STANDARD:a4.lcdColor),a7=(undefined===a4.lcdDecimals?2:a4.lcdDecimals),aS=(undefined===a4.unitString?"":a4.unitString),aX=(undefined===a4.unitStringVisible?false:a4.unitStringVisible),ba=(undefined===a4.digitalFont?false:a4.digitalFont),bf=(undefined===a4.valuesNumeric?true:a4.valuesNumeric),bj=(undefined===a4.value?0:a4.value),a0=(undefined===a4.alwaysScroll?false:a4.alwaysScroll),aW=(undefined===a4.autoScroll?false:a4.autoScroll),a5=(undefined===a4.section?null:a4.section);var bb=false;var bk=0;var a1;var aZ=false;var bd=this;var a9=A.getElementById(aT).getContext("2d");a9.save();a9.clearRect(0,0,a9.canvas.width,a9.canvas.height);a9.canvas.width=bi;a9.canvas.height=be;var a8=bi;var bo=be;var aR=0;var bc=Math.floor(bo/1.5);var a3=bc+"px sans-serif";var bh=bc+"px "+aC;var aV=false;var aQ;var bn=[];var a6=[];var bg=function(br,bp){a9.save();a9.textAlign="right";a9.strokeStyle=bp;a9.fillStyle=bp;a9.beginPath();a9.rect(2,0,a8-4,bo);a9.closePath();a9.clip();a9.font=ba?bh:a3;if(bf){var bq=0;aR=0;if(aX){a9.font=Math.floor(bo/2.5)+"px sans-serif";bq=a9.measureText(aS).width}if(ba){a9.font=bh}else{a9.font=a3}var bs=br.toFixed(a7);aR=a9.measureText(bs).width;a9.fillText(bs,a8-bq-4-bk,bo*0.5+bc*0.38);if(aX){a9.font=Math.floor(bo/2.5)+"px sans-serif";a9.fillText(aS,a8-2-bk,bo*0.5+bc*0.38)}}else{aR=a9.measureText(br).width;if(a0||(aW&&aR>a8-4)){if(!bb){if(aR>a8*0.8){bk=a8-aR-a8*0.2}else{bk=0}bb=true;clearTimeout(a1);a1=setTimeout(aY,200)}}else{if(aW&&aR<=a8-4){bk=0;bb=false}}a9.fillText(br,a8-2-bk,bo*0.5+bc*0.38)}a9.restore()};var a2=function(bI,bF,bL,bN){var bt=I(bI,bF);var bu=bt.getContext("2d");bu.save();var bE=0;var bO=0;var br=bI;var bX=bF;var bB=Math.min(bI,bF)*0.095;var bK=bu.createLinearGradient(0,bO,0,bO+bX);bK.addColorStop(0,"#4c4c4c");bK.addColorStop(0.08,"#666666");bK.addColorStop(0.92,"#666666");bK.addColorStop(1,"#e6e6e6");bu.fillStyle=bK;O(bu,bE,bO,br,bX,bB);bu.fill();bu.restore();bu.save();var bq=az(bL);var bG=aw(bq[0],bq[1],bq[2]);var bv=az(bN.gradientStartColor);var bV=aw(bv[0],bv[1],bv[2]);var bD=az(bN.gradientFraction1Color);var bU=aw(bD[0],bD[1],bD[2]);var bA=az(bN.gradientFraction2Color);var bS=aw(bA[0],bA[1],bA[2]);var bz=az(bN.gradientFraction3Color);var bR=aw(bz[0],bz[1],bz[2]);var bs=az(bN.gradientStopColor);var bx=aw(bs[0],bs[1],bs[2]);var bH=aa(bG[0],bG[1],bV[2]-0.31);var bM=aa(bG[0],bG[1],bU[2]-0.31);var bQ=aa(bG[0],bG[1],bS[2]-0.31);var bW=aa(bG[0],bG[1],bR[2]-0.31);var bP=aa(bG[0],bG[1],bx[2]-0.31);var by=1;var bJ=1;var bp=bI-2;var bT=bF-2;var bw=bB-1;var bC=bu.createLinearGradient(0,bJ,0,bJ+bT);bC.addColorStop(0,"rgb("+bH[0]+", "+bH[1]+", "+bH[2]+")");bC.addColorStop(0.03,"rgb("+bM[0]+","+bM[1]+","+bM[2]+")");bC.addColorStop(0.49,"rgb("+bQ[0]+","+bQ[1]+","+bQ[2]+")");bC.addColorStop(0.5,"rgb("+bW[0]+","+bW[1]+","+bW[2]+")");bC.addColorStop(1,"rgb("+bP[0]+","+bP[1]+","+bP[2]+")");bu.fillStyle=bC;O(bu,by,bJ,bp,bT,bw);bu.fill();bu.restore();return bt};var aU=function(br){var bq=az(br);var bs=aw(bq[0],bq[1],bq[2]);var bp=aa(bs[0],0.57,0.83);return"rgb("+bp[0]+", "+bp[1]+", "+bp[2]+")"};var aY=function(){if(bb){if(bk>a8){bk=-aR}bk+=2;a1=setTimeout(aY,50)}else{bk=0}if(!aZ){aZ=true;ab(bd.repaint)}};var bl=function(){var bp;aV=true;aQ=U(bi,be,bm);if(null!==a5&&0<a5.length){for(bp=0;bp<a5.length;bp++){bn[bp]=a2(bi,be,a5[bp].color,bm);a6[bp]=aU(a5[bp].color)}}};this.setValue=function(bp){if(bj!==bp){bj=bp;this.repaint()}};this.setLcdColor=function(bp){bm=bp;bl();this.repaint()};this.setSection=function(bp){a5=bp;bl({background:true,foreground:true});this.repaint()};this.setScrolling=function(bp){if(bp){if(bb){return}else{bb=bp;aY()}}else{bb=bp}};this.repaint=function(){if(!aV){bl()}a9.clearRect(0,0,a9.canvas.width,a9.canvas.height);var bq=aQ;var bp=bm.textColor;var br;if(null!==a5&&0<a5.length){for(br=0;br<a5.length;br++){if(bj>=a5[br].start&&bj<=a5[br].stop){bq=bn[br];bp=a6[br];break}}}a9.drawImage(bq,0,0);bg(bj,bp);aZ=false};this.repaint();return this};var Q=function(aS,aW){aW=aW||{};var a8=(undefined===aW.width?128:aW.width),a3=(undefined===aW.height?64:aW.height),bb=(undefined===aW.lcdColor?steelseries.LcdColor.STANDARD:aW.lcdColor),aY=(undefined===aW.lcdDecimals?2:aW.lcdDecimals),aR=(undefined===aW.unitString?"":aW.unitString),aU=(undefined===aW.unitStringVisible?false:aW.unitStringVisible),a2=(undefined===aW.digitalFont?false:aW.digitalFont),a5=(undefined===aW.valuesNumeric?true:aW.valuesNumeric),a9=(undefined===aW.value?0:aW.value);var a4=0;var a1=A.getElementById(aS).getContext("2d");a1.save();a1.clearRect(0,0,a1.canvas.width,a1.canvas.height);a1.canvas.width=a8;a1.canvas.height=a3;var a0=a8;var bc=a3;var aV=Math.floor(bc/1.875)+"px sans-serif";var a7=Math.floor(bc/1.875)+"px "+aC;var aZ=Math.floor(bc/3.5)+"px sans-serif";var aX=Math.floor(bc/3.5)+"px "+aC;var aT=false;var aQ;var a6=function(bf){a1.save();a1.textAlign="right";a1.textBaseline="middle";a1.strokeStyle=bb.textColor;a1.fillStyle=bb.textColor;if(bb===steelseries.LcdColor.STANDARD||bb===steelseries.LcdColor.STANDARD_GREEN){a1.shadowColor="gray";a1.shadowOffsetX=bc*0.05;a1.shadowOffsetY=bc*0.05;a1.shadowBlur=bc*0.06}if(a5){a1.font=Math.floor(bc/2.5)+"px sans-serif";var be=0;if(aU){a1.font=Math.floor(bc/2.5)+"px sans-serif";be=a1.measureText(aR).width}if(a2){a1.font=a7}else{a1.font=aV}var bd=bf.toFixed(aY);a1.fillText(bd,a0-be-4,bc*0.38);if(aU){a1.font=Math.floor(bc/3)+"px sans-serif";a1.fillText(aR,a0-2,bc*0.46)}var bg=a4.toFixed(aY);if(a2){a1.font=aX}else{a1.font=aZ}a1.textAlign="center";a1.fillText(bg,a0/2,bc*0.8)}else{a1.font=Math.floor(bc/2.5)+"px sans-serif";a1.fillText(bf,a0-2,bc*0.38);a1.font=aZ;a1.textAlign="center";a1.fillText(a4,a0/2,bc*0.8)}a1.restore()};var ba=function(){aT=true;aQ=U(a8,a3,bb)};this.setValue=function(bd){if(a9!==bd||a4!==bd){a4=a9;a9=bd;this.repaint()}};this.setLcdColor=function(bd){bb=bd;ba();this.repaint()};this.repaint=function(){if(!aT){ba()}a1.clearRect(0,0,a1.canvas.width,a1.canvas.height);a1.drawImage(aQ,0,0);a6(a9)};this.repaint();return this};var al=function(a1,bm){bm=bm||{};var a0=(undefined===bm.size?200:bm.size),bq=(undefined===bm.decimalsVisible?false:bm.decimalsVisible),aZ=(undefined===bm.textOrientationFixed?false:bm.textOrientationFixed),aT=(undefined===bm.frameDesign?steelseries.FrameDesign.METAL:bm.frameDesign),bb=(undefined===bm.frameVisible?true:bm.frameVisible),aR=(undefined===bm.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bm.backgroundColor),a9=(undefined===bm.backgroundVisible?true:bm.backgroundVisible),bs=(undefined===bm.pointerColor?steelseries.ColorDef.RED:bm.pointerColor),bp=(undefined===bm.foregroundType?steelseries.ForegroundType.TYPE1:bm.foregroundType),bo=(undefined===bm.foregroundVisible?true:bm.foregroundVisible);var a5;var a4=false;var bh=0;var be=0;var bc=0;var bi=G/360;var a6=this.value;var a8=bq?1:0;var bl=A.getElementById(a1).getContext("2d");bl.save();bl.clearRect(0,0,bl.canvas.width,bl.canvas.height);bl.canvas.width=a0;bl.canvas.height=a0;var bt=a0;var bd=a0;var aW=bt/2;var aV=bd/2;var a2=false;var bf=I(a0,a0);var aQ=bf.getContext("2d");var ba=I(a0,a0);var aS=ba.getContext("2d");var bg=I(a0,a0);var aU=bg.getContext("2d");var bj=I(a0,a0);var a7=bj.getContext("2d");var br=function(bu){var bx,bw,bv;bu.textAlign="center";bu.textBaseline="middle";bu.save();bu.strokeStyle=aR.labelColor.getRgbaColor();bu.fillStyle=aR.labelColor.getRgbaColor();bu.translate(aW,aV);for(bv=0;360>bv;bv++){bu.strokeStyle=aR.labelColor.getRgbaColor();bu.lineWidth=0.5;bu.beginPath();bu.moveTo(bt*0.38,0);bu.lineTo(bt*0.37,0);bu.closePath();bu.stroke();if(0===bv%5){bu.strokeStyle=aR.labelColor.getRgbaColor();bu.lineWidth=1;bu.beginPath();bu.moveTo(bt*0.38,0);bu.lineTo(bt*0.36,0);bu.closePath();bu.stroke()}if(0===bv%45){bu.strokeStyle=aR.labelColor.getRgbaColor();bu.lineWidth=1;bu.beginPath();bu.moveTo(bt*0.38,0);bu.lineTo(bt*0.34,0);bu.closePath();bu.stroke()}if(300<bt){bx="14px sans-serif";bw="12px sans-serif"}if(300>=bt){bx="12px sans-serif";bw="10px sans-serif"}if(200>=bt){bx="10px sans-serif";bw="8px sans-serif"}if(100>=bt){bx="8px sans-serif";bw="6px sans-serif"}bu.save();switch(bv){case 0:bu.translate(bt*0.31,0);bu.rotate((bv*l)+R);bu.font=bx;bu.fillText("0\u00B0",0,0,bt);bu.rotate(-(bv*l)+R);bu.translate(-bt*0.31,0);bu.translate(bt*0.41,0);bu.rotate((bv*l)-R);bu.font=bw;bu.fillText("0%",0,0,bt);break;case 45:bu.translate(bt*0.31,0);bu.rotate((bv*l)+0.25*am);bu.font=bx;bu.fillText("45\u00B0",0,0,bt);bu.rotate(-(bv*l)+0.25*am);bu.translate(-bt*0.31,0);bu.translate(bt*0.31,bt*0.085);bu.rotate((bv*l)-0.25*am);bu.font=bw;bu.fillText("100%",0,0,bt);break;case 90:bu.translate(bt*0.31,0);bu.rotate((bv*l));bu.font=bx;bu.fillText("90\u00B0",0,0,bt);bu.rotate(-(bv*l));bu.translate(-bt*0.31,0);bu.translate(bt*0.21,0);bu.rotate((bv*l));bu.font=bw;bu.fillText("\u221E",0,0,bt);break;case 135:bu.translate(bt*0.31,0);bu.rotate((bv*l)-0.25*am);bu.font=bx;bu.fillText("45\u00B0",0,0,bt);bu.rotate(-(bv*l)-0.25*am);bu.translate(-bt*0.31,0);bu.translate(bt*0.31,-bt*0.085);bu.rotate((bv*l)+0.25*am);bu.font=bw;bu.fillText("100%",0,0,bt);break;case 180:bu.translate(bt*0.31,0);bu.rotate((bv*l)-R);bu.font=bx;bu.fillText("0\u00B0",0,0,bt);bu.rotate(-(bv*l)-R);bu.translate(-bt*0.31,0);bu.translate(bt*0.41,0);bu.rotate((bv*l)+R);bu.font=bw;bu.fillText("0%",0,0,bt);bu.translate(-bt*0.41,0);break;case 225:bu.translate(bt*0.31,0);bu.rotate((bv*l)-0.75*am);bu.font=bx;bu.fillText("45\u00B0",0,0,bt);bu.rotate(-(bv*l)-0.75*am);bu.translate(-bt*0.31,0);bu.translate(bt*0.31,bt*0.085);bu.rotate((bv*l)+0.75*am);bu.font=bw;bu.fillText("100%",0,0,bt);break;case 270:bu.translate(bt*0.31,0);bu.rotate((bv*l)-am);bu.font=bx;bu.fillText("90\u00B0",0,0,bt);bu.rotate(-(bv*l)-am);bu.translate(-bt*0.31,0);bu.translate(bt*0.21,0);bu.rotate((bv*l)-am);bu.font=bw;bu.fillText("\u221E",0,0,bt);break;case 315:bu.translate(bt*0.31,0);bu.rotate((bv*l)-1.25*am);bu.font=bx;bu.fillText("45\u00B0",0,0,bt);bu.rotate(-(bv*l)-1.25*am);bu.translate(-bt*0.31,0);bu.translate(bt*0.31,-bt*0.085);bu.rotate((bv*l)+1.25*am);bu.font=bw;bu.fillText("100%",0,0,bt);break}bu.restore();bu.rotate(bi)}bu.translate(-aW,-aV);bu.restore()};var aY=function(bu){bu.save();bu.strokeStyle=aR.labelColor.getRgbaColor();bu.fillStyle=aR.labelColor.getRgbaColor();bu.save();bu.beginPath();bu.moveTo(bt*0.200934,bd*0.434579);bu.lineTo(bt*0.163551,bd*0.434579);bu.lineTo(bt*0.163551,bd*0.560747);bu.lineTo(bt*0.200934,bd*0.560747);bu.lineWidth=1;bu.lineCap="square";bu.lineJoin="miter";bu.stroke();bu.save();bu.beginPath();bu.moveTo(bt*0.163551,bd*0.471962);bu.lineTo(bt*0.205607,bd*0.5);bu.lineTo(bt*0.163551,bd*0.523364);bu.lineTo(bt*0.163551,bd*0.471962);bu.closePath();bu.fill();bu.save();bu.beginPath();bu.moveTo(bt*0.799065,bd*0.434579);bu.lineTo(bt*0.836448,bd*0.434579);bu.lineTo(bt*0.836448,bd*0.560747);bu.lineTo(bt*0.799065,bd*0.560747);bu.lineWidth=1;bu.lineCap="square";bu.lineJoin="miter";bu.stroke();bu.save();bu.beginPath();bu.moveTo(bt*0.836448,bd*0.471962);bu.lineTo(bt*0.794392,bd*0.5);bu.lineTo(bt*0.836448,bd*0.523364);bu.lineTo(bt*0.836448,bd*0.471962);bu.closePath();bu.fill();bu.restore()};var a3=function(bv){bv.save();bv.save();bv.beginPath();bv.moveTo(bt*0.523364,bd*0.350467);bv.lineTo(bt*0.5,bd*0.130841);bv.lineTo(bt*0.476635,bd*0.350467);bv.bezierCurveTo(bt*0.476635,bd*0.350467,bt*0.490654,bd*0.345794,bt*0.5,bd*0.345794);bv.bezierCurveTo(bt*0.509345,bd*0.345794,bt*0.523364,bd*0.350467,bt*0.523364,bd*0.350467);bv.closePath();var bu=bv.createLinearGradient(0,0.154205*bd,0,0.350466*bd);var bx=bs.dark;var bw=bs.light;bx.setAlpha(0.70588);bw.setAlpha(0.70588);bu.addColorStop(0,bx.getRgbaColor());bu.addColorStop(0.3,bw.getRgbaColor());bu.addColorStop(0.59,bw.getRgbaColor());bu.addColorStop(1,bx.getRgbaColor());bv.fillStyle=bu;var by=bs.light.getRgbaColor();bv.lineWidth=1;bv.lineCap="square";bv.lineJoin="miter";bv.strokeStyle=by;bv.fill();bv.stroke();bx.setAlpha(1);bw.setAlpha(1);bv.restore()};var aX=function(bu){bu.save();var bz=bs.dark;var bv=bs.light;bz.setAlpha(0.70588);bv.setAlpha(0.70588);bu.save();bu.beginPath();bu.moveTo(bt*0.285046,bd*0.514018);bu.lineTo(bt*0.21028,bd*0.5);bu.lineTo(bt*0.285046,bd*0.481308);bu.bezierCurveTo(bt*0.285046,bd*0.481308,bt*0.280373,bd*0.490654,bt*0.280373,bd*0.495327);bu.bezierCurveTo(bt*0.280373,bd*0.504672,bt*0.285046,bd*0.514018,bt*0.285046,bd*0.514018);bu.closePath();var bw=bu.createLinearGradient(0.224299*bt,0,0.289719*bt,0);bw.addColorStop(0,bz.getRgbaColor());bw.addColorStop(0.3,bv.getRgbaColor());bw.addColorStop(0.59,bv.getRgbaColor());bw.addColorStop(1,bz.getRgbaColor());bu.fillStyle=bw;var bA=bs.light.getRgbaColor();bu.lineWidth=1;bu.lineCap="square";bu.lineJoin="miter";bu.strokeStyle=bA;bu.fill();bu.stroke();bu.save();bu.beginPath();bu.moveTo(bt*0.714953,bd*0.514018);bu.lineTo(bt*0.789719,bd*0.5);bu.lineTo(bt*0.714953,bd*0.481308);bu.bezierCurveTo(bt*0.714953,bd*0.481308,bt*0.719626,bd*0.490654,bt*0.719626,bd*0.495327);bu.bezierCurveTo(bt*0.719626,bd*0.504672,bt*0.714953,bd*0.514018,bt*0.714953,bd*0.514018);bu.closePath();var bx=bu.createLinearGradient(0.7757*bt,0,0.71028*bt,0);bx.addColorStop(0,bz.getRgbaColor());bx.addColorStop(0.3,bv.getRgbaColor());bx.addColorStop(0.59,bv.getRgbaColor());bx.addColorStop(1,bz.getRgbaColor());bu.fillStyle=bx;var by=bs.light.getRgbaColor();bu.lineWidth=1;bu.lineCap="square";bu.lineJoin="miter";bu.strokeStyle=by;bu.fill();bu.stroke();bz.setAlpha(1);bv.setAlpha(1);bu.restore()};var bk=function(){a2=true;if(bb){d(aQ,aT,aW,aV,bt,bd)}if(a9){aO(aQ,aR,aW,aV,bt,bd);br(aQ)}aY(aS);a3(aS);aX(aU);if(bo){z(a7,bp,bt,bd,false)}};var bn=function(){bf.width=a0;bf.height=a0;aQ=bf.getContext("2d");ba.width=a0;ba.height=a0;aS=ba.getContext("2d");bg.width=a0;bg.height=a0;aU=bg.getContext("2d");bj.width=a0;bj.height=a0;a7=bj.getContext("2d")};this.setValue=function(bv){var bu;bu=0>bv?(360+bv):bv;bu=359.9<bv?(bv-360):bv;if(bh!==bu){bh=bu;be=2*((Math.abs(bh)*10)%10);if(10<be){be-=20}if(0===bh){bc=90}if(0<bh&&90>=bh){bc=(90-bh)}if(90<bh&&180>=bh){bc=(bh-90)}if(180<bh&&270>=bh){bc=(270-bh)}if(270<bh&&360>=bh){bc=(bh-270)}if(0>bh&&bh>=-90){bc=(90-Math.abs(bh))}if(bh<-90&&bh>=-180){bc=Math.abs(bh)-90}if(bh<-180&&bh>=-270){bc=270-Math.abs(bh)}if(bh<-270&&bh>=-360){bc=Math.abs(bh)-270}this.repaint()}};this.getValue=function(){return bh};this.setValueAnimated=function(bv){if(360-bv+bh<bv-bh){bv=360-bv}if(bh!==bv){if(undefined!==a5){if(a5.playing){a5.stop()}}a5=new Tween({},"",Tween.regularEaseInOut,bh,bv,1);var bu=this;a5.onMotionChanged=function(bw){bh=bw.target._pos;be=2*((Math.abs(bh)*10)%10);if(10<be){be-=20}if(0===bh){bc=90}if(0<bh&&90>=bh){bc=(90-bh)}if(90<bh&&180>=bh){bc=(bh-90)}if(180<bh&&270>=bh){bc=(270-bh)}if(270<bh&&360>=bh){bc=(bh-270)}if(0>bh&&bh>=-90){bc=(90-Math.abs(bh))}if(bh<-90&&bh>=-180){bc=Math.abs(bh)-90}if(bh<-180&&bh>=-270){bc=270-Math.abs(bh)}if(bh<-270&&bh>=-360){bc=Math.abs(bh)-270}if(!a4){a4=true;ab(bu.repaint)}};a5.start()}};this.setFrameDesign=function(bu){bn();aT=bu;bk();this.repaint()};this.setBackgroundColor=function(bu){bn();aR=bu;bk();this.repaint()};this.setForegroundType=function(bu){bn();bp=bu;bk();this.repaint()};this.setPointerColor=function(bu){bn();bs=bu;bk();this.repaint()};this.repaint=function(){if(!a2){bk()}bl.save();bl.clearRect(0,0,bl.canvas.width,bl.canvas.height);if(bb||a9){bl.drawImage(bf,0,0)}a6=R+bh*bi-R;bl.save();bl.translate(aW,aV);bl.rotate(a6);bl.translate(-aW,-aV);bl.drawImage(ba,0,0);bl.fillStyle=aR.labelColor.getRgbaColor();bl.textAlign="center";bl.textBaseline="middle";if(aZ){bl.restore();if(bq){bl.font=bt*0.1+"px sans-serif"}else{bl.font=bt*0.15+"px sans-serif"}bl.fillText(bc.toFixed(a8)+"\u00B0",aW,aV,bt*0.35)}else{if(bq){bl.font=bt*0.15+"px sans-serif"}else{bl.font=bt*0.2+"px sans-serif"}bl.fillText(bc.toFixed(a8)+"\u00B0",aW,aV,bt*0.35);bl.restore()}bl.translate(aW,aV);bl.rotate(a6+be*l);bl.translate(-aW,-aV);bl.drawImage(bg,0,0);bl.restore();if(bo){bl.drawImage(bj,0,0)}bl.restore();a4=false};this.repaint();return this};var at=function(aY,bk){bk=bk||{};var aX=(undefined===bk.size?200:bk.size),aT=(undefined===bk.frameDesign?steelseries.FrameDesign.METAL:bk.frameDesign),bb=(undefined===bk.frameVisible?true:bk.frameVisible),aR=(undefined===bk.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bk.backgroundColor),a9=(undefined===bk.backgroundVisible?true:bk.backgroundVisible),a7=(undefined===bk.pointerType?steelseries.PointerType.TYPE2:bk.pointerType),bp=(undefined===bk.pointerColor?steelseries.ColorDef.RED:bk.pointerColor),bq=(undefined===bk.knobType?steelseries.KnobType.STANDARD_KNOB:bk.knobType),bc=(undefined===bk.knobStyle?steelseries.KnobStyle.SILVER:bk.knobStyle),bn=(undefined===bk.foregroundType?steelseries.ForegroundType.TYPE1:bk.foregroundType),bm=(undefined===bk.foregroundVisible?true:bk.foregroundVisible),a4=(undefined===bk.pointSymbols?["N","NE","E","SE","S","SW","W","NW"]:bk.pointSymbols),bs=(undefined===bk.customLayer?null:bk.customLayer),aZ=(undefined===bk.degreeScale?false:bk.degreeScale),aW=(undefined===bk.roseVisible?true:bk.roseVisible);var a3;var a2=false;var bf=0;var bg=l;var a6=this.value;var bj=A.getElementById(aY).getContext("2d");bj.save();bj.clearRect(0,0,bj.canvas.width,bj.canvas.height);bj.canvas.width=aX;bj.canvas.height=aX;var br=aX;var bd=aX;var aV=br/2;var aU=bd/2;var a5=br*0.006;var a0=false;var be=I(aX,aX);var aQ=be.getContext("2d");var ba=I(aX,aX);var aS=ba.getContext("2d");var bh=I(aX,aX);var a8=bh.getContext("2d");var bo=function(bt){bt.textAlign="center";bt.textBaseline="middle";var bw,bv,bu;bt.save();bt.strokeStyle=aR.labelColor.getRgbaColor();bt.fillStyle=aR.labelColor.getRgbaColor();bt.translate(aV,aU);if(!aZ){bw=0.12*br+"px serif";bv=0.06*br+"px serif";for(bu=0;360>bu;bu+=2.5){if(0===bu%5){bt.lineWidth=1;bt.beginPath();bt.moveTo(br*0.38,0);bt.lineTo(br*0.36,0);bt.closePath();bt.stroke()}bt.save();switch(bu){case 0:bt.translate(br*0.35,0);bt.rotate(R);bt.font=bw;bt.fillText(a4[2],0,0,br);bt.translate(-br*0.35,0);break;case 45:bt.translate(br*0.29,0);bt.rotate(R);bt.font=bv;bt.fillText(a4[3],0,0,br);bt.translate(-br*0.29,0);break;case 90:bt.translate(br*0.35,0);bt.rotate(R);bt.font=bw;bt.fillText(a4[4],0,0,br);bt.translate(-br*0.35,0);break;case 135:bt.translate(br*0.29,0);bt.rotate(R);bt.font=bv;bt.fillText(a4[5],0,0,br);bt.translate(-br*0.29,0);break;case 180:bt.translate(br*0.35,0);bt.rotate(R);bt.font=bw;bt.fillText(a4[6],0,0,br);bt.translate(-br*0.35,0);break;case 225:bt.translate(br*0.29,0);bt.rotate(R);bt.font=bv;bt.fillText(a4[7],0,0,br);bt.translate(-br*0.29,0);break;case 270:bt.translate(br*0.35,0);bt.rotate(R);bt.font=bw;bt.fillText(a4[0],0,0,br);bt.translate(-br*0.35,0);break;case 315:bt.translate(br*0.29,0);bt.rotate(R);bt.font=bv;bt.fillText(a4[1],0,0,br);bt.translate(-br*0.29,0);break}bt.restore();if(aW&&(0===bu||22.5===bu||45===bu||67.5===bu||90===bu||112.5===bu||135===bu||157.5===bu||180===bu||202.5===bu||225===bu||247.5===bu||270===bu||292.5===bu||315===bu||337.5===bu||360===bu)){bt.save();bt.beginPath();if(bu%45){bt.moveTo(br*0.29,0)}else{bt.moveTo(br*0.38,0)}bt.lineTo(br*0.1,0);bt.closePath();bt.restore();bt.lineWidth=1;bt.strokeStyle=aR.symbolColor.getRgbaColor();bt.stroke()}bt.rotate(bg*2.5)}}else{bw=0.08*br+"px serif";bv=br*0.033+"px serif";bt.rotate(bg*10);for(bu=10;360>=bu;bu+=10){bt.save();switch(bu){case 360:bt.translate(br*0.35,0);bt.rotate(R);bt.font=bw;bt.fillText(a4[2],0,0,br);bt.translate(-br*0.35,0);break;case 90:bt.translate(br*0.35,0);bt.rotate(R);bt.font=bw;bt.fillText(a4[4],0,0,br);bt.translate(-br*0.35,0);break;case 180:bt.translate(br*0.35,0);bt.rotate(R);bt.font=bw;bt.fillText(a4[6],0,0,br);bt.translate(-br*0.35,0);break;case 270:bt.translate(br*0.35,0);bt.rotate(R);bt.font=bw;bt.fillText(a4[0],0,0,br);bt.translate(-br*0.35,0);break;default:var bx=(bu+90)%360;bt.translate(br*0.37,0);bt.rotate(R);bt.font=bv;bt.fillText(("0".substring(bx>=100)+bx),0,0,br);bt.translate(-br*0.37,0)}bt.restore();bt.rotate(bg*10)}}bt.translate(-aV,-aU);bt.restore()};var a1=function(bu){bu.save();switch(a7.type){case"type2":bu.beginPath();bu.moveTo(br*0.53271,bd*0.453271);bu.bezierCurveTo(br*0.53271,bd*0.453271,br*0.5,bd*0.149532,br*0.5,bd*0.149532);bu.bezierCurveTo(br*0.5,bd*0.149532,br*0.467289,bd*0.453271,br*0.467289,bd*0.453271);bu.bezierCurveTo(br*0.453271,bd*0.462616,br*0.443925,bd*0.481308,br*0.443925,bd*0.5);bu.bezierCurveTo(br*0.443925,bd*0.5,br*0.556074,bd*0.5,br*0.556074,bd*0.5);bu.bezierCurveTo(br*0.556074,bd*0.481308,br*0.546728,bd*0.462616,br*0.53271,bd*0.453271);bu.closePath();var by=bu.createLinearGradient(0.471962*br,0,0.528036*br,0);by.addColorStop(0,bp.light.getRgbaColor());by.addColorStop(0.46,bp.light.getRgbaColor());by.addColorStop(0.47,bp.medium.getRgbaColor());by.addColorStop(1,bp.medium.getRgbaColor());bu.fillStyle=by;bu.strokeStyle=bp.dark.getRgbaColor();bu.lineWidth=1;bu.lineCap="square";bu.lineJoin="miter";bu.fill();bu.stroke();bu.beginPath();bu.moveTo(br*0.467289,bd*0.546728);bu.bezierCurveTo(br*0.467289,bd*0.546728,br*0.5,bd*0.850467,br*0.5,bd*0.850467);bu.bezierCurveTo(br*0.5,bd*0.850467,br*0.53271,bd*0.546728,br*0.53271,bd*0.546728);bu.bezierCurveTo(br*0.546728,bd*0.537383,br*0.556074,bd*0.518691,br*0.556074,bd*0.5);bu.bezierCurveTo(br*0.556074,bd*0.5,br*0.443925,bd*0.5,br*0.443925,bd*0.5);bu.bezierCurveTo(br*0.443925,bd*0.518691,br*0.453271,bd*0.537383,br*0.467289,bd*0.546728);bu.closePath();var bA=bu.createLinearGradient(0.471962*br,0,0.528036*br,0);bA.addColorStop(0,"#e3e5e8");bA.addColorStop(0.48,"#e3e5e8");bA.addColorStop(0.48,"#abb1b8");bA.addColorStop(1,"#abb1b8");bu.fillStyle=bA;var bv="#abb1b8";bu.strokeStyle=bv;bu.lineWidth=1;bu.lineCap="square";bu.lineJoin="miter";bu.fill();bu.stroke();break;case"type3":bu.beginPath();bu.moveTo(br*0.5,bd*0.149532);bu.bezierCurveTo(br*0.5,bd*0.149532,br*0.443925,bd*0.490654,br*0.443925,bd*0.5);bu.bezierCurveTo(br*0.443925,bd*0.53271,br*0.467289,bd*0.556074,br*0.5,bd*0.556074);bu.bezierCurveTo(br*0.53271,bd*0.556074,br*0.556074,bd*0.53271,br*0.556074,bd*0.5);bu.bezierCurveTo(br*0.556074,bd*0.490654,br*0.5,bd*0.149532,br*0.5,bd*0.149532);bu.closePath();var bz=bu.createLinearGradient(0.471962*br,0,0.528036*br,0);bz.addColorStop(0,bp.light.getRgbaColor());bz.addColorStop(0.46,bp.light.getRgbaColor());bz.addColorStop(0.47,bp.medium.getRgbaColor());bz.addColorStop(1,bp.medium.getRgbaColor());bu.fillStyle=bz;bu.strokeStyle=bp.dark.getRgbaColor();bu.lineWidth=1;bu.lineCap="square";bu.lineJoin="miter";bu.fill();bu.stroke();break;case"type1:":default:bu.beginPath();bu.moveTo(br*0.5,bd*0.495327);bu.lineTo(br*0.528037,bd*0.495327);bu.lineTo(br*0.5,bd*0.149532);bu.lineTo(br*0.471962,bd*0.495327);bu.lineTo(br*0.5,bd*0.495327);bu.closePath();var bw=bu.createLinearGradient(0.471962*br,0,0.528036*br,0);bw.addColorStop(0,bp.light.getRgbaColor());bw.addColorStop(0.46,bp.light.getRgbaColor());bw.addColorStop(0.47,bp.medium.getRgbaColor());bw.addColorStop(1,bp.medium.getRgbaColor());bu.fillStyle=bw;bu.strokeStyle=bp.dark.getRgbaColor();bu.lineWidth=1;bu.lineCap="square";bu.lineJoin="miter";bu.fill();bu.stroke();bu.beginPath();bu.moveTo(br*0.5,bd*0.504672);bu.lineTo(br*0.471962,bd*0.504672);bu.lineTo(br*0.5,bd*0.850467);bu.lineTo(br*0.528037,bd*0.504672);bu.lineTo(br*0.5,bd*0.504672);bu.closePath();var bx=bu.createLinearGradient(0.471962*br,0,0.528036*br,0);bx.addColorStop(0,"#e3e5e8");bx.addColorStop(0.48,"#e3e5e8");bx.addColorStop(0.480099,"#abb1b8");bx.addColorStop(1,"#abb1b8");bu.fillStyle=bx;var bt="#abb1b8";bu.strokeStyle=bt;bu.lineWidth=1;bu.lineCap="square";bu.lineJoin="miter";bu.fill();bu.stroke();break}bu.restore()};var bi=function(){a0=true;if(bb){d(aQ,aT,aV,aU,br,bd)}if(a9){aO(aQ,aR,aV,aU,br,bd);P(aQ,bs,aV,aU,br,bd);if(aW){e(aQ,aV,aU,br,bd,aR)}bo(aQ)}a1(aS,false);if(bm){z(a8,bn,br,bd,true,bq,bc)}};var bl=function(){be.width=aX;be.height=aX;aQ=be.getContext("2d");ba.width=aX;ba.height=aX;aS=ba.getContext("2d");bh.width=aX;bh.height=aX;a8=bh.getContext("2d")};this.setValue=function(bt){bt=bt%360;if(bf!==bt){bf=bt;this.repaint()}};this.getValue=function(){return bf};this.setValueAnimated=function(bw){var bt=bw%360;var bu=this;var bv;if(bf!==bt){if(undefined!==a3){if(a3.playing){a3.stop()}}bv=ai(bf,bt);a3=new Tween({},"",Tween.elasticEaseOut,bf,bf+bv,2);a3.onMotionChanged=function(bx){bf=bx.target._pos%360;if(!a2){a2=true;ab(bu.repaint)}};a3.start()}};this.setFrameDesign=function(bt){bl();aT=bt;bi();this.repaint()};this.setBackgroundColor=function(bt){bl();aR=bt;bi();this.repaint()};this.setForegroundType=function(bt){bl();bn=bt;bi();this.repaint()};this.setPointerColor=function(bt){bl();bp=bt;bi();this.repaint()};this.setPointerType=function(bt){bl();a7=bt;bi();this.repaint()};this.setPointSymbols=function(bt){bl();a4=bt;bi();this.repaint()};this.repaint=function(){if(!a0){bi()}bj.clearRect(0,0,bj.canvas.width,bj.canvas.height);if(bb||a9){bj.drawImage(be,0,0)}a6=R+bf*bg-R;bj.save();bj.translate(aV,aU);bj.rotate(a6);bj.translate(-aV,-aU);bj.shadowColor="rgba(0, 0, 0, 0.8)";bj.shadowOffsetX=bj.shadowOffsetY=a5;bj.shadowBlur=a5*2;bj.drawImage(ba,0,0);bj.restore();if(bm){bj.drawImage(bh,0,0)}bj.restore();a2=false};this.repaint();return this};var H=function(a2,bG){bG=bG||{};var a1=(undefined===bG.size?200:bG.size),aS=(undefined===bG.frameDesign?steelseries.FrameDesign.METAL:bG.frameDesign),bq=(undefined===bG.frameVisible?true:bG.frameVisible),aR=(undefined===bG.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bG.backgroundColor),bk=(undefined===bG.backgroundVisible?true:bG.backgroundVisible),bB=(undefined===bG.pointerTypeLatest?steelseries.PointerType.TYPE1:bG.pointerTypeLatest),a7=(undefined===bG.pointerTypeAverage?steelseries.PointerType.TYPE8:bG.pointerTypeAverage),bQ=(undefined===bG.pointerColor?steelseries.ColorDef.RED:bG.pointerColor),by=(undefined===bG.pointerColorAverage?steelseries.ColorDef.BLUE:bG.pointerColorAverage),bR=(undefined===bG.knobType?steelseries.KnobType.STANDARD_KNOB:bG.knobType),bs=(undefined===bG.knobStyle?steelseries.KnobStyle.SILVER:bG.knobStyle),bL=(undefined===bG.foregroundType?steelseries.ForegroundType.TYPE1:bG.foregroundType),bK=(undefined===bG.foregroundVisible?true:bG.foregroundVisible),a9=(undefined===bG.pointSymbols?["N","NE","E","SE","S","SW","W","NW"]:bG.pointSymbols),bU=(undefined===bG.customLayer?null:bG.customLayer),a4=(undefined===bG.degreeScale?true:bG.degreeScale),aY=(undefined===bG.roseVisible?false:bG.roseVisible),bp=(undefined===bG.lcdColor?steelseries.LcdColor.STANDARD:bG.lcdColor),bA=(undefined===bG.lcdVisible?true:bG.lcdVisible),aZ=(undefined===bG.digitalFont?false:bG.digitalFont),bd=(undefined===bG.section?null:bG.section),br=(undefined===bG.area?null:bG.area),bI=(undefined===bG.lcdTitleStrings?["Latest","Average"]:bG.lcdTitleStrings),ba=(undefined===bG.titleString?"":bG.titleString),be=(undefined===bG.useColorLabels?false:bG.useColorLabels);var bf;var bc;var bP=0;var bh=0;var bz=l;var bt=this.valueLatest;var bJ=this.valueAverage;var bD=-R;var bg=G;var a3=360;var a6=false;var bF=A.getElementById(a2).getContext("2d");bF.save();bF.clearRect(0,0,bF.canvas.width,bF.canvas.height);bF.canvas.width=a1;bF.canvas.height=a1;var bT=a1;var bu=a1;var aV=bT/2;var aU=bu/2;var bO=Math.floor(bT/10);var bn=bO+"px sans-serif";var bx=bO+"px "+aC;var aT=bT*0.3;var bm=bu*0.12;var bj=(bT-aT)/2;var aX=bu*0.32;var aW=bu*0.565;var a5=false;var bv=I(a1,a1);var aQ=bv.getContext("2d");var bN;var bo=I(a1,a1);var a0=bo.getContext("2d");var bS=I(a1,a1);var bb=bS.getContext("2d");var bC=I(a1,a1);var bi=bC.getContext("2d");var a8=function(bW,bV){bF.save();bF.textAlign="center";bF.strokeStyle=bp.textColor;bF.fillStyle=bp.textColor;if(bW<0){bW+=360}bW="00"+Math.round(bW);bW=bW.substring(bW.length,bW.length-3);if(bp===steelseries.LcdColor.STANDARD||bp===steelseries.LcdColor.STANDARD_GREEN){bF.shadowColor="gray";bF.shadowOffsetX=bT*0.007;bF.shadowOffsetY=bT*0.007;bF.shadowBlur=bT*0.007}bF.font=(aZ?bx:bn);bF.fillText(bW+"\u00B0",bT/2+aT*0.05,(bV?aX:aW)+bm*0.5+bO*0.38,aT*0.9);bF.restore()};var bw=function(bV,b1,bY,bW,bZ){bV.save();bV.strokeStyle=bW;bV.fillStyle=bW;bV.lineWidth=bT*0.035;var bX=(bg/a3*b1);var b0=bX+(bY-b1)/(a3/bg);bV.translate(aV,aU);bV.rotate(bD);bV.beginPath();if(bZ){bV.moveTo(0,0);bV.arc(0,0,bT*0.365-bV.lineWidth/2,bX,b0,false)}else{bV.arc(0,0,bT*0.365,bX,b0,false)}if(bZ){bV.moveTo(0,0);bV.fill()}else{bV.stroke()}bV.translate(-aV,-aU);bV.restore()};var bM=function(b6){var b1=bT*0.38,bW=bT*0.35,bY=bT*0.36,bX=bT*0.1,b4=bT*0.31,bV=bT*0.36,b5,bZ,b2;b6.textAlign="center";b6.textBaseline="middle";b6.save();b6.strokeStyle=aR.labelColor.getRgbaColor();b6.fillStyle=aR.labelColor.getRgbaColor();b6.translate(aV,aU);if(!a4){b5=0.12*bT+"px serif";bZ=0.06*bT+"px serif";b6.lineWidth=1;b6.strokeStyle=aR.symbolColor.getRgbaColor();for(b2=0;360>b2;b2+=2.5){if(0===b2%5){b6.beginPath();b6.moveTo(bT*0.38,0);b6.lineTo(bT*0.36,0);b6.closePath();b6.stroke()}b6.save();switch(b2){case 0:b6.translate(bT*0.35,0);b6.rotate(R);b6.font=b5;b6.fillText(a9[2],0,0);b6.translate(-bT*0.35,0);break;case 45:b6.translate(bT*0.29,0);b6.rotate(R);b6.font=bZ;b6.fillText(a9[3],0,0);b6.translate(-bT*0.29,0);break;case 90:b6.translate(bT*0.35,0);b6.rotate(R);b6.font=b5;b6.fillText(a9[4],0,0);b6.translate(-bT*0.35,0);break;case 135:b6.translate(bT*0.29,0);b6.rotate(R);b6.font=bZ;b6.fillText(a9[5],0,0);b6.translate(-bT*0.29,0);break;case 180:b6.translate(bT*0.35,0);b6.rotate(R);b6.font=b5;b6.fillText(a9[6],0,0);b6.translate(-bT*0.35,0);break;case 225:b6.translate(bT*0.29,0);b6.rotate(R);b6.font=bZ;b6.fillText(a9[7],0,0);b6.translate(-bT*0.29,0);break;case 270:b6.translate(bT*0.35,0);b6.rotate(R);b6.font=b5;b6.fillText(a9[0],0,0);b6.translate(-bT*0.35,0);break;case 315:b6.translate(bT*0.29,0);b6.rotate(R);b6.font=bZ;b6.fillText(a9[1],0,0);b6.translate(-bT*0.29,0);break}b6.restore();if(aY&&(0===b2||22.5===b2||45===b2||67.5===b2||90===b2||112.5===b2||135===b2||157.5===b2||180===b2||202.5===b2||225===b2||247.5===b2||270===b2||292.5===b2||315===b2||337.5===b2||360===b2)){b6.save();b6.beginPath();if(b2%45){b6.moveTo(bT*0.29,0)}else{b6.moveTo(bT*0.38,0)}b6.lineTo(bT*0.1,0);b6.closePath();b6.restore();b6.stroke()}b6.rotate(bz*2.5)}}else{b5=Math.floor(0.1*bT)+"px serif bold";bZ=Math.floor(bT*0.04)+"px sans-serif";b6.rotate(bz*5);for(b2=5;360>=b2;b2+=5){b6.save();switch(b2){case 360:b6.translate(bV,0);b6.rotate(R);b6.font=b5;b6.fillText(a9[2],0,0,bX);b6.translate(-bV,0);break;case 90:b6.translate(bV,0);b6.rotate(R);b6.font=b5;b6.fillText(a9[4],0,0,bX);b6.translate(-bV,0);break;case 180:b6.translate(bV,0);b6.rotate(R);b6.font=b5;b6.fillText(a9[6],0,0,bX);b6.translate(-bV,0);break;case 270:b6.translate(bV,0);b6.rotate(R);b6.font=b5;b6.fillText(a9[0],0,0,bX);b6.translate(-bV,0);break;case 5:case 85:case 95:case 175:case 185:case 265:case 275:case 355:break;default:if((b2+90)%20){b6.lineWidth=((b2+90)%5)?1.5:1;b6.beginPath();b6.moveTo(b1,0);var b3=(b2+90)%10?bY:bW;b6.lineTo(b3,0);b6.closePath();b6.stroke()}else{b6.lineWidth=1.5;b6.beginPath();b6.moveTo(b1,0);b6.lineTo(bW,0);b6.closePath();b6.stroke();var b0=(b2+90)%360;b6.translate(b4,0);b6.rotate(R);b6.font=bZ;b6.fillText(("0".substring(b0>=100)+b0),0,0,bX);b6.translate(-b4,0)}}b6.restore();b6.rotate(bz*5)}}b6.translate(-aV,-aU);b6.restore()};var bl=function(bV){if(bI.length>0){bV.save();bV.textAlign="center";bV.textBaseline="middle";bV.fillStyle=(be?bQ.medium.getRgbaColor():aR.labelColor.getRgbaColor());bV.font=0.04*bT+"px sans-serif";bV.fillText(bI[0],bT/2,bu*0.29,bT*0.3);bV.fillStyle=(be?by.medium.getRgbaColor():aR.labelColor.getRgbaColor());bV.fillText(bI[1],bT/2,bu*0.71,bT*0.3);if(ba.length>0){bV.fillStyle=aR.labelColor.getRgbaColor();bV.font=0.0467*bT+"px sans-serif";bV.fillText(ba,bT/2,bu*0.5,bT*0.3)}}};var bE=function(bY){bY=bY||{};var b0=(undefined===bY.background?false:bY.background);var bX=(undefined===bY.pointer?false:bY.pointer);var bV=(undefined===bY.foreground?false:bY.foreground);a5=true;if(b0&&bq){d(aQ,aS,aV,aU,bT,bu)}if(b0&&bk){aO(aQ,aR,aV,aU,bT,bu);P(aQ,bU,aV,aU,bT,bu);if(null!==bd&&0<bd.length){var bZ=bd.length;do{bZ--;bw(aQ,bd[bZ].start,bd[bZ].stop,bd[bZ].color,false)}while(0<bZ)}if(null!==br&&0<br.length){var bW=br.length;do{bW--;bw(aQ,br[bW].start,br[bW].stop,br[bW].color,true)}while(0<bW)}bM(aQ)}if(b0&&aY){e(aQ,aV,aU,bT,bu,aR)}if(b0&&bA){bN=U(aT,bm,bp);aQ.drawImage(bN,bj,aX);aQ.drawImage(bN,bj,aW);bl(aQ)}if(bX){D(bb,bT,a7,by,aR.labelColor);D(a0,bT,bB,bQ,aR.labelColor)}if(bV&&bK){var b1=(bB.type==="type15"||bB.type==="type16"?false:true);z(bi,bL,bT,bu,b1,bR,bs)}};var bH=function(bW){bW=bW||{};var bY=(undefined===bW.background?false:bW.background);var bX=(undefined===bW.pointer?false:bW.pointer);var bV=(undefined===bW.foreground?false:bW.foreground);if(bY){bv.width=a1;bv.height=a1;aQ=bv.getContext("2d")}if(bX){bo.width=a1;bo.height=a1;a0=bo.getContext("2d");bS.width=a1;bS.height=a1;bb=bS.getContext("2d")}if(bV){bC.width=a1;bC.height=a1;bi=bC.getContext("2d")}};this.setValueLatest=function(bV){bV=bV===360?360:bV%360;if(bP!==bV){bP=bV;this.repaint()}};this.getValueLatest=function(){return bP};this.setValueAverage=function(bV){bV=bV===360?360:bV%360;if(bh!==bV){bh=bV;this.repaint()}};this.getValueAverage=function(){return bh};this.setValueAnimatedLatest=function(bY){var bV=(bY===360?360:bY%360),bW=this,bX;if(bP!==bV){if(undefined!==bf){if(bf.playing){bf.stop()}}bX=ai(bP,bV);bf=new Tween({},"",Tween.regularEaseInOut,bP,bP+bX,2.5);bf.onMotionChanged=function(bZ){bP=bZ.target._pos===360?360:bZ.target._pos%360;if(!a6){a6=true;ab(bW.repaint)}};if(bV===360){bf.onMotionFinished=function(bZ){bP=bV;if(!a6){a6=true;ab(bW.repaint)}}}bf.start()}};this.setValueAnimatedAverage=function(bY){var bV=(bY===360?360:bY%360);if(bh!==bY){var bW=this;if(undefined!==bc){if(bc.playing){bc.stop()}}var bX=ai(bh,bV);bc=new Tween({},"",Tween.regularEaseInOut,bh,bh+bX,2.5);bc.onMotionChanged=function(bZ){bh=bZ.target._pos===360?360:bZ.target._pos%360;if(!a6){a6=true;ab(bW.repaint)}};if(bV===360){bf.onMotionFinished=function(bZ){bh=bV;if(!a6){a6=true;ab(bW.repaint)}}}bc.start()}};this.setArea=function(bV){br=bV;bH({background:true});bE({background:true});this.repaint()};this.setSection=function(bV){bd=bV;bH({background:true});bE({background:true});this.repaint()};this.setFrameDesign=function(bV){aS=bV;bH({background:true});bE({background:true});this.repaint()};this.setBackgroundColor=function(bV){aR=bV;bH({background:true});bE({background:true});this.repaint()};this.setForegroundType=function(bV){bH({foreground:true});bL=bV;bE({foreground:true});this.repaint()};this.setPointerColor=function(bV){bH({pointer:true});bQ=bV;bE({pointer:true});this.repaint()};this.setPointerColorAverage=function(bV){bH({pointer:true});by=bV;bE({pointer:true});this.repaint()};this.setPointerType=function(bV){bB=bV;bH({pointer:true,foreground:true});bE({pointer:true,foreground:true});this.repaint()};this.setPointerTypeAverage=function(bV){a7=bV;bH({pointer:true,foreground:true});bE({pointer:true,foreground:true});this.repaint()};this.setPointSymbols=function(bV){a9=bV;bH({background:true});bE({background:true});this.repaint()};this.setLcdColor=function(bV){bp=bV;bH({background:true});bE({background:true});this.repaint()};this.setLcdTitleStrings=function(bV){bI=bV;bH({background:true});bE({background:true});this.repaint()};this.repaint=function(){if(!a5){bE({frame:true,background:true,led:true,pointer:true,foreground:true})}bF.clearRect(0,0,bF.canvas.width,bF.canvas.height);if(bq||bk){bF.drawImage(bv,0,0)}if(bA){a8(bP,true);a8(bh,false)}bJ=bh*bz;var bV=bT*0.006;bF.save();bF.translate(aV,aU);bF.rotate(bJ);bF.translate(-aV,-aU);bF.shadowColor="rgba(0, 0, 0, 0.8)";bF.shadowOffsetX=bF.shadowOffsetY=bV;bF.shadowBlur=bV*2;bF.drawImage(bS,0,0);bt=bP*bz-bJ;bF.translate(aV,aU);bF.rotate(bt);bF.translate(-aV,-aU);bF.drawImage(bo,0,0);bF.restore();if(bK){bF.drawImage(bC,0,0)}a6=false};this.repaint();return this};var ah=function(aW,a2){a2=a2||{};var bc=(undefined===a2.size?200:a2.size),a1=(undefined===a2.frameDesign?steelseries.FrameDesign.METAL:a2.frameDesign),aT=(undefined===a2.frameVisible?true:a2.frameVisible),bk=(undefined===a2.foregroundType?steelseries.ForegroundType.TYPE1:a2.foregroundType),bg=(undefined===a2.foregroundVisible?true:a2.foregroundVisible),bf=(undefined===a2.pointerColor?steelseries.ColorDef.WHITE:a2.pointerColor);var bn;var aZ;var a0=false;var bi=0;var a6=0;var bb=(am*bc)/360;var bd=0;var bj=false;var a9=A.getElementById(aW).getContext("2d");a9.save();a9.clearRect(0,0,a9.canvas.width,a9.canvas.height);a9.canvas.width=bc;a9.canvas.height=bc;var a8=bc;var bm=bc;var a5=a8/2;var a4=bm/2;var aX=false;var aU=I(bc,bc);var bo=aU.getContext("2d");var aY=I(bc,bc*am);var aR=aY.getContext("2d");var a7=I(bc*0.037383,bc*0.056074);var aS=a7.getContext("2d");var be=I(bc,bc);var aV=be.getContext("2d");var bl=function(bw){bw.save();var bt=bc;var bu=bc*am;var bs;bw.beginPath();bw.rect(0,0,bt,bu);bw.closePath();var br=bw.createLinearGradient(0,0,0,bu);br.addColorStop(0,"#7fd5f0");br.addColorStop(0.5,"#7fd5f0");br.addColorStop(0.5,"#3c4439");br.addColorStop(1,"#3c4439");bw.fillStyle=br;bw.fill();bw.lineWidth=1;var bv=bu/360*5;var bq=false;var bp=10;bw.textAlign="center";bw.textBaseline="middle";var bx=bt*0.04;bw.font=bx+"px sans-serif";bw.fillStyle="#37596e";for(bs=bu/2-bv;bs>0;bs-=bv){if(bp<=90){if(bq){bw.fillText(bp,(bt-(bt*0.2))/2-8,bs,bt*0.375);bw.fillText(bp,bt-(bt-(bt*0.2))/2+8,bs,bt*0.375);bw.beginPath();bw.moveTo((bt-(bt*0.2))/2,bs);bw.lineTo(bt-(bt-(bt*0.2))/2,bs);bw.closePath();bp+=10}else{bw.beginPath();bw.moveTo((bt-(bt*0.1))/2,bs);bw.lineTo(bt-(bt-(bt*0.1))/2,bs);bw.closePath()}bw.stroke()}bq^=true}bq=false;bp=10;bw.strokeStyle="#FFFFFF";bw.lineWidth=1.5;bw.beginPath();bw.moveTo(0,bu/2);bw.lineTo(bt,bu/2);bw.closePath();bw.stroke();bw.fillStyle="#FFFFFF";bw.lineWidth=1;for(bs=bu/2+bv;bs<=bu;bs+=bv){if(bp<=90){if(bq){bw.fillText(-bp,(bt-(bt*0.2))/2-8,bs,bt*0.375);bw.fillText(-bp,bt-(bt-(bt*0.2))/2+8,bs,bt*0.375);bw.beginPath();bw.moveTo((bt-(bt*0.2))/2,bs);bw.lineTo(bt-(bt-(bt*0.2))/2,bs);bw.closePath();bp+=10}else{bw.beginPath();bw.moveTo((bt-(bt*0.1))/2,bs);bw.lineTo(bt-(bt-(bt*0.1))/2,bs);bw.closePath()}bw.stroke()}bq^=true}bw.restore()};var a3=function(bp){bp.save();bp.fillStyle=bf.light.getRgbaColor();bp.beginPath();bp.moveTo(a8*0.476635,bm*0.5);bp.bezierCurveTo(a8*0.476635,bm*0.514018,a8*0.485981,bm*0.523364,a8*0.5,bm*0.523364);bp.bezierCurveTo(a8*0.514018,bm*0.523364,a8*0.523364,bm*0.514018,a8*0.523364,bm*0.5);bp.bezierCurveTo(a8*0.523364,bm*0.485981,a8*0.514018,bm*0.476635,a8*0.5,bm*0.476635);bp.bezierCurveTo(a8*0.485981,bm*0.476635,a8*0.476635,bm*0.485981,a8*0.476635,bm*0.5);bp.closePath();bp.moveTo(a8*0.415887,bm*0.504672);bp.lineTo(a8*0.415887,bm*0.495327);bp.bezierCurveTo(a8*0.415887,bm*0.495327,a8*0.467289,bm*0.495327,a8*0.467289,bm*0.495327);bp.bezierCurveTo(a8*0.471962,bm*0.481308,a8*0.481308,bm*0.471962,a8*0.495327,bm*0.467289);bp.bezierCurveTo(a8*0.495327,bm*0.467289,a8*0.495327,bm*0.415887,a8*0.495327,bm*0.415887);bp.lineTo(a8*0.504672,bm*0.415887);bp.bezierCurveTo(a8*0.504672,bm*0.415887,a8*0.504672,bm*0.467289,a8*0.504672,bm*0.467289);bp.bezierCurveTo(a8*0.518691,bm*0.471962,a8*0.528037,bm*0.481308,a8*0.53271,bm*0.495327);bp.bezierCurveTo(a8*0.53271,bm*0.495327,a8*0.584112,bm*0.495327,a8*0.584112,bm*0.495327);bp.lineTo(a8*0.584112,bm*0.504672);bp.bezierCurveTo(a8*0.584112,bm*0.504672,a8*0.53271,bm*0.504672,a8*0.53271,bm*0.504672);bp.bezierCurveTo(a8*0.528037,bm*0.518691,a8*0.518691,bm*0.53271,a8*0.5,bm*0.53271);bp.bezierCurveTo(a8*0.481308,bm*0.53271,a8*0.471962,bm*0.518691,a8*0.467289,bm*0.504672);bp.bezierCurveTo(a8*0.467289,bm*0.504672,a8*0.415887,bm*0.504672,a8*0.415887,bm*0.504672);bp.closePath();bp.fill();var br=5;var bq=5*l;bp.translate(a5,a4);bp.rotate(-R);bp.translate(-a5,-a4);var bs;for(bs=-90;bs<=90;bs+=br){if(bs%45===0||bs===0){bp.strokeStyle=bf.medium.getRgbaColor();bp.lineWidth=2;bp.beginPath();bp.moveTo(a8*0.5,bm*0.088785);bp.lineTo(a8*0.5,bm*0.113);bp.closePath();bp.stroke()}else{if(bs%15===0){bp.strokeStyle="#FFFFFF";bp.lineWidth=1;bp.beginPath();bp.moveTo(a8*0.5,bm*0.088785);bp.lineTo(a8*0.5,bm*0.103785);bp.closePath();bp.stroke()}else{bp.strokeStyle="#FFFFFF";bp.lineWidth=0.5;bp.beginPath();bp.moveTo(a8*0.5,bm*0.088785);bp.lineTo(a8*0.5,bm*0.093785);bp.closePath();bp.stroke()}}bp.translate(a5,a4);bp.rotate(bq,a5,a4);bp.translate(-a5,-a4)}bp.restore()};var aQ=function(bq){bq.save();var br=a8*0.037383;var bp=bm*0.056074;bq.beginPath();bq.moveTo(br*0.5,0);bq.lineTo(0,bp);bq.lineTo(br,bp);bq.closePath();bq.fillStyle=bf.light.getRgbaColor();bq.fill();bq.strokeStyle=bf.medium.getRgbaColor();bq.stroke();bq.restore()};var bh=function(){aX=true;if(aT){d(bo,a1,a5,a4,a8,bm)}bl(aR);aQ(aS);a3(aV);if(bg){z(aV,bk,a8,bm,true,aJ,T,K)}};var ba=function(){aU.width=bc;aU.height=bc;bo=aU.getContext("2d");aY.width=bc;aY.height=bc*am;aR=aY.getContext("2d");a7.width=bc*0.037383;a7.height=bc*0.056074;aS=a7.getContext("2d");be.width=bc;be.height=bc;aV=be.getContext("2d")};this.setRoll=function(bp){bp=bp%360;if(bi!==bp){bi=bp;this.repaint()}};this.getRoll=function(){return bi};this.setRollAnimated=function(bp){var bq=this;bp=bp%360;if(bi!==bp){if(undefined!==bn){if(bn.playing){bn.stop()}}bn=new Tween({},"",Tween.regularEaseInOut,bi,bp,1);bn.onMotionChanged=function(br){bi=br.target._pos;if(!a0){a0=true;ab(bq.repaint)}};bn.start()}};this.setPitch=function(bp){bp=((bp+180-bd)%360)-180;if(a6!==bp){a6=bp;if(a6>90){a6=90-(a6-90);if(!bj){this.setRoll(bi-180)}bj=true}else{if(a6<-90){a6=-90+(-90-a6);if(!bj){this.setRoll(bi+180)}bj=true}else{bj=false}}this.repaint()}};this.getPitch=function(){return a6};this.setPitchAnimated=function(bq){var bp=this;if(a6!==bq){if(undefined!==aZ){if(aZ.playing){aZ.stop()}}aZ=new Tween({},"",Tween.regularEaseInOut,a6,bq,1);aZ.onMotionChanged=function(br){a6=br.target._pos;if(a6>90){a6=90-(a6-90);if(!bj){this.setRoll(bi-180)}bj=true}else{if(a6<-90){a6=-90+(-90-a6);if(!bj){this.setRoll(bi+180)}bj=true}else{bj=false}}if(!a0){a0=true;ab(bp.repaint)}bp.setPitch(br.target._pos)};aZ.start()}};this.setPitchOffset=function(bp){bd=bp;this.repaint()};this.setFrameDesign=function(bp){ba();a1=bp;bh();this.repaint()};this.setForegroundType=function(bp){ba();bk=bp;bh();this.repaint()};this.repaint=function(){if(!aX){bh()}a9.save();a9.clearRect(0,0,a9.canvas.width,a9.canvas.height);a9.drawImage(aU,0,0);a9.save();a9.beginPath();a9.arc(a5,a4,a8*0.831775/2,0,G,true);a9.closePath();a9.clip();a9.translate(a5,a4);a9.rotate(-(bi*l));a9.translate(-a5,0);a9.translate(0,(a6*bb));a9.drawImage(aY,0,-aY.height/2);a9.translate(0,-(a6*bb)-a4);a9.drawImage(a7,(a8*0.5-a7.width/2),(a8*0.107476));a9.restore();a9.drawImage(be,0,0);a9.restore()};this.repaint();return this};var aq=function(aU,a1){a1=a1||{};var a4=(undefined===a1.size?32:a1.size),aT=(undefined===a1.ledColor?steelseries.LedColor.RED_LED:a1.ledColor);var a3=false;var aS=0;var aR=A.getElementById(aU).getContext("2d");aR.save();aR.clearRect(0,0,aR.canvas.width,aR.canvas.height);aR.canvas.width=a4;aR.canvas.height=a4;var aW=false;var a0=A.createElement("canvas");a0.width=a4;a0.height=a4;var aZ=a0.getContext("2d");var aQ=A.createElement("canvas");aQ.width=a4;aQ.height=a4;var aV=aQ.getContext("2d");var aY=aQ;var a2=function(){aW=true;aZ.clearRect(0,0,aZ.canvas.width,aZ.canvas.height);aZ.drawImage(ad(a4,1,aT),0,0);aV.clearRect(0,0,aV.canvas.width,aV.canvas.height);aV.drawImage(ad(a4,0,aT),0,0)};this.toggleLed=function(){if(aY===a0){aY=aQ}else{aY=a0}aX()};this.setLedColor=function(a5){aT=a5;aW=false;aX()};this.setLedOnOff=function(a5){if(true===a5){aY=a0}else{aY=aQ}aX()};this.blink=function(a5){if(a5){if(!a3){aS=setInterval(this.toggleLed,1000);a3=true}}else{if(a3){clearInterval(aS);a3=false}}};var aX=function(){if(!aW){a2()}aR.save();aR.clearRect(0,0,aR.canvas.width,aR.canvas.height);aR.drawImage(aY,0,0);aR.restore()};aX();return this};var c=function(a1,by){by=by||{};var a0=(undefined===by.size?200:by.size),aT=(undefined===by.frameDesign?steelseries.FrameDesign.METAL:by.frameDesign),bn=(undefined===by.frameVisible?true:by.frameVisible),a9=(undefined===by.pointerType?steelseries.PointerType.TYPE1:by.pointerType),bF=(undefined===by.pointerColor?(a9===steelseries.PointerType.TYPE1?steelseries.ColorDef.GRAY:steelseries.ColorDef.BLACK):by.pointerColor),aS=(undefined===by.backgroundColor?(a9===steelseries.PointerType.TYPE1?steelseries.BackgroundColor.ANTHRACITE:steelseries.BackgroundColor.LIGHT_GRAY):by.backgroundColor),bg=(undefined===by.backgroundVisible?true:by.backgroundVisible),bD=(undefined===by.foregroundType?steelseries.ForegroundType.TYPE1:by.foregroundType),bC=(undefined===by.foregroundVisible?true:by.foregroundVisible),bJ=(undefined===by.customLayer?null:by.customLayer),bc=(undefined===by.isAutomatic?true:by.isAutomatic),bf=(undefined===by.hour?11:by.hour),a3=(undefined===by.minute?5:by.minute),bj=(undefined===by.second?0:by.second),bH=(undefined===by.secondMovesContinuous?false:by.secondMovesContinuous),bu=(undefined===by.timeZoneOffsetHour?0:by.timeZoneOffsetHour),bl=(undefined===by.timeZoneOffsetMinute?0:by.timeZoneOffsetMinute),bb=(undefined===by.secondPointerVisible?true:by.secondPointerVisible);var bm=new Date();var bt;var bo;var bz;var bd;var aU=(bH?100:1000);aU=(bb?aU:100);var a2=this;var aX=6;var bx=A.getElementById(a1).getContext("2d");bx.save();bx.clearRect(0,0,bx.canvas.width,bx.canvas.height);bx.canvas.width=a0;bx.canvas.height=a0;var bG=a0;var bq=a0;var aW=bG/2;var aV=bq/2;var a4=false;var a5=I(a0,a0);var aY=a5.getContext("2d");var br=I(a0,a0);var aR=br.getContext("2d");var a6=I(a0,a0);var aZ=a6.getContext("2d");var bh=I(a0,a0);var bi=bh.getContext("2d");var bs=I(a0,a0);var bB=bs.getContext("2d");var bv=I(a0,a0);var be=bv.getContext("2d");var bE=function(bK,bQ){var bO;var bN;var bP;var bL,bM;bL=bG*0.405;bK.save();bK.translate(aW,aV);switch(bQ.type){case"type1":bN=bG*0.074766;bM=bL-bN;bK.strokeStyle=aS.labelColor.getRgbaColor();bK.lineWidth=bG*0.014018;for(bO=0;bO<360;bO+=30){bK.beginPath();bK.moveTo(bL,0);bK.lineTo(bM,0);bK.closePath();bK.stroke();bK.rotate(30*l)}bP=bG*0.126168;bM=bL-bP;bK.lineWidth=bG*0.03271;for(bO=0;bO<360;bO+=90){bK.beginPath();bK.moveTo(bL,0);bK.lineTo(bM,0);bK.closePath();bK.stroke();bK.rotate(90*l)}break;case"type2":default:bN=bG*0.037383;bM=bL-bN;bK.strokeStyle=aS.labelColor.getRgbaColor();bK.lineWidth=bG*0.009345;for(bO=0;bO<360;bO+=6){bK.beginPath();bK.moveTo(bL,0);bK.lineTo(bM,0);bK.closePath();bK.stroke();bK.rotate(6*l)}bP=bG*0.084112;bM=bL-bP;bK.lineWidth=bG*0.028037;for(bO=0;bO<360;bO+=30){bK.beginPath();bK.moveTo(bL,0);bK.lineTo(bM,0);bK.closePath();bK.stroke();bK.rotate(30*l)}break}bK.translate(-aW,-aV);bK.restore()};var bI=function(bK,bL){bK.save();var bM;switch(bL.type){case"type2":bK.beginPath();bK.lineWidth=bG*0.046728;bK.moveTo(aW,bG*0.289719);bK.lineTo(aW,bG*0.289719+bG*0.224299);bK.strokeStyle=bF.medium.getRgbaColor();bK.closePath();bK.stroke();break;case"type1":default:bK.beginPath();bK.moveTo(bG*0.471962,bq*0.560747);bK.lineTo(bG*0.471962,bq*0.214953);bK.lineTo(bG*0.5,bq*0.182242);bK.lineTo(bG*0.528037,bq*0.214953);bK.lineTo(bG*0.528037,bq*0.560747);bK.lineTo(bG*0.471962,bq*0.560747);bK.closePath();bM=bK.createLinearGradient(bG*0.471962,bq*0.560747,bG*0.528037,bq*0.214953);bM.addColorStop(1,bF.veryLight.getRgbaColor());bM.addColorStop(0,bF.light.getRgbaColor());bK.fillStyle=bM;bK.strokeStyle=bF.light.getRgbaColor();bK.fill();bK.stroke();break}bK.restore()};var aQ=function(bK,bL){bK.save();var bM;switch(bL.type){case"type2":bK.beginPath();bK.lineWidth=bG*0.03271;bK.moveTo(aW,bG*0.116822);bK.lineTo(aW,bG*0.116822+bG*0.38785);bK.strokeStyle=bF.medium.getRgbaColor();bK.closePath();bK.stroke();break;case"type1":default:bK.beginPath();bK.moveTo(bG*0.518691,bq*0.574766);bK.lineTo(bG*0.523364,bq*0.135514);bK.lineTo(bG*0.5,bq*0.107476);bK.lineTo(bG*0.476635,bq*0.140186);bK.lineTo(bG*0.476635,bq*0.574766);bK.lineTo(bG*0.518691,bq*0.574766);bK.closePath();bM=bK.createLinearGradient(bG*0.518691,bq*0.574766,bG*0.476635,bq*0.140186);bM.addColorStop(1,bF.veryLight.getRgbaColor());bM.addColorStop(0,bF.light.getRgbaColor());bK.fillStyle=bM;bK.strokeStyle=bF.light.getRgbaColor();bK.fill();bK.stroke();break}bK.restore()};var a8=function(bK,bL){bK.save();var bM;switch(bL.type){case"type2":bK.lineWidth=bG*0.009345;bK.beginPath();bK.moveTo(aW,bG*0.09813);bK.lineTo(aW,bG*0.09813+bG*0.126168);bK.closePath();bK.stroke();bK.lineWidth=bG*0.018691;bK.beginPath();bK.moveTo(aW,bG*0.308411);bK.lineTo(aW,bG*0.308411+bG*0.191588);bK.closePath();bK.stroke();bK.lineWidth=bG*0.016;bK.beginPath();bK.arc(aW,bG*0.26,bG*0.085/2,0,G);bK.closePath();bK.stroke();break;case"type1":default:bK.beginPath();bK.moveTo(bG*0.509345,bq*0.116822);bK.lineTo(bG*0.509345,bq*0.574766);bK.lineTo(bG*0.490654,bq*0.574766);bK.lineTo(bG*0.490654,bq*0.116822);bK.lineTo(bG*0.509345,bq*0.116822);bK.closePath();bM=bK.createLinearGradient(bG*0.509345,bq*0.116822,bG*0.490654,bq*0.574766);bM.addColorStop(0,steelseries.ColorDef.RED.light.getRgbaColor());bM.addColorStop(0.47,steelseries.ColorDef.RED.medium.getRgbaColor());bM.addColorStop(1,steelseries.ColorDef.RED.dark.getRgbaColor());bK.fillStyle=bM;bK.strokeStyle=steelseries.ColorDef.RED.dark.getRgbaColor();bK.fill();bK.stroke();break}bK.restore()};var ba=function(bK){var bL;bK.beginPath();bK.arc(aW,aV,bG*0.045,0,G);bK.closePath();bL=bK.createLinearGradient(aW-bG*0.045/2,aV-bG*0.045/2,aW+bG*0.045/2,aV+bG*0.045/2);bL.addColorStop(0,"#eef0f2");bL.addColorStop(1,"#65696d");bK.fillStyle=bL;bK.fill()};var bp=function(bK,bL){var bM;bK.save();switch(bL.type){case"type2":bK.fillStyle="#000000";bK.beginPath();bK.arc(aW,aV,bG*0.088785/2,0,G);bK.closePath();bK.fill();break;case"type1":default:bM=bK.createLinearGradient(aW-bG*0.027/2,aV-bG*0.027/2,aW+bG*0.027/2,aV+bG*0.027/2);bM.addColorStop(0,"#f3f4f7");bM.addColorStop(0.11,"#f3f5f7");bM.addColorStop(0.12,"#f1f3f5");bM.addColorStop(0.2,"#c0c5cb");bM.addColorStop(0.2,"#bec3c9");bM.addColorStop(1,"#bec3c9");bK.fillStyle=bM;bK.beginPath();bK.arc(aW,aV,bG*0.027,0,G);bK.closePath();bK.fill();break}bK.restore()};var bk=function(bK,bM,bL){bz=bL*aX*l;bt=bM*aX*l;bo=(bK+bM/60)*aX*5*l};var a7=function(){if(bc){bm=new Date()}else{bm.setHours(bf);bm.setMinutes(a3);bm.setSeconds(bj)}bj=bm.getSeconds()+(bH?bm.getMilliseconds()/1000:0);if(bu!==0&&bl!==0){bf=bm.getUTCHours()+bu}else{bf=bm.getHours()}bf=bf%12;if(bu!==0&&bl!==0){a3=bm.getUTCMinutes()+bl}else{a3=bm.getMinutes()}if(a3>60){a3-=60;bf++}if(a3<0){a3+=60;bf--}bf=bf%12;bk(bf,a3,bj);if(bc){bd=setTimeout(a7,aU)}a2.repaint()};var bw=function(bL){bL=bL||{};var bM=(undefined===bL.frame?false:bL.frame);var bN=(undefined===bL.background?false:bL.background);var bO=(undefined===bL.pointers?false:bL.pointers);var bK=(undefined===bL.foreground?false:bL.foreground);a4=true;if(bM&&bn){d(aY,aT,aW,aV,bG,bq)}if(bN&&bg){aO(aR,aS,aW,aV,bG,bq);P(aR,bJ,aW,aV,bG,bq);bE(aR,a9)}if(bO){bI(aZ,a9);aQ(bi,a9);a8(bB,a9)}if(bK&&bC){bp(be,a9);z(be,bD,bG,bq,false)}};var bA=function(bL){bL=bL||{};var bM=(undefined===bL.frame?false:bL.frame);var bN=(undefined===bL.background?false:bL.background);var bO=(undefined===bL.pointers?false:bL.pointers);var bK=(undefined===bL.foreground?false:bL.foreground);if(bM){a5.width=a0;a5.height=a0;aY=a5.getContext("2d")}if(bN){br.width=a0;br.height=a0;aR=br.getContext("2d")}if(bO){a6.width=a0;a6.height=a0;aZ=a6.getContext("2d");bh.width=a0;bh.height=a0;bi=bh.getContext("2d");bs.width=a0;bs.height=a0;bB=bs.getContext("2d")}if(bK){bv.width=a0;bv.height=a0;be=bv.getContext("2d")}};this.getAutomatic=function(){return bc};this.setAutomatic=function(bK){if(bc&&!bK){clearTimer(bd);bc=bK}else{if(!bc&&bK){bc=bK;a7()}}};this.getHour=function(){return bf};this.setHour=function(bK){bK=bK%12;if(bf!==bK){bf=bK;bk(bf,a3,bj);this.repaint()}};this.getMinute=function(){return a3};this.setMinute=function(bK){bK=bK%60;if(a3!==bK){a3=bK;bk(bf,a3,bj);this.repaint()}};this.getSecond=function(){return bj};this.setSecond=function(bK){bj=bK%60;if(bj!==bK){bj=bK;bk(bf,a3,bj);this.repaint()}};this.getTimeZoneOffsetHour=function(){return bu};this.setTimeZoneOffsetHour=function(bK){bu=bK;this.repaint()};this.getTimeZoneOffsetMinute=function(){return bl};this.setTimeZoneOffsetMinute=function(bK){bl=bK;this.repaint()};this.getSecondPointerVisible=function(){return bb};this.setSecondPointerVisible=function(bK){bb=bK;this.repaint()};this.getSecondMovesContinuous=function(){return bH};this.setSecondMovesContinuous=function(bK){bH=bK;aU=(bH?100:1000);aU=(bb?aU:100)};this.setFrameDesign=function(bK){bA({frame:true});aT=bK;bw({frame:true});this.repaint()};this.setBackgroundColor=function(bK){bA({frame:true,background:true});aS=bK;bw({frame:true,background:true});this.repaint()};this.setForegroundType=function(bK){bA({foreground:true});bD=bK;bw({foreground:true});this.repaint()};this.setPointerType=function(bK){bA({background:true,foreground:true,pointers:true});a9=bK;if(a9.type==="type1"){bF=steelseries.ColorDef.GRAY;aS=steelseries.BackgroundColor.ANTHRACITE}else{bF=steelseries.ColorDef.BLACK;aS=steelseries.BackgroundColor.LIGHT_GRAY}bw({background:true,foreground:true,pointers:true});this.repaint()};this.setPointerColor=function(bK){bA({pointers:true});bF=bK;bw({pointers:true});this.repaint()};this.repaint=function(){if(!a4){bw({frame:true,background:true,pointers:true,foreground:true})}bx.clearRect(0,0,bx.canvas.width,bx.canvas.height);if(bn){bx.drawImage(a5,0,0)}if(bg){bx.drawImage(br,0,0)}var bK=bG*0.006;bx.save();bx.translate(aW,aV);bx.rotate(bo);bx.translate(-aW,-aV);bx.shadowColor="rgba(0, 0, 0, 0.8)";bx.shadowOffsetX=bx.shadowOffsetY=bK;bx.shadowBlur=bK*2;bx.drawImage(a6,0,0);bx.translate(aW,aV);bx.rotate(bt-bo);bx.translate(-aW,-aV);bx.drawImage(bh,0,0);bx.restore();if(a9.type==="type1"){ba(bx)}if(bb){bx.save();bx.translate(aW,aV);bx.rotate(bz);bx.translate(-aW,-aV);bx.shadowColor="rgba(0, 0, 0, 0.8)";bx.shadowOffsetX=bx.shadowOffsetY=bK;bx.shadowBlur=bK*2;bx.drawImage(bs,0,0);bx.restore()}if(bC){bx.drawImage(bv,0,0)}};a7();return this};var Z=function(aT,aW){aW=aW||{};var aV=(undefined===aW.size?50:aW.size),aX=(undefined===aW.value?50:aW.value);var aS=aV;var aR=Math.ceil(aV*0.45);var aU=A.getElementById(aT).getContext("2d");aU.save();aU.clearRect(0,0,aU.canvas.width,aU.canvas.height);aU.canvas.width=aS;aU.canvas.height=aS;var aQ=function(bb,a7,a5,a9){var a8;bb.beginPath();bb.moveTo(a7*0.025,a5*0.055555);bb.lineTo(a7*0.9,a5*0.055555);bb.lineTo(a7*0.9,a5*0.944444);bb.lineTo(a7*0.025,a5*0.944444);bb.lineTo(a7*0.025,a5*0.055555);bb.closePath();bb.beginPath();bb.moveTo(a7*0.925,0);bb.lineTo(0,0);bb.lineTo(0,a5);bb.lineTo(a7*0.925,a5);bb.lineTo(a7*0.925,a5*0.722222);bb.bezierCurveTo(a7*0.925,a5*0.722222,a7*0.975,a5*0.722222,a7*0.975,a5*0.722222);bb.bezierCurveTo(a7,a5*0.722222,a7,a5*0.666666,a7,a5*0.666666);bb.bezierCurveTo(a7,a5*0.666666,a7,a5*0.333333,a7,a5*0.333333);bb.bezierCurveTo(a7,a5*0.333333,a7,a5*0.277777,a7*0.975,a5*0.277777);bb.bezierCurveTo(a7*0.975,a5*0.277777,a7*0.925,a5*0.277777,a7*0.925,a5*0.277777);bb.lineTo(a7*0.925,0);bb.closePath();a8=bb.createLinearGradient(0,0,0,a5);a8.addColorStop(0,"#ffffff");a8.addColorStop(1,"#7e7e7e");bb.fillStyle=a8;bb.fill();bb.beginPath();var a2=Math.max(a7*0.875*(a9/100),Math.ceil(a7*0.01));bb.rect(a7*0.025,a7*0.025,a2,a5*0.888888);bb.closePath();var aY=[0,0.4,1];var aZ=[new J(177,25,2,1),new J(219,167,21,1),new J(121,162,75,1)];var a1=new h(0,100,aY,aZ);bb.fillStyle=a1.getColorAt(a9/100).getRgbColor();bb.fill();bb.beginPath();a2=Math.max(a2-a7*0.05,0);bb.rect(a7*0.05,a7*0.05,a2,a5*0.777777);bb.closePath();var a3=[new J(198,39,5,1),new J(228,189,32,1),new J(163,216,102,1)];var a0=[new J(246,121,48,1),new J(246,244,157,1),new J(223,233,86,1)];var ba=[0,0.4,1];var a6=new h(0,100,ba,a3);var a4=new h(0,100,ba,a0);a8=bb.createLinearGradient(a7*0.05,0,a7*0.875,0);a8.addColorStop(0,a6.getColorAt(a9/100).getRgbColor());a8.addColorStop(0.5,a4.getColorAt(a9/100).getRgbColor());a8.addColorStop(1,a6.getColorAt(a9/100).getRgbColor());bb.fillStyle=a8;bb.fill();bb.beginPath();bb.rect(a7*0.025,a7*0.025,a7*0.875,a5*0.444444);bb.closePath();a8=bb.createLinearGradient(a7*0.025,a7*0.025,a7*0.875,a5*0.444444);a8.addColorStop(0,"rgba(255, 255, 255, 0)");a8.addColorStop(1,"rgba(255, 255, 255, 0.8)");bb.fillStyle=a8;bb.fill()};this.setValue=function(aY){aY=(aY<0?0:(aY>100?100:aY));if(aX!==aY){aX=aY;this.repaint()}};this.getValue=function(){return aX};this.repaint=function(){aU.clearRect(0,0,aU.canvas.width,aU.canvas.height);aQ(aU,aS,aR,aX)};this.repaint();return this};var ae=function(a2,bt){bt=bt||{};var a1=(undefined===bt.size?200:bt.size),aT=(undefined===bt.frameDesign?steelseries.FrameDesign.METAL:bt.frameDesign),bj=(undefined===bt.frameVisible?true:bt.frameVisible),bA=(undefined===bt.pointerColor?steelseries.ColorDef.BLACK:bt.pointerColor),aR=(undefined===bt.backgroundColor?steelseries.BackgroundColor.LIGHT_GRAY:bt.backgroundColor),bg=(undefined===bt.backgroundVisible?true:bt.backgroundVisible),by=(undefined===bt.foregroundType?steelseries.ForegroundType.TYPE1:bt.foregroundType),bx=(undefined===bt.foregroundVisible?true:bt.foregroundVisible),bC=(undefined===bt.customLayer?null:bt.customLayer),bn=0,bu=0,bb,aW=6,a3=this,bf=0,a8=0,bo=0,a7=0,be=0,bi=false,bl=false,bs=A.getElementById(a2).getContext("2d"),bB=a1,bk=a1,aV=bB/2,aU=bk/2,ba=0.285*bB,bq=aV-ba/2,bw=0.17*bB,a5=false,a6=I(a1,a1),aZ=a6.getContext("2d"),bm=I(a1,a1),aQ=bm.getContext("2d"),bd=I(a1,a1),aX=bd.getContext("2d"),aY=I(a1,a1),a0=aY.getContext("2d"),bp=I(a1,a1),bc=bp.getContext("2d"),bz=function(b2,bZ,bV,bS,bW,bU,bX){var b7=bS*bZ,bI=b7+"px sans-serif",bO=bZ*0.15,bG=0.5,bT=1,bQ=1.5,bN=bW*bZ,bY=Math.round(0.025*bZ),bK=Math.round(0.035*bZ),b5=Math.round(0.045*bZ),bR=aR.labelColor.getRgbaColor(),b9=aR.labelColor.getRgbaColor(),b8=bZ/2,b1=bZ*0.4,b4,bE,bJ,bP=0,bF=0,b0=0,bM,bD=0,b6=0,bL,bH=-am,b3=G/(bV);b2.width=b2.height=bZ;b2.save();b2.textAlign="center";b2.textBaseline="middle";b2.font=bI;for(bL=bH,bM=0;bM<=bV+1;bL-=b3*0.1,bM+=0.1){b2.lineWidth=bG;bD=Math.sin(bL);b6=Math.cos(bL);if(bP%2===0){b4=[b8+(b1-bY)*bD+bU,b8+(b1-bY)*b6+bX];bE=[b8+b1*bD+bU,b8+b1*b6+bX];b2.strokeStyle=b9;b2.beginPath();b2.moveTo(b4[0],b4[1]);b2.lineTo(bE[0],bE[1]);b2.closePath();b2.stroke()}if(bP===10||bP===0){b2.fillStyle=bR;b2.lineWidth=bT;bE=[b8+b1*bD+bU,b8+b1*b6+bX];bJ=[b8+(b1-bN)*bD+bU,b8+(b1-bN)*b6+bX];if(bF===5){if(bM!==bV){if(Math.round(bM)!==60){b2.fillText(Math.round(bM),bJ[0],bJ[1],bO)}}b2.lineWidth=bQ;b4=[b8+(b1-b5)*bD+bU,b8+(b1-b5)*b6+bX];bF=0}else{b2.lineWidth=bT;b4=[b8+(b1-bK)*bD+bU,b8+(b1-bK)*b6+bX]}b2.strokeStyle=b9;b2.beginPath();b2.moveTo(b4[0],b4[1]);b2.lineTo(bE[0],bE[1]);b2.closePath();b2.stroke();bP=0;b0++;bF++}bP++}b2.restore()},aS=function(bE){var bF,bD;bE.save();bE.beginPath();bE.moveTo(bB*0.509345,bB*0.457943);bE.lineTo(bB*0.5,bB*0.102803);bE.lineTo(bB*0.490654,bB*0.457943);bE.bezierCurveTo(bB*0.490654,bB*0.457943,bB*0.490654,bB*0.457943,bB*0.490654,bB*0.457943);bE.bezierCurveTo(bB*0.471962,bB*0.462616,bB*0.457943,bB*0.481308,bB*0.457943,bB*0.5);bE.bezierCurveTo(bB*0.457943,bB*0.518691,bB*0.471962,bB*0.537383,bB*0.490654,bB*0.542056);bE.bezierCurveTo(bB*0.490654,bB*0.542056,bB*0.490654,bB*0.542056,bB*0.490654,bB*0.542056);bE.lineTo(bB*0.490654,bB*0.621495);bE.lineTo(bB*0.509345,bB*0.621495);bE.lineTo(bB*0.509345,bB*0.542056);bE.bezierCurveTo(bB*0.509345,bB*0.542056,bB*0.509345,bB*0.542056,bB*0.509345,bB*0.542056);bE.bezierCurveTo(bB*0.528037,bB*0.537383,bB*0.542056,bB*0.518691,bB*0.542056,bB*0.5);bE.bezierCurveTo(bB*0.542056,bB*0.481308,bB*0.528037,bB*0.462616,bB*0.509345,bB*0.457943);bE.bezierCurveTo(bB*0.509345,bB*0.457943,bB*0.509345,bB*0.457943,bB*0.509345,bB*0.457943);bE.closePath();bF=bE.createLinearGradient(0,0,0,bB*0.621495);bF.addColorStop(0,bA.medium.getRgbaColor());bF.addColorStop(0.388888,bA.medium.getRgbaColor());bF.addColorStop(0.5,bA.light.getRgbaColor());bF.addColorStop(0.611111,bA.medium.getRgbaColor());bF.addColorStop(1,bA.medium.getRgbaColor());bE.fillStyle=bF;bE.strokeStyle=bA.dark.getRgbaColor();bE.fill();bE.stroke();bE.beginPath();bD=bB*0.06542/2;bE.arc(aV,aU,bD,0,G);bF=bE.createLinearGradient(aV-bD,aV+bD,0,aV+bD);bF.addColorStop(0,"#e6b35c");bF.addColorStop(0.01,"#e6b35c");bF.addColorStop(0.99,"#c48200");bF.addColorStop(1,"#c48200");bE.fillStyle=bF;bE.closePath();bE.fill();bE.beginPath();bD=bB*0.046728/2;bE.arc(aV,aU,bD,0,G);bF=bE.createRadialGradient(aV,aV,0,aV,aV,bD);bF.addColorStop(0,"#c5c5c5");bF.addColorStop(0.19,"#c5c5c5");bF.addColorStop(0.22,"#000000");bF.addColorStop(0.8,"#000000");bF.addColorStop(0.99,"#707070");bF.addColorStop(1,"#707070");bE.fillStyle=bF;bE.closePath();bE.fill();bE.restore()},a4=function(bE){var bF,bD;bE.save();bE.beginPath();bE.moveTo(bB*0.476635,bB*0.313084);bE.bezierCurveTo(bB*0.476635,bB*0.322429,bB*0.485981,bB*0.331775,bB*0.495327,bB*0.336448);bE.bezierCurveTo(bB*0.495327,bB*0.336448,bB*0.495327,bB*0.350467,bB*0.495327,bB*0.350467);bE.lineTo(bB*0.504672,bB*0.350467);bE.bezierCurveTo(bB*0.504672,bB*0.350467,bB*0.504672,bB*0.336448,bB*0.504672,bB*0.336448);bE.bezierCurveTo(bB*0.514018,bB*0.331775,bB*0.523364,bB*0.322429,bB*0.523364,bB*0.313084);bE.bezierCurveTo(bB*0.523364,bB*0.303738,bB*0.514018,bB*0.294392,bB*0.504672,bB*0.289719);bE.bezierCurveTo(bB*0.504672,bB*0.289719,bB*0.5,bB*0.200934,bB*0.5,bB*0.200934);bE.bezierCurveTo(bB*0.5,bB*0.200934,bB*0.495327,bB*0.289719,bB*0.495327,bB*0.289719);bE.bezierCurveTo(bB*0.485981,bB*0.294392,bB*0.476635,bB*0.303738,bB*0.476635,bB*0.313084);bE.closePath();bF=bE.createLinearGradient(0,0,bB,0);bF.addColorStop(0,bA.medium.getRgbaColor());bF.addColorStop(0.388888,bA.medium.getRgbaColor());bF.addColorStop(0.5,bA.light.getRgbaColor());bF.addColorStop(0.611111,bA.medium.getRgbaColor());bF.addColorStop(1,bA.medium.getRgbaColor());bE.fillStyle=bF;bE.strokeStyle=bA.dark.getRgbaColor();bE.fill();bE.stroke();bE.beginPath();bD=bB*0.037383/2;bE.arc(aV,bw+ba/2,bD,0,G);bE.fillStyle="#C48200";bE.closePath();bE.fill();bE.beginPath();bD=bB*0.028037/2;bE.arc(aV,bw+ba/2,bD,0,G);bE.fillStyle="#999999";bE.closePath();bE.fill();bE.beginPath();bD=bB*0.018691/2;bE.arc(aV,bw+ba/2,bD,0,G);bE.fillStyle="#000000";bE.closePath();bE.fill();bE.restore()},bh=function(){a8=new Date().getTime()-bf;bu=(a8*aW/1000);bn=(bu%10800)/30;bo=(a8/60000)%30;a7=(a8/1000)%60;be=(a8)%1000},br=function(bE){bE=bE||{};var bF=(undefined===bE.frame?false:bE.frame),bG=(undefined===bE.background?false:bE.background),bH=(undefined===bE.pointers?false:bE.pointers),bD=(undefined===bE.foreground?false:bE.foreground);a5=true;if(bF&&bj){d(aZ,aT,aV,aU,bB,bk)}if(bG&&bg){aO(aQ,aR,aV,aU,bB,bk);P(aQ,bC,aV,aU,bB,bk);bz(aQ,bB,60,0.075,0.1,0,0);bz(aQ,ba,30,0.095,0.13,bq,bw)}if(bH){aS(a0);a4(aX)}if(bD&&bx){z(bc,by,bB,bk,false)}},bv=function(bE){bE=bE||{};var bF=(undefined===bE.frame?false:bE.frame),bG=(undefined===bE.background?false:bE.background),bH=(undefined===bE.pointers?false:bE.pointers),bD=(undefined===bE.foreground?false:bE.foreground);if(bF){a6.width=a1;a6.height=a1;aZ=a6.getContext("2d")}if(bG){bm.width=a1;bm.height=a1;aQ=bm.getContext("2d")}if(bH){bd.width=a1;bd.height=a1;aX=bd.getContext("2d");aY.width=a1;aY.height=a1;a0=aY.getContext("2d")}if(bD){bp.width=a1;bp.height=a1;bc=bp.getContext("2d")}},a9=function(){if(!bl){bh();a3.repaint()}if(bi){bb=setTimeout(a9,200)}};this.isRunning=function(){return bi};this.start=function(){if(!bi){bi=true;bf=new Date().getTime()-a8;a9()}};this.stop=function(){if(bi){bi=false;clearTimeout(bb)}if(bl){bl=false;bh();this.repaint()}};this.reset=function(){if(bi){bi=false;bl=false;clearTimeout(bb)}bf=new Date().getTime();bh();this.repaint()};this.lap=function(){if(bi&&!bl){bl=true}else{if(bl){bl=false}}};this.getMeasuredTime=function(){return(bo+":"+a7+":"+be)};this.setFrameDesign=function(bD){bv({frame:true});aT=bD;br({frame:true});this.repaint()};this.setBackgroundColor=function(bD){bv({background:true});aR=bD;br({background:true});this.repaint()};this.setForegroundType=function(bD){bv({foreground:true});by=bD;br({foreground:true});this.repaint()};this.setPointerColor=function(bD){bv({pointers:true});bA=bD;br({pointers:true});this.repaint()};this.repaint=function(){if(!a5){br({frame:true,background:true,pointers:true,foreground:true})}bs.clearRect(0,0,bs.canvas.width,bs.canvas.height);if(bj){bs.drawImage(a6,0,0)}if(bg){bs.drawImage(bm,0,0)}var bD=bB*0.006;var bF=(bn+(2*Math.sin(bn*l)))*l;var bE=(bu+(2*Math.sin(bu*l)))*l;bs.save();bs.translate(aV,bw+ba/2);bs.rotate(bF);bs.translate(-aV,-(bw+ba/2));bs.shadowColor="rgba(0, 0, 0, 0.8)";bs.shadowOffsetX=bs.shadowOffsetY=bD/2;bs.shadowBlur=bD;bs.drawImage(bd,0,0);bs.restore();bs.save();bs.translate(aV,aU);bs.rotate(bE);bs.translate(-aV,-aU);bs.shadowColor="rgba(0, 0, 0, 0.8)";bs.shadowOffsetX=bs.shadowOffsetY=bD/2;bs.shadowBlur=bD;bs.drawImage(aY,0,0);bs.restore();if(bx){bs.drawImage(bp,0,0)}};bs.save();bs.clearRect(0,0,bs.canvas.width,bs.canvas.height);bs.canvas.width=a1;bs.canvas.height=a1;bf=new Date().getTime();a9();return this};var aP=function(a3,bC){bC=bC||{};var a2=(undefined===bC.size?200:bC.size),aU=(undefined===bC.frameDesign?steelseries.FrameDesign.METAL:bC.frameDesign),bo=(undefined===bC.frameVisible?true:bC.frameVisible),aR=(undefined===bC.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:bC.backgroundColor),bk=(undefined===bC.backgroundVisible?true:bC.backgroundVisible),bI=(undefined===bC.knobType?steelseries.KnobType.METAL_KNOB:bC.knobType),bp=(undefined===bC.knobStyle?steelseries.KnobStyle.BLACK:bC.knobStyle),bn=(undefined===bC.lcdColor?steelseries.LcdColor.BLACK:bC.lcdColor),bw=(undefined===bC.lcdVisible?true:bC.lcdVisible),aZ=(undefined===bC.digitalFont?false:bC.digitalFont),bF=(undefined===bC.foregroundType?steelseries.ForegroundType.TYPE1:bC.foregroundType),bE=(undefined===bC.foregroundVisible?true:bC.foregroundVisible),bK=(undefined===bC.customLayer?null:bC.customLayer),aX=0,ba=10,bv=aX,by=0,bc=0,a9=0,a6,bs,a7,bz=1,be,bd=false,bJ,bq,aW,aV,bm,bB=A.getElementById(a3).getContext("2d"),bi=am,a8=false,bb=I(a2,a2),aY=bb.getContext("2d"),bt=I(a2,a2),aQ=bt.getContext("2d"),bH,a1=I(a2,a2),br=a1.getContext("2d"),bg=I(a2,a2),aS=bg.getContext("2d"),a4=I(a2,a2),a5=a4.getContext("2d"),bx=I(a2,a2),bh=bx.getContext("2d");bB.save();bB.clearRect(0,0,bB.canvas.width,bB.canvas.height);bB.canvas.width=a2;bB.canvas.height=a2;bJ=a2;bq=a2;aW=bJ/2;aV=bq/2;bm=Math.floor(bJ*0.09)+"px sans-serif";var bf=function(bL){bB.save();bB.textAlign="right";bB.textBaseline="middle";bB.strokeStyle=bn.textColor;bB.fillStyle=bn.textColor;if(bn===steelseries.LcdColor.STANDARD||bn===steelseries.LcdColor.STANDARD_GREEN){bB.shadowColor="gray";bB.shadowOffsetX=bJ*0.007;bB.shadowOffsetY=bJ*0.007;bB.shadowBlur=bJ*0.009}if(aZ){bB.font=Math.floor(bJ*0.075)+"px "+aC}else{bB.font=Math.floor(bJ*0.075)+"px sans-serif"}bB.fillText(Math.round(bL),(bJ+(bJ*0.4))/2-4,bJ*0.607,bJ*0.4);bB.restore()};var bG=function(b1,b7,bR,b5,bT,bX,b3,bW,bM,bZ){var bY=Math.max(bJ*0.012,2),bN=Math.max(bJ*0.007,1.5),bU=bJ*0.13,bP=bJ*0.05,b4=bJ*0.07,b2=bJ*0.4,bV=0,b0=0,bL=0,b6=0,bQ,bS,bO=-bR-(b7/2);b1.save();b1.textAlign="center";b1.textBaseline="middle";b1.font=bm;b1.strokeStyle=aR.labelColor.getRgbaColor();b1.fillStyle=aR.labelColor.getRgbaColor();for(bQ=bO,bS=0;bS<=10;bQ-=bX*0.1,bS+=0.1){bL=Math.sin(bQ);b6=Math.cos(bQ);if(bV%2===0){b1.lineWidth=bN;b1.beginPath();b1.moveTo(aW+(b2-bP)*bL,aV+(b2-bP)*b6);b1.lineTo(aW+b2*bL,aV+b2*b6);b1.closePath();b1.stroke()}if(bV===10||bV===0){b1.lineWidth=bY;if(b7===0){if(Math.round(bS)!==ba){b1.fillText(Math.round(bS).toString(),aW+(b2-bU)*bL,aV+(b2-bU)*b6)}}bV=0;b0++;b1.beginPath();b1.moveTo(aW+(b2-b4)*bL,aV+(b2-b4)*b6);b1.lineTo(aW+b2*bL,aV+b2*b6);b1.closePath();b1.stroke()}bV++}b1.restore()};var a0=function(bL,bN){var bM;if(bN){bL.fillStyle="rgba(0, 0, 0, 0.5)";bL.strokeStyle="rgba(0, 0, 0, 0.5)"}else{bM=bL.createLinearGradient(0,bq*0.168224,0,bq*0.626168);bM.addColorStop(0,"#ffffff");bM.addColorStop(0.31,"#ffffff");bM.addColorStop(0.3101,"#ffffff");bM.addColorStop(0.32,"#202020");bM.addColorStop(1,"#202020");bL.fillStyle=bM}bL.save();bL.beginPath();bL.moveTo(bJ*0.518691,bq*0.471962);bL.bezierCurveTo(bJ*0.514018,bq*0.471962,bJ*0.509345,bq*0.467289,bJ*0.509345,bq*0.467289);bL.lineTo(bJ*0.509345,bq*0.200934);bL.lineTo(bJ*0.5,bq*0.168224);bL.lineTo(bJ*0.490654,bq*0.200934);bL.lineTo(bJ*0.490654,bq*0.467289);bL.bezierCurveTo(bJ*0.490654,bq*0.467289,bJ*0.481308,bq*0.471962,bJ*0.481308,bq*0.471962);bL.bezierCurveTo(bJ*0.471962,bq*0.481308,bJ*0.467289,bq*0.490654,bJ*0.467289,bq*0.5);bL.bezierCurveTo(bJ*0.467289,bq*0.514018,bJ*0.476635,bq*0.528037,bJ*0.490654,bq*0.53271);bL.bezierCurveTo(bJ*0.490654,bq*0.53271,bJ*0.490654,bq*0.579439,bJ*0.490654,bq*0.588785);bL.bezierCurveTo(bJ*0.485981,bq*0.593457,bJ*0.481308,bq*0.59813,bJ*0.481308,bq*0.607476);bL.bezierCurveTo(bJ*0.481308,bq*0.616822,bJ*0.490654,bq*0.626168,bJ*0.5,bq*0.626168);bL.bezierCurveTo(bJ*0.509345,bq*0.626168,bJ*0.518691,bq*0.616822,bJ*0.518691,bq*0.607476);bL.bezierCurveTo(bJ*0.518691,bq*0.59813,bJ*0.514018,bq*0.593457,bJ*0.504672,bq*0.588785);bL.bezierCurveTo(bJ*0.504672,bq*0.579439,bJ*0.504672,bq*0.53271,bJ*0.509345,bq*0.53271);bL.bezierCurveTo(bJ*0.523364,bq*0.528037,bJ*0.53271,bq*0.514018,bJ*0.53271,bq*0.5);bL.bezierCurveTo(bJ*0.53271,bq*0.490654,bJ*0.528037,bq*0.481308,bJ*0.518691,bq*0.471962);bL.closePath();bL.fill();bL.restore()};var bj=function(bL){var bM;bM=bL.createLinearGradient(0,bq*0.401869,0,bq*0.616822);bM.addColorStop(0,"#ffffff");bM.addColorStop(0.51,"#ffffff");bM.addColorStop(0.52,"#ffffff");bM.addColorStop(0.5201,"#202020");bM.addColorStop(0.53,"#202020");bM.addColorStop(1,"#202020");bL.fillStyle=bM;bL.beginPath();bL.moveTo(bJ*0.518691,bq*0.471962);bL.bezierCurveTo(bJ*0.514018,bq*0.462616,bJ*0.528037,bq*0.401869,bJ*0.528037,bq*0.401869);bL.lineTo(bJ*0.5,bq*0.331775);bL.lineTo(bJ*0.471962,bq*0.401869);bL.bezierCurveTo(bJ*0.471962,bq*0.401869,bJ*0.485981,bq*0.462616,bJ*0.481308,bq*0.471962);bL.bezierCurveTo(bJ*0.471962,bq*0.481308,bJ*0.467289,bq*0.490654,bJ*0.467289,bq*0.5);bL.bezierCurveTo(bJ*0.467289,bq*0.514018,bJ*0.476635,bq*0.528037,bJ*0.490654,bq*0.53271);bL.bezierCurveTo(bJ*0.490654,bq*0.53271,bJ*0.462616,bq*0.574766,bJ*0.462616,bq*0.593457);bL.bezierCurveTo(bJ*0.467289,bq*0.616822,bJ*0.5,bq*0.612149,bJ*0.5,bq*0.612149);bL.bezierCurveTo(bJ*0.5,bq*0.612149,bJ*0.53271,bq*0.616822,bJ*0.537383,bq*0.593457);bL.bezierCurveTo(bJ*0.537383,bq*0.574766,bJ*0.509345,bq*0.53271,bJ*0.509345,bq*0.53271);bL.bezierCurveTo(bJ*0.523364,bq*0.528037,bJ*0.53271,bq*0.514018,bJ*0.53271,bq*0.5);bL.bezierCurveTo(bJ*0.53271,bq*0.490654,bJ*0.528037,bq*0.481308,bJ*0.518691,bq*0.471962);bL.closePath();bL.fill();bL.restore()};var bu=function(bL){bL.fillStyle="#ffffff";bL.beginPath();bL.moveTo(bJ*0.518691,bq*0.471962);bL.bezierCurveTo(bJ*0.514018,bq*0.471962,bJ*0.514018,bq*0.467289,bJ*0.514018,bq*0.467289);bL.lineTo(bJ*0.514018,bq*0.317757);bL.lineTo(bJ*0.504672,bq*0.303738);bL.lineTo(bJ*0.504672,bq*0.182242);bL.lineTo(bJ*0.53271,bq*0.116822);bL.lineTo(bJ*0.462616,bq*0.116822);bL.lineTo(bJ*0.495327,bq*0.182242);bL.lineTo(bJ*0.495327,bq*0.299065);bL.lineTo(bJ*0.485981,bq*0.317757);bL.lineTo(bJ*0.485981,bq*0.467289);bL.bezierCurveTo(bJ*0.485981,bq*0.467289,bJ*0.485981,bq*0.471962,bJ*0.481308,bq*0.471962);bL.bezierCurveTo(bJ*0.471962,bq*0.481308,bJ*0.467289,bq*0.490654,bJ*0.467289,bq*0.5);bL.bezierCurveTo(bJ*0.467289,bq*0.518691,bJ*0.481308,bq*0.53271,bJ*0.5,bq*0.53271);bL.bezierCurveTo(bJ*0.518691,bq*0.53271,bJ*0.53271,bq*0.518691,bJ*0.53271,bq*0.5);bL.bezierCurveTo(bJ*0.53271,bq*0.490654,bJ*0.528037,bq*0.481308,bJ*0.518691,bq*0.471962);bL.closePath();bL.fill()};function bl(){a6=(G)/(ba-aX);bs=a6/10;a7=bs/10}function aT(){by=(bv%1000)/100;bc=(bv%10000)/100;a9=(bv%100000)/100}var bA=function(bM){bM=bM||{};var bN=(undefined===bM.frame?false:bM.frame),bO=(undefined===bM.background?false:bM.background),bP=(undefined===bM.pointers?false:bM.pointers),bL=(undefined===bM.foreground?false:bM.foreground);a8=true;bl();if(bN&&bo){d(aY,aU,aW,aV,bJ,bq)}if(bO&&bk){aO(aQ,aR,aW,aV,bJ,bq);P(aQ,bK,aW,aV,bJ,bq);bG(aQ,0,bi,0,10,a6,bz,0,true,true,null)}if(bO&&bw){bH=U(bJ*0.4,bq*0.09,bn);aQ.drawImage(bH,(bJ-(bJ*0.4))/2,bq*0.56)}if(bP){a0(a5,false);bj(aS,false);bu(br,false)}if(bL&&bE){z(bh,bF,bJ,bq,true,bI,bp)}};var bD=function(bM){bM=bM||{};var bN=(undefined===bM.frame?false:bM.frame),bO=(undefined===bM.background?false:bM.background),bP=(undefined===bM.pointers?false:bM.pointers),bL=(undefined===bM.foreground?false:bM.foreground);if(bN){bb.width=a2;bb.height=a2;aY=bb.getContext("2d")}if(bO){bt.width=a2;bt.height=a2;aQ=bt.getContext("2d")}if(bP){a4.width=a2;a4.height=a2;a5=a4.getContext("2d");bg.width=a2;bg.height=a2;aS=bg.getContext("2d");a1.width=a2;a1.height=a2;br=a1.getContext("2d")}if(bL){bx.width=a2;bx.height=a2;bh=bx.getContext("2d")}};this.setValue=function(bL){bv=bL;this.repaint()};this.getValue=function(){return bv};this.setValueAnimated=function(bO){var bL=(bO<aX?aX:bO),bM=this,bN;if(bv!==bL){if(undefined!==be){if(be.playing){be.stop()}}bN=Math.max(Math.abs(bv-bL)/10000*5,1);be=new Tween({},"",Tween.regularEaseInOut,bv,bL,bN);be.onMotionChanged=function(bP){bv=bP.target._pos;if(!bd){bd=true;ab(bM.repaint)}};be.start()}};this.setFrameDesign=function(bL){bD({frame:true});aU=bL;bA({frame:true});this.repaint()};this.setBackgroundColor=function(bL){bD({background:true,pointer:true});aR=bL;bA({background:true,pointer:true});this.repaint()};this.setForegroundType=function(bL){bD({foreground:true});bF=bL;bA({foreground:true});this.repaint()};this.setLcdColor=function(bL){bn=bL;bD({background:true});bA({background:true});this.repaint()};this.repaint=function(){if(!a8){bA({frame:true,background:true,led:true,pointers:true,foreground:true})}bB.clearRect(0,0,bB.canvas.width,bB.canvas.height);if(bo){bB.drawImage(bb,0,0)}bB.drawImage(bt,0,0);if(bw){bf(bv)}aT();var bL=bJ*0.006*0.5;bB.save();bB.translate(aW,aV);bB.rotate((a9-aX)*a7);bB.translate(-aW,-aV);bB.shadowColor="rgba(0, 0, 0, 0.8)";bB.shadowOffsetX=bB.shadowOffsetY=bL;bB.shadowBlur=bL*2;bB.drawImage(a1,0,0);bL=bJ*0.006*0.75;bB.shadowOffsetX=bB.shadowOffsetY=bL;bB.translate(aW,aV);bB.rotate((bc-aX)*bs-(a9-aX)*a7);bB.translate(-aW,-aV);bB.drawImage(bg,0,0);bL=bJ*0.006;bB.shadowOffsetX=bB.shadowOffsetY=bL;bB.translate(aW,aV);bB.rotate((by-aX)*a6-(bc-aX)*bs);bB.translate(-aW,-aV);bB.drawImage(a4,0,0);bB.restore();if(bE){bB.drawImage(bx,0,0)}bd=false};this.repaint();return this};var aD=function(aV,bv){bv=bv||{};var aQ=(undefined===bv.width?98:bv.width),aR=(undefined===bv.height?278:bv.height),bu,a9,by,bj,bm=false,bo=false,aY=false,aX=false,aW=A.createElement("canvas"),br=aW.getContext("2d"),a3=A.createElement("canvas"),bt=a3.getContext("2d"),bx=A.createElement("canvas"),bc=bx.getContext("2d"),aZ=A.createElement("canvas"),bl=aZ.getContext("2d"),bi=A.createElement("canvas"),bq=bi.getContext("2d"),bd=A.createElement("canvas"),bh=bd.getContext("2d"),bg=A.createElement("canvas"),be=bg.getContext("2d"),a5=A.createElement("canvas"),aT=a5.getContext("2d"),bn=A.createElement("canvas"),a7=bn.getContext("2d"),aS=A.createElement("canvas"),bf=aS.getContext("2d");bu=A.getElementById(aV).getContext("2d");bu.save();bu.clearRect(0,0,bu.canvas.width,bu.canvas.height);bu.canvas.width=aQ;bu.canvas.height=aR;a9=aQ<(aR*0.352517)?(aQ*2.836734):aR;by=a9*0.352517;bj=a9;aW.width=by;aW.height=bj;a3.width=by;a3.height=bj;bx.width=by;bx.height=bj;aZ.width=by;aZ.height=bj;bi.width=by;bi.height=bj;bd.width=by;bd.height=bj;bg.width=by;bg.height=bj;a5.width=by;a5.height=bj;bn.width=by;bn.height=bj;aS.width=by;aS.height=bj;var ba=function(bz){var bA,bB;bz.save();bz.save();bz.beginPath();bz.moveTo(0.107142*by,0);bz.lineTo(by-0.107142*by,0);bz.quadraticCurveTo(by,0,by,0.107142*by);bz.lineTo(by,bj-0.107142*by);bz.quadraticCurveTo(by,bj,by-0.107142*by,bj);bz.lineTo(0.107142*by,bj);bz.quadraticCurveTo(0,bj,0,bj-0.107142*by);bz.lineTo(0,0.107142*by);bz.quadraticCurveTo(0,0,0.107142*by,bj);bz.closePath();bA=bz.createLinearGradient(0.040816*by,0.007194*bj,0.952101*by,0.995882*bj);bA.addColorStop(0,"rgb(152, 152, 154)");bA.addColorStop(0.01,"rgb(152, 152, 154)");bA.addColorStop(0.09,"#333333");bA.addColorStop(0.24,"rgb(152, 152, 154)");bA.addColorStop(0.55,"rgb(31, 31, 31)");bA.addColorStop(0.78,"#363636");bA.addColorStop(0.98,"#000000");bA.addColorStop(1,"#000000");bz.fillStyle=bA;bz.fill();bz.restore();bz.save();bz.beginPath();bz.moveTo(0.030612*by+0.084183*by,0.010791*bj);bz.lineTo(0.030612*by+0.938775*by-0.084183*by,0.010791*bj);bz.quadraticCurveTo(0.030612*by+0.938775*by,0.010791*bj,0.030612*by+0.938775*by,0.010791*bj+0.084183*by);bz.lineTo(0.030612*by+0.938775*by,0.010791*bj+0.978417*bj-0.084183*by);bz.quadraticCurveTo(0.030612*by+0.938775*by,0.010791*bj+0.978417*bj,0.030612*by+0.938775*by-0.084183*by,0.010791*bj+0.978417*bj);bz.lineTo(0.030612*by+0.084183*by,0.010791*bj+0.978417*bj);bz.quadraticCurveTo(0.030612*by,0.010791*bj+0.978417*bj,0.030612*by,0.010791*bj+0.978417*bj-0.084183*by);bz.lineTo(0.030612*by,0.010791*bj+0.084183*by);bz.quadraticCurveTo(0.030612*by,0.010791*bj,0.030612*by+0.084183*by,0.010791*bj);bz.closePath();bB=bz.createLinearGradient(-0.132653*by,-0.053956*bj,2.061408*by,0.667293*bj);bB.addColorStop(0,"#000000");bB.addColorStop(0.01,"#000000");bB.addColorStop(0.16,"#373735");bB.addColorStop(0.31,"#000000");bB.addColorStop(0.44,"#303030");bB.addColorStop(0.65,"#000000");bB.addColorStop(0.87,"#363636");bB.addColorStop(0.98,"#000000");bB.addColorStop(1,"#000000");bz.fillStyle=bB;bz.fill();bz.restore();bz.restore()};var a1=function(bB){var bD,bA,bz,bC;bB.save();bB.save();bB.scale(1,1);bB.beginPath();bB.arc(0.5*by,0.805755*bj,0.397959*by,0,G,false);bD=bB.createLinearGradient(0,0.665467*bj,0,0.946043*bj);bD.addColorStop(0,"#ffffff");bD.addColorStop(0.05,"rgb(204, 204, 204)");bD.addColorStop(0.1,"rgb(153, 153, 153)");bD.addColorStop(0.17,"#666666");bD.addColorStop(0.27,"#333333");bD.addColorStop(1,"#010101");bB.fillStyle=bD;bB.fill();bB.restore();bB.save();bB.scale(1.083333,1);bB.beginPath();bB.arc(0.461538*by,0.816546*bj,0.367346*by,0,G,false);bA=bB.createLinearGradient(0,0.68705*bj,0,0.946043*bj);bA.addColorStop(0,"#000000");bA.addColorStop(0.35,"#040404");bA.addColorStop(0.66,"#000000");bA.addColorStop(1,"#010101");bB.fillStyle=bA;bB.fill();bB.restore();bB.save();bB.scale(1,1);bB.beginPath();bB.arc(0.5*by,0.809352*bj,0.357142*by,0,G,false);bz=bB.createRadialGradient(0.5*by,0.809352*bj,0,0.5*by,0.809352*bj,0.362244*by);bz.addColorStop(0,"#000000");bz.addColorStop(0.88,"#000000");bz.addColorStop(0.95,"rgb(94, 94, 94)");bz.addColorStop(1,"#010101");bB.fillStyle=bz;bB.fill();bB.restore();bB.save();bB.scale(1,1);bB.beginPath();bB.arc(0.5*by,0.809352*bj,0.357142*by,0,G,false);bC=bB.createLinearGradient(0,0.68705*bj,0,0.917266*bj);bC.addColorStop(0,"#000000");bC.addColorStop(1,"rgba(1, 1, 1, 0)");bB.fillStyle=bC;bB.fill();bB.restore();bB.restore()};var aU=function(bA){var bB,bz;bA.save();bA.save();bA.scale(1,1);bA.beginPath();bA.arc(0.5*by,0.809352*bj,0.32653*by,0,G,false);bB=bA.createRadialGradient(0.5*by,0.809352*bj,0,0.5*by,0.809352*bj,0.32653*by);bB.addColorStop(0,"rgb(85, 185, 123)");bB.addColorStop(1,"rgb(0, 31, 0)");bA.fillStyle=bB;bA.fill();bA.restore();bA.save();bA.beginPath();bA.moveTo(0,0.812949*bj);bA.bezierCurveTo(0,0.910071*bj,0.224489*by,0.989208*bj,0.5*by,0.989208*bj);bA.bezierCurveTo(0.77551*by,0.989208*bj,by,0.910071*bj,by,0.809352*bj);bA.bezierCurveTo(0.908163*by,0.751798*bj,0.704081*by,0.68705*bj,0.5*by,0.68705*bj);bA.bezierCurveTo(0.285714*by,0.68705*bj,0.081632*by,0.751798*bj,0,0.812949*bj);bA.closePath();bz=bA.createRadialGradient(0.5*by,0.809352*bj,0,0.5*by,0.809352*bj,0.515306*by);bz.addColorStop(0,"rgb(65, 187, 126)");bz.addColorStop(1,"rgba(4, 37, 8, 0)");bA.fillStyle=bz;bA.fill();bA.restore();bA.restore()};var a8=function(bz){var bA,bB;bz.save();bz.save();bz.scale(1,1);bz.beginPath();bz.arc(0.5*by,0.809352*bj,0.32653*by,0,G,false);bA=bz.createRadialGradient(0.5*by,0.809352*bj,0,0.5*by,0.809352*bj,0.32653*by);bA.addColorStop(0,"rgba(0, 255, 0, 0.25)");bA.addColorStop(1,"rgba(0, 255, 0, 0.05)");bz.fillStyle=bA;bz.fill();bz.restore();bz.save();bz.scale(1,1);bz.beginPath();bz.arc(0.5*by,0.809352*bj,0.32653*by,0,G,false);bB=bz.createRadialGradient(0.5*by,0.809352*bj,0,0.5*by,0.809352*bj,0.32653*by);bB.addColorStop(0,"rgba(1, 1, 1, 0)");bB.addColorStop(0.55,"rgba(0, 0, 0, 0)");bB.addColorStop(0.5501,"rgba(0, 0, 0, 0)");bB.addColorStop(0.78,"rgba(0, 0, 0, 0.12)");bB.addColorStop(0.79,"rgba(0, 0, 0, 0.12)");bB.addColorStop(1,"rgba(0, 0, 0, 0.5)");bz.fillStyle=bB;bz.fill();bz.restore();bz.fillStyle=bz.createPattern(bw,"repeat");bz.fill();bz.restore()};var a2=function(bB){var bA,bz,bD,bC;bB.save();bB.save();bB.scale(1,1);bB.beginPath();bB.arc(0.5*by,0.496402*bj,0.397959*by,0,G,false);bA=bB.createLinearGradient(0,0.356115*bj,0,0.63669*bj);bA.addColorStop(0,"#ffffff");bA.addColorStop(0.05,"rgb(204, 204, 204)");bA.addColorStop(0.1,"rgb(153, 153, 153)");bA.addColorStop(0.17,"#666666");bA.addColorStop(0.27,"#333333");bA.addColorStop(1,"#010101");bB.fillStyle=bA;bB.fill();bB.restore();bB.save();bB.scale(1.083333,1);bB.beginPath();bB.arc(0.461538*by,0.507194*bj,0.367346*by,0,G,false);bz=bB.createLinearGradient(0,0.377697*bj,0,0.63669*bj);bz.addColorStop(0,"#000000");bz.addColorStop(0.35,"#040404");bz.addColorStop(0.66,"#000000");bz.addColorStop(1,"#010101");bB.fillStyle=bz;bB.fill();bB.restore();bB.save();bB.scale(1,1);bB.beginPath();bB.arc(0.5*by,0.5*bj,0.357142*by,0,G,false);bD=bB.createRadialGradient(0.5*by,0.5*bj,0,0.5*by,0.5*bj,0.362244*by);bD.addColorStop(0,"#000000");bD.addColorStop(0.88,"#000000");bD.addColorStop(0.95,"#5e5e5e");bD.addColorStop(1,"#010101");bB.fillStyle=bD;bB.fill();bB.restore();bB.save();bB.scale(1,1);bB.beginPath();bB.arc(0.5*by,0.5*bj,0.357142*by,0,G,false);bC=bB.createLinearGradient(0,0.377697*bj,0,0.607913*bj);bC.addColorStop(0,"#000000");bC.addColorStop(1,"rgba(1, 1, 1, 0)");bB.fillStyle=bC;bB.fill();bB.restore();bB.restore()};var bp=function(bz){var bA,bB;bz.save();bz.save();bz.scale(1,1);bz.beginPath();bz.arc(0.5*by,0.5*bj,0.32653*by,0,G,false);bA=bz.createRadialGradient(0.5*by,0.5*bj,0,0.5*by,0.5*bj,0.32653*by);bA.addColorStop(0,"#fed434");bA.addColorStop(1,"#82330c");bz.fillStyle=bA;bz.fill();bz.restore();bz.save();bz.beginPath();bz.moveTo(0,0.503597*bj);bz.bezierCurveTo(0,0.600719*bj,0.224489*by,0.679856*bj,0.5*by,0.679856*bj);bz.bezierCurveTo(0.77551*by,0.679856*bj,by,0.600719*bj,by,0.5*bj);bz.bezierCurveTo(0.908163*by,0.442446*bj,0.704081*by,0.377697*bj,0.5*by,0.377697*bj);bz.bezierCurveTo(0.285714*by,0.377697*bj,0.081632*by,0.442446*bj,0,0.503597*bj);bz.closePath();bB=bz.createRadialGradient(0.5*by,0.5*bj,0,0.5*by,0.5*bj,0.515306*by);bB.addColorStop(0,"#fed434");bB.addColorStop(1,"rgba(130, 51, 12, 0)");bz.fillStyle=bB;bz.fill();bz.restore();bz.restore()};var a4=function(bz){var bB,bA;bz.save();bz.save();bz.scale(1,1);bz.beginPath();bz.arc(0.5*by,0.5*bj,0.32653*by,0,G,false);bB=bz.createRadialGradient(0.5*by,0.5*bj,0,0.5*by,0.5*bj,0.32653*by);bB.addColorStop(0,"rgba(255, 255, 0, 0.25)");bB.addColorStop(1,"rgba(255, 255, 0, 0.05)");bz.fillStyle=bB;bz.fill();bz.restore();bz.save();bz.scale(1,1);bz.beginPath();bz.arc(0.5*by,0.5*bj,0.32653*by,0,G,false);bA=bz.createRadialGradient(0.5*by,0.5*bj,0,0.5*by,0.5*bj,0.32653*by);bA.addColorStop(0,"rgba(1, 1, 1, 0)");bA.addColorStop(0.55,"rgba(0, 0, 0, 0)");bA.addColorStop(0.5501,"rgba(0, 0, 0, 0)");bA.addColorStop(0.78,"rgba(0, 0, 0, 0.12)");bA.addColorStop(0.79,"rgba(0, 0, 0, 0.13)");bA.addColorStop(1,"rgba(0, 0, 0, 0.5)");bz.fillStyle=bA;bz.fill();bz.restore();bz.fillStyle=bz.createPattern(bw,"repeat");bz.fill();bz.restore()};var bb=function(bB){var bD,bA,bC,bz;bB.save();bB.save();bB.scale(1,1);bB.beginPath();bB.arc(0.5*by,0.18705*bj,0.397959*by,0,G,false);bD=bB.createLinearGradient((0.5*by),(0.046762*bj),((0.5)*by),((0.327338)*bj));bD.addColorStop(0,"#ffffff");bD.addColorStop(0.05,"#cccccc");bD.addColorStop(0.1,"#999999");bD.addColorStop(0.17,"#666666");bD.addColorStop(0.27,"#333333");bD.addColorStop(1,"#010101");bB.fillStyle=bD;bB.fill();bB.restore();bB.save();bB.scale(1.083333,1);bB.beginPath();bB.arc(0.461538*by,0.197841*bj,0.367346*by,0,G,false);bA=bB.createLinearGradient((0.5*by),(0.068345*bj),((0.5)*by),((0.327338)*bj));bA.addColorStop(0,"#000000");bA.addColorStop(0.35,"#040404");bA.addColorStop(0.66,"#000000");bA.addColorStop(1,"#010101");bB.fillStyle=bA;bB.fill();bB.restore();bB.save();bB.scale(1,1);bB.beginPath();bB.arc(0.5*by,0.190647*bj,0.357142*by,0,G,false);bC=bB.createRadialGradient((0.5)*by,((0.190647)*bj),0,((0.5)*by),((0.190647)*bj),0.362244*by);bC.addColorStop(0,"#000000");bC.addColorStop(0.88,"#000000");bC.addColorStop(0.95,"#5e5e5e");bC.addColorStop(1,"#010101");bB.fillStyle=bC;bB.fill();bB.restore();bB.save();bB.scale(1,1);bB.beginPath();bB.arc(0.5*by,0.190647*bj,0.357142*by,0,G,false);bz=bB.createLinearGradient((0.5*by),(0.068345*bj),((0.5)*by),((0.298561)*bj));bz.addColorStop(0,"#000000");bz.addColorStop(1,"rgba(1, 1, 1, 0)");bB.fillStyle=bz;bB.fill();bB.restore();bB.restore()};var bk=function(bz){var bB,bA;bz.save();bz.save();bz.scale(1,1);bz.beginPath();bz.arc(0.5*by,0.190647*bj,0.32653*by,0,G,false);bB=bz.createRadialGradient(0.5*by,0.190647*bj,0,0.5*by,0.190647*bj,0.32653*by);bB.addColorStop(0,"#ff0000");bB.addColorStop(1,"#410004");bz.fillStyle=bB;bz.fill();bz.restore();bz.save();bz.beginPath();bz.moveTo(0,0.194244*bj);bz.bezierCurveTo(0,0.291366*bj,0.224489*by,0.370503*bj,0.5*by,0.370503*bj);bz.bezierCurveTo(0.77551*by,0.370503*bj,by,0.291366*bj,by,0.190647*bj);bz.bezierCurveTo(0.908163*by,0.133093*bj,0.704081*by,0.068345*bj,0.5*by,0.068345*bj);bz.bezierCurveTo(0.285714*by,0.068345*bj,0.081632*by,0.133093*bj,0,0.194244*bj);bz.closePath();bA=bz.createRadialGradient(0.5*by,0.190647*bj,0,0.5*by,0.190647*bj,0.515306*by);bA.addColorStop(0,"#ff0000");bA.addColorStop(1,"rgba(118, 5, 1, 0)");bz.fillStyle=bA;bz.fill();bz.restore();bz.restore()};var a6=function(bA){var bz,bB;bA.save();bA.save();bA.scale(1,1);bA.beginPath();bA.arc(0.5*by,0.190647*bj,0.32653*by,0,G,false);bz=bA.createRadialGradient(0.5*by,0.190647*bj,0,0.5*by,0.190647*bj,0.32653*by);bz.addColorStop(0,"rgba(255, 0, 0, 0.25)");bz.addColorStop(1,"rgba(255, 0, 0, 0.05)");bA.fillStyle=bz;bA.fill();bA.restore();bA.save();bA.scale(1,1);bA.beginPath();bA.arc(0.5*by,0.190647*bj,0.32653*by,0,G,false);bB=bA.createRadialGradient(0.5*by,0.190647*bj,0,0.5*by,0.190647*bj,0.32653*by);bB.addColorStop(0,"rgba(1, 1, 1, 0)");bB.addColorStop(0.55,"rgba(0, 0, 0, 0)");bB.addColorStop(0.5501,"rgba(0, 0, 0, 0)");bB.addColorStop(0.78,"rgba(0, 0, 0, 0.12)");bB.addColorStop(0.79,"rgba(0, 0, 0, 0.13)");bB.addColorStop(1,"rgba(0, 0, 0, 0.5)");bA.fillStyle=bB;bA.fill();bA.restore();bA.fillStyle=bA.createPattern(bw,"repeat");bA.fill();bA.restore()};function a0(bB,bz,bC){var bA=A.createElement("canvas");bA.width=bB;bA.height=bz;bC(bA.getContext("2d"));return bA}var bw=a0(2,2,function(bz){bz.save();bz.strokeStyle="rgba(0, 0, 0, 0.1)";bz.beginPath();bz.lineTo(0,0,1,0);bz.lineTo(0,1,0,1);bz.stroke();bz.restore()});var bs=function(){aX=true;ba(br);a1(bt);aU(bc);a8(bl);a2(bq);bp(bh);a4(be);bb(aT);bk(a7);a6(bf)};this.setRedOn=function(bz){bm=bz;this.repaint()};this.isRedOn=function(){return bm};this.setYellowOn=function(bz){bo=bz;this.repaint()};this.isYellowOn=function(){return bo};this.setGreenOn=function(bz){aY=bz;this.repaint()};this.isGreenOn=function(){return aY};this.repaint=function(){if(!aX){bs()}bu.save();bu.clearRect(0,0,bu.canvas.width,bu.canvas.height);bu.drawImage(aW,0,0);bu.drawImage(a3,0,0);if(aY){bu.drawImage(bx,0,0)}bu.drawImage(aZ,0,0);bu.drawImage(bi,0,0);if(bo){bu.drawImage(bd,0,0)}bu.drawImage(bg,0,0);bu.drawImage(a5,0,0);if(bm){bu.drawImage(bn,0,0)}bu.drawImage(aS,0,0);bu.restore()};this.repaint();return this};var M=function(aT,aX){aX=aX||{};var a1,a5=(undefined===aX.width?100:aX.width),a4=(undefined===aX.height?100:aX.height),bd=(undefined===aX.glowColor?"#ffff00":aX.glowColor),a3,a0,bc,aV=false,aR=false,aW=1,aZ=A.createElement("canvas"),a6=aZ.getContext("2d"),be=A.createElement("canvas"),a9=be.getContext("2d"),aS=A.createElement("canvas"),a8=aS.getContext("2d");a1=document.getElementById(aT).getContext("2d");a1.save();a1.clearRect(0,0,a1.canvas.width,a1.canvas.height);a1.canvas.width=a5;a1.canvas.height=a4;a3=a5<a4?a5:a4;a0=a3;bc=a3;function bb(bh,bf,bi){var bg=A.createElement("canvas");bg.width=bh;bg.height=bf;bi(bg.getContext("2d"));return bg}var aU=function(bf){var bh,bg=bb(1,1,function(bi){bi.fillStyle=bf;bi.beginPath();bi.rect(0,0,1,1);bi.fill()});bh=bg.getContext("2d").getImageData(0,0,2,2).data;return[bh[0],bh[1],bh[2]]};aZ.width=a0;aZ.height=bc;be.width=a0;be.height=bc;aS.width=a0;aS.height=bc;var ba=function(bf){var bg;bf.save();bf.clearRect(0,0,bf.canvas.width,bf.canvas.height);bf.save();bf.beginPath();bf.moveTo(0.289473*a0,0.438596*bc);bf.bezierCurveTo(0.289473*a0,0.561403*bc,0.385964*a0,0.605263*bc,0.385964*a0,0.745614*bc);bf.bezierCurveTo(0.385964*a0,0.745614*bc,0.587719*a0,0.745614*bc,0.587719*a0,0.745614*bc);bf.bezierCurveTo(0.587719*a0,0.605263*bc,0.692982*a0,0.561403*bc,0.692982*a0,0.438596*bc);bf.bezierCurveTo(0.692982*a0,0.324561*bc,0.605263*a0,0.22807*bc,0.5*a0,0.22807*bc);bf.bezierCurveTo(0.385964*a0,0.22807*bc,0.289473*a0,0.324561*bc,0.289473*a0,0.438596*bc);bf.closePath();bg=bf.createLinearGradient(0,0.289473*bc,0,0.701754*bc);bg.addColorStop(0,"#eeeeee");bg.addColorStop(0.99,"#999999");bg.addColorStop(1,"#999999");bf.fillStyle=bg;bf.fill();bf.lineCap="butt";bf.lineJoin="round";bf.lineWidth=0.008771*a0;bf.strokeStyle="#cccccc";bf.stroke();bf.restore();bf.restore()};var aY=function(bg){var bi,bk=aU(bd),bl=bk[0],bj=bk[1],bf=bk[2],bh=ar(bl,bj,bf);bg.save();bg.clearRect(0,0,bg.canvas.width,bg.canvas.height);bg.save();bg.beginPath();bg.moveTo(0.289473*a0,0.438596*bc);bg.bezierCurveTo(0.289473*a0,0.561403*bc,0.385964*a0,0.605263*bc,0.385964*a0,0.745614*bc);bg.bezierCurveTo(0.385964*a0,0.745614*bc,0.587719*a0,0.745614*bc,0.587719*a0,0.745614*bc);bg.bezierCurveTo(0.587719*a0,0.605263*bc,0.692982*a0,0.561403*bc,0.692982*a0,0.438596*bc);bg.bezierCurveTo(0.692982*a0,0.324561*bc,0.605263*a0,0.22807*bc,0.5*a0,0.22807*bc);bg.bezierCurveTo(0.385964*a0,0.22807*bc,0.289473*a0,0.324561*bc,0.289473*a0,0.438596*bc);bg.closePath();bi=bg.createLinearGradient(0,0.289473*bc,0,0.701754*bc);if(bl===bj&&bj===bf){bi.addColorStop(0,"hsl(0, 60%, 0%)");bi.addColorStop(1,"hsl(0, 40%, 0%)")}else{bi.addColorStop(0,"hsl("+bh[0]*255+", "+bh[1]*100+"%, 70%)");bi.addColorStop(1,"hsl("+bh[0]*255+", "+bh[1]*100+"%, 80%)")}bg.fillStyle=bi;bg.shadowOffsetX=0;bg.shadowOffsetY=0;bg.shadowBlur=30;bg.shadowColor=bd;bg.fill();bg.lineCap="butt";bg.lineJoin="round";bg.lineWidth=0.008771*a0;bg.strokeStyle="rgba("+bl+", "+bj+", "+bf+", 0.4)";bg.stroke();bg.restore();bg.restore()};var aQ=function(bg){var bi,bj,bh,bf;bg.save();bg.clearRect(0,0,bg.canvas.width,bg.canvas.height);bg.save();bg.beginPath();bg.moveTo(0.350877*a0,0.333333*bc);bg.bezierCurveTo(0.350877*a0,0.280701*bc,0.41228*a0,0.236842*bc,0.5*a0,0.236842*bc);bg.bezierCurveTo(0.578947*a0,0.236842*bc,0.64035*a0,0.280701*bc,0.64035*a0,0.333333*bc);bg.bezierCurveTo(0.64035*a0,0.385964*bc,0.578947*a0,0.429824*bc,0.5*a0,0.429824*bc);bg.bezierCurveTo(0.41228*a0,0.429824*bc,0.350877*a0,0.385964*bc,0.350877*a0,0.333333*bc);bg.closePath();bi=bg.createLinearGradient(0,0.245614*bc,0,0.429824*bc);bi.addColorStop(0,"#ffffff");bi.addColorStop(0.99,"rgba(255, 255, 255, 0)");bi.addColorStop(1,"rgba(255, 255, 255, 0)");bg.fillStyle=bi;bg.fill();bg.restore();bg.save();bg.beginPath();bg.moveTo(0.377192*a0,0.745614*bc);bg.bezierCurveTo(0.377192*a0,0.745614*bc,0.429824*a0,0.72807*bc,0.491228*a0,0.72807*bc);bg.bezierCurveTo(0.561403*a0,0.72807*bc,0.605263*a0,0.736842*bc,0.605263*a0,0.736842*bc);bg.lineTo(0.605263*a0,0.763157*bc);bg.lineTo(0.596491*a0,0.780701*bc);bg.lineTo(0.605263*a0,0.798245*bc);bg.lineTo(0.596491*a0,0.815789*bc);bg.lineTo(0.605263*a0,0.833333*bc);bg.lineTo(0.596491*a0,0.850877*bc);bg.lineTo(0.605263*a0,0.868421*bc);bg.lineTo(0.596491*a0,0.885964*bc);bg.lineTo(0.605263*a0,0.894736*bc);bg.bezierCurveTo(0.605263*a0,0.894736*bc,0.570175*a0,0.95614*bc,0.535087*a0,0.991228*bc);bg.bezierCurveTo(0.526315*a0,0.991228*bc,0.517543*a0,bc,0.5*a0,bc);bg.bezierCurveTo(0.482456*a0,bc,0.473684*a0,bc,0.464912*a0,0.991228*bc);bg.bezierCurveTo(0.421052*a0,0.947368*bc,0.394736*a0,0.903508*bc,0.394736*a0,0.903508*bc);bg.lineTo(0.394736*a0,0.894736*bc);bg.lineTo(0.385964*a0,0.885964*bc);bg.lineTo(0.394736*a0,0.868421*bc);bg.lineTo(0.385964*a0,0.850877*bc);bg.lineTo(0.394736*a0,0.833333*bc);bg.lineTo(0.385964*a0,0.815789*bc);bg.lineTo(0.394736*a0,0.798245*bc);bg.lineTo(0.377192*a0,0.789473*bc);bg.lineTo(0.394736*a0,0.771929*bc);bg.lineTo(0.377192*a0,0.763157*bc);bg.lineTo(0.377192*a0,0.745614*bc);bg.closePath();bj=bg.createLinearGradient(0.473684*a0,0.72807*bc,0.484702*a0,0.938307*bc);bj.addColorStop(0,"#333333");bj.addColorStop(0.04,"#d9dad6");bj.addColorStop(0.19,"#e4e5e0");bj.addColorStop(0.24,"#979996");bj.addColorStop(0.31,"#fbffff");bj.addColorStop(0.4,"#818584");bj.addColorStop(0.48,"#f5f7f4");bj.addColorStop(0.56,"#959794");bj.addColorStop(0.64,"#f2f2f0");bj.addColorStop(0.7,"#828783");bj.addColorStop(0.78,"#fcfcfc");bj.addColorStop(1,"#666666");bg.fillStyle=bj;bg.fill();bg.restore();bg.save();bg.beginPath();bg.moveTo(0.377192*a0,0.745614*bc);bg.bezierCurveTo(0.377192*a0,0.745614*bc,0.429824*a0,0.72807*bc,0.491228*a0,0.72807*bc);bg.bezierCurveTo(0.561403*a0,0.72807*bc,0.605263*a0,0.736842*bc,0.605263*a0,0.736842*bc);bg.lineTo(0.605263*a0,0.763157*bc);bg.lineTo(0.596491*a0,0.780701*bc);bg.lineTo(0.605263*a0,0.798245*bc);bg.lineTo(0.596491*a0,0.815789*bc);bg.lineTo(0.605263*a0,0.833333*bc);bg.lineTo(0.596491*a0,0.850877*bc);bg.lineTo(0.605263*a0,0.868421*bc);bg.lineTo(0.596491*a0,0.885964*bc);bg.lineTo(0.605263*a0,0.894736*bc);bg.bezierCurveTo(0.605263*a0,0.894736*bc,0.570175*a0,0.95614*bc,0.535087*a0,0.991228*bc);bg.bezierCurveTo(0.526315*a0,0.991228*bc,0.517543*a0,bc,0.5*a0,bc);bg.bezierCurveTo(0.482456*a0,bc,0.473684*a0,bc,0.464912*a0,0.991228*bc);bg.bezierCurveTo(0.421052*a0,0.947368*bc,0.394736*a0,0.903508*bc,0.394736*a0,0.903508*bc);bg.lineTo(0.394736*a0,0.894736*bc);bg.lineTo(0.385964*a0,0.885964*bc);bg.lineTo(0.394736*a0,0.868421*bc);bg.lineTo(0.385964*a0,0.850877*bc);bg.lineTo(0.394736*a0,0.833333*bc);bg.lineTo(0.385964*a0,0.815789*bc);bg.lineTo(0.394736*a0,0.798245*bc);bg.lineTo(0.377192*a0,0.789473*bc);bg.lineTo(0.394736*a0,0.771929*bc);bg.lineTo(0.377192*a0,0.763157*bc);bg.lineTo(0.377192*a0,0.745614*bc);bg.closePath();bh=bg.createLinearGradient(0.377192*a0,0.789473*bc,0.605263*a0,0.789473*bc);bh.addColorStop(0,"rgba(0, 0, 0, 0.4)");bh.addColorStop(0.15,"rgba(0, 0, 0, 0.32)");bh.addColorStop(0.85,"rgba(0, 0, 0, 0.33)");bh.addColorStop(1,"rgba(0, 0, 0, 0.4)");bg.fillStyle=bh;bg.fill();bg.restore();bg.save();bg.beginPath();bg.moveTo(0.421052*a0,0.947368*bc);bg.bezierCurveTo(0.438596*a0,0.95614*bc,0.447368*a0,0.973684*bc,0.464912*a0,0.991228*bc);bg.bezierCurveTo(0.473684*a0,bc,0.482456*a0,bc,0.5*a0,bc);bg.bezierCurveTo(0.517543*a0,bc,0.526315*a0,0.991228*bc,0.535087*a0,0.991228*bc);bg.bezierCurveTo(0.543859*a0,0.982456*bc,0.561403*a0,0.95614*bc,0.578947*a0,0.947368*bc);bg.bezierCurveTo(0.552631*a0,0.938596*bc,0.526315*a0,0.938596*bc,0.5*a0,0.938596*bc);bg.bezierCurveTo(0.473684*a0,0.938596*bc,0.447368*a0,0.938596*bc,0.421052*a0,0.947368*bc);bg.closePath();bf=bg.createLinearGradient(0,0.938596*bc,0,bc);bf.addColorStop(0,"#050a06");bf.addColorStop(0.61,"#070602");bf.addColorStop(0.71,"#999288");bf.addColorStop(0.83,"#010101");bf.addColorStop(1,"#000000");bg.fillStyle=bf;bg.fill();bg.restore();bg.restore()};var a2=function(bf){bf.save();bf.setTransform(1,0,0,1,0,0);bf.clearRect(0,0,bf.canvas.width,bf.canvas.height);bf.restore()};var a7=function(){aV=true;ba(a6);aY(a9);aQ(a8)};this.setOn=function(bf){aR=bf;this.repaint()};this.isOn=function(){return aR};this.setAlpha=function(bf){aW=bf;this.repaint()};this.getAlpha=function(){return aW};this.setGlowColor=function(bf){bd=bf;a7();this.repaint()};this.getGlowColor=function(){return bd};this.repaint=function(){if(!aV){a7()}a2(a1);a1.save();a1.drawImage(aZ,0,0);a1.globalAlpha=aW;if(aR){a1.drawImage(be,0,0)}a1.globalAlpha=1;a1.drawImage(aS,0,0);a1.restore()};this.repaint();return this};var aB=function(aV,bn){bn=bn||{};var aU=document,a1=(undefined===bn._context?null:bn._context),aS=(undefined===bn.height?40:bn.height),bp=(undefined===bn.digits?6:bn.digits),a7=(undefined===bn.decimals?1:bn.decimals),bc=(undefined===bn.decimalBackColor?"#F0F0F0":bn.decimalBackColor),a2=(undefined===bn.decimalForeColor?"#F01010":bn.decimalForeColor),bo=(undefined===bn.font?"sans-serif":bn.font),bf=(undefined===bn.value?0:bn.value),bh=(undefined===bn.valueBackColor?"#050505":bn.valueBackColor),a8=(undefined===bn.valueForeColor?"#F8F8F8":bn.valueForeColor),be=(undefined===bn.wobbleFactor?0.07:bn.wobbleFactor),aX=false,aZ,a3,aY=false,a0,a6,a9,aQ,a4,aT,bi,ba=[],bd,aR,bk,a5,bj,bl,bg,aW;if(a1){a3=a1}else{a3=aU.getElementById(aV).getContext("2d")}if(bf<0){bf=0}a0=Math.floor(aS*0.85);a9="600 "+a0+"px "+bo;a6=Math.floor(aS*0.68);aQ=a6*(bp+a7);a4=a0*11;aT=a4/12;bi=aT*0.81;a3.canvas.width=aQ;a3.canvas.height=aS;bd=I(aQ,aS);aR=bd.getContext("2d");bk=I(aQ,aS);a5=bk.getContext("2d");bj=I(a6,a4*1.1);bl=bj.getContext("2d");bg=I(a6,a4*1.1);aW=bg.getContext("2d");function bm(){var br,bq;aX=true;a5.rect(0,0,aQ,aS);br=a5.createLinearGradient(0,0,0,aS);br.addColorStop(0,"rgba(0, 0, 0, 1)");br.addColorStop(0.1,"rgba(0, 0, 0, 0.4)");br.addColorStop(0.33,"rgba(255, 255, 255, 0.45)");br.addColorStop(0.46,"rgba(255, 255, 255, 0)");br.addColorStop(0.9,"rgba(0, 0, 0, 0.4)");br.addColorStop(1,"rgba(0, 0, 0, 1)");a5.fillStyle=br;a5.fill();bl.rect(0,0,a6,a4*1.1);bl.fillStyle=bh;bl.fill();bl.strokeStyle="#f0f0f0";bl.lineWidth="1px";bl.moveTo(0,0);bl.lineTo(0,a4*1.1);bl.stroke();bl.strokeStyle="#202020";bl.moveTo(a6,0);bl.lineTo(a6,a4*1.1);bl.stroke();bl.textAlign="center";bl.textBaseline="middle";bl.font=a9;bl.fillStyle=a8;for(bq=9;bq<21;bq++){bl.fillText(bq%10,a6*0.5,aT*(bq-9)+aT/2)}if(a7>0){aW.rect(0,0,a6,a4*1.1);aW.fillStyle=bc;aW.fill();aW.strokeStyle="#f0f0f0";aW.lineWidth="1px";aW.moveTo(0,0);aW.lineTo(0,a4*1.1);aW.stroke();aW.strokeStyle="#202020";aW.moveTo(a6,0);aW.lineTo(a6,a4*1.1);aW.stroke();aW.textAlign="center";aW.textBaseline="middle";aW.font=a9;aW.fillStyle=a2;for(bq=9;bq<21;bq++){aW.fillText(bq%10,a6*0.5,aT*(bq-9)+aT/2)}}for(bq=0;bq<(bp+a7);bq++){ba[bq]=Math.random()*be*aS-be*aS/2}}function bb(){var bw=1,bv=bf,bu,bs,br,bq,bt;for(bu=0;bu<a7;bu++){bv*=10}br=Math.floor(bv);bq=bv-br;br=String(br);bt=9;for(bu=0;bu<a7+bp;bu++){bs=+br.substring(br.length-bu-1,br.length-bu)||0;if(bt!==9){bq=0}if(bu<a7){aR.drawImage(bg,aQ-a6*bw,-(aT*(bs+bq)+bi+ba[bu]))}else{aR.drawImage(bj,aQ-a6*bw,-(aT*(bs+bq)+bi+ba[bu]))}bw++;bt=bs}}this.setValueAnimated=function(bq){var br=this;bq=parseFloat(bq);if(bq<0){bq=0}if(bf!==bq){if(undefined!==aZ){if(aZ.playing){aZ.stop()}}aZ=new Tween({},"",Tween.strongEaseOut,bf,bq,2);aZ.onMotionChanged=function(bs){bf=bs.target._pos;if(!aY){aY=true;ab(br.repaint)}};aZ.start()}this.repaint()};this.setValue=function(bq){bf=bq;if(bf<0){bf=0}this.repaint()};this.getValue=function(){return bf};this.repaint=function(){if(!aX){bm()}bb();aR.drawImage(bk,0,0);a3.drawImage(bd,0,0);aY=false};this.repaint()};var e=function(aZ,aR,aQ,aV,aT,aX){var aY=true,aS,aW,aU=aX.symbolColor.getRgbaColor();aZ.save();aZ.lineWidth=1;aZ.fillStyle=aU;aZ.strokeStyle=aU;aZ.translate(aR,aQ);for(aS=0;aS<360;aS+=15){aY=!aY;aZ.beginPath();aZ.arc(0,0,aV*0.26,aS*l,(aS+15)*l,false);aZ.arc(0,0,aV*0.23,(aS+15)*l,aS*l,true);aZ.closePath();if(aY){aZ.fill()}aZ.stroke()}aZ.translate(-aR,-aQ);for(aS=0;360>=aS;aS+=90){aZ.beginPath();aZ.moveTo(aV*0.560747,aT*0.584112);aZ.lineTo(aV*0.640186,aT*0.644859);aZ.lineTo(aV*0.584112,aT*0.560747);aZ.lineTo(aV*0.560747,aT*0.584112);aZ.closePath();aZ.fillStyle=aU;aZ.fill();aZ.stroke();aZ.beginPath();aZ.moveTo(aV*0.523364,aT*0.397196);aZ.lineTo(aV*0.5,aT*0.196261);aZ.lineTo(aV*0.471962,aT*0.397196);aZ.lineTo(aV*0.523364,aT*0.397196);aZ.closePath();aW=aZ.createLinearGradient(0.476635*aV,0,0.518691*aV,0);aW.addColorStop(0,"rgb(222, 223, 218)");aW.addColorStop(0.48,"rgb(222, 223, 218)");aW.addColorStop(0.49,aU);aW.addColorStop(1,aU);aZ.fillStyle=aW;aZ.fill();aZ.stroke();aZ.translate(aR,aQ);aZ.rotate(aS*l);aZ.translate(-aR,-aQ)}aZ.beginPath();aZ.translate(aR,aQ);aZ.arc(0,0,aV*0.1,0,G,false);aZ.lineWidth=aV*0.022;aZ.stroke();aZ.translate(-aR,-aQ);aZ.restore()};var D=function(aX,aZ,aQ,aW,aY){var aV,aR,aU,aS,aT=aZ.toString()+aQ.type+aW.light.getHexColor()+aW.medium.getHexColor();if(!D.cache[aT]){aV=I(aZ,aZ);aR=aV.getContext("2d");switch(aQ.type){case"type2":aU=aR.createLinearGradient(0,aZ*0.471962,0,aZ*0.130841);aU.addColorStop(0,aY.getRgbaColor());aU.addColorStop(0.36,aY.getRgbaColor());aU.addColorStop(0.361,aW.light.getRgbaColor());aU.addColorStop(1,aW.light.getRgbaColor());aR.fillStyle=aU;aR.beginPath();aR.moveTo(aZ*0.518691,aZ*0.471962);aR.lineTo(aZ*0.509345,aZ*0.462616);aR.lineTo(aZ*0.509345,aZ*0.341121);aR.lineTo(aZ*0.504672,aZ*0.130841);aR.lineTo(aZ*0.495327,aZ*0.130841);aR.lineTo(aZ*0.490654,aZ*0.341121);aR.lineTo(aZ*0.490654,aZ*0.462616);aR.lineTo(aZ*0.481308,aZ*0.471962);aR.closePath();aR.fill();break;case"type3":aR.beginPath();aR.rect(aZ*0.495327,aZ*0.130841,aZ*0.009345,aZ*0.373831);aR.closePath();aR.fillStyle=aW.light.getRgbaColor();aR.fill();break;case"type4":aU=aR.createLinearGradient(0.467289*aZ,0,0.528036*aZ,0);aU.addColorStop(0,aW.dark.getRgbaColor());aU.addColorStop(0.51,aW.dark.getRgbaColor());aU.addColorStop(0.52,aW.light.getRgbaColor());aU.addColorStop(1,aW.light.getRgbaColor());aR.fillStyle=aU;aR.beginPath();aR.moveTo(aZ*0.5,aZ*0.126168);aR.lineTo(aZ*0.514018,aZ*0.135514);aR.lineTo(aZ*0.53271,aZ*0.5);aR.lineTo(aZ*0.523364,aZ*0.602803);aR.lineTo(aZ*0.476635,aZ*0.602803);aR.lineTo(aZ*0.467289,aZ*0.5);aR.lineTo(aZ*0.485981,aZ*0.135514);aR.lineTo(aZ*0.5,aZ*0.126168);aR.closePath();aR.fill();break;case"type5":aU=aR.createLinearGradient(0.471962*aZ,0,0.528036*aZ,0);aU.addColorStop(0,aW.light.getRgbaColor());aU.addColorStop(0.5,aW.light.getRgbaColor());aU.addColorStop(0.5,aW.medium.getRgbaColor());aU.addColorStop(1,aW.medium.getRgbaColor());aR.fillStyle=aU;aR.beginPath();aR.moveTo(aZ*0.5,aZ*0.495327);aR.lineTo(aZ*0.528037,aZ*0.495327);aR.lineTo(aZ*0.5,aZ*0.149532);aR.lineTo(aZ*0.471962,aZ*0.495327);aR.lineTo(aZ*0.5,aZ*0.495327);aR.closePath();aR.fill();aR.lineWidth=1;aR.lineCap="square";aR.lineJoin="miter";aR.strokeStyle=aW.dark.getRgbaColor();aR.stroke();break;case"type6":aR.fillStyle=aW.medium.getRgbaColor();aR.beginPath();aR.moveTo(aZ*0.481308,aZ*0.485981);aR.lineTo(aZ*0.481308,aZ*0.392523);aR.lineTo(aZ*0.485981,aZ*0.317757);aR.lineTo(aZ*0.495327,aZ*0.130841);aR.lineTo(aZ*0.504672,aZ*0.130841);aR.lineTo(aZ*0.514018,aZ*0.317757);aR.lineTo(aZ*0.518691,aZ*0.38785);aR.lineTo(aZ*0.518691,aZ*0.485981);aR.lineTo(aZ*0.504672,aZ*0.485981);aR.lineTo(aZ*0.504672,aZ*0.38785);aR.lineTo(aZ*0.5,aZ*0.317757);aR.lineTo(aZ*0.495327,aZ*0.392523);aR.lineTo(aZ*0.495327,aZ*0.485981);aR.lineTo(aZ*0.481308,aZ*0.485981);aR.closePath();aR.fill();break;case"type7":aU=aR.createLinearGradient(0.481308*aZ,0,0.518691*aZ,0);aU.addColorStop(0,aW.dark.getRgbaColor());aU.addColorStop(1,aW.medium.getRgbaColor());aR.fillStyle=aU;aR.beginPath();aR.moveTo(aZ*0.490654,aZ*0.130841);aR.lineTo(aZ*0.481308,aZ*0.5);aR.lineTo(aZ*0.518691,aZ*0.5);aR.lineTo(aZ*0.504672,aZ*0.130841);aR.lineTo(aZ*0.490654,aZ*0.130841);aR.closePath();aR.fill();break;case"type8":aU=aR.createLinearGradient(0.471962*aZ,0,0.528036*aZ,0);aU.addColorStop(0,aW.light.getRgbaColor());aU.addColorStop(0.5,aW.light.getRgbaColor());aU.addColorStop(0.5,aW.medium.getRgbaColor());aU.addColorStop(1,aW.medium.getRgbaColor());aR.fillStyle=aU;aR.strokeStyle=aW.dark.getRgbaColor();aR.beginPath();aR.moveTo(aZ*0.5,aZ*0.53271);aR.lineTo(aZ*0.53271,aZ*0.5);aR.bezierCurveTo(aZ*0.53271,aZ*0.5,aZ*0.509345,aZ*0.457943,aZ*0.5,aZ*0.149532);aR.bezierCurveTo(aZ*0.490654,aZ*0.457943,aZ*0.467289,aZ*0.5,aZ*0.467289,aZ*0.5);aR.lineTo(aZ*0.5,aZ*0.53271);aR.closePath();aR.fill();aR.stroke();break;case"type9":aU=aR.createLinearGradient(0.471962*aZ,0,0.528036*aZ,0);aU.addColorStop(0,"rgb(50, 50, 50)");aU.addColorStop(0.5,"#666666");aU.addColorStop(1,"rgb(50, 50, 50)");aR.fillStyle=aU;aR.strokeStyle="#2E2E2E";aR.beginPath();aR.moveTo(aZ*0.495327,aZ*0.233644);aR.lineTo(aZ*0.504672,aZ*0.233644);aR.lineTo(aZ*0.514018,aZ*0.439252);aR.lineTo(aZ*0.485981,aZ*0.439252);aR.lineTo(aZ*0.495327,aZ*0.233644);aR.closePath();aR.moveTo(aZ*0.490654,aZ*0.130841);aR.lineTo(aZ*0.471962,aZ*0.471962);aR.lineTo(aZ*0.471962,aZ*0.528037);aR.bezierCurveTo(aZ*0.471962,aZ*0.528037,aZ*0.476635,aZ*0.602803,aZ*0.476635,aZ*0.602803);aR.bezierCurveTo(aZ*0.476635,aZ*0.607476,aZ*0.481308,aZ*0.607476,aZ*0.5,aZ*0.607476);aR.bezierCurveTo(aZ*0.518691,aZ*0.607476,aZ*0.523364,aZ*0.607476,aZ*0.523364,aZ*0.602803);aR.bezierCurveTo(aZ*0.523364,aZ*0.602803,aZ*0.528037,aZ*0.528037,aZ*0.528037,aZ*0.528037);aR.lineTo(aZ*0.528037,aZ*0.471962);aR.lineTo(aZ*0.509345,aZ*0.130841);aR.lineTo(aZ*0.490654,aZ*0.130841);aR.closePath();aR.fill();aR.beginPath();aR.moveTo(aZ*0.495327,aZ*0.219626);aR.lineTo(aZ*0.504672,aZ*0.219626);aR.lineTo(aZ*0.504672,aZ*0.135514);aR.lineTo(aZ*0.495327,aZ*0.135514);aR.lineTo(aZ*0.495327,aZ*0.219626);aR.closePath();aR.fillStyle=aW.medium.getRgbaColor();aR.fill();break;case"type10":aR.beginPath();aR.moveTo(aZ*0.5,aZ*0.149532);aR.bezierCurveTo(aZ*0.5,aZ*0.149532,aZ*0.443925,aZ*0.490654,aZ*0.443925,aZ*0.5);aR.bezierCurveTo(aZ*0.443925,aZ*0.53271,aZ*0.467289,aZ*0.556074,aZ*0.5,aZ*0.556074);aR.bezierCurveTo(aZ*0.53271,aZ*0.556074,aZ*0.556074,aZ*0.53271,aZ*0.556074,aZ*0.5);aR.bezierCurveTo(aZ*0.556074,aZ*0.490654,aZ*0.5,aZ*0.149532,aZ*0.5,aZ*0.149532);aR.closePath();aU=aR.createLinearGradient(0.471962*aZ,0,0.528036*aZ,0);aU.addColorStop(0,aW.light.getRgbaColor());aU.addColorStop(0.5,aW.light.getRgbaColor());aU.addColorStop(0.5,aW.medium.getRgbaColor());aU.addColorStop(1,aW.medium.getRgbaColor());aR.fillStyle=aU;aR.strokeStyle=aW.medium.getRgbaColor();aR.lineWidth=1;aR.lineCap="square";aR.lineJoin="miter";aR.fill();aR.stroke();break;case"type11":aR.beginPath();aR.moveTo(0.5*aZ,0.168224*aZ);aR.lineTo(0.485981*aZ,0.5*aZ);aR.bezierCurveTo(0.485981*aZ,0.5*aZ,0.481308*aZ,0.584112*aZ,0.5*aZ,0.584112*aZ);aR.bezierCurveTo(0.514018*aZ,0.584112*aZ,0.509345*aZ,0.5*aZ,0.509345*aZ,0.5*aZ);aR.lineTo(0.5*aZ,0.168224*aZ);aR.closePath();aU=aR.createLinearGradient(0,0.168224*aZ,0,0.584112*aZ);aU.addColorStop(0,aW.medium.getRgbaColor());aU.addColorStop(1,aW.dark.getRgbaColor());aR.fillStyle=aU;aR.strokeStyle=aW.dark.getRgbaColor();aR.fill();aR.stroke();break;case"type12":aR.beginPath();aR.moveTo(0.5*aZ,0.168224*aZ);aR.lineTo(0.485981*aZ,0.5*aZ);aR.lineTo(0.5*aZ,0.504672*aZ);aR.lineTo(0.509345*aZ,0.5*aZ);aR.lineTo(0.5*aZ,0.168224*aZ);aR.closePath();aU=aR.createLinearGradient(0,0.168224*aZ,0,0.504672*aZ);aU.addColorStop(0,aW.medium.getRgbaColor());aU.addColorStop(1,aW.dark.getRgbaColor());aR.fillStyle=aU;aR.strokeStyle=aW.dark.getRgbaColor();aR.fill();aR.stroke();break;case"type13":case"type14":aR.beginPath();aR.moveTo(0.485981*aZ,0.168224*aZ);aR.lineTo(0.5*aZ,0.130841*aZ);aR.lineTo(0.509345*aZ,0.168224*aZ);aR.lineTo(0.509345*aZ,0.509345*aZ);aR.lineTo(0.485981*aZ,0.509345*aZ);aR.lineTo(0.485981*aZ,0.168224*aZ);aR.closePath();if(aQ.type==="type13"){aU=aR.createLinearGradient(0,0.5*aZ,0,0.130841*aZ);aU.addColorStop(0,aY.getRgbaColor());aU.addColorStop(0.85,aY.getRgbaColor());aU.addColorStop(0.85,aW.medium.getRgbaColor());aU.addColorStop(1,aW.medium.getRgbaColor());aR.fillStyle=aU}else{aU=aR.createLinearGradient(0.485981*aZ,0,0.509345*aZ,0);aU.addColorStop(0,aW.veryDark.getRgbaColor());aU.addColorStop(0.5,aW.light.getRgbaColor());aU.addColorStop(1,aW.veryDark.getRgbaColor());aR.fillStyle=aU}aR.fill();break;case"type15":case"type16":aR.beginPath();aR.moveTo(aZ*0.509345,aZ*0.457943);aR.lineTo(aZ*0.5015,aZ*0.13);aR.lineTo(aZ*0.4985,aZ*0.13);aR.lineTo(aZ*0.490654,aZ*0.457943);aR.bezierCurveTo(aZ*0.490654,aZ*0.457943,aZ*0.490654,aZ*0.457943,aZ*0.490654,aZ*0.457943);aR.bezierCurveTo(aZ*0.471962,aZ*0.462616,aZ*0.457943,aZ*0.481308,aZ*0.457943,aZ*0.5);aR.bezierCurveTo(aZ*0.457943,aZ*0.518691,aZ*0.471962,aZ*0.537383,aZ*0.490654,aZ*0.542056);aR.bezierCurveTo(aZ*0.490654,aZ*0.542056,aZ*0.490654,aZ*0.542056,aZ*0.490654,aZ*0.542056);if(aQ.type==="type15"){aR.lineTo(aZ*0.490654,aZ*0.57);aR.bezierCurveTo(aZ*0.46,aZ*0.58,aZ*0.46,aZ*0.62,aZ*0.490654,aZ*0.63);aR.bezierCurveTo(aZ*0.47,aZ*0.62,aZ*0.48,aZ*0.59,aZ*0.5,aZ*0.59);aR.bezierCurveTo(aZ*0.53,aZ*0.59,aZ*0.52,aZ*0.62,aZ*0.509345,aZ*0.63);aR.bezierCurveTo(aZ*0.54,aZ*0.62,aZ*0.54,aZ*0.58,aZ*0.509345,aZ*0.57);aR.lineTo(aZ*0.509345,aZ*0.57)}else{aR.lineTo(aZ*0.490654,aZ*0.621495);aR.lineTo(aZ*0.509345,aZ*0.621495)}aR.lineTo(aZ*0.509345,aZ*0.542056);aR.bezierCurveTo(aZ*0.509345,aZ*0.542056,aZ*0.509345,aZ*0.542056,aZ*0.509345,aZ*0.542056);aR.bezierCurveTo(aZ*0.528037,aZ*0.537383,aZ*0.542056,aZ*0.518691,aZ*0.542056,aZ*0.5);aR.bezierCurveTo(aZ*0.542056,aZ*0.481308,aZ*0.528037,aZ*0.462616,aZ*0.509345,aZ*0.457943);aR.bezierCurveTo(aZ*0.509345,aZ*0.457943,aZ*0.509345,aZ*0.457943,aZ*0.509345,aZ*0.457943);aR.closePath();if(aQ.type==="type15"){aU=aR.createLinearGradient(0,0,0,aZ*0.63)}else{aU=aR.createLinearGradient(0,0,0,aZ*0.621495)}aU.addColorStop(0,aW.medium.getRgbaColor());aU.addColorStop(0.388888,aW.medium.getRgbaColor());aU.addColorStop(0.5,aW.light.getRgbaColor());aU.addColorStop(0.611111,aW.medium.getRgbaColor());aU.addColorStop(1,aW.medium.getRgbaColor());aR.fillStyle=aU;aR.strokeStyle=aW.dark.getRgbaColor();aR.fill();aR.stroke();aR.beginPath();aS=aZ*0.06542/2;aR.arc(aZ*0.5,aZ*0.5,aS,0,G);aU=aR.createLinearGradient(aZ*0.5-aS,aZ*0.5+aS,0,aZ*0.5+aS);aU.addColorStop(0,"#e6b35c");aU.addColorStop(0.01,"#e6b35c");aU.addColorStop(0.99,"#c48200");aU.addColorStop(1,"#c48200");aR.fillStyle=aU;aR.closePath();aR.fill();aR.beginPath();aS=aZ*0.046728/2;aR.arc(aZ*0.5,aZ*0.5,aS,0,G);aU=aR.createRadialGradient(aZ*0.5,aZ*0.5,0,aZ*0.5,aZ*0.5,aS);aU.addColorStop(0,"#c5c5c5");aU.addColorStop(0.19,"#c5c5c5");aU.addColorStop(0.22,"#000000");aU.addColorStop(0.8,"#000000");aU.addColorStop(0.99,"#707070");aU.addColorStop(1,"#707070");aR.fillStyle=aU;aR.closePath();aR.fill();break;case"type1":default:aU=aR.createLinearGradient(0,aZ*0.471962,0,aZ*0.130841);aU.addColorStop(0,aW.veryDark.getRgbaColor());aU.addColorStop(0.3,aW.medium.getRgbaColor());aU.addColorStop(0.59,aW.medium.getRgbaColor());aU.addColorStop(1,aW.veryDark.getRgbaColor());aR.fillStyle=aU;aR.beginPath();aR.moveTo(aZ*0.518691,aZ*0.471962);aR.bezierCurveTo(aZ*0.514018,aZ*0.457943,aZ*0.509345,aZ*0.415887,aZ*0.509345,aZ*0.401869);aR.bezierCurveTo(aZ*0.504672,aZ*0.383177,aZ*0.5,aZ*0.130841,aZ*0.5,aZ*0.130841);aR.bezierCurveTo(aZ*0.5,aZ*0.130841,aZ*0.490654,aZ*0.383177,aZ*0.490654,aZ*0.397196);aR.bezierCurveTo(aZ*0.490654,aZ*0.415887,aZ*0.485981,aZ*0.457943,aZ*0.481308,aZ*0.471962);aR.bezierCurveTo(aZ*0.471962,aZ*0.481308,aZ*0.467289,aZ*0.490654,aZ*0.467289,aZ*0.5);aR.bezierCurveTo(aZ*0.467289,aZ*0.518691,aZ*0.481308,aZ*0.53271,aZ*0.5,aZ*0.53271);aR.bezierCurveTo(aZ*0.518691,aZ*0.53271,aZ*0.53271,aZ*0.518691,aZ*0.53271,aZ*0.5);aR.bezierCurveTo(aZ*0.53271,aZ*0.490654,aZ*0.528037,aZ*0.481308,aZ*0.518691,aZ*0.471962);aR.closePath();aR.fill();break}D.cache[aT]=aV}aX.drawImage(D.cache[aT],0,0);return this};D.cache={};var d=function(a3,aX,aV,aU,a1,aY){var aT,a0,a2,aR,aW,aS,aQ,aZ=a1.toString()+aY+aX.design;if(!d.cache[aZ]){aT=I(a1,aY);a0=aT.getContext("2d");a0.fillStyle="#848484";a0.strokeStyle="rgba(132, 132, 132, 0.5)";a0.beginPath();a0.arc(aV,aU,a1/2,0,G,true);a0.closePath();a0.fill();a0.stroke();a0.beginPath();a0.arc(aV,aU,a1*0.990654/2,0,G,true);a0.closePath();switch(aX.design){case"metal":a2=a0.createLinearGradient(0,a1*0.004672,0,aY*0.990654);a2.addColorStop(0,"#fefefe");a2.addColorStop(0.07,"rgb(210, 210, 210)");a2.addColorStop(0.12,"rgb(179, 179, 179)");a2.addColorStop(1,"rgb(213, 213, 213)");a0.fillStyle=a2;a0.fill();break;case"brass":a2=a0.createLinearGradient(0,a1*0.004672,0,aY*0.990654);a2.addColorStop(0,"rgb(249, 243, 155)");a2.addColorStop(0.05,"rgb(246, 226, 101)");a2.addColorStop(0.1,"rgb(240, 225, 132)");a2.addColorStop(0.5,"rgb(90, 57, 22)");a2.addColorStop(0.9,"rgb(249, 237, 139)");a2.addColorStop(0.95,"rgb(243, 226, 108)");a2.addColorStop(1,"rgb(202, 182, 113)");a0.fillStyle=a2;a0.fill();break;case"steel":a2=a0.createLinearGradient(0,a1*0.004672,0,aY*0.990654);a2.addColorStop(0,"rgb(231, 237, 237)");a2.addColorStop(0.05,"rgb(189, 199, 198)");a2.addColorStop(0.1,"rgb(192, 201, 200)");a2.addColorStop(0.5,"rgb(23, 31, 33)");a2.addColorStop(0.9,"rgb(196, 205, 204)");a2.addColorStop(0.95,"rgb(194, 204, 203)");a2.addColorStop(1,"rgb(189, 201, 199)");a0.fillStyle=a2;a0.fill();break;case"gold":a2=a0.createLinearGradient(0,a1*0.004672,0,aY*0.990654);a2.addColorStop(0,"rgb(255, 255, 207)");a2.addColorStop(0.15,"rgb(255, 237, 96)");a2.addColorStop(0.22,"rgb(254, 199, 57)");a2.addColorStop(0.3,"rgb(255, 249, 203)");a2.addColorStop(0.38,"rgb(255, 199, 64)");a2.addColorStop(0.44,"rgb(252, 194, 60)");a2.addColorStop(0.51,"rgb(255, 204, 59)");a2.addColorStop(0.6,"rgb(213, 134, 29)");a2.addColorStop(0.68,"rgb(255, 201, 56)");a2.addColorStop(0.75,"rgb(212, 135, 29)");a2.addColorStop(1,"rgb(247, 238, 101)");a0.fillStyle=a2;a0.fill();break;case"anthracite":a2=a0.createLinearGradient(0,0.004672*aY,0,0.995326*aY);a2.addColorStop(0,"rgb(118, 117, 135)");a2.addColorStop(0.06,"rgb(74, 74, 82)");a2.addColorStop(0.12,"rgb(50, 50, 54)");a2.addColorStop(1,"rgb(79, 79, 87)");a0.fillStyle=a2;a0.fill();break;case"tiltedGray":a2=a0.createLinearGradient(0.233644*a1,0.084112*aY,0.81258*a1,0.910919*aY);a2.addColorStop(0,"#ffffff");a2.addColorStop(0.07,"rgb(210, 210, 210)");a2.addColorStop(0.16,"rgb(179, 179, 179)");a2.addColorStop(0.33,"#ffffff");a2.addColorStop(0.55,"#c5c5c5");a2.addColorStop(0.79,"#ffffff");a2.addColorStop(1,"#666666");a0.fillStyle=a2;a0.fill();break;case"tiltedBlack":a2=a0.createLinearGradient(0.228971*a1,0.079439*aY,0.802547*a1,0.898591*aY);a2.addColorStop(0,"#666666");a2.addColorStop(0.21,"#000000");a2.addColorStop(0.47,"#666666");a2.addColorStop(0.99,"#000000");a2.addColorStop(1,"#000000");a0.fillStyle=a2;a0.fill();break;case"glossyMetal":a2=a0.createRadialGradient(0.5*a1,0.5*aY,0,0.5*a1,0.5*a1,0.5*a1);a2.addColorStop(0,"rgb(207, 207, 207)");a2.addColorStop(0.96,"rgb(205, 204, 205)");a2.addColorStop(1,"rgb(244, 244, 244)");a0.fillStyle=a2;a0.fill();a0.beginPath();a0.arc(0.5*a1,0.5*aY,0.973962*a1/2,0,G);a0.closePath();a2=a0.createLinearGradient(0,aY-0.971962*aY,0,0.971962*aY);a2.addColorStop(0,"rgb(249, 249, 249)");a2.addColorStop(0.23,"rgb(200, 195, 191)");a2.addColorStop(0.36,"#ffffff");a2.addColorStop(0.59,"rgb(29, 29, 29)");a2.addColorStop(0.76,"rgb(200, 194, 192)");a2.addColorStop(1,"rgb(209, 209, 209)");a0.fillStyle=a2;a0.fill();a0.beginPath();a0.arc(0.5*a1,0.5*aY,0.869158*a1/2,0,G);a0.closePath();a0.fillStyle="#f6f6f6";a0.fill();a0.beginPath();a0.arc(0.5*a1,0.5*aY,0.85*a1/2,0,G);a0.closePath();a0.fillStyle="#333333";a0.fill();break;case"blackMetal":aS=[0,0.125,0.347222,0.5,0.680555,0.875,1];aQ=[new J(254,254,254,1),new J(0,0,0,1),new J(153,153,153,1),new J(0,0,0,1),new J(153,153,153,1),new J(0,0,0,1),new J(254,254,254,1)];a0.save();a0.clip(a0.arc(aV,aU,a1*0.990654/2,0,G,true));aR=a1*0.495327;aW=a1*0.42056;a2=new F(aS,aQ);a2.fillCircle(a0,aV,aU,aW,aR);a0.strokeStyle="#848484";a0.strokeStyle="rgba(132, 132, 132, 0.8)";a0.beginPath();a0.lineWidth=a1/90;a0.arc(aV,aU,a1/2,0,G,true);a0.closePath();a0.stroke();a0.restore();break;case"shinyMetal":aS=[0,0.125,0.25,0.347222,0.5,0.652777,0.75,0.875,1];aQ=[new J(254,254,254,1),new J(210,210,210,1),new J(179,179,179,1),new J(238,238,238,1),new J(160,160,160,1),new J(238,238,238,1),new J(179,179,179,1),new J(210,210,210,1),new J(254,254,254,1)];a0.save();a0.clip(a0.arc(aV,aU,a1*0.990654/2,0,G,true));aR=a1*0.495327;aW=a1*0.42056;a2=new F(aS,aQ);a2.fillCircle(a0,aV,aU,aW,aR);a0.strokeStyle="#848484";a0.strokeStyle="rgba(132, 132, 132, 0.8)";a0.beginPath();a0.lineWidth=a1/90;a0.arc(aV,aU,a1/2,0,G,true);a0.closePath();a0.stroke();a0.restore();break;case"chrome":aS=[0,0.09,0.12,0.16,0.25,0.29,0.33,0.38,0.48,0.52,0.63,0.68,0.8,0.83,0.87,0.97,1];aQ=[new J(255,255,255,1),new J(255,255,255,1),new J(136,136,138,1),new J(164,185,190,1),new J(158,179,182,1),new J(112,112,112,1),new J(221,227,227,1),new J(155,176,179,1),new J(156,176,177,1),new J(254,255,255,1),new J(255,255,255,1),new J(156,180,180,1),new J(198,209,211,1),new J(246,248,247,1),new J(204,216,216,1),new J(164,188,190,1),new J(255,255,255,1)];a0.save();a0.clip(a0.arc(aV,aU,a1*0.990654/2,0,G,true));aR=a1*0.495327;aW=a1*0.42056;a2=new F(aS,aQ);a2.fillCircle(a0,aV,aU,aW,aR);a0.strokeStyle="#848484";a0.strokeStyle="rgba(132, 132, 132, 0.8)";a0.beginPath();a0.lineWidth=a1/90;a0.arc(aV,aU,a1/2,0,G,true);a0.closePath();a0.stroke();a0.restore();break}a0.fillStyle="rgb(191, 191, 191)";a0.beginPath();a0.arc(aV,aU,a1*0.841121/2,0,G,true);a0.closePath();a0.fill();a0.globalCompositeOperation="destination-out";a0.beginPath();a0.arc(aV,aU,a1*0.83/2,0,G,true);a0.closePath();a0.fill();d.cache[aZ]=aT}a3.drawImage(d.cache[aZ],0,0);return this};d.cache={};var k=function(a4,aW,aZ,aX,aT){var a0,aU,aR,aV,a2,a3,a1,aS=[],aQ=[],aY=aZ.toString()+aX+aW.design+aT;if(!k.cache[aY]){a0=Math.sqrt(aZ*aZ+aX*aX)*0.04;a0=Math.min(a0,(aT?aZ:aX)*0.1);aU=I(aZ,aX);aR=aU.getContext("2d");if(aT){aV=aZ*0.05;a2=aV-1;a3=aZ*0.028571}else{aV=aX*0.05;a2=aV-1;a3=aX*0.028571}O(aR,0,0,aZ,aX,aV);aR.fillStyle="#838383";aR.fill();O(aR,1,1,aZ-2,aX-2,a2);switch(aW.design){case"metal":a1=aR.createLinearGradient(0,aZ*0.004672,0,aX*0.990654);a1.addColorStop(0,"#fefefe");a1.addColorStop(0.07,"rgb(210, 210, 210)");a1.addColorStop(0.12,"rgb(179, 179, 179)");a1.addColorStop(1,"rgb(213, 213, 213)");aR.fillStyle=a1;aR.fill();break;case"brass":a1=aR.createLinearGradient(0,aZ*0.004672,0,aX*0.990654);a1.addColorStop(0,"rgb(249, 243, 155)");a1.addColorStop(0.05,"rgb(246, 226, 101)");a1.addColorStop(0.1,"rgb(240, 225, 132)");a1.addColorStop(0.5,"rgb(90, 57, 22)");a1.addColorStop(0.9,"rgb(249, 237, 139)");a1.addColorStop(0.95,"rgb(243, 226, 108)");a1.addColorStop(1,"rgb(202, 182, 113)");aR.fillStyle=a1;aR.fill();break;case"steel":a1=aR.createLinearGradient(0,aZ*0.004672,0,aX*0.990654);a1.addColorStop(0,"rgb(231, 237, 237)");a1.addColorStop(0.05,"rgb(189, 199, 198)");a1.addColorStop(0.1,"rgb(192, 201, 200)");a1.addColorStop(0.5,"rgb(23, 31, 33)");a1.addColorStop(0.9,"rgb(196, 205, 204)");a1.addColorStop(0.95,"rgb(194, 204, 203)");a1.addColorStop(1,"rgb(189, 201, 199)");aR.fillStyle=a1;aR.fill();break;case"gold":a1=aR.createLinearGradient(0,aZ*0.004672,0,aX*0.990654);a1.addColorStop(0,"rgb(255, 255, 207)");a1.addColorStop(0.15,"rgb(255, 237, 96)");a1.addColorStop(0.22,"rgb(254, 199, 57)");a1.addColorStop(0.3,"rgb(255, 249, 203)");a1.addColorStop(0.38,"rgb(255, 199, 64)");a1.addColorStop(0.44,"rgb(252, 194, 60)");a1.addColorStop(0.51,"rgb(255, 204, 59)");a1.addColorStop(0.6,"rgb(213, 134, 29)");a1.addColorStop(0.68,"rgb(255, 201, 56)");a1.addColorStop(0.75,"rgb(212, 135, 29)");a1.addColorStop(1,"rgb(247, 238, 101)");aR.fillStyle=a1;aR.fill();break;case"anthracite":a1=aR.createLinearGradient(0,0.004672*aX,0,0.995326*aX);a1.addColorStop(0,"rgb(118, 117, 135)");a1.addColorStop(0.06,"rgb(74, 74, 82)");a1.addColorStop(0.12,"rgb(50, 50, 54)");a1.addColorStop(1,"rgb(79, 79, 87)");aR.fillStyle=a1;aR.fill();break;case"tiltedGray":a1=aR.createLinearGradient(0.233644*aZ,0.084112*aX,0.81258*aZ,0.910919*aX);a1.addColorStop(0,"#ffffff");a1.addColorStop(0.07,"rgb(210, 210, 210)");a1.addColorStop(0.16,"rgb(179, 179, 179)");a1.addColorStop(0.33,"#ffffff");a1.addColorStop(0.55,"#c5c5c5");a1.addColorStop(0.79,"#ffffff");a1.addColorStop(1,"#666666");aR.fillStyle=a1;aR.fill();break;case"tiltedBlack":a1=aR.createLinearGradient(0.228971*aZ,0.079439*aX,0.802547*aZ,0.898591*aX);a1.addColorStop(0,"#666666");a1.addColorStop(0.21,"#000000");a1.addColorStop(0.47,"#666666");a1.addColorStop(0.99,"#000000");a1.addColorStop(1,"#000000");aR.fillStyle=a1;aR.fill();break;case"glossyMetal":aR.clip(O(aR,1,1,aZ-2,aX-2,aV));a1=aR.createLinearGradient(0,1,0,aX-2);a1.addColorStop(0,"rgb(249, 249, 249)");a1.addColorStop(0.2,"rgb(200, 195, 191)");a1.addColorStop(0.3,"#ffffff");a1.addColorStop(0.6,"rgb(29, 29, 29)");a1.addColorStop(0.8,"rgb(200, 194, 192)");a1.addColorStop(1,"rgb(209, 209, 209)");aR.fillStyle=a1;aR.fill();aR.clip(O(aR,a0-2,a0-2,aZ-(a0-2)*2,aX-(a0-2)*2,a3));aR.fillStyle="#f6f6f6";aR.fill();aR.clip(O(aR,a0-1,a0-1,aZ-(a0-1)*2,aX-(a0-1)*2,a3));aR.fillStyle="#333333";aR.fill();break;case"blackMetal":aS=[0,0.125,0.347222,0.5,0.680555,0.875,1];aQ=[new J("#FFFFFF"),new J("#000000"),new J("#999999"),new J("#000000"),new J("#999999"),new J("#000000"),new J("#FFFFFF")];aR.beginPath();O(aR,1,1,aZ-2,aX-2,aV);aR.closePath();aR.clip();a1=new F(aS,aQ);a1.fillRect(aR,aZ/2,aX/2,aZ,aX,a0,a0);break;case"shinyMetal":aS=[0,0.125,0.25,0.347222,0.5,0.652777,0.75,0.875,1];aQ=[new J("#FFFFFF"),new J("#D2D2D2"),new J("#B3B3B3"),new J("#EEEEEE"),new J("#A0A0A0"),new J("#EEEEEE"),new J("#B3B3B3"),new J("#D2D2D2"),new J("#FFFFFF")];aR.beginPath();O(aR,1,1,aZ-2,aX-2,aV);aR.closePath();aR.clip();a1=new F(aS,aQ);a1.fillRect(aR,aZ/2,aX/2,aZ,aX,a0,a0);break;case"chrome":aS=[0,0.09,0.12,0.16,0.25,0.29,0.33,0.38,0.48,0.52,0.63,0.68,0.8,0.83,0.87,0.97,1];aQ=[new J("#FFFFFF"),new J("#FFFFFF"),new J("#888890"),new J("#A4B9BE"),new J("#9EB3B6"),new J("#707070"),new J("#DDE3E3"),new J("#9BB0B3"),new J("#9CB0B1"),new J("#FEFFFF"),new J("#FFFFFF"),new J("#9CB4B4"),new J("#C6D1D3"),new J("#F6F8F7"),new J("#CCD8D8"),new J("#A4BCBE"),new J("#FFFFFF")];aR.beginPath();O(aR,1,1,aZ-2,aX-2,aV);aR.closePath();aR.clip();a1=new F(aS,aQ);a1.fillRect(aR,aZ/2,aX/2,aZ,aX,a0,a0);break}O(aR,a0-1,a0-1,aZ-(a0-1)*2,aX-(a0-1)*2,a3-1);aR.fillStyle="rgb(192, 192, 192)";aR.globalCompositeOperation="destination-out";O(aR,a0,a0,aZ-a0*2,aX-a0*2,4);aR.fill();k.cache[aY]=aU}a4.drawImage(k.cache[aY],0,0);return this};k.cache={};var aO=function(a5,aV,aZ,aY,a0,a9){var aR,a2,aX,ba,a1,a7=a0*0.831775/2,a6,aQ,a3,aT,a4,aU,aS,a8,aW=a0.toString()+a9+aV.name;if(!aO.cache[aW]){aR=I(a0,a9);a2=aR.getContext("2d");a2.beginPath();a2.arc(aZ,aY,a7,0,G,true);a2.closePath();if(aV.name==="CARBON"||aV.name==="PUNCHED_SHEET"||aV.name==="BRUSHED_METAL"||aV.name==="BRUSHED_STAINLESS"){if(aV.name==="CARBON"){a2.fillStyle=a2.createPattern(f,"repeat");a2.fill()}if(aV.name==="PUNCHED_SHEET"){a2.fillStyle=a2.createPattern(ap,"repeat");a2.fill()}aX=a2.createLinearGradient(a7,0,a0-a7,0);aX.addColorStop(0,"rgba(0, 0, 0, 0.25)");aX.addColorStop(0.5,"rgba(0, 0, 0, 0)");aX.addColorStop(1,"rgba(0, 0, 0, 0.25)");a2.fillStyle=aX;a2.beginPath();a2.arc(aZ,aY,a7,0,G,true);a2.closePath();a2.fill();if(aV.name==="BRUSHED_METAL"||aV.name==="BRUSHED_STAINLESS"){a6=(aV.name==="BRUSHED_METAL"?true:false);aQ=parseInt(aV.gradientStop.getHexColor().substr(-6),16);a3=p(aQ,5,0.1,a6,0.5);a2.fillStyle=a2.createPattern(a3.fill(0,0,a0,a9),"no-repeat");a2.fill()}}else{if(aV.name==="STAINLESS"||aV.name==="TURNED"){ba=[0,0.03,0.1,0.14,0.24,0.33,0.38,0.5,0.62,0.67,0.76,0.81,0.85,0.97,1];a1=[new J("#FDFDFD"),new J("#FDFDFD"),new J("#B2B2B4"),new J("#ACACAE"),new J("#FDFDFD"),new J("#8E8E8E"),new J("#8E8E8E"),new J("#FDFDFD"),new J("#8E8E8E"),new J("#8E8E8E"),new J("#FDFDFD"),new J("#ACACAE"),new J("#B2B2B4"),new J("#FDFDFD"),new J("#FDFDFD")];aX=new F(ba,a1);aX.fillCircle(a2,aZ,aY,0,a7);if(aV.name==="TURNED"){aT=a7;a4=aT*0.55;aU=l*(500/aT);a2.save();a2.beginPath();a2.arc(aZ,aY,aT,0,G);a2.closePath();a2.clip();a2.lineWidth=0.5;aS=G-aU*0.3;for(a8=0;a8<aS;a8+=aU){a2.strokeStyle="rgba(240, 240, 255, 0.25)";a2.beginPath();a2.arc(aZ+a4,aY,a4,0,G);a2.stroke();a2.translate(aZ,aY);a2.rotate(aU*0.3);a2.translate(-aZ,-aY);a2.strokeStyle="rgba(25, 10, 10, 0.1)";a2.beginPath();a2.arc(aZ+a4,aY,a4,0,G);a2.stroke();a2.translate(aZ,aY);a2.rotate(aU-aU*0.3);a2.translate(-aZ,-aY)}a2.restore()}}else{aX=a2.createLinearGradient(0,a0*0.084112,0,a7*2);aX.addColorStop(0,aV.gradientStart.getRgbaColor());aX.addColorStop(0.4,aV.gradientFraction.getRgbaColor());aX.addColorStop(1,aV.gradientStop.getRgbaColor());a2.fillStyle=aX;a2.fill()}}aX=a2.createRadialGradient(aZ,aY,0,aZ,aY,a7);aX.addColorStop(0,"rgba(0, 0, 0, 0)");aX.addColorStop(0.7,"rgba(0, 0, 0, 0)");aX.addColorStop(0.71,"rgba(0, 0, 0, 0)");aX.addColorStop(0.86,"rgba(0, 0, 0, 0.03)");aX.addColorStop(0.92,"rgba(0, 0, 0, 0.07)");aX.addColorStop(0.97,"rgba(0, 0, 0, 0.15)");aX.addColorStop(1,"rgba(0, 0, 0, 0.3)");a2.fillStyle=aX;a2.beginPath();a2.arc(aZ,aY,a7,0,G,true);a2.closePath();a2.fill();aO.cache[aW]=aR}a5.drawImage(aO.cache[aW],0,0);return this};aO.cache={};var P=function(aZ,aS,aR,aQ,aV,aU){var aY=aV*0.831775,aT=aU*0.831775,aX=(aV-aY)/2,aW=(aU-aT)/2;if(aS!==null&&aS.height>0&&aS.width>0){aZ.save();aZ.beginPath();aZ.arc(aR,aQ,aV*0.831775/2,0,G,true);aZ.clip();aZ.drawImage(aS,aX,aW,aY,aT);aZ.restore()}return this};var W=function(a7,aX,a2,bb,aR){var ba,aU,aZ,bc,a3,a9,a4,aQ,aT,aV,a6,a1,a0,aW,a8,aS,a5,aY=a2.toString()+bb+aR+aX.name;if(!W.cache[aY]){a9=Math.sqrt(a2*a2+bb*bb)*0.04;a9=Math.min(a9,(aR?a2:bb)*0.1);a4=I(a2,bb);aQ=a4.getContext("2d");aT=aX;O(aQ,a9,a9,a2-a9*2,bb-a9*2,4);if(aX.name==="CARBON"||aX.name==="PUNCHED_SHEET"||aX.name==="STAINLESS"||aX.name==="BRUSHED_METAL"||aX.name==="BRUSHED_STAINLESS"||aX.name==="TURNED"){if(aX.name==="CARBON"){aQ.fillStyle=aQ.createPattern(f,"repeat");aQ.fill()}if(aX.name==="PUNCHED_SHEET"){aQ.fillStyle=aQ.createPattern(ap,"repeat");aQ.fill()}if(aX.name==="STAINLESS"||aX.name==="TURNED"){bc=[0,0.03,0.1,0.14,0.24,0.33,0.38,0.5,0.62,0.67,0.76,0.81,0.85,0.97,1];a3=[new J("#FDFDFD"),new J("#FDFDFD"),new J("#B2B2B4"),new J("#ACACAE"),new J("#FDFDFD"),new J("#8E8E8E"),new J("#8E8E8E"),new J("#FDFDFD"),new J("#8E8E8E"),new J("#8E8E8E"),new J("#FDFDFD"),new J("#ACACAE"),new J("#B2B2B4"),new J("#FDFDFD"),new J("#FDFDFD")];aZ=new F(bc,a3);aQ.clip(O(aQ,a9,a9,a2-a9*2,bb-a9*2,4));aZ.fillRect(aQ,a2/2,bb/2,a2-a9*2,bb-a9*2,a2/2,bb/2);aZ=aQ.createLinearGradient(0,a9,0,bb-a9*2);aZ.addColorStop(0,"rgba(0, 0, 0, 0.25)");aZ.addColorStop(0.1,"rgba(0, 0, 0, 0.05)");aZ.addColorStop(1,"rgba(0, 0, 0, 0)");aQ.fillStyle=aZ;O(aQ,a9,a9,a2-a9*2,bb-a9*2,4);aQ.fill();aQ.restore();if(aX.name==="TURNED"){aV=Math.sqrt((a2-a9*2)*(a2-a9*2)+(bb-a9*2)*(bb-a9*2))/2;a6=aV*0.55;a1=a2/2;a0=bb/2;aW=G/360*(400/aV);aQ.save();aQ.beginPath();O(aQ,a9,a9,a2-a9*2,bb-a9*2,4);aQ.clip();aQ.lineWidth=0.5;aU=G-aW*0.3;for(ba=0;ba<aU;ba+=aW){aQ.strokeStyle="rgba(240, 240, 255, 0.25)";aQ.beginPath();aQ.arc(a1+a6,a0,a6,0,G);aQ.stroke();aQ.translate(a1,a0);aQ.rotate(aW*0.3);aQ.translate(-a1,-a0);aQ.strokeStyle="rgba(25, 10, 10, 0.1)";aQ.beginPath();aQ.arc(a1+a6,a0,a6,0,G);aQ.stroke();aQ.translate(a1,a0);aQ.rotate(-aW*0.3);aQ.translate(-a1,-a0);aQ.translate(a1,a0);aQ.rotate(aW);aQ.translate(-a1,-a0)}aQ.restore()}}aZ=aQ.createLinearGradient(a9,a9,a2-a9*2,bb-a9*2);aZ.addColorStop(0,"rgba(0, 0, 0, 0.25)");aZ.addColorStop(0.5,"rgba(0, 0, 0, 0)");aZ.addColorStop(1,"rgba(0, 0, 0, 0.25)");aQ.fillStyle=aZ;O(aQ,a9,a9,a2-a9*2,bb-a9*2,4);aQ.fill();if(aX.name==="BRUSHED_METAL"||aX.name==="BRUSHED_STAINLESS"){a8=(aX.name==="BRUSHED_METAL"?true:false);aS=parseInt(aX.gradientStop.getHexColor().substr(-6),16);a5=p(aS,5,0.1,a8,0.5);aQ.fillStyle=aQ.createPattern(a5.fill(0,0,a2,bb),"no-repeat");aQ.fill()}}else{aZ=aQ.createLinearGradient(0,a9,0,bb-a9*2);aZ.addColorStop(0,aX.gradientStart.getRgbaColor());aZ.addColorStop(0.4,aX.gradientFraction.getRgbaColor());aZ.addColorStop(1,aX.gradientStop.getRgbaColor());aQ.fillStyle=aZ;aQ.fill()}a3=["rgba(0, 0, 0, 0.3)","rgba(0, 0, 0, 0.15)","rgba(0, 0, 0, 0.07)","rgba(0, 0, 0, 0.03)","rgba(0, 0, 0, 0)","rgba(0, 0, 0, 0)","rgba(0, 0, 0, 0)"];for(ba=0;ba<7;ba++){O(aQ,a9+ba,a9+ba,a2-a9*2-(2*ba),bb-a9*2-(2*ba),4);aQ.strokeStyle=a3[ba];aQ.stroke()}W.cache[aY]=a4}a7.drawImage(W.cache[aY],0,0);return this};W.cache={};var z=function(a2,a6,aX,a7,aQ,a0,a5,a4,aR){var a1,aZ,a3=Math.ceil(a7*0.084112),aV=aX*0.5-a3/2,aT=a7*0.5-a3/2,aY=aX*0.008,aS,aW,aU=a6.type+aX+a7+aQ+(a0!==undefined?a0.type:"-")+(a5!==undefined?a5.style:"-")+(aR!==undefined?aR.type:"-");if(!z.cache[aU]){a1=I(aX,a7);aZ=a1.getContext("2d");if(aQ){aZ.shadowColor="rgba(0, 0, 0, 0.8)";aZ.shadowOffsetX=aZ.shadowOffsetY=aY;aZ.shadowBlur=aY*2;if(a4===steelseries.GaugeType.TYPE5){if(steelseries.Orientation.WEST===aR){aV=aX*0.733644-a3/2;aZ.drawImage(E(a3,a0,a5),aV,aT)}else{aT=a7*0.733644-a3/2;aZ.drawImage(E(a3,a0,a5),aV,a7*0.6857)}}else{aZ.drawImage(E(a3,a0,a5),aV,aT)}aZ.shadowOffsetX=aZ.shadowOffsetY=0;aZ.shadowBlur=0}switch(a6.type){case"type2":aZ.beginPath();aZ.moveTo(aX*0.135514,a7*0.696261);aZ.bezierCurveTo(aX*0.214953,a7*0.588785,aX*0.317757,a7*0.5,aX*0.462616,a7*0.425233);aZ.bezierCurveTo(aX*0.612149,a7*0.345794,aX*0.733644,a7*0.317757,aX*0.873831,a7*0.322429);aZ.bezierCurveTo(aX*0.766355,a7*0.112149,aX*0.528037,a7*0.023364,aX*0.313084,a7*0.130841);aZ.bezierCurveTo(aX*0.09813,a7*0.238317,aX*0.028037,a7*0.485981,aX*0.135514,a7*0.696261);aZ.closePath();aS=aZ.createLinearGradient(0.313084*aX,0.135514*a7,0.495528*aX,0.493582*a7);aS.addColorStop(0,"rgba(255, 255, 255, 0.275)");aS.addColorStop(1,"rgba(255, 255, 255, 0.015)");break;case"type3":aZ.beginPath();aZ.moveTo(aX*0.084112,a7*0.509345);aZ.bezierCurveTo(aX*0.21028,a7*0.556074,aX*0.462616,a7*0.560747,aX*0.5,a7*0.560747);aZ.bezierCurveTo(aX*0.537383,a7*0.560747,aX*0.794392,a7*0.560747,aX*0.915887,a7*0.509345);aZ.bezierCurveTo(aX*0.915887,a7*0.2757,aX*0.738317,a7*0.084112,aX*0.5,a7*0.084112);aZ.bezierCurveTo(aX*0.261682,a7*0.084112,aX*0.084112,a7*0.2757,aX*0.084112,a7*0.509345);aZ.closePath();aS=aZ.createLinearGradient(0,0.093457*a7,0,0.556073*a7);aS.addColorStop(0,"rgba(255, 255, 255, 0.275)");aS.addColorStop(1,"rgba(255, 255, 255, 0.015)");break;case"type4":aZ.beginPath();aZ.moveTo(aX*0.67757,a7*0.24299);aZ.bezierCurveTo(aX*0.771028,a7*0.308411,aX*0.822429,a7*0.411214,aX*0.813084,a7*0.528037);aZ.bezierCurveTo(aX*0.799065,a7*0.654205,aX*0.719626,a7*0.757009,aX*0.593457,a7*0.799065);aZ.bezierCurveTo(aX*0.485981,a7*0.831775,aX*0.369158,a7*0.808411,aX*0.285046,a7*0.728971);aZ.bezierCurveTo(aX*0.2757,a7*0.719626,aX*0.252336,a7*0.714953,aX*0.233644,a7*0.728971);aZ.bezierCurveTo(aX*0.214953,a7*0.747663,aX*0.219626,a7*0.771028,aX*0.228971,a7*0.7757);aZ.bezierCurveTo(aX*0.331775,a7*0.878504,aX*0.476635,a7*0.915887,aX*0.616822,a7*0.869158);aZ.bezierCurveTo(aX*0.771028,a7*0.822429,aX*0.873831,a7*0.691588,aX*0.88785,a7*0.53271);aZ.bezierCurveTo(aX*0.897196,a7*0.38785,aX*0.836448,a7*0.257009,aX*0.719626,a7*0.182242);aZ.bezierCurveTo(aX*0.705607,a7*0.172897,aX*0.682242,a7*0.163551,aX*0.663551,a7*0.186915);aZ.bezierCurveTo(aX*0.654205,a7*0.205607,aX*0.668224,a7*0.238317,aX*0.67757,a7*0.24299);aZ.closePath();aS=aZ.createRadialGradient((0.5)*aX,((0.5)*a7),0,((0.5)*aX),((0.5)*a7),0.38785*aX);aS.addColorStop(0,"rgba(255, 255, 255, 0)");aS.addColorStop(0.82,"rgba(255, 255, 255, 0)");aS.addColorStop(0.83,"rgba(255, 255, 255, 0)");aS.addColorStop(1,"rgba(255, 255, 255, 0.15)");aZ.beginPath();aZ.moveTo(aX*0.261682,a7*0.224299);aZ.bezierCurveTo(aX*0.285046,a7*0.238317,aX*0.252336,a7*0.285046,aX*0.24299,a7*0.317757);aZ.bezierCurveTo(aX*0.24299,a7*0.350467,aX*0.271028,a7*0.383177,aX*0.271028,a7*0.397196);aZ.bezierCurveTo(aX*0.2757,a7*0.415887,aX*0.261682,a7*0.457943,aX*0.238317,a7*0.509345);aZ.bezierCurveTo(aX*0.224299,a7*0.542056,aX*0.17757,a7*0.612149,aX*0.158878,a7*0.612149);aZ.bezierCurveTo(aX*0.144859,a7*0.612149,aX*0.088785,a7*0.546728,aX*0.130841,a7*0.369158);aZ.bezierCurveTo(aX*0.140186,a7*0.336448,aX*0.214953,a7*0.200934,aX*0.261682,a7*0.224299);aZ.closePath();aW=aZ.createLinearGradient(0.130841*aX,0.369158*a7,0.273839*aX,0.412877*a7);aW.addColorStop(0,"rgba(255, 255, 255, 0.275)");aW.addColorStop(1,"rgba(255, 255, 255, 0.015)");aZ.fillStyle=aW;aZ.fill();break;case"type5":aZ.beginPath();aZ.moveTo(aX*0.084112,a7*0.5);aZ.bezierCurveTo(aX*0.084112,a7*0.271028,aX*0.271028,a7*0.084112,aX*0.5,a7*0.084112);aZ.bezierCurveTo(aX*0.700934,a7*0.084112,aX*0.864485,a7*0.224299,aX*0.906542,a7*0.411214);aZ.bezierCurveTo(aX*0.911214,a7*0.439252,aX*0.911214,a7*0.518691,aX*0.845794,a7*0.537383);aZ.bezierCurveTo(aX*0.794392,a7*0.546728,aX*0.551401,a7*0.411214,aX*0.392523,a7*0.457943);aZ.bezierCurveTo(aX*0.168224,a7*0.509345,aX*0.135514,a7*0.7757,aX*0.093457,a7*0.593457);aZ.bezierCurveTo(aX*0.088785,a7*0.560747,aX*0.084112,a7*0.53271,aX*0.084112,a7*0.5);aZ.closePath();aS=aZ.createLinearGradient(0,0.084112*a7,0,0.644859*a7);aS.addColorStop(0,"rgba(255, 255, 255, 0.275)");aS.addColorStop(1,"rgba(255, 255, 255, 0.015)");break;case"type1":default:aZ.beginPath();aZ.moveTo(aX*0.084112,a7*0.509345);aZ.bezierCurveTo(aX*0.205607,a7*0.448598,aX*0.336448,a7*0.415887,aX*0.5,a7*0.415887);aZ.bezierCurveTo(aX*0.672897,a7*0.415887,aX*0.789719,a7*0.443925,aX*0.915887,a7*0.509345);aZ.bezierCurveTo(aX*0.915887,a7*0.2757,aX*0.738317,a7*0.084112,aX*0.5,a7*0.084112);aZ.bezierCurveTo(aX*0.261682,a7*0.084112,aX*0.084112,a7*0.2757,aX*0.084112,a7*0.509345);aZ.closePath();aS=aZ.createLinearGradient(0,0.088785*a7,0,0.490654*a7);aS.addColorStop(0,"rgba(255, 255, 255, 0.275)");aS.addColorStop(1,"rgba(255, 255, 255, 0.015)");break}aZ.fillStyle=aS;aZ.fill();z.cache[aU]=a1}a2.drawImage(z.cache[aU],0,0);return this};z.cache={};var aI=function(aZ,aX,aV,aT){var aR,aU,a0,aY,aQ,aS,aW=aX.toString()+aV+aT;if(!aI.cache[aW]){aR=I(aX,aV);aU=aR.getContext("2d");aY=Math.sqrt(aX*aX+aV*aV)*0.04;aY=Math.min(aY,(aT?aX:aV)*0.1);aQ=aY*1.3;aS=aQ*1.33;aU.beginPath();aU.moveTo(aQ,aV-aQ);aU.lineTo(aX-aQ,aV-aQ);aU.bezierCurveTo(aX-aQ,aV-aQ,aX-aS,aV*0.7,aX-aS,aV*0.5);aU.bezierCurveTo(aX-aS,aS,aX-aQ,aQ,aX-aY,aQ);aU.lineTo(aQ,aQ);aU.bezierCurveTo(aQ,aQ,aS,aV*0.285714,aS,aV*0.5);aU.bezierCurveTo(aS,aV*0.7,aQ,aV-aQ,aY,aV-aQ);aU.closePath();a0=aU.createLinearGradient(0,(aV-aY),0,aY);a0.addColorStop(0,"rgba(255, 255, 255, 0)");a0.addColorStop(0.06,"rgba(255, 255, 255, 0)");a0.addColorStop(0.07,"rgba(255, 255, 255, 0)");a0.addColorStop(0.12,"rgba(255, 255, 255, 0)");a0.addColorStop(0.17,"rgba(255, 255, 255, 0.013546)");a0.addColorStop(0.1701,"rgba(255, 255, 255, 0)");a0.addColorStop(0.79,"rgba(255, 255, 255, 0)");a0.addColorStop(0.8,"rgba(255, 255, 255, 0)");a0.addColorStop(0.84,"rgba(255, 255, 255, 0.082217)");a0.addColorStop(0.93,"rgba(255, 255, 255, 0.288702)");a0.addColorStop(0.94,"rgba(255, 255, 255, 0.298039)");a0.addColorStop(0.96,"rgba(255, 255, 255, 0.119213)");a0.addColorStop(0.97,"rgba(255, 255, 255, 0)");a0.addColorStop(1,"rgba(255, 255, 255, 0)");aU.fillStyle=a0;aU.fill();aI.cache[aW]=aR}aZ.drawImage(aI.cache[aW],0,0);return this};aI.cache={};var E=function(aY,aR,aQ){var aU,aV,aT=aY/2,aS=aY/2,aX,aW=aY.toString()+aR.type+aQ.style;if(!E.cache[aW]){aU=I(aY*1.18889,aY*1.18889);aV=aU.getContext("2d");switch(aR.type){case"metalKnob":aV.beginPath();aV.moveTo(0,aY*0.5);aV.bezierCurveTo(0,aY*0.222222,aY*0.222222,0,aY*0.5,0);aV.bezierCurveTo(aY*0.777777,0,aY,aY*0.222222,aY,aY*0.5);aV.bezierCurveTo(aY,aY*0.777777,aY*0.777777,aY,aY*0.5,aY);aV.bezierCurveTo(aY*0.222222,aY,0,aY*0.777777,0,aY*0.5);aV.closePath();aX=aV.createLinearGradient(0,0,0,aY);aX.addColorStop(0,"rgb(92, 95, 101)");aX.addColorStop(0.47,"rgb(46, 49, 53)");aX.addColorStop(1,"rgb(22, 23, 26)");aV.fillStyle=aX;aV.fill();aV.beginPath();aV.moveTo(aY*0.055555,aY*0.5);aV.bezierCurveTo(aY*0.055555,aY*0.277777,aY*0.277777,aY*0.055555,aY*0.5,aY*0.055555);aV.bezierCurveTo(aY*0.722222,aY*0.055555,aY*0.944444,aY*0.277777,aY*0.944444,aY*0.5);aV.bezierCurveTo(aY*0.944444,aY*0.722222,aY*0.722222,aY*0.944444,aY*0.5,aY*0.944444);aV.bezierCurveTo(aY*0.277777,aY*0.944444,aY*0.055555,aY*0.722222,aY*0.055555,aY*0.5);aV.closePath();aX=aV.createLinearGradient(0,0.055555*aY,0,0.944443*aY);switch(aQ.style){case"black":aX.addColorStop(0,"rgb(43, 42, 47)");aX.addColorStop(1,"rgb(26, 27, 32)");break;case"brass":aX.addColorStop(0,"rgb(150, 110, 54)");aX.addColorStop(1,"rgb(124, 95, 61)");break;case"silver":default:aX.addColorStop(0,"rgb(204, 204, 204)");aX.addColorStop(1,"rgb(87, 92, 98)");break}aV.fillStyle=aX;aV.fill();aV.beginPath();aV.moveTo(aY*0.777777,aY*0.833333);aV.bezierCurveTo(aY*0.722222,aY*0.722222,aY*0.611111,aY*0.666666,aY*0.5,aY*0.666666);aV.bezierCurveTo(aY*0.388888,aY*0.666666,aY*0.277777,aY*0.722222,aY*0.222222,aY*0.833333);aV.bezierCurveTo(aY*0.277777,aY*0.888888,aY*0.388888,aY*0.944444,aY*0.5,aY*0.944444);aV.bezierCurveTo(aY*0.611111,aY*0.944444,aY*0.722222,aY*0.888888,aY*0.777777,aY*0.833333);aV.closePath();aX=aV.createRadialGradient((0.555555)*aY,((0.944444)*aY),0,((0.555555)*aY),((0.944444)*aY),0.388888*aY);aX.addColorStop(0,"rgba(255, 255, 255, 0.6)");aX.addColorStop(1,"rgba(255, 255, 255, 0)");aV.fillStyle=aX;aV.fill();aV.beginPath();aV.moveTo(aY*0.944444,aY*0.277777);aV.bezierCurveTo(aY*0.833333,aY*0.111111,aY*0.666666,0,aY*0.5,0);aV.bezierCurveTo(aY*0.333333,0,aY*0.166666,aY*0.111111,aY*0.055555,aY*0.277777);aV.bezierCurveTo(aY*0.166666,aY*0.333333,aY*0.333333,aY*0.388888,aY*0.5,aY*0.388888);aV.bezierCurveTo(aY*0.666666,aY*0.388888,aY*0.833333,aY*0.333333,aY*0.944444,aY*0.277777);aV.closePath();aX=aV.createRadialGradient(0.5*aY,0,0,((0.5)*aY),0,0.583333*aY);aX.addColorStop(0,"rgba(255, 255, 255, 0.749019)");aX.addColorStop(1,"rgba(255, 255, 255, 0)");aV.fillStyle=aX;aV.fill();aV.beginPath();aV.moveTo(aY*0.277777,aY*0.555555);aV.bezierCurveTo(aY*0.277777,aY*0.388888,aY*0.388888,aY*0.277777,aY*0.5,aY*0.277777);aV.bezierCurveTo(aY*0.611111,aY*0.277777,aY*0.777777,aY*0.388888,aY*0.777777,aY*0.555555);aV.bezierCurveTo(aY*0.777777,aY*0.666666,aY*0.611111,aY*0.777777,aY*0.5,aY*0.777777);aV.bezierCurveTo(aY*0.388888,aY*0.777777,aY*0.277777,aY*0.666666,aY*0.277777,aY*0.555555);aV.closePath();aX=aV.createLinearGradient(0,0.277777*aY,0,0.722221*aY);aX.addColorStop(0,"#000000");aX.addColorStop(1,"rgb(204, 204, 204)");aV.fillStyle=aX;aV.fill();aV.beginPath();aV.moveTo(aY*0.333333,aY*0.555555);aV.bezierCurveTo(aY*0.333333,aY*0.444444,aY*0.388888,aY*0.333333,aY*0.5,aY*0.333333);aV.bezierCurveTo(aY*0.611111,aY*0.333333,aY*0.722222,aY*0.444444,aY*0.722222,aY*0.555555);aV.bezierCurveTo(aY*0.722222,aY*0.611111,aY*0.611111,aY*0.722222,aY*0.5,aY*0.722222);aV.bezierCurveTo(aY*0.388888,aY*0.722222,aY*0.333333,aY*0.611111,aY*0.333333,aY*0.555555);aV.closePath();aX=aV.createLinearGradient(0,0.333333*aY,0,0.666666*aY);aX.addColorStop(0,"rgb(10, 9, 1)");aX.addColorStop(1,"rgb(42, 41, 37)");aV.fillStyle=aX;aV.fill();break;case"standardKnob":aX=aV.createLinearGradient(0,0,0,aY);aX.addColorStop(0,"rgb(180, 180, 180)");aX.addColorStop(0.46,"rgb(63, 63, 63)");aX.addColorStop(1,"rgb(40, 40, 40)");aV.fillStyle=aX;aV.beginPath();aV.arc(aT,aS,aY/2,0,G,true);aV.closePath();aV.fill();aX=aV.createLinearGradient(0,aY-aY*0.77,0,aY-aY*0.77+aY*0.77);switch(aQ.style){case"black":aX.addColorStop(0,"rgb(191, 191, 191)");aX.addColorStop(0.5,"rgb(45, 44, 49)");aX.addColorStop(1,"rgb(125, 126, 128)");break;case"brass":aX.addColorStop(0,"rgb(223, 208, 174)");aX.addColorStop(0.5,"rgb(123, 95, 63)");aX.addColorStop(1,"rgb(207, 190, 157)");break;case"silver":default:aX.addColorStop(0,"rgb(215, 215, 215)");aX.addColorStop(0.5,"rgb(116, 116, 116)");aX.addColorStop(1,"rgb(215, 215, 215)");break}aV.fillStyle=aX;aV.beginPath();aV.arc(aT,aS,aY*0.77/2,0,G,true);aV.closePath();aV.fill();aX=aV.createRadialGradient(aT,aS,0,aT,aS,aY*0.77/2);aX.addColorStop(0,"rgba(0, 0, 0, 0)");aX.addColorStop(0.75,"rgba(0, 0, 0, 0)");aX.addColorStop(0.76,"rgba(0, 0, 0, 0.01)");aX.addColorStop(1,"rgba(0, 0, 0, 0.2)");aV.fillStyle=aX;aV.beginPath();aV.arc(aT,aS,aY*0.77/2,0,G,true);aV.closePath();aV.fill();break}E.cache[aW]=aU}return E.cache[aW]};E.cache={};var ad=function(aY,aR,aT){var aV,aU,aS=aY/2,aQ=aY/2,aX,aW=aY.toString()+aR+aT.outerColor_ON;if(!ad.cache[aW]){aV=I(aY,aY);aU=aV.getContext("2d");switch(aR){case 0:aX=aU.createRadialGradient(aS,aQ,0,aS,aQ,aY*0.5/2);aX.addColorStop(0,aT.innerColor1_OFF);aX.addColorStop(0.2,aT.innerColor2_OFF);aX.addColorStop(1,aT.outerColor_OFF);aU.fillStyle=aX;aU.beginPath();aU.arc(aS,aQ,aY*0.5/2,0,G,true);aU.closePath();aU.fill();aX=aU.createRadialGradient(aS,aQ,0,aS,aQ,aY*0.5/2);aX.addColorStop(0,"rgba(0, 0, 0, 0)");aX.addColorStop(0.8,"rgba(0, 0, 0, 0)");aX.addColorStop(1,"rgba(0, 0, 0, 0.4)");aU.fillStyle=aX;aU.beginPath();aU.arc(aS,aQ,aY*0.5/2,0,G,true);aU.closePath();aU.fill();aX=aU.createLinearGradient(0,0.35*aY,0,0.35*aY+0.15*aY);aX.addColorStop(0,"rgba(255, 255, 255, 0.4)");aX.addColorStop(1,"rgba(255, 255, 255, 0)");aU.fillStyle=aX;aU.beginPath();aU.arc(aS,0.35*aY+0.2*aY/2,aY*0.2,0,G,true);aU.closePath();aU.fill();break;case 1:aX=aU.createRadialGradient(aS,aQ,0,aS,aQ,aY*0.5/2);aX.addColorStop(0,aT.innerColor1_ON);aX.addColorStop(0.2,aT.innerColor2_ON);aX.addColorStop(1,aT.outerColor_ON);aU.fillStyle=aX;aU.beginPath();aU.arc(aS,aQ,aY*0.5/2,0,G,true);aU.closePath();aU.fill();aX=aU.createRadialGradient(aS,aQ,0,aS,aQ,aY*0.5/2);aX.addColorStop(0,"rgba(0, 0, 0, 0)");aX.addColorStop(0.8,"rgba(0, 0, 0, 0)");aX.addColorStop(1,"rgba(0, 0, 0, 0.4)");aU.fillStyle=aX;aU.beginPath();aU.arc(aS,aQ,aY*0.5/2,0,G,true);aU.closePath();aU.fill();aX=aU.createLinearGradient(0,0.35*aY,0,0.35*aY+0.15*aY);aX.addColorStop(0,"rgba(255, 255, 255, 0.4)");aX.addColorStop(1,"rgba(255, 255, 255, 0)");aU.fillStyle=aX;aU.beginPath();aU.arc(aS,0.35*aY+0.2*aY/2,aY*0.2,0,G,true);aU.closePath();aU.fill();aX=aU.createRadialGradient(aS,aQ,0,aS,aQ,aY/2);aX.addColorStop(0,N(aT.coronaColor,0).color);aX.addColorStop(0.6,N(aT.coronaColor,0.4).color);aX.addColorStop(0.7,N(aT.coronaColor,0.25).color);aX.addColorStop(0.8,N(aT.coronaColor,0.15).color);aX.addColorStop(0.85,N(aT.coronaColor,0.05).color);aX.addColorStop(1,N(aT.coronaColor,0).color);aU.fillStyle=aX;aU.beginPath();aU.arc(aS,aQ,aY/2,0,G,true);aU.closePath();aU.fill();break}ad.cache[aW]=aV}return ad.cache[aW]};ad.cache={};var U=function(aR,a4,a6){var aZ,aV,aU=0,aQ=0,a0=aR,a5=a4,aW=Math.min(aR,a4)*0.095,a2,aS=1,a3=1,aX=aR-2,a1=a4-2,aT=aW-1,aY=aR.toString()+a4+JSON.stringify(a6);if(!U.cache[aY]){aZ=I(aR,a4);aV=aZ.getContext("2d");a2=aV.createLinearGradient(0,aQ,0,aQ+a5);a2.addColorStop(0,"#4c4c4c");a2.addColorStop(0.08,"#666666");a2.addColorStop(0.92,"#666666");a2.addColorStop(1,"#e6e6e6");aV.fillStyle=a2;O(aV,aU,aQ,a0,a5,aW);aV.fill();a2=aV.createLinearGradient(0,a3,0,a3+a1);a2.addColorStop(0,a6.gradientStartColor);a2.addColorStop(0.03,a6.gradientFraction1Color);a2.addColorStop(0.49,a6.gradientFraction2Color);a2.addColorStop(0.5,a6.gradientFraction3Color);a2.addColorStop(1,a6.gradientStopColor);aV.fillStyle=a2;O(aV,aS,a3,aX,a1,aT);aV.fill();U.cache[aY]=aZ}return U.cache[aY]};U.cache={};var v=function(aS,aT,aQ,aR){var aW,aV,aU=aS.toString()+aT+aQ+aR;if(!v.cache[aU]){aW=A.createElement("canvas");aV=aW.getContext("2d");aW.width=aS;aW.height=aS;aV.fillStyle=aT;if(aQ){aV.beginPath();aV.moveTo(aS*0.5,aS);aV.lineTo(0,0);aV.lineTo(aS,0);aV.closePath();aV.fill()}else{if(aR){aV.beginPath();aV.moveTo(aS,aS*0.5);aV.lineTo(0,0);aV.lineTo(0,aS);aV.closePath();aV.fill()}else{aV.beginPath();aV.moveTo(aS*0.5,0);aV.lineTo(aS,aS);aV.lineTo(0,aS);aV.closePath();aV.fill()}}v.cache[aU]=aW}return v.cache[aU]};v.cache={};var af=function(aS,aY,aR){var aZ=aS*2,aU,aT,a0,aW=aY.state+aS+JSON.stringify(aR),aV=function(){var a1=aR[0];if(aY.state==="up"){a0=aT.createRadialGradient(0.5*aS,0.2*aZ,0,0.5*aS,0.2*aZ,0.5*aS);a0.addColorStop(0,a1.innerColor1_ON);a0.addColorStop(0.2,a1.innerColor2_ON);a0.addColorStop(1,a1.outerColor_ON)}else{a0=aT.createLinearGradient(0,0,0,0.5*aZ);a0.addColorStop(0,"#323232");a0.addColorStop(1,"#5c5c5c")}aT.fillStyle=a0;aT.beginPath();aT.moveTo(0.5*aS,0);aT.lineTo(aS,0.2*aZ);aT.lineTo(0.752*aS,0.2*aZ);aT.lineTo(0.752*aS,0.37*aZ);aT.lineTo(0.252*aS,0.37*aZ);aT.lineTo(0.252*aS,0.2*aZ);aT.lineTo(0,0.2*aZ);aT.closePath();aT.fill();if(aY.state!=="up"){aT.strokeStyle="rgba(0, 0, 0, 0.4)";aT.beginPath();aT.moveTo(0,0.2*aZ);aT.lineTo(0.5*aS,0);aT.lineTo(aS,0.2*aZ);aT.moveTo(0.252*aS,0.2*aZ);aT.lineTo(0.252*aS,0.37*aZ);aT.stroke();aT.strokeStyle="rgba(255, 255, 255, 0.3)";aT.beginPath();aT.moveTo(0.252*aS,0.37*aZ);aT.lineTo(0.752*aS,0.37*aZ);aT.lineTo(0.752*aS,0.2*aZ);aT.lineTo(aS,0.2*aZ);aT.stroke()}else{a0=aT.createRadialGradient(0.5*aS,0.2*aZ,0,0.5*aS,0.2*aZ,0.7*aS);a0.addColorStop(0,N(a1.coronaColor,0).color);a0.addColorStop(0.5,N(a1.coronaColor,0.3).color);a0.addColorStop(0.7,N(a1.coronaColor,0.2).color);a0.addColorStop(0.8,N(a1.coronaColor,0.1).color);a0.addColorStop(0.85,N(a1.coronaColor,0.05).color);a0.addColorStop(1,N(a1.coronaColor,0).color);aT.fillStyle=a0;aT.beginPath();aT.arc(0.5*aS,0.2*aZ,0.7*aS,0,G,true);aT.closePath();aT.fill()}},aX=function(){var a1=aR[1];aT.beginPath();if(aY.state==="steady"){a0=a1.outerColor_ON;aT.fillStyle=a0;aT.rect(0.128*aS,0.41*aZ,0.744*aS,0.074*aZ);aT.rect(0.128*aS,0.516*aZ,0.744*aS,0.074*aZ);aT.closePath();aT.fill()}else{a0=aT.createLinearGradient(0,0.41*aZ,0,0.41*aZ+0.074*aZ);a0.addColorStop(0,"#323232");a0.addColorStop(1,"#5c5c5c");aT.fillStyle=a0;aT.rect(0.128*aS,0.41*aZ,0.744*aS,0.074*aZ);aT.closePath();aT.fill();a0=aT.createLinearGradient(0,0.516*aZ,0,0.516*aZ+0.074*aZ);a0.addColorStop(0,"#323232");a0.addColorStop(1,"#5c5c5c");aT.fillStyle=a0;aT.rect(0.128*aS,0.516*aZ,0.744*aS,0.074*aZ);aT.closePath();aT.fill()}if(aY.state!=="steady"){aT.strokeStyle="rgba(0, 0, 0, 0.4)";aT.beginPath();aT.moveTo(0.128*aS,0.41*aZ+0.074*aZ);aT.lineTo(0.128*aS,0.41*aZ);aT.lineTo(0.128*aS+0.744*aS,0.41*aZ);aT.stroke();aT.beginPath();aT.moveTo(0.128*aS,0.516*aZ+0.074*aZ);aT.lineTo(0.128*aS,0.516*aZ);aT.lineTo(0.128*aS+0.744*aS,0.516*aZ);aT.stroke();aT.strokeStyle="rgba(255, 255, 255, 0.3)";aT.beginPath();aT.moveTo(0.128*aS+0.744*aS,0.41*aZ);aT.lineTo(0.128*aS+0.744*aS,0.41*aZ+0.074*aZ);aT.lineTo(0.128*aS,0.41*aZ+0.074*aZ);aT.stroke();aT.beginPath();aT.moveTo(0.128*aS+0.744*aS,0.516*aZ);aT.lineTo(0.128*aS+0.744*aS,0.516*aZ+0.074*aZ);aT.lineTo(0.128*aS,0.516*aZ+0.074*aZ);aT.stroke()}else{a0=aT.createRadialGradient(0.5*aS,0.5*aZ,0,0.5*aS,0.5*aZ,0.7*aS);a0.addColorStop(0,N(a1.coronaColor,0).color);a0.addColorStop(0.5,N(a1.coronaColor,0.3).color);a0.addColorStop(0.7,N(a1.coronaColor,0.2).color);a0.addColorStop(0.8,N(a1.coronaColor,0.1).color);a0.addColorStop(0.85,N(a1.coronaColor,0.05).color);a0.addColorStop(1,N(a1.coronaColor,0).color);aT.fillStyle=a0;aT.beginPath();aT.arc(0.5*aS,0.5*aZ,0.7*aS,0,G,true);aT.closePath();aT.fill()}},aQ=function(){var a1=aR[2];if(aY.state==="down"){a0=aT.createRadialGradient(0.5*aS,0.8*aZ,0,0.5*aS,0.8*aZ,0.5*aS);a0.addColorStop(0,a1.innerColor1_ON);a0.addColorStop(0.2,a1.innerColor2_ON);a0.addColorStop(1,a1.outerColor_ON)}else{a0=aT.createLinearGradient(0,0.63*aZ,0,aZ);a0.addColorStop(0,"#323232");a0.addColorStop(1,"#5c5c5c")}aT.beginPath();aT.fillStyle=a0;aT.moveTo(0.5*aS,aZ);aT.lineTo(aS,0.8*aZ);aT.lineTo(0.725*aS,0.8*aZ);aT.lineTo(0.725*aS,0.63*aZ);aT.lineTo(0.252*aS,0.63*aZ);aT.lineTo(0.252*aS,0.8*aZ);aT.lineTo(0,0.8*aZ);aT.closePath();aT.fill();if(aY.state!=="down"){aT.strokeStyle="rgba(0, 0, 0, 0.4)";aT.beginPath();aT.moveTo(0,0.8*aZ);aT.lineTo(0.252*aS,0.8*aZ);aT.moveTo(0.252*aS,0.63*aZ);aT.lineTo(0.752*aS,0.63*aZ);aT.stroke();aT.beginPath();aT.moveTo(0.752*aS,0.8*aZ);aT.lineTo(aS,0.8*aZ);aT.stroke();aT.strokeStyle="rgba(255, 255, 255, 0.3)";aT.beginPath();aT.moveTo(0,0.8*aZ);aT.lineTo(0.5*aS,aZ);aT.lineTo(aS,0.8*aZ);aT.stroke();aT.beginPath();aT.moveTo(0.752*aS,0.8*aZ);aT.lineTo(0.752*aS,0.63*aZ);aT.stroke()}else{a0=aT.createRadialGradient(0.5*aS,0.8*aZ,0,0.5*aS,0.8*aZ,0.7*aS);a0.addColorStop(0,N(a1.coronaColor,0).color);a0.addColorStop(0.5,N(a1.coronaColor,0.3).color);a0.addColorStop(0.7,N(a1.coronaColor,0.2).color);a0.addColorStop(0.8,N(a1.coronaColor,0.1).color);a0.addColorStop(0.85,N(a1.coronaColor,0.05).color);a0.addColorStop(1,N(a1.coronaColor,0).color);aT.fillStyle=a0;aT.beginPath();aT.arc(0.5*aS,0.8*aZ,0.7*aS,0,G,true);aT.closePath();aT.fill()}};if(!af.cache[aW]){aU=I(aS*2,aS*4);aT=aU.getContext("2d");aT.translate(aS*0.5,aS*0.5);switch(aY.state){case"up":aQ();aX();aV();break;case"steady":aQ();aV();aX();break;case"down":default:aV();aX();aQ();break}af.cache[aW]=aU}return af.cache[aW]};af.cache={};var an=function(aZ,aV,aT,aQ,aU,aW,aR,aX,aY,aS){aS=(undefined===aS?aS=steelseries.GaugeType.TYPE1:aS);aZ.save();aZ.textAlign=(aX?"center":"left");aZ.textBaseline="middle";aZ.strokeStyle=aW.labelColor.getRgbaColor();aZ.fillStyle=aW.labelColor.getRgbaColor();if(aX){aZ.font=0.046728*aV+"px sans-serif";aZ.fillText(aQ,aV/2,aT*0.3,aV*0.3);aZ.fillText(aU,aV/2,aT*0.38,aV*0.3)}else{if(aR){aZ.font=0.1*aV+"px sans-serif";aZ.save();aZ.translate(0.671428*aV,0.1375*aT);aZ.rotate(1.570796);aZ.fillText(aQ,0,0);aZ.translate(-0.671428*aV,-0.1375*aT);aZ.restore();aZ.font=0.071428*aV+"px sans-serif";if(aY){if(aS.type==="type2"){aZ.textAlign="right";aZ.fillText(aU,0.36*aV,aT*0.79,aV*0.25)}else{aZ.fillText(aU,0.63*aV,aT*0.85,aV*0.2)}}else{aZ.textAlign="center";if(aS.type==="type2"){aZ.fillText(aU,aV/2,aT*0.92,aV*0.2)}else{aZ.fillText(aU,aV/2,aT*0.89,aV*0.2)}}}else{aZ.font=0.035*aV+"px sans-serif";aZ.fillText(aQ,aV*0.15,aT*0.25,aV*0.3);aZ.font=0.025*aV+"px sans-serif";aZ.fillText(aU,aV*0.0625,aT*0.7,aV*0.07)}}aZ.restore()};var f=m(12,12,function(aS){var aT=aS.canvas.width,aR=aS.canvas.height,aQ=0,aV=0,aU;aS.save();aS.save();aS.beginPath();aS.rect(0,0,aT*0.5,aR*0.5);aS.closePath();aS.restore();aU=aS.createLinearGradient(0,aV*aR,0,0.5*aR+aV*aR);aU.addColorStop(0,"rgb(35, 35, 35)");aU.addColorStop(1,"rgb(23, 23, 23)");aS.fillStyle=aU;aS.fill();aS.save();aS.beginPath();aS.rect(aT*0.083333,0,aT*0.333333,aR*0.416666);aS.closePath();aS.restore();aQ=0.083333;aV=0;aU=aS.createLinearGradient(0,aV*aR,0,0.416666*aR+aV*aR);aU.addColorStop(0,"rgb(38, 38, 38)");aU.addColorStop(1,"rgb(30, 30, 30)");aS.fillStyle=aU;aS.fill();aS.save();aS.beginPath();aS.rect(aT*0.5,aR*0.5,aT*0.5,aR*0.5);aS.closePath();aS.restore();aQ=0.5;aV=0.5;aU=aS.createLinearGradient(0,aV*aR,0,0.5*aR+aV*aR);aU.addColorStop(0,"rgb(35, 35, 35)");aU.addColorStop(1,"rgb(23, 23, 23)");aS.fillStyle=aU;aS.fill();aS.save();aS.beginPath();aS.rect(aT*0.583333,aR*0.5,aT*0.333333,aR*0.416666);aS.closePath();aS.restore();aQ=0.583333;aV=0.5;aU=aS.createLinearGradient(0,aV*aR,0,0.416666*aR+aV*aR);aU.addColorStop(0,"rgb(38, 38, 38)");aU.addColorStop(1,"rgb(30, 30, 30)");aS.fillStyle=aU;aS.fill();aS.save();aS.beginPath();aS.rect(aT*0.5,0,aT*0.5,aR*0.5);aS.closePath();aS.restore();aQ=0.5;aV=0;aU=aS.createLinearGradient(0,aV*aR,0,0.5*aR+aV*aR);aU.addColorStop(0,"#303030");aU.addColorStop(1,"rgb(40, 40, 40)");aS.fillStyle=aU;aS.fill();aS.save();aS.beginPath();aS.rect(aT*0.583333,aR*0.083333,aT*0.333333,aR*0.416666);aS.closePath();aS.restore();aQ=0.583333;aV=0.083333;aU=aS.createLinearGradient(0,aV*aR,0,0.416666*aR+aV*aR);aU.addColorStop(0,"rgb(53, 53, 53)");aU.addColorStop(1,"rgb(45, 45, 45)");aS.fillStyle=aU;aS.fill();aS.save();aS.beginPath();aS.rect(0,aR*0.5,aT*0.5,aR*0.5);aS.closePath();aS.restore();aQ=0;aV=0.5;aU=aS.createLinearGradient(0,aV*aR,0,0.5*aR+aV*aR);aU.addColorStop(0,"#303030");aU.addColorStop(1,"#282828");aS.fillStyle=aU;aS.fill();aS.save();aS.beginPath();aS.rect(aT*0.083333,aR*0.583333,aT*0.333333,aR*0.416666);aS.closePath();aS.restore();aQ=0.083333;aV=0.583333;aU=aS.createLinearGradient(0,aV*aR,0,0.416666*aR+aV*aR);aU.addColorStop(0,"#353535");aU.addColorStop(1,"#2d2d2d");aS.fillStyle=aU;aS.fill();aS.restore()});var ap=m(15,15,function(aR){var aS=aR.canvas.width,aQ=aR.canvas.height,aT;aR.save();aR.save();aR.beginPath();aR.rect(0,0,aS,aQ);aR.closePath();aR.restore();aR.fillStyle="#1D2123";aR.fill();aR.save();aR.beginPath();aR.moveTo(0,aQ*0.266666);aR.bezierCurveTo(0,aQ*0.4,aS*0.066666,aQ*0.466666,aS*0.2,aQ*0.466666);aR.bezierCurveTo(aS*0.333333,aQ*0.466666,aS*0.4,aQ*0.4,aS*0.4,aQ*0.266666);aR.bezierCurveTo(aS*0.4,aQ*0.133333,aS*0.333333,aQ*0.066666,aS*0.2,aQ*0.066666);aR.bezierCurveTo(aS*0.066666,aQ*0.066666,0,aQ*0.133333,0,aQ*0.266666);aR.closePath();aT=aR.createLinearGradient(0,0.066666*aQ,0,0.466666*aQ);aT.addColorStop(0,"#000000");aT.addColorStop(1,"#444444");aR.fillStyle=aT;aR.fill();aR.save();aR.beginPath();aR.moveTo(0,aQ*0.2);aR.bezierCurveTo(0,aQ*0.333333,aS*0.066666,aQ*0.4,aS*0.2,aQ*0.4);aR.bezierCurveTo(aS*0.333333,aQ*0.4,aS*0.4,aQ*0.333333,aS*0.4,aQ*0.2);aR.bezierCurveTo(aS*0.4,aQ*0.066666,aS*0.333333,0,aS*0.2,0);aR.bezierCurveTo(aS*0.066666,0,0,aQ*0.066666,0,aQ*0.2);aR.closePath();aR.fillStyle="#050506";aR.fill();aR.save();aR.beginPath();aR.moveTo(aS*0.466666,aQ*0.733333);aR.bezierCurveTo(aS*0.466666,aQ*0.866666,aS*0.533333,aQ*0.933333,aS*0.666666,aQ*0.933333);aR.bezierCurveTo(aS*0.8,aQ*0.933333,aS*0.866666,aQ*0.866666,aS*0.866666,aQ*0.733333);aR.bezierCurveTo(aS*0.866666,aQ*0.6,aS*0.8,aQ*0.533333,aS*0.666666,aQ*0.533333);aR.bezierCurveTo(aS*0.533333,aQ*0.533333,aS*0.466666,aQ*0.6,aS*0.466666,aQ*0.733333);aR.closePath();aT=aR.createLinearGradient(0,0.533333*aQ,0,0.933333*aQ);aT.addColorStop(0,"#000000");aT.addColorStop(1,"#444444");aR.fillStyle=aT;aR.fill();aR.save();aR.beginPath();aR.moveTo(aS*0.466666,aQ*0.666666);aR.bezierCurveTo(aS*0.466666,aQ*0.8,aS*0.533333,aQ*0.866666,aS*0.666666,aQ*0.866666);aR.bezierCurveTo(aS*0.8,aQ*0.866666,aS*0.866666,aQ*0.8,aS*0.866666,aQ*0.666666);aR.bezierCurveTo(aS*0.866666,aQ*0.533333,aS*0.8,aQ*0.466666,aS*0.666666,aQ*0.466666);aR.bezierCurveTo(aS*0.533333,aQ*0.466666,aS*0.466666,aQ*0.533333,aS*0.466666,aQ*0.666666);aR.closePath();aR.fillStyle="#050506";aR.fill();aR.restore()});var p=function(aS,aR,aT,aQ,aX){this.fill=function(bm,bk,a1,aZ){var bj,bb,ba,be,bh,bd,bo,a3,a7,a6,a2=255,a5=(aS>>16)&255,bc=(aS>>8)&255,aY=aS&255,bg=0,bn=255*aT,a9,bf,bi,bp,a0,a4,a8,bl;bm=Math.floor(bm);bk=Math.floor(bk);a1=Math.ceil(a1);aZ=Math.ceil(aZ);bh=a1-bm;bd=aZ-bk;bo=I(bh,bd);a3=bo.getContext("2d");a7=a3.createImageData(bh,bd);a6=a3.createImageData(bh,bd);if(aX!==0){be=[];for(bj=0;bj<bh;bj++){be[bj]=(255*aX*Math.sin(bj/bh*am))|0}}for(ba=0;ba<bd;ba++){if(aR!==0){a9=bf=bi=0}for(bb=0;bb<bh;bb++){bp=(ba*bh*4)+(bb*4);a0=a5;a4=bc;a8=aY;if(aX!==0){bl=be[bb];a0+=bl;a4+=bl;a8+=bl}if(aQ){bg=((2*Math.random()-1)*bn)|0;a7.data[bp]=aV(a0+bg);a7.data[bp+1]=aV(a4+bg);a7.data[bp+2]=aV(a8+bg);a7.data[bp+3]=a2}else{a7.data[bp]=aU(a0,bn);a7.data[bp+1]=aU(a4,bn);a7.data[bp+2]=aU(a8,bn);a7.data[bp+3]=a2}}}if(aR>0){aW(a7,a6,bh,bd,aR,a2);a3.putImageData(a6,bm,bk)}else{a3.putImageData(a7,bm,bk)}return bo};function aU(aY,aZ){aY+=((2*Math.random()-1)*aZ)|0;return(aY<0?0:(aY>255?255:aY))}function aV(aY){return(aY<0?0:(aY>255?255:aY))}function aW(a9,aZ,aY,ba,a5,a1){var a8,a7,a3,a0,a4,bb,a2,a6;if(a5>=aY){a5=aY-1}a0=1/(a5*2+1);a4=0;for(a7=0;a7<ba;a7++){bb=a2=a6=0;for(a8=0;a8<a5;a8++){a3=(a4+a8)*4;bb+=a9.data[a3];a2+=a9.data[a3+1];a6+=a9.data[a3+2]}for(a8=0;a8<aY;a8++){if(a8>a5){a3=(a4-a5-1)*4;bb-=a9.data[a3];a2-=a9.data[a3+1];a6-=a9.data[a3+2]}if(a8+a5<aY){a3=(a4+a5)*4;bb+=a9.data[a3];a2+=a9.data[a3+1];a6+=a9.data[a3+2]}a3=a4*4;aZ.data[a3]=(bb*a0)|0;aZ.data[a3+1]=(a2*a0)|0;aZ.data[a3+2]=(a6*a0)|0;aZ.data[a3+3]=a1;a4++}}}return this};var J=function(aQ,aV,aW,aX){var aS,aU,aY,aT;if(arguments.length===1){aW=parseInt(aQ.substr(5,2),16);aV=parseInt(aQ.substr(3,2),16);aQ=parseInt(aQ.substr(1,2),16);aX=1}else{if(arguments.length===3){aX=1}}function aR(){aS=C(aQ,255);aU=C(aV,255);aY=C(aW,255);aT=C(aX,1)}aR();this.getRed=function(){return aS};this.setRed=function(aZ){aS=C(aZ,255)};this.getGreen=function(){return aU};this.setGreen=function(aZ){aU=C(aZ,255)};this.getBlue=function(){return aY};this.setBlue=function(aZ){aY=C(aZ,255)};this.getAlpha=function(){return aT};this.setAlpha=function(aZ){aT=C(aZ,1)};this.getRgbaColor=function(){return"rgba("+aS+", "+aU+", "+aY+", "+aT+")"};this.getRgbColor=function(){return"rgb("+aS+", "+aU+", "+aY+")"};this.getHexColor=function(){return"#"+aS.toString(16)+aU.toString(16)+aY.toString(16)}};var F=function(aT,aR){var aQ=aT.length-1,aS;for(aS=0;aS<=aQ;aS++){aT[aS]=G*aT[aS]-am}this.fillCircle=function(a6,aY,aX,bc,ba){var a9,aV=Math.ceil(ba),a0=aV*2,a5,aW,a1,aZ,a4,a3,a2,aU,bd,bb,a8,a7;a5=a6.createImageData(a0,a0);aW=255;for(aZ=0;aZ<a0;aZ++){a3=aV-aZ;a2=a3*a3;for(a1=0;a1<a0;a1++){a4=a1-aV;aU=Math.sqrt((a4*a4)+a2);if(aU<=aV&&aU>=bc){a9=Math.atan2(a4,a3);for(aS=0;aS<aQ;aS++){if(a9>=aT[aS]&&a9<aT[aS+1]){bb=aM(aR[aS],aR[aS+1],aT[aS+1]-aT[aS],a9-aT[aS],true)}}bd=((a0-aZ)*a0*4)+(a1*4);a5.data[bd]=bb[0];a5.data[bd+1]=bb[1];a5.data[bd+2]=bb[2];a5.data[bd+3]=aW}}}a8=I(a0,a0);a7=a8.getContext("2d");a7.putImageData(a5,0,0);a6.drawImage(a8,aY-aV,aX-aV)};this.fillRect=function(a5,aX,aW,a4,a2,bc,bb){var a8,a4=Math.ceil(a4),a9=a4/2,a2=Math.ceil(a2),aU=a2/2,bc=Math.ceil(bc),bb=Math.ceil(bb),a3,aV,aZ,aY,a1,a0,bd,ba,a7,a6;a3=a5.createImageData(a4,a2);aV=255;for(aY=0;aY<a2;aY++){a0=aU-aY;for(aZ=0;aZ<a4;aZ++){if(aY>bb&&aY<a2-bb){if(aZ>bc&&aZ<a4-bc){aZ=a4-bc}}a1=aZ-a9;a8=Math.atan2(a1,a0);for(aS=0;aS<aQ;aS++){if(a8>=aT[aS]&&a8<aT[aS+1]){ba=aM(aR[aS],aR[aS+1],aT[aS+1]-aT[aS],a8-aT[aS],true)}}bd=((a2-aY)*a4*4)+(aZ*4);a3.data[bd]=ba[0];a3.data[bd+1]=ba[0];a3.data[bd+2]=ba[0];a3.data[bd+3]=aV}}a7=I(a4,a2);a6=a7.getContext("2d");a6.putImageData(a3,0,0);a5.drawImage(a7,aX-a9,aW-aU)}};var h=function(aT,aR,aS,aQ){this.getColorAt=function(aY){var aX=0,a0=0,aW=1,aZ=1,aV,aU;aY=(aY<0?0:(aY>1?1:aY));for(aV=0;aV<aS.length;aV++){if(aS[aV]<aY&&aX<aS[aV]){aX=aS[aV];a0=aV}if(aS[aV]===aY){return aQ[aV]}if(aS[aV]>aY&&aW>=aS[aV]){aW=aS[aV];aZ=aV}}aU=(aY-aX)/(aW-aX);return aM(aQ[a0],aQ[aZ],1,aU)};this.getStart=function(){return aT};this.getEnd=function(){return aR}};function N(aS,aV){var aR=("#"===aS.charAt(0))?aS.substring(1,7):aS,aU=parseInt((aR).substring(0,2),16),aT=parseInt((aR).substring(2,4),16),aQ=parseInt((aR).substring(4,6),16);this.color="rgba("+aU+","+aT+","+aQ+","+aV+")";return this}function aM(a0,a1,aY,aU,aQ){var a7=1/255,a6=a0.getRed(),aV=a0.getGreen(),aS=a0.getBlue(),aR=a0.getAlpha(),a4=a1.getRed()-a6,aX=a1.getGreen()-aV,a5=a1.getBlue()-aS,aT=a1.getAlpha()*a7-aR*a7,a3=a4/aY*aU,a2=aX/aY*aU,aZ=a5/aY*aU,aW=aT/aY*aU;aQ=aQ||false;if(aQ){return[(a6+a3).toFixed(0),(aV+a2).toFixed(0),(aS+aZ).toFixed(0),aR+aW]}else{return new J((a6+a3).toFixed(0),(aV+a2).toFixed(0),(aS+aZ).toFixed(0),aR+aW)}}function ay(aS,aR,aQ){return{start:aS,stop:aR,color:aQ}}Math.log10=function(aQ){return(Math.log(aQ)/Math.LN10)};function g(aR,aQ){var aU=Math.floor(Math.log10(aR)),aT=aR/Math.pow(10,aU),aS;if(aQ){if(1.5>aT){aS=1}else{if(3>aT){aS=2}else{if(7>aT){aS=5}else{aS=10}}}}else{if(1>=aT){aS=1}else{if(2>=aT){aS=2}else{if(5>=aT){aS=5}else{aS=10}}}}return aS*Math.pow(10,aU)}function O(aU,aS,aX,aT,aV,aR){var aW=aS+aT,aQ=aX+aV;aU.beginPath();aU.moveTo(aS+aR,aX);aU.lineTo(aW-aR,aX);aU.quadraticCurveTo(aW,aX,aW,aX+aR);aU.lineTo(aW,aX+aV-aR);aU.quadraticCurveTo(aW,aQ,aW-aR,aQ);aU.lineTo(aS+aR,aQ);aU.quadraticCurveTo(aS,aQ,aS,aQ-aR);aU.lineTo(aS,aX+aR);aU.quadraticCurveTo(aS,aX,aS+aR,aX);aU.closePath();aU.stroke()}function I(aS,aQ){var aR=A.createElement("canvas");aR.width=aS;aR.height=aQ;return aR}function m(aS,aQ,aT){var aR=A.createElement("canvas");aR.width=aS;aR.height=aQ;aT(aR.getContext("2d"));return aR}function az(aQ){var aS,aR=m(1,1,function(aT){aT.fillStyle=aQ;aT.beginPath();aT.rect(0,0,1,1);aT.fill()});aS=aR.getContext("2d").getImageData(0,0,2,2).data;return[aS[0],aS[1],aS[2],aS[3]]}function r(aU){var aR,aX,aS,aV,aW,aT=az(aU),aQ=new J(aT[0],aT[1],aT[2],aT[3]);aR=aN(aQ,0.32);aX=aN(aQ,0.62);aS=av(aQ,0.84);aV=av(aQ,0.94);aW=av(aQ,1);return new B(aR,aX,aQ,aS,aV,aW)}function ar(aQ,aR,aW){var aS,aV,aU,aT,aY,aX;aQ/=255;aR/=255;aW/=255;aV=Math.max(aQ,aR,aW);aS=Math.min(aQ,aR,aW);aY=(aV+aS)/2;if(aV===aS){aU=aT=0}else{aX=aV-aS;aT=aY>0.5?aX/(2-aV-aS):aX/(aV+aS);switch(aV){case aQ:aU=(aR-aW)/aX+(aR<aW?6:0);break;case aR:aU=(aW-aQ)/aX+2;break;case aW:aU=(aQ-aR)/aX+4;break}aU/=6}return[aU,aT,aY]}function aa(aW,aU,aY){var aQ,aV,aZ,aT=Math.floor(aW*6),aX=aW*6-aT,aS=aY*(1-aU),aR=aY*(1-aX*aU),a0=aY*(1-(1-aX)*aU);switch(aT%6){case 0:aQ=aY;aV=a0;aZ=aS;break;case 1:aQ=aR;aV=aY;aZ=aS;break;case 2:aQ=aS;aV=aY;aZ=a0;break;case 3:aQ=aS;aV=aR;aZ=aY;break;case 4:aQ=a0;aV=aS;aZ=aY;break;case 5:aQ=aY;aV=aS;aZ=aR;break}return[Math.floor(aQ*255),Math.floor(aV*255),Math.floor(aZ*255)]}function aw(aQ,aT,aW){var aR,aX,aU,aS,aV,aY;aQ=aQ/255;aT=aT/255;aW=aW/255;aX=Math.max(aQ,aT,aW);aR=Math.min(aQ,aT,aW);aV=aX;aY=aX-aR;aS=aX===0?0:aY/aX;if(aX===aR){aU=0}else{switch(aX){case aQ:aU=(aT-aW)/aY+(aT<aW?6:0);break;case aT:aU=(aW-aQ)/aY+2;break;case aW:aU=(aQ-aT)/aY+4;break}aU/=6}return[aU,aS,aV]}function C(aR,aQ){return(aR<0?0:(aR>aQ?aQ:aR))}function aN(aR,aS){var aU=Math.floor(aR.getRed()*(1-aS)),aT=Math.floor(aR.getGreen()*(1-aS)),aQ=Math.floor(aR.getBlue()*(1-aS));aU=C(aU,255);aT=C(aT,255);aQ=C(aQ,255);return new J(aU,aT,aQ,aR.getAlpha())}function av(aR,aS){var aU=Math.round(aR.getRed()*(1+aS)),aT=Math.round(aR.getGreen()*(1+aS)),aQ=Math.round(aR.getBlue()*(1+aS));aU=C(aU,255);aT=C(aT,255);aQ=C(aQ,255);return new J(aU,aT,aQ,aR.getAlpha())}function o(aS,aQ,aR){var aU,aT;if(aR<=aQ){throw"Rotary bounds are of negative or zero size"}aU=aR-aQ;aT=Math.floor((aS-aQ)/aU);return aS-(aT*aU)}function ai(aR,aQ){return o((aQ-aR),-180,180)}var ab=(function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(aQ){window.setTimeout(aQ,1000/16)}}());var i;(function(){i=function(aV,aT,aQ,aU,aR,aS){this.gradientStart=aV;this.gradientFraction=aT;this.gradientStop=aQ;this.labelColor=aU;this.symbolColor=aR;this.name=aS}}());var ag;(function(){ag=function(aQ,aT,aS,aR,aV,aU){this.gradientStartColor=aQ;this.gradientFraction1Color=aT;this.gradientFraction2Color=aS;this.gradientFraction3Color=aR;this.gradientStopColor=aV;this.textColor=aU}}());var B;(function(){B=function(aV,aU,aS,aR,aQ,aT){this.veryDark=aV;this.dark=aU;this.medium=aS;this.light=aR;this.lighter=aQ;this.veryLight=aT}}());var ak;(function(){ak=function(aS,aQ,aW,aU,aT,aR,aV){this.innerColor1_ON=aS;this.innerColor2_ON=aQ;this.outerColor_ON=aW;this.coronaColor=aU;this.innerColor1_OFF=aT;this.innerColor2_OFF=aR;this.outerColor_OFF=aV}}());var aH;(function(){aH=function(aQ){this.type=aQ}}());var S;(function(){S=function(aQ){this.type=aQ}}());var aL;(function(){aL=function(aQ){this.type=aQ}}());var n;(function(){n=function(aQ){this.style=aQ}}());var aj;(function(){aj=function(aQ){this.design=aQ}}());var Y;(function(){Y=function(aQ){this.type=aQ}}());var a;(function(){a=function(aQ){this.type=aQ}}());var t;(function(){t=function(aQ){this.format=aQ}}());var aG;(function(){aG=function(aQ){this.type=aQ}}());var aA;(function(){aA=function(aQ){this.state=aQ}}());var s={DARK_GRAY:new i(new J(0,0,0,1),new J(51,51,51,1),new J(153,153,153,1),new J(255,255,255,1),new J(180,180,180,1),"DARK_GRAY"),SATIN_GRAY:new i(new J(45,57,57,1),new J(45,57,57,1),new J(45,57,57,1),new J(167,184,180,1),new J(137,154,150,1),"SATIN_GRAY"),LIGHT_GRAY:new i(new J(130,130,130,1),new J(181,181,181,1),new J(253,253,253,1),new J(0,0,0,1),new J(80,80,80,1),"LIGHT_GRAY"),WHITE:new i(new J(255,255,255,1),new J(255,255,255,1),new J(255,255,255,1),new J(0,0,0,1),new J(80,80,80,1),"WHITE"),BLACK:new i(new J(0,0,0,1),new J(0,0,0,1),new J(0,0,0,1),new J(255,255,255,1),new J(150,150,150,1),"BLACK"),BEIGE:new i(new J(178,172,150,1),new J(204,205,184,1),new J(231,231,214,1),new J(0,0,0,1),new J(80,80,80,1),"BEIGE"),BROWN:new i(new J(245,225,193,1),new J(245,225,193,1),new J(255,250,240,1),new J(109,73,47,1),new J(89,53,27,1),"BROWN"),RED:new i(new J(198,93,95,1),new J(212,132,134,1),new J(242,218,218,1),new J(0,0,0,1),new J(90,0,0,1),"RED"),GREEN:new i(new J(65,120,40,1),new J(129,171,95,1),new J(218,237,202,1),new J(0,0,0,1),new J(0,90,0,1),"GREEN"),BLUE:new i(new J(45,83,122,1),new J(115,144,170,1),new J(227,234,238,1),new J(0,0,0,1),new J(0,0,90,1),"BLUE"),ANTHRACITE:new i(new J(50,50,54,1),new J(47,47,51,1),new J(69,69,74,1),new J(250,250,250,1),new J(180,180,180,1),"ANTHRACITE"),MUD:new i(new J(80,86,82,1),new J(70,76,72,1),new J(57,62,58,1),new J(255,255,240,1),new J(225,225,210,1),"MUD"),PUNCHED_SHEET:new i(new J(50,50,54,1),new J(47,47,51,1),new J(69,69,74,1),new J(255,255,255,1),new J(180,180,180,1),"PUNCHED_SHEET"),CARBON:new i(new J(50,50,54,1),new J(47,47,51,1),new J(69,69,74,1),new J(255,255,255,1),new J(180,180,180,1),"CARBON"),STAINLESS:new i(new J(130,130,130,1),new J(181,181,181,1),new J(253,253,253,1),new J(0,0,0,1),new J(80,80,80,1),"STAINLESS"),BRUSHED_METAL:new i(new J(50,50,54,1),new J(47,47,51,1),new J(69,69,74,1),new J(0,0,0,1),new J(80,80,80,1),"BRUSHED_METAL"),BRUSHED_STAINLESS:new i(new J(50,50,54,1),new J(47,47,51,1),new J(110,110,112,1),new J(0,0,0,1),new J(80,80,80,1),"BRUSHED_STAINLESS"),TURNED:new i(new J(130,130,130,1),new J(181,181,181,1),new J(253,253,253,1),new J(0,0,0,1),new J(80,80,80,1),"TURNED")};var ao={BEIGE:new ag("#c8c8b1","rgb(241, 237, 207)","rgb(234, 230, 194)","rgb(225, 220, 183)","rgb(237, 232, 191)","#000000"),BLUE:new ag("#ffffff","rgb(231, 246, 255)","rgb(170, 224, 255)","rgb(136, 212, 255)","rgb(192, 232, 255)","#124564"),ORANGE:new ag("#ffffff","rgb(255, 245, 225)","rgb(255, 217, 147)","rgb(255, 201, 104)","rgb(255, 227, 173)","#503700"),RED:new ag("#ffffff","rgb(255, 225, 225)","rgb(253, 152, 152)","rgb(252, 114, 115)","rgb(254, 178, 178)","#4f0c0e"),YELLOW:new ag("#ffffff","rgb(245, 255, 186)","rgb(210, 255, 0)","rgb(158, 205, 0)","rgb(210, 255, 0)","#405300"),WHITE:new ag("#ffffff","#ffffff","rgb(241, 246, 242)","rgb(229, 239, 244)","#ffffff","#000000"),GRAY:new ag("#414141","rgb(117, 117, 117)","rgb(87, 87, 87)","#414141","rgb(81, 81, 81)","#ffffff"),BLACK:new ag("#414141","#666666","#333333","#000000","#333333","#cccccc"),GREEN:new ag("rgb(33, 67, 67)","rgb(33, 67, 67)","rgb(29, 58, 58)","rgb(28, 57, 57)","rgb(23, 46, 46)","rgba(0, 185, 165, 255)"),BLUE2:new ag("rgb(0, 68, 103)","rgb(8, 109, 165)","rgb(0, 72, 117)","rgb(0, 72, 117)","rgb(0, 68, 103)","rgb(111, 182, 228)"),BLUE_BLACK:new ag("rgb(22, 125, 212)","rgb(3, 162, 254)","rgb(3, 162, 254)","rgb(3, 162, 254)","rgb(11, 172, 244)","#000000"),BLUE_DARKBLUE:new ag("rgb(18, 33, 88)","rgb(18, 33, 88)","rgb(19, 30, 90)","rgb(17, 31, 94)","rgb(21, 25, 90)","rgb(23, 99, 221)"),BLUE_GRAY:new ag("rgb(135, 174, 255)","rgb(101, 159, 255)","rgb(44, 93, 255)","rgb(27, 65, 254)","rgb(12, 50, 255)","#b2b4ed"),STANDARD:new ag("rgb(131, 133, 119)","rgb(176, 183, 167)","rgb(165, 174, 153)","rgb(166, 175, 156)","rgb(175, 184, 165)","rgb(35, 42, 52)"),STANDARD_GREEN:new ag("#ffffff","rgb(219, 230, 220)","rgb(179, 194, 178)","rgb(153, 176, 151)","rgb(114, 138, 109)","#080C06"),BLUE_BLUE:new ag("rgb(100, 168, 253)","rgb(100, 168, 253)","rgb(95, 160, 250)","rgb(80, 144, 252)","rgb(74, 134, 255)","#002cbb"),RED_DARKRED:new ag("rgb(72, 36, 50)","rgb(185, 111, 110)","rgb(148, 66, 72)","rgb(83, 19, 20)","rgb(7, 6, 14)","#FE8B92"),DARKBLUE:new ag("rgb(14, 24, 31)","rgb(46, 105, 144)","rgb(19, 64, 96)","rgb(6, 20, 29)","rgb(8, 9, 10)","#3DB3FF"),LILA:new ag("rgb(175, 164, 255)","rgb(188, 168, 253)","rgb(176, 159, 255)","rgb(174, 147, 252)","rgb(168, 136, 233)","#076148"),BLACKRED:new ag("rgb(8, 12, 11)","rgb(10, 11, 13)","rgb(11, 10, 15)","rgb(7, 13, 9)","rgb(9, 13, 14)","#B50026"),DARKGREEN:new ag("rgb(25, 85, 0)","rgb(47, 154, 0)","rgb(30, 101, 0)","rgb(30, 101, 0)","rgb(25, 85, 0)","#233123"),AMBER:new ag("rgb(182, 71, 0)","rgb(236, 155, 25)","rgb(212, 93, 5)","rgb(212, 93, 5)","rgb(182, 71, 0)","#593A0A"),LIGHTBLUE:new ag("rgb(125, 146, 184)","rgb(197, 212, 231)","rgb(138, 155, 194)","rgb(138, 155, 194)","rgb(125, 146, 184)","#090051"),SECTIONS:new ag("#b2b2b2","#ffffff","#c4c4c4","#c4c4c4","#b2b2b2","#000000")};var q={RED:new B(new J(82,0,0,1),new J(158,0,19,1),new J(213,0,25,1),new J(240,82,88,1),new J(255,171,173,1),new J(255,217,218,1)),GREEN:new B(new J(8,54,4,1),new J(0,107,14,1),new J(15,148,0,1),new J(121,186,37,1),new J(190,231,141,1),new J(234,247,218,1)),BLUE:new B(new J(0,11,68,1),new J(0,73,135,1),new J(0,108,201,1),new J(0,141,242,1),new J(122,200,255,1),new J(204,236,255,1)),ORANGE:new B(new J(118,83,30,1),new J(215,67,0,1),new J(240,117,0,1),new J(255,166,0,1),new J(255,255,128,1),new J(255,247,194,1)),YELLOW:new B(new J(41,41,0,1),new J(102,102,0,1),new J(177,165,0,1),new J(255,242,0,1),new J(255,250,153,1),new J(255,252,204,1)),CYAN:new B(new J(15,109,109,1),new J(0,109,144,1),new J(0,144,191,1),new J(0,174,239,1),new J(153,223,249,1),new J(204,239,252,1)),MAGENTA:new B(new J(98,0,114,1),new J(128,24,72,1),new J(191,36,107,1),new J(255,48,143,1),new J(255,172,210,1),new J(255,214,23,1)),WHITE:new B(new J(210,210,210,1),new J(220,220,220,1),new J(235,235,235,1),new J(255,255,255,1),new J(255,255,255,1),new J(255,255,255,1)),GRAY:new B(new J(25,25,25,1),new J(51,51,51,1),new J(76,76,76,1),new J(128,128,128,1),new J(204,204,204,1),new J(243,243,243,1)),BLACK:new B(new J(0,0,0,1),new J(5,5,5,1),new J(10,10,10,1),new J(15,15,15,1),new J(20,20,20,1),new J(25,25,25,1)),RAITH:new B(new J(0,32,65,1),new J(0,65,125,1),new J(0,106,172,1),new J(130,180,214,1),new J(148,203,242,1),new J(191,229,255,1)),GREEN_LCD:new B(new J(0,55,45,1),new J(15,109,93,1),new J(0,185,165,1),new J(48,255,204,1),new J(153,255,227,1),new J(204,255,241,1)),JUG_GREEN:new B(new J(0,56,0,1),new J(32,69,36,1),new J(50,161,0,1),new J(129,206,0,1),new J(190,231,141,1),new J(234,247,218,1))};var w={RED_LED:new ak("#FF9A89","#FF9A89","#FF3300","#FF8D70","#7E1C00","#7E1C00","#641B00"),GREEN_LED:new ak("#9AFF89","#9AFF89","#59FF2A","#A5FF00","#1C7E00","#1C7E00","#1B6400"),BLUE_LED:new ak("#899AFF","#899AFF","#0033FF","#708DFF","#001C7E","#001C7E","#001B64"),ORANGE_LED:new ak("#FEA23F","#FEA23F","#FD6C00","#FD6C00","#592800","#592800","#421F00"),YELLOW_LED:new ak("#FFFF62","#FFFF62","#FFFF00","#FFFF00","#6B6D00","#6B6D00","#515300"),CYAN_LED:new ak("#00FFFF","#00FFFF","#1BC3C3","#00FFFF","#083B3B","#083B3B","#052727"),MAGENTA_LED:new ak("#D300FF","#D300FF","#8600CB","#C300FF","#38004B","#38004B","#280035")};var K={TYPE1:new aH("type1"),TYPE2:new aH("type2"),TYPE3:new aH("type3"),TYPE4:new aH("type4"),TYPE5:new aH("type5")};var ax={NORTH:new S("north"),SOUTH:new S("south"),EAST:new S("east"),WEST:new S("west")};var aJ={STANDARD_KNOB:new aL("standardKnob"),METAL_KNOB:new aL("metalKnob")};var T={BLACK:new n("black"),BRASS:new n("brass"),SILVER:new n("silver")};var aK={BLACK_METAL:new aj("blackMetal"),METAL:new aj("metal"),SHINY_METAL:new aj("shinyMetal"),BRASS:new aj("brass"),STEEL:new aj("steel"),CHROME:new aj("chrome"),GOLD:new aj("gold"),ANTHRACITE:new aj("anthracite"),TILTED_GRAY:new aj("tiltedGray"),TILTED_BLACK:new aj("tiltedBlack"),GLOSSY_METAL:new aj("glossyMetal")};var au={TYPE1:new Y("type1"),TYPE2:new Y("type2"),TYPE3:new Y("type3"),TYPE4:new Y("type4"),TYPE5:new Y("type5"),TYPE6:new Y("type6"),TYPE7:new Y("type7"),TYPE8:new Y("type8"),TYPE9:new Y("type9"),TYPE10:new Y("type10"),TYPE11:new Y("type11"),TYPE12:new Y("type12"),TYPE13:new Y("type13"),TYPE14:new Y("type14"),TYPE15:new Y("type15"),TYPE16:new Y("type16")};var aF={TYPE1:new a("type1"),TYPE2:new a("type2"),TYPE3:new a("type3"),TYPE4:new a("type4"),TYPE5:new a("type5")};var u={STANDARD:new t("standard"),FRACTIONAL:new t("fractional"),SCIENTIFIC:new t("scientific")};var X={NORMAL:new aG("normal"),HORIZONTAL:new aG("horizontal"),TANGENT:new aG("tangent")};var aE={UP:new aA("up"),STEADY:new aA("steady"),DOWN:new aA("down"),OFF:new aA("off")};return{Radial:V,RadialBargraph:x,RadialVertical:ac,Linear:L,LinearBargraph:y,DisplaySingle:j,DisplayMulti:Q,Level:al,Compass:at,WindDirection:H,Horizon:ah,Led:aq,Clock:c,Battery:Z,StopWatch:ae,Altimeter:aP,TrafficLight:aD,LightBulb:M,Odometer:aB,drawFrame:d,drawBackground:aO,drawForeground:z,rgbaColor:J,ConicalGradient:F,setAlpha:N,getColorFromFraction:aM,gradientWrapper:h,BackgroundColor:s,LcdColor:ao,ColorDef:q,LedColor:w,GaugeType:K,Orientation:ax,FrameDesign:aK,PointerType:au,ForegroundType:aF,KnobType:aJ,KnobStyle:T,LabelNumberFormat:u,TickLabelOrientation:X,TrendState:aE,Section:ay}}());