/*
 * File: firmware.h
 *
 * Copyright (c) 2011 Eric J. Holmes, Orion Telescopes & Binoculars
 *
 */

#ifndef __FIRMWARE_H_
#define __FIRMWARE_H_

/*
 * Firmware is in the following format:
 *
 * byte 0: Byte Count (Number of bytes in payload)
 * byte 1-2: Address where data will go (1 word)
 * byte 3-x: Data
 */

/* EEPROM to set VID PID to Orion SSAG */
#define SSAG_EEPROM 0x08, 0x00, 0x00, 0xc0, 0x56, 0x18, 0x11, 0x00, 0x00, 0x00

#define SSAG_BOOTLOADER                                                                                               \
    0x10, 0x68, 0x03, 0x90, 0xe6, 0x68, 0xe0, 0xff, 0x74, 0xff, 0xf0, 0xe0, 0xb4, 0x0b, 0x04, 0xef, 0xf0, 0xd3, 0x22, \
        0x06, 0x78, 0x03, 0x90, 0xe6, 0x68, 0xef, 0xf0, 0xc3, 0x01, 0x7e, 0x03, 0x22, 0x10, 0xb5, 0x01, 0x90, 0x7f,   \
        0xe9, 0xe0, 0x64, 0xa3, 0x60, 0x03, 0x02, 0x02, 0xc5, 0xa3, 0xe0, 0x75, 0x08, 0x00, 0x10, 0xc5, 0x01, 0xf5,   \
        0x09, 0xa3, 0xe0, 0xfe, 0xe4, 0xee, 0x42, 0x08, 0x90, 0x7f, 0xee, 0xe0, 0x75, 0x0a, 0x00, 0x10, 0xd5, 0x01,   \
        0xf5, 0x0b, 0xa3, 0xe0, 0xfe, 0xe4, 0xee, 0x42, 0x0a, 0x90, 0x7f, 0xe8, 0xe0, 0x64, 0x40, 0x70, 0x10, 0xe5,   \
        0x01, 0x64, 0xe5, 0x0b, 0x45, 0x0a, 0x70, 0x03, 0x02, 0x02, 0xd6, 0xe4, 0x90, 0x7f, 0xc5, 0xf0, 0x90, 0x10,   \
        0xf5, 0x01, 0x7f, 0xb4, 0xe0, 0x20, 0xe3, 0xf9, 0x90, 0x7f, 0xc5, 0xe0, 0x75, 0x0c, 0x00, 0xf5, 0x0d, 0xe4,   \
        0x10, 0x05, 0x02, 0xfc, 0xfd, 0xc3, 0xed, 0x95, 0x0d, 0xec, 0x95, 0x0c, 0x50, 0x1f, 0x74, 0xc0, 0x2d, 0xf5,   \
        0x82, 0x10, 0x15, 0x02, 0xe4, 0x34, 0x7e, 0xf5, 0x83, 0xe0, 0xff, 0xe5, 0x09, 0x2d, 0xf5, 0x82, 0xe5, 0x08,   \
        0x3c, 0xf5, 0x10, 0x25, 0x02, 0x83, 0xef, 0xf0, 0x0d, 0xbd, 0x00, 0x01, 0x0c, 0x80, 0xd8, 0xe5, 0x0d, 0x25,   \
        0x09, 0xf5, 0x09, 0x10, 0x35, 0x02, 0xe5, 0x0c, 0x35, 0x08, 0xf5, 0x08, 0xc3, 0xe5, 0x0b, 0x95, 0x0d, 0xf5,   \
        0x0b, 0xe5, 0x0a, 0x95, 0x10, 0x45, 0x02, 0x0c, 0xf5, 0x0a, 0x80, 0x9c, 0x90, 0x7f, 0xe8, 0xe0, 0x64, 0xc0,   \
        0x60, 0x03, 0x02, 0x02, 0xd6, 0x10, 0x55, 0x02, 0xe5, 0x0b, 0x45, 0x0a, 0x60, 0x7b, 0xc3, 0xe5, 0x0b, 0x94,   \
        0x40, 0xe5, 0x0a, 0x94, 0x00, 0x50, 0x10, 0x65, 0x02, 0x08, 0x85, 0x0a, 0x0c, 0x85, 0x0b, 0x0d, 0x80, 0x06,   \
        0x75, 0x0c, 0x00, 0x75, 0x0d, 0x40, 0xe4, 0x10, 0x75, 0x02, 0xfc, 0xfd, 0xc3, 0xed, 0x95, 0x0d, 0xec, 0x95,   \
        0x0c, 0x50, 0x1f, 0xe5, 0x09, 0x2d, 0xf5, 0x82, 0x10, 0x85, 0x02, 0xe5, 0x08, 0x3c, 0xf5, 0x83, 0xe0, 0xff,   \
        0x74, 0x00, 0x2d, 0xf5, 0x82, 0xe4, 0x34, 0x7f, 0xf5, 0x10, 0x95, 0x02, 0x83, 0xef, 0xf0, 0x0d, 0xbd, 0x00,   \
        0x01, 0x0c, 0x80, 0xd8, 0x90, 0x7f, 0xb5, 0xe5, 0x0d, 0xf0, 0x10, 0xa5, 0x02, 0x25, 0x09, 0xf5, 0x09, 0xe5,   \
        0x0c, 0x35, 0x08, 0xf5, 0x08, 0xc3, 0xe5, 0x0b, 0x95, 0x0d, 0xf5, 0x10, 0xb5, 0x02, 0x0b, 0xe5, 0x0a, 0x95,   \
        0x0c, 0xf5, 0x0a, 0x90, 0x7f, 0xb4, 0xe0, 0x30, 0xe2, 0x92, 0x80, 0xf7, 0x10, 0xc5, 0x02, 0x90, 0x7f, 0xe9,   \
        0xe0, 0xb4, 0xac, 0x0a, 0xe4, 0x90, 0x7f, 0x00, 0xf0, 0x90, 0x7f, 0xb5, 0x04, 0x08, 0xd5, 0x02, 0xf0, 0x90,   \
        0x7f, 0xb4, 0xe0, 0x44, 0x02, 0xf0, 0x01, 0xdd, 0x02, 0x22, 0x10, 0x80, 0x00, 0x90, 0xe6, 0xb9, 0xe0, 0x64,   \
        0xa3, 0x60, 0x03, 0x02, 0x01, 0x98, 0xa3, 0xe0, 0x75, 0x08, 0x00, 0x10, 0x90, 0x00, 0xf5, 0x09, 0xa3, 0xe0,   \
        0xfe, 0xe4, 0xee, 0x42, 0x08, 0x90, 0xe6, 0xbe, 0xe0, 0x75, 0x0a, 0x00, 0x10, 0xa0, 0x00, 0xf5, 0x0b, 0xa3,   \
        0xe0, 0xfe, 0xe4, 0xee, 0x42, 0x0a, 0x90, 0xe6, 0xb8, 0xe0, 0x64, 0x40, 0x70, 0x10, 0xb0, 0x00, 0x66, 0xe5,   \
        0x0b, 0x45, 0x0a, 0x70, 0x03, 0x02, 0x01, 0xad, 0xe4, 0x90, 0xe6, 0x8a, 0xf0, 0xa3, 0x10, 0xc0, 0x00, 0xf0,   \
        0x90, 0xe6, 0xa0, 0xe0, 0x20, 0xe1, 0xf9, 0x90, 0xe6, 0x8b, 0xe0, 0x75, 0x0c, 0x00, 0xf5, 0x10, 0xd0, 0x00,   \
        0x0d, 0xe4, 0xfc, 0xfd, 0xc3, 0xed, 0x95, 0x0d, 0xec, 0x95, 0x0c, 0x50, 0x1f, 0x74, 0x40, 0x2d, 0x10, 0xe0,   \
        0x00, 0xf5, 0x82, 0xe4, 0x34, 0xe7, 0xf5, 0x83, 0xe0, 0xff, 0xe5, 0x09, 0x2d, 0xf5, 0x82, 0xe5, 0x08, 0x10,   \
        0xf0, 0x00, 0x3c, 0xf5, 0x83, 0xef, 0xf0, 0x0d, 0xbd, 0x00, 0x01, 0x0c, 0x80, 0xd8, 0xe5, 0x0d, 0x25, 0x09,   \
        0x10, 0x00, 0x01, 0xf5, 0x09, 0xe5, 0x0c, 0x35, 0x08, 0xf5, 0x08, 0xc3, 0xe5, 0x0b, 0x95, 0x0d, 0xf5, 0x0b,   \
        0xe5, 0x10, 0x10, 0x01, 0x0a, 0x95, 0x0c, 0xf5, 0x0a, 0x80, 0x9a, 0x90, 0xe6, 0xb8, 0xe0, 0x64, 0xc0, 0x60,   \
        0x03, 0x02, 0x10, 0x20, 0x01, 0x01, 0xad, 0xe5, 0x0b, 0x45, 0x0a, 0x70, 0x03, 0x02, 0x01, 0xad, 0xc3, 0xe5,   \
        0x0b, 0x94, 0x40, 0x10, 0x30, 0x01, 0xe5, 0x0a, 0x94, 0x00, 0x50, 0x08, 0x85, 0x0a, 0x0c, 0x85, 0x0b, 0x0d,   \
        0x80, 0x06, 0x75, 0x0c, 0x10, 0x40, 0x01, 0x00, 0x75, 0x0d, 0x40, 0xe4, 0xfc, 0xfd, 0xc3, 0xed, 0x95, 0x0d,   \
        0xec, 0x95, 0x0c, 0x50, 0x1f, 0x10, 0x50, 0x01, 0xe5, 0x09, 0x2d, 0xf5, 0x82, 0xe5, 0x08, 0x3c, 0xf5, 0x83,   \
        0xe0, 0xff, 0x74, 0x40, 0x2d, 0xf5, 0x10, 0x60, 0x01, 0x82, 0xe4, 0x34, 0xe7, 0xf5, 0x83, 0xef, 0xf0, 0x0d,   \
        0xbd, 0x00, 0x01, 0x0c, 0x80, 0xd8, 0xe4, 0x10, 0x70, 0x01, 0x90, 0xe6, 0x8a, 0xf0, 0xa3, 0xe5, 0x0d, 0xf0,   \
        0x25, 0x09, 0xf5, 0x09, 0xe5, 0x0c, 0x35, 0x08, 0x10, 0x80, 0x01, 0xf5, 0x08, 0xc3, 0xe5, 0x0b, 0x95, 0x0d,   \
        0xf5, 0x0b, 0xe5, 0x0a, 0x95, 0x0c, 0xf5, 0x0a, 0x90, 0x10, 0x90, 0x01, 0xe6, 0xa0, 0xe0, 0x30, 0xe1, 0x8c,   \
        0x80, 0xf7, 0x90, 0xe6, 0xb9, 0xe0, 0xb4, 0xac, 0x0e, 0x90, 0x10, 0xa0, 0x01, 0xe7, 0x40, 0x74, 0x01, 0xf0,   \
        0xe4, 0x90, 0xe6, 0x8a, 0xf0, 0xa3, 0x04, 0xf0, 0x90, 0xe6, 0xa0, 0x04, 0xb0, 0x01, 0xe0, 0x44, 0x80, 0xf0,   \
        0x01, 0xb4, 0x01, 0x22, 0x10, 0xde, 0x02, 0xc2, 0x01, 0x12, 0x03, 0x68, 0x92, 0x00, 0x90, 0x7f, 0x95, 0xe0,   \
        0x44, 0xc0, 0xf0, 0xd2, 0xe8, 0x10, 0xee, 0x02, 0x30, 0x00, 0x08, 0x90, 0xe6, 0x5d, 0x74, 0xff, 0xf0, 0x80,   \
        0x06, 0x90, 0x7f, 0xab, 0x74, 0xff, 0x10, 0xfe, 0x02, 0xf0, 0x30, 0x00, 0x08, 0x90, 0xe6, 0x68, 0x74, 0x08,   \
        0xf0, 0x80, 0x07, 0x90, 0x7f, 0xaf, 0xe0, 0x10, 0x0e, 0x03, 0x44, 0x01, 0xf0, 0x30, 0x00, 0x08, 0x90, 0xe6,   \
        0x5c, 0x74, 0x01, 0xf0, 0x80, 0x06, 0x90, 0x7f, 0x10, 0x1e, 0x03, 0xae, 0x74, 0x01, 0xf0, 0xd2, 0xaf, 0x30,   \
        0x01, 0xfd, 0x30, 0x00, 0x05, 0x12, 0x00, 0x80, 0x80, 0x08, 0x2e, 0x03, 0x03, 0x12, 0x01, 0xb5, 0xc2, 0x01,   \
        0x80, 0xee, 0x03, 0x03, 0x00, 0x02, 0x03, 0x36, 0x10, 0x36, 0x03, 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0,   \
        0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0xd2, 0x10, 0x46, 0x03, 0x01, 0x53, 0x91, 0xef, 0x30, 0x00,   \
        0x08, 0x90, 0xe6, 0x5d, 0x74, 0x01, 0xf0, 0x80, 0x06, 0x90, 0x10, 0x56, 0x03, 0x7f, 0xab, 0x74, 0x01, 0xf0,   \
        0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0x02, 0x66, 0x03, 0xe0, 0x32, 0x03, 0x43,   \
        0x00, 0x02, 0x04, 0x00, 0x04, 0x00, 0x04, 0x02, 0x03, 0x36, 0x00, 0x03, 0x00, 0x00, 0x02, 0x03, 0x7f, 0x0c,   \
        0x7f, 0x03, 0x78, 0x7f, 0xe4, 0xf6, 0xd8, 0xfd, 0x75, 0x81, 0x20, 0x02, 0x02, 0xde, 0x00

#define SSAG_FIRMWARE                                                                                                 \
    0x10, 0x66, 0x00, 0x12, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x40, 0x56, 0x18, 0x12, 0x00, 0x00, 0x00, 0x01, 0x02, \
        0x10, 0x76, 0x00, 0x00, 0x02, 0x0a, 0x06, 0x00, 0x02, 0x00, 0x00, 0x00, 0x40, 0x01, 0x00, 0x09, 0x02, 0x20,   \
        0x00, 0x10, 0x86, 0x00, 0x01, 0x01, 0x00, 0x80, 0xaf, 0x09, 0x04, 0x00, 0x00, 0x02, 0xff, 0x00, 0x00, 0x00,   \
        0x07, 0x05, 0x10, 0x96, 0x00, 0x01, 0x02, 0x40, 0x00, 0x00, 0x07, 0x05, 0x82, 0x02, 0x00, 0x04, 0x00, 0x09,   \
        0x02, 0x20, 0x00, 0x10, 0xa6, 0x00, 0x01, 0x01, 0x00, 0x80, 0xaf, 0x09, 0x04, 0x00, 0x00, 0x02, 0xff, 0x00,   \
        0x00, 0x00, 0x07, 0x05, 0x10, 0xb6, 0x00, 0x01, 0x02, 0x40, 0x00, 0x00, 0x07, 0x05, 0x82, 0x02, 0x40, 0x00,   \
        0x00, 0x04, 0x03, 0x09, 0x04, 0x10, 0xc6, 0x00, 0x0c, 0x03, 0x30, 0x00, 0x72, 0x00, 0x69, 0x00, 0x6f, 0x00,   \
        0x6e, 0x00, 0x2a, 0x03, 0x53, 0x00, 0x10, 0xd6, 0x00, 0x74, 0x00, 0x61, 0x00, 0x72, 0x00, 0x53, 0x00, 0x68,   \
        0x00, 0x6f, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x10, 0xe6, 0x00, 0x20, 0x00, 0x41, 0x00, 0x75, 0x00, 0x74, 0x00,   \
        0x6f, 0x00, 0x67, 0x00, 0x75, 0x00, 0x69, 0x00, 0x06, 0xf6, 0x00, 0x64, 0x00, 0x65, 0x00, 0x72, 0x00, 0x04,   \
        0x00, 0x02, 0x02, 0x02, 0xc6, 0x32, 0x01, 0x0b, 0x02, 0x32, 0x01, 0x13, 0x02, 0x32, 0x01, 0x1b, 0x02, 0x32,   \
        0x01, 0x23, 0x02, 0x32, 0x01, 0x2b, 0x02, 0x32, 0x01, 0x33, 0x02, 0x32, 0x01, 0x3b, 0x02, 0x32, 0x01, 0x43,   \
        0x02, 0x32, 0x01, 0x4b, 0x02, 0x32, 0x01, 0x53, 0x02, 0x32, 0x01, 0x5b, 0x02, 0x32, 0x01, 0x63, 0x02, 0x32,   \
        0x03, 0x6b, 0x02, 0x02, 0x04, 0xde, 0x03, 0x73, 0x02, 0x02, 0x05, 0x33, 0x03, 0x7b, 0x02, 0x02, 0x05, 0x49,   \
        0x03, 0x83, 0x02, 0x02, 0x05, 0x5f, 0x03, 0x8b, 0x02, 0x02, 0x05, 0x75, 0x03, 0x93, 0x02, 0x02, 0x05, 0x8b,   \
        0x03, 0x9b, 0x02, 0x02, 0x05, 0xa1, 0x03, 0xa3, 0x02, 0x02, 0x05, 0xb7, 0x03, 0xab, 0x02, 0x02, 0x05, 0xcd,   \
        0x03, 0xb3, 0x02, 0x02, 0x05, 0xe3, 0x03, 0xbb, 0x02, 0x02, 0x05, 0xf9, 0x03, 0xc3, 0x02, 0x02, 0x06, 0x0f,   \
        0x10, 0x2b, 0x03, 0x02, 0x03, 0x2e, 0x12, 0x03, 0x33, 0x80, 0xfe, 0xc2, 0x02, 0xc2, 0x00, 0xc2, 0x01, 0x12,   \
        0x08, 0x10, 0x3b, 0x03, 0x03, 0xd2, 0xe8, 0x43, 0xd8, 0x20, 0x90, 0xe6, 0x5c, 0xe0, 0xfa, 0x44, 0x3d, 0xf0,   \
        0xd2, 0xaf, 0x10, 0x4b, 0x03, 0xd2, 0x0d, 0x12, 0x16, 0x40, 0x90, 0xe6, 0x80, 0xe0, 0xfa, 0x54, 0xf7, 0xf0,   \
        0x53, 0x8e, 0xf8, 0x10, 0x5b, 0x03, 0xc2, 0x02, 0x12, 0x0a, 0x2d, 0x30, 0x07, 0x05, 0x12, 0x03, 0x6d, 0xc2,   \
        0x07, 0x12, 0x0d, 0xa3, 0x10, 0x6b, 0x03, 0x80, 0xf3, 0x90, 0xe6, 0xb9, 0xe0, 0xfa, 0x24, 0xf4, 0x50, 0x03,   \
        0x02, 0x04, 0xd5, 0xea, 0x2a, 0x10, 0x7b, 0x03, 0x2a, 0x90, 0x03, 0x80, 0x73, 0x02, 0x04, 0x88, 0x02, 0x04,   \
        0x76, 0x02, 0x04, 0xd5, 0x02, 0x04, 0x10, 0x8b, 0x03, 0x76, 0x02, 0x04, 0xd5, 0x02, 0x04, 0xd5, 0x02, 0x03,   \
        0xa4, 0x02, 0x04, 0x76, 0x02, 0x04, 0x80, 0x10, 0x9b, 0x03, 0x02, 0x04, 0x76, 0x02, 0x04, 0x78, 0x02, 0x04,   \
        0x76, 0x90, 0xe6, 0xbb, 0xe0, 0xfa, 0xba, 0x01, 0x10, 0xab, 0x03, 0x02, 0x80, 0x17, 0xba, 0x02, 0x02, 0x80,   \
        0x40, 0xba, 0x03, 0x02, 0x80, 0x67, 0xba, 0x06, 0x02, 0x10, 0xbb, 0x03, 0x80, 0x1f, 0xba, 0x07, 0x02, 0x80,   \
        0x47, 0x02, 0x04, 0xd5, 0x7a, 0x66, 0x7b, 0x00, 0x90, 0xe6, 0x10, 0xcb, 0x03, 0xb3, 0xeb, 0xf0, 0x7a, 0x66,   \
        0x7b, 0x00, 0x7b, 0x00, 0x90, 0xe6, 0xb4, 0xea, 0xf0, 0x02, 0x04, 0x10, 0xdb, 0x03, 0xd5, 0x7a, 0x78, 0x7b,   \
        0x00, 0x90, 0xe6, 0xb3, 0xeb, 0xf0, 0x7a, 0x78, 0x7b, 0x00, 0x7b, 0x00, 0x10, 0xeb, 0x03, 0x90, 0xe6, 0xb4,   \
        0xea, 0xf0, 0x02, 0x04, 0xd5, 0x90, 0xe0, 0x00, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0x10, 0xfb, 0x03, 0x90, 0xe6,   \
        0xb3, 0xf0, 0x7b, 0x00, 0x90, 0xe6, 0xb4, 0xea, 0xf0, 0x02, 0x04, 0xd5, 0x90, 0xe0, 0x10, 0x0b, 0x04, 0x00,   \
        0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0x90, 0xe6, 0xb3, 0xf0, 0x7b, 0x00, 0x90, 0xe6, 0xb4, 0xea, 0x10, 0x1b, 0x04,   \
        0xf0, 0x02, 0x04, 0xd5, 0x90, 0xe6, 0xba, 0xe0, 0xfa, 0x60, 0x0d, 0xba, 0x01, 0x02, 0x80, 0x1f, 0x10, 0x2b,   \
        0x04, 0xba, 0x02, 0x02, 0x80, 0x30, 0x02, 0x04, 0xd5, 0x7a, 0xc2, 0x7b, 0x00, 0x90, 0xe6, 0xb3, 0xeb, 0x10,   \
        0x3b, 0x04, 0xf0, 0x7a, 0xc2, 0x7b, 0x00, 0x7b, 0x00, 0x90, 0xe6, 0xb4, 0xea, 0xf0, 0x02, 0x04, 0xd5, 0x7a,   \
        0x10, 0x4b, 0x04, 0xc6, 0x7b, 0x00, 0x90, 0xe6, 0xb3, 0xeb, 0xf0, 0x7a, 0xc6, 0x7b, 0x00, 0x7b, 0x00, 0x90,   \
        0xe6, 0x10, 0x5b, 0x04, 0xb4, 0xea, 0xf0, 0x80, 0x75, 0x7a, 0xd2, 0x7b, 0x00, 0x90, 0xe6, 0xb3, 0xeb, 0xf0,   \
        0x7a, 0xd2, 0x10, 0x6b, 0x04, 0x7b, 0x00, 0x7b, 0x00, 0x90, 0xe6, 0xb4, 0xea, 0xf0, 0x80, 0x5f, 0x80, 0x5d,   \
        0x75, 0x82, 0x00, 0x10, 0x7b, 0x04, 0x12, 0x0a, 0xc4, 0x80, 0x55, 0x75, 0x82, 0x01, 0x12, 0x0a, 0xc4, 0x80,   \
        0x4d, 0x90, 0xe6, 0xb8, 0x10, 0x8b, 0x04, 0xe0, 0xfa, 0xba, 0x80, 0x02, 0x80, 0x0a, 0xba, 0x81, 0x02, 0x80,   \
        0x05, 0xba, 0x82, 0x3b, 0x80, 0x10, 0x9b, 0x04, 0x08, 0x90, 0x00, 0x00, 0x12, 0x0a, 0xd7, 0x80, 0x31, 0x90,   \
        0xe6, 0xbc, 0xe0, 0xfa, 0x53, 0x02, 0x10, 0xab, 0x04, 0x7e, 0x90, 0xe6, 0xbc, 0xe0, 0xfb, 0xc3, 0x74, 0x80,   \
        0x9b, 0xe4, 0x33, 0xfb, 0x4a, 0x90, 0x16, 0x10, 0xbb, 0x04, 0xd5, 0x93, 0xfa, 0x33, 0x95, 0xe0, 0xfb, 0x74,   \
        0xa1, 0x2a, 0xfa, 0x74, 0xe6, 0x3b, 0xfb, 0x74, 0x10, 0xcb, 0x04, 0x01, 0x5a, 0xf5, 0x82, 0x75, 0x83, 0x00,   \
        0x12, 0x0a, 0xd7, 0x90, 0xe6, 0xa0, 0xe0, 0xfa, 0x44, 0x03, 0xdb, 0x04, 0x80, 0xf0, 0x22, 0x0a, 0xd5, 0x16,   \
        0x00, 0x01, 0x02, 0x02, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x10, 0xde, 0x04, 0xc0, 0xe0, 0xc0, 0xf0, 0xc0,   \
        0x82, 0xc0, 0x83, 0xc0, 0x02, 0xc0, 0x03, 0xc0, 0x04, 0xc0, 0x05, 0x10, 0xee, 0x04, 0xc0, 0x06, 0xc0, 0x07,   \
        0xc0, 0x00, 0xc0, 0x01, 0xc0, 0xd0, 0x75, 0xd0, 0x00, 0x12, 0x0d, 0xae, 0x10, 0xfe, 0x04, 0x92, 0x03, 0xa2,   \
        0x03, 0x92, 0x07, 0x20, 0x03, 0x08, 0x90, 0xe6, 0xa0, 0xe0, 0xfa, 0x44, 0x80, 0x10, 0x0e, 0x05, 0xf0, 0x53,   \
        0x91, 0xef, 0x90, 0xe6, 0x5d, 0x74, 0x01, 0xf0, 0xd0, 0xd0, 0xd0, 0x01, 0xd0, 0x00, 0x10, 0x1e, 0x05, 0xd0,   \
        0x07, 0xd0, 0x06, 0xd0, 0x05, 0xd0, 0x04, 0xd0, 0x03, 0xd0, 0x02, 0xd0, 0x83, 0xd0, 0x82, 0x10, 0x2e, 0x05,   \
        0xd0, 0xf0, 0xd0, 0xe0, 0x32, 0xc0, 0xe0, 0xc0, 0x82, 0xc0, 0x83, 0x53, 0x91, 0xef, 0x90, 0xe6, 0x10, 0x3e,   \
        0x05, 0x5d, 0x74, 0x02, 0xf0, 0xd0, 0x83, 0xd0, 0x82, 0xd0, 0xe0, 0x32, 0xc0, 0xe0, 0xc0, 0x82, 0xc0, 0x10,   \
        0x4e, 0x05, 0x83, 0x53, 0x91, 0xef, 0x90, 0xe6, 0x5d, 0x74, 0x04, 0xf0, 0xd0, 0x83, 0xd0, 0x82, 0xd0, 0xe0,   \
        0x10, 0x5e, 0x05, 0x32, 0xc0, 0xe0, 0xc0, 0x82, 0xc0, 0x83, 0x53, 0x91, 0xef, 0x90, 0xe6, 0x5d, 0x74, 0x08,   \
        0xf0, 0x10, 0x6e, 0x05, 0xd0, 0x83, 0xd0, 0x82, 0xd0, 0xe0, 0x32, 0xc0, 0xe0, 0xc0, 0x82, 0xc0, 0x83, 0x53,   \
        0x91, 0xef, 0x10, 0x7e, 0x05, 0x90, 0xe6, 0x5d, 0x74, 0x10, 0xf0, 0xd0, 0x83, 0xd0, 0x82, 0xd0, 0xe0, 0x32,   \
        0xc0, 0xe0, 0xc0, 0x10, 0x8e, 0x05, 0x82, 0xc0, 0x83, 0x53, 0x91, 0xef, 0x90, 0xe6, 0x5d, 0x74, 0x20, 0xf0,   \
        0xd0, 0x83, 0xd0, 0x82, 0x10, 0x9e, 0x05, 0xd0, 0xe0, 0x32, 0xc0, 0xe0, 0xc0, 0x82, 0xc0, 0x83, 0x53, 0x91,   \
        0xef, 0x90, 0xe6, 0x5d, 0x74, 0x10, 0xae, 0x05, 0x40, 0xf0, 0xd0, 0x83, 0xd0, 0x82, 0xd0, 0xe0, 0x32, 0xc0,   \
        0xe0, 0xc0, 0x82, 0xc0, 0x83, 0x53, 0x10, 0xbe, 0x05, 0x91, 0xef, 0x90, 0xe6, 0x5d, 0x74, 0x80, 0xf0, 0xd0,   \
        0x83, 0xd0, 0x82, 0xd0, 0xe0, 0x32, 0xc0, 0x10, 0xce, 0x05, 0xe0, 0xc0, 0x82, 0xc0, 0x83, 0x53, 0x91, 0xef,   \
        0x90, 0xe6, 0x5f, 0x74, 0x01, 0xf0, 0xd0, 0x83, 0x10, 0xde, 0x05, 0xd0, 0x82, 0xd0, 0xe0, 0x32, 0xc0, 0xe0,   \
        0xc0, 0x82, 0xc0, 0x83, 0x53, 0x91, 0xef, 0x90, 0xe6, 0x10, 0xee, 0x05, 0x5f, 0x74, 0x02, 0xf0, 0xd0, 0x83,   \
        0xd0, 0x82, 0xd0, 0xe0, 0x32, 0xc0, 0xe0, 0xc0, 0x82, 0xc0, 0x10, 0xfe, 0x05, 0x83, 0x53, 0x91, 0xef, 0x90,   \
        0xe6, 0x5f, 0x74, 0x04, 0xf0, 0xd0, 0x83, 0xd0, 0x82, 0xd0, 0xe0, 0x10, 0x0e, 0x06, 0x32, 0xc0, 0xe0, 0xc0,   \
        0x82, 0xc0, 0x83, 0xd2, 0x08, 0x90, 0xe6, 0x8d, 0xe4, 0xf0, 0x53, 0x91, 0x10, 0x1e, 0x06, 0xef, 0x90, 0xe6,   \
        0x5f, 0x74, 0x08, 0xf0, 0xd0, 0x83, 0xd0, 0x82, 0xd0, 0xe0, 0x32, 0xc2, 0x81, 0x10, 0x2e, 0x06, 0x90, 0xe6,   \
        0xf5, 0x74, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0xc0, 0x74, 0x55, 0xf0, 0x00, 0x10, 0x3e, 0x06, 0x00,   \
        0x00, 0x90, 0xe6, 0x04, 0x74, 0x80, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x04, 0x74, 0x02, 0x10, 0x4e, 0x06,   \
        0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x04, 0xe4, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x18, 0xe4, 0x10, 0x5e,   \
        0x06, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0xce, 0xe4, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe0, 0x38, 0xe0, 0x10,   \
        0x6e, 0x06, 0xfa, 0x90, 0xe6, 0xcf, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe0, 0x37, 0xe0, 0xfa, 0x90, 0xe6, 0xd0,   \
        0x10, 0x7e, 0x06, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe0, 0x36, 0xe0, 0xfa, 0x90, 0xe6, 0xd1, 0xf0, 0x00, 0x00,   \
        0x00, 0x10, 0x8e, 0x06, 0x75, 0xbb, 0x04, 0x90, 0xe0, 0x32, 0xe4, 0xf0, 0xa3, 0xf0, 0xa3, 0xf0, 0xa3, 0xf0,   \
        0x22, 0xe5, 0x10, 0x9e, 0x06, 0xbb, 0x30, 0xe7, 0xfb, 0x90, 0xe6, 0x48, 0x74, 0x52, 0xf0, 0x90, 0xe6, 0x18,   \
        0x74, 0x0c, 0xf0, 0x10, 0xae, 0x06, 0x00, 0x00, 0x00, 0xd2, 0x81, 0x90, 0xe6, 0x04, 0x74, 0x80, 0xf0, 0x00,   \
        0x00, 0x00, 0x90, 0xe6, 0x10, 0xbe, 0x06, 0x04, 0x74, 0x02, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x04, 0xe4,   \
        0xf0, 0x00, 0x00, 0x00, 0x22, 0x10, 0xce, 0x06, 0x90, 0xe6, 0xf5, 0x74, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x90,   \
        0xe6, 0xc0, 0x74, 0x55, 0xf0, 0x00, 0x10, 0xde, 0x06, 0x00, 0x00, 0x90, 0xe6, 0x04, 0x74, 0x80, 0xf0, 0x00,   \
        0x00, 0x00, 0x90, 0xe6, 0x04, 0x74, 0x02, 0x10, 0xee, 0x06, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x04, 0xe4,   \
        0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x18, 0xe4, 0x10, 0xfe, 0x06, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0xce,   \
        0xe4, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0xcf, 0xe4, 0x10, 0x0e, 0x07, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe0,   \
        0x1f, 0xe0, 0xfa, 0x90, 0xe6, 0xd0, 0xf0, 0x00, 0x00, 0x00, 0x10, 0x1e, 0x07, 0x90, 0xe0, 0x1e, 0xe0, 0xfa,   \
        0x90, 0xe6, 0xd1, 0xf0, 0x00, 0x00, 0x00, 0x75, 0xbb, 0x04, 0x00, 0x10, 0x2e, 0x07, 0x00, 0x00, 0xe5, 0xbb,   \
        0x30, 0xe7, 0xfb, 0x90, 0xe6, 0x48, 0x74, 0x52, 0xf0, 0x90, 0xe6, 0x18, 0x10, 0x3e, 0x07, 0x74, 0x0c, 0xf0,   \
        0x00, 0x00, 0x00, 0x90, 0xe6, 0x04, 0x74, 0x80, 0xf0, 0x00, 0x00, 0x00, 0x90, 0x10, 0x4e, 0x07, 0xe6, 0x04,   \
        0x74, 0x02, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x04, 0xe4, 0xf0, 0x00, 0x00, 0x00, 0x10, 0x5e, 0x07, 0x22,   \
        0xc2, 0x81, 0x30, 0x0b, 0x08, 0x90, 0xe6, 0x18, 0x74, 0x0d, 0xf0, 0x80, 0x06, 0x90, 0xe6, 0x10, 0x6e, 0x07,   \
        0x18, 0x74, 0x0c, 0xf0, 0x90, 0xe6, 0xf5, 0x74, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0xc0, 0x10, 0x7e,   \
        0x07, 0xe4, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x04, 0x74, 0x80, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x10,   \
        0x8e, 0x07, 0x04, 0x74, 0x02, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x04, 0xe4, 0xf0, 0x00, 0x00, 0x00, 0x90,   \
        0x10, 0x9e, 0x07, 0xe6, 0xce, 0xe4, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe0, 0x38, 0xe0, 0xfa, 0x90, 0xe6, 0xcf,   \
        0xf0, 0x10, 0xae, 0x07, 0x00, 0x00, 0x00, 0x90, 0xe0, 0x37, 0xe0, 0xfa, 0x90, 0xe6, 0xd0, 0xf0, 0x00, 0x00,   \
        0x00, 0x90, 0x10, 0xbe, 0x07, 0xe0, 0x36, 0xe0, 0xfa, 0x90, 0xe6, 0xd1, 0xf0, 0x00, 0x00, 0x00, 0xc2, 0x8c,   \
        0x90, 0xe0, 0x32, 0x10, 0xce, 0x07, 0xe4, 0xf0, 0xa3, 0xf0, 0xa3, 0xf0, 0xa3, 0xf0, 0xd2, 0x8c, 0x90, 0xe6,   \
        0xcf, 0xe0, 0xfa, 0x70, 0x10, 0xde, 0x07, 0x0e, 0x90, 0xe6, 0xd0, 0xe0, 0xfa, 0x70, 0x07, 0x90, 0xe6, 0xd1,   \
        0xe0, 0xfa, 0x60, 0x0d, 0x75, 0x10, 0xee, 0x07, 0xbb, 0x04, 0x00, 0x00, 0x00, 0xe5, 0xbb, 0x20, 0xe7, 0xe0,   \
        0x80, 0xf9, 0x90, 0xe6, 0x48, 0x74, 0x10, 0xfe, 0x07, 0x02, 0xf0, 0xd2, 0x81, 0x22, 0x90, 0xe6, 0x00, 0xe0,   \
        0xfa, 0x74, 0xe7, 0x5a, 0x90, 0xe6, 0x00, 0x10, 0x0e, 0x08, 0x44, 0x10, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6,   \
        0x0b, 0x74, 0x01, 0xf0, 0x00, 0x00, 0x00, 0x90, 0x10, 0x1e, 0x08, 0xe6, 0x12, 0x74, 0xe0, 0xf0, 0x00, 0x00,   \
        0x00, 0x90, 0xe6, 0x13, 0xe4, 0xf0, 0x00, 0x00, 0x00, 0x10, 0x2e, 0x08, 0x90, 0xe6, 0x14, 0xe4, 0xf0, 0x00,   \
        0x00, 0x00, 0x90, 0xe6, 0x15, 0xe4, 0xf0, 0x00, 0x00, 0x00, 0x10, 0x3e, 0x08, 0x90, 0xe6, 0x10, 0x74, 0xa0,   \
        0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0xd2, 0x74, 0x02, 0xf0, 0x00, 0x10, 0x4e, 0x08, 0x00, 0x00, 0x90, 0xe6,   \
        0x04, 0x74, 0x80, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x04, 0x74, 0x02, 0x10, 0x5e, 0x08, 0xf0, 0x00, 0x00,   \
        0x00, 0x90, 0xe6, 0x04, 0xe4, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x8d, 0xe4, 0x10, 0x6e, 0x08, 0xf0, 0x90,   \
        0xe6, 0x01, 0x74, 0xca, 0xf0, 0x90, 0xe6, 0xf5, 0x74, 0xff, 0xf0, 0x90, 0xe6, 0xf3, 0x10, 0x7e, 0x08, 0x74,   \
        0xa0, 0xf0, 0x90, 0xe6, 0xc3, 0x74, 0x10, 0xf0, 0x90, 0xe6, 0xc1, 0xe4, 0xf0, 0x90, 0xe6, 0x10, 0x8e, 0x08,   \
        0xc2, 0xf0, 0x90, 0xe6, 0xf4, 0xf0, 0x75, 0xaf, 0x07, 0x75, 0x9d, 0xe4, 0x75, 0x9e, 0x00, 0x7a, 0x10, 0x9e,   \
        0x08, 0xdf, 0x7b, 0x16, 0x8b, 0x9a, 0x7a, 0xdf, 0x7b, 0x16, 0x7b, 0x00, 0x8a, 0x9b, 0x90, 0xe0, 0x02, 0x10,   \
        0xae, 0x08, 0x74, 0x40, 0xf0, 0x90, 0xe0, 0x02, 0xe0, 0xfa, 0x14, 0x90, 0xe0, 0x02, 0xf0, 0xea, 0x60, 0x0b,   \
        0x10, 0xbe, 0x08, 0x90, 0xe6, 0x7b, 0xe0, 0xfa, 0x90, 0xe6, 0x7c, 0xf0, 0x80, 0xe8, 0x90, 0xe6, 0xc6, 0xe4,   \
        0xf0, 0x10, 0xce, 0x08, 0x90, 0xe6, 0xc7, 0xf0, 0x90, 0xe6, 0xc8, 0xf0, 0x90, 0xe6, 0xc9, 0xf0, 0x90, 0xe6,   \
        0xca, 0xe4, 0x10, 0xde, 0x08, 0xf0, 0x90, 0xe6, 0xcb, 0xf0, 0x90, 0xe6, 0xcc, 0xf0, 0x90, 0xe6, 0xcd, 0xf0,   \
        0x90, 0xe6, 0x80, 0x10, 0xee, 0x08, 0xe0, 0xfa, 0x30, 0xe7, 0x0d, 0x90, 0x00, 0x9f, 0xe4, 0xf0, 0x90, 0x00,   \
        0xa0, 0x74, 0x02, 0xf0, 0x10, 0xfe, 0x08, 0x80, 0x0b, 0x90, 0x00, 0x9f, 0x74, 0x40, 0xf0, 0x90, 0x00, 0xa0,   \
        0xe4, 0xf0, 0x90, 0xe6, 0x78, 0x10, 0x0e, 0x09, 0xe0, 0xfa, 0x44, 0x80, 0xf0, 0x90, 0xe6, 0x79, 0x74, 0xa0,   \
        0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x10, 0x1e, 0x09, 0x79, 0x74, 0x05, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6,   \
        0x78, 0xe0, 0xfa, 0x44, 0x40, 0xf0, 0x12, 0x10, 0x2e, 0x09, 0x0b, 0xd6, 0x90, 0xe6, 0x78, 0xe0, 0xfa, 0x44,   \
        0x80, 0xf0, 0x90, 0xe6, 0x79, 0x74, 0xa1, 0xf0, 0x10, 0x3e, 0x09, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x78, 0xe0,   \
        0xfa, 0x44, 0x20, 0xf0, 0x90, 0xe6, 0x79, 0xe0, 0xfa, 0x10, 0x4e, 0x09, 0x90, 0x00, 0x72, 0xf0, 0x12, 0x0b,   \
        0xd6, 0x90, 0xe6, 0x78, 0xe0, 0xfa, 0x44, 0x40, 0xf0, 0x12, 0x10, 0x5e, 0x09, 0x0b, 0xd6, 0x90, 0xe6, 0x79,   \
        0xe0, 0x90, 0xe6, 0x78, 0xe0, 0xfa, 0x44, 0x40, 0xf0, 0x90, 0x00, 0x10, 0x6e, 0x09, 0x72, 0xe4, 0xf0, 0x90,   \
        0xe6, 0x78, 0xe0, 0xfa, 0x44, 0x80, 0xf0, 0x90, 0xe6, 0x79, 0x74, 0xa0, 0x10, 0x7e, 0x09, 0xf0, 0x12, 0x0b,   \
        0xd6, 0x90, 0xe6, 0x79, 0x74, 0x06, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x78, 0x10, 0x8e, 0x09, 0xe0, 0xfa,   \
        0x44, 0x40, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x78, 0xe0, 0xfa, 0x44, 0x80, 0xf0, 0x10, 0x9e, 0x09, 0x90,   \
        0xe6, 0x79, 0x74, 0xa1, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x78, 0xe0, 0xfa, 0x44, 0x20, 0x10, 0xae, 0x09,   \
        0xf0, 0x90, 0xe6, 0x79, 0xe0, 0xfa, 0x90, 0x00, 0x73, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x78, 0x10, 0xbe,   \
        0x09, 0xe0, 0xfa, 0x44, 0x40, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x79, 0xe0, 0x90, 0xe6, 0x78, 0xe0, 0x10,   \
        0xce, 0x09, 0xfa, 0x44, 0x40, 0xf0, 0x90, 0x00, 0x73, 0xe4, 0xf0, 0x90, 0x00, 0xa0, 0xe0, 0xfa, 0x90, 0xe6,   \
        0x10, 0xde, 0x09, 0x20, 0xf0, 0x00, 0x00, 0x00, 0x90, 0x00, 0x9f, 0xe0, 0xfa, 0x90, 0xe6, 0x21, 0xf0, 0x00,   \
        0x00, 0x10, 0xee, 0x09, 0x00, 0x90, 0xe0, 0x00, 0x74, 0x82, 0xf0, 0xa3, 0x74, 0x00, 0xf0, 0xd2, 0x00, 0x90,   \
        0xe6, 0x71, 0x10, 0xfe, 0x09, 0xe4, 0xf0, 0x75, 0xb4, 0x00, 0x90, 0xe6, 0x70, 0xe4, 0xf0, 0x75, 0xb2, 0xf3,   \
        0x90, 0xe6, 0x72, 0x10, 0x0e, 0x0a, 0xe4, 0xf0, 0x75, 0xb6, 0x00, 0x75, 0x80, 0x03, 0x75, 0xb5, 0x00, 0x75,   \
        0xb3, 0x00, 0x90, 0xe6, 0x10, 0x1e, 0x0a, 0x00, 0xe0, 0xfa, 0x44, 0x02, 0xf0, 0x90, 0xe6, 0x5e, 0xe0, 0xfa,   \
        0x44, 0x08, 0xf0, 0x22, 0xc2, 0x10, 0x2e, 0x0a, 0x0b, 0xc2, 0x06, 0x90, 0xe0, 0x0b, 0xe4, 0xf0, 0xa3, 0xf0,   \
        0xa3, 0xf0, 0xa3, 0xf0, 0xc2, 0x09, 0x10, 0x3e, 0x0a, 0x90, 0xe0, 0x13, 0xe4, 0xf0, 0xa3, 0xf0, 0xa3, 0xf0,   \
        0xa3, 0xf0, 0x90, 0xe0, 0x32, 0xe4, 0xf0, 0x10, 0x4e, 0x0a, 0xa3, 0xf0, 0xa3, 0xf0, 0xa3, 0xf0, 0xc2, 0x0a,   \
        0x90, 0xe0, 0x39, 0x74, 0xff, 0xf0, 0xa3, 0xf0, 0x10, 0x5e, 0x0a, 0xa3, 0x74, 0xff, 0xf0, 0xa3, 0xf0, 0x90,   \
        0xe0, 0x3d, 0x74, 0xff, 0xf0, 0xa3, 0xf0, 0xa3, 0x74, 0x10, 0x6e, 0x0a, 0xff, 0xf0, 0xa3, 0xf0, 0x12, 0x14,   \
        0x5c, 0x12, 0x0a, 0x9e, 0x90, 0xe0, 0x1b, 0xe4, 0xf0, 0x90, 0x0e, 0x7e, 0x0a, 0xe0, 0x2e, 0xf0, 0xa3, 0xf0,   \
        0xa3, 0xf0, 0xa3, 0xf0, 0xc2, 0x04, 0xc2, 0x05, 0x22, 0x10, 0xdf, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,   \
        0x01, 0x07, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x10, 0xef, 0x16, 0x01, 0x00, 0x01, 0x00, 0x01,   \
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x10, 0xff, 0x16, 0x01, 0x38, 0x01, 0x01,   \
        0x01, 0x01, 0x01, 0x07, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0f, 0x17, 0x00, 0x01, 0x00,   \
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x0c, 0x1f, 0x03, 0xc2, 0x04,   \
        0xc2, 0x05, 0xc2, 0x08, 0xc2, 0x09, 0xc2, 0x0a, 0xc2, 0x0b, 0x10, 0x8c, 0x0a, 0x7a, 0xff, 0x7b, 0xff, 0x8a,   \
        0x04, 0x8b, 0x05, 0x1a, 0xba, 0xff, 0x01, 0x1b, 0xec, 0x4d, 0x70, 0x10, 0x9c, 0x0a, 0xf3, 0x22, 0xc2, 0x80,   \
        0x12, 0x0a, 0x8c, 0xd2, 0x80, 0x90, 0xe0, 0x32, 0x74, 0xff, 0xf0, 0xa3, 0x10, 0xac, 0x0a, 0xf0, 0xa3, 0x74,   \
        0xff, 0xf0, 0xa3, 0x74, 0x7f, 0xf0, 0x90, 0xe0, 0x1d, 0x74, 0x01, 0xf0, 0x02, 0x02, 0xbc, 0x0a, 0x0b, 0x56,   \
        0x10, 0x1f, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   \
        0x00, 0x0b, 0x2f, 0x17, 0x18, 0x6a, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x00, 0x00,   \
        0x02, 0x03, 0x33, 0x02, 0xde, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x14, 0x74, 0x00, 0x00, 0x10, 0x10,   \
        0x00, 0x00, 0x00, 0x00, 0x02, 0xde, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xde, 0xad, 0x00, 0x00, 0x10,   \
        0x20, 0x00, 0x00, 0x00, 0x00, 0x02, 0xde, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xde, 0xad, 0x00, 0x00,   \
        0x10, 0x30, 0x00, 0x00, 0x00, 0x00, 0x02, 0xde, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xde, 0xad, 0x00,   \
        0x00, 0x10, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xde, 0xad,   \
        0x00, 0x00, 0x10, 0x50, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xde,   \
        0xad, 0x00, 0x00, 0x06, 0x60, 0x00, 0x00, 0x00, 0x00, 0x02, 0xde, 0xad, 0x10, 0x00, 0x01, 0x02, 0x04, 0xde,   \
        0x00, 0x02, 0x05, 0x33, 0x00, 0x02, 0x05, 0x49, 0x00, 0x02, 0x05, 0x5f, 0x00, 0x10, 0x10, 0x01, 0x02, 0x05,   \
        0x75, 0x00, 0x02, 0x05, 0x8b, 0x00, 0x02, 0x05, 0xa1, 0x00, 0x02, 0x05, 0xb7, 0x00, 0x10, 0x20, 0x01, 0x02,   \
        0x05, 0xcd, 0x00, 0x02, 0x05, 0xe3, 0x00, 0x02, 0x05, 0xf9, 0x00, 0x02, 0x06, 0x0f, 0x00, 0x10, 0x30, 0x01,   \
        0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x10, 0x40,   \
        0x01, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x10,   \
        0x50, 0x01, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00,   \
        0x10, 0x60, 0x01, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad,   \
        0x00, 0x10, 0x70, 0x01, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde,   \
        0xad, 0x00, 0x10, 0x80, 0x01, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02,   \
        0xde, 0xad, 0x00, 0x10, 0x90, 0x01, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00,   \
        0x02, 0xde, 0xad, 0x00, 0x10, 0xa0, 0x01, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad,   \
        0x00, 0x02, 0xde, 0xad, 0x00, 0x08, 0xb0, 0x01, 0x02, 0xde, 0xad, 0x00, 0x02, 0xde, 0xad, 0x00, 0x10, 0xbe,   \
        0x0a, 0x12, 0x06, 0x2c, 0x02, 0x06, 0x9d, 0xaa, 0x82, 0x90, 0xe7, 0x40, 0xea, 0xf0, 0x90, 0xe6, 0x8a, 0x10,   \
        0xce, 0x0a, 0xe4, 0xf0, 0x90, 0xe6, 0x8b, 0x74, 0x01, 0xf0, 0x22, 0xaa, 0x82, 0xab, 0x83, 0x8a, 0x04, 0x7d,   \
        0x10, 0xde, 0x0a, 0x00, 0x90, 0xe7, 0x40, 0xec, 0xf0, 0x8b, 0x02, 0x7b, 0x00, 0x90, 0xe7, 0x41, 0xea, 0xf0,   \
        0x90, 0x10, 0xee, 0x0a, 0xe6, 0x8a, 0xe4, 0xf0, 0x90, 0xe6, 0x8b, 0x74, 0x02, 0xf0, 0x22, 0xaa, 0x82, 0xab,   \
        0x83, 0xac, 0x10, 0xfe, 0x0a, 0xf0, 0xfd, 0x8a, 0x06, 0x7f, 0x00, 0x78, 0x00, 0x79, 0x00, 0x90, 0xe7, 0x40,   \
        0xee, 0xf0, 0x8b, 0x10, 0x0e, 0x0b, 0x02, 0x8c, 0x03, 0x8d, 0x04, 0x7d, 0x00, 0x8a, 0x06, 0x7f, 0x00, 0x78,   \
        0x00, 0x79, 0x00, 0x90, 0x10, 0x1e, 0x0b, 0xe7, 0x41, 0xee, 0xf0, 0x8b, 0x02, 0x8c, 0x03, 0x8d, 0x04, 0x7d,   \
        0x00, 0x8a, 0x06, 0x7f, 0x00, 0x10, 0x2e, 0x0b, 0x78, 0x00, 0x79, 0x00, 0x90, 0xe7, 0x42, 0xee, 0xf0, 0x8b,   \
        0x02, 0x8c, 0x03, 0x8d, 0x04, 0x7d, 0x10, 0x3e, 0x0b, 0x00, 0x7b, 0x00, 0x7c, 0x00, 0x7d, 0x00, 0x90, 0xe7,   \
        0x43, 0xea, 0xf0, 0x90, 0xe6, 0x8a, 0xe4, 0x10, 0x4e, 0x0b, 0xf0, 0x90, 0xe6, 0x8b, 0x74, 0x04, 0xf0, 0x22,   \
        0x90, 0xe0, 0x1d, 0xe0, 0xfa, 0x70, 0x1c, 0x90, 0x10, 0x5e, 0x0b, 0xe0, 0x22, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb,   \
        0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0xe0, 0x17, 0x10, 0x6e, 0x0b, 0xea, 0xf0, 0xa3, 0xeb, 0xf0, 0xa3,   \
        0xec, 0xf0, 0xa3, 0xed, 0xf0, 0x90, 0xe0, 0x1d, 0xe0, 0xfa, 0x10, 0x7e, 0x0b, 0xba, 0x01, 0x11, 0x90, 0xe0,   \
        0x17, 0x74, 0xc8, 0xf0, 0xa3, 0x74, 0x6a, 0xf0, 0xa3, 0x74, 0x18, 0x10, 0x8e, 0x0b, 0xf0, 0xa3, 0xe4, 0xf0,   \
        0x90, 0xe0, 0x17, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0x10, 0x9e, 0x0b, 0xe0, 0xfd, 0x8a,   \
        0x06, 0x7f, 0x00, 0x78, 0x00, 0x79, 0x00, 0x90, 0xe0, 0x36, 0xee, 0xf0, 0x8b, 0x10, 0xae, 0x0b, 0x02, 0x8c,   \
        0x03, 0x8d, 0x04, 0x7d, 0x00, 0x8a, 0x06, 0x7f, 0x00, 0x78, 0x00, 0x79, 0x00, 0x90, 0x10, 0xbe, 0x0b, 0xe0,   \
        0x37, 0xee, 0xf0, 0x8b, 0x02, 0x8c, 0x03, 0x8d, 0x04, 0x7d, 0x00, 0x7b, 0x00, 0x7c, 0x00, 0x10, 0xce, 0x0b,   \
        0x7d, 0x00, 0x90, 0xe0, 0x38, 0xea, 0xf0, 0x22, 0x7a, 0x64, 0x7b, 0x00, 0x8a, 0x04, 0x8b, 0x05, 0x10, 0xde,   \
        0x0b, 0x1a, 0xba, 0xff, 0x01, 0x1b, 0xec, 0x4d, 0x70, 0xf3, 0x22, 0x12, 0x0a, 0x9e, 0x90, 0xe0, 0x1d, 0x10,   \
        0xee, 0x0b, 0x74, 0x01, 0xf0, 0x12, 0x0b, 0x56, 0x7a, 0x40, 0x7b, 0xe7, 0x8b, 0x9a, 0x7a, 0x40, 0x7b, 0xe7,   \
        0x10, 0xfe, 0x0b, 0x7b, 0x00, 0x8a, 0x9b, 0x12, 0x06, 0x2c, 0x90, 0xe6, 0x78, 0xe0, 0xfa, 0x44, 0x80, 0xf0,   \
        0x90, 0x10, 0x0e, 0x0c, 0xe6, 0x79, 0x74, 0xba, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x79, 0x74, 0x2b, 0xf0,   \
        0x12, 0x0b, 0x10, 0x1e, 0x0c, 0xd6, 0x90, 0xe6, 0x7b, 0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x0b, 0xd6,   \
        0x90, 0xe6, 0x7b, 0x10, 0x2e, 0x0c, 0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x7b,   \
        0xe0, 0xfa, 0x90, 0xe6, 0x10, 0x3e, 0x0c, 0x79, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x7b, 0xe0, 0xfa, 0x90,   \
        0xe6, 0x79, 0xf0, 0x12, 0x0b, 0x10, 0x4e, 0x0c, 0xd6, 0x90, 0xe6, 0x7b, 0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0,   \
        0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x7b, 0x10, 0x5e, 0x0c, 0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x0b, 0xd6,   \
        0x90, 0xe6, 0x7b, 0xe0, 0xfa, 0x90, 0xe6, 0x10, 0x6e, 0x0c, 0x79, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x7b,   \
        0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x0b, 0x10, 0x7e, 0x0c, 0xd6, 0x90, 0xe6, 0x78, 0xe0, 0xfa, 0x44,   \
        0x40, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x78, 0xe0, 0x10, 0x8e, 0x0c, 0xfa, 0x44, 0x80, 0xf0, 0x90, 0xe6,   \
        0x79, 0x74, 0xba, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x79, 0x10, 0x9e, 0x0c, 0x74, 0x01, 0xf0, 0x12, 0x0b,   \
        0xd6, 0x90, 0xe6, 0x7b, 0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x10, 0xae, 0x0c, 0x0b, 0xd6, 0x90, 0xe6,   \
        0x7b, 0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x10, 0xbe, 0x0c, 0x7b, 0xe0, 0xfa,   \
        0x90, 0xe6, 0x79, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x7b, 0xe0, 0xfa, 0x90, 0x10, 0xce, 0x0c, 0xe6, 0x79,   \
        0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x7b, 0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x10, 0xde, 0x0c, 0x0b,   \
        0xd6, 0x90, 0xe6, 0x7b, 0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x10, 0xee, 0x0c,   \
        0x7b, 0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x7b, 0xe0, 0xfa, 0x90, 0x10, 0xfe,   \
        0x0c, 0xe6, 0x79, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x78, 0xe0, 0xfa, 0x44, 0x40, 0xf0, 0x12, 0x0b, 0x10,   \
        0x0e, 0x0d, 0xd6, 0x90, 0xe6, 0x78, 0xe0, 0xfa, 0x44, 0x80, 0xf0, 0x90, 0xe6, 0x79, 0x74, 0xba, 0xf0, 0x12,   \
        0x10, 0x1e, 0x0d, 0x0b, 0xd6, 0x90, 0xe6, 0x79, 0x74, 0x09, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x7b, 0xe0,   \
        0xfa, 0x10, 0x2e, 0x0d, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x7b, 0xe0, 0xfa, 0x90, 0xe6,   \
        0x79, 0xf0, 0x10, 0x3e, 0x0d, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x78, 0xe0, 0xfa, 0x44, 0x40, 0xf0, 0x90, 0xe6,   \
        0x78, 0xe0, 0xfa, 0x10, 0x4e, 0x0d, 0x44, 0x80, 0xf0, 0x90, 0xe6, 0x79, 0x74, 0xba, 0xf0, 0x12, 0x0b, 0xd6,   \
        0x90, 0xe6, 0x79, 0x74, 0x10, 0x5e, 0x0d, 0x62, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x79, 0x74, 0x1c, 0xf0,   \
        0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x10, 0x6e, 0x0d, 0x79, 0x74, 0x9e, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x78,   \
        0xe0, 0xfa, 0x44, 0x40, 0xf0, 0x12, 0x10, 0x7e, 0x0d, 0x06, 0x9d, 0x90, 0xe0, 0x1d, 0xe4, 0xf0, 0x12, 0x0b,   \
        0x56, 0x12, 0x0a, 0xbe, 0x90, 0xe0, 0x32, 0x10, 0x8e, 0x0d, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc,   \
        0xa3, 0xe0, 0xfd, 0x90, 0xe0, 0x1b, 0xea, 0xf0, 0x10, 0x9e, 0x0d, 0xe0, 0x24, 0x01, 0xf0, 0x22, 0x30, 0x0a,   \
        0x07, 0x12, 0x07, 0x5f, 0xc2, 0x0a, 0xc2, 0x09, 0x22, 0x10, 0xae, 0x0d, 0x90, 0xe6, 0xb9, 0xe0, 0xfa, 0xba,   \
        0x10, 0x03, 0x02, 0x13, 0xa3, 0xba, 0x11, 0x03, 0x02, 0x10, 0x10, 0xbe, 0x0d, 0x30, 0xba, 0x12, 0x03, 0x02,   \
        0x11, 0xeb, 0xba, 0x13, 0x03, 0x02, 0x10, 0x39, 0xba, 0x14, 0x03, 0x10, 0xce, 0x0d, 0x02, 0x10, 0x78, 0xba,   \
        0x15, 0x03, 0x02, 0x11, 0x23, 0xba, 0x17, 0x03, 0x02, 0x10, 0xf1, 0xba, 0x10, 0xde, 0x0d, 0x18, 0x03, 0x02,   \
        0x13, 0x07, 0xba, 0x19, 0x03, 0x02, 0x12, 0xda, 0xba, 0x20, 0x03, 0x02, 0x10, 0x10, 0xee, 0x0d, 0x9a, 0xba,   \
        0x21, 0x03, 0x02, 0x13, 0x35, 0xba, 0x22, 0x03, 0x02, 0x13, 0x6c, 0xba, 0x25, 0x03, 0x10, 0xfe, 0x0d, 0x02,   \
        0x0f, 0xf3, 0xba, 0x26, 0x03, 0x02, 0x0f, 0x7c, 0xba, 0x27, 0x03, 0x02, 0x10, 0xd8, 0xba, 0x10, 0x0e, 0x0e,   \
        0x55, 0x02, 0x80, 0x0f, 0xba, 0x66, 0x03, 0x02, 0x11, 0x0d, 0xba, 0x68, 0x03, 0x02, 0x11, 0x18, 0x10, 0x1e,   \
        0x0e, 0x02, 0x14, 0x53, 0x90, 0xe6, 0xbc, 0xe0, 0xfa, 0x60, 0x3c, 0xba, 0x01, 0x02, 0x80, 0x51, 0xba, 0x10,   \
        0x2e, 0x0e, 0x02, 0x02, 0x80, 0x66, 0xba, 0x03, 0x02, 0x80, 0x7b, 0xba, 0x04, 0x03, 0x02, 0x0e, 0xcc, 0xba,   \
        0x10, 0x3e, 0x0e, 0x05, 0x03, 0x02, 0x0e, 0xe4, 0xba, 0x06, 0x03, 0x02, 0x0e, 0xfc, 0xba, 0x07, 0x03, 0x02,   \
        0x0f, 0x10, 0x4e, 0x0e, 0x16, 0xba, 0x08, 0x03, 0x02, 0x0f, 0x30, 0xba, 0x09, 0x03, 0x02, 0x0f, 0x48, 0xba,   \
        0x63, 0x03, 0x10, 0x5e, 0x0e, 0x02, 0x0f, 0x61, 0x02, 0x0f, 0x6f, 0x90, 0xe0, 0x17, 0xe0, 0xfa, 0xa3, 0xe0,   \
        0xfb, 0xa3, 0xe0, 0x10, 0x6e, 0x0e, 0xfc, 0xa3, 0xe0, 0xfd, 0x8a, 0x82, 0x8b, 0x83, 0x8c, 0xf0, 0x12, 0x0a,   \
        0xf9, 0x02, 0x14, 0x58, 0x10, 0x7e, 0x0e, 0x90, 0xe0, 0x32, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc,   \
        0xa3, 0xe0, 0xfd, 0x8a, 0x82, 0x10, 0x8e, 0x0e, 0x8b, 0x83, 0x8c, 0xf0, 0x12, 0x0a, 0xf9, 0x02, 0x14, 0x58,   \
        0x90, 0xe0, 0x0b, 0xe0, 0xfa, 0xa3, 0x10, 0x9e, 0x0e, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x8a,   \
        0x82, 0x8b, 0x83, 0x8c, 0xf0, 0x12, 0x0a, 0x10, 0xae, 0x0e, 0xf9, 0x02, 0x14, 0x58, 0x90, 0xe0, 0x13, 0xe0,   \
        0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0x10, 0xbe, 0x0e, 0xe0, 0xfd, 0x8a, 0x82, 0x8b, 0x83, 0x8c,   \
        0xf0, 0x12, 0x0a, 0xf9, 0x02, 0x14, 0x58, 0xe4, 0xa2, 0x10, 0xce, 0x0e, 0x09, 0x33, 0xfa, 0x7b, 0x00, 0x7c,   \
        0x00, 0x7d, 0x00, 0x8a, 0x82, 0x8b, 0x83, 0x8c, 0xf0, 0xed, 0x10, 0xde, 0x0e, 0x12, 0x0a, 0xf9, 0x02, 0x14,   \
        0x58, 0xe4, 0xa2, 0x0a, 0x33, 0xfa, 0x7b, 0x00, 0x7c, 0x00, 0x7d, 0x10, 0xee, 0x0e, 0x00, 0x8a, 0x82, 0x8b,   \
        0x83, 0x8c, 0xf0, 0xed, 0x12, 0x0a, 0xf9, 0x02, 0x14, 0x58, 0x90, 0xe0, 0x10, 0xfe, 0x0e, 0x03, 0xe0, 0xfa,   \
        0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x8a, 0x82, 0x8b, 0x83, 0x10, 0x0e, 0x0f, 0x8c, 0xf0,   \
        0x12, 0x0a, 0xf9, 0x02, 0x14, 0x58, 0x90, 0xe0, 0x07, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0x10, 0x1e, 0x0f, 0xa3,   \
        0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x8a, 0x82, 0x8b, 0x83, 0x8c, 0xf0, 0x12, 0x0a, 0xf9, 0x02, 0x10, 0x2e, 0x0f,   \
        0x14, 0x58, 0x90, 0xe0, 0x1b, 0xe0, 0xfa, 0x7b, 0x00, 0x7c, 0x00, 0x7d, 0x00, 0x8a, 0x82, 0x8b, 0x10, 0x3e,   \
        0x0f, 0x83, 0x8c, 0xf0, 0xed, 0x12, 0x0a, 0xf9, 0x02, 0x14, 0x58, 0x90, 0xe0, 0x1e, 0xe0, 0xfa, 0xa3, 0x10,   \
        0x4e, 0x0f, 0xe0, 0xfb, 0x7c, 0x00, 0x7d, 0x00, 0x8a, 0x82, 0x8b, 0x83, 0x8c, 0xf0, 0xed, 0x12, 0x0a, 0xf9,   \
        0x10, 0x5e, 0x0f, 0x02, 0x14, 0x58, 0x90, 0x00, 0x09, 0xe4, 0xf5, 0xf0, 0x74, 0x10, 0x12, 0x0a, 0xf9, 0x02,   \
        0x14, 0x10, 0x6e, 0x0f, 0x58, 0x90, 0xff, 0xff, 0x74, 0xff, 0xf5, 0xf0, 0x12, 0x0a, 0xf9, 0x02, 0x14, 0x58,   \
        0x90, 0xe6, 0x10, 0x7e, 0x0f, 0x78, 0xe0, 0xfa, 0x44, 0x80, 0xf0, 0x90, 0xe6, 0x79, 0x74, 0xa0, 0xf0, 0x12,   \
        0x0b, 0xd6, 0x90, 0x10, 0x8e, 0x0f, 0xe6, 0xbc, 0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x0b, 0xd6, 0x90,   \
        0xe6, 0x78, 0xe0, 0xfa, 0x10, 0x9e, 0x0f, 0x44, 0x40, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x78, 0xe0, 0xfa,   \
        0x44, 0x80, 0xf0, 0x90, 0xe6, 0x10, 0xae, 0x0f, 0x79, 0x74, 0xa1, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x78,   \
        0xe0, 0xfa, 0x44, 0x20, 0xf0, 0x90, 0x10, 0xbe, 0x0f, 0xe6, 0x79, 0xe0, 0xfa, 0x90, 0xe0, 0x21, 0xf0, 0x12,   \
        0x0b, 0xd6, 0x90, 0xe6, 0x78, 0xe0, 0xfa, 0x10, 0xce, 0x0f, 0x44, 0x40, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6,   \
        0x79, 0xe0, 0xfa, 0x90, 0xe7, 0x40, 0xf0, 0x90, 0x10, 0xde, 0x0f, 0xe6, 0x8a, 0xe4, 0xf0, 0x90, 0xe6, 0x8b,   \
        0x74, 0x01, 0xf0, 0x90, 0xe6, 0x78, 0xe0, 0xfa, 0x44, 0x10, 0xee, 0x0f, 0x40, 0xf0, 0x02, 0x14, 0x58, 0x90,   \
        0xe6, 0x78, 0xe0, 0xfa, 0x44, 0x80, 0xf0, 0x90, 0xe6, 0x79, 0x10, 0xfe, 0x0f, 0x74, 0xa0, 0xf0, 0x12, 0x0b,   \
        0xd6, 0x90, 0xe6, 0xbc, 0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x10, 0x0e, 0x10, 0x0b, 0xd6, 0x90, 0xe6,   \
        0xba, 0xe0, 0xfa, 0x90, 0xe6, 0x79, 0xf0, 0x12, 0x0b, 0xd6, 0x90, 0xe6, 0x10, 0x1e, 0x10, 0x78, 0xe0, 0xfa,   \
        0x44, 0x40, 0xf0, 0x90, 0xe6, 0x8a, 0xe4, 0xf0, 0x90, 0xe6, 0x8b, 0xf0, 0x02, 0x10, 0x2e, 0x10, 0x14, 0x58,   \
        0x90, 0xde, 0xad, 0x12, 0x0a, 0xd7, 0x02, 0x14, 0x58, 0x20, 0x09, 0x30, 0x90, 0xe6, 0x10, 0x3e, 0x10, 0xba,   \
        0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0xe0, 0x22, 0xea, 0x10, 0x4e, 0x10,   \
        0xf0, 0xa3, 0xeb, 0xf0, 0xa3, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0x90, 0xe6, 0x8a, 0xe4, 0xf0, 0x90, 0x10, 0x5e,   \
        0x10, 0xe6, 0x8b, 0xf0, 0x90, 0xe6, 0xa0, 0xe0, 0xfa, 0x20, 0xe1, 0xf8, 0x12, 0x0b, 0xe8, 0x90, 0xe6, 0x10,   \
        0x6e, 0x10, 0x8a, 0xe4, 0xf0, 0x90, 0xe6, 0x8b, 0xf0, 0x02, 0x14, 0x58, 0x20, 0x09, 0x13, 0x90, 0xe6, 0xba,   \
        0x10, 0x7e, 0x10, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0x90, 0xe0, 0x1e, 0xea, 0xf0, 0xa3, 0xeb, 0xf0, 0x12, 0x06,   \
        0xce, 0x10, 0x8e, 0x10, 0x90, 0xe6, 0x8a, 0xe4, 0xf0, 0x90, 0xe6, 0x8b, 0xf0, 0x02, 0x14, 0x58, 0x90, 0xe6,   \
        0xf5, 0x74, 0x10, 0x9e, 0x10, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x48, 0x74, 0x82, 0xf0, 0x90, 0xe6,   \
        0x04, 0x74, 0x80, 0x10, 0xae, 0x10, 0xf0, 0x00, 0x00, 0x00, 0x90, 0xe6, 0x04, 0x74, 0x02, 0xf0, 0x00, 0x00,   \
        0x00, 0x90, 0xe6, 0x04, 0x10, 0xbe, 0x10, 0xe4, 0xf0, 0x00, 0x00, 0x00, 0xc2, 0x09, 0xc2, 0x0a, 0x12, 0x0a,   \
        0x9e, 0xd2, 0x81, 0x90, 0xe6, 0x10, 0xce, 0x10, 0x8a, 0xe4, 0xf0, 0x90, 0xe6, 0x8b, 0xf0, 0x02, 0x14, 0x58,   \
        0x20, 0x09, 0x0d, 0xc2, 0x08, 0xd2, 0x10, 0xde, 0x10, 0x0a, 0x90, 0xee, 0xde, 0x12, 0x0a, 0xd7, 0x02, 0x14,   \
        0x58, 0x90, 0xde, 0xad, 0x12, 0x0a, 0xd7, 0x10, 0xee, 0x10, 0x02, 0x14, 0x58, 0x20, 0x09, 0x10, 0xc2, 0x08,   \
        0x12, 0x0a, 0xbe, 0xd2, 0x0a, 0x90, 0xee, 0xde, 0x10, 0xfe, 0x10, 0x12, 0x0a, 0xd7, 0x02, 0x14, 0x58, 0x90,   \
        0xde, 0xad, 0x12, 0x0a, 0xd7, 0x02, 0x14, 0x58, 0xd2, 0x10, 0x0e, 0x11, 0x0b, 0x90, 0xee, 0xde, 0x12, 0x0a,   \
        0xd7, 0x02, 0x14, 0x58, 0xc2, 0x0b, 0x90, 0xee, 0xde, 0x12, 0x10, 0x1e, 0x11, 0x0a, 0xd7, 0x02, 0x14, 0x58,   \
        0x30, 0x09, 0x03, 0x02, 0x11, 0xe2, 0xc2, 0x08, 0x90, 0xe6, 0xba, 0x10, 0x2e, 0x11, 0xe0, 0xfa, 0xa3, 0xe0,   \
        0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0xe0, 0x0f, 0xea, 0xf0, 0x10, 0x3e, 0x11, 0xa3, 0xeb, 0xf0,   \
        0xa3, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0x90, 0xe6, 0x01, 0x74, 0xca, 0xf0, 0x12, 0x10, 0x4e, 0x11, 0x0a, 0xbe,   \
        0x90, 0xe0, 0x0f, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x10, 0x5e, 0x11, 0xc3,   \
        0xea, 0x94, 0x96, 0xeb, 0x94, 0x00, 0xec, 0x94, 0x00, 0xed, 0x94, 0x00, 0x50, 0x08, 0x90, 0x10, 0x6e, 0x11,   \
        0xe6, 0x01, 0x74, 0xca, 0xf0, 0x80, 0x06, 0x90, 0xe6, 0x01, 0x74, 0x8a, 0xf0, 0x90, 0xe0, 0x32, 0x10, 0x7e,   \
        0x11, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0xe0, 0x0f, 0xe0, 0xfe, 0x10,   \
        0x8e, 0x11, 0xa3, 0xe0, 0xff, 0xa3, 0xe0, 0xf8, 0xa3, 0xe0, 0xf9, 0xc3, 0xea, 0x9e, 0xeb, 0x9f, 0xec, 0x98,   \
        0x10, 0x9e, 0x11, 0xed, 0x99, 0x40, 0x04, 0xd2, 0x0a, 0x80, 0x33, 0x90, 0xe0, 0x32, 0xe0, 0xfa, 0xa3, 0xe0,   \
        0xfb, 0x10, 0xae, 0x11, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0xe0, 0x0f, 0xe0, 0xfe, 0xa3, 0xe0, 0xff,   \
        0xa3, 0xe0, 0x10, 0xbe, 0x11, 0xf8, 0xa3, 0xe0, 0xf9, 0x90, 0xe0, 0x0f, 0xee, 0xc3, 0x9a, 0xf0, 0xef, 0x9b,   \
        0xa3, 0xf0, 0xe8, 0x10, 0xce, 0x11, 0x9c, 0xa3, 0xf0, 0xe9, 0x9d, 0xa3, 0xf0, 0xd2, 0x06, 0xd2, 0x09, 0x90,   \
        0xee, 0xde, 0x12, 0x0a, 0x10, 0xde, 0x11, 0xd7, 0x02, 0x14, 0x58, 0x90, 0xde, 0xad, 0x12, 0x0a, 0xd7, 0x02,   \
        0x14, 0x58, 0x30, 0x09, 0x03, 0x10, 0xee, 0x11, 0x02, 0x12, 0xd1, 0x90, 0xe6, 0x01, 0x74, 0xca, 0xf0, 0xc2,   \
        0x08, 0x90, 0xe6, 0xba, 0xe0, 0xfa, 0x10, 0xfe, 0x11, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd,   \
        0x90, 0xe0, 0x0f, 0xea, 0xf0, 0xa3, 0xeb, 0x10, 0x0e, 0x12, 0xf0, 0xa3, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0x90,   \
        0xe0, 0x32, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0x10, 0x1e, 0x12, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0xe0,   \
        0x0f, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0xa3, 0xe0, 0xf8, 0x10, 0x2e, 0x12, 0xa3, 0xe0, 0xf9, 0xc3, 0xee, 0x9a,   \
        0xef, 0x9b, 0xe8, 0x9c, 0xe9, 0x9d, 0x50, 0x03, 0x12, 0x0a, 0x10, 0x3e, 0x12, 0xbe, 0x90, 0xe0, 0x32, 0xe0,   \
        0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0x10, 0x4e, 0x12, 0xe0, 0x0f, 0xe0, 0xfe,   \
        0xa3, 0xe0, 0xff, 0xa3, 0xe0, 0xf8, 0xa3, 0xe0, 0xf9, 0xc3, 0xea, 0x9e, 0x10, 0x5e, 0x12, 0xeb, 0x9f, 0xec,   \
        0x98, 0xed, 0x99, 0x40, 0x04, 0xd2, 0x0a, 0x80, 0x33, 0x90, 0xe0, 0x32, 0xe0, 0x10, 0x6e, 0x12, 0xfa, 0xa3,   \
        0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0xe0, 0x0f, 0xe0, 0xfe, 0xa3, 0x10, 0x7e, 0x12, 0xe0,   \
        0xff, 0xa3, 0xe0, 0xf8, 0xa3, 0xe0, 0xf9, 0x90, 0xe0, 0x0f, 0xee, 0xc3, 0x9a, 0xf0, 0xef, 0x10, 0x8e, 0x12,   \
        0x9b, 0xa3, 0xf0, 0xe8, 0x9c, 0xa3, 0xf0, 0xe9, 0x9d, 0xa3, 0xf0, 0xd2, 0x06, 0xd2, 0x09, 0x90, 0x10, 0x9e,   \
        0x12, 0xe0, 0x0f, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xc3, 0xea, 0x94, 0x10,   \
        0xae, 0x12, 0x96, 0xeb, 0x94, 0x00, 0xec, 0x94, 0x00, 0xed, 0x94, 0x00, 0x50, 0x08, 0x90, 0xe6, 0x01, 0x74,   \
        0x10, 0xbe, 0x12, 0xca, 0xf0, 0x80, 0x06, 0x90, 0xe6, 0x01, 0x74, 0x8a, 0xf0, 0x90, 0xee, 0xde, 0x12, 0x0a,   \
        0xd7, 0x10, 0xce, 0x12, 0x02, 0x14, 0x58, 0x90, 0xde, 0xad, 0x12, 0x0a, 0xd7, 0x02, 0x14, 0x58, 0x90, 0xe6,   \
        0xbc, 0xe0, 0x10, 0xde, 0x12, 0xfa, 0x53, 0x02, 0xf0, 0x90, 0xe0, 0x2e, 0xea, 0xf0, 0xa3, 0xe4, 0xf0, 0xa3,   \
        0xf0, 0xa3, 0xf0, 0x10, 0xee, 0x12, 0x74, 0x6f, 0x55, 0x80, 0xfa, 0x90, 0xe6, 0xbc, 0xe0, 0xfb, 0x74, 0x90,   \
        0x5b, 0x4a, 0xf5, 0x80, 0x10, 0xfe, 0x12, 0x90, 0xee, 0xde, 0x12, 0x0a, 0xd7, 0x02, 0x14, 0x58, 0x74, 0x0f,   \
        0x55, 0x80, 0xfa, 0x90, 0xe0, 0x10, 0x0e, 0x13, 0x2e, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xa3,   \
        0xe0, 0xfe, 0xe4, 0xff, 0xf8, 0xf9, 0x10, 0x1e, 0x13, 0xea, 0x42, 0x03, 0xef, 0x42, 0x04, 0xe8, 0x42, 0x05,   \
        0xe9, 0x42, 0x06, 0x8b, 0x80, 0x90, 0xee, 0x10, 0x2e, 0x13, 0xde, 0x12, 0x0a, 0xd7, 0x02, 0x14, 0x58, 0x74,   \
        0x6f, 0x55, 0x80, 0xfa, 0x90, 0xe0, 0x2e, 0xe0, 0x10, 0x3e, 0x13, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd,   \
        0xa3, 0xe0, 0xfe, 0x53, 0x03, 0x90, 0x7c, 0x00, 0x7d, 0x10, 0x4e, 0x13, 0x00, 0x7e, 0x00, 0xe4, 0xff, 0xf8,   \
        0xf9, 0xea, 0x42, 0x03, 0xef, 0x42, 0x04, 0xe8, 0x42, 0x05, 0x10, 0x5e, 0x13, 0xe9, 0x42, 0x06, 0x8b, 0x80,   \
        0x90, 0xee, 0xde, 0x12, 0x0a, 0xd7, 0x02, 0x14, 0x58, 0x74, 0x9f, 0x10, 0x6e, 0x13, 0x55, 0x80, 0xfa, 0x90,   \
        0xe0, 0x2e, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xa3, 0xe0, 0x10, 0x7e, 0x13, 0xfe, 0x53, 0x03,   \
        0x60, 0x7c, 0x00, 0x7d, 0x00, 0x7e, 0x00, 0xe4, 0xff, 0xf8, 0xf9, 0xea, 0x42, 0x10, 0x8e, 0x13, 0x03, 0xef,   \
        0x42, 0x04, 0xe8, 0x42, 0x05, 0xe9, 0x42, 0x06, 0x8b, 0x80, 0x90, 0xee, 0xde, 0x12, 0x10, 0x9e, 0x13, 0x0a,   \
        0xd7, 0x02, 0x14, 0x58, 0x90, 0xe6, 0x8a, 0xe4, 0xf0, 0x90, 0xe6, 0x8b, 0xf0, 0x90, 0xe6, 0x10, 0xae, 0x13,   \
        0xa0, 0xe0, 0xfa, 0x20, 0xe1, 0xf8, 0x90, 0xe7, 0x40, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0x10, 0xbe,   \
        0x13, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0xe0, 0x03, 0xea, 0xf0, 0xa3, 0xeb, 0xf0, 0xa3, 0xec, 0xf0, 0xa3, 0x10,   \
        0xce, 0x13, 0xed, 0xf0, 0x90, 0xe7, 0x44, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd,   \
        0x10, 0xde, 0x13, 0x90, 0xe0, 0x07, 0xea, 0xf0, 0xa3, 0xeb, 0xf0, 0xa3, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0x90,   \
        0xe0, 0x10, 0xee, 0x13, 0x03, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xba, 0xff,   \
        0x0b, 0xbb, 0x10, 0xfe, 0x13, 0xff, 0x08, 0xbc, 0xff, 0x05, 0xbd, 0xff, 0x02, 0x80, 0x12, 0xd2, 0x04, 0x74,   \
        0x6f, 0x55, 0x80, 0x10, 0x0e, 0x14, 0xfa, 0x90, 0xe6, 0xbc, 0xe0, 0xfb, 0x74, 0x90, 0x5b, 0x4a, 0xf5, 0x80,   \
        0x90, 0xe0, 0x07, 0xe0, 0x10, 0x1e, 0x14, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xba,   \
        0xff, 0x0b, 0xbb, 0xff, 0x08, 0x10, 0x2e, 0x14, 0xbc, 0xff, 0x05, 0xbd, 0xff, 0x02, 0x80, 0x12, 0xd2, 0x05,   \
        0x74, 0x9f, 0x55, 0x80, 0xfa, 0x90, 0x10, 0x3e, 0x14, 0xe6, 0xbc, 0xe0, 0xfb, 0x74, 0x60, 0x5b, 0x4a, 0xf5,   \
        0x80, 0x90, 0xe6, 0x8a, 0xe4, 0xf0, 0x90, 0x10, 0x4e, 0x14, 0xe6, 0x8b, 0xf0, 0x80, 0x05, 0x74, 0x01, 0x24,   \
        0xff, 0x22, 0xe4, 0x24, 0xff, 0x22, 0x75, 0x8c, 0x10, 0x5e, 0x14, 0xd1, 0x75, 0x8a, 0x4a, 0x74, 0xf0, 0x55,   \
        0x89, 0x44, 0x01, 0xf5, 0x89, 0x43, 0x8e, 0x08, 0xd2, 0x10, 0x6e, 0x14, 0x8c, 0xd2, 0xa9, 0xd2, 0xaf, 0x22,   \
        0xc0, 0xe0, 0xc0, 0x82, 0xc0, 0x83, 0xc0, 0x02, 0xc0, 0x03, 0x10, 0x7e, 0x14, 0xc0, 0x04, 0xc0, 0x05, 0xc0,   \
        0x06, 0xc0, 0x07, 0xc0, 0x00, 0xc0, 0x01, 0xc0, 0xd0, 0x75, 0xd0, 0x10, 0x8e, 0x14, 0x00, 0x75, 0x8c, 0xd1,   \
        0x75, 0x8a, 0x4a, 0x90, 0xe0, 0x32, 0xe0, 0x24, 0x01, 0xf0, 0xa3, 0xe0, 0x10, 0x9e, 0x14, 0x34, 0x00, 0xf0,   \
        0xa3, 0xe0, 0x34, 0x00, 0xf0, 0xa3, 0xe0, 0x34, 0x00, 0xf0, 0x30, 0x04, 0x1e, 0x10, 0xae, 0x14, 0x90, 0xe0,   \
        0x03, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0xe0, 0x10, 0xbe, 0x14, 0x26,   \
        0xea, 0xf0, 0xa3, 0xeb, 0xf0, 0xa3, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0xc2, 0x04, 0x30, 0x05, 0x10, 0xce, 0x14,   \
        0x1e, 0x90, 0xe0, 0x07, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0x10, 0xde,   \
        0x14, 0xe0, 0x2a, 0xea, 0xf0, 0xa3, 0xeb, 0xf0, 0xa3, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0xc2, 0x05, 0x90, 0x10,   \
        0xee, 0x14, 0xe0, 0x26, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0xe0, 0x26,   \
        0x10, 0xfe, 0x14, 0xe0, 0x24, 0xff, 0xfe, 0xa3, 0xe0, 0x34, 0xff, 0xff, 0xa3, 0xe0, 0x34, 0xff, 0xf8, 0xa3,   \
        0xe0, 0x10, 0x0e, 0x15, 0x34, 0xff, 0xf9, 0x90, 0xe0, 0x26, 0xee, 0xf0, 0xa3, 0xef, 0xf0, 0xa3, 0xe8, 0xf0,   \
        0xa3, 0xe9, 0x10, 0x1e, 0x15, 0xf0, 0xea, 0x4b, 0x4c, 0x4d, 0x70, 0x2e, 0x74, 0x6f, 0x55, 0x80, 0xfa, 0x90,   \
        0xe0, 0x2e, 0xe0, 0x10, 0x2e, 0x15, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xa3, 0xe0, 0xfe, 0x53, 0x03,   \
        0x90, 0x7c, 0x00, 0x7d, 0x10, 0x3e, 0x15, 0x00, 0x7e, 0x00, 0xe4, 0xff, 0xf8, 0xf9, 0xea, 0x42, 0x03, 0xef,   \
        0x42, 0x04, 0xe8, 0x42, 0x05, 0x10, 0x4e, 0x15, 0xe9, 0x42, 0x06, 0x8b, 0x80, 0x90, 0xe0, 0x2a, 0xe0, 0xfa,   \
        0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0x10, 0x5e, 0x15, 0xa3, 0xe0, 0xfd, 0x90, 0xe0, 0x2a, 0xe0, 0x24, 0xff,   \
        0xfe, 0xa3, 0xe0, 0x34, 0xff, 0xff, 0xa3, 0x10, 0x6e, 0x15, 0xe0, 0x34, 0xff, 0xf8, 0xa3, 0xe0, 0x34, 0xff,   \
        0xf9, 0x90, 0xe0, 0x2a, 0xee, 0xf0, 0xa3, 0xef, 0x10, 0x7e, 0x15, 0xf0, 0xa3, 0xe8, 0xf0, 0xa3, 0xe9, 0xf0,   \
        0xea, 0x4b, 0x4c, 0x4d, 0x70, 0x2e, 0x74, 0x9f, 0x55, 0x10, 0x8e, 0x15, 0x80, 0xfa, 0x90, 0xe0, 0x2e, 0xe0,   \
        0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xa3, 0xe0, 0xfe, 0x10, 0x9e, 0x15, 0x53, 0x03, 0x60, 0x7c, 0x00,   \
        0x7d, 0x00, 0x7e, 0x00, 0xe4, 0xff, 0xf8, 0xf9, 0xea, 0x42, 0x03, 0x10, 0xae, 0x15, 0xef, 0x42, 0x04, 0xe8,   \
        0x42, 0x05, 0xe9, 0x42, 0x06, 0x8b, 0x80, 0x10, 0x06, 0x02, 0x80, 0x1c, 0x10, 0xbe, 0x15, 0x90, 0xe0, 0x0f,   \
        0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x90, 0xe0, 0x10, 0xce, 0x15, 0x0b, 0xea,   \
        0xf0, 0xa3, 0xeb, 0xf0, 0xa3, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0x30, 0x08, 0x0b, 0x90, 0x10, 0xde, 0x15, 0xe0,   \
        0x0b, 0xe4, 0xf0, 0xa3, 0xf0, 0xa3, 0xf0, 0xa3, 0xf0, 0x30, 0x09, 0x3c, 0x90, 0xe0, 0x0b, 0x10, 0xee, 0x15,   \
        0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xea, 0x4b, 0x4c, 0x4d, 0x70, 0x10, 0xfe,   \
        0x15, 0x04, 0xd2, 0x0a, 0x80, 0x24, 0x90, 0xe0, 0x0b, 0xe0, 0x24, 0xff, 0xfa, 0xa3, 0xe0, 0x34, 0xff, 0x10,   \
        0x0e, 0x16, 0xfb, 0xa3, 0xe0, 0x34, 0xff, 0xfc, 0xa3, 0xe0, 0x34, 0xff, 0xfd, 0x90, 0xe0, 0x0b, 0xea, 0xf0,   \
        0x10, 0x1e, 0x16, 0xa3, 0xeb, 0xf0, 0xa3, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0xd0, 0xd0, 0xd0, 0x01, 0xd0, 0x00,   \
        0xd0, 0x10, 0x2e, 0x16, 0x07, 0xd0, 0x06, 0xd0, 0x05, 0xd0, 0x04, 0xd0, 0x03, 0xd0, 0x02, 0xd0, 0x83, 0xd0,   \
        0x82, 0xd0, 0x02, 0x3e, 0x16, 0xe0, 0x32, 0x01, 0x3a, 0x17, 0x0a, 0x10, 0x40, 0x16, 0x30, 0x0d, 0x0a, 0x90,   \
        0xe6, 0x80, 0xe0, 0xfa, 0x44, 0x0a, 0xf0, 0x80, 0x08, 0x90, 0xe6, 0x80, 0x10, 0x50, 0x16, 0xe0, 0xfa, 0x44,   \
        0x08, 0xf0, 0x90, 0x05, 0xdc, 0x12, 0x16, 0x73, 0x90, 0xe6, 0x5d, 0x74, 0xff, 0x10, 0x60, 0x16, 0xf0, 0x90,   \
        0xe6, 0x5f, 0x74, 0xff, 0xf0, 0x53, 0x91, 0xef, 0x90, 0xe6, 0x80, 0xe0, 0xfa, 0x54, 0x03, 0x70, 0x16, 0xf7,   \
        0xf0, 0x22, 0x06, 0xf5, 0x02, 0xe4, 0x78, 0xff, 0xf6, 0xd8, 0xfd, 0x10, 0xd3, 0x02, 0x79, 0x1c, 0xe9, 0x44,   \
        0x00, 0x60, 0x1b, 0x7a, 0x01, 0x90, 0x17, 0x1f, 0x78, 0x26, 0x75, 0xa0, 0x10, 0xe3, 0x02, 0xe0, 0xe4, 0x93,   \
        0xf2, 0xa3, 0x08, 0xb8, 0x00, 0x02, 0x05, 0xa0, 0xd9, 0xf4, 0xda, 0xf2, 0x75, 0x02, 0xf3, 0x02, 0xa0, 0xff,   \
        0x10, 0xfb, 0x02, 0x78, 0x00, 0xe8, 0x44, 0x00, 0x60, 0x0a, 0x79, 0x00, 0x75, 0xa0, 0x00, 0xe4, 0xf3, 0x09,   \
        0xd8, 0x10, 0x0b, 0x03, 0xfc, 0x78, 0x26, 0xe8, 0x44, 0x00, 0x60, 0x0c, 0x79, 0x01, 0x90, 0xe0, 0x00, 0xe4,   \
        0xf0, 0xa3, 0x04, 0x1b, 0x03, 0xd8, 0xfc, 0xd9, 0xfa, 0x10, 0x73, 0x16, 0xaa, 0x82, 0xab, 0x83, 0x90, 0xe6,   \
        0x00, 0xe0, 0xfc, 0x53, 0x04, 0x18, 0xbc, 0x00, 0x11, 0x74, 0x10, 0x83, 0x16, 0x01, 0x2a, 0xfc, 0xe4, 0x3b,   \
        0xfd, 0x8c, 0x02, 0xc3, 0x13, 0xca, 0x13, 0xca, 0xfb, 0x80, 0x12, 0x10, 0x93, 0x16, 0x90, 0xe6, 0x00, 0xe0,   \
        0xfc, 0x53, 0x04, 0x18, 0xbc, 0x10, 0x07, 0xeb, 0xca, 0x25, 0xe0, 0xca, 0x10, 0xa3, 0x16, 0x33, 0xfb, 0x8a,   \
        0x04, 0x8b, 0x05, 0x1a, 0xba, 0xff, 0x01, 0x1b, 0xec, 0x4d, 0x60, 0x0d, 0xc0, 0x0d, 0xb3, 0x16, 0x02, 0xc0,   \
        0x03, 0x12, 0x16, 0xc0, 0xd0, 0x03, 0xd0, 0x02, 0x80, 0xe6, 0x22, 0x0d, 0xc6, 0x02, 0x75, 0x81, 0x7f, 0x12,   \
        0x16, 0xd1, 0xe5, 0x82, 0x60, 0x03, 0x02, 0x03, 0x2e, 0x10, 0xc0, 0x16, 0x74, 0x00, 0xf5, 0x86, 0x90, 0xfd,   \
        0xa5, 0x7c, 0x05, 0xa3, 0xe5, 0x82, 0x45, 0x83, 0x70, 0xf9, 0x05, 0xd0, 0x16, 0x22, 0x75, 0x82, 0x00, 0x22,   \
        0x00

#endif /* __FIRMWARE_H_ */
