#
# Crosscompilation file for cross-compiling indi-rpicam for Raspberry PI
#
MESSAGE(STATUS Starting RPI Toolchain)
SET(CMAKE_SYSTEM_NAME Linux)

SET(CMAKE_SYSROOT /tmp/indi-cross)
SET(CMAKE_SYSTEM_PROCESSOR armhf)
SET(CMAKE_LIBRARY_ARCHITECTURE arm-linux-gnueabihf)

SET(CMAKE_CXX_COMPILER /usr/bin/${CMAKE_LIBRARY_ARCHITECTURE}-g++)
SET(CMAKE_C_COMPILER /usr/bin/${CMAKE_LIBRARY_ARCHITECTURE}-gcc)
SET(CMAKE_CXX_STANDARD_LIBRARIES ${CMAKE_SYSROOT}/usr/lib/arm-linux-gnueabihf/libstdc++.so.6)
SET(CMAKE_ASM_COMPILER /usr/bin/${CMAKE_LIBRARY_ARCHITECTURE}-gcc)

#ADD_DEFINITIONS("-mcpu=arm1176jzf-s -mfpu=vfp -mfloat-abi=hard -marm")

STRING(APPEND CMAKE_CXX_FLAGS " -Wall")

SET(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -L${CMAKE_SYSROOT}/usr/lib/${CMAKE_LIBRARY_ARCHITECTURE} -L${CMAKE_SYSROOT}/lib/${CMAKE_LIBRARY_ARCHITECTURE} --sysroot=${CMAKE_SYSROOT}")
SET(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS} -L${CMAKE_SYSROOT}/usr/lib/${CMAKE_LIBRARY_ARCHITECTURE} -L${CMAKE_SYSROOT}/lib/${CMAKE_LIBRARY_ARCHITECTURE} --sysroot=${CMAKE_SYSROOT}")
SET(CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS} --sysroot=${CMAKE_SYSROOT}")

SET(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY BOTH)
SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE BOTH)
SET(CMAKE_FIND_ROOT_PATH_MODE_PACKAGE ONLY)
