#ifndef __VMLINUX_H__
#define __VMLINUX_H__

#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif

#ifndef __ksym
#define __ksym __attribute__((section(".ksyms")))
#endif

#ifndef __weak
#define __weak __attribute__((weak))
#endif

enum {
	AAFS_LOADDATA_ABI = 0,
	AAFS_LOADDATA_REVISION = 1,
	AAFS_LOADDATA_HASH = 2,
	AAFS_LOADDATA_DATA = 3,
	AAFS_LOADDATA_COMPRESSED_SIZE = 4,
	AAFS_LOADDATA_DIR = 5,
	AAFS_LOADDATA_NDENTS = 6,
};

enum {
	ACTION_FAIL = 0,
	ACTION_REPREP = 1,
	ACTION_DELAYED_REPREP = 2,
	ACTION_RETRY = 3,
	ACTION_DELAYED_RETRY = 4,
};

enum {
	ADMA_MMIO_BAR = 4,
	ADMA_PORTS = 2,
	ADMA_CPB_BYTES = 40,
	ADMA_PRD_BYTES = 2048,
	ADMA_PKT_BYTES = 2088,
	ADMA_DMA_BOUNDARY = 4294967295,
	ADMA_MODE_LOCK = 199,
	ADMA_CONTROL = 0,
	ADMA_STATUS = 2,
	ADMA_CPB_COUNT = 4,
	ADMA_CPB_CURRENT = 12,
	ADMA_CPB_NEXT = 12,
	ADMA_CPB_LOOKUP = 16,
	ADMA_FIFO_IN = 20,
	ADMA_FIFO_OUT = 22,
	aNIEN = 256,
	aGO = 128,
	aRSTADM = 32,
	aPIOMD4 = 3,
	aPSD = 64,
	aUIRQ = 16,
	aPERR = 1,
	cDONE = 1,
	cATERR = 8,
	cVLD = 1,
	cDAT = 4,
	cIEN = 8,
	pORD = 16,
	pDIRO = 32,
	pEND = 128,
	rIGN = 32,
	rEND = 128,
	ADMA_REGS_CONTROL = 14,
	ADMA_REGS_SECTOR_COUNT = 18,
	ADMA_REGS_LBA_LOW = 19,
	ADMA_REGS_LBA_MID = 20,
	ADMA_REGS_LBA_HIGH = 21,
	ADMA_REGS_DEVICE = 22,
	ADMA_REGS_COMMAND = 23,
	board_1841_idx = 0,
};

enum {
	AEL100X_TX_CONFIG1 = 49154,
	AEL1002_PWR_DOWN_HI = 49169,
	AEL1002_PWR_DOWN_LO = 49170,
	AEL1002_XFI_EQL = 49173,
	AEL1002_LB_EN = 49175,
	AEL_OPT_SETTINGS = 49175,
	AEL_I2C_CTRL = 49930,
	AEL_I2C_DATA = 49931,
	AEL_I2C_STAT = 49932,
	AEL2005_GPIO_CTRL = 49684,
	AEL2005_GPIO_STAT = 49685,
	AEL2020_GPIO_INTR = 49411,
	AEL2020_GPIO_CTRL = 49416,
	AEL2020_GPIO_STAT = 49420,
	AEL2020_GPIO_CFG = 49424,
	AEL2020_GPIO_SDA = 0,
	AEL2020_GPIO_MODDET = 1,
	AEL2020_GPIO_0 = 3,
	AEL2020_GPIO_1 = 2,
	AEL2020_GPIO_LSTAT = 2,
};

enum {
	AFFINITY = 0,
	AFFINITY_LIST = 1,
	EFFECTIVE = 2,
	EFFECTIVE_LIST = 3,
};

enum {
	AHCI_MAX_PORTS = 32,
	AHCI_MAX_SG = 168,
	AHCI_DMA_BOUNDARY = 4294967295,
	AHCI_MAX_CMDS = 32,
	AHCI_CMD_SZ = 32,
	AHCI_CMD_SLOT_SZ = 1024,
	AHCI_RX_FIS_SZ = 256,
	AHCI_CMD_TBL_CDB = 64,
	AHCI_CMD_TBL_HDR_SZ = 128,
	AHCI_CMD_TBL_SZ = 2816,
	AHCI_CMD_TBL_AR_SZ = 90112,
	AHCI_PORT_PRIV_DMA_SZ = 91392,
	AHCI_PORT_PRIV_FBS_DMA_SZ = 95232,
	AHCI_IRQ_ON_SG = 2147483648,
	AHCI_CMD_ATAPI = 32,
	AHCI_CMD_WRITE = 64,
	AHCI_CMD_PREFETCH = 128,
	AHCI_CMD_RESET = 256,
	AHCI_CMD_CLR_BUSY = 1024,
	RX_FIS_PIO_SETUP = 32,
	RX_FIS_D2H_REG = 64,
	RX_FIS_SDB = 88,
	RX_FIS_UNK = 96,
	HOST_CAP = 0,
	HOST_CTL = 4,
	HOST_IRQ_STAT = 8,
	HOST_PORTS_IMPL = 12,
	HOST_VERSION = 16,
	HOST_EM_LOC = 28,
	HOST_EM_CTL = 32,
	HOST_CAP2 = 36,
	HOST_RESET = 1,
	HOST_IRQ_EN = 2,
	HOST_MRSM = 4,
	HOST_AHCI_EN = 2147483648,
	HOST_CAP_SXS = 32,
	HOST_CAP_EMS = 64,
	HOST_CAP_CCC = 128,
	HOST_CAP_PART = 8192,
	HOST_CAP_SSC = 16384,
	HOST_CAP_PIO_MULTI = 32768,
	HOST_CAP_FBS = 65536,
	HOST_CAP_PMP = 131072,
	HOST_CAP_ONLY = 262144,
	HOST_CAP_CLO = 16777216,
	HOST_CAP_LED = 33554432,
	HOST_CAP_ALPM = 67108864,
	HOST_CAP_SSS = 134217728,
	HOST_CAP_MPS = 268435456,
	HOST_CAP_SNTF = 536870912,
	HOST_CAP_NCQ = 1073741824,
	HOST_CAP_64 = 2147483648,
	HOST_CAP2_BOH = 1,
	HOST_CAP2_NVMHCI = 2,
	HOST_CAP2_APST = 4,
	HOST_CAP2_SDS = 8,
	HOST_CAP2_SADM = 16,
	HOST_CAP2_DESO = 32,
	PORT_LST_ADDR = 0,
	PORT_LST_ADDR_HI = 4,
	PORT_FIS_ADDR = 8,
	PORT_FIS_ADDR_HI = 12,
	PORT_IRQ_STAT = 16,
	PORT_IRQ_MASK = 20,
	PORT_CMD = 24,
	PORT_TFDATA = 32,
	PORT_SIG = 36,
	PORT_CMD_ISSUE = 56,
	PORT_SCR_STAT = 40,
	PORT_SCR_CTL = 44,
	PORT_SCR_ERR = 48,
	PORT_SCR_ACT = 52,
	PORT_SCR_NTF = 60,
	PORT_FBS = 64,
	PORT_DEVSLP = 68,
	PORT_IRQ_COLD_PRES = 2147483648,
	PORT_IRQ_TF_ERR = 1073741824,
	PORT_IRQ_HBUS_ERR = 536870912,
	PORT_IRQ_HBUS_DATA_ERR = 268435456,
	PORT_IRQ_IF_ERR = 134217728,
	PORT_IRQ_IF_NONFATAL = 67108864,
	PORT_IRQ_OVERFLOW = 16777216,
	PORT_IRQ_BAD_PMP = 8388608,
	PORT_IRQ_PHYRDY = 4194304,
	PORT_IRQ_DMPS = 128,
	PORT_IRQ_CONNECT = 64,
	PORT_IRQ_SG_DONE = 32,
	PORT_IRQ_UNK_FIS = 16,
	PORT_IRQ_SDB_FIS = 8,
	PORT_IRQ_DMAS_FIS = 4,
	PORT_IRQ_PIOS_FIS = 2,
	PORT_IRQ_D2H_REG_FIS = 1,
	PORT_IRQ_FREEZE = 683671632,
	PORT_IRQ_ERROR = 2025848912,
	DEF_PORT_IRQ = 2025848959,
	PORT_CMD_ASP = 134217728,
	PORT_CMD_ALPE = 67108864,
	PORT_CMD_ATAPI = 16777216,
	PORT_CMD_FBSCP = 4194304,
	PORT_CMD_ESP = 2097152,
	PORT_CMD_CPD = 1048576,
	PORT_CMD_MPSP = 524288,
	PORT_CMD_HPCP = 262144,
	PORT_CMD_PMP = 131072,
	PORT_CMD_LIST_ON = 32768,
	PORT_CMD_FIS_ON = 16384,
	PORT_CMD_FIS_RX = 16,
	PORT_CMD_CLO = 8,
	PORT_CMD_POWER_ON = 4,
	PORT_CMD_SPIN_UP = 2,
	PORT_CMD_START = 1,
	PORT_CMD_ICC_MASK = 4026531840,
	PORT_CMD_ICC_ACTIVE = 268435456,
	PORT_CMD_ICC_PARTIAL = 536870912,
	PORT_CMD_ICC_SLUMBER = 1610612736,
	PORT_CMD_CAP = 8126464,
	PORT_FBS_DWE_OFFSET = 16,
	PORT_FBS_ADO_OFFSET = 12,
	PORT_FBS_DEV_OFFSET = 8,
	PORT_FBS_DEV_MASK = 3840,
	PORT_FBS_SDE = 4,
	PORT_FBS_DEC = 2,
	PORT_FBS_EN = 1,
	PORT_DEVSLP_DM_OFFSET = 25,
	PORT_DEVSLP_DM_MASK = 503316480,
	PORT_DEVSLP_DITO_OFFSET = 15,
	PORT_DEVSLP_MDAT_OFFSET = 10,
	PORT_DEVSLP_DETO_OFFSET = 2,
	PORT_DEVSLP_DSP = 2,
	PORT_DEVSLP_ADSE = 1,
	AHCI_HFLAG_NO_NCQ = 1,
	AHCI_HFLAG_IGN_IRQ_IF_ERR = 2,
	AHCI_HFLAG_IGN_SERR_INTERNAL = 4,
	AHCI_HFLAG_32BIT_ONLY = 8,
	AHCI_HFLAG_MV_PATA = 16,
	AHCI_HFLAG_NO_MSI = 32,
	AHCI_HFLAG_NO_PMP = 64,
	AHCI_HFLAG_SECT255 = 256,
	AHCI_HFLAG_YES_NCQ = 512,
	AHCI_HFLAG_NO_SUSPEND = 1024,
	AHCI_HFLAG_SRST_TOUT_IS_OFFLINE = 2048,
	AHCI_HFLAG_NO_SNTF = 4096,
	AHCI_HFLAG_NO_FPDMA_AA = 8192,
	AHCI_HFLAG_YES_FBS = 16384,
	AHCI_HFLAG_DELAY_ENGINE = 32768,
	AHCI_HFLAG_NO_DEVSLP = 131072,
	AHCI_HFLAG_NO_FBS = 262144,
	AHCI_HFLAG_MULTI_MSI = 1048576,
	AHCI_HFLAG_WAKE_BEFORE_STOP = 4194304,
	AHCI_HFLAG_YES_ALPM = 8388608,
	AHCI_HFLAG_NO_WRITE_TO_RO = 16777216,
	AHCI_HFLAG_SUSPEND_PHYS = 33554432,
	AHCI_HFLAG_NO_SXS = 67108864,
	AHCI_HFLAG_43BIT_ONLY = 134217728,
	AHCI_HFLAG_INTEL_PCS_QUIRK = 268435456,
	AHCI_FLAG_COMMON = 393346,
	ICH_MAP = 144,
	PCS_6 = 146,
	PCS_7 = 148,
	EM_MAX_SLOTS = 15,
	EM_MAX_RETRY = 5,
	EM_CTL_RST = 512,
	EM_CTL_TM = 256,
	EM_CTL_MR = 1,
	EM_CTL_ALHD = 67108864,
	EM_CTL_XMT = 33554432,
	EM_CTL_SMB = 16777216,
	EM_CTL_SGPIO = 524288,
	EM_CTL_SES = 262144,
	EM_CTL_SAFTE = 131072,
	EM_CTL_LED = 65536,
	EM_MSG_TYPE_LED = 1,
	EM_MSG_TYPE_SAFTE = 2,
	EM_MSG_TYPE_SES2 = 4,
	EM_MSG_TYPE_SGPIO = 8,
};

enum {
	AHCI_PCI_BAR = 5,
};

enum {
	AHCI_PCI_BAR_STA2X11 = 0,
	AHCI_PCI_BAR_CAVIUM = 0,
	AHCI_PCI_BAR_LOONGSON = 0,
	AHCI_PCI_BAR_ENMOTUS = 2,
	AHCI_PCI_BAR_CAVIUM_GEN5 = 4,
	AHCI_PCI_BAR_STANDARD = 5,
};

enum {
	AHC_POWER_STATE_D0 = 0,
	AHC_POWER_STATE_D1 = 1,
	AHC_POWER_STATE_D2 = 2,
	AHC_POWER_STATE_D3 = 3,
};

enum {
	AN_PKT_SIZE = 32,
	IMMED_PKT_SIZE = 48,
};

enum {
	AQ_LINK_STAT = 59392,
	AQ_IMASK_PMA = 61440,
	AQ_XAUI_RX_CFG = 50176,
	AQ_XAUI_TX_CFG = 58368,
	AQ_1G_CTRL = 50176,
	AQ_ANEG_STAT = 51200,
	AQ_FW_VERSION = 32,
	AQ_IFLAG_GLOBAL = 64512,
	AQ_IMASK_GLOBAL = 65280,
};

enum {
	AS3711_REGULATOR = 0,
	AS3711_BACKLIGHT = 1,
};

enum {
	AS3711_REGULATOR_SD_1 = 0,
	AS3711_REGULATOR_SD_2 = 1,
	AS3711_REGULATOR_SD_3 = 2,
	AS3711_REGULATOR_SD_4 = 3,
	AS3711_REGULATOR_LDO_1 = 4,
	AS3711_REGULATOR_LDO_2 = 5,
	AS3711_REGULATOR_LDO_3 = 6,
	AS3711_REGULATOR_LDO_4 = 7,
	AS3711_REGULATOR_LDO_5 = 8,
	AS3711_REGULATOR_LDO_6 = 9,
	AS3711_REGULATOR_LDO_7 = 10,
	AS3711_REGULATOR_LDO_8 = 11,
	AS3711_REGULATOR_MAX = 12,
};

enum {
	ASCII_NULL = 0,
	ASCII_BELL = 7,
	ASCII_BACKSPACE = 8,
	ASCII_IGNORE_FIRST = 8,
	ASCII_HTAB = 9,
	ASCII_LINEFEED = 10,
	ASCII_VTAB = 11,
	ASCII_FORMFEED = 12,
	ASCII_CAR_RET = 13,
	ASCII_IGNORE_LAST = 13,
	ASCII_SHIFTOUT = 14,
	ASCII_SHIFTIN = 15,
	ASCII_CANCEL = 24,
	ASCII_SUBSTITUTE = 26,
	ASCII_ESCAPE = 27,
	ASCII_CSI_IGNORE_FIRST = 32,
	ASCII_CSI_IGNORE_LAST = 63,
	ASCII_DEL = 127,
	ASCII_EXT_CSI = 155,
};

enum {
	ASSUME_PERFECT = 255,
	ASSUME_VALID_DTB = 1,
	ASSUME_VALID_INPUT = 2,
	ASSUME_LATEST = 4,
	ASSUME_NO_ROLLBACK = 8,
	ASSUME_LIBFDT_ORDER = 16,
	ASSUME_LIBFDT_FLAWLESS = 32,
};

enum {
	ATA_EH_SPDN_NCQ_OFF = 1,
	ATA_EH_SPDN_SPEED_DOWN = 2,
	ATA_EH_SPDN_FALLBACK_TO_PIO = 4,
	ATA_EH_SPDN_KEEP_ERRORS = 8,
	ATA_EFLAG_IS_IO = 1,
	ATA_EFLAG_DUBIOUS_XFER = 2,
	ATA_EFLAG_OLD_ER = -2147483648,
	ATA_ECAT_NONE = 0,
	ATA_ECAT_ATA_BUS = 1,
	ATA_ECAT_TOUT_HSM = 2,
	ATA_ECAT_UNK_DEV = 3,
	ATA_ECAT_DUBIOUS_NONE = 4,
	ATA_ECAT_DUBIOUS_ATA_BUS = 5,
	ATA_ECAT_DUBIOUS_TOUT_HSM = 6,
	ATA_ECAT_DUBIOUS_UNK_DEV = 7,
	ATA_ECAT_NR = 8,
	ATA_EH_CMD_DFL_TIMEOUT = 5000,
	ATA_EH_RESET_COOL_DOWN = 5000,
	ATA_EH_PRERESET_TIMEOUT = 10000,
	ATA_EH_FASTDRAIN_INTERVAL = 3000,
	ATA_EH_UA_TRIES = 5,
	ATA_EH_PROBE_TRIAL_INTERVAL = 60000,
	ATA_EH_PROBE_TRIALS = 2,
};

enum {
	ATA_GEN_CLASS_MATCH = 1,
	ATA_GEN_FORCE_DMA = 2,
	ATA_GEN_INTEL_IDER = 4,
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

enum {
	ATA_READID_POSTRESET = 1,
	ATA_DNXFER_PIO = 0,
	ATA_DNXFER_DMA = 1,
	ATA_DNXFER_40C = 2,
	ATA_DNXFER_FORCE_PIO = 3,
	ATA_DNXFER_FORCE_PIO0 = 4,
	ATA_DNXFER_QUIET = -2147483648,
};

enum {
	ATIIXP_IDE_PIO_TIMING = 64,
	ATIIXP_IDE_MWDMA_TIMING = 68,
	ATIIXP_IDE_PIO_CONTROL = 72,
	ATIIXP_IDE_PIO_MODE = 74,
	ATIIXP_IDE_UDMA_CONTROL = 84,
	ATIIXP_IDE_UDMA_MODE = 86,
};

enum {
	ATP867X_IO_CHANNEL_OFFSET = 16,
	ATP867X_IO_PIOSPD_ACTIVE_SHIFT = 4,
	ATP867X_IO_PIOSPD_RECOVER_SHIFT = 0,
	ATP867X_IO_DMAMODE_MSTR_SHIFT = 0,
	ATP867X_IO_DMAMODE_MSTR_MASK = 7,
	ATP867X_IO_DMAMODE_SLAVE_SHIFT = 4,
	ATP867X_IO_DMAMODE_SLAVE_MASK = 112,
	ATP867X_IO_DMAMODE_UDMA_6 = 7,
	ATP867X_IO_DMAMODE_UDMA_5 = 6,
	ATP867X_IO_DMAMODE_UDMA_4 = 5,
	ATP867X_IO_DMAMODE_UDMA_3 = 4,
	ATP867X_IO_DMAMODE_UDMA_2 = 3,
	ATP867X_IO_DMAMODE_UDMA_1 = 2,
	ATP867X_IO_DMAMODE_UDMA_0 = 1,
	ATP867X_IO_DMAMODE_DISABLE = 0,
	ATP867X_IO_SYS_INFO_66MHZ = 4,
	ATP867X_IO_SYS_INFO_SLOW_UDMA5 = 2,
	ATP867X_IO_SYS_MASK_RESERVED = -242,
	ATP867X_IO_PORTSPD_VAL = 4419,
	ATP867X_PREREAD_VAL = 512,
	ATP867X_NUM_PORTS = 4,
	ATP867X_BAR_IOBASE = 0,
	ATP867X_BAR_ROMBASE = 6,
};

enum {
	AT_PKT_END = -1,
	BEYOND_PKT_END = -2,
};

enum {
	AUTOP_INVALID = 0,
	AUTOP_HDD = 1,
	AUTOP_SSD_QD1 = 2,
	AUTOP_SSD_DFL = 3,
	AUTOP_SSD_FAST = 4,
};

enum {
	AX25_VALUES_IPDEFMODE = 0,
	AX25_VALUES_AXDEFMODE = 1,
	AX25_VALUES_BACKOFF = 2,
	AX25_VALUES_CONMODE = 3,
	AX25_VALUES_WINDOW = 4,
	AX25_VALUES_EWINDOW = 5,
	AX25_VALUES_T1 = 6,
	AX25_VALUES_T2 = 7,
	AX25_VALUES_T3 = 8,
	AX25_VALUES_IDLE = 9,
	AX25_VALUES_N2 = 10,
	AX25_VALUES_PACLEN = 11,
	AX25_VALUES_PROTOCOL = 12,
	AX25_VALUES_DS_TIMEOUT = 13,
	AX25_MAX_VALUES = 14,
};

enum {
	Audit_equal = 0,
	Audit_not_equal = 1,
	Audit_bitmask = 2,
	Audit_bittest = 3,
	Audit_lt = 4,
	Audit_gt = 5,
	Audit_le = 6,
	Audit_ge = 7,
	Audit_bad = 8,
};

enum {
	BAD_STACK = -1,
	NOT_STACK = 0,
	GOOD_FRAME = 1,
	GOOD_STACK = 2,
};

enum {
	BCM5706 = 0,
	NC370T = 1,
	NC370I = 2,
	BCM5706S = 3,
	NC370F = 4,
	BCM5708 = 5,
	BCM5708S = 6,
	BCM5709 = 7,
	BCM5709S = 8,
	BCM5716 = 9,
	BCM5716S = 10,
};

enum {
	BFA_ADAPTER_SERIAL_NUM_LEN = 12,
	BFA_ADAPTER_MODEL_NAME_LEN = 16,
	BFA_ADAPTER_MODEL_DESCR_LEN = 128,
	BFA_ADAPTER_MFG_NAME_LEN = 8,
	BFA_ADAPTER_SYM_NAME_LEN = 64,
	BFA_ADAPTER_OS_TYPE_LEN = 64,
	BFA_ADAPTER_UUID_LEN = 16,
};

enum {
	BFA_BOOT_BOOTLUN_MAX = 4,
	BFA_PREBOOT_BOOTLUN_MAX = 8,
};

enum {
	BFA_IOC_DRIVER_LEN = 16,
	BFA_IOC_CHIP_REV_LEN = 8,
};

enum {
	BFA_MFG_TYPE_CB_MAX = 825,
	BFA_MFG_TYPE_FC8P2 = 825,
	BFA_MFG_TYPE_FC8P1 = 815,
	BFA_MFG_TYPE_FC4P2 = 425,
	BFA_MFG_TYPE_FC4P1 = 415,
	BFA_MFG_TYPE_CNA10P2 = 1020,
	BFA_MFG_TYPE_CNA10P1 = 1010,
	BFA_MFG_TYPE_JAYHAWK = 804,
	BFA_MFG_TYPE_WANCHESE = 1007,
	BFA_MFG_TYPE_ASTRA = 807,
	BFA_MFG_TYPE_LIGHTNING_P0 = 902,
	BFA_MFG_TYPE_LIGHTNING = 1741,
	BFA_MFG_TYPE_PROWLER_F = 1560,
	BFA_MFG_TYPE_PROWLER_N = 1410,
	BFA_MFG_TYPE_PROWLER_C = 1710,
	BFA_MFG_TYPE_PROWLER_D = 1860,
	BFA_MFG_TYPE_CHINOOK = 1867,
	BFA_MFG_TYPE_CHINOOK2 = 1869,
	BFA_MFG_TYPE_INVALID = 0,
};

enum {
	BFA_PCI_FCOE_SSDEVICE_ID = 20,
	BFA_PCI_CT2_SSID_FCoE = 34,
	BFA_PCI_CT2_SSID_ETH = 35,
	BFA_PCI_CT2_SSID_FC = 36,
};

enum {
	BFA_PCI_VENDOR_ID_BROCADE = 5719,
	BFA_PCI_DEVICE_ID_FC_8G2P = 19,
	BFA_PCI_DEVICE_ID_FC_8G1P = 23,
	BFA_PCI_DEVICE_ID_CT = 20,
	BFA_PCI_DEVICE_ID_CT_FC = 33,
	BFA_PCI_DEVICE_ID_CT2 = 34,
	BFA_PCI_DEVICE_ID_CT2_QUAD = 35,
};

enum {
	BFA_REQQ_IOC = 0,
	BFA_REQQ_FCXP = 0,
	BFA_REQQ_LPS = 0,
	BFA_REQQ_PORT = 0,
	BFA_REQQ_FLASH = 0,
	BFA_REQQ_DIAG = 0,
	BFA_REQQ_RPORT = 0,
	BFA_REQQ_SBOOT = 0,
	BFA_REQQ_QOS_LO = 1,
	BFA_REQQ_QOS_MD = 2,
	BFA_REQQ_QOS_HI = 3,
};

enum {
	BFA_TRC_CNA_PORT = 1,
	BFA_TRC_CNA_IOC = 2,
	BFA_TRC_CNA_IOC_CB = 3,
	BFA_TRC_CNA_IOC_CT = 4,
};

enum {
	BFA_TRC_FCS_FCS = 1,
	BFA_TRC_FCS_PORT = 2,
	BFA_TRC_FCS_RPORT = 3,
	BFA_TRC_FCS_FCPIM = 4,
};

enum {
	BFA_TRC_HAL = 1,
	BFA_TRC_FCS = 2,
	BFA_TRC_LDRV = 3,
	BFA_TRC_CNA = 4,
};

enum {
	BFA_TRC_HAL_CORE = 1,
	BFA_TRC_HAL_FCXP = 2,
	BFA_TRC_HAL_FCPIM = 3,
	BFA_TRC_HAL_IOCFC_CT = 4,
	BFA_TRC_HAL_IOCFC_CB = 5,
};

enum {
	BFA_TRC_LDRV_BFAD = 1,
	BFA_TRC_LDRV_IM = 2,
	BFA_TRC_LDRV_BSG = 3,
};

enum {
	BFI_ADAPTER_TYPE_FC = 1,
	BFI_ADAPTER_TYPE_MK = 983040,
	BFI_ADAPTER_TYPE_SH = 16,
	BFI_ADAPTER_NPORTS_MK = 65280,
	BFI_ADAPTER_NPORTS_SH = 8,
	BFI_ADAPTER_SPEED_MK = 255,
	BFI_ADAPTER_SPEED_SH = 0,
	BFI_ADAPTER_PROTO = 1048576,
	BFI_ADAPTER_TTV = 2097152,
	BFI_ADAPTER_UNSUPP = 4194304,
};

enum {
	BFI_MSIX_CPE_QMIN_CB = 0,
	BFI_MSIX_CPE_QMAX_CB = 7,
	BFI_MSIX_RME_QMIN_CB = 8,
	BFI_MSIX_RME_QMAX_CB = 15,
	BFI_MSIX_CB_MAX = 22,
};

enum {
	BFI_MSIX_LPU_ERR_CT = 0,
	BFI_MSIX_CPE_QMIN_CT = 1,
	BFI_MSIX_CPE_QMAX_CT = 4,
	BFI_MSIX_RME_QMIN_CT = 5,
	BFI_MSIX_RME_QMAX_CT = 8,
	BFI_MSIX_CT_MAX = 9,
};

enum {
	BFI_SGE_DATA = 0,
	BFI_SGE_DATA_CPL = 1,
	BFI_SGE_DATA_LAST = 3,
	BFI_SGE_LINK = 2,
	BFI_SGE_PGDLEN = 2,
};

enum {
	BIAS = 2147483648,
};

enum {
	BINDER_BUFFER_FLAG_HAS_PARENT = 1,
};

enum {
	BINDER_DEBUG_USER_ERROR = 1,
	BINDER_DEBUG_FAILED_TRANSACTION = 2,
	BINDER_DEBUG_DEAD_TRANSACTION = 4,
	BINDER_DEBUG_OPEN_CLOSE = 8,
	BINDER_DEBUG_DEAD_BINDER = 16,
	BINDER_DEBUG_DEATH_NOTIFICATION = 32,
	BINDER_DEBUG_READ_WRITE = 64,
	BINDER_DEBUG_USER_REFS = 128,
	BINDER_DEBUG_THREADS = 256,
	BINDER_DEBUG_TRANSACTION = 512,
	BINDER_DEBUG_TRANSACTION_COMPLETE = 1024,
	BINDER_DEBUG_FREE_BUFFER = 2048,
	BINDER_DEBUG_INTERNAL_REFS = 4096,
	BINDER_DEBUG_PRIORITY_CAP = 8192,
	BINDER_DEBUG_SPINLOCKS = 16384,
};

enum {
	BINDER_DEBUG_USER_ERROR___2 = 1,
	BINDER_DEBUG_OPEN_CLOSE___2 = 2,
	BINDER_DEBUG_BUFFER_ALLOC = 4,
	BINDER_DEBUG_BUFFER_ALLOC_ASYNC = 8,
};

enum {
	BINDER_LOOPER_STATE_REGISTERED = 1,
	BINDER_LOOPER_STATE_ENTERED = 2,
	BINDER_LOOPER_STATE_EXITED = 4,
	BINDER_LOOPER_STATE_INVALID = 8,
	BINDER_LOOPER_STATE_WAITING = 16,
	BINDER_LOOPER_STATE_POLL = 32,
};

enum {
	BINDER_TYPE_BINDER = 1935813253,
	BINDER_TYPE_WEAK_BINDER = 2002922117,
	BINDER_TYPE_HANDLE = 1936206469,
	BINDER_TYPE_WEAK_HANDLE = 2003315333,
	BINDER_TYPE_FD = 1717840517,
	BINDER_TYPE_FDA = 1717854597,
	BINDER_TYPE_PTR = 1886661253,
};

enum {
	BINDER_WRITE_READ = 3224396289,
	BINDER_SET_IDLE_TIMEOUT = 2148033027,
	BINDER_SET_MAX_THREADS = 2147770885,
	BINDER_SET_IDLE_PRIORITY = 2147770886,
	BINDER_SET_CONTEXT_MGR = 2147770887,
	BINDER_THREAD_EXIT = 2147770888,
	BINDER_VERSION = 3221512713,
	BINDER_GET_NODE_DEBUG_INFO = 3222823435,
	BINDER_GET_NODE_INFO_FOR_REF = 3222823436,
	BINDER_SET_CONTEXT_MGR_EXT = 2149081613,
	BINDER_FREEZE = 2148295182,
	BINDER_GET_FROZEN_INFO = 3222037007,
	BINDER_ENABLE_ONEWAY_SPAM_DETECTION = 2147770896,
	BINDER_GET_EXTENDED_ERROR = 3222037009,
};

enum {
	BIOSET_NEED_BVECS = 1,
	BIOSET_NEED_RESCUER = 2,
	BIOSET_PERCPU_CACHE = 4,
};

enum {
	BIO_PAGE_PINNED = 0,
	BIO_CLONED = 1,
	BIO_BOUNCED = 2,
	BIO_QUIET = 3,
	BIO_CHAIN = 4,
	BIO_REFFED = 5,
	BIO_BPS_THROTTLED = 6,
	BIO_TRACE_COMPLETION = 7,
	BIO_CGROUP_ACCT = 8,
	BIO_QOS_THROTTLED = 9,
	BIO_QOS_MERGED = 10,
	BIO_REMAPPED = 11,
	BIO_ZONE_WRITE_PLUGGING = 12,
	BIO_EMULATES_ZONE_APPEND = 13,
	BIO_FLAG_LAST = 14,
};

enum {
	BLK_MQ_F_SHOULD_MERGE = 1,
	BLK_MQ_F_TAG_QUEUE_SHARED = 2,
	BLK_MQ_F_STACKING = 4,
	BLK_MQ_F_TAG_HCTX_SHARED = 8,
	BLK_MQ_F_BLOCKING = 32,
	BLK_MQ_F_NO_SCHED = 64,
	BLK_MQ_F_NO_SCHED_BY_DEFAULT = 128,
	BLK_MQ_F_ALLOC_POLICY_START_BIT = 8,
	BLK_MQ_F_ALLOC_POLICY_BITS = 1,
	BLK_MQ_S_STOPPED = 0,
	BLK_MQ_S_TAG_ACTIVE = 1,
	BLK_MQ_S_SCHED_RESTART = 2,
	BLK_MQ_S_INACTIVE = 3,
	BLK_MQ_MAX_DEPTH = 10240,
	BLK_MQ_CPU_WORK_BATCH = 8,
};

enum {
	BLK_MQ_NO_TAG = 4294967295,
	BLK_MQ_TAG_MIN = 1,
	BLK_MQ_TAG_MAX = 4294967294,
};

enum {
	BLK_MQ_REQ_NOWAIT = 1,
	BLK_MQ_REQ_RESERVED = 2,
	BLK_MQ_REQ_PM = 4,
};

enum {
	BLK_MQ_UNIQUE_TAG_BITS = 16,
	BLK_MQ_UNIQUE_TAG_MASK = 65535,
};

enum {
	BLOCK_BITMAP = 0,
	INODE_BITMAP = 1,
	INODE_TABLE = 2,
	GROUP_TABLE_COUNT = 3,
};

enum {
	BNX2X_PORT_QUERY_IDX = 0,
	BNX2X_PF_QUERY_IDX = 1,
	BNX2X_FCOE_QUERY_IDX = 2,
	BNX2X_FIRST_QUEUE_QUERY_IDX = 3,
};

enum {
	BPF_ADJ_ROOM_ENCAP_L2_MASK = 255,
	BPF_ADJ_ROOM_ENCAP_L2_SHIFT = 56,
};

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_CSUM_LEVEL_QUERY = 0,
	BPF_CSUM_LEVEL_INC = 1,
	BPF_CSUM_LEVEL_DEC = 2,
	BPF_CSUM_LEVEL_RESET = 3,
};

enum {
	BPF_FIB_LKUP_RET_SUCCESS = 0,
	BPF_FIB_LKUP_RET_BLACKHOLE = 1,
	BPF_FIB_LKUP_RET_UNREACHABLE = 2,
	BPF_FIB_LKUP_RET_PROHIBIT = 3,
	BPF_FIB_LKUP_RET_NOT_FWDED = 4,
	BPF_FIB_LKUP_RET_FWD_DISABLED = 5,
	BPF_FIB_LKUP_RET_UNSUPP_LWT = 6,
	BPF_FIB_LKUP_RET_NO_NEIGH = 7,
	BPF_FIB_LKUP_RET_FRAG_NEEDED = 8,
	BPF_FIB_LKUP_RET_NO_SRC_ADDR = 9,
};

enum {
	BPF_FIB_LOOKUP_DIRECT = 1,
	BPF_FIB_LOOKUP_OUTPUT = 2,
	BPF_FIB_LOOKUP_SKIP_NEIGH = 4,
	BPF_FIB_LOOKUP_TBID = 8,
	BPF_FIB_LOOKUP_SRC = 16,
	BPF_FIB_LOOKUP_MARK = 32,
};

enum {
	BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG = 1,
	BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL = 2,
	BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP = 4,
};

enum {
	BPF_F_ADJ_ROOM_FIXED_GSO = 1,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV4 = 2,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV6 = 4,
	BPF_F_ADJ_ROOM_ENCAP_L4_GRE = 8,
	BPF_F_ADJ_ROOM_ENCAP_L4_UDP = 16,
	BPF_F_ADJ_ROOM_NO_CSUM_RESET = 32,
	BPF_F_ADJ_ROOM_ENCAP_L2_ETH = 64,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV4 = 128,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV6 = 256,
};

enum {
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum {
	BPF_F_CURRENT_NETNS = -1,
};

enum {
	BPF_F_GET_BRANCH_RECORDS_SIZE = 1,
};

enum {
	BPF_F_HDR_FIELD_MASK = 15,
};

enum {
	BPF_F_INDEX_MASK = 4294967295ULL,
	BPF_F_CURRENT_CPU = 4294967295ULL,
	BPF_F_CTXLEN_MASK = 4503595332403200ULL,
};

enum {
	BPF_F_INGRESS = 1,
};

enum {
	BPF_F_NEIGH = 2,
	BPF_F_PEER = 4,
	BPF_F_NEXTHOP = 8,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
	BPF_F_VTYPE_BTF_OBJ_FD = 32768,
	BPF_F_TOKEN_FD = 65536,
	BPF_F_SEGV_ON_FAULT = 131072,
	BPF_F_NO_USER_CONV = 262144,
};

enum {
	BPF_F_PSEUDO_HDR = 16,
	BPF_F_MARK_MANGLED_0 = 32,
	BPF_F_MARK_ENFORCE = 64,
};

enum {
	BPF_F_RECOMPUTE_CSUM = 1,
	BPF_F_INVALIDATE_HASH = 2,
};

enum {
	BPF_F_SKIP_FIELD_MASK = 255,
	BPF_F_USER_STACK = 256,
	BPF_F_FAST_STACK_CMP = 512,
	BPF_F_REUSE_STACKID = 1024,
	BPF_F_USER_BUILD_ID = 2048,
};

enum {
	BPF_F_SYSCTL_BASE_NAME = 1,
};

enum {
	BPF_F_TIMER_ABS = 1,
	BPF_F_TIMER_CPU_PIN = 2,
};

enum {
	BPF_F_TUNINFO_FLAGS = 16,
};

enum {
	BPF_F_TUNINFO_IPV6 = 1,
};

enum {
	BPF_F_UPROBE_MULTI_RETURN = 1,
};

enum {
	BPF_F_ZERO_CSUM_TX = 2,
	BPF_F_DONT_FRAGMENT = 4,
	BPF_F_SEQ_NUMBER = 8,
	BPF_F_NO_TUNNEL_KEY = 16,
};

enum {
	BPF_LOAD_HDR_OPT_TCP_SYN = 1,
};

enum {
	BPF_LOCAL_STORAGE_GET_F_CREATE = 1,
	BPF_SK_STORAGE_GET_F_CREATE = 1,
};

enum {
	BPF_MAX_LOOPS = 8388608,
};

enum {
	BPF_MAX_TRAMP_LINKS = 38,
};

enum {
	BPF_RB_AVAIL_DATA = 0,
	BPF_RB_RING_SIZE = 1,
	BPF_RB_CONS_POS = 2,
	BPF_RB_PROD_POS = 3,
};

enum {
	BPF_RB_NO_WAKEUP = 1,
	BPF_RB_FORCE_WAKEUP = 2,
};

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

enum {
	BPF_RINGBUF_BUSY_BIT = 2147483648,
	BPF_RINGBUF_DISCARD_BIT = 1073741824,
	BPF_RINGBUF_HDR_SZ = 8,
};

enum {
	BPF_SKB_TSTAMP_UNSPEC = 0,
	BPF_SKB_TSTAMP_DELIVERY_MONO = 1,
};

enum {
	BPF_SK_LOOKUP_F_REPLACE = 1,
	BPF_SK_LOOKUP_F_NO_REUSEPORT = 2,
};

enum {
	BPF_SOCK_OPS_RTO_CB_FLAG = 1,
	BPF_SOCK_OPS_RETRANS_CB_FLAG = 2,
	BPF_SOCK_OPS_STATE_CB_FLAG = 4,
	BPF_SOCK_OPS_RTT_CB_FLAG = 8,
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG = 16,
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = 32,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG = 64,
	BPF_SOCK_OPS_ALL_CB_FLAGS = 127,
};

enum {
	BPF_SOCK_OPS_VOID = 0,
	BPF_SOCK_OPS_TIMEOUT_INIT = 1,
	BPF_SOCK_OPS_RWND_INIT = 2,
	BPF_SOCK_OPS_TCP_CONNECT_CB = 3,
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB = 4,
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB = 5,
	BPF_SOCK_OPS_NEEDS_ECN = 6,
	BPF_SOCK_OPS_BASE_RTT = 7,
	BPF_SOCK_OPS_RTO_CB = 8,
	BPF_SOCK_OPS_RETRANS_CB = 9,
	BPF_SOCK_OPS_STATE_CB = 10,
	BPF_SOCK_OPS_TCP_LISTEN_CB = 11,
	BPF_SOCK_OPS_RTT_CB = 12,
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB = 13,
	BPF_SOCK_OPS_HDR_OPT_LEN_CB = 14,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB = 15,
};

enum {
	BPF_TASK_ITER_ALL_PROCS = 0,
	BPF_TASK_ITER_ALL_THREADS = 1,
	BPF_TASK_ITER_PROC_THREADS = 2,
};

enum {
	BPF_TCP_ESTABLISHED = 1,
	BPF_TCP_SYN_SENT = 2,
	BPF_TCP_SYN_RECV = 3,
	BPF_TCP_FIN_WAIT1 = 4,
	BPF_TCP_FIN_WAIT2 = 5,
	BPF_TCP_TIME_WAIT = 6,
	BPF_TCP_CLOSE = 7,
	BPF_TCP_CLOSE_WAIT = 8,
	BPF_TCP_LAST_ACK = 9,
	BPF_TCP_LISTEN = 10,
	BPF_TCP_CLOSING = 11,
	BPF_TCP_NEW_SYN_RECV = 12,
	BPF_TCP_BOUND_INACTIVE = 13,
	BPF_TCP_MAX_STATES = 14,
};

enum {
	BPF_WRITE_HDR_TCP_CURRENT_MSS = 1,
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE = 2,
};

enum {
	BPF_XFRM_STATE_OPTS_SZ = 36,
};

enum {
	BR_MCAST_DIR_RX = 0,
	BR_MCAST_DIR_TX = 1,
	BR_MCAST_DIR_SIZE = 2,
};

enum {
	BTF_FIELDS_MAX = 11,
};

enum {
	BTF_FIELD_IGNORE = 0,
	BTF_FIELD_FOUND = 1,
};

enum {
	BTF_F_COMPACT = 1,
	BTF_F_NONAME = 2,
	BTF_F_PTR_RAW = 4,
	BTF_F_ZERO = 8,
};

enum {
	BTF_KFUNC_SET_MAX_CNT = 256,
	BTF_DTOR_KFUNC_MAX_CNT = 256,
	BTF_KFUNC_FILTER_MAX_CNT = 16,
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

enum {
	BTF_MODULE_F_LIVE = 1,
};

enum {
	BTF_SOCK_TYPE_INET = 0,
	BTF_SOCK_TYPE_INET_CONN = 1,
	BTF_SOCK_TYPE_INET_REQ = 2,
	BTF_SOCK_TYPE_INET_TW = 3,
	BTF_SOCK_TYPE_REQ = 4,
	BTF_SOCK_TYPE_SOCK = 5,
	BTF_SOCK_TYPE_SOCK_COMMON = 6,
	BTF_SOCK_TYPE_TCP = 7,
	BTF_SOCK_TYPE_TCP_REQ = 8,
	BTF_SOCK_TYPE_TCP_TW = 9,
	BTF_SOCK_TYPE_TCP6 = 10,
	BTF_SOCK_TYPE_UDP = 11,
	BTF_SOCK_TYPE_UDP6 = 12,
	BTF_SOCK_TYPE_UNIX = 13,
	BTF_SOCK_TYPE_MPTCP = 14,
	BTF_SOCK_TYPE_SOCKET = 15,
	MAX_BTF_SOCK_TYPE = 16,
};

enum {
	BTF_TRACING_TYPE_TASK = 0,
	BTF_TRACING_TYPE_FILE = 1,
	BTF_TRACING_TYPE_VMA = 2,
	MAX_BTF_TRACING_TYPE = 3,
};

enum {
	BTF_VAR_STATIC = 0,
	BTF_VAR_GLOBAL_ALLOCATED = 1,
	BTF_VAR_GLOBAL_EXTERN = 2,
};

enum {
	CAM_DIR_IN = 2,
	CAM_DIR_OUT = 1,
	CAM_DIR_NONE = 3,
};

enum {
	CFR = 80,
	CNTRL = 81,
	CMDTIM = 82,
	ARTIM0 = 83,
	DRWTIM0 = 84,
	ARTIM23 = 87,
	DRWTIM23 = 88,
	BRST = 89,
};

enum {
	CFR___2 = 80,
	CFR_INTR_CH0 = 4,
	CNTRL___2 = 81,
	CNTRL_CH0 = 4,
	CNTRL_CH1 = 8,
	CMDTIM___2 = 82,
	ARTTIM0 = 83,
	DRWTIM0___2 = 84,
	ARTTIM1 = 85,
	DRWTIM1 = 86,
	ARTTIM23 = 87,
	ARTTIM23_DIS_RA2 = 4,
	ARTTIM23_DIS_RA3 = 8,
	ARTTIM23_INTR_CH1 = 16,
	DRWTIM2 = 88,
	BRST___2 = 89,
	DRWTIM3 = 91,
	BMIDECR0 = 112,
	MRDMODE = 113,
	MRDMODE_INTR_CH0 = 4,
	MRDMODE_INTR_CH1 = 8,
	BMIDESR0 = 114,
	UDIDETCR0 = 115,
	DTPR0 = 116,
	BMIDECR1 = 120,
	BMIDECSR = 121,
	UDIDETCR1 = 123,
	DTPR1 = 124,
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

enum {
	CGROUPSTATS_CMD_ATTR_UNSPEC = 0,
	CGROUPSTATS_CMD_ATTR_FD = 1,
	__CGROUPSTATS_CMD_ATTR_MAX = 2,
};

enum {
	CGROUPSTATS_CMD_UNSPEC = 3,
	CGROUPSTATS_CMD_GET = 4,
	CGROUPSTATS_CMD_NEW = 5,
	__CGROUPSTATS_CMD_MAX = 6,
};

enum {
	CGROUPSTATS_TYPE_UNSPEC = 0,
	CGROUPSTATS_TYPE_CGROUP_STATS = 1,
	__CGROUPSTATS_TYPE_MAX = 2,
};

enum {
	CGRP_NOTIFY_ON_RELEASE = 0,
	CGRP_CPUSET_CLONE_CHILDREN = 1,
	CGRP_FREEZE = 2,
	CGRP_FROZEN = 3,
	CGRP_KILL = 4,
};

enum {
	CGRP_ROOT_NOPREFIX = 2,
	CGRP_ROOT_XATTR = 4,
	CGRP_ROOT_NS_DELEGATE = 8,
	CGRP_ROOT_FAVOR_DYNMODS = 16,
	CGRP_ROOT_CPUSET_V2_MODE = 65536,
	CGRP_ROOT_MEMORY_LOCAL_EVENTS = 131072,
	CGRP_ROOT_MEMORY_RECURSIVE_PROT = 262144,
	CGRP_ROOT_MEMORY_HUGETLB_ACCOUNTING = 524288,
};

enum {
	CHELSIO_GETMTUTAB = 1029,
	CHELSIO_SETMTUTAB = 1030,
	CHELSIO_SET_PM = 1032,
	CHELSIO_GET_PM = 1033,
	CHELSIO_GET_MEM = 1038,
	CHELSIO_LOAD_FW = 1041,
	CHELSIO_SET_TRACE_FILTER = 1044,
	CHELSIO_SET_QSET_PARAMS = 1045,
	CHELSIO_GET_QSET_PARAMS = 1046,
	CHELSIO_SET_QSET_NUM = 1047,
	CHELSIO_GET_QSET_NUM = 1048,
};

enum {
	CHIP_INVALID = 0,
	CHIP_PM8606 = 1,
	CHIP_PM8607 = 2,
	CHIP_MAX = 3,
};

enum {
	CLKCTL = 2,
	SYNCCTL = 3,
	HSYNCPOS = 4,
	PWRMNGMT = 5,
	DACOP = 6,
	PALETCTL = 7,
	SYSCLKCTL = 8,
	PIXFMT = 10,
	BPP8 = 11,
	BPP16 = 12,
	BPP24 = 13,
	BPP32 = 14,
	PIXCTL1 = 16,
	PIXCTL2 = 17,
	SYSCLKN = 21,
	SYSCLKM = 22,
	SYSCLKP = 23,
	SYSCLKC = 24,
	PIXM0 = 32,
	PIXN0 = 33,
	PIXP0 = 34,
	PIXC0 = 35,
	CURSCTL = 48,
	CURSXLO = 49,
	CURSXHI = 50,
	CURSYLO = 51,
	CURSYHI = 52,
	CURSHOTX = 53,
	CURSHOTY = 54,
	CURSACCTL = 55,
	CURSACATTR = 56,
	CURS1R = 64,
	CURS1G = 65,
	CURS1B = 66,
	CURS2R = 67,
	CURS2G = 68,
	CURS2B = 69,
	CURS3R = 70,
	CURS3G = 71,
	CURS3B = 72,
	BORDR = 96,
	BORDG = 97,
	BORDB = 98,
	MISCTL1 = 112,
	MISCTL2 = 113,
	MISCTL3 = 114,
	KEYCTL = 120,
};

enum {
	CNIC_EVENT_COAL_INDEX = 0,
	CNIC_SEND_DOORBELL = 4,
	CNIC_EVENT_CQ_ARM = 7,
	CNIC_RECV_DOORBELL = 8,
};

enum {
	COST_CTRL = 0,
	COST_MODEL = 1,
	NR_COST_CTRL_PARAMS = 2,
};

enum {
	CPL_ABORT_SEND_RST = 0,
	CPL_ABORT_NO_RST = 1,
	CPL_ABORT_POST_CLOSE_REQ = 2,
};

enum {
	CPL_ETH_II = 0,
	CPL_ETH_II_VLAN = 1,
	CPL_ETH_802_3 = 2,
	CPL_ETH_802_3_VLAN = 3,
};

enum {
	CPL_PASS_OPEN_REQ = 1,
	CPL_PASS_ACCEPT_RPL = 2,
	CPL_ACT_OPEN_REQ = 3,
	CPL_SET_TCB_FIELD = 5,
	CPL_GET_TCB = 6,
	CPL_CLOSE_CON_REQ = 8,
	CPL_CLOSE_LISTSRV_REQ = 9,
	CPL_ABORT_REQ = 10,
	CPL_ABORT_RPL = 11,
	CPL_TX_DATA = 12,
	CPL_RX_DATA_ACK = 13,
	CPL_TX_PKT = 14,
	CPL_L2T_WRITE_REQ = 18,
	CPL_SMT_WRITE_REQ = 20,
	CPL_TID_RELEASE = 26,
	CPL_SRQ_TABLE_REQ = 28,
	CPL_TX_DATA_ISO = 31,
	CPL_CLOSE_LISTSRV_RPL = 32,
	CPL_GET_TCB_RPL = 34,
	CPL_L2T_WRITE_RPL = 35,
	CPL_PASS_OPEN_RPL = 36,
	CPL_ACT_OPEN_RPL = 37,
	CPL_PEER_CLOSE = 38,
	CPL_ABORT_REQ_RSS = 43,
	CPL_ABORT_RPL_RSS = 45,
	CPL_SMT_WRITE_RPL = 46,
	CPL_RX_PHYS_ADDR = 48,
	CPL_CLOSE_CON_RPL = 50,
	CPL_ISCSI_HDR = 51,
	CPL_RDMA_CQE = 53,
	CPL_RDMA_CQE_READ_RSP = 54,
	CPL_RDMA_CQE_ERR = 55,
	CPL_RX_DATA = 57,
	CPL_SET_TCB_RPL = 58,
	CPL_RX_PKT = 59,
	CPL_RX_DDP_COMPLETE = 63,
	CPL_ACT_ESTABLISH = 64,
	CPL_PASS_ESTABLISH = 65,
	CPL_RX_DATA_DDP = 66,
	CPL_PASS_ACCEPT_REQ = 68,
	CPL_RX_ISCSI_CMP = 69,
	CPL_TRACE_PKT_T5 = 72,
	CPL_RX_ISCSI_DDP = 73,
	CPL_RX_TLS_CMP = 78,
	CPL_RDMA_READ_REQ = 96,
	CPL_PASS_OPEN_REQ6 = 129,
	CPL_ACT_OPEN_REQ6 = 131,
	CPL_TX_TLS_PDU = 136,
	CPL_TX_TLS_SFO = 137,
	CPL_TX_SEC_PDU = 138,
	CPL_TX_TLS_ACK = 139,
	CPL_RDMA_TERMINATE = 162,
	CPL_RDMA_WRITE = 164,
	CPL_SGE_EGR_UPDATE = 165,
	CPL_RX_MPS_PKT = 175,
	CPL_TRACE_PKT = 176,
	CPL_TLS_DATA = 177,
	CPL_ISCSI_DATA = 178,
	CPL_FW4_MSG = 192,
	CPL_FW4_PLD = 193,
	CPL_FW4_ACK = 195,
	CPL_SRQ_TABLE_RPL = 204,
	CPL_RX_PHYS_DSGL = 208,
	CPL_FW6_MSG = 224,
	CPL_FW6_PLD = 225,
	CPL_TX_TNL_LSO = 236,
	CPL_TX_PKT_LSO = 237,
	CPL_TX_PKT_XT = 238,
	NUM_CPL_CMDS = 239,
};

enum {
	CPL_PRIORITY_DATA = 0,
	CPL_PRIORITY_SETUP = 1,
	CPL_PRIORITY_TEARDOWN = 0,
	CPL_PRIORITY_LISTEN = 1,
	CPL_PRIORITY_ACK = 1,
	CPL_PRIORITY_CONTROL = 1,
};

enum {
	CPL_RET_BUF_DONE = 1,
	CPL_RET_BAD_MSG = 2,
	CPL_RET_UNKNOWN_TID = 4,
};

enum {
	CRNG_EMPTY = 0,
	CRNG_EARLY = 1,
	CRNG_READY = 2,
};

enum {
	CRNG_RESEED_START_INTERVAL = 1000,
	CRNG_RESEED_INTERVAL = 60000,
};

enum {
	CRYPTOA_UNSPEC = 0,
	CRYPTOA_ALG = 1,
	CRYPTOA_TYPE = 2,
	__CRYPTOA_MAX = 3,
};

enum {
	CRYPTO_AUTHENC_KEYA_UNSPEC = 0,
	CRYPTO_AUTHENC_KEYA_PARAM = 1,
};

enum {
	CRYPTO_KPP_SECRET_TYPE_UNKNOWN = 0,
	CRYPTO_KPP_SECRET_TYPE_DH = 1,
	CRYPTO_KPP_SECRET_TYPE_ECDH = 2,
};

enum {
	CRYPTO_MSG_ALG_REQUEST = 0,
	CRYPTO_MSG_ALG_REGISTER = 1,
	CRYPTO_MSG_ALG_LOADED = 2,
};

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

enum {
	CSIO_EGRESS = 1,
	CSIO_INGRESS = 2,
	CSIO_FREELIST = 3,
};

enum {
	CSIO_INTR_WRSIZE = 128,
	CSIO_INTR_IQSIZE = 65920,
	CSIO_FWEVT_WRSIZE = 128,
	CSIO_FWEVT_IQLEN = 128,
	CSIO_FWEVT_FLBUFS = 64,
	CSIO_FWEVT_IQSIZE = 16384,
	CSIO_HW_NIQ = 1,
	CSIO_HW_NFLQ = 1,
	CSIO_HW_NEQ = 1,
	CSIO_HW_NINTXQ = 1,
};

enum {
	CSIO_MAX_FLBUF_PER_IQWR = 4,
	CSIO_QCREDIT_SZ = 64,
	CSIO_MAX_QID = 65535,
	CSIO_MAX_IQ = 128,
	CSIO_SGE_NTIMERS = 6,
	CSIO_SGE_NCOUNTERS = 4,
	CSIO_SGE_FL_SIZE_REGS = 16,
};

enum {
	CSIO_MGMT_EQ_WRSIZE = 512,
	CSIO_MGMT_IQ_WRSIZE = 128,
	CSIO_MGMT_EQLEN = 64,
	CSIO_MGMT_IQLEN = 64,
};

enum {
	CSIO_SGE_DBFIFO_INT_THRESH = 10,
	CSIO_SGE_RX_DMA_OFFSET = 2,
	CSIO_SGE_FLBUF_SIZE1 = 65536,
	CSIO_SGE_FLBUF_SIZE2 = 1536,
	CSIO_SGE_FLBUF_SIZE3 = 9024,
	CSIO_SGE_FLBUF_SIZE4 = 9216,
	CSIO_SGE_FLBUF_SIZE5 = 2048,
	CSIO_SGE_FLBUF_SIZE6 = 128,
	CSIO_SGE_FLBUF_SIZE7 = 8192,
	CSIO_SGE_FLBUF_SIZE8 = 16384,
	CSIO_SGE_TIMER_VAL_0 = 5,
	CSIO_SGE_TIMER_VAL_1 = 10,
	CSIO_SGE_TIMER_VAL_2 = 20,
	CSIO_SGE_TIMER_VAL_3 = 50,
	CSIO_SGE_TIMER_VAL_4 = 100,
	CSIO_SGE_TIMER_VAL_5 = 200,
	CSIO_SGE_INT_CNT_VAL_0 = 1,
	CSIO_SGE_INT_CNT_VAL_1 = 4,
	CSIO_SGE_INT_CNT_VAL_2 = 8,
	CSIO_SGE_INT_CNT_VAL_3 = 16,
};

enum {
	CSI_DEC_hl_CURSOR_KEYS = 1,
	CSI_DEC_hl_132_COLUMNS = 3,
	CSI_DEC_hl_REVERSE_VIDEO = 5,
	CSI_DEC_hl_ORIGIN_MODE = 6,
	CSI_DEC_hl_AUTOWRAP = 7,
	CSI_DEC_hl_AUTOREPEAT = 8,
	CSI_DEC_hl_MOUSE_X10 = 9,
	CSI_DEC_hl_SHOW_CURSOR = 25,
	CSI_DEC_hl_MOUSE_VT200 = 1000,
};

enum {
	CSI_K_CURSOR_TO_LINEEND = 0,
	CSI_K_LINESTART_TO_CURSOR = 1,
	CSI_K_LINE = 2,
};

enum {
	CSI_hl_DISPLAY_CTRL = 3,
	CSI_hl_INSERT = 4,
	CSI_hl_AUTO_NL = 20,
};

enum {
	CSI_m_DEFAULT = 0,
	CSI_m_BOLD = 1,
	CSI_m_HALF_BRIGHT = 2,
	CSI_m_ITALIC = 3,
	CSI_m_UNDERLINE = 4,
	CSI_m_BLINK = 5,
	CSI_m_REVERSE = 7,
	CSI_m_PRI_FONT = 10,
	CSI_m_ALT_FONT1 = 11,
	CSI_m_ALT_FONT2 = 12,
	CSI_m_DOUBLE_UNDERLINE = 21,
	CSI_m_NORMAL_INTENSITY = 22,
	CSI_m_NO_ITALIC = 23,
	CSI_m_NO_UNDERLINE = 24,
	CSI_m_NO_BLINK = 25,
	CSI_m_NO_REVERSE = 27,
	CSI_m_FG_COLOR_BEG = 30,
	CSI_m_FG_COLOR_END = 37,
	CSI_m_FG_COLOR = 38,
	CSI_m_DEFAULT_FG_COLOR = 39,
	CSI_m_BG_COLOR_BEG = 40,
	CSI_m_BG_COLOR_END = 47,
	CSI_m_BG_COLOR = 48,
	CSI_m_DEFAULT_BG_COLOR = 49,
	CSI_m_BRIGHT_FG_COLOR_BEG = 90,
	CSI_m_BRIGHT_FG_COLOR_END = 97,
	CSI_m_BRIGHT_FG_COLOR_OFF = 60,
	CSI_m_BRIGHT_BG_COLOR_BEG = 100,
	CSI_m_BRIGHT_BG_COLOR_END = 107,
	CSI_m_BRIGHT_BG_COLOR_OFF = 60,
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

enum {
	CSS_TASK_ITER_PROCS = 1,
	CSS_TASK_ITER_THREADED = 2,
	CSS_TASK_ITER_SKIPPED = 65536,
};

enum {
	CTRL_ATTR_MCAST_GRP_UNSPEC = 0,
	CTRL_ATTR_MCAST_GRP_NAME = 1,
	CTRL_ATTR_MCAST_GRP_ID = 2,
	__CTRL_ATTR_MCAST_GRP_MAX = 3,
};

enum {
	CTRL_ATTR_OP_UNSPEC = 0,
	CTRL_ATTR_OP_ID = 1,
	CTRL_ATTR_OP_FLAGS = 2,
	__CTRL_ATTR_OP_MAX = 3,
};

enum {
	CTRL_ATTR_POLICY_UNSPEC = 0,
	CTRL_ATTR_POLICY_DO = 1,
	CTRL_ATTR_POLICY_DUMP = 2,
	__CTRL_ATTR_POLICY_DUMP_MAX = 3,
	CTRL_ATTR_POLICY_DUMP_MAX = 2,
};

enum {
	CTRL_ATTR_UNSPEC = 0,
	CTRL_ATTR_FAMILY_ID = 1,
	CTRL_ATTR_FAMILY_NAME = 2,
	CTRL_ATTR_VERSION = 3,
	CTRL_ATTR_HDRSIZE = 4,
	CTRL_ATTR_MAXATTR = 5,
	CTRL_ATTR_OPS = 6,
	CTRL_ATTR_MCAST_GROUPS = 7,
	CTRL_ATTR_POLICY = 8,
	CTRL_ATTR_OP_POLICY = 9,
	CTRL_ATTR_OP = 10,
	__CTRL_ATTR_MAX = 11,
};

enum {
	CTRL_CMD_UNSPEC = 0,
	CTRL_CMD_NEWFAMILY = 1,
	CTRL_CMD_DELFAMILY = 2,
	CTRL_CMD_GETFAMILY = 3,
	CTRL_CMD_NEWOPS = 4,
	CTRL_CMD_DELOPS = 5,
	CTRL_CMD_GETOPS = 6,
	CTRL_CMD_NEWMCAST_GRP = 7,
	CTRL_CMD_DELMCAST_GRP = 8,
	CTRL_CMD_GETMCAST_GRP = 9,
	CTRL_CMD_GETPOLICY = 10,
	__CTRL_CMD_MAX = 11,
};

enum {
	CTRL_IDE_IRQB = 1073741824,
	CTRL_IDE_IRQA = 268435456,
	CTRL_LEGIRQ = 2048,
	CTRL_P1F16 = 32,
	CTRL_P1EN = 16,
	CTRL_P0F16 = 2,
	CTRL_P0EN = 1,
};

enum {
	CT_GS3_REVISION = 1,
};

enum {
	CT_GSSUBTYPE_CFGSERVER = 1,
	CT_GSSUBTYPE_UNZONED_NS = 2,
	CT_GSSUBTYPE_ZONESERVER = 3,
	CT_GSSUBTYPE_LOCKSERVER = 4,
	CT_GSSUBTYPE_HBA_MGMTSERVER = 16,
};

enum {
	CT_GSSUBTYPE_NAMESERVER = 2,
};

enum {
	CT_GSTYPE_KEYSERVICE = 247,
	CT_GSTYPE_ALIASSERVICE = 248,
	CT_GSTYPE_MGMTSERVICE = 250,
	CT_GSTYPE_TIMESERVICE = 251,
	CT_GSTYPE_DIRSERVICE = 252,
};

enum {
	CT_NS_EXP_NOADDITIONAL = 0,
	CT_NS_EXP_ID_NOT_REG = 1,
	CT_NS_EXP_PN_NOT_REG = 2,
	CT_NS_EXP_NN_NOT_REG = 3,
	CT_NS_EXP_CS_NOT_REG = 4,
	CT_NS_EXP_IPN_NOT_REG = 5,
	CT_NS_EXP_IPA_NOT_REG = 6,
	CT_NS_EXP_FT_NOT_REG = 7,
	CT_NS_EXP_SPN_NOT_REG = 8,
	CT_NS_EXP_SNN_NOT_REG = 9,
	CT_NS_EXP_PT_NOT_REG = 10,
	CT_NS_EXP_IPP_NOT_REG = 11,
	CT_NS_EXP_FPN_NOT_REG = 12,
	CT_NS_EXP_HA_NOT_REG = 13,
	CT_NS_EXP_FD_NOT_REG = 14,
	CT_NS_EXP_FF_NOT_REG = 15,
	CT_NS_EXP_ACCESSDENIED = 16,
	CT_NS_EXP_UNACCEPTABLE_ID = 17,
	CT_NS_EXP_DATABASEEMPTY = 18,
	CT_NS_EXP_NOT_REG_IN_SCOPE = 19,
	CT_NS_EXP_DOM_ID_NOT_PRESENT = 20,
	CT_NS_EXP_PORT_NUM_NOT_PRESENT = 21,
	CT_NS_EXP_NO_DEVICE_ATTACHED = 22,
};

enum {
	CT_RSN_INV_CMD = 1,
	CT_RSN_INV_VER = 2,
	CT_RSN_LOGIC_ERR = 3,
	CT_RSN_INV_SIZE = 4,
	CT_RSN_LOGICAL_BUSY = 5,
	CT_RSN_PROTO_ERR = 7,
	CT_RSN_UNABLE_TO_PERF = 9,
	CT_RSN_NOT_SUPP = 11,
	CT_RSN_SERVER_NOT_AVBL = 13,
	CT_RSN_SESSION_COULD_NOT_BE_ESTBD = 14,
	CT_RSN_VENDOR_SPECIFIC = 255,
};

enum {
	CT_RSP_REJECT = 32769,
	CT_RSP_ACCEPT = 32770,
};

enum {
	CXL_MEM_COMMAND_ID_INVALID = 0,
	CXL_MEM_COMMAND_ID_IDENTIFY = 1,
	CXL_MEM_COMMAND_ID_RAW = 2,
	CXL_MEM_COMMAND_ID_GET_SUPPORTED_LOGS = 3,
	CXL_MEM_COMMAND_ID_GET_FW_INFO = 4,
	CXL_MEM_COMMAND_ID_GET_PARTITION_INFO = 5,
	CXL_MEM_COMMAND_ID_GET_LSA = 6,
	CXL_MEM_COMMAND_ID_GET_HEALTH_INFO = 7,
	CXL_MEM_COMMAND_ID_GET_LOG = 8,
	CXL_MEM_COMMAND_ID_SET_PARTITION_INFO = 9,
	CXL_MEM_COMMAND_ID_SET_LSA = 10,
	CXL_MEM_COMMAND_ID_GET_ALERT_CONFIG = 11,
	CXL_MEM_COMMAND_ID_SET_ALERT_CONFIG = 12,
	CXL_MEM_COMMAND_ID_GET_SHUTDOWN_STATE = 13,
	CXL_MEM_COMMAND_ID_SET_SHUTDOWN_STATE = 14,
	CXL_MEM_DEPRECATED_ID_GET_POISON = 15,
	CXL_MEM_DEPRECATED_ID_INJECT_POISON = 16,
	CXL_MEM_DEPRECATED_ID_CLEAR_POISON = 17,
	CXL_MEM_COMMAND_ID_GET_SCAN_MEDIA_CAPS = 18,
	CXL_MEM_DEPRECATED_ID_SCAN_MEDIA = 19,
	CXL_MEM_DEPRECATED_ID_GET_SCAN_MEDIA = 20,
	CXL_MEM_COMMAND_ID_GET_TIMESTAMP = 21,
	CXL_MEM_COMMAND_ID_GET_LOG_CAPS = 22,
	CXL_MEM_COMMAND_ID_CLEAR_LOG = 23,
	CXL_MEM_COMMAND_ID_GET_SUP_LOG_SUBLIST = 24,
	CXL_MEM_COMMAND_ID_MAX = 25,
};

enum {
	CY82_IDE_CMDREG = 4,
	CY82_IDE_ADDRSETUP = 72,
	CY82_IDE_MASTER_IOR = 76,
	CY82_IDE_MASTER_IOW = 77,
	CY82_IDE_SLAVE_IOR = 78,
	CY82_IDE_SLAVE_IOW = 79,
	CY82_IDE_MASTER_8BIT = 80,
	CY82_IDE_SLAVE_8BIT = 81,
	CY82_INDEX_PORT = 34,
	CY82_DATA_PORT = 35,
	CY82_INDEX_CTRLREG1 = 1,
	CY82_INDEX_CHANNEL0 = 48,
	CY82_INDEX_CHANNEL1 = 49,
	CY82_INDEX_TIMEOUT = 50,
};

enum {
	D0TIM = 128,
	D1TIM = 132,
	PM = 7,
	MDM = 768,
	UDM = 458752,
	PPE = 1073741824,
	USD = -2147483648,
};

enum {
	DAD_PROCESS = 0,
	DAD_BEGIN = 1,
	DAD_ABORT = 2,
};

enum {
	DBGI_MODE_MBUS = 0,
	DBGI_MODE_IDT52100 = 5,
};

enum {
	DDW_EXT_SIZE = 0,
	DDW_EXT_RESET_DMA_WIN = 1,
	DDW_EXT_QUERY_OUT_SIZE = 2,
};

enum {
	DDW_QUERY_PE_DMA_WIN = 0,
	DDW_CREATE_PE_DMA_WIN = 1,
	DDW_REMOVE_PE_DMA_WIN = 2,
	DDW_APPLICABLE_SIZE = 3,
};

enum {
	DD_DIR_COUNT = 2,
};

enum {
	DD_PRIO_COUNT = 3,
};

enum {
	DEFAULT_NSERVERS = 512,
	DEFAULT_NFILTERS = 128,
};

enum {
	DEVCONF_FORWARDING = 0,
	DEVCONF_HOPLIMIT = 1,
	DEVCONF_MTU6 = 2,
	DEVCONF_ACCEPT_RA = 3,
	DEVCONF_ACCEPT_REDIRECTS = 4,
	DEVCONF_AUTOCONF = 5,
	DEVCONF_DAD_TRANSMITS = 6,
	DEVCONF_RTR_SOLICITS = 7,
	DEVCONF_RTR_SOLICIT_INTERVAL = 8,
	DEVCONF_RTR_SOLICIT_DELAY = 9,
	DEVCONF_USE_TEMPADDR = 10,
	DEVCONF_TEMP_VALID_LFT = 11,
	DEVCONF_TEMP_PREFERED_LFT = 12,
	DEVCONF_REGEN_MAX_RETRY = 13,
	DEVCONF_MAX_DESYNC_FACTOR = 14,
	DEVCONF_MAX_ADDRESSES = 15,
	DEVCONF_FORCE_MLD_VERSION = 16,
	DEVCONF_ACCEPT_RA_DEFRTR = 17,
	DEVCONF_ACCEPT_RA_PINFO = 18,
	DEVCONF_ACCEPT_RA_RTR_PREF = 19,
	DEVCONF_RTR_PROBE_INTERVAL = 20,
	DEVCONF_ACCEPT_RA_RT_INFO_MAX_PLEN = 21,
	DEVCONF_PROXY_NDP = 22,
	DEVCONF_OPTIMISTIC_DAD = 23,
	DEVCONF_ACCEPT_SOURCE_ROUTE = 24,
	DEVCONF_MC_FORWARDING = 25,
	DEVCONF_DISABLE_IPV6 = 26,
	DEVCONF_ACCEPT_DAD = 27,
	DEVCONF_FORCE_TLLAO = 28,
	DEVCONF_NDISC_NOTIFY = 29,
	DEVCONF_MLDV1_UNSOLICITED_REPORT_INTERVAL = 30,
	DEVCONF_MLDV2_UNSOLICITED_REPORT_INTERVAL = 31,
	DEVCONF_SUPPRESS_FRAG_NDISC = 32,
	DEVCONF_ACCEPT_RA_FROM_LOCAL = 33,
	DEVCONF_USE_OPTIMISTIC = 34,
	DEVCONF_ACCEPT_RA_MTU = 35,
	DEVCONF_STABLE_SECRET = 36,
	DEVCONF_USE_OIF_ADDRS_ONLY = 37,
	DEVCONF_ACCEPT_RA_MIN_HOP_LIMIT = 38,
	DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 39,
	DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 40,
	DEVCONF_DROP_UNSOLICITED_NA = 41,
	DEVCONF_KEEP_ADDR_ON_DOWN = 42,
	DEVCONF_RTR_SOLICIT_MAX_INTERVAL = 43,
	DEVCONF_SEG6_ENABLED = 44,
	DEVCONF_SEG6_REQUIRE_HMAC = 45,
	DEVCONF_ENHANCED_DAD = 46,
	DEVCONF_ADDR_GEN_MODE = 47,
	DEVCONF_DISABLE_POLICY = 48,
	DEVCONF_ACCEPT_RA_RT_INFO_MIN_PLEN = 49,
	DEVCONF_NDISC_TCLASS = 50,
	DEVCONF_RPL_SEG_ENABLED = 51,
	DEVCONF_RA_DEFRTR_METRIC = 52,
	DEVCONF_IOAM6_ENABLED = 53,
	DEVCONF_IOAM6_ID = 54,
	DEVCONF_IOAM6_ID_WIDE = 55,
	DEVCONF_NDISC_EVICT_NOCARRIER = 56,
	DEVCONF_ACCEPT_UNTRACKED_NA = 57,
	DEVCONF_ACCEPT_RA_MIN_LFT = 58,
	DEVCONF_MAX = 59,
};

enum {
	DEVLINK_ATTR_STATS_RX_PACKETS = 0,
	DEVLINK_ATTR_STATS_RX_BYTES = 1,
	DEVLINK_ATTR_STATS_RX_DROPPED = 2,
	__DEVLINK_ATTR_STATS_MAX = 3,
	DEVLINK_ATTR_STATS_MAX = 2,
};

enum {
	DEVLINK_ATTR_TRAP_METADATA_TYPE_IN_PORT = 0,
	DEVLINK_ATTR_TRAP_METADATA_TYPE_FA_COOKIE = 1,
};

enum {
	DIO_LOCKING = 1,
	DIO_SKIP_HOLES = 2,
};

enum {
	DIO_SHOULD_DIRTY = 1,
	DIO_IS_SYNC = 2,
};

enum {
	DIR_OFFSET_MIN = 2,
};

enum {
	DISCOVERED = 16,
	EXPLORED = 32,
	FALLTHROUGH = 1,
	BRANCH = 2,
};

enum {
	DISK_EVENT_FLAG_POLL = 1,
	DISK_EVENT_FLAG_UEVENT = 2,
	DISK_EVENT_FLAG_BLOCK_ON_EXCL_WRITE = 4,
};

enum {
	DISK_EVENT_MEDIA_CHANGE = 1,
	DISK_EVENT_EJECT_REQUEST = 2,
};

enum {
	DONE_EXPLORING = 0,
	KEEP_EXPLORING = 1,
};

enum {
	DPLL_NLGRP_MONITOR = 0,
};

enum {
	DQF_INFO_DIRTY_B = 17,
};

enum {
	DQF_ROOT_SQUASH_B = 0,
	DQF_SYS_FILE_B = 16,
	DQF_PRIVATE = 17,
};

enum {
	DQST_LOOKUPS = 0,
	DQST_DROPS = 1,
	DQST_READS = 2,
	DQST_WRITES = 3,
	DQST_CACHE_HITS = 4,
	DQST_ALLOC_DQUOTS = 5,
	DQST_FREE_DQUOTS = 6,
	DQST_SYNCS = 7,
	_DQST_DQSTAT_LAST = 8,
};

enum {
	DRBL_HANDSHAKE = 1,
	DRBL_SOFT_RESET = 2,
	DRBL_BUS_CHANGE = 4,
	DRBL_EVENT_NOTIFY = 8,
	DRBL_MU_RESET = 16,
	DRBL_HANDSHAKE_ISR = 1,
	CMD_FLAG_NON_DATA = 1,
	CMD_FLAG_DMA = 2,
	CMD_FLAG_PIO = 4,
	CMD_FLAG_DATA_IN = 8,
	CMD_FLAG_DATA_OUT = 16,
	CMD_FLAG_PRDT_IN_HOST = 32,
};

enum {
	DTRIG_UNKNOWN = 0,
	DTRIG_VECTOR_CI = 1,
	DTRIG_SUSPEND_ESCAPE = 2,
};

enum {
	DUMP_IO = 0,
	DUMP_MBX = 1,
	DUMP_ELS = 2,
	DUMP_NVMELS = 3,
};

enum {
	DUMP_PREFIX_NONE = 0,
	DUMP_PREFIX_ADDRESS = 1,
	DUMP_PREFIX_OFFSET = 2,
};

enum {
	EDC_OPT_AEL2005 = 0,
	EDC_OPT_AEL2005_SIZE = 1084,
	EDC_TWX_AEL2005 = 1,
	EDC_TWX_AEL2005_SIZE = 1464,
	EDC_TWX_AEL2020 = 2,
	EDC_TWX_AEL2020_SIZE = 1628,
	EDC_MAX_SIZE = 1628,
};

enum {
	EEH_NEXT_ERR_NONE = 0,
	EEH_NEXT_ERR_INF = 1,
	EEH_NEXT_ERR_FROZEN_PE = 2,
	EEH_NEXT_ERR_FENCED_PHB = 3,
	EEH_NEXT_ERR_DEAD_PHB = 4,
	EEH_NEXT_ERR_DEAD_IOC = 5,
};

enum {
	EI_ETYPE_NULL = 0,
	EI_ETYPE_ERRNO = 1,
	EI_ETYPE_ERRNO_NULL = 2,
	EI_ETYPE_TRUE = 3,
};

enum {
	EP_STATE_IDLE = 0,
	EP_STATE_PG_OFLD_START = 1,
	EP_STATE_PG_OFLD_COMPL = 2,
	EP_STATE_OFLD_START = 4,
	EP_STATE_OFLD_COMPL = 8,
	EP_STATE_CONNECT_START = 16,
	EP_STATE_CONNECT_COMPL = 32,
	EP_STATE_ULP_UPDATE_START = 64,
	EP_STATE_ULP_UPDATE_COMPL = 128,
	EP_STATE_DISCONN_START = 256,
	EP_STATE_DISCONN_COMPL = 512,
	EP_STATE_CLEANUP_START = 1024,
	EP_STATE_CLEANUP_CMPL = 2048,
	EP_STATE_TCP_FIN_RCVD = 4096,
	EP_STATE_TCP_RST_RCVD = 8192,
	EP_STATE_LOGOUT_SENT = 16384,
	EP_STATE_LOGOUT_RESP_RCVD = 32768,
	EP_STATE_PG_OFLD_FAILED = 16777216,
	EP_STATE_ULP_UPDATE_FAILED = 33554432,
	EP_STATE_CLEANUP_FAILED = 67108864,
	EP_STATE_OFLD_FAILED = 134217728,
	EP_STATE_CONNECT_FAILED = 268435456,
	EP_STATE_DISCONN_TIMEDOUT = 536870912,
	EP_STATE_OFLD_FAILED_CID_BUSY = 2147483648,
};

enum {
	EPecma = 0,
	EPdec = 1,
	EPeq = 2,
	EPgt = 3,
	EPlt = 4,
};

enum {
	ERASE = 0,
	WERASE = 1,
	KILL = 2,
};

enum {
	ESAS2R_LOG_NONE = 0,
	ESAS2R_LOG_CRIT = 1,
	ESAS2R_LOG_WARN = 2,
	ESAS2R_LOG_INFO = 3,
	ESAS2R_LOG_DEBG = 4,
	ESAS2R_LOG_TRCE = 5,
	ESAS2R_LOG_DFLT = 2,
};

enum {
	ES_WRITTEN_B = 0,
	ES_UNWRITTEN_B = 1,
	ES_DELAYED_B = 2,
	ES_HOLE_B = 3,
	ES_REFERENCED_B = 4,
	ES_FLAGS = 5,
};

enum {
	ETHTOOL_A_BITSET_BITS_UNSPEC = 0,
	ETHTOOL_A_BITSET_BITS_BIT = 1,
	__ETHTOOL_A_BITSET_BITS_CNT = 2,
	ETHTOOL_A_BITSET_BITS_MAX = 1,
};

enum {
	ETHTOOL_A_BITSET_BIT_UNSPEC = 0,
	ETHTOOL_A_BITSET_BIT_INDEX = 1,
	ETHTOOL_A_BITSET_BIT_NAME = 2,
	ETHTOOL_A_BITSET_BIT_VALUE = 3,
	__ETHTOOL_A_BITSET_BIT_CNT = 4,
	ETHTOOL_A_BITSET_BIT_MAX = 3,
};

enum {
	ETHTOOL_A_BITSET_UNSPEC = 0,
	ETHTOOL_A_BITSET_NOMASK = 1,
	ETHTOOL_A_BITSET_SIZE = 2,
	ETHTOOL_A_BITSET_BITS = 3,
	ETHTOOL_A_BITSET_VALUE = 4,
	ETHTOOL_A_BITSET_MASK = 5,
	__ETHTOOL_A_BITSET_CNT = 6,
	ETHTOOL_A_BITSET_MAX = 5,
};

enum {
	ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC = 0,
	ETHTOOL_A_CABLE_AMPLITUDE_PAIR = 1,
	ETHTOOL_A_CABLE_AMPLITUDE_mV = 2,
	__ETHTOOL_A_CABLE_AMPLITUDE_CNT = 3,
	ETHTOOL_A_CABLE_AMPLITUDE_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC = 0,
	ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR = 1,
	ETHTOOL_A_CABLE_FAULT_LENGTH_CM = 2,
	__ETHTOOL_A_CABLE_FAULT_LENGTH_CNT = 3,
	ETHTOOL_A_CABLE_FAULT_LENGTH_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_NEST_RESULT = 1,
	ETHTOOL_A_CABLE_NEST_FAULT_LENGTH = 2,
	__ETHTOOL_A_CABLE_NEST_CNT = 3,
	ETHTOOL_A_CABLE_NEST_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_PAIR_A = 0,
	ETHTOOL_A_CABLE_PAIR_B = 1,
	ETHTOOL_A_CABLE_PAIR_C = 2,
	ETHTOOL_A_CABLE_PAIR_D = 3,
};

enum {
	ETHTOOL_A_CABLE_PULSE_UNSPEC = 0,
	ETHTOOL_A_CABLE_PULSE_mV = 1,
	__ETHTOOL_A_CABLE_PULSE_CNT = 2,
	ETHTOOL_A_CABLE_PULSE_MAX = 1,
};

enum {
	ETHTOOL_A_CABLE_RESULT_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_PAIR = 1,
	ETHTOOL_A_CABLE_RESULT_CODE = 2,
	__ETHTOOL_A_CABLE_RESULT_CNT = 3,
	ETHTOOL_A_CABLE_RESULT_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_STEP_UNSPEC = 0,
	ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE = 1,
	ETHTOOL_A_CABLE_STEP_LAST_DISTANCE = 2,
	ETHTOOL_A_CABLE_STEP_STEP_DISTANCE = 3,
	__ETHTOOL_A_CABLE_STEP_CNT = 4,
	ETHTOOL_A_CABLE_STEP_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TDR_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TDR_NEST_STEP = 1,
	ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE = 2,
	ETHTOOL_A_CABLE_TDR_NEST_PULSE = 3,
	__ETHTOOL_A_CABLE_TDR_NEST_CNT = 4,
	ETHTOOL_A_CABLE_TDR_NEST_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS = 2,
	ETHTOOL_A_CABLE_TEST_NTF_NEST = 3,
	__ETHTOOL_A_CABLE_TEST_NTF_CNT = 4,
	ETHTOOL_A_CABLE_TEST_NTF_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST = 2,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP = 3,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR = 4,
	__ETHTOOL_A_CABLE_TEST_TDR_CFG_CNT = 5,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX = 4,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG = 2,
	__ETHTOOL_A_CABLE_TEST_TDR_CNT = 3,
	ETHTOOL_A_CABLE_TEST_TDR_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_HEADER = 1,
	__ETHTOOL_A_CABLE_TEST_CNT = 2,
	ETHTOOL_A_CABLE_TEST_MAX = 1,
};

enum {
	ETHTOOL_A_CHANNELS_UNSPEC = 0,
	ETHTOOL_A_CHANNELS_HEADER = 1,
	ETHTOOL_A_CHANNELS_RX_MAX = 2,
	ETHTOOL_A_CHANNELS_TX_MAX = 3,
	ETHTOOL_A_CHANNELS_OTHER_MAX = 4,
	ETHTOOL_A_CHANNELS_COMBINED_MAX = 5,
	ETHTOOL_A_CHANNELS_RX_COUNT = 6,
	ETHTOOL_A_CHANNELS_TX_COUNT = 7,
	ETHTOOL_A_CHANNELS_OTHER_COUNT = 8,
	ETHTOOL_A_CHANNELS_COMBINED_COUNT = 9,
	__ETHTOOL_A_CHANNELS_CNT = 10,
	ETHTOOL_A_CHANNELS_MAX = 9,
};

enum {
	ETHTOOL_A_COALESCE_UNSPEC = 0,
	ETHTOOL_A_COALESCE_HEADER = 1,
	ETHTOOL_A_COALESCE_RX_USECS = 2,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES = 3,
	ETHTOOL_A_COALESCE_RX_USECS_IRQ = 4,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ = 5,
	ETHTOOL_A_COALESCE_TX_USECS = 6,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES = 7,
	ETHTOOL_A_COALESCE_TX_USECS_IRQ = 8,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ = 9,
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS = 10,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX = 11,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX = 12,
	ETHTOOL_A_COALESCE_PKT_RATE_LOW = 13,
	ETHTOOL_A_COALESCE_RX_USECS_LOW = 14,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW = 15,
	ETHTOOL_A_COALESCE_TX_USECS_LOW = 16,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW = 17,
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH = 18,
	ETHTOOL_A_COALESCE_RX_USECS_HIGH = 19,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH = 20,
	ETHTOOL_A_COALESCE_TX_USECS_HIGH = 21,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH = 22,
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL = 23,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX = 24,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX = 25,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_BYTES = 26,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_FRAMES = 27,
	ETHTOOL_A_COALESCE_TX_AGGR_TIME_USECS = 28,
	__ETHTOOL_A_COALESCE_CNT = 29,
	ETHTOOL_A_COALESCE_MAX = 28,
};

enum {
	ETHTOOL_A_DEBUG_UNSPEC = 0,
	ETHTOOL_A_DEBUG_HEADER = 1,
	ETHTOOL_A_DEBUG_MSGMASK = 2,
	__ETHTOOL_A_DEBUG_CNT = 3,
	ETHTOOL_A_DEBUG_MAX = 2,
};

enum {
	ETHTOOL_A_EEE_UNSPEC = 0,
	ETHTOOL_A_EEE_HEADER = 1,
	ETHTOOL_A_EEE_MODES_OURS = 2,
	ETHTOOL_A_EEE_MODES_PEER = 3,
	ETHTOOL_A_EEE_ACTIVE = 4,
	ETHTOOL_A_EEE_ENABLED = 5,
	ETHTOOL_A_EEE_TX_LPI_ENABLED = 6,
	ETHTOOL_A_EEE_TX_LPI_TIMER = 7,
	__ETHTOOL_A_EEE_CNT = 8,
	ETHTOOL_A_EEE_MAX = 7,
};

enum {
	ETHTOOL_A_FEATURES_UNSPEC = 0,
	ETHTOOL_A_FEATURES_HEADER = 1,
	ETHTOOL_A_FEATURES_HW = 2,
	ETHTOOL_A_FEATURES_WANTED = 3,
	ETHTOOL_A_FEATURES_ACTIVE = 4,
	ETHTOOL_A_FEATURES_NOCHANGE = 5,
	__ETHTOOL_A_FEATURES_CNT = 6,
	ETHTOOL_A_FEATURES_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_STAT_UNSPEC = 0,
	ETHTOOL_A_FEC_STAT_PAD = 1,
	ETHTOOL_A_FEC_STAT_CORRECTED = 2,
	ETHTOOL_A_FEC_STAT_UNCORR = 3,
	ETHTOOL_A_FEC_STAT_CORR_BITS = 4,
	__ETHTOOL_A_FEC_STAT_CNT = 5,
	ETHTOOL_A_FEC_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_FEC_UNSPEC = 0,
	ETHTOOL_A_FEC_HEADER = 1,
	ETHTOOL_A_FEC_MODES = 2,
	ETHTOOL_A_FEC_AUTO = 3,
	ETHTOOL_A_FEC_ACTIVE = 4,
	ETHTOOL_A_FEC_STATS = 5,
	__ETHTOOL_A_FEC_CNT = 6,
	ETHTOOL_A_FEC_MAX = 5,
};

enum {
	ETHTOOL_A_HEADER_UNSPEC = 0,
	ETHTOOL_A_HEADER_DEV_INDEX = 1,
	ETHTOOL_A_HEADER_DEV_NAME = 2,
	ETHTOOL_A_HEADER_FLAGS = 3,
	__ETHTOOL_A_HEADER_CNT = 4,
	ETHTOOL_A_HEADER_MAX = 3,
};

enum {
	ETHTOOL_A_LINKINFO_UNSPEC = 0,
	ETHTOOL_A_LINKINFO_HEADER = 1,
	ETHTOOL_A_LINKINFO_PORT = 2,
	ETHTOOL_A_LINKINFO_PHYADDR = 3,
	ETHTOOL_A_LINKINFO_TP_MDIX = 4,
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL = 5,
	ETHTOOL_A_LINKINFO_TRANSCEIVER = 6,
	__ETHTOOL_A_LINKINFO_CNT = 7,
	ETHTOOL_A_LINKINFO_MAX = 6,
};

enum {
	ETHTOOL_A_LINKMODES_UNSPEC = 0,
	ETHTOOL_A_LINKMODES_HEADER = 1,
	ETHTOOL_A_LINKMODES_AUTONEG = 2,
	ETHTOOL_A_LINKMODES_OURS = 3,
	ETHTOOL_A_LINKMODES_PEER = 4,
	ETHTOOL_A_LINKMODES_SPEED = 5,
	ETHTOOL_A_LINKMODES_DUPLEX = 6,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG = 7,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE = 8,
	ETHTOOL_A_LINKMODES_LANES = 9,
	ETHTOOL_A_LINKMODES_RATE_MATCHING = 10,
	__ETHTOOL_A_LINKMODES_CNT = 11,
	ETHTOOL_A_LINKMODES_MAX = 10,
};

enum {
	ETHTOOL_A_LINKSTATE_UNSPEC = 0,
	ETHTOOL_A_LINKSTATE_HEADER = 1,
	ETHTOOL_A_LINKSTATE_LINK = 2,
	ETHTOOL_A_LINKSTATE_SQI = 3,
	ETHTOOL_A_LINKSTATE_SQI_MAX = 4,
	ETHTOOL_A_LINKSTATE_EXT_STATE = 5,
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE = 6,
	ETHTOOL_A_LINKSTATE_EXT_DOWN_CNT = 7,
	__ETHTOOL_A_LINKSTATE_CNT = 8,
	ETHTOOL_A_LINKSTATE_MAX = 7,
};

enum {
	ETHTOOL_A_MM_STAT_UNSPEC = 0,
	ETHTOOL_A_MM_STAT_PAD = 1,
	ETHTOOL_A_MM_STAT_REASSEMBLY_ERRORS = 2,
	ETHTOOL_A_MM_STAT_SMD_ERRORS = 3,
	ETHTOOL_A_MM_STAT_REASSEMBLY_OK = 4,
	ETHTOOL_A_MM_STAT_RX_FRAG_COUNT = 5,
	ETHTOOL_A_MM_STAT_TX_FRAG_COUNT = 6,
	ETHTOOL_A_MM_STAT_HOLD_COUNT = 7,
	__ETHTOOL_A_MM_STAT_CNT = 8,
	ETHTOOL_A_MM_STAT_MAX = 7,
};

enum {
	ETHTOOL_A_MM_UNSPEC = 0,
	ETHTOOL_A_MM_HEADER = 1,
	ETHTOOL_A_MM_PMAC_ENABLED = 2,
	ETHTOOL_A_MM_TX_ENABLED = 3,
	ETHTOOL_A_MM_TX_ACTIVE = 4,
	ETHTOOL_A_MM_TX_MIN_FRAG_SIZE = 5,
	ETHTOOL_A_MM_RX_MIN_FRAG_SIZE = 6,
	ETHTOOL_A_MM_VERIFY_ENABLED = 7,
	ETHTOOL_A_MM_VERIFY_STATUS = 8,
	ETHTOOL_A_MM_VERIFY_TIME = 9,
	ETHTOOL_A_MM_MAX_VERIFY_TIME = 10,
	ETHTOOL_A_MM_STATS = 11,
	__ETHTOOL_A_MM_CNT = 12,
	ETHTOOL_A_MM_MAX = 11,
};

enum {
	ETHTOOL_A_MODULE_EEPROM_UNSPEC = 0,
	ETHTOOL_A_MODULE_EEPROM_HEADER = 1,
	ETHTOOL_A_MODULE_EEPROM_OFFSET = 2,
	ETHTOOL_A_MODULE_EEPROM_LENGTH = 3,
	ETHTOOL_A_MODULE_EEPROM_PAGE = 4,
	ETHTOOL_A_MODULE_EEPROM_BANK = 5,
	ETHTOOL_A_MODULE_EEPROM_I2C_ADDRESS = 6,
	ETHTOOL_A_MODULE_EEPROM_DATA = 7,
	__ETHTOOL_A_MODULE_EEPROM_CNT = 8,
	ETHTOOL_A_MODULE_EEPROM_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_UNSPEC = 0,
	ETHTOOL_A_MODULE_HEADER = 1,
	ETHTOOL_A_MODULE_POWER_MODE_POLICY = 2,
	ETHTOOL_A_MODULE_POWER_MODE = 3,
	__ETHTOOL_A_MODULE_CNT = 4,
	ETHTOOL_A_MODULE_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_STAT_UNSPEC = 0,
	ETHTOOL_A_PAUSE_STAT_PAD = 1,
	ETHTOOL_A_PAUSE_STAT_TX_FRAMES = 2,
	ETHTOOL_A_PAUSE_STAT_RX_FRAMES = 3,
	__ETHTOOL_A_PAUSE_STAT_CNT = 4,
	ETHTOOL_A_PAUSE_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_UNSPEC = 0,
	ETHTOOL_A_PAUSE_HEADER = 1,
	ETHTOOL_A_PAUSE_AUTONEG = 2,
	ETHTOOL_A_PAUSE_RX = 3,
	ETHTOOL_A_PAUSE_TX = 4,
	ETHTOOL_A_PAUSE_STATS = 5,
	ETHTOOL_A_PAUSE_STATS_SRC = 6,
	__ETHTOOL_A_PAUSE_CNT = 7,
	ETHTOOL_A_PAUSE_MAX = 6,
};

enum {
	ETHTOOL_A_PHC_VCLOCKS_UNSPEC = 0,
	ETHTOOL_A_PHC_VCLOCKS_HEADER = 1,
	ETHTOOL_A_PHC_VCLOCKS_NUM = 2,
	ETHTOOL_A_PHC_VCLOCKS_INDEX = 3,
	__ETHTOOL_A_PHC_VCLOCKS_CNT = 4,
	ETHTOOL_A_PHC_VCLOCKS_MAX = 3,
};

enum {
	ETHTOOL_A_PLCA_UNSPEC = 0,
	ETHTOOL_A_PLCA_HEADER = 1,
	ETHTOOL_A_PLCA_VERSION = 2,
	ETHTOOL_A_PLCA_ENABLED = 3,
	ETHTOOL_A_PLCA_STATUS = 4,
	ETHTOOL_A_PLCA_NODE_CNT = 5,
	ETHTOOL_A_PLCA_NODE_ID = 6,
	ETHTOOL_A_PLCA_TO_TMR = 7,
	ETHTOOL_A_PLCA_BURST_CNT = 8,
	ETHTOOL_A_PLCA_BURST_TMR = 9,
	__ETHTOOL_A_PLCA_CNT = 10,
	ETHTOOL_A_PLCA_MAX = 9,
};

enum {
	ETHTOOL_A_PRIVFLAGS_UNSPEC = 0,
	ETHTOOL_A_PRIVFLAGS_HEADER = 1,
	ETHTOOL_A_PRIVFLAGS_FLAGS = 2,
	__ETHTOOL_A_PRIVFLAGS_CNT = 3,
	ETHTOOL_A_PRIVFLAGS_MAX = 2,
};

enum {
	ETHTOOL_A_PSE_UNSPEC = 0,
	ETHTOOL_A_PSE_HEADER = 1,
	ETHTOOL_A_PODL_PSE_ADMIN_STATE = 2,
	ETHTOOL_A_PODL_PSE_ADMIN_CONTROL = 3,
	ETHTOOL_A_PODL_PSE_PW_D_STATUS = 4,
	ETHTOOL_A_C33_PSE_ADMIN_STATE = 5,
	ETHTOOL_A_C33_PSE_ADMIN_CONTROL = 6,
	ETHTOOL_A_C33_PSE_PW_D_STATUS = 7,
	__ETHTOOL_A_PSE_CNT = 8,
	ETHTOOL_A_PSE_MAX = 7,
};

enum {
	ETHTOOL_A_RINGS_UNSPEC = 0,
	ETHTOOL_A_RINGS_HEADER = 1,
	ETHTOOL_A_RINGS_RX_MAX = 2,
	ETHTOOL_A_RINGS_RX_MINI_MAX = 3,
	ETHTOOL_A_RINGS_RX_JUMBO_MAX = 4,
	ETHTOOL_A_RINGS_TX_MAX = 5,
	ETHTOOL_A_RINGS_RX = 6,
	ETHTOOL_A_RINGS_RX_MINI = 7,
	ETHTOOL_A_RINGS_RX_JUMBO = 8,
	ETHTOOL_A_RINGS_TX = 9,
	ETHTOOL_A_RINGS_RX_BUF_LEN = 10,
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT = 11,
	ETHTOOL_A_RINGS_CQE_SIZE = 12,
	ETHTOOL_A_RINGS_TX_PUSH = 13,
	ETHTOOL_A_RINGS_RX_PUSH = 14,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN = 15,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN_MAX = 16,
	__ETHTOOL_A_RINGS_CNT = 17,
	ETHTOOL_A_RINGS_MAX = 16,
};

enum {
	ETHTOOL_A_RSS_UNSPEC = 0,
	ETHTOOL_A_RSS_HEADER = 1,
	ETHTOOL_A_RSS_CONTEXT = 2,
	ETHTOOL_A_RSS_HFUNC = 3,
	ETHTOOL_A_RSS_INDIR = 4,
	ETHTOOL_A_RSS_HKEY = 5,
	ETHTOOL_A_RSS_INPUT_XFRM = 6,
	__ETHTOOL_A_RSS_CNT = 7,
	ETHTOOL_A_RSS_MAX = 6,
};

enum {
	ETHTOOL_A_STATS_ETH_CTRL_3_TX = 0,
	ETHTOOL_A_STATS_ETH_CTRL_4_RX = 1,
	ETHTOOL_A_STATS_ETH_CTRL_5_RX_UNSUP = 2,
	__ETHTOOL_A_STATS_ETH_CTRL_CNT = 3,
	ETHTOOL_A_STATS_ETH_CTRL_MAX = 2,
};

enum {
	ETHTOOL_A_STATS_ETH_MAC_2_TX_PKT = 0,
	ETHTOOL_A_STATS_ETH_MAC_3_SINGLE_COL = 1,
	ETHTOOL_A_STATS_ETH_MAC_4_MULTI_COL = 2,
	ETHTOOL_A_STATS_ETH_MAC_5_RX_PKT = 3,
	ETHTOOL_A_STATS_ETH_MAC_6_FCS_ERR = 4,
	ETHTOOL_A_STATS_ETH_MAC_7_ALIGN_ERR = 5,
	ETHTOOL_A_STATS_ETH_MAC_8_TX_BYTES = 6,
	ETHTOOL_A_STATS_ETH_MAC_9_TX_DEFER = 7,
	ETHTOOL_A_STATS_ETH_MAC_10_LATE_COL = 8,
	ETHTOOL_A_STATS_ETH_MAC_11_XS_COL = 9,
	ETHTOOL_A_STATS_ETH_MAC_12_TX_INT_ERR = 10,
	ETHTOOL_A_STATS_ETH_MAC_13_CS_ERR = 11,
	ETHTOOL_A_STATS_ETH_MAC_14_RX_BYTES = 12,
	ETHTOOL_A_STATS_ETH_MAC_15_RX_INT_ERR = 13,
	ETHTOOL_A_STATS_ETH_MAC_18_TX_MCAST = 14,
	ETHTOOL_A_STATS_ETH_MAC_19_TX_BCAST = 15,
	ETHTOOL_A_STATS_ETH_MAC_20_XS_DEFER = 16,
	ETHTOOL_A_STATS_ETH_MAC_21_RX_MCAST = 17,
	ETHTOOL_A_STATS_ETH_MAC_22_RX_BCAST = 18,
	ETHTOOL_A_STATS_ETH_MAC_23_IR_LEN_ERR = 19,
	ETHTOOL_A_STATS_ETH_MAC_24_OOR_LEN = 20,
	ETHTOOL_A_STATS_ETH_MAC_25_TOO_LONG_ERR = 21,
	__ETHTOOL_A_STATS_ETH_MAC_CNT = 22,
	ETHTOOL_A_STATS_ETH_MAC_MAX = 21,
};

enum {
	ETHTOOL_A_STATS_ETH_PHY_5_SYM_ERR = 0,
	__ETHTOOL_A_STATS_ETH_PHY_CNT = 1,
	ETHTOOL_A_STATS_ETH_PHY_MAX = 0,
};

enum {
	ETHTOOL_A_STATS_GRP_UNSPEC = 0,
	ETHTOOL_A_STATS_GRP_PAD = 1,
	ETHTOOL_A_STATS_GRP_ID = 2,
	ETHTOOL_A_STATS_GRP_SS_ID = 3,
	ETHTOOL_A_STATS_GRP_STAT = 4,
	ETHTOOL_A_STATS_GRP_HIST_RX = 5,
	ETHTOOL_A_STATS_GRP_HIST_TX = 6,
	ETHTOOL_A_STATS_GRP_HIST_BKT_LOW = 7,
	ETHTOOL_A_STATS_GRP_HIST_BKT_HI = 8,
	ETHTOOL_A_STATS_GRP_HIST_VAL = 9,
	__ETHTOOL_A_STATS_GRP_CNT = 10,
	ETHTOOL_A_STATS_GRP_MAX = 9,
};

enum {
	ETHTOOL_A_STATS_RMON_UNDERSIZE = 0,
	ETHTOOL_A_STATS_RMON_OVERSIZE = 1,
	ETHTOOL_A_STATS_RMON_FRAG = 2,
	ETHTOOL_A_STATS_RMON_JABBER = 3,
	__ETHTOOL_A_STATS_RMON_CNT = 4,
	ETHTOOL_A_STATS_RMON_MAX = 3,
};

enum {
	ETHTOOL_A_STATS_UNSPEC = 0,
	ETHTOOL_A_STATS_PAD = 1,
	ETHTOOL_A_STATS_HEADER = 2,
	ETHTOOL_A_STATS_GROUPS = 3,
	ETHTOOL_A_STATS_GRP = 4,
	ETHTOOL_A_STATS_SRC = 5,
	__ETHTOOL_A_STATS_CNT = 6,
	ETHTOOL_A_STATS_MAX = 5,
};

enum {
	ETHTOOL_A_STRINGSETS_UNSPEC = 0,
	ETHTOOL_A_STRINGSETS_STRINGSET = 1,
	__ETHTOOL_A_STRINGSETS_CNT = 2,
	ETHTOOL_A_STRINGSETS_MAX = 1,
};

enum {
	ETHTOOL_A_STRINGSET_UNSPEC = 0,
	ETHTOOL_A_STRINGSET_ID = 1,
	ETHTOOL_A_STRINGSET_COUNT = 2,
	ETHTOOL_A_STRINGSET_STRINGS = 3,
	__ETHTOOL_A_STRINGSET_CNT = 4,
	ETHTOOL_A_STRINGSET_MAX = 3,
};

enum {
	ETHTOOL_A_STRINGS_UNSPEC = 0,
	ETHTOOL_A_STRINGS_STRING = 1,
	__ETHTOOL_A_STRINGS_CNT = 2,
	ETHTOOL_A_STRINGS_MAX = 1,
};

enum {
	ETHTOOL_A_STRING_UNSPEC = 0,
	ETHTOOL_A_STRING_INDEX = 1,
	ETHTOOL_A_STRING_VALUE = 2,
	__ETHTOOL_A_STRING_CNT = 3,
	ETHTOOL_A_STRING_MAX = 2,
};

enum {
	ETHTOOL_A_STRSET_UNSPEC = 0,
	ETHTOOL_A_STRSET_HEADER = 1,
	ETHTOOL_A_STRSET_STRINGSETS = 2,
	ETHTOOL_A_STRSET_COUNTS_ONLY = 3,
	__ETHTOOL_A_STRSET_CNT = 4,
	ETHTOOL_A_STRSET_MAX = 3,
};

enum {
	ETHTOOL_A_TSINFO_UNSPEC = 0,
	ETHTOOL_A_TSINFO_HEADER = 1,
	ETHTOOL_A_TSINFO_TIMESTAMPING = 2,
	ETHTOOL_A_TSINFO_TX_TYPES = 3,
	ETHTOOL_A_TSINFO_RX_FILTERS = 4,
	ETHTOOL_A_TSINFO_PHC_INDEX = 5,
	ETHTOOL_A_TSINFO_STATS = 6,
	__ETHTOOL_A_TSINFO_CNT = 7,
	ETHTOOL_A_TSINFO_MAX = 6,
};

enum {
	ETHTOOL_A_TS_STAT_UNSPEC = 0,
	ETHTOOL_A_TS_STAT_TX_PKTS = 1,
	ETHTOOL_A_TS_STAT_TX_LOST = 2,
	ETHTOOL_A_TS_STAT_TX_ERR = 3,
	__ETHTOOL_A_TS_STAT_CNT = 4,
	ETHTOOL_A_TS_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_INFO_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_INFO_HEADER = 1,
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS = 2,
	__ETHTOOL_A_TUNNEL_INFO_CNT = 3,
	ETHTOOL_A_TUNNEL_INFO_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT = 1,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE = 2,
	__ETHTOOL_A_TUNNEL_UDP_ENTRY_CNT = 3,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE = 1,
	ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES = 2,
	ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY = 3,
	__ETHTOOL_A_TUNNEL_UDP_TABLE_CNT = 4,
	ETHTOOL_A_TUNNEL_UDP_TABLE_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE = 1,
	__ETHTOOL_A_TUNNEL_UDP_CNT = 2,
	ETHTOOL_A_TUNNEL_UDP_MAX = 1,
};

enum {
	ETHTOOL_A_WOL_UNSPEC = 0,
	ETHTOOL_A_WOL_HEADER = 1,
	ETHTOOL_A_WOL_MODES = 2,
	ETHTOOL_A_WOL_SOPASS = 3,
	__ETHTOOL_A_WOL_CNT = 4,
	ETHTOOL_A_WOL_MAX = 3,
};

enum {
	ETHTOOL_MSG_KERNEL_NONE = 0,
	ETHTOOL_MSG_STRSET_GET_REPLY = 1,
	ETHTOOL_MSG_LINKINFO_GET_REPLY = 2,
	ETHTOOL_MSG_LINKINFO_NTF = 3,
	ETHTOOL_MSG_LINKMODES_GET_REPLY = 4,
	ETHTOOL_MSG_LINKMODES_NTF = 5,
	ETHTOOL_MSG_LINKSTATE_GET_REPLY = 6,
	ETHTOOL_MSG_DEBUG_GET_REPLY = 7,
	ETHTOOL_MSG_DEBUG_NTF = 8,
	ETHTOOL_MSG_WOL_GET_REPLY = 9,
	ETHTOOL_MSG_WOL_NTF = 10,
	ETHTOOL_MSG_FEATURES_GET_REPLY = 11,
	ETHTOOL_MSG_FEATURES_SET_REPLY = 12,
	ETHTOOL_MSG_FEATURES_NTF = 13,
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY = 14,
	ETHTOOL_MSG_PRIVFLAGS_NTF = 15,
	ETHTOOL_MSG_RINGS_GET_REPLY = 16,
	ETHTOOL_MSG_RINGS_NTF = 17,
	ETHTOOL_MSG_CHANNELS_GET_REPLY = 18,
	ETHTOOL_MSG_CHANNELS_NTF = 19,
	ETHTOOL_MSG_COALESCE_GET_REPLY = 20,
	ETHTOOL_MSG_COALESCE_NTF = 21,
	ETHTOOL_MSG_PAUSE_GET_REPLY = 22,
	ETHTOOL_MSG_PAUSE_NTF = 23,
	ETHTOOL_MSG_EEE_GET_REPLY = 24,
	ETHTOOL_MSG_EEE_NTF = 25,
	ETHTOOL_MSG_TSINFO_GET_REPLY = 26,
	ETHTOOL_MSG_CABLE_TEST_NTF = 27,
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF = 28,
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY = 29,
	ETHTOOL_MSG_FEC_GET_REPLY = 30,
	ETHTOOL_MSG_FEC_NTF = 31,
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY = 32,
	ETHTOOL_MSG_STATS_GET_REPLY = 33,
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY = 34,
	ETHTOOL_MSG_MODULE_GET_REPLY = 35,
	ETHTOOL_MSG_MODULE_NTF = 36,
	ETHTOOL_MSG_PSE_GET_REPLY = 37,
	ETHTOOL_MSG_RSS_GET_REPLY = 38,
	ETHTOOL_MSG_PLCA_GET_CFG_REPLY = 39,
	ETHTOOL_MSG_PLCA_GET_STATUS_REPLY = 40,
	ETHTOOL_MSG_PLCA_NTF = 41,
	ETHTOOL_MSG_MM_GET_REPLY = 42,
	ETHTOOL_MSG_MM_NTF = 43,
	__ETHTOOL_MSG_KERNEL_CNT = 44,
	ETHTOOL_MSG_KERNEL_MAX = 43,
};

enum {
	ETHTOOL_MSG_USER_NONE = 0,
	ETHTOOL_MSG_STRSET_GET = 1,
	ETHTOOL_MSG_LINKINFO_GET = 2,
	ETHTOOL_MSG_LINKINFO_SET = 3,
	ETHTOOL_MSG_LINKMODES_GET = 4,
	ETHTOOL_MSG_LINKMODES_SET = 5,
	ETHTOOL_MSG_LINKSTATE_GET = 6,
	ETHTOOL_MSG_DEBUG_GET = 7,
	ETHTOOL_MSG_DEBUG_SET = 8,
	ETHTOOL_MSG_WOL_GET = 9,
	ETHTOOL_MSG_WOL_SET = 10,
	ETHTOOL_MSG_FEATURES_GET = 11,
	ETHTOOL_MSG_FEATURES_SET = 12,
	ETHTOOL_MSG_PRIVFLAGS_GET = 13,
	ETHTOOL_MSG_PRIVFLAGS_SET = 14,
	ETHTOOL_MSG_RINGS_GET = 15,
	ETHTOOL_MSG_RINGS_SET = 16,
	ETHTOOL_MSG_CHANNELS_GET = 17,
	ETHTOOL_MSG_CHANNELS_SET = 18,
	ETHTOOL_MSG_COALESCE_GET = 19,
	ETHTOOL_MSG_COALESCE_SET = 20,
	ETHTOOL_MSG_PAUSE_GET = 21,
	ETHTOOL_MSG_PAUSE_SET = 22,
	ETHTOOL_MSG_EEE_GET = 23,
	ETHTOOL_MSG_EEE_SET = 24,
	ETHTOOL_MSG_TSINFO_GET = 25,
	ETHTOOL_MSG_CABLE_TEST_ACT = 26,
	ETHTOOL_MSG_CABLE_TEST_TDR_ACT = 27,
	ETHTOOL_MSG_TUNNEL_INFO_GET = 28,
	ETHTOOL_MSG_FEC_GET = 29,
	ETHTOOL_MSG_FEC_SET = 30,
	ETHTOOL_MSG_MODULE_EEPROM_GET = 31,
	ETHTOOL_MSG_STATS_GET = 32,
	ETHTOOL_MSG_PHC_VCLOCKS_GET = 33,
	ETHTOOL_MSG_MODULE_GET = 34,
	ETHTOOL_MSG_MODULE_SET = 35,
	ETHTOOL_MSG_PSE_GET = 36,
	ETHTOOL_MSG_PSE_SET = 37,
	ETHTOOL_MSG_RSS_GET = 38,
	ETHTOOL_MSG_PLCA_GET_CFG = 39,
	ETHTOOL_MSG_PLCA_SET_CFG = 40,
	ETHTOOL_MSG_PLCA_GET_STATUS = 41,
	ETHTOOL_MSG_MM_GET = 42,
	ETHTOOL_MSG_MM_SET = 43,
	__ETHTOOL_MSG_USER_CNT = 44,
	ETHTOOL_MSG_USER_MAX = 43,
};

enum {
	ETHTOOL_STATS_ETH_PHY = 0,
	ETHTOOL_STATS_ETH_MAC = 1,
	ETHTOOL_STATS_ETH_CTRL = 2,
	ETHTOOL_STATS_RMON = 3,
	__ETHTOOL_STATS_CNT = 4,
};

enum {
	ETHTOOL_TCP_DATA_SPLIT_UNKNOWN = 0,
	ETHTOOL_TCP_DATA_SPLIT_DISABLED = 1,
	ETHTOOL_TCP_DATA_SPLIT_ENABLED = 2,
};

enum {
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN = 0,
	ETHTOOL_UDP_TUNNEL_TYPE_GENEVE = 1,
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE = 2,
	__ETHTOOL_UDP_TUNNEL_TYPE_CNT = 3,
};

enum {
	ETH_RSS_HASH_TOP_BIT = 0,
	ETH_RSS_HASH_XOR_BIT = 1,
	ETH_RSS_HASH_CRC32_BIT = 2,
	ETH_RSS_HASH_FUNCS_COUNT = 3,
};

enum {
	EVENTFS_SAVE_MODE = 65536,
	EVENTFS_SAVE_UID = 131072,
	EVENTFS_SAVE_GID = 262144,
};

enum {
	EVENT_FILE_FL_ENABLED = 1,
	EVENT_FILE_FL_RECORDED_CMD = 2,
	EVENT_FILE_FL_RECORDED_TGID = 4,
	EVENT_FILE_FL_FILTERED = 8,
	EVENT_FILE_FL_NO_SET_FILTER = 16,
	EVENT_FILE_FL_SOFT_MODE = 32,
	EVENT_FILE_FL_SOFT_DISABLED = 64,
	EVENT_FILE_FL_TRIGGER_MODE = 128,
	EVENT_FILE_FL_TRIGGER_COND = 256,
	EVENT_FILE_FL_PID_FILTER = 512,
	EVENT_FILE_FL_WAS_ENABLED = 1024,
	EVENT_FILE_FL_FREED = 2048,
};

enum {
	EVENT_FILE_FL_ENABLED_BIT = 0,
	EVENT_FILE_FL_RECORDED_CMD_BIT = 1,
	EVENT_FILE_FL_RECORDED_TGID_BIT = 2,
	EVENT_FILE_FL_FILTERED_BIT = 3,
	EVENT_FILE_FL_NO_SET_FILTER_BIT = 4,
	EVENT_FILE_FL_SOFT_MODE_BIT = 5,
	EVENT_FILE_FL_SOFT_DISABLED_BIT = 6,
	EVENT_FILE_FL_TRIGGER_MODE_BIT = 7,
	EVENT_FILE_FL_TRIGGER_COND_BIT = 8,
	EVENT_FILE_FL_PID_FILTER_BIT = 9,
	EVENT_FILE_FL_WAS_ENABLED_BIT = 10,
	EVENT_FILE_FL_FREED_BIT = 11,
};

enum {
	EVENT_TRIGGER_FL_PROBE = 1,
};

enum {
	EXT4_FC_REASON_XATTR = 0,
	EXT4_FC_REASON_CROSS_RENAME = 1,
	EXT4_FC_REASON_JOURNAL_FLAG_CHANGE = 2,
	EXT4_FC_REASON_NOMEM = 3,
	EXT4_FC_REASON_SWAP_BOOT = 4,
	EXT4_FC_REASON_RESIZE = 5,
	EXT4_FC_REASON_RENAME_DIR = 6,
	EXT4_FC_REASON_FALLOC_RANGE = 7,
	EXT4_FC_REASON_INODE_JOURNAL_DATA = 8,
	EXT4_FC_REASON_ENCRYPTED_FILENAME = 9,
	EXT4_FC_REASON_MAX = 10,
};

enum {
	EXT4_FC_STATUS_OK = 0,
	EXT4_FC_STATUS_INELIGIBLE = 1,
	EXT4_FC_STATUS_SKIPPED = 2,
	EXT4_FC_STATUS_FAILED = 3,
};

enum {
	EXT4_INODE_SECRM = 0,
	EXT4_INODE_UNRM = 1,
	EXT4_INODE_COMPR = 2,
	EXT4_INODE_SYNC = 3,
	EXT4_INODE_IMMUTABLE = 4,
	EXT4_INODE_APPEND = 5,
	EXT4_INODE_NODUMP = 6,
	EXT4_INODE_NOATIME = 7,
	EXT4_INODE_DIRTY = 8,
	EXT4_INODE_COMPRBLK = 9,
	EXT4_INODE_NOCOMPR = 10,
	EXT4_INODE_ENCRYPT = 11,
	EXT4_INODE_INDEX = 12,
	EXT4_INODE_IMAGIC = 13,
	EXT4_INODE_JOURNAL_DATA = 14,
	EXT4_INODE_NOTAIL = 15,
	EXT4_INODE_DIRSYNC = 16,
	EXT4_INODE_TOPDIR = 17,
	EXT4_INODE_HUGE_FILE = 18,
	EXT4_INODE_EXTENTS = 19,
	EXT4_INODE_VERITY = 20,
	EXT4_INODE_EA_INODE = 21,
	EXT4_INODE_DAX = 25,
	EXT4_INODE_INLINE_DATA = 28,
	EXT4_INODE_PROJINHERIT = 29,
	EXT4_INODE_CASEFOLD = 30,
	EXT4_INODE_RESERVED = 31,
};

enum {
	EXT4_MF_MNTDIR_SAMPLED = 0,
	EXT4_MF_FC_INELIGIBLE = 1,
};

enum {
	EXT4_STATE_NEW = 0,
	EXT4_STATE_XATTR = 1,
	EXT4_STATE_NO_EXPAND = 2,
	EXT4_STATE_DA_ALLOC_CLOSE = 3,
	EXT4_STATE_EXT_MIGRATE = 4,
	EXT4_STATE_NEWENTRY = 5,
	EXT4_STATE_MAY_INLINE_DATA = 6,
	EXT4_STATE_EXT_PRECACHED = 7,
	EXT4_STATE_LUSTRE_EA_INODE = 8,
	EXT4_STATE_VERITY_IN_PROGRESS = 9,
	EXT4_STATE_FC_COMMITTING = 10,
	EXT4_STATE_ORPHAN_FILE = 11,
};

enum {
	Enabled = 0,
	Magic = 1,
};

enum {
	FAILURE_BAD_HOST = 1,
	FAILURE_SESSION_FAILED = 2,
	FAILURE_SESSION_FREED = 3,
	FAILURE_WINDOW_CLOSED = 4,
	FAILURE_OOM = 5,
	FAILURE_SESSION_TERMINATE = 6,
	FAILURE_SESSION_IN_RECOVERY = 7,
	FAILURE_SESSION_RECOVERY_TIMEOUT = 8,
	FAILURE_SESSION_LOGGING_OUT = 9,
	FAILURE_SESSION_NOT_READY = 10,
};

enum {
	FAN_EVENT_INIT = 0,
	FAN_EVENT_REPORTED = 1,
	FAN_EVENT_ANSWERED = 2,
	FAN_EVENT_CANCELED = 3,
};

enum {
	FBCON_LOGO_CANSHOW = -1,
	FBCON_LOGO_DRAW = -2,
	FBCON_LOGO_DONTSHOW = -3,
};

enum {
	FB_BLANK_UNBLANK = 0,
	FB_BLANK_NORMAL = 1,
	FB_BLANK_VSYNC_SUSPEND = 2,
	FB_BLANK_HSYNC_SUSPEND = 3,
	FB_BLANK_POWERDOWN = 4,
};

enum {
	FC = 0,
	SPI = 1,
	SAS = 2,
};

enum {
	FC4_PRIORITY_NVME = 1,
	FC4_PRIORITY_FCP = 2,
};

enum {
	FCNVME_CMD_CAT_MASK = 15,
	FCNVME_CMD_CAT_ADMINQ = 1,
	FCNVME_CMD_CAT_CSSMASK = 7,
	FCNVME_CMD_CAT_CSSFLAG = 8,
};

enum {
	FCNVME_CMD_FLAGS_DIRMASK = 3,
	FCNVME_CMD_FLAGS_WRITE = 1,
	FCNVME_CMD_FLAGS_READ = 2,
	FCNVME_CMD_FLAGS_PICWP = 4,
};

enum {
	FCNVME_LSDESC_RSVD = 0,
	FCNVME_LSDESC_RQST = 1,
	FCNVME_LSDESC_RJT = 2,
	FCNVME_LSDESC_CREATE_ASSOC_CMD = 3,
	FCNVME_LSDESC_CREATE_CONN_CMD = 4,
	FCNVME_LSDESC_DISCONN_CMD = 5,
	FCNVME_LSDESC_CONN_ID = 6,
	FCNVME_LSDESC_ASSOC_ID = 7,
};

enum {
	FCNVME_LS_RSVD = 0,
	FCNVME_LS_RJT = 1,
	FCNVME_LS_ACC = 2,
	FCNVME_LS_CREATE_ASSOCIATION = 3,
	FCNVME_LS_CREATE_CONNECTION = 4,
	FCNVME_LS_DISCONNECT_ASSOC = 5,
	FCNVME_LS_DISCONNECT_CONN = 6,
};

enum {
	FCS_UNKNOWN = 0,
	FCS_UNCONFIGURED = 1,
	FCS_DEVICE_DEAD = 2,
	FCS_DEVICE_LOST = 3,
	FCS_ONLINE = 4,
};

enum {
	FCTL_EC_ORIG = 0,
	FCTL_EC_RESP = 8388608,
	FCTL_SEQ_INI = 0,
	FCTL_SEQ_REC = 4194304,
	FCTL_FS_EXCH = 2097152,
	FCTL_LS_EXCH = 1048576,
	FCTL_END_SEQ = 524288,
	FCTL_SI_XFER = 65536,
	FCTL_RO_PRESENT = 8,
	FCTL_FILLBYTE_MASK = 3,
};

enum {
	FC_CAT_LD_REQUEST = 2,
	FC_CAT_LD_REPLY = 3,
	FC_CAT_LD_DIAG = 15,
};

enum {
	FC_CAT_NOP = 0,
	FC_CAT_ABTS = 1,
	FC_CAT_RMC = 2,
	FC_CAT_BA_ACC = 4,
	FC_CAT_BA_RJT = 5,
	FC_CAT_PRMT = 6,
};

enum {
	FC_CAT_UNCATEG_INFO = 0,
	FC_CAT_SOLICIT_DATA = 1,
	FC_CAT_UNSOLICIT_CTRL = 2,
	FC_CAT_SOLICIT_CTRL = 3,
	FC_CAT_UNSOLICIT_DATA = 4,
	FC_CAT_DATA_DESC = 5,
	FC_CAT_UNSOLICIT_CMD = 6,
	FC_CAT_CMD_STATUS = 7,
};

enum {
	FC_CAT_VFT_HDR = 0,
	FC_CAT_IFR_HDR = 1,
	FC_CAT_ENC_HDR = 2,
};

enum {
	FC_ELS_LS_RJT = 1,
	FC_ELS_ACC = 2,
	FC_ELS_PLOGI = 3,
	FC_ELS_FLOGI = 4,
	FC_ELS_LOGO = 5,
	FC_ELS_ABTX = 6,
	FC_ELS_RES = 8,
	FC_ELS_RSS = 9,
	FC_ELS_RSI = 10,
	FC_ELS_ESTC = 12,
	FC_ELS_RTV = 14,
	FC_ELS_RLS = 15,
	FC_ELS_ECHO = 16,
	FC_ELS_TEST = 17,
	FC_ELS_RRQ = 18,
	FC_ELS_REC = 19,
	FC_ELS_PRLI = 32,
	FC_ELS_PRLO = 33,
	FC_ELS_SCN = 34,
	FC_ELS_TPRLO = 36,
	FC_ELS_PDISC = 80,
	FC_ELS_FDISC = 81,
	FC_ELS_ADISC = 82,
	FC_ELS_FARP_REQ = 84,
	FC_ELS_FARP_REP = 85,
	FC_ELS_FAN = 96,
	FC_ELS_RSCN = 97,
	FC_ELS_SCR = 98,
	FC_ELS_RTIN = 119,
	FC_ELS_RNID = 120,
	FC_ELS_RLIR = 121,
	FC_ELS_RPSC = 125,
	FC_ELS_QSA = 126,
	FC_ELS_E2E_LBEACON = 129,
	FC_ELS_AUTH = 144,
	FC_ELS_RFCN = 151,
};

enum {
	FC_LS_RJT_EXP_NO_ADDL_INFO = 0,
	FC_LS_RJT_EXP_SPARMS_ERR_OPTIONS = 1,
	FC_LS_RJT_EXP_SPARMS_ERR_INI_CTL = 3,
	FC_LS_RJT_EXP_SPARMS_ERR_REC_CTL = 5,
	FC_LS_RJT_EXP_SPARMS_ERR_RXSZ = 7,
	FC_LS_RJT_EXP_SPARMS_ERR_CONSEQ = 9,
	FC_LS_RJT_EXP_SPARMS_ERR_CREDIT = 11,
	FC_LS_RJT_EXP_INV_PORT_NAME = 13,
	FC_LS_RJT_EXP_INV_NODE_FABRIC_NAME = 14,
	FC_LS_RJT_EXP_INV_CSP = 15,
	FC_LS_RJT_EXP_INV_ASSOC_HDR = 17,
	FC_LS_RJT_EXP_ASSOC_HDR_REQD = 19,
	FC_LS_RJT_EXP_INV_ORIG_S_ID = 21,
	FC_LS_RJT_EXP_INV_OXID_RXID_COMB = 23,
	FC_LS_RJT_EXP_CMD_ALREADY_IN_PROG = 25,
	FC_LS_RJT_EXP_LOGIN_REQUIRED = 30,
	FC_LS_RJT_EXP_INVALID_NPORT_ID = 31,
	FC_LS_RJT_EXP_INSUFF_RES = 41,
	FC_LS_RJT_EXP_CMD_NOT_SUPP = 44,
	FC_LS_RJT_EXP_INV_PAYLOAD_LEN = 45,
};

enum {
	FC_LS_RJT_RSN_INV_CMD_CODE = 1,
	FC_LS_RJT_RSN_LOGICAL_ERROR = 3,
	FC_LS_RJT_RSN_LOGICAL_BUSY = 5,
	FC_LS_RJT_RSN_PROTOCOL_ERROR = 7,
	FC_LS_RJT_RSN_UNABLE_TO_PERF_CMD = 9,
	FC_LS_RJT_RSN_CMD_NOT_SUPP = 11,
};

enum {
	FC_MIN_PDUSZ = 512,
	FC_MAX_PDUSZ = 2112,
};

enum {
	FC_MIN_WELL_KNOWN_ADDR = 16777200,
	FC_DOMAIN_CONTROLLER_MASK = 16776192,
	FC_ALIAS_SERVER = 16777208,
	FC_MGMT_SERVER = 16777210,
	FC_TIME_SERVER = 16777211,
	FC_NAME_SERVER = 16777212,
	FC_FABRIC_CONTROLLER = 16777213,
	FC_FABRIC_PORT = 16777214,
	FC_BROADCAST_SERVER = 16777215,
};

enum {
	FC_PH_VER_4_3 = 9,
	FC_PH_VER_PH_3 = 32,
};

enum {
	FC_PRLI_ACC_XQTD = 1,
	FC_PRLI_ACC_PREDEF_IMG = 5,
};

enum {
	FC_RTG_FC4_DEV_DATA = 0,
	FC_RTG_EXT_LINK = 2,
	FC_RTG_FC4_LINK_DATA = 3,
	FC_RTG_VIDEO_DATA = 4,
	FC_RTG_EXT_HDR = 5,
	FC_RTG_BASIC_LINK = 8,
	FC_RTG_LINK_CTRL = 12,
};

enum {
	FC_RXID_ANY = 65535,
};

enum {
	FC_SCR_REG_FUNC_FABRIC_DETECTED = 1,
	FC_SCR_REG_FUNC_N_PORT_DETECTED = 2,
	FC_SCR_REG_FUNC_FULL = 3,
	FC_SCR_REG_FUNC_CLEAR_REG = 255,
};

enum {
	FC_TYPE_BLS = 0,
	FC_TYPE_ELS = 1,
	FC_TYPE_IP = 5,
	FC_TYPE_FCP = 8,
	FC_TYPE_GPP = 9,
	FC_TYPE_SERVICES = 32,
	FC_TYPE_FC_FSS = 34,
	FC_TYPE_FC_AL = 35,
	FC_TYPE_FC_SNMP = 36,
	FC_TYPE_FC_SPINFAB = 238,
	FC_TYPE_FC_DIAG = 239,
	FC_TYPE_MAX = 256,
};

enum {
	FC_VU_SCR_REG_FUNC_FABRIC_NAME_CHANGE = 1,
};

enum {
	FIB6_NO_SERNUM_CHANGE = 0,
};

enum {
	FILTER_OTHER = 0,
	FILTER_STATIC_STRING = 1,
	FILTER_DYN_STRING = 2,
	FILTER_RDYN_STRING = 3,
	FILTER_PTR_STRING = 4,
	FILTER_TRACE_FN = 5,
	FILTER_CPUMASK = 6,
	FILTER_COMM = 7,
	FILTER_CPU = 8,
	FILTER_STACKTRACE = 9,
};

enum {
	FILT_ERR_NONE = 0,
	FILT_ERR_INVALID_OP = 1,
	FILT_ERR_TOO_MANY_OPEN = 2,
	FILT_ERR_TOO_MANY_CLOSE = 3,
	FILT_ERR_MISSING_QUOTE = 4,
	FILT_ERR_MISSING_BRACE_OPEN = 5,
	FILT_ERR_MISSING_BRACE_CLOSE = 6,
	FILT_ERR_OPERAND_TOO_LONG = 7,
	FILT_ERR_EXPECT_STRING = 8,
	FILT_ERR_EXPECT_DIGIT = 9,
	FILT_ERR_ILLEGAL_FIELD_OP = 10,
	FILT_ERR_FIELD_NOT_FOUND = 11,
	FILT_ERR_ILLEGAL_INTVAL = 12,
	FILT_ERR_BAD_SUBSYS_FILTER = 13,
	FILT_ERR_TOO_MANY_PREDS = 14,
	FILT_ERR_INVALID_FILTER = 15,
	FILT_ERR_INVALID_CPULIST = 16,
	FILT_ERR_IP_FIELD_ONLY = 17,
	FILT_ERR_INVALID_VALUE = 18,
	FILT_ERR_NO_FUNCTION = 19,
	FILT_ERR_ERRNO = 20,
	FILT_ERR_NO_FILTER = 21,
};

enum {
	FLAGS_ADC = 1,
	FLAGS_RTC = 2,
};

enum {
	FLAGS_FILL_FULL = 268435456,
	FLAGS_FILL_START = 536870912,
	FLAGS_FILL_END = 805306368,
};

enum {
	FLASH_EXP_ROM_START_SEC = 0,
	FLASH_EXP_ROM_NSECS = 6,
	FLASH_EXP_ROM_START = 0,
	FLASH_EXP_ROM_MAX_SIZE = 393216,
	FLASH_IBFT_START_SEC = 6,
	FLASH_IBFT_NSECS = 1,
	FLASH_IBFT_START = 393216,
	FLASH_IBFT_MAX_SIZE = 65536,
	FLASH_BOOTCFG_START_SEC = 7,
	FLASH_BOOTCFG_NSECS = 1,
	FLASH_BOOTCFG_START = 458752,
	FLASH_BOOTCFG_MAX_SIZE = 65536,
	FLASH_FW_START_SEC = 8,
	FLASH_FW_NSECS = 16,
	FLASH_FW_START = 524288,
	FLASH_FW_MAX_SIZE = 1048576,
	FLASH_FWBOOTSTRAP_START_SEC = 27,
	FLASH_FWBOOTSTRAP_NSECS = 1,
	FLASH_FWBOOTSTRAP_START = 1769472,
	FLASH_FWBOOTSTRAP_MAX_SIZE = 65536,
	FLASH_ISCSI_CRASH_START_SEC = 29,
	FLASH_ISCSI_CRASH_NSECS = 1,
	FLASH_ISCSI_CRASH_START = 1900544,
	FLASH_ISCSI_CRASH_MAX_SIZE = 65536,
	FLASH_FCOE_CRASH_START_SEC = 30,
	FLASH_FCOE_CRASH_NSECS = 1,
	FLASH_FCOE_CRASH_START = 1966080,
	FLASH_FCOE_CRASH_MAX_SIZE = 65536,
	FLASH_CFG_START_SEC = 31,
	FLASH_CFG_NSECS = 1,
	FLASH_CFG_START = 2031616,
	FLASH_CFG_MAX_SIZE = 65536,
	FLASH_MIN_SIZE = 2097152,
	FLASH_FPGA_CFG_START_SEC = 15,
	FLASH_FPGA_CFG_START = 983040,
};

enum {
	FLASH_METHOD_UNKNOWN = 0,
	FLASH_METHOD_A = 1,
	FLASH_METHOD_B = 2,
};

enum {
	FLAT_BINDER_FLAG_PRIORITY_MASK = 255,
	FLAT_BINDER_FLAG_ACCEPTS_FDS = 256,
	FLAT_BINDER_FLAG_TXN_SECURITY_CTX = 4096,
};

enum {
	FOLL_TOUCH = 65536,
	FOLL_TRIED = 131072,
	FOLL_REMOTE = 262144,
	FOLL_PIN = 524288,
	FOLL_FAST_ONLY = 1048576,
	FOLL_UNLOCKABLE = 2097152,
	FOLL_MADV_POPULATE = 4194304,
};

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

enum {
	FORMAT_HEADER = 1,
	FORMAT_FIELD_SEPERATOR = 2,
	FORMAT_PRINTFMT = 3,
};

enum {
	FRA_UNSPEC = 0,
	FRA_DST = 1,
	FRA_SRC = 2,
	FRA_IIFNAME = 3,
	FRA_GOTO = 4,
	FRA_UNUSED2 = 5,
	FRA_PRIORITY = 6,
	FRA_UNUSED3 = 7,
	FRA_UNUSED4 = 8,
	FRA_UNUSED5 = 9,
	FRA_FWMARK = 10,
	FRA_FLOW = 11,
	FRA_TUN_ID = 12,
	FRA_SUPPRESS_IFGROUP = 13,
	FRA_SUPPRESS_PREFIXLEN = 14,
	FRA_TABLE = 15,
	FRA_FWMASK = 16,
	FRA_OIFNAME = 17,
	FRA_PAD = 18,
	FRA_L3MDEV = 19,
	FRA_UID_RANGE = 20,
	FRA_PROTOCOL = 21,
	FRA_IP_PROTO = 22,
	FRA_SPORT_RANGE = 23,
	FRA_DPORT_RANGE = 24,
	__FRA_MAX = 25,
};

enum {
	FR_ACT_UNSPEC = 0,
	FR_ACT_TO_TBL = 1,
	FR_ACT_GOTO = 2,
	FR_ACT_NOP = 3,
	FR_ACT_RES3 = 4,
	FR_ACT_RES4 = 5,
	FR_ACT_BLACKHOLE = 6,
	FR_ACT_UNREACHABLE = 7,
	FR_ACT_PROHIBIT = 8,
	__FR_ACT_MAX = 9,
};

enum {
	FTRACE_FL_ENABLED = 2147483648,
	FTRACE_FL_REGS = 1073741824,
	FTRACE_FL_REGS_EN = 536870912,
	FTRACE_FL_TRAMP = 268435456,
	FTRACE_FL_TRAMP_EN = 134217728,
	FTRACE_FL_IPMODIFY = 67108864,
	FTRACE_FL_DISABLED = 33554432,
	FTRACE_FL_DIRECT = 16777216,
	FTRACE_FL_DIRECT_EN = 8388608,
	FTRACE_FL_CALL_OPS = 4194304,
	FTRACE_FL_CALL_OPS_EN = 2097152,
	FTRACE_FL_TOUCHED = 1048576,
	FTRACE_FL_MODIFIED = 524288,
};

enum {
	FTRACE_HASH_FL_MOD = 1,
};

enum {
	FTRACE_ITER_FILTER = 1,
	FTRACE_ITER_NOTRACE = 2,
	FTRACE_ITER_PRINTALL = 4,
	FTRACE_ITER_DO_PROBES = 8,
	FTRACE_ITER_PROBE = 16,
	FTRACE_ITER_MOD = 32,
	FTRACE_ITER_ENABLED = 64,
	FTRACE_ITER_TOUCHED = 128,
	FTRACE_ITER_ADDRS = 256,
};

enum {
	FTRACE_MODIFY_ENABLE_FL = 1,
	FTRACE_MODIFY_MAY_SLEEP_FL = 2,
};

enum {
	FTRACE_OPS_FL_ENABLED = 1,
	FTRACE_OPS_FL_DYNAMIC = 2,
	FTRACE_OPS_FL_SAVE_REGS = 4,
	FTRACE_OPS_FL_SAVE_REGS_IF_SUPPORTED = 8,
	FTRACE_OPS_FL_RECURSION = 16,
	FTRACE_OPS_FL_STUB = 32,
	FTRACE_OPS_FL_INITIALIZED = 64,
	FTRACE_OPS_FL_DELETED = 128,
	FTRACE_OPS_FL_ADDING = 256,
	FTRACE_OPS_FL_REMOVING = 512,
	FTRACE_OPS_FL_MODIFYING = 1024,
	FTRACE_OPS_FL_ALLOC_TRAMP = 2048,
	FTRACE_OPS_FL_IPMODIFY = 4096,
	FTRACE_OPS_FL_PID = 8192,
	FTRACE_OPS_FL_RCU = 16384,
	FTRACE_OPS_FL_TRACE_ARRAY = 32768,
	FTRACE_OPS_FL_PERMANENT = 65536,
	FTRACE_OPS_FL_DIRECT = 131072,
};

enum {
	FTRACE_UPDATE_CALLS = 1,
	FTRACE_DISABLE_CALLS = 2,
	FTRACE_UPDATE_TRACE_FUNC = 4,
	FTRACE_START_FUNC_RET = 8,
	FTRACE_STOP_FUNC_RET = 16,
	FTRACE_MAY_SLEEP = 32,
};

enum {
	FTRACE_UPDATE_IGNORE = 0,
	FTRACE_UPDATE_MAKE_CALL = 1,
	FTRACE_UPDATE_MODIFY_CALL = 2,
	FTRACE_UPDATE_MAKE_NOP = 3,
};

enum {
	FULL_INIT_DONE = 1,
	USING_MSI = 2,
	USING_MSIX = 4,
	QUEUES_BOUND = 8,
	TP_PARITY_INIT = 16,
	NAPI_INIT = 32,
};

enum {
	FUNC_CAN0_a = 0,
	FUNC_CAN0_b = 1,
	FUNC_CAN1 = 2,
	FUNC_CLKMON = 3,
	FUNC_NONE = 4,
	FUNC_FC0_a = 5,
	FUNC_FC0_b = 6,
	FUNC_FC0_c = 7,
	FUNC_FC1_a = 8,
	FUNC_FC1_b = 9,
	FUNC_FC1_c = 10,
	FUNC_FC2_a = 11,
	FUNC_FC2_b = 12,
	FUNC_FC3_a = 13,
	FUNC_FC3_b = 14,
	FUNC_FC3_c = 15,
	FUNC_FC4_a = 16,
	FUNC_FC4_b = 17,
	FUNC_FC4_c = 18,
	FUNC_FC_SHRD0 = 19,
	FUNC_FC_SHRD1 = 20,
	FUNC_FC_SHRD2 = 21,
	FUNC_FC_SHRD3 = 22,
	FUNC_FC_SHRD4 = 23,
	FUNC_FC_SHRD5 = 24,
	FUNC_FC_SHRD6 = 25,
	FUNC_FC_SHRD7 = 26,
	FUNC_FC_SHRD8 = 27,
	FUNC_FC_SHRD9 = 28,
	FUNC_FC_SHRD10 = 29,
	FUNC_FC_SHRD11 = 30,
	FUNC_FC_SHRD12 = 31,
	FUNC_FC_SHRD13 = 32,
	FUNC_FC_SHRD14 = 33,
	FUNC_FC_SHRD15 = 34,
	FUNC_FC_SHRD16 = 35,
	FUNC_FC_SHRD17 = 36,
	FUNC_FC_SHRD18 = 37,
	FUNC_FC_SHRD19 = 38,
	FUNC_FC_SHRD20 = 39,
	FUNC_GPIO = 40,
	FUNC_IB_TRG_a = 41,
	FUNC_IB_TRG_b = 42,
	FUNC_IB_TRG_c = 43,
	FUNC_IRQ0 = 44,
	FUNC_IRQ_IN_a = 45,
	FUNC_IRQ_IN_b = 46,
	FUNC_IRQ_IN_c = 47,
	FUNC_IRQ0_IN = 48,
	FUNC_IRQ_OUT_a = 49,
	FUNC_IRQ_OUT_b = 50,
	FUNC_IRQ_OUT_c = 51,
	FUNC_IRQ0_OUT = 52,
	FUNC_IRQ1 = 53,
	FUNC_IRQ1_IN = 54,
	FUNC_IRQ1_OUT = 55,
	FUNC_EXT_IRQ = 56,
	FUNC_MIIM = 57,
	FUNC_MIIM_a = 58,
	FUNC_MIIM_b = 59,
	FUNC_MIIM_c = 60,
	FUNC_MIIM_Sa = 61,
	FUNC_MIIM_Sb = 62,
	FUNC_OB_TRG = 63,
	FUNC_OB_TRG_a = 64,
	FUNC_OB_TRG_b = 65,
	FUNC_PHY_LED = 66,
	FUNC_PCI_WAKE = 67,
	FUNC_MD = 68,
	FUNC_PTP0 = 69,
	FUNC_PTP1 = 70,
	FUNC_PTP2 = 71,
	FUNC_PTP3 = 72,
	FUNC_PTPSYNC_0 = 73,
	FUNC_PTPSYNC_1 = 74,
	FUNC_PTPSYNC_2 = 75,
	FUNC_PTPSYNC_3 = 76,
	FUNC_PTPSYNC_4 = 77,
	FUNC_PTPSYNC_5 = 78,
	FUNC_PTPSYNC_6 = 79,
	FUNC_PTPSYNC_7 = 80,
	FUNC_PWM = 81,
	FUNC_PWM_a = 82,
	FUNC_PWM_b = 83,
	FUNC_QSPI1 = 84,
	FUNC_QSPI2 = 85,
	FUNC_R = 86,
	FUNC_RECO_a = 87,
	FUNC_RECO_b = 88,
	FUNC_RECO_CLK = 89,
	FUNC_SD = 90,
	FUNC_SFP = 91,
	FUNC_SFP_SD = 92,
	FUNC_SG0 = 93,
	FUNC_SG1 = 94,
	FUNC_SG2 = 95,
	FUNC_SGPIO_a = 96,
	FUNC_SGPIO_b = 97,
	FUNC_SI = 98,
	FUNC_SI2 = 99,
	FUNC_TACHO = 100,
	FUNC_TACHO_a = 101,
	FUNC_TACHO_b = 102,
	FUNC_TWI = 103,
	FUNC_TWI2 = 104,
	FUNC_TWI3 = 105,
	FUNC_TWI_SCL_M = 106,
	FUNC_TWI_SLC_GATE = 107,
	FUNC_TWI_SLC_GATE_AD = 108,
	FUNC_UART = 109,
	FUNC_UART2 = 110,
	FUNC_UART3 = 111,
	FUNC_USB_H_a = 112,
	FUNC_USB_H_b = 113,
	FUNC_USB_H_c = 114,
	FUNC_USB_S_a = 115,
	FUNC_USB_S_b = 116,
	FUNC_USB_S_c = 117,
	FUNC_PLL_STAT = 118,
	FUNC_EMMC = 119,
	FUNC_EMMC_SD = 120,
	FUNC_REF_CLK = 121,
	FUNC_RCVRD_CLK = 122,
	FUNC_MAX = 123,
};

enum {
	FUTEX_STATE_OK = 0,
	FUTEX_STATE_EXITING = 1,
	FUTEX_STATE_DEAD = 2,
};

enum {
	FW_FEATURE_PSERIES_POSSIBLE = 35183556296703ULL,
	FW_FEATURE_PSERIES_ALWAYS = 0ULL,
	FW_FEATURE_POWERNV_POSSIBLE = 275146342400ULL,
	FW_FEATURE_POWERNV_ALWAYS = 0ULL,
	FW_FEATURE_PS3_POSSIBLE = 12582912ULL,
	FW_FEATURE_PS3_ALWAYS = 12582912ULL,
	FW_FEATURE_NATIVE_POSSIBLE = 0ULL,
	FW_FEATURE_NATIVE_ALWAYS = 0ULL,
	FW_FEATURE_POSSIBLE = 35183824732159ULL,
	FW_FEATURE_ALWAYS = 0ULL,
};

enum {
	FW_TYPE_CMD_RPL = 0,
	FW_TYPE_WR_RPL = 1,
	FW_TYPE_CQE = 2,
	FW_TYPE_OFLD_CONNECTION_WR_RPL = 3,
	FW_TYPE_RSSCPL = 4,
};

enum {
	GENHD_FL_REMOVABLE = 1,
	GENHD_FL_HIDDEN = 2,
	GENHD_FL_NO_PART = 4,
};

enum {
	GET_MAX_OUTSTANDING_WR = 0,
	GET_TX_MAX_CHUNK = 1,
	GET_TID_RANGE = 2,
	GET_STID_RANGE = 3,
	GET_RTBL_RANGE = 4,
	GET_L2T_CAPACITY = 5,
	GET_MTUS = 6,
	GET_WR_LEN = 7,
	GET_IFF_FROM_MAC = 8,
	GET_DDP_PARAMS = 9,
	GET_PORTS = 10,
	ULP_ISCSI_GET_PARAMS = 11,
	ULP_ISCSI_SET_PARAMS = 12,
	RDMA_GET_PARAMS = 13,
	RDMA_CQ_OP = 14,
	RDMA_CQ_SETUP = 15,
	RDMA_CQ_DISABLE = 16,
	RDMA_CTRL_QP_SETUP = 17,
	RDMA_GET_MEM = 18,
	RDMA_GET_MIB = 19,
	GET_RX_PAGE_INFO = 50,
	GET_ISCSI_IPV4ADDR = 51,
	GET_EMBEDDED_INFO = 70,
};

enum {
	GI2C_PORT = 0,
	PI2C_PORT = 1,
};

enum {
	GPIOLINE_CHANGED_REQUESTED = 1,
	GPIOLINE_CHANGED_RELEASED = 2,
	GPIOLINE_CHANGED_CONFIG = 3,
};

enum {
	GP_IDLE = 0,
	GP_ENTER = 1,
	GP_PASSED = 2,
	GP_EXIT = 3,
	GP_REPLAY = 4,
};

enum {
	GS_FC_GFN_CMD = 276,
	GS_FC_GMAL_CMD = 278,
	GS_FC_TRACE_CMD = 1024,
	GS_FC_PING_CMD = 1025,
};

enum {
	GS_GID_PN = 289,
	GS_GPN_ID = 274,
	GS_GNN_ID = 275,
	GS_GID_FT = 369,
	GS_GSPN_ID = 280,
	GS_RFT_ID = 535,
	GS_RSPN_ID = 536,
	GS_RSNN_NN = 569,
	GS_RPN_ID = 530,
	GS_RNN_ID = 531,
	GS_RCS_ID = 532,
	GS_RPT_ID = 538,
	GS_GA_NXT = 256,
	GS_RFF_ID = 543,
};

enum {
	HANDSHAKE_A_ACCEPT_SOCKFD = 1,
	HANDSHAKE_A_ACCEPT_HANDLER_CLASS = 2,
	HANDSHAKE_A_ACCEPT_MESSAGE_TYPE = 3,
	HANDSHAKE_A_ACCEPT_TIMEOUT = 4,
	HANDSHAKE_A_ACCEPT_AUTH_MODE = 5,
	HANDSHAKE_A_ACCEPT_PEER_IDENTITY = 6,
	HANDSHAKE_A_ACCEPT_CERTIFICATE = 7,
	HANDSHAKE_A_ACCEPT_PEERNAME = 8,
	__HANDSHAKE_A_ACCEPT_MAX = 9,
	HANDSHAKE_A_ACCEPT_MAX = 8,
};

enum {
	HANDSHAKE_A_DONE_STATUS = 1,
	HANDSHAKE_A_DONE_SOCKFD = 2,
	HANDSHAKE_A_DONE_REMOTE_AUTH = 3,
	__HANDSHAKE_A_DONE_MAX = 4,
	HANDSHAKE_A_DONE_MAX = 3,
};

enum {
	HANDSHAKE_A_X509_CERT = 1,
	HANDSHAKE_A_X509_PRIVKEY = 2,
	__HANDSHAKE_A_X509_MAX = 3,
	HANDSHAKE_A_X509_MAX = 2,
};

enum {
	HANDSHAKE_CMD_READY = 1,
	HANDSHAKE_CMD_ACCEPT = 2,
	HANDSHAKE_CMD_DONE = 3,
	__HANDSHAKE_CMD_MAX = 4,
	HANDSHAKE_CMD_MAX = 3,
};

enum {
	HANDSHAKE_NLGRP_NONE = 0,
	HANDSHAKE_NLGRP_TLSHD = 1,
};

enum {
	HASH_SIZE = 128,
};

enum {
	HBA_IU_TYPE_SCSI_CMD_REQ = 64,
	HBA_IU_TYPE_SCSI_TM_REQ = 65,
	HBA_IU_TYPE_SATA_REQ = 66,
	HBA_IU_TYPE_RESP = 96,
	HBA_IU_TYPE_COALESCED_RESP = 97,
	HBA_IU_TYPE_INT_COALESCING_CFG_REQ = 112,
};

enum {
	HBA_RESP_STAT_IO_ERROR = 1,
	HBA_RESP_STAT_IO_ABORTED = 2,
	HBA_RESP_STAT_NO_PATH_TO_DEVICE = 3,
	HBA_RESP_STAT_INVALID_DEVICE = 4,
	HBA_RESP_STAT_HBAMODE_DISABLED = 14,
	HBA_RESP_STAT_UNDERRUN = 81,
	HBA_RESP_STAT_OVERRUN = 117,
};

enum {
	HBA_RESP_SVCRES_TASK_COMPLETE = 0,
	HBA_RESP_SVCRES_FAILURE = 1,
	HBA_RESP_SVCRES_TMF_COMPLETE = 2,
	HBA_RESP_SVCRES_TMF_SUCCEEDED = 3,
	HBA_RESP_SVCRES_TMF_REJECTED = 4,
	HBA_RESP_SVCRES_TMF_LUN_INVALID = 5,
};

enum {
	HIBERNATION_INVALID = 0,
	HIBERNATION_PLATFORM = 1,
	HIBERNATION_SHUTDOWN = 2,
	HIBERNATION_REBOOT = 3,
	HIBERNATION_SUSPEND = 4,
	HIBERNATION_TEST_RESUME = 5,
	__HIBERNATION_AFTER_LAST = 6,
};

enum {
	HIST_ERR_NONE = 0,
	HIST_ERR_DUPLICATE_VAR = 1,
	HIST_ERR_VAR_NOT_UNIQUE = 2,
	HIST_ERR_TOO_MANY_VARS = 3,
	HIST_ERR_MALFORMED_ASSIGNMENT = 4,
	HIST_ERR_NAMED_MISMATCH = 5,
	HIST_ERR_TRIGGER_EEXIST = 6,
	HIST_ERR_TRIGGER_ENOENT_CLEAR = 7,
	HIST_ERR_SET_CLOCK_FAIL = 8,
	HIST_ERR_BAD_FIELD_MODIFIER = 9,
	HIST_ERR_TOO_MANY_SUBEXPR = 10,
	HIST_ERR_TIMESTAMP_MISMATCH = 11,
	HIST_ERR_TOO_MANY_FIELD_VARS = 12,
	HIST_ERR_EVENT_FILE_NOT_FOUND = 13,
	HIST_ERR_HIST_NOT_FOUND = 14,
	HIST_ERR_HIST_CREATE_FAIL = 15,
	HIST_ERR_SYNTH_VAR_NOT_FOUND = 16,
	HIST_ERR_SYNTH_EVENT_NOT_FOUND = 17,
	HIST_ERR_SYNTH_TYPE_MISMATCH = 18,
	HIST_ERR_SYNTH_COUNT_MISMATCH = 19,
	HIST_ERR_FIELD_VAR_PARSE_FAIL = 20,
	HIST_ERR_VAR_CREATE_FIND_FAIL = 21,
	HIST_ERR_ONX_NOT_VAR = 22,
	HIST_ERR_ONX_VAR_NOT_FOUND = 23,
	HIST_ERR_ONX_VAR_CREATE_FAIL = 24,
	HIST_ERR_FIELD_VAR_CREATE_FAIL = 25,
	HIST_ERR_TOO_MANY_PARAMS = 26,
	HIST_ERR_PARAM_NOT_FOUND = 27,
	HIST_ERR_INVALID_PARAM = 28,
	HIST_ERR_ACTION_NOT_FOUND = 29,
	HIST_ERR_NO_SAVE_PARAMS = 30,
	HIST_ERR_TOO_MANY_SAVE_ACTIONS = 31,
	HIST_ERR_ACTION_MISMATCH = 32,
	HIST_ERR_NO_CLOSING_PAREN = 33,
	HIST_ERR_SUBSYS_NOT_FOUND = 34,
	HIST_ERR_INVALID_SUBSYS_EVENT = 35,
	HIST_ERR_INVALID_REF_KEY = 36,
	HIST_ERR_VAR_NOT_FOUND = 37,
	HIST_ERR_FIELD_NOT_FOUND = 38,
	HIST_ERR_EMPTY_ASSIGNMENT = 39,
	HIST_ERR_INVALID_SORT_MODIFIER = 40,
	HIST_ERR_EMPTY_SORT_FIELD = 41,
	HIST_ERR_TOO_MANY_SORT_FIELDS = 42,
	HIST_ERR_INVALID_SORT_FIELD = 43,
	HIST_ERR_INVALID_STR_OPERAND = 44,
	HIST_ERR_EXPECT_NUMBER = 45,
	HIST_ERR_UNARY_MINUS_SUBEXPR = 46,
	HIST_ERR_DIVISION_BY_ZERO = 47,
	HIST_ERR_NEED_NOHC_VAL = 48,
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum {
	HMM_NEED_FAULT = 1,
	HMM_NEED_WRITE_FAULT = 2,
	HMM_NEED_ALL_BITS = 3,
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

enum {
	HUGETLB_SHMFS_INODE = 1,
	HUGETLB_ANONHUGE_INODE = 2,
};

enum {
	HV_GPCI_CM_GA = 128,
	HV_GPCI_CM_EXPANDED = 64,
	HV_GPCI_CM_LAB = 32,
};

enum {
	HW_BREAKPOINT_EMPTY = 0,
	HW_BREAKPOINT_R = 1,
	HW_BREAKPOINT_W = 2,
	HW_BREAKPOINT_RW = 3,
	HW_BREAKPOINT_X = 4,
	HW_BREAKPOINT_INVALID = 7,
};

enum {
	IBM = 0,
	TVP = 1,
};

enum {
	ICMP6_MIB_NUM = 0,
	ICMP6_MIB_INMSGS = 1,
	ICMP6_MIB_INERRORS = 2,
	ICMP6_MIB_OUTMSGS = 3,
	ICMP6_MIB_OUTERRORS = 4,
	ICMP6_MIB_CSUMERRORS = 5,
	ICMP6_MIB_RATELIMITHOST = 6,
	__ICMP6_MIB_MAX = 7,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICQ_EXITED = 4,
	ICQ_DESTROYED = 8,
};

enum {
	IDETIM = 108,
	IORDY = 2,
	PPE___2 = 4,
	FTIM = 1,
	ENABLED = 32768,
	SECONDARY = 16384,
};

enum {
	IDT75P52100 = 4,
	IDT75N43102 = 5,
};

enum {
	IDX_MODULE_ID = 0,
	IDX_ST_OPS_COMMON_VALUE_ID = 1,
};

enum {
	IFAL_ADDRESS = 1,
	IFAL_LABEL = 2,
	__IFAL_MAX = 3,
};

enum {
	IFA_UNSPEC = 0,
	IFA_ADDRESS = 1,
	IFA_LOCAL = 2,
	IFA_LABEL = 3,
	IFA_BROADCAST = 4,
	IFA_ANYCAST = 5,
	IFA_CACHEINFO = 6,
	IFA_MULTICAST = 7,
	IFA_FLAGS = 8,
	IFA_RT_PRIORITY = 9,
	IFA_TARGET_NETNSID = 10,
	IFA_PROTO = 11,
	__IFA_MAX = 12,
};

enum {
	IFLA_BRIDGE_FLAGS = 0,
	IFLA_BRIDGE_MODE = 1,
	IFLA_BRIDGE_VLAN_INFO = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_INFO = 3,
	IFLA_BRIDGE_MRP = 4,
	IFLA_BRIDGE_CFM = 5,
	IFLA_BRIDGE_MST = 6,
	__IFLA_BRIDGE_MAX = 7,
};

enum {
	IFLA_BRPORT_UNSPEC = 0,
	IFLA_BRPORT_STATE = 1,
	IFLA_BRPORT_PRIORITY = 2,
	IFLA_BRPORT_COST = 3,
	IFLA_BRPORT_MODE = 4,
	IFLA_BRPORT_GUARD = 5,
	IFLA_BRPORT_PROTECT = 6,
	IFLA_BRPORT_FAST_LEAVE = 7,
	IFLA_BRPORT_LEARNING = 8,
	IFLA_BRPORT_UNICAST_FLOOD = 9,
	IFLA_BRPORT_PROXYARP = 10,
	IFLA_BRPORT_LEARNING_SYNC = 11,
	IFLA_BRPORT_PROXYARP_WIFI = 12,
	IFLA_BRPORT_ROOT_ID = 13,
	IFLA_BRPORT_BRIDGE_ID = 14,
	IFLA_BRPORT_DESIGNATED_PORT = 15,
	IFLA_BRPORT_DESIGNATED_COST = 16,
	IFLA_BRPORT_ID = 17,
	IFLA_BRPORT_NO = 18,
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK = 19,
	IFLA_BRPORT_CONFIG_PENDING = 20,
	IFLA_BRPORT_MESSAGE_AGE_TIMER = 21,
	IFLA_BRPORT_FORWARD_DELAY_TIMER = 22,
	IFLA_BRPORT_HOLD_TIMER = 23,
	IFLA_BRPORT_FLUSH = 24,
	IFLA_BRPORT_MULTICAST_ROUTER = 25,
	IFLA_BRPORT_PAD = 26,
	IFLA_BRPORT_MCAST_FLOOD = 27,
	IFLA_BRPORT_MCAST_TO_UCAST = 28,
	IFLA_BRPORT_VLAN_TUNNEL = 29,
	IFLA_BRPORT_BCAST_FLOOD = 30,
	IFLA_BRPORT_GROUP_FWD_MASK = 31,
	IFLA_BRPORT_NEIGH_SUPPRESS = 32,
	IFLA_BRPORT_ISOLATED = 33,
	IFLA_BRPORT_BACKUP_PORT = 34,
	IFLA_BRPORT_MRP_RING_OPEN = 35,
	IFLA_BRPORT_MRP_IN_OPEN = 36,
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT = 37,
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT = 38,
	IFLA_BRPORT_LOCKED = 39,
	IFLA_BRPORT_MAB = 40,
	IFLA_BRPORT_MCAST_N_GROUPS = 41,
	IFLA_BRPORT_MCAST_MAX_GROUPS = 42,
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS = 43,
	IFLA_BRPORT_BACKUP_NHID = 44,
	__IFLA_BRPORT_MAX = 45,
};

enum {
	IFLA_EVENT_NONE = 0,
	IFLA_EVENT_REBOOT = 1,
	IFLA_EVENT_FEATURES = 2,
	IFLA_EVENT_BONDING_FAILOVER = 3,
	IFLA_EVENT_NOTIFY_PEERS = 4,
	IFLA_EVENT_IGMP_RESEND = 5,
	IFLA_EVENT_BONDING_OPTIONS = 6,
};

enum {
	IFLA_INET6_UNSPEC = 0,
	IFLA_INET6_FLAGS = 1,
	IFLA_INET6_CONF = 2,
	IFLA_INET6_STATS = 3,
	IFLA_INET6_MCAST = 4,
	IFLA_INET6_CACHEINFO = 5,
	IFLA_INET6_ICMP6STATS = 6,
	IFLA_INET6_TOKEN = 7,
	IFLA_INET6_ADDR_GEN_MODE = 8,
	IFLA_INET6_RA_MTU = 9,
	__IFLA_INET6_MAX = 10,
};

enum {
	IFLA_INET_UNSPEC = 0,
	IFLA_INET_CONF = 1,
	__IFLA_INET_MAX = 2,
};

enum {
	IFLA_INFO_UNSPEC = 0,
	IFLA_INFO_KIND = 1,
	IFLA_INFO_DATA = 2,
	IFLA_INFO_XSTATS = 3,
	IFLA_INFO_SLAVE_KIND = 4,
	IFLA_INFO_SLAVE_DATA = 5,
	__IFLA_INFO_MAX = 6,
};

enum {
	IFLA_IPTUN_UNSPEC = 0,
	IFLA_IPTUN_LINK = 1,
	IFLA_IPTUN_LOCAL = 2,
	IFLA_IPTUN_REMOTE = 3,
	IFLA_IPTUN_TTL = 4,
	IFLA_IPTUN_TOS = 5,
	IFLA_IPTUN_ENCAP_LIMIT = 6,
	IFLA_IPTUN_FLOWINFO = 7,
	IFLA_IPTUN_FLAGS = 8,
	IFLA_IPTUN_PROTO = 9,
	IFLA_IPTUN_PMTUDISC = 10,
	IFLA_IPTUN_6RD_PREFIX = 11,
	IFLA_IPTUN_6RD_RELAY_PREFIX = 12,
	IFLA_IPTUN_6RD_PREFIXLEN = 13,
	IFLA_IPTUN_6RD_RELAY_PREFIXLEN = 14,
	IFLA_IPTUN_ENCAP_TYPE = 15,
	IFLA_IPTUN_ENCAP_FLAGS = 16,
	IFLA_IPTUN_ENCAP_SPORT = 17,
	IFLA_IPTUN_ENCAP_DPORT = 18,
	IFLA_IPTUN_COLLECT_METADATA = 19,
	IFLA_IPTUN_FWMARK = 20,
	__IFLA_IPTUN_MAX = 21,
};

enum {
	IFLA_MCTP_UNSPEC = 0,
	IFLA_MCTP_NET = 1,
	__IFLA_MCTP_MAX = 2,
};

enum {
	IFLA_NETKIT_UNSPEC = 0,
	IFLA_NETKIT_PEER_INFO = 1,
	IFLA_NETKIT_PRIMARY = 2,
	IFLA_NETKIT_POLICY = 3,
	IFLA_NETKIT_PEER_POLICY = 4,
	IFLA_NETKIT_MODE = 5,
	__IFLA_NETKIT_MAX = 6,
};

enum {
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_REQUEST = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_USED = 2,
	__IFLA_OFFLOAD_XSTATS_HW_S_INFO_MAX = 3,
};

enum {
	IFLA_OFFLOAD_XSTATS_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_CPU_HIT = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO = 2,
	IFLA_OFFLOAD_XSTATS_L3_STATS = 3,
	__IFLA_OFFLOAD_XSTATS_MAX = 4,
};

enum {
	IFLA_PORT_UNSPEC = 0,
	IFLA_PORT_VF = 1,
	IFLA_PORT_PROFILE = 2,
	IFLA_PORT_VSI_TYPE = 3,
	IFLA_PORT_INSTANCE_UUID = 4,
	IFLA_PORT_HOST_UUID = 5,
	IFLA_PORT_REQUEST = 6,
	IFLA_PORT_RESPONSE = 7,
	__IFLA_PORT_MAX = 8,
};

enum {
	IFLA_PROTO_DOWN_REASON_UNSPEC = 0,
	IFLA_PROTO_DOWN_REASON_MASK = 1,
	IFLA_PROTO_DOWN_REASON_VALUE = 2,
	__IFLA_PROTO_DOWN_REASON_CNT = 3,
	IFLA_PROTO_DOWN_REASON_MAX = 2,
};

enum {
	IFLA_STATS_GETSET_UNSPEC = 0,
	IFLA_STATS_GET_FILTERS = 1,
	IFLA_STATS_SET_OFFLOAD_XSTATS_L3_STATS = 2,
	__IFLA_STATS_GETSET_MAX = 3,
};

enum {
	IFLA_STATS_UNSPEC = 0,
	IFLA_STATS_LINK_64 = 1,
	IFLA_STATS_LINK_XSTATS = 2,
	IFLA_STATS_LINK_XSTATS_SLAVE = 3,
	IFLA_STATS_LINK_OFFLOAD_XSTATS = 4,
	IFLA_STATS_AF_SPEC = 5,
	__IFLA_STATS_MAX = 6,
};

enum {
	IFLA_UNSPEC = 0,
	IFLA_ADDRESS = 1,
	IFLA_BROADCAST = 2,
	IFLA_IFNAME = 3,
	IFLA_MTU = 4,
	IFLA_LINK = 5,
	IFLA_QDISC = 6,
	IFLA_STATS = 7,
	IFLA_COST = 8,
	IFLA_PRIORITY = 9,
	IFLA_MASTER = 10,
	IFLA_WIRELESS = 11,
	IFLA_PROTINFO = 12,
	IFLA_TXQLEN = 13,
	IFLA_MAP = 14,
	IFLA_WEIGHT = 15,
	IFLA_OPERSTATE = 16,
	IFLA_LINKMODE = 17,
	IFLA_LINKINFO = 18,
	IFLA_NET_NS_PID = 19,
	IFLA_IFALIAS = 20,
	IFLA_NUM_VF = 21,
	IFLA_VFINFO_LIST = 22,
	IFLA_STATS64 = 23,
	IFLA_VF_PORTS = 24,
	IFLA_PORT_SELF = 25,
	IFLA_AF_SPEC = 26,
	IFLA_GROUP = 27,
	IFLA_NET_NS_FD = 28,
	IFLA_EXT_MASK = 29,
	IFLA_PROMISCUITY = 30,
	IFLA_NUM_TX_QUEUES = 31,
	IFLA_NUM_RX_QUEUES = 32,
	IFLA_CARRIER = 33,
	IFLA_PHYS_PORT_ID = 34,
	IFLA_CARRIER_CHANGES = 35,
	IFLA_PHYS_SWITCH_ID = 36,
	IFLA_LINK_NETNSID = 37,
	IFLA_PHYS_PORT_NAME = 38,
	IFLA_PROTO_DOWN = 39,
	IFLA_GSO_MAX_SEGS = 40,
	IFLA_GSO_MAX_SIZE = 41,
	IFLA_PAD = 42,
	IFLA_XDP = 43,
	IFLA_EVENT = 44,
	IFLA_NEW_NETNSID = 45,
	IFLA_IF_NETNSID = 46,
	IFLA_TARGET_NETNSID = 46,
	IFLA_CARRIER_UP_COUNT = 47,
	IFLA_CARRIER_DOWN_COUNT = 48,
	IFLA_NEW_IFINDEX = 49,
	IFLA_MIN_MTU = 50,
	IFLA_MAX_MTU = 51,
	IFLA_PROP_LIST = 52,
	IFLA_ALT_IFNAME = 53,
	IFLA_PERM_ADDRESS = 54,
	IFLA_PROTO_DOWN_REASON = 55,
	IFLA_PARENT_DEV_NAME = 56,
	IFLA_PARENT_DEV_BUS_NAME = 57,
	IFLA_GRO_MAX_SIZE = 58,
	IFLA_TSO_MAX_SIZE = 59,
	IFLA_TSO_MAX_SEGS = 60,
	IFLA_ALLMULTI = 61,
	IFLA_DEVLINK_PORT = 62,
	IFLA_GSO_IPV4_MAX_SIZE = 63,
	IFLA_GRO_IPV4_MAX_SIZE = 64,
	IFLA_DPLL_PIN = 65,
	__IFLA_MAX = 66,
};

enum {
	IFLA_VF_INFO_UNSPEC = 0,
	IFLA_VF_INFO = 1,
	__IFLA_VF_INFO_MAX = 2,
};

enum {
	IFLA_VF_PORT_UNSPEC = 0,
	IFLA_VF_PORT = 1,
	__IFLA_VF_PORT_MAX = 2,
};

enum {
	IFLA_VF_STATS_RX_PACKETS = 0,
	IFLA_VF_STATS_TX_PACKETS = 1,
	IFLA_VF_STATS_RX_BYTES = 2,
	IFLA_VF_STATS_TX_BYTES = 3,
	IFLA_VF_STATS_BROADCAST = 4,
	IFLA_VF_STATS_MULTICAST = 5,
	IFLA_VF_STATS_PAD = 6,
	IFLA_VF_STATS_RX_DROPPED = 7,
	IFLA_VF_STATS_TX_DROPPED = 8,
	__IFLA_VF_STATS_MAX = 9,
};

enum {
	IFLA_VF_UNSPEC = 0,
	IFLA_VF_MAC = 1,
	IFLA_VF_VLAN = 2,
	IFLA_VF_TX_RATE = 3,
	IFLA_VF_SPOOFCHK = 4,
	IFLA_VF_LINK_STATE = 5,
	IFLA_VF_RATE = 6,
	IFLA_VF_RSS_QUERY_EN = 7,
	IFLA_VF_STATS = 8,
	IFLA_VF_TRUST = 9,
	IFLA_VF_IB_NODE_GUID = 10,
	IFLA_VF_IB_PORT_GUID = 11,
	IFLA_VF_VLAN_LIST = 12,
	IFLA_VF_BROADCAST = 13,
	__IFLA_VF_MAX = 14,
};

enum {
	IFLA_VF_VLAN_INFO_UNSPEC = 0,
	IFLA_VF_VLAN_INFO = 1,
	__IFLA_VF_VLAN_INFO_MAX = 2,
};

enum {
	IFLA_XDP_UNSPEC = 0,
	IFLA_XDP_FD = 1,
	IFLA_XDP_ATTACHED = 2,
	IFLA_XDP_FLAGS = 3,
	IFLA_XDP_PROG_ID = 4,
	IFLA_XDP_DRV_PROG_ID = 5,
	IFLA_XDP_SKB_PROG_ID = 6,
	IFLA_XDP_HW_PROG_ID = 7,
	IFLA_XDP_EXPECTED_FD = 8,
	__IFLA_XDP_MAX = 9,
};

enum {
	IF_ACT_NONE = -1,
	IF_ACT_FILTER = 0,
	IF_ACT_START = 1,
	IF_ACT_STOP = 2,
	IF_SRC_FILE = 3,
	IF_SRC_KERNEL = 4,
	IF_SRC_FILEADDR = 5,
	IF_SRC_KERNELADDR = 6,
};

enum {
	IF_LINK_MODE_DEFAULT = 0,
	IF_LINK_MODE_DORMANT = 1,
	IF_LINK_MODE_TESTING = 2,
};

enum {
	IF_OPER_UNKNOWN = 0,
	IF_OPER_NOTPRESENT = 1,
	IF_OPER_DOWN = 2,
	IF_OPER_LOWERLAYERDOWN = 3,
	IF_OPER_TESTING = 4,
	IF_OPER_DORMANT = 5,
	IF_OPER_UP = 6,
};

enum {
	IF_STATE_ACTION = 0,
	IF_STATE_SOURCE = 1,
	IF_STATE_END = 2,
};

enum {
	IMAGE_INVALID = 0,
	IMAGE_LOADING = 1,
	IMAGE_READY = 2,
};

enum {
	IMASK_PMA = 4,
	IMASK_GLOBAL = 32768,
	ADV_1G_FULL = 32768,
	ADV_1G_HALF = 16384,
	ADV_10G_FULL = 4096,
	AQ_RESET = 49152,
	AQ_LOWPOWER = 4096,
};

enum {
	IMC_TYPE_THREAD = 1,
	IMC_TYPE_TRACE = 2,
	IMC_TYPE_CORE = 4,
	IMC_TYPE_CHIP = 16,
};

enum {
	IMR0 = 16,
	IMR1 = 20,
	OMR0 = 24,
	OMR1 = 28,
	IDBL = 32,
	IIS = 36,
	IIM = 40,
	ODBL = 44,
	OIS = 48,
	OIM = 60,
	YIOA_STATUS = 0,
	YH2I_INT = 32,
	YINT_EN = 52,
	YI2H_INT = 156,
	YI2H_INT_C = 160,
	YH2I_REQ = 192,
	YH2I_REQ_HI = 196,
	PSCRATCH0 = 176,
	PSCRATCH1 = 180,
	PSCRATCH2 = 184,
	PSCRATCH3 = 188,
	PSCRATCH4 = 200,
	MAILBOX_BASE = 4096,
	MAILBOX_HNDSHK_STS = 0,
	MU_INBOUND_DOORBELL_HANDSHAKE = 1,
	MU_INBOUND_DOORBELL_REQHEADCHANGED = 2,
	MU_INBOUND_DOORBELL_STATUSTAILCHANGED = 4,
	MU_INBOUND_DOORBELL_HMUSTOPPED = 8,
	MU_INBOUND_DOORBELL_RESET = 16,
	MU_OUTBOUND_DOORBELL_HANDSHAKE = 1,
	MU_OUTBOUND_DOORBELL_REQUESTTAILCHANGED = 2,
	MU_OUTBOUND_DOORBELL_STATUSHEADCHANGED = 4,
	MU_OUTBOUND_DOORBELL_BUSCHANGE = 8,
	MU_OUTBOUND_DOORBELL_HASEVENT = 16,
	MU_OUTBOUND_DOORBELL_REQUEST_RESET = 134217728,
	MU_STATE_STARTING = 1,
	MU_STATE_STARTED = 2,
	MU_STATE_RESETTING = 3,
	MU_STATE_FAILED = 4,
	MU_STATE_STOP = 5,
	MU_STATE_NOCONNECT = 6,
	MU_MAX_DELAY = 50,
	MU_HANDSHAKE_SIGNATURE = 1437248085,
	MU_HANDSHAKE_SIGNATURE_HALF = 1515847680,
	MU_HARD_RESET_WAIT = 30000,
	HMU_PARTNER_TYPE = 2,
	SRB_STATUS_SUCCESS = 1,
	SRB_STATUS_ERROR = 4,
	SRB_STATUS_BUSY = 5,
	SRB_STATUS_INVALID_REQUEST = 6,
	SRB_STATUS_SELECTION_TIMEOUT = 10,
	SRB_SEE_SENSE = 128,
	TASK_ATTRIBUTE_SIMPLE = 0,
	TASK_ATTRIBUTE_HEADOFQUEUE = 1,
	TASK_ATTRIBUTE_ORDERED = 2,
	TASK_ATTRIBUTE_ACA = 4,
};

enum {
	INET6_IFADDR_STATE_PREDAD = 0,
	INET6_IFADDR_STATE_DAD = 1,
	INET6_IFADDR_STATE_POSTDAD = 2,
	INET6_IFADDR_STATE_ERRDAD = 3,
	INET6_IFADDR_STATE_DEAD = 4,
};

enum {
	INET_DIAG_NONE = 0,
	INET_DIAG_MEMINFO = 1,
	INET_DIAG_INFO = 2,
	INET_DIAG_VEGASINFO = 3,
	INET_DIAG_CONG = 4,
	INET_DIAG_TOS = 5,
	INET_DIAG_TCLASS = 6,
	INET_DIAG_SKMEMINFO = 7,
	INET_DIAG_SHUTDOWN = 8,
	INET_DIAG_DCTCPINFO = 9,
	INET_DIAG_PROTOCOL = 10,
	INET_DIAG_SKV6ONLY = 11,
	INET_DIAG_LOCALS = 12,
	INET_DIAG_PEERS = 13,
	INET_DIAG_PAD = 14,
	INET_DIAG_MARK = 15,
	INET_DIAG_BBRINFO = 16,
	INET_DIAG_CLASS_ID = 17,
	INET_DIAG_MD5SIG = 18,
	INET_DIAG_ULP_INFO = 19,
	INET_DIAG_SK_BPF_STORAGES = 20,
	INET_DIAG_CGROUP_ID = 21,
	INET_DIAG_SOCKOPT = 22,
	__INET_DIAG_MAX = 23,
};

enum {
	INET_DIAG_REQ_NONE = 0,
	INET_DIAG_REQ_BYTECODE = 1,
	INET_DIAG_REQ_SK_BPF_STORAGES = 2,
	INET_DIAG_REQ_PROTOCOL = 3,
	__INET_DIAG_REQ_MAX = 4,
};

enum {
	INET_ECN_NOT_ECT = 0,
	INET_ECN_ECT_1 = 1,
	INET_ECN_ECT_0 = 2,
	INET_ECN_CE = 3,
	INET_ECN_MASK = 3,
};

enum {
	INET_FLAGS_PKTINFO = 0,
	INET_FLAGS_TTL = 1,
	INET_FLAGS_TOS = 2,
	INET_FLAGS_RECVOPTS = 3,
	INET_FLAGS_RETOPTS = 4,
	INET_FLAGS_PASSSEC = 5,
	INET_FLAGS_ORIGDSTADDR = 6,
	INET_FLAGS_CHECKSUM = 7,
	INET_FLAGS_RECVFRAGSIZE = 8,
	INET_FLAGS_RECVERR = 9,
	INET_FLAGS_RECVERR_RFC4884 = 10,
	INET_FLAGS_FREEBIND = 11,
	INET_FLAGS_HDRINCL = 12,
	INET_FLAGS_MC_LOOP = 13,
	INET_FLAGS_MC_ALL = 14,
	INET_FLAGS_TRANSPARENT = 15,
	INET_FLAGS_IS_ICSK = 16,
	INET_FLAGS_NODEFRAG = 17,
	INET_FLAGS_BIND_ADDRESS_NO_PORT = 18,
	INET_FLAGS_DEFER_CONNECT = 19,
	INET_FLAGS_MC6_LOOP = 20,
	INET_FLAGS_RECVERR6_RFC4884 = 21,
	INET_FLAGS_MC6_ALL = 22,
	INET_FLAGS_AUTOFLOWLABEL_SET = 23,
	INET_FLAGS_AUTOFLOWLABEL = 24,
	INET_FLAGS_DONTFRAG = 25,
	INET_FLAGS_RECVERR6 = 26,
	INET_FLAGS_REPFLOW = 27,
	INET_FLAGS_RTALERT_ISOLATE = 28,
	INET_FLAGS_SNDFLOW = 29,
	INET_FLAGS_RTALERT = 30,
};

enum {
	INET_FRAG_FIRST_IN = 1,
	INET_FRAG_LAST_IN = 2,
	INET_FRAG_COMPLETE = 4,
	INET_FRAG_HASH_DEAD = 8,
	INET_FRAG_DROP = 16,
};

enum {
	INET_ULP_INFO_UNSPEC = 0,
	INET_ULP_INFO_NAME = 1,
	INET_ULP_INFO_TLS = 2,
	INET_ULP_INFO_MPTCP = 3,
	__INET_ULP_INFO_MAX = 4,
};

enum {
	INSN_F_FRAMENO_MASK = 7,
	INSN_F_SPI_MASK = 63,
	INSN_F_SPI_SHIFT = 3,
	INSN_F_STACK_ACCESS = 512,
};

enum {
	INTERRUPT_MASK_ALL_VER_11 = 204799,
	INTERRUPT_MASK_ALL_VER_21 = 466943,
};

enum {
	INVERT = 1,
	PROCESS_AND = 2,
	PROCESS_OR = 4,
};

enum {
	IOAM6_ATTR_UNSPEC = 0,
	IOAM6_ATTR_NS_ID = 1,
	IOAM6_ATTR_NS_DATA = 2,
	IOAM6_ATTR_NS_DATA_WIDE = 3,
	IOAM6_ATTR_SC_ID = 4,
	IOAM6_ATTR_SC_DATA = 5,
	IOAM6_ATTR_SC_NONE = 6,
	IOAM6_ATTR_PAD = 7,
	__IOAM6_ATTR_MAX = 8,
};

enum {
	IOAM6_CMD_UNSPEC = 0,
	IOAM6_CMD_ADD_NAMESPACE = 1,
	IOAM6_CMD_DEL_NAMESPACE = 2,
	IOAM6_CMD_DUMP_NAMESPACES = 3,
	IOAM6_CMD_ADD_SCHEMA = 4,
	IOAM6_CMD_DEL_SCHEMA = 5,
	IOAM6_CMD_DUMP_SCHEMAS = 6,
	IOAM6_CMD_NS_SET_SCHEMA = 7,
	__IOAM6_CMD_MAX = 8,
};

enum {
	IOAM6_IPTUNNEL_UNSPEC = 0,
	IOAM6_IPTUNNEL_MODE = 1,
	IOAM6_IPTUNNEL_DST = 2,
	IOAM6_IPTUNNEL_TRACE = 3,
	IOAM6_IPTUNNEL_FREQ_K = 4,
	IOAM6_IPTUNNEL_FREQ_N = 5,
	__IOAM6_IPTUNNEL_MAX = 6,
};

enum {
	IOCB_CMD_PREAD = 0,
	IOCB_CMD_PWRITE = 1,
	IOCB_CMD_FSYNC = 2,
	IOCB_CMD_FDSYNC = 3,
	IOCB_CMD_POLL = 5,
	IOCB_CMD_NOOP = 6,
	IOCB_CMD_PREADV = 7,
	IOCB_CMD_PWRITEV = 8,
};

enum {
	IOCMD_IOC_ENABLE = 1,
	IOCMD_IOC_DISABLE = 2,
	IOCMD_IOC_GET_ATTR = 3,
	IOCMD_IOC_GET_INFO = 4,
	IOCMD_IOC_GET_STATS = 5,
	IOCMD_IOC_GET_FWSTATS = 6,
	IOCMD_IOC_RESET_STATS = 7,
	IOCMD_IOC_RESET_FWSTATS = 8,
	IOCMD_IOC_SET_ADAPTER_NAME = 9,
	IOCMD_IOC_SET_PORT_NAME = 10,
	IOCMD_IOC_FW_SIG_INV = 11,
	IOCMD_IOCFC_GET_ATTR = 12,
	IOCMD_IOCFC_SET_INTR = 13,
	IOCMD_PORT_ENABLE = 14,
	IOCMD_PORT_DISABLE = 15,
	IOCMD_PORT_GET_ATTR = 16,
	IOCMD_PORT_GET_STATS = 17,
	IOCMD_PORT_RESET_STATS = 18,
	IOCMD_PORT_CFG_TOPO = 19,
	IOCMD_PORT_CFG_SPEED = 20,
	IOCMD_PORT_CFG_ALPA = 21,
	IOCMD_PORT_CFG_MAXFRSZ = 22,
	IOCMD_PORT_CLR_ALPA = 23,
	IOCMD_PORT_BBCR_ENABLE = 24,
	IOCMD_PORT_BBCR_DISABLE = 25,
	IOCMD_PORT_BBCR_GET_ATTR = 26,
	IOCMD_LPORT_GET_ATTR = 27,
	IOCMD_LPORT_GET_RPORTS = 28,
	IOCMD_LPORT_GET_STATS = 29,
	IOCMD_LPORT_RESET_STATS = 30,
	IOCMD_LPORT_GET_IOSTATS = 31,
	IOCMD_RPORT_GET_ATTR = 32,
	IOCMD_RPORT_GET_ADDR = 33,
	IOCMD_RPORT_GET_STATS = 34,
	IOCMD_RPORT_RESET_STATS = 35,
	IOCMD_RPORT_SET_SPEED = 36,
	IOCMD_VPORT_GET_ATTR = 37,
	IOCMD_VPORT_GET_STATS = 38,
	IOCMD_VPORT_RESET_STATS = 39,
	IOCMD_FABRIC_GET_LPORTS = 40,
	IOCMD_RATELIM_ENABLE = 41,
	IOCMD_RATELIM_DISABLE = 42,
	IOCMD_RATELIM_DEF_SPEED = 43,
	IOCMD_FCPIM_FAILOVER = 44,
	IOCMD_FCPIM_MODSTATS = 45,
	IOCMD_FCPIM_MODSTATSCLR = 46,
	IOCMD_FCPIM_DEL_ITN_STATS = 47,
	IOCMD_ITNIM_GET_ATTR = 48,
	IOCMD_ITNIM_GET_IOSTATS = 49,
	IOCMD_ITNIM_RESET_STATS = 50,
	IOCMD_ITNIM_GET_ITNSTATS = 51,
	IOCMD_IOC_PCIFN_CFG = 52,
	IOCMD_FCPORT_ENABLE = 53,
	IOCMD_FCPORT_DISABLE = 54,
	IOCMD_PCIFN_CREATE = 55,
	IOCMD_PCIFN_DELETE = 56,
	IOCMD_PCIFN_BW = 57,
	IOCMD_ADAPTER_CFG_MODE = 58,
	IOCMD_PORT_CFG_MODE = 59,
	IOCMD_FLASH_ENABLE_OPTROM = 60,
	IOCMD_FLASH_DISABLE_OPTROM = 61,
	IOCMD_FAA_QUERY = 62,
	IOCMD_CEE_GET_ATTR = 63,
	IOCMD_CEE_GET_STATS = 64,
	IOCMD_CEE_RESET_STATS = 65,
	IOCMD_SFP_MEDIA = 66,
	IOCMD_SFP_SPEED = 67,
	IOCMD_FLASH_GET_ATTR = 68,
	IOCMD_FLASH_ERASE_PART = 69,
	IOCMD_FLASH_UPDATE_PART = 70,
	IOCMD_FLASH_READ_PART = 71,
	IOCMD_DIAG_TEMP = 72,
	IOCMD_DIAG_MEMTEST = 73,
	IOCMD_DIAG_LOOPBACK = 74,
	IOCMD_DIAG_FWPING = 75,
	IOCMD_DIAG_QUEUETEST = 76,
	IOCMD_DIAG_SFP = 77,
	IOCMD_DIAG_LED = 78,
	IOCMD_DIAG_BEACON_LPORT = 79,
	IOCMD_DIAG_LB_STAT = 80,
	IOCMD_PHY_GET_ATTR = 81,
	IOCMD_PHY_GET_STATS = 82,
	IOCMD_PHY_UPDATE_FW = 83,
	IOCMD_PHY_READ_FW = 84,
	IOCMD_VHBA_QUERY = 85,
	IOCMD_DEBUG_PORTLOG = 86,
	IOCMD_DEBUG_FW_CORE = 87,
	IOCMD_DEBUG_FW_STATE_CLR = 88,
	IOCMD_DEBUG_PORTLOG_CLR = 89,
	IOCMD_DEBUG_START_DTRC = 90,
	IOCMD_DEBUG_STOP_DTRC = 91,
	IOCMD_DEBUG_PORTLOG_CTL = 92,
	IOCMD_FCPIM_PROFILE_ON = 93,
	IOCMD_FCPIM_PROFILE_OFF = 94,
	IOCMD_ITNIM_GET_IOPROFILE = 95,
	IOCMD_FCPORT_GET_STATS = 96,
	IOCMD_FCPORT_RESET_STATS = 97,
	IOCMD_BOOT_CFG = 98,
	IOCMD_BOOT_QUERY = 99,
	IOCMD_PREBOOT_QUERY = 100,
	IOCMD_ETHBOOT_CFG = 101,
	IOCMD_ETHBOOT_QUERY = 102,
	IOCMD_TRUNK_ENABLE = 103,
	IOCMD_TRUNK_DISABLE = 104,
	IOCMD_TRUNK_GET_ATTR = 105,
	IOCMD_QOS_ENABLE = 106,
	IOCMD_QOS_DISABLE = 107,
	IOCMD_QOS_GET_ATTR = 108,
	IOCMD_QOS_GET_VC_ATTR = 109,
	IOCMD_QOS_GET_STATS = 110,
	IOCMD_QOS_RESET_STATS = 111,
	IOCMD_VF_GET_STATS = 112,
	IOCMD_VF_RESET_STATS = 113,
	IOCMD_FCPIM_LUNMASK_ENABLE = 114,
	IOCMD_FCPIM_LUNMASK_DISABLE = 115,
	IOCMD_FCPIM_LUNMASK_CLEAR = 116,
	IOCMD_FCPIM_LUNMASK_QUERY = 117,
	IOCMD_FCPIM_LUNMASK_ADD = 118,
	IOCMD_FCPIM_LUNMASK_DELETE = 119,
	IOCMD_DIAG_DPORT_ENABLE = 120,
	IOCMD_DIAG_DPORT_DISABLE = 121,
	IOCMD_QOS_SET_BW = 122,
	IOCMD_FCPIM_THROTTLE_QUERY = 123,
	IOCMD_FCPIM_THROTTLE_SET = 124,
	IOCMD_TFRU_READ = 125,
	IOCMD_TFRU_WRITE = 126,
	IOCMD_FRUVPD_READ = 127,
	IOCMD_FRUVPD_UPDATE = 128,
	IOCMD_FRUVPD_GET_MAX_SIZE = 129,
	IOCMD_DIAG_DPORT_SHOW = 130,
	IOCMD_DIAG_DPORT_START = 131,
};

enum {
	IOMMU_SET_DOMAIN_MUST_SUCCEED = 1,
};

enum {
	IOPRIO_CLASS_NONE = 0,
	IOPRIO_CLASS_RT = 1,
	IOPRIO_CLASS_BE = 2,
	IOPRIO_CLASS_IDLE = 3,
	IOPRIO_CLASS_INVALID = 7,
};

enum {
	IOPRIO_HINT_NONE = 0,
	IOPRIO_HINT_DEV_DURATION_LIMIT_1 = 1,
	IOPRIO_HINT_DEV_DURATION_LIMIT_2 = 2,
	IOPRIO_HINT_DEV_DURATION_LIMIT_3 = 3,
	IOPRIO_HINT_DEV_DURATION_LIMIT_4 = 4,
	IOPRIO_HINT_DEV_DURATION_LIMIT_5 = 5,
	IOPRIO_HINT_DEV_DURATION_LIMIT_6 = 6,
	IOPRIO_HINT_DEV_DURATION_LIMIT_7 = 7,
};

enum {
	IOPRIO_WHO_PROCESS = 1,
	IOPRIO_WHO_PGRP = 2,
	IOPRIO_WHO_USER = 3,
};

enum {
	IORES_DESC_NONE = 0,
	IORES_DESC_CRASH_KERNEL = 1,
	IORES_DESC_ACPI_TABLES = 2,
	IORES_DESC_ACPI_NV_STORAGE = 3,
	IORES_DESC_PERSISTENT_MEMORY = 4,
	IORES_DESC_PERSISTENT_MEMORY_LEGACY = 5,
	IORES_DESC_DEVICE_PRIVATE_MEMORY = 6,
	IORES_DESC_RESERVED = 7,
	IORES_DESC_SOFT_RESERVED = 8,
	IORES_DESC_CXL = 9,
};

enum {
	IORING_RSRC_FILE = 0,
	IORING_RSRC_BUFFER = 1,
};

enum {
	IOU_F_TWQ_LAZY_WAKE = 1,
};

enum {
	IOU_OK = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_REQUEUE = -3072,
	IOU_STOP_MULTISHOT = -125,
};

enum {
	IOU_POLL_DONE = 0,
	IOU_POLL_NO_ACTION = 1,
	IOU_POLL_REMOVE_POLL_USE_RES = 2,
	IOU_POLL_REISSUE = 3,
	IOU_POLL_REQUEUE = 4,
};

enum {
	IO_ACCT_STALLED_BIT = 0,
};

enum {
	IO_APOLL_OK = 0,
	IO_APOLL_ABORTED = 1,
	IO_APOLL_READY = 2,
};

enum {
	IO_CHECK_CQ_OVERFLOW_BIT = 0,
	IO_CHECK_CQ_DROPPED_BIT = 1,
};

enum {
	IO_EVENTFD_OP_SIGNAL_BIT = 0,
	IO_EVENTFD_OP_FREE_BIT = 1,
};

enum {
	IO_SQ_THREAD_SHOULD_STOP = 0,
	IO_SQ_THREAD_SHOULD_PARK = 1,
};

enum {
	IO_WORKER_F_UP = 0,
	IO_WORKER_F_RUNNING = 1,
	IO_WORKER_F_FREE = 2,
	IO_WORKER_F_BOUND = 3,
};

enum {
	IO_WQ_ACCT_BOUND = 0,
	IO_WQ_ACCT_UNBOUND = 1,
	IO_WQ_ACCT_NR = 2,
};

enum {
	IO_WQ_BIT_EXIT = 0,
};

enum {
	IO_WQ_WORK_CANCEL = 1,
	IO_WQ_WORK_HASHED = 2,
	IO_WQ_WORK_UNBOUND = 4,
	IO_WQ_WORK_CONCURRENT = 16,
	IO_WQ_HASH_SHIFT = 24,
};

enum {
	IP6MRA_CREPORT_UNSPEC = 0,
	IP6MRA_CREPORT_MSGTYPE = 1,
	IP6MRA_CREPORT_MIF_ID = 2,
	IP6MRA_CREPORT_SRC_ADDR = 3,
	IP6MRA_CREPORT_DST_ADDR = 4,
	IP6MRA_CREPORT_PKT = 5,
	__IP6MRA_CREPORT_MAX = 6,
};

enum {
	IP6_FH_F_FRAG = 1,
	IP6_FH_F_AUTH = 2,
	IP6_FH_F_SKIP_RH = 4,
};

enum {
	IPMRA_CREPORT_UNSPEC = 0,
	IPMRA_CREPORT_MSGTYPE = 1,
	IPMRA_CREPORT_VIF_ID = 2,
	IPMRA_CREPORT_SRC_ADDR = 3,
	IPMRA_CREPORT_DST_ADDR = 4,
	IPMRA_CREPORT_PKT = 5,
	IPMRA_CREPORT_TABLE = 6,
	__IPMRA_CREPORT_MAX = 7,
};

enum {
	IPMRA_TABLE_UNSPEC = 0,
	IPMRA_TABLE_ID = 1,
	IPMRA_TABLE_CACHE_RES_QUEUE_LEN = 2,
	IPMRA_TABLE_MROUTE_REG_VIF_NUM = 3,
	IPMRA_TABLE_MROUTE_DO_ASSERT = 4,
	IPMRA_TABLE_MROUTE_DO_PIM = 5,
	IPMRA_TABLE_VIFS = 6,
	IPMRA_TABLE_MROUTE_DO_WRVIFWHOLE = 7,
	__IPMRA_TABLE_MAX = 8,
};

enum {
	IPMRA_VIFA_UNSPEC = 0,
	IPMRA_VIFA_IFINDEX = 1,
	IPMRA_VIFA_VIF_ID = 2,
	IPMRA_VIFA_FLAGS = 3,
	IPMRA_VIFA_BYTES_IN = 4,
	IPMRA_VIFA_BYTES_OUT = 5,
	IPMRA_VIFA_PACKETS_IN = 6,
	IPMRA_VIFA_PACKETS_OUT = 7,
	IPMRA_VIFA_LOCAL_ADDR = 8,
	IPMRA_VIFA_REMOTE_ADDR = 9,
	IPMRA_VIFA_PAD = 10,
	__IPMRA_VIFA_MAX = 11,
};

enum {
	IPMRA_VIF_UNSPEC = 0,
	IPMRA_VIF = 1,
	__IPMRA_VIF_MAX = 2,
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_RAW = 255,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 4,
	IPSTATS_MIB_OUTREQUESTS = 5,
	IPSTATS_MIB_OUTOCTETS = 6,
	IPSTATS_MIB_INHDRERRORS = 7,
	IPSTATS_MIB_INTOOBIGERRORS = 8,
	IPSTATS_MIB_INNOROUTES = 9,
	IPSTATS_MIB_INADDRERRORS = 10,
	IPSTATS_MIB_INUNKNOWNPROTOS = 11,
	IPSTATS_MIB_INTRUNCATEDPKTS = 12,
	IPSTATS_MIB_INDISCARDS = 13,
	IPSTATS_MIB_OUTDISCARDS = 14,
	IPSTATS_MIB_OUTNOROUTES = 15,
	IPSTATS_MIB_REASMTIMEOUT = 16,
	IPSTATS_MIB_REASMREQDS = 17,
	IPSTATS_MIB_REASMOKS = 18,
	IPSTATS_MIB_REASMFAILS = 19,
	IPSTATS_MIB_FRAGOKS = 20,
	IPSTATS_MIB_FRAGFAILS = 21,
	IPSTATS_MIB_FRAGCREATES = 22,
	IPSTATS_MIB_INMCASTPKTS = 23,
	IPSTATS_MIB_OUTMCASTPKTS = 24,
	IPSTATS_MIB_INBCASTPKTS = 25,
	IPSTATS_MIB_OUTBCASTPKTS = 26,
	IPSTATS_MIB_INMCASTOCTETS = 27,
	IPSTATS_MIB_OUTMCASTOCTETS = 28,
	IPSTATS_MIB_INBCASTOCTETS = 29,
	IPSTATS_MIB_OUTBCASTOCTETS = 30,
	IPSTATS_MIB_CSUMERRORS = 31,
	IPSTATS_MIB_NOECTPKTS = 32,
	IPSTATS_MIB_ECT1PKTS = 33,
	IPSTATS_MIB_ECT0PKTS = 34,
	IPSTATS_MIB_CEPKTS = 35,
	IPSTATS_MIB_REASM_OVERLAPS = 36,
	IPSTATS_MIB_OUTPKTS = 37,
	__IPSTATS_MIB_MAX = 38,
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

enum {
	IPV6_SADDR_RULE_INIT = 0,
	IPV6_SADDR_RULE_LOCAL = 1,
	IPV6_SADDR_RULE_SCOPE = 2,
	IPV6_SADDR_RULE_PREFERRED = 3,
	IPV6_SADDR_RULE_HOA = 4,
	IPV6_SADDR_RULE_OIF = 5,
	IPV6_SADDR_RULE_LABEL = 6,
	IPV6_SADDR_RULE_PRIVACY = 7,
	IPV6_SADDR_RULE_ORCHID = 8,
	IPV6_SADDR_RULE_PREFIX = 9,
	IPV6_SADDR_RULE_NOT_OPTIMISTIC = 10,
	IPV6_SADDR_RULE_MAX = 11,
};

enum {
	IP_TUNNEL_CSUM_BIT = 0,
	IP_TUNNEL_ROUTING_BIT = 1,
	IP_TUNNEL_KEY_BIT = 2,
	IP_TUNNEL_SEQ_BIT = 3,
	IP_TUNNEL_STRICT_BIT = 4,
	IP_TUNNEL_REC_BIT = 5,
	IP_TUNNEL_VERSION_BIT = 6,
	IP_TUNNEL_NO_KEY_BIT = 7,
	IP_TUNNEL_DONT_FRAGMENT_BIT = 8,
	IP_TUNNEL_OAM_BIT = 9,
	IP_TUNNEL_CRIT_OPT_BIT = 10,
	IP_TUNNEL_GENEVE_OPT_BIT = 11,
	IP_TUNNEL_VXLAN_OPT_BIT = 12,
	IP_TUNNEL_NOCACHE_BIT = 13,
	IP_TUNNEL_ERSPAN_OPT_BIT = 14,
	IP_TUNNEL_GTP_OPT_BIT = 15,
	IP_TUNNEL_VTI_BIT = 16,
	IP_TUNNEL_SIT_ISATAP_BIT = 16,
	IP_TUNNEL_PFCP_OPT_BIT = 17,
	__IP_TUNNEL_FLAG_NUM = 18,
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
};

enum {
	IRQC_IS_HARDIRQ = 0,
	IRQC_IS_NESTED = 1,
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_MOVE_PCNTXT = 32768,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_HANDLE_ENFORCE_IRQCTX = 134217728,
	IRQD_AFFINITY_ON_ACTIVATE = 268435456,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 536870912,
	IRQD_RESEND_WHEN_IN_PROGRESS = 1073741824,
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	IRQTF_RUNTHREAD = 0,
	IRQTF_WARNED = 1,
	IRQTF_AFFINITY = 2,
	IRQTF_FORCED_THREAD = 3,
	IRQTF_READY = 4,
};

enum {
	IRQ_DOMAIN_FLAG_HIERARCHY = 1,
	IRQ_DOMAIN_NAME_ALLOCATED = 2,
	IRQ_DOMAIN_FLAG_IPI_PER_CPU = 4,
	IRQ_DOMAIN_FLAG_IPI_SINGLE = 8,
	IRQ_DOMAIN_FLAG_MSI = 16,
	IRQ_DOMAIN_FLAG_ISOLATED_MSI = 32,
	IRQ_DOMAIN_FLAG_NO_MAP = 64,
	IRQ_DOMAIN_FLAG_MSI_PARENT = 256,
	IRQ_DOMAIN_FLAG_MSI_DEVICE = 512,
	IRQ_DOMAIN_FLAG_NONCORE = 65536,
};

enum {
	IRQ_POLL_F_SCHED = 0,
	IRQ_POLL_F_DISABLE = 1,
};

enum {
	IRQ_SET_MASK_OK = 0,
	IRQ_SET_MASK_OK_NOCOPY = 1,
	IRQ_SET_MASK_OK_DONE = 2,
};

enum {
	IRQ_STARTUP_NORMAL = 0,
	IRQ_STARTUP_MANAGED = 1,
	IRQ_STARTUP_ABORT = 2,
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_MOVE_PCNTXT = 16384,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	ISCSI_CONN_INITIAL_STAGE = 0,
	ISCSI_CONN_STARTED = 1,
	ISCSI_CONN_STOPPED = 2,
	ISCSI_CONN_CLEANUP_WAIT = 3,
};

enum {
	ISCSI_HOST_SETUP = 0,
	ISCSI_HOST_REMOVED = 1,
};

enum {
	ISCSI_MAX_AHS_SIZE = 256,
	ISCSI_DIGEST_SIZE = 4,
};

enum {
	ISCSI_SESSION_LOGGED_IN = 0,
	ISCSI_SESSION_FAILED = 1,
	ISCSI_SESSION_FREE = 2,
};

enum {
	ISCSI_SESSION_TARGET_UNBOUND = 0,
	ISCSI_SESSION_TARGET_ALLOCATED = 1,
	ISCSI_SESSION_TARGET_SCANNED = 2,
	ISCSI_SESSION_TARGET_UNBINDING = 3,
	ISCSI_SESSION_TARGET_MAX = 4,
};

enum {
	ISCSI_STATE_FREE = 1,
	ISCSI_STATE_LOGGED_IN = 2,
	ISCSI_STATE_FAILED = 3,
	ISCSI_STATE_TERMINATE = 4,
	ISCSI_STATE_IN_RECOVERY = 5,
	ISCSI_STATE_RECOVERY_FAILED = 6,
	ISCSI_STATE_LOGGING_OUT = 7,
};

enum {
	ISCSI_TASK_FREE = 0,
	ISCSI_TASK_COMPLETED = 1,
	ISCSI_TASK_PENDING = 2,
	ISCSI_TASK_RUNNING = 3,
	ISCSI_TASK_ABRT_TMF = 4,
	ISCSI_TASK_ABRT_SESS_RECOV = 5,
	ISCSI_TASK_REQUEUE_SCSIQ = 6,
};

enum {
	ISCSI_TCP_SEGMENT_DONE = 0,
	ISCSI_TCP_SKB_DONE = 1,
	ISCSI_TCP_CONN_ERR = 2,
	ISCSI_TCP_SUSPENDED = 3,
};

enum {
	I_DATA_SEM_NORMAL = 0,
	I_DATA_SEM_OTHER = 1,
	I_DATA_SEM_QUOTA = 2,
	I_DATA_SEM_EA = 3,
};

enum {
	I_LCOEF_RBPS = 0,
	I_LCOEF_RSEQIOPS = 1,
	I_LCOEF_RRANDIOPS = 2,
	I_LCOEF_WBPS = 3,
	I_LCOEF_WSEQIOPS = 4,
	I_LCOEF_WRANDIOPS = 5,
	NR_I_LCOEFS = 6,
};

enum {
	K2_FLAG_SATA_8_PORTS = 16777216,
	K2_FLAG_NO_ATAPI_DMA = 33554432,
	K2_FLAG_BAR_POS_3 = 67108864,
	K2_SATA_TF_CMD_OFFSET = 0,
	K2_SATA_TF_DATA_OFFSET = 0,
	K2_SATA_TF_ERROR_OFFSET = 4,
	K2_SATA_TF_NSECT_OFFSET = 8,
	K2_SATA_TF_LBAL_OFFSET = 12,
	K2_SATA_TF_LBAM_OFFSET = 16,
	K2_SATA_TF_LBAH_OFFSET = 20,
	K2_SATA_TF_DEVICE_OFFSET = 24,
	K2_SATA_TF_CMDSTAT_OFFSET = 28,
	K2_SATA_TF_CTL_OFFSET = 32,
	K2_SATA_DMA_CMD_OFFSET = 48,
	K2_SATA_SCR_STATUS_OFFSET = 64,
	K2_SATA_SCR_ERROR_OFFSET = 68,
	K2_SATA_SCR_CONTROL_OFFSET = 72,
	K2_SATA_SICR1_OFFSET = 128,
	K2_SATA_SICR2_OFFSET = 132,
	K2_SATA_SIM_OFFSET = 136,
	K2_SATA_PORT_OFFSET = 256,
	chip_svw4 = 0,
	chip_svw8 = 1,
	chip_svw42 = 2,
	chip_svw43 = 3,
};

enum {
	KBUF_MODE_EXPAND = 1,
	KBUF_MODE_FREE = 2,
};

enum {
	KERNEL_PARAM_FL_UNSAFE = 1,
	KERNEL_PARAM_FL_HWPARAM = 2,
};

enum {
	KERNEL_PARAM_OPS_FL_NOARG = 1,
};

enum {
	KF_ARG_DYNPTR_ID = 0,
	KF_ARG_LIST_HEAD_ID = 1,
	KF_ARG_LIST_NODE_ID = 2,
	KF_ARG_RB_ROOT_ID = 3,
	KF_ARG_RB_NODE_ID = 4,
	KF_ARG_WORKQUEUE_ID = 5,
};

enum {
	KTW_FREEZABLE = 1,
};

enum {
	KVMPPC_GSE_BE32 = 0,
	KVMPPC_GSE_BE64 = 1,
	KVMPPC_GSE_VEC128 = 2,
	KVMPPC_GSE_PARTITION_TABLE = 3,
	KVMPPC_GSE_PROCESS_TABLE = 4,
	KVMPPC_GSE_BUFFER = 5,
	__KVMPPC_GSE_TYPE_MAX = 6,
};

enum {
	KVMPPC_GS_CLASS_GUESTWIDE = 1,
	KVMPPC_GS_CLASS_META = 2,
	KVMPPC_GS_CLASS_DWORD_REG = 4,
	KVMPPC_GS_CLASS_WORD_REG = 8,
	KVMPPC_GS_CLASS_VECTOR = 16,
	KVMPPC_GS_CLASS_INTR = 32,
};

enum {
	KVMPPC_GS_FLAGS_WIDE = 1,
};

enum {
	L2T_STATE_VALID = 0,
	L2T_STATE_STALE = 1,
	L2T_STATE_RESOLVING = 2,
	L2T_STATE_UNUSED = 3,
};

enum {
	LAST_NORM = 0,
	LAST_ROOT = 1,
	LAST_DOT = 2,
	LAST_DOTDOT = 3,
};

enum {
	LAT_OK = 1,
	LAT_UNKNOWN = 2,
	LAT_UNKNOWN_WRITES = 3,
	LAT_EXCEEDED = 4,
};

enum {
	LCOEF_RPAGE = 0,
	LCOEF_RSEQIO = 1,
	LCOEF_RRANDIO = 2,
	LCOEF_WPAGE = 3,
	LCOEF_WSEQIO = 4,
	LCOEF_WRANDIO = 5,
	NR_LCOEFS = 6,
};

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_RESUMING = 4194304,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_ZAC = 1073741824,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_BOOT = 30000,
	ATA_TMOUT_BOOT_QUICK = 7000,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_HORKAGE_DIAGNOSTIC = 1,
	ATA_HORKAGE_NODMA = 2,
	ATA_HORKAGE_NONCQ = 4,
	ATA_HORKAGE_MAX_SEC_128 = 8,
	ATA_HORKAGE_BROKEN_HPA = 16,
	ATA_HORKAGE_DISABLE = 32,
	ATA_HORKAGE_HPA_SIZE = 64,
	ATA_HORKAGE_IVB = 256,
	ATA_HORKAGE_STUCK_ERR = 512,
	ATA_HORKAGE_BRIDGE_OK = 1024,
	ATA_HORKAGE_ATAPI_MOD16_DMA = 2048,
	ATA_HORKAGE_FIRMWARE_WARN = 4096,
	ATA_HORKAGE_1_5_GBPS = 8192,
	ATA_HORKAGE_NOSETXFER = 16384,
	ATA_HORKAGE_BROKEN_FPDMA_AA = 32768,
	ATA_HORKAGE_DUMP_ID = 65536,
	ATA_HORKAGE_MAX_SEC_LBA48 = 131072,
	ATA_HORKAGE_ATAPI_DMADIR = 262144,
	ATA_HORKAGE_NO_NCQ_TRIM = 524288,
	ATA_HORKAGE_NOLPM = 1048576,
	ATA_HORKAGE_WD_BROKEN_LPM = 2097152,
	ATA_HORKAGE_ZERO_AFTER_TRIM = 4194304,
	ATA_HORKAGE_NO_DMA_LOG = 8388608,
	ATA_HORKAGE_NOTRIM = 16777216,
	ATA_HORKAGE_MAX_SEC_1024 = 33554432,
	ATA_HORKAGE_MAX_TRIM_128M = 67108864,
	ATA_HORKAGE_NO_NCQ_ON_ATI = 134217728,
	ATA_HORKAGE_NO_ID_DEV_LOG = 268435456,
	ATA_HORKAGE_NO_LOG_DIR = 536870912,
	ATA_HORKAGE_NO_FUA = 1073741824,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_DELAYEDACKS = 16,
	LINUX_MIB_DELAYEDACKLOCKED = 17,
	LINUX_MIB_DELAYEDACKLOST = 18,
	LINUX_MIB_LISTENOVERFLOWS = 19,
	LINUX_MIB_LISTENDROPS = 20,
	LINUX_MIB_TCPHPHITS = 21,
	LINUX_MIB_TCPPUREACKS = 22,
	LINUX_MIB_TCPHPACKS = 23,
	LINUX_MIB_TCPRENORECOVERY = 24,
	LINUX_MIB_TCPSACKRECOVERY = 25,
	LINUX_MIB_TCPSACKRENEGING = 26,
	LINUX_MIB_TCPSACKREORDER = 27,
	LINUX_MIB_TCPRENOREORDER = 28,
	LINUX_MIB_TCPTSREORDER = 29,
	LINUX_MIB_TCPFULLUNDO = 30,
	LINUX_MIB_TCPPARTIALUNDO = 31,
	LINUX_MIB_TCPDSACKUNDO = 32,
	LINUX_MIB_TCPLOSSUNDO = 33,
	LINUX_MIB_TCPLOSTRETRANSMIT = 34,
	LINUX_MIB_TCPRENOFAILURES = 35,
	LINUX_MIB_TCPSACKFAILURES = 36,
	LINUX_MIB_TCPLOSSFAILURES = 37,
	LINUX_MIB_TCPFASTRETRANS = 38,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 39,
	LINUX_MIB_TCPTIMEOUTS = 40,
	LINUX_MIB_TCPLOSSPROBES = 41,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 42,
	LINUX_MIB_TCPRENORECOVERYFAIL = 43,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 44,
	LINUX_MIB_TCPRCVCOLLAPSED = 45,
	LINUX_MIB_TCPDSACKOLDSENT = 46,
	LINUX_MIB_TCPDSACKOFOSENT = 47,
	LINUX_MIB_TCPDSACKRECV = 48,
	LINUX_MIB_TCPDSACKOFORECV = 49,
	LINUX_MIB_TCPABORTONDATA = 50,
	LINUX_MIB_TCPABORTONCLOSE = 51,
	LINUX_MIB_TCPABORTONMEMORY = 52,
	LINUX_MIB_TCPABORTONTIMEOUT = 53,
	LINUX_MIB_TCPABORTONLINGER = 54,
	LINUX_MIB_TCPABORTFAILED = 55,
	LINUX_MIB_TCPMEMORYPRESSURES = 56,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 57,
	LINUX_MIB_TCPSACKDISCARD = 58,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 59,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 60,
	LINUX_MIB_TCPSPURIOUSRTOS = 61,
	LINUX_MIB_TCPMD5NOTFOUND = 62,
	LINUX_MIB_TCPMD5UNEXPECTED = 63,
	LINUX_MIB_TCPMD5FAILURE = 64,
	LINUX_MIB_SACKSHIFTED = 65,
	LINUX_MIB_SACKMERGED = 66,
	LINUX_MIB_SACKSHIFTFALLBACK = 67,
	LINUX_MIB_TCPBACKLOGDROP = 68,
	LINUX_MIB_PFMEMALLOCDROP = 69,
	LINUX_MIB_TCPMINTTLDROP = 70,
	LINUX_MIB_TCPDEFERACCEPTDROP = 71,
	LINUX_MIB_IPRPFILTER = 72,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 73,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 74,
	LINUX_MIB_TCPREQQFULLDROP = 75,
	LINUX_MIB_TCPRETRANSFAIL = 76,
	LINUX_MIB_TCPRCVCOALESCE = 77,
	LINUX_MIB_TCPBACKLOGCOALESCE = 78,
	LINUX_MIB_TCPOFOQUEUE = 79,
	LINUX_MIB_TCPOFODROP = 80,
	LINUX_MIB_TCPOFOMERGE = 81,
	LINUX_MIB_TCPCHALLENGEACK = 82,
	LINUX_MIB_TCPSYNCHALLENGE = 83,
	LINUX_MIB_TCPFASTOPENACTIVE = 84,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 85,
	LINUX_MIB_TCPFASTOPENPASSIVE = 86,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 87,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 88,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 89,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 90,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 91,
	LINUX_MIB_BUSYPOLLRXPACKETS = 92,
	LINUX_MIB_TCPAUTOCORKING = 93,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 94,
	LINUX_MIB_TCPTOZEROWINDOWADV = 95,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 96,
	LINUX_MIB_TCPSYNRETRANS = 97,
	LINUX_MIB_TCPORIGDATASENT = 98,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 99,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 100,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 101,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 102,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 103,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 104,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 105,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 106,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 107,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 108,
	LINUX_MIB_TCPWINPROBE = 109,
	LINUX_MIB_TCPKEEPALIVE = 110,
	LINUX_MIB_TCPMTUPFAIL = 111,
	LINUX_MIB_TCPMTUPSUCCESS = 112,
	LINUX_MIB_TCPDELIVERED = 113,
	LINUX_MIB_TCPDELIVEREDCE = 114,
	LINUX_MIB_TCPACKCOMPRESSED = 115,
	LINUX_MIB_TCPZEROWINDOWDROP = 116,
	LINUX_MIB_TCPRCVQDROP = 117,
	LINUX_MIB_TCPWQUEUETOOBIG = 118,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 119,
	LINUX_MIB_TCPTIMEOUTREHASH = 120,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 121,
	LINUX_MIB_TCPDSACKRECVSEGS = 122,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 123,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 124,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 125,
	LINUX_MIB_TCPPLBREHASH = 126,
	LINUX_MIB_TCPAOREQUIRED = 127,
	LINUX_MIB_TCPAOBAD = 128,
	LINUX_MIB_TCPAOKEYNOTFOUND = 129,
	LINUX_MIB_TCPAOGOOD = 130,
	LINUX_MIB_TCPAODROPPEDICMPS = 131,
	__LINUX_MIB_MAX = 132,
};

enum {
	LINUX_MIB_TLSNUM = 0,
	LINUX_MIB_TLSCURRTXSW = 1,
	LINUX_MIB_TLSCURRRXSW = 2,
	LINUX_MIB_TLSCURRTXDEVICE = 3,
	LINUX_MIB_TLSCURRRXDEVICE = 4,
	LINUX_MIB_TLSTXSW = 5,
	LINUX_MIB_TLSRXSW = 6,
	LINUX_MIB_TLSTXDEVICE = 7,
	LINUX_MIB_TLSRXDEVICE = 8,
	LINUX_MIB_TLSDECRYPTERROR = 9,
	LINUX_MIB_TLSRXDEVICERESYNC = 10,
	LINUX_MIB_TLSDECRYPTRETRY = 11,
	LINUX_MIB_TLSRXNOPADVIOL = 12,
	__LINUX_MIB_TLSMAX = 13,
};

enum {
	LINUX_MIB_XFRMNUM = 0,
	LINUX_MIB_XFRMINERROR = 1,
	LINUX_MIB_XFRMINBUFFERERROR = 2,
	LINUX_MIB_XFRMINHDRERROR = 3,
	LINUX_MIB_XFRMINNOSTATES = 4,
	LINUX_MIB_XFRMINSTATEPROTOERROR = 5,
	LINUX_MIB_XFRMINSTATEMODEERROR = 6,
	LINUX_MIB_XFRMINSTATESEQERROR = 7,
	LINUX_MIB_XFRMINSTATEEXPIRED = 8,
	LINUX_MIB_XFRMINSTATEMISMATCH = 9,
	LINUX_MIB_XFRMINSTATEINVALID = 10,
	LINUX_MIB_XFRMINTMPLMISMATCH = 11,
	LINUX_MIB_XFRMINNOPOLS = 12,
	LINUX_MIB_XFRMINPOLBLOCK = 13,
	LINUX_MIB_XFRMINPOLERROR = 14,
	LINUX_MIB_XFRMOUTERROR = 15,
	LINUX_MIB_XFRMOUTBUNDLEGENERROR = 16,
	LINUX_MIB_XFRMOUTBUNDLECHECKERROR = 17,
	LINUX_MIB_XFRMOUTNOSTATES = 18,
	LINUX_MIB_XFRMOUTSTATEPROTOERROR = 19,
	LINUX_MIB_XFRMOUTSTATEMODEERROR = 20,
	LINUX_MIB_XFRMOUTSTATESEQERROR = 21,
	LINUX_MIB_XFRMOUTSTATEEXPIRED = 22,
	LINUX_MIB_XFRMOUTPOLBLOCK = 23,
	LINUX_MIB_XFRMOUTPOLDEAD = 24,
	LINUX_MIB_XFRMOUTPOLERROR = 25,
	LINUX_MIB_XFRMFWDHDRERROR = 26,
	LINUX_MIB_XFRMOUTSTATEINVALID = 27,
	LINUX_MIB_XFRMACQUIREERROR = 28,
	LINUX_MIB_XFRMOUTSTATEDIRERROR = 29,
	LINUX_MIB_XFRMINSTATEDIRERROR = 30,
	__LINUX_MIB_XFRMMAX = 31,
};

enum {
	LINUX_RAID_PARTITION = 253,
};

enum {
	LOGIC_PIO_INDIRECT = 0,
	LOGIC_PIO_CPU_MMIO = 1,
};

enum {
	LSB = 0,
	CSB = 1,
	MSB = 2,
};

enum {
	LWTUNNEL_IP_OPTS_UNSPEC = 0,
	LWTUNNEL_IP_OPTS_GENEVE = 1,
	LWTUNNEL_IP_OPTS_VXLAN = 2,
	LWTUNNEL_IP_OPTS_ERSPAN = 3,
	__LWTUNNEL_IP_OPTS_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_ERSPAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_ERSPAN_VER = 1,
	LWTUNNEL_IP_OPT_ERSPAN_INDEX = 2,
	LWTUNNEL_IP_OPT_ERSPAN_DIR = 3,
	LWTUNNEL_IP_OPT_ERSPAN_HWID = 4,
	__LWTUNNEL_IP_OPT_ERSPAN_MAX = 5,
};

enum {
	LWTUNNEL_IP_OPT_GENEVE_UNSPEC = 0,
	LWTUNNEL_IP_OPT_GENEVE_CLASS = 1,
	LWTUNNEL_IP_OPT_GENEVE_TYPE = 2,
	LWTUNNEL_IP_OPT_GENEVE_DATA = 3,
	__LWTUNNEL_IP_OPT_GENEVE_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_VXLAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_VXLAN_GBP = 1,
	__LWTUNNEL_IP_OPT_VXLAN_MAX = 2,
};

enum {
	LWTUNNEL_XMIT_DONE = 0,
	LWTUNNEL_XMIT_CONTINUE = 256,
};

enum {
	LWT_BPF_PROG_UNSPEC = 0,
	LWT_BPF_PROG_FD = 1,
	LWT_BPF_PROG_NAME = 2,
	__LWT_BPF_PROG_MAX = 3,
};

enum {
	LWT_BPF_UNSPEC = 0,
	LWT_BPF_IN = 1,
	LWT_BPF_OUT = 2,
	LWT_BPF_XMIT = 3,
	LWT_BPF_XMIT_HEADROOM = 4,
	__LWT_BPF_MAX = 5,
};

enum {
	MAC_DIRECTION_RX = 1,
	MAC_DIRECTION_TX = 2,
	MAC_RXFIFO_SIZE = 32768,
};

enum {
	MASK_EE_STATUS = 65535,
	MASK_EE_DYNCAP_EVENT = 1,
	MASK_EE_SYSPOOL_EVENT = 2,
	MASK_EE_URGENT_BKOPS = 4,
	MASK_EE_TOO_HIGH_TEMP = 8,
	MASK_EE_TOO_LOW_TEMP = 16,
	MASK_EE_WRITEBOOSTER_EVENT = 32,
	MASK_EE_PERFORMANCE_THROTTLING = 64,
};

enum {
	MASK_EXT_IID_SUPPORT = 1024,
};

enum {
	MASK_OCS = 15,
};

enum {
	MASK_TM_SERVICE_RESP = 255,
};

enum {
	MASK_TRANSFER_REQUESTS_SLOTS = 31,
	MASK_TASK_MANAGEMENT_REQUEST_SLOTS = 458752,
	MASK_EHSLUTRD_SUPPORTED = 4194304,
	MASK_AUTO_HIBERN8_SUPPORT = 8388608,
	MASK_64_ADDRESSING_SUPPORT = 16777216,
	MASK_OUT_OF_ORDER_DATA_DELIVERY_SUPPORT = 33554432,
	MASK_UIC_DME_TEST_MODE_SUPPORT = 67108864,
	MASK_CRYPTO_SUPPORT = 268435456,
	MASK_MCQ_SUPPORT = 1073741824,
};

enum {
	MAX77620_IRQ_TOP_GLBL = 0,
	MAX77620_IRQ_TOP_SD = 1,
	MAX77620_IRQ_TOP_LDO = 2,
	MAX77620_IRQ_TOP_GPIO = 3,
	MAX77620_IRQ_TOP_RTC = 4,
	MAX77620_IRQ_TOP_32K = 5,
	MAX77620_IRQ_TOP_ONOFF = 6,
	MAX77620_IRQ_LBT_MBATLOW = 7,
	MAX77620_IRQ_LBT_TJALRM1 = 8,
	MAX77620_IRQ_LBT_TJALRM2 = 9,
};

enum {
	MAX8925_IRQ_VCHG_DC_OVP = 0,
	MAX8925_IRQ_VCHG_DC_F = 1,
	MAX8925_IRQ_VCHG_DC_R = 2,
	MAX8925_IRQ_VCHG_THM_OK_R = 3,
	MAX8925_IRQ_VCHG_THM_OK_F = 4,
	MAX8925_IRQ_VCHG_SYSLOW_F = 5,
	MAX8925_IRQ_VCHG_SYSLOW_R = 6,
	MAX8925_IRQ_VCHG_RST = 7,
	MAX8925_IRQ_VCHG_DONE = 8,
	MAX8925_IRQ_VCHG_TOPOFF = 9,
	MAX8925_IRQ_VCHG_TMR_FAULT = 10,
	MAX8925_IRQ_GPM_RSTIN = 11,
	MAX8925_IRQ_GPM_MPL = 12,
	MAX8925_IRQ_GPM_SW_3SEC = 13,
	MAX8925_IRQ_GPM_EXTON_F = 14,
	MAX8925_IRQ_GPM_EXTON_R = 15,
	MAX8925_IRQ_GPM_SW_1SEC = 16,
	MAX8925_IRQ_GPM_SW_F = 17,
	MAX8925_IRQ_GPM_SW_R = 18,
	MAX8925_IRQ_GPM_SYSCKEN_F = 19,
	MAX8925_IRQ_GPM_SYSCKEN_R = 20,
	MAX8925_IRQ_RTC_ALARM1 = 21,
	MAX8925_IRQ_RTC_ALARM0 = 22,
	MAX8925_IRQ_TSC_STICK = 23,
	MAX8925_IRQ_TSC_NSTICK = 24,
	MAX8925_NR_IRQS = 25,
};

enum {
	MAX8998_IRQ_DCINF = 0,
	MAX8998_IRQ_DCINR = 1,
	MAX8998_IRQ_JIGF = 2,
	MAX8998_IRQ_JIGR = 3,
	MAX8998_IRQ_PWRONF = 4,
	MAX8998_IRQ_PWRONR = 5,
	MAX8998_IRQ_WTSREVNT = 6,
	MAX8998_IRQ_SMPLEVNT = 7,
	MAX8998_IRQ_ALARM1 = 8,
	MAX8998_IRQ_ALARM0 = 9,
	MAX8998_IRQ_ONKEY1S = 10,
	MAX8998_IRQ_TOPOFFR = 11,
	MAX8998_IRQ_DCINOVPR = 12,
	MAX8998_IRQ_CHGRSTF = 13,
	MAX8998_IRQ_DONER = 14,
	MAX8998_IRQ_CHGFAULT = 15,
	MAX8998_IRQ_LOBAT1 = 16,
	MAX8998_IRQ_LOBAT2 = 17,
	MAX8998_IRQ_NR = 18,
};

enum {
	MAX8998_REG_IRQ1 = 0,
	MAX8998_REG_IRQ2 = 1,
	MAX8998_REG_IRQ3 = 2,
	MAX8998_REG_IRQ4 = 3,
	MAX8998_REG_IRQM1 = 4,
	MAX8998_REG_IRQM2 = 5,
	MAX8998_REG_IRQM3 = 6,
	MAX8998_REG_IRQM4 = 7,
	MAX8998_REG_STATUS1 = 8,
	MAX8998_REG_STATUS2 = 9,
	MAX8998_REG_STATUSM1 = 10,
	MAX8998_REG_STATUSM2 = 11,
	MAX8998_REG_CHGR1 = 12,
	MAX8998_REG_CHGR2 = 13,
	MAX8998_REG_LDO_ACTIVE_DISCHARGE1 = 14,
	MAX8998_REG_LDO_ACTIVE_DISCHARGE2 = 15,
	MAX8998_REG_BUCK_ACTIVE_DISCHARGE3 = 16,
	MAX8998_REG_ONOFF1 = 17,
	MAX8998_REG_ONOFF2 = 18,
	MAX8998_REG_ONOFF3 = 19,
	MAX8998_REG_ONOFF4 = 20,
	MAX8998_REG_BUCK1_VOLTAGE1 = 21,
	MAX8998_REG_BUCK1_VOLTAGE2 = 22,
	MAX8998_REG_BUCK1_VOLTAGE3 = 23,
	MAX8998_REG_BUCK1_VOLTAGE4 = 24,
	MAX8998_REG_BUCK2_VOLTAGE1 = 25,
	MAX8998_REG_BUCK2_VOLTAGE2 = 26,
	MAX8998_REG_BUCK3 = 27,
	MAX8998_REG_BUCK4 = 28,
	MAX8998_REG_LDO2_LDO3 = 29,
	MAX8998_REG_LDO4 = 30,
	MAX8998_REG_LDO5 = 31,
	MAX8998_REG_LDO6 = 32,
	MAX8998_REG_LDO7 = 33,
	MAX8998_REG_LDO8_LDO9 = 34,
	MAX8998_REG_LDO10_LDO11 = 35,
	MAX8998_REG_LDO12 = 36,
	MAX8998_REG_LDO13 = 37,
	MAX8998_REG_LDO14 = 38,
	MAX8998_REG_LDO15 = 39,
	MAX8998_REG_LDO16 = 40,
	MAX8998_REG_LDO17 = 41,
	MAX8998_REG_BKCHR = 42,
	MAX8998_REG_LBCNFG1 = 43,
	MAX8998_REG_LBCNFG2 = 44,
};

enum {
	MAX_ETH_QSETS = 32,
	MAX_OFLD_QSETS = 16,
	MAX_CTRL_QUEUES = 4,
};

enum {
	MAX_IORES_LEVEL = 5,
};

enum {
	MAX_NPORTS = 2,
	MAX_FRAME_SIZE = 10240,
	EEPROMSIZE = 8192,
	SERNUM_LEN = 16,
	RSS_TABLE_SIZE = 64,
	TCB_SIZE = 128,
	NMTUS = 16,
	NCCTRL_WIN = 32,
	PROTO_SRAM_LINES = 128,
};

enum {
	MAX_NPORTS___2 = 4,
	SERNUM_LEN___2 = 24,
	ID_LEN = 16,
	PN_LEN = 16,
	MACADDR_LEN = 12,
};

enum {
	MAX_OPT_ARGS = 3,
};

enum {
	MAX_TXQ_ENTRIES = 16384,
	MAX_CTRL_TXQ_ENTRIES = 1024,
	MAX_RSPQ_ENTRIES = 16384,
	MAX_RX_BUFFERS = 16384,
	MAX_RX_JUMBO_BUFFERS = 16384,
	MIN_TXQ_ENTRIES = 4,
	MIN_CTRL_TXQ_ENTRIES = 4,
	MIN_RSPQ_ENTRIES = 32,
	MIN_FL_ENTRIES = 32,
};

enum {
	MBE_REFERENCED_B = 0,
	MBE_REUSABLE_B = 1,
};

enum {
	MB_INODE_PA = 0,
	MB_GROUP_PA = 1,
};

enum {
	MC5_MIN_TIDS = 16,
};

enum {
	MC5_MODE_144_BIT = 1,
	MC5_MODE_72_BIT = 2,
};

enum {
	MCTP_TRACE_KEY_TIMEOUT = 0,
	MCTP_TRACE_KEY_REPLIED = 1,
	MCTP_TRACE_KEY_INVALIDATED = 2,
	MCTP_TRACE_KEY_CLOSED = 3,
	MCTP_TRACE_KEY_DROPPED = 4,
};

enum {
	MDBA_GET_ENTRY_UNSPEC = 0,
	MDBA_GET_ENTRY = 1,
	MDBA_GET_ENTRY_ATTRS = 2,
	__MDBA_GET_ENTRY_MAX = 3,
};

enum {
	MDBA_SET_ENTRY_UNSPEC = 0,
	MDBA_SET_ENTRY = 1,
	MDBA_SET_ENTRY_ATTRS = 2,
	__MDBA_SET_ENTRY_MAX = 3,
};

enum {
	MEGASAS_HBA_OPERATIONAL = 0,
	MEGASAS_ADPRESET_SM_INFAULT = 1,
	MEGASAS_ADPRESET_SM_FW_RESET_SUCCESS = 2,
	MEGASAS_ADPRESET_SM_OPERATIONAL = 3,
	MEGASAS_HW_CRITICAL_ERROR = 4,
	MEGASAS_ADPRESET_SM_POLLING = 5,
	MEGASAS_ADPRESET_INPROG_SIGN = 3735936685,
};

enum {
	MEMBARRIER_FLAG_SYNC_CORE = 1,
	MEMBARRIER_FLAG_RSEQ = 2,
};

enum {
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_READY = 1,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED = 2,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED_READY = 4,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED = 8,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE_READY = 16,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ_READY = 64,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ = 128,
};

enum {
	MEMMAP_ON_MEMORY_DISABLE = 0,
	MEMMAP_ON_MEMORY_ENABLE = 1,
	MEMMAP_ON_MEMORY_FORCE = 2,
};

enum {
	MEMORY_HOTPLUG_MIN_BOOTMEM_TYPE = 12,
	SECTION_INFO = 12,
	MIX_SECTION_INFO = 13,
	NODE_INFO = 14,
	MEMORY_HOTPLUG_MAX_BOOTMEM_TYPE = 14,
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

enum {
	MEMWIN_APERTURE = 2048,
	MEMWIN_BASE = 112640,
};

enum {
	MEM_CM = 0,
	MEM_PMRX = 1,
	MEM_PMTX = 2,
};

enum {
	MEM_EDC0 = 0,
	MEM_EDC1 = 1,
	MEM_MC = 2,
	MEM_MC0 = 2,
	MEM_MC1 = 3,
};

enum {
	MEM_LOADS = 228505944544ULL,
};

enum {
	MEM_STORES = 228640162272ULL,
};

enum {
	MFC_STATIC = 1,
	MFC_OFFLOAD = 2,
};

enum {
	MILLION = 1000000,
	MIN_PERIOD = 1000,
	MAX_PERIOD = 1000000,
	MARGIN_MIN_PCT = 10,
	MARGIN_LOW_PCT = 20,
	MARGIN_TARGET_PCT = 50,
	INUSE_ADJ_STEP_PCT = 25,
	TIMER_SLACK_PCT = 1,
	WEIGHT_ONE = 65536,
};

enum {
	MIPI_DCS_NOP = 0,
	MIPI_DCS_SOFT_RESET = 1,
	MIPI_DCS_GET_COMPRESSION_MODE = 3,
	MIPI_DCS_GET_DISPLAY_ID = 4,
	MIPI_DCS_GET_ERROR_COUNT_ON_DSI = 5,
	MIPI_DCS_GET_RED_CHANNEL = 6,
	MIPI_DCS_GET_GREEN_CHANNEL = 7,
	MIPI_DCS_GET_BLUE_CHANNEL = 8,
	MIPI_DCS_GET_DISPLAY_STATUS = 9,
	MIPI_DCS_GET_POWER_MODE = 10,
	MIPI_DCS_GET_ADDRESS_MODE = 11,
	MIPI_DCS_GET_PIXEL_FORMAT = 12,
	MIPI_DCS_GET_DISPLAY_MODE = 13,
	MIPI_DCS_GET_SIGNAL_MODE = 14,
	MIPI_DCS_GET_DIAGNOSTIC_RESULT = 15,
	MIPI_DCS_ENTER_SLEEP_MODE = 16,
	MIPI_DCS_EXIT_SLEEP_MODE = 17,
	MIPI_DCS_ENTER_PARTIAL_MODE = 18,
	MIPI_DCS_ENTER_NORMAL_MODE = 19,
	MIPI_DCS_GET_IMAGE_CHECKSUM_RGB = 20,
	MIPI_DCS_GET_IMAGE_CHECKSUM_CT = 21,
	MIPI_DCS_EXIT_INVERT_MODE = 32,
	MIPI_DCS_ENTER_INVERT_MODE = 33,
	MIPI_DCS_SET_GAMMA_CURVE = 38,
	MIPI_DCS_SET_DISPLAY_OFF = 40,
	MIPI_DCS_SET_DISPLAY_ON = 41,
	MIPI_DCS_SET_COLUMN_ADDRESS = 42,
	MIPI_DCS_SET_PAGE_ADDRESS = 43,
	MIPI_DCS_WRITE_MEMORY_START = 44,
	MIPI_DCS_WRITE_LUT = 45,
	MIPI_DCS_READ_MEMORY_START = 46,
	MIPI_DCS_SET_PARTIAL_ROWS = 48,
	MIPI_DCS_SET_PARTIAL_COLUMNS = 49,
	MIPI_DCS_SET_SCROLL_AREA = 51,
	MIPI_DCS_SET_TEAR_OFF = 52,
	MIPI_DCS_SET_TEAR_ON = 53,
	MIPI_DCS_SET_ADDRESS_MODE = 54,
	MIPI_DCS_SET_SCROLL_START = 55,
	MIPI_DCS_EXIT_IDLE_MODE = 56,
	MIPI_DCS_ENTER_IDLE_MODE = 57,
	MIPI_DCS_SET_PIXEL_FORMAT = 58,
	MIPI_DCS_WRITE_MEMORY_CONTINUE = 60,
	MIPI_DCS_SET_3D_CONTROL = 61,
	MIPI_DCS_READ_MEMORY_CONTINUE = 62,
	MIPI_DCS_GET_3D_CONTROL = 63,
	MIPI_DCS_SET_VSYNC_TIMING = 64,
	MIPI_DCS_SET_TEAR_SCANLINE = 68,
	MIPI_DCS_GET_SCANLINE = 69,
	MIPI_DCS_SET_DISPLAY_BRIGHTNESS = 81,
	MIPI_DCS_GET_DISPLAY_BRIGHTNESS = 82,
	MIPI_DCS_WRITE_CONTROL_DISPLAY = 83,
	MIPI_DCS_GET_CONTROL_DISPLAY = 84,
	MIPI_DCS_WRITE_POWER_SAVE = 85,
	MIPI_DCS_GET_POWER_SAVE = 86,
	MIPI_DCS_SET_CABC_MIN_BRIGHTNESS = 94,
	MIPI_DCS_GET_CABC_MIN_BRIGHTNESS = 95,
	MIPI_DCS_READ_DDB_START = 161,
	MIPI_DCS_READ_PPS_START = 162,
	MIPI_DCS_READ_DDB_CONTINUE = 168,
	MIPI_DCS_READ_PPS_CONTINUE = 169,
};

enum {
	MIPI_DSI_V_SYNC_START = 1,
	MIPI_DSI_V_SYNC_END = 17,
	MIPI_DSI_H_SYNC_START = 33,
	MIPI_DSI_H_SYNC_END = 49,
	MIPI_DSI_COMPRESSION_MODE = 7,
	MIPI_DSI_END_OF_TRANSMISSION = 8,
	MIPI_DSI_COLOR_MODE_OFF = 2,
	MIPI_DSI_COLOR_MODE_ON = 18,
	MIPI_DSI_SHUTDOWN_PERIPHERAL = 34,
	MIPI_DSI_TURN_ON_PERIPHERAL = 50,
	MIPI_DSI_GENERIC_SHORT_WRITE_0_PARAM = 3,
	MIPI_DSI_GENERIC_SHORT_WRITE_1_PARAM = 19,
	MIPI_DSI_GENERIC_SHORT_WRITE_2_PARAM = 35,
	MIPI_DSI_GENERIC_READ_REQUEST_0_PARAM = 4,
	MIPI_DSI_GENERIC_READ_REQUEST_1_PARAM = 20,
	MIPI_DSI_GENERIC_READ_REQUEST_2_PARAM = 36,
	MIPI_DSI_DCS_SHORT_WRITE = 5,
	MIPI_DSI_DCS_SHORT_WRITE_PARAM = 21,
	MIPI_DSI_DCS_READ = 6,
	MIPI_DSI_EXECUTE_QUEUE = 22,
	MIPI_DSI_SET_MAXIMUM_RETURN_PACKET_SIZE = 55,
	MIPI_DSI_NULL_PACKET = 9,
	MIPI_DSI_BLANKING_PACKET = 25,
	MIPI_DSI_GENERIC_LONG_WRITE = 41,
	MIPI_DSI_DCS_LONG_WRITE = 57,
	MIPI_DSI_PICTURE_PARAMETER_SET = 10,
	MIPI_DSI_COMPRESSED_PIXEL_STREAM = 11,
	MIPI_DSI_LOOSELY_PACKED_PIXEL_STREAM_YCBCR20 = 12,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR24 = 28,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR16 = 44,
	MIPI_DSI_PACKED_PIXEL_STREAM_30 = 13,
	MIPI_DSI_PACKED_PIXEL_STREAM_36 = 29,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR12 = 61,
	MIPI_DSI_PACKED_PIXEL_STREAM_16 = 14,
	MIPI_DSI_PACKED_PIXEL_STREAM_18 = 30,
	MIPI_DSI_PIXEL_STREAM_3BYTE_18 = 46,
	MIPI_DSI_PACKED_PIXEL_STREAM_24 = 62,
};

enum {
	MIX_INFLIGHT = 2147483648,
};

enum {
	MLX_MC_RBT_SUPPORT = 1,
	MLX_MC_RBT_AVL = 8,
};

enum {
	MMIO_BAR_PCI = 5,
	MMIO_BAR_CARDBUS = 1,
	NR_PORTS = 2,
	IDMA_CPB_TBL_SIZE = 128,
	INIC_DMA_BOUNDARY = 16777215,
	HOST_ACTRL = 8,
	HOST_CTL___2 = 124,
	HOST_STAT = 126,
	HOST_IRQ_STAT___2 = 188,
	HOST_IRQ_MASK = 190,
	PORT_SIZE = 64,
	PORT_TF_DATA = 0,
	PORT_TF_FEATURE = 1,
	PORT_TF_NSECT = 2,
	PORT_TF_LBAL = 3,
	PORT_TF_LBAM = 4,
	PORT_TF_LBAH = 5,
	PORT_TF_DEVICE = 6,
	PORT_TF_COMMAND = 7,
	PORT_TF_ALT_STAT = 8,
	PORT_IRQ_STAT___2 = 9,
	PORT_IRQ_MASK___2 = 10,
	PORT_PRD_CTL = 11,
	PORT_PRD_ADDR = 12,
	PORT_PRD_XFERLEN = 16,
	PORT_CPB_CPBLAR = 24,
	PORT_CPB_PTQFIFO = 28,
	PORT_IDMA_CTL = 20,
	PORT_IDMA_STAT = 22,
	PORT_RPQ_FIFO = 30,
	PORT_RPQ_CNT = 31,
	PORT_SCR = 32,
	HCTL_LEDEN = 8,
	HCTL_IRQOFF = 256,
	HCTL_FTHD0 = 1024,
	HCTL_FTHD1 = 2048,
	HCTL_PWRDWN = 4096,
	HCTL_SOFTRST = 8192,
	HCTL_RPGSEL = 32768,
	HCTL_KNOWN_BITS = 45312,
	HIRQ_PORT0 = 1,
	HIRQ_PORT1 = 2,
	HIRQ_SOFT = 16384,
	HIRQ_GLOBAL = 32768,
	PIRQ_OFFLINE = 1,
	PIRQ_ONLINE = 2,
	PIRQ_COMPLETE = 4,
	PIRQ_FATAL = 8,
	PIRQ_ATA = 16,
	PIRQ_REPLY = 32,
	PIRQ_PENDING = 128,
	PIRQ_ERR = 11,
	PIRQ_MASK_DEFAULT = 48,
	PIRQ_MASK_FREEZE = 255,
	PRD_CTL_START = 1,
	PRD_CTL_WR = 8,
	PRD_CTL_DMAEN = 128,
	IDMA_CTL_RST_ATA = 4,
	IDMA_CTL_RST_IDMA = 32,
	IDMA_CTL_GO = 128,
	IDMA_CTL_ATA_NIEN = 256,
	IDMA_STAT_PERR = 1,
	IDMA_STAT_CPBERR = 2,
	IDMA_STAT_LGCY = 8,
	IDMA_STAT_UIRQ = 16,
	IDMA_STAT_STPD = 32,
	IDMA_STAT_PSD = 64,
	IDMA_STAT_DONE = 128,
	IDMA_STAT_ERR = 3,
	CPB_CTL_VALID = 1,
	CPB_CTL_QUEUED = 2,
	CPB_CTL_DATA = 4,
	CPB_CTL_IEN = 8,
	CPB_CTL_DEVDIR = 16,
	CPB_RESP_DONE = 1,
	CPB_RESP_REL = 2,
	CPB_RESP_IGNORED = 4,
	CPB_RESP_ATA_ERR = 8,
	CPB_RESP_SPURIOUS = 16,
	CPB_RESP_UNDERFLOW = 32,
	CPB_RESP_OVERFLOW = 64,
	CPB_RESP_CPB_ERR = 128,
	PRD_DRAIN = 2,
	PRD_CDB = 4,
	PRD_DIRECT_INTR = 8,
	PRD_DMA = 16,
	PRD_WRITE = 32,
	PRD_IOM = 64,
	PRD_END = 128,
};

enum {
	MMOP_OFFLINE = 0,
	MMOP_ONLINE = 1,
	MMOP_ONLINE_KERNEL = 2,
	MMOP_ONLINE_MOVABLE = 3,
};

enum {
	MMU_FTRS_POSSIBLE = 4261477953,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum {
	MODULE_DEV_ADDR = 160,
	SFF_DEV_ADDR = 162,
};

enum {
	MOXA_SUPP_RS232 = 1,
	MOXA_SUPP_RS422 = 2,
	MOXA_SUPP_RS485 = 4,
};

enum {
	MPOL_DEFAULT = 0,
	MPOL_PREFERRED = 1,
	MPOL_BIND = 2,
	MPOL_INTERLEAVE = 3,
	MPOL_LOCAL = 4,
	MPOL_PREFERRED_MANY = 5,
	MPOL_WEIGHTED_INTERLEAVE = 6,
	MPOL_MAX = 7,
};

enum {
	MPTCP_CMSG_TS = 1,
	MPTCP_CMSG_INQ = 2,
};

enum {
	MPTCP_PM_ADDR_ATTR_UNSPEC = 0,
	MPTCP_PM_ADDR_ATTR_FAMILY = 1,
	MPTCP_PM_ADDR_ATTR_ID = 2,
	MPTCP_PM_ADDR_ATTR_ADDR4 = 3,
	MPTCP_PM_ADDR_ATTR_ADDR6 = 4,
	MPTCP_PM_ADDR_ATTR_PORT = 5,
	MPTCP_PM_ADDR_ATTR_FLAGS = 6,
	MPTCP_PM_ADDR_ATTR_IF_IDX = 7,
	__MPTCP_PM_ADDR_ATTR_MAX = 8,
};

enum {
	MPTCP_PM_ATTR_UNSPEC = 0,
	MPTCP_PM_ATTR_ADDR = 1,
	MPTCP_PM_ATTR_RCV_ADD_ADDRS = 2,
	MPTCP_PM_ATTR_SUBFLOWS = 3,
	MPTCP_PM_ATTR_TOKEN = 4,
	MPTCP_PM_ATTR_LOC_ID = 5,
	MPTCP_PM_ATTR_ADDR_REMOTE = 6,
	__MPTCP_ATTR_AFTER_LAST = 7,
};

enum {
	MPTCP_PM_CMD_UNSPEC = 0,
	MPTCP_PM_CMD_ADD_ADDR = 1,
	MPTCP_PM_CMD_DEL_ADDR = 2,
	MPTCP_PM_CMD_GET_ADDR = 3,
	MPTCP_PM_CMD_FLUSH_ADDRS = 4,
	MPTCP_PM_CMD_SET_LIMITS = 5,
	MPTCP_PM_CMD_GET_LIMITS = 6,
	MPTCP_PM_CMD_SET_FLAGS = 7,
	MPTCP_PM_CMD_ANNOUNCE = 8,
	MPTCP_PM_CMD_REMOVE = 9,
	MPTCP_PM_CMD_SUBFLOW_CREATE = 10,
	MPTCP_PM_CMD_SUBFLOW_DESTROY = 11,
	__MPTCP_PM_CMD_AFTER_LAST = 12,
};

enum {
	MPTCP_PM_ENDPOINT_ADDR = 1,
	__MPTCP_PM_ENDPOINT_MAX = 2,
};

enum {
	MPTCP_SUBFLOW_ATTR_UNSPEC = 0,
	MPTCP_SUBFLOW_ATTR_TOKEN_REM = 1,
	MPTCP_SUBFLOW_ATTR_TOKEN_LOC = 2,
	MPTCP_SUBFLOW_ATTR_RELWRITE_SEQ = 3,
	MPTCP_SUBFLOW_ATTR_MAP_SEQ = 4,
	MPTCP_SUBFLOW_ATTR_MAP_SFSEQ = 5,
	MPTCP_SUBFLOW_ATTR_SSN_OFFSET = 6,
	MPTCP_SUBFLOW_ATTR_MAP_DATALEN = 7,
	MPTCP_SUBFLOW_ATTR_FLAGS = 8,
	MPTCP_SUBFLOW_ATTR_ID_REM = 9,
	MPTCP_SUBFLOW_ATTR_ID_LOC = 10,
	MPTCP_SUBFLOW_ATTR_PAD = 11,
	__MPTCP_SUBFLOW_ATTR_MAX = 12,
};

enum {
	MSGLOOP_IN_PROG = 0,
	MSGLOOP_MSGCOMPLETE = 1,
	MSGLOOP_TERMINATED = 2,
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_FLAG_USE_DEV_FWNODE = 128,
	MSI_FLAG_PARENT_PM_DEV = 256,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
};

enum {
	MV_DMA_BOUNDARY = 65535,
	EDMA_REQ_Q_BASE_LO_MASK = 4294966272,
	EDMA_RSP_Q_BASE_LO_MASK = 4294967040,
};

enum {
	MV_PRIMARY_BAR = 0,
	MV_IO_BAR = 2,
	MV_MISC_BAR = 3,
	MV_MAJOR_REG_AREA_SZ = 65536,
	MV_MINOR_REG_AREA_SZ = 8192,
	COAL_CLOCKS_PER_USEC = 150,
	MAX_COAL_TIME_THRESHOLD = 16777215,
	MAX_COAL_IO_COUNT = 255,
	MV_PCI_REG_BASE = 0,
	COAL_REG_BASE = 98304,
	IRQ_COAL_CAUSE = 98312,
	ALL_PORTS_COAL_IRQ = 16,
	IRQ_COAL_IO_THRESHOLD = 98508,
	IRQ_COAL_TIME_THRESHOLD = 98512,
	TRAN_COAL_CAUSE_LO = 98440,
	TRAN_COAL_CAUSE_HI = 98444,
	SATAHC0_REG_BASE = 131072,
	FLASH_CTL = 66668,
	GPIO_PORT_CTL = 66800,
	RESET_CFG = 98520,
	MV_PCI_REG_SZ = 65536,
	MV_SATAHC_REG_SZ = 65536,
	MV_SATAHC_ARBTR_REG_SZ = 8192,
	MV_PORT_REG_SZ = 8192,
	MV_MAX_Q_DEPTH = 32,
	MV_MAX_Q_DEPTH_MASK = 31,
	MV_CRQB_Q_SZ = 1024,
	MV_CRPB_Q_SZ = 256,
	MV_MAX_SG_CT = 256,
	MV_SG_TBL_SZ = 4096,
	MV_PORT_HC_SHIFT = 2,
	MV_PORTS_PER_HC = 4,
	MV_PORT_MASK = 3,
	MV_FLAG_DUAL_HC = 1073741824,
	MV_COMMON_FLAGS = 514,
	MV_GEN_I_FLAGS = 578,
	MV_GEN_II_FLAGS = 656898,
	MV_GEN_IIE_FLAGS = 919042,
	CRQB_FLAG_READ = 1,
	CRQB_TAG_SHIFT = 1,
	CRQB_IOID_SHIFT = 6,
	CRQB_PMP_SHIFT = 12,
	CRQB_HOSTQ_SHIFT = 17,
	CRQB_CMD_ADDR_SHIFT = 8,
	CRQB_CMD_CS = 4096,
	CRQB_CMD_LAST = 32768,
	CRPB_FLAG_STATUS_SHIFT = 8,
	CRPB_IOID_SHIFT_6 = 5,
	CRPB_IOID_SHIFT_7 = 7,
	EPRD_FLAG_END_OF_TBL = -2147483648,
	MV_PCI_COMMAND = 3072,
	MV_PCI_COMMAND_MWRCOM = 16,
	MV_PCI_COMMAND_MRDTRIG = 128,
	PCI_MAIN_CMD_STS = 3376,
	STOP_PCI_MASTER = 4,
	PCI_MASTER_EMPTY = 8,
	GLOB_SFT_RST = 16,
	MV_PCI_MODE = 3328,
	MV_PCI_MODE_MASK = 48,
	MV_PCI_EXP_ROM_BAR_CTL = 3372,
	MV_PCI_DISC_TIMER = 3332,
	MV_PCI_MSI_TRIGGER = 3128,
	MV_PCI_SERR_MASK = 3112,
	MV_PCI_XBAR_TMOUT = 7428,
	MV_PCI_ERR_LOW_ADDRESS = 7488,
	MV_PCI_ERR_HIGH_ADDRESS = 7492,
	MV_PCI_ERR_ATTRIBUTE = 7496,
	MV_PCI_ERR_COMMAND = 7504,
	PCI_IRQ_CAUSE = 7512,
	PCI_IRQ_MASK = 7516,
	PCI_UNMASK_ALL_IRQS = 8388607,
	PCIE_IRQ_CAUSE = 6400,
	PCIE_IRQ_MASK = 6416,
	PCIE_UNMASK_ALL_IRQS = 1034,
	PCI_HC_MAIN_IRQ_CAUSE = 7520,
	PCI_HC_MAIN_IRQ_MASK = 7524,
	SOC_HC_MAIN_IRQ_CAUSE = 131104,
	SOC_HC_MAIN_IRQ_MASK = 131108,
	ERR_IRQ = 1,
	DONE_IRQ = 2,
	HC0_IRQ_PEND = 511,
	HC_SHIFT = 9,
	DONE_IRQ_0_3 = 170,
	DONE_IRQ_4_7 = 87040,
	PCI_ERR = 262144,
	TRAN_COAL_LO_DONE = 524288,
	TRAN_COAL_HI_DONE = 1048576,
	PORTS_0_3_COAL_DONE = 256,
	PORTS_4_7_COAL_DONE = 131072,
	ALL_PORTS_COAL_DONE = 2097152,
	GPIO_INT = 4194304,
	SELF_INT = 8388608,
	TWSI_INT = 16777216,
	HC_MAIN_RSVD = -33554432,
	HC_MAIN_RSVD_5 = -524288,
	HC_MAIN_RSVD_SOC = -320,
	HC_CFG = 0,
	HC_IRQ_CAUSE = 20,
	DMA_IRQ = 1,
	HC_COAL_IRQ = 16,
	DEV_IRQ = 256,
	HC_IRQ_COAL_IO_THRESHOLD = 12,
	HC_IRQ_COAL_TIME_THRESHOLD = 16,
	SOC_LED_CTRL = 44,
	SOC_LED_CTRL_BLINK = 1,
	SOC_LED_CTRL_ACT_PRESENCE = 4,
	SHD_BLK = 256,
	SHD_CTL_AST = 32,
	SATA_STATUS = 768,
	SATA_ACTIVE = 848,
	FIS_IRQ_CAUSE = 868,
	FIS_IRQ_CAUSE_AN = 512,
	LTMODE = 780,
	LTMODE_BIT8 = 256,
	PHY_MODE2 = 816,
	PHY_MODE3 = 784,
	PHY_MODE4 = 788,
	PHY_MODE4_CFG_MASK = 3,
	PHY_MODE4_CFG_VALUE = 1,
	PHY_MODE4_RSVD_ZEROS = 1575223290,
	PHY_MODE4_RSVD_ONES = 5,
	SATA_IFCTL = 836,
	SATA_TESTCTL = 840,
	SATA_IFSTAT = 844,
	VENDOR_UNIQUE_FIS = 860,
	FISCFG = 864,
	FISCFG_WAIT_DEV_ERR = 256,
	FISCFG_SINGLE_SYNC = 65536,
	PHY_MODE9_GEN2 = 920,
	PHY_MODE9_GEN1 = 924,
	PHYCFG_OFS = 928,
	MV5_PHY_MODE = 116,
	MV5_LTMODE = 48,
	MV5_PHY_CTL = 12,
	SATA_IFCFG = 80,
	LP_PHY_CTL = 88,
	LP_PHY_CTL_PIN_PU_PLL = 1,
	LP_PHY_CTL_PIN_PU_RX = 2,
	LP_PHY_CTL_PIN_PU_TX = 4,
	LP_PHY_CTL_GEN_TX_3G = 32,
	LP_PHY_CTL_GEN_RX_3G = 512,
	MV_M2_PREAMP_MASK = 2016,
	EDMA_CFG = 0,
	EDMA_CFG_Q_DEPTH = 31,
	EDMA_CFG_NCQ = 32,
	EDMA_CFG_NCQ_GO_ON_ERR = 16384,
	EDMA_CFG_RD_BRST_EXT = 2048,
	EDMA_CFG_WR_BUFF_LEN = 8192,
	EDMA_CFG_EDMA_FBS = 65536,
	EDMA_CFG_FBS = 67108864,
	EDMA_ERR_IRQ_CAUSE = 8,
	EDMA_ERR_IRQ_MASK = 12,
	EDMA_ERR_D_PAR = 1,
	EDMA_ERR_PRD_PAR = 2,
	EDMA_ERR_DEV = 4,
	EDMA_ERR_DEV_DCON = 8,
	EDMA_ERR_DEV_CON = 16,
	EDMA_ERR_SERR = 32,
	EDMA_ERR_SELF_DIS = 128,
	EDMA_ERR_SELF_DIS_5 = 256,
	EDMA_ERR_BIST_ASYNC = 256,
	EDMA_ERR_TRANS_IRQ_7 = 256,
	EDMA_ERR_CRQB_PAR = 512,
	EDMA_ERR_CRPB_PAR = 1024,
	EDMA_ERR_INTRL_PAR = 2048,
	EDMA_ERR_IORDY = 4096,
	EDMA_ERR_LNK_CTRL_RX = 122880,
	EDMA_ERR_LNK_CTRL_RX_0 = 8192,
	EDMA_ERR_LNK_CTRL_RX_1 = 16384,
	EDMA_ERR_LNK_CTRL_RX_2 = 32768,
	EDMA_ERR_LNK_CTRL_RX_3 = 65536,
	EDMA_ERR_LNK_DATA_RX = 1966080,
	EDMA_ERR_LNK_CTRL_TX = 65011712,
	EDMA_ERR_LNK_CTRL_TX_0 = 2097152,
	EDMA_ERR_LNK_CTRL_TX_1 = 4194304,
	EDMA_ERR_LNK_CTRL_TX_2 = 8388608,
	EDMA_ERR_LNK_CTRL_TX_3 = 16777216,
	EDMA_ERR_LNK_CTRL_TX_4 = 33554432,
	EDMA_ERR_LNK_DATA_TX = 2080374784,
	EDMA_ERR_TRANS_PROTO = -2147483648,
	EDMA_ERR_OVERRUN_5 = 32,
	EDMA_ERR_UNDERRUN_5 = 64,
	EDMA_ERR_IRQ_TRANSIENT = 65101824,
	EDMA_EH_FREEZE = -65102149,
	EDMA_EH_FREEZE_5 = 8059,
	EDMA_REQ_Q_BASE_HI = 16,
	EDMA_REQ_Q_IN_PTR = 20,
	EDMA_REQ_Q_OUT_PTR = 24,
	EDMA_REQ_Q_PTR_SHIFT = 5,
	EDMA_RSP_Q_BASE_HI = 28,
	EDMA_RSP_Q_IN_PTR = 32,
	EDMA_RSP_Q_OUT_PTR = 36,
	EDMA_RSP_Q_PTR_SHIFT = 3,
	EDMA_CMD = 40,
	EDMA_EN = 1,
	EDMA_DS = 2,
	EDMA_RESET = 4,
	EDMA_STATUS = 48,
	EDMA_STATUS_CACHE_EMPTY = 64,
	EDMA_STATUS_IDLE = 128,
	EDMA_IORDY_TMOUT = 52,
	EDMA_ARB_CFG = 56,
	EDMA_HALTCOND = 96,
	EDMA_UNKNOWN_RSVD = 108,
	BMDMA_CMD = 548,
	BMDMA_STATUS = 552,
	BMDMA_PRD_LOW = 556,
	BMDMA_PRD_HIGH = 560,
	MV_HP_FLAG_MSI = 1,
	MV_HP_ERRATA_50XXB0 = 2,
	MV_HP_ERRATA_50XXB2 = 4,
	MV_HP_ERRATA_60X1B2 = 8,
	MV_HP_ERRATA_60X1C0 = 16,
	MV_HP_GEN_I = 64,
	MV_HP_GEN_II = 128,
	MV_HP_GEN_IIE = 256,
	MV_HP_PCIE = 512,
	MV_HP_CUT_THROUGH = 1024,
	MV_HP_FLAG_SOC = 2048,
	MV_HP_QUIRK_LED_BLINK_EN = 4096,
	MV_HP_FIX_LP_PHY_CTL = 8192,
	MV_PP_FLAG_EDMA_EN = 1,
	MV_PP_FLAG_NCQ_EN = 2,
	MV_PP_FLAG_FBS_EN = 4,
	MV_PP_FLAG_DELAYED_EH = 8,
	MV_PP_FLAG_FAKE_ATA_BUSY = 16,
};

enum {
	NAPIF_STATE_SCHED = 1,
	NAPIF_STATE_MISSED = 2,
	NAPIF_STATE_DISABLE = 4,
	NAPIF_STATE_NPSVC = 8,
	NAPIF_STATE_LISTED = 16,
	NAPIF_STATE_NO_BUSY_POLL = 32,
	NAPIF_STATE_IN_BUSY_POLL = 64,
	NAPIF_STATE_PREFER_BUSY_POLL = 128,
	NAPIF_STATE_THREADED = 256,
	NAPIF_STATE_SCHED_THREADED = 512,
};

enum {
	NAPI_F_PREFER_BUSY_POLL = 1,
	NAPI_F_END_ON_RESCHED = 2,
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
};

enum {
	NCHAN = 4,
	MAX_MTU = 9600,
	EEPROMSIZE___2 = 17408,
	EEPROMVSIZE = 32768,
	EEPROMPFSIZE = 1024,
	RSS_NENTRIES = 2048,
	T6_RSS_NENTRIES = 4096,
	TCB_SIZE___2 = 128,
	NMTUS___2 = 16,
	NCCTRL_WIN___2 = 32,
	NTX_SCHED = 8,
	PM_NSTATS = 5,
	T6_PM_NSTATS = 7,
	MBOX_LEN = 64,
	TRACE_LEN = 112,
	FILTER_OPT_LEN = 36,
};

enum {
	NCSI_CAP_BASE = 0,
	NCSI_CAP_GENERIC = 0,
	NCSI_CAP_BC = 1,
	NCSI_CAP_MC = 2,
	NCSI_CAP_BUFFER = 3,
	NCSI_CAP_AEN = 4,
	NCSI_CAP_VLAN = 5,
	NCSI_CAP_MAX = 6,
};

enum {
	NCSI_CAP_GENERIC_HWA = 1,
	NCSI_CAP_GENERIC_HDS = 2,
	NCSI_CAP_GENERIC_FC = 4,
	NCSI_CAP_GENERIC_FC1 = 8,
	NCSI_CAP_GENERIC_MC = 16,
	NCSI_CAP_GENERIC_HWA_UNKNOWN = 0,
	NCSI_CAP_GENERIC_HWA_SUPPORT = 32,
	NCSI_CAP_GENERIC_HWA_NOT_SUPPORT = 64,
	NCSI_CAP_GENERIC_HWA_RESERVED = 96,
	NCSI_CAP_GENERIC_HWA_MASK = 96,
	NCSI_CAP_GENERIC_MASK = 127,
	NCSI_CAP_BC_ARP = 1,
	NCSI_CAP_BC_DHCPC = 2,
	NCSI_CAP_BC_DHCPS = 4,
	NCSI_CAP_BC_NETBIOS = 8,
	NCSI_CAP_BC_MASK = 15,
	NCSI_CAP_MC_IPV6_NEIGHBOR = 1,
	NCSI_CAP_MC_IPV6_ROUTER = 2,
	NCSI_CAP_MC_DHCPV6_RELAY = 4,
	NCSI_CAP_MC_DHCPV6_WELL_KNOWN = 8,
	NCSI_CAP_MC_IPV6_MLD = 16,
	NCSI_CAP_MC_IPV6_NEIGHBOR_S = 32,
	NCSI_CAP_MC_MASK = 63,
	NCSI_CAP_AEN_LSC = 1,
	NCSI_CAP_AEN_CR = 2,
	NCSI_CAP_AEN_HDS = 4,
	NCSI_CAP_AEN_MASK = 7,
	NCSI_CAP_VLAN_ONLY = 1,
	NCSI_CAP_VLAN_NO = 2,
	NCSI_CAP_VLAN_ANY = 4,
	NCSI_CAP_VLAN_MASK = 7,
};

enum {
	NCSI_MODE_BASE = 0,
	NCSI_MODE_ENABLE = 0,
	NCSI_MODE_TX_ENABLE = 1,
	NCSI_MODE_LINK = 2,
	NCSI_MODE_VLAN = 3,
	NCSI_MODE_BC = 4,
	NCSI_MODE_MC = 5,
	NCSI_MODE_AEN = 6,
	NCSI_MODE_FC = 7,
	NCSI_MODE_MAX = 8,
};

enum {
	NDA_UNSPEC = 0,
	NDA_DST = 1,
	NDA_LLADDR = 2,
	NDA_CACHEINFO = 3,
	NDA_PROBES = 4,
	NDA_VLAN = 5,
	NDA_PORT = 6,
	NDA_VNI = 7,
	NDA_IFINDEX = 8,
	NDA_MASTER = 9,
	NDA_LINK_NETNSID = 10,
	NDA_SRC_VNI = 11,
	NDA_PROTOCOL = 12,
	NDA_NH_ID = 13,
	NDA_FDB_EXT_ATTRS = 14,
	NDA_FLAGS_EXT = 15,
	NDA_NDM_STATE_MASK = 16,
	NDA_NDM_FLAGS_MASK = 17,
	__NDA_MAX = 18,
};

enum {
	NDD_UNARMED = 1,
	NDD_LOCKED = 2,
	NDD_SECURITY_OVERWRITE = 3,
	NDD_WORK_PENDING = 4,
	NDD_LABELING = 6,
	NDD_INCOHERENT = 7,
	NDD_REGISTER_SYNC = 8,
	ND_IOCTL_MAX_BUFLEN = 4194304,
	ND_CMD_MAX_ELEM = 5,
	ND_CMD_MAX_ENVELOPE = 256,
	ND_MAX_MAPPINGS = 32,
	ND_REGION_PAGEMAP = 0,
	ND_REGION_PERSIST_CACHE = 1,
	ND_REGION_PERSIST_MEMCTRL = 2,
	ND_REGION_ASYNC = 3,
	ND_REGION_CXL = 4,
	DPA_RESOURCE_ADJUSTED = 1,
};

enum {
	NDTA_UNSPEC = 0,
	NDTA_NAME = 1,
	NDTA_THRESH1 = 2,
	NDTA_THRESH2 = 3,
	NDTA_THRESH3 = 4,
	NDTA_CONFIG = 5,
	NDTA_PARMS = 6,
	NDTA_STATS = 7,
	NDTA_GC_INTERVAL = 8,
	NDTA_PAD = 9,
	__NDTA_MAX = 10,
};

enum {
	NDTPA_UNSPEC = 0,
	NDTPA_IFINDEX = 1,
	NDTPA_REFCNT = 2,
	NDTPA_REACHABLE_TIME = 3,
	NDTPA_BASE_REACHABLE_TIME = 4,
	NDTPA_RETRANS_TIME = 5,
	NDTPA_GC_STALETIME = 6,
	NDTPA_DELAY_PROBE_TIME = 7,
	NDTPA_QUEUE_LEN = 8,
	NDTPA_APP_PROBES = 9,
	NDTPA_UCAST_PROBES = 10,
	NDTPA_MCAST_PROBES = 11,
	NDTPA_ANYCAST_DELAY = 12,
	NDTPA_PROXY_DELAY = 13,
	NDTPA_PROXY_QLEN = 14,
	NDTPA_LOCKTIME = 15,
	NDTPA_QUEUE_LENBYTES = 16,
	NDTPA_MCAST_REPROBES = 17,
	NDTPA_PAD = 18,
	NDTPA_INTERVAL_PROBE_TIME_MS = 19,
	__NDTPA_MAX = 20,
};

enum {
	NDUSEROPT_UNSPEC = 0,
	NDUSEROPT_SRCADDR = 1,
	__NDUSEROPT_MAX = 2,
};

enum {
	NEIGH_ARP_TABLE = 0,
	NEIGH_ND_TABLE = 1,
	NEIGH_DN_TABLE = 2,
	NEIGH_NR_TABLES = 3,
	NEIGH_LINK_TABLE = 3,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	NESTED_SYNC_IMM_BIT = 0,
	NESTED_SYNC_TODO_BIT = 1,
};

enum {
	NETCONFA_UNSPEC = 0,
	NETCONFA_IFINDEX = 1,
	NETCONFA_FORWARDING = 2,
	NETCONFA_RP_FILTER = 3,
	NETCONFA_MC_FORWARDING = 4,
	NETCONFA_PROXY_NEIGH = 5,
	NETCONFA_IGNORE_ROUTES_WITH_LINKDOWN = 6,
	NETCONFA_INPUT = 7,
	NETCONFA_BC_FORWARDING = 8,
	__NETCONFA_MAX = 9,
};

enum {
	NETDEV_A_DEV_IFINDEX = 1,
	NETDEV_A_DEV_PAD = 2,
	NETDEV_A_DEV_XDP_FEATURES = 3,
	NETDEV_A_DEV_XDP_ZC_MAX_SEGS = 4,
	NETDEV_A_DEV_XDP_RX_METADATA_FEATURES = 5,
	NETDEV_A_DEV_XSK_FEATURES = 6,
	__NETDEV_A_DEV_MAX = 7,
	NETDEV_A_DEV_MAX = 6,
};

enum {
	NETDEV_A_NAPI_IFINDEX = 1,
	NETDEV_A_NAPI_ID = 2,
	NETDEV_A_NAPI_IRQ = 3,
	NETDEV_A_NAPI_PID = 4,
	__NETDEV_A_NAPI_MAX = 5,
	NETDEV_A_NAPI_MAX = 4,
};

enum {
	NETDEV_A_PAGE_POOL_ID = 1,
	NETDEV_A_PAGE_POOL_IFINDEX = 2,
	NETDEV_A_PAGE_POOL_NAPI_ID = 3,
	NETDEV_A_PAGE_POOL_INFLIGHT = 4,
	NETDEV_A_PAGE_POOL_INFLIGHT_MEM = 5,
	NETDEV_A_PAGE_POOL_DETACH_TIME = 6,
	__NETDEV_A_PAGE_POOL_MAX = 7,
	NETDEV_A_PAGE_POOL_MAX = 6,
};

enum {
	NETDEV_A_PAGE_POOL_STATS_INFO = 1,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_FAST = 8,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW = 9,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW_HIGH_ORDER = 10,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_EMPTY = 11,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_REFILL = 12,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_WAIVE = 13,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHED = 14,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHE_FULL = 15,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING = 16,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING_FULL = 17,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RELEASED_REFCNT = 18,
	__NETDEV_A_PAGE_POOL_STATS_MAX = 19,
	NETDEV_A_PAGE_POOL_STATS_MAX = 18,
};

enum {
	NETDEV_A_QSTATS_IFINDEX = 1,
	NETDEV_A_QSTATS_QUEUE_TYPE = 2,
	NETDEV_A_QSTATS_QUEUE_ID = 3,
	NETDEV_A_QSTATS_SCOPE = 4,
	NETDEV_A_QSTATS_RX_PACKETS = 8,
	NETDEV_A_QSTATS_RX_BYTES = 9,
	NETDEV_A_QSTATS_TX_PACKETS = 10,
	NETDEV_A_QSTATS_TX_BYTES = 11,
	NETDEV_A_QSTATS_RX_ALLOC_FAIL = 12,
	NETDEV_A_QSTATS_RX_HW_DROPS = 13,
	NETDEV_A_QSTATS_RX_HW_DROP_OVERRUNS = 14,
	NETDEV_A_QSTATS_RX_CSUM_COMPLETE = 15,
	NETDEV_A_QSTATS_RX_CSUM_UNNECESSARY = 16,
	NETDEV_A_QSTATS_RX_CSUM_NONE = 17,
	NETDEV_A_QSTATS_RX_CSUM_BAD = 18,
	NETDEV_A_QSTATS_RX_HW_GRO_PACKETS = 19,
	NETDEV_A_QSTATS_RX_HW_GRO_BYTES = 20,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_PACKETS = 21,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_BYTES = 22,
	NETDEV_A_QSTATS_RX_HW_DROP_RATELIMITS = 23,
	NETDEV_A_QSTATS_TX_HW_DROPS = 24,
	NETDEV_A_QSTATS_TX_HW_DROP_ERRORS = 25,
	NETDEV_A_QSTATS_TX_CSUM_NONE = 26,
	NETDEV_A_QSTATS_TX_NEEDS_CSUM = 27,
	NETDEV_A_QSTATS_TX_HW_GSO_PACKETS = 28,
	NETDEV_A_QSTATS_TX_HW_GSO_BYTES = 29,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_PACKETS = 30,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_BYTES = 31,
	NETDEV_A_QSTATS_TX_HW_DROP_RATELIMITS = 32,
	NETDEV_A_QSTATS_TX_STOP = 33,
	NETDEV_A_QSTATS_TX_WAKE = 34,
	__NETDEV_A_QSTATS_MAX = 35,
	NETDEV_A_QSTATS_MAX = 34,
};

enum {
	NETDEV_A_QUEUE_ID = 1,
	NETDEV_A_QUEUE_IFINDEX = 2,
	NETDEV_A_QUEUE_TYPE = 3,
	NETDEV_A_QUEUE_NAPI_ID = 4,
	__NETDEV_A_QUEUE_MAX = 5,
	NETDEV_A_QUEUE_MAX = 4,
};

enum {
	NETDEV_CMD_DEV_GET = 1,
	NETDEV_CMD_DEV_ADD_NTF = 2,
	NETDEV_CMD_DEV_DEL_NTF = 3,
	NETDEV_CMD_DEV_CHANGE_NTF = 4,
	NETDEV_CMD_PAGE_POOL_GET = 5,
	NETDEV_CMD_PAGE_POOL_ADD_NTF = 6,
	NETDEV_CMD_PAGE_POOL_DEL_NTF = 7,
	NETDEV_CMD_PAGE_POOL_CHANGE_NTF = 8,
	NETDEV_CMD_PAGE_POOL_STATS_GET = 9,
	NETDEV_CMD_QUEUE_GET = 10,
	NETDEV_CMD_NAPI_GET = 11,
	NETDEV_CMD_QSTATS_GET = 12,
	__NETDEV_CMD_MAX = 13,
	NETDEV_CMD_MAX = 12,
};

enum {
	NETDEV_NLGRP_MGMT = 0,
	NETDEV_NLGRP_PAGE_POOL = 1,
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	NETIF_F_LLTX_BIT = 12,
	NETIF_F_NETNS_LOCAL_BIT = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_LAST = 34,
	NETIF_F_FCOE_CRC_BIT = 35,
	NETIF_F_SCTP_CRC_BIT = 36,
	NETIF_F_FCOE_MTU_BIT = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	NETLINK_F_KERNEL_SOCKET = 0,
	NETLINK_F_RECV_PKTINFO = 1,
	NETLINK_F_BROADCAST_SEND_ERROR = 2,
	NETLINK_F_RECV_NO_ENOBUFS = 3,
	NETLINK_F_LISTEN_ALL_NSID = 4,
	NETLINK_F_CAP_ACK = 5,
	NETLINK_F_EXT_ACK = 6,
	NETLINK_F_STRICT_CHK = 7,
};

enum {
	NETLINK_UNCONNECTED = 0,
	NETLINK_CONNECTED = 1,
};

enum {
	NETNSA_NONE = 0,
	NETNSA_NSID = 1,
	NETNSA_PID = 2,
	NETNSA_FD = 3,
	NETNSA_TARGET_NSID = 4,
	NETNSA_CURRENT_NSID = 5,
	__NETNSA_MAX = 6,
};

enum {
	NET_NS_INDEX = 0,
	UTS_NS_INDEX = 1,
	IPC_NS_INDEX = 2,
	PID_NS_INDEX = 3,
	USER_NS_INDEX = 4,
	MNT_NS_INDEX = 5,
	CGROUP_NS_INDEX = 6,
	NR_NAMESPACES = 7,
};

enum {
	NEXTHOP_GRP_TYPE_MPATH = 0,
	NEXTHOP_GRP_TYPE_RES = 1,
	__NEXTHOP_GRP_TYPE_MAX = 2,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum {
	NHA_GROUP_STATS_ENTRY_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY_ID = 1,
	NHA_GROUP_STATS_ENTRY_PACKETS = 2,
	NHA_GROUP_STATS_ENTRY_PACKETS_HW = 3,
	__NHA_GROUP_STATS_ENTRY_MAX = 4,
};

enum {
	NHA_GROUP_STATS_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY = 1,
	__NHA_GROUP_STATS_MAX = 2,
};

enum {
	NHA_RES_BUCKET_UNSPEC = 0,
	NHA_RES_BUCKET_PAD = 0,
	NHA_RES_BUCKET_INDEX = 1,
	NHA_RES_BUCKET_IDLE_TIME = 2,
	NHA_RES_BUCKET_NH_ID = 3,
	__NHA_RES_BUCKET_MAX = 4,
};

enum {
	NHA_RES_GROUP_UNSPEC = 0,
	NHA_RES_GROUP_PAD = 0,
	NHA_RES_GROUP_BUCKETS = 1,
	NHA_RES_GROUP_IDLE_TIMER = 2,
	NHA_RES_GROUP_UNBALANCED_TIMER = 3,
	NHA_RES_GROUP_UNBALANCED_TIME = 4,
	__NHA_RES_GROUP_MAX = 5,
};

enum {
	NHA_UNSPEC = 0,
	NHA_ID = 1,
	NHA_GROUP = 2,
	NHA_GROUP_TYPE = 3,
	NHA_BLACKHOLE = 4,
	NHA_OIF = 5,
	NHA_GATEWAY = 6,
	NHA_ENCAP_TYPE = 7,
	NHA_ENCAP = 8,
	NHA_GROUPS = 9,
	NHA_MASTER = 10,
	NHA_FDB = 11,
	NHA_RES_GROUP = 12,
	NHA_RES_BUCKET = 13,
	NHA_OP_FLAGS = 14,
	NHA_GROUP_STATS = 15,
	NHA_HW_STATS_ENABLE = 16,
	NHA_HW_STATS_USED = 17,
	__NHA_MAX = 18,
};

enum {
	NLA_UNSPEC = 0,
	NLA_U8 = 1,
	NLA_U16 = 2,
	NLA_U32 = 3,
	NLA_U64 = 4,
	NLA_STRING = 5,
	NLA_FLAG = 6,
	NLA_MSECS = 7,
	NLA_NESTED = 8,
	NLA_NESTED_ARRAY = 9,
	NLA_NUL_STRING = 10,
	NLA_BINARY = 11,
	NLA_S8 = 12,
	NLA_S16 = 13,
	NLA_S32 = 14,
	NLA_S64 = 15,
	NLA_BITFIELD32 = 16,
	NLA_REJECT = 17,
	NLA_BE16 = 18,
	NLA_BE32 = 19,
	NLA_SINT = 20,
	NLA_UINT = 21,
	__NLA_TYPE_MAX = 22,
};

enum {
	NOTHING = 0,
	DELETE = 1,
	ADD = 2,
	CHANGE = 3,
};

enum {
	NO_ACTION = 0,
	MODE_CHANGE_ACCEPT = 1,
	MODE_CHANGE_NO_ACTION = 2,
	TARGET_STILL_ACTIVE = 3,
};

enum {
	NUM_TRIAL_SAMPLES = 8192,
	MAX_SAMPLES_PER_BIT = 66,
};

enum {
	NVMEM_ADD = 1,
	NVMEM_REMOVE = 2,
	NVMEM_CELL_ADD = 3,
	NVMEM_CELL_REMOVE = 4,
	NVMEM_LAYOUT_ADD = 5,
	NVMEM_LAYOUT_REMOVE = 6,
};

enum {
	NVMET_FCOP_READDATA = 1,
	NVMET_FCOP_WRITEDATA = 2,
	NVMET_FCOP_READDATA_RSP = 3,
	NVMET_FCOP_RSP = 4,
};

enum {
	NVMET_FCTGTFEAT_READDATA_RSP = 1,
};

enum {
	NVMET_TCP_F_INIT_FAILED = 1,
};

enum {
	NVME_AEN_BIT_NS_ATTR = 8,
	NVME_AEN_BIT_FW_ACT = 9,
	NVME_AEN_BIT_ANA_CHANGE = 11,
	NVME_AEN_BIT_DISC_CHANGE = 31,
};

enum {
	NVME_AEN_CFG_NS_ATTR = 256,
	NVME_AEN_CFG_FW_ACT = 512,
	NVME_AEN_CFG_ANA_CHANGE = 2048,
	NVME_AEN_CFG_DISC_CHANGE = -2147483648,
};

enum {
	NVME_AER_ERROR = 0,
	NVME_AER_SMART = 1,
	NVME_AER_NOTICE = 2,
	NVME_AER_CSS = 6,
	NVME_AER_VS = 7,
};

enum {
	NVME_AER_ERROR_PERSIST_INT_ERR = 3,
};

enum {
	NVME_AER_NOTICE_NS_CHANGED = 0,
	NVME_AER_NOTICE_FW_ACT_STARTING = 1,
	NVME_AER_NOTICE_ANA = 3,
	NVME_AER_NOTICE_DISC_CHANGED = 240,
};

enum {
	NVME_AUTH_COMMON_MESSAGES = 0,
	NVME_AUTH_DHCHAP_MESSAGES = 1,
};

enum {
	NVME_AUTH_DHCHAP_AUTH_ID = 1,
};

enum {
	NVME_AUTH_DHCHAP_FAILURE_FAILED = 1,
	NVME_AUTH_DHCHAP_FAILURE_NOT_USABLE = 2,
	NVME_AUTH_DHCHAP_FAILURE_CONCAT_MISMATCH = 3,
	NVME_AUTH_DHCHAP_FAILURE_HASH_UNUSABLE = 4,
	NVME_AUTH_DHCHAP_FAILURE_DHGROUP_UNUSABLE = 5,
	NVME_AUTH_DHCHAP_FAILURE_INCORRECT_PAYLOAD = 6,
	NVME_AUTH_DHCHAP_FAILURE_INCORRECT_MESSAGE = 7,
};

enum {
	NVME_AUTH_DHCHAP_FAILURE_REASON_FAILED = 1,
};

enum {
	NVME_AUTH_DHCHAP_MESSAGE_NEGOTIATE = 0,
	NVME_AUTH_DHCHAP_MESSAGE_CHALLENGE = 1,
	NVME_AUTH_DHCHAP_MESSAGE_REPLY = 2,
	NVME_AUTH_DHCHAP_MESSAGE_SUCCESS1 = 3,
	NVME_AUTH_DHCHAP_MESSAGE_SUCCESS2 = 4,
	NVME_AUTH_DHCHAP_MESSAGE_FAILURE2 = 240,
	NVME_AUTH_DHCHAP_MESSAGE_FAILURE1 = 241,
};

enum {
	NVME_AUTH_DHCHAP_PROTOCOL_IDENTIFIER = 233,
};

enum {
	NVME_AUTH_DHGROUP_NULL = 0,
	NVME_AUTH_DHGROUP_2048 = 1,
	NVME_AUTH_DHGROUP_3072 = 2,
	NVME_AUTH_DHGROUP_4096 = 3,
	NVME_AUTH_DHGROUP_6144 = 4,
	NVME_AUTH_DHGROUP_8192 = 5,
	NVME_AUTH_DHGROUP_INVALID = 255,
};

enum {
	NVME_AUTH_HASH_SHA256 = 1,
	NVME_AUTH_HASH_SHA384 = 2,
	NVME_AUTH_HASH_SHA512 = 3,
	NVME_AUTH_HASH_INVALID = 255,
};

enum {
	NVME_CAP_CRMS_CRWMS = 576460752303423488ULL,
	NVME_CAP_CRMS_CRIMS = 1152921504606846976ULL,
};

enum {
	NVME_CAP_CSS_NVM = 1,
	NVME_CAP_CSS_CSI = 64,
};

enum {
	NVME_CC_ENABLE = 1,
	NVME_CC_EN_SHIFT = 0,
	NVME_CC_CSS_SHIFT = 4,
	NVME_CC_MPS_SHIFT = 7,
	NVME_CC_AMS_SHIFT = 11,
	NVME_CC_SHN_SHIFT = 14,
	NVME_CC_IOSQES_SHIFT = 16,
	NVME_CC_IOCQES_SHIFT = 20,
	NVME_CC_CSS_NVM = 0,
	NVME_CC_CSS_CSI = 96,
	NVME_CC_CSS_MASK = 112,
	NVME_CC_AMS_RR = 0,
	NVME_CC_AMS_WRRU = 2048,
	NVME_CC_AMS_VS = 14336,
	NVME_CC_SHN_NONE = 0,
	NVME_CC_SHN_NORMAL = 16384,
	NVME_CC_SHN_ABRUPT = 32768,
	NVME_CC_SHN_MASK = 49152,
	NVME_CC_IOSQES = 393216,
	NVME_CC_IOCQES = 4194304,
	NVME_CC_CRIME = 16777216,
};

enum {
	NVME_CMBMSC_CRE = 1,
	NVME_CMBMSC_CMSE = 2,
};

enum {
	NVME_CMBSZ_SQS = 1,
	NVME_CMBSZ_CQS = 2,
	NVME_CMBSZ_LISTS = 4,
	NVME_CMBSZ_RDS = 8,
	NVME_CMBSZ_WDS = 16,
	NVME_CMBSZ_SZ_SHIFT = 12,
	NVME_CMBSZ_SZ_MASK = 1048575,
	NVME_CMBSZ_SZU_SHIFT = 8,
	NVME_CMBSZ_SZU_MASK = 15,
};

enum {
	NVME_CMD_EFFECTS_CSUPP = 1,
	NVME_CMD_EFFECTS_LBCC = 2,
	NVME_CMD_EFFECTS_NCC = 4,
	NVME_CMD_EFFECTS_NIC = 8,
	NVME_CMD_EFFECTS_CCC = 16,
	NVME_CMD_EFFECTS_CSER_MASK = 49152,
	NVME_CMD_EFFECTS_CSE_MASK = 458752,
	NVME_CMD_EFFECTS_UUID_SEL = 524288,
	NVME_CMD_EFFECTS_SCOPE_MASK = 4293918720,
};

enum {
	NVME_CMD_FUSE_FIRST = 1,
	NVME_CMD_FUSE_SECOND = 2,
	NVME_CMD_SGL_METABUF = 64,
	NVME_CMD_SGL_METASEG = 128,
	NVME_CMD_SGL_ALL = 192,
};

enum {
	NVME_CONNECT_AUTHREQ_ASCR = 262144,
	NVME_CONNECT_AUTHREQ_ATR = 131072,
};

enum {
	NVME_CONNECT_DISABLE_SQFLOW = 4,
};

enum {
	NVME_CSI_NVM = 0,
	NVME_CSI_ZNS = 2,
};

enum {
	NVME_CSTS_RDY = 1,
	NVME_CSTS_CFS = 2,
	NVME_CSTS_NSSRO = 16,
	NVME_CSTS_PP = 32,
	NVME_CSTS_SHST_NORMAL = 0,
	NVME_CSTS_SHST_OCCUR = 4,
	NVME_CSTS_SHST_CMPLT = 8,
	NVME_CSTS_SHST_MASK = 12,
};

enum {
	NVME_CTRL_CMIC_MULTI_PORT = 1,
	NVME_CTRL_CMIC_MULTI_CTRL = 2,
	NVME_CTRL_CMIC_ANA = 8,
	NVME_CTRL_ONCS_COMPARE = 1,
	NVME_CTRL_ONCS_WRITE_UNCORRECTABLE = 2,
	NVME_CTRL_ONCS_DSM = 4,
	NVME_CTRL_ONCS_WRITE_ZEROES = 8,
	NVME_CTRL_ONCS_RESERVATIONS = 32,
	NVME_CTRL_ONCS_TIMESTAMP = 64,
	NVME_CTRL_VWC_PRESENT = 1,
	NVME_CTRL_OACS_SEC_SUPP = 1,
	NVME_CTRL_OACS_NS_MNGT_SUPP = 8,
	NVME_CTRL_OACS_DIRECTIVES = 32,
	NVME_CTRL_OACS_DBBUF_SUPP = 256,
	NVME_CTRL_LPA_CMD_EFFECTS_LOG = 2,
	NVME_CTRL_CTRATT_128_ID = 1,
	NVME_CTRL_CTRATT_NON_OP_PSP = 2,
	NVME_CTRL_CTRATT_NVM_SETS = 4,
	NVME_CTRL_CTRATT_READ_RECV_LVLS = 8,
	NVME_CTRL_CTRATT_ENDURANCE_GROUPS = 16,
	NVME_CTRL_CTRATT_PREDICTABLE_LAT = 32,
	NVME_CTRL_CTRATT_NAMESPACE_GRANULARITY = 128,
	NVME_CTRL_CTRATT_UUID_LIST = 512,
};

enum {
	NVME_DSMGMT_IDR = 1,
	NVME_DSMGMT_IDW = 2,
	NVME_DSMGMT_AD = 4,
};

enum {
	NVME_ENABLE_ACRE = 1,
	NVME_ENABLE_LBAFEE = 1,
};

enum {
	NVME_HOST_MEM_ENABLE = 1,
	NVME_HOST_MEM_RETURN = 2,
};

enum {
	NVME_ID_CNS_NS = 0,
	NVME_ID_CNS_CTRL = 1,
	NVME_ID_CNS_NS_ACTIVE_LIST = 2,
	NVME_ID_CNS_NS_DESC_LIST = 3,
	NVME_ID_CNS_CS_NS = 5,
	NVME_ID_CNS_CS_CTRL = 6,
	NVME_ID_CNS_NS_CS_INDEP = 8,
	NVME_ID_CNS_NS_PRESENT_LIST = 16,
	NVME_ID_CNS_NS_PRESENT = 17,
	NVME_ID_CNS_CTRL_NS_LIST = 18,
	NVME_ID_CNS_CTRL_LIST = 19,
	NVME_ID_CNS_SCNDRY_CTRL_LIST = 21,
	NVME_ID_CNS_NS_GRANULARITY = 22,
	NVME_ID_CNS_UUID_LIST = 23,
};

enum {
	NVME_ID_NS_NVM_STS_MASK = 127,
	NVME_ID_NS_NVM_GUARD_SHIFT = 7,
	NVME_ID_NS_NVM_GUARD_MASK = 3,
};

enum {
	NVME_IOCTL_VEC = 1,
	NVME_IOCTL_PARTITION = 2,
};

enum {
	NVME_MC_EXTENDED_LBA = 1,
	NVME_MC_METADATA_PTR = 2,
};

enum {
	NVME_NIDT_EUI64 = 1,
	NVME_NIDT_NGUID = 2,
	NVME_NIDT_UUID = 3,
	NVME_NIDT_CSI = 4,
};

enum {
	NVME_NSTAT_NRDY = 1,
};

enum {
	NVME_NS_FEAT_THIN = 1,
	NVME_NS_FEAT_ATOMICS = 2,
	NVME_NS_FEAT_IO_OPT = 16,
	NVME_NS_ATTR_RO = 1,
	NVME_NS_FLBAS_LBA_MASK = 15,
	NVME_NS_FLBAS_LBA_UMASK = 96,
	NVME_NS_FLBAS_LBA_SHIFT = 1,
	NVME_NS_FLBAS_META_EXT = 16,
	NVME_NS_NMIC_SHARED = 1,
	NVME_LBAF_RP_BEST = 0,
	NVME_LBAF_RP_BETTER = 1,
	NVME_LBAF_RP_GOOD = 2,
	NVME_LBAF_RP_DEGRADED = 3,
	NVME_NS_DPC_PI_LAST = 16,
	NVME_NS_DPC_PI_FIRST = 8,
	NVME_NS_DPC_PI_TYPE3 = 4,
	NVME_NS_DPC_PI_TYPE2 = 2,
	NVME_NS_DPC_PI_TYPE1 = 1,
	NVME_NS_DPS_PI_FIRST = 8,
	NVME_NS_DPS_PI_MASK = 7,
	NVME_NS_DPS_PI_TYPE1 = 1,
	NVME_NS_DPS_PI_TYPE2 = 2,
	NVME_NS_DPS_PI_TYPE3 = 3,
};

enum {
	NVME_NS_NO_WRITE_PROTECT = 0,
	NVME_NS_WRITE_PROTECT = 1,
	NVME_NS_WRITE_PROTECT_POWER_CYCLE = 2,
	NVME_NS_WRITE_PROTECT_PERMANENT = 3,
};

enum {
	NVME_NVM_NS_16B_GUARD = 0,
	NVME_NVM_NS_32B_GUARD = 1,
	NVME_NVM_NS_64B_GUARD = 2,
};

enum {
	NVME_PS_FLAGS_MAX_POWER_SCALE = 1,
	NVME_PS_FLAGS_NON_OP_STATE = 2,
};

enum {
	NVME_QUEUE_PHYS_CONTIG = 1,
	NVME_CQ_IRQ_ENABLED = 2,
	NVME_SQ_PRIO_URGENT = 0,
	NVME_SQ_PRIO_HIGH = 2,
	NVME_SQ_PRIO_MEDIUM = 4,
	NVME_SQ_PRIO_LOW = 6,
	NVME_FEAT_ARBITRATION = 1,
	NVME_FEAT_POWER_MGMT = 2,
	NVME_FEAT_LBA_RANGE = 3,
	NVME_FEAT_TEMP_THRESH = 4,
	NVME_FEAT_ERR_RECOVERY = 5,
	NVME_FEAT_VOLATILE_WC = 6,
	NVME_FEAT_NUM_QUEUES = 7,
	NVME_FEAT_IRQ_COALESCE = 8,
	NVME_FEAT_IRQ_CONFIG = 9,
	NVME_FEAT_WRITE_ATOMIC = 10,
	NVME_FEAT_ASYNC_EVENT = 11,
	NVME_FEAT_AUTO_PST = 12,
	NVME_FEAT_HOST_MEM_BUF = 13,
	NVME_FEAT_TIMESTAMP = 14,
	NVME_FEAT_KATO = 15,
	NVME_FEAT_HCTM = 16,
	NVME_FEAT_NOPSC = 17,
	NVME_FEAT_RRL = 18,
	NVME_FEAT_PLM_CONFIG = 19,
	NVME_FEAT_PLM_WINDOW = 20,
	NVME_FEAT_HOST_BEHAVIOR = 22,
	NVME_FEAT_SANITIZE = 23,
	NVME_FEAT_SW_PROGRESS = 128,
	NVME_FEAT_HOST_ID = 129,
	NVME_FEAT_RESV_MASK = 130,
	NVME_FEAT_RESV_PERSIST = 131,
	NVME_FEAT_WRITE_PROTECT = 132,
	NVME_FEAT_VENDOR_START = 192,
	NVME_FEAT_VENDOR_END = 255,
	NVME_LOG_ERROR = 1,
	NVME_LOG_SMART = 2,
	NVME_LOG_FW_SLOT = 3,
	NVME_LOG_CHANGED_NS = 4,
	NVME_LOG_CMD_EFFECTS = 5,
	NVME_LOG_DEVICE_SELF_TEST = 6,
	NVME_LOG_TELEMETRY_HOST = 7,
	NVME_LOG_TELEMETRY_CTRL = 8,
	NVME_LOG_ENDURANCE_GROUP = 9,
	NVME_LOG_ANA = 12,
	NVME_LOG_DISC = 112,
	NVME_LOG_RESERVATION = 128,
	NVME_FWACT_REPL = 0,
	NVME_FWACT_REPL_ACTV = 8,
	NVME_FWACT_ACTV = 16,
};

enum {
	NVME_REG_CAP = 0,
	NVME_REG_VS = 8,
	NVME_REG_INTMS = 12,
	NVME_REG_INTMC = 16,
	NVME_REG_CC = 20,
	NVME_REG_CSTS = 28,
	NVME_REG_NSSR = 32,
	NVME_REG_AQA = 36,
	NVME_REG_ASQ = 40,
	NVME_REG_ACQ = 48,
	NVME_REG_CMBLOC = 56,
	NVME_REG_CMBSZ = 60,
	NVME_REG_BPINFO = 64,
	NVME_REG_BPRSEL = 68,
	NVME_REG_BPMBL = 72,
	NVME_REG_CMBMSC = 80,
	NVME_REG_CRTO = 104,
	NVME_REG_PMRCAP = 3584,
	NVME_REG_PMRCTL = 3588,
	NVME_REG_PMRSTS = 3592,
	NVME_REG_PMREBS = 3596,
	NVME_REG_PMRSWTP = 3600,
	NVME_REG_DBS = 4096,
};

enum {
	NVME_REQ_CANCELLED = 1,
	NVME_REQ_USERCMD = 2,
	NVME_MPATH_IO_STATS = 4,
};

enum {
	NVME_RW_LR = 32768,
	NVME_RW_FUA = 16384,
	NVME_RW_APPEND_PIREMAP = 512,
	NVME_RW_DSM_FREQ_UNSPEC = 0,
	NVME_RW_DSM_FREQ_TYPICAL = 1,
	NVME_RW_DSM_FREQ_RARE = 2,
	NVME_RW_DSM_FREQ_READS = 3,
	NVME_RW_DSM_FREQ_WRITES = 4,
	NVME_RW_DSM_FREQ_RW = 5,
	NVME_RW_DSM_FREQ_ONCE = 6,
	NVME_RW_DSM_FREQ_PREFETCH = 7,
	NVME_RW_DSM_FREQ_TEMP = 8,
	NVME_RW_DSM_LATENCY_NONE = 0,
	NVME_RW_DSM_LATENCY_IDLE = 16,
	NVME_RW_DSM_LATENCY_NORM = 32,
	NVME_RW_DSM_LATENCY_LOW = 48,
	NVME_RW_DSM_SEQ_REQ = 64,
	NVME_RW_DSM_COMPRESSED = 128,
	NVME_RW_PRINFO_PRCHK_REF = 1024,
	NVME_RW_PRINFO_PRCHK_APP = 2048,
	NVME_RW_PRINFO_PRCHK_GUARD = 4096,
	NVME_RW_PRINFO_PRACT = 8192,
	NVME_RW_DTYPE_STREAMS = 16,
	NVME_WZ_DEAC = 512,
};

enum {
	NVME_SC_SUCCESS = 0,
	NVME_SC_INVALID_OPCODE = 1,
	NVME_SC_INVALID_FIELD = 2,
	NVME_SC_CMDID_CONFLICT = 3,
	NVME_SC_DATA_XFER_ERROR = 4,
	NVME_SC_POWER_LOSS = 5,
	NVME_SC_INTERNAL = 6,
	NVME_SC_ABORT_REQ = 7,
	NVME_SC_ABORT_QUEUE = 8,
	NVME_SC_FUSED_FAIL = 9,
	NVME_SC_FUSED_MISSING = 10,
	NVME_SC_INVALID_NS = 11,
	NVME_SC_CMD_SEQ_ERROR = 12,
	NVME_SC_SGL_INVALID_LAST = 13,
	NVME_SC_SGL_INVALID_COUNT = 14,
	NVME_SC_SGL_INVALID_DATA = 15,
	NVME_SC_SGL_INVALID_METADATA = 16,
	NVME_SC_SGL_INVALID_TYPE = 17,
	NVME_SC_CMB_INVALID_USE = 18,
	NVME_SC_PRP_INVALID_OFFSET = 19,
	NVME_SC_ATOMIC_WU_EXCEEDED = 20,
	NVME_SC_OP_DENIED = 21,
	NVME_SC_SGL_INVALID_OFFSET = 22,
	NVME_SC_RESERVED = 23,
	NVME_SC_HOST_ID_INCONSIST = 24,
	NVME_SC_KA_TIMEOUT_EXPIRED = 25,
	NVME_SC_KA_TIMEOUT_INVALID = 26,
	NVME_SC_ABORTED_PREEMPT_ABORT = 27,
	NVME_SC_SANITIZE_FAILED = 28,
	NVME_SC_SANITIZE_IN_PROGRESS = 29,
	NVME_SC_SGL_INVALID_GRANULARITY = 30,
	NVME_SC_CMD_NOT_SUP_CMB_QUEUE = 31,
	NVME_SC_NS_WRITE_PROTECTED = 32,
	NVME_SC_CMD_INTERRUPTED = 33,
	NVME_SC_TRANSIENT_TR_ERR = 34,
	NVME_SC_ADMIN_COMMAND_MEDIA_NOT_READY = 36,
	NVME_SC_INVALID_IO_CMD_SET = 44,
	NVME_SC_LBA_RANGE = 128,
	NVME_SC_CAP_EXCEEDED = 129,
	NVME_SC_NS_NOT_READY = 130,
	NVME_SC_RESERVATION_CONFLICT = 131,
	NVME_SC_FORMAT_IN_PROGRESS = 132,
	NVME_SC_CQ_INVALID = 256,
	NVME_SC_QID_INVALID = 257,
	NVME_SC_QUEUE_SIZE = 258,
	NVME_SC_ABORT_LIMIT = 259,
	NVME_SC_ABORT_MISSING = 260,
	NVME_SC_ASYNC_LIMIT = 261,
	NVME_SC_FIRMWARE_SLOT = 262,
	NVME_SC_FIRMWARE_IMAGE = 263,
	NVME_SC_INVALID_VECTOR = 264,
	NVME_SC_INVALID_LOG_PAGE = 265,
	NVME_SC_INVALID_FORMAT = 266,
	NVME_SC_FW_NEEDS_CONV_RESET = 267,
	NVME_SC_INVALID_QUEUE = 268,
	NVME_SC_FEATURE_NOT_SAVEABLE = 269,
	NVME_SC_FEATURE_NOT_CHANGEABLE = 270,
	NVME_SC_FEATURE_NOT_PER_NS = 271,
	NVME_SC_FW_NEEDS_SUBSYS_RESET = 272,
	NVME_SC_FW_NEEDS_RESET = 273,
	NVME_SC_FW_NEEDS_MAX_TIME = 274,
	NVME_SC_FW_ACTIVATE_PROHIBITED = 275,
	NVME_SC_OVERLAPPING_RANGE = 276,
	NVME_SC_NS_INSUFFICIENT_CAP = 277,
	NVME_SC_NS_ID_UNAVAILABLE = 278,
	NVME_SC_NS_ALREADY_ATTACHED = 280,
	NVME_SC_NS_IS_PRIVATE = 281,
	NVME_SC_NS_NOT_ATTACHED = 282,
	NVME_SC_THIN_PROV_NOT_SUPP = 283,
	NVME_SC_CTRL_LIST_INVALID = 284,
	NVME_SC_SELT_TEST_IN_PROGRESS = 285,
	NVME_SC_BP_WRITE_PROHIBITED = 286,
	NVME_SC_CTRL_ID_INVALID = 287,
	NVME_SC_SEC_CTRL_STATE_INVALID = 288,
	NVME_SC_CTRL_RES_NUM_INVALID = 289,
	NVME_SC_RES_ID_INVALID = 290,
	NVME_SC_PMR_SAN_PROHIBITED = 291,
	NVME_SC_ANA_GROUP_ID_INVALID = 292,
	NVME_SC_ANA_ATTACH_FAILED = 293,
	NVME_SC_BAD_ATTRIBUTES = 384,
	NVME_SC_INVALID_PI = 385,
	NVME_SC_READ_ONLY = 386,
	NVME_SC_ONCS_NOT_SUPPORTED = 387,
	NVME_SC_CONNECT_FORMAT = 384,
	NVME_SC_CONNECT_CTRL_BUSY = 385,
	NVME_SC_CONNECT_INVALID_PARAM = 386,
	NVME_SC_CONNECT_RESTART_DISC = 387,
	NVME_SC_CONNECT_INVALID_HOST = 388,
	NVME_SC_DISCOVERY_RESTART = 400,
	NVME_SC_AUTH_REQUIRED = 401,
	NVME_SC_ZONE_BOUNDARY_ERROR = 440,
	NVME_SC_ZONE_FULL = 441,
	NVME_SC_ZONE_READ_ONLY = 442,
	NVME_SC_ZONE_OFFLINE = 443,
	NVME_SC_ZONE_INVALID_WRITE = 444,
	NVME_SC_ZONE_TOO_MANY_ACTIVE = 445,
	NVME_SC_ZONE_TOO_MANY_OPEN = 446,
	NVME_SC_ZONE_INVALID_TRANSITION = 447,
	NVME_SC_WRITE_FAULT = 640,
	NVME_SC_READ_ERROR = 641,
	NVME_SC_GUARD_CHECK = 642,
	NVME_SC_APPTAG_CHECK = 643,
	NVME_SC_REFTAG_CHECK = 644,
	NVME_SC_COMPARE_FAILED = 645,
	NVME_SC_ACCESS_DENIED = 646,
	NVME_SC_UNWRITTEN_BLOCK = 647,
	NVME_SC_INTERNAL_PATH_ERROR = 768,
	NVME_SC_ANA_PERSISTENT_LOSS = 769,
	NVME_SC_ANA_INACCESSIBLE = 770,
	NVME_SC_ANA_TRANSITION = 771,
	NVME_SC_CTRL_PATH_ERROR = 864,
	NVME_SC_HOST_PATH_ERROR = 880,
	NVME_SC_HOST_ABORTED_CMD = 881,
	NVME_SC_CRD = 6144,
	NVME_SC_MORE = 8192,
	NVME_SC_DNR = 16384,
};

enum {
	NVME_SGL_FMT_ADDRESS = 0,
	NVME_SGL_FMT_OFFSET = 1,
	NVME_SGL_FMT_TRANSPORT_A = 10,
	NVME_SGL_FMT_INVALIDATE = 15,
};

enum {
	NVME_SGL_FMT_DATA_DESC = 0,
	NVME_SGL_FMT_SEG_DESC = 2,
	NVME_SGL_FMT_LAST_SEG_DESC = 3,
	NVME_KEY_SGL_FMT_DATA_DESC = 4,
	NVME_TRANSPORT_SGL_DATA_DESC = 5,
};

enum {
	NVME_SMART_CRIT_SPARE = 1,
	NVME_SMART_CRIT_TEMPERATURE = 2,
	NVME_SMART_CRIT_RELIABILITY = 4,
	NVME_SMART_CRIT_MEDIA = 8,
	NVME_SMART_CRIT_VOLATILE_MEMORY = 16,
};

enum {
	NVME_SUBMIT_AT_HEAD = 1,
	NVME_SUBMIT_NOWAIT = 2,
	NVME_SUBMIT_RESERVED = 4,
	NVME_SUBMIT_RETRY = 8,
};

enum {
	NVME_TEMP_THRESH_MASK = 65535,
	NVME_TEMP_THRESH_SELECT_SHIFT = 16,
	NVME_TEMP_THRESH_TYPE_UNDER = 1048576,
};

enum {
	NVME_ZONE_TYPE_SEQWRITE_REQ = 2,
};

enum {
	NVME_ZRA_ZONE_REPORT = 0,
	NVME_ZRASF_ZONE_REPORT_ALL = 0,
	NVME_ZRASF_ZONE_STATE_EMPTY = 1,
	NVME_ZRASF_ZONE_STATE_IMP_OPEN = 2,
	NVME_ZRASF_ZONE_STATE_EXP_OPEN = 3,
	NVME_ZRASF_ZONE_STATE_CLOSED = 4,
	NVME_ZRASF_ZONE_STATE_READONLY = 5,
	NVME_ZRASF_ZONE_STATE_FULL = 6,
	NVME_ZRASF_ZONE_STATE_OFFLINE = 7,
	NVME_REPORT_ZONE_PARTIAL = 1,
};

enum {
	NVMF_ADDR_FAMILY_PCI = 0,
	NVMF_ADDR_FAMILY_IP4 = 1,
	NVMF_ADDR_FAMILY_IP6 = 2,
	NVMF_ADDR_FAMILY_IB = 3,
	NVMF_ADDR_FAMILY_FC = 4,
	NVMF_ADDR_FAMILY_LOOP = 254,
	NVMF_ADDR_FAMILY_MAX = 255,
};

enum {
	NVMF_OPT_ERR = 0,
	NVMF_OPT_TRANSPORT = 1,
	NVMF_OPT_NQN = 2,
	NVMF_OPT_TRADDR = 4,
	NVMF_OPT_TRSVCID = 8,
	NVMF_OPT_QUEUE_SIZE = 16,
	NVMF_OPT_NR_IO_QUEUES = 32,
	NVMF_OPT_TL_RETRY_COUNT = 64,
	NVMF_OPT_KATO = 128,
	NVMF_OPT_HOSTNQN = 256,
	NVMF_OPT_RECONNECT_DELAY = 512,
	NVMF_OPT_HOST_TRADDR = 1024,
	NVMF_OPT_CTRL_LOSS_TMO = 2048,
	NVMF_OPT_HOST_ID = 4096,
	NVMF_OPT_DUP_CONNECT = 8192,
	NVMF_OPT_DISABLE_SQFLOW = 16384,
	NVMF_OPT_HDR_DIGEST = 32768,
	NVMF_OPT_DATA_DIGEST = 65536,
	NVMF_OPT_NR_WRITE_QUEUES = 131072,
	NVMF_OPT_NR_POLL_QUEUES = 262144,
	NVMF_OPT_TOS = 524288,
	NVMF_OPT_FAIL_FAST_TMO = 1048576,
	NVMF_OPT_HOST_IFACE = 2097152,
	NVMF_OPT_DISCOVERY = 4194304,
	NVMF_OPT_DHCHAP_SECRET = 8388608,
	NVMF_OPT_DHCHAP_CTRL_SECRET = 16777216,
	NVMF_OPT_TLS = 33554432,
	NVMF_OPT_KEYRING = 67108864,
	NVMF_OPT_TLS_KEY = 134217728,
};

enum {
	NVMF_RDMA_CMS_RDMA_CM = 1,
};

enum {
	NVMF_RDMA_PRTYPE_NOT_SPECIFIED = 1,
	NVMF_RDMA_PRTYPE_IB = 2,
	NVMF_RDMA_PRTYPE_ROCE = 3,
	NVMF_RDMA_PRTYPE_ROCEV2 = 4,
	NVMF_RDMA_PRTYPE_IWARP = 5,
};

enum {
	NVMF_RDMA_QPTYPE_CONNECTED = 1,
	NVMF_RDMA_QPTYPE_DATAGRAM = 2,
	NVMF_RDMA_QPTYPE_INVALID = 255,
};

enum {
	NVMF_TCP_SECTYPE_NONE = 0,
	NVMF_TCP_SECTYPE_TLS12 = 1,
	NVMF_TCP_SECTYPE_TLS13 = 2,
	NVMF_TCP_SECTYPE_INVALID = 255,
};

enum {
	NVMF_TREQ_NOT_SPECIFIED = 0,
	NVMF_TREQ_REQUIRED = 1,
	NVMF_TREQ_NOT_REQUIRED = 2,
	NVMF_TREQ_DISABLE_SQFLOW = 4,
};

enum {
	NVMF_TRTYPE_RDMA = 1,
	NVMF_TRTYPE_FC = 2,
	NVMF_TRTYPE_TCP = 3,
	NVMF_TRTYPE_LOOP = 254,
	NVMF_TRTYPE_MAX = 255,
};

enum {
	NV_MMIO_BAR = 5,
	NV_PORTS = 2,
	NV_PIO_MASK = 31,
	NV_MWDMA_MASK = 7,
	NV_UDMA_MASK = 127,
	NV_PORT0_SCR_REG_OFFSET = 0,
	NV_PORT1_SCR_REG_OFFSET = 64,
	NV_INT_STATUS = 16,
	NV_INT_ENABLE = 17,
	NV_INT_STATUS_CK804 = 1088,
	NV_INT_ENABLE_CK804 = 1089,
	NV_INT_DEV = 1,
	NV_INT_PM = 2,
	NV_INT_ADDED = 4,
	NV_INT_REMOVED = 8,
	NV_INT_PORT_SHIFT = 4,
	NV_INT_ALL = 15,
	NV_INT_MASK = 13,
	NV_INT_CONFIG = 18,
	NV_INT_CONFIG_METHD = 1,
	NV_MCP_SATA_CFG_20 = 80,
	NV_MCP_SATA_CFG_20_SATA_SPACE_EN = 4,
	NV_MCP_SATA_CFG_20_PORT0_EN = 131072,
	NV_MCP_SATA_CFG_20_PORT1_EN = 65536,
	NV_MCP_SATA_CFG_20_PORT0_PWB_EN = 16384,
	NV_MCP_SATA_CFG_20_PORT1_PWB_EN = 4096,
	NV_ADMA_MAX_CPBS = 32,
	NV_ADMA_CPB_SZ = 128,
	NV_ADMA_APRD_SZ = 16,
	NV_ADMA_SGTBL_LEN = 56,
	NV_ADMA_SGTBL_TOTAL_LEN = 61,
	NV_ADMA_SGTBL_SZ = 896,
	NV_ADMA_PORT_PRIV_DMA_SZ = 32768,
	NV_ADMA_GEN = 1024,
	NV_ADMA_GEN_CTL = 0,
	NV_ADMA_NOTIFIER_CLEAR = 48,
	NV_ADMA_PORT = 1152,
	NV_ADMA_PORT_SIZE = 256,
	NV_ADMA_CTL = 64,
	NV_ADMA_CPB_COUNT = 66,
	NV_ADMA_NEXT_CPB_IDX = 67,
	NV_ADMA_STAT = 68,
	NV_ADMA_CPB_BASE_LOW = 72,
	NV_ADMA_CPB_BASE_HIGH = 76,
	NV_ADMA_APPEND = 80,
	NV_ADMA_NOTIFIER = 104,
	NV_ADMA_NOTIFIER_ERROR = 108,
	NV_ADMA_CTL_HOTPLUG_IEN = 1,
	NV_ADMA_CTL_CHANNEL_RESET = 32,
	NV_ADMA_CTL_GO = 128,
	NV_ADMA_CTL_AIEN = 256,
	NV_ADMA_CTL_READ_NON_COHERENT = 2048,
	NV_ADMA_CTL_WRITE_NON_COHERENT = 4096,
	NV_CPB_RESP_DONE = 1,
	NV_CPB_RESP_ATA_ERR = 8,
	NV_CPB_RESP_CMD_ERR = 16,
	NV_CPB_RESP_CPB_ERR = 128,
	NV_CPB_CTL_CPB_VALID = 1,
	NV_CPB_CTL_QUEUE = 2,
	NV_CPB_CTL_APRD_VALID = 4,
	NV_CPB_CTL_IEN = 8,
	NV_CPB_CTL_FPDMA = 16,
	NV_APRD_WRITE = 2,
	NV_APRD_END = 4,
	NV_APRD_CONT = 8,
	NV_ADMA_STAT_TIMEOUT = 1,
	NV_ADMA_STAT_HOTUNPLUG = 2,
	NV_ADMA_STAT_HOTPLUG = 4,
	NV_ADMA_STAT_CPBERR = 16,
	NV_ADMA_STAT_SERROR = 32,
	NV_ADMA_STAT_CMD_COMPLETE = 64,
	NV_ADMA_STAT_IDLE = 256,
	NV_ADMA_STAT_LEGACY = 512,
	NV_ADMA_STAT_STOPPED = 1024,
	NV_ADMA_STAT_DONE = 4096,
	NV_ADMA_STAT_ERR = 17,
	NV_ADMA_PORT_REGISTER_MODE = 1,
	NV_ADMA_ATAPI_SETUP_COMPLETE = 2,
	NV_CTL_MCP55 = 1024,
	NV_INT_STATUS_MCP55 = 1088,
	NV_INT_ENABLE_MCP55 = 1092,
	NV_NCQ_REG_MCP55 = 1096,
	NV_INT_ALL_MCP55 = 65535,
	NV_INT_PORT_SHIFT_MCP55 = 16,
	NV_INT_MASK_MCP55 = 65533,
	NV_CTL_PRI_SWNCQ = 2,
	NV_CTL_SEC_SWNCQ = 4,
	NV_SWNCQ_IRQ_DEV = 1,
	NV_SWNCQ_IRQ_PM = 2,
	NV_SWNCQ_IRQ_ADDED = 4,
	NV_SWNCQ_IRQ_REMOVED = 8,
	NV_SWNCQ_IRQ_BACKOUT = 16,
	NV_SWNCQ_IRQ_SDBFIS = 32,
	NV_SWNCQ_IRQ_DHREGFIS = 64,
	NV_SWNCQ_IRQ_DMASETUP = 128,
	NV_SWNCQ_IRQ_HOTPLUG = 12,
};

enum {
	OD_NORMAL_SAMPLE = 0,
	OD_SUB_SAMPLE = 1,
};

enum {
	OFFLOAD_STATUS_UP = 0,
	OFFLOAD_STATUS_DOWN = 1,
	OFFLOAD_PORT_DOWN = 2,
	OFFLOAD_PORT_UP = 3,
	OFFLOAD_DB_FULL = 4,
	OFFLOAD_DB_EMPTY = 5,
	OFFLOAD_DB_DROP = 6,
};

enum {
	ONLINE_POLICY_CONTIG_ZONES = 0,
	ONLINE_POLICY_AUTO_MOVABLE = 1,
};

enum {
	OPAL_HMI_FLAGS_TB_RESYNC = 1ULL,
	OPAL_HMI_FLAGS_DEC_LOST = 2ULL,
	OPAL_HMI_FLAGS_HDEC_LOST = 4ULL,
	OPAL_HMI_FLAGS_TOD_TB_FAIL = 8ULL,
	OPAL_HMI_FLAGS_NEW_EVENT = 9223372036854775808ULL,
};

enum {
	OPAL_IMC_COUNTERS_NEST = 1,
	OPAL_IMC_COUNTERS_CORE = 2,
	OPAL_IMC_COUNTERS_TRACE = 3,
};

enum {
	OPAL_P7IOC_DIAG_TYPE_NONE = 0,
	OPAL_P7IOC_DIAG_TYPE_RGC = 1,
	OPAL_P7IOC_DIAG_TYPE_BI = 2,
	OPAL_P7IOC_DIAG_TYPE_CI = 3,
	OPAL_P7IOC_DIAG_TYPE_MISC = 4,
	OPAL_P7IOC_DIAG_TYPE_I2C = 5,
	OPAL_P7IOC_DIAG_TYPE_LAST = 6,
};

enum {
	OPAL_P7IOC_NUM_PEST_REGS = 128,
	OPAL_PHB3_NUM_PEST_REGS = 256,
	OPAL_PHB4_NUM_PEST_REGS = 512,
};

enum {
	OPAL_PCI_TCE_KILL_PAGES = 0,
	OPAL_PCI_TCE_KILL_PE = 1,
	OPAL_PCI_TCE_KILL_ALL = 2,
};

enum {
	OPAL_PHB_ERROR_DATA_TYPE_P7IOC = 1,
	OPAL_PHB_ERROR_DATA_TYPE_PHB3 = 2,
	OPAL_PHB_ERROR_DATA_TYPE_PHB4 = 3,
};

enum {
	OPAL_REBOOT_NORMAL = 0,
	OPAL_REBOOT_PLATFORM_ERROR = 1,
	OPAL_REBOOT_FULL_IPL = 2,
	OPAL_REBOOT_MPIPL = 3,
	OPAL_REBOOT_FAST = 4,
};

enum {
	OPAL_REINIT_CPUS_HILE_BE = 1,
	OPAL_REINIT_CPUS_HILE_LE = 2,
	OPAL_REINIT_CPUS_MMU_HASH = 4,
	OPAL_REINIT_CPUS_MMU_RADIX = 8,
	OPAL_REINIT_CPUS_TM_SUSPEND_DISABLED = 16,
};

enum {
	OPAL_XIVE_EQ_ENABLED = 1,
	OPAL_XIVE_EQ_ALWAYS_NOTIFY = 2,
	OPAL_XIVE_EQ_ESCALATE = 4,
};

enum {
	OPAL_XIVE_IRQ_TRIGGER_PAGE = 1,
	OPAL_XIVE_IRQ_STORE_EOI = 2,
	OPAL_XIVE_IRQ_LSI = 4,
	OPAL_XIVE_IRQ_SHIFT_BUG = 8,
	OPAL_XIVE_IRQ_MASK_VIA_FW = 16,
	OPAL_XIVE_IRQ_EOI_VIA_FW = 32,
	OPAL_XIVE_IRQ_STORE_EOI2 = 64,
};

enum {
	OPAL_XIVE_MODE_EMU = 0,
	OPAL_XIVE_MODE_EXPL = 1,
};

enum {
	OPAL_XIVE_VP_ENABLED = 1,
	OPAL_XIVE_VP_SINGLE_ESCALATION = 2,
};

enum {
	OPT_UID = 0,
	OPT_GID = 1,
	OPT_MODE = 2,
	OPT_DELEGATE_CMDS = 3,
	OPT_DELEGATE_MAPS = 4,
	OPT_DELEGATE_PROGS = 5,
	OPT_DELEGATE_ATTACHS = 6,
};

enum {
	Opt_bsd_df = 0,
	Opt_minix_df = 1,
	Opt_grpid = 2,
	Opt_nogrpid = 3,
	Opt_resgid = 4,
	Opt_resuid = 5,
	Opt_sb = 6,
	Opt_nouid32 = 7,
	Opt_debug = 8,
	Opt_removed = 9,
	Opt_user_xattr = 10,
	Opt_acl = 11,
	Opt_auto_da_alloc = 12,
	Opt_noauto_da_alloc = 13,
	Opt_noload = 14,
	Opt_commit = 15,
	Opt_min_batch_time = 16,
	Opt_max_batch_time = 17,
	Opt_journal_dev = 18,
	Opt_journal_path = 19,
	Opt_journal_checksum = 20,
	Opt_journal_async_commit = 21,
	Opt_abort = 22,
	Opt_data_journal = 23,
	Opt_data_ordered = 24,
	Opt_data_writeback = 25,
	Opt_data_err_abort = 26,
	Opt_data_err_ignore = 27,
	Opt_test_dummy_encryption = 28,
	Opt_inlinecrypt = 29,
	Opt_usrjquota = 30,
	Opt_grpjquota = 31,
	Opt_quota = 32,
	Opt_noquota = 33,
	Opt_barrier = 34,
	Opt_nobarrier = 35,
	Opt_err = 36,
	Opt_usrquota = 37,
	Opt_grpquota = 38,
	Opt_prjquota = 39,
	Opt_dax = 40,
	Opt_dax_always = 41,
	Opt_dax_inode = 42,
	Opt_dax_never = 43,
	Opt_stripe = 44,
	Opt_delalloc = 45,
	Opt_nodelalloc = 46,
	Opt_warn_on_error = 47,
	Opt_nowarn_on_error = 48,
	Opt_mblk_io_submit = 49,
	Opt_debug_want_extra_isize = 50,
	Opt_nomblk_io_submit = 51,
	Opt_block_validity = 52,
	Opt_noblock_validity = 53,
	Opt_inode_readahead_blks = 54,
	Opt_journal_ioprio = 55,
	Opt_dioread_nolock = 56,
	Opt_dioread_lock = 57,
	Opt_discard = 58,
	Opt_nodiscard = 59,
	Opt_init_itable = 60,
	Opt_noinit_itable = 61,
	Opt_max_dir_size_kb = 62,
	Opt_nojournal_checksum = 63,
	Opt_nombcache = 64,
	Opt_no_prefetch_block_bitmaps = 65,
	Opt_mb_optimize_scan = 66,
	Opt_errors = 67,
	Opt_data = 68,
	Opt_data_err = 69,
	Opt_jqfmt = 70,
	Opt_dax_type = 71,
};

enum {
	Opt_err___2 = 0,
	Opt_enc = 1,
	Opt_hash = 2,
};

enum {
	Opt_uid = 0,
	Opt_gid = 1,
	Opt_mode = 2,
};

enum {
	Opt_uid___2 = 0,
	Opt_gid___2 = 1,
	Opt_mode___2 = 2,
	Opt_ptmxmode = 3,
	Opt_newinstance = 4,
	Opt_max = 5,
	Opt_err___3 = 6,
};

enum {
	PADDRW = 0,
	PDATA = 4,
	PPMASK = 8,
	PADDRR = 12,
	PIDXLO = 16,
	PIDXHI = 20,
	PIDXDATA = 24,
	PIDXCTL = 28,
};

enum {
	PAGE_REPORTING_IDLE = 0,
	PAGE_REPORTING_REQUESTED = 1,
	PAGE_REPORTING_ACTIVE = 2,
};

enum {
	PAGE_WAS_MAPPED = 1,
	PAGE_WAS_MLOCKED = 2,
	PAGE_OLD_STATES = 3,
};

enum {
	PALMAS_EXT_CONTROL_ENABLE1 = 1,
	PALMAS_EXT_CONTROL_ENABLE2 = 2,
	PALMAS_EXT_CONTROL_NSLEEP = 4,
};

enum {
	PAPR_MISCDEV_IOC_ID = 178,
};

enum {
	PAPR_SYSPARM_MAX_INPUT = 1024,
	PAPR_SYSPARM_MAX_OUTPUT = 4000,
};

enum {
	PAUSE_RX = 1,
	PAUSE_TX = 2,
	PAUSE_AUTONEG = 4,
};

enum {
	PCI66 = 2,
	USE_DPLL = 1,
};

enum {
	PCI_REASSIGN_ALL_RSRC = 1,
	PCI_REASSIGN_ALL_BUS = 2,
	PCI_PROBE_ONLY = 4,
	PCI_CAN_SKIP_ISA_ALIGN = 8,
	PCI_ENABLE_PROC_DOMAINS = 16,
	PCI_COMPAT_DOMAIN_0 = 32,
	PCI_SCAN_ALL_PCIE_DEVS = 64,
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_IOV_RESOURCES = 7,
	PCI_IOV_RESOURCE_END = 12,
	PCI_BRIDGE_RESOURCES = 13,
	PCI_BRIDGE_RESOURCE_END = 16,
	PCI_NUM_RESOURCES = 17,
	DEVICE_COUNT_RESOURCE = 17,
};

enum {
	PCI_VARIANT_PCI = 0,
	PCI_VARIANT_PCIX_MODE1_PARITY = 1,
	PCI_VARIANT_PCIX_MODE1_ECC = 2,
	PCI_VARIANT_PCIX_266_MODE2 = 3,
	PCI_VARIANT_PCIE = 4,
};

enum {
	PDC_MAX_PORTS = 4,
	PDC_MMIO_BAR = 3,
	PDC_MAX_PRD = 127,
	PDC_INT_SEQMASK = 64,
	PDC_FLASH_CTL = 68,
	PDC_PCI_CTL = 72,
	PDC_SATA_PLUG_CSR = 108,
	PDC2_SATA_PLUG_CSR = 96,
	PDC_TBG_MODE = 1052,
	PDC_SLEW_CTL = 1136,
	PDC_FEATURE = 4,
	PDC_SECTOR_COUNT = 8,
	PDC_SECTOR_NUMBER = 12,
	PDC_CYLINDER_LOW = 16,
	PDC_CYLINDER_HIGH = 20,
	PDC_DEVICE = 24,
	PDC_COMMAND = 28,
	PDC_ALTSTATUS = 56,
	PDC_PKT_SUBMIT = 64,
	PDC_GLOBAL_CTL = 72,
	PDC_CTLSTAT = 96,
	PDC_SATA_ERROR = 4,
	PDC_PHYMODE4 = 20,
	PDC_LINK_LAYER_ERRORS = 108,
	PDC_FPDMA_CTLSTAT = 216,
	PDC_INTERNAL_DEBUG_1 = 248,
	PDC_INTERNAL_DEBUG_2 = 252,
	PDC_FPDMA_CTLSTAT_RESET = 8,
	PDC_FPDMA_CTLSTAT_DMASETUP_INT_FLAG = 1024,
	PDC_FPDMA_CTLSTAT_SETDB_INT_FLAG = 2048,
	PDC_PH_ERR = 256,
	PDC_SH_ERR = 512,
	PDC_DH_ERR = 1024,
	PDC2_HTO_ERR = 4096,
	PDC2_ATA_HBA_ERR = 8192,
	PDC2_ATA_DMA_CNT_ERR = 16384,
	PDC_OVERRUN_ERR = 524288,
	PDC_UNDERRUN_ERR = 1048576,
	PDC_DRIVE_ERR = 2097152,
	PDC_PCI_SYS_ERR = 4194304,
	PDC1_PCI_PARITY_ERR = 8388608,
	PDC1_ERR_MASK = 8388608,
	PDC2_ERR_MASK = 28672,
	PDC_ERR_MASK = 16283392,
	board_2037x = 0,
	board_2037x_pata = 1,
	board_20319 = 2,
	board_20619 = 3,
	board_2057x = 4,
	board_2057x_pata = 5,
	board_40518 = 6,
	PDC_HAS_PATA = 2,
	PDC_SEQCNTRL_INT_MASK = 32,
	PDC_FEATURE_ATAPI_PIO = 0,
	PDC_FEATURE_ATAPI_DMA = 1,
	PDC_DEVICE_SATA = 224,
	PDC_DMA_ENABLE = 128,
	PDC_IRQ_DISABLE = 1024,
	PDC_RESET = 2048,
	PDC_COMMON_FLAGS = 512,
	PDC_FLAG_GEN_II = 16777216,
	PDC_FLAG_SATA_PATA = 33554432,
	PDC_FLAG_4_PORTS = 67108864,
};

enum {
	PDC_MMIO_BAR___2 = 5,
	PDC_UDMA_100 = 0,
	PDC_UDMA_133 = 1,
	PDC_100_MHZ = 100000000,
	PDC_133_MHZ = 133333333,
	PDC_SYS_CTL = 4352,
	PDC_ATA_CTL = 4356,
	PDC_GLOBAL_CTL___2 = 4360,
	PDC_CTCR0 = 4364,
	PDC_CTCR1 = 4368,
	PDC_BYTE_COUNT = 4384,
	PDC_PLL_CTL = 4610,
};

enum {
	PDC_MMIO_BAR___3 = 3,
	PDC_DIMM_BAR = 4,
	PDC_PRD_TBL = 68,
	PDC_PKT_SUBMIT___2 = 64,
	PDC_HDMA_PKT_SUBMIT = 256,
	PDC_INT_SEQMASK___2 = 64,
	PDC_HDMA_CTLSTAT = 300,
	PDC_CTLSTAT___2 = 96,
	PDC_20621_SEQCTL = 1024,
	PDC_20621_SEQMASK = 1152,
	PDC_20621_GENERAL_CTL = 1156,
	PDC_20621_PAGE_SIZE = 32768,
	PDC_20621_DIMM_WINDOW = 12,
	PDC_20621_DIMM_BASE = 2097152,
	PDC_20621_DIMM_DATA = 65536,
	PDC_DIMM_DATA_STEP = 262144,
	PDC_DIMM_WINDOW_STEP = 8192,
	PDC_DIMM_HOST_PRD = 6144,
	PDC_DIMM_HOST_PKT = 0,
	PDC_DIMM_HPKT_PRD = 128,
	PDC_DIMM_ATA_PKT = 256,
	PDC_DIMM_APKT_PRD = 384,
	PDC_DIMM_HEADER_SZ = 512,
	PDC_PAGE_WINDOW = 64,
	PDC_PAGE_DATA = 66,
	PDC_PAGE_SET = 8,
	PDC_CHIP0_OFS = 786432,
	PDC_20621_ERR_MASK = 16252928,
	board_20621 = 0,
	PDC_MASK_INT = 1024,
	PDC_RESET___2 = 2048,
	PDC_DMA_ENABLE___2 = 128,
	PDC_MAX_HDMA = 32,
	PDC_HDMA_Q_MASK = 31,
	PDC_DIMM0_SPD_DEV_ADDRESS = 80,
	PDC_DIMM1_SPD_DEV_ADDRESS = 81,
	PDC_I2C_CONTROL = 72,
	PDC_I2C_ADDR_DATA = 76,
	PDC_DIMM0_CONTROL = 128,
	PDC_DIMM1_CONTROL = 132,
	PDC_SDRAM_CONTROL = 136,
	PDC_I2C_WRITE = 0,
	PDC_I2C_READ = 64,
	PDC_I2C_START = 128,
	PDC_I2C_MASK_INT = 32,
	PDC_I2C_COMPLETE = 65536,
	PDC_I2C_NO_ACK = 1048576,
	PDC_DIMM_SPD_SUBADDRESS_START = 0,
	PDC_DIMM_SPD_SUBADDRESS_END = 127,
	PDC_DIMM_SPD_ROW_NUM = 3,
	PDC_DIMM_SPD_COLUMN_NUM = 4,
	PDC_DIMM_SPD_MODULE_ROW = 5,
	PDC_DIMM_SPD_TYPE = 11,
	PDC_DIMM_SPD_FRESH_RATE = 12,
	PDC_DIMM_SPD_BANK_NUM = 17,
	PDC_DIMM_SPD_CAS_LATENCY = 18,
	PDC_DIMM_SPD_ATTRIBUTE = 21,
	PDC_DIMM_SPD_ROW_PRE_CHARGE = 27,
	PDC_DIMM_SPD_ROW_ACTIVE_DELAY = 28,
	PDC_DIMM_SPD_RAS_CAS_DELAY = 29,
	PDC_DIMM_SPD_ACTIVE_PRECHARGE = 30,
	PDC_DIMM_SPD_SYSTEM_FREQ = 126,
	PDC_CTL_STATUS = 8,
	PDC_DIMM_WINDOW_CTLR = 12,
	PDC_TIME_CONTROL = 60,
	PDC_TIME_PERIOD = 64,
	PDC_TIME_COUNTER = 68,
	PDC_GENERAL_CTLR = 1156,
	PCI_PLL_INIT = 2320701476,
	PCI_X_TCOUNT = 3994967295,
	PDC_TIMER_BUZZER = 1024,
	PDC_TIMER_MODE_PERIODIC = 0,
	PDC_TIMER_MODE_ONCE = 256,
	PDC_TIMER_ENABLE = 128,
	PDC_TIMER_MASK_INT = 32,
	PDC_TIMER_SEQ_MASK = 31,
	PDC_TIMER_DEFAULT = 416,
};

enum {
	PERCPU_REF_INIT_ATOMIC = 1,
	PERCPU_REF_INIT_DEAD = 2,
	PERCPU_REF_ALLOW_REINIT = 4,
};

enum {
	PER_LINUX = 0,
	PER_LINUX_32BIT = 8388608,
	PER_LINUX_FDPIC = 524288,
	PER_SVR4 = 68157441,
	PER_SVR3 = 83886082,
	PER_SCOSVR3 = 117440515,
	PER_OSR5 = 100663299,
	PER_WYSEV386 = 83886084,
	PER_ISCR4 = 67108869,
	PER_BSD = 6,
	PER_SUNOS = 67108870,
	PER_XENIX = 83886087,
	PER_LINUX32 = 8,
	PER_LINUX32_3GB = 134217736,
	PER_IRIX32 = 67108873,
	PER_IRIXN32 = 67108874,
	PER_IRIX64 = 67108875,
	PER_RISCOS = 12,
	PER_SOLARIS = 67108877,
	PER_UW7 = 68157454,
	PER_OSF4 = 15,
	PER_HPUX = 16,
	PER_MASK = 255,
};

enum {
	PIIX_IOCFG = 84,
	ICH5_PMR = 144,
	ICH5_PCS = 146,
	PIIX_SIDPR_BAR = 5,
	PIIX_SIDPR_LEN = 16,
	PIIX_SIDPR_IDX = 0,
	PIIX_SIDPR_DATA = 4,
	PIIX_FLAG_CHECKINTR = 268435456,
	PIIX_FLAG_SIDPR = 536870912,
	PIIX_PATA_FLAGS = 1,
	PIIX_SATA_FLAGS = 268435458,
	PIIX_FLAG_PIO16 = 1073741824,
	PIIX_80C_PRI = 48,
	PIIX_80C_SEC = 192,
	P0 = 0,
	P1 = 1,
	P2 = 2,
	P3 = 3,
	IDE = -1,
	NA = -2,
	RV = -3,
	PIIX_AHCI_DEVICE = 6,
	PIIX_HOST_BROKEN_SUSPEND = 16777216,
};

enum {
	PIM_TYPE_HELLO = 0,
	PIM_TYPE_REGISTER = 1,
	PIM_TYPE_REGISTER_STOP = 2,
	PIM_TYPE_JOIN_PRUNE = 3,
	PIM_TYPE_BOOTSTRAP = 4,
	PIM_TYPE_ASSERT = 5,
	PIM_TYPE_GRAFT = 6,
	PIM_TYPE_GRAFT_ACK = 7,
	PIM_TYPE_CANDIDATE_RP_ADV = 8,
};

enum {
	PINCONF_BIAS = 0,
	PINCONF_SCHMITT = 1,
	PINCONF_DRIVE_STRENGTH = 2,
};

enum {
	PLAT8250_DEV_LEGACY = -1,
	PLAT8250_DEV_PLATFORM = 0,
	PLAT8250_DEV_PLATFORM1 = 1,
	PLAT8250_DEV_PLATFORM2 = 2,
	PLAT8250_DEV_FOURPORT = 3,
	PLAT8250_DEV_ACCENT = 4,
	PLAT8250_DEV_BOCA = 5,
	PLAT8250_DEV_EXAR_ST16C554 = 6,
	PLAT8250_DEV_HUB6 = 7,
	PLAT8250_DEV_AU1X00 = 8,
	PLAT8250_DEV_SM501 = 9,
};

enum {
	PM8607_IRQ_ONKEY = 0,
	PM8607_IRQ_EXTON = 1,
	PM8607_IRQ_CHG = 2,
	PM8607_IRQ_BAT = 3,
	PM8607_IRQ_RTC = 4,
	PM8607_IRQ_CC = 5,
	PM8607_IRQ_VBAT = 6,
	PM8607_IRQ_VCHG = 7,
	PM8607_IRQ_VSYS = 8,
	PM8607_IRQ_TINT = 9,
	PM8607_IRQ_GPADC0 = 10,
	PM8607_IRQ_GPADC1 = 11,
	PM8607_IRQ_GPADC2 = 12,
	PM8607_IRQ_GPADC3 = 13,
	PM8607_IRQ_AUDIO_SHORT = 14,
	PM8607_IRQ_PEN = 15,
	PM8607_IRQ_HEADSET = 16,
	PM8607_IRQ_HOOK = 17,
	PM8607_IRQ_MICIN = 18,
	PM8607_IRQ_CHG_FAIL = 19,
	PM8607_IRQ_CHG_DONE = 20,
	PM8607_IRQ_CHG_FAULT = 21,
};

enum {
	PMCRAID_AEN_ATTR_UNSPEC = 0,
	PMCRAID_AEN_ATTR_EVENT = 1,
	__PMCRAID_AEN_ATTR_MAX = 2,
};

enum {
	PMCRAID_AEN_CMD_UNSPEC = 0,
	PMCRAID_AEN_CMD_EVENT = 1,
	__PMCRAID_AEN_CMD_MAX = 2,
};

enum {
	PM_BR_CMPL = 315486,
};

enum {
	PM_BR_FIN = 192586,
};

enum {
	PM_BR_MPRED_CMPL = 262390,
};

enum {
	PM_CYC = 393460,
};

enum {
	PM_CYC___2 = 30,
	PM_GCT_NOSLOT_CYC = 65784,
	PM_CMPLU_STALL = 262154,
	PM_INST_CMPL = 2,
	PM_BRU_FIN = 65640,
	PM_BR_MPRED_CMPL___2 = 262390,
	PM_LD_REF_L1 = 65774,
	PM_LD_MISS_L1 = 254036,
	PM_ST_MISS_L1 = 196848,
	PM_L1_PREF = 55480,
	PM_INST_FROM_L1 = 16512,
	PM_L1_ICACHE_MISS = 131325,
	PM_L1_DEMAND_WRITE = 16524,
	PM_IC_PREF_WRITE = 16526,
	PM_DATA_FROM_L3 = 311362,
	PM_DATA_FROM_L3MISS = 196862,
	PM_L2_ST = 94336,
	PM_L2_ST_MISS = 94338,
	PM_L3_PREF_ALL = 319570,
	PM_DTLB_MISS = 196860,
	PM_ITLB_MISS = 262396,
	PM_RUN_INST_CMPL = 327930,
	PM_RUN_INST_CMPL_ALT = 262394,
	PM_RUN_CYC = 393460,
	PM_RUN_CYC_ALT = 131316,
	PM_MRK_ST_CMPL = 65844,
	PM_MRK_ST_CMPL_ALT = 197090,
	PM_BR_MRK_2PATH = 65848,
	PM_BR_MRK_2PATH_ALT = 262456,
	PM_L3_CO_MEPF = 98434,
	PM_L3_CO_MEPF_ALT = 254046,
	PM_MRK_DATA_FROM_L2MISS = 119118,
	PM_MRK_DATA_FROM_L2MISS_ALT = 262632,
	PM_CMPLU_STALL_ALT = 122964,
	PM_BR_2PATH = 131126,
	PM_BR_2PATH_ALT = 262198,
	PM_INST_DISP = 131314,
	PM_INST_DISP_ALT = 196850,
	PM_MRK_FILT_MATCH = 131388,
	PM_MRK_FILT_MATCH_ALT = 196910,
	PM_LD_MISS_L1_ALT = 262384,
	MEM_ACCESS = 17039840,
};

enum {
	PM_CYC___3 = 30ULL,
	PM_ICT_NOSLOT_CYC = 65784ULL,
	PM_CMPLU_STALL___2 = 122964ULL,
	PM_INST_CMPL___2 = 2ULL,
	PM_BR_CMPL___2 = 315486ULL,
	PM_BR_MPRED_CMPL___3 = 262390ULL,
	PM_LD_REF_L1___2 = 65788ULL,
	PM_LD_MISS_L1_FIN = 180302ULL,
	PM_LD_MISS_L1___2 = 254036ULL,
	PM_LD_MISS_L1_ALT___2 = 262384ULL,
	PM_ST_MISS_L1___2 = 196848ULL,
	PM_L1_PREF___2 = 131156ULL,
	PM_INST_FROM_L1___2 = 16512ULL,
	PM_L1_ICACHE_MISS___2 = 131325ULL,
	PM_L1_DEMAND_WRITE___2 = 16524ULL,
	PM_IC_PREF_WRITE___2 = 18572ULL,
	PM_DATA_FROM_L3___2 = 311362ULL,
	PM_DATA_FROM_L3MISS___2 = 196862ULL,
	PM_L2_ST___2 = 92288ULL,
	PM_L2_ST_MISS___2 = 157824ULL,
	PM_L3_PREF_ALL___2 = 319570ULL,
	PM_DTLB_MISS___2 = 196860ULL,
	PM_ITLB_MISS___2 = 262396ULL,
	PM_RUN_INST_CMPL___2 = 327930ULL,
	PM_RUN_INST_CMPL_ALT___2 = 262394ULL,
	PM_RUN_CYC___2 = 393460ULL,
	PM_RUN_CYC_ALT___2 = 131316ULL,
	PM_INST_DISP___2 = 131314ULL,
	PM_INST_DISP_ALT___2 = 196850ULL,
	PM_BR_2PATH___2 = 131126ULL,
	PM_BR_2PATH_ALT___2 = 262198ULL,
	PM_MRK_ST_DONE_L2 = 65844ULL,
	PM_RADIX_PWC_L1_HIT = 127062ULL,
	PM_FLOP_CMPL = 65780ULL,
	PM_MRK_NTF_FIN = 131346ULL,
	PM_RADIX_PWC_L2_HIT = 184356ULL,
	PM_IFETCH_THROTTLE = 213086ULL,
	PM_MRK_L2_TM_ST_ABORT_SISTER = 254300ULL,
	PM_RADIX_PWC_L3_HIT = 258134ULL,
	PM_RUN_CYC_SMT2_MODE = 196716ULL,
	PM_TM_TX_PASS_RUN_INST = 319508ULL,
	PM_DISP_HELD_SYNC_HOLD = 262204ULL,
	PM_DTLB_MISS_16G = 114776ULL,
	PM_DERAT_MISS_2M = 114778ULL,
	PM_DTLB_MISS_2M = 114780ULL,
	PM_MRK_DTLB_MISS_1G = 119132ULL,
	PM_DTLB_MISS_4K = 180310ULL,
	PM_DERAT_MISS_1G = 180314ULL,
	PM_MRK_DERAT_MISS_2M = 184658ULL,
	PM_MRK_DTLB_MISS_4K = 184662ULL,
	PM_MRK_DTLB_MISS_16G = 184670ULL,
	PM_DTLB_MISS_64K = 245846ULL,
	PM_MRK_DERAT_MISS_1G = 250194ULL,
	PM_MRK_DTLB_MISS_64K = 250198ULL,
	PM_DTLB_MISS_16M = 311382ULL,
	PM_DTLB_MISS_1G = 311386ULL,
	PM_MRK_DTLB_MISS_16M = 311646ULL,
	MEM_LOADS___2 = 224210977248ULL,
	MEM_STORES___2 = 224345194976ULL,
};

enum {
	PM_CYC_ALT = 30,
};

enum {
	PM_CYC_ALT___2 = 65776,
	PM_CYC_INST_CMPL = 65778,
	PM_FLOP_CMPL___2 = 65780,
	PM_L1_ITLB_MISS = 65782,
	PM_NO_INST_AVAIL = 65784,
	PM_LD_CMPL = 65788,
	PM_INST_CMPL_ALT = 65790,
	PM_ST_CMPL = 131312,
	PM_INST_DISP___3 = 131314,
	PM_RUN_CYC___3 = 131316,
	PM_L1_DTLB_RELOAD = 131318,
	PM_BR_TAKEN_CMPL = 131322,
	PM_L1_ICACHE_MISS___3 = 131324,
	PM_L1_RELOAD_FROM_MEM = 131326,
	PM_ST_MISS_L1___3 = 196848,
	PM_INST_DISP_ALT___3 = 196850,
	PM_BR_MISPREDICT = 196854,
	PM_DTLB_MISS___3 = 196860,
	PM_DATA_FROM_L3MISS___3 = 196862,
	PM_LD_MISS_L1___3 = 262384,
	PM_CYC_INST_DISP = 262386,
	PM_BR_MPRED_CMPL___4 = 262390,
	PM_RUN_INST_CMPL___3 = 262394,
	PM_ITLB_MISS___3 = 262396,
	PM_LD_NOT_CACHED = 262398,
	PM_INST_CMPL___3 = 327930,
	PM_CYC___4 = 393460,
};

enum {
	PM_DATA_FROM_L3___3 = 5418393301794880ULL,
};

enum {
	PM_DATA_FROM_L3MISS___4 = 196862,
};

enum {
	PM_DTLB_MISS___4 = 196860,
};

enum {
	PM_IC_DEMAND_L2_BR_ALL = 18584,
	PM_GCT_UTIL_7_TO_10_SLOTS = 8352,
	PM_PMC2_SAVED = 65570,
	PM_CMPLU_STALL_DFU = 131132,
	PM_VSU0_16FLOP = 41124,
	PM_MRK_LSU_DERAT_MISS = 249946,
	PM_MRK_ST_CMPL___2 = 65588,
	PM_NEST_PAIR3_ADD = 264321,
	PM_L2_ST_DISP = 287104,
	PM_L2_CASTOUT_MOD = 90496,
	PM_ISEG = 8356,
	PM_MRK_INST_TIMEO = 262196,
	PM_L2_RCST_DISP_FAIL_ADDR = 221826,
	PM_LSU1_DC_PREF_STREAM_CONFIRM = 53430,
	PM_IERAT_WR_64K = 16574,
	PM_MRK_DTLB_MISS_16M___2 = 315486,
	PM_IERAT_MISS = 65782,
	PM_MRK_PTEG_FROM_LMEM = 315474,
	PM_FLOP = 65780,
	PM_THRD_PRIO_4_5_CYC = 16564,
	PM_BR_PRED_TA = 16554,
	PM_CMPLU_STALL_FXU = 131092,
	PM_EXT_INT = 131320,
	PM_VSU_FSQRT_FDIV = 43144,
	PM_MRK_LD_MISS_EXPOSED_CYC = 65598,
	PM_LSU1_LDF = 49286,
	PM_IC_WRITE_ALL = 18572,
	PM_LSU0_SRQ_STFWD = 49312,
	PM_PTEG_FROM_RL2L3_MOD = 114770,
	PM_MRK_DATA_FROM_L31_SHR = 118862,
	PM_DATA_FROM_L21_MOD = 245830,
	PM_VSU1_SCAL_DOUBLE_ISSUED = 45194,
	PM_VSU0_8FLOP = 41120,
	PM_POWER_EVENT1 = 65646,
	PM_DISP_CLB_HELD_BAL = 8338,
	PM_VSU1_2FLOP = 41114,
	PM_LWSYNC_HELD = 8346,
	PM_PTEG_FROM_DL2L3_SHR = 245844,
	PM_INST_FROM_L21_MOD = 213062,
	PM_IERAT_XLATE_WR_16MPLUS = 16572,
	PM_IC_REQ_ALL = 18568,
	PM_DSLB_MISS = 53392,
	PM_L3_MISS = 127106,
	PM_LSU0_L1_PREF = 53432,
	PM_VSU_SCALAR_SINGLE_ISSUED = 47236,
	PM_LSU1_DC_PREF_STREAM_CONFIRM_STRIDE = 53438,
	PM_L2_INST = 221312,
	PM_VSU0_FRSP = 41140,
	PM_FLUSH_DISP = 8322,
	PM_PTEG_FROM_L2MISS = 311384,
	PM_VSU1_DQ_ISSUED = 45210,
	PM_CMPLU_STALL_LSU = 131090,
	PM_MRK_DATA_FROM_DMEM = 118858,
	PM_LSU_FLUSH_ULD = 51376,
	PM_PTEG_FROM_LMEM = 311378,
	PM_MRK_DERAT_MISS_16M = 249948,
	PM_THRD_ALL_RUN_CYC = 131084,
	PM_MEM0_PREFETCH_DISP = 131203,
	PM_MRK_STALL_CMPLU_CYC_COUNT = 196671,
	PM_DATA_FROM_DL2L3_MOD = 245836,
	PM_VSU_FRSP = 43188,
	PM_MRK_DATA_FROM_L21_MOD = 249926,
	PM_PMC1_OVERFLOW = 131088,
	PM_VSU0_SINGLE = 41128,
	PM_MRK_PTEG_FROM_L3MISS = 184408,
	PM_MRK_PTEG_FROM_L31_SHR = 184406,
	PM_VSU0_VECTOR_SP_ISSUED = 45200,
	PM_VSU1_FEST = 41146,
	PM_MRK_INST_DISP = 131120,
	PM_VSU0_COMPLEX_ISSUED = 45206,
	PM_LSU1_FLUSH_UST = 49334,
	PM_INST_CMPL___4 = 2,
	PM_FXU_IDLE = 65550,
	PM_LSU0_FLUSH_ULD = 49328,
	PM_MRK_DATA_FROM_DL2L3_MOD = 249932,
	PM_LSU_LMQ_SRQ_EMPTY_ALL_CYC = 196636,
	PM_LSU1_REJECT_LMQ_FULL = 49318,
	PM_INST_PTEG_FROM_L21_MOD = 254038,
	PM_INST_FROM_RL2L3_MOD = 81986,
	PM_SHL_CREATED = 20610,
	PM_L2_ST_HIT = 287106,
	PM_DATA_FROM_DMEM = 114762,
	PM_L3_LD_MISS = 192642,
	PM_FXU1_BUSY_FXU0_IDLE = 262158,
	PM_DISP_CLB_HELD_RES = 8340,
	PM_L2_SN_SX_I_DONE = 222082,
	PM_GRP_CMPL = 196612,
	PM_STCX_CMPL = 49304,
	PM_VSU0_2FLOP = 41112,
	PM_L3_PREF_MISS = 258178,
	PM_LSU_SRQ_SYNC_CYC = 53398,
	PM_LSU_REJECT_ERAT_MISS = 131172,
	PM_L1_ICACHE_MISS___4 = 131324,
	PM_LSU1_FLUSH_SRQ = 49342,
	PM_LD_REF_L1_LSU0 = 49280,
	PM_VSU0_FEST = 41144,
	PM_VSU_VECTOR_SINGLE_ISSUED = 47248,
	PM_FREQ_UP = 262156,
	PM_DATA_FROM_LMEM = 245834,
	PM_LSU1_LDX = 49290,
	PM_PMC3_OVERFLOW = 262160,
	PM_MRK_BR_MPRED = 196662,
	PM_SHL_MATCH = 20614,
	PM_MRK_BR_TAKEN = 65590,
	PM_CMPLU_STALL_BRU = 262222,
	PM_ISLB_MISS = 53394,
	PM_CYC___5 = 30,
	PM_DISP_HELD_THERMAL = 196614,
	PM_INST_PTEG_FROM_RL2L3_SHR = 188500,
	PM_LSU1_SRQ_STFWD = 49314,
	PM_GCT_NOSLOT_BR_MPRED = 262170,
	PM_1PLUS_PPC_CMPL = 65778,
	PM_PTEG_FROM_DMEM = 180306,
	PM_VSU_2FLOP = 43160,
	PM_GCT_FULL_CYC = 16518,
	PM_MRK_DATA_FROM_L3_CYC = 262176,
	PM_LSU_SRQ_S0_ALLOC = 53405,
	PM_MRK_DERAT_MISS_4K = 118876,
	PM_BR_MPRED_TA = 16558,
	PM_INST_PTEG_FROM_L2MISS = 319576,
	PM_DPU_HELD_POWER = 131078,
	PM_RUN_INST_CMPL___4 = 262394,
	PM_MRK_VSU_FIN = 196658,
	PM_LSU_SRQ_S0_VALID = 53404,
	PM_GCT_EMPTY_CYC = 131080,
	PM_IOPS_DISP = 196628,
	PM_RUN_SPURR = 65544,
	PM_PTEG_FROM_L21_MOD = 245846,
	PM_VSU0_1FLOP = 41088,
	PM_SNOOP_TLBIE = 53426,
	PM_DATA_FROM_L3MISS___5 = 180296,
	PM_VSU_SINGLE = 43176,
	PM_DTLB_MISS_16G___2 = 114782,
	PM_CMPLU_STALL_VECTOR = 131100,
	PM_FLUSH = 262392,
	PM_L2_LD_HIT = 221570,
	PM_NEST_PAIR2_AND = 198787,
	PM_VSU1_1FLOP = 41090,
	PM_IC_PREF_REQ = 16522,
	PM_L3_LD_HIT = 192640,
	PM_GCT_NOSLOT_IC_MISS = 131098,
	PM_DISP_HELD = 65542,
	PM_L2_LD = 90240,
	PM_LSU_FLUSH_SRQ = 51388,
	PM_BC_PLUS_8_CONV = 16568,
	PM_MRK_DATA_FROM_L31_MOD_CYC = 262182,
	PM_CMPLU_STALL_VECTOR_LONG = 262218,
	PM_L2_RCST_BUSY_RC_FULL = 156290,
	PM_TB_BIT_TRANS = 196856,
	PM_THERMAL_MAX = 262150,
	PM_LSU1_FLUSH_ULD = 49330,
	PM_LSU1_REJECT_LHS = 49326,
	PM_LSU_LRQ_S0_ALLOC = 53407,
	PM_L3_CO_L31 = 323712,
	PM_POWER_EVENT4 = 262254,
	PM_DATA_FROM_L31_SHR = 114766,
	PM_BR_UNCOND = 16542,
	PM_LSU1_DC_PREF_STREAM_ALLOC = 53418,
	PM_PMC4_REWIND = 65568,
	PM_L2_RCLD_DISP = 90752,
	PM_THRD_PRIO_2_3_CYC = 16562,
	PM_MRK_PTEG_FROM_L2MISS = 315480,
	PM_IC_DEMAND_L2_BHT_REDIRECT = 16536,
	PM_LSU_DERAT_MISS = 131318,
	PM_IC_PREF_CANCEL_L2 = 16532,
	PM_MRK_FIN_STALL_CYC_COUNT = 65597,
	PM_BR_PRED_CCACHE = 16544,
	PM_GCT_UTIL_1_TO_2_SLOTS = 8348,
	PM_MRK_ST_CMPL_INT = 196660,
	PM_LSU_TWO_TABLEWALK_CYC = 53414,
	PM_MRK_DATA_FROM_L3MISS = 184392,
	PM_GCT_NOSLOT_CYC___2 = 65784,
	PM_LSU_SET_MPRED = 49320,
	PM_FLUSH_DISP_TLBIE = 8330,
	PM_VSU1_FCONV = 41138,
	PM_DERAT_MISS_16G = 311388,
	PM_INST_FROM_LMEM = 213066,
	PM_IC_DEMAND_L2_BR_REDIRECT = 16538,
	PM_CMPLU_STALL_SCALAR_LONG = 131096,
	PM_INST_PTEG_FROM_L2 = 122960,
	PM_PTEG_FROM_L2 = 114768,
	PM_MRK_DATA_FROM_L21_SHR_CYC = 131108,
	PM_MRK_DTLB_MISS_4K___2 = 184410,
	PM_VSU0_FPSCR = 45212,
	PM_VSU1_VECT_DOUBLE_ISSUED = 45186,
	PM_MRK_PTEG_FROM_RL2L3_MOD = 118866,
	PM_MEM0_RQ_DISP = 65667,
	PM_L2_LD_MISS = 155776,
	PM_VMX_RESULT_SAT_1 = 45216,
	PM_L1_PREF___3 = 55480,
	PM_MRK_DATA_FROM_LMEM_CYC = 131116,
	PM_GRP_IC_MISS_NONSPEC = 65548,
	PM_PB_NODE_PUMP = 65665,
	PM_SHL_MERGED = 20612,
	PM_NEST_PAIR1_ADD = 133249,
	PM_DATA_FROM_L3___4 = 114760,
	PM_LSU_FLUSH = 8334,
	PM_LSU_SRQ_SYNC_COUNT = 53399,
	PM_PMC2_OVERFLOW = 196624,
	PM_LSU_LDF = 51332,
	PM_POWER_EVENT3 = 196718,
	PM_DISP_WT = 196616,
	PM_CMPLU_STALL_REJECT = 262166,
	PM_IC_BANK_CONFLICT = 16514,
	PM_BR_MPRED_CR_TA = 18606,
	PM_L2_INST_MISS = 221314,
	PM_CMPLU_STALL_ERAT_MISS = 262168,
	PM_NEST_PAIR2_ADD = 198785,
	PM_MRK_LSU_FLUSH = 53388,
	PM_L2_LDST = 92288,
	PM_INST_FROM_L31_SHR = 81998,
	PM_VSU0_FIN = 41148,
	PM_LARX_LSU = 51348,
	PM_INST_FROM_RMEM = 213058,
	PM_DISP_CLB_HELD_TLBIE = 8342,
	PM_MRK_DATA_FROM_DMEM_CYC = 131118,
	PM_BR_PRED_CR = 16552,
	PM_LSU_REJECT = 65636,
	PM_GCT_UTIL_3_TO_6_SLOTS = 8350,
	PM_CMPLU_STALL_END_GCT_NOSLOT = 65576,
	PM_LSU0_REJECT_LMQ_FULL = 49316,
	PM_VSU_FEST = 43192,
	PM_NEST_PAIR0_AND = 67715,
	PM_PTEG_FROM_L3 = 180304,
	PM_POWER_EVENT2 = 131182,
	PM_IC_PREF_CANCEL_PAGE = 16528,
	PM_VSU0_FSQRT_FDIV = 41096,
	PM_MRK_GRP_CMPL = 262192,
	PM_VSU0_SCAL_DOUBLE_ISSUED = 45192,
	PM_GRP_DISP = 196618,
	PM_LSU0_LDX = 49288,
	PM_DATA_FROM_L2 = 114752,
	PM_MRK_DATA_FROM_RL2L3_MOD = 118850,
	PM_LD_REF_L1___3 = 51328,
	PM_VSU0_VECT_DOUBLE_ISSUED = 45184,
	PM_VSU1_2FLOP_DOUBLE = 41102,
	PM_THRD_PRIO_6_7_CYC = 16566,
	PM_BC_PLUS_8_RSLV_TAKEN = 16570,
	PM_BR_MPRED_CR = 16556,
	PM_L3_CO_MEM = 323714,
	PM_LD_MISS_L1___4 = 262384,
	PM_DATA_FROM_RL2L3_MOD = 114754,
	PM_LSU_SRQ_FULL_CYC = 65562,
	PM_TABLEWALK_CYC = 65574,
	PM_MRK_PTEG_FROM_RMEM = 249938,
	PM_LSU_SRQ_STFWD = 51360,
	PM_INST_PTEG_FROM_RMEM = 254034,
	PM_FXU0_FIN = 65540,
	PM_LSU1_L1_SW_PREF = 49310,
	PM_PTEG_FROM_L31_MOD = 114772,
	PM_PMC5_OVERFLOW = 65572,
	PM_LD_REF_L1_LSU1 = 49282,
	PM_INST_PTEG_FROM_L21_SHR = 319574,
	PM_CMPLU_STALL_THRD = 65564,
	PM_DATA_FROM_RMEM = 245826,
	PM_VSU0_SCAL_SINGLE_ISSUED = 45188,
	PM_BR_MPRED_LSTACK = 16550,
	PM_MRK_DATA_FROM_RL2L3_MOD_CYC = 262184,
	PM_LSU0_FLUSH_UST = 49332,
	PM_LSU_NCST = 49296,
	PM_BR_TAKEN = 131076,
	PM_INST_PTEG_FROM_LMEM = 319570,
	PM_GCT_NOSLOT_BR_MPRED_IC_MISS = 262172,
	PM_DTLB_MISS_4K___2 = 180314,
	PM_PMC4_SAVED = 196642,
	PM_VSU1_PERMUTE_ISSUED = 45202,
	PM_SLB_MISS = 55440,
	PM_LSU1_FLUSH_LRQ = 49338,
	PM_DTLB_MISS___5 = 196860,
	PM_VSU1_FRSP = 41142,
	PM_VSU_VECTOR_DOUBLE_ISSUED = 47232,
	PM_L2_CASTOUT_SHR = 90498,
	PM_DATA_FROM_DL2L3_SHR = 245828,
	PM_VSU1_STF = 45198,
	PM_ST_FIN = 131312,
	PM_PTEG_FROM_L21_SHR = 311382,
	PM_L2_LOC_GUESS_WRONG = 156800,
	PM_MRK_STCX_FAIL = 53390,
	PM_LSU0_REJECT_LHS = 49324,
	PM_IC_PREF_CANCEL_HIT = 16530,
	PM_L3_PREF_BUSY = 323712,
	PM_MRK_BRU_FIN = 131130,
	PM_LSU1_NCLD = 49294,
	PM_INST_PTEG_FROM_L31_MOD = 122964,
	PM_LSU_NCLD = 51340,
	PM_LSU_LDX = 51336,
	PM_L2_LOC_GUESS_CORRECT = 91264,
	PM_THRESH_TIMEO = 65592,
	PM_L3_PREF_ST = 53422,
	PM_DISP_CLB_HELD_SYNC = 8344,
	PM_VSU_SIMPLE_ISSUED = 47252,
	PM_VSU1_SINGLE = 41130,
	PM_DATA_TABLEWALK_CYC = 196634,
	PM_L2_RC_ST_DONE = 222080,
	PM_MRK_PTEG_FROM_L21_MOD = 249942,
	PM_LARX_LSU1 = 49302,
	PM_MRK_DATA_FROM_RMEM = 249922,
	PM_DISP_CLB_HELD = 8336,
	PM_DERAT_MISS_4K = 114780,
	PM_L2_RCLD_DISP_FAIL_ADDR = 90754,
	PM_SEG_EXCEPTION = 10404,
	PM_FLUSH_DISP_SB = 8332,
	PM_L2_DC_INV = 156034,
	PM_PTEG_FROM_DL2L3_MOD = 311380,
	PM_DSEG = 8358,
	PM_BR_PRED_LSTACK = 16546,
	PM_VSU0_STF = 45196,
	PM_LSU_FX_FIN = 65638,
	PM_DERAT_MISS_16M = 245852,
	PM_MRK_PTEG_FROM_DL2L3_MOD = 315476,
	PM_GCT_UTIL_11_PLUS_SLOTS = 8354,
	PM_INST_FROM_L3 = 81992,
	PM_MRK_IFU_FIN = 196666,
	PM_ITLB_MISS___4 = 262396,
	PM_VSU_STF = 47244,
	PM_LSU_FLUSH_UST = 51380,
	PM_L2_LDST_MISS = 157824,
	PM_FXU1_FIN = 262148,
	PM_SHL_DEALLOCATED = 20608,
	PM_L2_SN_M_WR_DONE = 287618,
	PM_LSU_REJECT_SET_MPRED = 51368,
	PM_L3_PREF_LD = 53420,
	PM_L2_SN_M_RD_DONE = 287616,
	PM_MRK_DERAT_MISS_16G = 315484,
	PM_VSU_FCONV = 43184,
	PM_ANY_THRD_RUN_CYC = 65786,
	PM_LSU_LMQ_FULL_CYC = 53412,
	PM_MRK_LSU_REJECT_LHS = 53378,
	PM_MRK_LD_MISS_L1_CYC = 262206,
	PM_MRK_DATA_FROM_L2_CYC = 131104,
	PM_INST_IMC_MATCH_DISP = 196630,
	PM_MRK_DATA_FROM_RMEM_CYC = 262188,
	PM_VSU0_SIMPLE_ISSUED = 45204,
	PM_CMPLU_STALL_DIV = 262164,
	PM_MRK_PTEG_FROM_RL2L3_SHR = 184404,
	PM_VSU_FMA_DOUBLE = 43152,
	PM_VSU_4FLOP = 43164,
	PM_VSU1_FIN = 41150,
	PM_NEST_PAIR1_AND = 133251,
	PM_INST_PTEG_FROM_RL2L3_MOD = 122962,
	PM_RUN_CYC___4 = 131316,
	PM_PTEG_FROM_RMEM = 245842,
	PM_LSU_LRQ_S0_VALID = 53406,
	PM_LSU0_LDF = 49284,
	PM_FLUSH_COMPLETION = 196626,
	PM_ST_MISS_L1___4 = 196848,
	PM_L2_NODE_PUMP = 222336,
	PM_INST_FROM_DL2L3_SHR = 213060,
	PM_MRK_STALL_CMPLU_CYC = 196670,
	PM_VSU1_DENORM = 41134,
	PM_MRK_DATA_FROM_L31_SHR_CYC = 131110,
	PM_NEST_PAIR0_ADD = 67713,
	PM_INST_FROM_L3MISS = 147528,
	PM_EE_OFF_EXT_INT = 8320,
	PM_INST_PTEG_FROM_DMEM = 188498,
	PM_INST_FROM_DL2L3_MOD = 213068,
	PM_PMC6_OVERFLOW = 196644,
	PM_VSU_2FLOP_DOUBLE = 43148,
	PM_TLB_MISS = 131174,
	PM_FXU_BUSY = 131086,
	PM_L2_RCLD_DISP_FAIL_OTHER = 156288,
	PM_LSU_REJECT_LMQ_FULL = 51364,
	PM_IC_RELOAD_SHR = 16534,
	PM_GRP_MRK = 65585,
	PM_MRK_ST_NEST = 131124,
	PM_VSU1_FSQRT_FDIV = 41098,
	PM_LSU0_FLUSH_LRQ = 49336,
	PM_LARX_LSU0 = 49300,
	PM_IBUF_FULL_CYC = 16516,
	PM_MRK_DATA_FROM_DL2L3_SHR_CYC = 131114,
	PM_LSU_DC_PREF_STREAM_ALLOC = 55464,
	PM_GRP_MRK_CYC = 65584,
	PM_MRK_DATA_FROM_RL2L3_SHR_CYC = 131112,
	PM_L2_GLOB_GUESS_CORRECT = 91266,
	PM_LSU_REJECT_LHS = 51372,
	PM_MRK_DATA_FROM_LMEM = 249930,
	PM_INST_PTEG_FROM_L3 = 188496,
	PM_FREQ_DOWN = 196620,
	PM_PB_RETRY_NODE_PUMP = 196737,
	PM_INST_FROM_RL2L3_SHR = 81996,
	PM_MRK_INST_ISSUED = 65586,
	PM_PTEG_FROM_L3MISS = 180312,
	PM_RUN_PURR = 262388,
	PM_MRK_GRP_IC_MISS = 262200,
	PM_MRK_DATA_FROM_L3 = 118856,
	PM_CMPLU_STALL_DCACHE_MISS = 131094,
	PM_PTEG_FROM_RL2L3_SHR = 180308,
	PM_LSU_FLUSH_LRQ = 51384,
	PM_MRK_DERAT_MISS_64K = 184412,
	PM_INST_PTEG_FROM_DL2L3_MOD = 319572,
	PM_L2_ST_MISS___3 = 155778,
	PM_MRK_PTEG_FROM_L21_SHR = 315478,
	PM_LWSYNC = 53396,
	PM_LSU0_DC_PREF_STREAM_CONFIRM_STRIDE = 53436,
	PM_MRK_LSU_FLUSH_LRQ = 53384,
	PM_INST_IMC_MATCH_CMPL = 65776,
	PM_NEST_PAIR3_AND = 264323,
	PM_PB_RETRY_SYS_PUMP = 262273,
	PM_MRK_INST_FIN = 196656,
	PM_MRK_PTEG_FROM_DL2L3_SHR = 249940,
	PM_INST_FROM_L31_MOD = 81988,
	PM_MRK_DTLB_MISS_64K___2 = 249950,
	PM_LSU_FIN = 196710,
	PM_MRK_LSU_REJECT = 262244,
	PM_L2_CO_FAIL_BUSY = 91010,
	PM_MEM0_WQ_DISP = 262275,
	PM_DATA_FROM_L31_MOD = 114756,
	PM_THERMAL_WARN = 65558,
	PM_VSU0_4FLOP = 41116,
	PM_BR_MPRED_CCACHE = 16548,
	PM_CMPLU_STALL_IFU = 262220,
	PM_L1_DEMAND_WRITE___3 = 16524,
	PM_FLUSH_BR_MPRED = 8324,
	PM_MRK_DTLB_MISS_16G___2 = 118878,
	PM_MRK_PTEG_FROM_DMEM = 184402,
	PM_L2_RCST_DISP = 221824,
	PM_CMPLU_STALL___3 = 262154,
	PM_LSU_PARTIAL_CDF = 49322,
	PM_DISP_CLB_HELD_SB = 8360,
	PM_VSU0_FMA_DOUBLE = 41104,
	PM_FXU0_BUSY_FXU1_IDLE = 196622,
	PM_IC_DEMAND_CYC = 65560,
	PM_MRK_DATA_FROM_L21_SHR = 249934,
	PM_MRK_LSU_FLUSH_UST = 53382,
	PM_INST_PTEG_FROM_L3MISS = 188504,
	PM_VSU_DENORM = 43180,
	PM_MRK_LSU_PARTIAL_CDF = 53376,
	PM_INST_FROM_L21_SHR = 213070,
	PM_IC_PREF_WRITE___3 = 16526,
	PM_BR_PRED = 16540,
	PM_INST_FROM_DMEM = 81994,
	PM_IC_PREF_CANCEL_ALL = 18576,
	PM_LSU_DC_PREF_STREAM_CONFIRM = 55476,
	PM_MRK_LSU_FLUSH_SRQ = 53386,
	PM_MRK_FIN_STALL_CYC = 65596,
	PM_L2_RCST_DISP_FAIL_OTHER = 287360,
	PM_VSU1_DD_ISSUED = 45208,
	PM_PTEG_FROM_L31_SHR = 180310,
	PM_DATA_FROM_L21_SHR = 245838,
	PM_LSU0_NCLD = 49292,
	PM_VSU1_4FLOP = 41118,
	PM_VSU1_8FLOP = 41122,
	PM_VSU_8FLOP = 43168,
	PM_LSU_LMQ_SRQ_EMPTY_CYC = 131134,
	PM_DTLB_MISS_64K___2 = 245854,
	PM_THRD_CONC_RUN_INST = 196852,
	PM_MRK_PTEG_FROM_L2 = 118864,
	PM_PB_SYS_PUMP = 131201,
	PM_VSU_FIN = 43196,
	PM_MRK_DATA_FROM_L31_MOD = 118852,
	PM_THRD_PRIO_0_1_CYC = 16560,
	PM_DERAT_MISS_64K = 180316,
	PM_PMC2_REWIND = 196640,
	PM_INST_FROM_L2 = 81984,
	PM_GRP_BR_MPRED_NONSPEC = 65546,
	PM_INST_DISP___4 = 131314,
	PM_MEM0_RD_CANCEL_TOTAL = 196739,
	PM_LSU0_DC_PREF_STREAM_CONFIRM = 53428,
	PM_L1_DCACHE_RELOAD_VALID = 196854,
	PM_VSU_SCALAR_DOUBLE_ISSUED = 47240,
	PM_L3_PREF_HIT = 258176,
	PM_MRK_PTEG_FROM_L31_MOD = 118868,
	PM_CMPLU_STALL_STORE = 131146,
	PM_MRK_FXU_FIN = 131128,
	PM_PMC4_OVERFLOW = 65552,
	PM_MRK_PTEG_FROM_L3 = 184400,
	PM_LSU0_LMQ_LHR_MERGE = 53400,
	PM_BTAC_HIT = 20618,
	PM_L3_RD_BUSY = 323714,
	PM_LSU0_L1_SW_PREF = 49308,
	PM_INST_FROM_L2MISS = 278600,
	PM_LSU0_DC_PREF_STREAM_ALLOC = 53416,
	PM_L2_ST___3 = 90242,
	PM_VSU0_DENORM = 41132,
	PM_MRK_DATA_FROM_DL2L3_SHR = 249924,
	PM_BR_PRED_CR_TA = 18602,
	PM_VSU0_FCONV = 41136,
	PM_MRK_LSU_FLUSH_ULD = 53380,
	PM_BTAC_MISS = 20616,
	PM_MRK_LD_MISS_EXPOSED_CYC_COUNT = 65599,
	PM_MRK_DATA_FROM_L2 = 118848,
	PM_LSU_DCACHE_RELOAD_VALID = 53410,
	PM_VSU_FMA = 43140,
	PM_LSU0_FLUSH_SRQ = 49340,
	PM_LSU1_L1_PREF = 53434,
	PM_IOPS_CMPL = 65556,
	PM_L2_SYS_PUMP = 222338,
	PM_L2_RCLD_BUSY_RC_FULL = 287362,
	PM_LSU_LMQ_S0_ALLOC = 53409,
	PM_FLUSH_DISP_SYNC = 8328,
	PM_MRK_DATA_FROM_DL2L3_MOD_CYC = 262186,
	PM_L2_IC_INV = 156032,
	PM_MRK_DATA_FROM_L21_MOD_CYC = 262180,
	PM_L3_PREF_LDST = 55468,
	PM_LSU_SRQ_EMPTY_CYC = 262152,
	PM_LSU_LMQ_S0_VALID = 53408,
	PM_FLUSH_PARTIAL = 8326,
	PM_VSU1_FMA_DOUBLE = 41106,
	PM_1PLUS_PPC_DISP = 262386,
	PM_DATA_FROM_L2MISS = 131326,
	PM_SUSPENDED = 0,
	PM_VSU0_FMA = 41092,
	PM_CMPLU_STALL_SCALAR = 262162,
	PM_STCX_FAIL = 49306,
	PM_VSU0_FSQRT_FDIV_DOUBLE = 41108,
	PM_DC_PREF_DST = 53424,
	PM_VSU1_SCAL_SINGLE_ISSUED = 45190,
	PM_L3_HIT = 127104,
	PM_L2_GLOB_GUESS_WRONG = 156802,
	PM_MRK_DFU_FIN = 131122,
	PM_INST_FROM_L1___3 = 16512,
	PM_BRU_FIN___2 = 65640,
	PM_IC_DEMAND_REQ = 16520,
	PM_VSU1_FSQRT_FDIV_DOUBLE = 41110,
	PM_VSU1_FMA = 41094,
	PM_MRK_LD_MISS_L1 = 131126,
	PM_VSU0_2FLOP_DOUBLE = 41100,
	PM_LSU_DC_PREF_STRIDED_STREAM_CONFIRM = 55484,
	PM_INST_PTEG_FROM_L31_SHR = 188502,
	PM_MRK_LSU_REJECT_ERAT_MISS = 196708,
	PM_MRK_DATA_FROM_L2MISS___2 = 315464,
	PM_DATA_FROM_RL2L3_SHR = 114764,
	PM_INST_FROM_PREF = 81990,
	PM_VSU1_SQ = 45214,
	PM_L2_LD_DISP = 221568,
	PM_L2_DISP_ALL = 286848,
	PM_THRD_GRP_CMPL_BOTH_CYC = 65554,
	PM_VSU_FSQRT_FDIV_DOUBLE = 43156,
	PM_BR_MPRED = 262390,
	PM_INST_PTEG_FROM_DL2L3_SHR = 254036,
	PM_VSU_1FLOP = 43136,
	PM_HV_CYC = 131082,
	PM_MRK_LSU_FIN = 262194,
	PM_MRK_DATA_FROM_RL2L3_SHR = 118860,
	PM_DTLB_MISS_16M___2 = 311390,
	PM_LSU1_LMQ_LHR_MERGE = 53402,
	PM_IFU_FIN = 262246,
	PM_1THRD_CON_RUN_INSTR = 196706,
	PM_CMPLU_STALL_COUNT = 262155,
	PM_MEM0_PB_RD_CL = 196739,
	PM_THRD_1_RUN_CYC = 65632,
	PM_THRD_2_CONC_RUN_INSTR = 262242,
	PM_THRD_2_RUN_CYC = 131168,
	PM_THRD_3_CONC_RUN_INST = 65634,
	PM_THRD_3_RUN_CYC = 196704,
	PM_THRD_4_CONC_RUN_INST = 131170,
	PM_THRD_4_RUN_CYC = 262240,
};

enum {
	PM_IC_PREF_REQ___2 = 16544,
};

enum {
	PM_INST_CMPL___5 = 327930,
};

enum {
	PM_INST_CMPL_ALT___2 = 2,
};

enum {
	PM_INST_FROM_L1___4 = 16512,
};

enum {
	PM_INST_FROM_L1MISS = 17732923532886080ULL,
};

enum {
	PM_ITLB_MISS___5 = 262396,
};

enum {
	PM_L1_ICACHE_MISS___5 = 131324,
};

enum {
	PM_L2_ST___4 = 1099511914624ULL,
};

enum {
	PM_L2_ST_MISS___4 = 157824,
};

enum {
	PM_L3_PF_MISS_L3 = 17592186134656ULL,
};

enum {
	PM_LD_DEMAND_MISS_L1_FIN = 262384,
};

enum {
	PM_LD_MISS_L1___5 = 254036,
};

enum {
	PM_LD_PREFETCH_CACHE_LINE_MISS = 65580,
};

enum {
	PM_LD_REF_L1___4 = 65788,
};

enum {
	PM_MPRED_BR_FIN = 254104,
};

enum {
	PM_ST_MISS_L1___5 = 196848,
};

enum {
	POOL_BITS = 256,
	POOL_READY_BITS = 256,
	POOL_EARLY_BITS = 128,
};

enum {
	POWER_SUPPLY_CAPACITY_LEVEL_UNKNOWN = 0,
	POWER_SUPPLY_CAPACITY_LEVEL_CRITICAL = 1,
	POWER_SUPPLY_CAPACITY_LEVEL_LOW = 2,
	POWER_SUPPLY_CAPACITY_LEVEL_NORMAL = 3,
	POWER_SUPPLY_CAPACITY_LEVEL_HIGH = 4,
	POWER_SUPPLY_CAPACITY_LEVEL_FULL = 5,
};

enum {
	POWER_SUPPLY_CHARGE_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_CHARGE_TYPE_NONE = 1,
	POWER_SUPPLY_CHARGE_TYPE_TRICKLE = 2,
	POWER_SUPPLY_CHARGE_TYPE_FAST = 3,
	POWER_SUPPLY_CHARGE_TYPE_STANDARD = 4,
	POWER_SUPPLY_CHARGE_TYPE_ADAPTIVE = 5,
	POWER_SUPPLY_CHARGE_TYPE_CUSTOM = 6,
	POWER_SUPPLY_CHARGE_TYPE_LONGLIFE = 7,
	POWER_SUPPLY_CHARGE_TYPE_BYPASS = 8,
};

enum {
	POWER_SUPPLY_HEALTH_UNKNOWN = 0,
	POWER_SUPPLY_HEALTH_GOOD = 1,
	POWER_SUPPLY_HEALTH_OVERHEAT = 2,
	POWER_SUPPLY_HEALTH_DEAD = 3,
	POWER_SUPPLY_HEALTH_OVERVOLTAGE = 4,
	POWER_SUPPLY_HEALTH_UNSPEC_FAILURE = 5,
	POWER_SUPPLY_HEALTH_COLD = 6,
	POWER_SUPPLY_HEALTH_WATCHDOG_TIMER_EXPIRE = 7,
	POWER_SUPPLY_HEALTH_SAFETY_TIMER_EXPIRE = 8,
	POWER_SUPPLY_HEALTH_OVERCURRENT = 9,
	POWER_SUPPLY_HEALTH_CALIBRATION_REQUIRED = 10,
	POWER_SUPPLY_HEALTH_WARM = 11,
	POWER_SUPPLY_HEALTH_COOL = 12,
	POWER_SUPPLY_HEALTH_HOT = 13,
	POWER_SUPPLY_HEALTH_NO_BATTERY = 14,
};

enum {
	POWER_SUPPLY_SCOPE_UNKNOWN = 0,
	POWER_SUPPLY_SCOPE_SYSTEM = 1,
	POWER_SUPPLY_SCOPE_DEVICE = 2,
};

enum {
	POWER_SUPPLY_STATUS_UNKNOWN = 0,
	POWER_SUPPLY_STATUS_CHARGING = 1,
	POWER_SUPPLY_STATUS_DISCHARGING = 2,
	POWER_SUPPLY_STATUS_NOT_CHARGING = 3,
	POWER_SUPPLY_STATUS_FULL = 4,
};

enum {
	POWER_SUPPLY_TECHNOLOGY_UNKNOWN = 0,
	POWER_SUPPLY_TECHNOLOGY_NiMH = 1,
	POWER_SUPPLY_TECHNOLOGY_LION = 2,
	POWER_SUPPLY_TECHNOLOGY_LIPO = 3,
	POWER_SUPPLY_TECHNOLOGY_LiFe = 4,
	POWER_SUPPLY_TECHNOLOGY_NiCd = 5,
	POWER_SUPPLY_TECHNOLOGY_LiMn = 6,
};

enum {
	PREFIX_UNSPEC = 0,
	PREFIX_ADDRESS = 1,
	PREFIX_CACHEINFO = 2,
	__PREFIX_MAX = 3,
};

enum {
	PROCESSOR_BUS_TOPOLOGY = 0,
	PROCESSOR_CONFIG = 1,
	AFFINITY_DOMAIN_VIA_VP = 2,
	AFFINITY_DOMAIN_VIA_DOM = 3,
	AFFINITY_DOMAIN_VIA_PAR = 4,
};

enum {
	PROC_ENTRY_PERMANENT = 1,
};

enum {
	PROC_ROOT_INO = 1,
	PROC_IPC_INIT_INO = 4026531839,
	PROC_UTS_INIT_INO = 4026531838,
	PROC_USER_INIT_INO = 4026531837,
	PROC_PID_INIT_INO = 4026531836,
	PROC_CGROUP_INIT_INO = 4026531835,
	PROC_TIME_INIT_INO = 4026531834,
};

enum {
	PWMF_REQUESTED = 0,
	PWMF_EXPORTED = 1,
};

enum {
	PWR_OK = 0,
	PWR_LOCAL = 1,
	PWR_REMOTE = 2,
	PWR_BUSY = 3,
	PWR_ERROR_CAP = 4,
	PWR_FATAL_ERROR = 5,
};

enum {
	QIF_BLIMITS_B = 0,
	QIF_SPACE_B = 1,
	QIF_ILIMITS_B = 2,
	QIF_INODES_B = 3,
	QIF_BTIME_B = 4,
	QIF_ITIME_B = 5,
};

enum {
	QLA82XX_TEMP_NORMAL = 1,
	QLA82XX_TEMP_WARN = 2,
	QLA82XX_TEMP_PANIC = 3,
};

enum {
	QLA8XXX_DEV_UNKNOWN = 0,
	QLA8XXX_DEV_COLD = 1,
	QLA8XXX_DEV_INITIALIZING = 2,
	QLA8XXX_DEV_READY = 3,
	QLA8XXX_DEV_NEED_RESET = 4,
	QLA8XXX_DEV_NEED_QUIESCENT = 5,
	QLA8XXX_DEV_FAILED = 6,
	QLA8XXX_DEV_QUIESCENT = 7,
	MAX_STATES = 8,
};

enum {
	QOS_ENABLE = 0,
	QOS_CTRL = 1,
	NR_QOS_CTRL_PARAMS = 2,
};

enum {
	QOS_RPPM = 0,
	QOS_RLAT = 1,
	QOS_WPPM = 2,
	QOS_WLAT = 3,
	QOS_MIN = 4,
	QOS_MAX = 5,
	NR_QOS_PARAMS = 6,
};

enum {
	QS_DMA_BOUNDARY = 18446744073709551615ULL,
};

enum {
	QS_MMIO_BAR = 4,
	QS_PORTS = 4,
	QS_MAX_PRD = 128,
	QS_CPB_ORDER = 6,
	QS_CPB_BYTES = 64,
	QS_PRD_BYTES = 2048,
	QS_PKT_BYTES = 2112,
	QS_HCF_CNFG3 = 3,
	QS_HID_HPHY = 4,
	QS_HCT_CTRL = 228,
	QS_HST_SFF = 256,
	QS_HVS_SERD3 = 915,
	QS_HPHY_64BIT = 2,
	QS_CNFG3_GSRST = 1,
	QS_SERD3_PHY_ENA = 240,
	QS_CCF_CPBA = 1808,
	QS_CCF_CSEP = 1816,
	QS_CFC_HUFT = 2048,
	QS_CFC_HDFT = 2052,
	QS_CFC_DUFT = 2056,
	QS_CFC_DDFT = 2060,
	QS_CCT_CTR0 = 2304,
	QS_CCT_CTR1 = 2305,
	QS_CCT_CFF = 2560,
	QS_CTR0_REG = 2,
	QS_CTR0_CLER = 4,
	QS_CTR1_RDEV = 2,
	QS_CTR1_RCHN = 16,
	QS_CCF_RUN_PKT = 263,
	QS_HCB_HDR = 1,
	QS_DCB_HDR = 2,
	QS_HF_DIRO = 1,
	QS_HF_DAT = 8,
	QS_HF_IEN = 16,
	QS_HF_VLD = 32,
	QS_DF_PORD = 4,
	QS_DF_ELBA = 8,
	board_2068_idx = 0,
};

enum {
	QTYPE_EQ = 1,
	QTYPE_CQ = 2,
	QTYPE_MCCQ = 3,
	QTYPE_WRBQ = 4,
	QTYPE_DPDUQ = 5,
	QTYPE_SGL = 6,
};

enum {
	QUOTA_NL_A_UNSPEC = 0,
	QUOTA_NL_A_QTYPE = 1,
	QUOTA_NL_A_EXCESS_ID = 2,
	QUOTA_NL_A_WARNING = 3,
	QUOTA_NL_A_DEV_MAJOR = 4,
	QUOTA_NL_A_DEV_MINOR = 5,
	QUOTA_NL_A_CAUSED_ID = 6,
	QUOTA_NL_A_PAD = 7,
	__QUOTA_NL_A_MAX = 8,
};

enum {
	QUOTA_NL_C_UNSPEC = 0,
	QUOTA_NL_C_WARNING = 1,
	__QUOTA_NL_C_MAX = 2,
};

enum {
	Q_REQUEUE_PI_NONE = 0,
	Q_REQUEUE_PI_IGNORE = 1,
	Q_REQUEUE_PI_IN_PROGRESS = 2,
	Q_REQUEUE_PI_WAIT = 3,
	Q_REQUEUE_PI_DONE = 4,
	Q_REQUEUE_PI_LOCKED = 5,
};

enum {
	RADIX_TREE_ITER_TAG_MASK = 15,
	RADIX_TREE_ITER_TAGGED = 16,
	RADIX_TREE_ITER_CONTIG = 32,
};

enum {
	RB_ADD_STAMP_NONE = 0,
	RB_ADD_STAMP_EXTEND = 2,
	RB_ADD_STAMP_ABSOLUTE = 4,
	RB_ADD_STAMP_FORCE = 8,
};

enum {
	RB_CTX_TRANSITION = 0,
	RB_CTX_NMI = 1,
	RB_CTX_IRQ = 2,
	RB_CTX_SOFTIRQ = 3,
	RB_CTX_NORMAL = 4,
	RB_CTX_MAX = 5,
};

enum {
	RB_LEN_TIME_EXTEND = 8,
	RB_LEN_TIME_STAMP = 8,
};

enum {
	RC5T583_DS_NONE = 0,
	RC5T583_DS_DC0 = 1,
	RC5T583_DS_DC1 = 2,
	RC5T583_DS_DC2 = 3,
	RC5T583_DS_DC3 = 4,
	RC5T583_DS_LDO0 = 5,
	RC5T583_DS_LDO1 = 6,
	RC5T583_DS_LDO2 = 7,
	RC5T583_DS_LDO3 = 8,
	RC5T583_DS_LDO4 = 9,
	RC5T583_DS_LDO5 = 10,
	RC5T583_DS_LDO6 = 11,
	RC5T583_DS_LDO7 = 12,
	RC5T583_DS_LDO8 = 13,
	RC5T583_DS_LDO9 = 14,
	RC5T583_DS_PSO0 = 15,
	RC5T583_DS_PSO1 = 16,
	RC5T583_DS_PSO2 = 17,
	RC5T583_DS_PSO3 = 18,
	RC5T583_DS_PSO4 = 19,
	RC5T583_DS_PSO5 = 20,
	RC5T583_DS_PSO6 = 21,
	RC5T583_DS_PSO7 = 22,
	RC5T583_DS_MAX = 23,
};

enum {
	RC5T583_EXT_PWRREQ1_CONTROL = 1,
	RC5T583_EXT_PWRREQ2_CONTROL = 2,
};

enum {
	RC5T583_GPIO0 = 0,
	RC5T583_GPIO1 = 1,
	RC5T583_GPIO2 = 2,
	RC5T583_GPIO3 = 3,
	RC5T583_GPIO4 = 4,
	RC5T583_GPIO5 = 5,
	RC5T583_GPIO6 = 6,
	RC5T583_GPIO7 = 7,
	RC5T583_MAX_GPIO = 8,
};

enum {
	RC5T583_IRQ_ONKEY = 0,
	RC5T583_IRQ_ACOK = 1,
	RC5T583_IRQ_LIDOPEN = 2,
	RC5T583_IRQ_PREOT = 3,
	RC5T583_IRQ_CLKSTP = 4,
	RC5T583_IRQ_ONKEY_OFF = 5,
	RC5T583_IRQ_WD = 6,
	RC5T583_IRQ_EN_PWRREQ1 = 7,
	RC5T583_IRQ_EN_PWRREQ2 = 8,
	RC5T583_IRQ_PRE_VINDET = 9,
	RC5T583_IRQ_DC0LIM = 10,
	RC5T583_IRQ_DC1LIM = 11,
	RC5T583_IRQ_DC2LIM = 12,
	RC5T583_IRQ_DC3LIM = 13,
	RC5T583_IRQ_CTC = 14,
	RC5T583_IRQ_YALE = 15,
	RC5T583_IRQ_DALE = 16,
	RC5T583_IRQ_WALE = 17,
	RC5T583_IRQ_AIN1L = 18,
	RC5T583_IRQ_AIN2L = 19,
	RC5T583_IRQ_AIN3L = 20,
	RC5T583_IRQ_VBATL = 21,
	RC5T583_IRQ_VIN3L = 22,
	RC5T583_IRQ_VIN8L = 23,
	RC5T583_IRQ_AIN1H = 24,
	RC5T583_IRQ_AIN2H = 25,
	RC5T583_IRQ_AIN3H = 26,
	RC5T583_IRQ_VBATH = 27,
	RC5T583_IRQ_VIN3H = 28,
	RC5T583_IRQ_VIN8H = 29,
	RC5T583_IRQ_ADCEND = 30,
	RC5T583_IRQ_GPIO0 = 31,
	RC5T583_IRQ_GPIO1 = 32,
	RC5T583_IRQ_GPIO2 = 33,
	RC5T583_IRQ_GPIO3 = 34,
	RC5T583_IRQ_GPIO4 = 35,
	RC5T583_IRQ_GPIO5 = 36,
	RC5T583_IRQ_GPIO6 = 37,
	RC5T583_IRQ_GPIO7 = 38,
	RC5T583_MAX_IRQS = 39,
};

enum {
	RC5T583_REGULATOR_DC0 = 0,
	RC5T583_REGULATOR_DC1 = 1,
	RC5T583_REGULATOR_DC2 = 2,
	RC5T583_REGULATOR_DC3 = 3,
	RC5T583_REGULATOR_LDO0 = 4,
	RC5T583_REGULATOR_LDO1 = 5,
	RC5T583_REGULATOR_LDO2 = 6,
	RC5T583_REGULATOR_LDO3 = 7,
	RC5T583_REGULATOR_LDO4 = 8,
	RC5T583_REGULATOR_LDO5 = 9,
	RC5T583_REGULATOR_LDO6 = 10,
	RC5T583_REGULATOR_LDO7 = 11,
	RC5T583_REGULATOR_LDO8 = 12,
	RC5T583_REGULATOR_LDO9 = 13,
	RC5T583_REGULATOR_MAX = 14,
};

enum {
	READ_REG = 0,
	WRITE_REG = 1,
	CNTRL_REG = 3,
	STRAP_REG = 5,
	MISC_REG = 6,
};

enum {
	REASON_BOUNDS = -1,
	REASON_TYPE = -2,
	REASON_PATHS = -3,
	REASON_LIMIT = -4,
	REASON_STACK = -5,
};

enum {
	REGION_INTERSECTS = 0,
	REGION_DISJOINT = 1,
	REGION_MIXED = 2,
};

enum {
	REGULATOR_ERROR_CLEARED = 0,
	REGULATOR_FAILED_RETRY = 1,
	REGULATOR_ERROR_ON = 2,
};

enum {
	REG_CONTROLLER_CAPABILITIES = 0,
	REG_MCQCAP = 4,
	REG_UFS_VERSION = 8,
	REG_CONTROLLER_DEV_ID = 16,
	REG_CONTROLLER_PROD_ID = 20,
	REG_AUTO_HIBERNATE_IDLE_TIMER = 24,
	REG_INTERRUPT_STATUS = 32,
	REG_INTERRUPT_ENABLE = 36,
	REG_CONTROLLER_STATUS = 48,
	REG_CONTROLLER_ENABLE = 52,
	REG_UIC_ERROR_CODE_PHY_ADAPTER_LAYER = 56,
	REG_UIC_ERROR_CODE_DATA_LINK_LAYER = 60,
	REG_UIC_ERROR_CODE_NETWORK_LAYER = 64,
	REG_UIC_ERROR_CODE_TRANSPORT_LAYER = 68,
	REG_UIC_ERROR_CODE_DME = 72,
	REG_UTP_TRANSFER_REQ_INT_AGG_CONTROL = 76,
	REG_UTP_TRANSFER_REQ_LIST_BASE_L = 80,
	REG_UTP_TRANSFER_REQ_LIST_BASE_H = 84,
	REG_UTP_TRANSFER_REQ_DOOR_BELL = 88,
	REG_UTP_TRANSFER_REQ_LIST_CLEAR = 92,
	REG_UTP_TRANSFER_REQ_LIST_RUN_STOP = 96,
	REG_UTP_TASK_REQ_LIST_BASE_L = 112,
	REG_UTP_TASK_REQ_LIST_BASE_H = 116,
	REG_UTP_TASK_REQ_DOOR_BELL = 120,
	REG_UTP_TASK_REQ_LIST_CLEAR = 124,
	REG_UTP_TASK_REQ_LIST_RUN_STOP = 128,
	REG_UIC_COMMAND = 144,
	REG_UIC_COMMAND_ARG_1 = 148,
	REG_UIC_COMMAND_ARG_2 = 152,
	REG_UIC_COMMAND_ARG_3 = 156,
	UFSHCI_REG_SPACE_SIZE = 160,
	REG_UFS_CCAP = 256,
	REG_UFS_CRYPTOCAP = 260,
	REG_UFS_MEM_CFG = 768,
	REG_UFS_MCQ_CFG = 896,
	REG_UFS_ESILBA = 900,
	REG_UFS_ESIUBA = 904,
	UFSHCI_CRYPTO_REG_SPACE_SIZE = 1024,
};

enum {
	REG_CQHP = 0,
	REG_CQTP = 4,
};

enum {
	REG_CQIS = 0,
	REG_CQIE = 4,
};

enum {
	REG_GENL_ATTR_UNSPEC = 0,
	REG_GENL_ATTR_EVENT = 1,
	__REG_GENL_ATTR_MAX = 2,
};

enum {
	REG_GENL_CMD_UNSPEC = 0,
	REG_GENL_CMD_EVENT = 1,
	__REG_GENL_CMD_MAX = 2,
};

enum {
	REG_IBE = 0,
	REG_IEV = 1,
	REG_IS = 2,
	REG_IE = 3,
	REG_DIRECT = 4,
};

enum {
	REG_INPUT_DATA = 0,
	REG_PORT_CONFIG = 1,
	REG_PORT_ENABLE = 2,
	REG_SIO_CONFIG = 3,
	REG_SIO_CLOCK = 4,
	REG_INT_POLARITY = 5,
	REG_INT_TRIGGER = 6,
	REG_INT_ACK = 7,
	REG_INT_ENABLE = 8,
	REG_INT_IDENT = 9,
	MAXREG = 10,
};

enum {
	REG_RE = 0,
	REG_FE = 1,
	REG_IE___2 = 2,
};

enum {
	REG_SQATTR = 0,
	REG_SQLBA = 4,
	REG_SQUBA = 8,
	REG_SQDAO = 12,
	REG_SQISAO = 16,
	REG_CQATTR = 32,
	REG_CQLBA = 36,
	REG_CQUBA = 40,
	REG_CQDAO = 44,
	REG_CQISAO = 48,
};

enum {
	REG_SQHP = 0,
	REG_SQTP = 4,
	REG_SQRTC = 8,
	REG_SQCTI = 12,
	REG_SQRTS = 16,
};

enum {
	REQ_FSEQ_PREFLUSH = 1,
	REQ_FSEQ_DATA = 2,
	REQ_FSEQ_POSTFLUSH = 4,
	REQ_FSEQ_DONE = 8,
	REQ_FSEQ_ACTIONS = 7,
	FLUSH_PENDING_TIMEOUT = 5000,
};

enum {
	REQ_F_FIXED_FILE = 1ULL,
	REQ_F_IO_DRAIN = 2ULL,
	REQ_F_LINK = 4ULL,
	REQ_F_HARDLINK = 8ULL,
	REQ_F_FORCE_ASYNC = 16ULL,
	REQ_F_BUFFER_SELECT = 32ULL,
	REQ_F_CQE_SKIP = 64ULL,
	REQ_F_FAIL = 256ULL,
	REQ_F_INFLIGHT = 512ULL,
	REQ_F_CUR_POS = 1024ULL,
	REQ_F_NOWAIT = 2048ULL,
	REQ_F_LINK_TIMEOUT = 4096ULL,
	REQ_F_NEED_CLEANUP = 8192ULL,
	REQ_F_POLLED = 16384ULL,
	REQ_F_BUFFER_SELECTED = 32768ULL,
	REQ_F_BUFFER_RING = 65536ULL,
	REQ_F_REISSUE = 131072ULL,
	REQ_F_SUPPORT_NOWAIT = 268435456ULL,
	REQ_F_ISREG = 536870912ULL,
	REQ_F_CREDS = 262144ULL,
	REQ_F_REFCOUNT = 524288ULL,
	REQ_F_ARM_LTIMEOUT = 1048576ULL,
	REQ_F_ASYNC_DATA = 2097152ULL,
	REQ_F_SKIP_LINK_CQES = 4194304ULL,
	REQ_F_SINGLE_POLL = 8388608ULL,
	REQ_F_DOUBLE_POLL = 16777216ULL,
	REQ_F_APOLL_MULTISHOT = 33554432ULL,
	REQ_F_CLEAR_POLLIN = 67108864ULL,
	REQ_F_HASH_LOCKED = 134217728ULL,
	REQ_F_POLL_NO_LAZY = 1073741824ULL,
	REQ_F_CANCEL_SEQ = 2147483648ULL,
	REQ_F_CAN_POLL = 4294967296ULL,
	REQ_F_BL_EMPTY = 8589934592ULL,
	REQ_F_BL_NO_RECYCLE = 17179869184ULL,
	REQ_F_BUFFERS_COMMIT = 34359738368ULL,
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_BUFFER_SELECTED_BIT = 15,
	REQ_F_BUFFER_RING_BIT = 16,
	REQ_F_REISSUE_BIT = 17,
	REQ_F_CREDS_BIT = 18,
	REQ_F_REFCOUNT_BIT = 19,
	REQ_F_ARM_LTIMEOUT_BIT = 20,
	REQ_F_ASYNC_DATA_BIT = 21,
	REQ_F_SKIP_LINK_CQES_BIT = 22,
	REQ_F_SINGLE_POLL_BIT = 23,
	REQ_F_DOUBLE_POLL_BIT = 24,
	REQ_F_APOLL_MULTISHOT_BIT = 25,
	REQ_F_CLEAR_POLLIN_BIT = 26,
	REQ_F_HASH_LOCKED_BIT = 27,
	REQ_F_SUPPORT_NOWAIT_BIT = 28,
	REQ_F_ISREG_BIT = 29,
	REQ_F_POLL_NO_LAZY_BIT = 30,
	REQ_F_CANCEL_SEQ_BIT = 31,
	REQ_F_CAN_POLL_BIT = 32,
	REQ_F_BL_EMPTY_BIT = 33,
	REQ_F_BL_NO_RECYCLE_BIT = 34,
	REQ_F_BUFFERS_COMMIT_BIT = 35,
	__REQ_F_LAST_BIT = 36,
};

enum {
	RESOURCE_NONE = 0,
	RESOURCE_IOCB = 1,
	RESOURCE_EXCH = 2,
	RESOURCE_FORCE = 4,
	RESOURCE_HA = 8,
};

enum {
	RES_USAGE = 0,
	RES_RSVD_USAGE = 1,
	RES_LIMIT = 2,
	RES_RSVD_LIMIT = 3,
	RES_MAX_USAGE = 4,
	RES_RSVD_MAX_USAGE = 5,
	RES_FAILCNT = 6,
	RES_RSVD_FAILCNT = 7,
};

enum {
	RES_USAGE___2 = 0,
	RES_LIMIT___2 = 1,
	RES_MAX_USAGE___2 = 2,
	RES_FAILCNT___2 = 3,
	RES_SOFT_LIMIT = 4,
};

enum {
	RPL_IPTUNNEL_UNSPEC = 0,
	RPL_IPTUNNEL_SRH = 1,
	__RPL_IPTUNNEL_MAX = 2,
};

enum {
	RQ_WAIT_BUSY_PCT = 5,
	UNBUSY_THR_PCT = 75,
	MIN_DELAY_THR_PCT = 500,
	MAX_DELAY_THR_PCT = 25000,
	MIN_DELAY = 250,
	MAX_DELAY = 250000,
	DFGV_USAGE_PCT = 50,
	DFGV_PERIOD = 100000,
	MAX_LAGGING_PERIODS = 10,
	IOC_PAGE_SHIFT = 12,
	IOC_PAGE_SIZE = 4096,
	IOC_SECT_TO_PAGE_SHIFT = 3,
	LCOEF_RANDIO_PAGES = 4096,
};

enum {
	RSS_HASH_NONE = 0,
	RSS_HASH_2_TUPLE = 1,
	RSS_HASH_4_TUPLE = 2,
	RSS_HASH_TCPV6 = 3,
};

enum {
	RTAS_WORK_AREA_ARENA_ALIGN = 65536,
	RTAS_WORK_AREA_ARENA_SZ = 262144,
	RTAS_WORK_AREA_MIN_ALLOC_SZ = 128,
};

enum {
	RTAS_WORK_AREA_MAX_ALLOC_SZ = 131072,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	RTM_BASE = 16,
	RTM_NEWLINK = 16,
	RTM_DELLINK = 17,
	RTM_GETLINK = 18,
	RTM_SETLINK = 19,
	RTM_NEWADDR = 20,
	RTM_DELADDR = 21,
	RTM_GETADDR = 22,
	RTM_NEWROUTE = 24,
	RTM_DELROUTE = 25,
	RTM_GETROUTE = 26,
	RTM_NEWNEIGH = 28,
	RTM_DELNEIGH = 29,
	RTM_GETNEIGH = 30,
	RTM_NEWRULE = 32,
	RTM_DELRULE = 33,
	RTM_GETRULE = 34,
	RTM_NEWQDISC = 36,
	RTM_DELQDISC = 37,
	RTM_GETQDISC = 38,
	RTM_NEWTCLASS = 40,
	RTM_DELTCLASS = 41,
	RTM_GETTCLASS = 42,
	RTM_NEWTFILTER = 44,
	RTM_DELTFILTER = 45,
	RTM_GETTFILTER = 46,
	RTM_NEWACTION = 48,
	RTM_DELACTION = 49,
	RTM_GETACTION = 50,
	RTM_NEWPREFIX = 52,
	RTM_GETMULTICAST = 58,
	RTM_GETANYCAST = 62,
	RTM_NEWNEIGHTBL = 64,
	RTM_GETNEIGHTBL = 66,
	RTM_SETNEIGHTBL = 67,
	RTM_NEWNDUSEROPT = 68,
	RTM_NEWADDRLABEL = 72,
	RTM_DELADDRLABEL = 73,
	RTM_GETADDRLABEL = 74,
	RTM_GETDCB = 78,
	RTM_SETDCB = 79,
	RTM_NEWNETCONF = 80,
	RTM_DELNETCONF = 81,
	RTM_GETNETCONF = 82,
	RTM_NEWMDB = 84,
	RTM_DELMDB = 85,
	RTM_GETMDB = 86,
	RTM_NEWNSID = 88,
	RTM_DELNSID = 89,
	RTM_GETNSID = 90,
	RTM_NEWSTATS = 92,
	RTM_GETSTATS = 94,
	RTM_SETSTATS = 95,
	RTM_NEWCACHEREPORT = 96,
	RTM_NEWCHAIN = 100,
	RTM_DELCHAIN = 101,
	RTM_GETCHAIN = 102,
	RTM_NEWNEXTHOP = 104,
	RTM_DELNEXTHOP = 105,
	RTM_GETNEXTHOP = 106,
	RTM_NEWLINKPROP = 108,
	RTM_DELLINKPROP = 109,
	RTM_GETLINKPROP = 110,
	RTM_NEWVLAN = 112,
	RTM_DELVLAN = 113,
	RTM_GETVLAN = 114,
	RTM_NEWNEXTHOPBUCKET = 116,
	RTM_DELNEXTHOPBUCKET = 117,
	RTM_GETNEXTHOPBUCKET = 118,
	RTM_NEWTUNNEL = 120,
	RTM_DELTUNNEL = 121,
	RTM_GETTUNNEL = 122,
	__RTM_MAX = 123,
};

enum {
	RTN_UNSPEC = 0,
	RTN_UNICAST = 1,
	RTN_LOCAL = 2,
	RTN_BROADCAST = 3,
	RTN_ANYCAST = 4,
	RTN_MULTICAST = 5,
	RTN_BLACKHOLE = 6,
	RTN_UNREACHABLE = 7,
	RTN_PROHIBIT = 8,
	RTN_THROW = 9,
	RTN_NAT = 10,
	RTN_XRESOLVE = 11,
	__RTN_MAX = 12,
};

enum {
	RWB_DEF_DEPTH = 16,
	RWB_WINDOW_NSEC = 100000000,
	RWB_MIN_WRITE_SAMPLES = 3,
	RWB_UNKNOWN_BUMP = 5,
};

enum {
	Root_NFS = 255,
	Root_CIFS = 254,
	Root_Generic = 253,
	Root_RAM0 = 1048576,
};

enum {
	S1SA = 0,
	S2SA = 1,
	SP = 2,
	DSA = 3,
	CNT = 4,
	DP_OCTL = 5,
	CLR = 6,
	BI = 8,
	MBC = 9,
	BLTCTL = 10,
	HES = 12,
	HEB = 13,
	HSB = 14,
	HT = 15,
	VES = 16,
	VEB = 17,
	VSB = 18,
	VT = 19,
	HCIV = 20,
	VCIV = 21,
	TCDR = 22,
	VIL = 23,
	STGCTL = 24,
	SSR = 25,
	HRIR = 26,
	SPR = 27,
	CMR = 28,
	SRGCTL = 29,
	RRCIV = 30,
	RRSC = 31,
	RRCR = 34,
	GIOE = 32,
	GIO = 33,
	SCR = 35,
	SSTATUS = 36,
	PRC = 37,
};

enum {
	SAS_DATAPRES_NO_DATA = 0,
	SAS_DATAPRES_RESPONSE_DATA = 1,
	SAS_DATAPRES_SENSE_DATA = 2,
};

enum {
	SAS_DEV_GONE = 0,
	SAS_DEV_FOUND = 1,
	SAS_DEV_DESTROY = 2,
	SAS_DEV_EH_PENDING = 3,
	SAS_DEV_LU_RESET = 4,
	SAS_DEV_RESET = 5,
};

enum {
	SATA_CHAN_ENAB = 64,
	SATA_INT_GATE = 65,
	SATA_NATIVE_MODE = 66,
	SVIA_MISC_3 = 70,
	PATA_UDMA_TIMING = 179,
	PATA_PIO_TIMING = 171,
	PORT0 = 2,
	PORT1 = 1,
	ALL_PORTS = 3,
	NATIVE_MODE_ALL = 240,
	SATA_EXT_PHY = 64,
	SATA_HOTPLUG = 32,
};

enum {
	SATA_DWC_CMD_ISSUED_NOT = 0,
	SATA_DWC_CMD_ISSUED_PEND = 1,
	SATA_DWC_CMD_ISSUED_EXEC = 2,
	SATA_DWC_CMD_ISSUED_NODATA = 3,
	SATA_DWC_DMA_PENDING_NONE = 0,
	SATA_DWC_DMA_PENDING_TX = 1,
	SATA_DWC_DMA_PENDING_RX = 2,
};

enum {
	SATA_DWC_MAX_PORTS = 1,
	SATA_DWC_SCR_OFFSET = 36,
	SATA_DWC_REG_OFFSET = 100,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum {
	SCM_TSTAMP_SND = 0,
	SCM_TSTAMP_SCHED = 1,
	SCM_TSTAMP_ACK = 2,
};

enum {
	SCR_SCONTROL_DET_ENABLE = 1,
	SCR_SSTATUS_DET_PRESENT = 1,
	SCR_SERROR_DIAG_X = 67108864,
	SATA_DWC_TXFIFO_DEPTH = 511,
	SATA_DWC_RXFIFO_DEPTH = 511,
	SATA_DWC_DMACR_TMOD_TXCHEN = 4,
	SATA_DWC_DMACR_TXCHEN = 5,
	SATA_DWC_DMACR_RXCHEN = 6,
	SATA_DWC_DMACR_TXRXCH_CLEAR = 4,
	SATA_DWC_INTPR_DMAT = 1,
	SATA_DWC_INTPR_NEWFP = 2,
	SATA_DWC_INTPR_PMABRT = 4,
	SATA_DWC_INTPR_ERR = 8,
	SATA_DWC_INTPR_NEWBIST = 16,
	SATA_DWC_INTPR_IPF = 268435456,
	SATA_DWC_INTMR_DMATM = 1,
	SATA_DWC_INTMR_NEWFPM = 2,
	SATA_DWC_INTMR_PMABRTM = 4,
	SATA_DWC_INTMR_ERRM = 8,
	SATA_DWC_INTMR_NEWBISTM = 16,
	SATA_DWC_LLCR_SCRAMEN = 1,
	SATA_DWC_LLCR_DESCRAMEN = 2,
	SATA_DWC_LLCR_RPDEN = 4,
	SATA_DWC_SERROR_ERR_BITS = 268373763,
};

enum {
	SCSI_DH_OK = 0,
	SCSI_DH_DEV_FAILED = 1,
	SCSI_DH_DEV_TEMP_BUSY = 2,
	SCSI_DH_DEV_UNSUPP = 3,
	SCSI_DH_DEVICE_MAX = 4,
	SCSI_DH_NOTCONN = 5,
	SCSI_DH_CONN_FAILURE = 6,
	SCSI_DH_TRANSPORT_MAX = 7,
	SCSI_DH_IO = 8,
	SCSI_DH_INVALID_IO = 9,
	SCSI_DH_RETRY = 10,
	SCSI_DH_IMM_RETRY = 11,
	SCSI_DH_TIMED_OUT = 12,
	SCSI_DH_RES_TEMP_UNAVAIL = 13,
	SCSI_DH_DEV_OFFLINED = 14,
	SCSI_DH_NOMEM = 15,
	SCSI_DH_NOSYS = 16,
	SCSI_DH_DRIVER_MAX = 17,
};

enum {
	SD_BALANCE_NEWIDLE = 1,
	SD_BALANCE_EXEC = 2,
	SD_BALANCE_FORK = 4,
	SD_BALANCE_WAKE = 8,
	SD_WAKE_AFFINE = 16,
	SD_ASYM_CPUCAPACITY = 32,
	SD_ASYM_CPUCAPACITY_FULL = 64,
	SD_SHARE_CPUCAPACITY = 128,
	SD_CLUSTER = 256,
	SD_SHARE_LLC = 512,
	SD_SERIALIZE = 1024,
	SD_ASYM_PACKING = 2048,
	SD_PREFER_SIBLING = 4096,
	SD_OVERLAP = 8192,
	SD_NUMA = 16384,
};

enum {
	SD_DEF_XFER_BLOCKS = 65535,
	SD_MAX_XFER_BLOCKS = 4294967295,
	SD_MAX_WS10_BLOCKS = 65535,
	SD_MAX_WS16_BLOCKS = 8388607,
};

enum {
	SD_EXT_CDB_SIZE = 32,
	SD_MEMPOOL_SIZE = 2,
};

enum {
	SD_LBP_FULL = 0,
	SD_LBP_UNMAP = 1,
	SD_LBP_WS16 = 2,
	SD_LBP_WS10 = 3,
	SD_LBP_ZERO = 4,
	SD_LBP_DISABLE = 5,
};

enum {
	SD_ZERO_WRITE = 0,
	SD_ZERO_WS = 1,
	SD_ZERO_WS16_UNMAP = 2,
	SD_ZERO_WS10_UNMAP = 3,
};

enum {
	SECTION_MARKED_PRESENT_BIT = 0,
	SECTION_HAS_MEM_MAP_BIT = 1,
	SECTION_IS_ONLINE_BIT = 2,
	SECTION_IS_EARLY_BIT = 3,
	SECTION_TAINT_ZONE_DEVICE_BIT = 4,
	SECTION_MAP_LAST_BIT = 5,
};

enum {
	SEG6_ATTR_UNSPEC = 0,
	SEG6_ATTR_DST = 1,
	SEG6_ATTR_DSTLEN = 2,
	SEG6_ATTR_HMACKEYID = 3,
	SEG6_ATTR_SECRET = 4,
	SEG6_ATTR_SECRETLEN = 5,
	SEG6_ATTR_ALGID = 6,
	SEG6_ATTR_HMACINFO = 7,
	__SEG6_ATTR_MAX = 8,
};

enum {
	SEG6_CMD_UNSPEC = 0,
	SEG6_CMD_SETHMAC = 1,
	SEG6_CMD_DUMPHMAC = 2,
	SEG6_CMD_SET_TUNSRC = 3,
	SEG6_CMD_GET_TUNSRC = 4,
	__SEG6_CMD_MAX = 5,
};

enum {
	SEG6_HMAC_ALGO_SHA1 = 1,
	SEG6_HMAC_ALGO_SHA256 = 2,
};

enum {
	SEG6_IPTUNNEL_UNSPEC = 0,
	SEG6_IPTUNNEL_SRH = 1,
	__SEG6_IPTUNNEL_MAX = 2,
};

enum {
	SEG6_IPTUN_MODE_INLINE = 0,
	SEG6_IPTUN_MODE_ENCAP = 1,
	SEG6_IPTUN_MODE_L2ENCAP = 2,
	SEG6_IPTUN_MODE_ENCAP_RED = 3,
	SEG6_IPTUN_MODE_L2ENCAP_RED = 4,
};

enum {
	SEG6_LOCAL_ACTION_UNSPEC = 0,
	SEG6_LOCAL_ACTION_END = 1,
	SEG6_LOCAL_ACTION_END_X = 2,
	SEG6_LOCAL_ACTION_END_T = 3,
	SEG6_LOCAL_ACTION_END_DX2 = 4,
	SEG6_LOCAL_ACTION_END_DX6 = 5,
	SEG6_LOCAL_ACTION_END_DX4 = 6,
	SEG6_LOCAL_ACTION_END_DT6 = 7,
	SEG6_LOCAL_ACTION_END_DT4 = 8,
	SEG6_LOCAL_ACTION_END_B6 = 9,
	SEG6_LOCAL_ACTION_END_B6_ENCAP = 10,
	SEG6_LOCAL_ACTION_END_BM = 11,
	SEG6_LOCAL_ACTION_END_S = 12,
	SEG6_LOCAL_ACTION_END_AS = 13,
	SEG6_LOCAL_ACTION_END_AM = 14,
	SEG6_LOCAL_ACTION_END_BPF = 15,
	SEG6_LOCAL_ACTION_END_DT46 = 16,
	__SEG6_LOCAL_ACTION_MAX = 17,
};

enum {
	SEG6_LOCAL_BPF_PROG_UNSPEC = 0,
	SEG6_LOCAL_BPF_PROG = 1,
	SEG6_LOCAL_BPF_PROG_NAME = 2,
	__SEG6_LOCAL_BPF_PROG_MAX = 3,
};

enum {
	SEG6_LOCAL_CNT_UNSPEC = 0,
	SEG6_LOCAL_CNT_PAD = 1,
	SEG6_LOCAL_CNT_PACKETS = 2,
	SEG6_LOCAL_CNT_BYTES = 3,
	SEG6_LOCAL_CNT_ERRORS = 4,
	__SEG6_LOCAL_CNT_MAX = 5,
};

enum {
	SEG6_LOCAL_FLV_OP_UNSPEC = 0,
	SEG6_LOCAL_FLV_OP_PSP = 1,
	SEG6_LOCAL_FLV_OP_USP = 2,
	SEG6_LOCAL_FLV_OP_USD = 3,
	SEG6_LOCAL_FLV_OP_NEXT_CSID = 4,
	__SEG6_LOCAL_FLV_OP_MAX = 5,
};

enum {
	SEG6_LOCAL_FLV_UNSPEC = 0,
	SEG6_LOCAL_FLV_OPERATION = 1,
	SEG6_LOCAL_FLV_LCBLOCK_BITS = 2,
	SEG6_LOCAL_FLV_LCNODE_FN_BITS = 3,
	__SEG6_LOCAL_FLV_MAX = 4,
};

enum {
	SEG6_LOCAL_UNSPEC = 0,
	SEG6_LOCAL_ACTION = 1,
	SEG6_LOCAL_SRH = 2,
	SEG6_LOCAL_TABLE = 3,
	SEG6_LOCAL_NH4 = 4,
	SEG6_LOCAL_NH6 = 5,
	SEG6_LOCAL_IIF = 6,
	SEG6_LOCAL_OIF = 7,
	SEG6_LOCAL_BPF = 8,
	SEG6_LOCAL_VRFTABLE = 9,
	SEG6_LOCAL_COUNTERS = 10,
	SEG6_LOCAL_FLAVORS = 11,
	__SEG6_LOCAL_MAX = 12,
};

enum {
	SERNUM_LEN___3 = 16,
	EC_LEN = 16,
	ID_LEN___2 = 16,
};

enum {
	SFF8024_ID_UNK = 0,
	SFF8024_ID_SFF_8472 = 2,
	SFF8024_ID_SFP = 3,
	SFF8024_ID_DWDM_SFP = 11,
	SFF8024_ID_QSFP_8438 = 12,
	SFF8024_ID_QSFP_8436_8636 = 13,
	SFF8024_ID_QSFP28_8636 = 17,
	SFF8024_ENCODING_UNSPEC = 0,
	SFF8024_ENCODING_8B10B = 1,
	SFF8024_ENCODING_4B5B = 2,
	SFF8024_ENCODING_NRZ = 3,
	SFF8024_ENCODING_8472_MANCHESTER = 4,
	SFF8024_ENCODING_8472_SONET = 5,
	SFF8024_ENCODING_8472_64B66B = 6,
	SFF8024_ENCODING_8436_MANCHESTER = 6,
	SFF8024_ENCODING_8436_SONET = 4,
	SFF8024_ENCODING_8436_64B66B = 5,
	SFF8024_ENCODING_256B257B = 7,
	SFF8024_ENCODING_PAM4 = 8,
	SFF8024_CONNECTOR_UNSPEC = 0,
	SFF8024_CONNECTOR_SC = 1,
	SFF8024_CONNECTOR_FIBERJACK = 6,
	SFF8024_CONNECTOR_LC = 7,
	SFF8024_CONNECTOR_MT_RJ = 8,
	SFF8024_CONNECTOR_MU = 9,
	SFF8024_CONNECTOR_SG = 10,
	SFF8024_CONNECTOR_OPTICAL_PIGTAIL = 11,
	SFF8024_CONNECTOR_MPO_1X12 = 12,
	SFF8024_CONNECTOR_MPO_2X16 = 13,
	SFF8024_CONNECTOR_HSSDC_II = 32,
	SFF8024_CONNECTOR_COPPER_PIGTAIL = 33,
	SFF8024_CONNECTOR_RJ45 = 34,
	SFF8024_CONNECTOR_NOSEPARATE = 35,
	SFF8024_CONNECTOR_MXC_2X16 = 36,
	SFF8024_ECC_UNSPEC = 0,
	SFF8024_ECC_100G_25GAUI_C2M_AOC = 1,
	SFF8024_ECC_100GBASE_SR4_25GBASE_SR = 2,
	SFF8024_ECC_100GBASE_LR4_25GBASE_LR = 3,
	SFF8024_ECC_100GBASE_ER4_25GBASE_ER = 4,
	SFF8024_ECC_100GBASE_SR10 = 5,
	SFF8024_ECC_100GBASE_CR4 = 11,
	SFF8024_ECC_25GBASE_CR_S = 12,
	SFF8024_ECC_25GBASE_CR_N = 13,
	SFF8024_ECC_10GBASE_T_SFI = 22,
	SFF8024_ECC_10GBASE_T_SR = 28,
	SFF8024_ECC_5GBASE_T = 29,
	SFF8024_ECC_2_5GBASE_T = 30,
};

enum {
	SFP_XMTR_TECH_CU = 1,
	SFP_XMTR_TECH_CP = 2,
	SFP_XMTR_TECH_CA = 4,
	SFP_XMTR_TECH_LL = 8,
	SFP_XMTR_TECH_SL = 16,
	SFP_XMTR_TECH_SN = 32,
	SFP_XMTR_TECH_EL_INTRA = 64,
	SFP_XMTR_TECH_EL_INTER = 128,
	SFP_XMTR_TECH_LC = 256,
	SFP_XMTR_TECH_SA = 512,
};

enum {
	SF_ATTEMPTS = 5,
	SF_SEC_SIZE = 65536,
	SF_SIZE = 524288,
	SF_PROG_PAGE = 2,
	SF_WR_DISABLE = 4,
	SF_RD_STATUS = 5,
	SF_WR_ENABLE = 6,
	SF_RD_DATA_FAST = 11,
	SF_ERASE_SECTOR = 216,
	FW_FLASH_BOOT_ADDR = 458752,
	FW_VERS_ADDR = 524284,
	FW_MIN_SIZE = 8,
};

enum {
	SF_ATTEMPTS___2 = 10,
	SF_PROG_PAGE___2 = 2,
	SF_WR_DISABLE___2 = 4,
	SF_RD_STATUS___2 = 5,
	SF_WR_ENABLE___2 = 6,
	SF_RD_DATA_FAST___2 = 11,
	SF_RD_ID = 159,
	SF_ERASE_SECTOR___2 = 216,
};

enum {
	SF_PAGE_SIZE = 256,
	SF_SEC_SIZE___2 = 65536,
};

enum {
	SGE_MAX_WR_LEN = 512,
	SGE_CTXT_SIZE = 24,
	SGE_NTIMERS = 6,
	SGE_NCOUNTERS = 4,
	SGE_NDBQTIMERS = 8,
	SGE_MAX_IQ_SIZE = 65520,
	SGE_TIMER_RSTRT_CNTR = 6,
	SGE_TIMER_UPD_CIDX = 7,
	SGE_EQ_IDXSIZE = 64,
	SGE_INTRDST_PCI = 0,
	SGE_INTRDST_IQ = 1,
	SGE_UPDATEDEL_NONE = 0,
	SGE_UPDATEDEL_INTR = 1,
	SGE_UPDATEDEL_STPG = 2,
	SGE_UPDATEDEL_BOTH = 3,
	SGE_HOSTFCMODE_NONE = 0,
	SGE_HOSTFCMODE_IQ = 1,
	SGE_HOSTFCMODE_STPG = 2,
	SGE_HOSTFCMODE_BOTH = 3,
	SGE_FETCHBURSTMIN_16B = 0,
	SGE_FETCHBURSTMIN_32B = 1,
	SGE_FETCHBURSTMIN_64B = 2,
	SGE_FETCHBURSTMIN_128B = 3,
	SGE_FETCHBURSTMAX_64B = 0,
	SGE_FETCHBURSTMAX_128B = 1,
	SGE_FETCHBURSTMAX_256B = 2,
	SGE_FETCHBURSTMAX_512B = 3,
	SGE_CIDXFLUSHTHRESH_1 = 0,
	SGE_CIDXFLUSHTHRESH_2 = 1,
	SGE_CIDXFLUSHTHRESH_4 = 2,
	SGE_CIDXFLUSHTHRESH_8 = 3,
	SGE_CIDXFLUSHTHRESH_16 = 4,
	SGE_CIDXFLUSHTHRESH_32 = 5,
	SGE_CIDXFLUSHTHRESH_64 = 6,
	SGE_CIDXFLUSHTHRESH_128 = 7,
	SGE_INGPADBOUNDARY_SHIFT = 5,
};

enum {
	SGE_PSTAT_TSO = 0,
	SGE_PSTAT_RX_CSUM_GOOD = 1,
	SGE_PSTAT_TX_CSUM = 2,
	SGE_PSTAT_VLANEX = 3,
	SGE_PSTAT_VLANINS = 4,
	SGE_PSTAT_MAX = 5,
};

enum {
	SGE_QSETS = 8,
	SGE_RXQ_PER_SET = 2,
	SGE_TXQ_PER_SET = 3,
};

enum {
	SGPIO_ARCH_LUTON = 0,
	SGPIO_ARCH_OCELOT = 1,
	SGPIO_ARCH_SPARX5 = 2,
};

enum {
	SGPIO_FLAGS_HAS_IRQ = 1,
};

enum {
	SIL24_HOST_BAR = 0,
	SIL24_PORT_BAR = 2,
	SIL24_PRB_SZ = 64,
	SIL24_MAX_SGT = 1023,
	SIL24_MAX_SGE = 4093,
	HOST_SLOT_STAT = 0,
	HOST_CTRL = 64,
	HOST_IRQ_STAT___3 = 68,
	HOST_PHY_CFG = 72,
	HOST_BIST_CTRL = 80,
	HOST_BIST_PTRN = 84,
	HOST_BIST_STAT = 88,
	HOST_MEM_BIST_STAT = 92,
	HOST_FLASH_CMD = 112,
	HOST_FLASH_DATA = 116,
	HOST_TRANSITION_DETECT = 117,
	HOST_GPIO_CTRL = 118,
	HOST_I2C_ADDR = 120,
	HOST_I2C_DATA = 124,
	HOST_I2C_XFER_CNT = 126,
	HOST_I2C_CTRL = 127,
	HOST_SSTAT_ATTN = -2147483648,
	HOST_CTRL_M66EN = 65536,
	HOST_CTRL_TRDY = 131072,
	HOST_CTRL_STOP = 262144,
	HOST_CTRL_DEVSEL = 524288,
	HOST_CTRL_REQ64 = 1048576,
	HOST_CTRL_GLOBAL_RST = -2147483648,
	PORT_REGS_SIZE = 8192,
	PORT_LRAM = 0,
	PORT_LRAM_SLOT_SZ = 128,
	PORT_PMP = 3968,
	PORT_PMP_STATUS = 0,
	PORT_PMP_QACTIVE = 4,
	PORT_PMP_SIZE = 8,
	PORT_CTRL_STAT = 4096,
	PORT_CTRL_CLR = 4100,
	PORT_IRQ_STAT___3 = 4104,
	PORT_IRQ_ENABLE_SET = 4112,
	PORT_IRQ_ENABLE_CLR = 4116,
	PORT_ACTIVATE_UPPER_ADDR = 4124,
	PORT_EXEC_FIFO = 4128,
	PORT_CMD_ERR = 4132,
	PORT_FIS_CFG = 4136,
	PORT_FIFO_THRES = 4140,
	PORT_DECODE_ERR_CNT = 4160,
	PORT_DECODE_ERR_THRESH = 4162,
	PORT_CRC_ERR_CNT = 4164,
	PORT_CRC_ERR_THRESH = 4166,
	PORT_HSHK_ERR_CNT = 4168,
	PORT_HSHK_ERR_THRESH = 4170,
	PORT_PHY_CFG = 4176,
	PORT_SLOT_STAT = 6144,
	PORT_CMD_ACTIVATE = 7168,
	PORT_CONTEXT = 7684,
	PORT_EXEC_DIAG = 7680,
	PORT_PSD_DIAG = 7744,
	PORT_SCONTROL = 7936,
	PORT_SSTATUS = 7940,
	PORT_SERROR = 7944,
	PORT_SACTIVE = 7948,
	PORT_CS_PORT_RST = 1,
	PORT_CS_DEV_RST = 2,
	PORT_CS_INIT = 4,
	PORT_CS_IRQ_WOC = 8,
	PORT_CS_CDB16 = 32,
	PORT_CS_PMP_RESUME = 64,
	PORT_CS_32BIT_ACTV = 1024,
	PORT_CS_PMP_EN = 8192,
	PORT_CS_RDY = -2147483648,
	PORT_IRQ_COMPLETE = 1,
	PORT_IRQ_ERROR___2 = 2,
	PORT_IRQ_PORTRDY_CHG = 4,
	PORT_IRQ_PWR_CHG = 8,
	PORT_IRQ_PHYRDY_CHG = 16,
	PORT_IRQ_COMWAKE = 32,
	PORT_IRQ_UNK_FIS___2 = 64,
	PORT_IRQ_DEV_XCHG = 128,
	PORT_IRQ_8B10B = 256,
	PORT_IRQ_CRC = 512,
	PORT_IRQ_HANDSHAKE = 1024,
	PORT_IRQ_SDB_NOTIFY = 2048,
	DEF_PORT_IRQ___2 = 2259,
	PORT_IRQ_RAW_SHIFT = 16,
	PORT_IRQ_MASKED_MASK = 2047,
	PORT_IRQ_RAW_MASK = 134152192,
	PORT_IRQ_STEER_SHIFT = 30,
	PORT_IRQ_STEER_MASK = -1073741824,
	PORT_CERR_DEV = 1,
	PORT_CERR_SDB = 2,
	PORT_CERR_DATA = 3,
	PORT_CERR_SEND = 4,
	PORT_CERR_INCONSISTENT = 5,
	PORT_CERR_DIRECTION = 6,
	PORT_CERR_UNDERRUN = 7,
	PORT_CERR_OVERRUN = 8,
	PORT_CERR_PKT_PROT = 11,
	PORT_CERR_SGT_BOUNDARY = 16,
	PORT_CERR_SGT_TGTABRT = 17,
	PORT_CERR_SGT_MSTABRT = 18,
	PORT_CERR_SGT_PCIPERR = 19,
	PORT_CERR_CMD_BOUNDARY = 24,
	PORT_CERR_CMD_TGTABRT = 25,
	PORT_CERR_CMD_MSTABRT = 26,
	PORT_CERR_CMD_PCIPERR = 27,
	PORT_CERR_XFR_UNDEF = 32,
	PORT_CERR_XFR_TGTABRT = 33,
	PORT_CERR_XFR_MSTABRT = 34,
	PORT_CERR_XFR_PCIPERR = 35,
	PORT_CERR_SENDSERVICE = 36,
	PRB_CTRL_PROTOCOL = 1,
	PRB_CTRL_PACKET_READ = 16,
	PRB_CTRL_PACKET_WRITE = 32,
	PRB_CTRL_NIEN = 64,
	PRB_CTRL_SRST = 128,
	PRB_PROT_PACKET = 1,
	PRB_PROT_TCQ = 2,
	PRB_PROT_NCQ = 4,
	PRB_PROT_READ = 8,
	PRB_PROT_WRITE = 16,
	PRB_PROT_TRANSPARENT = 32,
	SGE_TRM = -2147483648,
	SGE_LNK = 1073741824,
	SGE_DRD = 536870912,
	SIL24_MAX_CMDS = 31,
	BID_SIL3124 = 0,
	BID_SIL3132 = 1,
	BID_SIL3131 = 2,
	SIL24_COMMON_FLAGS = 918658,
	SIL24_FLAG_PCIX_IRQ_WOC = 16777216,
	IRQ_STAT_4PORTS = 15,
};

enum {
	SIL_MMIO_BAR = 5,
	SIL_FLAG_NO_SATA_IRQ = 268435456,
	SIL_FLAG_RERR_ON_DMA_ACT = 536870912,
	SIL_FLAG_MOD15WRITE = 1073741824,
	SIL_DFL_PORT_FLAGS = 2,
	sil_3112 = 0,
	sil_3112_no_sata_irq = 1,
	sil_3512 = 2,
	sil_3114 = 3,
	SIL_SYSCFG = 72,
	SIL_MASK_IDE0_INT = 4194304,
	SIL_MASK_IDE1_INT = 8388608,
	SIL_MASK_IDE2_INT = 16777216,
	SIL_MASK_IDE3_INT = 33554432,
	SIL_MASK_2PORT = 12582912,
	SIL_MASK_4PORT = 62914560,
	SIL_INTR_STEERING = 2,
	SIL_DMA_ENABLE = 1,
	SIL_DMA_RDWR = 8,
	SIL_DMA_SATA_IRQ = 16,
	SIL_DMA_ACTIVE = 65536,
	SIL_DMA_ERROR = 131072,
	SIL_DMA_COMPLETE = 262144,
	SIL_DMA_N_SATA_IRQ = 64,
	SIL_DMA_N_ACTIVE = 16777216,
	SIL_DMA_N_ERROR = 33554432,
	SIL_DMA_N_COMPLETE = 67108864,
	SIL_SIEN_N = 65536,
	SIL_QUIRK_MOD15WRITE = 1,
	SIL_QUIRK_UDMA5MAX = 2,
};

enum {
	SKBFL_ZEROCOPY_ENABLE = 1,
	SKBFL_SHARED_FRAG = 2,
	SKBFL_PURE_ZEROCOPY = 4,
	SKBFL_DONT_ORPHAN = 8,
	SKBFL_MANAGED_FRAG_REFS = 16,
};

enum {
	SKBTX_HW_TSTAMP = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_HW_TSTAMP_USE_CYCLES = 8,
	SKBTX_WIFI_STATUS = 16,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
};

enum {
	SKB_FCLONE_UNAVAILABLE = 0,
	SKB_FCLONE_ORIG = 1,
	SKB_FCLONE_CLONE = 2,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
};

enum {
	SKCIPHER_WALK_PHYS = 1,
	SKCIPHER_WALK_SLOW = 2,
	SKCIPHER_WALK_COPY = 4,
	SKCIPHER_WALK_DIFF = 8,
	SKCIPHER_WALK_SLEEP = 16,
};

enum {
	SK_DIAG_BPF_STORAGE_NONE = 0,
	SK_DIAG_BPF_STORAGE_PAD = 1,
	SK_DIAG_BPF_STORAGE_MAP_ID = 2,
	SK_DIAG_BPF_STORAGE_MAP_VALUE = 3,
	__SK_DIAG_BPF_STORAGE_MAX = 4,
};

enum {
	SK_DIAG_BPF_STORAGE_REP_NONE = 0,
	SK_DIAG_BPF_STORAGE = 1,
	__SK_DIAG_BPF_STORAGE_REP_MAX = 2,
};

enum {
	SK_DIAG_BPF_STORAGE_REQ_NONE = 0,
	SK_DIAG_BPF_STORAGE_REQ_MAP_FD = 1,
	__SK_DIAG_BPF_STORAGE_REQ_MAX = 2,
};

enum {
	SK_MEMINFO_RMEM_ALLOC = 0,
	SK_MEMINFO_RCVBUF = 1,
	SK_MEMINFO_WMEM_ALLOC = 2,
	SK_MEMINFO_SNDBUF = 3,
	SK_MEMINFO_FWD_ALLOC = 4,
	SK_MEMINFO_WMEM_QUEUED = 5,
	SK_MEMINFO_OPTMEM = 6,
	SK_MEMINFO_BACKLOG = 7,
	SK_MEMINFO_DROPS = 8,
	SK_MEMINFO_VARS = 9,
};

enum {
	SOCK_WAKE_IO = 0,
	SOCK_WAKE_WAITD = 1,
	SOCK_WAKE_SPACE = 2,
	SOCK_WAKE_URG = 3,
};

enum {
	SOF_TIMESTAMPING_TX_HARDWARE = 1,
	SOF_TIMESTAMPING_TX_SOFTWARE = 2,
	SOF_TIMESTAMPING_RX_HARDWARE = 4,
	SOF_TIMESTAMPING_RX_SOFTWARE = 8,
	SOF_TIMESTAMPING_SOFTWARE = 16,
	SOF_TIMESTAMPING_SYS_HARDWARE = 32,
	SOF_TIMESTAMPING_RAW_HARDWARE = 64,
	SOF_TIMESTAMPING_OPT_ID = 128,
	SOF_TIMESTAMPING_TX_SCHED = 256,
	SOF_TIMESTAMPING_TX_ACK = 512,
	SOF_TIMESTAMPING_OPT_CMSG = 1024,
	SOF_TIMESTAMPING_OPT_TSONLY = 2048,
	SOF_TIMESTAMPING_OPT_STATS = 4096,
	SOF_TIMESTAMPING_OPT_PKTINFO = 8192,
	SOF_TIMESTAMPING_OPT_TX_SWHW = 16384,
	SOF_TIMESTAMPING_BIND_PHC = 32768,
	SOF_TIMESTAMPING_OPT_ID_TCP = 65536,
	SOF_TIMESTAMPING_LAST = 65536,
	SOF_TIMESTAMPING_MASK = 131071,
};

enum {
	SPI_BLIST_NOIUS = 1,
};

enum {
	SQ_START = 0,
	SQ_STOP = 1,
	SQ_ICU = 2,
};

enum {
	SQ_STS = 1,
	SQ_CUS = 2,
};

enum {
	SRP_BUF_FORMAT_DIRECT = 2,
	SRP_BUF_FORMAT_INDIRECT = 4,
};

enum {
	SRP_LOGIN_REQ = 0,
	SRP_TSK_MGMT = 1,
	SRP_CMD = 2,
	SRP_I_LOGOUT = 3,
	SRP_LOGIN_RSP = 192,
	SRP_RSP = 193,
	SRP_LOGIN_REJ = 194,
	SRP_T_LOGOUT = 128,
	SRP_CRED_REQ = 129,
	SRP_AER_REQ = 130,
	SRP_CRED_RSP = 65,
	SRP_AER_RSP = 66,
};

enum {
	SRP_NO_DATA_DESC = 0,
	SRP_DATA_DESC_DIRECT = 1,
	SRP_DATA_DESC_INDIRECT = 2,
	SRP_DATA_DESC_IMM = 3,
};

enum {
	SRP_RSP_FLAG_RSPVALID = 1,
	SRP_RSP_FLAG_SNSVALID = 2,
	SRP_RSP_FLAG_DOOVER = 4,
	SRP_RSP_FLAG_DOUNDER = 8,
	SRP_RSP_FLAG_DIOVER = 16,
	SRP_RSP_FLAG_DIUNDER = 32,
};

enum {
	SRP_TSK_ABORT_TASK = 1,
	SRP_TSK_ABORT_TASK_SET = 2,
	SRP_TSK_CLEAR_TASK_SET = 4,
	SRP_TSK_LUN_RESET = 8,
	SRP_TSK_CLEAR_ACA = 64,
};

enum {
	SS_STS_NORMAL = 2147483648,
	SS_STS_DONE = 1073741824,
	SS_STS_HANDSHAKE = 536870912,
	SS_HEAD_HANDSHAKE = 128,
	SS_H2I_INT_RESET = 256,
	SS_I2H_REQUEST_RESET = 8192,
	SS_MU_OPERATIONAL = 2147483648,
};

enum {
	STAT_ULP_CH0_PBL_OOB = 0,
	STAT_ULP_CH1_PBL_OOB = 1,
	STAT_PCI_CORR_ECC = 2,
	IRQ_NUM_STATS = 3,
};

enum {
	STEX_CDB_LENGTH = 16,
	STATUS_VAR_LEN = 128,
	SG_CF_EOT = 128,
	SG_CF_64B = 64,
	SG_CF_HOST = 32,
	MSG_DATA_DIR_ND = 0,
	MSG_DATA_DIR_IN = 1,
	MSG_DATA_DIR_OUT = 2,
	st_shasta = 0,
	st_vsc = 1,
	st_yosemite = 2,
	st_seq = 3,
	st_yel = 4,
	st_P3 = 5,
	PASSTHRU_REQ_TYPE = 1,
	PASSTHRU_REQ_NO_WAKEUP = 256,
	ST_INTERNAL_TIMEOUT = 180,
	ST_TO_CMD = 0,
	ST_FROM_CMD = 1,
	MGT_CMD = 216,
	SINBAND_MGT_CMD = 217,
	ARRAY_CMD = 224,
	CONTROLLER_CMD = 225,
	DEBUGGING_CMD = 226,
	PASSTHRU_CMD = 227,
	PASSTHRU_GET_ADAPTER = 5,
	PASSTHRU_GET_DRVVER = 16,
	CTLR_CONFIG_CMD = 3,
	CTLR_SHUTDOWN = 13,
	CTLR_POWER_STATE_CHANGE = 14,
	CTLR_POWER_SAVING = 1,
	PASSTHRU_SIGNATURE = 1312903233,
	MGT_CMD_SIGNATURE = 186,
	INQUIRY_EVPD = 1,
	ST_ADDITIONAL_MEM = 2097152,
	ST_ADDITIONAL_MEM_MIN = 524288,
	PMIC_SHUTDOWN = 13,
	PMIC_REUMSE = 16,
	ST_IGNORED = -1,
	ST_NOTHANDLED = 7,
	ST_S3 = 3,
	ST_S4 = 4,
	ST_S5 = 5,
	ST_S6 = 6,
};

enum {
	STMPE_IDX_CHIP_ID = 0,
	STMPE_IDX_SYS_CTRL = 1,
	STMPE_IDX_SYS_CTRL2 = 2,
	STMPE_IDX_ICR_LSB = 3,
	STMPE_IDX_IER_LSB = 4,
	STMPE_IDX_IER_MSB = 5,
	STMPE_IDX_ISR_LSB = 6,
	STMPE_IDX_ISR_MSB = 7,
	STMPE_IDX_GPMR_LSB = 8,
	STMPE_IDX_GPMR_CSB = 9,
	STMPE_IDX_GPMR_MSB = 10,
	STMPE_IDX_GPSR_LSB = 11,
	STMPE_IDX_GPSR_CSB = 12,
	STMPE_IDX_GPSR_MSB = 13,
	STMPE_IDX_GPCR_LSB = 14,
	STMPE_IDX_GPCR_CSB = 15,
	STMPE_IDX_GPCR_MSB = 16,
	STMPE_IDX_GPDR_LSB = 17,
	STMPE_IDX_GPDR_CSB = 18,
	STMPE_IDX_GPDR_MSB = 19,
	STMPE_IDX_GPEDR_LSB = 20,
	STMPE_IDX_GPEDR_CSB = 21,
	STMPE_IDX_GPEDR_MSB = 22,
	STMPE_IDX_GPRER_LSB = 23,
	STMPE_IDX_GPRER_CSB = 24,
	STMPE_IDX_GPRER_MSB = 25,
	STMPE_IDX_GPFER_LSB = 26,
	STMPE_IDX_GPFER_CSB = 27,
	STMPE_IDX_GPFER_MSB = 28,
	STMPE_IDX_GPPUR_LSB = 29,
	STMPE_IDX_GPPDR_LSB = 30,
	STMPE_IDX_GPAFR_U_MSB = 31,
	STMPE_IDX_IEGPIOR_LSB = 32,
	STMPE_IDX_IEGPIOR_CSB = 33,
	STMPE_IDX_IEGPIOR_MSB = 34,
	STMPE_IDX_ISGPIOR_LSB = 35,
	STMPE_IDX_ISGPIOR_CSB = 36,
	STMPE_IDX_ISGPIOR_MSB = 37,
	STMPE_IDX_MAX = 38,
};

enum {
	SUN_WHOLE_DISK = 5,
	LINUX_RAID_PARTITION___2 = 253,
};

enum {
	SUPPORTED_IRQ = 16777216,
};

enum {
	SWITCHTEC_GAS_MRPC_OFFSET = 0,
	SWITCHTEC_GAS_TOP_CFG_OFFSET = 4096,
	SWITCHTEC_GAS_SW_EVENT_OFFSET = 6144,
	SWITCHTEC_GAS_SYS_INFO_OFFSET = 8192,
	SWITCHTEC_GAS_FLASH_INFO_OFFSET = 8704,
	SWITCHTEC_GAS_PART_CFG_OFFSET = 16384,
	SWITCHTEC_GAS_NTB_OFFSET = 65536,
	SWITCHTEC_GAS_PFF_CSR_OFFSET = 1261568,
};

enum {
	SWITCHTEC_NTB_REG_INFO_OFFSET = 0,
	SWITCHTEC_NTB_REG_CTRL_OFFSET = 16384,
	SWITCHTEC_NTB_REG_DBMSG_OFFSET = 409600,
};

enum {
	SWP_USED = 1,
	SWP_WRITEOK = 2,
	SWP_DISCARDABLE = 4,
	SWP_DISCARDING = 8,
	SWP_SOLIDSTATE = 16,
	SWP_CONTINUED = 32,
	SWP_BLKDEV = 64,
	SWP_ACTIVATED = 128,
	SWP_FS_OPS = 256,
	SWP_AREA_DISCARD = 512,
	SWP_PAGE_DISCARD = 1024,
	SWP_STABLE_WRITES = 2048,
	SWP_SYNCHRONOUS_IO = 4096,
	SWP_SCANNING = 16384,
};

enum {
	SX150X_123 = 0,
	SX150X_456 = 1,
	SX150X_789 = 2,
};

enum {
	SX150X_789_REG_MISC_AUTOCLEAR_OFF = 1,
	SX150X_MAX_REGISTER = 173,
	SX150X_IRQ_TYPE_EDGE_RISING = 1,
	SX150X_IRQ_TYPE_EDGE_FALLING = 2,
	SX150X_789_RESET_KEY1 = 18,
	SX150X_789_RESET_KEY2 = 52,
};

enum {
	SYNTH_ERR_BAD_NAME = 0,
	SYNTH_ERR_INVALID_CMD = 1,
	SYNTH_ERR_INVALID_DYN_CMD = 2,
	SYNTH_ERR_EVENT_EXISTS = 3,
	SYNTH_ERR_TOO_MANY_FIELDS = 4,
	SYNTH_ERR_INCOMPLETE_TYPE = 5,
	SYNTH_ERR_INVALID_TYPE = 6,
	SYNTH_ERR_INVALID_FIELD = 7,
	SYNTH_ERR_INVALID_ARRAY_SPEC = 8,
};

enum {
	T3_REV_A = 0,
	T3_REV_B = 2,
	T3_REV_B2 = 3,
	T3_REV_C = 4,
};

enum {
	TASKLET_STATE_SCHED = 0,
	TASKLET_STATE_RUN = 1,
};

enum {
	TASKSTATS_CMD_ATTR_UNSPEC = 0,
	TASKSTATS_CMD_ATTR_PID = 1,
	TASKSTATS_CMD_ATTR_TGID = 2,
	TASKSTATS_CMD_ATTR_REGISTER_CPUMASK = 3,
	TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK = 4,
	__TASKSTATS_CMD_ATTR_MAX = 5,
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum {
	TASKSTATS_TYPE_UNSPEC = 0,
	TASKSTATS_TYPE_PID = 1,
	TASKSTATS_TYPE_TGID = 2,
	TASKSTATS_TYPE_STATS = 3,
	TASKSTATS_TYPE_AGGR_PID = 4,
	TASKSTATS_TYPE_AGGR_TGID = 5,
	TASKSTATS_TYPE_NULL = 6,
	__TASKSTATS_TYPE_MAX = 7,
};

enum {
	TASK_COMM_LEN = 16,
};

enum {
	TASK_REQ_UPIU_SIZE_DWORDS = 8,
	TASK_RSP_UPIU_SIZE_DWORDS = 8,
	ALIGNED_UPIU_SIZE = 512,
};

enum {
	TCA_ACT_UNSPEC = 0,
	TCA_ACT_KIND = 1,
	TCA_ACT_OPTIONS = 2,
	TCA_ACT_INDEX = 3,
	TCA_ACT_STATS = 4,
	TCA_ACT_PAD = 5,
	TCA_ACT_COOKIE = 6,
	TCA_ACT_FLAGS = 7,
	TCA_ACT_HW_STATS = 8,
	TCA_ACT_USED_HW_STATS = 9,
	TCA_ACT_IN_HW_COUNT = 10,
	__TCA_ACT_MAX = 11,
};

enum {
	TCA_EMATCH_TREE_UNSPEC = 0,
	TCA_EMATCH_TREE_HDR = 1,
	TCA_EMATCH_TREE_LIST = 2,
	__TCA_EMATCH_TREE_MAX = 3,
};

enum {
	TCA_FLOWER_KEY_CT_FLAGS_NEW = 1,
	TCA_FLOWER_KEY_CT_FLAGS_ESTABLISHED = 2,
	TCA_FLOWER_KEY_CT_FLAGS_RELATED = 4,
	TCA_FLOWER_KEY_CT_FLAGS_TRACKED = 8,
	TCA_FLOWER_KEY_CT_FLAGS_INVALID = 16,
	TCA_FLOWER_KEY_CT_FLAGS_REPLY = 32,
	__TCA_FLOWER_KEY_CT_FLAGS_MAX = 33,
};

enum {
	TCA_ROOT_UNSPEC = 0,
	TCA_ROOT_TAB = 1,
	TCA_ROOT_FLAGS = 2,
	TCA_ROOT_COUNT = 3,
	TCA_ROOT_TIME_DELTA = 4,
	TCA_ROOT_EXT_WARN_MSG = 5,
	__TCA_ROOT_MAX = 6,
};

enum {
	TCA_STAB_UNSPEC = 0,
	TCA_STAB_BASE = 1,
	TCA_STAB_DATA = 2,
	__TCA_STAB_MAX = 3,
};

enum {
	TCA_STATS_UNSPEC = 0,
	TCA_STATS_BASIC = 1,
	TCA_STATS_RATE_EST = 2,
	TCA_STATS_QUEUE = 3,
	TCA_STATS_APP = 4,
	TCA_STATS_RATE_EST64 = 5,
	TCA_STATS_PAD = 6,
	TCA_STATS_BASIC_HW = 7,
	TCA_STATS_PKT64 = 8,
	__TCA_STATS_MAX = 9,
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

enum {
	TCG_SECP_00 = 0,
	TCG_SECP_01 = 1,
};

enum {
	TCPF_ESTABLISHED = 2,
	TCPF_SYN_SENT = 4,
	TCPF_SYN_RECV = 8,
	TCPF_FIN_WAIT1 = 16,
	TCPF_FIN_WAIT2 = 32,
	TCPF_TIME_WAIT = 64,
	TCPF_CLOSE = 128,
	TCPF_CLOSE_WAIT = 256,
	TCPF_LAST_ACK = 512,
	TCPF_LISTEN = 1024,
	TCPF_CLOSING = 2048,
	TCPF_NEW_SYN_RECV = 4096,
	TCPF_BOUND_INACTIVE = 8192,
};

enum {
	TCP_BPF_BASE = 0,
	TCP_BPF_TX = 1,
	TCP_BPF_RX = 2,
	TCP_BPF_TXRX = 3,
	TCP_BPF_NUM_CFGS = 4,
};

enum {
	TCP_BPF_IPV4 = 0,
	TCP_BPF_IPV6 = 1,
	TCP_BPF_NUM_PROTS = 2,
};

enum {
	TCP_BPF_IW = 1001,
	TCP_BPF_SNDCWND_CLAMP = 1002,
	TCP_BPF_DELACK_MAX = 1003,
	TCP_BPF_RTO_MIN = 1004,
	TCP_BPF_SYN = 1005,
	TCP_BPF_SYN_IP = 1006,
	TCP_BPF_SYN_MAC = 1007,
};

enum {
	TCP_CMSG_INQ = 1,
	TCP_CMSG_TS = 2,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_BOUND_INACTIVE = 13,
	TCP_MAX_STATES = 14,
};

enum {
	TCP_FLAG_CWR = 32768,
	TCP_FLAG_ECE = 16384,
	TCP_FLAG_URG = 8192,
	TCP_FLAG_ACK = 4096,
	TCP_FLAG_PSH = 2048,
	TCP_FLAG_RST = 1024,
	TCP_FLAG_SYN = 512,
	TCP_FLAG_FIN = 256,
	TCP_RESERVED_BITS = 15,
	TCP_DATA_OFFSET = 240,
};

enum {
	TCP_METRICS_ATTR_UNSPEC = 0,
	TCP_METRICS_ATTR_ADDR_IPV4 = 1,
	TCP_METRICS_ATTR_ADDR_IPV6 = 2,
	TCP_METRICS_ATTR_AGE = 3,
	TCP_METRICS_ATTR_TW_TSVAL = 4,
	TCP_METRICS_ATTR_TW_TS_STAMP = 5,
	TCP_METRICS_ATTR_VALS = 6,
	TCP_METRICS_ATTR_FOPEN_MSS = 7,
	TCP_METRICS_ATTR_FOPEN_SYN_DROPS = 8,
	TCP_METRICS_ATTR_FOPEN_SYN_DROP_TS = 9,
	TCP_METRICS_ATTR_FOPEN_COOKIE = 10,
	TCP_METRICS_ATTR_SADDR_IPV4 = 11,
	TCP_METRICS_ATTR_SADDR_IPV6 = 12,
	TCP_METRICS_ATTR_PAD = 13,
	__TCP_METRICS_ATTR_MAX = 14,
};

enum {
	TCP_METRICS_CMD_UNSPEC = 0,
	TCP_METRICS_CMD_GET = 1,
	TCP_METRICS_CMD_DEL = 2,
	__TCP_METRICS_CMD_MAX = 3,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	TCP_NLA_PAD = 0,
	TCP_NLA_BUSY = 1,
	TCP_NLA_RWND_LIMITED = 2,
	TCP_NLA_SNDBUF_LIMITED = 3,
	TCP_NLA_DATA_SEGS_OUT = 4,
	TCP_NLA_TOTAL_RETRANS = 5,
	TCP_NLA_PACING_RATE = 6,
	TCP_NLA_DELIVERY_RATE = 7,
	TCP_NLA_SND_CWND = 8,
	TCP_NLA_REORDERING = 9,
	TCP_NLA_MIN_RTT = 10,
	TCP_NLA_RECUR_RETRANS = 11,
	TCP_NLA_DELIVERY_RATE_APP_LMT = 12,
	TCP_NLA_SNDQ_SIZE = 13,
	TCP_NLA_CA_STATE = 14,
	TCP_NLA_SND_SSTHRESH = 15,
	TCP_NLA_DELIVERED = 16,
	TCP_NLA_DELIVERED_CE = 17,
	TCP_NLA_BYTES_SENT = 18,
	TCP_NLA_BYTES_RETRANS = 19,
	TCP_NLA_DSACK_DUPS = 20,
	TCP_NLA_REORD_SEEN = 21,
	TCP_NLA_SRTT = 22,
	TCP_NLA_TIMEOUT_REHASH = 23,
	TCP_NLA_BYTES_NOTSENT = 24,
	TCP_NLA_EDT = 25,
	TCP_NLA_TTL = 26,
	TCP_NLA_REHASH = 27,
};

enum {
	TCP_NO_QUEUE = 0,
	TCP_RECV_QUEUE = 1,
	TCP_SEND_QUEUE = 2,
	TCP_QUEUES_NR = 3,
};

enum {
	TEST_ALIGNMENT = 16,
};

enum {
	TEST_NONE = 0,
	TEST_CORE = 1,
	TEST_CPUS = 2,
	TEST_PLATFORM = 3,
	TEST_DEVICES = 4,
	TEST_FREEZER = 5,
	__TEST_AFTER_LAST = 6,
};

enum {
	TLB_INVAL_SCOPE_GLOBAL = 0,
	TLB_INVAL_SCOPE_LPID = 1,
};

enum {
	TLS_ALERT_DESC_CLOSE_NOTIFY = 0,
	TLS_ALERT_DESC_UNEXPECTED_MESSAGE = 10,
	TLS_ALERT_DESC_BAD_RECORD_MAC = 20,
	TLS_ALERT_DESC_RECORD_OVERFLOW = 22,
	TLS_ALERT_DESC_HANDSHAKE_FAILURE = 40,
	TLS_ALERT_DESC_BAD_CERTIFICATE = 42,
	TLS_ALERT_DESC_UNSUPPORTED_CERTIFICATE = 43,
	TLS_ALERT_DESC_CERTIFICATE_REVOKED = 44,
	TLS_ALERT_DESC_CERTIFICATE_EXPIRED = 45,
	TLS_ALERT_DESC_CERTIFICATE_UNKNOWN = 46,
	TLS_ALERT_DESC_ILLEGAL_PARAMETER = 47,
	TLS_ALERT_DESC_UNKNOWN_CA = 48,
	TLS_ALERT_DESC_ACCESS_DENIED = 49,
	TLS_ALERT_DESC_DECODE_ERROR = 50,
	TLS_ALERT_DESC_DECRYPT_ERROR = 51,
	TLS_ALERT_DESC_TOO_MANY_CIDS_REQUESTED = 52,
	TLS_ALERT_DESC_PROTOCOL_VERSION = 70,
	TLS_ALERT_DESC_INSUFFICIENT_SECURITY = 71,
	TLS_ALERT_DESC_INTERNAL_ERROR = 80,
	TLS_ALERT_DESC_INAPPROPRIATE_FALLBACK = 86,
	TLS_ALERT_DESC_USER_CANCELED = 90,
	TLS_ALERT_DESC_MISSING_EXTENSION = 109,
	TLS_ALERT_DESC_UNSUPPORTED_EXTENSION = 110,
	TLS_ALERT_DESC_UNRECOGNIZED_NAME = 112,
	TLS_ALERT_DESC_BAD_CERTIFICATE_STATUS_RESPONSE = 113,
	TLS_ALERT_DESC_UNKNOWN_PSK_IDENTITY = 115,
	TLS_ALERT_DESC_CERTIFICATE_REQUIRED = 116,
	TLS_ALERT_DESC_NO_APPLICATION_PROTOCOL = 120,
};

enum {
	TLS_ALERT_LEVEL_WARNING = 1,
	TLS_ALERT_LEVEL_FATAL = 2,
};

enum {
	TLS_NO_KEYRING = 0,
	TLS_NO_PEERID = 0,
	TLS_NO_CERT = 0,
	TLS_NO_PRIVKEY = 0,
};

enum {
	TLS_RECORD_TYPE_CHANGE_CIPHER_SPEC = 20,
	TLS_RECORD_TYPE_ALERT = 21,
	TLS_RECORD_TYPE_HANDSHAKE = 22,
	TLS_RECORD_TYPE_DATA = 23,
	TLS_RECORD_TYPE_HEARTBEAT = 24,
	TLS_RECORD_TYPE_TLS12_CID = 25,
	TLS_RECORD_TYPE_ACK = 26,
};

enum {
	TMF_INITIAL = 0,
	TMF_QUEUED = 1,
	TMF_SUCCESS = 2,
	TMF_FAILED = 3,
	TMF_TIMEDOUT = 4,
	TMF_NOT_FOUND = 5,
};

enum {
	TOO_MANY_CLOSE = -1,
	TOO_MANY_OPEN = -2,
	MISSING_QUOTE = -3,
};

enum {
	TPS65090_IRQ_INTERRUPT = 0,
	TPS65090_IRQ_VAC_STATUS_CHANGE = 1,
	TPS65090_IRQ_VSYS_STATUS_CHANGE = 2,
	TPS65090_IRQ_BAT_STATUS_CHANGE = 3,
	TPS65090_IRQ_CHARGING_STATUS_CHANGE = 4,
	TPS65090_IRQ_CHARGING_COMPLETE = 5,
	TPS65090_IRQ_OVERLOAD_DCDC1 = 6,
	TPS65090_IRQ_OVERLOAD_DCDC2 = 7,
	TPS65090_IRQ_OVERLOAD_DCDC3 = 8,
	TPS65090_IRQ_OVERLOAD_FET1 = 9,
	TPS65090_IRQ_OVERLOAD_FET2 = 10,
	TPS65090_IRQ_OVERLOAD_FET3 = 11,
	TPS65090_IRQ_OVERLOAD_FET4 = 12,
	TPS65090_IRQ_OVERLOAD_FET5 = 13,
	TPS65090_IRQ_OVERLOAD_FET6 = 14,
	TPS65090_IRQ_OVERLOAD_FET7 = 15,
};

enum {
	TPS65090_REGULATOR_DCDC1 = 0,
	TPS65090_REGULATOR_DCDC2 = 1,
	TPS65090_REGULATOR_DCDC3 = 2,
	TPS65090_REGULATOR_FET1 = 3,
	TPS65090_REGULATOR_FET2 = 4,
	TPS65090_REGULATOR_FET3 = 5,
	TPS65090_REGULATOR_FET4 = 6,
	TPS65090_REGULATOR_FET5 = 7,
	TPS65090_REGULATOR_FET6 = 8,
	TPS65090_REGULATOR_FET7 = 9,
	TPS65090_REGULATOR_LDO1 = 10,
	TPS65090_REGULATOR_LDO2 = 11,
	TPS65090_REGULATOR_MAX = 12,
};

enum {
	TPS6586X_ID_SYS = 0,
	TPS6586X_ID_SM_0 = 1,
	TPS6586X_ID_SM_1 = 2,
	TPS6586X_ID_SM_2 = 3,
	TPS6586X_ID_LDO_0 = 4,
	TPS6586X_ID_LDO_1 = 5,
	TPS6586X_ID_LDO_2 = 6,
	TPS6586X_ID_LDO_3 = 7,
	TPS6586X_ID_LDO_4 = 8,
	TPS6586X_ID_LDO_5 = 9,
	TPS6586X_ID_LDO_6 = 10,
	TPS6586X_ID_LDO_7 = 11,
	TPS6586X_ID_LDO_8 = 12,
	TPS6586X_ID_LDO_9 = 13,
	TPS6586X_ID_LDO_RTC = 14,
	TPS6586X_ID_MAX_REGULATOR = 15,
};

enum {
	TPS6586X_INT_PLDO_0 = 0,
	TPS6586X_INT_PLDO_1 = 1,
	TPS6586X_INT_PLDO_2 = 2,
	TPS6586X_INT_PLDO_3 = 3,
	TPS6586X_INT_PLDO_4 = 4,
	TPS6586X_INT_PLDO_5 = 5,
	TPS6586X_INT_PLDO_6 = 6,
	TPS6586X_INT_PLDO_7 = 7,
	TPS6586X_INT_COMP_DET = 8,
	TPS6586X_INT_ADC = 9,
	TPS6586X_INT_PLDO_8 = 10,
	TPS6586X_INT_PLDO_9 = 11,
	TPS6586X_INT_PSM_0 = 12,
	TPS6586X_INT_PSM_1 = 13,
	TPS6586X_INT_PSM_2 = 14,
	TPS6586X_INT_PSM_3 = 15,
	TPS6586X_INT_RTC_ALM1 = 16,
	TPS6586X_INT_ACUSB_OVP = 17,
	TPS6586X_INT_USB_DET = 18,
	TPS6586X_INT_AC_DET = 19,
	TPS6586X_INT_BAT_DET = 20,
	TPS6586X_INT_CHG_STAT = 21,
	TPS6586X_INT_CHG_TEMP = 22,
	TPS6586X_INT_PP = 23,
	TPS6586X_INT_RESUME = 24,
	TPS6586X_INT_LOW_SYS = 25,
	TPS6586X_INT_RTC_ALM2 = 26,
};

enum {
	TP_ERR_FILE_NOT_FOUND = 0,
	TP_ERR_NO_REGULAR_FILE = 1,
	TP_ERR_BAD_REFCNT = 2,
	TP_ERR_REFCNT_OPEN_BRACE = 3,
	TP_ERR_BAD_REFCNT_SUFFIX = 4,
	TP_ERR_BAD_UPROBE_OFFS = 5,
	TP_ERR_BAD_MAXACT_TYPE = 6,
	TP_ERR_BAD_MAXACT = 7,
	TP_ERR_MAXACT_TOO_BIG = 8,
	TP_ERR_BAD_PROBE_ADDR = 9,
	TP_ERR_NON_UNIQ_SYMBOL = 10,
	TP_ERR_BAD_RETPROBE = 11,
	TP_ERR_NO_TRACEPOINT = 12,
	TP_ERR_BAD_ADDR_SUFFIX = 13,
	TP_ERR_NO_GROUP_NAME = 14,
	TP_ERR_GROUP_TOO_LONG = 15,
	TP_ERR_BAD_GROUP_NAME = 16,
	TP_ERR_NO_EVENT_NAME = 17,
	TP_ERR_EVENT_TOO_LONG = 18,
	TP_ERR_BAD_EVENT_NAME = 19,
	TP_ERR_EVENT_EXIST = 20,
	TP_ERR_RETVAL_ON_PROBE = 21,
	TP_ERR_NO_RETVAL = 22,
	TP_ERR_BAD_STACK_NUM = 23,
	TP_ERR_BAD_ARG_NUM = 24,
	TP_ERR_BAD_VAR = 25,
	TP_ERR_BAD_REG_NAME = 26,
	TP_ERR_BAD_MEM_ADDR = 27,
	TP_ERR_BAD_IMM = 28,
	TP_ERR_IMMSTR_NO_CLOSE = 29,
	TP_ERR_FILE_ON_KPROBE = 30,
	TP_ERR_BAD_FILE_OFFS = 31,
	TP_ERR_SYM_ON_UPROBE = 32,
	TP_ERR_TOO_MANY_OPS = 33,
	TP_ERR_DEREF_NEED_BRACE = 34,
	TP_ERR_BAD_DEREF_OFFS = 35,
	TP_ERR_DEREF_OPEN_BRACE = 36,
	TP_ERR_COMM_CANT_DEREF = 37,
	TP_ERR_BAD_FETCH_ARG = 38,
	TP_ERR_ARRAY_NO_CLOSE = 39,
	TP_ERR_BAD_ARRAY_SUFFIX = 40,
	TP_ERR_BAD_ARRAY_NUM = 41,
	TP_ERR_ARRAY_TOO_BIG = 42,
	TP_ERR_BAD_TYPE = 43,
	TP_ERR_BAD_STRING = 44,
	TP_ERR_BAD_SYMSTRING = 45,
	TP_ERR_BAD_BITFIELD = 46,
	TP_ERR_ARG_NAME_TOO_LONG = 47,
	TP_ERR_NO_ARG_NAME = 48,
	TP_ERR_BAD_ARG_NAME = 49,
	TP_ERR_USED_ARG_NAME = 50,
	TP_ERR_ARG_TOO_LONG = 51,
	TP_ERR_NO_ARG_BODY = 52,
	TP_ERR_BAD_INSN_BNDRY = 53,
	TP_ERR_FAIL_REG_PROBE = 54,
	TP_ERR_DIFF_PROBE_TYPE = 55,
	TP_ERR_DIFF_ARG_TYPE = 56,
	TP_ERR_SAME_PROBE = 57,
	TP_ERR_NO_EVENT_INFO = 58,
	TP_ERR_BAD_ATTACH_EVENT = 59,
	TP_ERR_BAD_ATTACH_ARG = 60,
	TP_ERR_NO_EP_FILTER = 61,
	TP_ERR_NOSUP_BTFARG = 62,
	TP_ERR_NO_BTFARG = 63,
	TP_ERR_NO_BTF_ENTRY = 64,
	TP_ERR_BAD_VAR_ARGS = 65,
	TP_ERR_NOFENTRY_ARGS = 66,
	TP_ERR_DOUBLE_ARGS = 67,
	TP_ERR_ARGS_2LONG = 68,
	TP_ERR_ARGIDX_2BIG = 69,
	TP_ERR_NO_PTR_STRCT = 70,
	TP_ERR_NOSUP_DAT_ARG = 71,
	TP_ERR_BAD_HYPHEN = 72,
	TP_ERR_NO_BTF_FIELD = 73,
	TP_ERR_BAD_BTF_TID = 74,
	TP_ERR_BAD_TYPE4STR = 75,
	TP_ERR_NEED_STRING_TYPE = 76,
};

enum {
	TRACEFS_EVENT_INODE = 2,
	TRACEFS_GID_PERM_SET = 4,
	TRACEFS_UID_PERM_SET = 8,
	TRACEFS_INSTANCE_INODE = 16,
};

enum {
	TRACE_ARRAY_FL_GLOBAL = 1,
};

enum {
	TRACE_CTX_NMI = 0,
	TRACE_CTX_IRQ = 1,
	TRACE_CTX_SOFTIRQ = 2,
	TRACE_CTX_NORMAL = 3,
	TRACE_CTX_TRANSITION = 4,
};

enum {
	TRACE_EVENT_FL_FILTERED = 1,
	TRACE_EVENT_FL_CAP_ANY = 2,
	TRACE_EVENT_FL_NO_SET_FILTER = 4,
	TRACE_EVENT_FL_IGNORE_ENABLE = 8,
	TRACE_EVENT_FL_TRACEPOINT = 16,
	TRACE_EVENT_FL_DYNAMIC = 32,
	TRACE_EVENT_FL_KPROBE = 64,
	TRACE_EVENT_FL_UPROBE = 128,
	TRACE_EVENT_FL_EPROBE = 256,
	TRACE_EVENT_FL_FPROBE = 512,
	TRACE_EVENT_FL_CUSTOM = 1024,
};

enum {
	TRACE_EVENT_FL_FILTERED_BIT = 0,
	TRACE_EVENT_FL_CAP_ANY_BIT = 1,
	TRACE_EVENT_FL_NO_SET_FILTER_BIT = 2,
	TRACE_EVENT_FL_IGNORE_ENABLE_BIT = 3,
	TRACE_EVENT_FL_TRACEPOINT_BIT = 4,
	TRACE_EVENT_FL_DYNAMIC_BIT = 5,
	TRACE_EVENT_FL_KPROBE_BIT = 6,
	TRACE_EVENT_FL_UPROBE_BIT = 7,
	TRACE_EVENT_FL_EPROBE_BIT = 8,
	TRACE_EVENT_FL_FPROBE_BIT = 9,
	TRACE_EVENT_FL_CUSTOM_BIT = 10,
};

enum {
	TRACE_FTRACE_BIT = 0,
	TRACE_FTRACE_NMI_BIT = 1,
	TRACE_FTRACE_IRQ_BIT = 2,
	TRACE_FTRACE_SIRQ_BIT = 3,
	TRACE_FTRACE_TRANSITION_BIT = 4,
	TRACE_INTERNAL_BIT = 5,
	TRACE_INTERNAL_NMI_BIT = 6,
	TRACE_INTERNAL_IRQ_BIT = 7,
	TRACE_INTERNAL_SIRQ_BIT = 8,
	TRACE_INTERNAL_TRANSITION_BIT = 9,
	TRACE_BRANCH_BIT = 10,
	TRACE_IRQ_BIT = 11,
	TRACE_GRAPH_BIT = 12,
	TRACE_GRAPH_DEPTH_START_BIT = 13,
	TRACE_GRAPH_DEPTH_END_BIT = 14,
	TRACE_GRAPH_NOTRACE_BIT = 15,
	TRACE_RECORD_RECURSION_BIT = 16,
};

enum {
	TRACE_FUNC_NO_OPTS = 0,
	TRACE_FUNC_OPT_STACK = 1,
	TRACE_FUNC_OPT_NO_REPEATS = 2,
	TRACE_FUNC_OPT_HIGHEST_BIT = 4,
};

enum {
	TRACE_NOP_OPT_ACCEPT = 1,
	TRACE_NOP_OPT_REFUSE = 2,
};

enum {
	TRACE_PIDS = 1,
	TRACE_NO_PIDS = 2,
};

enum {
	TRACE_SIGNAL_DELIVERED = 0,
	TRACE_SIGNAL_IGNORED = 1,
	TRACE_SIGNAL_ALREADY_PENDING = 2,
	TRACE_SIGNAL_OVERFLOW_FAIL = 3,
	TRACE_SIGNAL_LOSE_INFO = 4,
};

enum {
	TVPADDRW = 0,
	TVPPDATA = 4,
	TVPPMASK = 8,
	TVPPADRR = 12,
	TVPCADRW = 16,
	TVPCDATA = 20,
	TVPCADRR = 28,
	TVPDCCTL = 36,
	TVPIDATA = 40,
	TVPCRDAT = 44,
	TVPCXPOL = 48,
	TVPCXPOH = 52,
	TVPCYPOL = 56,
	TVPCYPOH = 60,
};

enum {
	TVPIRREV = 1,
	TVPIRICC = 6,
	TVPIRBRC = 7,
	TVPIRLAC = 15,
	TVPIRTCC = 24,
	TVPIRMXC = 25,
	TVPIRCLS = 26,
	TVPIRPPG = 28,
	TVPIRGEC = 29,
	TVPIRMIC = 30,
	TVPIRPLA = 44,
	TVPIRPPD = 45,
	TVPIRMPD = 46,
	TVPIRLPD = 47,
	TVPIRCKL = 48,
	TVPIRCKH = 49,
	TVPIRCRL = 50,
	TVPIRCRH = 51,
	TVPIRCGL = 52,
	TVPIRCGH = 53,
	TVPIRCBL = 54,
	TVPIRCBH = 55,
	TVPIRCKC = 56,
	TVPIRMLC = 57,
	TVPIRSEN = 58,
	TVPIRTMD = 59,
	TVPIRRML = 60,
	TVPIRRMM = 61,
	TVPIRRMS = 62,
	TVPIRDID = 63,
	TVPIRRES = 255,
};

enum {
	TXQ_ETH = 0,
	TXQ_OFLD = 1,
	TXQ_CTRL = 2,
};

enum {
	TXQ_RUNNING = 1,
	TXQ_LAST_PKT_DB = 2,
};

enum {
	TYPE_MAX8998 = 0,
	TYPE_LP3974 = 1,
	TYPE_LP3979 = 2,
};

enum {
	TYPE_SRB = 0,
	TYPE_TGT_CMD = 1,
	TYPE_TGT_TMCMD = 2,
};

enum {
	UDP_BPF_IPV4 = 0,
	UDP_BPF_IPV6 = 1,
	UDP_BPF_NUM_PROTS = 2,
};

enum {
	UDP_FLAGS_CORK = 0,
	UDP_FLAGS_NO_CHECK6_TX = 1,
	UDP_FLAGS_NO_CHECK6_RX = 2,
	UDP_FLAGS_GRO_ENABLED = 3,
	UDP_FLAGS_ACCEPT_FRAGLIST = 4,
	UDP_FLAGS_ACCEPT_L4 = 5,
	UDP_FLAGS_ENCAP_ENABLED = 6,
	UDP_FLAGS_UDPLITE_SEND_CC = 7,
	UDP_FLAGS_UDPLITE_RECV_CC = 8,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	UFSHCD_EH_IN_PROGRESS = 1,
};

enum {
	UFSHCD_MAX_CHANNEL = 0,
	UFSHCD_MAX_ID = 1,
	UFSHCD_CMD_PER_LUN = 31,
	UFSHCD_CAN_QUEUE = 31,
};

enum {
	UFSHCD_NANO_AMP = 0,
	UFSHCD_MICRO_AMP = 1,
	UFSHCD_MILI_AMP = 2,
	UFSHCD_AMP = 3,
};

enum {
	UFSHCD_POLL_FROM_INTERRUPT_CONTEXT = -1,
};

enum {
	UFSHCD_UIC_DL_PA_INIT_ERROR = 1,
	UFSHCD_UIC_DL_NAC_RECEIVED_ERROR = 2,
	UFSHCD_UIC_DL_TCx_REPLAY_ERROR = 4,
	UFSHCD_UIC_NL_ERROR = 8,
	UFSHCD_UIC_TL_ERROR = 16,
	UFSHCD_UIC_DME_ERROR = 32,
	UFSHCD_UIC_PA_GENERIC_ERROR = 64,
};

enum {
	UFS_ABORT_TASK = 1,
	UFS_ABORT_TASK_SET = 2,
	UFS_CLEAR_TASK_SET = 4,
	UFS_LOGICAL_RESET = 8,
	UFS_QUERY_TASK = 128,
	UFS_QUERY_TASK_SET = 129,
};

enum {
	UFS_DEV_LOW_TEMP_NOTIF = 16,
	UFS_DEV_HIGH_TEMP_NOTIF = 32,
	UFS_DEV_EXT_TEMP_NOTIF = 64,
	UFS_DEV_HPB_SUPPORT = 128,
	UFS_DEV_WRITE_BOOSTER_SUP = 256,
	UFS_DEV_EXT_IID_SUP = 65536,
};

enum {
	UFS_UPIU_REPORT_LUNS_WLUN = 129,
	UFS_UPIU_UFS_DEVICE_WLUN = 208,
	UFS_UPIU_BOOT_WLUN = 176,
	UFS_UPIU_RPMB_WLUN = 196,
};

enum {
	ULP_MEM_READ = 2,
	ULP_MEM_WRITE = 3,
	ULP_TXPKT = 4,
};

enum {
	ULP_TX_SC_NOOP = 128,
	ULP_TX_SC_IMM = 129,
	ULP_TX_SC_DSGL = 130,
	ULP_TX_SC_ISGL = 131,
	ULP_TX_SC_MEMRD = 134,
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

enum {
	UNKNOWN_CLASS = 0,
	NIC_CLASS = 1,
	FCOE_CLASS = 2,
	ISCSI_CLASS = 3,
};

enum {
	UPIU_CMD_FLAGS_NONE = 0,
	UPIU_CMD_FLAGS_CP = 4,
	UPIU_CMD_FLAGS_WRITE = 32,
	UPIU_CMD_FLAGS_READ = 64,
};

enum {
	UPIU_COMMAND_SET_TYPE_SCSI = 0,
	UPIU_COMMAND_SET_TYPE_UFS = 1,
	UPIU_COMMAND_SET_TYPE_QUERY = 2,
};

enum {
	UPIU_QUERY_FUNC_STANDARD_READ_REQUEST = 1,
	UPIU_QUERY_FUNC_STANDARD_WRITE_REQUEST = 129,
};

enum {
	UPIU_RSP_FLAG_UNDERFLOW = 32,
	UPIU_RSP_FLAG_OVERFLOW = 64,
};

enum {
	UPIU_TASK_MANAGEMENT_FUNC_COMPL = 0,
	UPIU_TASK_MANAGEMENT_FUNC_NOT_SUPPORTED = 4,
	UPIU_TASK_MANAGEMENT_FUNC_SUCCEEDED = 8,
	UPIU_TASK_MANAGEMENT_FUNC_FAILED = 5,
	UPIU_INCORRECT_LOGICAL_UNIT_NO = 9,
};

enum {
	UTP_CMD_TYPE_UFS_STORAGE = 1,
};

enum {
	VERBOSE_STATUS = 1,
};

enum {
	VERR_NO_ERROR = 0,
	VERR_CR_ASSOC_LEN = 1,
	VERR_CR_ASSOC_RQST_LEN = 2,
	VERR_CR_ASSOC_CMD = 3,
	VERR_CR_ASSOC_CMD_LEN = 4,
	VERR_ERSP_RATIO = 5,
	VERR_ASSOC_ALLOC_FAIL = 6,
	VERR_QUEUE_ALLOC_FAIL = 7,
	VERR_CR_CONN_LEN = 8,
	VERR_CR_CONN_RQST_LEN = 9,
	VERR_ASSOC_ID = 10,
	VERR_ASSOC_ID_LEN = 11,
	VERR_NO_ASSOC = 12,
	VERR_CONN_ID = 13,
	VERR_CONN_ID_LEN = 14,
	VERR_INVAL_CONN = 15,
	VERR_CR_CONN_CMD = 16,
	VERR_CR_CONN_CMD_LEN = 17,
	VERR_DISCONN_LEN = 18,
	VERR_DISCONN_RQST_LEN = 19,
	VERR_DISCONN_CMD = 20,
	VERR_DISCONN_CMD_LEN = 21,
	VERR_DISCONN_SCOPE = 22,
	VERR_RS_LEN = 23,
	VERR_RS_RQST_LEN = 24,
	VERR_RS_CMD = 25,
	VERR_RS_CMD_LEN = 26,
	VERR_RS_RCTL = 27,
	VERR_RS_RO = 28,
	VERR_LSACC = 29,
	VERR_LSDESC_RQST = 30,
	VERR_LSDESC_RQST_LEN = 31,
	VERR_CR_ASSOC = 32,
	VERR_CR_ASSOC_ACC_LEN = 33,
	VERR_CR_CONN = 34,
	VERR_CR_CONN_ACC_LEN = 35,
	VERR_DISCONN = 36,
	VERR_DISCONN_ACC_LEN = 37,
};

enum {
	VIA_BAD_PREQ = 1,
	VIA_BAD_CLK66 = 2,
	VIA_SET_FIFO = 4,
	VIA_NO_UNMASK = 8,
	VIA_BAD_ID = 16,
	VIA_BAD_AST = 32,
	VIA_NO_ENABLES = 64,
	VIA_SATA_PATA = 128,
};

enum {
	VIA_IDFLAG_SINGLE = 1,
};

enum {
	VMGENID_SIZE = 16,
};

enum {
	VSC8211_SIGDET_CTRL = 19,
	VSC8211_EXT_CTRL = 23,
	VSC8211_INTR_ENABLE = 25,
	VSC8211_INTR_STATUS = 26,
	VSC8211_LED_CTRL = 27,
	VSC8211_AUX_CTRL_STAT = 28,
	VSC8211_EXT_PAGE_AXS = 31,
};

enum {
	VSC_CTRL_CLAUSE37_VIEW = 16,
	VSC_CTRL_MEDIA_MODE_HI = 61440,
};

enum {
	VSC_INTR_RX_ERR = 1,
	VSC_INTR_MS_ERR = 2,
	VSC_INTR_CABLE = 4,
	VSC_INTR_FALSE_CARR = 8,
	VSC_INTR_MEDIA_CHG = 16,
	VSC_INTR_RX_FIFO = 32,
	VSC_INTR_TX_FIFO = 64,
	VSC_INTR_DESCRAMBL = 128,
	VSC_INTR_SYMBOL_ERR = 256,
	VSC_INTR_NEG_DONE = 1024,
	VSC_INTR_NEG_ERR = 2048,
	VSC_INTR_DPLX_CHG = 4096,
	VSC_INTR_LINK_CHG = 8192,
	VSC_INTR_SPD_CHG = 16384,
	VSC_INTR_ENABLE = 32768,
};

enum {
	VSC_MMIO_BAR = 0,
	VSC_SATA_INT_STAT_OFFSET = 0,
	VSC_SATA_INT_MASK_OFFSET = 4,
	VSC_SATA_TF_CMD_OFFSET = 0,
	VSC_SATA_TF_DATA_OFFSET = 0,
	VSC_SATA_TF_ERROR_OFFSET = 4,
	VSC_SATA_TF_FEATURE_OFFSET = 6,
	VSC_SATA_TF_NSECT_OFFSET = 8,
	VSC_SATA_TF_LBAL_OFFSET = 12,
	VSC_SATA_TF_LBAM_OFFSET = 16,
	VSC_SATA_TF_LBAH_OFFSET = 20,
	VSC_SATA_TF_DEVICE_OFFSET = 24,
	VSC_SATA_TF_STATUS_OFFSET = 28,
	VSC_SATA_TF_COMMAND_OFFSET = 29,
	VSC_SATA_TF_ALTSTATUS_OFFSET = 40,
	VSC_SATA_TF_CTL_OFFSET = 41,
	VSC_SATA_UP_DESCRIPTOR_OFFSET = 100,
	VSC_SATA_UP_DATA_BUFFER_OFFSET = 108,
	VSC_SATA_DMA_CMD_OFFSET = 112,
	VSC_SATA_SCR_STATUS_OFFSET = 256,
	VSC_SATA_SCR_ERROR_OFFSET = 260,
	VSC_SATA_SCR_CONTROL_OFFSET = 264,
	VSC_SATA_PORT_OFFSET = 512,
	VSC_SATA_INT_ERROR_CRC = 64,
	VSC_SATA_INT_ERROR_T = 32,
	VSC_SATA_INT_ERROR_P = 16,
	VSC_SATA_INT_ERROR_R = 8,
	VSC_SATA_INT_ERROR_E = 4,
	VSC_SATA_INT_ERROR_M = 2,
	VSC_SATA_INT_PHY_CHANGE = 1,
	VSC_SATA_INT_ERROR = 127,
};

enum {
	VTIME_PER_SEC_SHIFT = 37ULL,
	VTIME_PER_SEC = 137438953472ULL,
	VTIME_PER_USEC = 137438ULL,
	VTIME_PER_NSEC = 137ULL,
	VRATE_MIN_PPM = 10000ULL,
	VRATE_MAX_PPM = 100000000ULL,
	VRATE_MIN = 1374ULL,
	VRATE_CLAMP_ADJ_PCT = 4ULL,
	AUTOP_CYCLE_NSEC = 10000000000ULL,
};

enum {
	WALK_TRAILING = 1,
	WALK_MORE = 2,
	WALK_NOFOLLOW = 4,
};

enum {
	WBT_RWQ_BG = 0,
	WBT_RWQ_KSWAPD = 1,
	WBT_RWQ_DISCARD = 2,
	WBT_NUM_RWQ = 3,
};

enum {
	WBT_STATE_ON_DEFAULT = 1,
	WBT_STATE_ON_MANUAL = 2,
	WBT_STATE_OFF_DEFAULT = 3,
	WBT_STATE_OFF_MANUAL = 4,
};

enum {
	WB_BUF_MODE_LU_DEDICATED = 0,
	WB_BUF_MODE_SHARED = 1,
};

enum {
	XA_CHECK_SCHED = 4096,
};

enum {
	XDP_ATTACHED_NONE = 0,
	XDP_ATTACHED_DRV = 1,
	XDP_ATTACHED_SKB = 2,
	XDP_ATTACHED_HW = 3,
	XDP_ATTACHED_MULTI = 4,
};

enum {
	XFRM_DEV_OFFLOAD_FLAG_ACQ = 1,
};

enum {
	XFRM_DEV_OFFLOAD_IN = 1,
	XFRM_DEV_OFFLOAD_OUT = 2,
	XFRM_DEV_OFFLOAD_FWD = 3,
};

enum {
	XFRM_DEV_OFFLOAD_UNSPECIFIED = 0,
	XFRM_DEV_OFFLOAD_CRYPTO = 1,
	XFRM_DEV_OFFLOAD_PACKET = 2,
};

enum {
	XFRM_LOOKUP_ICMP = 1,
	XFRM_LOOKUP_QUEUE = 2,
	XFRM_LOOKUP_KEEP_DST_REF = 4,
};

enum {
	XFRM_MODE_FLAG_TUNNEL = 1,
};

enum {
	XFRM_MSG_BASE = 16,
	XFRM_MSG_NEWSA = 16,
	XFRM_MSG_DELSA = 17,
	XFRM_MSG_GETSA = 18,
	XFRM_MSG_NEWPOLICY = 19,
	XFRM_MSG_DELPOLICY = 20,
	XFRM_MSG_GETPOLICY = 21,
	XFRM_MSG_ALLOCSPI = 22,
	XFRM_MSG_ACQUIRE = 23,
	XFRM_MSG_EXPIRE = 24,
	XFRM_MSG_UPDPOLICY = 25,
	XFRM_MSG_UPDSA = 26,
	XFRM_MSG_POLEXPIRE = 27,
	XFRM_MSG_FLUSHSA = 28,
	XFRM_MSG_FLUSHPOLICY = 29,
	XFRM_MSG_NEWAE = 30,
	XFRM_MSG_GETAE = 31,
	XFRM_MSG_REPORT = 32,
	XFRM_MSG_MIGRATE = 33,
	XFRM_MSG_NEWSADINFO = 34,
	XFRM_MSG_GETSADINFO = 35,
	XFRM_MSG_NEWSPDINFO = 36,
	XFRM_MSG_GETSPDINFO = 37,
	XFRM_MSG_MAPPING = 38,
	XFRM_MSG_SETDEFAULT = 39,
	XFRM_MSG_GETDEFAULT = 40,
	__XFRM_MSG_MAX = 41,
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum {
	XFRM_POLICY_TYPE_MAIN = 0,
	XFRM_POLICY_TYPE_SUB = 1,
	XFRM_POLICY_TYPE_MAX = 2,
	XFRM_POLICY_TYPE_ANY = 255,
};

enum {
	XFRM_STATE_VOID = 0,
	XFRM_STATE_ACQ = 1,
	XFRM_STATE_VALID = 2,
	XFRM_STATE_ERROR = 3,
	XFRM_STATE_EXPIRED = 4,
	XFRM_STATE_DEAD = 5,
};

enum {
	XIVE_SYNC_EAS = 1,
	XIVE_SYNC_QUEUE = 2,
};

enum {
	ZONELIST_FALLBACK = 0,
	ZONELIST_NOFALLBACK = 1,
	MAX_ZONELISTS = 2,
};

enum {
	ZSTDbss_compress = 0,
	ZSTDbss_noCompress = 1,
};

enum {
	_DQUOT_USAGE_ENABLED = 0,
	_DQUOT_LIMITS_ENABLED = 1,
	_DQUOT_SUSPENDED = 2,
	_DQUOT_STATE_FLAGS = 3,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 2048,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_MOVE_PCNTXT = 16384,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2096911,
};

enum {
	__F0_INTX_STATUS_MSIX = 0,
	__F0_INTX_STATUS_INTA = 1,
	__F0_INTX_STATUS_INTB = 2,
	__F0_INTX_STATUS_INTC = 3,
	__F0_INTX_STATUS_INTD = 4,
};

enum {
	__IOAM6_IPTUNNEL_MODE_MIN = 0,
	IOAM6_IPTUNNEL_MODE_INLINE = 1,
	IOAM6_IPTUNNEL_MODE_ENCAP = 2,
	IOAM6_IPTUNNEL_MODE_AUTO = 3,
	__IOAM6_IPTUNNEL_MODE_MAX = 4,
};

enum {
	__ND_OPT_PREFIX_INFO_END = 0,
	ND_OPT_SOURCE_LL_ADDR = 1,
	ND_OPT_TARGET_LL_ADDR = 2,
	ND_OPT_PREFIX_INFO = 3,
	ND_OPT_REDIRECT_HDR = 4,
	ND_OPT_MTU = 5,
	ND_OPT_NONCE = 14,
	__ND_OPT_ARRAY_MAX = 15,
	ND_OPT_ROUTE_INFO = 24,
	ND_OPT_RDNSS = 25,
	ND_OPT_DNSSL = 31,
	ND_OPT_6CO = 34,
	ND_OPT_CAPTIVE_PORTAL = 37,
	ND_OPT_PREF64 = 38,
	__ND_OPT_MAX = 39,
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

enum {
	__SCHED_FEAT_PLACE_LAG = 0,
	__SCHED_FEAT_PLACE_DEADLINE_INITIAL = 1,
	__SCHED_FEAT_RUN_TO_PARITY = 2,
	__SCHED_FEAT_NEXT_BUDDY = 3,
	__SCHED_FEAT_CACHE_HOT_BUDDY = 4,
	__SCHED_FEAT_WAKEUP_PREEMPTION = 5,
	__SCHED_FEAT_HRTICK = 6,
	__SCHED_FEAT_HRTICK_DL = 7,
	__SCHED_FEAT_DOUBLE_TICK = 8,
	__SCHED_FEAT_NONTASK_CAPACITY = 9,
	__SCHED_FEAT_TTWU_QUEUE = 10,
	__SCHED_FEAT_SIS_UTIL = 11,
	__SCHED_FEAT_WARN_DOUBLE_CLOCK = 12,
	__SCHED_FEAT_RT_PUSH_IPI = 13,
	__SCHED_FEAT_RT_RUNTIME_SHARE = 14,
	__SCHED_FEAT_LB_MIN = 15,
	__SCHED_FEAT_ATTACH_AGE_LOAD = 16,
	__SCHED_FEAT_WA_IDLE = 17,
	__SCHED_FEAT_WA_WEIGHT = 18,
	__SCHED_FEAT_WA_BIAS = 19,
	__SCHED_FEAT_UTIL_EST = 20,
	__SCHED_FEAT_LATENCY_WARN = 21,
	__SCHED_FEAT_HZ_BW = 22,
	__SCHED_FEAT_NR = 23,
};

enum {
	__SD_BALANCE_NEWIDLE = 0,
	__SD_BALANCE_EXEC = 1,
	__SD_BALANCE_FORK = 2,
	__SD_BALANCE_WAKE = 3,
	__SD_WAKE_AFFINE = 4,
	__SD_ASYM_CPUCAPACITY = 5,
	__SD_ASYM_CPUCAPACITY_FULL = 6,
	__SD_SHARE_CPUCAPACITY = 7,
	__SD_CLUSTER = 8,
	__SD_SHARE_LLC = 9,
	__SD_SERIALIZE = 10,
	__SD_ASYM_PACKING = 11,
	__SD_PREFER_SIBLING = 12,
	__SD_OVERLAP = 13,
	__SD_NUMA = 14,
	__SD_FLAG_CNT = 15,
};

enum {
	___GFP_DMA_BIT = 0,
	___GFP_HIGHMEM_BIT = 1,
	___GFP_DMA32_BIT = 2,
	___GFP_MOVABLE_BIT = 3,
	___GFP_RECLAIMABLE_BIT = 4,
	___GFP_HIGH_BIT = 5,
	___GFP_IO_BIT = 6,
	___GFP_FS_BIT = 7,
	___GFP_ZERO_BIT = 8,
	___GFP_UNUSED_BIT = 9,
	___GFP_DIRECT_RECLAIM_BIT = 10,
	___GFP_KSWAPD_RECLAIM_BIT = 11,
	___GFP_WRITE_BIT = 12,
	___GFP_NOWARN_BIT = 13,
	___GFP_RETRY_MAYFAIL_BIT = 14,
	___GFP_NOFAIL_BIT = 15,
	___GFP_NORETRY_BIT = 16,
	___GFP_MEMALLOC_BIT = 17,
	___GFP_COMP_BIT = 18,
	___GFP_NOMEMALLOC_BIT = 19,
	___GFP_HARDWALL_BIT = 20,
	___GFP_THISNODE_BIT = 21,
	___GFP_ACCOUNT_BIT = 22,
	___GFP_ZEROTAGS_BIT = 23,
	___GFP_NO_OBJ_EXT_BIT = 24,
	___GFP_LAST_BIT = 25,
};

enum {
	__ctx_convertBPF_PROG_TYPE_SOCKET_FILTER = 0,
	__ctx_convertBPF_PROG_TYPE_SCHED_CLS = 1,
	__ctx_convertBPF_PROG_TYPE_SCHED_ACT = 2,
	__ctx_convertBPF_PROG_TYPE_XDP = 3,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SKB = 4,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK = 5,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK_ADDR = 6,
	__ctx_convertBPF_PROG_TYPE_LWT_IN = 7,
	__ctx_convertBPF_PROG_TYPE_LWT_OUT = 8,
	__ctx_convertBPF_PROG_TYPE_LWT_XMIT = 9,
	__ctx_convertBPF_PROG_TYPE_LWT_SEG6LOCAL = 10,
	__ctx_convertBPF_PROG_TYPE_SOCK_OPS = 11,
	__ctx_convertBPF_PROG_TYPE_SK_SKB = 12,
	__ctx_convertBPF_PROG_TYPE_SK_MSG = 13,
	__ctx_convertBPF_PROG_TYPE_FLOW_DISSECTOR = 14,
	__ctx_convertBPF_PROG_TYPE_KPROBE = 15,
	__ctx_convertBPF_PROG_TYPE_TRACEPOINT = 16,
	__ctx_convertBPF_PROG_TYPE_PERF_EVENT = 17,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT = 18,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 19,
	__ctx_convertBPF_PROG_TYPE_TRACING = 20,
	__ctx_convertBPF_PROG_TYPE_CGROUP_DEVICE = 21,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SYSCTL = 22,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCKOPT = 23,
	__ctx_convertBPF_PROG_TYPE_LIRC_MODE2 = 24,
	__ctx_convertBPF_PROG_TYPE_SK_REUSEPORT = 25,
	__ctx_convertBPF_PROG_TYPE_SK_LOOKUP = 26,
	__ctx_convertBPF_PROG_TYPE_STRUCT_OPS = 27,
	__ctx_convertBPF_PROG_TYPE_EXT = 28,
	__ctx_convertBPF_PROG_TYPE_SYSCALL = 29,
	__ctx_convertBPF_PROG_TYPE_NETFILTER = 30,
	__ctx_convert_unused = 31,
};

enum {
	attr_noop = 0,
	attr_delayed_allocation_blocks = 1,
	attr_session_write_kbytes = 2,
	attr_lifetime_write_kbytes = 3,
	attr_reserved_clusters = 4,
	attr_sra_exceeded_retry_limit = 5,
	attr_inode_readahead = 6,
	attr_trigger_test_error = 7,
	attr_first_error_time = 8,
	attr_last_error_time = 9,
	attr_clusters_in_group = 10,
	attr_mb_order = 11,
	attr_feature = 12,
	attr_pointer_pi = 13,
	attr_pointer_ui = 14,
	attr_pointer_ul = 15,
	attr_pointer_u64 = 16,
	attr_pointer_u8 = 17,
	attr_pointer_string = 18,
	attr_pointer_atomic = 19,
	attr_journal_task = 20,
};

enum {
	blank_off = 0,
	blank_normal_wait = 1,
	blank_vesa_wait = 2,
};

enum {
	cphy_cause_link_change = 1,
	cphy_cause_fifo_error = 2,
	cphy_cause_module_change = 4,
};

enum {
	cpuset = 0,
	possible = 1,
	fail = 2,
};

enum {
	edc_none = 0,
	edc_sr = 1,
	edc_twinax = 2,
};

enum {
	false = 0,
	true = 1,
};

enum {
	in_arbitration = 2,
	in_selection = 4,
	in_other = 8,
	disconnect = 16,
	aborted = 32,
	sent_ident = 64,
};

enum {
	lcb_ctx_undo_next = 0,
	lcb_ctx_prev = 1,
	lcb_ctx_next = 2,
};

enum {
	mechtype_caddy = 0,
	mechtype_tray = 1,
	mechtype_popup = 2,
	mechtype_individual_changer = 4,
	mechtype_cartridge_changer = 5,
};

enum {
	ncsi_dev_state_major = 65280,
	ncsi_dev_state_minor = 255,
	ncsi_dev_state_probe_deselect = 513,
	ncsi_dev_state_probe_package = 514,
	ncsi_dev_state_probe_channel = 515,
	ncsi_dev_state_probe_mlx_gma = 516,
	ncsi_dev_state_probe_mlx_smaf = 517,
	ncsi_dev_state_probe_cis = 518,
	ncsi_dev_state_probe_keep_phy = 519,
	ncsi_dev_state_probe_gvi = 520,
	ncsi_dev_state_probe_gc = 521,
	ncsi_dev_state_probe_gls = 522,
	ncsi_dev_state_probe_dp = 523,
	ncsi_dev_state_config_sp = 769,
	ncsi_dev_state_config_cis = 770,
	ncsi_dev_state_config_oem_gma = 771,
	ncsi_dev_state_config_clear_vids = 772,
	ncsi_dev_state_config_svf = 773,
	ncsi_dev_state_config_ev = 774,
	ncsi_dev_state_config_sma = 775,
	ncsi_dev_state_config_ebf = 776,
	ncsi_dev_state_config_dgmf = 777,
	ncsi_dev_state_config_ecnt = 778,
	ncsi_dev_state_config_ec = 779,
	ncsi_dev_state_config_ae = 780,
	ncsi_dev_state_config_gls = 781,
	ncsi_dev_state_config_done = 782,
	ncsi_dev_state_suspend_select = 1025,
	ncsi_dev_state_suspend_gls = 1026,
	ncsi_dev_state_suspend_dcnt = 1027,
	ncsi_dev_state_suspend_dc = 1028,
	ncsi_dev_state_suspend_deselect = 1029,
	ncsi_dev_state_suspend_done = 1030,
};

enum {
	ncsi_dev_state_registered = 0,
	ncsi_dev_state_functional = 256,
	ncsi_dev_state_probe = 512,
	ncsi_dev_state_config = 768,
	ncsi_dev_state_suspend = 1024,
};

enum {
	none = 0,
	day = 1,
	month = 2,
	year = 3,
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

enum {
	phy_modtype_none = 0,
	phy_modtype_sr = 1,
	phy_modtype_lr = 2,
	phy_modtype_lrm = 3,
	phy_modtype_twinax = 4,
	phy_modtype_twinax_long = 5,
	phy_modtype_unknown = 6,
};

enum {
	ptr_explicit = 0,
	ptr_ext4_sb_info_offset = 1,
	ptr_ext4_super_block_offset = 2,
};

enum {
	sis_180 = 0,
	SIS_SCR_PCI_BAR = 5,
	SIS_GENCTL = 84,
	SIS_SCR_BASE = 192,
	SIS180_SATA1_OFS = 16,
	SIS182_SATA1_OFS = 32,
	SIS_PMR = 144,
	SIS_PMR_COMBINED = 48,
	SIS_FLAG_CFGSCR = 1073741824,
	GENCTL_IOMAPPED_SCR = 67108864,
};

enum {
	sysctl_hung_task_timeout_secs = 0,
};

enum {
	uli_5289 = 0,
	uli_5287 = 1,
	uli_5281 = 2,
	uli_max_ports = 4,
	ULI5287_BASE = 144,
	ULI5287_OFFS = 16,
	ULI5281_BASE = 96,
	ULI5281_OFFS = 96,
};

typedef enum {
	BIT_DStream_unfinished = 0,
	BIT_DStream_endOfBuffer = 1,
	BIT_DStream_completed = 2,
	BIT_DStream_overflow = 3,
} BIT_DStream_status;

typedef enum {
	ZSTD_error_no_error = 0,
	ZSTD_error_GENERIC = 1,
	ZSTD_error_prefix_unknown = 10,
	ZSTD_error_version_unsupported = 12,
	ZSTD_error_frameParameter_unsupported = 14,
	ZSTD_error_frameParameter_windowTooLarge = 16,
	ZSTD_error_corruption_detected = 20,
	ZSTD_error_checksum_wrong = 22,
	ZSTD_error_dictionary_corrupted = 30,
	ZSTD_error_dictionary_wrong = 32,
	ZSTD_error_dictionaryCreation_failed = 34,
	ZSTD_error_parameter_unsupported = 40,
	ZSTD_error_parameter_outOfBound = 42,
	ZSTD_error_tableLog_tooLarge = 44,
	ZSTD_error_maxSymbolValue_tooLarge = 46,
	ZSTD_error_maxSymbolValue_tooSmall = 48,
	ZSTD_error_stage_wrong = 60,
	ZSTD_error_init_missing = 62,
	ZSTD_error_memory_allocation = 64,
	ZSTD_error_workSpace_tooSmall = 66,
	ZSTD_error_dstSize_tooSmall = 70,
	ZSTD_error_srcSize_wrong = 72,
	ZSTD_error_dstBuffer_null = 74,
	ZSTD_error_frameIndex_tooLarge = 100,
	ZSTD_error_seekableIO = 102,
	ZSTD_error_dstBuffer_wrong = 104,
	ZSTD_error_srcBuffer_wrong = 105,
	ZSTD_error_maxCode = 120,
} ZSTD_ErrorCode;

typedef ZSTD_ErrorCode ERR_enum;

typedef enum {
	FSE_repeat_none = 0,
	FSE_repeat_check = 1,
	FSE_repeat_valid = 2,
} FSE_repeat;

typedef enum {
	trustInput = 0,
	checkMaxSymbolValue = 1,
} HIST_checkInput_e;

typedef enum {
	HUF_singleStream = 0,
	HUF_fourStreams = 1,
} HUF_nbStreams_e;

typedef enum {
	HUF_repeat_none = 0,
	HUF_repeat_check = 1,
	HUF_repeat_valid = 2,
} HUF_repeat;

typedef enum {
	MPTBASE_DRIVER = 0,
	MPTCTL_DRIVER = 1,
	MPTSPI_DRIVER = 2,
	MPTFC_DRIVER = 3,
	MPTSAS_DRIVER = 4,
	MPTLAN_DRIVER = 5,
	MPTSTM_DRIVER = 6,
	MPTUNKNOWN_DRIVER = 7,
} MPT_DRIVER_CLASS;

typedef enum {
	ZSTD_e_continue = 0,
	ZSTD_e_flush = 1,
	ZSTD_e_end = 2,
} ZSTD_EndDirective;

typedef enum {
	zop_dynamic = 0,
	zop_predef = 1,
} ZSTD_OptPrice_e;

typedef enum {
	ZSTD_reset_session_only = 1,
	ZSTD_reset_parameters = 2,
	ZSTD_reset_session_and_parameters = 3,
} ZSTD_ResetDirective;

typedef enum {
	ZSTD_bm_buffered = 0,
	ZSTD_bm_stable = 1,
} ZSTD_bufferMode_e;

typedef enum {
	ZSTDb_not_buffered = 0,
	ZSTDb_buffered = 1,
} ZSTD_buffered_policy_e;

typedef enum {
	ZSTD_cpm_noAttachDict = 0,
	ZSTD_cpm_attachDict = 1,
	ZSTD_cpm_createCDict = 2,
	ZSTD_cpm_unknown = 3,
} ZSTD_cParamMode_e;

typedef enum {
	ZSTD_c_compressionLevel = 100,
	ZSTD_c_windowLog = 101,
	ZSTD_c_hashLog = 102,
	ZSTD_c_chainLog = 103,
	ZSTD_c_searchLog = 104,
	ZSTD_c_minMatch = 105,
	ZSTD_c_targetLength = 106,
	ZSTD_c_strategy = 107,
	ZSTD_c_enableLongDistanceMatching = 160,
	ZSTD_c_ldmHashLog = 161,
	ZSTD_c_ldmMinMatch = 162,
	ZSTD_c_ldmBucketSizeLog = 163,
	ZSTD_c_ldmHashRateLog = 164,
	ZSTD_c_contentSizeFlag = 200,
	ZSTD_c_checksumFlag = 201,
	ZSTD_c_dictIDFlag = 202,
	ZSTD_c_nbWorkers = 400,
	ZSTD_c_jobSize = 401,
	ZSTD_c_overlapLog = 402,
	ZSTD_c_experimentalParam1 = 500,
	ZSTD_c_experimentalParam2 = 10,
	ZSTD_c_experimentalParam3 = 1000,
	ZSTD_c_experimentalParam4 = 1001,
	ZSTD_c_experimentalParam5 = 1002,
	ZSTD_c_experimentalParam6 = 1003,
	ZSTD_c_experimentalParam7 = 1004,
	ZSTD_c_experimentalParam8 = 1005,
	ZSTD_c_experimentalParam9 = 1006,
	ZSTD_c_experimentalParam10 = 1007,
	ZSTD_c_experimentalParam11 = 1008,
	ZSTD_c_experimentalParam12 = 1009,
	ZSTD_c_experimentalParam13 = 1010,
	ZSTD_c_experimentalParam14 = 1011,
	ZSTD_c_experimentalParam15 = 1012,
} ZSTD_cParameter;

typedef enum {
	zcss_init = 0,
	zcss_load = 1,
	zcss_flush = 2,
} ZSTD_cStreamStage;

typedef enum {
	ZSTDcrp_makeClean = 0,
	ZSTDcrp_leaveDirty = 1,
} ZSTD_compResetPolicy_e;

typedef enum {
	ZSTDcs_created = 0,
	ZSTDcs_init = 1,
	ZSTDcs_ongoing = 2,
	ZSTDcs_ending = 3,
} ZSTD_compressionStage_e;

typedef enum {
	ZSTD_cwksp_alloc_objects = 0,
	ZSTD_cwksp_alloc_buffers = 1,
	ZSTD_cwksp_alloc_aligned = 2,
} ZSTD_cwksp_alloc_phase_e;

typedef enum {
	ZSTD_cwksp_dynamic_alloc = 0,
	ZSTD_cwksp_static_alloc = 1,
} ZSTD_cwksp_static_alloc_e;

typedef enum {
	ZSTD_d_windowLogMax = 100,
	ZSTD_d_experimentalParam1 = 1000,
	ZSTD_d_experimentalParam2 = 1001,
	ZSTD_d_experimentalParam3 = 1002,
	ZSTD_d_experimentalParam4 = 1003,
} ZSTD_dParameter;

typedef enum {
	ZSTDds_getFrameHeaderSize = 0,
	ZSTDds_decodeFrameHeader = 1,
	ZSTDds_decodeBlockHeader = 2,
	ZSTDds_decompressBlock = 3,
	ZSTDds_decompressLastBlock = 4,
	ZSTDds_checkChecksum = 5,
	ZSTDds_decodeSkippableHeader = 6,
	ZSTDds_skipFrame = 7,
} ZSTD_dStage;

typedef enum {
	zdss_init = 0,
	zdss_loadHeader = 1,
	zdss_read = 2,
	zdss_load = 3,
	zdss_flush = 4,
} ZSTD_dStreamStage;

typedef enum {
	ZSTD_defaultDisallowed = 0,
	ZSTD_defaultAllowed = 1,
} ZSTD_defaultPolicy_e;

typedef enum {
	ZSTD_dictDefaultAttach = 0,
	ZSTD_dictForceAttach = 1,
	ZSTD_dictForceCopy = 2,
	ZSTD_dictForceLoad = 3,
} ZSTD_dictAttachPref_e;

typedef enum {
	ZSTD_dct_auto = 0,
	ZSTD_dct_rawContent = 1,
	ZSTD_dct_fullDict = 2,
} ZSTD_dictContentType_e;

typedef enum {
	ZSTD_dlm_byCopy = 0,
	ZSTD_dlm_byRef = 1,
} ZSTD_dictLoadMethod_e;

typedef enum {
	ZSTD_noDict = 0,
	ZSTD_extDict = 1,
	ZSTD_dictMatchState = 2,
	ZSTD_dedicatedDictSearch = 3,
} ZSTD_dictMode_e;

typedef enum {
	ZSTD_dtlm_fast = 0,
	ZSTD_dtlm_full = 1,
} ZSTD_dictTableLoadMethod_e;

typedef enum {
	ZSTD_use_indefinitely = -1,
	ZSTD_dont_use = 0,
	ZSTD_use_once = 1,
} ZSTD_dictUses_e;

typedef enum {
	ZSTD_d_validateChecksum = 0,
	ZSTD_d_ignoreChecksum = 1,
} ZSTD_forceIgnoreChecksum_e;

typedef enum {
	ZSTD_f_zstd1 = 0,
	ZSTD_f_zstd1_magicless = 1,
} ZSTD_format_e;

typedef enum {
	ZSTD_frame = 0,
	ZSTD_skippableFrame = 1,
} ZSTD_frameType_e;

typedef enum {
	ZSTDirp_continue = 0,
	ZSTDirp_reset = 1,
} ZSTD_indexResetPolicy_e;

typedef enum {
	ZSTD_not_in_dst = 0,
	ZSTD_in_dst = 1,
	ZSTD_split = 2,
} ZSTD_litLocation_e;

typedef enum {
	ZSTD_llt_none = 0,
	ZSTD_llt_literalLength = 1,
	ZSTD_llt_matchLength = 2,
} ZSTD_longLengthType_e;

typedef enum {
	ZSTD_lo_isRegularOffset = 0,
	ZSTD_lo_isLongOffset = 1,
} ZSTD_longOffset_e;

typedef enum {
	ZSTDnit_frameHeader = 0,
	ZSTDnit_blockHeader = 1,
	ZSTDnit_block = 2,
	ZSTDnit_lastBlock = 3,
	ZSTDnit_checksum = 4,
	ZSTDnit_skippableFrame = 5,
} ZSTD_nextInputType_e;

typedef enum {
	ZSTD_no_overlap = 0,
	ZSTD_overlap_src_before_dst = 1,
} ZSTD_overlap_e;

typedef enum {
	ZSTD_ps_auto = 0,
	ZSTD_ps_enable = 1,
	ZSTD_ps_disable = 2,
} ZSTD_paramSwitch_e;

typedef enum {
	ZSTD_rmd_refSingleDDict = 0,
	ZSTD_rmd_refMultipleDDicts = 1,
} ZSTD_refMultipleDDicts_e;

typedef enum {
	ZSTD_resetTarget_CDict = 0,
	ZSTD_resetTarget_CCtx = 1,
} ZSTD_resetTarget_e;

typedef enum {
	ZSTD_sf_noBlockDelimiters = 0,
	ZSTD_sf_explicitBlockDelimiters = 1,
} ZSTD_sequenceFormat_e;

typedef enum {
	ZSTD_fast = 1,
	ZSTD_dfast = 2,
	ZSTD_greedy = 3,
	ZSTD_lazy = 4,
	ZSTD_lazy2 = 5,
	ZSTD_btlazy2 = 6,
	ZSTD_btopt = 7,
	ZSTD_btultra = 8,
	ZSTD_btultra2 = 9,
} ZSTD_strategy;

typedef enum {
	AC_GETDEV_CHANGED = 2048,
	AC_INQ_CHANGED = 1024,
	AC_TRANSFER_NEG = 512,
	AC_LOST_DEVICE = 256,
	AC_FOUND_DEVICE = 128,
	AC_PATH_DEREGISTERED = 64,
	AC_PATH_REGISTERED = 32,
	AC_SENT_BDR = 16,
	AC_SCSI_AEN = 8,
	AC_UNSOL_RESEL = 2,
	AC_BUS_RESET = 1,
} ac_code;

typedef enum {
	adma_state_idle = 0,
	adma_state_pkt = 1,
	adma_state_mmio = 2,
} adma_state_t;

typedef enum {
	AHC_BUGNONE = 0,
	AHC_TMODE_WIDEODD_BUG = 1,
	AHC_AUTOFLUSH_BUG = 2,
	AHC_CACHETHEN_BUG = 4,
	AHC_CACHETHEN_DIS_BUG = 8,
	AHC_PCI_2_1_RETRY_BUG = 16,
	AHC_PCI_MWI_BUG = 32,
	AHC_SCBCHAN_UPLOAD_BUG = 64,
} ahc_bug;

typedef enum {
	AHC_NONE = 0,
	AHC_CHIPID_MASK = 255,
	AHC_AIC7770 = 1,
	AHC_AIC7850 = 2,
	AHC_AIC7855 = 3,
	AHC_AIC7859 = 4,
	AHC_AIC7860 = 5,
	AHC_AIC7870 = 6,
	AHC_AIC7880 = 7,
	AHC_AIC7895 = 8,
	AHC_AIC7895C = 9,
	AHC_AIC7890 = 10,
	AHC_AIC7896 = 11,
	AHC_AIC7892 = 12,
	AHC_AIC7899 = 13,
	AHC_VL = 256,
	AHC_EISA = 512,
	AHC_PCI = 1024,
	AHC_BUS_MASK = 3840,
} ahc_chip;

typedef enum {
	AHC_FENONE = 0,
	AHC_ULTRA = 1,
	AHC_ULTRA2 = 2,
	AHC_WIDE = 4,
	AHC_TWIN = 8,
	AHC_MORE_SRAM = 16,
	AHC_CMD_CHAN = 32,
	AHC_QUEUE_REGS = 64,
	AHC_SG_PRELOAD = 128,
	AHC_SPIOCAP = 256,
	AHC_MULTI_TID = 512,
	AHC_HS_MAILBOX = 1024,
	AHC_DT = 2048,
	AHC_NEW_TERMCTL = 4096,
	AHC_MULTI_FUNC = 8192,
	AHC_LARGE_SCBS = 16384,
	AHC_AUTORATE = 32768,
	AHC_AUTOPAUSE = 65536,
	AHC_TARGETMODE = 131072,
	AHC_MULTIROLE = 262144,
	AHC_REMOVABLE = 524288,
	AHC_HVD = 1048576,
	AHC_AIC7770_FE = 0,
	AHC_AIC7850_FE = 196865,
	AHC_AIC7860_FE = 196865,
	AHC_AIC7870_FE = 196608,
	AHC_AIC7880_FE = 196609,
	AHC_AIC7890_FE = 153330,
	AHC_AIC7892_FE = 253682,
	AHC_AIC7895_FE = 221233,
	AHC_AIC7895C_FE = 221745,
	AHC_AIC7896_FE = 161522,
	AHC_AIC7899_FE = 261874,
} ahc_feature;

typedef enum {
	AHC_FNONE = 0,
	AHC_PRIMARY_CHANNEL = 3,
	AHC_USEDEFAULTS = 4,
	AHC_SEQUENCER_DEBUG = 8,
	AHC_SHARED_SRAM = 16,
	AHC_LARGE_SEEPROM = 32,
	AHC_RESET_BUS_A = 64,
	AHC_RESET_BUS_B = 128,
	AHC_EXTENDED_TRANS_A = 256,
	AHC_EXTENDED_TRANS_B = 512,
	AHC_TERM_ENB_A = 1024,
	AHC_TERM_ENB_B = 2048,
	AHC_INITIATORROLE = 4096,
	AHC_TARGETROLE = 8192,
	AHC_NEWEEPROM_FMT = 16384,
	AHC_TQINFIFO_BLOCKED = 65536,
	AHC_INT50_SPEEDFLEX = 131072,
	AHC_SCB_BTT = 262144,
	AHC_BIOS_ENABLED = 524288,
	AHC_ALL_INTERRUPTS = 1048576,
	AHC_PAGESCBS = 4194304,
	AHC_EDGE_INTERRUPT = 8388608,
	AHC_39BIT_ADDRESSING = 16777216,
	AHC_LSCBS_ENABLED = 33554432,
	AHC_SCB_CONFIG_USED = 67108864,
	AHC_NO_BIOS_INIT = 134217728,
	AHC_DISABLE_PCI_PERR = 268435456,
	AHC_HAS_TERM_LOGIC = 536870912,
} ahc_flag;

typedef enum {
	AHC_DEV_FREEZE_TIL_EMPTY = 2,
	AHC_DEV_Q_BASIC = 16,
	AHC_DEV_Q_TAGGED = 32,
	AHC_DEV_PERIODIC_OTAG = 64,
} ahc_linux_dev_flags;

typedef enum {
	MSG_TYPE_NONE = 0,
	MSG_TYPE_INITIATOR_MSGOUT = 1,
	MSG_TYPE_INITIATOR_MSGIN = 2,
	MSG_TYPE_TARGET_MSGOUT = 3,
	MSG_TYPE_TARGET_MSGIN = 4,
} ahc_msg_type;

typedef enum {
	AHCMSG_1B = 0,
	AHCMSG_2B = 1,
	AHCMSG_EXT = 2,
} ahc_msgtype;

typedef enum {
	AHC_NEG_TO_GOAL = 0,
	AHC_NEG_IF_NON_ASYNC = 1,
	AHC_NEG_ALWAYS = 2,
} ahc_neg_type;

typedef enum {
	AHC_QUEUE_NONE = 0,
	AHC_QUEUE_BASIC = 1,
	AHC_QUEUE_TAGGED = 2,
} ahc_queue_alg;

typedef enum {
	SEARCH_COMPLETE = 0,
	SEARCH_COUNT = 1,
	SEARCH_REMOVE = 2,
} ahc_search_action;

typedef enum {
	AHD_BUGNONE = 0,
	AHD_SENT_SCB_UPDATE_BUG = 1,
	AHD_ABORT_LQI_BUG = 2,
	AHD_PKT_BITBUCKET_BUG = 4,
	AHD_LONG_SETIMO_BUG = 8,
	AHD_NLQICRC_DELAYED_BUG = 16,
	AHD_SCSIRST_BUG = 32,
	AHD_PCIX_CHIPRST_BUG = 64,
	AHD_PCIX_MMAPIO_BUG = 128,
	AHD_PCIX_SCBRAM_RD_BUG = 256,
	AHD_PCIX_BUG_MASK = 448,
	AHD_LQO_ATNO_BUG = 512,
	AHD_AUTOFLUSH_BUG = 1024,
	AHD_CLRLQO_AUTOCLR_BUG = 2048,
	AHD_PKTIZED_STATUS_BUG = 4096,
	AHD_PKT_LUN_BUG = 8192,
	AHD_NONPACKFIFO_BUG = 16384,
	AHD_MDFF_WSCBPTR_BUG = 32768,
	AHD_REG_SLOW_SETTLE_BUG = 65536,
	AHD_SET_MODE_BUG = 131072,
	AHD_BUSFREEREV_BUG = 262144,
	AHD_PACED_NEGTABLE_BUG = 524288,
	AHD_LQOOVERRUN_BUG = 1048576,
	AHD_INTCOLLISION_BUG = 2097152,
	AHD_EARLY_REQ_BUG = 4194304,
	AHD_FAINT_LED_BUG = 8388608,
} ahd_bug;

typedef enum {
	AHD_NONE = 0,
	AHD_CHIPID_MASK = 255,
	AHD_AIC7901 = 1,
	AHD_AIC7902 = 2,
	AHD_AIC7901A = 3,
	AHD_PCI = 256,
	AHD_PCIX = 512,
	AHD_BUS_MASK = 3840,
} ahd_chip;

typedef enum {
	AHD_FENONE = 0,
	AHD_WIDE = 1,
	AHD_AIC79XXB_SLOWCRC = 2,
	AHD_MULTI_FUNC = 256,
	AHD_TARGETMODE = 4096,
	AHD_MULTIROLE = 8192,
	AHD_RTI = 16384,
	AHD_NEW_IOCELL_OPTS = 32768,
	AHD_NEW_DFCNTRL_OPTS = 65536,
	AHD_FAST_CDB_DELIVERY = 131072,
	AHD_REMOVABLE = 0,
	AHD_AIC7901_FE = 0,
	AHD_AIC7901A_FE = 0,
	AHD_AIC7902_FE = 256,
} ahd_feature;

typedef enum {
	AHD_FNONE = 0,
	AHD_BOOT_CHANNEL = 1,
	AHD_USEDEFAULTS = 4,
	AHD_SEQUENCER_DEBUG = 8,
	AHD_RESET_BUS_A = 16,
	AHD_EXTENDED_TRANS_A = 32,
	AHD_TERM_ENB_A = 64,
	AHD_SPCHK_ENB_A = 128,
	AHD_STPWLEVEL_A = 256,
	AHD_INITIATORROLE = 512,
	AHD_TARGETROLE = 1024,
	AHD_RESOURCE_SHORTAGE = 2048,
	AHD_TQINFIFO_BLOCKED = 4096,
	AHD_INT50_SPEEDFLEX = 8192,
	AHD_BIOS_ENABLED = 16384,
	AHD_ALL_INTERRUPTS = 32768,
	AHD_39BIT_ADDRESSING = 65536,
	AHD_64BIT_ADDRESSING = 131072,
	AHD_CURRENT_SENSING = 262144,
	AHD_SCB_CONFIG_USED = 524288,
	AHD_HP_BOARD = 1048576,
	AHD_BUS_RESET_ACTIVE = 2097152,
	AHD_UPDATE_PEND_CMDS = 4194304,
	AHD_RUNNING_QOUTFIFO = 8388608,
	AHD_HAD_FIRST_SEL = 16777216,
} ahd_flag;

typedef enum {
	AHD_DEV_FREEZE_TIL_EMPTY = 2,
	AHD_DEV_Q_BASIC = 16,
	AHD_DEV_Q_TAGGED = 32,
	AHD_DEV_PERIODIC_OTAG = 64,
} ahd_linux_dev_flags;

typedef enum {
	AHD_MODE_DFF0 = 0,
	AHD_MODE_DFF1 = 1,
	AHD_MODE_CCHAN = 2,
	AHD_MODE_SCSI = 3,
	AHD_MODE_CFG = 4,
	AHD_MODE_UNKNOWN = 5,
} ahd_mode;

typedef enum {
	MSG_FLAG_NONE = 0,
	MSG_FLAG_EXPECT_PPR_BUSFREE = 1,
	MSG_FLAG_IU_REQ_CHANGED = 2,
	MSG_FLAG_EXPECT_IDE_BUSFREE = 4,
	MSG_FLAG_EXPECT_QASREJ_BUSFREE = 8,
	MSG_FLAG_PACKETIZED = 16,
} ahd_msg_flags;

typedef enum {
	MSG_TYPE_NONE___2 = 0,
	MSG_TYPE_INITIATOR_MSGOUT___2 = 1,
	MSG_TYPE_INITIATOR_MSGIN___2 = 2,
	MSG_TYPE_TARGET_MSGOUT___2 = 3,
	MSG_TYPE_TARGET_MSGIN___2 = 4,
} ahd_msg_type;

typedef enum {
	AHDMSG_1B = 0,
	AHDMSG_2B = 1,
	AHDMSG_EXT = 2,
} ahd_msgtype;

typedef enum {
	AHD_NEG_TO_GOAL = 0,
	AHD_NEG_IF_NON_ASYNC = 1,
	AHD_NEG_ALWAYS = 2,
} ahd_neg_type;

typedef enum {
	AHD_POWER_STATE_D0 = 0,
	AHD_POWER_STATE_D1 = 1,
	AHD_POWER_STATE_D2 = 2,
	AHD_POWER_STATE_D3 = 3,
} ahd_power_state;

typedef enum {
	AHD_QUEUE_NONE = 0,
	AHD_QUEUE_BASIC = 1,
	AHD_QUEUE_TAGGED = 2,
} ahd_queue_alg;

typedef enum {
	SEARCH_COMPLETE___2 = 0,
	SEARCH_COUNT___2 = 1,
	SEARCH_REMOVE___2 = 2,
	SEARCH_PRINT = 3,
} ahd_search_action;

typedef enum {
	bt_raw = 0,
	bt_rle = 1,
	bt_compressed = 2,
	bt_reserved = 3,
} blockType_e;

typedef enum {
	need_more = 0,
	block_done = 1,
	finish_started = 2,
	finish_done = 3,
} block_state;

typedef enum {
	BNX2X_OBJ_TYPE_RX = 0,
	BNX2X_OBJ_TYPE_TX = 1,
	BNX2X_OBJ_TYPE_RX_TX = 2,
} bnx2x_obj_type;

typedef enum {
	BUS_SPACE_MEMIO = 0,
	BUS_SPACE_PIO = 1,
} bus_space_tag_t;

typedef enum {
	CAM_REQ_INPROG = 0,
	CAM_REQ_CMP = 1,
	CAM_REQ_ABORTED = 2,
	CAM_UA_ABORT = 3,
	CAM_REQ_CMP_ERR = 4,
	CAM_BUSY = 5,
	CAM_REQ_INVALID = 6,
	CAM_PATH_INVALID = 7,
	CAM_SEL_TIMEOUT = 8,
	CAM_CMD_TIMEOUT = 9,
	CAM_SCSI_STATUS_ERROR = 10,
	CAM_SCSI_BUS_RESET = 11,
	CAM_UNCOR_PARITY = 12,
	CAM_AUTOSENSE_FAIL = 13,
	CAM_NO_HBA = 14,
	CAM_DATA_RUN_ERR = 15,
	CAM_UNEXP_BUSFREE = 16,
	CAM_SEQUENCE_FAIL = 17,
	CAM_CCB_LEN_ERR = 18,
	CAM_PROVIDE_FAIL = 19,
	CAM_BDR_SENT = 20,
	CAM_REQ_TERMIO = 21,
	CAM_UNREC_HBA_ERROR = 22,
	CAM_REQ_TOO_BIG = 23,
	CAM_UA_TERMIO = 24,
	CAM_MSG_REJECT_REC = 25,
	CAM_DEV_NOT_THERE = 26,
	CAM_RESRC_UNAVAIL = 27,
	CAM_REQUEUE_REQ = 28,
	CAM_DEV_QFRZN = 64,
	CAM_STATUS_MASK = 63,
} cam_status;

typedef enum {
	CODES = 0,
	LENS = 1,
	DISTS = 2,
} codetype;

typedef enum {
	FILE_MEMORY_MIGRATE = 0,
	FILE_CPULIST = 1,
	FILE_MEMLIST = 2,
	FILE_EFFECTIVE_CPULIST = 3,
	FILE_EFFECTIVE_MEMLIST = 4,
	FILE_SUBPARTS_CPULIST = 5,
	FILE_EXCLUSIVE_CPULIST = 6,
	FILE_EFFECTIVE_XCPULIST = 7,
	FILE_ISOLATED_CPULIST = 8,
	FILE_CPU_EXCLUSIVE = 9,
	FILE_MEM_EXCLUSIVE = 10,
	FILE_MEM_HARDWALL = 11,
	FILE_SCHED_LOAD_BALANCE = 12,
	FILE_PARTITION_ROOT = 13,
	FILE_SCHED_RELAX_DOMAIN_LEVEL = 14,
	FILE_MEMORY_PRESSURE_ENABLED = 15,
	FILE_MEMORY_PRESSURE = 16,
	FILE_SPREAD_PAGE = 17,
	FILE_SPREAD_SLAB = 18,
} cpuset_filetype_t;

typedef enum {
	CS_ONLINE = 0,
	CS_CPU_EXCLUSIVE = 1,
	CS_MEM_EXCLUSIVE = 2,
	CS_MEM_HARDWALL = 3,
	CS_MEMORY_MIGRATE = 4,
	CS_SCHED_LOAD_BALANCE = 5,
	CS_SPREAD_PAGE = 6,
	CS_SPREAD_SLAB = 7,
} cpuset_flagbits_t;

typedef enum {
	noDictIssue = 0,
	dictSmall = 1,
} dictIssue_directive;

typedef enum {
	noDict = 0,
	withPrefix64k = 1,
	usingExtDict = 2,
} dict_directive;

typedef enum {
	EITHER = 0,
	INDEX = 1,
	DIRENT = 2,
	DIRENT_HTREE = 3,
} dirblock_type_t;

typedef enum {
	decode_full_block = 0,
	partial_decode = 1,
} earlyEnd_directive;

typedef enum {
	endOnOutputSize = 0,
	endOnInputSize = 1,
} endCondition_directive;

typedef enum {
	EXT4_IGET_NORMAL = 0,
	EXT4_IGET_SPECIAL = 1,
	EXT4_IGET_HANDLE = 2,
	EXT4_IGET_BAD = 4,
	EXT4_IGET_EA_INODE = 8,
} ext4_iget_flags;

typedef enum {
	FCT_UNKNOWN = 0,
	FCT_BROADCAST = 1,
	FCT_INITIATOR = 2,
	FCT_TARGET = 4,
	FCT_NVME_INITIATOR = 16,
	FCT_NVME_TARGET = 32,
	FCT_NVME_DISCOVERY = 64,
	FCT_NVME = 240,
} fc_port_type_t;

typedef enum {
	FS_DECRYPT = 0,
	FS_ENCRYPT = 1,
} fscrypt_direction_t;

typedef enum {
	HEAD = 0,
	FLAGS = 1,
	TIME = 2,
	OS = 3,
	EXLEN = 4,
	EXTRA = 5,
	NAME = 6,
	COMMENT = 7,
	HCRC = 8,
	DICTID = 9,
	DICT = 10,
	TYPE = 11,
	TYPEDO = 12,
	STORED = 13,
	COPY = 14,
	TABLE = 15,
	LENLENS = 16,
	CODELENS = 17,
	LEN = 18,
	LENEXT = 19,
	DIST = 20,
	DISTEXT = 21,
	MATCH = 22,
	LIT = 23,
	CHECK = 24,
	LENGTH = 25,
	DONE = 26,
	BAD = 27,
	MEM = 28,
	SYNC = 29,
} inflate_mode;

typedef enum {
	ISOLATE_ABORT = 0,
	ISOLATE_NONE = 1,
	ISOLATE_SUCCESS = 2,
} isolate_migrate_t;

typedef enum {
	noLimit = 0,
	limitedOutput = 1,
} limitedOutput_directive;

typedef enum {
	PAGE_KEEP = 0,
	PAGE_ACTIVATE = 1,
	PAGE_SUCCESS = 2,
	PAGE_CLEAN = 3,
} pageout_t;

typedef enum {
	QLA_PCI_RESUME = 0,
	QLA_PCI_ERR_DETECTED = 1,
	QLA_PCI_MMIO_ENABLED = 2,
	QLA_PCI_SLOT_RESET = 3,
} pci_error_state_t;

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_MAX = 33,
} phy_interface_t;

typedef enum {
	PORT_PATA0 = 0,
	PORT_PATA1 = 1,
	PORT_SATA = 2,
} port_type;

typedef enum {
	qs_state_mmio = 0,
	qs_state_pkt = 1,
} qs_state_t;

typedef enum {
	ROLE_UNKNOWN = 0,
	ROLE_INITIATOR = 1,
	ROLE_TARGET = 2,
} role_t;

typedef enum {
	SCB_FREE = 0,
	SCB_OTHERTCL_TIMEOUT = 2,
	SCB_DEVICE_RESET = 4,
	SCB_SENSE = 8,
	SCB_CDB32_PTR = 16,
	SCB_RECOVERY_SCB = 32,
	SCB_AUTO_NEGOTIATE = 64,
	SCB_NEGOTIATE = 128,
	SCB_ABORT = 256,
	SCB_UNTAGGEDQ = 512,
	SCB_ACTIVE = 1024,
	SCB_TARGET_IMMEDIATE = 2048,
	SCB_TRANSMISSION_ERROR = 4096,
	SCB_TARGET_SCB = 8192,
	SCB_SILENT = 16384,
} scb_flag;

typedef enum {
	SCB_FLAG_NONE = 0,
	SCB_TRANSMISSION_ERROR___2 = 1,
	SCB_OTHERTCL_TIMEOUT___2 = 2,
	SCB_DEVICE_RESET___2 = 4,
	SCB_SENSE___2 = 8,
	SCB_CDB32_PTR___2 = 16,
	SCB_RECOVERY_SCB___2 = 32,
	SCB_AUTO_NEGOTIATE___2 = 64,
	SCB_NEGOTIATE___2 = 128,
	SCB_ABORT___2 = 256,
	SCB_ACTIVE___2 = 512,
	SCB_TARGET_IMMEDIATE___2 = 1024,
	SCB_PACKETIZED = 2048,
	SCB_EXPECT_PPR_BUSFREE = 4096,
	SCB_PKT_SENSE = 8192,
	SCB_EXTERNAL_RESET = 16384,
	SCB_ON_COL_LIST = 32768,
	SCB_SILENT___2 = 65536,
} scb_flag___2;

typedef enum {
	search_hashChain = 0,
	search_binaryTree = 1,
	search_rowHash = 2,
} searchMethod_e;

typedef enum {
	C46 = 6,
	C56_66 = 8,
} seeprom_chip_t;

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

typedef enum {
	not_streaming = 0,
	is_streaming = 1,
} streaming_operation;

typedef enum {
	set_basic = 0,
	set_rle = 1,
	set_compressed = 2,
	set_repeat = 3,
} symbolEncodingType_e;

typedef enum {
	byPtr = 0,
	byU32 = 1,
	byU16 = 2,
} tableType_t;

typedef ZSTD_ErrorCode zstd_error_code;

enum ALLOCATE_OPT {
	ALLOCATE_DEF = 0,
	ALLOCATE_MFT = 1,
	ALLOCATE_ZERO = 2,
};

enum ATTR_TYPE {
	ATTR_ZERO = 0,
	ATTR_STD = 16,
	ATTR_LIST = 32,
	ATTR_NAME = 48,
	ATTR_ID = 64,
	ATTR_SECURE = 80,
	ATTR_LABEL = 96,
	ATTR_VOL_INFO = 112,
	ATTR_DATA = 128,
	ATTR_ROOT = 144,
	ATTR_ALLOC = 160,
	ATTR_BITMAP = 176,
	ATTR_REPARSE = 192,
	ATTR_EA_INFO = 208,
	ATTR_EA = 224,
	ATTR_PROPERTYSET = 240,
	ATTR_LOGGED_UTILITY_STREAM = 256,
	ATTR_END = 4294967295,
};

enum CMD_RET_VALUES {
	REFIRE_CMD = 1,
	COMPLETE_CMD = 2,
	RETURN_CMD = 3,
};

enum COLLATION_RULE {
	NTFS_COLLATION_TYPE_BINARY = 0,
	NTFS_COLLATION_TYPE_FILENAME = 1,
	NTFS_COLLATION_TYPE_UINT = 16,
	NTFS_COLLATION_TYPE_SID = 17,
	NTFS_COLLATION_TYPE_SECURITY_HASH = 18,
	NTFS_COLLATION_TYPE_UINTS = 19,
};

enum CPL_error {
	CPL_ERR_NONE = 0,
	CPL_ERR_TCAM_PARITY = 1,
	CPL_ERR_TCAM_FULL = 3,
	CPL_ERR_CONN_RESET = 20,
	CPL_ERR_CONN_EXIST = 22,
	CPL_ERR_ARP_MISS = 23,
	CPL_ERR_BAD_SYN = 24,
	CPL_ERR_CONN_TIMEDOUT = 30,
	CPL_ERR_XMIT_TIMEDOUT = 31,
	CPL_ERR_PERSIST_TIMEDOUT = 32,
	CPL_ERR_FINWAIT2_TIMEDOUT = 33,
	CPL_ERR_KEEPALIVE_TIMEDOUT = 34,
	CPL_ERR_RTX_NEG_ADVICE = 35,
	CPL_ERR_PERSIST_NEG_ADVICE = 36,
	CPL_ERR_ABORT_FAILED = 42,
	CPL_ERR_GENERAL = 99,
};

enum CPL_opcode {
	CPL_PASS_OPEN_REQ___2 = 1,
	CPL_PASS_ACCEPT_RPL___2 = 2,
	CPL_ACT_OPEN_REQ___2 = 3,
	CPL_SET_TCB = 4,
	CPL_SET_TCB_FIELD___2 = 5,
	CPL_GET_TCB___2 = 6,
	CPL_PCMD = 7,
	CPL_CLOSE_CON_REQ___2 = 8,
	CPL_CLOSE_LISTSRV_REQ___2 = 9,
	CPL_ABORT_REQ___2 = 10,
	CPL_ABORT_RPL___2 = 11,
	CPL_TX_DATA___2 = 12,
	CPL_RX_DATA_ACK___2 = 13,
	CPL_TX_PKT___2 = 14,
	CPL_RTE_DELETE_REQ = 15,
	CPL_RTE_WRITE_REQ = 16,
	CPL_RTE_READ_REQ = 17,
	CPL_L2T_WRITE_REQ___2 = 18,
	CPL_L2T_READ_REQ = 19,
	CPL_SMT_WRITE_REQ___2 = 20,
	CPL_SMT_READ_REQ = 21,
	CPL_TX_PKT_LSO___2 = 22,
	CPL_PCMD_READ = 23,
	CPL_BARRIER = 24,
	CPL_TID_RELEASE___2 = 26,
	CPL_CLOSE_LISTSRV_RPL___2 = 32,
	CPL_ERROR = 33,
	CPL_GET_TCB_RPL___2 = 34,
	CPL_L2T_WRITE_RPL___2 = 35,
	CPL_PCMD_READ_RPL = 36,
	CPL_PCMD_RPL = 37,
	CPL_PEER_CLOSE___2 = 38,
	CPL_RTE_DELETE_RPL = 39,
	CPL_RTE_WRITE_RPL = 40,
	CPL_RX_DDP_COMPLETE___2 = 41,
	CPL_RX_PHYS_ADDR___2 = 42,
	CPL_RX_PKT___2 = 43,
	CPL_RX_URG_NOTIFY = 44,
	CPL_SET_TCB_RPL___2 = 45,
	CPL_SMT_WRITE_RPL___2 = 46,
	CPL_TX_DATA_ACK = 47,
	CPL_ABORT_REQ_RSS___2 = 48,
	CPL_ABORT_RPL_RSS___2 = 49,
	CPL_CLOSE_CON_RPL___2 = 50,
	CPL_ISCSI_HDR___2 = 51,
	CPL_L2T_READ_RPL = 52,
	CPL_RDMA_CQE___2 = 53,
	CPL_RDMA_CQE_READ_RSP___2 = 54,
	CPL_RDMA_CQE_ERR___2 = 55,
	CPL_RTE_READ_RPL = 56,
	CPL_RX_DATA___2 = 57,
	CPL_ACT_OPEN_RPL___2 = 64,
	CPL_PASS_OPEN_RPL___2 = 65,
	CPL_RX_DATA_DDP___2 = 66,
	CPL_SMT_READ_RPL = 67,
	CPL_ACT_ESTABLISH___2 = 80,
	CPL_PASS_ESTABLISH___2 = 81,
	CPL_PASS_ACCEPT_REQ___2 = 112,
	CPL_ASYNC_NOTIF = 128,
	CPL_TX_DMA_ACK = 160,
	CPL_RDMA_READ_REQ___2 = 161,
	CPL_RDMA_TERMINATE___2 = 162,
	CPL_TRACE_PKT___2 = 163,
	CPL_RDMA_EC_STATUS = 165,
	NUM_CPL_CMDS___2 = 166,
};

enum CSI_J {
	CSI_J_CURSOR_TO_END = 0,
	CSI_J_START_TO_CURSOR = 1,
	CSI_J_VISIBLE = 2,
	CSI_J_FULL = 3,
};

enum CSI_right_square_bracket {
	CSI_RSB_COLOR_FOR_UNDERLINE = 1,
	CSI_RSB_COLOR_FOR_HALF_BRIGHT = 2,
	CSI_RSB_MAKE_CUR_COLOR_DEFAULT = 8,
	CSI_RSB_BLANKING_INTERVAL = 9,
	CSI_RSB_BELL_FREQUENCY = 10,
	CSI_RSB_BELL_DURATION = 11,
	CSI_RSB_BRING_CONSOLE_TO_FRONT = 12,
	CSI_RSB_UNBLANK = 13,
	CSI_RSB_VESA_OFF_INTERVAL = 14,
	CSI_RSB_BRING_PREV_CONSOLE_TO_FRONT = 15,
	CSI_RSB_CURSOR_BLINK_INTERVAL = 16,
};

enum DAC960_BA_reg_offset {
	DAC960_BA_IRQSTS_OFFSET = 48,
	DAC960_BA_IRQMASK_OFFSET = 52,
	DAC960_BA_CMDMBX_OFFSET = 80,
	DAC960_BA_CMDSTS_OFFSET = 88,
	DAC960_BA_IDB_OFFSET = 96,
	DAC960_BA_ODB_OFFSET = 97,
	DAC960_BA_ERRSTS_OFFSET = 99,
};

enum DAC960_GEM_reg_offset {
	DAC960_GEM_IDB_READ_OFFSET = 532,
	DAC960_GEM_IDB_CLEAR_OFFSET = 536,
	DAC960_GEM_ODB_READ_OFFSET = 548,
	DAC960_GEM_ODB_CLEAR_OFFSET = 552,
	DAC960_GEM_IRQSTS_OFFSET = 520,
	DAC960_GEM_IRQMASK_READ_OFFSET = 556,
	DAC960_GEM_IRQMASK_CLEAR_OFFSET = 560,
	DAC960_GEM_CMDMBX_OFFSET = 1296,
	DAC960_GEM_CMDSTS_OFFSET = 1304,
	DAC960_GEM_ERRSTS_READ_OFFSET = 548,
	DAC960_GEM_ERRSTS_CLEAR_OFFSET = 552,
};

enum DAC960_LA_reg_offset {
	DAC960_LA_IRQMASK_OFFSET = 52,
	DAC960_LA_CMDOP_OFFSET = 80,
	DAC960_LA_CMDID_OFFSET = 81,
	DAC960_LA_MBOX2_OFFSET = 82,
	DAC960_LA_MBOX3_OFFSET = 83,
	DAC960_LA_MBOX4_OFFSET = 84,
	DAC960_LA_MBOX5_OFFSET = 85,
	DAC960_LA_MBOX6_OFFSET = 86,
	DAC960_LA_MBOX7_OFFSET = 87,
	DAC960_LA_MBOX8_OFFSET = 88,
	DAC960_LA_MBOX9_OFFSET = 89,
	DAC960_LA_MBOX10_OFFSET = 90,
	DAC960_LA_MBOX11_OFFSET = 91,
	DAC960_LA_MBOX12_OFFSET = 92,
	DAC960_LA_STSID_OFFSET = 93,
	DAC960_LA_STS_OFFSET = 94,
	DAC960_LA_IDB_OFFSET = 96,
	DAC960_LA_ODB_OFFSET = 97,
	DAC960_LA_ERRSTS_OFFSET = 99,
};

enum DAC960_LP_reg_offset {
	DAC960_LP_CMDMBX_OFFSET = 16,
	DAC960_LP_CMDSTS_OFFSET = 24,
	DAC960_LP_IDB_OFFSET = 32,
	DAC960_LP_ODB_OFFSET = 44,
	DAC960_LP_ERRSTS_OFFSET = 46,
	DAC960_LP_IRQSTS_OFFSET = 48,
	DAC960_LP_IRQMASK_OFFSET = 52,
};

enum DAC960_PD_reg_offset {
	DAC960_PD_CMDOP_OFFSET = 0,
	DAC960_PD_CMDID_OFFSET = 1,
	DAC960_PD_MBOX2_OFFSET = 2,
	DAC960_PD_MBOX3_OFFSET = 3,
	DAC960_PD_MBOX4_OFFSET = 4,
	DAC960_PD_MBOX5_OFFSET = 5,
	DAC960_PD_MBOX6_OFFSET = 6,
	DAC960_PD_MBOX7_OFFSET = 7,
	DAC960_PD_MBOX8_OFFSET = 8,
	DAC960_PD_MBOX9_OFFSET = 9,
	DAC960_PD_MBOX10_OFFSET = 10,
	DAC960_PD_MBOX11_OFFSET = 11,
	DAC960_PD_MBOX12_OFFSET = 12,
	DAC960_PD_STSID_OFFSET = 13,
	DAC960_PD_STS_OFFSET = 14,
	DAC960_PD_ERRSTS_OFFSET = 63,
	DAC960_PD_IDB_OFFSET = 64,
	DAC960_PD_ODB_OFFSET = 65,
	DAC960_PD_IRQEN_OFFSET = 67,
};

enum DAC960_PG_reg_offset {
	DAC960_PG_IDB_OFFSET = 32,
	DAC960_PG_ODB_OFFSET = 44,
	DAC960_PG_IRQMASK_OFFSET = 52,
	DAC960_PG_CMDOP_OFFSET = 4096,
	DAC960_PG_CMDID_OFFSET = 4097,
	DAC960_PG_MBOX2_OFFSET = 4098,
	DAC960_PG_MBOX3_OFFSET = 4099,
	DAC960_PG_MBOX4_OFFSET = 4100,
	DAC960_PG_MBOX5_OFFSET = 4101,
	DAC960_PG_MBOX6_OFFSET = 4102,
	DAC960_PG_MBOX7_OFFSET = 4103,
	DAC960_PG_MBOX8_OFFSET = 4104,
	DAC960_PG_MBOX9_OFFSET = 4105,
	DAC960_PG_MBOX10_OFFSET = 4106,
	DAC960_PG_MBOX11_OFFSET = 4107,
	DAC960_PG_MBOX12_OFFSET = 4108,
	DAC960_PG_STSID_OFFSET = 4120,
	DAC960_PG_STS_OFFSET = 4122,
	DAC960_PG_ERRSTS_OFFSET = 4159,
};

enum DCMD_RETURN_STATUS {
	DCMD_SUCCESS = 0,
	DCMD_TIMEOUT = 1,
	DCMD_FAILED = 2,
	DCMD_BUSY = 3,
	DCMD_INIT = 255,
};

enum DCMD_TIMEOUT_ACTION {
	INITIATE_OCR = 0,
	KILL_ADAPTER = 1,
	IGNORE_TIMEOUT = 2,
};

enum DTPM_NODE_TYPE {
	DTPM_NODE_VIRTUAL = 0,
	DTPM_NODE_DT = 1,
};

enum ELX_LOOPBACK_CMD {
	ELX_LOOPBACK_XRI_SETUP = 0,
	ELX_LOOPBACK_DATA = 1,
};

enum FILE_ATTRIBUTE {
	FILE_ATTRIBUTE_READONLY = 1,
	FILE_ATTRIBUTE_HIDDEN = 2,
	FILE_ATTRIBUTE_SYSTEM = 4,
	FILE_ATTRIBUTE_ARCHIVE = 32,
	FILE_ATTRIBUTE_DEVICE = 64,
	FILE_ATTRIBUTE_TEMPORARY = 256,
	FILE_ATTRIBUTE_SPARSE_FILE = 512,
	FILE_ATTRIBUTE_REPARSE_POINT = 1024,
	FILE_ATTRIBUTE_COMPRESSED = 2048,
	FILE_ATTRIBUTE_OFFLINE = 4096,
	FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 8192,
	FILE_ATTRIBUTE_ENCRYPTED = 16384,
	FILE_ATTRIBUTE_VALID_FLAGS = 32695,
	FILE_ATTRIBUTE_DIRECTORY = 268435456,
	FILE_ATTRIBUTE_INDEX = 536870912,
};

enum FW_BOOT_CONTEXT {
	PROBE_CONTEXT = 0,
	OCR_CONTEXT = 1,
};

enum HVSI_PROTOCOL_STATE {
	HVSI_CLOSED = 0,
	HVSI_WAIT_FOR_VER_RESPONSE = 1,
	HVSI_WAIT_FOR_VER_QUERY = 2,
	HVSI_OPEN = 3,
	HVSI_WAIT_FOR_MCTRL_RESPONSE = 4,
	HVSI_FSP_DIED = 5,
};

enum IO_REPARSE_TAG {
	IO_REPARSE_TAG_SYMBOLIC_LINK = 0,
	IO_REPARSE_TAG_NAME_SURROGATE = 536870912,
	IO_REPARSE_TAG_MICROSOFT = 2147483648,
	IO_REPARSE_TAG_MOUNT_POINT = 2684354563,
	IO_REPARSE_TAG_SYMLINK = 2684354572,
	IO_REPARSE_TAG_HSM = 3221225476,
	IO_REPARSE_TAG_SIS = 2147483655,
	IO_REPARSE_TAG_DEDUP = 2147483667,
	IO_REPARSE_TAG_COMPRESS = 2147483671,
	IO_REPARSE_TAG_DFS = 2147483658,
	IO_REPARSE_TAG_FILTER_MANAGER = 2147483659,
	IO_REPARSE_TAG_IFSTEST_CONGRUENT = 9,
	IO_REPARSE_TAG_ARKIVIO = 12,
	IO_REPARSE_TAG_SOLUTIONSOFT = 536870925,
	IO_REPARSE_TAG_COMMVAULT = 14,
	IO_REPARSE_TAG_CLOUD = 2415919130,
	IO_REPARSE_TAG_CLOUD_1 = 2415923226,
	IO_REPARSE_TAG_CLOUD_2 = 2415927322,
	IO_REPARSE_TAG_CLOUD_3 = 2415931418,
	IO_REPARSE_TAG_CLOUD_4 = 2415935514,
	IO_REPARSE_TAG_CLOUD_5 = 2415939610,
	IO_REPARSE_TAG_CLOUD_6 = 2415943706,
	IO_REPARSE_TAG_CLOUD_7 = 2415947802,
	IO_REPARSE_TAG_CLOUD_8 = 2415951898,
	IO_REPARSE_TAG_CLOUD_9 = 2415955994,
	IO_REPARSE_TAG_CLOUD_A = 2415960090,
	IO_REPARSE_TAG_CLOUD_B = 2415964186,
	IO_REPARSE_TAG_CLOUD_C = 2415968282,
	IO_REPARSE_TAG_CLOUD_D = 2415972378,
	IO_REPARSE_TAG_CLOUD_E = 2415976474,
	IO_REPARSE_TAG_CLOUD_F = 2415980570,
};

enum KTHREAD_BITS {
	KTHREAD_IS_PER_CPU = 0,
	KTHREAD_SHOULD_STOP = 1,
	KTHREAD_SHOULD_PARK = 2,
};

enum MCE_Disposition {
	MCE_DISPOSITION_RECOVERED = 0,
	MCE_DISPOSITION_NOT_RECOVERED = 1,
};

enum MCE_EratErrorType {
	MCE_ERAT_ERROR_INDETERMINATE = 0,
	MCE_ERAT_ERROR_PARITY = 1,
	MCE_ERAT_ERROR_MULTIHIT = 2,
};

enum MCE_ErrorClass {
	MCE_ECLASS_UNKNOWN = 0,
	MCE_ECLASS_HARDWARE = 1,
	MCE_ECLASS_HARD_INDETERMINATE = 2,
	MCE_ECLASS_SOFTWARE = 3,
	MCE_ECLASS_SOFT_INDETERMINATE = 4,
};

enum MCE_ErrorType {
	MCE_ERROR_TYPE_UNKNOWN = 0,
	MCE_ERROR_TYPE_UE = 1,
	MCE_ERROR_TYPE_SLB = 2,
	MCE_ERROR_TYPE_ERAT = 3,
	MCE_ERROR_TYPE_TLB = 4,
	MCE_ERROR_TYPE_USER = 5,
	MCE_ERROR_TYPE_RA = 6,
	MCE_ERROR_TYPE_LINK = 7,
	MCE_ERROR_TYPE_DCACHE = 8,
	MCE_ERROR_TYPE_ICACHE = 9,
};

enum MCE_Initiator {
	MCE_INITIATOR_UNKNOWN = 0,
	MCE_INITIATOR_CPU = 1,
	MCE_INITIATOR_PCI = 2,
	MCE_INITIATOR_ISA = 3,
	MCE_INITIATOR_MEMORY = 4,
	MCE_INITIATOR_POWERMGM = 5,
};

enum MCE_LinkErrorType {
	MCE_LINK_ERROR_INDETERMINATE = 0,
	MCE_LINK_ERROR_IFETCH_TIMEOUT = 1,
	MCE_LINK_ERROR_PAGE_TABLE_WALK_IFETCH_TIMEOUT = 2,
	MCE_LINK_ERROR_LOAD_TIMEOUT = 3,
	MCE_LINK_ERROR_STORE_TIMEOUT = 4,
	MCE_LINK_ERROR_PAGE_TABLE_WALK_LOAD_STORE_TIMEOUT = 5,
};

enum MCE_RaErrorType {
	MCE_RA_ERROR_INDETERMINATE = 0,
	MCE_RA_ERROR_IFETCH = 1,
	MCE_RA_ERROR_IFETCH_FOREIGN = 2,
	MCE_RA_ERROR_PAGE_TABLE_WALK_IFETCH = 3,
	MCE_RA_ERROR_PAGE_TABLE_WALK_IFETCH_FOREIGN = 4,
	MCE_RA_ERROR_LOAD = 5,
	MCE_RA_ERROR_STORE = 6,
	MCE_RA_ERROR_PAGE_TABLE_WALK_LOAD_STORE = 7,
	MCE_RA_ERROR_PAGE_TABLE_WALK_LOAD_STORE_FOREIGN = 8,
	MCE_RA_ERROR_LOAD_STORE_FOREIGN = 9,
};

enum MCE_Severity {
	MCE_SEV_NO_ERROR = 0,
	MCE_SEV_WARNING = 1,
	MCE_SEV_SEVERE = 2,
	MCE_SEV_FATAL = 3,
};

enum MCE_SlbErrorType {
	MCE_SLB_ERROR_INDETERMINATE = 0,
	MCE_SLB_ERROR_PARITY = 1,
	MCE_SLB_ERROR_MULTIHIT = 2,
};

enum MCE_TlbErrorType {
	MCE_TLB_ERROR_INDETERMINATE = 0,
	MCE_TLB_ERROR_PARITY = 1,
	MCE_TLB_ERROR_MULTIHIT = 2,
};

enum MCE_UeErrorType {
	MCE_UE_ERROR_INDETERMINATE = 0,
	MCE_UE_ERROR_IFETCH = 1,
	MCE_UE_ERROR_PAGE_TABLE_WALK_IFETCH = 2,
	MCE_UE_ERROR_LOAD_STORE = 3,
	MCE_UE_ERROR_PAGE_TABLE_WALK_LOAD_STORE = 4,
};

enum MCE_UserErrorType {
	MCE_USER_ERROR_INDETERMINATE = 0,
	MCE_USER_ERROR_TLBIE = 1,
	MCE_USER_ERROR_SCV = 2,
};

enum MCE_Version {
	MCE_V1 = 1,
};

enum MEGASAS_LD_TARGET_ID_STATUS {
	LD_TARGET_ID_INITIAL = 0,
	LD_TARGET_ID_ACTIVE = 1,
	LD_TARGET_ID_DELETED = 2,
};

enum MEGASAS_OCR_CAUSE {
	FW_FAULT_OCR = 0,
	SCSIIO_TIMEOUT_OCR = 1,
	MFI_IO_TIMEOUT_OCR = 2,
};

enum MFI_CMD_OP {
	MFI_CMD_INIT = 0,
	MFI_CMD_LD_READ = 1,
	MFI_CMD_LD_WRITE = 2,
	MFI_CMD_LD_SCSI_IO = 3,
	MFI_CMD_PD_SCSI_IO = 4,
	MFI_CMD_DCMD = 5,
	MFI_CMD_ABORT = 6,
	MFI_CMD_SMP = 7,
	MFI_CMD_STP = 8,
	MFI_CMD_NVME = 9,
	MFI_CMD_TOOLBOX = 10,
	MFI_CMD_OP_COUNT = 11,
	MFI_CMD_INVALID = 255,
};

enum MFI_STAT {
	MFI_STAT_OK = 0,
	MFI_STAT_INVALID_CMD = 1,
	MFI_STAT_INVALID_DCMD = 2,
	MFI_STAT_INVALID_PARAMETER = 3,
	MFI_STAT_INVALID_SEQUENCE_NUMBER = 4,
	MFI_STAT_ABORT_NOT_POSSIBLE = 5,
	MFI_STAT_APP_HOST_CODE_NOT_FOUND = 6,
	MFI_STAT_APP_IN_USE = 7,
	MFI_STAT_APP_NOT_INITIALIZED = 8,
	MFI_STAT_ARRAY_INDEX_INVALID = 9,
	MFI_STAT_ARRAY_ROW_NOT_EMPTY = 10,
	MFI_STAT_CONFIG_RESOURCE_CONFLICT = 11,
	MFI_STAT_DEVICE_NOT_FOUND = 12,
	MFI_STAT_DRIVE_TOO_SMALL = 13,
	MFI_STAT_FLASH_ALLOC_FAIL = 14,
	MFI_STAT_FLASH_BUSY = 15,
	MFI_STAT_FLASH_ERROR = 16,
	MFI_STAT_FLASH_IMAGE_BAD = 17,
	MFI_STAT_FLASH_IMAGE_INCOMPLETE = 18,
	MFI_STAT_FLASH_NOT_OPEN = 19,
	MFI_STAT_FLASH_NOT_STARTED = 20,
	MFI_STAT_FLUSH_FAILED = 21,
	MFI_STAT_HOST_CODE_NOT_FOUNT = 22,
	MFI_STAT_LD_CC_IN_PROGRESS = 23,
	MFI_STAT_LD_INIT_IN_PROGRESS = 24,
	MFI_STAT_LD_LBA_OUT_OF_RANGE = 25,
	MFI_STAT_LD_MAX_CONFIGURED = 26,
	MFI_STAT_LD_NOT_OPTIMAL = 27,
	MFI_STAT_LD_RBLD_IN_PROGRESS = 28,
	MFI_STAT_LD_RECON_IN_PROGRESS = 29,
	MFI_STAT_LD_WRONG_RAID_LEVEL = 30,
	MFI_STAT_MAX_SPARES_EXCEEDED = 31,
	MFI_STAT_MEMORY_NOT_AVAILABLE = 32,
	MFI_STAT_MFC_HW_ERROR = 33,
	MFI_STAT_NO_HW_PRESENT = 34,
	MFI_STAT_NOT_FOUND = 35,
	MFI_STAT_NOT_IN_ENCL = 36,
	MFI_STAT_PD_CLEAR_IN_PROGRESS = 37,
	MFI_STAT_PD_TYPE_WRONG = 38,
	MFI_STAT_PR_DISABLED = 39,
	MFI_STAT_ROW_INDEX_INVALID = 40,
	MFI_STAT_SAS_CONFIG_INVALID_ACTION = 41,
	MFI_STAT_SAS_CONFIG_INVALID_DATA = 42,
	MFI_STAT_SAS_CONFIG_INVALID_PAGE = 43,
	MFI_STAT_SAS_CONFIG_INVALID_TYPE = 44,
	MFI_STAT_SCSI_DONE_WITH_ERROR = 45,
	MFI_STAT_SCSI_IO_FAILED = 46,
	MFI_STAT_SCSI_RESERVATION_CONFLICT = 47,
	MFI_STAT_SHUTDOWN_FAILED = 48,
	MFI_STAT_TIME_NOT_SET = 49,
	MFI_STAT_WRONG_STATE = 50,
	MFI_STAT_LD_OFFLINE = 51,
	MFI_STAT_PEER_NOTIFICATION_REJECTED = 52,
	MFI_STAT_PEER_NOTIFICATION_FAILED = 53,
	MFI_STAT_RESERVATION_IN_PROGRESS = 54,
	MFI_STAT_I2C_ERRORS_DETECTED = 55,
	MFI_STAT_PCI_ERRORS_DETECTED = 56,
	MFI_STAT_CONFIG_SEQ_MISMATCH = 103,
	MFI_STAT_INVALID_STATUS = 255,
};

enum MR_ADAPTER_TYPE {
	MFI_SERIES = 1,
	THUNDERBOLT_SERIES = 2,
	INVADER_SERIES = 3,
	VENTURA_SERIES = 4,
	AERO_SERIES = 5,
};

enum MR_EVT_CLASS {
	MR_EVT_CLASS_DEBUG = -2,
	MR_EVT_CLASS_PROGRESS = -1,
	MR_EVT_CLASS_INFO = 0,
	MR_EVT_CLASS_WARNING = 1,
	MR_EVT_CLASS_CRITICAL = 2,
	MR_EVT_CLASS_FATAL = 3,
	MR_EVT_CLASS_DEAD = 4,
};

enum MR_EVT_LOCALE {
	MR_EVT_LOCALE_LD = 1,
	MR_EVT_LOCALE_PD = 2,
	MR_EVT_LOCALE_ENCL = 4,
	MR_EVT_LOCALE_BBU = 8,
	MR_EVT_LOCALE_SAS = 16,
	MR_EVT_LOCALE_CTRL = 32,
	MR_EVT_LOCALE_CONFIG = 64,
	MR_EVT_LOCALE_CLUSTER = 128,
	MR_EVT_LOCALE_ALL = 65535,
};

enum MR_FW_CRASH_DUMP_STATE {
	UNAVAILABLE = 0,
	AVAILABLE = 1,
	COPYING = 2,
	COPIED = 3,
	COPY_ERROR = 4,
};

enum MR_LD_QUERY_TYPE {
	MR_LD_QUERY_TYPE_ALL = 0,
	MR_LD_QUERY_TYPE_EXPOSED_TO_HOST = 1,
	MR_LD_QUERY_TYPE_USED_TGT_IDS = 2,
	MR_LD_QUERY_TYPE_CLUSTER_ACCESS = 3,
	MR_LD_QUERY_TYPE_CLUSTER_LOCALE = 4,
};

enum MR_PD_QUERY_TYPE {
	MR_PD_QUERY_TYPE_ALL = 0,
	MR_PD_QUERY_TYPE_STATE = 1,
	MR_PD_QUERY_TYPE_POWER_STATE = 2,
	MR_PD_QUERY_TYPE_MEDIA_TYPE = 3,
	MR_PD_QUERY_TYPE_SPEED = 4,
	MR_PD_QUERY_TYPE_EXPOSED_TO_HOST = 5,
};

enum MR_PD_STATE {
	MR_PD_STATE_UNCONFIGURED_GOOD = 0,
	MR_PD_STATE_UNCONFIGURED_BAD = 1,
	MR_PD_STATE_HOT_SPARE = 2,
	MR_PD_STATE_OFFLINE = 16,
	MR_PD_STATE_FAILED = 17,
	MR_PD_STATE_REBUILD = 20,
	MR_PD_STATE_ONLINE = 24,
	MR_PD_STATE_COPYBACK = 32,
	MR_PD_STATE_SYSTEM = 64,
};

enum MR_PD_TYPE {
	UNKNOWN_DRIVE = 0,
	PARALLEL_SCSI = 1,
	SAS_PD = 2,
	SATA_PD = 3,
	FC_PD = 4,
	NVME_PD = 5,
};

enum MR_PERF_MODE {
	MR_BALANCED_PERF_MODE = 0,
	MR_IOPS_PERF_MODE = 1,
	MR_LATENCY_PERF_MODE = 2,
};

enum MR_RAID_FLAGS_IO_SUB_TYPE {
	MR_RAID_FLAGS_IO_SUB_TYPE_NONE = 0,
	MR_RAID_FLAGS_IO_SUB_TYPE_SYSTEM_PD = 1,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_DATA = 2,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_P = 3,
	MR_RAID_FLAGS_IO_SUB_TYPE_RMW_Q = 4,
	MR_RAID_FLAGS_IO_SUB_TYPE_CACHE_BYPASS = 6,
	MR_RAID_FLAGS_IO_SUB_TYPE_LDIO_BW_LIMIT = 7,
	MR_RAID_FLAGS_IO_SUB_TYPE_R56_DIV_OFFLOAD = 8,
};

enum MR_RAID_MAP_DESC_TYPE {
	RAID_MAP_DESC_TYPE_DEVHDL_INFO = 0,
	RAID_MAP_DESC_TYPE_TGTID_INFO = 1,
	RAID_MAP_DESC_TYPE_ARRAY_INFO = 2,
	RAID_MAP_DESC_TYPE_SPAN_INFO = 3,
	RAID_MAP_DESC_TYPE_COUNT = 4,
};

enum MR_SCSI_CMD_TYPE {
	READ_WRITE_LDIO = 0,
	NON_READ_WRITE_LDIO = 1,
	READ_WRITE_SYSPDIO = 2,
	NON_READ_WRITE_SYSPDIO = 3,
};

enum NTFS_DIRTY_FLAGS {
	NTFS_DIRTY_CLEAR = 0,
	NTFS_DIRTY_DIRTY = 1,
	NTFS_DIRTY_ERROR = 2,
};

enum NTFS_LOG_OPERATION {
	Noop = 0,
	CompensationLogRecord = 1,
	InitializeFileRecordSegment = 2,
	DeallocateFileRecordSegment = 3,
	WriteEndOfFileRecordSegment = 4,
	CreateAttribute = 5,
	DeleteAttribute = 6,
	UpdateResidentValue = 7,
	UpdateNonresidentValue = 8,
	UpdateMappingPairs = 9,
	DeleteDirtyClusters = 10,
	SetNewAttributeSizes = 11,
	AddIndexEntryRoot = 12,
	DeleteIndexEntryRoot = 13,
	AddIndexEntryAllocation = 14,
	DeleteIndexEntryAllocation = 15,
	WriteEndOfIndexBuffer = 16,
	SetIndexEntryVcnRoot = 17,
	SetIndexEntryVcnAllocation = 18,
	UpdateFileNameRoot = 19,
	UpdateFileNameAllocation = 20,
	SetBitsInNonresidentBitMap = 21,
	ClearBitsInNonresidentBitMap = 22,
	HotFix = 23,
	EndTopLevelAction = 24,
	PrepareTransaction = 25,
	CommitTransaction = 26,
	ForgetTransaction = 27,
	OpenNonresidentAttribute = 28,
	OpenAttributeTableDump = 29,
	AttributeNamesDump = 30,
	DirtyPageTableDump = 31,
	TransactionTableDump = 32,
	UpdateRecordDataRoot = 33,
	UpdateRecordDataAllocation = 34,
	UpdateRelativeDataInIndex = 35,
	UpdateRelativeDataInIndex2 = 36,
	ZeroEndOfFileRecord = 37,
};

enum NTFS_SIGNATURE {
	NTFS_FILE_SIGNATURE = 1162627398,
	NTFS_INDX_SIGNATURE = 1480871497,
	NTFS_CHKD_SIGNATURE = 1145784387,
	NTFS_RSTR_SIGNATURE = 1381258066,
	NTFS_RCRD_SIGNATURE = 1146241874,
	NTFS_BAAD_SIGNATURE = 1145127234,
	NTFS_HOLE_SIGNATURE = 1162628936,
	NTFS_FFFF_SIGNATURE = 4294967295,
};

enum OID {
	OID_id_dsa_with_sha1 = 0,
	OID_id_dsa = 1,
	OID_id_ecPublicKey = 2,
	OID_id_prime192v1 = 3,
	OID_id_prime256v1 = 4,
	OID_id_ecdsa_with_sha1 = 5,
	OID_id_ecdsa_with_sha224 = 6,
	OID_id_ecdsa_with_sha256 = 7,
	OID_id_ecdsa_with_sha384 = 8,
	OID_id_ecdsa_with_sha512 = 9,
	OID_rsaEncryption = 10,
	OID_sha1WithRSAEncryption = 11,
	OID_sha256WithRSAEncryption = 12,
	OID_sha384WithRSAEncryption = 13,
	OID_sha512WithRSAEncryption = 14,
	OID_sha224WithRSAEncryption = 15,
	OID_data = 16,
	OID_signed_data = 17,
	OID_email_address = 18,
	OID_contentType = 19,
	OID_messageDigest = 20,
	OID_signingTime = 21,
	OID_smimeCapabilites = 22,
	OID_smimeAuthenticatedAttrs = 23,
	OID_mskrb5 = 24,
	OID_krb5 = 25,
	OID_krb5u2u = 26,
	OID_msIndirectData = 27,
	OID_msStatementType = 28,
	OID_msSpOpusInfo = 29,
	OID_msPeImageDataObjId = 30,
	OID_msIndividualSPKeyPurpose = 31,
	OID_msOutlookExpress = 32,
	OID_ntlmssp = 33,
	OID_negoex = 34,
	OID_spnego = 35,
	OID_IAKerb = 36,
	OID_PKU2U = 37,
	OID_Scram = 38,
	OID_certAuthInfoAccess = 39,
	OID_sha1 = 40,
	OID_id_ansip384r1 = 41,
	OID_id_ansip521r1 = 42,
	OID_sha256 = 43,
	OID_sha384 = 44,
	OID_sha512 = 45,
	OID_sha224 = 46,
	OID_commonName = 47,
	OID_surname = 48,
	OID_countryName = 49,
	OID_locality = 50,
	OID_stateOrProvinceName = 51,
	OID_organizationName = 52,
	OID_organizationUnitName = 53,
	OID_title = 54,
	OID_description = 55,
	OID_name = 56,
	OID_givenName = 57,
	OID_initials = 58,
	OID_generationalQualifier = 59,
	OID_subjectKeyIdentifier = 60,
	OID_keyUsage = 61,
	OID_subjectAltName = 62,
	OID_issuerAltName = 63,
	OID_basicConstraints = 64,
	OID_crlDistributionPoints = 65,
	OID_certPolicies = 66,
	OID_authorityKeyIdentifier = 67,
	OID_extKeyUsage = 68,
	OID_NetlogonMechanism = 69,
	OID_appleLocalKdcSupported = 70,
	OID_gostCPSignA = 71,
	OID_gostCPSignB = 72,
	OID_gostCPSignC = 73,
	OID_gost2012PKey256 = 74,
	OID_gost2012PKey512 = 75,
	OID_gost2012Digest256 = 76,
	OID_gost2012Digest512 = 77,
	OID_gost2012Signature256 = 78,
	OID_gost2012Signature512 = 79,
	OID_gostTC26Sign256A = 80,
	OID_gostTC26Sign256B = 81,
	OID_gostTC26Sign256C = 82,
	OID_gostTC26Sign256D = 83,
	OID_gostTC26Sign512A = 84,
	OID_gostTC26Sign512B = 85,
	OID_gostTC26Sign512C = 86,
	OID_sm2 = 87,
	OID_sm3 = 88,
	OID_SM2_with_SM3 = 89,
	OID_sm3WithRSAEncryption = 90,
	OID_TPMLoadableKey = 91,
	OID_TPMImportableKey = 92,
	OID_TPMSealedData = 93,
	OID_sha3_256 = 94,
	OID_sha3_384 = 95,
	OID_sha3_512 = 96,
	OID_id_ecdsa_with_sha3_256 = 97,
	OID_id_ecdsa_with_sha3_384 = 98,
	OID_id_ecdsa_with_sha3_512 = 99,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_256 = 100,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_384 = 101,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_512 = 102,
	OID__NR = 103,
};

enum OpalDeviceCompare {
	OPAL_IGNORE_RID_DEVICE_NUMBER = 0,
	OPAL_COMPARE_RID_DEVICE_NUMBER = 1,
};

enum OpalEehFreezeActionToken {
	OPAL_EEH_ACTION_CLEAR_FREEZE_MMIO = 1,
	OPAL_EEH_ACTION_CLEAR_FREEZE_DMA = 2,
	OPAL_EEH_ACTION_CLEAR_FREEZE_ALL = 3,
	OPAL_EEH_ACTION_SET_FREEZE_MMIO = 1,
	OPAL_EEH_ACTION_SET_FREEZE_DMA = 2,
	OPAL_EEH_ACTION_SET_FREEZE_ALL = 3,
};

enum OpalErrinjectFunc {
	OPAL_ERR_INJECT_FUNC_IOA_LD_MEM_ADDR = 0,
	OPAL_ERR_INJECT_FUNC_IOA_LD_MEM_DATA = 1,
	OPAL_ERR_INJECT_FUNC_IOA_LD_IO_ADDR = 2,
	OPAL_ERR_INJECT_FUNC_IOA_LD_IO_DATA = 3,
	OPAL_ERR_INJECT_FUNC_IOA_LD_CFG_ADDR = 4,
	OPAL_ERR_INJECT_FUNC_IOA_LD_CFG_DATA = 5,
	OPAL_ERR_INJECT_FUNC_IOA_ST_MEM_ADDR = 6,
	OPAL_ERR_INJECT_FUNC_IOA_ST_MEM_DATA = 7,
	OPAL_ERR_INJECT_FUNC_IOA_ST_IO_ADDR = 8,
	OPAL_ERR_INJECT_FUNC_IOA_ST_IO_DATA = 9,
	OPAL_ERR_INJECT_FUNC_IOA_ST_CFG_ADDR = 10,
	OPAL_ERR_INJECT_FUNC_IOA_ST_CFG_DATA = 11,
	OPAL_ERR_INJECT_FUNC_IOA_DMA_RD_ADDR = 12,
	OPAL_ERR_INJECT_FUNC_IOA_DMA_RD_DATA = 13,
	OPAL_ERR_INJECT_FUNC_IOA_DMA_RD_MASTER = 14,
	OPAL_ERR_INJECT_FUNC_IOA_DMA_RD_TARGET = 15,
	OPAL_ERR_INJECT_FUNC_IOA_DMA_WR_ADDR = 16,
	OPAL_ERR_INJECT_FUNC_IOA_DMA_WR_DATA = 17,
	OPAL_ERR_INJECT_FUNC_IOA_DMA_WR_MASTER = 18,
	OPAL_ERR_INJECT_FUNC_IOA_DMA_WR_TARGET = 19,
};

enum OpalErrinjectType {
	OPAL_ERR_INJECT_TYPE_IOA_BUS_ERR = 0,
	OPAL_ERR_INJECT_TYPE_IOA_BUS_ERR64 = 1,
};

enum OpalFreezeState {
	OPAL_EEH_STOPPED_NOT_FROZEN = 0,
	OPAL_EEH_STOPPED_MMIO_FREEZE = 1,
	OPAL_EEH_STOPPED_DMA_FREEZE = 2,
	OPAL_EEH_STOPPED_MMIO_DMA_FREEZE = 3,
	OPAL_EEH_STOPPED_RESET = 4,
	OPAL_EEH_STOPPED_TEMP_UNAVAIL = 5,
	OPAL_EEH_STOPPED_PERM_UNAVAIL = 6,
};

enum OpalFuncCompare {
	OPAL_IGNORE_RID_FUNCTION_NUMBER = 0,
	OPAL_COMPARE_RID_FUNCTION_NUMBER = 1,
};

enum OpalHMI_CoreXstopReason {
	CORE_CHECKSTOP_IFU_REGFILE = 1,
	CORE_CHECKSTOP_IFU_LOGIC = 2,
	CORE_CHECKSTOP_PC_DURING_RECOV = 4,
	CORE_CHECKSTOP_ISU_REGFILE = 8,
	CORE_CHECKSTOP_ISU_LOGIC = 16,
	CORE_CHECKSTOP_FXU_LOGIC = 32,
	CORE_CHECKSTOP_VSU_LOGIC = 64,
	CORE_CHECKSTOP_PC_RECOV_IN_MAINT_MODE = 128,
	CORE_CHECKSTOP_LSU_REGFILE = 256,
	CORE_CHECKSTOP_PC_FWD_PROGRESS = 512,
	CORE_CHECKSTOP_LSU_LOGIC = 1024,
	CORE_CHECKSTOP_PC_LOGIC = 2048,
	CORE_CHECKSTOP_PC_HYP_RESOURCE = 4096,
	CORE_CHECKSTOP_PC_HANG_RECOV_FAILED = 8192,
	CORE_CHECKSTOP_PC_AMBI_HANG_DETECTED = 16384,
	CORE_CHECKSTOP_PC_DEBUG_TRIG_ERR_INJ = 32768,
	CORE_CHECKSTOP_PC_SPRD_HYP_ERR_INJ = 65536,
};

enum OpalHMI_Disposition {
	OpalHMI_DISPOSITION_RECOVERED = 0,
	OpalHMI_DISPOSITION_NOT_RECOVERED = 1,
};

enum OpalHMI_ErrType {
	OpalHMI_ERROR_MALFUNC_ALERT = 0,
	OpalHMI_ERROR_PROC_RECOV_DONE = 1,
	OpalHMI_ERROR_PROC_RECOV_DONE_AGAIN = 2,
	OpalHMI_ERROR_PROC_RECOV_MASKED = 3,
	OpalHMI_ERROR_TFAC = 4,
	OpalHMI_ERROR_TFMR_PARITY = 5,
	OpalHMI_ERROR_HA_OVERFLOW_WARN = 6,
	OpalHMI_ERROR_XSCOM_FAIL = 7,
	OpalHMI_ERROR_XSCOM_DONE = 8,
	OpalHMI_ERROR_SCOM_FIR = 9,
	OpalHMI_ERROR_DEBUG_TRIG_FIR = 10,
	OpalHMI_ERROR_HYP_RESOURCE = 11,
	OpalHMI_ERROR_CAPP_RECOVERY = 12,
};

enum OpalHMI_NestAccelXstopReason {
	NX_CHECKSTOP_SHM_INVAL_STATE_ERR = 1,
	NX_CHECKSTOP_DMA_INVAL_STATE_ERR_1 = 2,
	NX_CHECKSTOP_DMA_INVAL_STATE_ERR_2 = 4,
	NX_CHECKSTOP_DMA_CH0_INVAL_STATE_ERR = 8,
	NX_CHECKSTOP_DMA_CH1_INVAL_STATE_ERR = 16,
	NX_CHECKSTOP_DMA_CH2_INVAL_STATE_ERR = 32,
	NX_CHECKSTOP_DMA_CH3_INVAL_STATE_ERR = 64,
	NX_CHECKSTOP_DMA_CH4_INVAL_STATE_ERR = 128,
	NX_CHECKSTOP_DMA_CH5_INVAL_STATE_ERR = 256,
	NX_CHECKSTOP_DMA_CH6_INVAL_STATE_ERR = 512,
	NX_CHECKSTOP_DMA_CH7_INVAL_STATE_ERR = 1024,
	NX_CHECKSTOP_DMA_CRB_UE = 2048,
	NX_CHECKSTOP_DMA_CRB_SUE = 4096,
	NX_CHECKSTOP_PBI_ISN_UE = 8192,
};

enum OpalHMI_Severity {
	OpalHMI_SEV_NO_ERROR = 0,
	OpalHMI_SEV_WARNING = 1,
	OpalHMI_SEV_ERROR_SYNC = 2,
	OpalHMI_SEV_FATAL = 3,
};

enum OpalHMI_Version {
	OpalHMIEvt_V1 = 1,
	OpalHMIEvt_V2 = 2,
};

enum OpalHMI_XstopType {
	CHECKSTOP_TYPE_UNKNOWN = 0,
	CHECKSTOP_TYPE_CORE = 1,
	CHECKSTOP_TYPE_NX = 2,
	CHECKSTOP_TYPE_NPU = 3,
};

enum OpalLPCAddressType {
	OPAL_LPC_MEM = 0,
	OPAL_LPC_IO = 1,
	OPAL_LPC_FW = 2,
};

enum OpalM64Action {
	OPAL_DISABLE_M64 = 0,
	OPAL_ENABLE_M64_SPLIT = 1,
	OPAL_ENABLE_M64_NON_SPLIT = 2,
};

enum OpalMemErrType {
	OPAL_MEM_ERR_TYPE_RESILIENCE = 0,
	OPAL_MEM_ERR_TYPE_DYN_DALLOC = 1,
};

enum OpalMemErr_DynErrType {
	OPAL_MEM_DYNAMIC_DEALLOC = 0,
};

enum OpalMemErr_ResilErrType {
	OPAL_MEM_RESILIENCE_CE = 0,
	OPAL_MEM_RESILIENCE_UE = 1,
	OPAL_MEM_RESILIENCE_UE_SCRUB = 2,
};

enum OpalMemErr_Version {
	OpalMemErr_V1 = 1,
};

enum OpalMmioWindowType {
	OPAL_M32_WINDOW_TYPE = 1,
	OPAL_M64_WINDOW_TYPE = 2,
	OPAL_IO_WINDOW_TYPE = 3,
};

enum OpalPciBusCompare {
	OpalPciBusAny = 0,
	OpalPciBus3Bits = 2,
	OpalPciBus4Bits = 3,
	OpalPciBus5Bits = 4,
	OpalPciBus6Bits = 5,
	OpalPciBus7Bits = 6,
	OpalPciBusAll = 7,
};

enum OpalPciErrorSeverity {
	OPAL_EEH_SEV_NO_ERROR = 0,
	OPAL_EEH_SEV_IOC_DEAD = 1,
	OPAL_EEH_SEV_PHB_DEAD = 2,
	OPAL_EEH_SEV_PHB_FENCED = 3,
	OPAL_EEH_SEV_PE_ER = 4,
	OPAL_EEH_SEV_INF = 5,
};

enum OpalPciReinitScope {
	OPAL_REINIT_PCI_DEV = 1000,
};

enum OpalPciResetScope {
	OPAL_RESET_PHB_COMPLETE = 1,
	OPAL_RESET_PCI_LINK = 2,
	OPAL_RESET_PHB_ERROR = 3,
	OPAL_RESET_PCI_HOT = 4,
	OPAL_RESET_PCI_FUNDAMENTAL = 5,
	OPAL_RESET_PCI_IODA_TABLE = 6,
};

enum OpalPciResetState {
	OPAL_DEASSERT_RESET = 0,
	OPAL_ASSERT_RESET = 1,
};

enum OpalPciStatusToken {
	OPAL_EEH_NO_ERROR = 0,
	OPAL_EEH_IOC_ERROR = 1,
	OPAL_EEH_PHB_ERROR = 2,
	OPAL_EEH_PE_ERROR = 3,
	OPAL_EEH_PE_MMIO_ERROR = 4,
	OPAL_EEH_PE_DMA_ERROR = 5,
};

enum OpalPeAction {
	OPAL_UNMAP_PE = 0,
	OPAL_MAP_PE = 1,
};

enum OpalPeltvAction {
	OPAL_REMOVE_PE_FROM_DOMAIN = 0,
	OPAL_ADD_PE_TO_DOMAIN = 1,
};

enum OpalPendingState {
	OPAL_EVENT_OPAL_INTERNAL = 1,
	OPAL_EVENT_NVRAM = 2,
	OPAL_EVENT_RTC = 4,
	OPAL_EVENT_CONSOLE_OUTPUT = 8,
	OPAL_EVENT_CONSOLE_INPUT = 16,
	OPAL_EVENT_ERROR_LOG_AVAIL = 32,
	OPAL_EVENT_ERROR_LOG = 64,
	OPAL_EVENT_EPOW = 128,
	OPAL_EVENT_LED_STATUS = 256,
	OPAL_EVENT_PCI_ERROR = 512,
	OPAL_EVENT_DUMP_AVAIL = 1024,
	OPAL_EVENT_MSG_PENDING = 2048,
};

enum OpalSysEpow {
	OPAL_SYSEPOW_POWER = 0,
	OPAL_SYSEPOW_TEMP = 1,
	OPAL_SYSEPOW_COOLING = 2,
	OPAL_SYSEPOW_MAX = 3,
};

enum OpalSysPower {
	OPAL_SYSPOWER_UPS = 1,
	OPAL_SYSPOWER_CHNG = 2,
	OPAL_SYSPOWER_FAIL = 4,
	OPAL_SYSPOWER_INCL = 8,
};

enum OpalSysparamPerm {
	OPAL_SYSPARAM_READ = 1,
	OPAL_SYSPARAM_WRITE = 2,
	OPAL_SYSPARAM_RW = 3,
};

enum OpalThreadStatus {
	OPAL_THREAD_INACTIVE = 0,
	OPAL_THREAD_STARTED = 1,
	OPAL_THREAD_UNAVAILABLE = 2,
};

enum Opt {
	Opt_uid___3 = 0,
	Opt_gid___3 = 1,
	Opt_umask = 2,
	Opt_dmask = 3,
	Opt_fmask = 4,
	Opt_immutable = 5,
	Opt_discard___2 = 6,
	Opt_force = 7,
	Opt_sparse = 8,
	Opt_nohidden = 9,
	Opt_hide_dot_files = 10,
	Opt_windows_names = 11,
	Opt_showmeta = 12,
	Opt_acl___2 = 13,
	Opt_iocharset = 14,
	Opt_prealloc = 15,
	Opt_nocase = 16,
	Opt_err___4 = 17,
};

enum RECORD_FLAG {
	RECORD_FLAG_IN_USE = 1,
	RECORD_FLAG_DIR = 2,
	RECORD_FLAG_SYSTEM = 4,
	RECORD_FLAG_INDEX = 8,
};

enum RECORD_NUM {
	MFT_REC_MFT = 0,
	MFT_REC_MIRR = 1,
	MFT_REC_LOG = 2,
	MFT_REC_VOL = 3,
	MFT_REC_ATTR = 4,
	MFT_REC_ROOT = 5,
	MFT_REC_BITMAP = 6,
	MFT_REC_BOOT = 7,
	MFT_REC_BADCLUST = 8,
	MFT_REC_SECURE = 9,
	MFT_REC_UPCASE = 10,
	MFT_REC_EXTEND = 11,
	MFT_REC_RESERVED = 12,
	MFT_REC_FREE = 16,
	MFT_REC_USER = 24,
};

enum REGION_TYPE {
	REGION_TYPE_UNUSED = 0,
	REGION_TYPE_SHARED_READ = 1,
	REGION_TYPE_SHARED_WRITE = 2,
	REGION_TYPE_EXCLUSIVE = 3,
};

enum REPARSE_SIGN {
	REPARSE_NONE = 0,
	REPARSE_COMPRESSED = 1,
	REPARSE_DEDUPLICATED = 2,
	REPARSE_LINK = 3,
};

enum SHIFT_DIRECTION {
	SHIFT_LEFT = 0,
	SHIFT_RIGHT = 1,
};

enum VANIR_REVISION_ID {
	VANIR_A0_REV = 160,
	VANIR_B0_REV = 1,
	VANIR_C0_REV = 2,
	VANIR_C1_REV = 3,
	VANIR_C2_REV = 194,
};

enum VP_STATUS {
	VP_STAT_COMPL = 0,
	VP_STAT_FAIL = 1,
	VP_STAT_ID_CHG = 2,
	VP_STAT_SNS_TO = 3,
	VP_STAT_SNS_RJT = 4,
	VP_STAT_SCR_TO = 5,
	VP_STAT_SCR_RJT = 6,
};

enum _MR_CRASH_BUF_STATUS {
	MR_CRASH_BUF_TURN_OFF = 0,
	MR_CRASH_BUF_TURN_ON = 1,
};

enum _MpiIocLogInfoFc {
	MPI_IOCLOGINFO_FC_INIT_BASE = 536870912,
	MPI_IOCLOGINFO_FC_INIT_ERROR_OUT_OF_ORDER_FRAME = 536870913,
	MPI_IOCLOGINFO_FC_INIT_ERROR_BAD_START_OF_FRAME = 536870914,
	MPI_IOCLOGINFO_FC_INIT_ERROR_BAD_END_OF_FRAME = 536870915,
	MPI_IOCLOGINFO_FC_INIT_ERROR_OVER_RUN = 536870916,
	MPI_IOCLOGINFO_FC_INIT_ERROR_RX_OTHER = 536870917,
	MPI_IOCLOGINFO_FC_INIT_ERROR_SUBPROC_DEAD = 536870918,
	MPI_IOCLOGINFO_FC_INIT_ERROR_RX_OVERRUN = 536870919,
	MPI_IOCLOGINFO_FC_INIT_ERROR_RX_BAD_STATUS = 536870920,
	MPI_IOCLOGINFO_FC_INIT_ERROR_RX_UNEXPECTED_FRAME = 536870921,
	MPI_IOCLOGINFO_FC_INIT_ERROR_LINK_FAILURE = 536870922,
	MPI_IOCLOGINFO_FC_INIT_ERROR_TX_TIMEOUT = 536870923,
	MPI_IOCLOGINFO_FC_TARGET_BASE = 553648128,
	MPI_IOCLOGINFO_FC_TARGET_NO_PDISC = 553648129,
	MPI_IOCLOGINFO_FC_TARGET_NO_LOGIN = 553648130,
	MPI_IOCLOGINFO_FC_TARGET_DOAR_KILLED_BY_LIP = 553648131,
	MPI_IOCLOGINFO_FC_TARGET_DIAR_KILLED_BY_LIP = 553648132,
	MPI_IOCLOGINFO_FC_TARGET_DIAR_MISSING_DATA = 553648133,
	MPI_IOCLOGINFO_FC_TARGET_DONR_KILLED_BY_LIP = 553648134,
	MPI_IOCLOGINFO_FC_TARGET_WRSP_KILLED_BY_LIP = 553648135,
	MPI_IOCLOGINFO_FC_TARGET_DINR_KILLED_BY_LIP = 553648136,
	MPI_IOCLOGINFO_FC_TARGET_DINR_MISSING_DATA = 553648137,
	MPI_IOCLOGINFO_FC_TARGET_MRSP_KILLED_BY_LIP = 553648138,
	MPI_IOCLOGINFO_FC_TARGET_NO_CLASS_3 = 553648139,
	MPI_IOCLOGINFO_FC_TARGET_LOGIN_NOT_VALID = 553648140,
	MPI_IOCLOGINFO_FC_TARGET_FROM_OUTBOUND = 553648142,
	MPI_IOCLOGINFO_FC_TARGET_WAITING_FOR_DATA_IN = 553648143,
	MPI_IOCLOGINFO_FC_LAN_BASE = 570425344,
	MPI_IOCLOGINFO_FC_LAN_TRANS_SGL_MISSING = 570425345,
	MPI_IOCLOGINFO_FC_LAN_TRANS_WRONG_PLACE = 570425346,
	MPI_IOCLOGINFO_FC_LAN_TRANS_RES_BITS_SET = 570425347,
	MPI_IOCLOGINFO_FC_LAN_WRONG_SGL_FLAG = 570425348,
	MPI_IOCLOGINFO_FC_MSG_BASE = 587202560,
	MPI_IOCLOGINFO_FC_LINK_BASE = 603979776,
	MPI_IOCLOGINFO_FC_LINK_LOOP_INIT_TIMEOUT = 603979777,
	MPI_IOCLOGINFO_FC_LINK_ALREADY_INITIALIZED = 603979778,
	MPI_IOCLOGINFO_FC_LINK_LINK_NOT_ESTABLISHED = 603979779,
	MPI_IOCLOGINFO_FC_LINK_CRC_ERROR = 603979780,
	MPI_IOCLOGINFO_FC_CTX_BASE = 620756992,
	MPI_IOCLOGINFO_FC_INVALID_FIELD_BYTE_OFFSET = 637534208,
	MPI_IOCLOGINFO_FC_INVALID_FIELD_MAX_OFFSET = 654311423,
	MPI_IOCLOGINFO_FC_STATE_CHANGE = 654311424,
};

enum __sk_action {
	__SK_DROP = 0,
	__SK_PASS = 1,
	__SK_REDIRECT = 2,
	__SK_NONE = 3,
};

enum _lpfc_ctx_cmd {
	LPFC_CTX_LUN = 0,
	LPFC_CTX_TGT = 1,
	LPFC_CTX_HOST = 2,
};

typedef enum _lpfc_ctx_cmd lpfc_ctx_cmd;

enum _lpfc_iocb_type {
	LPFC_UNKNOWN_IOCB = 0,
	LPFC_UNSOL_IOCB = 1,
	LPFC_SOL_IOCB = 2,
	LPFC_ABORT_IOCB = 3,
};

typedef enum _lpfc_iocb_type lpfc_iocb_type;

enum _slab_flag_bits {
	_SLAB_CONSISTENCY_CHECKS = 0,
	_SLAB_RED_ZONE = 1,
	_SLAB_POISON = 2,
	_SLAB_KMALLOC = 3,
	_SLAB_HWCACHE_ALIGN = 4,
	_SLAB_CACHE_DMA = 5,
	_SLAB_CACHE_DMA32 = 6,
	_SLAB_STORE_USER = 7,
	_SLAB_PANIC = 8,
	_SLAB_TYPESAFE_BY_RCU = 9,
	_SLAB_TRACE = 10,
	_SLAB_NOLEAKTRACE = 11,
	_SLAB_NO_MERGE = 12,
	_SLAB_ACCOUNT = 13,
	_SLAB_NO_USER_FLAGS = 14,
	_SLAB_RECLAIM_ACCOUNT = 15,
	_SLAB_OBJECT_POISON = 16,
	_SLAB_CMPXCHG_DOUBLE = 17,
	_SLAB_NO_OBJ_EXT = 18,
	_SLAB_FLAGS_LAST_BIT = 19,
};

enum aa_code {
	AA_U8 = 0,
	AA_U16 = 1,
	AA_U32 = 2,
	AA_U64 = 3,
	AA_NAME = 4,
	AA_STRING = 5,
	AA_BLOB = 6,
	AA_STRUCT = 7,
	AA_STRUCTEND = 8,
	AA_LIST = 9,
	AA_LISTEND = 10,
	AA_ARRAY = 11,
	AA_ARRAYEND = 12,
};

enum aa_sfs_type {
	AA_SFS_TYPE_BOOLEAN = 0,
	AA_SFS_TYPE_STRING = 1,
	AA_SFS_TYPE_U64 = 2,
	AA_SFS_TYPE_FOPS = 3,
	AA_SFS_TYPE_DIR = 4,
};

enum aac_cmd_owner {
	AAC_OWNER_MIDLEVEL = 257,
	AAC_OWNER_LOWLEVEL = 258,
	AAC_OWNER_ERROR_HANDLER = 259,
	AAC_OWNER_FIRMWARE = 262,
};

enum aac_log_level {
	LOG_AAC_INIT = 10,
	LOG_AAC_INFORMATIONAL = 20,
	LOG_AAC_WARNING = 30,
	LOG_AAC_LOW_ERROR = 40,
	LOG_AAC_MEDIUM_ERROR = 50,
	LOG_AAC_HIGH_ERROR = 60,
	LOG_AAC_PANIC = 70,
	LOG_AAC_DEBUG = 80,
	LOG_AAC_WINDBG_PRINT = 90,
};

enum aac_queue_types {
	HostNormCmdQueue = 0,
	HostHighCmdQueue = 1,
	AdapNormCmdQueue = 2,
	AdapHighCmdQueue = 3,
	HostNormRespQueue = 4,
	HostHighRespQueue = 5,
	AdapNormRespQueue = 6,
	AdapHighRespQueue = 7,
};

enum aafs_ns_type {
	AAFS_NS_DIR = 0,
	AAFS_NS_PROFS = 1,
	AAFS_NS_NS = 2,
	AAFS_NS_RAW_DATA = 3,
	AAFS_NS_LOAD = 4,
	AAFS_NS_REPLACE = 5,
	AAFS_NS_REMOVE = 6,
	AAFS_NS_REVISION = 7,
	AAFS_NS_COUNT = 8,
	AAFS_NS_MAX_COUNT = 9,
	AAFS_NS_SIZE = 10,
	AAFS_NS_MAX_SIZE = 11,
	AAFS_NS_OWNER = 12,
	AAFS_NS_SIZEOF = 13,
};

enum aafs_prof_type {
	AAFS_PROF_DIR = 0,
	AAFS_PROF_PROFS = 1,
	AAFS_PROF_NAME = 2,
	AAFS_PROF_MODE = 3,
	AAFS_PROF_ATTACH = 4,
	AAFS_PROF_HASH = 5,
	AAFS_PROF_RAW_DATA = 6,
	AAFS_PROF_RAW_HASH = 7,
	AAFS_PROF_RAW_ABI = 8,
	AAFS_PROF_SIZEOF = 9,
};

enum aat2870_id {
	AAT2870_ID_BL = 0,
	AAT2870_ID_LDOA = 1,
	AAT2870_ID_LDOB = 2,
	AAT2870_ID_LDOC = 3,
	AAT2870_ID_LDOD = 4,
};

enum access_coordinate_class {
	ACCESS_COORDINATE_LOCAL = 0,
	ACCESS_COORDINATE_CPU = 1,
	ACCESS_COORDINATE_MAX = 2,
};

enum acpi_cdat_type {
	ACPI_CDAT_TYPE_DSMAS = 0,
	ACPI_CDAT_TYPE_DSLBIS = 1,
	ACPI_CDAT_TYPE_DSMSCIS = 2,
	ACPI_CDAT_TYPE_DSIS = 3,
	ACPI_CDAT_TYPE_DSEMTS = 4,
	ACPI_CDAT_TYPE_SSLBIS = 5,
	ACPI_CDAT_TYPE_RESERVED = 6,
};

enum acpi_subtable_type {
	ACPI_SUBTABLE_COMMON = 0,
	ACPI_SUBTABLE_HMAT = 1,
	ACPI_SUBTABLE_PRMT = 2,
	ACPI_SUBTABLE_CEDT = 3,
	CDAT_SUBTABLE = 4,
};

enum action {
	ABORT_COMMAND = 0,
	DEVICE_RESET = 1,
	BUS_RESET = 2,
};

enum action_id {
	ACTION_SAVE = 1,
	ACTION_TRACE = 2,
	ACTION_SNAPSHOT = 3,
};

enum actions {
	REGISTER = 0,
	DEREGISTER = 1,
	CPU_DONT_CARE = 2,
};

enum addr_type_t {
	UNICAST_ADDR = 0,
	MULTICAST_ADDR = 1,
	ANYCAST_ADDR = 2,
};

enum al_fic_state {
	AL_FIC_UNCONFIGURED = 0,
	AL_FIC_CONFIGURED_LEVEL = 1,
	AL_FIC_CONFIGURED_RISING_EDGE = 2,
};

enum alarmtimer_restart {
	ALARMTIMER_NORESTART = 0,
	ALARMTIMER_RESTART = 1,
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum amd_chipset_gen {
	NOT_AMD_CHIPSET = 0,
	AMD_CHIPSET_SB600 = 1,
	AMD_CHIPSET_SB700 = 2,
	AMD_CHIPSET_SB800 = 3,
	AMD_CHIPSET_HUDSON2 = 4,
	AMD_CHIPSET_BOLTON = 5,
	AMD_CHIPSET_YANGTZE = 6,
	AMD_CHIPSET_TAISHAN = 7,
	AMD_CHIPSET_UNKNOWN = 8,
};

enum as3711_su2_fbprot {
	AS3711_SU2_LX_SD4 = 0,
	AS3711_SU2_GPIO2 = 1,
	AS3711_SU2_GPIO3 = 2,
	AS3711_SU2_GPIO4 = 3,
};

enum as3711_su2_feedback {
	AS3711_SU2_VOLTAGE = 0,
	AS3711_SU2_CURR1 = 1,
	AS3711_SU2_CURR2 = 2,
	AS3711_SU2_CURR3 = 3,
	AS3711_SU2_CURR_AUTO = 4,
};

enum asn1_class {
	ASN1_UNIV = 0,
	ASN1_APPL = 1,
	ASN1_CONT = 2,
	ASN1_PRIV = 3,
};

enum asn1_method {
	ASN1_PRIM = 0,
	ASN1_CONS = 1,
};

enum asn1_opcode {
	ASN1_OP_MATCH = 0,
	ASN1_OP_MATCH_OR_SKIP = 1,
	ASN1_OP_MATCH_ACT = 2,
	ASN1_OP_MATCH_ACT_OR_SKIP = 3,
	ASN1_OP_MATCH_JUMP = 4,
	ASN1_OP_MATCH_JUMP_OR_SKIP = 5,
	ASN1_OP_MATCH_ANY = 8,
	ASN1_OP_MATCH_ANY_OR_SKIP = 9,
	ASN1_OP_MATCH_ANY_ACT = 10,
	ASN1_OP_MATCH_ANY_ACT_OR_SKIP = 11,
	ASN1_OP_COND_MATCH_OR_SKIP = 17,
	ASN1_OP_COND_MATCH_ACT_OR_SKIP = 19,
	ASN1_OP_COND_MATCH_JUMP_OR_SKIP = 21,
	ASN1_OP_COND_MATCH_ANY = 24,
	ASN1_OP_COND_MATCH_ANY_OR_SKIP = 25,
	ASN1_OP_COND_MATCH_ANY_ACT = 26,
	ASN1_OP_COND_MATCH_ANY_ACT_OR_SKIP = 27,
	ASN1_OP_COND_FAIL = 28,
	ASN1_OP_COMPLETE = 29,
	ASN1_OP_ACT = 30,
	ASN1_OP_MAYBE_ACT = 31,
	ASN1_OP_END_SEQ = 32,
	ASN1_OP_END_SET = 33,
	ASN1_OP_END_SEQ_OF = 34,
	ASN1_OP_END_SET_OF = 35,
	ASN1_OP_END_SEQ_ACT = 36,
	ASN1_OP_END_SET_ACT = 37,
	ASN1_OP_END_SEQ_OF_ACT = 38,
	ASN1_OP_END_SET_OF_ACT = 39,
	ASN1_OP_RETURN = 40,
	ASN1_OP__NR = 41,
};

enum asn1_tag {
	ASN1_EOC = 0,
	ASN1_BOOL = 1,
	ASN1_INT = 2,
	ASN1_BTS = 3,
	ASN1_OTS = 4,
	ASN1_NULL = 5,
	ASN1_OID = 6,
	ASN1_ODE = 7,
	ASN1_EXT = 8,
	ASN1_REAL = 9,
	ASN1_ENUM = 10,
	ASN1_EPDV = 11,
	ASN1_UTF8STR = 12,
	ASN1_RELOID = 13,
	ASN1_SEQ = 16,
	ASN1_SET = 17,
	ASN1_NUMSTR = 18,
	ASN1_PRNSTR = 19,
	ASN1_TEXSTR = 20,
	ASN1_VIDSTR = 21,
	ASN1_IA5STR = 22,
	ASN1_UNITIM = 23,
	ASN1_GENTIM = 24,
	ASN1_GRASTR = 25,
	ASN1_VISSTR = 26,
	ASN1_GENSTR = 27,
	ASN1_UNISTR = 28,
	ASN1_CHRSTR = 29,
	ASN1_BMPSTR = 30,
	ASN1_LONG_TAG = 31,
};

enum assoc_array_walk_status {
	assoc_array_walk_tree_empty = 0,
	assoc_array_walk_found_terminal_node = 1,
	assoc_array_walk_found_wrong_shortcut = 2,
};

enum asymmetric_payload_bits {
	asym_crypto = 0,
	asym_subtype = 1,
	asym_key_ids = 2,
	asym_auth = 3,
};

enum ata_completion_errors {
	AC_ERR_OK = 0,
	AC_ERR_DEV = 1,
	AC_ERR_HSM = 2,
	AC_ERR_TIMEOUT = 4,
	AC_ERR_MEDIA = 8,
	AC_ERR_ATA_BUS = 16,
	AC_ERR_HOST_BUS = 32,
	AC_ERR_SYSTEM = 64,
	AC_ERR_INVALID = 128,
	AC_ERR_OTHER = 256,
	AC_ERR_NODEV_HINT = 512,
	AC_ERR_NCQ = 1024,
};

enum ata_dev_iter_mode {
	ATA_DITER_ENABLED = 0,
	ATA_DITER_ENABLED_REVERSE = 1,
	ATA_DITER_ALL = 2,
	ATA_DITER_ALL_REVERSE = 3,
};

enum ata_link_iter_mode {
	ATA_LITER_EDGE = 0,
	ATA_LITER_HOST_FIRST = 1,
	ATA_LITER_PMP_FIRST = 2,
};

enum ata_lpm_hints {
	ATA_LPM_EMPTY = 1,
	ATA_LPM_HIPM = 2,
	ATA_LPM_WAKE_ONLY = 4,
};

enum ata_lpm_policy {
	ATA_LPM_UNKNOWN = 0,
	ATA_LPM_MAX_POWER = 1,
	ATA_LPM_MED_POWER = 2,
	ATA_LPM_MED_POWER_WITH_DIPM = 3,
	ATA_LPM_MIN_POWER_WITH_PARTIAL = 4,
	ATA_LPM_MIN_POWER = 5,
};

enum ata_prot_flags {
	ATA_PROT_FLAG_PIO = 1,
	ATA_PROT_FLAG_DMA = 2,
	ATA_PROT_FLAG_NCQ = 4,
	ATA_PROT_FLAG_ATAPI = 8,
	ATA_PROT_UNKNOWN = 255,
	ATA_PROT_NODATA = 0,
	ATA_PROT_PIO = 1,
	ATA_PROT_DMA = 2,
	ATA_PROT_NCQ_NODATA = 4,
	ATA_PROT_NCQ = 6,
	ATAPI_PROT_NODATA = 8,
	ATAPI_PROT_PIO = 9,
	ATAPI_PROT_DMA = 10,
};

enum ata_xfer_mask {
	ATA_MASK_PIO = 127,
	ATA_MASK_MWDMA = 3968,
	ATA_MASK_UDMA = 1044480,
};

enum attr_idn {
	QUERY_ATTR_IDN_BOOT_LU_EN = 0,
	QUERY_ATTR_IDN_MAX_HPB_SINGLE_CMD = 1,
	QUERY_ATTR_IDN_POWER_MODE = 2,
	QUERY_ATTR_IDN_ACTIVE_ICC_LVL = 3,
	QUERY_ATTR_IDN_OOO_DATA_EN = 4,
	QUERY_ATTR_IDN_BKOPS_STATUS = 5,
	QUERY_ATTR_IDN_PURGE_STATUS = 6,
	QUERY_ATTR_IDN_MAX_DATA_IN = 7,
	QUERY_ATTR_IDN_MAX_DATA_OUT = 8,
	QUERY_ATTR_IDN_DYN_CAP_NEEDED = 9,
	QUERY_ATTR_IDN_REF_CLK_FREQ = 10,
	QUERY_ATTR_IDN_CONF_DESC_LOCK = 11,
	QUERY_ATTR_IDN_MAX_NUM_OF_RTT = 12,
	QUERY_ATTR_IDN_EE_CONTROL = 13,
	QUERY_ATTR_IDN_EE_STATUS = 14,
	QUERY_ATTR_IDN_SECONDS_PASSED = 15,
	QUERY_ATTR_IDN_CNTX_CONF = 16,
	QUERY_ATTR_IDN_CORR_PRG_BLK_NUM = 17,
	QUERY_ATTR_IDN_RESERVED2 = 18,
	QUERY_ATTR_IDN_RESERVED3 = 19,
	QUERY_ATTR_IDN_FFU_STATUS = 20,
	QUERY_ATTR_IDN_PSA_STATE = 21,
	QUERY_ATTR_IDN_PSA_DATA_SIZE = 22,
	QUERY_ATTR_IDN_REF_CLK_GATING_WAIT_TIME = 23,
	QUERY_ATTR_IDN_CASE_ROUGH_TEMP = 24,
	QUERY_ATTR_IDN_HIGH_TEMP_BOUND = 25,
	QUERY_ATTR_IDN_LOW_TEMP_BOUND = 26,
	QUERY_ATTR_IDN_WB_FLUSH_STATUS = 28,
	QUERY_ATTR_IDN_AVAIL_WB_BUFF_SIZE = 29,
	QUERY_ATTR_IDN_WB_BUFF_LIFE_TIME_EST = 30,
	QUERY_ATTR_IDN_CURR_WB_BUFF_SIZE = 31,
	QUERY_ATTR_IDN_EXT_IID_EN = 42,
	QUERY_ATTR_IDN_TIMESTAMP = 48,
};

enum audit_mode {
	AUDIT_NORMAL = 0,
	AUDIT_QUIET_DENIED = 1,
	AUDIT_QUIET = 2,
	AUDIT_NOQUIET = 3,
	AUDIT_ALL = 4,
};

enum audit_nfcfgop {
	AUDIT_XT_OP_REGISTER = 0,
	AUDIT_XT_OP_REPLACE = 1,
	AUDIT_XT_OP_UNREGISTER = 2,
	AUDIT_NFT_OP_TABLE_REGISTER = 3,
	AUDIT_NFT_OP_TABLE_UNREGISTER = 4,
	AUDIT_NFT_OP_CHAIN_REGISTER = 5,
	AUDIT_NFT_OP_CHAIN_UNREGISTER = 6,
	AUDIT_NFT_OP_RULE_REGISTER = 7,
	AUDIT_NFT_OP_RULE_UNREGISTER = 8,
	AUDIT_NFT_OP_SET_REGISTER = 9,
	AUDIT_NFT_OP_SET_UNREGISTER = 10,
	AUDIT_NFT_OP_SETELEM_REGISTER = 11,
	AUDIT_NFT_OP_SETELEM_UNREGISTER = 12,
	AUDIT_NFT_OP_GEN_REGISTER = 13,
	AUDIT_NFT_OP_OBJ_REGISTER = 14,
	AUDIT_NFT_OP_OBJ_UNREGISTER = 15,
	AUDIT_NFT_OP_OBJ_RESET = 16,
	AUDIT_NFT_OP_FLOWTABLE_REGISTER = 17,
	AUDIT_NFT_OP_FLOWTABLE_UNREGISTER = 18,
	AUDIT_NFT_OP_SETELEM_RESET = 19,
	AUDIT_NFT_OP_RULE_RESET = 20,
	AUDIT_NFT_OP_INVALID = 21,
};

enum audit_nlgrps {
	AUDIT_NLGRP_NONE = 0,
	AUDIT_NLGRP_READLOG = 1,
	__AUDIT_NLGRP_MAX = 2,
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

enum audit_state {
	AUDIT_STATE_DISABLED = 0,
	AUDIT_STATE_BUILD = 1,
	AUDIT_STATE_RECORD = 2,
};

enum audit_type {
	AUDIT_APPARMOR_AUDIT = 0,
	AUDIT_APPARMOR_ALLOWED = 1,
	AUDIT_APPARMOR_DENIED = 2,
	AUDIT_APPARMOR_HINT = 3,
	AUDIT_APPARMOR_STATUS = 4,
	AUDIT_APPARMOR_ERROR = 5,
	AUDIT_APPARMOR_KILL = 6,
	AUDIT_APPARMOR_AUTO = 7,
};

enum auditsc_class_t {
	AUDITSC_NATIVE = 0,
	AUDITSC_COMPAT = 1,
	AUDITSC_OPEN = 2,
	AUDITSC_OPENAT = 3,
	AUDITSC_SOCKETCALL = 4,
	AUDITSC_EXECVE = 5,
	AUDITSC_OPENAT2 = 6,
	AUDITSC_NVALS = 7,
};

enum auth_els_sub_cmd {
	SEND_ELS = 0,
	SEND_ELS_REPLY = 1,
	PULL_ELS = 2,
};

enum batadv_packettype {
	BATADV_IV_OGM = 0,
	BATADV_BCAST = 1,
	BATADV_CODED = 2,
	BATADV_ELP = 3,
	BATADV_OGM2 = 4,
	BATADV_MCAST = 5,
	BATADV_UNICAST = 64,
	BATADV_UNICAST_FRAG = 65,
	BATADV_UNICAST_4ADDR = 66,
	BATADV_ICMP = 67,
	BATADV_UNICAST_TVLV = 68,
};

enum bbr_mode {
	BBR_STARTUP = 0,
	BBR_DRAIN = 1,
	BBR_PROBE_BW = 2,
	BBR_PROBE_RTT = 3,
};

enum be_mem_enum {
	HWI_MEM_ADDN_CONTEXT = 0,
	HWI_MEM_WRB = 1,
	HWI_MEM_WRBH = 2,
	HWI_MEM_SGLH = 3,
	HWI_MEM_SGE = 4,
	HWI_MEM_TEMPLATE_HDR_ULP0 = 5,
	HWI_MEM_ASYNC_HEADER_BUF_ULP0 = 6,
	HWI_MEM_ASYNC_DATA_BUF_ULP0 = 7,
	HWI_MEM_ASYNC_HEADER_RING_ULP0 = 8,
	HWI_MEM_ASYNC_DATA_RING_ULP0 = 9,
	HWI_MEM_ASYNC_HEADER_HANDLE_ULP0 = 10,
	HWI_MEM_ASYNC_DATA_HANDLE_ULP0 = 11,
	HWI_MEM_ASYNC_PDU_CONTEXT_ULP0 = 12,
	HWI_MEM_TEMPLATE_HDR_ULP1 = 13,
	HWI_MEM_ASYNC_HEADER_BUF_ULP1 = 14,
	HWI_MEM_ASYNC_DATA_BUF_ULP1 = 15,
	HWI_MEM_ASYNC_HEADER_RING_ULP1 = 16,
	HWI_MEM_ASYNC_DATA_RING_ULP1 = 17,
	HWI_MEM_ASYNC_HEADER_HANDLE_ULP1 = 18,
	HWI_MEM_ASYNC_DATA_HANDLE_ULP1 = 19,
	HWI_MEM_ASYNC_PDU_CONTEXT_ULP1 = 20,
	ISCSI_MEM_GLOBAL_HEADER = 21,
	SE_MEM_MAX = 22,
};

enum behavior {
	EXCLUSIVE = 0,
	SHARED = 1,
	DROP = 2,
};

enum bfa_aen_category {
	BFA_AEN_CAT_ADAPTER = 1,
	BFA_AEN_CAT_PORT = 2,
	BFA_AEN_CAT_LPORT = 3,
	BFA_AEN_CAT_RPORT = 4,
	BFA_AEN_CAT_ITNIM = 5,
	BFA_AEN_CAT_AUDIT = 8,
	BFA_AEN_CAT_IOC = 9,
};

enum bfa_audit_aen_event {
	BFA_AUDIT_AEN_AUTH_ENABLE = 1,
	BFA_AUDIT_AEN_AUTH_DISABLE = 2,
	BFA_AUDIT_AEN_FLASH_ERASE = 3,
	BFA_AUDIT_AEN_FLASH_UPDATE = 4,
};

enum bfa_bbcr_state {
	BFA_BBCR_DISABLED = 0,
	BFA_BBCR_ONLINE = 1,
	BFA_BBCR_OFFLINE = 2,
};

enum bfa_boolean {
	BFA_FALSE = 0,
	BFA_TRUE = 1,
};

enum bfa_dconf_event {
	BFA_DCONF_SM_INIT = 1,
	BFA_DCONF_SM_FLASH_COMP = 2,
	BFA_DCONF_SM_WR = 3,
	BFA_DCONF_SM_TIMEOUT = 4,
	BFA_DCONF_SM_EXIT = 5,
	BFA_DCONF_SM_IOCDISABLE = 6,
};

enum bfa_defs_sfp_media_e {
	BFA_SFP_MEDIA_UNKNOWN = 0,
	BFA_SFP_MEDIA_CU = 1,
	BFA_SFP_MEDIA_LW = 2,
	BFA_SFP_MEDIA_SW = 3,
	BFA_SFP_MEDIA_EL = 4,
	BFA_SFP_MEDIA_UNSUPPORT = 5,
};

enum bfa_diag_dport_test_opmode {
	BFA_DPORT_OPMODE_AUTO = 0,
	BFA_DPORT_OPMODE_MANU = 1,
};

enum bfa_diag_dport_test_status {
	DPORT_TEST_ST_IDLE = 0,
	DPORT_TEST_ST_FINAL = 1,
	DPORT_TEST_ST_SKIP = 2,
	DPORT_TEST_ST_FAIL = 3,
	DPORT_TEST_ST_INPRG = 4,
	DPORT_TEST_ST_RESPONDER = 5,
	DPORT_TEST_ST_STOPPED = 6,
	DPORT_TEST_ST_MAX = 7,
};

enum bfa_diag_dport_test_type {
	DPORT_TEST_ELOOP = 0,
	DPORT_TEST_OLOOP = 1,
	DPORT_TEST_ROLOOP = 2,
	DPORT_TEST_LINK = 3,
	DPORT_TEST_MAX = 4,
};

enum bfa_dport_sm_event {
	BFA_DPORT_SM_ENABLE = 1,
	BFA_DPORT_SM_DISABLE = 2,
	BFA_DPORT_SM_FWRSP = 3,
	BFA_DPORT_SM_QRESUME = 4,
	BFA_DPORT_SM_HWFAIL = 5,
	BFA_DPORT_SM_START = 6,
	BFA_DPORT_SM_REQFAIL = 7,
	BFA_DPORT_SM_SCN = 8,
};

enum bfa_dport_test_state_e {
	BFA_DPORT_ST_DISABLED = 0,
	BFA_DPORT_ST_INP = 1,
	BFA_DPORT_ST_COMP = 2,
	BFA_DPORT_ST_NO_SFP = 3,
	BFA_DPORT_ST_NOTSTART = 4,
};

enum bfa_eproto_status {
	BFA_EPROTO_BAD_ACCEPT = 0,
	BFA_EPROTO_UNKNOWN_RSP = 1,
};

enum bfa_fcport_ln_sm_event {
	BFA_FCPORT_LN_SM_LINKUP = 1,
	BFA_FCPORT_LN_SM_LINKDOWN = 2,
	BFA_FCPORT_LN_SM_NOTIFICATION = 3,
};

enum bfa_fcport_sm_event {
	BFA_FCPORT_SM_START = 1,
	BFA_FCPORT_SM_STOP = 2,
	BFA_FCPORT_SM_ENABLE = 3,
	BFA_FCPORT_SM_DISABLE = 4,
	BFA_FCPORT_SM_FWRSP = 5,
	BFA_FCPORT_SM_LINKUP = 6,
	BFA_FCPORT_SM_LINKDOWN = 7,
	BFA_FCPORT_SM_QRESUME = 8,
	BFA_FCPORT_SM_HWFAIL = 9,
	BFA_FCPORT_SM_DPORTENABLE = 10,
	BFA_FCPORT_SM_DPORTDISABLE = 11,
	BFA_FCPORT_SM_FAA_MISCONFIG = 12,
	BFA_FCPORT_SM_DDPORTENABLE = 13,
	BFA_FCPORT_SM_DDPORTDISABLE = 14,
};

enum bfa_fcs_fabric_event {
	BFA_FCS_FABRIC_SM_CREATE = 1,
	BFA_FCS_FABRIC_SM_DELETE = 2,
	BFA_FCS_FABRIC_SM_LINK_DOWN = 3,
	BFA_FCS_FABRIC_SM_LINK_UP = 4,
	BFA_FCS_FABRIC_SM_CONT_OP = 5,
	BFA_FCS_FABRIC_SM_RETRY_OP = 6,
	BFA_FCS_FABRIC_SM_NO_FABRIC = 7,
	BFA_FCS_FABRIC_SM_PERF_EVFP = 8,
	BFA_FCS_FABRIC_SM_ISOLATE = 9,
	BFA_FCS_FABRIC_SM_NO_TAGGING = 10,
	BFA_FCS_FABRIC_SM_DELAYED = 11,
	BFA_FCS_FABRIC_SM_AUTH_FAILED = 12,
	BFA_FCS_FABRIC_SM_AUTH_SUCCESS = 13,
	BFA_FCS_FABRIC_SM_DELCOMP = 14,
	BFA_FCS_FABRIC_SM_LOOPBACK = 15,
	BFA_FCS_FABRIC_SM_START = 16,
	BFA_FCS_FABRIC_SM_STOP = 17,
	BFA_FCS_FABRIC_SM_STOPCOMP = 18,
	BFA_FCS_FABRIC_SM_LOGOCOMP = 19,
};

enum bfa_fcs_fabric_type {
	BFA_FCS_FABRIC_UNKNOWN = 0,
	BFA_FCS_FABRIC_SWITCHED = 1,
	BFA_FCS_FABRIC_N2N = 2,
	BFA_FCS_FABRIC_LOOP = 3,
};

enum bfa_fcs_itnim_event {
	BFA_FCS_ITNIM_SM_FCS_ONLINE = 1,
	BFA_FCS_ITNIM_SM_OFFLINE = 2,
	BFA_FCS_ITNIM_SM_FRMSENT = 3,
	BFA_FCS_ITNIM_SM_RSP_OK = 4,
	BFA_FCS_ITNIM_SM_RSP_ERROR = 5,
	BFA_FCS_ITNIM_SM_TIMEOUT = 6,
	BFA_FCS_ITNIM_SM_HCB_OFFLINE = 7,
	BFA_FCS_ITNIM_SM_HCB_ONLINE = 8,
	BFA_FCS_ITNIM_SM_INITIATOR = 9,
	BFA_FCS_ITNIM_SM_DELETE = 10,
	BFA_FCS_ITNIM_SM_PRLO = 11,
	BFA_FCS_ITNIM_SM_RSP_NOT_SUPP = 12,
	BFA_FCS_ITNIM_SM_HAL_ONLINE = 13,
};

enum bfa_fcs_lport_event {
	BFA_FCS_PORT_SM_CREATE = 1,
	BFA_FCS_PORT_SM_ONLINE = 2,
	BFA_FCS_PORT_SM_OFFLINE = 3,
	BFA_FCS_PORT_SM_DELETE = 4,
	BFA_FCS_PORT_SM_DELRPORT = 5,
	BFA_FCS_PORT_SM_STOP = 6,
};

enum bfa_fcs_vport_event {
	BFA_FCS_VPORT_SM_CREATE = 1,
	BFA_FCS_VPORT_SM_DELETE = 2,
	BFA_FCS_VPORT_SM_START = 3,
	BFA_FCS_VPORT_SM_STOP = 4,
	BFA_FCS_VPORT_SM_ONLINE = 5,
	BFA_FCS_VPORT_SM_OFFLINE = 6,
	BFA_FCS_VPORT_SM_FRMSENT = 7,
	BFA_FCS_VPORT_SM_RSP_OK = 8,
	BFA_FCS_VPORT_SM_RSP_ERROR = 9,
	BFA_FCS_VPORT_SM_TIMEOUT = 10,
	BFA_FCS_VPORT_SM_DELCOMP = 11,
	BFA_FCS_VPORT_SM_RSP_DUP_WWN = 12,
	BFA_FCS_VPORT_SM_RSP_FAILED = 13,
	BFA_FCS_VPORT_SM_STOPCOMP = 14,
	BFA_FCS_VPORT_SM_FABRIC_MAX = 15,
};

enum bfa_fec_state_s {
	BFA_FEC_ONLINE = 1,
	BFA_FEC_OFFLINE = 2,
	BFA_FEC_OFFLINE_NOT_16G = 3,
};

enum bfa_flash_cmd {
	BFA_FLASH_FAST_READ = 11,
	BFA_FLASH_READ_STATUS = 5,
};

enum bfa_flash_err {
	BFA_FLASH_NOT_PRESENT = -1,
	BFA_FLASH_UNINIT = -2,
	BFA_FLASH_BAD = -3,
	BFA_FLASH_BUSY = -4,
	BFA_FLASH_ERR_CMD_ACT = -5,
	BFA_FLASH_ERR_FIFO_CNT = -6,
	BFA_FLASH_ERR_WIP = -7,
	BFA_FLASH_ERR_TIMEOUT = -8,
	BFA_FLASH_ERR_LEN = -9,
};

enum bfa_flash_part_type {
	BFA_FLASH_PART_OPTROM = 1,
	BFA_FLASH_PART_FWIMG = 2,
	BFA_FLASH_PART_FWCFG = 3,
	BFA_FLASH_PART_DRV = 4,
	BFA_FLASH_PART_BOOT = 5,
	BFA_FLASH_PART_ASIC = 6,
	BFA_FLASH_PART_MFG = 7,
	BFA_FLASH_PART_OPTROM2 = 8,
	BFA_FLASH_PART_VPD = 9,
	BFA_FLASH_PART_PBC = 10,
	BFA_FLASH_PART_BOOTOVL = 11,
	BFA_FLASH_PART_LOG = 12,
	BFA_FLASH_PART_PXECFG = 13,
	BFA_FLASH_PART_PXEOVL = 14,
	BFA_FLASH_PART_PORTCFG = 15,
	BFA_FLASH_PART_ASICBK = 16,
};

enum bfa_ioc_aen_event {
	BFA_IOC_AEN_HBGOOD = 1,
	BFA_IOC_AEN_HBFAIL = 2,
	BFA_IOC_AEN_ENABLE = 3,
	BFA_IOC_AEN_DISABLE = 4,
	BFA_IOC_AEN_FWMISMATCH = 5,
	BFA_IOC_AEN_FWCFG_ERROR = 6,
	BFA_IOC_AEN_INVALID_VENDOR = 7,
	BFA_IOC_AEN_INVALID_NWWN = 8,
	BFA_IOC_AEN_INVALID_PWWN = 9,
};

enum bfa_ioc_event_e {
	BFA_IOC_E_ENABLED = 1,
	BFA_IOC_E_DISABLED = 2,
	BFA_IOC_E_FAILED = 3,
};

enum bfa_ioc_state {
	BFA_IOC_UNINIT = 1,
	BFA_IOC_RESET = 2,
	BFA_IOC_SEMWAIT = 3,
	BFA_IOC_HWINIT = 4,
	BFA_IOC_GETATTR = 5,
	BFA_IOC_OPERATIONAL = 6,
	BFA_IOC_INITFAIL = 7,
	BFA_IOC_FAIL = 8,
	BFA_IOC_DISABLING = 9,
	BFA_IOC_DISABLED = 10,
	BFA_IOC_FWMISMATCH = 11,
	BFA_IOC_ENABLING = 12,
	BFA_IOC_HWFAIL = 13,
	BFA_IOC_ACQ_ADDR = 14,
};

enum bfa_ioc_type_e {
	BFA_IOC_TYPE_FC = 1,
	BFA_IOC_TYPE_FCoE = 2,
	BFA_IOC_TYPE_LL = 3,
};

enum bfa_iocpf_state {
	BFA_IOCPF_RESET = 1,
	BFA_IOCPF_SEMWAIT = 2,
	BFA_IOCPF_HWINIT = 3,
	BFA_IOCPF_READY = 4,
	BFA_IOCPF_INITFAIL = 5,
	BFA_IOCPF_FAIL = 6,
	BFA_IOCPF_DISABLING = 7,
	BFA_IOCPF_DISABLED = 8,
	BFA_IOCPF_FWMISMATCH = 9,
};

enum bfa_ioim_event {
	BFA_IOIM_SM_START = 1,
	BFA_IOIM_SM_COMP_GOOD = 2,
	BFA_IOIM_SM_COMP = 3,
	BFA_IOIM_SM_COMP_UTAG = 4,
	BFA_IOIM_SM_DONE = 5,
	BFA_IOIM_SM_FREE = 6,
	BFA_IOIM_SM_ABORT = 7,
	BFA_IOIM_SM_ABORT_COMP = 8,
	BFA_IOIM_SM_ABORT_DONE = 9,
	BFA_IOIM_SM_QRESUME = 10,
	BFA_IOIM_SM_SGALLOCED = 11,
	BFA_IOIM_SM_SQRETRY = 12,
	BFA_IOIM_SM_HCB = 13,
	BFA_IOIM_SM_CLEANUP = 14,
	BFA_IOIM_SM_TMSTART = 15,
	BFA_IOIM_SM_TMDONE = 16,
	BFA_IOIM_SM_HWFAIL = 17,
	BFA_IOIM_SM_IOTOV = 18,
};

enum bfa_ioim_lm_ua_status {
	BFA_IOIM_LM_UA_RESET = 0,
	BFA_IOIM_LM_UA_SET = 1,
};

enum bfa_ioim_lun_mask_state_s {
	BFA_IOIM_LUN_MASK_INACTIVE = 0,
	BFA_IOIM_LUN_MASK_ACTIVE = 1,
	BFA_IOIM_LUN_MASK_FETCHED = 2,
};

enum bfa_itnim_aen_event {
	BFA_ITNIM_AEN_ONLINE = 1,
	BFA_ITNIM_AEN_OFFLINE = 2,
	BFA_ITNIM_AEN_DISCONNECT = 3,
};

enum bfa_itnim_event {
	BFA_ITNIM_SM_CREATE = 1,
	BFA_ITNIM_SM_ONLINE = 2,
	BFA_ITNIM_SM_OFFLINE = 3,
	BFA_ITNIM_SM_FWRSP = 4,
	BFA_ITNIM_SM_DELETE = 5,
	BFA_ITNIM_SM_CLEANUP = 6,
	BFA_ITNIM_SM_SLER = 7,
	BFA_ITNIM_SM_HWFAIL = 8,
	BFA_ITNIM_SM_QRESUME = 9,
};

enum bfa_itnim_state {
	BFA_ITNIM_OFFLINE = 0,
	BFA_ITNIM_PRLI_SEND = 1,
	BFA_ITNIM_PRLI_SENT = 2,
	BFA_ITNIM_PRLI_RETRY = 3,
	BFA_ITNIM_HCB_ONLINE = 4,
	BFA_ITNIM_ONLINE = 5,
	BFA_ITNIM_HCB_OFFLINE = 6,
	BFA_ITNIM_INITIATIOR = 7,
};

enum bfa_lport_aen_event {
	BFA_LPORT_AEN_NEW = 1,
	BFA_LPORT_AEN_DELETE = 2,
	BFA_LPORT_AEN_ONLINE = 3,
	BFA_LPORT_AEN_OFFLINE = 4,
	BFA_LPORT_AEN_DISCONNECT = 5,
	BFA_LPORT_AEN_NEW_PROP = 6,
	BFA_LPORT_AEN_DELETE_PROP = 7,
	BFA_LPORT_AEN_NEW_STANDARD = 8,
	BFA_LPORT_AEN_DELETE_STANDARD = 9,
	BFA_LPORT_AEN_NPIV_DUP_WWN = 10,
	BFA_LPORT_AEN_NPIV_FABRIC_MAX = 11,
	BFA_LPORT_AEN_NPIV_UNKNOWN = 12,
};

enum bfa_lport_role {
	BFA_LPORT_ROLE_FCP_IM = 1,
	BFA_LPORT_ROLE_FCP_MAX = 1,
};

enum bfa_lport_state {
	BFA_LPORT_UNINIT = 0,
	BFA_LPORT_FDISC = 1,
	BFA_LPORT_ONLINE = 2,
	BFA_LPORT_OFFLINE = 3,
};

enum bfa_lport_type {
	BFA_LPORT_TYPE_PHYSICAL = 0,
	BFA_LPORT_TYPE_VIRTUAL = 1,
};

enum bfa_lps_event {
	BFA_LPS_SM_LOGIN = 1,
	BFA_LPS_SM_LOGOUT = 2,
	BFA_LPS_SM_FWRSP = 3,
	BFA_LPS_SM_RESUME = 4,
	BFA_LPS_SM_DELETE = 5,
	BFA_LPS_SM_OFFLINE = 6,
	BFA_LPS_SM_RX_CVL = 7,
	BFA_LPS_SM_SET_N2N_PID = 8,
};

enum bfa_lunmask_state_s {
	BFA_LUNMASK_DISABLED = 0,
	BFA_LUNMASK_ENABLED = 1,
	BFA_LUNMASK_MINCFG = 2,
	BFA_LUNMASK_UNINITIALIZED = 255,
};

enum bfa_mode_s {
	BFA_MODE_HBA = 1,
	BFA_MODE_CNA = 2,
	BFA_MODE_NIC = 3,
};

enum bfa_plog_eid {
	BFA_PL_EID_INVALID = 0,
	BFA_PL_EID_IOC_DISABLE = 1,
	BFA_PL_EID_IOC_ENABLE = 2,
	BFA_PL_EID_PORT_DISABLE = 3,
	BFA_PL_EID_PORT_ENABLE = 4,
	BFA_PL_EID_PORT_ST_CHANGE = 5,
	BFA_PL_EID_TX = 6,
	BFA_PL_EID_TX_ACK1 = 7,
	BFA_PL_EID_TX_RJT = 8,
	BFA_PL_EID_TX_BSY = 9,
	BFA_PL_EID_RX = 10,
	BFA_PL_EID_RX_ACK1 = 11,
	BFA_PL_EID_RX_RJT = 12,
	BFA_PL_EID_RX_BSY = 13,
	BFA_PL_EID_CT_IN = 14,
	BFA_PL_EID_CT_OUT = 15,
	BFA_PL_EID_DRIVER_START = 16,
	BFA_PL_EID_RSCN = 17,
	BFA_PL_EID_DEBUG = 18,
	BFA_PL_EID_MISC = 19,
	BFA_PL_EID_FIP_FCF_DISC = 20,
	BFA_PL_EID_FIP_FCF_CVL = 21,
	BFA_PL_EID_LOGIN = 22,
	BFA_PL_EID_LOGO = 23,
	BFA_PL_EID_TRUNK_SCN = 24,
	BFA_PL_EID_MAX = 25,
};

enum bfa_plog_log_type {
	BFA_PL_LOG_TYPE_INVALID = 0,
	BFA_PL_LOG_TYPE_INT = 1,
	BFA_PL_LOG_TYPE_STRING = 2,
};

enum bfa_plog_mid {
	BFA_PL_MID_INVALID = 0,
	BFA_PL_MID_DEBUG = 1,
	BFA_PL_MID_DRVR = 2,
	BFA_PL_MID_HAL = 3,
	BFA_PL_MID_HAL_FCXP = 4,
	BFA_PL_MID_HAL_UF = 5,
	BFA_PL_MID_FCS = 6,
	BFA_PL_MID_LPS = 7,
	BFA_PL_MID_MAX = 8,
};

enum bfa_port_aen_event {
	BFA_PORT_AEN_ONLINE = 1,
	BFA_PORT_AEN_OFFLINE = 2,
	BFA_PORT_AEN_RLIR = 3,
	BFA_PORT_AEN_SFP_INSERT = 4,
	BFA_PORT_AEN_SFP_REMOVE = 5,
	BFA_PORT_AEN_SFP_POM = 6,
	BFA_PORT_AEN_ENABLE = 7,
	BFA_PORT_AEN_DISABLE = 8,
	BFA_PORT_AEN_AUTH_ON = 9,
	BFA_PORT_AEN_AUTH_OFF = 10,
	BFA_PORT_AEN_DISCONNECT = 11,
	BFA_PORT_AEN_QOS_NEG = 12,
	BFA_PORT_AEN_FABRIC_NAME_CHANGE = 13,
	BFA_PORT_AEN_SFP_ACCESS_ERROR = 14,
	BFA_PORT_AEN_SFP_UNSUPPORT = 15,
};

enum bfa_port_linkstate {
	BFA_PORT_LINKUP = 1,
	BFA_PORT_LINKDOWN = 2,
};

enum bfa_port_linkstate_rsn {
	BFA_PORT_LINKSTATE_RSN_NONE = 0,
	BFA_PORT_LINKSTATE_RSN_DISABLED = 1,
	BFA_PORT_LINKSTATE_RSN_RX_NOS = 2,
	BFA_PORT_LINKSTATE_RSN_RX_OLS = 3,
	BFA_PORT_LINKSTATE_RSN_RX_LIP = 4,
	BFA_PORT_LINKSTATE_RSN_RX_LIPF7 = 5,
	BFA_PORT_LINKSTATE_RSN_SFP_REMOVED = 6,
	BFA_PORT_LINKSTATE_RSN_PORT_FAULT = 7,
	BFA_PORT_LINKSTATE_RSN_RX_LOS = 8,
	BFA_PORT_LINKSTATE_RSN_LOCAL_FAULT = 9,
	BFA_PORT_LINKSTATE_RSN_REMOTE_FAULT = 10,
	BFA_PORT_LINKSTATE_RSN_TIMEOUT = 11,
	BFA_PORT_LINKSTATE_RSN_FAA_MISCONFIG = 12,
	CEE_LLDP_INFO_AGED_OUT = 20,
	CEE_LLDP_SHUTDOWN_TLV_RCVD = 21,
	CEE_PEER_NOT_ADVERTISE_DCBX = 22,
	CEE_PEER_NOT_ADVERTISE_PG = 23,
	CEE_PEER_NOT_ADVERTISE_PFC = 24,
	CEE_PEER_NOT_ADVERTISE_FCOE = 25,
	CEE_PG_NOT_COMPATIBLE = 26,
	CEE_PFC_NOT_COMPATIBLE = 27,
	CEE_FCOE_NOT_COMPATIBLE = 28,
	CEE_BAD_PG_RCVD = 29,
	CEE_BAD_BW_RCVD = 30,
	CEE_BAD_PFC_RCVD = 31,
	CEE_BAD_APP_PRI_RCVD = 32,
	CEE_FCOE_PRI_PFC_OFF = 33,
	CEE_DUP_CONTROL_TLV_RCVD = 34,
	CEE_DUP_FEAT_TLV_RCVD = 35,
	CEE_APPLY_NEW_CFG = 36,
	CEE_PROTOCOL_INIT = 37,
	CEE_PHY_LINK_DOWN = 38,
	CEE_LLS_FCOE_ABSENT = 39,
	CEE_LLS_FCOE_DOWN = 40,
	CEE_ISCSI_NOT_COMPATIBLE = 41,
	CEE_ISCSI_PRI_PFC_OFF = 42,
	CEE_ISCSI_PRI_OVERLAP_FCOE_PRI = 43,
};

enum bfa_port_opmode {
	BFA_PORT_OPMODE_NORMAL = 0,
	BFA_PORT_OPMODE_LB_INT = 1,
	BFA_PORT_OPMODE_LB_SLW = 2,
	BFA_PORT_OPMODE_LB_EXT = 4,
	BFA_PORT_OPMODE_LB_CBL = 8,
	BFA_PORT_OPMODE_LB_NLINT = 32,
};

enum bfa_port_speed {
	BFA_PORT_SPEED_UNKNOWN = 0,
	BFA_PORT_SPEED_1GBPS = 1,
	BFA_PORT_SPEED_2GBPS = 2,
	BFA_PORT_SPEED_4GBPS = 4,
	BFA_PORT_SPEED_8GBPS = 8,
	BFA_PORT_SPEED_10GBPS = 10,
	BFA_PORT_SPEED_16GBPS = 16,
	BFA_PORT_SPEED_AUTO = 15,
};

enum bfa_port_states {
	BFA_PORT_ST_UNINIT = 1,
	BFA_PORT_ST_ENABLING_QWAIT = 2,
	BFA_PORT_ST_ENABLING = 3,
	BFA_PORT_ST_LINKDOWN = 4,
	BFA_PORT_ST_LINKUP = 5,
	BFA_PORT_ST_DISABLING_QWAIT = 6,
	BFA_PORT_ST_DISABLING = 7,
	BFA_PORT_ST_DISABLED = 8,
	BFA_PORT_ST_STOPPED = 9,
	BFA_PORT_ST_IOCDOWN = 10,
	BFA_PORT_ST_IOCDIS = 11,
	BFA_PORT_ST_FWMISMATCH = 12,
	BFA_PORT_ST_PREBOOT_DISABLED = 13,
	BFA_PORT_ST_TOGGLING_QWAIT = 14,
	BFA_PORT_ST_FAA_MISCONFIG = 15,
	BFA_PORT_ST_DPORT = 16,
	BFA_PORT_ST_DDPORT = 17,
	BFA_PORT_ST_MAX_STATE = 18,
};

enum bfa_port_topology {
	BFA_PORT_TOPOLOGY_NONE = 0,
	BFA_PORT_TOPOLOGY_P2P_OLD_VER = 1,
	BFA_PORT_TOPOLOGY_LOOP = 2,
	BFA_PORT_TOPOLOGY_AUTO_OLD_VER = 3,
	BFA_PORT_TOPOLOGY_AUTO = 4,
	BFA_PORT_TOPOLOGY_P2P = 5,
};

enum bfa_port_type {
	BFA_PORT_TYPE_UNKNOWN = 1,
	BFA_PORT_TYPE_NPORT = 5,
	BFA_PORT_TYPE_NLPORT = 6,
	BFA_PORT_TYPE_LPORT = 20,
	BFA_PORT_TYPE_P2P = 21,
	BFA_PORT_TYPE_VPORT = 22,
};

enum bfa_qos_bw_alloc {
	BFA_QOS_BW_HIGH = 60,
	BFA_QOS_BW_MED = 30,
	BFA_QOS_BW_LOW = 10,
};

enum bfa_qos_state {
	BFA_QOS_DISABLED = 0,
	BFA_QOS_ONLINE = 1,
	BFA_QOS_OFFLINE = 2,
};

enum bfa_rport_aen_event {
	BFA_RPORT_AEN_ONLINE = 1,
	BFA_RPORT_AEN_OFFLINE = 2,
	BFA_RPORT_AEN_DISCONNECT = 3,
	BFA_RPORT_AEN_QOS_PRIO = 4,
	BFA_RPORT_AEN_QOS_FLOWID = 5,
};

enum bfa_rport_event {
	BFA_RPORT_SM_CREATE = 1,
	BFA_RPORT_SM_DELETE = 2,
	BFA_RPORT_SM_ONLINE = 3,
	BFA_RPORT_SM_OFFLINE = 4,
	BFA_RPORT_SM_FWRSP = 5,
	BFA_RPORT_SM_HWFAIL = 6,
	BFA_RPORT_SM_QOS_SCN = 7,
	BFA_RPORT_SM_SET_SPEED = 8,
	BFA_RPORT_SM_QRESUME = 9,
};

enum bfa_rport_function {
	BFA_RPORT_INITIATOR = 1,
	BFA_RPORT_TARGET = 2,
};

enum bfa_rport_state {
	BFA_RPORT_UNINIT = 0,
	BFA_RPORT_OFFLINE = 1,
	BFA_RPORT_PLOGI = 2,
	BFA_RPORT_ONLINE = 3,
	BFA_RPORT_PLOGI_RETRY = 4,
	BFA_RPORT_NSQUERY = 5,
	BFA_RPORT_ADISC = 6,
	BFA_RPORT_LOGO = 7,
	BFA_RPORT_LOGORCV = 8,
	BFA_RPORT_NSDISC = 9,
};

enum bfa_sfp_stat_e {
	BFA_SFP_STATE_INIT = 0,
	BFA_SFP_STATE_REMOVED = 1,
	BFA_SFP_STATE_INSERTED = 2,
	BFA_SFP_STATE_VALID = 3,
	BFA_SFP_STATE_UNSUPPORT = 4,
	BFA_SFP_STATE_FAILED = 5,
};

enum bfa_status {
	BFA_STATUS_OK = 0,
	BFA_STATUS_FAILED = 1,
	BFA_STATUS_EINVAL = 2,
	BFA_STATUS_ENOMEM = 3,
	BFA_STATUS_ETIMER = 5,
	BFA_STATUS_EPROTOCOL = 6,
	BFA_STATUS_BADFLASH = 9,
	BFA_STATUS_SFP_UNSUPP = 10,
	BFA_STATUS_UNKNOWN_VFID = 11,
	BFA_STATUS_DATACORRUPTED = 12,
	BFA_STATUS_DEVBUSY = 13,
	BFA_STATUS_HDMA_FAILED = 16,
	BFA_STATUS_FLASH_BAD_LEN = 17,
	BFA_STATUS_UNKNOWN_LWWN = 18,
	BFA_STATUS_UNKNOWN_RWWN = 19,
	BFA_STATUS_VPORT_EXISTS = 21,
	BFA_STATUS_VPORT_MAX = 22,
	BFA_STATUS_UNSUPP_SPEED = 23,
	BFA_STATUS_INVLD_DFSZ = 24,
	BFA_STATUS_CMD_NOTSUPP = 26,
	BFA_STATUS_FABRIC_RJT = 29,
	BFA_STATUS_UNKNOWN_VWWN = 30,
	BFA_STATUS_PORT_OFFLINE = 34,
	BFA_STATUS_VPORT_WWN_BP = 46,
	BFA_STATUS_PORT_NOT_DISABLED = 47,
	BFA_STATUS_NO_FCPIM_NEXUS = 52,
	BFA_STATUS_IOC_FAILURE = 56,
	BFA_STATUS_INVALID_WWN = 57,
	BFA_STATUS_ADAPTER_ENABLED = 60,
	BFA_STATUS_IOC_NON_OP = 61,
	BFA_STATUS_VERSION_FAIL = 70,
	BFA_STATUS_DIAG_BUSY = 71,
	BFA_STATUS_BEACON_ON = 72,
	BFA_STATUS_ENOFSAVE = 78,
	BFA_STATUS_IOC_DISABLED = 82,
	BFA_STATUS_ERROR_TRL_ENABLED = 87,
	BFA_STATUS_ERROR_QOS_ENABLED = 88,
	BFA_STATUS_NO_SFP_DEV = 89,
	BFA_STATUS_MEMTEST_FAILED = 90,
	BFA_STATUS_LEDTEST_OP = 109,
	BFA_STATUS_INVALID_MAC = 134,
	BFA_STATUS_CMD_NOTSUPP_CNA = 146,
	BFA_STATUS_PBC = 154,
	BFA_STATUS_BAD_FWCFG = 156,
	BFA_STATUS_INVALID_VENDOR = 158,
	BFA_STATUS_SFP_NOT_READY = 159,
	BFA_STATUS_TRUNK_ENABLED = 164,
	BFA_STATUS_TRUNK_DISABLED = 165,
	BFA_STATUS_IOPROFILE_OFF = 175,
	BFA_STATUS_PHY_NOT_PRESENT = 183,
	BFA_STATUS_FEATURE_NOT_SUPPORTED = 192,
	BFA_STATUS_ENTRY_EXISTS = 193,
	BFA_STATUS_ENTRY_NOT_EXISTS = 194,
	BFA_STATUS_NO_CHANGE = 195,
	BFA_STATUS_FAA_ENABLED = 197,
	BFA_STATUS_FAA_DISABLED = 198,
	BFA_STATUS_FAA_ACQUIRED = 199,
	BFA_STATUS_FAA_ACQ_ADDR = 200,
	BFA_STATUS_BBCR_FC_ONLY = 201,
	BFA_STATUS_ERROR_TRUNK_ENABLED = 203,
	BFA_STATUS_MAX_ENTRY_REACHED = 212,
	BFA_STATUS_TOPOLOGY_LOOP = 230,
	BFA_STATUS_LOOP_UNSUPP_MEZZ = 231,
	BFA_STATUS_INVALID_BW = 233,
	BFA_STATUS_QOS_BW_INVALID = 234,
	BFA_STATUS_DPORT_ENABLED = 235,
	BFA_STATUS_DPORT_DISABLED = 236,
	BFA_STATUS_CMD_NOTSUPP_MEZZ = 239,
	BFA_STATUS_FRU_NOT_PRESENT = 240,
	BFA_STATUS_DPORT_NO_SFP = 243,
	BFA_STATUS_DPORT_ERR = 245,
	BFA_STATUS_DPORT_ENOSYS = 254,
	BFA_STATUS_DPORT_CANT_PERF = 255,
	BFA_STATUS_DPORT_LOGICALERR = 256,
	BFA_STATUS_DPORT_SWBUSY = 257,
	BFA_STATUS_ERR_BBCR_SPEED_UNSUPPORT = 258,
	BFA_STATUS_ERROR_BBCR_ENABLED = 259,
	BFA_STATUS_INVALID_BBSCN = 260,
	BFA_STATUS_DDPORT_ERR = 261,
	BFA_STATUS_DPORT_SFPWRAP_ERR = 262,
	BFA_STATUS_BBCR_CFG_NO_CHANGE = 265,
	BFA_STATUS_DPORT_SW_NOTREADY = 268,
	BFA_STATUS_DPORT_INV_SFP = 271,
	BFA_STATUS_DPORT_CMD_NOTSUPP = 273,
	BFA_STATUS_MAX_VAL = 274,
};

enum bfa_trunk_link_fctl {
	BFA_TRUNK_LINK_FCTL_NORMAL = 0,
	BFA_TRUNK_LINK_FCTL_VC = 1,
	BFA_TRUNK_LINK_FCTL_VC_QOS = 2,
};

enum bfa_trunk_link_state {
	BFA_TRUNK_LINK_STATE_UP = 1,
	BFA_TRUNK_LINK_STATE_DN_LINKDN = 2,
	BFA_TRUNK_LINK_STATE_DN_GRP_MIS = 3,
	BFA_TRUNK_LINK_STATE_DN_SPD_MIS = 4,
	BFA_TRUNK_LINK_STATE_DN_MODE_MIS = 5,
};

enum bfa_trunk_state {
	BFA_TRUNK_DISABLED = 0,
	BFA_TRUNK_ONLINE = 1,
	BFA_TRUNK_OFFLINE = 2,
};

enum bfa_tskim_event {
	BFA_TSKIM_SM_START = 1,
	BFA_TSKIM_SM_DONE = 2,
	BFA_TSKIM_SM_QRESUME = 3,
	BFA_TSKIM_SM_HWFAIL = 5,
	BFA_TSKIM_SM_HCB = 6,
	BFA_TSKIM_SM_IOS_DONE = 7,
	BFA_TSKIM_SM_CLEANUP = 8,
	BFA_TSKIM_SM_CLEANUP_DONE = 9,
	BFA_TSKIM_SM_UTAG = 10,
};

enum bfa_vport_state {
	BFA_FCS_VPORT_UNINIT = 0,
	BFA_FCS_VPORT_CREATED = 1,
	BFA_FCS_VPORT_OFFLINE = 1,
	BFA_FCS_VPORT_FDISC_SEND = 2,
	BFA_FCS_VPORT_FDISC = 3,
	BFA_FCS_VPORT_FDISC_RETRY = 4,
	BFA_FCS_VPORT_FDISC_RSP_WAIT = 5,
	BFA_FCS_VPORT_ONLINE = 6,
	BFA_FCS_VPORT_DELETING = 7,
	BFA_FCS_VPORT_CLEANUP = 8,
	BFA_FCS_VPORT_LOGO_SEND = 9,
	BFA_FCS_VPORT_LOGO = 10,
	BFA_FCS_VPORT_ERROR = 11,
	BFA_FCS_VPORT_MAX_STATE = 12,
};

enum bfad_binding_type {
	FCP_PWWN_BINDING = 1,
	FCP_NWWN_BINDING = 2,
	FCP_FCID_BINDING = 3,
};

enum bfad_itnim_state {
	ITNIM_STATE_NONE = 0,
	ITNIM_STATE_ONLINE = 1,
	ITNIM_STATE_OFFLINE_PENDING = 2,
	ITNIM_STATE_OFFLINE = 3,
	ITNIM_STATE_TIMEOUT = 4,
	ITNIM_STATE_FREE = 5,
};

enum bfad_port_pvb_type {
	BFAD_PORT_PHYS_BASE = 0,
	BFAD_PORT_PHYS_VPORT = 1,
	BFAD_PORT_VF_BASE = 2,
	BFAD_PORT_VF_VPORT = 3,
};

enum bfad_sm_event {
	BFAD_E_CREATE = 1,
	BFAD_E_KTHREAD_CREATE_FAILED = 2,
	BFAD_E_INIT = 3,
	BFAD_E_INIT_SUCCESS = 4,
	BFAD_E_HAL_INIT_FAILED = 5,
	BFAD_E_INIT_FAILED = 6,
	BFAD_E_FCS_EXIT_COMP = 7,
	BFAD_E_EXIT_COMP = 8,
	BFAD_E_STOP = 9,
};

enum bfi_ablk_h2i_msgs_e {
	BFI_ABLK_H2I_QUERY = 1,
	BFI_ABLK_H2I_ADPT_CONFIG = 2,
	BFI_ABLK_H2I_PORT_CONFIG = 3,
	BFI_ABLK_H2I_PF_CREATE = 4,
	BFI_ABLK_H2I_PF_DELETE = 5,
	BFI_ABLK_H2I_PF_UPDATE = 6,
	BFI_ABLK_H2I_OPTROM_ENABLE = 7,
	BFI_ABLK_H2I_OPTROM_DISABLE = 8,
};

enum bfi_ablk_i2h_msgs_e {
	BFI_ABLK_I2H_QUERY = 129,
	BFI_ABLK_I2H_ADPT_CONFIG = 130,
	BFI_ABLK_I2H_PORT_CONFIG = 131,
	BFI_ABLK_I2H_PF_CREATE = 132,
	BFI_ABLK_I2H_PF_DELETE = 133,
	BFI_ABLK_I2H_PF_UPDATE = 134,
	BFI_ABLK_I2H_OPTROM_ENABLE = 135,
	BFI_ABLK_I2H_OPTROM_DISABLE = 136,
};

enum bfi_asic_gen {
	BFI_ASIC_GEN_CB = 1,
	BFI_ASIC_GEN_CT = 2,
	BFI_ASIC_GEN_CT2 = 3,
};

enum bfi_asic_mode {
	BFI_ASIC_MODE_FC = 1,
	BFI_ASIC_MODE_FC16 = 2,
	BFI_ASIC_MODE_ETH = 3,
	BFI_ASIC_MODE_COMBO = 4,
};

enum bfi_cee_h2i_msgs_e {
	BFI_CEE_H2I_GET_CFG_REQ = 1,
	BFI_CEE_H2I_RESET_STATS = 2,
	BFI_CEE_H2I_GET_STATS_REQ = 3,
};

enum bfi_cee_i2h_msgs_e {
	BFI_CEE_I2H_GET_CFG_RSP = 129,
	BFI_CEE_I2H_RESET_STATS_RSP = 130,
	BFI_CEE_I2H_GET_STATS_RSP = 131,
};

enum bfi_diag_h2i {
	BFI_DIAG_H2I_PORTBEACON = 1,
	BFI_DIAG_H2I_LOOPBACK = 2,
	BFI_DIAG_H2I_FWPING = 3,
	BFI_DIAG_H2I_TEMPSENSOR = 4,
	BFI_DIAG_H2I_LEDTEST = 5,
	BFI_DIAG_H2I_QTEST = 6,
	BFI_DIAG_H2I_DPORT = 7,
};

enum bfi_diag_i2h {
	BFI_DIAG_I2H_PORTBEACON = 129,
	BFI_DIAG_I2H_LOOPBACK = 130,
	BFI_DIAG_I2H_FWPING = 131,
	BFI_DIAG_I2H_TEMPSENSOR = 132,
	BFI_DIAG_I2H_LEDTEST = 133,
	BFI_DIAG_I2H_QTEST = 134,
	BFI_DIAG_I2H_DPORT = 135,
	BFI_DIAG_I2H_DPORT_SCN = 136,
};

enum bfi_dport_req {
	BFI_DPORT_DISABLE = 0,
	BFI_DPORT_ENABLE = 1,
	BFI_DPORT_START = 2,
	BFI_DPORT_SHOW = 3,
	BFI_DPORT_DYN_DISABLE = 4,
};

enum bfi_dport_scn {
	BFI_DPORT_SCN_TESTSTART = 1,
	BFI_DPORT_SCN_TESTCOMP = 2,
	BFI_DPORT_SCN_SFP_REMOVED = 3,
	BFI_DPORT_SCN_DDPORT_ENABLE = 4,
	BFI_DPORT_SCN_DDPORT_DISABLE = 5,
	BFI_DPORT_SCN_FCPORT_DISABLE = 6,
	BFI_DPORT_SCN_SUBTESTSTART = 7,
	BFI_DPORT_SCN_TESTSKIP = 8,
	BFI_DPORT_SCN_DDPORT_DISABLED = 9,
};

enum bfi_fcport_h2i {
	BFI_FCPORT_H2I_ENABLE_REQ = 1,
	BFI_FCPORT_H2I_DISABLE_REQ = 2,
	BFI_FCPORT_H2I_SET_SVC_PARAMS_REQ = 3,
	BFI_FCPORT_H2I_STATS_GET_REQ = 4,
	BFI_FCPORT_H2I_STATS_CLEAR_REQ = 5,
};

enum bfi_fcport_i2h {
	BFI_FCPORT_I2H_ENABLE_RSP = 129,
	BFI_FCPORT_I2H_DISABLE_RSP = 130,
	BFI_FCPORT_I2H_SET_SVC_PARAMS_RSP = 131,
	BFI_FCPORT_I2H_STATS_GET_RSP = 132,
	BFI_FCPORT_I2H_STATS_CLEAR_RSP = 133,
	BFI_FCPORT_I2H_EVENT = 134,
	BFI_FCPORT_I2H_TRUNK_SCN = 135,
	BFI_FCPORT_I2H_ENABLE_AEN = 136,
	BFI_FCPORT_I2H_DISABLE_AEN = 137,
};

enum bfi_fcxp_h2i {
	BFI_FCXP_H2I_SEND_REQ = 1,
};

enum bfi_fcxp_i2h {
	BFI_FCXP_I2H_SEND_RSP = 129,
};

enum bfi_flash_h2i_msgs {
	BFI_FLASH_H2I_QUERY_REQ = 1,
	BFI_FLASH_H2I_ERASE_REQ = 2,
	BFI_FLASH_H2I_WRITE_REQ = 3,
	BFI_FLASH_H2I_READ_REQ = 4,
	BFI_FLASH_H2I_BOOT_VER_REQ = 5,
};

enum bfi_flash_i2h_msgs {
	BFI_FLASH_I2H_QUERY_RSP = 129,
	BFI_FLASH_I2H_ERASE_RSP = 130,
	BFI_FLASH_I2H_WRITE_RSP = 131,
	BFI_FLASH_I2H_READ_RSP = 132,
	BFI_FLASH_I2H_BOOT_VER_RSP = 133,
	BFI_FLASH_I2H_EVENT = 255,
};

enum bfi_fru_h2i_msgs {
	BFI_FRUVPD_H2I_WRITE_REQ = 1,
	BFI_FRUVPD_H2I_READ_REQ = 2,
	BFI_TFRU_H2I_WRITE_REQ = 3,
	BFI_TFRU_H2I_READ_REQ = 4,
};

enum bfi_fru_i2h_msgs {
	BFI_FRUVPD_I2H_WRITE_RSP = 129,
	BFI_FRUVPD_I2H_READ_RSP = 130,
	BFI_TFRU_I2H_WRITE_RSP = 131,
	BFI_TFRU_I2H_READ_RSP = 132,
};

enum bfi_fwboot_type {
	BFI_FWBOOT_TYPE_NORMAL = 0,
	BFI_FWBOOT_TYPE_FLASH = 1,
	BFI_FWBOOT_TYPE_MEMTEST = 2,
};

enum bfi_ioc_h2i_msgs {
	BFI_IOC_H2I_ENABLE_REQ = 1,
	BFI_IOC_H2I_DISABLE_REQ = 2,
	BFI_IOC_H2I_GETATTR_REQ = 3,
	BFI_IOC_H2I_DBG_SYNC = 4,
	BFI_IOC_H2I_DBG_DUMP = 5,
};

enum bfi_ioc_i2h_msgs {
	BFI_IOC_I2H_ENABLE_REPLY = 129,
	BFI_IOC_I2H_DISABLE_REPLY = 130,
	BFI_IOC_I2H_GETATTR_REPLY = 131,
	BFI_IOC_I2H_HBEAT = 132,
	BFI_IOC_I2H_ACQ_ADDR_REPLY = 133,
};

enum bfi_ioc_img_ver_cmp_e {
	BFI_IOC_IMG_VER_INCOMP = 0,
	BFI_IOC_IMG_VER_OLD = 1,
	BFI_IOC_IMG_VER_SAME = 2,
	BFI_IOC_IMG_VER_BETTER = 3,
};

enum bfi_ioc_state {
	BFI_IOC_UNINIT = 0,
	BFI_IOC_INITING = 1,
	BFI_IOC_HWINIT = 2,
	BFI_IOC_CFG = 3,
	BFI_IOC_OP = 4,
	BFI_IOC_DISABLING = 5,
	BFI_IOC_DISABLED = 6,
	BFI_IOC_CFG_DISABLED = 7,
	BFI_IOC_FAIL = 8,
	BFI_IOC_MEMTEST = 9,
};

enum bfi_iocfc_h2i_msgs {
	BFI_IOCFC_H2I_CFG_REQ = 1,
	BFI_IOCFC_H2I_SET_INTR_REQ = 2,
	BFI_IOCFC_H2I_UPDATEQ_REQ = 3,
	BFI_IOCFC_H2I_FAA_QUERY_REQ = 4,
	BFI_IOCFC_H2I_ADDR_REQ = 5,
};

enum bfi_iocfc_i2h_msgs {
	BFI_IOCFC_I2H_CFG_REPLY = 129,
	BFI_IOCFC_I2H_UPDATEQ_RSP = 131,
	BFI_IOCFC_I2H_FAA_QUERY_RSP = 132,
	BFI_IOCFC_I2H_ADDR_MSG = 133,
};

enum bfi_ioim_h2i {
	BFI_IOIM_H2I_IOABORT_REQ = 1,
	BFI_IOIM_H2I_IOCLEANUP_REQ = 2,
};

enum bfi_ioim_status {
	BFI_IOIM_STS_OK = 0,
	BFI_IOIM_STS_HOST_ABORTED = 1,
	BFI_IOIM_STS_ABORTED = 2,
	BFI_IOIM_STS_TIMEDOUT = 3,
	BFI_IOIM_STS_RES_FREE = 4,
	BFI_IOIM_STS_SQER_NEEDED = 5,
	BFI_IOIM_STS_PROTO_ERR = 6,
	BFI_IOIM_STS_UTAG = 7,
	BFI_IOIM_STS_PATHTOV = 8,
};

enum bfi_itn_h2i {
	BFI_ITN_H2I_CREATE_REQ = 1,
	BFI_ITN_H2I_DELETE_REQ = 2,
};

enum bfi_itn_i2h {
	BFI_ITN_I2H_CREATE_RSP = 129,
	BFI_ITN_I2H_DELETE_RSP = 130,
	BFI_ITN_I2H_SLER_EVENT = 131,
};

enum bfi_lps_h2i_msgs {
	BFI_LPS_H2I_LOGIN_REQ = 1,
	BFI_LPS_H2I_LOGOUT_REQ = 2,
	BFI_LPS_H2I_N2N_PID_REQ = 3,
};

enum bfi_lps_i2h_msgs {
	BFI_LPS_I2H_LOGIN_RSP = 129,
	BFI_LPS_I2H_LOGOUT_RSP = 130,
	BFI_LPS_I2H_CVL_EVENT = 131,
};

enum bfi_mclass {
	BFI_MC_IOC = 1,
	BFI_MC_DIAG = 2,
	BFI_MC_FLASH = 3,
	BFI_MC_CEE = 4,
	BFI_MC_FCPORT = 5,
	BFI_MC_IOCFC = 6,
	BFI_MC_ABLK = 7,
	BFI_MC_UF = 8,
	BFI_MC_FCXP = 9,
	BFI_MC_LPS = 10,
	BFI_MC_RPORT = 11,
	BFI_MC_ITN = 12,
	BFI_MC_IOIM_READ = 13,
	BFI_MC_IOIM_WRITE = 14,
	BFI_MC_IOIM_IO = 15,
	BFI_MC_IOIM = 16,
	BFI_MC_IOIM_IOCOM = 17,
	BFI_MC_TSKIM = 18,
	BFI_MC_PORT = 21,
	BFI_MC_SFP = 22,
	BFI_MC_PHY = 25,
	BFI_MC_FRU = 34,
	BFI_MC_MAX = 35,
};

enum bfi_pcifn_class {
	BFI_PCIFN_CLASS_FC = 3076,
	BFI_PCIFN_CLASS_ETH = 512,
};

enum bfi_phy_h2i_msgs_e {
	BFI_PHY_H2I_QUERY_REQ = 1,
	BFI_PHY_H2I_STATS_REQ = 2,
	BFI_PHY_H2I_WRITE_REQ = 3,
	BFI_PHY_H2I_READ_REQ = 4,
};

enum bfi_phy_i2h_msgs_e {
	BFI_PHY_I2H_QUERY_RSP = 129,
	BFI_PHY_I2H_STATS_RSP = 130,
	BFI_PHY_I2H_WRITE_RSP = 131,
	BFI_PHY_I2H_READ_RSP = 132,
};

enum bfi_port_h2i {
	BFI_PORT_H2I_ENABLE_REQ = 1,
	BFI_PORT_H2I_DISABLE_REQ = 2,
	BFI_PORT_H2I_GET_STATS_REQ = 3,
	BFI_PORT_H2I_CLEAR_STATS_REQ = 4,
};

enum bfi_port_i2h {
	BFI_PORT_I2H_ENABLE_RSP = 129,
	BFI_PORT_I2H_DISABLE_RSP = 130,
	BFI_PORT_I2H_GET_STATS_RSP = 131,
	BFI_PORT_I2H_CLEAR_STATS_RSP = 132,
};

enum bfi_port_mode {
	BFI_PORT_MODE_FC = 1,
	BFI_PORT_MODE_ETH = 2,
};

enum bfi_rport_h2i_msgs {
	BFI_RPORT_H2I_CREATE_REQ = 1,
	BFI_RPORT_H2I_DELETE_REQ = 2,
	BFI_RPORT_H2I_SET_SPEED_REQ = 3,
};

enum bfi_rport_i2h_msgs {
	BFI_RPORT_I2H_CREATE_RSP = 129,
	BFI_RPORT_I2H_DELETE_RSP = 130,
	BFI_RPORT_I2H_QOS_SCN = 131,
	BFI_RPORT_I2H_LIP_SCN_ONLINE = 132,
	BFI_RPORT_I2H_LIP_SCN_OFFLINE = 133,
	BFI_RPORT_I2H_NO_DEV = 134,
};

enum bfi_sfp_h2i_e {
	BFI_SFP_H2I_SHOW = 1,
	BFI_SFP_H2I_SCN = 2,
};

enum bfi_sfp_i2h_e {
	BFI_SFP_I2H_SHOW = 129,
	BFI_SFP_I2H_SCN = 130,
};

enum bfi_sfp_mem_e {
	BFI_SFP_MEM_ALL = 1,
	BFI_SFP_MEM_DIAGEXT = 2,
};

enum bfi_tskim_h2i {
	BFI_TSKIM_H2I_TM_REQ = 1,
	BFI_TSKIM_H2I_ABORT_REQ = 2,
};

enum bfi_tskim_status {
	BFI_TSKIM_STS_OK = 0,
	BFI_TSKIM_STS_NOT_SUPP = 4,
	BFI_TSKIM_STS_FAILED = 5,
	BFI_TSKIM_STS_TIMEOUT = 10,
	BFI_TSKIM_STS_ABORTED = 11,
	BFI_TSKIM_STS_UTAG = 12,
};

enum bfi_uf_h2i {
	BFI_UF_H2I_BUF_POST = 1,
};

enum bfi_uf_i2h {
	BFI_UF_I2H_FRM_RCVD = 129,
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_PrivateStart = 16,
};

enum binder_deferred_state {
	BINDER_DEFERRED_FLUSH = 1,
	BINDER_DEFERRED_RELEASE = 2,
};

enum binder_driver_command_protocol {
	BC_TRANSACTION = 2151703296,
	BC_REPLY = 2151703297,
	BC_ACQUIRE_RESULT = 2147771138,
	BC_FREE_BUFFER = 2148033283,
	BC_INCREFS = 2147771140,
	BC_ACQUIRE = 2147771141,
	BC_RELEASE = 2147771142,
	BC_DECREFS = 2147771143,
	BC_INCREFS_DONE = 2148557576,
	BC_ACQUIRE_DONE = 2148557577,
	BC_ATTEMPT_ACQUIRE = 2148033290,
	BC_REGISTER_LOOPER = 536896267,
	BC_ENTER_LOOPER = 536896268,
	BC_EXIT_LOOPER = 536896269,
	BC_REQUEST_DEATH_NOTIFICATION = 2148295438,
	BC_CLEAR_DEATH_NOTIFICATION = 2148295439,
	BC_DEAD_BINDER_DONE = 2148033296,
	BC_TRANSACTION_SG = 2152227601,
	BC_REPLY_SG = 2152227602,
};

enum binder_driver_return_protocol {
	BR_ERROR = 1074033152,
	BR_OK = 536900097,
	BR_TRANSACTION_SEC_CTX = 1078489602,
	BR_TRANSACTION = 1077965314,
	BR_REPLY = 1077965315,
	BR_ACQUIRE_RESULT = 1074033156,
	BR_DEAD_REPLY = 536900101,
	BR_TRANSACTION_COMPLETE = 536900102,
	BR_INCREFS = 1074819591,
	BR_ACQUIRE = 1074819592,
	BR_RELEASE = 1074819593,
	BR_DECREFS = 1074819594,
	BR_ATTEMPT_ACQUIRE = 1075343883,
	BR_NOOP = 536900108,
	BR_SPAWN_LOOPER = 536900109,
	BR_FINISHED = 536900110,
	BR_DEAD_BINDER = 1074295311,
	BR_CLEAR_DEATH_NOTIFICATION_DONE = 1074295312,
	BR_FAILED_REPLY = 536900113,
	BR_FROZEN_REPLY = 536900114,
	BR_ONEWAY_SPAM_SUSPECT = 536900115,
	BR_TRANSACTION_PENDING_FROZEN = 536900116,
};

enum binder_stat_types {
	BINDER_STAT_PROC = 0,
	BINDER_STAT_THREAD = 1,
	BINDER_STAT_NODE = 2,
	BINDER_STAT_REF = 3,
	BINDER_STAT_DEATH = 4,
	BINDER_STAT_TRANSACTION = 5,
	BINDER_STAT_TRANSACTION_COMPLETE = 6,
	BINDER_STAT_COUNT = 7,
};

enum binder_work_type {
	BINDER_WORK_TRANSACTION = 1,
	BINDER_WORK_TRANSACTION_COMPLETE = 2,
	BINDER_WORK_TRANSACTION_PENDING = 3,
	BINDER_WORK_TRANSACTION_ONEWAY_SPAM_SUSPECT = 4,
	BINDER_WORK_RETURN_ERROR = 5,
	BINDER_WORK_NODE = 6,
	BINDER_WORK_DEAD_BINDER = 7,
	BINDER_WORK_DEAD_BINDER_AND_CLEAR = 8,
	BINDER_WORK_CLEAR_DEATH_NOTIFICATION = 9,
};

enum binderfs_param {
	Opt_max___2 = 0,
	Opt_stats_mode = 1,
};

enum binderfs_stats_mode {
	binderfs_stats_mode_unset = 0,
	binderfs_stats_mode_global = 1,
};

enum bio_merge_status {
	BIO_MERGE_OK = 0,
	BIO_MERGE_NONE = 1,
	BIO_MERGE_FAILED = 2,
};

enum bio_post_read_step {
	STEP_INITIAL = 0,
	STEP_DECRYPT = 1,
	STEP_VERITY = 2,
	STEP_MAX = 3,
};

enum bip_flags {
	BIP_BLOCK_INTEGRITY = 1,
	BIP_MAPPED_INTEGRITY = 2,
	BIP_CTRL_NOCHECK = 4,
	BIP_DISK_NOCHECK = 8,
	BIP_IP_CHECKSUM = 16,
	BIP_INTEGRITY_USER = 32,
	BIP_COPY_USER = 64,
};

enum bkops_status {
	BKOPS_STATUS_NO_OP = 0,
	BKOPS_STATUS_NON_CRITICAL = 1,
	BKOPS_STATUS_PERF_IMPACT = 2,
	BKOPS_STATUS_CRITICAL = 3,
	BKOPS_STATUS_MAX = 3,
};

enum blacklist_hash_type {
	BLACKLIST_HASH_X509_TBS = 1,
	BLACKLIST_HASH_BINARY = 2,
};

enum blake2s_iv {
	BLAKE2S_IV0 = 1779033703,
	BLAKE2S_IV1 = 3144134277,
	BLAKE2S_IV2 = 1013904242,
	BLAKE2S_IV3 = 2773480762,
	BLAKE2S_IV4 = 1359893119,
	BLAKE2S_IV5 = 2600822924,
	BLAKE2S_IV6 = 528734635,
	BLAKE2S_IV7 = 1541459225,
};

enum blake2s_lengths {
	BLAKE2S_BLOCK_SIZE = 64,
	BLAKE2S_HASH_SIZE = 32,
	BLAKE2S_KEY_SIZE = 32,
	BLAKE2S_128_HASH_SIZE = 16,
	BLAKE2S_160_HASH_SIZE = 20,
	BLAKE2S_224_HASH_SIZE = 28,
	BLAKE2S_256_HASH_SIZE = 32,
};

enum blk_bounce {
	BLK_BOUNCE_NONE = 0,
	BLK_BOUNCE_HIGH = 1,
};

enum blk_crypto_mode_num {
	BLK_ENCRYPTION_MODE_INVALID = 0,
	BLK_ENCRYPTION_MODE_AES_256_XTS = 1,
	BLK_ENCRYPTION_MODE_AES_128_CBC_ESSIV = 2,
	BLK_ENCRYPTION_MODE_ADIANTUM = 3,
	BLK_ENCRYPTION_MODE_SM4_XTS = 4,
	BLK_ENCRYPTION_MODE_MAX = 5,
};

enum blk_default_limits {
	BLK_MAX_SEGMENTS = 128,
	BLK_SAFE_MAX_SECTORS = 255,
	BLK_MAX_SEGMENT_SIZE = 65536,
	BLK_SEG_BOUNDARY_MASK = 4294967295,
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

enum blk_integrity_flags {
	BLK_INTEGRITY_VERIFY = 1,
	BLK_INTEGRITY_GENERATE = 2,
	BLK_INTEGRITY_DEVICE_CAPABLE = 4,
	BLK_INTEGRITY_IP_CHECKSUM = 8,
};

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

enum blk_zone_cond {
	BLK_ZONE_COND_NOT_WP = 0,
	BLK_ZONE_COND_EMPTY = 1,
	BLK_ZONE_COND_IMP_OPEN = 2,
	BLK_ZONE_COND_EXP_OPEN = 3,
	BLK_ZONE_COND_CLOSED = 4,
	BLK_ZONE_COND_READONLY = 13,
	BLK_ZONE_COND_FULL = 14,
	BLK_ZONE_COND_OFFLINE = 15,
};

enum blk_zone_report_flags {
	BLK_ZONE_REP_CAPACITY = 1,
};

enum blk_zone_type {
	BLK_ZONE_TYPE_CONVENTIONAL = 1,
	BLK_ZONE_TYPE_SEQWRITE_REQ = 2,
	BLK_ZONE_TYPE_SEQWRITE_PREF = 3,
};

enum blkg_iostat_type {
	BLKG_IOSTAT_READ = 0,
	BLKG_IOSTAT_WRITE = 1,
	BLKG_IOSTAT_DISCARD = 2,
	BLKG_IOSTAT_NR = 3,
};

enum blkg_rwstat_type {
	BLKG_RWSTAT_READ = 0,
	BLKG_RWSTAT_WRITE = 1,
	BLKG_RWSTAT_SYNC = 2,
	BLKG_RWSTAT_ASYNC = 3,
	BLKG_RWSTAT_DISCARD = 4,
	BLKG_RWSTAT_NR = 5,
	BLKG_RWSTAT_TOTAL = 5,
};

enum blktrace_act {
	__BLK_TA_QUEUE = 1,
	__BLK_TA_BACKMERGE = 2,
	__BLK_TA_FRONTMERGE = 3,
	__BLK_TA_GETRQ = 4,
	__BLK_TA_SLEEPRQ = 5,
	__BLK_TA_REQUEUE = 6,
	__BLK_TA_ISSUE = 7,
	__BLK_TA_COMPLETE = 8,
	__BLK_TA_PLUG = 9,
	__BLK_TA_UNPLUG_IO = 10,
	__BLK_TA_UNPLUG_TIMER = 11,
	__BLK_TA_INSERT = 12,
	__BLK_TA_SPLIT = 13,
	__BLK_TA_BOUNCE = 14,
	__BLK_TA_REMAP = 15,
	__BLK_TA_ABORT = 16,
	__BLK_TA_DRV_DATA = 17,
	__BLK_TA_CGROUP = 256,
};

enum block_state {
	NON_BLOCKING = 0,
	BLOCKING = 1,
};

enum bmic_flush_cache_shutdown_event {
	NONE_CACHE_FLUSH_ONLY = 0,
	SHUTDOWN = 1,
	HIBERNATE = 2,
	SUSPEND = 3,
	RESTART = 4,
};

enum bnx2x_func_cmd {
	BNX2X_F_CMD_HW_INIT = 0,
	BNX2X_F_CMD_START = 1,
	BNX2X_F_CMD_STOP = 2,
	BNX2X_F_CMD_HW_RESET = 3,
	BNX2X_F_CMD_AFEX_UPDATE = 4,
	BNX2X_F_CMD_AFEX_VIFLISTS = 5,
	BNX2X_F_CMD_TX_STOP = 6,
	BNX2X_F_CMD_TX_START = 7,
	BNX2X_F_CMD_SWITCH_UPDATE = 8,
	BNX2X_F_CMD_SET_TIMESYNC = 9,
	BNX2X_F_CMD_MAX = 10,
};

enum bnx2x_func_state {
	BNX2X_F_STATE_RESET = 0,
	BNX2X_F_STATE_INITIALIZED = 1,
	BNX2X_F_STATE_STARTED = 2,
	BNX2X_F_STATE_TX_STOPPED = 3,
	BNX2X_F_STATE_MAX = 4,
};

enum bnx2x_mcast_cmd {
	BNX2X_MCAST_CMD_ADD = 0,
	BNX2X_MCAST_CMD_CONT = 1,
	BNX2X_MCAST_CMD_DEL = 2,
	BNX2X_MCAST_CMD_RESTORE = 3,
	BNX2X_MCAST_CMD_SET = 4,
	BNX2X_MCAST_CMD_SET_ADD = 5,
	BNX2X_MCAST_CMD_SET_DEL = 6,
};

enum bnx2x_q_state {
	BNX2X_Q_STATE_RESET = 0,
	BNX2X_Q_STATE_INITIALIZED = 1,
	BNX2X_Q_STATE_ACTIVE = 2,
	BNX2X_Q_STATE_MULTI_COS = 3,
	BNX2X_Q_STATE_MCOS_TERMINATED = 4,
	BNX2X_Q_STATE_INACTIVE = 5,
	BNX2X_Q_STATE_STOPPED = 6,
	BNX2X_Q_STATE_TERMINATED = 7,
	BNX2X_Q_STATE_FLRED = 8,
	BNX2X_Q_STATE_MAX = 9,
};

enum bnx2x_queue_cmd {
	BNX2X_Q_CMD_INIT = 0,
	BNX2X_Q_CMD_SETUP = 1,
	BNX2X_Q_CMD_SETUP_TX_ONLY = 2,
	BNX2X_Q_CMD_DEACTIVATE = 3,
	BNX2X_Q_CMD_ACTIVATE = 4,
	BNX2X_Q_CMD_UPDATE = 5,
	BNX2X_Q_CMD_UPDATE_TPA = 6,
	BNX2X_Q_CMD_HALT = 7,
	BNX2X_Q_CMD_CFC_DEL = 8,
	BNX2X_Q_CMD_TERMINATE = 9,
	BNX2X_Q_CMD_EMPTY = 10,
	BNX2X_Q_CMD_MAX = 11,
};

enum bnx2x_recovery_state {
	BNX2X_RECOVERY_DONE = 0,
	BNX2X_RECOVERY_INIT = 1,
	BNX2X_RECOVERY_WAIT = 2,
	BNX2X_RECOVERY_FAILED = 3,
	BNX2X_RECOVERY_NIC_LOADING = 4,
};

enum bnx2x_tpa_mode_t {
	TPA_MODE_DISABLED = 0,
	TPA_MODE_LRO = 1,
	TPA_MODE_GRO = 2,
};

enum bnx2x_udp_port_type {
	BNX2X_UDP_PORT_VXLAN = 0,
	BNX2X_UDP_PORT_GENEVE = 1,
	BNX2X_UDP_PORT_MAX = 2,
};

enum bnx2x_vlan_mac_cmd {
	BNX2X_VLAN_MAC_ADD = 0,
	BNX2X_VLAN_MAC_DEL = 1,
	BNX2X_VLAN_MAC_MOVE = 2,
};

enum board_ids {
	board_ahci = 0,
	board_ahci_43bit_dma = 1,
	board_ahci_ign_iferr = 2,
	board_ahci_no_debounce_delay = 3,
	board_ahci_no_msi = 4,
	board_ahci_pcs_quirk = 5,
	board_ahci_pcs_quirk_no_devslp = 6,
	board_ahci_pcs_quirk_no_sntf = 7,
	board_ahci_yes_fbs = 8,
	board_ahci_al = 9,
	board_ahci_avn = 10,
	board_ahci_mcp65 = 11,
	board_ahci_mcp77 = 12,
	board_ahci_mcp89 = 13,
	board_ahci_mv = 14,
	board_ahci_sb600 = 15,
	board_ahci_sb700 = 16,
	board_ahci_vt8251 = 17,
	board_ahci_mcp_linux = 11,
	board_ahci_mcp67 = 11,
	board_ahci_mcp73 = 11,
	board_ahci_mcp79 = 12,
};

enum board_ids___2 {
	board_acard_ahci = 0,
};

enum board_ids_enum {
	vt6420 = 0,
	vt6421 = 1,
	vt8251 = 2,
};

enum bp_type_idx {
	TYPE_INST = 0,
	TYPE_DATA = 1,
	TYPE_MAX = 2,
};

enum bpf_access_src {
	ACCESS_DIRECT = 1,
	ACCESS_HELPER = 2,
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

enum bpf_addr_space_cast {
	BPF_ADDR_SPACE_CAST = 1,
};

enum bpf_adj_room_mode {
	BPF_ADJ_ROOM_NET = 0,
	BPF_ADJ_ROOM_MAC = 1,
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_PTR_TO_ARENA = 5,
	ARG_CONST_SIZE = 6,
	ARG_CONST_SIZE_OR_ZERO = 7,
	ARG_PTR_TO_CTX = 8,
	ARG_ANYTHING = 9,
	ARG_PTR_TO_SPIN_LOCK = 10,
	ARG_PTR_TO_SOCK_COMMON = 11,
	ARG_PTR_TO_INT = 12,
	ARG_PTR_TO_LONG = 13,
	ARG_PTR_TO_SOCKET = 14,
	ARG_PTR_TO_BTF_ID = 15,
	ARG_PTR_TO_RINGBUF_MEM = 16,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 17,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 18,
	ARG_PTR_TO_PERCPU_BTF_ID = 19,
	ARG_PTR_TO_FUNC = 20,
	ARG_PTR_TO_STACK = 21,
	ARG_PTR_TO_CONST_STR = 22,
	ARG_PTR_TO_TIMER = 23,
	ARG_PTR_TO_KPTR = 24,
	ARG_PTR_TO_DYNPTR = 25,
	__BPF_ARG_TYPE_MAX = 26,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 264,
	ARG_PTR_TO_SOCKET_OR_NULL = 270,
	ARG_PTR_TO_STACK_OR_NULL = 277,
	ARG_PTR_TO_BTF_ID_OR_NULL = 271,
	ARG_PTR_TO_UNINIT_MEM = 32772,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 33554431,
};

enum bpf_async_type {
	BPF_ASYNC_TYPE_TIMER = 0,
	BPF_ASYNC_TYPE_WQ = 1,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	BPF_CGROUP_UNIX_CONNECT = 49,
	BPF_CGROUP_UNIX_SENDMSG = 50,
	BPF_CGROUP_UNIX_RECVMSG = 51,
	BPF_CGROUP_UNIX_GETPEERNAME = 52,
	BPF_CGROUP_UNIX_GETSOCKNAME = 53,
	BPF_NETKIT_PRIMARY = 54,
	BPF_NETKIT_PEER = 55,
	BPF_TRACE_KPROBE_SESSION = 56,
	__MAX_BPF_ATTACH_TYPE = 57,
};

enum bpf_audit {
	BPF_AUDIT_LOAD = 0,
	BPF_AUDIT_UNLOAD = 1,
	BPF_AUDIT_MAX = 2,
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

enum bpf_cgroup_storage_type {
	BPF_CGROUP_STORAGE_SHARED = 0,
	BPF_CGROUP_STORAGE_PERCPU = 1,
	__BPF_CGROUP_STORAGE_MAX = 2,
};

enum bpf_check_mtu_flags {
	BPF_MTU_CHK_SEGS = 1,
};

enum bpf_check_mtu_ret {
	BPF_MTU_CHK_RET_SUCCESS = 0,
	BPF_MTU_CHK_RET_FRAG_NEEDED = 1,
	BPF_MTU_CHK_RET_SEGS_TOOBIG = 2,
};

enum bpf_cmd {
	BPF_MAP_CREATE = 0,
	BPF_MAP_LOOKUP_ELEM = 1,
	BPF_MAP_UPDATE_ELEM = 2,
	BPF_MAP_DELETE_ELEM = 3,
	BPF_MAP_GET_NEXT_KEY = 4,
	BPF_PROG_LOAD = 5,
	BPF_OBJ_PIN = 6,
	BPF_OBJ_GET = 7,
	BPF_PROG_ATTACH = 8,
	BPF_PROG_DETACH = 9,
	BPF_PROG_TEST_RUN = 10,
	BPF_PROG_RUN = 10,
	BPF_PROG_GET_NEXT_ID = 11,
	BPF_MAP_GET_NEXT_ID = 12,
	BPF_PROG_GET_FD_BY_ID = 13,
	BPF_MAP_GET_FD_BY_ID = 14,
	BPF_OBJ_GET_INFO_BY_FD = 15,
	BPF_PROG_QUERY = 16,
	BPF_RAW_TRACEPOINT_OPEN = 17,
	BPF_BTF_LOAD = 18,
	BPF_BTF_GET_FD_BY_ID = 19,
	BPF_TASK_FD_QUERY = 20,
	BPF_MAP_LOOKUP_AND_DELETE_ELEM = 21,
	BPF_MAP_FREEZE = 22,
	BPF_BTF_GET_NEXT_ID = 23,
	BPF_MAP_LOOKUP_BATCH = 24,
	BPF_MAP_LOOKUP_AND_DELETE_BATCH = 25,
	BPF_MAP_UPDATE_BATCH = 26,
	BPF_MAP_DELETE_BATCH = 27,
	BPF_LINK_CREATE = 28,
	BPF_LINK_UPDATE = 29,
	BPF_LINK_GET_FD_BY_ID = 30,
	BPF_LINK_GET_NEXT_ID = 31,
	BPF_ENABLE_STATS = 32,
	BPF_ITER_CREATE = 33,
	BPF_LINK_DETACH = 34,
	BPF_PROG_BIND_MAP = 35,
	BPF_TOKEN_CREATE = 36,
	__MAX_BPF_CMD = 37,
};

enum bpf_cond_pseudo_jmp {
	BPF_MAY_GOTO = 0,
};

enum bpf_core_relo_kind {
	BPF_CORE_FIELD_BYTE_OFFSET = 0,
	BPF_CORE_FIELD_BYTE_SIZE = 1,
	BPF_CORE_FIELD_EXISTS = 2,
	BPF_CORE_FIELD_SIGNED = 3,
	BPF_CORE_FIELD_LSHIFT_U64 = 4,
	BPF_CORE_FIELD_RSHIFT_U64 = 5,
	BPF_CORE_TYPE_ID_LOCAL = 6,
	BPF_CORE_TYPE_ID_TARGET = 7,
	BPF_CORE_TYPE_EXISTS = 8,
	BPF_CORE_TYPE_SIZE = 9,
	BPF_CORE_ENUMVAL_EXISTS = 10,
	BPF_CORE_ENUMVAL_VALUE = 11,
	BPF_CORE_TYPE_MATCHES = 12,
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

enum bpf_hdr_start_off {
	BPF_HDR_START_MAC = 0,
	BPF_HDR_START_NET = 1,
};

enum bpf_iter_feature {
	BPF_ITER_RESCHED = 1,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

enum bpf_jit_poke_reason {
	BPF_POKE_REASON_TAIL_CALL = 0,
};

enum bpf_link_type {
	BPF_LINK_TYPE_UNSPEC = 0,
	BPF_LINK_TYPE_RAW_TRACEPOINT = 1,
	BPF_LINK_TYPE_TRACING = 2,
	BPF_LINK_TYPE_CGROUP = 3,
	BPF_LINK_TYPE_ITER = 4,
	BPF_LINK_TYPE_NETNS = 5,
	BPF_LINK_TYPE_XDP = 6,
	BPF_LINK_TYPE_PERF_EVENT = 7,
	BPF_LINK_TYPE_KPROBE_MULTI = 8,
	BPF_LINK_TYPE_STRUCT_OPS = 9,
	BPF_LINK_TYPE_NETFILTER = 10,
	BPF_LINK_TYPE_TCX = 11,
	BPF_LINK_TYPE_UPROBE_MULTI = 12,
	BPF_LINK_TYPE_NETKIT = 13,
	BPF_LINK_TYPE_SOCKMAP = 14,
	__MAX_BPF_LINK_TYPE = 15,
};

enum bpf_lru_list_type {
	BPF_LRU_LIST_T_ACTIVE = 0,
	BPF_LRU_LIST_T_INACTIVE = 1,
	BPF_LRU_LIST_T_FREE = 2,
	BPF_LRU_LOCAL_LIST_T_FREE = 3,
	BPF_LRU_LOCAL_LIST_T_PENDING = 4,
};

enum bpf_lwt_encap_mode {
	BPF_LWT_ENCAP_SEG6 = 0,
	BPF_LWT_ENCAP_SEG6_INLINE = 1,
	BPF_LWT_ENCAP_IP = 2,
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE_DEPRECATED = 21,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
	BPF_MAP_TYPE_ARENA = 33,
	__MAX_BPF_MAP_TYPE = 34,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

enum bpf_perf_event_type {
	BPF_PERF_EVENT_UNSPEC = 0,
	BPF_PERF_EVENT_UPROBE = 1,
	BPF_PERF_EVENT_URETPROBE = 2,
	BPF_PERF_EVENT_KPROBE = 3,
	BPF_PERF_EVENT_KRETPROBE = 4,
	BPF_PERF_EVENT_TRACEPOINT = 5,
	BPF_PERF_EVENT_EVENT = 6,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
	__MAX_BPF_PROG_TYPE = 33,
};

enum bpf_reg_liveness {
	REG_LIVE_NONE = 0,
	REG_LIVE_READ32 = 1,
	REG_LIVE_READ64 = 2,
	REG_LIVE_READ = 3,
	REG_LIVE_WRITTEN = 4,
	REG_LIVE_DONE = 8,
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_ARENA = 18,
	PTR_TO_BUF = 19,
	PTR_TO_FUNC = 20,
	CONST_PTR_TO_DYNPTR = 21,
	__BPF_REG_TYPE_MAX = 22,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 33554431,
};

enum bpf_ret_code {
	BPF_OK = 0,
	BPF_DROP = 2,
	BPF_REDIRECT = 7,
	BPF_LWT_REROUTE = 128,
	BPF_FLOW_DISSECTOR_CONTINUE = 129,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 33554431,
};

enum bpf_stack_build_id_status {
	BPF_STACK_BUILD_ID_EMPTY = 0,
	BPF_STACK_BUILD_ID_VALID = 1,
	BPF_STACK_BUILD_ID_IP = 2,
};

enum bpf_stack_slot_type {
	STACK_INVALID = 0,
	STACK_SPILL = 1,
	STACK_MISC = 2,
	STACK_ZERO = 3,
	STACK_DYNPTR = 4,
	STACK_ITER = 5,
};

enum bpf_stats_type {
	BPF_STATS_RUN_TIME = 0,
};

enum bpf_struct_ops_state {
	BPF_STRUCT_OPS_STATE_INIT = 0,
	BPF_STRUCT_OPS_STATE_INUSE = 1,
	BPF_STRUCT_OPS_STATE_TOBEFREE = 2,
	BPF_STRUCT_OPS_STATE_READY = 3,
};

enum bpf_struct_walk_result {
	WALK_SCALAR = 0,
	WALK_PTR = 1,
	WALK_STRUCT = 2,
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

enum bpf_task_vma_iter_find_op {
	task_vma_iter_first_vma = 0,
	task_vma_iter_next_vma = 1,
	task_vma_iter_find_vma = 2,
};

enum bpf_text_poke_type {
	BPF_MOD_CALL = 0,
	BPF_MOD_JUMP = 1,
};

enum bpf_tramp_prog_type {
	BPF_TRAMP_FENTRY = 0,
	BPF_TRAMP_FEXIT = 1,
	BPF_TRAMP_MODIFY_RETURN = 2,
	BPF_TRAMP_MAX = 3,
	BPF_TRAMP_REPLACE = 4,
};

enum bpf_type {
	BPF_TYPE_UNSPEC = 0,
	BPF_TYPE_PROG = 1,
	BPF_TYPE_MAP = 2,
	BPF_TYPE_LINK = 3,
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	__BPF_TYPE_FLAG_MAX = 16777217,
	__BPF_TYPE_LAST_FLAG = 16777216,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

enum branch_cache_flush_type {
	BRANCH_CACHE_FLUSH_NONE = 1,
	BRANCH_CACHE_FLUSH_SW = 2,
	BRANCH_CACHE_FLUSH_HW = 4,
};

enum btf_arg_tag {
	ARG_TAG_CTX = 1,
	ARG_TAG_NONNULL = 2,
	ARG_TAG_TRUSTED = 4,
	ARG_TAG_NULLABLE = 8,
	ARG_TAG_ARENA = 16,
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR_PERCPU = 16,
	BPF_KPTR = 28,
	BPF_LIST_HEAD = 32,
	BPF_LIST_NODE = 64,
	BPF_RB_ROOT = 128,
	BPF_RB_NODE = 256,
	BPF_GRAPH_NODE = 320,
	BPF_GRAPH_ROOT = 160,
	BPF_REFCOUNT = 512,
	BPF_WORKQUEUE = 1024,
};

enum btf_func_linkage {
	BTF_FUNC_STATIC = 0,
	BTF_FUNC_GLOBAL = 1,
	BTF_FUNC_EXTERN = 2,
};

enum btf_kfunc_hook {
	BTF_KFUNC_HOOK_COMMON = 0,
	BTF_KFUNC_HOOK_XDP = 1,
	BTF_KFUNC_HOOK_TC = 2,
	BTF_KFUNC_HOOK_STRUCT_OPS = 3,
	BTF_KFUNC_HOOK_TRACING = 4,
	BTF_KFUNC_HOOK_SYSCALL = 5,
	BTF_KFUNC_HOOK_FMODRET = 6,
	BTF_KFUNC_HOOK_CGROUP_SKB = 7,
	BTF_KFUNC_HOOK_SCHED_ACT = 8,
	BTF_KFUNC_HOOK_SK_SKB = 9,
	BTF_KFUNC_HOOK_SOCKET_FILTER = 10,
	BTF_KFUNC_HOOK_LWT = 11,
	BTF_KFUNC_HOOK_NETFILTER = 12,
	BTF_KFUNC_HOOK_KPROBE = 13,
	BTF_KFUNC_HOOK_MAX = 14,
};

enum buddy {
	FIRST = 0,
	LAST = 1,
};

enum buf_end_align_type {
	SAME_PAGE_UNALIGNED = 0,
	SAME_PAGE_ALIGNED = 1,
	NEXT_PAGE_UNALIGNED = 2,
	NEXT_PAGE_ALIGNED = 3,
	NEXT_NEXT_UNALIGNED = 4,
	LOOP_END = 5,
};

enum bug_trap_type {
	BUG_TRAP_TYPE_NONE = 0,
	BUG_TRAP_TYPE_WARN = 1,
	BUG_TRAP_TYPE_BUG = 2,
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

enum cache_type {
	CACHE_TYPE_NOCACHE = 0,
	CACHE_TYPE_INST = 1,
	CACHE_TYPE_DATA = 2,
	CACHE_TYPE_SEPARATE = 3,
	CACHE_TYPE_UNIFIED = 4,
};

enum cc_attr {
	CC_ATTR_MEM_ENCRYPT = 0,
	CC_ATTR_HOST_MEM_ENCRYPT = 1,
	CC_ATTR_GUEST_MEM_ENCRYPT = 2,
	CC_ATTR_GUEST_STATE_ENCRYPT = 3,
	CC_ATTR_GUEST_UNROLL_STRING_IO = 4,
	CC_ATTR_GUEST_SEV_SNP = 5,
	CC_ATTR_HOTPLUG_DISABLED = 6,
	CC_ATTR_HOST_SEV_SNP = 7,
};

enum cc_fec {
	FEC_AUTO = 1,
	FEC_RS = 2,
	FEC_BASER_RS = 4,
};

enum cc_pause {
	PAUSE_RX___2 = 1,
	PAUSE_TX___2 = 2,
	PAUSE_AUTONEG___2 = 4,
};

enum cdns_pcie_msg_code {
	MSG_CODE_ASSERT_INTA = 32,
	MSG_CODE_ASSERT_INTB = 33,
	MSG_CODE_ASSERT_INTC = 34,
	MSG_CODE_ASSERT_INTD = 35,
	MSG_CODE_DEASSERT_INTA = 36,
	MSG_CODE_DEASSERT_INTB = 37,
	MSG_CODE_DEASSERT_INTC = 38,
	MSG_CODE_DEASSERT_INTD = 39,
};

enum cdns_pcie_msg_routing {
	MSG_ROUTING_TO_RC = 0,
	MSG_ROUTING_BY_ADDR = 1,
	MSG_ROUTING_BY_ID = 2,
	MSG_ROUTING_BCAST = 3,
	MSG_ROUTING_LOCAL = 4,
	MSG_ROUTING_GATHER = 5,
};

enum cdns_pcie_rp_bar {
	RP_BAR_UNDEFINED = -1,
	RP_BAR0 = 0,
	RP_BAR1 = 1,
	RP_NO_BAR = 2,
};

enum cdrom_print_option {
	CTL_NAME = 0,
	CTL_SPEED = 1,
	CTL_SLOTS = 2,
	CTL_CAPABILITY = 3,
};

enum cee_attrs {
	DCB_ATTR_CEE_UNSPEC = 0,
	DCB_ATTR_CEE_PEER_PG = 1,
	DCB_ATTR_CEE_PEER_PFC = 2,
	DCB_ATTR_CEE_PEER_APP_TABLE = 3,
	DCB_ATTR_CEE_TX_PG = 4,
	DCB_ATTR_CEE_RX_PG = 5,
	DCB_ATTR_CEE_PFC = 6,
	DCB_ATTR_CEE_APP_TABLE = 7,
	DCB_ATTR_CEE_FEAT = 8,
	__DCB_ATTR_CEE_MAX = 9,
};

enum cfg80211_signal_type {
	CFG80211_SIGNAL_TYPE_NONE = 0,
	CFG80211_SIGNAL_TYPE_MBM = 1,
	CFG80211_SIGNAL_TYPE_UNSPEC = 2,
};

enum cgroup1_param {
	Opt_all = 0,
	Opt_clone_children = 1,
	Opt_cpuset_v2_mode = 2,
	Opt_name = 3,
	Opt_none = 4,
	Opt_noprefix = 5,
	Opt_release_agent = 6,
	Opt_xattr = 7,
	Opt_favordynmods = 8,
	Opt_nofavordynmods = 9,
};

enum cgroup2_param {
	Opt_nsdelegate = 0,
	Opt_favordynmods___2 = 1,
	Opt_memory_localevents = 2,
	Opt_memory_recursiveprot = 3,
	Opt_memory_hugetlb_accounting = 4,
	nr__cgroup2_params = 5,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_UNIX_CONNECT = 9,
	CGROUP_INET4_POST_BIND = 10,
	CGROUP_INET6_POST_BIND = 11,
	CGROUP_UDP4_SENDMSG = 12,
	CGROUP_UDP6_SENDMSG = 13,
	CGROUP_UNIX_SENDMSG = 14,
	CGROUP_SYSCTL = 15,
	CGROUP_UDP4_RECVMSG = 16,
	CGROUP_UDP6_RECVMSG = 17,
	CGROUP_UNIX_RECVMSG = 18,
	CGROUP_GETSOCKOPT = 19,
	CGROUP_SETSOCKOPT = 20,
	CGROUP_INET4_GETPEERNAME = 21,
	CGROUP_INET6_GETPEERNAME = 22,
	CGROUP_UNIX_GETPEERNAME = 23,
	CGROUP_INET4_GETSOCKNAME = 24,
	CGROUP_INET6_GETSOCKNAME = 25,
	CGROUP_UNIX_GETSOCKNAME = 26,
	CGROUP_INET_SOCK_RELEASE = 27,
	CGROUP_LSM_START = 28,
	CGROUP_LSM_END = 27,
	MAX_CGROUP_BPF_ATTACH_TYPE = 28,
};

enum cgroup_filetype {
	CGROUP_FILE_PROCS = 0,
	CGROUP_FILE_TASKS = 1,
};

enum cgroup_opt_features {
	OPT_FEATURE_PRESSURE = 0,
	OPT_FEATURE_COUNT = 1,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	net_cls_cgrp_id = 7,
	perf_event_cgrp_id = 8,
	net_prio_cgrp_id = 9,
	hugetlb_cgrp_id = 10,
	pids_cgrp_id = 11,
	rdma_cgrp_id = 12,
	CGROUP_SUBSYS_COUNT = 13,
};

enum chacha_constants {
	CHACHA_CONSTANT_EXPA = 1634760805,
	CHACHA_CONSTANT_ND_3 = 857760878,
	CHACHA_CONSTANT_2_BY = 2036477234,
	CHACHA_CONSTANT_TE_K = 1797285236,
};

enum chap_type_e {
	CHAP_TYPE_OUT = 0,
	CHAP_TYPE_IN = 1,
};

enum chip_flavors {
	chip_8001 = 0,
	chip_8008 = 1,
	chip_8009 = 2,
	chip_8018 = 3,
	chip_8019 = 4,
	chip_8074 = 5,
	chip_8076 = 6,
	chip_8077 = 7,
	chip_8006 = 8,
	chip_8070 = 9,
	chip_8072 = 10,
};

enum chip_flavors___2 {
	chip_6320 = 0,
	chip_6440 = 1,
	chip_6485 = 2,
	chip_9480 = 3,
	chip_9180 = 4,
	chip_9445 = 5,
	chip_9485 = 6,
	chip_1300 = 7,
	chip_1320 = 8,
};

enum chip_register_bits {
	PHY_MIN_SPP_PHYS_LINK_RATE_MASK = 3840,
	PHY_MAX_SPP_PHYS_LINK_RATE_MASK = 61440,
	PHY_NEG_SPP_PHYS_LINK_RATE_MASK_OFFSET = 16,
	PHY_NEG_SPP_PHYS_LINK_RATE_MASK = 983040,
};

enum chip_register_bits___2 {
	PHY_MIN_SPP_PHYS_LINK_RATE_MASK___2 = 1792,
	PHY_MAX_SPP_PHYS_LINK_RATE_MASK___2 = 28672,
	PHY_NEG_SPP_PHYS_LINK_RATE_MASK_OFFSET___2 = 16,
	PHY_NEG_SPP_PHYS_LINK_RATE_MASK___2 = 196608,
};

enum chip_type {
	T5_A0 = 80,
	T5_A1 = 81,
	T5_FIRST_REV = 80,
	T5_LAST_REV = 81,
	T6_A0 = 96,
	T6_FIRST_REV = 96,
	T6_LAST_REV = 96,
};

enum chip_type___2 {
	chip_504x = 0,
	chip_508x = 1,
	chip_5080 = 2,
	chip_604x = 3,
	chip_608x = 4,
	chip_6042 = 5,
	chip_7042 = 6,
	chip_soc = 7,
};

enum chip_type___3 {
	unknown = 0,
	tmc1800 = 1,
	tmc18c50 = 2,
	tmc18c30 = 3,
};

enum chip_type___4 {
	T4_A1 = 65,
	T4_A2 = 66,
	T4_FIRST_REV = 65,
	T4_LAST_REV = 66,
	T5_A0___2 = 80,
	T5_A1___2 = 81,
	T5_FIRST_REV___2 = 80,
	T5_LAST_REV___2 = 81,
	T6_A0___2 = 96,
	T6_FIRST_REV___2 = 96,
	T6_LAST_REV___2 = 96,
};

enum class_map_type {
	DD_CLASS_TYPE_DISJOINT_BITS = 0,
	DD_CLASS_TYPE_LEVEL_NUM = 1,
	DD_CLASS_TYPE_DISJOINT_NAMES = 2,
	DD_CLASS_TYPE_LEVEL_NAMES = 3,
};

enum class_stat_type {
	ZS_OBJS_ALLOCATED = 12,
	ZS_OBJS_INUSE = 13,
	NR_CLASS_STAT_TYPES = 14,
};

enum cleanup_prefix_rt_t {
	CLEANUP_PREFIX_RT_NOP = 0,
	CLEANUP_PREFIX_RT_DEL = 1,
	CLEANUP_PREFIX_RT_EXPIRE = 2,
};

enum clear_nexus_phase {
	NEXUS_PHASE_PRE = 0,
	NEXUS_PHASE_POST = 1,
	NEXUS_PHASE_RESUME = 2,
};

enum clear_refs_types {
	CLEAR_REFS_ALL = 1,
	CLEAR_REFS_ANON = 2,
	CLEAR_REFS_MAPPED = 3,
	CLEAR_REFS_SOFT_DIRTY = 4,
	CLEAR_REFS_MM_HIWATER_RSS = 5,
	CLEAR_REFS_LAST = 6,
};

enum clk_div_values {
	DWC_UFS_REG_HCLKDIV_DIV_62_5 = 62,
	DWC_UFS_REG_HCLKDIV_DIV_125 = 125,
	DWC_UFS_REG_HCLKDIV_DIV_200 = 200,
};

enum clk_gating_state {
	CLKS_OFF = 0,
	CLKS_ON = 1,
	REQ_CLKS_OFF = 2,
	REQ_CLKS_ON = 3,
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_X86_TSC_EARLY = 2,
	CSID_X86_TSC = 3,
	CSID_X86_KVM_CLK = 4,
	CSID_MAX = 5,
};

enum closure_state {
	CLOSURE_BITS_START = 67108864,
	CLOSURE_DESTRUCTOR = 67108864,
	CLOSURE_WAITING = 268435456,
	CLOSURE_RUNNING = 1073741824,
};

enum comm_dir {
	COMM_DIR_NONE = 0,
	COMM_DIR_RX = 1,
	COMM_DIR_TX = 2,
	COMM_DIR_RX_AND_TX = 3,
};

enum command {
	MPI3MR_DRV_CMD = 1,
	MPI3MR_MPT_CMD = 2,
};

enum common_spqe_cmd_id {
	RAMROD_CMD_ID_COMMON_UNUSED = 0,
	RAMROD_CMD_ID_COMMON_FUNCTION_START = 1,
	RAMROD_CMD_ID_COMMON_FUNCTION_STOP = 2,
	RAMROD_CMD_ID_COMMON_FUNCTION_UPDATE = 3,
	RAMROD_CMD_ID_COMMON_CFC_DEL = 4,
	RAMROD_CMD_ID_COMMON_CFC_DEL_WB = 5,
	RAMROD_CMD_ID_COMMON_STAT_QUERY = 6,
	RAMROD_CMD_ID_COMMON_STOP_TRAFFIC = 7,
	RAMROD_CMD_ID_COMMON_START_TRAFFIC = 8,
	RAMROD_CMD_ID_COMMON_AFEX_VIF_LISTS = 9,
	RAMROD_CMD_ID_COMMON_SET_TIMESYNC = 10,
	MAX_COMMON_SPQE_CMD_ID = 11,
};

enum compact_priority {
	COMPACT_PRIO_SYNC_FULL = 0,
	MIN_COMPACT_PRIORITY = 0,
	COMPACT_PRIO_SYNC_LIGHT = 1,
	MIN_COMPACT_COSTLY_PRIORITY = 1,
	DEF_COMPACT_PRIORITY = 1,
	COMPACT_PRIO_ASYNC = 2,
	INIT_COMPACT_PRIORITY = 2,
};

enum compact_result {
	COMPACT_NOT_SUITABLE_ZONE = 0,
	COMPACT_SKIPPED = 1,
	COMPACT_DEFERRED = 2,
	COMPACT_NO_SUITABLE_PAGE = 3,
	COMPACT_CONTINUE = 4,
	COMPACT_COMPLETE = 5,
	COMPACT_PARTIAL_SKIPPED = 6,
	COMPACT_CONTENDED = 7,
	COMPACT_SUCCESS = 8,
};

enum con_flush_mode {
	CONSOLE_FLUSH_PENDING = 0,
	CONSOLE_REPLAY_ALL = 1,
};

enum con_msg_format_flags {
	MSG_FORMAT_DEFAULT = 0,
	MSG_FORMAT_SYSLOG = 1,
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

enum connection_type {
	ETH_CONNECTION_TYPE = 0,
	TOE_CONNECTION_TYPE = 1,
	RDMA_CONNECTION_TYPE = 2,
	ISCSI_CONNECTION_TYPE = 3,
	FCOE_CONNECTION_TYPE = 4,
	RESERVED_CONNECTION_TYPE_0 = 5,
	RESERVED_CONNECTION_TYPE_1 = 6,
	RESERVED_CONNECTION_TYPE_2 = 7,
	NONE_CONNECTION_TYPE = 8,
	MAX_CONNECTION_TYPE = 9,
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
	CON_NBCON = 256,
};

enum cpio_fields {
	C_MAGIC = 0,
	C_INO = 1,
	C_MODE = 2,
	C_UID = 3,
	C_GID = 4,
	C_NLINK = 5,
	C_MTIME = 6,
	C_FILESIZE = 7,
	C_MAJ = 8,
	C_MIN = 9,
	C_RMAJ = 10,
	C_RMIN = 11,
	C_NAMESIZE = 12,
	C_CHKSUM = 13,
	C_NFIELDS = 14,
};

enum cpu_idle_type {
	__CPU_NOT_IDLE = 0,
	CPU_IDLE = 1,
	CPU_NEWLY_IDLE = 2,
	CPU_MAX_IDLE_TYPES = 3,
};

enum cpu_led_event {
	CPU_LED_IDLE_START = 0,
	CPU_LED_IDLE_END = 1,
	CPU_LED_START = 2,
	CPU_LED_STOP = 3,
	CPU_LED_HALTED = 4,
};

enum cpu_mitigations {
	CPU_MITIGATIONS_OFF = 0,
	CPU_MITIGATIONS_AUTO = 1,
	CPU_MITIGATIONS_AUTO_NOSMT = 2,
};

enum cpu_usage_stat {
	CPUTIME_USER = 0,
	CPUTIME_NICE = 1,
	CPUTIME_SYSTEM = 2,
	CPUTIME_SOFTIRQ = 3,
	CPUTIME_IRQ = 4,
	CPUTIME_IDLE = 5,
	CPUTIME_IOWAIT = 6,
	CPUTIME_STEAL = 7,
	CPUTIME_GUEST = 8,
	CPUTIME_GUEST_NICE = 9,
	CPUTIME_FORCEIDLE = 10,
	NR_STATS = 11,
};

enum cpuacct_stat_index {
	CPUACCT_STAT_USER = 0,
	CPUACCT_STAT_SYSTEM = 1,
	CPUACCT_STAT_NSTATS = 2,
};

enum cpufreq_table_sorting {
	CPUFREQ_TABLE_UNSORTED = 0,
	CPUFREQ_TABLE_SORTED_ASCENDING = 1,
	CPUFREQ_TABLE_SORTED_DESCENDING = 2,
};

enum cpuhp_smt_control {
	CPU_SMT_ENABLED = 0,
	CPU_SMT_DISABLED = 1,
	CPU_SMT_FORCE_DISABLED = 2,
	CPU_SMT_NOT_SUPPORTED = 3,
	CPU_SMT_NOT_IMPLEMENTED = 4,
};

enum cpuhp_state {
	CPUHP_INVALID = -1,
	CPUHP_OFFLINE = 0,
	CPUHP_CREATE_THREADS = 1,
	CPUHP_PERF_PREPARE = 2,
	CPUHP_PERF_X86_PREPARE = 3,
	CPUHP_PERF_X86_AMD_UNCORE_PREP = 4,
	CPUHP_PERF_POWER = 5,
	CPUHP_PERF_SUPERH = 6,
	CPUHP_X86_HPET_DEAD = 7,
	CPUHP_X86_MCE_DEAD = 8,
	CPUHP_VIRT_NET_DEAD = 9,
	CPUHP_IBMVNIC_DEAD = 10,
	CPUHP_SLUB_DEAD = 11,
	CPUHP_DEBUG_OBJ_DEAD = 12,
	CPUHP_MM_WRITEBACK_DEAD = 13,
	CPUHP_MM_VMSTAT_DEAD = 14,
	CPUHP_SOFTIRQ_DEAD = 15,
	CPUHP_NET_MVNETA_DEAD = 16,
	CPUHP_CPUIDLE_DEAD = 17,
	CPUHP_ARM64_FPSIMD_DEAD = 18,
	CPUHP_ARM_OMAP_WAKE_DEAD = 19,
	CPUHP_IRQ_POLL_DEAD = 20,
	CPUHP_BLOCK_SOFTIRQ_DEAD = 21,
	CPUHP_BIO_DEAD = 22,
	CPUHP_ACPI_CPUDRV_DEAD = 23,
	CPUHP_S390_PFAULT_DEAD = 24,
	CPUHP_BLK_MQ_DEAD = 25,
	CPUHP_FS_BUFF_DEAD = 26,
	CPUHP_PRINTK_DEAD = 27,
	CPUHP_MM_MEMCQ_DEAD = 28,
	CPUHP_PERCPU_CNT_DEAD = 29,
	CPUHP_RADIX_DEAD = 30,
	CPUHP_PAGE_ALLOC = 31,
	CPUHP_NET_DEV_DEAD = 32,
	CPUHP_PCI_XGENE_DEAD = 33,
	CPUHP_IOMMU_IOVA_DEAD = 34,
	CPUHP_AP_ARM_CACHE_B15_RAC_DEAD = 35,
	CPUHP_PADATA_DEAD = 36,
	CPUHP_AP_DTPM_CPU_DEAD = 37,
	CPUHP_RANDOM_PREPARE = 38,
	CPUHP_WORKQUEUE_PREP = 39,
	CPUHP_POWER_NUMA_PREPARE = 40,
	CPUHP_HRTIMERS_PREPARE = 41,
	CPUHP_PROFILE_PREPARE = 42,
	CPUHP_X2APIC_PREPARE = 43,
	CPUHP_SMPCFD_PREPARE = 44,
	CPUHP_RELAY_PREPARE = 45,
	CPUHP_MD_RAID5_PREPARE = 46,
	CPUHP_RCUTREE_PREP = 47,
	CPUHP_CPUIDLE_COUPLED_PREPARE = 48,
	CPUHP_POWERPC_PMAC_PREPARE = 49,
	CPUHP_POWERPC_MMU_CTX_PREPARE = 50,
	CPUHP_XEN_PREPARE = 51,
	CPUHP_XEN_EVTCHN_PREPARE = 52,
	CPUHP_ARM_SHMOBILE_SCU_PREPARE = 53,
	CPUHP_SH_SH3X_PREPARE = 54,
	CPUHP_TOPOLOGY_PREPARE = 55,
	CPUHP_NET_IUCV_PREPARE = 56,
	CPUHP_ARM_BL_PREPARE = 57,
	CPUHP_TRACE_RB_PREPARE = 58,
	CPUHP_MM_ZS_PREPARE = 59,
	CPUHP_MM_ZSWP_POOL_PREPARE = 60,
	CPUHP_KVM_PPC_BOOK3S_PREPARE = 61,
	CPUHP_ZCOMP_PREPARE = 62,
	CPUHP_TIMERS_PREPARE = 63,
	CPUHP_MIPS_SOC_PREPARE = 64,
	CPUHP_BP_PREPARE_DYN = 65,
	CPUHP_BP_PREPARE_DYN_END = 85,
	CPUHP_BP_KICK_AP = 86,
	CPUHP_BRINGUP_CPU = 87,
	CPUHP_AP_IDLE_DEAD = 88,
	CPUHP_AP_OFFLINE = 89,
	CPUHP_AP_CACHECTRL_STARTING = 90,
	CPUHP_AP_SCHED_STARTING = 91,
	CPUHP_AP_RCUTREE_DYING = 92,
	CPUHP_AP_CPU_PM_STARTING = 93,
	CPUHP_AP_IRQ_GIC_STARTING = 94,
	CPUHP_AP_IRQ_HIP04_STARTING = 95,
	CPUHP_AP_IRQ_APPLE_AIC_STARTING = 96,
	CPUHP_AP_IRQ_ARMADA_XP_STARTING = 97,
	CPUHP_AP_IRQ_BCM2836_STARTING = 98,
	CPUHP_AP_IRQ_MIPS_GIC_STARTING = 99,
	CPUHP_AP_IRQ_LOONGARCH_STARTING = 100,
	CPUHP_AP_IRQ_SIFIVE_PLIC_STARTING = 101,
	CPUHP_AP_IRQ_RISCV_IMSIC_STARTING = 102,
	CPUHP_AP_IRQ_RISCV_SBI_IPI_STARTING = 103,
	CPUHP_AP_ARM_MVEBU_COHERENCY = 104,
	CPUHP_AP_PERF_X86_AMD_UNCORE_STARTING = 105,
	CPUHP_AP_PERF_X86_STARTING = 106,
	CPUHP_AP_PERF_X86_AMD_IBS_STARTING = 107,
	CPUHP_AP_PERF_X86_CSTATE_STARTING = 108,
	CPUHP_AP_PERF_XTENSA_STARTING = 109,
	CPUHP_AP_ARM_VFP_STARTING = 110,
	CPUHP_AP_ARM64_DEBUG_MONITORS_STARTING = 111,
	CPUHP_AP_PERF_ARM_HW_BREAKPOINT_STARTING = 112,
	CPUHP_AP_PERF_ARM_ACPI_STARTING = 113,
	CPUHP_AP_PERF_ARM_STARTING = 114,
	CPUHP_AP_PERF_RISCV_STARTING = 115,
	CPUHP_AP_ARM_L2X0_STARTING = 116,
	CPUHP_AP_EXYNOS4_MCT_TIMER_STARTING = 117,
	CPUHP_AP_ARM_ARCH_TIMER_STARTING = 118,
	CPUHP_AP_ARM_ARCH_TIMER_EVTSTRM_STARTING = 119,
	CPUHP_AP_ARM_GLOBAL_TIMER_STARTING = 120,
	CPUHP_AP_JCORE_TIMER_STARTING = 121,
	CPUHP_AP_ARM_TWD_STARTING = 122,
	CPUHP_AP_QCOM_TIMER_STARTING = 123,
	CPUHP_AP_TEGRA_TIMER_STARTING = 124,
	CPUHP_AP_ARMADA_TIMER_STARTING = 125,
	CPUHP_AP_MIPS_GIC_TIMER_STARTING = 126,
	CPUHP_AP_ARC_TIMER_STARTING = 127,
	CPUHP_AP_RISCV_TIMER_STARTING = 128,
	CPUHP_AP_CLINT_TIMER_STARTING = 129,
	CPUHP_AP_CSKY_TIMER_STARTING = 130,
	CPUHP_AP_TI_GP_TIMER_STARTING = 131,
	CPUHP_AP_HYPERV_TIMER_STARTING = 132,
	CPUHP_AP_DUMMY_TIMER_STARTING = 133,
	CPUHP_AP_ARM_XEN_STARTING = 134,
	CPUHP_AP_ARM_XEN_RUNSTATE_STARTING = 135,
	CPUHP_AP_ARM_CORESIGHT_STARTING = 136,
	CPUHP_AP_ARM_CORESIGHT_CTI_STARTING = 137,
	CPUHP_AP_ARM64_ISNDEP_STARTING = 138,
	CPUHP_AP_SMPCFD_DYING = 139,
	CPUHP_AP_HRTIMERS_DYING = 140,
	CPUHP_AP_TICK_DYING = 141,
	CPUHP_AP_X86_TBOOT_DYING = 142,
	CPUHP_AP_ARM_CACHE_B15_RAC_DYING = 143,
	CPUHP_AP_ONLINE = 144,
	CPUHP_TEARDOWN_CPU = 145,
	CPUHP_AP_ONLINE_IDLE = 146,
	CPUHP_AP_HYPERV_ONLINE = 147,
	CPUHP_AP_KVM_ONLINE = 148,
	CPUHP_AP_SCHED_WAIT_EMPTY = 149,
	CPUHP_AP_SMPBOOT_THREADS = 150,
	CPUHP_AP_IRQ_AFFINITY_ONLINE = 151,
	CPUHP_AP_BLK_MQ_ONLINE = 152,
	CPUHP_AP_ARM_MVEBU_SYNC_CLOCKS = 153,
	CPUHP_AP_X86_INTEL_EPB_ONLINE = 154,
	CPUHP_AP_PERF_ONLINE = 155,
	CPUHP_AP_PERF_X86_ONLINE = 156,
	CPUHP_AP_PERF_X86_UNCORE_ONLINE = 157,
	CPUHP_AP_PERF_X86_AMD_UNCORE_ONLINE = 158,
	CPUHP_AP_PERF_X86_AMD_POWER_ONLINE = 159,
	CPUHP_AP_PERF_X86_RAPL_ONLINE = 160,
	CPUHP_AP_PERF_X86_CSTATE_ONLINE = 161,
	CPUHP_AP_PERF_S390_CF_ONLINE = 162,
	CPUHP_AP_PERF_S390_SF_ONLINE = 163,
	CPUHP_AP_PERF_ARM_CCI_ONLINE = 164,
	CPUHP_AP_PERF_ARM_CCN_ONLINE = 165,
	CPUHP_AP_PERF_ARM_HISI_CPA_ONLINE = 166,
	CPUHP_AP_PERF_ARM_HISI_DDRC_ONLINE = 167,
	CPUHP_AP_PERF_ARM_HISI_HHA_ONLINE = 168,
	CPUHP_AP_PERF_ARM_HISI_L3_ONLINE = 169,
	CPUHP_AP_PERF_ARM_HISI_PA_ONLINE = 170,
	CPUHP_AP_PERF_ARM_HISI_SLLC_ONLINE = 171,
	CPUHP_AP_PERF_ARM_HISI_PCIE_PMU_ONLINE = 172,
	CPUHP_AP_PERF_ARM_HNS3_PMU_ONLINE = 173,
	CPUHP_AP_PERF_ARM_L2X0_ONLINE = 174,
	CPUHP_AP_PERF_ARM_QCOM_L2_ONLINE = 175,
	CPUHP_AP_PERF_ARM_QCOM_L3_ONLINE = 176,
	CPUHP_AP_PERF_ARM_APM_XGENE_ONLINE = 177,
	CPUHP_AP_PERF_ARM_CAVIUM_TX2_UNCORE_ONLINE = 178,
	CPUHP_AP_PERF_ARM_MARVELL_CN10K_DDR_ONLINE = 179,
	CPUHP_AP_PERF_POWERPC_NEST_IMC_ONLINE = 180,
	CPUHP_AP_PERF_POWERPC_CORE_IMC_ONLINE = 181,
	CPUHP_AP_PERF_POWERPC_THREAD_IMC_ONLINE = 182,
	CPUHP_AP_PERF_POWERPC_TRACE_IMC_ONLINE = 183,
	CPUHP_AP_PERF_POWERPC_HV_24x7_ONLINE = 184,
	CPUHP_AP_PERF_POWERPC_HV_GPCI_ONLINE = 185,
	CPUHP_AP_PERF_CSKY_ONLINE = 186,
	CPUHP_AP_TMIGR_ONLINE = 187,
	CPUHP_AP_WATCHDOG_ONLINE = 188,
	CPUHP_AP_WORKQUEUE_ONLINE = 189,
	CPUHP_AP_RANDOM_ONLINE = 190,
	CPUHP_AP_RCUTREE_ONLINE = 191,
	CPUHP_AP_BASE_CACHEINFO_ONLINE = 192,
	CPUHP_AP_ONLINE_DYN = 193,
	CPUHP_AP_ONLINE_DYN_END = 233,
	CPUHP_AP_X86_HPET_ONLINE = 234,
	CPUHP_AP_X86_KVM_CLK_ONLINE = 235,
	CPUHP_AP_ACTIVE = 236,
	CPUHP_ONLINE = 237,
};

enum cpuhp_sync_state {
	SYNC_STATE_DEAD = 0,
	SYNC_STATE_KICKED = 1,
	SYNC_STATE_SHOULD_DIE = 2,
	SYNC_STATE_ALIVE = 3,
	SYNC_STATE_SHOULD_ONLINE = 4,
	SYNC_STATE_ONLINE = 5,
};

enum criteria {
	CR_POWER2_ALIGNED = 0,
	CR_GOAL_LEN_FAST = 1,
	CR_BEST_AVAIL_LEN = 2,
	CR_GOAL_LEN_SLOW = 3,
	CR_ANY_FREE = 4,
	EXT4_MB_NUM_CRS = 5,
};

enum crypto_attr_type_t {
	CRYPTOCFGA_UNSPEC = 0,
	CRYPTOCFGA_PRIORITY_VAL = 1,
	CRYPTOCFGA_REPORT_LARVAL = 2,
	CRYPTOCFGA_REPORT_HASH = 3,
	CRYPTOCFGA_REPORT_BLKCIPHER = 4,
	CRYPTOCFGA_REPORT_AEAD = 5,
	CRYPTOCFGA_REPORT_COMPRESS = 6,
	CRYPTOCFGA_REPORT_RNG = 7,
	CRYPTOCFGA_REPORT_CIPHER = 8,
	CRYPTOCFGA_REPORT_AKCIPHER = 9,
	CRYPTOCFGA_REPORT_KPP = 10,
	CRYPTOCFGA_REPORT_ACOMP = 11,
	CRYPTOCFGA_STAT_LARVAL = 12,
	CRYPTOCFGA_STAT_HASH = 13,
	CRYPTOCFGA_STAT_BLKCIPHER = 14,
	CRYPTOCFGA_STAT_AEAD = 15,
	CRYPTOCFGA_STAT_COMPRESS = 16,
	CRYPTOCFGA_STAT_RNG = 17,
	CRYPTOCFGA_STAT_CIPHER = 18,
	CRYPTOCFGA_STAT_AKCIPHER = 19,
	CRYPTOCFGA_STAT_KPP = 20,
	CRYPTOCFGA_STAT_ACOMP = 21,
	__CRYPTOCFGA_MAX = 22,
};

enum csio_dev_master {
	CSIO_MASTER_CANT = 0,
	CSIO_MASTER_MAY = 1,
	CSIO_MASTER_MUST = 2,
};

enum csio_dev_state {
	CSIO_DEV_STATE_UNINIT = 0,
	CSIO_DEV_STATE_INIT = 1,
	CSIO_DEV_STATE_ERR = 2,
};

enum csio_evt {
	CSIO_EVT_FW = 0,
	CSIO_EVT_MBX = 1,
	CSIO_EVT_SCN = 2,
	CSIO_EVT_DEV_LOSS = 3,
	CSIO_EVT_MAX = 4,
};

enum csio_hw_ev {
	CSIO_HWE_CFG = 1,
	CSIO_HWE_INIT = 2,
	CSIO_HWE_INIT_DONE = 3,
	CSIO_HWE_FATAL = 4,
	CSIO_HWE_PCIERR_DETECTED = 5,
	CSIO_HWE_PCIERR_SLOT_RESET = 6,
	CSIO_HWE_PCIERR_RESUME = 7,
	CSIO_HWE_QUIESCED = 8,
	CSIO_HWE_HBA_RESET = 9,
	CSIO_HWE_HBA_RESET_DONE = 10,
	CSIO_HWE_FW_DLOAD = 11,
	CSIO_HWE_PCI_REMOVE = 12,
	CSIO_HWE_SUSPEND = 13,
	CSIO_HWE_RESUME = 14,
	CSIO_HWE_MAX = 15,
};

enum csio_intr_mode {
	CSIO_IM_NONE = 0,
	CSIO_IM_INTX = 1,
	CSIO_IM_MSI = 2,
	CSIO_IM_MSIX = 3,
};

enum csio_ln_ev {
	CSIO_LNE_NONE = 0,
	CSIO_LNE_LINKUP = 1,
	CSIO_LNE_FAB_INIT_DONE = 2,
	CSIO_LNE_LINK_DOWN = 3,
	CSIO_LNE_DOWN_LINK = 4,
	CSIO_LNE_LOGO = 5,
	CSIO_LNE_CLOSE = 6,
	CSIO_LNE_MAX_EVENT = 7,
};

enum csio_ln_fc_evt {
	CSIO_LN_FC_LINKUP = 1,
	CSIO_LN_FC_LINKDOWN = 2,
	CSIO_LN_FC_RSCN = 3,
	CSIO_LN_FC_ATTRIB_UPDATE = 4,
};

enum csio_ln_notify {
	CSIO_LN_NOTIFY_HWREADY = 1,
	CSIO_LN_NOTIFY_HWSTOP = 2,
	CSIO_LN_NOTIFY_HWREMOVE = 3,
	CSIO_LN_NOTIFY_HWRESET = 4,
};

enum csio_mb_owner {
	CSIO_MBOWNER_NONE = 0,
	CSIO_MBOWNER_FW = 1,
	CSIO_MBOWNER_PL = 2,
};

enum csio_rn_ev {
	CSIO_RNFE_NONE = 0,
	CSIO_RNFE_LOGGED_IN = 1,
	CSIO_RNFE_PRLI_DONE = 2,
	CSIO_RNFE_PLOGI_RECV = 3,
	CSIO_RNFE_PRLI_RECV = 4,
	CSIO_RNFE_LOGO_RECV = 5,
	CSIO_RNFE_PRLO_RECV = 6,
	CSIO_RNFE_DOWN = 7,
	CSIO_RNFE_CLOSE = 8,
	CSIO_RNFE_NAME_MISSING = 9,
	CSIO_RNFE_MAX_EVENT = 10,
};

enum csio_scsi_ev {
	CSIO_SCSIE_START_IO = 1,
	CSIO_SCSIE_START_TM = 2,
	CSIO_SCSIE_COMPLETED = 3,
	CSIO_SCSIE_ABORT = 4,
	CSIO_SCSIE_ABORTED = 5,
	CSIO_SCSIE_CLOSE = 6,
	CSIO_SCSIE_CLOSED = 7,
	CSIO_SCSIE_DRVCLEANUP = 8,
};

enum csio_scsi_lev {
	CSIO_LEV_ALL = 1,
	CSIO_LEV_LNODE = 2,
	CSIO_LEV_RNODE = 3,
	CSIO_LEV_LUN = 4,
};

enum ct_dccp_states {
	CT_DCCP_NONE = 0,
	CT_DCCP_REQUEST = 1,
	CT_DCCP_RESPOND = 2,
	CT_DCCP_PARTOPEN = 3,
	CT_DCCP_OPEN = 4,
	CT_DCCP_CLOSEREQ = 5,
	CT_DCCP_CLOSING = 6,
	CT_DCCP_TIMEWAIT = 7,
	CT_DCCP_IGNORE = 8,
	CT_DCCP_INVALID = 9,
	__CT_DCCP_MAX = 10,
};

enum ct_format {
	SSP_F_H = 0,
	SSP_F_IU = 24,
	SSP_F_MAX = 77,
	STP_CMD_FIS = 0,
	STP_ATAPI_CMD = 64,
	STP_F_MAX = 16,
	SMP_F_T = 0,
	SMP_F_DEP = 1,
	SMP_F_MAX = 257,
};

enum ctlr_enabled_state {
	FCOE_CTLR_ENABLED = 0,
	FCOE_CTLR_DISABLED = 1,
	FCOE_CTLR_UNUSED = 2,
};

enum ctrl_offsets {
	BASE_OFFSET = 0,
	SLOT_AVAIL1 = 4,
	SLOT_AVAIL2 = 8,
	SLOT_CONFIG = 12,
	SEC_BUS_CONFIG = 16,
	MSI_CTRL = 18,
	PROG_INTERFACE = 19,
	CMD = 20,
	CMD_STATUS = 22,
	INTR_LOC = 24,
	SERR_LOC = 28,
	SERR_INTR_ENABLE = 32,
	SLOT1 = 36,
};

enum ctx_state {
	CONTEXT_DISABLED = -1,
	CONTEXT_KERNEL = 0,
	CONTEXT_IDLE = 1,
	CONTEXT_USER = 2,
	CONTEXT_GUEST = 3,
	CONTEXT_MAX = 4,
};

enum cxgb4_uld {
	CXGB4_ULD_INIT = 0,
	CXGB4_ULD_RDMA = 1,
	CXGB4_ULD_ISCSI = 2,
	CXGB4_ULD_ISCSIT = 3,
	CXGB4_ULD_CRYPTO = 4,
	CXGB4_ULD_IPSEC = 5,
	CXGB4_ULD_TLS = 6,
	CXGB4_ULD_KTLS = 7,
	CXGB4_ULD_MAX = 8,
};

enum cxgbi_dbg_flag {
	CXGBI_DBG_ISCSI = 0,
	CXGBI_DBG_DDP = 1,
	CXGBI_DBG_TOE = 2,
	CXGBI_DBG_SOCK = 3,
	CXGBI_DBG_PDU_TX = 4,
	CXGBI_DBG_PDU_RX = 5,
	CXGBI_DBG_DEV = 6,
};

enum cxgbi_skcb_flags {
	SKCBF_TX_NEED_HDR = 0,
	SKCBF_TX_MEM_WRITE = 1,
	SKCBF_TX_FLAG_COMPL = 2,
	SKCBF_RX_COALESCED = 3,
	SKCBF_RX_HDR = 4,
	SKCBF_RX_DATA = 5,
	SKCBF_RX_STATUS = 6,
	SKCBF_RX_ISCSI_COMPL = 7,
	SKCBF_RX_DATA_DDPD = 8,
	SKCBF_RX_HCRC_ERR = 9,
	SKCBF_RX_DCRC_ERR = 10,
	SKCBF_RX_PAD_ERR = 11,
	SKCBF_TX_ISO = 12,
};

enum cxgbi_sock_flags {
	CTPF_ABORT_RPL_RCVD = 0,
	CTPF_ABORT_REQ_RCVD = 1,
	CTPF_ABORT_RPL_PENDING = 2,
	CTPF_TX_DATA_SENT = 3,
	CTPF_ACTIVE_CLOSE_NEEDED = 4,
	CTPF_HAS_ATID = 5,
	CTPF_HAS_TID = 6,
	CTPF_OFFLOAD_DOWN = 7,
	CTPF_LOGOUT_RSP_RCVD = 8,
};

enum cxgbi_sock_states {
	CTP_CLOSED = 0,
	CTP_CONNECTING = 1,
	CTP_ACTIVE_OPEN = 2,
	CTP_ESTABLISHED = 3,
	CTP_ACTIVE_CLOSE = 4,
	CTP_PASSIVE_CLOSE = 5,
	CTP_CLOSE_WAIT_1 = 6,
	CTP_CLOSE_WAIT_2 = 7,
	CTP_ABORTING = 8,
};

enum cxl_context_status {
	CLOSED = 0,
	OPENED = 1,
	STARTED = 2,
};

enum d_real_type {
	D_REAL_DATA = 0,
	D_REAL_METADATA = 1,
};

enum d_walk_ret {
	D_WALK_CONTINUE = 0,
	D_WALK_QUIT = 1,
	D_WALK_NORETRY = 2,
	D_WALK_SKIP = 3,
};

enum da9052_chip_id {
	DA9052 = 0,
	DA9053_AA = 1,
	DA9053_BA = 2,
	DA9053_BB = 3,
	DA9053_BC = 4,
};

enum damon_ops_id {
	DAMON_OPS_VADDR = 0,
	DAMON_OPS_FVADDR = 1,
	DAMON_OPS_PADDR = 2,
	NR_DAMON_OPS = 3,
};

enum damon_sysfs_cmd {
	DAMON_SYSFS_CMD_ON = 0,
	DAMON_SYSFS_CMD_OFF = 1,
	DAMON_SYSFS_CMD_COMMIT = 2,
	DAMON_SYSFS_CMD_COMMIT_SCHEMES_QUOTA_GOALS = 3,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_STATS = 4,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_TRIED_BYTES = 5,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_TRIED_REGIONS = 6,
	DAMON_SYSFS_CMD_CLEAR_SCHEMES_TRIED_REGIONS = 7,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_EFFECTIVE_QUOTAS = 8,
	NR_DAMON_SYSFS_CMDS = 9,
};

enum damos_action {
	DAMOS_WILLNEED = 0,
	DAMOS_COLD = 1,
	DAMOS_PAGEOUT = 2,
	DAMOS_HUGEPAGE = 3,
	DAMOS_NOHUGEPAGE = 4,
	DAMOS_LRU_PRIO = 5,
	DAMOS_LRU_DEPRIO = 6,
	DAMOS_STAT = 7,
	NR_DAMOS_ACTIONS = 8,
};

enum damos_filter_type {
	DAMOS_FILTER_TYPE_ANON = 0,
	DAMOS_FILTER_TYPE_MEMCG = 1,
	DAMOS_FILTER_TYPE_YOUNG = 2,
	DAMOS_FILTER_TYPE_ADDR = 3,
	DAMOS_FILTER_TYPE_TARGET = 4,
	NR_DAMOS_FILTER_TYPES = 5,
};

enum damos_quota_goal_metric {
	DAMOS_QUOTA_USER_INPUT = 0,
	DAMOS_QUOTA_SOME_MEM_PSI_US = 1,
	NR_DAMOS_QUOTA_GOAL_METRICS = 2,
};

enum damos_sysfs_regions_upd_status {
	DAMOS_TRIED_REGIONS_UPD_IDLE = 0,
	DAMOS_TRIED_REGIONS_UPD_STARTED = 1,
	DAMOS_TRIED_REGIONS_UPD_FINISHED = 2,
};

enum damos_wmark_metric {
	DAMOS_WMARK_NONE = 0,
	DAMOS_WMARK_FREE_MEM_RATE = 1,
	NR_DAMOS_WMARK_METRICS = 2,
};

enum data_direction {
	DATA_DIR_NONE = 0,
	DATA_DIR_IN = 1,
	DATA_DIR_OUT = 2,
	DATA_DIR_BYRECIPIENT = 4,
};

enum data_source {
	CM_BATTERY_PRESENT = 0,
	CM_NO_BATTERY = 1,
	CM_FUEL_GAUGE = 2,
	CM_CHARGER_STAT = 3,
};

enum dax_access_mode {
	DAX_ACCESS = 0,
	DAX_RECOVERY_WRITE = 1,
};

enum dax_device_flags {
	DAXDEV_ALIVE = 0,
	DAXDEV_WRITE_CACHE = 1,
	DAXDEV_SYNC = 2,
	DAXDEV_NOCACHE = 3,
	DAXDEV_NOMC = 4,
};

enum dax_driver_type {
	DAXDRV_KMEM_TYPE = 0,
	DAXDRV_DEVICE_TYPE = 1,
};

enum dax_wake_mode {
	WAKE_ALL = 0,
	WAKE_NEXT = 1,
};

enum db_flags_t {
	EDB_ACTIVE = 1,
};

enum dcb_general_attr_values {
	DCB_ATTR_VALUE_UNDEFINED = 255,
};

enum dcbevent_notif_type {
	DCB_APP_EVENT = 1,
};

enum dcbnl_app_attrs {
	DCB_APP_ATTR_UNDEFINED = 0,
	DCB_APP_ATTR_IDTYPE = 1,
	DCB_APP_ATTR_ID = 2,
	DCB_APP_ATTR_PRIORITY = 3,
	__DCB_APP_ATTR_ENUM_MAX = 4,
	DCB_APP_ATTR_MAX = 3,
};

enum dcbnl_attrs {
	DCB_ATTR_UNDEFINED = 0,
	DCB_ATTR_IFNAME = 1,
	DCB_ATTR_STATE = 2,
	DCB_ATTR_PFC_STATE = 3,
	DCB_ATTR_PFC_CFG = 4,
	DCB_ATTR_NUM_TC = 5,
	DCB_ATTR_PG_CFG = 6,
	DCB_ATTR_SET_ALL = 7,
	DCB_ATTR_PERM_HWADDR = 8,
	DCB_ATTR_CAP = 9,
	DCB_ATTR_NUMTCS = 10,
	DCB_ATTR_BCN = 11,
	DCB_ATTR_APP = 12,
	DCB_ATTR_IEEE = 13,
	DCB_ATTR_DCBX = 14,
	DCB_ATTR_FEATCFG = 15,
	DCB_ATTR_CEE = 16,
	__DCB_ATTR_ENUM_MAX = 17,
	DCB_ATTR_MAX = 16,
};

enum dcbnl_bcn_attrs {
	DCB_BCN_ATTR_UNDEFINED = 0,
	DCB_BCN_ATTR_RP_0 = 1,
	DCB_BCN_ATTR_RP_1 = 2,
	DCB_BCN_ATTR_RP_2 = 3,
	DCB_BCN_ATTR_RP_3 = 4,
	DCB_BCN_ATTR_RP_4 = 5,
	DCB_BCN_ATTR_RP_5 = 6,
	DCB_BCN_ATTR_RP_6 = 7,
	DCB_BCN_ATTR_RP_7 = 8,
	DCB_BCN_ATTR_RP_ALL = 9,
	DCB_BCN_ATTR_BCNA_0 = 10,
	DCB_BCN_ATTR_BCNA_1 = 11,
	DCB_BCN_ATTR_ALPHA = 12,
	DCB_BCN_ATTR_BETA = 13,
	DCB_BCN_ATTR_GD = 14,
	DCB_BCN_ATTR_GI = 15,
	DCB_BCN_ATTR_TMAX = 16,
	DCB_BCN_ATTR_TD = 17,
	DCB_BCN_ATTR_RMIN = 18,
	DCB_BCN_ATTR_W = 19,
	DCB_BCN_ATTR_RD = 20,
	DCB_BCN_ATTR_RU = 21,
	DCB_BCN_ATTR_WRTT = 22,
	DCB_BCN_ATTR_RI = 23,
	DCB_BCN_ATTR_C = 24,
	DCB_BCN_ATTR_ALL = 25,
	__DCB_BCN_ATTR_ENUM_MAX = 26,
	DCB_BCN_ATTR_MAX = 25,
};

enum dcbnl_cap_attrs {
	DCB_CAP_ATTR_UNDEFINED = 0,
	DCB_CAP_ATTR_ALL = 1,
	DCB_CAP_ATTR_PG = 2,
	DCB_CAP_ATTR_PFC = 3,
	DCB_CAP_ATTR_UP2TC = 4,
	DCB_CAP_ATTR_PG_TCS = 5,
	DCB_CAP_ATTR_PFC_TCS = 6,
	DCB_CAP_ATTR_GSP = 7,
	DCB_CAP_ATTR_BCN = 8,
	DCB_CAP_ATTR_DCBX = 9,
	__DCB_CAP_ATTR_ENUM_MAX = 10,
	DCB_CAP_ATTR_MAX = 9,
};

enum dcbnl_commands {
	DCB_CMD_UNDEFINED = 0,
	DCB_CMD_GSTATE = 1,
	DCB_CMD_SSTATE = 2,
	DCB_CMD_PGTX_GCFG = 3,
	DCB_CMD_PGTX_SCFG = 4,
	DCB_CMD_PGRX_GCFG = 5,
	DCB_CMD_PGRX_SCFG = 6,
	DCB_CMD_PFC_GCFG = 7,
	DCB_CMD_PFC_SCFG = 8,
	DCB_CMD_SET_ALL = 9,
	DCB_CMD_GPERM_HWADDR = 10,
	DCB_CMD_GCAP = 11,
	DCB_CMD_GNUMTCS = 12,
	DCB_CMD_SNUMTCS = 13,
	DCB_CMD_PFC_GSTATE = 14,
	DCB_CMD_PFC_SSTATE = 15,
	DCB_CMD_BCN_GCFG = 16,
	DCB_CMD_BCN_SCFG = 17,
	DCB_CMD_GAPP = 18,
	DCB_CMD_SAPP = 19,
	DCB_CMD_IEEE_SET = 20,
	DCB_CMD_IEEE_GET = 21,
	DCB_CMD_GDCBX = 22,
	DCB_CMD_SDCBX = 23,
	DCB_CMD_GFEATCFG = 24,
	DCB_CMD_SFEATCFG = 25,
	DCB_CMD_CEE_GET = 26,
	DCB_CMD_IEEE_DEL = 27,
	__DCB_CMD_ENUM_MAX = 28,
	DCB_CMD_MAX = 27,
};

enum dcbnl_featcfg_attrs {
	DCB_FEATCFG_ATTR_UNDEFINED = 0,
	DCB_FEATCFG_ATTR_ALL = 1,
	DCB_FEATCFG_ATTR_PG = 2,
	DCB_FEATCFG_ATTR_PFC = 3,
	DCB_FEATCFG_ATTR_APP = 4,
	__DCB_FEATCFG_ATTR_ENUM_MAX = 5,
	DCB_FEATCFG_ATTR_MAX = 4,
};

enum dcbnl_numtcs_attrs {
	DCB_NUMTCS_ATTR_UNDEFINED = 0,
	DCB_NUMTCS_ATTR_ALL = 1,
	DCB_NUMTCS_ATTR_PG = 2,
	DCB_NUMTCS_ATTR_PFC = 3,
	__DCB_NUMTCS_ATTR_ENUM_MAX = 4,
	DCB_NUMTCS_ATTR_MAX = 3,
};

enum dcbnl_pfc_up_attrs {
	DCB_PFC_UP_ATTR_UNDEFINED = 0,
	DCB_PFC_UP_ATTR_0 = 1,
	DCB_PFC_UP_ATTR_1 = 2,
	DCB_PFC_UP_ATTR_2 = 3,
	DCB_PFC_UP_ATTR_3 = 4,
	DCB_PFC_UP_ATTR_4 = 5,
	DCB_PFC_UP_ATTR_5 = 6,
	DCB_PFC_UP_ATTR_6 = 7,
	DCB_PFC_UP_ATTR_7 = 8,
	DCB_PFC_UP_ATTR_ALL = 9,
	__DCB_PFC_UP_ATTR_ENUM_MAX = 10,
	DCB_PFC_UP_ATTR_MAX = 9,
};

enum dcbnl_pg_attrs {
	DCB_PG_ATTR_UNDEFINED = 0,
	DCB_PG_ATTR_TC_0 = 1,
	DCB_PG_ATTR_TC_1 = 2,
	DCB_PG_ATTR_TC_2 = 3,
	DCB_PG_ATTR_TC_3 = 4,
	DCB_PG_ATTR_TC_4 = 5,
	DCB_PG_ATTR_TC_5 = 6,
	DCB_PG_ATTR_TC_6 = 7,
	DCB_PG_ATTR_TC_7 = 8,
	DCB_PG_ATTR_TC_MAX = 9,
	DCB_PG_ATTR_TC_ALL = 10,
	DCB_PG_ATTR_BW_ID_0 = 11,
	DCB_PG_ATTR_BW_ID_1 = 12,
	DCB_PG_ATTR_BW_ID_2 = 13,
	DCB_PG_ATTR_BW_ID_3 = 14,
	DCB_PG_ATTR_BW_ID_4 = 15,
	DCB_PG_ATTR_BW_ID_5 = 16,
	DCB_PG_ATTR_BW_ID_6 = 17,
	DCB_PG_ATTR_BW_ID_7 = 18,
	DCB_PG_ATTR_BW_ID_MAX = 19,
	DCB_PG_ATTR_BW_ID_ALL = 20,
	__DCB_PG_ATTR_ENUM_MAX = 21,
	DCB_PG_ATTR_MAX = 20,
};

enum dcbnl_tc_attrs {
	DCB_TC_ATTR_PARAM_UNDEFINED = 0,
	DCB_TC_ATTR_PARAM_PGID = 1,
	DCB_TC_ATTR_PARAM_UP_MAPPING = 2,
	DCB_TC_ATTR_PARAM_STRICT_PRIO = 3,
	DCB_TC_ATTR_PARAM_BW_PCT = 4,
	DCB_TC_ATTR_PARAM_ALL = 5,
	__DCB_TC_ATTR_PARAM_ENUM_MAX = 6,
	DCB_TC_ATTR_PARAM_MAX = 5,
};

enum dccp_state {
	DCCP_OPEN = 1,
	DCCP_REQUESTING = 2,
	DCCP_LISTEN = 10,
	DCCP_RESPOND = 3,
	DCCP_ACTIVE_CLOSEREQ = 4,
	DCCP_PASSIVE_CLOSE = 8,
	DCCP_CLOSING = 11,
	DCCP_TIME_WAIT = 6,
	DCCP_CLOSED = 7,
	DCCP_NEW_SYN_RECV = 12,
	DCCP_PARTOPEN = 14,
	DCCP_PASSIVE_CLOSEREQ = 15,
	DCCP_MAX_STATES = 16,
};

enum dd_data_dir {
	DD_READ = 0,
	DD_WRITE = 1,
};

enum dd_prio {
	DD_RT_PRIO = 0,
	DD_BE_PRIO = 1,
	DD_IDLE_PRIO = 2,
	DD_PRIO_MAX = 2,
};

enum dentry_d_lock_class {
	DENTRY_D_LOCK_NORMAL = 0,
	DENTRY_D_LOCK_NESTED = 1,
};

enum depot_counter_id {
	DEPOT_COUNTER_REFD_ALLOCS = 0,
	DEPOT_COUNTER_REFD_FREES = 1,
	DEPOT_COUNTER_REFD_INUSE = 2,
	DEPOT_COUNTER_FREELIST_SIZE = 3,
	DEPOT_COUNTER_PERSIST_COUNT = 4,
	DEPOT_COUNTER_PERSIST_BYTES = 5,
	DEPOT_COUNTER_COUNT = 6,
};

enum desc_header_offset {
	QUERY_DESC_LENGTH_OFFSET = 0,
	QUERY_DESC_DESC_TYPE_OFFSET = 1,
};

enum desc_idn {
	QUERY_DESC_IDN_DEVICE = 0,
	QUERY_DESC_IDN_CONFIGURATION = 1,
	QUERY_DESC_IDN_UNIT = 2,
	QUERY_DESC_IDN_RFU_0 = 3,
	QUERY_DESC_IDN_INTERCONNECT = 4,
	QUERY_DESC_IDN_STRING = 5,
	QUERY_DESC_IDN_RFU_1 = 6,
	QUERY_DESC_IDN_GEOMETRY = 7,
	QUERY_DESC_IDN_POWER = 8,
	QUERY_DESC_IDN_HEALTH = 9,
	QUERY_DESC_IDN_MAX = 10,
};

enum desc_state {
	desc_miss = -1,
	desc_reserved = 0,
	desc_committed = 1,
	desc_finalized = 2,
	desc_reusable = 3,
};

enum dev_cmd_type {
	DEV_CMD_TYPE_NOP = 0,
	DEV_CMD_TYPE_QUERY = 1,
	DEV_CMD_TYPE_RPMB = 2,
};

enum dev_dma_attr {
	DEV_DMA_NOT_SUPPORTED = 0,
	DEV_DMA_NON_COHERENT = 1,
	DEV_DMA_COHERENT = 2,
};

enum dev_pm_opp_event {
	OPP_EVENT_ADD = 0,
	OPP_EVENT_REMOVE = 1,
	OPP_EVENT_ENABLE = 2,
	OPP_EVENT_DISABLE = 3,
	OPP_EVENT_ADJUST_VOLTAGE = 4,
};

enum dev_pm_qos_req_type {
	DEV_PM_QOS_RESUME_LATENCY = 1,
	DEV_PM_QOS_LATENCY_TOLERANCE = 2,
	DEV_PM_QOS_MIN_FREQUENCY = 3,
	DEV_PM_QOS_MAX_FREQUENCY = 4,
	DEV_PM_QOS_FLAGS = 5,
};

enum dev_prop_type {
	DEV_PROP_U8 = 0,
	DEV_PROP_U16 = 1,
	DEV_PROP_U32 = 2,
	DEV_PROP_U64 = 3,
	DEV_PROP_STRING = 4,
	DEV_PROP_REF = 5,
};

enum dev_reset {
	MVS_SOFT_RESET = 0,
	MVS_HARD_RESET = 1,
	MVS_PHY_TUNE = 2,
};

enum dev_status {
	MVS_DEV_NORMAL = 0,
	MVS_DEV_EH = 1,
};

enum devcg_behavior {
	DEVCG_DEFAULT_NONE = 0,
	DEVCG_DEFAULT_ALLOW = 1,
	DEVCG_DEFAULT_DENY = 2,
};

enum devfreq_parent_dev_type {
	DEVFREQ_PARENT_DEV = 0,
	CPUFREQ_PARENT_DEV = 1,
};

enum devfreq_timer {
	DEVFREQ_TIMER_DEFERRABLE = 0,
	DEVFREQ_TIMER_DELAYED = 1,
	DEVFREQ_TIMER_NUM = 2,
};

enum device_desc_param {
	DEVICE_DESC_PARAM_LEN = 0,
	DEVICE_DESC_PARAM_TYPE = 1,
	DEVICE_DESC_PARAM_DEVICE_TYPE = 2,
	DEVICE_DESC_PARAM_DEVICE_CLASS = 3,
	DEVICE_DESC_PARAM_DEVICE_SUB_CLASS = 4,
	DEVICE_DESC_PARAM_PRTCL = 5,
	DEVICE_DESC_PARAM_NUM_LU = 6,
	DEVICE_DESC_PARAM_NUM_WLU = 7,
	DEVICE_DESC_PARAM_BOOT_ENBL = 8,
	DEVICE_DESC_PARAM_DESC_ACCSS_ENBL = 9,
	DEVICE_DESC_PARAM_INIT_PWR_MODE = 10,
	DEVICE_DESC_PARAM_HIGH_PR_LUN = 11,
	DEVICE_DESC_PARAM_SEC_RMV_TYPE = 12,
	DEVICE_DESC_PARAM_SEC_LU = 13,
	DEVICE_DESC_PARAM_BKOP_TERM_LT = 14,
	DEVICE_DESC_PARAM_ACTVE_ICC_LVL = 15,
	DEVICE_DESC_PARAM_SPEC_VER = 16,
	DEVICE_DESC_PARAM_MANF_DATE = 18,
	DEVICE_DESC_PARAM_MANF_NAME = 20,
	DEVICE_DESC_PARAM_PRDCT_NAME = 21,
	DEVICE_DESC_PARAM_SN = 22,
	DEVICE_DESC_PARAM_OEM_ID = 23,
	DEVICE_DESC_PARAM_MANF_ID = 24,
	DEVICE_DESC_PARAM_UD_OFFSET = 26,
	DEVICE_DESC_PARAM_UD_LEN = 27,
	DEVICE_DESC_PARAM_RTT_CAP = 28,
	DEVICE_DESC_PARAM_FRQ_RTC = 29,
	DEVICE_DESC_PARAM_UFS_FEAT = 31,
	DEVICE_DESC_PARAM_FFU_TMT = 32,
	DEVICE_DESC_PARAM_Q_DPTH = 33,
	DEVICE_DESC_PARAM_DEV_VER = 34,
	DEVICE_DESC_PARAM_NUM_SEC_WPA = 36,
	DEVICE_DESC_PARAM_PSA_MAX_DATA = 37,
	DEVICE_DESC_PARAM_PSA_TMT = 41,
	DEVICE_DESC_PARAM_PRDCT_REV = 42,
	DEVICE_DESC_PARAM_HPB_VER = 64,
	DEVICE_DESC_PARAM_HPB_CONTROL = 66,
	DEVICE_DESC_PARAM_EXT_UFS_FEATURE_SUP = 79,
	DEVICE_DESC_PARAM_WB_PRESRV_USRSPC_EN = 83,
	DEVICE_DESC_PARAM_WB_TYPE = 84,
	DEVICE_DESC_PARAM_WB_SHARED_ALLOC_UNITS = 85,
};

enum device_link_state {
	DL_STATE_NONE = -1,
	DL_STATE_DORMANT = 0,
	DL_STATE_AVAILABLE = 1,
	DL_STATE_CONSUMER_PROBE = 2,
	DL_STATE_ACTIVE = 3,
	DL_STATE_SUPPLIER_UNBIND = 4,
};

enum device_physical_location_horizontal_position {
	DEVICE_HORI_POS_LEFT = 0,
	DEVICE_HORI_POS_CENTER = 1,
	DEVICE_HORI_POS_RIGHT = 2,
};

enum device_physical_location_panel {
	DEVICE_PANEL_TOP = 0,
	DEVICE_PANEL_BOTTOM = 1,
	DEVICE_PANEL_LEFT = 2,
	DEVICE_PANEL_RIGHT = 3,
	DEVICE_PANEL_FRONT = 4,
	DEVICE_PANEL_BACK = 5,
	DEVICE_PANEL_UNKNOWN = 6,
};

enum device_physical_location_vertical_position {
	DEVICE_VERT_POS_UPPER = 0,
	DEVICE_VERT_POS_CENTER = 1,
	DEVICE_VERT_POS_LOWER = 2,
};

enum device_removable {
	DEVICE_REMOVABLE_NOT_SUPPORTED = 0,
	DEVICE_REMOVABLE_UNKNOWN = 1,
	DEVICE_FIXED = 2,
	DEVICE_REMOVABLE = 3,
};

enum devkmsg_log_bits {
	__DEVKMSG_LOG_BIT_ON = 0,
	__DEVKMSG_LOG_BIT_OFF = 1,
	__DEVKMSG_LOG_BIT_LOCK = 2,
};

enum devkmsg_log_masks {
	DEVKMSG_LOG_MASK_ON = 1,
	DEVKMSG_LOG_MASK_OFF = 2,
	DEVKMSG_LOG_MASK_LOCK = 4,
};

enum devlink_attr {
	DEVLINK_ATTR_UNSPEC = 0,
	DEVLINK_ATTR_BUS_NAME = 1,
	DEVLINK_ATTR_DEV_NAME = 2,
	DEVLINK_ATTR_PORT_INDEX = 3,
	DEVLINK_ATTR_PORT_TYPE = 4,
	DEVLINK_ATTR_PORT_DESIRED_TYPE = 5,
	DEVLINK_ATTR_PORT_NETDEV_IFINDEX = 6,
	DEVLINK_ATTR_PORT_NETDEV_NAME = 7,
	DEVLINK_ATTR_PORT_IBDEV_NAME = 8,
	DEVLINK_ATTR_PORT_SPLIT_COUNT = 9,
	DEVLINK_ATTR_PORT_SPLIT_GROUP = 10,
	DEVLINK_ATTR_SB_INDEX = 11,
	DEVLINK_ATTR_SB_SIZE = 12,
	DEVLINK_ATTR_SB_INGRESS_POOL_COUNT = 13,
	DEVLINK_ATTR_SB_EGRESS_POOL_COUNT = 14,
	DEVLINK_ATTR_SB_INGRESS_TC_COUNT = 15,
	DEVLINK_ATTR_SB_EGRESS_TC_COUNT = 16,
	DEVLINK_ATTR_SB_POOL_INDEX = 17,
	DEVLINK_ATTR_SB_POOL_TYPE = 18,
	DEVLINK_ATTR_SB_POOL_SIZE = 19,
	DEVLINK_ATTR_SB_POOL_THRESHOLD_TYPE = 20,
	DEVLINK_ATTR_SB_THRESHOLD = 21,
	DEVLINK_ATTR_SB_TC_INDEX = 22,
	DEVLINK_ATTR_SB_OCC_CUR = 23,
	DEVLINK_ATTR_SB_OCC_MAX = 24,
	DEVLINK_ATTR_ESWITCH_MODE = 25,
	DEVLINK_ATTR_ESWITCH_INLINE_MODE = 26,
	DEVLINK_ATTR_DPIPE_TABLES = 27,
	DEVLINK_ATTR_DPIPE_TABLE = 28,
	DEVLINK_ATTR_DPIPE_TABLE_NAME = 29,
	DEVLINK_ATTR_DPIPE_TABLE_SIZE = 30,
	DEVLINK_ATTR_DPIPE_TABLE_MATCHES = 31,
	DEVLINK_ATTR_DPIPE_TABLE_ACTIONS = 32,
	DEVLINK_ATTR_DPIPE_TABLE_COUNTERS_ENABLED = 33,
	DEVLINK_ATTR_DPIPE_ENTRIES = 34,
	DEVLINK_ATTR_DPIPE_ENTRY = 35,
	DEVLINK_ATTR_DPIPE_ENTRY_INDEX = 36,
	DEVLINK_ATTR_DPIPE_ENTRY_MATCH_VALUES = 37,
	DEVLINK_ATTR_DPIPE_ENTRY_ACTION_VALUES = 38,
	DEVLINK_ATTR_DPIPE_ENTRY_COUNTER = 39,
	DEVLINK_ATTR_DPIPE_MATCH = 40,
	DEVLINK_ATTR_DPIPE_MATCH_VALUE = 41,
	DEVLINK_ATTR_DPIPE_MATCH_TYPE = 42,
	DEVLINK_ATTR_DPIPE_ACTION = 43,
	DEVLINK_ATTR_DPIPE_ACTION_VALUE = 44,
	DEVLINK_ATTR_DPIPE_ACTION_TYPE = 45,
	DEVLINK_ATTR_DPIPE_VALUE = 46,
	DEVLINK_ATTR_DPIPE_VALUE_MASK = 47,
	DEVLINK_ATTR_DPIPE_VALUE_MAPPING = 48,
	DEVLINK_ATTR_DPIPE_HEADERS = 49,
	DEVLINK_ATTR_DPIPE_HEADER = 50,
	DEVLINK_ATTR_DPIPE_HEADER_NAME = 51,
	DEVLINK_ATTR_DPIPE_HEADER_ID = 52,
	DEVLINK_ATTR_DPIPE_HEADER_FIELDS = 53,
	DEVLINK_ATTR_DPIPE_HEADER_GLOBAL = 54,
	DEVLINK_ATTR_DPIPE_HEADER_INDEX = 55,
	DEVLINK_ATTR_DPIPE_FIELD = 56,
	DEVLINK_ATTR_DPIPE_FIELD_NAME = 57,
	DEVLINK_ATTR_DPIPE_FIELD_ID = 58,
	DEVLINK_ATTR_DPIPE_FIELD_BITWIDTH = 59,
	DEVLINK_ATTR_DPIPE_FIELD_MAPPING_TYPE = 60,
	DEVLINK_ATTR_PAD = 61,
	DEVLINK_ATTR_ESWITCH_ENCAP_MODE = 62,
	DEVLINK_ATTR_RESOURCE_LIST = 63,
	DEVLINK_ATTR_RESOURCE = 64,
	DEVLINK_ATTR_RESOURCE_NAME = 65,
	DEVLINK_ATTR_RESOURCE_ID = 66,
	DEVLINK_ATTR_RESOURCE_SIZE = 67,
	DEVLINK_ATTR_RESOURCE_SIZE_NEW = 68,
	DEVLINK_ATTR_RESOURCE_SIZE_VALID = 69,
	DEVLINK_ATTR_RESOURCE_SIZE_MIN = 70,
	DEVLINK_ATTR_RESOURCE_SIZE_MAX = 71,
	DEVLINK_ATTR_RESOURCE_SIZE_GRAN = 72,
	DEVLINK_ATTR_RESOURCE_UNIT = 73,
	DEVLINK_ATTR_RESOURCE_OCC = 74,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_ID = 75,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_UNITS = 76,
	DEVLINK_ATTR_PORT_FLAVOUR = 77,
	DEVLINK_ATTR_PORT_NUMBER = 78,
	DEVLINK_ATTR_PORT_SPLIT_SUBPORT_NUMBER = 79,
	DEVLINK_ATTR_PARAM = 80,
	DEVLINK_ATTR_PARAM_NAME = 81,
	DEVLINK_ATTR_PARAM_GENERIC = 82,
	DEVLINK_ATTR_PARAM_TYPE = 83,
	DEVLINK_ATTR_PARAM_VALUES_LIST = 84,
	DEVLINK_ATTR_PARAM_VALUE = 85,
	DEVLINK_ATTR_PARAM_VALUE_DATA = 86,
	DEVLINK_ATTR_PARAM_VALUE_CMODE = 87,
	DEVLINK_ATTR_REGION_NAME = 88,
	DEVLINK_ATTR_REGION_SIZE = 89,
	DEVLINK_ATTR_REGION_SNAPSHOTS = 90,
	DEVLINK_ATTR_REGION_SNAPSHOT = 91,
	DEVLINK_ATTR_REGION_SNAPSHOT_ID = 92,
	DEVLINK_ATTR_REGION_CHUNKS = 93,
	DEVLINK_ATTR_REGION_CHUNK = 94,
	DEVLINK_ATTR_REGION_CHUNK_DATA = 95,
	DEVLINK_ATTR_REGION_CHUNK_ADDR = 96,
	DEVLINK_ATTR_REGION_CHUNK_LEN = 97,
	DEVLINK_ATTR_INFO_DRIVER_NAME = 98,
	DEVLINK_ATTR_INFO_SERIAL_NUMBER = 99,
	DEVLINK_ATTR_INFO_VERSION_FIXED = 100,
	DEVLINK_ATTR_INFO_VERSION_RUNNING = 101,
	DEVLINK_ATTR_INFO_VERSION_STORED = 102,
	DEVLINK_ATTR_INFO_VERSION_NAME = 103,
	DEVLINK_ATTR_INFO_VERSION_VALUE = 104,
	DEVLINK_ATTR_SB_POOL_CELL_SIZE = 105,
	DEVLINK_ATTR_FMSG = 106,
	DEVLINK_ATTR_FMSG_OBJ_NEST_START = 107,
	DEVLINK_ATTR_FMSG_PAIR_NEST_START = 108,
	DEVLINK_ATTR_FMSG_ARR_NEST_START = 109,
	DEVLINK_ATTR_FMSG_NEST_END = 110,
	DEVLINK_ATTR_FMSG_OBJ_NAME = 111,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_TYPE = 112,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_DATA = 113,
	DEVLINK_ATTR_HEALTH_REPORTER = 114,
	DEVLINK_ATTR_HEALTH_REPORTER_NAME = 115,
	DEVLINK_ATTR_HEALTH_REPORTER_STATE = 116,
	DEVLINK_ATTR_HEALTH_REPORTER_ERR_COUNT = 117,
	DEVLINK_ATTR_HEALTH_REPORTER_RECOVER_COUNT = 118,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS = 119,
	DEVLINK_ATTR_HEALTH_REPORTER_GRACEFUL_PERIOD = 120,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_RECOVER = 121,
	DEVLINK_ATTR_FLASH_UPDATE_FILE_NAME = 122,
	DEVLINK_ATTR_FLASH_UPDATE_COMPONENT = 123,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_MSG = 124,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_DONE = 125,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TOTAL = 126,
	DEVLINK_ATTR_PORT_PCI_PF_NUMBER = 127,
	DEVLINK_ATTR_PORT_PCI_VF_NUMBER = 128,
	DEVLINK_ATTR_STATS = 129,
	DEVLINK_ATTR_TRAP_NAME = 130,
	DEVLINK_ATTR_TRAP_ACTION = 131,
	DEVLINK_ATTR_TRAP_TYPE = 132,
	DEVLINK_ATTR_TRAP_GENERIC = 133,
	DEVLINK_ATTR_TRAP_METADATA = 134,
	DEVLINK_ATTR_TRAP_GROUP_NAME = 135,
	DEVLINK_ATTR_RELOAD_FAILED = 136,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS_NS = 137,
	DEVLINK_ATTR_NETNS_FD = 138,
	DEVLINK_ATTR_NETNS_PID = 139,
	DEVLINK_ATTR_NETNS_ID = 140,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_DUMP = 141,
	DEVLINK_ATTR_TRAP_POLICER_ID = 142,
	DEVLINK_ATTR_TRAP_POLICER_RATE = 143,
	DEVLINK_ATTR_TRAP_POLICER_BURST = 144,
	DEVLINK_ATTR_PORT_FUNCTION = 145,
	DEVLINK_ATTR_INFO_BOARD_SERIAL_NUMBER = 146,
	DEVLINK_ATTR_PORT_LANES = 147,
	DEVLINK_ATTR_PORT_SPLITTABLE = 148,
	DEVLINK_ATTR_PORT_EXTERNAL = 149,
	DEVLINK_ATTR_PORT_CONTROLLER_NUMBER = 150,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TIMEOUT = 151,
	DEVLINK_ATTR_FLASH_UPDATE_OVERWRITE_MASK = 152,
	DEVLINK_ATTR_RELOAD_ACTION = 153,
	DEVLINK_ATTR_RELOAD_ACTIONS_PERFORMED = 154,
	DEVLINK_ATTR_RELOAD_LIMITS = 155,
	DEVLINK_ATTR_DEV_STATS = 156,
	DEVLINK_ATTR_RELOAD_STATS = 157,
	DEVLINK_ATTR_RELOAD_STATS_ENTRY = 158,
	DEVLINK_ATTR_RELOAD_STATS_LIMIT = 159,
	DEVLINK_ATTR_RELOAD_STATS_VALUE = 160,
	DEVLINK_ATTR_REMOTE_RELOAD_STATS = 161,
	DEVLINK_ATTR_RELOAD_ACTION_INFO = 162,
	DEVLINK_ATTR_RELOAD_ACTION_STATS = 163,
	DEVLINK_ATTR_PORT_PCI_SF_NUMBER = 164,
	DEVLINK_ATTR_RATE_TYPE = 165,
	DEVLINK_ATTR_RATE_TX_SHARE = 166,
	DEVLINK_ATTR_RATE_TX_MAX = 167,
	DEVLINK_ATTR_RATE_NODE_NAME = 168,
	DEVLINK_ATTR_RATE_PARENT_NODE_NAME = 169,
	DEVLINK_ATTR_REGION_MAX_SNAPSHOTS = 170,
	DEVLINK_ATTR_LINECARD_INDEX = 171,
	DEVLINK_ATTR_LINECARD_STATE = 172,
	DEVLINK_ATTR_LINECARD_TYPE = 173,
	DEVLINK_ATTR_LINECARD_SUPPORTED_TYPES = 174,
	DEVLINK_ATTR_NESTED_DEVLINK = 175,
	DEVLINK_ATTR_SELFTESTS = 176,
	DEVLINK_ATTR_RATE_TX_PRIORITY = 177,
	DEVLINK_ATTR_RATE_TX_WEIGHT = 178,
	DEVLINK_ATTR_REGION_DIRECT = 179,
	__DEVLINK_ATTR_MAX = 180,
	DEVLINK_ATTR_MAX = 179,
};

enum devlink_attr_selftest_id {
	DEVLINK_ATTR_SELFTEST_ID_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_ID_FLASH = 1,
	__DEVLINK_ATTR_SELFTEST_ID_MAX = 2,
	DEVLINK_ATTR_SELFTEST_ID_MAX = 1,
};

enum devlink_attr_selftest_result {
	DEVLINK_ATTR_SELFTEST_RESULT_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_RESULT = 1,
	DEVLINK_ATTR_SELFTEST_RESULT_ID = 2,
	DEVLINK_ATTR_SELFTEST_RESULT_STATUS = 3,
	__DEVLINK_ATTR_SELFTEST_RESULT_MAX = 4,
	DEVLINK_ATTR_SELFTEST_RESULT_MAX = 3,
};

enum devlink_command {
	DEVLINK_CMD_UNSPEC = 0,
	DEVLINK_CMD_GET = 1,
	DEVLINK_CMD_SET = 2,
	DEVLINK_CMD_NEW = 3,
	DEVLINK_CMD_DEL = 4,
	DEVLINK_CMD_PORT_GET = 5,
	DEVLINK_CMD_PORT_SET = 6,
	DEVLINK_CMD_PORT_NEW = 7,
	DEVLINK_CMD_PORT_DEL = 8,
	DEVLINK_CMD_PORT_SPLIT = 9,
	DEVLINK_CMD_PORT_UNSPLIT = 10,
	DEVLINK_CMD_SB_GET = 11,
	DEVLINK_CMD_SB_SET = 12,
	DEVLINK_CMD_SB_NEW = 13,
	DEVLINK_CMD_SB_DEL = 14,
	DEVLINK_CMD_SB_POOL_GET = 15,
	DEVLINK_CMD_SB_POOL_SET = 16,
	DEVLINK_CMD_SB_POOL_NEW = 17,
	DEVLINK_CMD_SB_POOL_DEL = 18,
	DEVLINK_CMD_SB_PORT_POOL_GET = 19,
	DEVLINK_CMD_SB_PORT_POOL_SET = 20,
	DEVLINK_CMD_SB_PORT_POOL_NEW = 21,
	DEVLINK_CMD_SB_PORT_POOL_DEL = 22,
	DEVLINK_CMD_SB_TC_POOL_BIND_GET = 23,
	DEVLINK_CMD_SB_TC_POOL_BIND_SET = 24,
	DEVLINK_CMD_SB_TC_POOL_BIND_NEW = 25,
	DEVLINK_CMD_SB_TC_POOL_BIND_DEL = 26,
	DEVLINK_CMD_SB_OCC_SNAPSHOT = 27,
	DEVLINK_CMD_SB_OCC_MAX_CLEAR = 28,
	DEVLINK_CMD_ESWITCH_GET = 29,
	DEVLINK_CMD_ESWITCH_SET = 30,
	DEVLINK_CMD_DPIPE_TABLE_GET = 31,
	DEVLINK_CMD_DPIPE_ENTRIES_GET = 32,
	DEVLINK_CMD_DPIPE_HEADERS_GET = 33,
	DEVLINK_CMD_DPIPE_TABLE_COUNTERS_SET = 34,
	DEVLINK_CMD_RESOURCE_SET = 35,
	DEVLINK_CMD_RESOURCE_DUMP = 36,
	DEVLINK_CMD_RELOAD = 37,
	DEVLINK_CMD_PARAM_GET = 38,
	DEVLINK_CMD_PARAM_SET = 39,
	DEVLINK_CMD_PARAM_NEW = 40,
	DEVLINK_CMD_PARAM_DEL = 41,
	DEVLINK_CMD_REGION_GET = 42,
	DEVLINK_CMD_REGION_SET = 43,
	DEVLINK_CMD_REGION_NEW = 44,
	DEVLINK_CMD_REGION_DEL = 45,
	DEVLINK_CMD_REGION_READ = 46,
	DEVLINK_CMD_PORT_PARAM_GET = 47,
	DEVLINK_CMD_PORT_PARAM_SET = 48,
	DEVLINK_CMD_PORT_PARAM_NEW = 49,
	DEVLINK_CMD_PORT_PARAM_DEL = 50,
	DEVLINK_CMD_INFO_GET = 51,
	DEVLINK_CMD_HEALTH_REPORTER_GET = 52,
	DEVLINK_CMD_HEALTH_REPORTER_SET = 53,
	DEVLINK_CMD_HEALTH_REPORTER_RECOVER = 54,
	DEVLINK_CMD_HEALTH_REPORTER_DIAGNOSE = 55,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_GET = 56,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_CLEAR = 57,
	DEVLINK_CMD_FLASH_UPDATE = 58,
	DEVLINK_CMD_FLASH_UPDATE_END = 59,
	DEVLINK_CMD_FLASH_UPDATE_STATUS = 60,
	DEVLINK_CMD_TRAP_GET = 61,
	DEVLINK_CMD_TRAP_SET = 62,
	DEVLINK_CMD_TRAP_NEW = 63,
	DEVLINK_CMD_TRAP_DEL = 64,
	DEVLINK_CMD_TRAP_GROUP_GET = 65,
	DEVLINK_CMD_TRAP_GROUP_SET = 66,
	DEVLINK_CMD_TRAP_GROUP_NEW = 67,
	DEVLINK_CMD_TRAP_GROUP_DEL = 68,
	DEVLINK_CMD_TRAP_POLICER_GET = 69,
	DEVLINK_CMD_TRAP_POLICER_SET = 70,
	DEVLINK_CMD_TRAP_POLICER_NEW = 71,
	DEVLINK_CMD_TRAP_POLICER_DEL = 72,
	DEVLINK_CMD_HEALTH_REPORTER_TEST = 73,
	DEVLINK_CMD_RATE_GET = 74,
	DEVLINK_CMD_RATE_SET = 75,
	DEVLINK_CMD_RATE_NEW = 76,
	DEVLINK_CMD_RATE_DEL = 77,
	DEVLINK_CMD_LINECARD_GET = 78,
	DEVLINK_CMD_LINECARD_SET = 79,
	DEVLINK_CMD_LINECARD_NEW = 80,
	DEVLINK_CMD_LINECARD_DEL = 81,
	DEVLINK_CMD_SELFTESTS_GET = 82,
	DEVLINK_CMD_SELFTESTS_RUN = 83,
	DEVLINK_CMD_NOTIFY_FILTER_SET = 84,
	__DEVLINK_CMD_MAX = 85,
	DEVLINK_CMD_MAX = 84,
};

enum devlink_dpipe_action_type {
	DEVLINK_DPIPE_ACTION_TYPE_FIELD_MODIFY = 0,
};

enum devlink_dpipe_field_ethernet_id {
	DEVLINK_DPIPE_FIELD_ETHERNET_DST_MAC = 0,
};

enum devlink_dpipe_field_ipv4_id {
	DEVLINK_DPIPE_FIELD_IPV4_DST_IP = 0,
};

enum devlink_dpipe_field_ipv6_id {
	DEVLINK_DPIPE_FIELD_IPV6_DST_IP = 0,
};

enum devlink_dpipe_field_mapping_type {
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_NONE = 0,
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_IFINDEX = 1,
};

enum devlink_dpipe_header_id {
	DEVLINK_DPIPE_HEADER_ETHERNET = 0,
	DEVLINK_DPIPE_HEADER_IPV4 = 1,
	DEVLINK_DPIPE_HEADER_IPV6 = 2,
};

enum devlink_dpipe_match_type {
	DEVLINK_DPIPE_MATCH_TYPE_FIELD_EXACT = 0,
};

enum devlink_eswitch_encap_mode {
	DEVLINK_ESWITCH_ENCAP_MODE_NONE = 0,
	DEVLINK_ESWITCH_ENCAP_MODE_BASIC = 1,
};

enum devlink_health_reporter_state {
	DEVLINK_HEALTH_REPORTER_STATE_HEALTHY = 0,
	DEVLINK_HEALTH_REPORTER_STATE_ERROR = 1,
};

enum devlink_info_version_type {
	DEVLINK_INFO_VERSION_TYPE_NONE = 0,
	DEVLINK_INFO_VERSION_TYPE_COMPONENT = 1,
};

enum devlink_linecard_state {
	DEVLINK_LINECARD_STATE_UNSPEC = 0,
	DEVLINK_LINECARD_STATE_UNPROVISIONED = 1,
	DEVLINK_LINECARD_STATE_UNPROVISIONING = 2,
	DEVLINK_LINECARD_STATE_PROVISIONING = 3,
	DEVLINK_LINECARD_STATE_PROVISIONING_FAILED = 4,
	DEVLINK_LINECARD_STATE_PROVISIONED = 5,
	DEVLINK_LINECARD_STATE_ACTIVE = 6,
	__DEVLINK_LINECARD_STATE_MAX = 7,
	DEVLINK_LINECARD_STATE_MAX = 6,
};

enum devlink_multicast_groups {
	DEVLINK_MCGRP_CONFIG = 0,
};

enum devlink_param_cmode {
	DEVLINK_PARAM_CMODE_RUNTIME = 0,
	DEVLINK_PARAM_CMODE_DRIVERINIT = 1,
	DEVLINK_PARAM_CMODE_PERMANENT = 2,
	__DEVLINK_PARAM_CMODE_MAX = 3,
	DEVLINK_PARAM_CMODE_MAX = 2,
};

enum devlink_param_generic_id {
	DEVLINK_PARAM_GENERIC_ID_INT_ERR_RESET = 0,
	DEVLINK_PARAM_GENERIC_ID_MAX_MACS = 1,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_SRIOV = 2,
	DEVLINK_PARAM_GENERIC_ID_REGION_SNAPSHOT = 3,
	DEVLINK_PARAM_GENERIC_ID_IGNORE_ARI = 4,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MAX = 5,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MIN = 6,
	DEVLINK_PARAM_GENERIC_ID_FW_LOAD_POLICY = 7,
	DEVLINK_PARAM_GENERIC_ID_RESET_DEV_ON_DRV_PROBE = 8,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ROCE = 9,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_REMOTE_DEV_RESET = 10,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ETH = 11,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_RDMA = 12,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_VNET = 13,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_IWARP = 14,
	DEVLINK_PARAM_GENERIC_ID_IO_EQ_SIZE = 15,
	DEVLINK_PARAM_GENERIC_ID_EVENT_EQ_SIZE = 16,
	__DEVLINK_PARAM_GENERIC_ID_MAX = 17,
	DEVLINK_PARAM_GENERIC_ID_MAX = 16,
};

enum devlink_param_type {
	DEVLINK_PARAM_TYPE_U8 = 0,
	DEVLINK_PARAM_TYPE_U16 = 1,
	DEVLINK_PARAM_TYPE_U32 = 2,
	DEVLINK_PARAM_TYPE_STRING = 3,
	DEVLINK_PARAM_TYPE_BOOL = 4,
};

enum devlink_port_flavour {
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0,
	DEVLINK_PORT_FLAVOUR_CPU = 1,
	DEVLINK_PORT_FLAVOUR_DSA = 2,
	DEVLINK_PORT_FLAVOUR_PCI_PF = 3,
	DEVLINK_PORT_FLAVOUR_PCI_VF = 4,
	DEVLINK_PORT_FLAVOUR_VIRTUAL = 5,
	DEVLINK_PORT_FLAVOUR_UNUSED = 6,
	DEVLINK_PORT_FLAVOUR_PCI_SF = 7,
};

enum devlink_port_fn_attr_cap {
	DEVLINK_PORT_FN_ATTR_CAP_ROCE_BIT = 0,
	DEVLINK_PORT_FN_ATTR_CAP_MIGRATABLE_BIT = 1,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_CRYPTO_BIT = 2,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_PACKET_BIT = 3,
	__DEVLINK_PORT_FN_ATTR_CAPS_MAX = 4,
};

enum devlink_port_fn_opstate {
	DEVLINK_PORT_FN_OPSTATE_DETACHED = 0,
	DEVLINK_PORT_FN_OPSTATE_ATTACHED = 1,
};

enum devlink_port_fn_state {
	DEVLINK_PORT_FN_STATE_INACTIVE = 0,
	DEVLINK_PORT_FN_STATE_ACTIVE = 1,
};

enum devlink_port_function_attr {
	DEVLINK_PORT_FUNCTION_ATTR_UNSPEC = 0,
	DEVLINK_PORT_FUNCTION_ATTR_HW_ADDR = 1,
	DEVLINK_PORT_FN_ATTR_STATE = 2,
	DEVLINK_PORT_FN_ATTR_OPSTATE = 3,
	DEVLINK_PORT_FN_ATTR_CAPS = 4,
	DEVLINK_PORT_FN_ATTR_DEVLINK = 5,
	DEVLINK_PORT_FN_ATTR_MAX_IO_EQS = 6,
	__DEVLINK_PORT_FUNCTION_ATTR_MAX = 7,
	DEVLINK_PORT_FUNCTION_ATTR_MAX = 6,
};

enum devlink_port_type {
	DEVLINK_PORT_TYPE_NOTSET = 0,
	DEVLINK_PORT_TYPE_AUTO = 1,
	DEVLINK_PORT_TYPE_ETH = 2,
	DEVLINK_PORT_TYPE_IB = 3,
};

enum devlink_rate_type {
	DEVLINK_RATE_TYPE_LEAF = 0,
	DEVLINK_RATE_TYPE_NODE = 1,
};

enum devlink_reload_action {
	DEVLINK_RELOAD_ACTION_UNSPEC = 0,
	DEVLINK_RELOAD_ACTION_DRIVER_REINIT = 1,
	DEVLINK_RELOAD_ACTION_FW_ACTIVATE = 2,
	__DEVLINK_RELOAD_ACTION_MAX = 3,
	DEVLINK_RELOAD_ACTION_MAX = 2,
};

enum devlink_reload_limit {
	DEVLINK_RELOAD_LIMIT_UNSPEC = 0,
	DEVLINK_RELOAD_LIMIT_NO_RESET = 1,
	__DEVLINK_RELOAD_LIMIT_MAX = 2,
	DEVLINK_RELOAD_LIMIT_MAX = 1,
};

enum devlink_resource_unit {
	DEVLINK_RESOURCE_UNIT_ENTRY = 0,
};

enum devlink_sb_pool_type {
	DEVLINK_SB_POOL_TYPE_INGRESS = 0,
	DEVLINK_SB_POOL_TYPE_EGRESS = 1,
};

enum devlink_sb_threshold_type {
	DEVLINK_SB_THRESHOLD_TYPE_STATIC = 0,
	DEVLINK_SB_THRESHOLD_TYPE_DYNAMIC = 1,
};

enum devlink_selftest_status {
	DEVLINK_SELFTEST_STATUS_SKIP = 0,
	DEVLINK_SELFTEST_STATUS_PASS = 1,
	DEVLINK_SELFTEST_STATUS_FAIL = 2,
};

enum devlink_trap_action {
	DEVLINK_TRAP_ACTION_DROP = 0,
	DEVLINK_TRAP_ACTION_TRAP = 1,
	DEVLINK_TRAP_ACTION_MIRROR = 2,
};

enum devlink_trap_generic_id {
	DEVLINK_TRAP_GENERIC_ID_SMAC_MC = 0,
	DEVLINK_TRAP_GENERIC_ID_VLAN_TAG_MISMATCH = 1,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_VLAN_FILTER = 2,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_STP_FILTER = 3,
	DEVLINK_TRAP_GENERIC_ID_EMPTY_TX_LIST = 4,
	DEVLINK_TRAP_GENERIC_ID_PORT_LOOPBACK_FILTER = 5,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_ROUTE = 6,
	DEVLINK_TRAP_GENERIC_ID_TTL_ERROR = 7,
	DEVLINK_TRAP_GENERIC_ID_TAIL_DROP = 8,
	DEVLINK_TRAP_GENERIC_ID_NON_IP_PACKET = 9,
	DEVLINK_TRAP_GENERIC_ID_UC_DIP_MC_DMAC = 10,
	DEVLINK_TRAP_GENERIC_ID_DIP_LB = 11,
	DEVLINK_TRAP_GENERIC_ID_SIP_MC = 12,
	DEVLINK_TRAP_GENERIC_ID_SIP_LB = 13,
	DEVLINK_TRAP_GENERIC_ID_CORRUPTED_IP_HDR = 14,
	DEVLINK_TRAP_GENERIC_ID_IPV4_SIP_BC = 15,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_RESERVED_SCOPE = 16,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_INTERFACE_LOCAL_SCOPE = 17,
	DEVLINK_TRAP_GENERIC_ID_MTU_ERROR = 18,
	DEVLINK_TRAP_GENERIC_ID_UNRESOLVED_NEIGH = 19,
	DEVLINK_TRAP_GENERIC_ID_RPF = 20,
	DEVLINK_TRAP_GENERIC_ID_REJECT_ROUTE = 21,
	DEVLINK_TRAP_GENERIC_ID_IPV4_LPM_UNICAST_MISS = 22,
	DEVLINK_TRAP_GENERIC_ID_IPV6_LPM_UNICAST_MISS = 23,
	DEVLINK_TRAP_GENERIC_ID_NON_ROUTABLE = 24,
	DEVLINK_TRAP_GENERIC_ID_DECAP_ERROR = 25,
	DEVLINK_TRAP_GENERIC_ID_OVERLAY_SMAC_MC = 26,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_FLOW_ACTION_DROP = 27,
	DEVLINK_TRAP_GENERIC_ID_EGRESS_FLOW_ACTION_DROP = 28,
	DEVLINK_TRAP_GENERIC_ID_STP = 29,
	DEVLINK_TRAP_GENERIC_ID_LACP = 30,
	DEVLINK_TRAP_GENERIC_ID_LLDP = 31,
	DEVLINK_TRAP_GENERIC_ID_IGMP_QUERY = 32,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V1_REPORT = 33,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_REPORT = 34,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V3_REPORT = 35,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_LEAVE = 36,
	DEVLINK_TRAP_GENERIC_ID_MLD_QUERY = 37,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_REPORT = 38,
	DEVLINK_TRAP_GENERIC_ID_MLD_V2_REPORT = 39,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_DONE = 40,
	DEVLINK_TRAP_GENERIC_ID_IPV4_DHCP = 41,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DHCP = 42,
	DEVLINK_TRAP_GENERIC_ID_ARP_REQUEST = 43,
	DEVLINK_TRAP_GENERIC_ID_ARP_RESPONSE = 44,
	DEVLINK_TRAP_GENERIC_ID_ARP_OVERLAY = 45,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_SOLICIT = 46,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_ADVERT = 47,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BFD = 48,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BFD = 49,
	DEVLINK_TRAP_GENERIC_ID_IPV4_OSPF = 50,
	DEVLINK_TRAP_GENERIC_ID_IPV6_OSPF = 51,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BGP = 52,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BGP = 53,
	DEVLINK_TRAP_GENERIC_ID_IPV4_VRRP = 54,
	DEVLINK_TRAP_GENERIC_ID_IPV6_VRRP = 55,
	DEVLINK_TRAP_GENERIC_ID_IPV4_PIM = 56,
	DEVLINK_TRAP_GENERIC_ID_IPV6_PIM = 57,
	DEVLINK_TRAP_GENERIC_ID_UC_LB = 58,
	DEVLINK_TRAP_GENERIC_ID_LOCAL_ROUTE = 59,
	DEVLINK_TRAP_GENERIC_ID_EXTERNAL_ROUTE = 60,
	DEVLINK_TRAP_GENERIC_ID_IPV6_UC_DIP_LINK_LOCAL_SCOPE = 61,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_NODES = 62,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_ROUTERS = 63,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_SOLICIT = 64,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ADVERT = 65,
	DEVLINK_TRAP_GENERIC_ID_IPV6_REDIRECT = 66,
	DEVLINK_TRAP_GENERIC_ID_IPV4_ROUTER_ALERT = 67,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ALERT = 68,
	DEVLINK_TRAP_GENERIC_ID_PTP_EVENT = 69,
	DEVLINK_TRAP_GENERIC_ID_PTP_GENERAL = 70,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_SAMPLE = 71,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_TRAP = 72,
	DEVLINK_TRAP_GENERIC_ID_EARLY_DROP = 73,
	DEVLINK_TRAP_GENERIC_ID_VXLAN_PARSING = 74,
	DEVLINK_TRAP_GENERIC_ID_LLC_SNAP_PARSING = 75,
	DEVLINK_TRAP_GENERIC_ID_VLAN_PARSING = 76,
	DEVLINK_TRAP_GENERIC_ID_PPPOE_PPP_PARSING = 77,
	DEVLINK_TRAP_GENERIC_ID_MPLS_PARSING = 78,
	DEVLINK_TRAP_GENERIC_ID_ARP_PARSING = 79,
	DEVLINK_TRAP_GENERIC_ID_IP_1_PARSING = 80,
	DEVLINK_TRAP_GENERIC_ID_IP_N_PARSING = 81,
	DEVLINK_TRAP_GENERIC_ID_GRE_PARSING = 82,
	DEVLINK_TRAP_GENERIC_ID_UDP_PARSING = 83,
	DEVLINK_TRAP_GENERIC_ID_TCP_PARSING = 84,
	DEVLINK_TRAP_GENERIC_ID_IPSEC_PARSING = 85,
	DEVLINK_TRAP_GENERIC_ID_SCTP_PARSING = 86,
	DEVLINK_TRAP_GENERIC_ID_DCCP_PARSING = 87,
	DEVLINK_TRAP_GENERIC_ID_GTP_PARSING = 88,
	DEVLINK_TRAP_GENERIC_ID_ESP_PARSING = 89,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_NEXTHOP = 90,
	DEVLINK_TRAP_GENERIC_ID_DMAC_FILTER = 91,
	DEVLINK_TRAP_GENERIC_ID_EAPOL = 92,
	DEVLINK_TRAP_GENERIC_ID_LOCKED_PORT = 93,
	__DEVLINK_TRAP_GENERIC_ID_MAX = 94,
	DEVLINK_TRAP_GENERIC_ID_MAX = 93,
};

enum devlink_trap_group_generic_id {
	DEVLINK_TRAP_GROUP_GENERIC_ID_L2_DROPS = 0,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_DROPS = 1,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_EXCEPTIONS = 2,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BUFFER_DROPS = 3,
	DEVLINK_TRAP_GROUP_GENERIC_ID_TUNNEL_DROPS = 4,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_DROPS = 5,
	DEVLINK_TRAP_GROUP_GENERIC_ID_STP = 6,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LACP = 7,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LLDP = 8,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MC_SNOOPING = 9,
	DEVLINK_TRAP_GROUP_GENERIC_ID_DHCP = 10,
	DEVLINK_TRAP_GROUP_GENERIC_ID_NEIGH_DISCOVERY = 11,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BFD = 12,
	DEVLINK_TRAP_GROUP_GENERIC_ID_OSPF = 13,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BGP = 14,
	DEVLINK_TRAP_GROUP_GENERIC_ID_VRRP = 15,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PIM = 16,
	DEVLINK_TRAP_GROUP_GENERIC_ID_UC_LB = 17,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LOCAL_DELIVERY = 18,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EXTERNAL_DELIVERY = 19,
	DEVLINK_TRAP_GROUP_GENERIC_ID_IPV6 = 20,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_EVENT = 21,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_GENERAL = 22,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_SAMPLE = 23,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_TRAP = 24,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PARSER_ERROR_DROPS = 25,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EAPOL = 26,
	__DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 27,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 26,
};

enum devlink_trap_type {
	DEVLINK_TRAP_TYPE_DROP = 0,
	DEVLINK_TRAP_TYPE_EXCEPTION = 1,
	DEVLINK_TRAP_TYPE_CONTROL = 2,
};

enum devm_ioremap_type {
	DEVM_IOREMAP = 0,
	DEVM_IOREMAP_UC = 1,
	DEVM_IOREMAP_WC = 2,
	DEVM_IOREMAP_NP = 3,
};

enum die_val {
	DIE_OOPS = 1,
	DIE_IABR_MATCH = 2,
	DIE_DABR_MATCH = 3,
	DIE_BPT = 4,
	DIE_SSTEP = 5,
};

enum discover_event {
	DISCE_DISCOVER_DOMAIN = 0,
	DISCE_REVALIDATE_DOMAIN = 1,
	DISCE_SUSPEND = 2,
	DISCE_RESUME = 3,
	DISC_NUM_EVENTS = 4,
};

enum discovery_state {
	DSC_DELETED = 0,
	DSC_GNL = 1,
	DSC_LOGIN_PEND = 2,
	DSC_LOGIN_FAILED = 3,
	DSC_GPDB = 4,
	DSC_UPD_FCPORT = 5,
	DSC_LOGIN_COMPLETE = 6,
	DSC_ADISC = 7,
	DSC_DELETE_PEND = 8,
	DSC_LOGIN_AUTH_PEND = 9,
};

enum discovery_state___2 {
	LPFC_VPORT_UNKNOWN = 0,
	LPFC_VPORT_FAILED = 1,
	LPFC_LOCAL_CFG_LINK = 6,
	LPFC_FLOGI = 7,
	LPFC_FDISC = 8,
	LPFC_FABRIC_CFG_LINK = 9,
	LPFC_NS_REG = 10,
	LPFC_NS_QRY = 11,
	LPFC_BUILD_DISC_LIST = 12,
	LPFC_DISC_AUTH = 13,
	LPFC_VPORT_READY = 32,
};

enum display_flags {
	DISPLAY_FLAGS_HSYNC_LOW = 1,
	DISPLAY_FLAGS_HSYNC_HIGH = 2,
	DISPLAY_FLAGS_VSYNC_LOW = 4,
	DISPLAY_FLAGS_VSYNC_HIGH = 8,
	DISPLAY_FLAGS_DE_LOW = 16,
	DISPLAY_FLAGS_DE_HIGH = 32,
	DISPLAY_FLAGS_PIXDATA_POSEDGE = 64,
	DISPLAY_FLAGS_PIXDATA_NEGEDGE = 128,
	DISPLAY_FLAGS_INTERLACED = 256,
	DISPLAY_FLAGS_DOUBLESCAN = 512,
	DISPLAY_FLAGS_DOUBLECLK = 1024,
	DISPLAY_FLAGS_SYNC_POSEDGE = 2048,
	DISPLAY_FLAGS_SYNC_NEGEDGE = 4096,
};

enum dl_bw_request {
	dl_bw_req_check_overflow = 0,
	dl_bw_req_alloc = 1,
	dl_bw_req_free = 2,
};

enum dl_dev_state {
	DL_DEV_NO_DRIVER = 0,
	DL_DEV_PROBING = 1,
	DL_DEV_DRIVER_BOUND = 2,
	DL_DEV_UNBINDING = 3,
};

enum dma_ctrl_flags {
	DMA_PREP_INTERRUPT = 1,
	DMA_CTRL_ACK = 2,
	DMA_PREP_PQ_DISABLE_P = 4,
	DMA_PREP_PQ_DISABLE_Q = 8,
	DMA_PREP_CONTINUE = 16,
	DMA_PREP_FENCE = 32,
	DMA_CTRL_REUSE = 64,
	DMA_PREP_CMD = 128,
	DMA_PREP_REPEAT = 256,
	DMA_PREP_LOAD_EOT = 512,
};

enum dma_data_direction {
	DMA_BIDIRECTIONAL = 0,
	DMA_TO_DEVICE = 1,
	DMA_FROM_DEVICE = 2,
	DMA_NONE = 3,
};

enum dma_desc_metadata_mode {
	DESC_METADATA_NONE = 0,
	DESC_METADATA_CLIENT = 1,
	DESC_METADATA_ENGINE = 2,
};

enum dma_fence_flag_bits {
	DMA_FENCE_FLAG_SIGNALED_BIT = 0,
	DMA_FENCE_FLAG_TIMESTAMP_BIT = 1,
	DMA_FENCE_FLAG_ENABLE_SIGNAL_BIT = 2,
	DMA_FENCE_FLAG_USER_BITS = 3,
};

enum dma_residue_granularity {
	DMA_RESIDUE_GRANULARITY_DESCRIPTOR = 0,
	DMA_RESIDUE_GRANULARITY_SEGMENT = 1,
	DMA_RESIDUE_GRANULARITY_BURST = 2,
};

enum dma_resv_usage {
	DMA_RESV_USAGE_KERNEL = 0,
	DMA_RESV_USAGE_WRITE = 1,
	DMA_RESV_USAGE_READ = 2,
	DMA_RESV_USAGE_BOOKKEEP = 3,
};

enum dma_slave_buswidth {
	DMA_SLAVE_BUSWIDTH_UNDEFINED = 0,
	DMA_SLAVE_BUSWIDTH_1_BYTE = 1,
	DMA_SLAVE_BUSWIDTH_2_BYTES = 2,
	DMA_SLAVE_BUSWIDTH_3_BYTES = 3,
	DMA_SLAVE_BUSWIDTH_4_BYTES = 4,
	DMA_SLAVE_BUSWIDTH_8_BYTES = 8,
	DMA_SLAVE_BUSWIDTH_16_BYTES = 16,
	DMA_SLAVE_BUSWIDTH_32_BYTES = 32,
	DMA_SLAVE_BUSWIDTH_64_BYTES = 64,
	DMA_SLAVE_BUSWIDTH_128_BYTES = 128,
};

enum dma_status {
	DMA_COMPLETE = 0,
	DMA_IN_PROGRESS = 1,
	DMA_PAUSED = 2,
	DMA_ERROR = 3,
	DMA_OUT_OF_ORDER = 4,
};

enum dma_transaction_type {
	DMA_MEMCPY = 0,
	DMA_XOR = 1,
	DMA_PQ = 2,
	DMA_XOR_VAL = 3,
	DMA_PQ_VAL = 4,
	DMA_MEMSET = 5,
	DMA_MEMSET_SG = 6,
	DMA_INTERRUPT = 7,
	DMA_PRIVATE = 8,
	DMA_ASYNC_TX = 9,
	DMA_SLAVE = 10,
	DMA_CYCLIC = 11,
	DMA_INTERLEAVE = 12,
	DMA_COMPLETION_NO_ORDER = 13,
	DMA_REPEAT = 14,
	DMA_LOAD_EOT = 15,
	DMA_TX_TYPE_END = 16,
};

enum dma_transfer_direction {
	DMA_MEM_TO_MEM = 0,
	DMA_MEM_TO_DEV = 1,
	DMA_DEV_TO_MEM = 2,
	DMA_DEV_TO_DEV = 3,
	DMA_TRANS_NONE = 4,
};

enum dma_type {
	dma_mbox = 1,
	dma_ebuf = 2,
};

enum dmaengine_alignment {
	DMAENGINE_ALIGN_1_BYTE = 0,
	DMAENGINE_ALIGN_2_BYTES = 1,
	DMAENGINE_ALIGN_4_BYTES = 2,
	DMAENGINE_ALIGN_8_BYTES = 3,
	DMAENGINE_ALIGN_16_BYTES = 4,
	DMAENGINE_ALIGN_32_BYTES = 5,
	DMAENGINE_ALIGN_64_BYTES = 6,
	DMAENGINE_ALIGN_128_BYTES = 7,
	DMAENGINE_ALIGN_256_BYTES = 8,
};

enum dmaengine_tx_result {
	DMA_TRANS_NOERROR = 0,
	DMA_TRANS_READ_FAILED = 1,
	DMA_TRANS_WRITE_FAILED = 2,
	DMA_TRANS_ABORTED = 3,
};

enum dmi_field {
	DMI_NONE = 0,
	DMI_BIOS_VENDOR = 1,
	DMI_BIOS_VERSION = 2,
	DMI_BIOS_DATE = 3,
	DMI_BIOS_RELEASE = 4,
	DMI_EC_FIRMWARE_RELEASE = 5,
	DMI_SYS_VENDOR = 6,
	DMI_PRODUCT_NAME = 7,
	DMI_PRODUCT_VERSION = 8,
	DMI_PRODUCT_SERIAL = 9,
	DMI_PRODUCT_UUID = 10,
	DMI_PRODUCT_SKU = 11,
	DMI_PRODUCT_FAMILY = 12,
	DMI_BOARD_VENDOR = 13,
	DMI_BOARD_NAME = 14,
	DMI_BOARD_VERSION = 15,
	DMI_BOARD_SERIAL = 16,
	DMI_BOARD_ASSET_TAG = 17,
	DMI_CHASSIS_VENDOR = 18,
	DMI_CHASSIS_TYPE = 19,
	DMI_CHASSIS_VERSION = 20,
	DMI_CHASSIS_SERIAL = 21,
	DMI_CHASSIS_ASSET_TAG = 22,
	DMI_STRING_MAX = 23,
	DMI_OEM_STRING = 24,
};

enum dpll_a {
	DPLL_A_ID = 1,
	DPLL_A_MODULE_NAME = 2,
	DPLL_A_PAD = 3,
	DPLL_A_CLOCK_ID = 4,
	DPLL_A_MODE = 5,
	DPLL_A_MODE_SUPPORTED = 6,
	DPLL_A_LOCK_STATUS = 7,
	DPLL_A_TEMP = 8,
	DPLL_A_TYPE = 9,
	DPLL_A_LOCK_STATUS_ERROR = 10,
	__DPLL_A_MAX = 11,
	DPLL_A_MAX = 10,
};

enum dpll_a_pin {
	DPLL_A_PIN_ID = 1,
	DPLL_A_PIN_PARENT_ID = 2,
	DPLL_A_PIN_MODULE_NAME = 3,
	DPLL_A_PIN_PAD = 4,
	DPLL_A_PIN_CLOCK_ID = 5,
	DPLL_A_PIN_BOARD_LABEL = 6,
	DPLL_A_PIN_PANEL_LABEL = 7,
	DPLL_A_PIN_PACKAGE_LABEL = 8,
	DPLL_A_PIN_TYPE = 9,
	DPLL_A_PIN_DIRECTION = 10,
	DPLL_A_PIN_FREQUENCY = 11,
	DPLL_A_PIN_FREQUENCY_SUPPORTED = 12,
	DPLL_A_PIN_FREQUENCY_MIN = 13,
	DPLL_A_PIN_FREQUENCY_MAX = 14,
	DPLL_A_PIN_PRIO = 15,
	DPLL_A_PIN_STATE = 16,
	DPLL_A_PIN_CAPABILITIES = 17,
	DPLL_A_PIN_PARENT_DEVICE = 18,
	DPLL_A_PIN_PARENT_PIN = 19,
	DPLL_A_PIN_PHASE_ADJUST_MIN = 20,
	DPLL_A_PIN_PHASE_ADJUST_MAX = 21,
	DPLL_A_PIN_PHASE_ADJUST = 22,
	DPLL_A_PIN_PHASE_OFFSET = 23,
	DPLL_A_PIN_FRACTIONAL_FREQUENCY_OFFSET = 24,
	__DPLL_A_PIN_MAX = 25,
	DPLL_A_PIN_MAX = 24,
};

enum dpll_cmd {
	DPLL_CMD_DEVICE_ID_GET = 1,
	DPLL_CMD_DEVICE_GET = 2,
	DPLL_CMD_DEVICE_SET = 3,
	DPLL_CMD_DEVICE_CREATE_NTF = 4,
	DPLL_CMD_DEVICE_DELETE_NTF = 5,
	DPLL_CMD_DEVICE_CHANGE_NTF = 6,
	DPLL_CMD_PIN_ID_GET = 7,
	DPLL_CMD_PIN_GET = 8,
	DPLL_CMD_PIN_SET = 9,
	DPLL_CMD_PIN_CREATE_NTF = 10,
	DPLL_CMD_PIN_DELETE_NTF = 11,
	DPLL_CMD_PIN_CHANGE_NTF = 12,
	__DPLL_CMD_MAX = 13,
	DPLL_CMD_MAX = 12,
};

enum dpll_lock_status {
	DPLL_LOCK_STATUS_UNLOCKED = 1,
	DPLL_LOCK_STATUS_LOCKED = 2,
	DPLL_LOCK_STATUS_LOCKED_HO_ACQ = 3,
	DPLL_LOCK_STATUS_HOLDOVER = 4,
	__DPLL_LOCK_STATUS_MAX = 5,
	DPLL_LOCK_STATUS_MAX = 4,
};

enum dpll_lock_status_error {
	DPLL_LOCK_STATUS_ERROR_NONE = 1,
	DPLL_LOCK_STATUS_ERROR_UNDEFINED = 2,
	DPLL_LOCK_STATUS_ERROR_MEDIA_DOWN = 3,
	DPLL_LOCK_STATUS_ERROR_FRACTIONAL_FREQUENCY_OFFSET_TOO_HIGH = 4,
	__DPLL_LOCK_STATUS_ERROR_MAX = 5,
	DPLL_LOCK_STATUS_ERROR_MAX = 4,
};

enum dpll_mode {
	DPLL_MODE_MANUAL = 1,
	DPLL_MODE_AUTOMATIC = 2,
	__DPLL_MODE_MAX = 3,
	DPLL_MODE_MAX = 2,
};

enum dpll_pin_capabilities {
	DPLL_PIN_CAPABILITIES_DIRECTION_CAN_CHANGE = 1,
	DPLL_PIN_CAPABILITIES_PRIORITY_CAN_CHANGE = 2,
	DPLL_PIN_CAPABILITIES_STATE_CAN_CHANGE = 4,
};

enum dpll_pin_direction {
	DPLL_PIN_DIRECTION_INPUT = 1,
	DPLL_PIN_DIRECTION_OUTPUT = 2,
	__DPLL_PIN_DIRECTION_MAX = 3,
	DPLL_PIN_DIRECTION_MAX = 2,
};

enum dpll_pin_state {
	DPLL_PIN_STATE_CONNECTED = 1,
	DPLL_PIN_STATE_DISCONNECTED = 2,
	DPLL_PIN_STATE_SELECTABLE = 3,
	__DPLL_PIN_STATE_MAX = 4,
	DPLL_PIN_STATE_MAX = 3,
};

enum dpll_pin_type {
	DPLL_PIN_TYPE_MUX = 1,
	DPLL_PIN_TYPE_EXT = 2,
	DPLL_PIN_TYPE_SYNCE_ETH_PORT = 3,
	DPLL_PIN_TYPE_INT_OSCILLATOR = 4,
	DPLL_PIN_TYPE_GNSS = 5,
	__DPLL_PIN_TYPE_MAX = 6,
	DPLL_PIN_TYPE_MAX = 5,
};

enum dpll_type {
	DPLL_TYPE_PPS = 1,
	DPLL_TYPE_EEC = 2,
	__DPLL_TYPE_MAX = 3,
	DPLL_TYPE_MAX = 2,
};

enum dpm_order {
	DPM_ORDER_NONE = 0,
	DPM_ORDER_DEV_AFTER_PARENT = 1,
	DPM_ORDER_PARENT_BEFORE_DEV = 2,
	DPM_ORDER_DEV_LAST = 3,
};

enum drbg_prefixes {
	DRBG_PREFIX0 = 0,
	DRBG_PREFIX1 = 1,
	DRBG_PREFIX2 = 2,
	DRBG_PREFIX3 = 3,
};

enum drbg_seed_state {
	DRBG_SEED_STATE_UNSEEDED = 0,
	DRBG_SEED_STATE_PARTIAL = 1,
	DRBG_SEED_STATE_FULL = 2,
};

enum driver_configuration {
	MVS_TX_RING_SZ = 1024,
	MVS_RX_RING_SZ = 1024,
	MVS_SOC_SLOTS = 64,
	MVS_SOC_TX_RING_SZ = 128,
	MVS_SOC_RX_RING_SZ = 128,
	MVS_SLOT_BUF_SZ = 8192,
	MVS_SSP_CMD_SZ = 64,
	MVS_ATA_CMD_SZ = 96,
	MVS_OAF_SZ = 64,
	MVS_QUEUE_SIZE = 64,
	MVS_RSVD_SLOTS = 4,
	MVS_SOC_CAN_QUEUE = 62,
};

enum dsa_db_type {
	DSA_DB_PORT = 0,
	DSA_DB_LAG = 1,
	DSA_DB_BRIDGE = 2,
};

enum dsa_tag_protocol {
	DSA_TAG_PROTO_NONE = 0,
	DSA_TAG_PROTO_BRCM = 1,
	DSA_TAG_PROTO_BRCM_LEGACY = 22,
	DSA_TAG_PROTO_BRCM_PREPEND = 2,
	DSA_TAG_PROTO_DSA = 3,
	DSA_TAG_PROTO_EDSA = 4,
	DSA_TAG_PROTO_GSWIP = 5,
	DSA_TAG_PROTO_KSZ9477 = 6,
	DSA_TAG_PROTO_KSZ9893 = 7,
	DSA_TAG_PROTO_LAN9303 = 8,
	DSA_TAG_PROTO_MTK = 9,
	DSA_TAG_PROTO_QCA = 10,
	DSA_TAG_PROTO_TRAILER = 11,
	DSA_TAG_PROTO_8021Q = 12,
	DSA_TAG_PROTO_SJA1105 = 13,
	DSA_TAG_PROTO_KSZ8795 = 14,
	DSA_TAG_PROTO_OCELOT = 15,
	DSA_TAG_PROTO_AR9331 = 16,
	DSA_TAG_PROTO_RTL4_A = 17,
	DSA_TAG_PROTO_HELLCREEK = 18,
	DSA_TAG_PROTO_XRS700X = 19,
	DSA_TAG_PROTO_OCELOT_8021Q = 20,
	DSA_TAG_PROTO_SEVILLE = 21,
	DSA_TAG_PROTO_SJA1110 = 23,
	DSA_TAG_PROTO_RTL8_4 = 24,
	DSA_TAG_PROTO_RTL8_4T = 25,
	DSA_TAG_PROTO_RZN1_A5PSW = 26,
	DSA_TAG_PROTO_LAN937X = 27,
};

enum dw_dma_fc {
	DW_DMA_FC_D_M2M = 0,
	DW_DMA_FC_D_M2P = 1,
	DW_DMA_FC_D_P2M = 2,
	DW_DMA_FC_D_P2P = 3,
	DW_DMA_FC_P_P2M = 4,
	DW_DMA_FC_SP_P2P = 5,
	DW_DMA_FC_P_M2P = 6,
	DW_DMA_FC_DP_P2P = 7,
};

enum dw_dmac_flags {
	DW_DMA_IS_CYCLIC = 0,
	DW_DMA_IS_SOFT_LLP = 1,
	DW_DMA_IS_PAUSED = 2,
	DW_DMA_IS_INITIALIZED = 3,
};

enum dw_edma_chip_flags {
	DW_EDMA_CHIP_LOCAL = 1,
};

enum dw_edma_map_format {
	EDMA_MF_EDMA_LEGACY = 0,
	EDMA_MF_EDMA_UNROLL = 1,
	EDMA_MF_HDMA_COMPAT = 5,
	EDMA_MF_HDMA_NATIVE = 7,
};

enum dw_pcie_app_clk {
	DW_PCIE_DBI_CLK = 0,
	DW_PCIE_MSTR_CLK = 1,
	DW_PCIE_SLV_CLK = 2,
	DW_PCIE_NUM_APP_CLKS = 3,
};

enum dw_pcie_app_rst {
	DW_PCIE_DBI_RST = 0,
	DW_PCIE_MSTR_RST = 1,
	DW_PCIE_SLV_RST = 2,
	DW_PCIE_NUM_APP_RSTS = 3,
};

enum dw_pcie_core_clk {
	DW_PCIE_PIPE_CLK = 0,
	DW_PCIE_CORE_CLK = 1,
	DW_PCIE_AUX_CLK = 2,
	DW_PCIE_REF_CLK = 3,
	DW_PCIE_NUM_CORE_CLKS = 4,
};

enum dw_pcie_core_rst {
	DW_PCIE_NON_STICKY_RST = 0,
	DW_PCIE_STICKY_RST = 1,
	DW_PCIE_CORE_RST = 2,
	DW_PCIE_PIPE_RST = 3,
	DW_PCIE_PHY_RST = 4,
	DW_PCIE_HOT_RST = 5,
	DW_PCIE_PWR_RST = 6,
	DW_PCIE_NUM_CORE_RSTS = 7,
};

enum dw_pcie_device_mode {
	DW_PCIE_UNKNOWN_TYPE = 0,
	DW_PCIE_EP_TYPE = 1,
	DW_PCIE_LEG_EP_TYPE = 2,
	DW_PCIE_RC_TYPE = 3,
};

enum dw_pcie_ltssm {
	DW_PCIE_LTSSM_DETECT_QUIET = 0,
	DW_PCIE_LTSSM_DETECT_ACT = 1,
	DW_PCIE_LTSSM_L0 = 17,
	DW_PCIE_LTSSM_L2_IDLE = 21,
	DW_PCIE_LTSSM_UNKNOWN = 4294967295,
};

enum dwc_specific_registers {
	DWC_UFS_REG_HCLKDIV = 252,
};

enum dynevent_type {
	DYNEVENT_TYPE_SYNTH = 1,
	DYNEVENT_TYPE_KPROBE = 2,
	DYNEVENT_TYPE_NONE = 3,
};

enum ecc_dialects {
	ECC_DIALECT_STANDARD = 0,
	ECC_DIALECT_ED25519 = 1,
	ECC_DIALECT_SAFECURVE = 2,
};

enum els_request64_wqe_word11 {
	LPFC_ELS_ID_DEFAULT = 0,
	LPFC_ELS_ID_LOGO = 1,
	LPFC_ELS_ID_FDISC = 2,
	LPFC_ELS_ID_FLOGI = 3,
	LPFC_ELS_ID_PLOGI = 4,
};

enum elv_merge {
	ELEVATOR_NO_MERGE = 0,
	ELEVATOR_FRONT_MERGE = 1,
	ELEVATOR_BACK_MERGE = 2,
	ELEVATOR_DISCARD_MERGE = 3,
};

enum enable_type {
	undefined = -1,
	user_disabled = 0,
	auto_disabled = 1,
	user_enabled = 2,
	auto_enabled = 3,
};

enum enode_flags_t {
	ENODE_ACTIVE = 1,
};

enum environment_cap {
	ENVIRON_ANY = 0,
	ENVIRON_INDOOR = 1,
	ENVIRON_OUTDOOR = 2,
};

enum error_detector {
	ERROR_DETECTOR_KFENCE = 0,
	ERROR_DETECTOR_KASAN = 1,
	ERROR_DETECTOR_WARN = 2,
};

enum error_info_rec {
	CMD_ISS_STPD = 2147483648,
	CMD_PI_ERR = 1073741824,
	RSP_OVER = 536870912,
	RETRY_LIM = 268435456,
	UNK_FIS = 134217728,
	DMA_TERM = 67108864,
	SYNC_ERR = 33554432,
	TFILE_ERR = 16777216,
	R_ERR = 8388608,
	RD_OFS = 1048576,
	XFER_RDY_OFS = 524288,
	UNEXP_XFER_RDY = 262144,
	DATA_OVER_UNDER = 65536,
	INTERLOCK = 32768,
	NAK = 16384,
	ACK_NAK_TO = 8192,
	CXN_CLOSED = 4096,
	OPEN_TO = 2048,
	PATH_BLOCKED = 1024,
	NO_DEST = 512,
	STP_RES_BSY = 256,
	BREAK = 128,
	BAD_DEST = 64,
	BAD_PROTO = 32,
	BAD_RATE = 16,
	WRONG_DEST = 8,
	CREDIT_TO = 4,
	WDOG_TO = 2,
	BUF_PAR = 1,
};

enum esp_rev {
	ESP100 = 0,
	ESP100A = 1,
	ESP236 = 2,
	FAS236 = 3,
	PCSCSI = 4,
	FSC = 5,
	FAS100A = 6,
	FAST = 7,
	FASHME = 8,
};

enum eth_addr_type {
	UNKNOWN_ADDRESS = 0,
	UNICAST_ADDRESS = 1,
	MULTICAST_ADDRESS = 2,
	BROADCAST_ADDRESS = 3,
	MAX_ETH_ADDR_TYPE = 4,
};

enum eth_fp_hsi_ver {
	ETH_FP_HSI_VER_0 = 0,
	ETH_FP_HSI_VER_1 = 1,
	ETH_FP_HSI_VER_2 = 2,
	MAX_ETH_FP_HSI_VER = 3,
};

enum eth_spqe_cmd_id {
	RAMROD_CMD_ID_ETH_UNUSED = 0,
	RAMROD_CMD_ID_ETH_CLIENT_SETUP = 1,
	RAMROD_CMD_ID_ETH_HALT = 2,
	RAMROD_CMD_ID_ETH_FORWARD_SETUP = 3,
	RAMROD_CMD_ID_ETH_TX_QUEUE_SETUP = 4,
	RAMROD_CMD_ID_ETH_CLIENT_UPDATE = 5,
	RAMROD_CMD_ID_ETH_EMPTY = 6,
	RAMROD_CMD_ID_ETH_TERMINATE = 7,
	RAMROD_CMD_ID_ETH_TPA_UPDATE = 8,
	RAMROD_CMD_ID_ETH_CLASSIFICATION_RULES = 9,
	RAMROD_CMD_ID_ETH_FILTER_RULES = 10,
	RAMROD_CMD_ID_ETH_MULTICAST_RULES = 11,
	RAMROD_CMD_ID_ETH_RSS_UPDATE = 12,
	RAMROD_CMD_ID_ETH_SET_MAC = 13,
	MAX_ETH_SPQE_CMD_ID = 14,
};

enum ethtool_c33_pse_admin_state {
	ETHTOOL_C33_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_C33_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_C33_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_c33_pse_pw_d_status {
	ETHTOOL_C33_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_C33_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_C33_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_C33_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_C33_PSE_PW_D_STATUS_TEST = 5,
	ETHTOOL_C33_PSE_PW_D_STATUS_FAULT = 6,
	ETHTOOL_C33_PSE_PW_D_STATUS_OTHERFAULT = 7,
};

enum ethtool_fec_config_bits {
	ETHTOOL_FEC_NONE_BIT = 0,
	ETHTOOL_FEC_AUTO_BIT = 1,
	ETHTOOL_FEC_OFF_BIT = 2,
	ETHTOOL_FEC_RS_BIT = 3,
	ETHTOOL_FEC_BASER_BIT = 4,
	ETHTOOL_FEC_LLRS_BIT = 5,
};

enum ethtool_flags {
	ETH_FLAG_TXVLAN = 128,
	ETH_FLAG_RXVLAN = 256,
	ETH_FLAG_LRO = 32768,
	ETH_FLAG_NTUPLE = 134217728,
	ETH_FLAG_RXHASH = 268435456,
};

enum ethtool_header_flags {
	ETHTOOL_FLAG_COMPACT_BITSETS = 1,
	ETHTOOL_FLAG_OMIT_REPLY = 2,
	ETHTOOL_FLAG_STATS = 4,
};

enum ethtool_link_ext_state {
	ETHTOOL_LINK_EXT_STATE_AUTONEG = 0,
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE = 1,
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH = 2,
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY = 3,
	ETHTOOL_LINK_EXT_STATE_NO_CABLE = 4,
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE = 5,
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE = 6,
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE = 7,
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED = 8,
	ETHTOOL_LINK_EXT_STATE_OVERHEAT = 9,
	ETHTOOL_LINK_EXT_STATE_MODULE = 10,
};

enum ethtool_link_ext_substate_autoneg {
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE = 5,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD = 6,
};

enum ethtool_link_ext_substate_bad_signal_integrity {
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_REFERENCE_CLOCK_LOST = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_ALOS = 4,
};

enum ethtool_link_ext_substate_cable_issue {
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE = 2,
};

enum ethtool_link_ext_substate_link_logical_mismatch {
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED = 5,
};

enum ethtool_link_ext_substate_link_training {
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT = 4,
};

enum ethtool_link_ext_substate_module {
	ETHTOOL_LINK_EXT_SUBSTATE_MODULE_CMIS_NOT_READY = 1,
};

enum ethtool_link_mode_bit_indices {
	ETHTOOL_LINK_MODE_10baseT_Half_BIT = 0,
	ETHTOOL_LINK_MODE_10baseT_Full_BIT = 1,
	ETHTOOL_LINK_MODE_100baseT_Half_BIT = 2,
	ETHTOOL_LINK_MODE_100baseT_Full_BIT = 3,
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT = 4,
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT = 5,
	ETHTOOL_LINK_MODE_Autoneg_BIT = 6,
	ETHTOOL_LINK_MODE_TP_BIT = 7,
	ETHTOOL_LINK_MODE_AUI_BIT = 8,
	ETHTOOL_LINK_MODE_MII_BIT = 9,
	ETHTOOL_LINK_MODE_FIBRE_BIT = 10,
	ETHTOOL_LINK_MODE_BNC_BIT = 11,
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT = 12,
	ETHTOOL_LINK_MODE_Pause_BIT = 13,
	ETHTOOL_LINK_MODE_Asym_Pause_BIT = 14,
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT = 15,
	ETHTOOL_LINK_MODE_Backplane_BIT = 16,
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT = 17,
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT = 18,
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT = 19,
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT = 20,
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT = 21,
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT = 22,
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT = 23,
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT = 24,
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT = 25,
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT = 26,
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT = 27,
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT = 28,
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT = 29,
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT = 30,
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT = 31,
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT = 32,
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT = 33,
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT = 34,
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT = 35,
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT = 36,
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT = 37,
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT = 38,
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT = 39,
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT = 40,
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT = 41,
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT = 42,
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT = 43,
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT = 44,
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT = 45,
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT = 46,
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT = 47,
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT = 48,
	ETHTOOL_LINK_MODE_FEC_NONE_BIT = 49,
	ETHTOOL_LINK_MODE_FEC_RS_BIT = 50,
	ETHTOOL_LINK_MODE_FEC_BASER_BIT = 51,
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT = 52,
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT = 53,
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT = 54,
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT = 55,
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT = 56,
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT = 57,
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT = 58,
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT = 59,
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT = 60,
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT = 61,
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT = 62,
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT = 63,
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT = 64,
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT = 65,
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT = 66,
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT = 67,
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT = 68,
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT = 69,
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT = 70,
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT = 71,
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT = 72,
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT = 73,
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT = 74,
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT = 75,
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT = 76,
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT = 77,
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT = 78,
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT = 79,
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT = 80,
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT = 81,
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT = 82,
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT = 83,
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT = 84,
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT = 85,
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT = 86,
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT = 87,
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT = 88,
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT = 89,
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT = 90,
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT = 91,
	ETHTOOL_LINK_MODE_10baseT1L_Full_BIT = 92,
	ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT = 93,
	ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT = 94,
	ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT = 95,
	ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT = 96,
	ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT = 97,
	ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT = 98,
	ETHTOOL_LINK_MODE_10baseT1S_Full_BIT = 99,
	ETHTOOL_LINK_MODE_10baseT1S_Half_BIT = 100,
	ETHTOOL_LINK_MODE_10baseT1S_P2MP_Half_BIT = 101,
	__ETHTOOL_LINK_MODE_MASK_NBITS = 102,
};

enum ethtool_mac_stats_src {
	ETHTOOL_MAC_STATS_SRC_AGGREGATE = 0,
	ETHTOOL_MAC_STATS_SRC_EMAC = 1,
	ETHTOOL_MAC_STATS_SRC_PMAC = 2,
};

enum ethtool_mm_verify_status {
	ETHTOOL_MM_VERIFY_STATUS_UNKNOWN = 0,
	ETHTOOL_MM_VERIFY_STATUS_INITIAL = 1,
	ETHTOOL_MM_VERIFY_STATUS_VERIFYING = 2,
	ETHTOOL_MM_VERIFY_STATUS_SUCCEEDED = 3,
	ETHTOOL_MM_VERIFY_STATUS_FAILED = 4,
	ETHTOOL_MM_VERIFY_STATUS_DISABLED = 5,
};

enum ethtool_module_power_mode {
	ETHTOOL_MODULE_POWER_MODE_LOW = 1,
	ETHTOOL_MODULE_POWER_MODE_HIGH = 2,
};

enum ethtool_module_power_mode_policy {
	ETHTOOL_MODULE_POWER_MODE_POLICY_HIGH = 1,
	ETHTOOL_MODULE_POWER_MODE_POLICY_AUTO = 2,
};

enum ethtool_multicast_groups {
	ETHNL_MCGRP_MONITOR = 0,
};

enum ethtool_phys_id_state {
	ETHTOOL_ID_INACTIVE = 0,
	ETHTOOL_ID_ACTIVE = 1,
	ETHTOOL_ID_ON = 2,
	ETHTOOL_ID_OFF = 3,
};

enum ethtool_podl_pse_admin_state {
	ETHTOOL_PODL_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_PODL_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_podl_pse_pw_d_status {
	ETHTOOL_PODL_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SLEEP = 5,
	ETHTOOL_PODL_PSE_PW_D_STATUS_IDLE = 6,
	ETHTOOL_PODL_PSE_PW_D_STATUS_ERROR = 7,
};

enum ethtool_sfeatures_retval_bits {
	ETHTOOL_F_UNSUPPORTED__BIT = 0,
	ETHTOOL_F_WISH__BIT = 1,
	ETHTOOL_F_COMPAT__BIT = 2,
};

enum ethtool_stringset {
	ETH_SS_TEST = 0,
	ETH_SS_STATS = 1,
	ETH_SS_PRIV_FLAGS = 2,
	ETH_SS_NTUPLE_FILTERS = 3,
	ETH_SS_FEATURES = 4,
	ETH_SS_RSS_HASH_FUNCS = 5,
	ETH_SS_TUNABLES = 6,
	ETH_SS_PHY_STATS = 7,
	ETH_SS_PHY_TUNABLES = 8,
	ETH_SS_LINK_MODES = 9,
	ETH_SS_MSG_CLASSES = 10,
	ETH_SS_WOL_MODES = 11,
	ETH_SS_SOF_TIMESTAMPING = 12,
	ETH_SS_TS_TX_TYPES = 13,
	ETH_SS_TS_RX_FILTERS = 14,
	ETH_SS_UDP_TUNNEL_TYPES = 15,
	ETH_SS_STATS_STD = 16,
	ETH_SS_STATS_ETH_PHY = 17,
	ETH_SS_STATS_ETH_MAC = 18,
	ETH_SS_STATS_ETH_CTRL = 19,
	ETH_SS_STATS_RMON = 20,
	ETH_SS_COUNT = 21,
};

enum ethtool_supported_ring_param {
	ETHTOOL_RING_USE_RX_BUF_LEN = 1,
	ETHTOOL_RING_USE_CQE_SIZE = 2,
	ETHTOOL_RING_USE_TX_PUSH = 4,
	ETHTOOL_RING_USE_RX_PUSH = 8,
	ETHTOOL_RING_USE_TX_PUSH_BUF_LEN = 16,
	ETHTOOL_RING_USE_TCP_DATA_SPLIT = 32,
};

enum ethtool_test_flags {
	ETH_TEST_FL_OFFLINE = 1,
	ETH_TEST_FL_FAILED = 2,
	ETH_TEST_FL_EXTERNAL_LB = 4,
	ETH_TEST_FL_EXTERNAL_LB_DONE = 8,
};

enum event_cause_fcoe {
	PLOGI_ACC_RCVD = 1,
	PLOGI_RJT_RCVD = 2,
	PLOGI_RCVD = 3,
	PLOGO_RCVD = 4,
	PRLI_ACC_RCVD = 5,
	PRLI_RJT_RCVD = 6,
	PRLI_RCVD = 7,
	PRLO_RCVD = 8,
	NPORT_ID_CHGD = 9,
	FLOGO_RCVD = 10,
	CLR_VIRT_LNK_RCVD = 11,
	FLOGI_ACC_RCVD = 12,
	FLOGI_RJT_RCVD = 13,
	FDISC_ACC_RCVD = 14,
	FDISC_RJT_RCVD = 15,
	FLOGI_TMO_MAX_RETRY = 16,
	IMPL_LOGO_ADISC_ACC = 17,
	IMPL_LOGO_ADISC_RJT = 18,
	IMPL_LOGO_ADISC_CNFLT = 19,
	PRLI_TMO = 20,
	ADISC_TMO = 21,
	RSCN_DEV_LOST = 22,
	SCR_ACC_RCVD = 23,
	ADISC_RJT_RCVD = 24,
	LOGO_SNT = 25,
	PROTO_ERR_IMPL_LOGO = 26,
};

enum event_command_flags {
	EVENT_CMD_FL_POST_TRIGGER = 1,
	EVENT_CMD_FL_NEEDS_REC = 2,
};

enum event_trigger_type {
	ETT_NONE = 0,
	ETT_TRACE_ONOFF = 1,
	ETT_SNAPSHOT = 2,
	ETT_STACKTRACE = 4,
	ETT_EVENT_ENABLE = 8,
	ETT_EVENT_HIST = 16,
	ETT_HIST_ENABLE = 32,
	ETT_EVENT_EPROBE = 64,
};

enum event_type_t {
	EVENT_FLEXIBLE = 1,
	EVENT_PINNED = 2,
	EVENT_TIME = 4,
	EVENT_CPU = 8,
	EVENT_CGROUP = 16,
	EVENT_ALL = 3,
};

enum ex_phy_state {
	PHY_EMPTY = 0,
	PHY_VACANT = 1,
	PHY_NOT_PRESENT = 2,
	PHY_DEVICE_DISCOVERED = 3,
};

enum exact_level {
	NOT_EXACT = 0,
	EXACT = 1,
	RANGE_WITHIN = 2,
};

enum exec_status {
	SAS_SAM_STAT_GOOD = 0,
	SAS_SAM_STAT_BUSY = 8,
	SAS_SAM_STAT_TASK_ABORTED = 64,
	SAS_SAM_STAT_CHECK_CONDITION = 2,
	SAS_DEV_NO_RESPONSE = 128,
	SAS_DATA_UNDERRUN = 129,
	SAS_DATA_OVERRUN = 130,
	SAS_INTERRUPTED = 131,
	SAS_QUEUE_FULL = 132,
	SAS_DEVICE_UNKNOWN = 133,
	SAS_OPEN_REJECT = 134,
	SAS_OPEN_TO = 135,
	SAS_PROTO_RESPONSE = 136,
	SAS_PHY_DOWN = 137,
	SAS_NAK_R_ERR = 138,
	SAS_PENDING = 139,
	SAS_ABORTED_TASK = 140,
};

enum execmem_range_flags {
	EXECMEM_KASAN_SHADOW = 1,
};

enum execmem_type {
	EXECMEM_DEFAULT = 0,
	EXECMEM_MODULE_TEXT = 0,
	EXECMEM_KPROBES = 1,
	EXECMEM_FTRACE = 2,
	EXECMEM_BPF = 3,
	EXECMEM_MODULE_DATA = 4,
	EXECMEM_TYPE_MAX = 5,
};

enum ext4_journal_trigger_type {
	EXT4_JTR_ORPHAN_FILE = 0,
	EXT4_JTR_NONE = 1,
};

enum ext4_li_mode {
	EXT4_LI_MODE_PREFETCH_BBITMAP = 0,
	EXT4_LI_MODE_ITABLE = 1,
};

enum fail_dup_mod_reason {
	FAIL_DUP_MOD_BECOMING = 0,
	FAIL_DUP_MOD_LOAD = 1,
};

enum fanotify_event_type {
	FANOTIFY_EVENT_TYPE_FID = 0,
	FANOTIFY_EVENT_TYPE_FID_NAME = 1,
	FANOTIFY_EVENT_TYPE_PATH = 2,
	FANOTIFY_EVENT_TYPE_PATH_PERM = 3,
	FANOTIFY_EVENT_TYPE_OVERFLOW = 4,
	FANOTIFY_EVENT_TYPE_FS_ERROR = 5,
	__FANOTIFY_EVENT_TYPE_NUM = 6,
};

enum fault_flag {
	FAULT_FLAG_WRITE = 1,
	FAULT_FLAG_MKWRITE = 2,
	FAULT_FLAG_ALLOW_RETRY = 4,
	FAULT_FLAG_RETRY_NOWAIT = 8,
	FAULT_FLAG_KILLABLE = 16,
	FAULT_FLAG_TRIED = 32,
	FAULT_FLAG_USER = 64,
	FAULT_FLAG_REMOTE = 128,
	FAULT_FLAG_INSTRUCTION = 256,
	FAULT_FLAG_INTERRUPTIBLE = 512,
	FAULT_FLAG_UNSHARE = 1024,
	FAULT_FLAG_ORIG_PTE_VALID = 2048,
	FAULT_FLAG_VMA_LOCK = 4096,
};

enum fbq_type {
	regular = 0,
	remote = 1,
	all = 2,
};

enum fc4type_t {
	FS_FC4TYPE_FCP = 1,
	FS_FC4TYPE_NVME = 2,
	FS_FCP_IS_N2N = 128,
};

enum fc_ba_rjt_explan {
	FC_BA_RJT_EXP_NONE = 0,
	FC_BA_RJT_INV_XID = 3,
	FC_BA_RJT_ABT = 5,
};

enum fc_ba_rjt_reason {
	FC_BA_RJT_NONE = 0,
	FC_BA_RJT_INVL_CMD = 1,
	FC_BA_RJT_LOG_ERR = 3,
	FC_BA_RJT_LOG_BUSY = 5,
	FC_BA_RJT_PROTO_ERR = 7,
	FC_BA_RJT_UNABLE = 9,
	FC_BA_RJT_VENDOR = 255,
};

enum fc_class {
	FC_CLASS_NONE = 0,
	FC_CLASS_2 = 45,
	FC_CLASS_3 = 46,
	FC_CLASS_4 = 41,
	FC_CLASS_F = 40,
};

enum fc_cos {
	FC_CLASS_2___2 = 4,
	FC_CLASS_3___2 = 8,
	FC_CLASS_2_3 = 12,
};

enum fc_ct_cmd {
	FC_FS_RJT = 32769,
	FC_FS_ACC = 32770,
};

enum fc_ct_explan {
	FC_FS_EXP_NONE = 0,
	FC_FS_EXP_PID = 1,
	FC_FS_EXP_PNAM = 2,
	FC_FS_EXP_NNAM = 3,
	FC_FS_EXP_COS = 4,
	FC_FS_EXP_FTNR = 7,
};

enum fc_ct_fs_type {
	FC_FST_ALIAS = 248,
	FC_FST_MGMT = 250,
	FC_FST_TIME = 251,
	FC_FST_DIR = 252,
};

enum fc_ct_reason {
	FC_FS_RJT_CMD = 1,
	FC_FS_RJT_VER = 2,
	FC_FS_RJT_LOG = 3,
	FC_FS_RJT_IUSIZ = 4,
	FC_FS_RJT_BSY = 5,
	FC_FS_RJT_PROTO = 7,
	FC_FS_RJT_UNABL = 9,
	FC_FS_RJT_UNSUP = 11,
};

enum fc_ct_rev {
	FC_CT_REV = 1,
};

enum fc_diag_cg_sig_freq_types {
	EDC_CG_SIGFREQ_CNT_MIN = 1,
	EDC_CG_SIGFREQ_CNT_MAX = 999,
	EDC_CG_SIGFREQ_SEC = 1,
	EDC_CG_SIGFREQ_MSEC = 2,
};

enum fc_disc_event {
	DISC_EV_NONE = 0,
	DISC_EV_SUCCESS = 1,
	DISC_EV_FAILED = 2,
};

enum fc_edc_cg_signal_cap_types {
	EDC_CG_SIG_NOTSUPPORTED = 0,
	EDC_CG_SIG_WARN_ONLY = 1,
	EDC_CG_SIG_WARN_ALARM = 2,
};

enum fc_els_cmd {
	ELS_LS_RJT = 1,
	ELS_LS_ACC = 2,
	ELS_PLOGI = 3,
	ELS_FLOGI = 4,
	ELS_LOGO = 5,
	ELS_ABTX = 6,
	ELS_RCS = 7,
	ELS_RES = 8,
	ELS_RSS = 9,
	ELS_RSI = 10,
	ELS_ESTS = 11,
	ELS_ESTC = 12,
	ELS_ADVC = 13,
	ELS_RTV = 14,
	ELS_RLS = 15,
	ELS_ECHO = 16,
	ELS_TEST = 17,
	ELS_RRQ = 18,
	ELS_REC = 19,
	ELS_SRR = 20,
	ELS_FPIN = 22,
	ELS_EDC = 23,
	ELS_RDP = 24,
	ELS_RDF = 25,
	ELS_PRLI = 32,
	ELS_PRLO = 33,
	ELS_SCN = 34,
	ELS_TPLS = 35,
	ELS_TPRLO = 36,
	ELS_LCLM = 37,
	ELS_GAID = 48,
	ELS_FACT = 49,
	ELS_FDACDT = 50,
	ELS_NACT = 51,
	ELS_NDACT = 52,
	ELS_QOSR = 64,
	ELS_RVCS = 65,
	ELS_PDISC = 80,
	ELS_FDISC = 81,
	ELS_ADISC = 82,
	ELS_RNC = 83,
	ELS_FARP_REQ = 84,
	ELS_FARP_REPL = 85,
	ELS_RPS = 86,
	ELS_RPL = 87,
	ELS_RPBC = 88,
	ELS_FAN = 96,
	ELS_RSCN = 97,
	ELS_SCR = 98,
	ELS_RNFT = 99,
	ELS_CSR = 104,
	ELS_CSU = 105,
	ELS_LINIT = 112,
	ELS_LSTS = 114,
	ELS_RNID = 120,
	ELS_RLIR = 121,
	ELS_LIRR = 122,
	ELS_SRL = 123,
	ELS_SBRP = 124,
	ELS_RPSC = 125,
	ELS_QSA = 126,
	ELS_EVFP = 127,
	ELS_LKA = 128,
	ELS_AUTH_ELS = 144,
};

enum fc_els_rjt_explan {
	ELS_EXPL_NONE = 0,
	ELS_EXPL_SPP_OPT_ERR = 1,
	ELS_EXPL_SPP_ICTL_ERR = 3,
	ELS_EXPL_AH = 17,
	ELS_EXPL_AH_REQ = 19,
	ELS_EXPL_SID = 21,
	ELS_EXPL_OXID_RXID = 23,
	ELS_EXPL_INPROG = 25,
	ELS_EXPL_PLOGI_REQD = 30,
	ELS_EXPL_INSUF_RES = 41,
	ELS_EXPL_UNAB_DATA = 42,
	ELS_EXPL_UNSUPR = 44,
	ELS_EXPL_INV_LEN = 45,
	ELS_EXPL_NOT_NEIGHBOR = 98,
};

enum fc_els_rjt_reason {
	ELS_RJT_NONE = 0,
	ELS_RJT_INVAL = 1,
	ELS_RJT_LOGIC = 3,
	ELS_RJT_BUSY = 5,
	ELS_RJT_PROT = 7,
	ELS_RJT_UNAB = 9,
	ELS_RJT_UNSUP = 11,
	ELS_RJT_INPROG = 14,
	ELS_RJT_FIP = 32,
	ELS_RJT_VENDOR = 255,
};

enum fc_els_rnid_fmt {
	ELS_RNIDF_NONE = 0,
	ELS_RNIDF_GEN = 223,
};

enum fc_els_rscn_addr_fmt {
	ELS_ADDR_FMT_PORT = 0,
	ELS_ADDR_FMT_AREA = 1,
	ELS_ADDR_FMT_DOM = 2,
	ELS_ADDR_FMT_FAB = 3,
};

enum fc_els_scr_func {
	ELS_SCRF_FAB = 1,
	ELS_SCRF_NPORT = 2,
	ELS_SCRF_FULL = 3,
	ELS_SCRF_CLEAR = 255,
};

enum fc_els_spp_resp {
	FC_SPP_RESP_ACK = 1,
	FC_SPP_RESP_RES = 2,
	FC_SPP_RESP_INIT = 3,
	FC_SPP_RESP_NO_PA = 4,
	FC_SPP_RESP_CONF = 5,
	FC_SPP_RESP_COND = 6,
	FC_SPP_RESP_MULT = 7,
	FC_SPP_RESP_INVL = 8,
};

enum fc_eof {
	FC_EOF_N = 65,
	FC_EOF_T = 66,
	FC_EOF_RT = 68,
	FC_EOF_DT = 70,
	FC_EOF_NI = 73,
	FC_EOF_DTI = 78,
	FC_EOF_RTI = 79,
	FC_EOF_A = 80,
} __attribute__((mode(byte)));

enum fc_fdmi_hba_attr_type {
	FC_FDMI_HBA_ATTR_NODENAME = 1,
	FC_FDMI_HBA_ATTR_MANUFACTURER = 2,
	FC_FDMI_HBA_ATTR_SERIALNUMBER = 3,
	FC_FDMI_HBA_ATTR_MODEL = 4,
	FC_FDMI_HBA_ATTR_MODELDESCRIPTION = 5,
	FC_FDMI_HBA_ATTR_HARDWAREVERSION = 6,
	FC_FDMI_HBA_ATTR_DRIVERVERSION = 7,
	FC_FDMI_HBA_ATTR_OPTIONROMVERSION = 8,
	FC_FDMI_HBA_ATTR_FIRMWAREVERSION = 9,
	FC_FDMI_HBA_ATTR_OSNAMEVERSION = 10,
	FC_FDMI_HBA_ATTR_MAXCTPAYLOAD = 11,
	FC_FDMI_HBA_ATTR_NODESYMBLNAME = 12,
	FC_FDMI_HBA_ATTR_VENDORSPECIFICINFO = 13,
	FC_FDMI_HBA_ATTR_NUMBEROFPORTS = 14,
	FC_FDMI_HBA_ATTR_FABRICNAME = 15,
	FC_FDMI_HBA_ATTR_BIOSVERSION = 16,
	FC_FDMI_HBA_ATTR_BIOSSTATE = 17,
	FC_FDMI_HBA_ATTR_VENDORIDENTIFIER = 224,
};

enum fc_fdmi_port_attr_type {
	FC_FDMI_PORT_ATTR_FC4TYPES = 1,
	FC_FDMI_PORT_ATTR_SUPPORTEDSPEED = 2,
	FC_FDMI_PORT_ATTR_CURRENTPORTSPEED = 3,
	FC_FDMI_PORT_ATTR_MAXFRAMESIZE = 4,
	FC_FDMI_PORT_ATTR_OSDEVICENAME = 5,
	FC_FDMI_PORT_ATTR_HOSTNAME = 6,
	FC_FDMI_PORT_ATTR_NODENAME = 7,
	FC_FDMI_PORT_ATTR_PORTNAME = 8,
	FC_FDMI_PORT_ATTR_SYMBOLICNAME = 9,
	FC_FDMI_PORT_ATTR_PORTTYPE = 10,
	FC_FDMI_PORT_ATTR_SUPPORTEDCLASSSRVC = 11,
	FC_FDMI_PORT_ATTR_FABRICNAME = 12,
	FC_FDMI_PORT_ATTR_CURRENTFC4TYPE = 13,
	FC_FDMI_PORT_ATTR_PORTSTATE = 257,
	FC_FDMI_PORT_ATTR_DISCOVEREDPORTS = 258,
	FC_FDMI_PORT_ATTR_PORTID = 259,
};

enum fc_fdmi_req {
	FC_FDMI_GRHL = 256,
	FC_FDMI_GHAT = 257,
	FC_FDMI_GRPL = 258,
	FC_FDMI_GPAT = 272,
	FC_FDMI_RHBA = 512,
	FC_FDMI_RHAT = 513,
	FC_FDMI_RPRT = 528,
	FC_FDMI_RPA = 529,
	FC_FDMI_DHBA = 768,
	FC_FDMI_DHAT = 769,
	FC_FDMI_DPRT = 784,
	FC_FDMI_DPA = 785,
};

enum fc_fh_type {
	FC_TYPE_BLS___2 = 0,
	FC_TYPE_ELS___2 = 1,
	FC_TYPE_IP___2 = 5,
	FC_TYPE_FCP___2 = 8,
	FC_TYPE_CT = 32,
	FC_TYPE_ILS = 34,
	FC_TYPE_NVME = 40,
};

enum fc_fpin_congn_event_types {
	FPIN_CONGN_CLEAR = 0,
	FPIN_CONGN_LOST_CREDIT = 1,
	FPIN_CONGN_CREDIT_STALL = 2,
	FPIN_CONGN_OVERSUBSCRIPTION = 3,
	FPIN_CONGN_DEVICE_SPEC = 15,
};

enum fc_fpin_congn_severity_types {
	FPIN_CONGN_SEVERITY_WARNING = 241,
	FPIN_CONGN_SEVERITY_ERROR = 247,
};

enum fc_fpin_deli_event_types {
	FPIN_DELI_UNKNOWN = 0,
	FPIN_DELI_TIMEOUT = 1,
	FPIN_DELI_UNABLE_TO_ROUTE = 2,
	FPIN_DELI_DEVICE_SPEC = 15,
};

enum fc_fpin_li_event_types {
	FPIN_LI_UNKNOWN = 0,
	FPIN_LI_LINK_FAILURE = 1,
	FPIN_LI_LOSS_OF_SYNC = 2,
	FPIN_LI_LOSS_OF_SIG = 3,
	FPIN_LI_PRIM_SEQ_ERR = 4,
	FPIN_LI_INVALID_TX_WD = 5,
	FPIN_LI_INVALID_CRC = 6,
	FPIN_LI_DEVICE_SPEC = 15,
};

enum fc_host_event_code {
	FCH_EVT_LIP = 1,
	FCH_EVT_LINKUP = 2,
	FCH_EVT_LINKDOWN = 3,
	FCH_EVT_LIPRESET = 4,
	FCH_EVT_RSCN = 5,
	FCH_EVT_ADAPTER_CHANGE = 259,
	FCH_EVT_PORT_UNKNOWN = 512,
	FCH_EVT_PORT_OFFLINE = 513,
	FCH_EVT_PORT_ONLINE = 514,
	FCH_EVT_PORT_FABRIC = 516,
	FCH_EVT_LINK_UNKNOWN = 1280,
	FCH_EVT_LINK_FPIN = 1281,
	FCH_EVT_LINK_FPIN_ACK = 1282,
	FCH_EVT_VENDOR_UNIQUE = 65535,
};

enum fc_lport_event {
	FC_LPORT_EV_ADD = 0,
	FC_LPORT_EV_DEL = 1,
};

enum fc_lport_state {
	LPORT_ST_DISABLED = 0,
	LPORT_ST_FLOGI = 1,
	LPORT_ST_DNS = 2,
	LPORT_ST_RNN_ID = 3,
	LPORT_ST_RSNN_NN = 4,
	LPORT_ST_RSPN_ID = 5,
	LPORT_ST_RFT_ID = 6,
	LPORT_ST_RFF_ID = 7,
	LPORT_ST_FDMI = 8,
	LPORT_ST_RHBA = 9,
	LPORT_ST_RPA = 10,
	LPORT_ST_DHBA = 11,
	LPORT_ST_DPRT = 12,
	LPORT_ST_SCR = 13,
	LPORT_ST_READY = 14,
	LPORT_ST_LOGO = 15,
	LPORT_ST_RESET = 16,
};

enum fc_ls_tlv_dtag {
	ELS_DTAG_LS_REQ_INFO = 1,
	ELS_DTAG_LNK_FAULT_CAP = 65549,
	ELS_DTAG_CG_SIGNAL_CAP = 65551,
	ELS_DTAG_LNK_INTEGRITY = 131073,
	ELS_DTAG_DELIVERY = 131074,
	ELS_DTAG_PEER_CONGEST = 131075,
	ELS_DTAG_CONGESTION = 131076,
	ELS_DTAG_FPIN_REGISTER = 196609,
};

enum fc_ns_req {
	FC_NS_GA_NXT = 256,
	FC_NS_GI_A = 257,
	FC_NS_GPN_ID = 274,
	FC_NS_GNN_ID = 275,
	FC_NS_GSPN_ID = 280,
	FC_NS_GID_PN = 289,
	FC_NS_GID_NN = 305,
	FC_NS_GID_FT = 369,
	FC_NS_GPN_FT = 370,
	FC_NS_GID_PT = 417,
	FC_NS_RPN_ID = 530,
	FC_NS_RNN_ID = 531,
	FC_NS_RFT_ID = 535,
	FC_NS_RSPN_ID = 536,
	FC_NS_RFF_ID = 543,
	FC_NS_RSNN_NN = 569,
};

enum fc_parse_status {
	FC_PARSE_OK = 0,
	FC_PARSE_FAILURE = 1,
	FC_PARSE_BUSY = 2,
	FC_PARSE_LEN_INVAL = 3,
	FC_PARSE_ACC_INVAL = 4,
	FC_PARSE_PWWN_NOT_EQUAL = 5,
	FC_PARSE_NWWN_NOT_EQUAL = 6,
	FC_PARSE_RXSZ_INVAL = 7,
	FC_PARSE_NOT_FCP = 8,
	FC_PARSE_OPAFLAG_INVAL = 9,
	FC_PARSE_RPAFLAG_INVAL = 10,
	FC_PARSE_OPA_INVAL = 11,
	FC_PARSE_RPA_INVAL = 12,
};

enum fc_pf_rjt_reason {
	FC_RJT_NONE = 0,
	FC_RJT_INVL_DID = 1,
	FC_RJT_INVL_SID = 2,
	FC_RJT_P_UNAV_T = 3,
	FC_RJT_P_UNAV = 4,
	FC_RJT_CLS_UNSUP = 5,
	FC_RJT_DEL_USAGE = 6,
	FC_RJT_TYPE_UNSUP = 7,
	FC_RJT_LINK_CTL = 8,
	FC_RJT_R_CTL = 9,
	FC_RJT_F_CTL = 10,
	FC_RJT_OX_ID = 11,
	FC_RJT_RX_ID = 12,
	FC_RJT_SEQ_ID = 13,
	FC_RJT_DF_CTL = 14,
	FC_RJT_SEQ_CNT = 15,
	FC_RJT_PARAM = 16,
	FC_RJT_EXCH_ERR = 17,
	FC_RJT_PROTO = 18,
	FC_RJT_LEN = 19,
	FC_RJT_UNEXP_ACK = 20,
	FC_RJT_FAB_CLASS = 21,
	FC_RJT_LOGI_REQ = 22,
	FC_RJT_SEQ_XS = 23,
	FC_RJT_EXCH_EST = 24,
	FC_RJT_FAB_UNAV = 26,
	FC_RJT_VC_ID = 27,
	FC_RJT_CS_CTL = 28,
	FC_RJT_INSUF_RES = 29,
	FC_RJT_INVL_CLS = 31,
	FC_RJT_PREEMT_RJT = 32,
	FC_RJT_PREEMT_DIS = 33,
	FC_RJT_MCAST_ERR = 34,
	FC_RJT_MCAST_ET = 35,
	FC_RJT_PRLI_REQ = 36,
	FC_RJT_INVL_ATT = 37,
	FC_RJT_VENDOR = 255,
};

enum fc_port_state {
	FC_PORTSTATE_UNKNOWN = 0,
	FC_PORTSTATE_NOTPRESENT = 1,
	FC_PORTSTATE_ONLINE = 2,
	FC_PORTSTATE_OFFLINE = 3,
	FC_PORTSTATE_BLOCKED = 4,
	FC_PORTSTATE_BYPASSED = 5,
	FC_PORTSTATE_DIAGNOSTICS = 6,
	FC_PORTSTATE_LINKDOWN = 7,
	FC_PORTSTATE_ERROR = 8,
	FC_PORTSTATE_LOOPBACK = 9,
	FC_PORTSTATE_DELETED = 10,
	FC_PORTSTATE_MARGINAL = 11,
};

enum fc_port_type {
	FC_PORTTYPE_UNKNOWN = 0,
	FC_PORTTYPE_OTHER = 1,
	FC_PORTTYPE_NOTPRESENT = 2,
	FC_PORTTYPE_NPORT = 3,
	FC_PORTTYPE_NLPORT = 4,
	FC_PORTTYPE_LPORT = 5,
	FC_PORTTYPE_PTP = 6,
	FC_PORTTYPE_NPIV = 7,
};

enum fc_rctl {
	FC_RCTL_DD_UNCAT = 0,
	FC_RCTL_DD_SOL_DATA = 1,
	FC_RCTL_DD_UNSOL_CTL = 2,
	FC_RCTL_DD_SOL_CTL = 3,
	FC_RCTL_DD_UNSOL_DATA = 4,
	FC_RCTL_DD_DATA_DESC = 5,
	FC_RCTL_DD_UNSOL_CMD = 6,
	FC_RCTL_DD_CMD_STATUS = 7,
	FC_RCTL_ELS_REQ = 34,
	FC_RCTL_ELS_REP = 35,
	FC_RCTL_ELS4_REQ = 50,
	FC_RCTL_ELS4_REP = 51,
	FC_RCTL_VFTH = 80,
	FC_RCTL_IFRH = 81,
	FC_RCTL_ENCH = 82,
	FC_RCTL_BA_NOP = 128,
	FC_RCTL_BA_ABTS = 129,
	FC_RCTL_BA_RMC = 130,
	FC_RCTL_BA_ACC = 132,
	FC_RCTL_BA_RJT = 133,
	FC_RCTL_BA_PRMT = 134,
	FC_RCTL_ACK_1 = 192,
	FC_RCTL_ACK_0 = 193,
	FC_RCTL_P_RJT = 194,
	FC_RCTL_F_RJT = 195,
	FC_RCTL_P_BSY = 196,
	FC_RCTL_F_BSY = 197,
	FC_RCTL_F_BSYL = 198,
	FC_RCTL_LCR = 199,
	FC_RCTL_END = 201,
};

enum fc_rport_event {
	RPORT_EV_NONE = 0,
	RPORT_EV_READY = 1,
	RPORT_EV_FAILED = 2,
	RPORT_EV_STOP = 3,
	RPORT_EV_LOGO = 4,
};

enum fc_rport_state {
	RPORT_ST_INIT = 0,
	RPORT_ST_FLOGI = 1,
	RPORT_ST_PLOGI_WAIT = 2,
	RPORT_ST_PLOGI = 3,
	RPORT_ST_PRLI = 4,
	RPORT_ST_RTV = 5,
	RPORT_ST_READY = 6,
	RPORT_ST_ADISC = 7,
	RPORT_ST_DELETE = 8,
};

enum fc_rpsc_op_speed {
	RPSC_OP_SPEED_1G = 32768,
	RPSC_OP_SPEED_2G = 16384,
	RPSC_OP_SPEED_4G = 8192,
	RPSC_OP_SPEED_10G = 4096,
	RPSC_OP_SPEED_8G = 2048,
	RPSC_OP_SPEED_16G = 1024,
	RPSC_OP_SPEED_NOT_EST = 1,
};

enum fc_rpsc_speed_cap {
	RPSC_SPEED_CAP_1G = 32768,
	RPSC_SPEED_CAP_2G = 16384,
	RPSC_SPEED_CAP_4G = 8192,
	RPSC_SPEED_CAP_10G = 4096,
	RPSC_SPEED_CAP_8G = 2048,
	RPSC_SPEED_CAP_16G = 1024,
	RPSC_SPEED_CAP_UNKNOWN = 1,
};

enum fc_rscn_format {
	FC_RSCN_FORMAT_PORTID = 0,
	FC_RSCN_FORMAT_AREA = 1,
	FC_RSCN_FORMAT_DOMAIN = 2,
	FC_RSCN_FORMAT_FABRIC = 3,
};

enum fc_sof {
	FC_SOF_F = 40,
	FC_SOF_I4 = 41,
	FC_SOF_I2 = 45,
	FC_SOF_I3 = 46,
	FC_SOF_N4 = 49,
	FC_SOF_N2 = 53,
	FC_SOF_N3 = 54,
	FC_SOF_C4 = 57,
} __attribute__((mode(byte)));

enum fc_tgtid_binding_type {
	FC_TGTID_BIND_NONE = 0,
	FC_TGTID_BIND_BY_WWPN = 1,
	FC_TGTID_BIND_BY_WWNN = 2,
	FC_TGTID_BIND_BY_ID = 3,
};

enum fc_tprlo_type {
	FC_GLOBAL_LOGO = 1,
	FC_TPR_LOGO = 2,
};

enum fc_vport_state {
	FC_VPORT_UNKNOWN = 0,
	FC_VPORT_ACTIVE = 1,
	FC_VPORT_DISABLED = 2,
	FC_VPORT_LINKDOWN = 3,
	FC_VPORT_INITIALIZING = 4,
	FC_VPORT_NO_FABRIC_SUPP = 5,
	FC_VPORT_NO_FABRIC_RSCS = 6,
	FC_VPORT_FABRIC_LOGOUT = 7,
	FC_VPORT_FABRIC_REJ_WWN = 8,
	FC_VPORT_FAILED = 9,
};

enum fc_well_known_fid {
	FC_FID_NONE = 0,
	FC_FID_BCAST = 16777215,
	FC_FID_FLOGI = 16777214,
	FC_FID_FCTRL = 16777213,
	FC_FID_DIR_SERV = 16777212,
	FC_FID_TIME_SERV = 16777211,
	FC_FID_MGMT_SERV = 16777210,
	FC_FID_QOS = 16777209,
	FC_FID_ALIASES = 16777208,
	FC_FID_SEC_KEY = 16777207,
	FC_FID_CLOCK = 16777206,
	FC_FID_MCAST_SERV = 16777205,
};

enum fcf_state {
	FCOE_FCF_STATE_UNKNOWN = 0,
	FCOE_FCF_STATE_DISCONNECTED = 1,
	FCOE_FCF_STATE_CONNECTED = 2,
	FCOE_FCF_STATE_DELETED = 3,
};

enum fcnvme_ls_rjt_explan {
	FCNVME_RJT_EXP_NONE = 0,
	FCNVME_RJT_EXP_OXID_RXID = 23,
	FCNVME_RJT_EXP_UNAB_DATA = 42,
	FCNVME_RJT_EXP_INV_LEN = 45,
	FCNVME_RJT_EXP_INV_ERSP_RAT = 64,
	FCNVME_RJT_EXP_INV_CTLR_ID = 65,
	FCNVME_RJT_EXP_INV_QUEUE_ID = 66,
	FCNVME_RJT_EXP_INV_SQSIZE = 67,
	FCNVME_RJT_EXP_INV_HOSTID = 68,
	FCNVME_RJT_EXP_INV_HOSTNQN = 69,
	FCNVME_RJT_EXP_INV_SUBNQN = 70,
};

enum fcnvme_ls_rjt_reason {
	FCNVME_RJT_RC_NONE = 0,
	FCNVME_RJT_RC_INVAL = 1,
	FCNVME_RJT_RC_LOGIC = 3,
	FCNVME_RJT_RC_UNAB = 9,
	FCNVME_RJT_RC_UNSUP = 11,
	FCNVME_RJT_RC_INV_ASSOC = 64,
	FCNVME_RJT_RC_INV_CONN = 65,
	FCNVME_RJT_RC_INV_PARAM = 66,
	FCNVME_RJT_RC_INSUF_RES = 67,
	FCNVME_RJT_RC_VENDOR = 255,
};

enum fcoe_cmn_type {
	FCOE_ELS = 0,
	FCOE_CT = 1,
	FCOE_SCSI_CMD = 2,
	FCOE_UNSOL_ELS = 3,
};

enum fcoe_create_link_state {
	FCOE_CREATE_LINK_DOWN = 0,
	FCOE_CREATE_LINK_UP = 1,
};

enum fcp_iodir {
	FCP_IODIR_NONE = 0,
	FCP_IODIR_WRITE = 1,
	FCP_IODIR_READ = 2,
	FCP_IODIR_RW = 3,
};

enum fcp_residue {
	FCP_NO_RESIDUE = 0,
	FCP_RESID_OVER = 1,
	FCP_RESID_UNDER = 2,
};

enum fcp_resp_rsp_codes {
	FCP_TMF_CMPL = 0,
	FCP_DATA_LEN_INVALID = 1,
	FCP_CMND_FIELDS_INVALID = 2,
	FCP_DATA_PARAM_MISMATCH = 3,
	FCP_TMF_REJECTED = 4,
	FCP_TMF_FAILED = 5,
	FCP_TMF_INVALID_LUN = 9,
};

enum fcp_tm_cmnd {
	FCP_TM_ABORT_TASK_SET = 2,
	FCP_TM_CLEAR_TASK_SET = 4,
	FCP_TM_LUN_RESET = 16,
	FCP_TM_TARGET_RESET = 32,
	FCP_TM_CLEAR_ACA = 64,
};

enum fdmi_hba_attribute_type {
	FDMI_HBA_ATTRIB_NODENAME = 1,
	FDMI_HBA_ATTRIB_MANUFACTURER = 2,
	FDMI_HBA_ATTRIB_SERIALNUM = 3,
	FDMI_HBA_ATTRIB_MODEL = 4,
	FDMI_HBA_ATTRIB_MODEL_DESC = 5,
	FDMI_HBA_ATTRIB_HW_VERSION = 6,
	FDMI_HBA_ATTRIB_DRIVER_VERSION = 7,
	FDMI_HBA_ATTRIB_ROM_VERSION = 8,
	FDMI_HBA_ATTRIB_FW_VERSION = 9,
	FDMI_HBA_ATTRIB_OS_NAME = 10,
	FDMI_HBA_ATTRIB_MAX_CT = 11,
	FDMI_HBA_ATTRIB_NODE_SYM_NAME = 12,
	FDMI_HBA_ATTRIB_VENDOR_INFO = 13,
	FDMI_HBA_ATTRIB_NUM_PORTS = 14,
	FDMI_HBA_ATTRIB_FABRIC_NAME = 15,
	FDMI_HBA_ATTRIB_BIOS_VER = 16,
	FDMI_HBA_ATTRIB_VENDOR_ID = 224,
	FDMI_HBA_ATTRIB_MAX_TYPE = 225,
};

enum fdmi_port_attribute_type {
	FDMI_PORT_ATTRIB_FC4_TYPES = 1,
	FDMI_PORT_ATTRIB_SUPP_SPEED = 2,
	FDMI_PORT_ATTRIB_PORT_SPEED = 3,
	FDMI_PORT_ATTRIB_FRAME_SIZE = 4,
	FDMI_PORT_ATTRIB_DEV_NAME = 5,
	FDMI_PORT_ATTRIB_HOST_NAME = 6,
	FDMI_PORT_ATTRIB_NODE_NAME = 7,
	FDMI_PORT_ATTRIB_PORT_NAME = 8,
	FDMI_PORT_ATTRIB_PORT_SYM_NAME = 9,
	FDMI_PORT_ATTRIB_PORT_TYPE = 10,
	FDMI_PORT_ATTRIB_SUPP_COS = 11,
	FDMI_PORT_ATTRIB_PORT_FAB_NAME = 12,
	FDMI_PORT_ATTRIB_PORT_FC4_TYPE = 13,
	FDMI_PORT_ATTRIB_PORT_STATE = 257,
	FDMI_PORT_ATTRIB_PORT_NUM_RPRT = 258,
	FDMI_PORT_ATTR_MAX_TYPE = 259,
};

enum fetch_op {
	FETCH_OP_NOP = 0,
	FETCH_OP_REG = 1,
	FETCH_OP_STACK = 2,
	FETCH_OP_STACKP = 3,
	FETCH_OP_RETVAL = 4,
	FETCH_OP_IMM = 5,
	FETCH_OP_COMM = 6,
	FETCH_OP_ARG = 7,
	FETCH_OP_FOFFS = 8,
	FETCH_OP_DATA = 9,
	FETCH_OP_EDATA = 10,
	FETCH_OP_DEREF = 11,
	FETCH_OP_UDEREF = 12,
	FETCH_OP_ST_RAW = 13,
	FETCH_OP_ST_MEM = 14,
	FETCH_OP_ST_UMEM = 15,
	FETCH_OP_ST_STRING = 16,
	FETCH_OP_ST_USTRING = 17,
	FETCH_OP_ST_SYMSTR = 18,
	FETCH_OP_ST_EDATA = 19,
	FETCH_OP_MOD_BF = 20,
	FETCH_OP_LP_ARRAY = 21,
	FETCH_OP_TP_ARG = 22,
	FETCH_OP_END = 23,
	FETCH_NOP_SYMBOL = 24,
};

enum fib6_walk_state {
	FWS_S = 0,
	FWS_L = 1,
	FWS_R = 2,
	FWS_C = 3,
	FWS_U = 4,
};

enum fib_event_type {
	FIB_EVENT_ENTRY_REPLACE = 0,
	FIB_EVENT_ENTRY_APPEND = 1,
	FIB_EVENT_ENTRY_ADD = 2,
	FIB_EVENT_ENTRY_DEL = 3,
	FIB_EVENT_RULE_ADD = 4,
	FIB_EVENT_RULE_DEL = 5,
	FIB_EVENT_NH_ADD = 6,
	FIB_EVENT_NH_DEL = 7,
	FIB_EVENT_VIF_ADD = 8,
	FIB_EVENT_VIF_DEL = 9,
};

enum fib_xfer_state {
	HostOwned = 1,
	AdapterOwned = 2,
	FibInitialized = 4,
	FibEmpty = 8,
	AllocatedFromPool = 16,
	SentFromHost = 32,
	SentFromAdapter = 64,
	ResponseExpected = 128,
	NoResponseExpected = 256,
	AdapterProcessed = 512,
	HostProcessed = 1024,
	HighPriority = 2048,
	NormalPriority = 4096,
	Async = 8192,
	AsyncIo = 8192,
	PageFileIo = 16384,
	ShutdownRequest = 32768,
	LazyWrite = 65536,
	AdapterMicroFib = 131072,
	BIOSFibPath = 262144,
	FastResponseCapable = 524288,
	ApiFib = 1048576,
	NoMoreAifDataAvailable = 2097152,
};

enum fid_type {
	FILEID_ROOT = 0,
	FILEID_INO32_GEN = 1,
	FILEID_INO32_GEN_PARENT = 2,
	FILEID_BTRFS_WITHOUT_PARENT = 77,
	FILEID_BTRFS_WITH_PARENT = 78,
	FILEID_BTRFS_WITH_PARENT_ROOT = 79,
	FILEID_UDF_WITHOUT_PARENT = 81,
	FILEID_UDF_WITH_PARENT = 82,
	FILEID_NILFS_WITHOUT_PARENT = 97,
	FILEID_NILFS_WITH_PARENT = 98,
	FILEID_FAT_WITHOUT_PARENT = 113,
	FILEID_FAT_WITH_PARENT = 114,
	FILEID_INO64_GEN = 129,
	FILEID_INO64_GEN_PARENT = 130,
	FILEID_LUSTRE = 151,
	FILEID_BCACHEFS_WITHOUT_PARENT = 177,
	FILEID_BCACHEFS_WITH_PARENT = 178,
	FILEID_KERNFS = 254,
	FILEID_INVALID = 255,
};

enum field_op_id {
	FIELD_OP_NONE = 0,
	FIELD_OP_PLUS = 1,
	FIELD_OP_MINUS = 2,
	FIELD_OP_UNARY_MINUS = 3,
	FIELD_OP_DIV = 4,
	FIELD_OP_MULT = 5,
};

enum file_time_flags {
	S_ATIME = 1,
	S_MTIME = 2,
	S_CTIME = 4,
	S_VERSION = 8,
};

enum filter_op_ids {
	OP_GLOB = 0,
	OP_NE = 1,
	OP_EQ = 2,
	OP_LE = 3,
	OP_LT = 4,
	OP_GE = 5,
	OP_GT = 6,
	OP_BAND = 7,
	OP_MAX = 8,
};

enum filter_pred_fn {
	FILTER_PRED_FN_NOP = 0,
	FILTER_PRED_FN_64 = 1,
	FILTER_PRED_FN_64_CPUMASK = 2,
	FILTER_PRED_FN_S64 = 3,
	FILTER_PRED_FN_U64 = 4,
	FILTER_PRED_FN_32 = 5,
	FILTER_PRED_FN_32_CPUMASK = 6,
	FILTER_PRED_FN_S32 = 7,
	FILTER_PRED_FN_U32 = 8,
	FILTER_PRED_FN_16 = 9,
	FILTER_PRED_FN_16_CPUMASK = 10,
	FILTER_PRED_FN_S16 = 11,
	FILTER_PRED_FN_U16 = 12,
	FILTER_PRED_FN_8 = 13,
	FILTER_PRED_FN_8_CPUMASK = 14,
	FILTER_PRED_FN_S8 = 15,
	FILTER_PRED_FN_U8 = 16,
	FILTER_PRED_FN_COMM = 17,
	FILTER_PRED_FN_STRING = 18,
	FILTER_PRED_FN_STRLOC = 19,
	FILTER_PRED_FN_STRRELLOC = 20,
	FILTER_PRED_FN_PCHAR_USER = 21,
	FILTER_PRED_FN_PCHAR = 22,
	FILTER_PRED_FN_CPU = 23,
	FILTER_PRED_FN_CPU_CPUMASK = 24,
	FILTER_PRED_FN_CPUMASK = 25,
	FILTER_PRED_FN_CPUMASK_CPU = 26,
	FILTER_PRED_FN_FUNCTION = 27,
	FILTER_PRED_FN_ = 28,
	FILTER_PRED_TEST_VISITED = 29,
};

enum finalization_type {
	FINALIZATION_TYPE_FINAL = 0,
	FINALIZATION_TYPE_FINUP = 1,
	FINALIZATION_TYPE_DIGEST = 2,
};

enum fip_conn_type {
	FIP_CONN_TYPE_UNKNOWN = 0,
	FIP_CONN_TYPE_FABRIC = 1,
	FIP_CONN_TYPE_VN2VN = 2,
};

enum fip_desc_type {
	FIP_DT_PRI = 1,
	FIP_DT_MAC = 2,
	FIP_DT_MAP_OUI = 3,
	FIP_DT_NAME = 4,
	FIP_DT_FAB = 5,
	FIP_DT_FCOE_SIZE = 6,
	FIP_DT_FLOGI = 7,
	FIP_DT_FDISC = 8,
	FIP_DT_LOGO = 9,
	FIP_DT_ELP = 10,
	FIP_DT_VN_ID = 11,
	FIP_DT_FKA = 12,
	FIP_DT_VENDOR = 13,
	FIP_DT_VLAN = 14,
	FIP_DT_FC4F = 15,
	FIP_DT_LIMIT = 16,
	FIP_DT_NON_CRITICAL = 128,
	FIP_DT_CLR_VLINKS = 128,
	FIP_DT_VENDOR_BASE = 241,
};

enum fip_disc_subcode {
	FIP_SC_SOL = 1,
	FIP_SC_ADV = 2,
};

enum fip_fka_flags {
	FIP_FKA_ADV_D = 1,
};

enum fip_flag {
	FIP_FL_FPMA = 32768,
	FIP_FL_SPMA = 16384,
	FIP_FL_FCF = 32,
	FIP_FL_FDF = 16,
	FIP_FL_REC_OR_P2P = 8,
	FIP_FL_AVAIL = 4,
	FIP_FL_SOL = 2,
	FIP_FL_FPORT = 1,
};

enum fip_mode {
	FIP_MODE_AUTO = 0,
	FIP_MODE_NON_FIP = 1,
	FIP_MODE_FABRIC = 2,
	FIP_MODE_VN2VN = 3,
};

enum fip_opcode {
	FIP_OP_DISC = 1,
	FIP_OP_LS = 2,
	FIP_OP_CTRL = 3,
	FIP_OP_VLAN = 4,
	FIP_OP_VN2VN = 5,
	FIP_OP_VENDOR_MIN = 65528,
	FIP_OP_VENDOR_MAX = 65534,
};

enum fip_reset_subcode {
	FIP_SC_KEEP_ALIVE = 1,
	FIP_SC_CLR_VLINK = 2,
};

enum fip_state {
	FIP_ST_DISABLED = 0,
	FIP_ST_LINK_WAIT = 1,
	FIP_ST_AUTO = 2,
	FIP_ST_NON_FIP = 3,
	FIP_ST_ENABLED = 4,
	FIP_ST_VNMP_START = 5,
	FIP_ST_VNMP_PROBE1 = 6,
	FIP_ST_VNMP_PROBE2 = 7,
	FIP_ST_VNMP_CLAIM = 8,
	FIP_ST_VNMP_UP = 9,
};

enum fip_trans_subcode {
	FIP_SC_REQ = 1,
	FIP_SC_REP = 2,
};

enum fip_vlan_subcode {
	FIP_SC_VL_REQ = 1,
	FIP_SC_VL_NOTE = 2,
	FIP_SC_VL_VN2VN_NOTE = 3,
};

enum fip_vn2vn_subcode {
	FIP_SC_VN_PROBE_REQ = 1,
	FIP_SC_VN_PROBE_REP = 2,
	FIP_SC_VN_CLAIM_NOTIFY = 3,
	FIP_SC_VN_CLAIM_REP = 4,
	FIP_SC_VN_BEACON = 5,
};

enum fit_type {
	NOTHING_FIT = 0,
	FL_FIT_TYPE = 1,
	LE_FIT_TYPE = 2,
	RE_FIT_TYPE = 3,
	NE_FIT_TYPE = 4,
};

enum fixed_addresses {
	FIX_HOLE = 0,
	__end_of_permanent_fixed_addresses = 1,
	FIX_BTMAP_END = 1,
	FIX_BTMAP_BEGIN = 64,
	__end_of_fixed_addresses = 65,
};

enum flag_idn {
	QUERY_FLAG_IDN_FDEVICEINIT = 1,
	QUERY_FLAG_IDN_PERMANENT_WPE = 2,
	QUERY_FLAG_IDN_PWR_ON_WPE = 3,
	QUERY_FLAG_IDN_BKOPS_EN = 4,
	QUERY_FLAG_IDN_LIFE_SPAN_MODE_ENABLE = 5,
	QUERY_FLAG_IDN_PURGE_ENABLE = 6,
	QUERY_FLAG_IDN_RESERVED2 = 7,
	QUERY_FLAG_IDN_FPHYRESOURCEREMOVAL = 8,
	QUERY_FLAG_IDN_BUSY_RTC = 9,
	QUERY_FLAG_IDN_RESERVED3 = 10,
	QUERY_FLAG_IDN_PERMANENTLY_DISABLE_FW_UPDATE = 11,
	QUERY_FLAG_IDN_WB_EN = 14,
	QUERY_FLAG_IDN_WB_BUFF_FLUSH_EN = 15,
	QUERY_FLAG_IDN_WB_BUFF_FLUSH_DURING_HIBERN8 = 16,
	QUERY_FLAG_IDN_HPB_RESET = 17,
	QUERY_FLAG_IDN_HPB_EN = 18,
};

enum flow_action_hw_stats {
	FLOW_ACTION_HW_STATS_IMMEDIATE = 1,
	FLOW_ACTION_HW_STATS_DELAYED = 2,
	FLOW_ACTION_HW_STATS_ANY = 3,
	FLOW_ACTION_HW_STATS_DISABLED = 4,
	FLOW_ACTION_HW_STATS_DONT_CARE = 7,
};

enum flow_action_hw_stats_bit {
	FLOW_ACTION_HW_STATS_IMMEDIATE_BIT = 0,
	FLOW_ACTION_HW_STATS_DELAYED_BIT = 1,
	FLOW_ACTION_HW_STATS_DISABLED_BIT = 2,
	FLOW_ACTION_HW_STATS_NUM_BITS = 3,
};

enum flow_action_id {
	FLOW_ACTION_ACCEPT = 0,
	FLOW_ACTION_DROP = 1,
	FLOW_ACTION_TRAP = 2,
	FLOW_ACTION_GOTO = 3,
	FLOW_ACTION_REDIRECT = 4,
	FLOW_ACTION_MIRRED = 5,
	FLOW_ACTION_REDIRECT_INGRESS = 6,
	FLOW_ACTION_MIRRED_INGRESS = 7,
	FLOW_ACTION_VLAN_PUSH = 8,
	FLOW_ACTION_VLAN_POP = 9,
	FLOW_ACTION_VLAN_MANGLE = 10,
	FLOW_ACTION_TUNNEL_ENCAP = 11,
	FLOW_ACTION_TUNNEL_DECAP = 12,
	FLOW_ACTION_MANGLE = 13,
	FLOW_ACTION_ADD = 14,
	FLOW_ACTION_CSUM = 15,
	FLOW_ACTION_MARK = 16,
	FLOW_ACTION_PTYPE = 17,
	FLOW_ACTION_PRIORITY = 18,
	FLOW_ACTION_RX_QUEUE_MAPPING = 19,
	FLOW_ACTION_WAKE = 20,
	FLOW_ACTION_QUEUE = 21,
	FLOW_ACTION_SAMPLE = 22,
	FLOW_ACTION_POLICE = 23,
	FLOW_ACTION_CT = 24,
	FLOW_ACTION_CT_METADATA = 25,
	FLOW_ACTION_MPLS_PUSH = 26,
	FLOW_ACTION_MPLS_POP = 27,
	FLOW_ACTION_MPLS_MANGLE = 28,
	FLOW_ACTION_GATE = 29,
	FLOW_ACTION_PPPOE_PUSH = 30,
	FLOW_ACTION_JUMP = 31,
	FLOW_ACTION_PIPE = 32,
	FLOW_ACTION_VLAN_PUSH_ETH = 33,
	FLOW_ACTION_VLAN_POP_ETH = 34,
	FLOW_ACTION_CONTINUE = 35,
	NUM_FLOW_ACTIONS = 36,
};

enum flow_action_mangle_base {
	FLOW_ACT_MANGLE_UNSPEC = 0,
	FLOW_ACT_MANGLE_HDR_TYPE_ETH = 1,
	FLOW_ACT_MANGLE_HDR_TYPE_IP4 = 2,
	FLOW_ACT_MANGLE_HDR_TYPE_IP6 = 3,
	FLOW_ACT_MANGLE_HDR_TYPE_TCP = 4,
	FLOW_ACT_MANGLE_HDR_TYPE_UDP = 5,
};

enum flow_block_binder_type {
	FLOW_BLOCK_BINDER_TYPE_UNSPEC = 0,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_INGRESS = 1,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_EGRESS = 2,
	FLOW_BLOCK_BINDER_TYPE_RED_EARLY_DROP = 3,
	FLOW_BLOCK_BINDER_TYPE_RED_MARK = 4,
};

enum flow_block_command {
	FLOW_BLOCK_BIND = 0,
	FLOW_BLOCK_UNBIND = 1,
};

enum flow_cls_command {
	FLOW_CLS_REPLACE = 0,
	FLOW_CLS_DESTROY = 1,
	FLOW_CLS_STATS = 2,
	FLOW_CLS_TMPLT_CREATE = 3,
	FLOW_CLS_TMPLT_DESTROY = 4,
};

enum flow_dissect_ret {
	FLOW_DISSECT_RET_OUT_GOOD = 0,
	FLOW_DISSECT_RET_OUT_BAD = 1,
	FLOW_DISSECT_RET_PROTO_AGAIN = 2,
	FLOW_DISSECT_RET_IPPROTO_AGAIN = 3,
	FLOW_DISSECT_RET_CONTINUE = 4,
};

enum flow_dissector_key_id {
	FLOW_DISSECTOR_KEY_CONTROL = 0,
	FLOW_DISSECTOR_KEY_BASIC = 1,
	FLOW_DISSECTOR_KEY_IPV4_ADDRS = 2,
	FLOW_DISSECTOR_KEY_IPV6_ADDRS = 3,
	FLOW_DISSECTOR_KEY_PORTS = 4,
	FLOW_DISSECTOR_KEY_PORTS_RANGE = 5,
	FLOW_DISSECTOR_KEY_ICMP = 6,
	FLOW_DISSECTOR_KEY_ETH_ADDRS = 7,
	FLOW_DISSECTOR_KEY_TIPC = 8,
	FLOW_DISSECTOR_KEY_ARP = 9,
	FLOW_DISSECTOR_KEY_VLAN = 10,
	FLOW_DISSECTOR_KEY_FLOW_LABEL = 11,
	FLOW_DISSECTOR_KEY_GRE_KEYID = 12,
	FLOW_DISSECTOR_KEY_MPLS_ENTROPY = 13,
	FLOW_DISSECTOR_KEY_ENC_KEYID = 14,
	FLOW_DISSECTOR_KEY_ENC_IPV4_ADDRS = 15,
	FLOW_DISSECTOR_KEY_ENC_IPV6_ADDRS = 16,
	FLOW_DISSECTOR_KEY_ENC_CONTROL = 17,
	FLOW_DISSECTOR_KEY_ENC_PORTS = 18,
	FLOW_DISSECTOR_KEY_MPLS = 19,
	FLOW_DISSECTOR_KEY_TCP = 20,
	FLOW_DISSECTOR_KEY_IP = 21,
	FLOW_DISSECTOR_KEY_CVLAN = 22,
	FLOW_DISSECTOR_KEY_ENC_IP = 23,
	FLOW_DISSECTOR_KEY_ENC_OPTS = 24,
	FLOW_DISSECTOR_KEY_META = 25,
	FLOW_DISSECTOR_KEY_CT = 26,
	FLOW_DISSECTOR_KEY_HASH = 27,
	FLOW_DISSECTOR_KEY_NUM_OF_VLANS = 28,
	FLOW_DISSECTOR_KEY_PPPOE = 29,
	FLOW_DISSECTOR_KEY_L2TPV3 = 30,
	FLOW_DISSECTOR_KEY_CFM = 31,
	FLOW_DISSECTOR_KEY_IPSEC = 32,
	FLOW_DISSECTOR_KEY_MAX = 33,
};

enum flowlabel_reflect {
	FLOWLABEL_REFLECT_ESTABLISHED = 1,
	FLOWLABEL_REFLECT_TCP_RESET = 2,
	FLOWLABEL_REFLECT_ICMPV6_ECHO_REPLIES = 4,
};

enum flush_type {
	FLUSH_TYPE_NONE = 0,
	FLUSH_TYPE_FLUSH = 1,
	FLUSH_TYPE_REIMPORT = 2,
};

enum folio_references {
	FOLIOREF_RECLAIM = 0,
	FOLIOREF_RECLAIM_CLEAN = 1,
	FOLIOREF_KEEP = 2,
	FOLIOREF_ACTIVATE = 3,
};

enum format_type {
	FORMAT_TYPE_NONE = 0,
	FORMAT_TYPE_WIDTH = 1,
	FORMAT_TYPE_PRECISION = 2,
	FORMAT_TYPE_CHAR = 3,
	FORMAT_TYPE_STR = 4,
	FORMAT_TYPE_PTR = 5,
	FORMAT_TYPE_PERCENT_CHAR = 6,
	FORMAT_TYPE_INVALID = 7,
	FORMAT_TYPE_LONG_LONG = 8,
	FORMAT_TYPE_ULONG = 9,
	FORMAT_TYPE_LONG = 10,
	FORMAT_TYPE_UBYTE = 11,
	FORMAT_TYPE_BYTE = 12,
	FORMAT_TYPE_USHORT = 13,
	FORMAT_TYPE_SHORT = 14,
	FORMAT_TYPE_UINT = 15,
	FORMAT_TYPE_INT = 16,
	FORMAT_TYPE_SIZE_T = 17,
	FORMAT_TYPE_PTRDIFF = 18,
};

enum fortify_func {
	FORTIFY_FUNC_strncpy = 0,
	FORTIFY_FUNC_strnlen = 1,
	FORTIFY_FUNC_strlen = 2,
	FORTIFY_FUNC_strscpy = 3,
	FORTIFY_FUNC_strlcat = 4,
	FORTIFY_FUNC_strcat = 5,
	FORTIFY_FUNC_strncat = 6,
	FORTIFY_FUNC_memset = 7,
	FORTIFY_FUNC_memcpy = 8,
	FORTIFY_FUNC_memmove = 9,
	FORTIFY_FUNC_memscan = 10,
	FORTIFY_FUNC_memcmp = 11,
	FORTIFY_FUNC_memchr = 12,
	FORTIFY_FUNC_memchr_inv = 13,
	FORTIFY_FUNC_kmemdup = 14,
	FORTIFY_FUNC_strcpy = 15,
	FORTIFY_FUNC_UNKNOWN = 16,
};

enum framer_clock_type {
	FRAMER_CLOCK_EXT = 0,
	FRAMER_CLOCK_INT = 1,
};

enum framer_event {
	FRAMER_EVENT_STATUS = 0,
};

enum framer_iface {
	FRAMER_IFACE_E1 = 0,
	FRAMER_IFACE_T1 = 1,
};

enum freeze_holder {
	FREEZE_HOLDER_KERNEL = 1,
	FREEZE_HOLDER_USERSPACE = 2,
	FREEZE_MAY_NEST = 4,
};

enum freezer_state_flags {
	CGROUP_FREEZER_ONLINE = 1,
	CGROUP_FREEZING_SELF = 2,
	CGROUP_FREEZING_PARENT = 4,
	CGROUP_FROZEN = 8,
	CGROUP_FREEZING = 6,
};

enum freq_qos_req_type {
	FREQ_QOS_MIN = 1,
	FREQ_QOS_MAX = 2,
};

enum fs_context_phase {
	FS_CONTEXT_CREATE_PARAMS = 0,
	FS_CONTEXT_CREATING = 1,
	FS_CONTEXT_AWAITING_MOUNT = 2,
	FS_CONTEXT_AWAITING_RECONF = 3,
	FS_CONTEXT_RECONF_PARAMS = 4,
	FS_CONTEXT_RECONFIGURING = 5,
	FS_CONTEXT_FAILED = 6,
};

enum fs_context_purpose {
	FS_CONTEXT_FOR_MOUNT = 0,
	FS_CONTEXT_FOR_SUBMOUNT = 1,
	FS_CONTEXT_FOR_RECONFIGURE = 2,
};

enum fs_value_type {
	fs_value_is_undefined = 0,
	fs_value_is_flag = 1,
	fs_value_is_string = 2,
	fs_value_is_blob = 3,
	fs_value_is_filename = 4,
	fs_value_is_file = 5,
};

enum fsconfig_command {
	FSCONFIG_SET_FLAG = 0,
	FSCONFIG_SET_STRING = 1,
	FSCONFIG_SET_BINARY = 2,
	FSCONFIG_SET_PATH = 3,
	FSCONFIG_SET_PATH_EMPTY = 4,
	FSCONFIG_SET_FD = 5,
	FSCONFIG_CMD_CREATE = 6,
	FSCONFIG_CMD_RECONFIGURE = 7,
	FSCONFIG_CMD_CREATE_EXCL = 8,
};

enum fsl_mc_pool_type {
	FSL_MC_POOL_DPMCP = 0,
	FSL_MC_POOL_DPBP = 1,
	FSL_MC_POOL_DPCON = 2,
	FSL_MC_POOL_IRQ = 3,
	FSL_MC_NUM_POOL_TYPES = 4,
};

enum fsnotify_data_type {
	FSNOTIFY_EVENT_NONE = 0,
	FSNOTIFY_EVENT_PATH = 1,
	FSNOTIFY_EVENT_INODE = 2,
	FSNOTIFY_EVENT_DENTRY = 3,
	FSNOTIFY_EVENT_ERROR = 4,
};

enum fsnotify_group_prio {
	FSNOTIFY_PRIO_NORMAL = 0,
	FSNOTIFY_PRIO_CONTENT = 1,
	FSNOTIFY_PRIO_PRE_CONTENT = 2,
	__FSNOTIFY_PRIO_NUM = 3,
};

enum fsnotify_iter_type {
	FSNOTIFY_ITER_TYPE_INODE = 0,
	FSNOTIFY_ITER_TYPE_VFSMOUNT = 1,
	FSNOTIFY_ITER_TYPE_SB = 2,
	FSNOTIFY_ITER_TYPE_PARENT = 3,
	FSNOTIFY_ITER_TYPE_INODE2 = 4,
	FSNOTIFY_ITER_TYPE_COUNT = 5,
};

enum fsnotify_obj_type {
	FSNOTIFY_OBJ_TYPE_ANY = -1,
	FSNOTIFY_OBJ_TYPE_INODE = 0,
	FSNOTIFY_OBJ_TYPE_VFSMOUNT = 1,
	FSNOTIFY_OBJ_TYPE_SB = 2,
	FSNOTIFY_OBJ_TYPE_COUNT = 3,
	FSNOTIFY_OBJ_TYPE_DETACHED = 3,
};

enum ftrace_bug_type {
	FTRACE_BUG_UNKNOWN = 0,
	FTRACE_BUG_INIT = 1,
	FTRACE_BUG_NOP = 2,
	FTRACE_BUG_CALL = 3,
	FTRACE_BUG_UPDATE = 4,
};

enum ftrace_dump_mode {
	DUMP_NONE = 0,
	DUMP_ALL = 1,
	DUMP_ORIG = 2,
	DUMP_PARAM = 3,
};

enum ftrace_ops_cmd {
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_SELF = 0,
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_PEER = 1,
	FTRACE_OPS_CMD_DISABLE_SHARE_IPMODIFY_PEER = 2,
};

enum fullness_group {
	ZS_INUSE_RATIO_0 = 0,
	ZS_INUSE_RATIO_10 = 1,
	ZS_INUSE_RATIO_99 = 10,
	ZS_INUSE_RATIO_100 = 11,
	NR_FULLNESS_GROUPS = 12,
};

enum futex_access {
	FUTEX_READ = 0,
	FUTEX_WRITE = 1,
};

enum fw_caps {
	FW_CAPS_UNKNOWN = 0,
	FW_CAPS16 = 1,
	FW_CAPS32 = 2,
};

enum fw_caps_config_fcoe {
	FW_CAPS_CONFIG_FCOE_INITIATOR = 1,
	FW_CAPS_CONFIG_FCOE_TARGET = 2,
	FW_CAPS_CONFIG_FCOE_CTRL_OFLD = 4,
};

enum fw_cmd_opcodes {
	FW_LDST_CMD = 1,
	FW_RESET_CMD = 3,
	FW_HELLO_CMD = 4,
	FW_BYE_CMD = 5,
	FW_INITIALIZE_CMD = 6,
	FW_CAPS_CONFIG_CMD = 7,
	FW_PARAMS_CMD = 8,
	FW_PFVF_CMD = 9,
	FW_IQ_CMD = 16,
	FW_EQ_MNGT_CMD = 17,
	FW_EQ_ETH_CMD = 18,
	FW_EQ_CTRL_CMD = 19,
	FW_EQ_OFLD_CMD = 33,
	FW_VI_CMD = 20,
	FW_VI_MAC_CMD = 21,
	FW_VI_RXMODE_CMD = 22,
	FW_VI_ENABLE_CMD = 23,
	FW_ACL_MAC_CMD = 24,
	FW_ACL_VLAN_CMD = 25,
	FW_VI_STATS_CMD = 26,
	FW_PORT_CMD = 27,
	FW_PORT_STATS_CMD = 28,
	FW_PORT_LB_STATS_CMD = 29,
	FW_PORT_TRACE_CMD = 30,
	FW_PORT_TRACE_MMAP_CMD = 31,
	FW_RSS_IND_TBL_CMD = 32,
	FW_RSS_GLB_CONFIG_CMD = 34,
	FW_RSS_VI_CONFIG_CMD = 35,
	FW_SCHED_CMD = 36,
	FW_DEVLOG_CMD = 37,
	FW_CLIP_CMD = 40,
	FW_PTP_CMD = 62,
	FW_HMA_CMD = 63,
	FW_LASTC2E_CMD = 64,
	FW_ERROR_CMD = 128,
	FW_DEBUG_CMD = 129,
};

enum fw_cmd_stor_opcodes {
	FW_FCOE_RES_INFO_CMD = 49,
	FW_FCOE_LINK_CMD = 50,
	FW_FCOE_VNP_CMD = 51,
	FW_FCOE_SPARAMS_CMD = 53,
	FW_FCOE_STATS_CMD = 55,
	FW_FCOE_FCF_CMD = 56,
};

enum fw_event_type {
	fw_event_null = 0,
	fw_event_lun_change = 1,
	fw_event_present = 2,
	fw_event_not_present = 3,
	fw_event_vda_ae = 4,
};

enum fw_fcoe_link_status {
	FCOE_LINKDOWN = 0,
	FCOE_LINKUP = 1,
};

enum fw_fcoe_link_sub_op {
	FCOE_LINK_DOWN = 0,
	FCOE_LINK_UP = 1,
	FCOE_LINK_COND = 2,
};

enum fw_hdr_chip {
	FW_HDR_CHIP_T4 = 0,
	FW_HDR_CHIP_T5 = 1,
	FW_HDR_CHIP_T6 = 2,
};

enum fw_hdr_flags {
	FW_HDR_FLAGS_RESET_HALT = 1,
};

enum fw_hdr_intfver {
	FW_HDR_INTFVER_NIC = 0,
	FW_HDR_INTFVER_VNIC = 0,
	FW_HDR_INTFVER_OFLD = 0,
	FW_HDR_INTFVER_RI = 0,
	FW_HDR_INTFVER_ISCSIPDU = 0,
	FW_HDR_INTFVER_ISCSI = 0,
	FW_HDR_INTFVER_FCOEPDU = 0,
	FW_HDR_INTFVER_FCOE = 0,
};

enum fw_hellow_cmd {
	fw_hello_cmd_stage_os = 0,
};

enum fw_iq_type {
	FW_IQ_TYPE_FL_INT_CAP = 0,
	FW_IQ_TYPE_NO_FL_INT_CAP = 1,
};

enum fw_ldst_addrspc {
	FW_LDST_ADDRSPC_FIRMWARE = 1,
	FW_LDST_ADDRSPC_SGE_EGRC = 8,
	FW_LDST_ADDRSPC_SGE_INGC = 9,
	FW_LDST_ADDRSPC_SGE_FLMC = 10,
	FW_LDST_ADDRSPC_SGE_CONMC = 11,
	FW_LDST_ADDRSPC_TP_PIO = 16,
	FW_LDST_ADDRSPC_TP_TM_PIO = 17,
	FW_LDST_ADDRSPC_TP_MIB = 18,
	FW_LDST_ADDRSPC_MDIO = 24,
	FW_LDST_ADDRSPC_MPS = 32,
	FW_LDST_ADDRSPC_FUNC = 40,
	FW_LDST_ADDRSPC_FUNC_PCIE = 41,
	FW_LDST_ADDRSPC_I2C = 56,
};

enum fw_memtype_cf {
	FW_MEMTYPE_CF_EDC0 = 0,
	FW_MEMTYPE_CF_EDC1 = 1,
	FW_MEMTYPE_CF_EXTMEM = 2,
	FW_MEMTYPE_CF_FLASH = 4,
	FW_MEMTYPE_CF_INTERNAL = 5,
	FW_MEMTYPE_CF_EXTMEM1 = 6,
	FW_MEMTYPE_CF_HMA = 7,
};

enum fw_ofld_prot {
	PROT_FCOE = 1,
	PROT_ISCSI = 2,
};

enum fw_opt {
	FW_OPT_UEVENT = 1,
	FW_OPT_NOWAIT = 2,
	FW_OPT_USERHELPER = 4,
	FW_OPT_NO_WARN = 8,
	FW_OPT_NOCACHE = 16,
	FW_OPT_NOFALLBACK_SYSFS = 32,
	FW_OPT_FALLBACK_PLATFORM = 64,
	FW_OPT_PARTIAL = 128,
};

enum fw_params_mnem {
	FW_PARAMS_MNEM_DEV = 1,
	FW_PARAMS_MNEM_PFVF = 2,
	FW_PARAMS_MNEM_REG = 3,
	FW_PARAMS_MNEM_DMAQ = 4,
	FW_PARAMS_MNEM_CHNET = 5,
	FW_PARAMS_MNEM_LAST = 6,
};

enum fw_params_param_dev {
	FW_PARAMS_PARAM_DEV_CCLK = 0,
	FW_PARAMS_PARAM_DEV_PORTVEC = 1,
	FW_PARAMS_PARAM_DEV_NTID = 2,
	FW_PARAMS_PARAM_DEV_FLOWC_BUFFIFO_SZ = 3,
	FW_PARAMS_PARAM_DEV_INTVER_NIC = 4,
	FW_PARAMS_PARAM_DEV_INTVER_VNIC = 5,
	FW_PARAMS_PARAM_DEV_INTVER_OFLD = 6,
	FW_PARAMS_PARAM_DEV_INTVER_RI = 7,
	FW_PARAMS_PARAM_DEV_INTVER_ISCSIPDU = 8,
	FW_PARAMS_PARAM_DEV_INTVER_ISCSI = 9,
	FW_PARAMS_PARAM_DEV_INTVER_FCOE = 10,
	FW_PARAMS_PARAM_DEV_FWREV = 11,
	FW_PARAMS_PARAM_DEV_TPREV = 12,
	FW_PARAMS_PARAM_DEV_CF = 13,
	FW_PARAMS_PARAM_DEV_PHYFW = 15,
	FW_PARAMS_PARAM_DEV_DIAG = 17,
	FW_PARAMS_PARAM_DEV_MAXORDIRD_QP = 19,
	FW_PARAMS_PARAM_DEV_MAXIRD_ADAPTER = 20,
	FW_PARAMS_PARAM_DEV_ULPTX_MEMWRITE_DSGL = 23,
	FW_PARAMS_PARAM_DEV_FWCACHE = 24,
	FW_PARAMS_PARAM_DEV_SCFGREV = 26,
	FW_PARAMS_PARAM_DEV_VPDREV = 27,
	FW_PARAMS_PARAM_DEV_RI_FR_NSMR_TPTE_WR = 28,
	FW_PARAMS_PARAM_DEV_FILTER2_WR = 29,
	FW_PARAMS_PARAM_DEV_MPSBGMAP = 30,
	FW_PARAMS_PARAM_DEV_TPCHMAP = 31,
	FW_PARAMS_PARAM_DEV_HMA_SIZE = 32,
	FW_PARAMS_PARAM_DEV_RDMA_WRITE_WITH_IMM = 33,
	FW_PARAMS_PARAM_DEV_PPOD_EDRAM = 35,
	FW_PARAMS_PARAM_DEV_RI_WRITE_CMPL_WR = 36,
	FW_PARAMS_PARAM_DEV_HPFILTER_REGION_SUPPORT = 38,
	FW_PARAMS_PARAM_DEV_OPAQUE_VIID_SMT_EXTN = 39,
	FW_PARAMS_PARAM_DEV_HASHFILTER_WITH_OFLD = 40,
	FW_PARAMS_PARAM_DEV_DBQ_TIMER = 41,
	FW_PARAMS_PARAM_DEV_DBQ_TIMERTICK = 42,
	FW_PARAMS_PARAM_DEV_NUM_TM_CLASS = 43,
	FW_PARAMS_PARAM_DEV_FILTER = 46,
	FW_PARAMS_PARAM_DEV_KTLS_HW = 49,
};

enum fw_params_param_pfvf {
	FW_PARAMS_PARAM_PFVF_RWXCAPS = 0,
	FW_PARAMS_PARAM_PFVF_ROUTE_START = 1,
	FW_PARAMS_PARAM_PFVF_ROUTE_END = 2,
	FW_PARAMS_PARAM_PFVF_CLIP_START = 3,
	FW_PARAMS_PARAM_PFVF_CLIP_END = 4,
	FW_PARAMS_PARAM_PFVF_FILTER_START = 5,
	FW_PARAMS_PARAM_PFVF_FILTER_END = 6,
	FW_PARAMS_PARAM_PFVF_SERVER_START = 7,
	FW_PARAMS_PARAM_PFVF_SERVER_END = 8,
	FW_PARAMS_PARAM_PFVF_TDDP_START = 9,
	FW_PARAMS_PARAM_PFVF_TDDP_END = 10,
	FW_PARAMS_PARAM_PFVF_ISCSI_START = 11,
	FW_PARAMS_PARAM_PFVF_ISCSI_END = 12,
	FW_PARAMS_PARAM_PFVF_STAG_START = 13,
	FW_PARAMS_PARAM_PFVF_STAG_END = 14,
	FW_PARAMS_PARAM_PFVF_RQ_START = 31,
	FW_PARAMS_PARAM_PFVF_RQ_END = 16,
	FW_PARAMS_PARAM_PFVF_PBL_START = 17,
	FW_PARAMS_PARAM_PFVF_PBL_END = 18,
	FW_PARAMS_PARAM_PFVF_L2T_START = 19,
	FW_PARAMS_PARAM_PFVF_L2T_END = 20,
	FW_PARAMS_PARAM_PFVF_SQRQ_START = 21,
	FW_PARAMS_PARAM_PFVF_SQRQ_END = 22,
	FW_PARAMS_PARAM_PFVF_CQ_START = 23,
	FW_PARAMS_PARAM_PFVF_CQ_END = 24,
	FW_PARAMS_PARAM_PFVF_SRQ_START = 25,
	FW_PARAMS_PARAM_PFVF_SRQ_END = 26,
	FW_PARAMS_PARAM_PFVF_SCHEDCLASS_ETH = 32,
	FW_PARAMS_PARAM_PFVF_VIID = 36,
	FW_PARAMS_PARAM_PFVF_CPMASK = 37,
	FW_PARAMS_PARAM_PFVF_OCQ_START = 38,
	FW_PARAMS_PARAM_PFVF_OCQ_END = 39,
	FW_PARAMS_PARAM_PFVF_CONM_MAP = 40,
	FW_PARAMS_PARAM_PFVF_IQFLINT_START = 41,
	FW_PARAMS_PARAM_PFVF_IQFLINT_END = 42,
	FW_PARAMS_PARAM_PFVF_EQ_START = 43,
	FW_PARAMS_PARAM_PFVF_EQ_END = 44,
	FW_PARAMS_PARAM_PFVF_ACTIVE_FILTER_START = 45,
	FW_PARAMS_PARAM_PFVF_ACTIVE_FILTER_END = 46,
	FW_PARAMS_PARAM_PFVF_ETHOFLD_START = 47,
	FW_PARAMS_PARAM_PFVF_ETHOFLD_END = 48,
	FW_PARAMS_PARAM_PFVF_CPLFW4MSG_ENCAP = 49,
	FW_PARAMS_PARAM_PFVF_HPFILTER_START = 50,
	FW_PARAMS_PARAM_PFVF_HPFILTER_END = 51,
	FW_PARAMS_PARAM_PFVF_TLS_START = 52,
	FW_PARAMS_PARAM_PFVF_TLS_END = 53,
	FW_PARAMS_PARAM_PFVF_RAWF_START = 54,
	FW_PARAMS_PARAM_PFVF_RAWF_END = 55,
	FW_PARAMS_PARAM_PFVF_NCRYPTO_LOOKASIDE = 57,
	FW_PARAMS_PARAM_PFVF_PORT_CAPS32 = 58,
	FW_PARAMS_PARAM_PFVF_PPOD_EDRAM_START = 59,
	FW_PARAMS_PARAM_PFVF_PPOD_EDRAM_END = 60,
	FW_PARAMS_PARAM_PFVF_LINK_STATE = 64,
};

enum fw_port_action {
	FW_PORT_ACTION_L1_CFG = 1,
	FW_PORT_ACTION_L2_CFG = 2,
	FW_PORT_ACTION_GET_PORT_INFO = 3,
	FW_PORT_ACTION_L2_PPP_CFG = 4,
	FW_PORT_ACTION_L2_DCB_CFG = 5,
	FW_PORT_ACTION_DCB_READ_TRANS = 6,
	FW_PORT_ACTION_DCB_READ_RECV = 7,
	FW_PORT_ACTION_DCB_READ_DET = 8,
	FW_PORT_ACTION_L1_CFG32 = 9,
	FW_PORT_ACTION_GET_PORT_INFO32 = 10,
	FW_PORT_ACTION_LOW_PWR_TO_NORMAL = 16,
	FW_PORT_ACTION_L1_LOW_PWR_EN = 17,
	FW_PORT_ACTION_L2_WOL_MODE_EN = 18,
	FW_PORT_ACTION_LPBK_TO_NORMAL = 32,
	FW_PORT_ACTION_L1_LPBK = 33,
	FW_PORT_ACTION_L1_PMA_LPBK = 34,
	FW_PORT_ACTION_L1_PCS_LPBK = 35,
	FW_PORT_ACTION_L1_PHYXS_CSIDE_LPBK = 36,
	FW_PORT_ACTION_L1_PHYXS_ESIDE_LPBK = 37,
	FW_PORT_ACTION_PHY_RESET = 64,
	FW_PORT_ACTION_PMA_RESET = 65,
	FW_PORT_ACTION_PCS_RESET = 66,
	FW_PORT_ACTION_PHYXS_RESET = 67,
	FW_PORT_ACTION_DTEXS_REEST = 68,
	FW_PORT_ACTION_AN_RESET = 69,
};

enum fw_port_cap {
	FW_PORT_CAP_SPEED_100M = 1,
	FW_PORT_CAP_SPEED_1G = 2,
	FW_PORT_CAP_SPEED_25G = 4,
	FW_PORT_CAP_SPEED_10G = 8,
	FW_PORT_CAP_SPEED_40G = 16,
	FW_PORT_CAP_SPEED_100G = 32,
	FW_PORT_CAP_FC_RX = 64,
	FW_PORT_CAP_FC_TX = 128,
	FW_PORT_CAP_ANEG = 256,
	FW_PORT_CAP_MDIAUTO = 512,
	FW_PORT_CAP_MDISTRAIGHT = 1024,
	FW_PORT_CAP_FEC_RS = 2048,
	FW_PORT_CAP_FEC_BASER_RS = 4096,
	FW_PORT_CAP_FORCE_PAUSE = 8192,
	FW_PORT_CAP_802_3_PAUSE = 16384,
	FW_PORT_CAP_802_3_ASM_DIR = 32768,
};

enum fw_port_mdi32 {
	FW_PORT_CAP32_MDI_UNCHANGED = 0,
	FW_PORT_CAP32_MDI_AUTO = 1,
	FW_PORT_CAP32_MDI_F_STRAIGHT = 2,
	FW_PORT_CAP32_MDI_F_CROSSOVER = 3,
};

enum fw_port_module_type {
	FW_PORT_MOD_TYPE_NA = 0,
	FW_PORT_MOD_TYPE_LR = 1,
	FW_PORT_MOD_TYPE_SR = 2,
	FW_PORT_MOD_TYPE_ER = 3,
	FW_PORT_MOD_TYPE_TWINAX_PASSIVE = 4,
	FW_PORT_MOD_TYPE_TWINAX_ACTIVE = 5,
	FW_PORT_MOD_TYPE_LRM = 6,
	FW_PORT_MOD_TYPE_ERROR = 28,
	FW_PORT_MOD_TYPE_UNKNOWN = 29,
	FW_PORT_MOD_TYPE_NOTSUPPORTED = 30,
	FW_PORT_MOD_TYPE_NONE = 31,
};

enum fw_resource_type {
	RSC_CARVEOUT = 0,
	RSC_DEVMEM = 1,
	RSC_TRACE = 2,
	RSC_VDEV = 3,
	RSC_LAST = 4,
	RSC_VENDOR_START = 128,
	RSC_VENDOR_END = 512,
};

enum fw_retval {
	FW_SUCCESS = 0,
	FW_EPERM = 1,
	FW_ENOENT = 2,
	FW_EIO = 5,
	FW_ENOEXEC = 8,
	FW_EAGAIN = 11,
	FW_ENOMEM = 12,
	FW_EFAULT = 14,
	FW_EBUSY = 16,
	FW_EEXIST = 17,
	FW_ENODEV = 19,
	FW_EINVAL = 22,
	FW_ENOSPC = 28,
	FW_ENOSYS = 38,
	FW_ENODATA = 61,
	FW_EPROTO = 71,
	FW_EADDRINUSE = 98,
	FW_EADDRNOTAVAIL = 99,
	FW_ENETDOWN = 100,
	FW_ENETUNREACH = 101,
	FW_ENOBUFS = 105,
	FW_ETIMEDOUT = 110,
	FW_EINPROGRESS = 115,
	FW_SCSI_ABORT_REQUESTED = 128,
	FW_SCSI_ABORT_TIMEDOUT = 129,
	FW_SCSI_ABORTED = 130,
	FW_SCSI_CLOSE_REQUESTED = 131,
	FW_ERR_LINK_DOWN = 132,
	FW_RDEV_NOT_READY = 133,
	FW_ERR_RDEV_LOST = 134,
	FW_ERR_RDEV_LOGO = 135,
	FW_FCOE_NO_XCHG = 136,
	FW_SCSI_RSP_ERR = 137,
	FW_ERR_RDEV_IMPL_LOGO = 138,
	FW_SCSI_UNDER_FLOW_ERR = 139,
	FW_SCSI_OVER_FLOW_ERR = 140,
	FW_SCSI_DDP_ERR = 141,
	FW_SCSI_TASK_ERR = 142,
};

enum fw_status {
	FW_STATUS_UNKNOWN = 0,
	FW_STATUS_LOADING = 1,
	FW_STATUS_DONE = 2,
	FW_STATUS_ABORTED = 3,
};

enum fw_upload_err {
	FW_UPLOAD_ERR_NONE = 0,
	FW_UPLOAD_ERR_HW_ERROR = 1,
	FW_UPLOAD_ERR_TIMEOUT = 2,
	FW_UPLOAD_ERR_CANCELED = 3,
	FW_UPLOAD_ERR_BUSY = 4,
	FW_UPLOAD_ERR_INVALID_SIZE = 5,
	FW_UPLOAD_ERR_RW_ERROR = 6,
	FW_UPLOAD_ERR_WEAROUT = 7,
	FW_UPLOAD_ERR_FW_INVALID = 8,
	FW_UPLOAD_ERR_MAX = 9,
};

enum fw_upload_prog {
	FW_UPLOAD_PROG_IDLE = 0,
	FW_UPLOAD_PROG_RECEIVING = 1,
	FW_UPLOAD_PROG_PREPARING = 2,
	FW_UPLOAD_PROG_TRANSFERRING = 3,
	FW_UPLOAD_PROG_PROGRAMMING = 4,
	FW_UPLOAD_PROG_MAX = 5,
};

enum fw_version_type {
	FW_VERSION_N3 = 0,
	FW_VERSION_T3 = 1,
};

enum fw_wr_stor_opcodes {
	FW_RDEV_WR = 56,
	FW_FCOE_ELS_CT_WR = 48,
	FW_SCSI_WRITE_WR = 49,
	FW_SCSI_READ_WR = 50,
	FW_SCSI_CMD_WR = 51,
	FW_SCSI_ABRT_CLS_WR = 52,
};

enum gcry_mpi_constants {
	MPI_C_ZERO = 0,
	MPI_C_ONE = 1,
	MPI_C_TWO = 2,
	MPI_C_THREE = 3,
	MPI_C_FOUR = 4,
	MPI_C_EIGHT = 5,
};

enum gcry_mpi_ec_models {
	MPI_EC_WEIERSTRASS = 0,
	MPI_EC_MONTGOMERY = 1,
	MPI_EC_EDWARDS = 2,
};

enum gcry_mpi_format {
	GCRYMPI_FMT_NONE = 0,
	GCRYMPI_FMT_STD = 1,
	GCRYMPI_FMT_PGP = 2,
	GCRYMPI_FMT_SSH = 3,
	GCRYMPI_FMT_HEX = 4,
	GCRYMPI_FMT_USG = 5,
	GCRYMPI_FMT_OPAQUE = 8,
};

enum genl_validate_flags {
	GENL_DONT_VALIDATE_STRICT = 1,
	GENL_DONT_VALIDATE_DUMP = 2,
	GENL_DONT_VALIDATE_DUMP_STRICT = 4,
};

enum genpd_notication {
	GENPD_NOTIFY_PRE_OFF = 0,
	GENPD_NOTIFY_OFF = 1,
	GENPD_NOTIFY_PRE_ON = 2,
	GENPD_NOTIFY_ON = 3,
};

enum geometry_desc_param {
	GEOMETRY_DESC_PARAM_LEN = 0,
	GEOMETRY_DESC_PARAM_TYPE = 1,
	GEOMETRY_DESC_PARAM_DEV_CAP = 4,
	GEOMETRY_DESC_PARAM_MAX_NUM_LUN = 12,
	GEOMETRY_DESC_PARAM_SEG_SIZE = 13,
	GEOMETRY_DESC_PARAM_ALLOC_UNIT_SIZE = 17,
	GEOMETRY_DESC_PARAM_MIN_BLK_SIZE = 18,
	GEOMETRY_DESC_PARAM_OPT_RD_BLK_SIZE = 19,
	GEOMETRY_DESC_PARAM_OPT_WR_BLK_SIZE = 20,
	GEOMETRY_DESC_PARAM_MAX_IN_BUF_SIZE = 21,
	GEOMETRY_DESC_PARAM_MAX_OUT_BUF_SIZE = 22,
	GEOMETRY_DESC_PARAM_RPMB_RW_SIZE = 23,
	GEOMETRY_DESC_PARAM_DYN_CAP_RSRC_PLC = 24,
	GEOMETRY_DESC_PARAM_DATA_ORDER = 25,
	GEOMETRY_DESC_PARAM_MAX_NUM_CTX = 26,
	GEOMETRY_DESC_PARAM_TAG_UNIT_SIZE = 27,
	GEOMETRY_DESC_PARAM_TAG_RSRC_SIZE = 28,
	GEOMETRY_DESC_PARAM_SEC_RM_TYPES = 29,
	GEOMETRY_DESC_PARAM_MEM_TYPES = 30,
	GEOMETRY_DESC_PARAM_SCM_MAX_NUM_UNITS = 32,
	GEOMETRY_DESC_PARAM_SCM_CAP_ADJ_FCTR = 36,
	GEOMETRY_DESC_PARAM_NPM_MAX_NUM_UNITS = 38,
	GEOMETRY_DESC_PARAM_NPM_CAP_ADJ_FCTR = 42,
	GEOMETRY_DESC_PARAM_ENM1_MAX_NUM_UNITS = 44,
	GEOMETRY_DESC_PARAM_ENM1_CAP_ADJ_FCTR = 48,
	GEOMETRY_DESC_PARAM_ENM2_MAX_NUM_UNITS = 50,
	GEOMETRY_DESC_PARAM_ENM2_CAP_ADJ_FCTR = 54,
	GEOMETRY_DESC_PARAM_ENM3_MAX_NUM_UNITS = 56,
	GEOMETRY_DESC_PARAM_ENM3_CAP_ADJ_FCTR = 60,
	GEOMETRY_DESC_PARAM_ENM4_MAX_NUM_UNITS = 62,
	GEOMETRY_DESC_PARAM_ENM4_CAP_ADJ_FCTR = 66,
	GEOMETRY_DESC_PARAM_OPT_LOG_BLK_SIZE = 68,
	GEOMETRY_DESC_PARAM_HPB_REGION_SIZE = 72,
	GEOMETRY_DESC_PARAM_HPB_NUMBER_LU = 73,
	GEOMETRY_DESC_PARAM_HPB_SUBREGION_SIZE = 74,
	GEOMETRY_DESC_PARAM_HPB_MAX_ACTIVE_REGS = 75,
	GEOMETRY_DESC_PARAM_WB_MAX_ALLOC_UNITS = 79,
	GEOMETRY_DESC_PARAM_WB_MAX_WB_LUNS = 83,
	GEOMETRY_DESC_PARAM_WB_BUFF_CAP_ADJ = 84,
	GEOMETRY_DESC_PARAM_WB_SUP_RED_TYPE = 85,
	GEOMETRY_DESC_PARAM_WB_SUP_WB_TYPE = 86,
};

enum get_block_ctx {
	GET_BLOCK_GENERAL = 0,
	GET_BLOCK_WRITE_BEGIN = 1,
	GET_BLOCK_DIRECT_IO_R = 2,
	GET_BLOCK_DIRECT_IO_W = 3,
	GET_BLOCK_BMAP = 4,
};

enum get_iov_fw_value_index {
	BAR_ADDRS = 1,
	APERTURE_SIZE = 2,
	WDW_SIZE = 3,
};

enum gpd_status {
	GENPD_STATE_ON = 0,
	GENPD_STATE_OFF = 1,
};

enum gpio_lookup_flags {
	GPIO_ACTIVE_HIGH = 0,
	GPIO_ACTIVE_LOW = 1,
	GPIO_OPEN_DRAIN = 2,
	GPIO_OPEN_SOURCE = 4,
	GPIO_PERSISTENT = 0,
	GPIO_TRANSITORY = 8,
	GPIO_PULL_UP = 16,
	GPIO_PULL_DOWN = 32,
	GPIO_PULL_DISABLE = 64,
	GPIO_LOOKUP_FLAGS_DEFAULT = 0,
};

enum gpio_select {
	NO_GPIO = 0,
	GPIO_1 = 1,
	GPIO_2 = 2,
};

enum gpio_v2_line_attr_id {
	GPIO_V2_LINE_ATTR_ID_FLAGS = 1,
	GPIO_V2_LINE_ATTR_ID_OUTPUT_VALUES = 2,
	GPIO_V2_LINE_ATTR_ID_DEBOUNCE = 3,
};

enum gpio_v2_line_changed_type {
	GPIO_V2_LINE_CHANGED_REQUESTED = 1,
	GPIO_V2_LINE_CHANGED_RELEASED = 2,
	GPIO_V2_LINE_CHANGED_CONFIG = 3,
};

enum gpio_v2_line_event_id {
	GPIO_V2_LINE_EVENT_RISING_EDGE = 1,
	GPIO_V2_LINE_EVENT_FALLING_EDGE = 2,
};

enum gpio_v2_line_flag {
	GPIO_V2_LINE_FLAG_USED = 1,
	GPIO_V2_LINE_FLAG_ACTIVE_LOW = 2,
	GPIO_V2_LINE_FLAG_INPUT = 4,
	GPIO_V2_LINE_FLAG_OUTPUT = 8,
	GPIO_V2_LINE_FLAG_EDGE_RISING = 16,
	GPIO_V2_LINE_FLAG_EDGE_FALLING = 32,
	GPIO_V2_LINE_FLAG_OPEN_DRAIN = 64,
	GPIO_V2_LINE_FLAG_OPEN_SOURCE = 128,
	GPIO_V2_LINE_FLAG_BIAS_PULL_UP = 256,
	GPIO_V2_LINE_FLAG_BIAS_PULL_DOWN = 512,
	GPIO_V2_LINE_FLAG_BIAS_DISABLED = 1024,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_REALTIME = 2048,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_HTE = 4096,
};

enum gpiod_flags {
	GPIOD_ASIS = 0,
	GPIOD_IN = 1,
	GPIOD_OUT_LOW = 3,
	GPIOD_OUT_HIGH = 7,
	GPIOD_OUT_LOW_OPEN_DRAIN = 11,
	GPIOD_OUT_HIGH_OPEN_DRAIN = 15,
};

enum graph_filter_type {
	GRAPH_FILTER_NOTRACE = 0,
	GRAPH_FILTER_FUNCTION = 1,
};

enum gre_conntrack {
	GRE_CT_UNREPLIED = 0,
	GRE_CT_REPLIED = 1,
	GRE_CT_MAX = 2,
};

enum gro_result {
	GRO_MERGED = 0,
	GRO_MERGED_FREE = 1,
	GRO_HELD = 2,
	GRO_NORMAL = 3,
	GRO_CONSUMED = 4,
};

typedef enum gro_result gro_result_t;

enum group_type {
	group_has_spare = 0,
	group_fully_busy = 1,
	group_misfit_task = 2,
	group_smt_balance = 3,
	group_asym_packing = 4,
	group_imbalanced = 5,
	group_overloaded = 6,
};

enum handler_id {
	HANDLER_ONMATCH = 1,
	HANDLER_ONMAX = 2,
	HANDLER_ONCHANGE = 3,
};

enum handshake_auth {
	HANDSHAKE_AUTH_UNSPEC = 0,
	HANDSHAKE_AUTH_UNAUTH = 1,
	HANDSHAKE_AUTH_PSK = 2,
	HANDSHAKE_AUTH_X509 = 3,
};

enum handshake_handler_class {
	HANDSHAKE_HANDLER_CLASS_NONE = 0,
	HANDSHAKE_HANDLER_CLASS_TLSHD = 1,
	HANDSHAKE_HANDLER_CLASS_MAX = 2,
};

enum handshake_msg_type {
	HANDSHAKE_MSG_TYPE_UNSPEC = 0,
	HANDSHAKE_MSG_TYPE_CLIENTHELLO = 1,
	HANDSHAKE_MSG_TYPE_SERVERHELLO = 2,
};

enum hardware_details {
	MVS_MAX_PHYS = 8,
	MVS_MAX_PORTS = 8,
	MVS_SOC_PHYS = 4,
	MVS_SOC_PORTS = 4,
	MVS_MAX_DEVICES = 1024,
};

enum hash_algo {
	HASH_ALGO_MD4 = 0,
	HASH_ALGO_MD5 = 1,
	HASH_ALGO_SHA1 = 2,
	HASH_ALGO_RIPE_MD_160 = 3,
	HASH_ALGO_SHA256 = 4,
	HASH_ALGO_SHA384 = 5,
	HASH_ALGO_SHA512 = 6,
	HASH_ALGO_SHA224 = 7,
	HASH_ALGO_RIPE_MD_128 = 8,
	HASH_ALGO_RIPE_MD_256 = 9,
	HASH_ALGO_RIPE_MD_320 = 10,
	HASH_ALGO_WP_256 = 11,
	HASH_ALGO_WP_384 = 12,
	HASH_ALGO_WP_512 = 13,
	HASH_ALGO_TGR_128 = 14,
	HASH_ALGO_TGR_160 = 15,
	HASH_ALGO_TGR_192 = 16,
	HASH_ALGO_SM3_256 = 17,
	HASH_ALGO_STREEBOG_256 = 18,
	HASH_ALGO_STREEBOG_512 = 19,
	HASH_ALGO_SHA3_256 = 20,
	HASH_ALGO_SHA3_384 = 21,
	HASH_ALGO_SHA3_512 = 22,
	HASH_ALGO__LAST = 23,
};

enum hba_port_matched_codes {
	NOT_MATCHED = 0,
	MATCHED_WITH_ADDR_AND_PHYMASK = 1,
	MATCHED_WITH_ADDR_SUBPHYMASK_AND_PORT = 2,
	MATCHED_WITH_ADDR_AND_SUBPHYMASK = 3,
	MATCHED_WITH_ADDR = 4,
};

enum hba_state {
	LPFC_LINK_UNKNOWN = 0,
	LPFC_WARM_START = 1,
	LPFC_INIT_START = 2,
	LPFC_INIT_MBX_CMDS = 3,
	LPFC_LINK_DOWN = 4,
	LPFC_LINK_UP = 5,
	LPFC_CLEAR_LA = 6,
	LPFC_HBA_READY = 32,
	LPFC_HBA_ERROR = -1,
};

enum hba_temp_state {
	HBA_NORMAL_TEMP = 0,
	HBA_OVER_TEMP = 1,
};

enum hctx_type {
	HCTX_TYPE_DEFAULT = 0,
	HCTX_TYPE_READ = 1,
	HCTX_TYPE_POLL = 2,
	HCTX_MAX_TYPES = 3,
};

enum hdmi_3d_structure {
	HDMI_3D_STRUCTURE_INVALID = -1,
	HDMI_3D_STRUCTURE_FRAME_PACKING = 0,
	HDMI_3D_STRUCTURE_FIELD_ALTERNATIVE = 1,
	HDMI_3D_STRUCTURE_LINE_ALTERNATIVE = 2,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_FULL = 3,
	HDMI_3D_STRUCTURE_L_DEPTH = 4,
	HDMI_3D_STRUCTURE_L_DEPTH_GFX_GFX_DEPTH = 5,
	HDMI_3D_STRUCTURE_TOP_AND_BOTTOM = 6,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_HALF = 8,
};

enum hdmi_active_aspect {
	HDMI_ACTIVE_ASPECT_16_9_TOP = 2,
	HDMI_ACTIVE_ASPECT_14_9_TOP = 3,
	HDMI_ACTIVE_ASPECT_16_9_CENTER = 4,
	HDMI_ACTIVE_ASPECT_PICTURE = 8,
	HDMI_ACTIVE_ASPECT_4_3 = 9,
	HDMI_ACTIVE_ASPECT_16_9 = 10,
	HDMI_ACTIVE_ASPECT_14_9 = 11,
	HDMI_ACTIVE_ASPECT_4_3_SP_14_9 = 13,
	HDMI_ACTIVE_ASPECT_16_9_SP_14_9 = 14,
	HDMI_ACTIVE_ASPECT_16_9_SP_4_3 = 15,
};

enum hdmi_audio_coding_type {
	HDMI_AUDIO_CODING_TYPE_STREAM = 0,
	HDMI_AUDIO_CODING_TYPE_PCM = 1,
	HDMI_AUDIO_CODING_TYPE_AC3 = 2,
	HDMI_AUDIO_CODING_TYPE_MPEG1 = 3,
	HDMI_AUDIO_CODING_TYPE_MP3 = 4,
	HDMI_AUDIO_CODING_TYPE_MPEG2 = 5,
	HDMI_AUDIO_CODING_TYPE_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_DTS = 7,
	HDMI_AUDIO_CODING_TYPE_ATRAC = 8,
	HDMI_AUDIO_CODING_TYPE_DSD = 9,
	HDMI_AUDIO_CODING_TYPE_EAC3 = 10,
	HDMI_AUDIO_CODING_TYPE_DTS_HD = 11,
	HDMI_AUDIO_CODING_TYPE_MLP = 12,
	HDMI_AUDIO_CODING_TYPE_DST = 13,
	HDMI_AUDIO_CODING_TYPE_WMA_PRO = 14,
	HDMI_AUDIO_CODING_TYPE_CXT = 15,
};

enum hdmi_audio_coding_type_ext {
	HDMI_AUDIO_CODING_TYPE_EXT_CT = 0,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC = 1,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC_V2 = 2,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG_SURROUND = 3,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC = 4,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_V2 = 5,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_EXT_DRA = 7,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_SURROUND = 8,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC_SURROUND = 10,
};

enum hdmi_audio_sample_frequency {
	HDMI_AUDIO_SAMPLE_FREQUENCY_STREAM = 0,
	HDMI_AUDIO_SAMPLE_FREQUENCY_32000 = 1,
	HDMI_AUDIO_SAMPLE_FREQUENCY_44100 = 2,
	HDMI_AUDIO_SAMPLE_FREQUENCY_48000 = 3,
	HDMI_AUDIO_SAMPLE_FREQUENCY_88200 = 4,
	HDMI_AUDIO_SAMPLE_FREQUENCY_96000 = 5,
	HDMI_AUDIO_SAMPLE_FREQUENCY_176400 = 6,
	HDMI_AUDIO_SAMPLE_FREQUENCY_192000 = 7,
};

enum hdmi_audio_sample_size {
	HDMI_AUDIO_SAMPLE_SIZE_STREAM = 0,
	HDMI_AUDIO_SAMPLE_SIZE_16 = 1,
	HDMI_AUDIO_SAMPLE_SIZE_20 = 2,
	HDMI_AUDIO_SAMPLE_SIZE_24 = 3,
};

enum hdmi_colorimetry {
	HDMI_COLORIMETRY_NONE = 0,
	HDMI_COLORIMETRY_ITU_601 = 1,
	HDMI_COLORIMETRY_ITU_709 = 2,
	HDMI_COLORIMETRY_EXTENDED = 3,
};

enum hdmi_colorspace {
	HDMI_COLORSPACE_RGB = 0,
	HDMI_COLORSPACE_YUV422 = 1,
	HDMI_COLORSPACE_YUV444 = 2,
	HDMI_COLORSPACE_YUV420 = 3,
	HDMI_COLORSPACE_RESERVED4 = 4,
	HDMI_COLORSPACE_RESERVED5 = 5,
	HDMI_COLORSPACE_RESERVED6 = 6,
	HDMI_COLORSPACE_IDO_DEFINED = 7,
};

enum hdmi_content_type {
	HDMI_CONTENT_TYPE_GRAPHICS = 0,
	HDMI_CONTENT_TYPE_PHOTO = 1,
	HDMI_CONTENT_TYPE_CINEMA = 2,
	HDMI_CONTENT_TYPE_GAME = 3,
};

enum hdmi_eotf {
	HDMI_EOTF_TRADITIONAL_GAMMA_SDR = 0,
	HDMI_EOTF_TRADITIONAL_GAMMA_HDR = 1,
	HDMI_EOTF_SMPTE_ST2084 = 2,
	HDMI_EOTF_BT_2100_HLG = 3,
};

enum hdmi_extended_colorimetry {
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_601 = 0,
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_709 = 1,
	HDMI_EXTENDED_COLORIMETRY_S_YCC_601 = 2,
	HDMI_EXTENDED_COLORIMETRY_OPYCC_601 = 3,
	HDMI_EXTENDED_COLORIMETRY_OPRGB = 4,
	HDMI_EXTENDED_COLORIMETRY_BT2020_CONST_LUM = 5,
	HDMI_EXTENDED_COLORIMETRY_BT2020 = 6,
	HDMI_EXTENDED_COLORIMETRY_RESERVED = 7,
};

enum hdmi_infoframe_type {
	HDMI_INFOFRAME_TYPE_VENDOR = 129,
	HDMI_INFOFRAME_TYPE_AVI = 130,
	HDMI_INFOFRAME_TYPE_SPD = 131,
	HDMI_INFOFRAME_TYPE_AUDIO = 132,
	HDMI_INFOFRAME_TYPE_DRM = 135,
};

enum hdmi_metadata_type {
	HDMI_STATIC_METADATA_TYPE1 = 0,
};

enum hdmi_nups {
	HDMI_NUPS_UNKNOWN = 0,
	HDMI_NUPS_HORIZONTAL = 1,
	HDMI_NUPS_VERTICAL = 2,
	HDMI_NUPS_BOTH = 3,
};

enum hdmi_picture_aspect {
	HDMI_PICTURE_ASPECT_NONE = 0,
	HDMI_PICTURE_ASPECT_4_3 = 1,
	HDMI_PICTURE_ASPECT_16_9 = 2,
	HDMI_PICTURE_ASPECT_64_27 = 3,
	HDMI_PICTURE_ASPECT_256_135 = 4,
	HDMI_PICTURE_ASPECT_RESERVED = 5,
};

enum hdmi_quantization_range {
	HDMI_QUANTIZATION_RANGE_DEFAULT = 0,
	HDMI_QUANTIZATION_RANGE_LIMITED = 1,
	HDMI_QUANTIZATION_RANGE_FULL = 2,
	HDMI_QUANTIZATION_RANGE_RESERVED = 3,
};

enum hdmi_scan_mode {
	HDMI_SCAN_MODE_NONE = 0,
	HDMI_SCAN_MODE_OVERSCAN = 1,
	HDMI_SCAN_MODE_UNDERSCAN = 2,
	HDMI_SCAN_MODE_RESERVED = 3,
};

enum hdmi_spd_sdi {
	HDMI_SPD_SDI_UNKNOWN = 0,
	HDMI_SPD_SDI_DSTB = 1,
	HDMI_SPD_SDI_DVDP = 2,
	HDMI_SPD_SDI_DVHS = 3,
	HDMI_SPD_SDI_HDDVR = 4,
	HDMI_SPD_SDI_DVC = 5,
	HDMI_SPD_SDI_DSC = 6,
	HDMI_SPD_SDI_VCD = 7,
	HDMI_SPD_SDI_GAME = 8,
	HDMI_SPD_SDI_PC = 9,
	HDMI_SPD_SDI_BD = 10,
	HDMI_SPD_SDI_SACD = 11,
	HDMI_SPD_SDI_HDDVD = 12,
	HDMI_SPD_SDI_PMP = 13,
};

enum hdmi_ycc_quantization_range {
	HDMI_YCC_QUANTIZATION_RANGE_LIMITED = 0,
	HDMI_YCC_QUANTIZATION_RANGE_FULL = 1,
};

enum health_desc_param {
	HEALTH_DESC_PARAM_LEN = 0,
	HEALTH_DESC_PARAM_TYPE = 1,
	HEALTH_DESC_PARAM_EOL_INFO = 2,
	HEALTH_DESC_PARAM_LIFE_TIME_EST_A = 3,
	HEALTH_DESC_PARAM_LIFE_TIME_EST_B = 4,
};

enum hist_field_flags {
	HIST_FIELD_FL_HITCOUNT = 1,
	HIST_FIELD_FL_KEY = 2,
	HIST_FIELD_FL_STRING = 4,
	HIST_FIELD_FL_HEX = 8,
	HIST_FIELD_FL_SYM = 16,
	HIST_FIELD_FL_SYM_OFFSET = 32,
	HIST_FIELD_FL_EXECNAME = 64,
	HIST_FIELD_FL_SYSCALL = 128,
	HIST_FIELD_FL_STACKTRACE = 256,
	HIST_FIELD_FL_LOG2 = 512,
	HIST_FIELD_FL_TIMESTAMP = 1024,
	HIST_FIELD_FL_TIMESTAMP_USECS = 2048,
	HIST_FIELD_FL_VAR = 4096,
	HIST_FIELD_FL_EXPR = 8192,
	HIST_FIELD_FL_VAR_REF = 16384,
	HIST_FIELD_FL_CPU = 32768,
	HIST_FIELD_FL_ALIAS = 65536,
	HIST_FIELD_FL_BUCKET = 131072,
	HIST_FIELD_FL_CONST = 262144,
	HIST_FIELD_FL_PERCENT = 524288,
	HIST_FIELD_FL_GRAPH = 1048576,
};

enum hist_field_fn {
	HIST_FIELD_FN_NOP = 0,
	HIST_FIELD_FN_VAR_REF = 1,
	HIST_FIELD_FN_COUNTER = 2,
	HIST_FIELD_FN_CONST = 3,
	HIST_FIELD_FN_LOG2 = 4,
	HIST_FIELD_FN_BUCKET = 5,
	HIST_FIELD_FN_TIMESTAMP = 6,
	HIST_FIELD_FN_CPU = 7,
	HIST_FIELD_FN_STRING = 8,
	HIST_FIELD_FN_DYNSTRING = 9,
	HIST_FIELD_FN_RELDYNSTRING = 10,
	HIST_FIELD_FN_PSTRING = 11,
	HIST_FIELD_FN_S64 = 12,
	HIST_FIELD_FN_U64 = 13,
	HIST_FIELD_FN_S32 = 14,
	HIST_FIELD_FN_U32 = 15,
	HIST_FIELD_FN_S16 = 16,
	HIST_FIELD_FN_U16 = 17,
	HIST_FIELD_FN_S8 = 18,
	HIST_FIELD_FN_U8 = 19,
	HIST_FIELD_FN_UMINUS = 20,
	HIST_FIELD_FN_MINUS = 21,
	HIST_FIELD_FN_PLUS = 22,
	HIST_FIELD_FN_DIV = 23,
	HIST_FIELD_FN_MULT = 24,
	HIST_FIELD_FN_DIV_POWER2 = 25,
	HIST_FIELD_FN_DIV_NOT_POWER2 = 26,
	HIST_FIELD_FN_DIV_MULT_SHIFT = 27,
	HIST_FIELD_FN_EXECNAME = 28,
	HIST_FIELD_FN_STACK = 29,
};

enum hk_flags {
	HK_FLAG_TIMER = 1,
	HK_FLAG_RCU = 2,
	HK_FLAG_MISC = 4,
	HK_FLAG_SCHED = 8,
	HK_FLAG_TICK = 16,
	HK_FLAG_DOMAIN = 32,
	HK_FLAG_WQ = 64,
	HK_FLAG_MANAGED_IRQ = 128,
	HK_FLAG_KTHREAD = 256,
};

enum hk_type {
	HK_TYPE_TIMER = 0,
	HK_TYPE_RCU = 1,
	HK_TYPE_MISC = 2,
	HK_TYPE_SCHED = 3,
	HK_TYPE_TICK = 4,
	HK_TYPE_DOMAIN = 5,
	HK_TYPE_WQ = 6,
	HK_TYPE_MANAGED_IRQ = 7,
	HK_TYPE_KTHREAD = 8,
	HK_TYPE_MAX = 9,
};

enum hmm_pfn_flags {
	HMM_PFN_VALID = 9223372036854775808ULL,
	HMM_PFN_WRITE = 4611686018427387904ULL,
	HMM_PFN_ERROR = 2305843009213693952ULL,
	HMM_PFN_ORDER_SHIFT = 56ULL,
	HMM_PFN_REQ_FAULT = 9223372036854775808ULL,
	HMM_PFN_REQ_WRITE = 4611686018427387904ULL,
	HMM_PFN_FLAGS = 18374686479671623680ULL,
};

enum hn_flags_bits {
	HANDSHAKE_F_NET_DRAINING = 0,
};

enum host_registers {
	MVS_HST_CHIP_CONFIG = 65796,
};

enum hp_flags_bits {
	HANDSHAKE_F_PROTO_NOTIFY = 0,
};

enum hpt_iop_request_type {
	IOP_REQUEST_TYPE_GET_CONFIG = 0,
	IOP_REQUEST_TYPE_SET_CONFIG = 1,
	IOP_REQUEST_TYPE_BLOCK_COMMAND = 2,
	IOP_REQUEST_TYPE_SCSI_COMMAND = 3,
	IOP_REQUEST_TYPE_IOCTL_COMMAND = 4,
	IOP_REQUEST_TYPE_MAX = 5,
};

enum hpt_iop_result_type {
	IOP_RESULT_PENDING = 0,
	IOP_RESULT_SUCCESS = 1,
	IOP_RESULT_FAIL = 2,
	IOP_RESULT_BUSY = 3,
	IOP_RESULT_RESET = 4,
	IOP_RESULT_INVALID_REQUEST = 5,
	IOP_RESULT_BAD_TARGET = 6,
	IOP_RESULT_CHECK_CONDITION = 7,
};

enum hpt_iopmu_message {
	IOPMU_INBOUND_MSG0_NOP = 0,
	IOPMU_INBOUND_MSG0_RESET = 1,
	IOPMU_INBOUND_MSG0_FLUSH = 2,
	IOPMU_INBOUND_MSG0_SHUTDOWN = 3,
	IOPMU_INBOUND_MSG0_STOP_BACKGROUND_TASK = 4,
	IOPMU_INBOUND_MSG0_START_BACKGROUND_TASK = 5,
	IOPMU_INBOUND_MSG0_RESET_COMM = 6,
	IOPMU_INBOUND_MSG0_MAX = 255,
	IOPMU_OUTBOUND_MSG0_REGISTER_DEVICE_0 = 256,
	IOPMU_OUTBOUND_MSG0_REGISTER_DEVICE_MAX = 511,
	IOPMU_OUTBOUND_MSG0_UNREGISTER_DEVICE_0 = 512,
	IOPMU_OUTBOUND_MSG0_UNREGISTER_DEVICE_MAX = 767,
	IOPMU_OUTBOUND_MSG0_REVALIDATE_DEVICE_0 = 768,
	IOPMU_OUTBOUND_MSG0_REVALIDATE_DEVICE_MAX = 1023,
};

enum hptiop_family {
	UNKNOWN_BASED_IOP = 0,
	INTEL_BASED_IOP = 1,
	MV_BASED_IOP = 2,
	MVFREY_BASED_IOP = 3,
};

enum hr_flags_bits {
	HANDSHAKE_F_REQ_COMPLETED = 0,
	HANDSHAKE_F_REQ_SESSION = 1,
};

enum hrtimer_base_type {
	HRTIMER_BASE_MONOTONIC = 0,
	HRTIMER_BASE_REALTIME = 1,
	HRTIMER_BASE_BOOTTIME = 2,
	HRTIMER_BASE_TAI = 3,
	HRTIMER_BASE_MONOTONIC_SOFT = 4,
	HRTIMER_BASE_REALTIME_SOFT = 5,
	HRTIMER_BASE_BOOTTIME_SOFT = 6,
	HRTIMER_BASE_TAI_SOFT = 7,
	HRTIMER_MAX_CLOCK_BASES = 8,
};

enum hrtimer_mode {
	HRTIMER_MODE_ABS = 0,
	HRTIMER_MODE_REL = 1,
	HRTIMER_MODE_PINNED = 2,
	HRTIMER_MODE_SOFT = 4,
	HRTIMER_MODE_HARD = 8,
	HRTIMER_MODE_ABS_PINNED = 2,
	HRTIMER_MODE_REL_PINNED = 3,
	HRTIMER_MODE_ABS_SOFT = 4,
	HRTIMER_MODE_REL_SOFT = 5,
	HRTIMER_MODE_ABS_PINNED_SOFT = 6,
	HRTIMER_MODE_REL_PINNED_SOFT = 7,
	HRTIMER_MODE_ABS_HARD = 8,
	HRTIMER_MODE_REL_HARD = 9,
	HRTIMER_MODE_ABS_PINNED_HARD = 10,
	HRTIMER_MODE_REL_PINNED_HARD = 11,
};

enum hrtimer_restart {
	HRTIMER_NORESTART = 0,
	HRTIMER_RESTART = 1,
};

enum hsm_task_states {
	HSM_ST_IDLE = 0,
	HSM_ST_FIRST = 1,
	HSM_ST = 2,
	HSM_ST_LAST = 3,
	HSM_ST_ERR = 4,
};

enum hugetlb_memory_event {
	HUGETLB_MAX = 0,
	HUGETLB_NR_MEMORY_EVENTS = 1,
};

enum hugetlb_page_flags {
	HPG_restore_reserve = 0,
	HPG_migratable = 1,
	HPG_temporary = 2,
	HPG_freed = 3,
	HPG_vmemmap_optimized = 4,
	HPG_raw_hwp_unreliable = 5,
	__NR_HPAGEFLAGS = 6,
};

enum hugetlb_param {
	Opt_gid___4 = 0,
	Opt_min_size = 1,
	Opt_mode___3 = 2,
	Opt_nr_inodes = 3,
	Opt_pagesize = 4,
	Opt_size = 5,
	Opt_uid___4 = 6,
};

enum hugetlbfs_size_type {
	NO_SIZE = 0,
	SIZE_STD = 1,
	SIZE_PERCENT = 2,
};

enum hv_gpci_requests {
	HV_GPCI_dispatch_timebase_by_processor = 16,
	HV_GPCI_entitled_capped_uncapped_donated_idle_timebase_by_partition = 32,
	HV_GPCI_run_instructions_run_cycles_by_partition = 48,
	HV_GPCI_system_performance_capabilities = 64,
	HV_GPCI_processor_bus_utilization_abc_links = 80,
	HV_GPCI_processor_bus_utilization_wxyz_links = 96,
	HV_GPCI_processor_bus_utilization_gx_links = 112,
	HV_GPCI_processor_bus_utilization_mc_links = 128,
	HV_GPCI_processor_core_utilization = 148,
	HV_GPCI_partition_hypervisor_queuing_times = 224,
	HV_GPCI_system_hypervisor_times = 240,
	HV_GPCI_system_tlbie_count_and_time = 244,
	HV_GPCI_partition_instruction_count_and_time = 256,
};

enum hv_perf_domains {
	HV_PERF_DOMAIN_PHYS_CHIP = 1,
	HV_PERF_DOMAIN_PHYS_CORE = 2,
	HV_PERF_DOMAIN_VCPU_HOME_CORE = 3,
	HV_PERF_DOMAIN_VCPU_HOME_CHIP = 4,
	HV_PERF_DOMAIN_VCPU_HOME_NODE = 5,
	HV_PERF_DOMAIN_VCPU_REMOTE_NODE = 6,
	HV_PERF_DOMAIN_MAX = 7,
};

enum hv_protocol {
	HV_PROTOCOL_RAW = 0,
	HV_PROTOCOL_HVSI = 1,
};

typedef enum hv_protocol hv_protocol_t;

enum hw_event_mc_err_type {
	HW_EVENT_ERR_CORRECTED = 0,
	HW_EVENT_ERR_UNCORRECTED = 1,
	HW_EVENT_ERR_DEFERRED = 2,
	HW_EVENT_ERR_FATAL = 3,
	HW_EVENT_ERR_INFO = 4,
};

enum hw_register_bits {
	INT_EN = 2,
	HBA_RST = 1,
	INT_XOR = 16,
	INT_SAS_SATA = 1,
	SATA_TARGET = 65536,
	MODE_AUTO_DET_PORT7 = 32768,
	MODE_AUTO_DET_PORT6 = 16384,
	MODE_AUTO_DET_PORT5 = 8192,
	MODE_AUTO_DET_PORT4 = 4096,
	MODE_AUTO_DET_PORT3 = 2048,
	MODE_AUTO_DET_PORT2 = 1024,
	MODE_AUTO_DET_PORT1 = 512,
	MODE_AUTO_DET_PORT0 = 256,
	MODE_AUTO_DET_EN = 65280,
	MODE_SAS_PORT7_MASK = 128,
	MODE_SAS_PORT6_MASK = 64,
	MODE_SAS_PORT5_MASK = 32,
	MODE_SAS_PORT4_MASK = 16,
	MODE_SAS_PORT3_MASK = 8,
	MODE_SAS_PORT2_MASK = 4,
	MODE_SAS_PORT1_MASK = 2,
	MODE_SAS_PORT0_MASK = 1,
	MODE_SAS_SATA = 255,
	TX_EN = 65536,
	TX_RING_SZ_MASK = 4095,
	RX_EN = 65536,
	RX_RING_SZ_MASK = 4095,
	COAL_EN = 65536,
	CINT_I2C = 2147483648,
	CINT_SW0 = 1073741824,
	CINT_SW1 = 536870912,
	CINT_PRD_BC = 268435456,
	CINT_DMA_PCIE = 134217728,
	CINT_MEM = 67108864,
	CINT_I2C_SLAVE = 33554432,
	CINT_NON_SPEC_NCQ_ERROR = 33554432,
	CINT_SRS = 8,
	CINT_CI_STOP = 2,
	CINT_DONE = 1,
	CINT_PORT_STOPPED = 65536,
	CINT_PORT = 256,
	CINT_PORT_MASK_OFFSET = 8,
	CINT_PORT_MASK = 65280,
	CINT_PHY_MASK_OFFSET = 4,
	CINT_PHY_MASK = 240,
	TXQ_CMD_SHIFT = 29,
	TXQ_CMD_SSP = 1,
	TXQ_CMD_SMP = 2,
	TXQ_CMD_STP = 3,
	TXQ_CMD_SSP_FREE_LIST = 4,
	TXQ_CMD_SLOT_RESET = 7,
	TXQ_MODE_I = 268435456,
	TXQ_MODE_TARGET = 0,
	TXQ_MODE_INITIATOR = 1,
	TXQ_PRIO_HI = 134217728,
	TXQ_PRI_NORMAL = 0,
	TXQ_PRI_HIGH = 1,
	TXQ_SRS_SHIFT = 20,
	TXQ_SRS_MASK = 127,
	TXQ_PHY_SHIFT = 12,
	TXQ_PHY_MASK = 255,
	TXQ_SLOT_MASK = 4095,
	RXQ_GOOD = 8388608,
	RXQ_SLOT_RESET = 2097152,
	RXQ_CMD_RX = 1048576,
	RXQ_ATTN = 524288,
	RXQ_RSP = 262144,
	RXQ_ERR = 131072,
	RXQ_DONE = 65536,
	RXQ_SLOT_MASK = 4095,
	MCH_PRD_LEN_SHIFT = 16,
	MCH_SSP_FR_TYPE_SHIFT = 13,
	MCH_SSP_FR_CMD = 0,
	MCH_SSP_FR_TASK = 1,
	MCH_SSP_FR_XFER_RDY = 4,
	MCH_SSP_FR_RESP = 5,
	MCH_SSP_FR_READ = 6,
	MCH_SSP_FR_READ_RESP = 7,
	MCH_SSP_MODE_PASSTHRU = 1,
	MCH_SSP_MODE_NORMAL = 0,
	MCH_PASSTHRU = 4096,
	MCH_FBURST = 2048,
	MCH_CHK_LEN = 1024,
	MCH_RETRY = 512,
	MCH_PROTECTION = 256,
	MCH_RESET = 128,
	MCH_FPDMA = 64,
	MCH_ATAPI = 32,
	MCH_BIST = 16,
	MCH_PMP_MASK = 15,
	CCTL_RST = 32,
	CCTL_ENDIAN_DATA = 8,
	CCTL_ENDIAN_RSP = 4,
	CCTL_ENDIAN_OPEN = 2,
	CCTL_ENDIAN_CMD = 1,
	PHY_SSP_RST = 8,
	PHY_BCAST_CHG = 4,
	PHY_RST_HARD = 2,
	PHY_RST = 1,
	PHY_READY_MASK = 1048576,
	PHYEV_DEC_ERR = 16777216,
	PHYEV_DCDR_ERR = 8388608,
	PHYEV_CRC_ERR = 4194304,
	PHYEV_UNASSOC_FIS = 524288,
	PHYEV_AN = 262144,
	PHYEV_BIST_ACT = 131072,
	PHYEV_SIG_FIS = 65536,
	PHYEV_POOF = 4096,
	PHYEV_IU_BIG = 2048,
	PHYEV_IU_SMALL = 1024,
	PHYEV_UNK_TAG = 512,
	PHYEV_BROAD_CH = 256,
	PHYEV_COMWAKE = 128,
	PHYEV_PORT_SEL = 64,
	PHYEV_HARD_RST = 32,
	PHYEV_ID_TMOUT = 16,
	PHYEV_ID_FAIL = 8,
	PHYEV_ID_DONE = 4,
	PHYEV_HARD_RST_DONE = 2,
	PHYEV_RDY_CH = 1,
	PCS_EN_SATA_REG_SHIFT = 16,
	PCS_EN_PORT_XMT_SHIFT = 12,
	PCS_EN_PORT_XMT_SHIFT2 = 8,
	PCS_SATA_RETRY = 256,
	PCS_RSP_RX_EN = 128,
	PCS_SATA_RETRY_2 = 64,
	PCS_SELF_CLEAR = 32,
	PCS_FIS_RX_EN = 16,
	PCS_CMD_STOP_ERR = 8,
	PCS_CMD_RST = 2,
	PCS_CMD_EN = 1,
	PORT_DEV_SSP_TRGT = 524288,
	PORT_DEV_SMP_TRGT = 262144,
	PORT_DEV_STP_TRGT = 131072,
	PORT_DEV_SSP_INIT = 2048,
	PORT_DEV_SMP_INIT = 1024,
	PORT_DEV_STP_INIT = 512,
	PORT_PHY_ID_MASK = 4278190080,
	PORT_SSP_TRGT_MASK = 524288,
	PORT_SSP_INIT_MASK = 2048,
	PORT_DEV_TRGT_MASK = 917504,
	PORT_DEV_INIT_MASK = 3584,
	PORT_DEV_TYPE_MASK = 7,
	PHY_RDY = 4,
	PHY_DW_SYNC = 2,
	PHY_OOB_DTCTD = 1,
	PHY_MODE6_LATECLK = 536870912,
	PHY_MODE6_DTL_SPEED = 134217728,
	PHY_MODE6_FC_ORDER = 67108864,
	PHY_MODE6_MUCNT_EN = 16777216,
	PHY_MODE6_SEL_MUCNT_LEN = 4194304,
	PHY_MODE6_SELMUPI = 1048576,
	PHY_MODE6_SELMUPF = 262144,
	PHY_MODE6_SELMUFF = 65536,
	PHY_MODE6_SELMUFI = 16384,
	PHY_MODE6_FREEZE_LOOP = 4096,
	PHY_MODE6_INT_RXFOFFS = 8,
	PHY_MODE6_FRC_RXFOFFS = 4,
	PHY_MODE6_STAU_0D8 = 2,
	PHY_MODE6_RXSAT_DIS = 1,
};

enum hw_registers {
	MVS_GBL_CTL = 4,
	MVS_GBL_INT_STAT = 0,
	MVS_GBL_PI = 12,
	MVS_PHY_CTL = 64,
	MVS_PORTS_IMP = 156,
	MVS_GBL_PORT_TYPE = 160,
	MVS_CTL = 256,
	MVS_PCS = 260,
	MVS_CMD_LIST_LO = 264,
	MVS_CMD_LIST_HI = 268,
	MVS_RX_FIS_LO = 272,
	MVS_RX_FIS_HI = 276,
	MVS_STP_REG_SET_0 = 280,
	MVS_STP_REG_SET_1 = 284,
	MVS_TX_CFG = 288,
	MVS_TX_LO = 292,
	MVS_TX_HI = 296,
	MVS_TX_PROD_IDX = 300,
	MVS_TX_CONS_IDX = 304,
	MVS_RX_CFG = 308,
	MVS_RX_LO = 312,
	MVS_RX_HI = 316,
	MVS_RX_CONS_IDX = 320,
	MVS_INT_COAL = 328,
	MVS_INT_COAL_TMOUT = 332,
	MVS_INT_STAT = 336,
	MVS_INT_MASK = 340,
	MVS_INT_STAT_SRS_0 = 344,
	MVS_INT_MASK_SRS_0 = 348,
	MVS_INT_STAT_SRS_1 = 352,
	MVS_INT_MASK_SRS_1 = 356,
	MVS_NON_NCQ_ERR_0 = 360,
	MVS_NON_NCQ_ERR_1 = 364,
	MVS_CMD_ADDR = 368,
	MVS_CMD_DATA = 372,
	MVS_MEM_PARITY_ERR = 376,
	MVS_P0_INT_STAT = 384,
	MVS_P0_INT_MASK = 388,
	MVS_P4_INT_STAT = 416,
	MVS_P4_INT_MASK = 420,
	MVS_P0_SER_CTLSTAT = 464,
	MVS_P4_SER_CTLSTAT = 480,
	MVS_P0_CFG_ADDR = 512,
	MVS_P0_CFG_DATA = 516,
	MVS_P4_CFG_ADDR = 544,
	MVS_P4_CFG_DATA = 548,
	MVS_P0_VSR_ADDR = 592,
	MVS_P0_VSR_DATA = 596,
	MVS_P4_VSR_ADDR = 592,
	MVS_P4_VSR_DATA = 596,
	MVS_PA_VSR_ADDR = 656,
	MVS_PA_VSR_PORT = 660,
	MVS_COMMAND_ACTIVE = 768,
};

enum hw_registers___2 {
	MVS_GBL_CTL___2 = 4,
	MVS_GBL_INT_STAT___2 = 8,
	MVS_GBL_PI___2 = 12,
	MVS_PHY_CTL___2 = 64,
	MVS_PORTS_IMP___2 = 156,
	MVS_GBL_PORT_TYPE___2 = 160,
	MVS_CTL___2 = 256,
	MVS_PCS___2 = 260,
	MVS_CMD_LIST_LO___2 = 264,
	MVS_CMD_LIST_HI___2 = 268,
	MVS_RX_FIS_LO___2 = 272,
	MVS_RX_FIS_HI___2 = 276,
	MVS_TX_CFG___2 = 288,
	MVS_TX_LO___2 = 292,
	MVS_TX_HI___2 = 296,
	MVS_TX_PROD_IDX___2 = 300,
	MVS_TX_CONS_IDX___2 = 304,
	MVS_RX_CFG___2 = 308,
	MVS_RX_LO___2 = 312,
	MVS_RX_HI___2 = 316,
	MVS_RX_CONS_IDX___2 = 320,
	MVS_INT_COAL___2 = 328,
	MVS_INT_COAL_TMOUT___2 = 332,
	MVS_INT_STAT___2 = 336,
	MVS_INT_MASK___2 = 340,
	MVS_INT_STAT_SRS_0___2 = 344,
	MVS_INT_MASK_SRS_0___2 = 348,
	MVS_P0_INT_STAT___2 = 352,
	MVS_P0_INT_MASK___2 = 356,
	MVS_P4_INT_STAT___2 = 512,
	MVS_P4_INT_MASK___2 = 516,
	MVS_P0_SER_CTLSTAT___2 = 384,
	MVS_P4_SER_CTLSTAT___2 = 544,
	MVS_CMD_ADDR___2 = 440,
	MVS_CMD_DATA___2 = 444,
	MVS_P0_CFG_ADDR___2 = 448,
	MVS_P0_CFG_DATA___2 = 452,
	MVS_P4_CFG_ADDR___2 = 560,
	MVS_P4_CFG_DATA___2 = 564,
	MVS_P0_VSR_ADDR___2 = 480,
	MVS_P0_VSR_DATA___2 = 484,
	MVS_P4_VSR_ADDR___2 = 592,
	MVS_P4_VSR_DATA___2 = 596,
};

enum hwh_type_enum {
	HWH_TYPE_IO = 1,
	HWH_TYPE_LOGOUT = 2,
	HWH_TYPE_TMF = 3,
	HWH_TYPE_NOP = 4,
	HWH_TYPE_IO_RD = 5,
	HWH_TYPE_LOGIN = 11,
	HWH_TYPE_INVALID = 4294967295,
};

enum hwmon_chip_attributes {
	hwmon_chip_temp_reset_history = 0,
	hwmon_chip_in_reset_history = 1,
	hwmon_chip_curr_reset_history = 2,
	hwmon_chip_power_reset_history = 3,
	hwmon_chip_register_tz = 4,
	hwmon_chip_update_interval = 5,
	hwmon_chip_alarms = 6,
	hwmon_chip_samples = 7,
	hwmon_chip_curr_samples = 8,
	hwmon_chip_in_samples = 9,
	hwmon_chip_power_samples = 10,
	hwmon_chip_temp_samples = 11,
	hwmon_chip_beep_enable = 12,
};

enum hwmon_curr_attributes {
	hwmon_curr_enable = 0,
	hwmon_curr_input = 1,
	hwmon_curr_min = 2,
	hwmon_curr_max = 3,
	hwmon_curr_lcrit = 4,
	hwmon_curr_crit = 5,
	hwmon_curr_average = 6,
	hwmon_curr_lowest = 7,
	hwmon_curr_highest = 8,
	hwmon_curr_reset_history = 9,
	hwmon_curr_label = 10,
	hwmon_curr_alarm = 11,
	hwmon_curr_min_alarm = 12,
	hwmon_curr_max_alarm = 13,
	hwmon_curr_lcrit_alarm = 14,
	hwmon_curr_crit_alarm = 15,
	hwmon_curr_rated_min = 16,
	hwmon_curr_rated_max = 17,
	hwmon_curr_beep = 18,
};

enum hwmon_energy_attributes {
	hwmon_energy_enable = 0,
	hwmon_energy_input = 1,
	hwmon_energy_label = 2,
};

enum hwmon_fan_attributes {
	hwmon_fan_enable = 0,
	hwmon_fan_input = 1,
	hwmon_fan_label = 2,
	hwmon_fan_min = 3,
	hwmon_fan_max = 4,
	hwmon_fan_div = 5,
	hwmon_fan_pulses = 6,
	hwmon_fan_target = 7,
	hwmon_fan_alarm = 8,
	hwmon_fan_min_alarm = 9,
	hwmon_fan_max_alarm = 10,
	hwmon_fan_fault = 11,
	hwmon_fan_beep = 12,
};

enum hwmon_humidity_attributes {
	hwmon_humidity_enable = 0,
	hwmon_humidity_input = 1,
	hwmon_humidity_label = 2,
	hwmon_humidity_min = 3,
	hwmon_humidity_min_hyst = 4,
	hwmon_humidity_max = 5,
	hwmon_humidity_max_hyst = 6,
	hwmon_humidity_alarm = 7,
	hwmon_humidity_fault = 8,
	hwmon_humidity_rated_min = 9,
	hwmon_humidity_rated_max = 10,
	hwmon_humidity_min_alarm = 11,
	hwmon_humidity_max_alarm = 12,
};

enum hwmon_in_attributes {
	hwmon_in_enable = 0,
	hwmon_in_input = 1,
	hwmon_in_min = 2,
	hwmon_in_max = 3,
	hwmon_in_lcrit = 4,
	hwmon_in_crit = 5,
	hwmon_in_average = 6,
	hwmon_in_lowest = 7,
	hwmon_in_highest = 8,
	hwmon_in_reset_history = 9,
	hwmon_in_label = 10,
	hwmon_in_alarm = 11,
	hwmon_in_min_alarm = 12,
	hwmon_in_max_alarm = 13,
	hwmon_in_lcrit_alarm = 14,
	hwmon_in_crit_alarm = 15,
	hwmon_in_rated_min = 16,
	hwmon_in_rated_max = 17,
	hwmon_in_beep = 18,
	hwmon_in_fault = 19,
};

enum hwmon_intrusion_attributes {
	hwmon_intrusion_alarm = 0,
	hwmon_intrusion_beep = 1,
};

enum hwmon_power_attributes {
	hwmon_power_enable = 0,
	hwmon_power_average = 1,
	hwmon_power_average_interval = 2,
	hwmon_power_average_interval_max = 3,
	hwmon_power_average_interval_min = 4,
	hwmon_power_average_highest = 5,
	hwmon_power_average_lowest = 6,
	hwmon_power_average_max = 7,
	hwmon_power_average_min = 8,
	hwmon_power_input = 9,
	hwmon_power_input_highest = 10,
	hwmon_power_input_lowest = 11,
	hwmon_power_reset_history = 12,
	hwmon_power_accuracy = 13,
	hwmon_power_cap = 14,
	hwmon_power_cap_hyst = 15,
	hwmon_power_cap_max = 16,
	hwmon_power_cap_min = 17,
	hwmon_power_min = 18,
	hwmon_power_max = 19,
	hwmon_power_crit = 20,
	hwmon_power_lcrit = 21,
	hwmon_power_label = 22,
	hwmon_power_alarm = 23,
	hwmon_power_cap_alarm = 24,
	hwmon_power_min_alarm = 25,
	hwmon_power_max_alarm = 26,
	hwmon_power_lcrit_alarm = 27,
	hwmon_power_crit_alarm = 28,
	hwmon_power_rated_min = 29,
	hwmon_power_rated_max = 30,
};

enum hwmon_pwm_attributes {
	hwmon_pwm_input = 0,
	hwmon_pwm_enable = 1,
	hwmon_pwm_mode = 2,
	hwmon_pwm_freq = 3,
	hwmon_pwm_auto_channels_temp = 4,
};

enum hwmon_sensor_types {
	hwmon_chip = 0,
	hwmon_temp = 1,
	hwmon_in = 2,
	hwmon_curr = 3,
	hwmon_power = 4,
	hwmon_energy = 5,
	hwmon_humidity = 6,
	hwmon_fan = 7,
	hwmon_pwm = 8,
	hwmon_intrusion = 9,
	hwmon_max = 10,
};

enum hwmon_temp_attributes {
	hwmon_temp_enable = 0,
	hwmon_temp_input = 1,
	hwmon_temp_type = 2,
	hwmon_temp_lcrit = 3,
	hwmon_temp_lcrit_hyst = 4,
	hwmon_temp_min = 5,
	hwmon_temp_min_hyst = 6,
	hwmon_temp_max = 7,
	hwmon_temp_max_hyst = 8,
	hwmon_temp_crit = 9,
	hwmon_temp_crit_hyst = 10,
	hwmon_temp_emergency = 11,
	hwmon_temp_emergency_hyst = 12,
	hwmon_temp_alarm = 13,
	hwmon_temp_lcrit_alarm = 14,
	hwmon_temp_min_alarm = 15,
	hwmon_temp_max_alarm = 16,
	hwmon_temp_crit_alarm = 17,
	hwmon_temp_emergency_alarm = 18,
	hwmon_temp_fault = 19,
	hwmon_temp_offset = 20,
	hwmon_temp_label = 21,
	hwmon_temp_lowest = 22,
	hwmon_temp_highest = 23,
	hwmon_temp_reset_history = 24,
	hwmon_temp_rated_min = 25,
	hwmon_temp_rated_max = 26,
	hwmon_temp_beep = 27,
};

enum hwparam_type {
	hwparam_ioport = 0,
	hwparam_iomem = 1,
	hwparam_ioport_or_iomem = 2,
	hwparam_irq = 3,
	hwparam_dma = 4,
	hwparam_dma_addr = 5,
	hwparam_other = 6,
};

enum hwtstamp_flags {
	HWTSTAMP_FLAG_BONDED_PHC_INDEX = 1,
	HWTSTAMP_FLAG_LAST = 1,
	HWTSTAMP_FLAG_MASK = 1,
};

enum hwtstamp_rx_filters {
	HWTSTAMP_FILTER_NONE = 0,
	HWTSTAMP_FILTER_ALL = 1,
	HWTSTAMP_FILTER_SOME = 2,
	HWTSTAMP_FILTER_PTP_V1_L4_EVENT = 3,
	HWTSTAMP_FILTER_PTP_V1_L4_SYNC = 4,
	HWTSTAMP_FILTER_PTP_V1_L4_DELAY_REQ = 5,
	HWTSTAMP_FILTER_PTP_V2_L4_EVENT = 6,
	HWTSTAMP_FILTER_PTP_V2_L4_SYNC = 7,
	HWTSTAMP_FILTER_PTP_V2_L4_DELAY_REQ = 8,
	HWTSTAMP_FILTER_PTP_V2_L2_EVENT = 9,
	HWTSTAMP_FILTER_PTP_V2_L2_SYNC = 10,
	HWTSTAMP_FILTER_PTP_V2_L2_DELAY_REQ = 11,
	HWTSTAMP_FILTER_PTP_V2_EVENT = 12,
	HWTSTAMP_FILTER_PTP_V2_SYNC = 13,
	HWTSTAMP_FILTER_PTP_V2_DELAY_REQ = 14,
	HWTSTAMP_FILTER_NTP_ALL = 15,
	__HWTSTAMP_FILTER_CNT = 16,
};

enum hwtstamp_source {
	HWTSTAMP_SOURCE_NETDEV = 0,
	HWTSTAMP_SOURCE_PHYLIB = 1,
};

enum hwtstamp_tx_types {
	HWTSTAMP_TX_OFF = 0,
	HWTSTAMP_TX_ON = 1,
	HWTSTAMP_TX_ONESTEP_SYNC = 2,
	HWTSTAMP_TX_ONESTEP_P2P = 3,
	__HWTSTAMP_TX_CNT = 4,
};

enum i2c_alert_protocol {
	I2C_PROTOCOL_SMBUS_ALERT = 0,
	I2C_PROTOCOL_SMBUS_HOST_NOTIFY = 1,
};

enum i2c_slave_event {
	I2C_SLAVE_READ_REQUESTED = 0,
	I2C_SLAVE_WRITE_REQUESTED = 1,
	I2C_SLAVE_READ_PROCESSED = 2,
	I2C_SLAVE_WRITE_RECEIVED = 3,
	I2C_SLAVE_STOP = 4,
};

enum i8042_controller_reset_mode {
	I8042_RESET_NEVER = 0,
	I8042_RESET_ALWAYS = 1,
	I8042_RESET_ON_S2RAM = 2,
};

enum ib_atomic_cap {
	IB_ATOMIC_NONE = 0,
	IB_ATOMIC_HCA = 1,
	IB_ATOMIC_GLOB = 2,
};

enum ib_cq_notify_flags {
	IB_CQ_SOLICITED = 1,
	IB_CQ_NEXT_COMP = 2,
	IB_CQ_SOLICITED_MASK = 3,
	IB_CQ_REPORT_MISSED_EVENTS = 4,
};

enum ib_event_type {
	IB_EVENT_CQ_ERR = 0,
	IB_EVENT_QP_FATAL = 1,
	IB_EVENT_QP_REQ_ERR = 2,
	IB_EVENT_QP_ACCESS_ERR = 3,
	IB_EVENT_COMM_EST = 4,
	IB_EVENT_SQ_DRAINED = 5,
	IB_EVENT_PATH_MIG = 6,
	IB_EVENT_PATH_MIG_ERR = 7,
	IB_EVENT_DEVICE_FATAL = 8,
	IB_EVENT_PORT_ACTIVE = 9,
	IB_EVENT_PORT_ERR = 10,
	IB_EVENT_LID_CHANGE = 11,
	IB_EVENT_PKEY_CHANGE = 12,
	IB_EVENT_SM_CHANGE = 13,
	IB_EVENT_SRQ_ERR = 14,
	IB_EVENT_SRQ_LIMIT_REACHED = 15,
	IB_EVENT_QP_LAST_WQE_REACHED = 16,
	IB_EVENT_CLIENT_REREGISTER = 17,
	IB_EVENT_GID_CHANGE = 18,
	IB_EVENT_WQ_FATAL = 19,
};

enum ib_flow_action_type {
	IB_FLOW_ACTION_UNSPECIFIED = 0,
	IB_FLOW_ACTION_ESP = 1,
};

enum ib_flow_attr_type {
	IB_FLOW_ATTR_NORMAL = 0,
	IB_FLOW_ATTR_ALL_DEFAULT = 1,
	IB_FLOW_ATTR_MC_DEFAULT = 2,
	IB_FLOW_ATTR_SNIFFER = 3,
};

enum ib_flow_spec_type {
	IB_FLOW_SPEC_ETH = 32,
	IB_FLOW_SPEC_IB = 34,
	IB_FLOW_SPEC_IPV4 = 48,
	IB_FLOW_SPEC_IPV6 = 49,
	IB_FLOW_SPEC_ESP = 52,
	IB_FLOW_SPEC_TCP = 64,
	IB_FLOW_SPEC_UDP = 65,
	IB_FLOW_SPEC_VXLAN_TUNNEL = 80,
	IB_FLOW_SPEC_GRE = 81,
	IB_FLOW_SPEC_MPLS = 96,
	IB_FLOW_SPEC_INNER = 256,
	IB_FLOW_SPEC_ACTION_TAG = 4096,
	IB_FLOW_SPEC_ACTION_DROP = 4097,
	IB_FLOW_SPEC_ACTION_HANDLE = 4098,
	IB_FLOW_SPEC_ACTION_COUNT = 4099,
};

enum ib_gid_type {
	IB_GID_TYPE_IB = 0,
	IB_GID_TYPE_ROCE = 1,
	IB_GID_TYPE_ROCE_UDP_ENCAP = 2,
	IB_GID_TYPE_SIZE = 3,
};

enum ib_mig_state {
	IB_MIG_MIGRATED = 0,
	IB_MIG_REARM = 1,
	IB_MIG_ARMED = 2,
};

enum ib_mr_type {
	IB_MR_TYPE_MEM_REG = 0,
	IB_MR_TYPE_SG_GAPS = 1,
	IB_MR_TYPE_DM = 2,
	IB_MR_TYPE_USER = 3,
	IB_MR_TYPE_DMA = 4,
	IB_MR_TYPE_INTEGRITY = 5,
};

enum ib_mtu {
	IB_MTU_256 = 1,
	IB_MTU_512 = 2,
	IB_MTU_1024 = 3,
	IB_MTU_2048 = 4,
	IB_MTU_4096 = 5,
};

enum ib_mw_type {
	IB_MW_TYPE_1 = 1,
	IB_MW_TYPE_2 = 2,
};

enum ib_poll_context {
	IB_POLL_SOFTIRQ = 0,
	IB_POLL_WORKQUEUE = 1,
	IB_POLL_UNBOUND_WORKQUEUE = 2,
	IB_POLL_LAST_POOL_TYPE = 2,
	IB_POLL_DIRECT = 3,
};

enum ib_port_state {
	IB_PORT_NOP = 0,
	IB_PORT_DOWN = 1,
	IB_PORT_INIT = 2,
	IB_PORT_ARMED = 3,
	IB_PORT_ACTIVE = 4,
	IB_PORT_ACTIVE_DEFER = 5,
};

enum ib_qp_state {
	IB_QPS_RESET = 0,
	IB_QPS_INIT = 1,
	IB_QPS_RTR = 2,
	IB_QPS_RTS = 3,
	IB_QPS_SQD = 4,
	IB_QPS_SQE = 5,
	IB_QPS_ERR = 6,
};

enum ib_qp_type {
	IB_QPT_SMI = 0,
	IB_QPT_GSI = 1,
	IB_QPT_RC = 2,
	IB_QPT_UC = 3,
	IB_QPT_UD = 4,
	IB_QPT_RAW_IPV6 = 5,
	IB_QPT_RAW_ETHERTYPE = 6,
	IB_QPT_RAW_PACKET = 8,
	IB_QPT_XRC_INI = 9,
	IB_QPT_XRC_TGT = 10,
	IB_QPT_MAX = 11,
	IB_QPT_DRIVER = 255,
	IB_QPT_RESERVED1 = 4096,
	IB_QPT_RESERVED2 = 4097,
	IB_QPT_RESERVED3 = 4098,
	IB_QPT_RESERVED4 = 4099,
	IB_QPT_RESERVED5 = 4100,
	IB_QPT_RESERVED6 = 4101,
	IB_QPT_RESERVED7 = 4102,
	IB_QPT_RESERVED8 = 4103,
	IB_QPT_RESERVED9 = 4104,
	IB_QPT_RESERVED10 = 4105,
};

enum ib_sig_err_type {
	IB_SIG_BAD_GUARD = 0,
	IB_SIG_BAD_REFTAG = 1,
	IB_SIG_BAD_APPTAG = 2,
};

enum ib_sig_type {
	IB_SIGNAL_ALL_WR = 0,
	IB_SIGNAL_REQ_WR = 1,
};

enum ib_signature_type {
	IB_SIG_TYPE_NONE = 0,
	IB_SIG_TYPE_T10_DIF = 1,
};

enum ib_srq_attr_mask {
	IB_SRQ_MAX_WR = 1,
	IB_SRQ_LIMIT = 2,
};

enum ib_srq_type {
	IB_SRQT_BASIC = 0,
	IB_SRQT_XRC = 1,
	IB_SRQT_TM = 2,
};

enum ib_t10_dif_bg_type {
	IB_T10DIF_CRC = 0,
	IB_T10DIF_CSUM = 1,
};

enum ib_uverbs_access_flags {
	IB_UVERBS_ACCESS_LOCAL_WRITE = 1,
	IB_UVERBS_ACCESS_REMOTE_WRITE = 2,
	IB_UVERBS_ACCESS_REMOTE_READ = 4,
	IB_UVERBS_ACCESS_REMOTE_ATOMIC = 8,
	IB_UVERBS_ACCESS_MW_BIND = 16,
	IB_UVERBS_ACCESS_ZERO_BASED = 32,
	IB_UVERBS_ACCESS_ON_DEMAND = 64,
	IB_UVERBS_ACCESS_HUGETLB = 128,
	IB_UVERBS_ACCESS_FLUSH_GLOBAL = 256,
	IB_UVERBS_ACCESS_FLUSH_PERSISTENT = 512,
	IB_UVERBS_ACCESS_RELAXED_ORDERING = 1048576,
	IB_UVERBS_ACCESS_OPTIONAL_RANGE = 1072693248,
};

enum ib_uverbs_advise_mr_advice {
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH = 0,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_WRITE = 1,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_NO_FAULT = 2,
};

enum ib_uverbs_create_qp_mask {
	IB_UVERBS_CREATE_QP_MASK_IND_TABLE = 1,
};

enum ib_uverbs_device_cap_flags {
	IB_UVERBS_DEVICE_RESIZE_MAX_WR = 1ULL,
	IB_UVERBS_DEVICE_BAD_PKEY_CNTR = 2ULL,
	IB_UVERBS_DEVICE_BAD_QKEY_CNTR = 4ULL,
	IB_UVERBS_DEVICE_RAW_MULTI = 8ULL,
	IB_UVERBS_DEVICE_AUTO_PATH_MIG = 16ULL,
	IB_UVERBS_DEVICE_CHANGE_PHY_PORT = 32ULL,
	IB_UVERBS_DEVICE_UD_AV_PORT_ENFORCE = 64ULL,
	IB_UVERBS_DEVICE_CURR_QP_STATE_MOD = 128ULL,
	IB_UVERBS_DEVICE_SHUTDOWN_PORT = 256ULL,
	IB_UVERBS_DEVICE_PORT_ACTIVE_EVENT = 1024ULL,
	IB_UVERBS_DEVICE_SYS_IMAGE_GUID = 2048ULL,
	IB_UVERBS_DEVICE_RC_RNR_NAK_GEN = 4096ULL,
	IB_UVERBS_DEVICE_SRQ_RESIZE = 8192ULL,
	IB_UVERBS_DEVICE_N_NOTIFY_CQ = 16384ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW = 131072ULL,
	IB_UVERBS_DEVICE_UD_IP_CSUM = 262144ULL,
	IB_UVERBS_DEVICE_XRC = 1048576ULL,
	IB_UVERBS_DEVICE_MEM_MGT_EXTENSIONS = 2097152ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2A = 8388608ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2B = 16777216ULL,
	IB_UVERBS_DEVICE_RC_IP_CSUM = 33554432ULL,
	IB_UVERBS_DEVICE_RAW_IP_CSUM = 67108864ULL,
	IB_UVERBS_DEVICE_MANAGED_FLOW_STEERING = 536870912ULL,
	IB_UVERBS_DEVICE_RAW_SCATTER_FCS = 17179869184ULL,
	IB_UVERBS_DEVICE_PCI_WRITE_END_PADDING = 68719476736ULL,
	IB_UVERBS_DEVICE_FLUSH_GLOBAL = 274877906944ULL,
	IB_UVERBS_DEVICE_FLUSH_PERSISTENT = 549755813888ULL,
	IB_UVERBS_DEVICE_ATOMIC_WRITE = 1099511627776ULL,
};

enum ib_uverbs_gid_type {
	IB_UVERBS_GID_TYPE_IB = 0,
	IB_UVERBS_GID_TYPE_ROCE_V1 = 1,
	IB_UVERBS_GID_TYPE_ROCE_V2 = 2,
};

enum ib_uverbs_qp_create_flags {
	IB_UVERBS_QP_CREATE_BLOCK_MULTICAST_LOOPBACK = 2,
	IB_UVERBS_QP_CREATE_SCATTER_FCS = 256,
	IB_UVERBS_QP_CREATE_CVLAN_STRIPPING = 512,
	IB_UVERBS_QP_CREATE_PCI_WRITE_END_PADDING = 2048,
	IB_UVERBS_QP_CREATE_SQ_SIG_ALL = 4096,
};

enum ib_uverbs_qp_type {
	IB_UVERBS_QPT_RC = 2,
	IB_UVERBS_QPT_UC = 3,
	IB_UVERBS_QPT_UD = 4,
	IB_UVERBS_QPT_RAW_PACKET = 8,
	IB_UVERBS_QPT_XRC_INI = 9,
	IB_UVERBS_QPT_XRC_TGT = 10,
	IB_UVERBS_QPT_DRIVER = 255,
};

enum ib_uverbs_raw_packet_caps {
	IB_UVERBS_RAW_PACKET_CAP_CVLAN_STRIPPING = 1,
	IB_UVERBS_RAW_PACKET_CAP_SCATTER_FCS = 2,
	IB_UVERBS_RAW_PACKET_CAP_IP_CSUM = 4,
	IB_UVERBS_RAW_PACKET_CAP_DELAY_DROP = 8,
};

enum ib_uverbs_srq_type {
	IB_UVERBS_SRQT_BASIC = 0,
	IB_UVERBS_SRQT_XRC = 1,
	IB_UVERBS_SRQT_TM = 2,
};

enum ib_uverbs_wc_opcode {
	IB_UVERBS_WC_SEND = 0,
	IB_UVERBS_WC_RDMA_WRITE = 1,
	IB_UVERBS_WC_RDMA_READ = 2,
	IB_UVERBS_WC_COMP_SWAP = 3,
	IB_UVERBS_WC_FETCH_ADD = 4,
	IB_UVERBS_WC_BIND_MW = 5,
	IB_UVERBS_WC_LOCAL_INV = 6,
	IB_UVERBS_WC_TSO = 7,
	IB_UVERBS_WC_FLUSH = 8,
	IB_UVERBS_WC_ATOMIC_WRITE = 9,
};

enum ib_uverbs_wq_flags {
	IB_UVERBS_WQ_FLAGS_CVLAN_STRIPPING = 1,
	IB_UVERBS_WQ_FLAGS_SCATTER_FCS = 2,
	IB_UVERBS_WQ_FLAGS_DELAY_DROP = 4,
	IB_UVERBS_WQ_FLAGS_PCI_WRITE_END_PADDING = 8,
};

enum ib_uverbs_wq_type {
	IB_UVERBS_WQT_RQ = 0,
};

enum ib_uverbs_wr_opcode {
	IB_UVERBS_WR_RDMA_WRITE = 0,
	IB_UVERBS_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_UVERBS_WR_SEND = 2,
	IB_UVERBS_WR_SEND_WITH_IMM = 3,
	IB_UVERBS_WR_RDMA_READ = 4,
	IB_UVERBS_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_UVERBS_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_UVERBS_WR_LOCAL_INV = 7,
	IB_UVERBS_WR_BIND_MW = 8,
	IB_UVERBS_WR_SEND_WITH_INV = 9,
	IB_UVERBS_WR_TSO = 10,
	IB_UVERBS_WR_RDMA_READ_WITH_INV = 11,
	IB_UVERBS_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_UVERBS_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_UVERBS_WR_FLUSH = 14,
	IB_UVERBS_WR_ATOMIC_WRITE = 15,
};

enum ib_uverbs_write_cmds {
	IB_USER_VERBS_CMD_GET_CONTEXT = 0,
	IB_USER_VERBS_CMD_QUERY_DEVICE = 1,
	IB_USER_VERBS_CMD_QUERY_PORT = 2,
	IB_USER_VERBS_CMD_ALLOC_PD = 3,
	IB_USER_VERBS_CMD_DEALLOC_PD = 4,
	IB_USER_VERBS_CMD_CREATE_AH = 5,
	IB_USER_VERBS_CMD_MODIFY_AH = 6,
	IB_USER_VERBS_CMD_QUERY_AH = 7,
	IB_USER_VERBS_CMD_DESTROY_AH = 8,
	IB_USER_VERBS_CMD_REG_MR = 9,
	IB_USER_VERBS_CMD_REG_SMR = 10,
	IB_USER_VERBS_CMD_REREG_MR = 11,
	IB_USER_VERBS_CMD_QUERY_MR = 12,
	IB_USER_VERBS_CMD_DEREG_MR = 13,
	IB_USER_VERBS_CMD_ALLOC_MW = 14,
	IB_USER_VERBS_CMD_BIND_MW = 15,
	IB_USER_VERBS_CMD_DEALLOC_MW = 16,
	IB_USER_VERBS_CMD_CREATE_COMP_CHANNEL = 17,
	IB_USER_VERBS_CMD_CREATE_CQ = 18,
	IB_USER_VERBS_CMD_RESIZE_CQ = 19,
	IB_USER_VERBS_CMD_DESTROY_CQ = 20,
	IB_USER_VERBS_CMD_POLL_CQ = 21,
	IB_USER_VERBS_CMD_PEEK_CQ = 22,
	IB_USER_VERBS_CMD_REQ_NOTIFY_CQ = 23,
	IB_USER_VERBS_CMD_CREATE_QP = 24,
	IB_USER_VERBS_CMD_QUERY_QP = 25,
	IB_USER_VERBS_CMD_MODIFY_QP = 26,
	IB_USER_VERBS_CMD_DESTROY_QP = 27,
	IB_USER_VERBS_CMD_POST_SEND = 28,
	IB_USER_VERBS_CMD_POST_RECV = 29,
	IB_USER_VERBS_CMD_ATTACH_MCAST = 30,
	IB_USER_VERBS_CMD_DETACH_MCAST = 31,
	IB_USER_VERBS_CMD_CREATE_SRQ = 32,
	IB_USER_VERBS_CMD_MODIFY_SRQ = 33,
	IB_USER_VERBS_CMD_QUERY_SRQ = 34,
	IB_USER_VERBS_CMD_DESTROY_SRQ = 35,
	IB_USER_VERBS_CMD_POST_SRQ_RECV = 36,
	IB_USER_VERBS_CMD_OPEN_XRCD = 37,
	IB_USER_VERBS_CMD_CLOSE_XRCD = 38,
	IB_USER_VERBS_CMD_CREATE_XSRQ = 39,
	IB_USER_VERBS_CMD_OPEN_QP = 40,
};

enum ib_wc_opcode {
	IB_WC_SEND = 0,
	IB_WC_RDMA_WRITE = 1,
	IB_WC_RDMA_READ = 2,
	IB_WC_COMP_SWAP = 3,
	IB_WC_FETCH_ADD = 4,
	IB_WC_BIND_MW = 5,
	IB_WC_LOCAL_INV = 6,
	IB_WC_LSO = 7,
	IB_WC_ATOMIC_WRITE = 9,
	IB_WC_REG_MR = 10,
	IB_WC_MASKED_COMP_SWAP = 11,
	IB_WC_MASKED_FETCH_ADD = 12,
	IB_WC_FLUSH = 8,
	IB_WC_RECV = 128,
	IB_WC_RECV_RDMA_WITH_IMM = 129,
};

enum ib_wc_status {
	IB_WC_SUCCESS = 0,
	IB_WC_LOC_LEN_ERR = 1,
	IB_WC_LOC_QP_OP_ERR = 2,
	IB_WC_LOC_EEC_OP_ERR = 3,
	IB_WC_LOC_PROT_ERR = 4,
	IB_WC_WR_FLUSH_ERR = 5,
	IB_WC_MW_BIND_ERR = 6,
	IB_WC_BAD_RESP_ERR = 7,
	IB_WC_LOC_ACCESS_ERR = 8,
	IB_WC_REM_INV_REQ_ERR = 9,
	IB_WC_REM_ACCESS_ERR = 10,
	IB_WC_REM_OP_ERR = 11,
	IB_WC_RETRY_EXC_ERR = 12,
	IB_WC_RNR_RETRY_EXC_ERR = 13,
	IB_WC_LOC_RDD_VIOL_ERR = 14,
	IB_WC_REM_INV_RD_REQ_ERR = 15,
	IB_WC_REM_ABORT_ERR = 16,
	IB_WC_INV_EECN_ERR = 17,
	IB_WC_INV_EEC_STATE_ERR = 18,
	IB_WC_FATAL_ERR = 19,
	IB_WC_RESP_TIMEOUT_ERR = 20,
	IB_WC_GENERAL_ERR = 21,
};

enum ib_wq_state {
	IB_WQS_RESET = 0,
	IB_WQS_RDY = 1,
	IB_WQS_ERR = 2,
};

enum ib_wq_type {
	IB_WQT_RQ = 0,
};

enum ib_wr_opcode {
	IB_WR_RDMA_WRITE = 0,
	IB_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_WR_SEND = 2,
	IB_WR_SEND_WITH_IMM = 3,
	IB_WR_RDMA_READ = 4,
	IB_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_WR_BIND_MW = 8,
	IB_WR_LSO = 10,
	IB_WR_SEND_WITH_INV = 9,
	IB_WR_RDMA_READ_WITH_INV = 11,
	IB_WR_LOCAL_INV = 7,
	IB_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_WR_FLUSH = 14,
	IB_WR_ATOMIC_WRITE = 15,
	IB_WR_REG_MR = 32,
	IB_WR_REG_MR_INTEGRITY = 33,
	IB_WR_RESERVED1 = 240,
	IB_WR_RESERVED2 = 241,
	IB_WR_RESERVED3 = 242,
	IB_WR_RESERVED4 = 243,
	IB_WR_RESERVED5 = 244,
	IB_WR_RESERVED6 = 245,
	IB_WR_RESERVED7 = 246,
	IB_WR_RESERVED8 = 247,
	IB_WR_RESERVED9 = 248,
	IB_WR_RESERVED10 = 249,
};

enum ibmvfc_ae_link_state {
	IBMVFC_AE_LS_LINK_UP = 1,
	IBMVFC_AE_LS_LINK_BOUNCED = 2,
	IBMVFC_AE_LS_LINK_DOWN = 4,
	IBMVFC_AE_LS_LINK_DEAD = 8,
};

enum ibmvfc_async_event {
	IBMVFC_AE_ELS_PLOGI = 1,
	IBMVFC_AE_ELS_LOGO = 2,
	IBMVFC_AE_ELS_PRLO = 4,
	IBMVFC_AE_SCN_NPORT = 8,
	IBMVFC_AE_SCN_GROUP = 16,
	IBMVFC_AE_SCN_DOMAIN = 32,
	IBMVFC_AE_SCN_FABRIC = 64,
	IBMVFC_AE_LINK_UP = 128,
	IBMVFC_AE_LINK_DOWN = 256,
	IBMVFC_AE_LINK_DEAD = 512,
	IBMVFC_AE_HALT = 1024,
	IBMVFC_AE_RESUME = 2048,
	IBMVFC_AE_ADAPTER_FAILED = 4096,
	IBMVFC_AE_FPIN = 8192,
};

enum ibmvfc_cmd_flags {
	IBMVFC_SCATTERLIST = 1,
	IBMVFC_NO_MEM_DESC = 2,
	IBMVFC_READ = 4,
	IBMVFC_WRITE = 8,
	IBMVFC_TMF = 128,
	IBMVFC_CLASS_3_ERR = 256,
};

enum ibmvfc_cmd_status_flags {
	IBMVFC_FABRIC_MAPPED = 1,
	IBMVFC_VIOS_FAILURE = 2,
	IBMVFC_FC_FAILURE = 4,
	IBMVFC_FC_SCSI_ERROR = 8,
	IBMVFC_HW_EVENT_LOGGED = 16,
	IBMVFC_VIOS_LOGGED = 32,
};

enum ibmvfc_crq_formats {
	IBMVFC_CMD_FORMAT = 1,
	IBMVFC_ASYNC_EVENT = 2,
	IBMVFC_MAD_FORMAT = 4,
};

enum ibmvfc_crq_init_msg {
	IBMVFC_CRQ_INIT = 1,
	IBMVFC_CRQ_INIT_COMPLETE = 2,
};

enum ibmvfc_crq_valid {
	IBMVFC_CRQ_CMD_RSP = 128,
	IBMVFC_CRQ_INIT_RSP = 192,
	IBMVFC_CRQ_XPORT_EVENT = 255,
};

enum ibmvfc_crq_xport_evts {
	IBMVFC_PARTNER_FAILED = 1,
	IBMVFC_PARTNER_DEREGISTER = 2,
	IBMVFC_PARTITION_MIGRATED = 6,
};

enum ibmvfc_fabric_mapped_errors {
	IBMVFC_UNABLE_TO_ESTABLISH = 1,
	IBMVFC_XPORT_FAULT = 2,
	IBMVFC_CMD_TIMEOUT = 3,
	IBMVFC_ENETDOWN = 4,
	IBMVFC_HW_FAILURE = 5,
	IBMVFC_LINK_DOWN_ERR = 6,
	IBMVFC_LINK_DEAD_ERR = 7,
	IBMVFC_UNABLE_TO_REGISTER = 8,
	IBMVFC_XPORT_BUSY = 10,
	IBMVFC_XPORT_DEAD = 11,
	IBMVFC_CONFIG_ERROR = 12,
	IBMVFC_NAME_SERVER_FAIL = 13,
	IBMVFC_LINK_HALTED = 14,
	IBMVFC_XPORT_GENERAL = 32768,
};

enum ibmvfc_fc_reason {
	IBMVFC_INVALID_ELS_CMD_CODE = 1,
	IBMVFC_INVALID_VERSION = 2,
	IBMVFC_LOGICAL_ERROR = 3,
	IBMVFC_INVALID_CT_IU_SIZE = 4,
	IBMVFC_LOGICAL_BUSY = 5,
	IBMVFC_PROTOCOL_ERROR = 7,
	IBMVFC_UNABLE_TO_PERFORM_REQ = 9,
	IBMVFC_CMD_NOT_SUPPORTED = 11,
	IBMVFC_SERVER_NOT_AVAIL = 13,
	IBMVFC_CMD_IN_PROGRESS = 14,
	IBMVFC_VENDOR_SPECIFIC = 255,
};

enum ibmvfc_fc_task_attr {
	IBMVFC_SIMPLE_TASK = 0,
	IBMVFC_HEAD_OF_QUEUE = 1,
	IBMVFC_ORDERED_TASK = 2,
	IBMVFC_ACA_TASK = 4,
};

enum ibmvfc_fc_tmf_flags {
	IBMVFC_ABORT_TASK_SET = 2,
	IBMVFC_LUN_RESET = 16,
	IBMVFC_TARGET_RESET = 32,
};

enum ibmvfc_fc_type {
	IBMVFC_FABRIC_REJECT = 1,
	IBMVFC_PORT_REJECT = 2,
	IBMVFC_LS_REJECT = 3,
	IBMVFC_FABRIC_BUSY = 4,
	IBMVFC_PORT_BUSY = 5,
	IBMVFC_BASIC_REJECT = 6,
};

enum ibmvfc_fcp_rsp_flags {
	FCP_BIDI_RSP = 128,
	FCP_BIDI_READ_RESID_UNDER = 64,
	FCP_BIDI_READ_RESID_OVER = 32,
	FCP_CONF_REQ = 16,
	FCP_RESID_UNDER___2 = 8,
	FCP_RESID_OVER___2 = 4,
	FCP_SNS_LEN_VALID = 2,
	FCP_RSP_LEN_VALID = 1,
};

enum ibmvfc_gs_explain {
	IBMVFC_PORT_NAME_NOT_REG = 2,
};

enum ibmvfc_host_action {
	IBMVFC_HOST_ACTION_NONE = 0,
	IBMVFC_HOST_ACTION_RESET = 1,
	IBMVFC_HOST_ACTION_REENABLE = 2,
	IBMVFC_HOST_ACTION_LOGO = 3,
	IBMVFC_HOST_ACTION_LOGO_WAIT = 4,
	IBMVFC_HOST_ACTION_INIT = 5,
	IBMVFC_HOST_ACTION_INIT_WAIT = 6,
	IBMVFC_HOST_ACTION_QUERY = 7,
	IBMVFC_HOST_ACTION_QUERY_TGTS = 8,
	IBMVFC_HOST_ACTION_TGT_DEL = 9,
	IBMVFC_HOST_ACTION_ALLOC_TGTS = 10,
	IBMVFC_HOST_ACTION_TGT_INIT = 11,
	IBMVFC_HOST_ACTION_TGT_DEL_FAILED = 12,
};

enum ibmvfc_host_state {
	IBMVFC_NO_CRQ = 0,
	IBMVFC_INITIALIZING = 1,
	IBMVFC_ACTIVE = 2,
	IBMVFC_HALTED = 3,
	IBMVFC_LINK_DOWN = 4,
	IBMVFC_LINK_DEAD = 5,
	IBMVFC_HOST_OFFLINE = 6,
};

enum ibmvfc_mad_types {
	IBMVFC_NPIV_LOGIN = 1,
	IBMVFC_DISC_TARGETS = 2,
	IBMVFC_PORT_LOGIN = 4,
	IBMVFC_PROCESS_LOGIN = 8,
	IBMVFC_QUERY_TARGET = 16,
	IBMVFC_MOVE_LOGIN = 32,
	IBMVFC_IMPLICIT_LOGOUT = 64,
	IBMVFC_PASSTHRU = 512,
	IBMVFC_TMF_MAD = 256,
	IBMVFC_NPIV_LOGOUT = 2048,
	IBMVFC_CHANNEL_ENQUIRY = 4096,
	IBMVFC_CHANNEL_SETUP = 8192,
	IBMVFC_CONNECTION_INFO = 16384,
};

enum ibmvfc_msg_fmt {
	IBMVFC_CRQ_FMT = 0,
	IBMVFC_ASYNC_FMT = 1,
	IBMVFC_SUB_CRQ_FMT = 2,
};

enum ibmvfc_protocol {
	IBMVFC_PROTO_SCSI = 0,
	IBMVFC_PROTO_NVME = 1,
};

enum ibmvfc_target_action {
	IBMVFC_TGT_ACTION_NONE = 0,
	IBMVFC_TGT_ACTION_INIT = 1,
	IBMVFC_TGT_ACTION_INIT_WAIT = 2,
	IBMVFC_TGT_ACTION_LOGOUT_RPORT = 3,
	IBMVFC_TGT_ACTION_LOGOUT_RPORT_WAIT = 4,
	IBMVFC_TGT_ACTION_DEL_RPORT = 5,
	IBMVFC_TGT_ACTION_DELETED_RPORT = 6,
	IBMVFC_TGT_ACTION_DEL_AND_LOGOUT_RPORT = 7,
	IBMVFC_TGT_ACTION_LOGOUT_DELETED_RPORT = 8,
};

enum ibmvfc_vios_errors {
	IBMVFC_CRQ_FAILURE = 1,
	IBMVFC_SW_FAILURE = 2,
	IBMVFC_INVALID_PARAMETER = 3,
	IBMVFC_MISSING_PARAMETER = 4,
	IBMVFC_HOST_IO_BUS = 5,
	IBMVFC_TRANS_CANCELLED = 6,
	IBMVFC_TRANS_CANCELLED_IMPLICIT = 7,
	IBMVFC_INSUFFICIENT_RESOURCE = 8,
	IBMVFC_PLOGI_REQUIRED = 16,
	IBMVFC_COMMAND_FAILED = 32768,
};

enum ibmvscsi_host_action {
	IBMVSCSI_HOST_ACTION_NONE = 0,
	IBMVSCSI_HOST_ACTION_RESET = 1,
	IBMVSCSI_HOST_ACTION_REENABLE = 2,
	IBMVSCSI_HOST_ACTION_UNBLOCK = 3,
};

enum id_action {
	ID_REMOVE = 0,
	ID_ADD = 1,
};

enum idle_boot_override {
	IDLE_NO_OVERRIDE = 0,
	IDLE_POWERSAVE_OFF = 1,
};

enum ieee80211_bss_type {
	IEEE80211_BSS_TYPE_ESS = 0,
	IEEE80211_BSS_TYPE_PBSS = 1,
	IEEE80211_BSS_TYPE_IBSS = 2,
	IEEE80211_BSS_TYPE_MBSS = 3,
	IEEE80211_BSS_TYPE_ANY = 4,
};

enum ieee80211_edmg_bw_config {
	IEEE80211_EDMG_BW_CONFIG_4 = 4,
	IEEE80211_EDMG_BW_CONFIG_5 = 5,
	IEEE80211_EDMG_BW_CONFIG_6 = 6,
	IEEE80211_EDMG_BW_CONFIG_7 = 7,
	IEEE80211_EDMG_BW_CONFIG_8 = 8,
	IEEE80211_EDMG_BW_CONFIG_9 = 9,
	IEEE80211_EDMG_BW_CONFIG_10 = 10,
	IEEE80211_EDMG_BW_CONFIG_11 = 11,
	IEEE80211_EDMG_BW_CONFIG_12 = 12,
	IEEE80211_EDMG_BW_CONFIG_13 = 13,
	IEEE80211_EDMG_BW_CONFIG_14 = 14,
	IEEE80211_EDMG_BW_CONFIG_15 = 15,
};

enum ieee802154_filtering_level {
	IEEE802154_FILTERING_NONE = 0,
	IEEE802154_FILTERING_1_FCS = 1,
	IEEE802154_FILTERING_2_PROMISCUOUS = 2,
	IEEE802154_FILTERING_3_SCAN = 3,
	IEEE802154_FILTERING_4_FRAME_FIELDS = 4,
};

enum ieee8021q_traffic_type {
	IEEE8021Q_TT_BK = 0,
	IEEE8021Q_TT_BE = 1,
	IEEE8021Q_TT_EE = 2,
	IEEE8021Q_TT_CA = 3,
	IEEE8021Q_TT_VI = 4,
	IEEE8021Q_TT_VO = 5,
	IEEE8021Q_TT_IC = 6,
	IEEE8021Q_TT_NC = 7,
	IEEE8021Q_TT_MAX = 8,
};

enum ieee_attrs {
	DCB_ATTR_IEEE_UNSPEC = 0,
	DCB_ATTR_IEEE_ETS = 1,
	DCB_ATTR_IEEE_PFC = 2,
	DCB_ATTR_IEEE_APP_TABLE = 3,
	DCB_ATTR_IEEE_PEER_ETS = 4,
	DCB_ATTR_IEEE_PEER_PFC = 5,
	DCB_ATTR_IEEE_PEER_APP = 6,
	DCB_ATTR_IEEE_MAXRATE = 7,
	DCB_ATTR_IEEE_QCN = 8,
	DCB_ATTR_IEEE_QCN_STATS = 9,
	DCB_ATTR_DCB_BUFFER = 10,
	DCB_ATTR_DCB_APP_TRUST_TABLE = 11,
	DCB_ATTR_DCB_REWR_TABLE = 12,
	__DCB_ATTR_IEEE_MAX = 13,
};

enum ieee_attrs_app {
	DCB_ATTR_IEEE_APP_UNSPEC = 0,
	DCB_ATTR_IEEE_APP = 1,
	DCB_ATTR_DCB_APP = 2,
	__DCB_ATTR_IEEE_APP_MAX = 3,
};

enum igu_int_cmd {
	IGU_INT_ENABLE = 0,
	IGU_INT_DISABLE = 1,
	IGU_INT_NOP = 2,
	IGU_INT_NOP2 = 3,
	MAX_IGU_INT_CMD = 4,
};

enum igu_seg_access {
	IGU_SEG_ACCESS_NORM = 0,
	IGU_SEG_ACCESS_DEF = 1,
	IGU_SEG_ACCESS_ATTN = 2,
	MAX_IGU_SEG_ACCESS = 3,
};

enum in6_addr_gen_mode {
	IN6_ADDR_GEN_MODE_EUI64 = 0,
	IN6_ADDR_GEN_MODE_NONE = 1,
	IN6_ADDR_GEN_MODE_STABLE_PRIVACY = 2,
	IN6_ADDR_GEN_MODE_RANDOM = 3,
};

enum index_mutex_classed {
	INDEX_MUTEX_I30 = 0,
	INDEX_MUTEX_SII = 1,
	INDEX_MUTEX_SDH = 2,
	INDEX_MUTEX_SO = 3,
	INDEX_MUTEX_SQ = 4,
	INDEX_MUTEX_SR = 5,
	INDEX_MUTEX_TOTAL = 6,
};

enum inet_csk_ack_state_t {
	ICSK_ACK_SCHED = 1,
	ICSK_ACK_TIMER = 2,
	ICSK_ACK_PUSHED = 4,
	ICSK_ACK_PUSHED2 = 8,
	ICSK_ACK_NOW = 16,
	ICSK_ACK_NOMEM = 32,
};

enum inode_i_mutex_lock_class {
	I_MUTEX_NORMAL = 0,
	I_MUTEX_PARENT = 1,
	I_MUTEX_CHILD = 2,
	I_MUTEX_XATTR = 3,
	I_MUTEX_NONDIR2 = 4,
	I_MUTEX_PARENT2 = 5,
};

enum inplace_mode {
	OUT_OF_PLACE = 0,
	INPLACE_ONE_SGLIST = 1,
	INPLACE_TWO_SGLISTS = 2,
};

enum input_clock_type {
	INPUT_CLK_REAL = 0,
	INPUT_CLK_MONO = 1,
	INPUT_CLK_BOOT = 2,
	INPUT_CLK_MAX = 3,
};

enum instruction_type {
	COMPUTE = 0,
	LOAD = 1,
	LOAD_MULTI = 2,
	LOAD_FP = 3,
	LOAD_VMX = 4,
	LOAD_VSX = 5,
	STORE = 6,
	STORE_MULTI = 7,
	STORE_FP = 8,
	STORE_VMX = 9,
	STORE_VSX = 10,
	LARX = 11,
	STCX = 12,
	BRANCH___2 = 13,
	MFSPR = 14,
	MTSPR = 15,
	CACHEOP = 16,
	BARRIER = 17,
	SYSCALL = 18,
	SYSCALL_VECTORED_0 = 19,
	MFMSR = 20,
	MTMSR = 21,
	RFI = 22,
	INTERRUPT = 23,
	UNKNOWN = 24,
};

enum int_type {
	SYS_INT = 1,
	DCDC_INT = 2,
	RTC_INT = 4,
	ADC_INT = 8,
	GPIO_INT___2 = 16,
};

enum intel_ufs_dsm_func_id {
	INTEL_DSM_FNS = 0,
	INTEL_DSM_RESET = 1,
};

enum interconnect_desc_param {
	INTERCONNECT_DESC_PARAM_LEN = 0,
	INTERCONNECT_DESC_PARAM_TYPE = 1,
	INTERCONNECT_DESC_PARAM_UNIPRO_VER = 2,
	INTERCONNECT_DESC_PARAM_MPHY_VER = 4,
};

enum intr_type_t {
	NONE = 0,
	INTx = 1,
	MSI = 2,
	MSIX = 3,
};

enum io_uring_cmd_flags {
	IO_URING_F_COMPLETE_DEFER = 1,
	IO_URING_F_UNLOCKED = 2,
	IO_URING_F_MULTISHOT = 4,
	IO_URING_F_IOWQ = 8,
	IO_URING_F_NONBLOCK = -2147483648,
	IO_URING_F_SQE128 = 256,
	IO_URING_F_CQE32 = 512,
	IO_URING_F_IOPOLL = 1024,
	IO_URING_F_CANCEL = 2048,
	IO_URING_F_COMPAT = 4096,
};

enum io_uring_msg_ring_flags {
	IORING_MSG_DATA = 0,
	IORING_MSG_SEND_FD = 1,
};

enum io_uring_op {
	IORING_OP_NOP = 0,
	IORING_OP_READV = 1,
	IORING_OP_WRITEV = 2,
	IORING_OP_FSYNC = 3,
	IORING_OP_READ_FIXED = 4,
	IORING_OP_WRITE_FIXED = 5,
	IORING_OP_POLL_ADD = 6,
	IORING_OP_POLL_REMOVE = 7,
	IORING_OP_SYNC_FILE_RANGE = 8,
	IORING_OP_SENDMSG = 9,
	IORING_OP_RECVMSG = 10,
	IORING_OP_TIMEOUT = 11,
	IORING_OP_TIMEOUT_REMOVE = 12,
	IORING_OP_ACCEPT = 13,
	IORING_OP_ASYNC_CANCEL = 14,
	IORING_OP_LINK_TIMEOUT = 15,
	IORING_OP_CONNECT = 16,
	IORING_OP_FALLOCATE = 17,
	IORING_OP_OPENAT = 18,
	IORING_OP_CLOSE = 19,
	IORING_OP_FILES_UPDATE = 20,
	IORING_OP_STATX = 21,
	IORING_OP_READ = 22,
	IORING_OP_WRITE = 23,
	IORING_OP_FADVISE = 24,
	IORING_OP_MADVISE = 25,
	IORING_OP_SEND = 26,
	IORING_OP_RECV = 27,
	IORING_OP_OPENAT2 = 28,
	IORING_OP_EPOLL_CTL = 29,
	IORING_OP_SPLICE = 30,
	IORING_OP_PROVIDE_BUFFERS = 31,
	IORING_OP_REMOVE_BUFFERS = 32,
	IORING_OP_TEE = 33,
	IORING_OP_SHUTDOWN = 34,
	IORING_OP_RENAMEAT = 35,
	IORING_OP_UNLINKAT = 36,
	IORING_OP_MKDIRAT = 37,
	IORING_OP_SYMLINKAT = 38,
	IORING_OP_LINKAT = 39,
	IORING_OP_MSG_RING = 40,
	IORING_OP_FSETXATTR = 41,
	IORING_OP_SETXATTR = 42,
	IORING_OP_FGETXATTR = 43,
	IORING_OP_GETXATTR = 44,
	IORING_OP_SOCKET = 45,
	IORING_OP_URING_CMD = 46,
	IORING_OP_SEND_ZC = 47,
	IORING_OP_SENDMSG_ZC = 48,
	IORING_OP_READ_MULTISHOT = 49,
	IORING_OP_WAITID = 50,
	IORING_OP_FUTEX_WAIT = 51,
	IORING_OP_FUTEX_WAKE = 52,
	IORING_OP_FUTEX_WAITV = 53,
	IORING_OP_FIXED_FD_INSTALL = 54,
	IORING_OP_FTRUNCATE = 55,
	IORING_OP_LAST = 56,
};

enum io_uring_register_op {
	IORING_REGISTER_BUFFERS = 0,
	IORING_UNREGISTER_BUFFERS = 1,
	IORING_REGISTER_FILES = 2,
	IORING_UNREGISTER_FILES = 3,
	IORING_REGISTER_EVENTFD = 4,
	IORING_UNREGISTER_EVENTFD = 5,
	IORING_REGISTER_FILES_UPDATE = 6,
	IORING_REGISTER_EVENTFD_ASYNC = 7,
	IORING_REGISTER_PROBE = 8,
	IORING_REGISTER_PERSONALITY = 9,
	IORING_UNREGISTER_PERSONALITY = 10,
	IORING_REGISTER_RESTRICTIONS = 11,
	IORING_REGISTER_ENABLE_RINGS = 12,
	IORING_REGISTER_FILES2 = 13,
	IORING_REGISTER_FILES_UPDATE2 = 14,
	IORING_REGISTER_BUFFERS2 = 15,
	IORING_REGISTER_BUFFERS_UPDATE = 16,
	IORING_REGISTER_IOWQ_AFF = 17,
	IORING_UNREGISTER_IOWQ_AFF = 18,
	IORING_REGISTER_IOWQ_MAX_WORKERS = 19,
	IORING_REGISTER_RING_FDS = 20,
	IORING_UNREGISTER_RING_FDS = 21,
	IORING_REGISTER_PBUF_RING = 22,
	IORING_UNREGISTER_PBUF_RING = 23,
	IORING_REGISTER_SYNC_CANCEL = 24,
	IORING_REGISTER_FILE_ALLOC_RANGE = 25,
	IORING_REGISTER_PBUF_STATUS = 26,
	IORING_REGISTER_NAPI = 27,
	IORING_UNREGISTER_NAPI = 28,
	IORING_REGISTER_LAST = 29,
	IORING_REGISTER_USE_REGISTERED_RING = 2147483648,
};

enum io_uring_register_pbuf_ring_flags {
	IOU_PBUF_RING_MMAP = 1,
};

enum io_uring_register_restriction_op {
	IORING_RESTRICTION_REGISTER_OP = 0,
	IORING_RESTRICTION_SQE_OP = 1,
	IORING_RESTRICTION_SQE_FLAGS_ALLOWED = 2,
	IORING_RESTRICTION_SQE_FLAGS_REQUIRED = 3,
	IORING_RESTRICTION_LAST = 4,
};

enum io_uring_socket_op {
	SOCKET_URING_OP_SIOCINQ = 0,
	SOCKET_URING_OP_SIOCOUTQ = 1,
	SOCKET_URING_OP_GETSOCKOPT = 2,
	SOCKET_URING_OP_SETSOCKOPT = 3,
};

enum io_uring_sqe_flags_bit {
	IOSQE_FIXED_FILE_BIT = 0,
	IOSQE_IO_DRAIN_BIT = 1,
	IOSQE_IO_LINK_BIT = 2,
	IOSQE_IO_HARDLINK_BIT = 3,
	IOSQE_ASYNC_BIT = 4,
	IOSQE_BUFFER_SELECT_BIT = 5,
	IOSQE_CQE_SKIP_SUCCESS_BIT = 6,
};

enum io_wq_cancel {
	IO_WQ_CANCEL_OK = 0,
	IO_WQ_CANCEL_RUNNING = 1,
	IO_WQ_CANCEL_NOTFOUND = 2,
};

enum io_wq_type {
	IO_WQ_BOUND = 0,
	IO_WQ_UNBOUND = 1,
};

enum ioam6_event_attr {
	IOAM6_EVENT_ATTR_UNSPEC = 0,
	IOAM6_EVENT_ATTR_TRACE_NAMESPACE = 1,
	IOAM6_EVENT_ATTR_TRACE_NODELEN = 2,
	IOAM6_EVENT_ATTR_TRACE_TYPE = 3,
	IOAM6_EVENT_ATTR_TRACE_DATA = 4,
	__IOAM6_EVENT_ATTR_MAX = 5,
};

enum ioam6_event_type {
	IOAM6_EVENT_UNSPEC = 0,
	IOAM6_EVENT_TRACE = 1,
};

enum ioc_event {
	IOC_E_RESET = 1,
	IOC_E_ENABLE = 2,
	IOC_E_DISABLE = 3,
	IOC_E_DETACH = 4,
	IOC_E_ENABLED = 5,
	IOC_E_FWRSP_GETATTR = 6,
	IOC_E_DISABLED = 7,
	IOC_E_PFFAILED = 8,
	IOC_E_HBFAIL = 9,
	IOC_E_HWERROR = 10,
	IOC_E_TIMEOUT = 11,
	IOC_E_HWFAILED = 12,
};

enum ioc_running {
	IOC_IDLE = 0,
	IOC_RUNNING = 1,
	IOC_STOP = 2,
};

enum iocfc_event {
	IOCFC_E_INIT = 1,
	IOCFC_E_START = 2,
	IOCFC_E_STOP = 3,
	IOCFC_E_ENABLE = 4,
	IOCFC_E_DISABLE = 5,
	IOCFC_E_IOC_ENABLED = 6,
	IOCFC_E_IOC_DISABLED = 7,
	IOCFC_E_IOC_FAILED = 8,
	IOCFC_E_DCONF_DONE = 9,
	IOCFC_E_CFG_DONE = 10,
};

enum iocpf_event {
	IOCPF_E_ENABLE = 1,
	IOCPF_E_DISABLE = 2,
	IOCPF_E_STOP = 3,
	IOCPF_E_FWREADY = 4,
	IOCPF_E_FWRSP_ENABLE = 5,
	IOCPF_E_FWRSP_DISABLE = 6,
	IOCPF_E_FAIL = 7,
	IOCPF_E_INITFAIL = 8,
	IOCPF_E_GETATTRFAIL = 9,
	IOCPF_E_SEMLOCKED = 10,
	IOCPF_E_TIMEOUT = 11,
	IOCPF_E_SEM_ERROR = 12,
};

enum iommu_cap {
	IOMMU_CAP_CACHE_COHERENCY = 0,
	IOMMU_CAP_NOEXEC = 1,
	IOMMU_CAP_PRE_BOOT_PROTECTION = 2,
	IOMMU_CAP_ENFORCE_CACHE_COHERENCY = 3,
	IOMMU_CAP_DEFERRED_FLUSH = 4,
	IOMMU_CAP_DIRTY_TRACKING = 5,
};

enum iommu_dev_features {
	IOMMU_DEV_FEAT_SVA = 0,
	IOMMU_DEV_FEAT_IOPF = 1,
};

enum iommu_resv_type {
	IOMMU_RESV_DIRECT = 0,
	IOMMU_RESV_DIRECT_RELAXABLE = 1,
	IOMMU_RESV_RESERVED = 2,
	IOMMU_RESV_MSI = 3,
	IOMMU_RESV_SW_MSI = 4,
};

enum ip6_defrag_users {
	IP6_DEFRAG_LOCAL_DELIVER = 0,
	IP6_DEFRAG_CONNTRACK_IN = 1,
	__IP6_DEFRAG_CONNTRACK_IN = 65536,
	IP6_DEFRAG_CONNTRACK_OUT = 65537,
	__IP6_DEFRAG_CONNTRACK_OUT = 131072,
	IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 131073,
	__IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 196608,
};

enum ip_conntrack_dir {
	IP_CT_DIR_ORIGINAL = 0,
	IP_CT_DIR_REPLY = 1,
	IP_CT_DIR_MAX = 2,
};

enum ip_conntrack_info {
	IP_CT_ESTABLISHED = 0,
	IP_CT_RELATED = 1,
	IP_CT_NEW = 2,
	IP_CT_IS_REPLY = 3,
	IP_CT_ESTABLISHED_REPLY = 3,
	IP_CT_RELATED_REPLY = 4,
	IP_CT_NUMBER = 5,
	IP_CT_UNTRACKED = 7,
};

enum ip_conntrack_status {
	IPS_EXPECTED_BIT = 0,
	IPS_EXPECTED = 1,
	IPS_SEEN_REPLY_BIT = 1,
	IPS_SEEN_REPLY = 2,
	IPS_ASSURED_BIT = 2,
	IPS_ASSURED = 4,
	IPS_CONFIRMED_BIT = 3,
	IPS_CONFIRMED = 8,
	IPS_SRC_NAT_BIT = 4,
	IPS_SRC_NAT = 16,
	IPS_DST_NAT_BIT = 5,
	IPS_DST_NAT = 32,
	IPS_NAT_MASK = 48,
	IPS_SEQ_ADJUST_BIT = 6,
	IPS_SEQ_ADJUST = 64,
	IPS_SRC_NAT_DONE_BIT = 7,
	IPS_SRC_NAT_DONE = 128,
	IPS_DST_NAT_DONE_BIT = 8,
	IPS_DST_NAT_DONE = 256,
	IPS_NAT_DONE_MASK = 384,
	IPS_DYING_BIT = 9,
	IPS_DYING = 512,
	IPS_FIXED_TIMEOUT_BIT = 10,
	IPS_FIXED_TIMEOUT = 1024,
	IPS_TEMPLATE_BIT = 11,
	IPS_TEMPLATE = 2048,
	IPS_UNTRACKED_BIT = 12,
	IPS_UNTRACKED = 4096,
	IPS_NAT_CLASH_BIT = 12,
	IPS_NAT_CLASH = 4096,
	IPS_HELPER_BIT = 13,
	IPS_HELPER = 8192,
	IPS_OFFLOAD_BIT = 14,
	IPS_OFFLOAD = 16384,
	IPS_HW_OFFLOAD_BIT = 15,
	IPS_HW_OFFLOAD = 32768,
	IPS_UNCHANGEABLE_MASK = 56313,
	__IPS_MAX_BIT = 16,
};

enum ip_defrag_users {
	IP_DEFRAG_LOCAL_DELIVER = 0,
	IP_DEFRAG_CALL_RA_CHAIN = 1,
	IP_DEFRAG_CONNTRACK_IN = 2,
	__IP_DEFRAG_CONNTRACK_IN_END = 65537,
	IP_DEFRAG_CONNTRACK_OUT = 65538,
	__IP_DEFRAG_CONNTRACK_OUT_END = 131073,
	IP_DEFRAG_CONNTRACK_BRIDGE_IN = 131074,
	__IP_DEFRAG_CONNTRACK_BRIDGE_IN = 196609,
	IP_DEFRAG_VS_IN = 196610,
	IP_DEFRAG_VS_OUT = 196611,
	IP_DEFRAG_VS_FWD = 196612,
	IP_DEFRAG_AF_PACKET = 196613,
	IP_DEFRAG_MACVLAN = 196614,
};

enum ipmi_addr_space {
	IPMI_IO_ADDR_SPACE = 0,
	IPMI_MEM_ADDR_SPACE = 1,
};

enum ipmi_addr_src {
	SI_INVALID = 0,
	SI_HOTMOD = 1,
	SI_HARDCODED = 2,
	SI_SPMI = 3,
	SI_ACPI = 4,
	SI_SMBIOS = 5,
	SI_PCI = 6,
	SI_DEVICETREE = 7,
	SI_PLATFORM = 8,
	SI_LAST = 9,
};

enum ipmi_plat_interface_type {
	IPMI_PLAT_IF_SI = 0,
	IPMI_PLAT_IF_SSIF = 1,
};

enum irq_domain_bus_token {
	DOMAIN_BUS_ANY = 0,
	DOMAIN_BUS_WIRED = 1,
	DOMAIN_BUS_GENERIC_MSI = 2,
	DOMAIN_BUS_PCI_MSI = 3,
	DOMAIN_BUS_PLATFORM_MSI = 4,
	DOMAIN_BUS_NEXUS = 5,
	DOMAIN_BUS_IPI = 6,
	DOMAIN_BUS_FSL_MC_MSI = 7,
	DOMAIN_BUS_TI_SCI_INTA_MSI = 8,
	DOMAIN_BUS_WAKEUP = 9,
	DOMAIN_BUS_VMD_MSI = 10,
	DOMAIN_BUS_PCI_DEVICE_MSI = 11,
	DOMAIN_BUS_PCI_DEVICE_MSIX = 12,
	DOMAIN_BUS_DMAR = 13,
	DOMAIN_BUS_AMDVI = 14,
	DOMAIN_BUS_DEVICE_MSI = 15,
	DOMAIN_BUS_WIRED_TO_MSI = 16,
};

enum irq_gc_flags {
	IRQ_GC_INIT_MASK_CACHE = 1,
	IRQ_GC_INIT_NESTED_LOCK = 2,
	IRQ_GC_MASK_CACHE_PER_TYPE = 4,
	IRQ_GC_NO_MASK = 8,
	IRQ_GC_BE_IO = 16,
};

enum irqchip_irq_state {
	IRQCHIP_STATE_PENDING = 0,
	IRQCHIP_STATE_ACTIVE = 1,
	IRQCHIP_STATE_MASKED = 2,
	IRQCHIP_STATE_LINE_LEVEL = 3,
};

enum irqreturn {
	IRQ_NONE = 0,
	IRQ_HANDLED = 1,
	IRQ_WAKE_THREAD = 2,
};

typedef enum irqreturn irqreturn_t;

enum iscsi_boot_acpitbl_properties_enum {
	ISCSI_BOOT_ACPITBL_SIGNATURE = 0,
	ISCSI_BOOT_ACPITBL_OEM_ID = 1,
	ISCSI_BOOT_ACPITBL_OEM_TABLE_ID = 2,
};

enum iscsi_boot_eth_properties_enum {
	ISCSI_BOOT_ETH_INDEX = 0,
	ISCSI_BOOT_ETH_FLAGS = 1,
	ISCSI_BOOT_ETH_IP_ADDR = 2,
	ISCSI_BOOT_ETH_PREFIX_LEN = 3,
	ISCSI_BOOT_ETH_SUBNET_MASK = 4,
	ISCSI_BOOT_ETH_ORIGIN = 5,
	ISCSI_BOOT_ETH_GATEWAY = 6,
	ISCSI_BOOT_ETH_PRIMARY_DNS = 7,
	ISCSI_BOOT_ETH_SECONDARY_DNS = 8,
	ISCSI_BOOT_ETH_DHCP = 9,
	ISCSI_BOOT_ETH_VLAN = 10,
	ISCSI_BOOT_ETH_MAC = 11,
	ISCSI_BOOT_ETH_HOSTNAME = 12,
	ISCSI_BOOT_ETH_END_MARKER = 13,
};

enum iscsi_boot_initiator_properties_enum {
	ISCSI_BOOT_INI_INDEX = 0,
	ISCSI_BOOT_INI_FLAGS = 1,
	ISCSI_BOOT_INI_ISNS_SERVER = 2,
	ISCSI_BOOT_INI_SLP_SERVER = 3,
	ISCSI_BOOT_INI_PRI_RADIUS_SERVER = 4,
	ISCSI_BOOT_INI_SEC_RADIUS_SERVER = 5,
	ISCSI_BOOT_INI_INITIATOR_NAME = 6,
	ISCSI_BOOT_INI_END_MARKER = 7,
};

enum iscsi_boot_tgt_properties_enum {
	ISCSI_BOOT_TGT_INDEX = 0,
	ISCSI_BOOT_TGT_FLAGS = 1,
	ISCSI_BOOT_TGT_IP_ADDR = 2,
	ISCSI_BOOT_TGT_PORT = 3,
	ISCSI_BOOT_TGT_LUN = 4,
	ISCSI_BOOT_TGT_CHAP_TYPE = 5,
	ISCSI_BOOT_TGT_NIC_ASSOC = 6,
	ISCSI_BOOT_TGT_NAME = 7,
	ISCSI_BOOT_TGT_CHAP_NAME = 8,
	ISCSI_BOOT_TGT_CHAP_SECRET = 9,
	ISCSI_BOOT_TGT_REV_CHAP_NAME = 10,
	ISCSI_BOOT_TGT_REV_CHAP_SECRET = 11,
	ISCSI_BOOT_TGT_END_MARKER = 12,
};

enum iscsi_chap_param {
	ISCSI_CHAP_PARAM_INDEX = 0,
	ISCSI_CHAP_PARAM_CHAP_TYPE = 1,
	ISCSI_CHAP_PARAM_USERNAME = 2,
	ISCSI_CHAP_PARAM_PASSWORD = 3,
	ISCSI_CHAP_PARAM_PASSWORD_LEN = 4,
};

enum iscsi_conn_state {
	ISCSI_CONN_STATE_FREE = 0,
	ISCSI_CONN_STATE_XPT_WAIT = 1,
	ISCSI_CONN_STATE_IN_LOGIN = 2,
	ISCSI_CONN_STATE_LOGGED_IN = 3,
	ISCSI_CONN_STATE_IN_LOGOUT = 4,
	ISCSI_CONN_STATE_LOGOUT_REQUESTED = 5,
	ISCSI_CONN_STATE_CLEANUP_WAIT = 6,
};

enum iscsi_connection_state {
	ISCSI_CONN_UP = 0,
	ISCSI_CONN_DOWN = 1,
	ISCSI_CONN_FAILED = 2,
	ISCSI_CONN_BOUND = 3,
};

enum iscsi_discovery_parent_type {
	ISCSI_DISC_PARENT_UNKNOWN = 1,
	ISCSI_DISC_PARENT_SENDTGT = 2,
	ISCSI_DISC_PARENT_ISNS = 3,
};

enum iscsi_err {
	ISCSI_OK = 0,
	ISCSI_ERR_DATASN = 1001,
	ISCSI_ERR_DATA_OFFSET = 1002,
	ISCSI_ERR_MAX_CMDSN = 1003,
	ISCSI_ERR_EXP_CMDSN = 1004,
	ISCSI_ERR_BAD_OPCODE = 1005,
	ISCSI_ERR_DATALEN = 1006,
	ISCSI_ERR_AHSLEN = 1007,
	ISCSI_ERR_PROTO = 1008,
	ISCSI_ERR_LUN = 1009,
	ISCSI_ERR_BAD_ITT = 1010,
	ISCSI_ERR_CONN_FAILED = 1011,
	ISCSI_ERR_R2TSN = 1012,
	ISCSI_ERR_SESSION_FAILED = 1013,
	ISCSI_ERR_HDR_DGST = 1014,
	ISCSI_ERR_DATA_DGST = 1015,
	ISCSI_ERR_PARAM_NOT_FOUND = 1016,
	ISCSI_ERR_NO_SCSI_CMD = 1017,
	ISCSI_ERR_INVALID_HOST = 1018,
	ISCSI_ERR_XMIT_FAILED = 1019,
	ISCSI_ERR_TCP_CONN_CLOSE = 1020,
	ISCSI_ERR_SCSI_EH_SESSION_RST = 1021,
	ISCSI_ERR_NOP_TIMEDOUT = 1022,
};

enum iscsi_flashnode_param {
	ISCSI_FLASHNODE_IS_FW_ASSIGNED_IPV6 = 0,
	ISCSI_FLASHNODE_PORTAL_TYPE = 1,
	ISCSI_FLASHNODE_AUTO_SND_TGT_DISABLE = 2,
	ISCSI_FLASHNODE_DISCOVERY_SESS = 3,
	ISCSI_FLASHNODE_ENTRY_EN = 4,
	ISCSI_FLASHNODE_HDR_DGST_EN = 5,
	ISCSI_FLASHNODE_DATA_DGST_EN = 6,
	ISCSI_FLASHNODE_IMM_DATA_EN = 7,
	ISCSI_FLASHNODE_INITIAL_R2T_EN = 8,
	ISCSI_FLASHNODE_DATASEQ_INORDER = 9,
	ISCSI_FLASHNODE_PDU_INORDER = 10,
	ISCSI_FLASHNODE_CHAP_AUTH_EN = 11,
	ISCSI_FLASHNODE_SNACK_REQ_EN = 12,
	ISCSI_FLASHNODE_DISCOVERY_LOGOUT_EN = 13,
	ISCSI_FLASHNODE_BIDI_CHAP_EN = 14,
	ISCSI_FLASHNODE_DISCOVERY_AUTH_OPTIONAL = 15,
	ISCSI_FLASHNODE_ERL = 16,
	ISCSI_FLASHNODE_TCP_TIMESTAMP_STAT = 17,
	ISCSI_FLASHNODE_TCP_NAGLE_DISABLE = 18,
	ISCSI_FLASHNODE_TCP_WSF_DISABLE = 19,
	ISCSI_FLASHNODE_TCP_TIMER_SCALE = 20,
	ISCSI_FLASHNODE_TCP_TIMESTAMP_EN = 21,
	ISCSI_FLASHNODE_IP_FRAG_DISABLE = 22,
	ISCSI_FLASHNODE_MAX_RECV_DLENGTH = 23,
	ISCSI_FLASHNODE_MAX_XMIT_DLENGTH = 24,
	ISCSI_FLASHNODE_FIRST_BURST = 25,
	ISCSI_FLASHNODE_DEF_TIME2WAIT = 26,
	ISCSI_FLASHNODE_DEF_TIME2RETAIN = 27,
	ISCSI_FLASHNODE_MAX_R2T = 28,
	ISCSI_FLASHNODE_KEEPALIVE_TMO = 29,
	ISCSI_FLASHNODE_ISID = 30,
	ISCSI_FLASHNODE_TSID = 31,
	ISCSI_FLASHNODE_PORT = 32,
	ISCSI_FLASHNODE_MAX_BURST = 33,
	ISCSI_FLASHNODE_DEF_TASKMGMT_TMO = 34,
	ISCSI_FLASHNODE_IPADDR = 35,
	ISCSI_FLASHNODE_ALIAS = 36,
	ISCSI_FLASHNODE_REDIRECT_IPADDR = 37,
	ISCSI_FLASHNODE_MAX_SEGMENT_SIZE = 38,
	ISCSI_FLASHNODE_LOCAL_PORT = 39,
	ISCSI_FLASHNODE_IPV4_TOS = 40,
	ISCSI_FLASHNODE_IPV6_TC = 41,
	ISCSI_FLASHNODE_IPV6_FLOW_LABEL = 42,
	ISCSI_FLASHNODE_NAME = 43,
	ISCSI_FLASHNODE_TPGT = 44,
	ISCSI_FLASHNODE_LINK_LOCAL_IPV6 = 45,
	ISCSI_FLASHNODE_DISCOVERY_PARENT_IDX = 46,
	ISCSI_FLASHNODE_DISCOVERY_PARENT_TYPE = 47,
	ISCSI_FLASHNODE_TCP_XMIT_WSF = 48,
	ISCSI_FLASHNODE_TCP_RECV_WSF = 49,
	ISCSI_FLASHNODE_CHAP_IN_IDX = 50,
	ISCSI_FLASHNODE_CHAP_OUT_IDX = 51,
	ISCSI_FLASHNODE_USERNAME = 52,
	ISCSI_FLASHNODE_USERNAME_IN = 53,
	ISCSI_FLASHNODE_PASSWORD = 54,
	ISCSI_FLASHNODE_PASSWORD_IN = 55,
	ISCSI_FLASHNODE_STATSN = 56,
	ISCSI_FLASHNODE_EXP_STATSN = 57,
	ISCSI_FLASHNODE_IS_BOOT_TGT = 58,
	ISCSI_FLASHNODE_MAX = 59,
};

enum iscsi_host_event_code {
	ISCSI_EVENT_LINKUP = 1,
	ISCSI_EVENT_LINKDOWN = 2,
	ISCSI_EVENT_MAX = 3,
};

enum iscsi_host_param {
	ISCSI_HOST_PARAM_HWADDRESS = 0,
	ISCSI_HOST_PARAM_INITIATOR_NAME = 1,
	ISCSI_HOST_PARAM_NETDEV_NAME = 2,
	ISCSI_HOST_PARAM_IPADDRESS = 3,
	ISCSI_HOST_PARAM_PORT_STATE = 4,
	ISCSI_HOST_PARAM_PORT_SPEED = 5,
	ISCSI_HOST_PARAM_MAX = 6,
};

enum iscsi_iface_param {
	ISCSI_IFACE_PARAM_DEF_TASKMGMT_TMO = 0,
	ISCSI_IFACE_PARAM_HDRDGST_EN = 1,
	ISCSI_IFACE_PARAM_DATADGST_EN = 2,
	ISCSI_IFACE_PARAM_IMM_DATA_EN = 3,
	ISCSI_IFACE_PARAM_INITIAL_R2T_EN = 4,
	ISCSI_IFACE_PARAM_DATASEQ_INORDER_EN = 5,
	ISCSI_IFACE_PARAM_PDU_INORDER_EN = 6,
	ISCSI_IFACE_PARAM_ERL = 7,
	ISCSI_IFACE_PARAM_MAX_RECV_DLENGTH = 8,
	ISCSI_IFACE_PARAM_FIRST_BURST = 9,
	ISCSI_IFACE_PARAM_MAX_R2T = 10,
	ISCSI_IFACE_PARAM_MAX_BURST = 11,
	ISCSI_IFACE_PARAM_CHAP_AUTH_EN = 12,
	ISCSI_IFACE_PARAM_BIDI_CHAP_EN = 13,
	ISCSI_IFACE_PARAM_DISCOVERY_AUTH_OPTIONAL = 14,
	ISCSI_IFACE_PARAM_DISCOVERY_LOGOUT_EN = 15,
	ISCSI_IFACE_PARAM_STRICT_LOGIN_COMP_EN = 16,
	ISCSI_IFACE_PARAM_INITIATOR_NAME = 17,
};

enum iscsi_ipaddress_state {
	ISCSI_IPDDRESS_STATE_UNCONFIGURED = 0,
	ISCSI_IPDDRESS_STATE_ACQUIRING = 1,
	ISCSI_IPDDRESS_STATE_TENTATIVE = 2,
	ISCSI_IPDDRESS_STATE_VALID = 3,
	ISCSI_IPDDRESS_STATE_DISABLING = 4,
	ISCSI_IPDDRESS_STATE_INVALID = 5,
	ISCSI_IPDDRESS_STATE_DEPRECATED = 6,
};

enum iscsi_net_param {
	ISCSI_NET_PARAM_IPV4_ADDR = 1,
	ISCSI_NET_PARAM_IPV4_SUBNET = 2,
	ISCSI_NET_PARAM_IPV4_GW = 3,
	ISCSI_NET_PARAM_IPV4_BOOTPROTO = 4,
	ISCSI_NET_PARAM_MAC = 5,
	ISCSI_NET_PARAM_IPV6_LINKLOCAL = 6,
	ISCSI_NET_PARAM_IPV6_ADDR = 7,
	ISCSI_NET_PARAM_IPV6_ROUTER = 8,
	ISCSI_NET_PARAM_IPV6_ADDR_AUTOCFG = 9,
	ISCSI_NET_PARAM_IPV6_LINKLOCAL_AUTOCFG = 10,
	ISCSI_NET_PARAM_IPV6_ROUTER_AUTOCFG = 11,
	ISCSI_NET_PARAM_IFACE_ENABLE = 12,
	ISCSI_NET_PARAM_VLAN_ID = 13,
	ISCSI_NET_PARAM_VLAN_PRIORITY = 14,
	ISCSI_NET_PARAM_VLAN_ENABLED = 15,
	ISCSI_NET_PARAM_VLAN_TAG = 16,
	ISCSI_NET_PARAM_IFACE_TYPE = 17,
	ISCSI_NET_PARAM_IFACE_NAME = 18,
	ISCSI_NET_PARAM_MTU = 19,
	ISCSI_NET_PARAM_PORT = 20,
	ISCSI_NET_PARAM_IPADDR_STATE = 21,
	ISCSI_NET_PARAM_IPV6_LINKLOCAL_STATE = 22,
	ISCSI_NET_PARAM_IPV6_ROUTER_STATE = 23,
	ISCSI_NET_PARAM_DELAYED_ACK_EN = 24,
	ISCSI_NET_PARAM_TCP_NAGLE_DISABLE = 25,
	ISCSI_NET_PARAM_TCP_WSF_DISABLE = 26,
	ISCSI_NET_PARAM_TCP_WSF = 27,
	ISCSI_NET_PARAM_TCP_TIMER_SCALE = 28,
	ISCSI_NET_PARAM_TCP_TIMESTAMP_EN = 29,
	ISCSI_NET_PARAM_CACHE_ID = 30,
	ISCSI_NET_PARAM_IPV4_DHCP_DNS_ADDR_EN = 31,
	ISCSI_NET_PARAM_IPV4_DHCP_SLP_DA_EN = 32,
	ISCSI_NET_PARAM_IPV4_TOS_EN = 33,
	ISCSI_NET_PARAM_IPV4_TOS = 34,
	ISCSI_NET_PARAM_IPV4_GRAT_ARP_EN = 35,
	ISCSI_NET_PARAM_IPV4_DHCP_ALT_CLIENT_ID_EN = 36,
	ISCSI_NET_PARAM_IPV4_DHCP_ALT_CLIENT_ID = 37,
	ISCSI_NET_PARAM_IPV4_DHCP_REQ_VENDOR_ID_EN = 38,
	ISCSI_NET_PARAM_IPV4_DHCP_USE_VENDOR_ID_EN = 39,
	ISCSI_NET_PARAM_IPV4_DHCP_VENDOR_ID = 40,
	ISCSI_NET_PARAM_IPV4_DHCP_LEARN_IQN_EN = 41,
	ISCSI_NET_PARAM_IPV4_FRAGMENT_DISABLE = 42,
	ISCSI_NET_PARAM_IPV4_IN_FORWARD_EN = 43,
	ISCSI_NET_PARAM_IPV4_TTL = 44,
	ISCSI_NET_PARAM_IPV6_GRAT_NEIGHBOR_ADV_EN = 45,
	ISCSI_NET_PARAM_IPV6_MLD_EN = 46,
	ISCSI_NET_PARAM_IPV6_FLOW_LABEL = 47,
	ISCSI_NET_PARAM_IPV6_TRAFFIC_CLASS = 48,
	ISCSI_NET_PARAM_IPV6_HOP_LIMIT = 49,
	ISCSI_NET_PARAM_IPV6_ND_REACHABLE_TMO = 50,
	ISCSI_NET_PARAM_IPV6_ND_REXMIT_TIME = 51,
	ISCSI_NET_PARAM_IPV6_ND_STALE_TMO = 52,
	ISCSI_NET_PARAM_IPV6_DUP_ADDR_DETECT_CNT = 53,
	ISCSI_NET_PARAM_IPV6_RTR_ADV_LINK_MTU = 54,
	ISCSI_NET_PARAM_REDIRECT_EN = 55,
};

enum iscsi_param {
	ISCSI_PARAM_MAX_RECV_DLENGTH = 0,
	ISCSI_PARAM_MAX_XMIT_DLENGTH = 1,
	ISCSI_PARAM_HDRDGST_EN = 2,
	ISCSI_PARAM_DATADGST_EN = 3,
	ISCSI_PARAM_INITIAL_R2T_EN = 4,
	ISCSI_PARAM_MAX_R2T = 5,
	ISCSI_PARAM_IMM_DATA_EN = 6,
	ISCSI_PARAM_FIRST_BURST = 7,
	ISCSI_PARAM_MAX_BURST = 8,
	ISCSI_PARAM_PDU_INORDER_EN = 9,
	ISCSI_PARAM_DATASEQ_INORDER_EN = 10,
	ISCSI_PARAM_ERL = 11,
	ISCSI_PARAM_IFMARKER_EN = 12,
	ISCSI_PARAM_OFMARKER_EN = 13,
	ISCSI_PARAM_EXP_STATSN = 14,
	ISCSI_PARAM_TARGET_NAME = 15,
	ISCSI_PARAM_TPGT = 16,
	ISCSI_PARAM_PERSISTENT_ADDRESS = 17,
	ISCSI_PARAM_PERSISTENT_PORT = 18,
	ISCSI_PARAM_SESS_RECOVERY_TMO = 19,
	ISCSI_PARAM_CONN_PORT = 20,
	ISCSI_PARAM_CONN_ADDRESS = 21,
	ISCSI_PARAM_USERNAME = 22,
	ISCSI_PARAM_USERNAME_IN = 23,
	ISCSI_PARAM_PASSWORD = 24,
	ISCSI_PARAM_PASSWORD_IN = 25,
	ISCSI_PARAM_FAST_ABORT = 26,
	ISCSI_PARAM_ABORT_TMO = 27,
	ISCSI_PARAM_LU_RESET_TMO = 28,
	ISCSI_PARAM_HOST_RESET_TMO = 29,
	ISCSI_PARAM_PING_TMO = 30,
	ISCSI_PARAM_RECV_TMO = 31,
	ISCSI_PARAM_IFACE_NAME = 32,
	ISCSI_PARAM_ISID = 33,
	ISCSI_PARAM_INITIATOR_NAME = 34,
	ISCSI_PARAM_TGT_RESET_TMO = 35,
	ISCSI_PARAM_TARGET_ALIAS = 36,
	ISCSI_PARAM_CHAP_IN_IDX = 37,
	ISCSI_PARAM_CHAP_OUT_IDX = 38,
	ISCSI_PARAM_BOOT_ROOT = 39,
	ISCSI_PARAM_BOOT_NIC = 40,
	ISCSI_PARAM_BOOT_TARGET = 41,
	ISCSI_PARAM_AUTO_SND_TGT_DISABLE = 42,
	ISCSI_PARAM_DISCOVERY_SESS = 43,
	ISCSI_PARAM_PORTAL_TYPE = 44,
	ISCSI_PARAM_CHAP_AUTH_EN = 45,
	ISCSI_PARAM_DISCOVERY_LOGOUT_EN = 46,
	ISCSI_PARAM_BIDI_CHAP_EN = 47,
	ISCSI_PARAM_DISCOVERY_AUTH_OPTIONAL = 48,
	ISCSI_PARAM_DEF_TIME2WAIT = 49,
	ISCSI_PARAM_DEF_TIME2RETAIN = 50,
	ISCSI_PARAM_MAX_SEGMENT_SIZE = 51,
	ISCSI_PARAM_STATSN = 52,
	ISCSI_PARAM_KEEPALIVE_TMO = 53,
	ISCSI_PARAM_LOCAL_PORT = 54,
	ISCSI_PARAM_TSID = 55,
	ISCSI_PARAM_DEF_TASKMGMT_TMO = 56,
	ISCSI_PARAM_TCP_TIMESTAMP_STAT = 57,
	ISCSI_PARAM_TCP_WSF_DISABLE = 58,
	ISCSI_PARAM_TCP_NAGLE_DISABLE = 59,
	ISCSI_PARAM_TCP_TIMER_SCALE = 60,
	ISCSI_PARAM_TCP_TIMESTAMP_EN = 61,
	ISCSI_PARAM_TCP_XMIT_WSF = 62,
	ISCSI_PARAM_TCP_RECV_WSF = 63,
	ISCSI_PARAM_IP_FRAGMENT_DISABLE = 64,
	ISCSI_PARAM_IPV4_TOS = 65,
	ISCSI_PARAM_IPV6_TC = 66,
	ISCSI_PARAM_IPV6_FLOW_LABEL = 67,
	ISCSI_PARAM_IS_FW_ASSIGNED_IPV6 = 68,
	ISCSI_PARAM_DISCOVERY_PARENT_IDX = 69,
	ISCSI_PARAM_DISCOVERY_PARENT_TYPE = 70,
	ISCSI_PARAM_LOCAL_IPADDR = 71,
	ISCSI_PARAM_MAX = 72,
};

enum iscsi_param_type {
	ISCSI_PARAM = 0,
	ISCSI_HOST_PARAM = 1,
	ISCSI_NET_PARAM = 2,
	ISCSI_FLASHNODE_PARAM = 3,
	ISCSI_CHAP_PARAM = 4,
	ISCSI_IFACE_PARAM = 5,
};

enum iscsi_ping_status_code {
	ISCSI_PING_SUCCESS = 0,
	ISCSI_PING_FW_DISABLED = 1,
	ISCSI_PING_IPADDR_INVALID = 2,
	ISCSI_PING_LINKLOCAL_IPV6_ADDR_INVALID = 3,
	ISCSI_PING_TIMEOUT = 4,
	ISCSI_PING_INVALID_DEST_ADDR = 5,
	ISCSI_PING_OVERSIZE_PACKET = 6,
	ISCSI_PING_ICMP_ERROR = 7,
	ISCSI_PING_MAX_REQ_EXCEEDED = 8,
	ISCSI_PING_NO_ARP_RECEIVED = 9,
};

enum iscsi_port_speed {
	ISCSI_PORT_SPEED_UNKNOWN = 1,
	ISCSI_PORT_SPEED_10MBPS = 2,
	ISCSI_PORT_SPEED_100MBPS = 4,
	ISCSI_PORT_SPEED_1GBPS = 8,
	ISCSI_PORT_SPEED_10GBPS = 16,
	ISCSI_PORT_SPEED_25GBPS = 32,
	ISCSI_PORT_SPEED_40GBPS = 64,
};

enum iscsi_port_state {
	ISCSI_PORT_STATE_DOWN = 1,
	ISCSI_PORT_STATE_UP = 2,
};

enum iscsi_router_state {
	ISCSI_ROUTER_STATE_UNKNOWN = 0,
	ISCSI_ROUTER_STATE_ADVERTISED = 1,
	ISCSI_ROUTER_STATE_MANUAL = 2,
	ISCSI_ROUTER_STATE_STALE = 3,
};

enum iscsi_tgt_dscvr {
	ISCSI_TGT_DSCVR_SEND_TARGETS = 1,
	ISCSI_TGT_DSCVR_ISNS = 2,
	ISCSI_TGT_DSCVR_SLP = 3,
};

enum iscsi_uevent_e {
	ISCSI_UEVENT_UNKNOWN = 0,
	ISCSI_UEVENT_CREATE_SESSION = 11,
	ISCSI_UEVENT_DESTROY_SESSION = 12,
	ISCSI_UEVENT_CREATE_CONN = 13,
	ISCSI_UEVENT_DESTROY_CONN = 14,
	ISCSI_UEVENT_BIND_CONN = 15,
	ISCSI_UEVENT_SET_PARAM = 16,
	ISCSI_UEVENT_START_CONN = 17,
	ISCSI_UEVENT_STOP_CONN = 18,
	ISCSI_UEVENT_SEND_PDU = 19,
	ISCSI_UEVENT_GET_STATS = 20,
	ISCSI_UEVENT_GET_PARAM = 21,
	ISCSI_UEVENT_TRANSPORT_EP_CONNECT = 22,
	ISCSI_UEVENT_TRANSPORT_EP_POLL = 23,
	ISCSI_UEVENT_TRANSPORT_EP_DISCONNECT = 24,
	ISCSI_UEVENT_TGT_DSCVR = 25,
	ISCSI_UEVENT_SET_HOST_PARAM = 26,
	ISCSI_UEVENT_UNBIND_SESSION = 27,
	ISCSI_UEVENT_CREATE_BOUND_SESSION = 28,
	ISCSI_UEVENT_TRANSPORT_EP_CONNECT_THROUGH_HOST = 29,
	ISCSI_UEVENT_PATH_UPDATE = 30,
	ISCSI_UEVENT_SET_IFACE_PARAMS = 31,
	ISCSI_UEVENT_PING = 32,
	ISCSI_UEVENT_GET_CHAP = 33,
	ISCSI_UEVENT_DELETE_CHAP = 34,
	ISCSI_UEVENT_SET_FLASHNODE_PARAMS = 35,
	ISCSI_UEVENT_NEW_FLASHNODE = 36,
	ISCSI_UEVENT_DEL_FLASHNODE = 37,
	ISCSI_UEVENT_LOGIN_FLASHNODE = 38,
	ISCSI_UEVENT_LOGOUT_FLASHNODE = 39,
	ISCSI_UEVENT_LOGOUT_FLASHNODE_SID = 40,
	ISCSI_UEVENT_SET_CHAP = 41,
	ISCSI_UEVENT_GET_HOST_STATS = 42,
	ISCSI_UEVENT_DESTROY_SESSION_ASYNC = 43,
	ISCSI_KEVENT_RECV_PDU = 101,
	ISCSI_KEVENT_CONN_ERROR = 102,
	ISCSI_KEVENT_IF_ERROR = 103,
	ISCSI_KEVENT_DESTROY_SESSION = 104,
	ISCSI_KEVENT_UNBIND_SESSION = 105,
	ISCSI_KEVENT_CREATE_SESSION = 106,
	ISCSI_KEVENT_PATH_REQ = 107,
	ISCSI_KEVENT_IF_DOWN = 108,
	ISCSI_KEVENT_CONN_LOGIN_STATE = 109,
	ISCSI_KEVENT_HOST_EVENT = 110,
	ISCSI_KEVENT_PING_COMP = 111,
};

enum iter_type {
	ITER_UBUF = 0,
	ITER_IOVEC = 1,
	ITER_BVEC = 2,
	ITER_KVEC = 3,
	ITER_XARRAY = 4,
	ITER_DISCARD = 5,
};

enum jbd2_shrink_type {
	JBD2_SHRINK_DESTROY = 0,
	JBD2_SHRINK_BUSY_STOP = 1,
	JBD2_SHRINK_BUSY_SKIP = 2,
};

enum jbd_state_bits {
	BH_JBD = 16,
	BH_JWrite = 17,
	BH_Freed = 18,
	BH_Revoked = 19,
	BH_RevokeValid = 20,
	BH_JBDDirty = 21,
	BH_JournalHead = 22,
	BH_Shadow = 23,
	BH_Verified = 24,
	BH_JBDPrivateStart = 25,
};

enum jump_label_type {
	JUMP_LABEL_NOP = 0,
	JUMP_LABEL_JMP = 1,
};

enum kcmp_type {
	KCMP_FILE = 0,
	KCMP_VM = 1,
	KCMP_FILES = 2,
	KCMP_FS = 3,
	KCMP_SIGHAND = 4,
	KCMP_IO = 5,
	KCMP_SYSVSEM = 6,
	KCMP_EPOLL_TFD = 7,
	KCMP_TYPES = 8,
};

enum kcore_type {
	KCORE_TEXT = 0,
	KCORE_VMALLOC = 1,
	KCORE_RAM = 2,
	KCORE_VMEMMAP = 3,
	KCORE_USER = 4,
};

enum kernel_load_data_id {
	LOADING_UNKNOWN = 0,
	LOADING_FIRMWARE = 1,
	LOADING_MODULE = 2,
	LOADING_KEXEC_IMAGE = 3,
	LOADING_KEXEC_INITRAMFS = 4,
	LOADING_POLICY = 5,
	LOADING_X509_CERTIFICATE = 6,
	LOADING_MAX_ID = 7,
};

enum kernel_pkey_operation {
	kernel_pkey_encrypt = 0,
	kernel_pkey_decrypt = 1,
	kernel_pkey_sign = 2,
	kernel_pkey_verify = 3,
};

enum kernel_read_file_id {
	READING_UNKNOWN = 0,
	READING_FIRMWARE = 1,
	READING_MODULE = 2,
	READING_KEXEC_IMAGE = 3,
	READING_KEXEC_INITRAMFS = 4,
	READING_POLICY = 5,
	READING_X509_CERTIFICATE = 6,
	READING_MAX_ID = 7,
};

enum kernfs_node_flag {
	KERNFS_ACTIVATED = 16,
	KERNFS_NS = 32,
	KERNFS_HAS_SEQ_SHOW = 64,
	KERNFS_HAS_MMAP = 128,
	KERNFS_LOCKDEP = 256,
	KERNFS_HIDDEN = 512,
	KERNFS_SUICIDAL = 1024,
	KERNFS_SUICIDED = 2048,
	KERNFS_EMPTY_DIR = 4096,
	KERNFS_HAS_RELEASE = 8192,
	KERNFS_REMOVING = 16384,
};

enum kernfs_node_type {
	KERNFS_DIR = 1,
	KERNFS_FILE = 2,
	KERNFS_LINK = 4,
};

enum kernfs_root_flag {
	KERNFS_ROOT_CREATE_DEACTIVATED = 1,
	KERNFS_ROOT_EXTRA_OPEN_PERM_CHECK = 2,
	KERNFS_ROOT_SUPPORT_EXPORTOP = 4,
	KERNFS_ROOT_SUPPORT_USER_XATTR = 8,
};

enum key_being_used_for {
	VERIFYING_MODULE_SIGNATURE = 0,
	VERIFYING_FIRMWARE_SIGNATURE = 1,
	VERIFYING_KEXEC_PE_SIGNATURE = 2,
	VERIFYING_KEY_SIGNATURE = 3,
	VERIFYING_KEY_SELF_SIGNATURE = 4,
	VERIFYING_UNSPECIFIED_SIGNATURE = 5,
	NR__KEY_BEING_USED_FOR = 6,
};

enum key_lookup_flag {
	KEY_LOOKUP_CREATE = 1,
	KEY_LOOKUP_PARTIAL = 2,
	KEY_LOOKUP_ALL = 3,
};

enum key_need_perm {
	KEY_NEED_UNSPECIFIED = 0,
	KEY_NEED_VIEW = 1,
	KEY_NEED_READ = 2,
	KEY_NEED_WRITE = 3,
	KEY_NEED_SEARCH = 4,
	KEY_NEED_LINK = 5,
	KEY_NEED_SETATTR = 6,
	KEY_NEED_UNLINK = 7,
	KEY_SYSADMIN_OVERRIDE = 8,
	KEY_AUTHTOKEN_OVERRIDE = 9,
	KEY_DEFER_PERM_CHECK = 10,
};

enum key_notification_subtype {
	NOTIFY_KEY_INSTANTIATED = 0,
	NOTIFY_KEY_UPDATED = 1,
	NOTIFY_KEY_LINKED = 2,
	NOTIFY_KEY_UNLINKED = 3,
	NOTIFY_KEY_CLEARED = 4,
	NOTIFY_KEY_REVOKED = 5,
	NOTIFY_KEY_INVALIDATED = 6,
	NOTIFY_KEY_SETATTR = 7,
};

enum key_state {
	KEY_IS_UNINSTANTIATED = 0,
	KEY_IS_POSITIVE = 1,
};

enum kfunc_ptr_arg_type {
	KF_ARG_PTR_TO_CTX = 0,
	KF_ARG_PTR_TO_ALLOC_BTF_ID = 1,
	KF_ARG_PTR_TO_REFCOUNTED_KPTR = 2,
	KF_ARG_PTR_TO_DYNPTR = 3,
	KF_ARG_PTR_TO_ITER = 4,
	KF_ARG_PTR_TO_LIST_HEAD = 5,
	KF_ARG_PTR_TO_LIST_NODE = 6,
	KF_ARG_PTR_TO_BTF_ID = 7,
	KF_ARG_PTR_TO_MEM = 8,
	KF_ARG_PTR_TO_MEM_SIZE = 9,
	KF_ARG_PTR_TO_CALLBACK = 10,
	KF_ARG_PTR_TO_RB_ROOT = 11,
	KF_ARG_PTR_TO_RB_NODE = 12,
	KF_ARG_PTR_TO_NULL = 13,
	KF_ARG_PTR_TO_CONST_STR = 14,
	KF_ARG_PTR_TO_MAP = 15,
	KF_ARG_PTR_TO_WORKQUEUE = 16,
};

enum kmalloc_cache_type {
	KMALLOC_NORMAL = 0,
	KMALLOC_DMA = 0,
	KMALLOC_RANDOM_START = 0,
	KMALLOC_RANDOM_END = 0,
	KMALLOC_RECLAIM = 1,
	KMALLOC_CGROUP = 2,
	NR_KMALLOC_TYPES = 3,
};

enum kmsg_dump_reason {
	KMSG_DUMP_UNDEF = 0,
	KMSG_DUMP_PANIC = 1,
	KMSG_DUMP_OOPS = 2,
	KMSG_DUMP_EMERG = 3,
	KMSG_DUMP_SHUTDOWN = 4,
	KMSG_DUMP_MAX = 5,
};

enum kobj_ns_type {
	KOBJ_NS_TYPE_NONE = 0,
	KOBJ_NS_TYPE_NET = 1,
	KOBJ_NS_TYPES = 2,
};

enum kobject_action {
	KOBJ_ADD = 0,
	KOBJ_REMOVE = 1,
	KOBJ_CHANGE = 2,
	KOBJ_MOVE = 3,
	KOBJ_ONLINE = 4,
	KOBJ_OFFLINE = 5,
	KOBJ_BIND = 6,
	KOBJ_UNBIND = 7,
};

enum kprobe_slot_state {
	SLOT_CLEAN = 0,
	SLOT_DIRTY = 1,
	SLOT_USED = 2,
};

enum ksm_advisor_type {
	KSM_ADVISOR_NONE = 0,
	KSM_ADVISOR_SCAN_TIME = 1,
};

enum ksm_get_folio_flags {
	KSM_GET_FOLIO_NOLOCK = 0,
	KSM_GET_FOLIO_LOCK = 1,
	KSM_GET_FOLIO_TRYLOCK = 2,
};

enum kvm_bus {
	KVM_MMIO_BUS = 0,
	KVM_PIO_BUS = 1,
	KVM_VIRTIO_CCW_NOTIFY_BUS = 2,
	KVM_FAST_MMIO_BUS = 3,
	KVM_NR_BUSES = 4,
};

enum kvm_mr_change {
	KVM_MR_CREATE = 0,
	KVM_MR_DELETE = 1,
	KVM_MR_MOVE = 2,
	KVM_MR_FLAGS_ONLY = 3,
};

enum kvm_stat_kind {
	KVM_STAT_VM = 0,
	KVM_STAT_VCPU = 1,
};

enum l1d_flush_type {
	L1D_FLUSH_NONE = 1,
	L1D_FLUSH_FALLBACK = 2,
	L1D_FLUSH_ORI = 4,
	L1D_FLUSH_MTTRIG = 8,
};

enum l2tp_debug_flags {
	L2TP_MSG_DEBUG = 1,
	L2TP_MSG_CONTROL = 2,
	L2TP_MSG_SEQ = 4,
	L2TP_MSG_DATA = 8,
};

enum l3mdev_type {
	L3MDEV_TYPE_UNSPEC = 0,
	L3MDEV_TYPE_VRF = 1,
	__L3MDEV_TYPE_MAX = 2,
};

enum label_flags {
	FLAG_HAT = 1,
	FLAG_UNCONFINED = 2,
	FLAG_NULL = 4,
	FLAG_IX_ON_NAME_ERROR = 8,
	FLAG_IMMUTIBLE = 16,
	FLAG_USER_DEFINED = 32,
	FLAG_NO_LIST_REF = 64,
	FLAG_NS_COUNT = 128,
	FLAG_IN_TREE = 256,
	FLAG_PROFILE = 512,
	FLAG_EXPLICIT = 1024,
	FLAG_STALE = 2048,
	FLAG_RENAMED = 4096,
	FLAG_REVOKED = 8192,
	FLAG_DEBUG1 = 16384,
	FLAG_DEBUG2 = 32768,
};

enum landlock_rule_type;

enum led_brightness {
	LED_OFF = 0,
	LED_ON = 1,
	LED_HALF = 127,
	LED_FULL = 255,
};

enum led_default_state {
	LEDS_DEFSTATE_OFF = 0,
	LEDS_DEFSTATE_ON = 1,
	LEDS_DEFSTATE_KEEP = 2,
};

enum legacy_fs_param {
	LEGACY_FS_UNSET_PARAMS = 0,
	LEGACY_FS_MONOLITHIC_PARAMS = 1,
	LEGACY_FS_INDIVIDUAL_PARAMS = 2,
};

enum link_status {
	UFSHCD_LINK_IS_DOWN = 1,
	UFSHCD_LINK_IS_UP = 2,
};

enum linux_mptcp_mib_field {
	MPTCP_MIB_NUM = 0,
	MPTCP_MIB_MPCAPABLEPASSIVE = 1,
	MPTCP_MIB_MPCAPABLEACTIVE = 2,
	MPTCP_MIB_MPCAPABLEACTIVEACK = 3,
	MPTCP_MIB_MPCAPABLEPASSIVEACK = 4,
	MPTCP_MIB_MPCAPABLEPASSIVEFALLBACK = 5,
	MPTCP_MIB_MPCAPABLEACTIVEFALLBACK = 6,
	MPTCP_MIB_TOKENFALLBACKINIT = 7,
	MPTCP_MIB_RETRANSSEGS = 8,
	MPTCP_MIB_JOINNOTOKEN = 9,
	MPTCP_MIB_JOINSYNRX = 10,
	MPTCP_MIB_JOINSYNBACKUPRX = 11,
	MPTCP_MIB_JOINSYNACKRX = 12,
	MPTCP_MIB_JOINSYNACKBACKUPRX = 13,
	MPTCP_MIB_JOINSYNACKMAC = 14,
	MPTCP_MIB_JOINACKRX = 15,
	MPTCP_MIB_JOINACKMAC = 16,
	MPTCP_MIB_DSSNOMATCH = 17,
	MPTCP_MIB_INFINITEMAPTX = 18,
	MPTCP_MIB_INFINITEMAPRX = 19,
	MPTCP_MIB_DSSTCPMISMATCH = 20,
	MPTCP_MIB_DATACSUMERR = 21,
	MPTCP_MIB_OFOQUEUETAIL = 22,
	MPTCP_MIB_OFOQUEUE = 23,
	MPTCP_MIB_OFOMERGE = 24,
	MPTCP_MIB_NODSSWINDOW = 25,
	MPTCP_MIB_DUPDATA = 26,
	MPTCP_MIB_ADDADDR = 27,
	MPTCP_MIB_ADDADDRTX = 28,
	MPTCP_MIB_ADDADDRTXDROP = 29,
	MPTCP_MIB_ECHOADD = 30,
	MPTCP_MIB_ECHOADDTX = 31,
	MPTCP_MIB_ECHOADDTXDROP = 32,
	MPTCP_MIB_PORTADD = 33,
	MPTCP_MIB_ADDADDRDROP = 34,
	MPTCP_MIB_JOINPORTSYNRX = 35,
	MPTCP_MIB_JOINPORTSYNACKRX = 36,
	MPTCP_MIB_JOINPORTACKRX = 37,
	MPTCP_MIB_MISMATCHPORTSYNRX = 38,
	MPTCP_MIB_MISMATCHPORTACKRX = 39,
	MPTCP_MIB_RMADDR = 40,
	MPTCP_MIB_RMADDRDROP = 41,
	MPTCP_MIB_RMADDRTX = 42,
	MPTCP_MIB_RMADDRTXDROP = 43,
	MPTCP_MIB_RMSUBFLOW = 44,
	MPTCP_MIB_MPPRIOTX = 45,
	MPTCP_MIB_MPPRIORX = 46,
	MPTCP_MIB_MPFAILTX = 47,
	MPTCP_MIB_MPFAILRX = 48,
	MPTCP_MIB_MPFASTCLOSETX = 49,
	MPTCP_MIB_MPFASTCLOSERX = 50,
	MPTCP_MIB_MPRSTTX = 51,
	MPTCP_MIB_MPRSTRX = 52,
	MPTCP_MIB_RCVPRUNED = 53,
	MPTCP_MIB_SUBFLOWSTALE = 54,
	MPTCP_MIB_SUBFLOWRECOVER = 55,
	MPTCP_MIB_SNDWNDSHARED = 56,
	MPTCP_MIB_RCVWNDSHARED = 57,
	MPTCP_MIB_RCVWNDCONFLICTUPDATE = 58,
	MPTCP_MIB_RCVWNDCONFLICT = 59,
	MPTCP_MIB_CURRESTAB = 60,
	__MPTCP_MIB_MAX = 61,
};

enum lochnagar_type {
	LOCHNAGAR1 = 0,
	LOCHNAGAR2 = 1,
};

enum lockdep_ok {
	LOCKDEP_STILL_OK = 0,
	LOCKDEP_NOW_UNRELIABLE = 1,
};

enum lockdown_reason {
	LOCKDOWN_NONE = 0,
	LOCKDOWN_MODULE_SIGNATURE = 1,
	LOCKDOWN_DEV_MEM = 2,
	LOCKDOWN_EFI_TEST = 3,
	LOCKDOWN_KEXEC = 4,
	LOCKDOWN_HIBERNATION = 5,
	LOCKDOWN_PCI_ACCESS = 6,
	LOCKDOWN_IOPORT = 7,
	LOCKDOWN_MSR = 8,
	LOCKDOWN_ACPI_TABLES = 9,
	LOCKDOWN_DEVICE_TREE = 10,
	LOCKDOWN_PCMCIA_CIS = 11,
	LOCKDOWN_TIOCSSERIAL = 12,
	LOCKDOWN_MODULE_PARAMETERS = 13,
	LOCKDOWN_MMIOTRACE = 14,
	LOCKDOWN_DEBUGFS = 15,
	LOCKDOWN_XMON_WR = 16,
	LOCKDOWN_BPF_WRITE_USER = 17,
	LOCKDOWN_DBG_WRITE_KERNEL = 18,
	LOCKDOWN_RTAS_ERROR_INJECTION = 19,
	LOCKDOWN_INTEGRITY_MAX = 20,
	LOCKDOWN_KCORE = 21,
	LOCKDOWN_KPROBES = 22,
	LOCKDOWN_BPF_READ_KERNEL = 23,
	LOCKDOWN_DBG_READ_KERNEL = 24,
	LOCKDOWN_PERF = 25,
	LOCKDOWN_TRACEFS = 26,
	LOCKDOWN_XMON_RW = 27,
	LOCKDOWN_XFRM_SECRET = 28,
	LOCKDOWN_CONFIDENTIALITY_MAX = 29,
};

enum login_state {
	DSC_LS_LLIOCB_SENT = 2,
	DSC_LS_PLOGI_PEND = 3,
	DSC_LS_PLOGI_COMP = 4,
	DSC_LS_PRLI_PEND = 5,
	DSC_LS_PRLI_COMP = 6,
	DSC_LS_PORT_UNAVAIL = 7,
	DSC_LS_PRLO_PEND = 9,
	DSC_LS_LOGO_PEND = 10,
};

enum lp8788_alarm_sel {
	LP8788_ALARM_1 = 0,
	LP8788_ALARM_2 = 1,
	LP8788_ALARM_MAX = 2,
};

enum lp8788_charger_event {
	NO_CHARGER = 0,
	CHARGER_DETECTED = 1,
};

enum lp8788_dvs_sel {
	DVS_SEL_V0 = 0,
	DVS_SEL_V1 = 1,
	DVS_SEL_V2 = 2,
	DVS_SEL_V3 = 3,
};

enum lp8788_int_id {
	LP8788_INT_TSDL = 0,
	LP8788_INT_TSDH = 1,
	LP8788_INT_UVLO = 2,
	LP8788_INT_FLAGMON = 3,
	LP8788_INT_PWRON_TIME = 4,
	LP8788_INT_PWRON = 5,
	LP8788_INT_COMP1 = 6,
	LP8788_INT_COMP2 = 7,
	LP8788_INT_CHG_INPUT_STATE = 8,
	LP8788_INT_CHG_STATE = 9,
	LP8788_INT_EOC = 10,
	LP8788_INT_CHG_RESTART = 11,
	LP8788_INT_RESTART_TIMEOUT = 12,
	LP8788_INT_FULLCHG_TIMEOUT = 13,
	LP8788_INT_PRECHG_TIMEOUT = 14,
	LP8788_INT_RTC_ALARM1 = 17,
	LP8788_INT_RTC_ALARM2 = 18,
	LP8788_INT_ENTER_SYS_SUPPORT = 19,
	LP8788_INT_EXIT_SYS_SUPPORT = 20,
	LP8788_INT_BATT_LOW = 21,
	LP8788_INT_NO_BATT = 22,
	LP8788_INT_MAX = 24,
};

enum lp8788_isink_number {
	LP8788_ISINK_1 = 0,
	LP8788_ISINK_2 = 1,
	LP8788_ISINK_3 = 2,
};

enum lp8788_isink_scale {
	LP8788_ISINK_SCALE_100mA = 0,
	LP8788_ISINK_SCALE_120mA = 1,
};

enum lpfc_fc4_xpt_flags {
	NLP_XPT_REGD = 1,
	SCSI_XPT_REGD = 2,
	NVME_XPT_REGD = 4,
	NVME_XPT_UNREG_WAIT = 8,
	NLP_XPT_HAS_HH = 16,
};

enum lpfc_fc_flag {
	FC_PT2PT = 0,
	FC_PT2PT_PLOGI = 1,
	FC_DISC_TMO = 2,
	FC_PUBLIC_LOOP = 3,
	FC_LBIT = 4,
	FC_RSCN_MODE = 5,
	FC_NLP_MORE = 6,
	FC_OFFLINE_MODE = 7,
	FC_FABRIC = 8,
	FC_VPORT_LOGO_RCVD = 9,
	FC_RSCN_DISCOVERY = 10,
	FC_LOGO_RCVD_DID_CHNG = 11,
	FC_PT2PT_NO_NVME = 12,
	FC_SCSI_SCAN_TMO = 13,
	FC_ABORT_DISCOVERY = 14,
	FC_NDISC_ACTIVE = 15,
	FC_BYPASSED_MODE = 16,
	FC_VPORT_NEEDS_REG_VPI = 17,
	FC_RSCN_DEFERRED = 18,
	FC_VPORT_NEEDS_INIT_VPI = 19,
	FC_VPORT_CVL_RCVD = 20,
	FC_VFI_REGISTERED = 21,
	FC_FDISC_COMPLETED = 22,
	FC_DISC_DELAYED = 23,
};

enum lpfc_hba_bit_flags {
	FABRIC_COMANDS_BLOCKED = 0,
	HBA_PCI_ERR = 1,
	MBX_TMO_ERR = 2,
};

enum lpfc_hba_flag {
	HBA_ERATT_HANDLED = 0,
	DEFER_ERATT = 1,
	HBA_FCOE_MODE = 2,
	HBA_SP_QUEUE_EVT = 3,
	HBA_POST_RECEIVE_BUFFER = 4,
	HBA_PERSISTENT_TOPO = 5,
	ELS_XRI_ABORT_EVENT = 6,
	ASYNC_EVENT = 7,
	LINK_DISABLED = 8,
	FCF_TS_INPROG = 9,
	FCF_RR_INPROG = 10,
	HBA_FIP_SUPPORT = 11,
	HBA_DEVLOSS_TMO = 13,
	HBA_RRQ_ACTIVE = 14,
	HBA_IOQ_FLUSH = 15,
	HBA_RECOVERABLE_UE = 17,
	HBA_FORCED_LINK_SPEED = 18,
	HBA_FLOGI_ISSUED = 20,
	HBA_DEFER_FLOGI = 23,
	HBA_SETUP = 24,
	HBA_NEEDS_CFG_PORT = 25,
	HBA_HBEAT_INP = 26,
	HBA_HBEAT_TMO = 27,
	HBA_FLOGI_OUTSTANDING = 28,
	HBA_RHBA_CMPL = 29,
};

enum lpfc_irq_chann_mode {
	NORMAL_MODE = 0,
	NUMA_MODE = 1,
	NHT_MODE = 2,
};

enum lpfc_load_flag {
	FC_LOADING = 0,
	FC_UNLOADING = 1,
	FC_ALLOW_FDMI = 2,
	FC_ALLOW_VMID = 3,
	FC_DEREGISTER_ALL_APP_ID = 4,
};

enum lpfc_mbox_ctx {
	MBOX_THD_UNLOCKED = 0,
	MBOX_THD_LOCKED = 1,
};

enum lpfc_nlp_save_flags {
	NLP_IN_RECOV_POST_DEV_LOSS = 1,
	NLP_WAIT_FOR_LOGO = 2,
};

enum lpfc_poll_mode {
	LPFC_QUEUE_WORK = 0,
	LPFC_THREADED_IRQ = 1,
};

enum lpfc_polling_flags {
	ENABLE_FCP_RING_POLLING = 1,
	DISABLE_FCP_RING_INT = 2,
};

enum lpfc_protgrp_type {
	LPFC_PG_TYPE_INVALID = 0,
	LPFC_PG_TYPE_NO_DIF = 1,
	LPFC_PG_TYPE_EMBD_DIF = 2,
	LPFC_PG_TYPE_DIF_BUF = 3,
};

enum lpfc_sge_type {
	GEN_BUFF_TYPE = 0,
	SCSI_BUFF_TYPE = 1,
	NVMET_BUFF_TYPE = 2,
};

enum lpfc_sgl_state {
	SGL_FREED = 0,
	SGL_ALLOCATED = 1,
	SGL_XRI_ABORTED = 2,
};

enum lpfc_sli4_queue_subtype {
	LPFC_NONE = 0,
	LPFC_MBOX = 1,
	LPFC_IO = 2,
	LPFC_ELS = 3,
	LPFC_NVMET = 4,
	LPFC_NVME_LS = 5,
	LPFC_USOL = 6,
};

enum lpfc_sli4_queue_type {
	LPFC_EQ = 0,
	LPFC_GCQ = 1,
	LPFC_MCQ = 2,
	LPFC_WCQ = 3,
	LPFC_RCQ = 4,
	LPFC_MQ = 5,
	LPFC_WQ = 6,
	LPFC_HRQ = 7,
	LPFC_DRQ = 8,
};

enum lpfc_work_type {
	LPFC_EVT_ONLINE = 0,
	LPFC_EVT_OFFLINE_PREP = 1,
	LPFC_EVT_OFFLINE = 2,
	LPFC_EVT_WARM_START = 3,
	LPFC_EVT_KILL = 4,
	LPFC_EVT_ELS_RETRY = 5,
	LPFC_EVT_DEV_LOSS = 6,
	LPFC_EVT_FASTPATH_MGMT_EVT = 7,
	LPFC_EVT_RESET_HBA = 8,
	LPFC_EVT_RECOVER_PORT = 9,
};

enum lru_list {
	LRU_INACTIVE_ANON = 0,
	LRU_ACTIVE_ANON = 1,
	LRU_INACTIVE_FILE = 2,
	LRU_ACTIVE_FILE = 3,
	LRU_UNEVICTABLE = 4,
	NR_LRU_LISTS = 5,
};

enum lru_status {
	LRU_REMOVED = 0,
	LRU_REMOVED_RETRY = 1,
	LRU_ROTATE = 2,
	LRU_SKIP = 3,
	LRU_RETRY = 4,
	LRU_STOP = 5,
};

enum lruvec_flags {
	LRUVEC_CGROUP_CONGESTED = 0,
	LRUVEC_NODE_CONGESTED = 1,
};

enum lsm_event {
	LSM_POLICY_CHANGE = 0,
};

enum lsm_order {
	LSM_ORDER_FIRST = -1,
	LSM_ORDER_MUTABLE = 0,
	LSM_ORDER_LAST = 1,
};

enum lw_bits {
	LW_URGENT = 0,
};

enum lwtunnel_encap_types {
	LWTUNNEL_ENCAP_NONE = 0,
	LWTUNNEL_ENCAP_MPLS = 1,
	LWTUNNEL_ENCAP_IP = 2,
	LWTUNNEL_ENCAP_ILA = 3,
	LWTUNNEL_ENCAP_IP6 = 4,
	LWTUNNEL_ENCAP_SEG6 = 5,
	LWTUNNEL_ENCAP_BPF = 6,
	LWTUNNEL_ENCAP_SEG6_LOCAL = 7,
	LWTUNNEL_ENCAP_RPL = 8,
	LWTUNNEL_ENCAP_IOAM6 = 9,
	LWTUNNEL_ENCAP_XFRM = 10,
	__LWTUNNEL_ENCAP_MAX = 11,
};

enum lwtunnel_ip6_t {
	LWTUNNEL_IP6_UNSPEC = 0,
	LWTUNNEL_IP6_ID = 1,
	LWTUNNEL_IP6_DST = 2,
	LWTUNNEL_IP6_SRC = 3,
	LWTUNNEL_IP6_HOPLIMIT = 4,
	LWTUNNEL_IP6_TC = 5,
	LWTUNNEL_IP6_FLAGS = 6,
	LWTUNNEL_IP6_PAD = 7,
	LWTUNNEL_IP6_OPTS = 8,
	__LWTUNNEL_IP6_MAX = 9,
};

enum lwtunnel_ip_t {
	LWTUNNEL_IP_UNSPEC = 0,
	LWTUNNEL_IP_ID = 1,
	LWTUNNEL_IP_DST = 2,
	LWTUNNEL_IP_SRC = 3,
	LWTUNNEL_IP_TTL = 4,
	LWTUNNEL_IP_TOS = 5,
	LWTUNNEL_IP_FLAGS = 6,
	LWTUNNEL_IP_PAD = 7,
	LWTUNNEL_IP_OPTS = 8,
	__LWTUNNEL_IP_MAX = 9,
};

enum lzma2_seq {
	SEQ_CONTROL = 0,
	SEQ_UNCOMPRESSED_1 = 1,
	SEQ_UNCOMPRESSED_2 = 2,
	SEQ_COMPRESSED_0 = 3,
	SEQ_COMPRESSED_1 = 4,
	SEQ_PROPERTIES = 5,
	SEQ_LZMA_PREPARE = 6,
	SEQ_LZMA_RUN = 7,
	SEQ_COPY = 8,
};

enum lzma_state {
	STATE_LIT_LIT = 0,
	STATE_MATCH_LIT_LIT = 1,
	STATE_REP_LIT_LIT = 2,
	STATE_SHORTREP_LIT_LIT = 3,
	STATE_MATCH_LIT = 4,
	STATE_REP_LIT = 5,
	STATE_SHORTREP_LIT = 6,
	STATE_LIT_MATCH = 7,
	STATE_LIT_LONGREP = 8,
	STATE_LIT_SHORTREP = 9,
	STATE_NONLIT_MATCH = 10,
	STATE_NONLIT_REP = 11,
};

enum mac_idx_types {
	LAN_MAC_IDX = 0,
	SAN_MAC_IDX = 1,
	MAX_MAC_IDX = 2,
};

enum macsec_offload {
	MACSEC_OFFLOAD_OFF = 0,
	MACSEC_OFFLOAD_PHY = 1,
	MACSEC_OFFLOAD_MAC = 2,
	__MACSEC_OFFLOAD_END = 3,
	MACSEC_OFFLOAD_MAX = 2,
};

enum macsec_validation_type {
	MACSEC_VALIDATE_DISABLED = 0,
	MACSEC_VALIDATE_CHECK = 1,
	MACSEC_VALIDATE_STRICT = 2,
	__MACSEC_VALIDATE_END = 3,
	MACSEC_VALIDATE_MAX = 2,
};

enum maple_status {
	ma_active = 0,
	ma_start = 1,
	ma_root = 2,
	ma_none = 3,
	ma_pause = 4,
	ma_overflow = 5,
	ma_underflow = 6,
	ma_error = 7,
};

enum maple_type {
	maple_dense = 0,
	maple_leaf_64 = 1,
	maple_range_64 = 2,
	maple_arange_64 = 3,
};

enum mapping_flags {
	AS_EIO = 0,
	AS_ENOSPC = 1,
	AS_MM_ALL_LOCKS = 2,
	AS_UNEVICTABLE = 3,
	AS_EXITING = 4,
	AS_NO_WRITEBACK_TAGS = 5,
	AS_LARGE_FOLIO_SUPPORT = 6,
	AS_RELEASE_ALWAYS = 7,
	AS_STABLE_WRITES = 8,
	AS_UNMOVABLE = 9,
};

enum mapping_status {
	MAPPING_OK = 0,
	MAPPING_INVALID = 1,
	MAPPING_EMPTY = 2,
	MAPPING_DATA_FIN = 3,
	MAPPING_DUMMY = 4,
	MAPPING_BAD_CSUM = 5,
};

enum max77620_chip_id {
	MAX77620 = 0,
	MAX20024 = 1,
	MAX77663 = 2,
};

enum max77693_types {
	TYPE_MAX77693_UNKNOWN = 0,
	TYPE_MAX77693 = 1,
	TYPE_MAX77843 = 2,
	TYPE_MAX77693_NUM = 3,
};

enum max77843_charger_reg {
	MAX77843_CHG_REG_CHG_INT = 176,
	MAX77843_CHG_REG_CHG_INT_MASK = 177,
	MAX77843_CHG_REG_CHG_INT_OK = 178,
	MAX77843_CHG_REG_CHG_DTLS_00 = 179,
	MAX77843_CHG_REG_CHG_DTLS_01 = 180,
	MAX77843_CHG_REG_CHG_DTLS_02 = 181,
	MAX77843_CHG_REG_CHG_CNFG_00 = 183,
	MAX77843_CHG_REG_CHG_CNFG_01 = 184,
	MAX77843_CHG_REG_CHG_CNFG_02 = 185,
	MAX77843_CHG_REG_CHG_CNFG_03 = 186,
	MAX77843_CHG_REG_CHG_CNFG_04 = 187,
	MAX77843_CHG_REG_CHG_CNFG_06 = 189,
	MAX77843_CHG_REG_CHG_CNFG_07 = 190,
	MAX77843_CHG_REG_CHG_CNFG_09 = 192,
	MAX77843_CHG_REG_CHG_CNFG_10 = 193,
	MAX77843_CHG_REG_CHG_CNFG_11 = 194,
	MAX77843_CHG_REG_CHG_CNFG_12 = 195,
	MAX77843_CHG_REG_END = 196,
};

enum max77843_sys_reg {
	MAX77843_SYS_REG_PMICID = 0,
	MAX77843_SYS_REG_PMICREV = 1,
	MAX77843_SYS_REG_MAINCTRL1 = 2,
	MAX77843_SYS_REG_INTSRC = 34,
	MAX77843_SYS_REG_INTSRCMASK = 35,
	MAX77843_SYS_REG_SYSINTSRC = 36,
	MAX77843_SYS_REG_SYSINTMASK = 38,
	MAX77843_SYS_REG_TOPSYS_STAT = 40,
	MAX77843_SYS_REG_SAFEOUTCTRL = 198,
	MAX77843_SYS_REG_END = 199,
};

enum max8997_haptic_motor_type {
	MAX8997_HAPTIC_ERM = 0,
	MAX8997_HAPTIC_LRA = 1,
};

enum max8997_haptic_pulse_mode {
	MAX8997_EXTERNAL_MODE = 0,
	MAX8997_INTERNAL_MODE = 1,
};

enum max8997_haptic_pwm_divisor {
	MAX8997_PWM_DIVISOR_32 = 0,
	MAX8997_PWM_DIVISOR_64 = 1,
	MAX8997_PWM_DIVISOR_128 = 2,
	MAX8997_PWM_DIVISOR_256 = 3,
};

enum max8997_haptic_reg {
	MAX8997_HAPTIC_REG_GENERAL = 0,
	MAX8997_HAPTIC_REG_CONF1 = 1,
	MAX8997_HAPTIC_REG_CONF2 = 2,
	MAX8997_HAPTIC_REG_DRVCONF = 3,
	MAX8997_HAPTIC_REG_CYCLECONF1 = 4,
	MAX8997_HAPTIC_REG_CYCLECONF2 = 5,
	MAX8997_HAPTIC_REG_SIGCONF1 = 6,
	MAX8997_HAPTIC_REG_SIGCONF2 = 7,
	MAX8997_HAPTIC_REG_SIGCONF3 = 8,
	MAX8997_HAPTIC_REG_SIGCONF4 = 9,
	MAX8997_HAPTIC_REG_SIGDC1 = 10,
	MAX8997_HAPTIC_REG_SIGDC2 = 11,
	MAX8997_HAPTIC_REG_SIGPWMDC1 = 12,
	MAX8997_HAPTIC_REG_SIGPWMDC2 = 13,
	MAX8997_HAPTIC_REG_SIGPWMDC3 = 14,
	MAX8997_HAPTIC_REG_SIGPWMDC4 = 15,
	MAX8997_HAPTIC_REG_MTR_REV = 16,
	MAX8997_HAPTIC_REG_END = 17,
};

enum max8997_irq {
	MAX8997_PMICIRQ_PWRONR = 0,
	MAX8997_PMICIRQ_PWRONF = 1,
	MAX8997_PMICIRQ_PWRON1SEC = 2,
	MAX8997_PMICIRQ_JIGONR = 3,
	MAX8997_PMICIRQ_JIGONF = 4,
	MAX8997_PMICIRQ_LOWBAT2 = 5,
	MAX8997_PMICIRQ_LOWBAT1 = 6,
	MAX8997_PMICIRQ_JIGR = 7,
	MAX8997_PMICIRQ_JIGF = 8,
	MAX8997_PMICIRQ_MR = 9,
	MAX8997_PMICIRQ_DVS1OK = 10,
	MAX8997_PMICIRQ_DVS2OK = 11,
	MAX8997_PMICIRQ_DVS3OK = 12,
	MAX8997_PMICIRQ_DVS4OK = 13,
	MAX8997_PMICIRQ_CHGINS = 14,
	MAX8997_PMICIRQ_CHGRM = 15,
	MAX8997_PMICIRQ_DCINOVP = 16,
	MAX8997_PMICIRQ_TOPOFFR = 17,
	MAX8997_PMICIRQ_CHGRSTF = 18,
	MAX8997_PMICIRQ_MBCHGTMEXPD = 19,
	MAX8997_PMICIRQ_RTC60S = 20,
	MAX8997_PMICIRQ_RTCA1 = 21,
	MAX8997_PMICIRQ_RTCA2 = 22,
	MAX8997_PMICIRQ_SMPL_INT = 23,
	MAX8997_PMICIRQ_RTC1S = 24,
	MAX8997_PMICIRQ_WTSR = 25,
	MAX8997_MUICIRQ_ADCError = 26,
	MAX8997_MUICIRQ_ADCLow = 27,
	MAX8997_MUICIRQ_ADC = 28,
	MAX8997_MUICIRQ_VBVolt = 29,
	MAX8997_MUICIRQ_DBChg = 30,
	MAX8997_MUICIRQ_DCDTmr = 31,
	MAX8997_MUICIRQ_ChgDetRun = 32,
	MAX8997_MUICIRQ_ChgTyp = 33,
	MAX8997_MUICIRQ_OVP = 34,
	MAX8997_IRQ_NR = 35,
};

enum max8997_irq_source {
	PMIC_INT1 = 0,
	PMIC_INT2 = 1,
	PMIC_INT3 = 2,
	PMIC_INT4 = 3,
	FUEL_GAUGE = 4,
	MUIC_INT1 = 5,
	MUIC_INT2 = 6,
	MUIC_INT3 = 7,
	GPIO_LOW = 8,
	GPIO_HI = 9,
	FLASH_STATUS = 10,
	MAX8997_IRQ_GROUP_NR = 11,
};

enum max8997_led_mode {
	MAX8997_NONE = 0,
	MAX8997_FLASH_MODE = 1,
	MAX8997_MOVIE_MODE = 2,
	MAX8997_FLASH_PIN_CONTROL_MODE = 3,
	MAX8997_MOVIE_PIN_CONTROL_MODE = 4,
};

enum max8997_muic_reg {
	MAX8997_MUIC_REG_ID = 0,
	MAX8997_MUIC_REG_INT1 = 1,
	MAX8997_MUIC_REG_INT2 = 2,
	MAX8997_MUIC_REG_INT3 = 3,
	MAX8997_MUIC_REG_STATUS1 = 4,
	MAX8997_MUIC_REG_STATUS2 = 5,
	MAX8997_MUIC_REG_STATUS3 = 6,
	MAX8997_MUIC_REG_INTMASK1 = 7,
	MAX8997_MUIC_REG_INTMASK2 = 8,
	MAX8997_MUIC_REG_INTMASK3 = 9,
	MAX8997_MUIC_REG_CDETCTRL = 10,
	MAX8997_MUIC_REG_CONTROL1 = 12,
	MAX8997_MUIC_REG_CONTROL2 = 13,
	MAX8997_MUIC_REG_CONTROL3 = 14,
	MAX8997_MUIC_REG_END = 15,
};

enum max8997_pmic_reg {
	MAX8997_REG_PMIC_ID0 = 0,
	MAX8997_REG_PMIC_ID1 = 1,
	MAX8997_REG_INTSRC = 2,
	MAX8997_REG_INT1 = 3,
	MAX8997_REG_INT2 = 4,
	MAX8997_REG_INT3 = 5,
	MAX8997_REG_INT4 = 6,
	MAX8997_REG_INT1MSK = 8,
	MAX8997_REG_INT2MSK = 9,
	MAX8997_REG_INT3MSK = 10,
	MAX8997_REG_INT4MSK = 11,
	MAX8997_REG_STATUS1 = 13,
	MAX8997_REG_STATUS2 = 14,
	MAX8997_REG_STATUS3 = 15,
	MAX8997_REG_STATUS4 = 16,
	MAX8997_REG_MAINCON1 = 19,
	MAX8997_REG_MAINCON2 = 20,
	MAX8997_REG_BUCKRAMP = 21,
	MAX8997_REG_BUCK1CTRL = 24,
	MAX8997_REG_BUCK1DVS1 = 25,
	MAX8997_REG_BUCK1DVS2 = 26,
	MAX8997_REG_BUCK1DVS3 = 27,
	MAX8997_REG_BUCK1DVS4 = 28,
	MAX8997_REG_BUCK1DVS5 = 29,
	MAX8997_REG_BUCK1DVS6 = 30,
	MAX8997_REG_BUCK1DVS7 = 31,
	MAX8997_REG_BUCK1DVS8 = 32,
	MAX8997_REG_BUCK2CTRL = 33,
	MAX8997_REG_BUCK2DVS1 = 34,
	MAX8997_REG_BUCK2DVS2 = 35,
	MAX8997_REG_BUCK2DVS3 = 36,
	MAX8997_REG_BUCK2DVS4 = 37,
	MAX8997_REG_BUCK2DVS5 = 38,
	MAX8997_REG_BUCK2DVS6 = 39,
	MAX8997_REG_BUCK2DVS7 = 40,
	MAX8997_REG_BUCK2DVS8 = 41,
	MAX8997_REG_BUCK3CTRL = 42,
	MAX8997_REG_BUCK3DVS = 43,
	MAX8997_REG_BUCK4CTRL = 44,
	MAX8997_REG_BUCK4DVS = 45,
	MAX8997_REG_BUCK5CTRL = 46,
	MAX8997_REG_BUCK5DVS1 = 47,
	MAX8997_REG_BUCK5DVS2 = 48,
	MAX8997_REG_BUCK5DVS3 = 49,
	MAX8997_REG_BUCK5DVS4 = 50,
	MAX8997_REG_BUCK5DVS5 = 51,
	MAX8997_REG_BUCK5DVS6 = 52,
	MAX8997_REG_BUCK5DVS7 = 53,
	MAX8997_REG_BUCK5DVS8 = 54,
	MAX8997_REG_BUCK6CTRL = 55,
	MAX8997_REG_BUCK6BPSKIPCTRL = 56,
	MAX8997_REG_BUCK7CTRL = 57,
	MAX8997_REG_BUCK7DVS = 58,
	MAX8997_REG_LDO1CTRL = 59,
	MAX8997_REG_LDO2CTRL = 60,
	MAX8997_REG_LDO3CTRL = 61,
	MAX8997_REG_LDO4CTRL = 62,
	MAX8997_REG_LDO5CTRL = 63,
	MAX8997_REG_LDO6CTRL = 64,
	MAX8997_REG_LDO7CTRL = 65,
	MAX8997_REG_LDO8CTRL = 66,
	MAX8997_REG_LDO9CTRL = 67,
	MAX8997_REG_LDO10CTRL = 68,
	MAX8997_REG_LDO11CTRL = 69,
	MAX8997_REG_LDO12CTRL = 70,
	MAX8997_REG_LDO13CTRL = 71,
	MAX8997_REG_LDO14CTRL = 72,
	MAX8997_REG_LDO15CTRL = 73,
	MAX8997_REG_LDO16CTRL = 74,
	MAX8997_REG_LDO17CTRL = 75,
	MAX8997_REG_LDO18CTRL = 76,
	MAX8997_REG_LDO21CTRL = 77,
	MAX8997_REG_MBCCTRL1 = 80,
	MAX8997_REG_MBCCTRL2 = 81,
	MAX8997_REG_MBCCTRL3 = 82,
	MAX8997_REG_MBCCTRL4 = 83,
	MAX8997_REG_MBCCTRL5 = 84,
	MAX8997_REG_MBCCTRL6 = 85,
	MAX8997_REG_OTPCGHCVS = 86,
	MAX8997_REG_SAFEOUTCTRL = 90,
	MAX8997_REG_LBCNFG1 = 94,
	MAX8997_REG_LBCNFG2 = 95,
	MAX8997_REG_BBCCTRL = 96,
	MAX8997_REG_FLASH1_CUR = 99,
	MAX8997_REG_FLASH2_CUR = 100,
	MAX8997_REG_MOVIE_CUR = 101,
	MAX8997_REG_GSMB_CUR = 102,
	MAX8997_REG_BOOST_CNTL = 103,
	MAX8997_REG_LEN_CNTL = 104,
	MAX8997_REG_FLASH_CNTL = 105,
	MAX8997_REG_WDT_CNTL = 106,
	MAX8997_REG_MAXFLASH1 = 107,
	MAX8997_REG_MAXFLASH2 = 108,
	MAX8997_REG_FLASHSTATUS = 109,
	MAX8997_REG_FLASHSTATUSMASK = 110,
	MAX8997_REG_GPIOCNTL1 = 112,
	MAX8997_REG_GPIOCNTL2 = 113,
	MAX8997_REG_GPIOCNTL3 = 114,
	MAX8997_REG_GPIOCNTL4 = 115,
	MAX8997_REG_GPIOCNTL5 = 116,
	MAX8997_REG_GPIOCNTL6 = 117,
	MAX8997_REG_GPIOCNTL7 = 118,
	MAX8997_REG_GPIOCNTL8 = 119,
	MAX8997_REG_GPIOCNTL9 = 120,
	MAX8997_REG_GPIOCNTL10 = 121,
	MAX8997_REG_GPIOCNTL11 = 122,
	MAX8997_REG_GPIOCNTL12 = 123,
	MAX8997_REG_LDO1CONFIG = 128,
	MAX8997_REG_LDO2CONFIG = 129,
	MAX8997_REG_LDO3CONFIG = 130,
	MAX8997_REG_LDO4CONFIG = 131,
	MAX8997_REG_LDO5CONFIG = 132,
	MAX8997_REG_LDO6CONFIG = 133,
	MAX8997_REG_LDO7CONFIG = 134,
	MAX8997_REG_LDO8CONFIG = 135,
	MAX8997_REG_LDO9CONFIG = 136,
	MAX8997_REG_LDO10CONFIG = 137,
	MAX8997_REG_LDO11CONFIG = 138,
	MAX8997_REG_LDO12CONFIG = 139,
	MAX8997_REG_LDO13CONFIG = 140,
	MAX8997_REG_LDO14CONFIG = 141,
	MAX8997_REG_LDO15CONFIG = 142,
	MAX8997_REG_LDO16CONFIG = 143,
	MAX8997_REG_LDO17CONFIG = 144,
	MAX8997_REG_LDO18CONFIG = 145,
	MAX8997_REG_LDO21CONFIG = 146,
	MAX8997_REG_DVSOKTIMER1 = 151,
	MAX8997_REG_DVSOKTIMER2 = 152,
	MAX8997_REG_DVSOKTIMER4 = 153,
	MAX8997_REG_DVSOKTIMER5 = 154,
	MAX8997_REG_PMIC_END = 155,
};

enum max8997_types {
	TYPE_MAX8997 = 0,
	TYPE_MAX8966 = 1,
};

enum mbox_type {
	mbox_rd = 1,
	mbox_wr = 2,
};

enum mc_target_type {
	MC_TARGET_NONE = 0,
	MC_TARGET_PAGE = 1,
	MC_TARGET_SWAP = 2,
	MC_TARGET_DEVICE = 3,
};

enum mctp_neigh_source {
	MCTP_NEIGH_STATIC = 0,
	MCTP_NEIGH_DISCOVER = 1,
};

enum mctrl_gpio_idx {
	UART_GPIO_CTS = 0,
	UART_GPIO_DSR = 1,
	UART_GPIO_DCD = 2,
	UART_GPIO_RNG = 3,
	UART_GPIO_RI = 3,
	UART_GPIO_RTS = 4,
	UART_GPIO_DTR = 5,
	UART_GPIO_MAX = 6,
};

enum mem_cgroup_events_target {
	MEM_CGROUP_TARGET_THRESH = 0,
	MEM_CGROUP_TARGET_SOFTLIMIT = 1,
	MEM_CGROUP_NTARGETS = 2,
};

enum membarrier_cmd {
	MEMBARRIER_CMD_QUERY = 0,
	MEMBARRIER_CMD_GLOBAL = 1,
	MEMBARRIER_CMD_GLOBAL_EXPEDITED = 2,
	MEMBARRIER_CMD_REGISTER_GLOBAL_EXPEDITED = 4,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED = 8,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED = 16,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_SYNC_CORE = 64,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_RSEQ = 128,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_RSEQ = 256,
	MEMBARRIER_CMD_GET_REGISTRATIONS = 512,
	MEMBARRIER_CMD_SHARED = 1,
};

enum membarrier_cmd_flag {
	MEMBARRIER_CMD_FLAG_CPU = 1,
};

enum memblock_flags {
	MEMBLOCK_NONE = 0,
	MEMBLOCK_HOTPLUG = 1,
	MEMBLOCK_MIRROR = 2,
	MEMBLOCK_NOMAP = 4,
	MEMBLOCK_DRIVER_MANAGED = 8,
	MEMBLOCK_RSRV_NOINIT = 16,
};

enum memcg_memory_event {
	MEMCG_LOW = 0,
	MEMCG_HIGH = 1,
	MEMCG_MAX = 2,
	MEMCG_OOM = 3,
	MEMCG_OOM_KILL = 4,
	MEMCG_OOM_GROUP_KILL = 5,
	MEMCG_SWAP_HIGH = 6,
	MEMCG_SWAP_MAX = 7,
	MEMCG_SWAP_FAIL = 8,
	MEMCG_NR_MEMORY_EVENTS = 9,
};

enum memcg_stat_item {
	MEMCG_SWAP = 47,
	MEMCG_SOCK = 48,
	MEMCG_PERCPU_B = 49,
	MEMCG_VMALLOC = 50,
	MEMCG_KMEM = 51,
	MEMCG_ZSWAP_B = 52,
	MEMCG_ZSWAPPED = 53,
	MEMCG_NR_STAT = 54,
};

enum meminit_context {
	MEMINIT_EARLY = 0,
	MEMINIT_HOTPLUG = 1,
};

enum memory_region_num {
	AAP1 = 0,
	IOP = 1,
	NVMD = 2,
	FW_FLASH = 3,
	FORENSIC_MEM = 4,
	USI_MAX_MEMCNT_BASE = 5,
};

enum memory_type {
	MEMORY_DEVICE_PRIVATE = 1,
	MEMORY_DEVICE_COHERENT = 2,
	MEMORY_DEVICE_FS_DAX = 3,
	MEMORY_DEVICE_GENERIC = 4,
	MEMORY_DEVICE_PCI_P2PDMA = 5,
};

enum metadata_type {
	METADATA_IP_TUNNEL = 0,
	METADATA_HW_PORT_MUX = 1,
	METADATA_MACSEC = 2,
	METADATA_XFRM = 3,
};

enum mf_action_page_type {
	MF_MSG_KERNEL = 0,
	MF_MSG_KERNEL_HIGH_ORDER = 1,
	MF_MSG_SLAB = 2,
	MF_MSG_DIFFERENT_COMPOUND = 3,
	MF_MSG_HUGE = 4,
	MF_MSG_FREE_HUGE = 5,
	MF_MSG_UNMAP_FAILED = 6,
	MF_MSG_DIRTY_SWAPCACHE = 7,
	MF_MSG_CLEAN_SWAPCACHE = 8,
	MF_MSG_DIRTY_MLOCKED_LRU = 9,
	MF_MSG_CLEAN_MLOCKED_LRU = 10,
	MF_MSG_DIRTY_UNEVICTABLE_LRU = 11,
	MF_MSG_CLEAN_UNEVICTABLE_LRU = 12,
	MF_MSG_DIRTY_LRU = 13,
	MF_MSG_CLEAN_LRU = 14,
	MF_MSG_TRUNCATED_LRU = 15,
	MF_MSG_BUDDY = 16,
	MF_MSG_DAX = 17,
	MF_MSG_UNSPLIT_THP = 18,
	MF_MSG_UNKNOWN = 19,
};

enum mf_cfg_afex_vlan_mode {
	FUNC_MF_CFG_AFEX_VLAN_TRUNK_MODE = 0,
	FUNC_MF_CFG_AFEX_VLAN_ACCESS_MODE = 1,
	FUNC_MF_CFG_AFEX_VLAN_TRUNK_TAG_NATIVE_MODE = 2,
};

enum mf_flags {
	MF_COUNT_INCREASED = 1,
	MF_ACTION_REQUIRED = 2,
	MF_MUST_KILL = 4,
	MF_SOFT_OFFLINE = 8,
	MF_UNPOISON = 16,
	MF_SW_SIMULATED = 32,
	MF_NO_RETRY = 64,
	MF_MEM_PRE_REMOVE = 128,
};

enum mf_result {
	MF_IGNORED = 0,
	MF_FAILED = 1,
	MF_DELAYED = 2,
	MF_RECOVERED = 3,
};

enum mfi_evt_class {
	MFI_EVT_CLASS_DEBUG = -2,
	MFI_EVT_CLASS_PROGRESS = -1,
	MFI_EVT_CLASS_INFO = 0,
	MFI_EVT_CLASS_WARNING = 1,
	MFI_EVT_CLASS_CRITICAL = 2,
	MFI_EVT_CLASS_FATAL = 3,
	MFI_EVT_CLASS_DEAD = 4,
};

enum mfill_atomic_mode {
	MFILL_ATOMIC_COPY = 0,
	MFILL_ATOMIC_ZEROPAGE = 1,
	MFILL_ATOMIC_CONTINUE = 2,
	MFILL_ATOMIC_POISON = 3,
	NR_MFILL_ATOMIC_MODES = 4,
};

enum migrate_mode {
	MIGRATE_ASYNC = 0,
	MIGRATE_SYNC_LIGHT = 1,
	MIGRATE_SYNC = 2,
	MIGRATE_SYNC_NO_COPY = 3,
};

enum migrate_reason {
	MR_COMPACTION = 0,
	MR_MEMORY_FAILURE = 1,
	MR_MEMORY_HOTPLUG = 2,
	MR_SYSCALL = 3,
	MR_MEMPOLICY_MBIND = 4,
	MR_NUMA_MISPLACED = 5,
	MR_CONTIG_RANGE = 6,
	MR_LONGTERM_PIN = 7,
	MR_DEMOTION = 8,
	MR_TYPES = 9,
};

enum migrate_vma_direction {
	MIGRATE_VMA_SELECT_SYSTEM = 1,
	MIGRATE_VMA_SELECT_DEVICE_PRIVATE = 2,
	MIGRATE_VMA_SELECT_DEVICE_COHERENT = 4,
};

enum migratetype {
	MIGRATE_UNMOVABLE = 0,
	MIGRATE_MOVABLE = 1,
	MIGRATE_RECLAIMABLE = 2,
	MIGRATE_PCPTYPES = 3,
	MIGRATE_HIGHATOMIC = 3,
	MIGRATE_CMA = 4,
	MIGRATE_ISOLATE = 5,
	MIGRATE_TYPES = 6,
};

enum migration_type {
	migrate_load = 0,
	migrate_util = 1,
	migrate_task = 2,
	migrate_misfit = 3,
};

enum mipi_dsi_compression_algo {
	MIPI_DSI_COMPRESSION_DSC = 0,
	MIPI_DSI_COMPRESSION_VENDOR = 3,
};

enum mipi_dsi_dcs_tear_mode {
	MIPI_DSI_DCS_TEAR_MODE_VBLANK = 0,
	MIPI_DSI_DCS_TEAR_MODE_VHBLANK = 1,
};

enum mipi_dsi_pixel_format {
	MIPI_DSI_FMT_RGB888 = 0,
	MIPI_DSI_FMT_RGB666 = 1,
	MIPI_DSI_FMT_RGB666_PACKED = 2,
	MIPI_DSI_FMT_RGB565 = 3,
};

enum mm_cid_state {
	MM_CID_UNSET = 4294967295,
	MM_CID_LAZY_PUT = 2147483648,
};

enum mminit_level {
	MMINIT_WARNING = 0,
	MMINIT_VERIFY = 1,
	MMINIT_TRACE = 2,
};

enum mmu_notifier_event {
	MMU_NOTIFY_UNMAP = 0,
	MMU_NOTIFY_CLEAR = 1,
	MMU_NOTIFY_PROTECTION_VMA = 2,
	MMU_NOTIFY_PROTECTION_PAGE = 3,
	MMU_NOTIFY_SOFT_DIRTY = 4,
	MMU_NOTIFY_RELEASE = 5,
	MMU_NOTIFY_MIGRATE = 6,
	MMU_NOTIFY_EXCLUSIVE = 7,
};

enum mnt_tree_flags_t {
	MNT_TREE_MOVE = 1,
	MNT_TREE_BENEATH = 2,
};

enum mod_license {
	NOT_GPL_ONLY = 0,
	GPL_ONLY = 1,
};

enum mod_mem_type {
	MOD_TEXT = 0,
	MOD_DATA = 1,
	MOD_RODATA = 2,
	MOD_RO_AFTER_INIT = 3,
	MOD_INIT_TEXT = 4,
	MOD_INIT_DATA = 5,
	MOD_INIT_RODATA = 6,
	MOD_MEM_NUM_TYPES = 7,
	MOD_INVALID = -1,
};

enum module_state {
	MODULE_STATE_LIVE = 0,
	MODULE_STATE_COMING = 1,
	MODULE_STATE_GOING = 2,
	MODULE_STATE_UNFORMED = 3,
};

enum mpi3_man9_resources {
	MPI3_MAN9_RSRC_OUTSTANDING_REQS = 0,
	MPI3_MAN9_RSRC_TARGET_CMDS = 1,
	MPI3_MAN9_RSRC_RESERVED02 = 2,
	MPI3_MAN9_RSRC_NVME = 3,
	MPI3_MAN9_RSRC_INITIATORS = 4,
	MPI3_MAN9_RSRC_VDS = 5,
	MPI3_MAN9_RSRC_ENCLOSURES = 6,
	MPI3_MAN9_RSRC_ENCLOSURE_PHYS = 7,
	MPI3_MAN9_RSRC_EXPANDERS = 8,
	MPI3_MAN9_RSRC_PCIE_SWITCHES = 9,
	MPI3_MAN9_RSRC_RESERVED10 = 10,
	MPI3_MAN9_RSRC_HOST_PD_DRIVES = 11,
	MPI3_MAN9_RSRC_ADV_HOST_PD_DRIVES = 12,
	MPI3_MAN9_RSRC_RAID_PD_DRIVES = 13,
	MPI3_MAN9_RSRC_DRV_DIAG_BUF = 14,
	MPI3_MAN9_RSRC_NAMESPACE_COUNT = 15,
	MPI3_MAN9_RSRC_NUM_RESOURCES = 16,
};

enum mpi3mr_dev_state {
	MPI3MR_DEV_CREATED = 1,
	MPI3MR_DEV_REMOVE_HS_STARTED = 2,
	MPI3MR_DEV_DELETED = 3,
};

enum mpi3mr_iocstate {
	MRIOC_STATE_READY = 1,
	MRIOC_STATE_RESET = 2,
	MRIOC_STATE_FAULT = 3,
	MRIOC_STATE_BECOMING_READY = 4,
	MRIOC_STATE_RESET_REQUESTED = 5,
	MRIOC_STATE_UNRECOVERABLE = 6,
};

enum mpi3mr_reset_reason {
	MPI3MR_RESET_FROM_BRINGUP = 1,
	MPI3MR_RESET_FROM_FAULT_WATCH = 2,
	MPI3MR_RESET_FROM_APP = 3,
	MPI3MR_RESET_FROM_EH_HOS = 4,
	MPI3MR_RESET_FROM_TM_TIMEOUT = 5,
	MPI3MR_RESET_FROM_APP_TIMEOUT = 6,
	MPI3MR_RESET_FROM_MUR_FAILURE = 7,
	MPI3MR_RESET_FROM_CTLR_CLEANUP = 8,
	MPI3MR_RESET_FROM_CIACTIV_FAULT = 9,
	MPI3MR_RESET_FROM_PE_TIMEOUT = 10,
	MPI3MR_RESET_FROM_TSU_TIMEOUT = 11,
	MPI3MR_RESET_FROM_DELREQQ_TIMEOUT = 12,
	MPI3MR_RESET_FROM_DELREPQ_TIMEOUT = 13,
	MPI3MR_RESET_FROM_CREATEREPQ_TIMEOUT = 14,
	MPI3MR_RESET_FROM_CREATEREQQ_TIMEOUT = 15,
	MPI3MR_RESET_FROM_IOCFACTS_TIMEOUT = 16,
	MPI3MR_RESET_FROM_IOCINIT_TIMEOUT = 17,
	MPI3MR_RESET_FROM_EVTNOTIFY_TIMEOUT = 18,
	MPI3MR_RESET_FROM_EVTACK_TIMEOUT = 19,
	MPI3MR_RESET_FROM_CIACTVRST_TIMER = 20,
	MPI3MR_RESET_FROM_GETPKGVER_TIMEOUT = 21,
	MPI3MR_RESET_FROM_PELABORT_TIMEOUT = 22,
	MPI3MR_RESET_FROM_SYSFS = 23,
	MPI3MR_RESET_FROM_SYSFS_TIMEOUT = 24,
	MPI3MR_RESET_FROM_FIRMWARE = 27,
	MPI3MR_RESET_FROM_CFG_REQ_TIMEOUT = 29,
	MPI3MR_RESET_FROM_SAS_TRANSPORT_TIMEOUT = 30,
};

enum mpi_err {
	MPI_IO_STATUS_SUCCESS = 0,
	MPI_IO_STATUS_BUSY = 1,
	MPI_IO_STATUS_FAIL = 2,
};

enum mpic_reg_type {
	mpic_access_mmio_le = 0,
	mpic_access_mmio_be = 1,
};

enum mpt3sas_perf_mode {
	MPT_PERF_MODE_DEFAULT = -1,
	MPT_PERF_MODE_BALANCED = 0,
	MPT_PERF_MODE_IOPS = 1,
	MPT_PERF_MODE_LATENCY = 2,
};

enum mptcp_addr_signal_status {
	MPTCP_ADD_ADDR_SIGNAL = 0,
	MPTCP_ADD_ADDR_ECHO = 1,
	MPTCP_RM_ADDR_SIGNAL = 2,
};

enum mptcp_event_attr {
	MPTCP_ATTR_UNSPEC = 0,
	MPTCP_ATTR_TOKEN = 1,
	MPTCP_ATTR_FAMILY = 2,
	MPTCP_ATTR_LOC_ID = 3,
	MPTCP_ATTR_REM_ID = 4,
	MPTCP_ATTR_SADDR4 = 5,
	MPTCP_ATTR_SADDR6 = 6,
	MPTCP_ATTR_DADDR4 = 7,
	MPTCP_ATTR_DADDR6 = 8,
	MPTCP_ATTR_SPORT = 9,
	MPTCP_ATTR_DPORT = 10,
	MPTCP_ATTR_BACKUP = 11,
	MPTCP_ATTR_ERROR = 12,
	MPTCP_ATTR_FLAGS = 13,
	MPTCP_ATTR_TIMEOUT = 14,
	MPTCP_ATTR_IF_IDX = 15,
	MPTCP_ATTR_RESET_REASON = 16,
	MPTCP_ATTR_RESET_FLAGS = 17,
	MPTCP_ATTR_SERVER_SIDE = 18,
	__MPTCP_ATTR_MAX = 19,
};

enum mptcp_event_type {
	MPTCP_EVENT_UNSPEC = 0,
	MPTCP_EVENT_CREATED = 1,
	MPTCP_EVENT_ESTABLISHED = 2,
	MPTCP_EVENT_CLOSED = 3,
	MPTCP_EVENT_ANNOUNCED = 6,
	MPTCP_EVENT_REMOVED = 7,
	MPTCP_EVENT_SUB_ESTABLISHED = 10,
	MPTCP_EVENT_SUB_CLOSED = 11,
	MPTCP_EVENT_SUB_PRIORITY = 13,
	MPTCP_EVENT_LISTENER_CREATED = 15,
	MPTCP_EVENT_LISTENER_CLOSED = 16,
};

enum mptcp_pm_status {
	MPTCP_PM_ADD_ADDR_RECEIVED = 0,
	MPTCP_PM_ADD_ADDR_SEND_ACK = 1,
	MPTCP_PM_RM_ADDR_RECEIVED = 2,
	MPTCP_PM_ESTABLISHED = 3,
	MPTCP_PM_SUBFLOW_ESTABLISHED = 4,
	MPTCP_PM_ALREADY_ESTABLISHED = 5,
	MPTCP_PM_MPC_ENDPOINT_ACCOUNTED = 6,
};

enum mptcp_pm_type {
	MPTCP_PM_TYPE_KERNEL = 0,
	MPTCP_PM_TYPE_USERSPACE = 1,
	__MPTCP_PM_TYPE_NR = 2,
	__MPTCP_PM_TYPE_MAX = 1,
};

enum mptsas_hotplug_action {
	MPTSAS_ADD_DEVICE = 0,
	MPTSAS_DEL_DEVICE = 1,
	MPTSAS_ADD_RAID = 2,
	MPTSAS_DEL_RAID = 3,
	MPTSAS_ADD_PHYSDISK = 4,
	MPTSAS_ADD_PHYSDISK_REPROBE = 5,
	MPTSAS_DEL_PHYSDISK = 6,
	MPTSAS_DEL_PHYSDISK_REPROBE = 7,
	MPTSAS_ADD_INACTIVE_VOLUME = 8,
	MPTSAS_IGNORE_EVENT = 9,
};

enum mq_rq_state {
	MQ_RQ_IDLE = 0,
	MQ_RQ_IN_FLIGHT = 1,
	MQ_RQ_COMPLETE = 2,
};

enum mscode_actions {
	ACT_mscode_note_content_type = 0,
	ACT_mscode_note_digest = 1,
	ACT_mscode_note_digest_algo = 2,
	NR__mscode_actions = 3,
};

enum msdos_sys_ind {
	DOS_EXTENDED_PARTITION = 5,
	LINUX_EXTENDED_PARTITION = 133,
	WIN98_EXTENDED_PARTITION = 15,
	LINUX_DATA_PARTITION = 131,
	LINUX_LVM_PARTITION = 142,
	LINUX_RAID_PARTITION___3 = 253,
	SOLARIS_X86_PARTITION = 130,
	NEW_SOLARIS_X86_PARTITION = 191,
	DM6_AUX1PARTITION = 81,
	DM6_AUX3PARTITION = 83,
	DM6_PARTITION = 84,
	EZD_PARTITION = 85,
	FREEBSD_PARTITION = 165,
	OPENBSD_PARTITION = 166,
	NETBSD_PARTITION = 169,
	BSDI_PARTITION = 183,
	MINIX_PARTITION = 129,
	UNIXWARE_PARTITION = 99,
};

enum msi_desc_filter {
	MSI_DESC_ALL = 0,
	MSI_DESC_NOTASSOCIATED = 1,
	MSI_DESC_ASSOCIATED = 2,
};

enum msi_domain_ids {
	MSI_DEFAULT_DOMAIN = 0,
	MSI_MAX_DEVICE_IRQDOMAINS = 1,
};

enum mthp_stat_item {
	MTHP_STAT_ANON_FAULT_ALLOC = 0,
	MTHP_STAT_ANON_FAULT_FALLBACK = 1,
	MTHP_STAT_ANON_FAULT_FALLBACK_CHARGE = 2,
	MTHP_STAT_SWPOUT = 3,
	MTHP_STAT_SWPOUT_FALLBACK = 4,
	__MTHP_STAT_COUNT = 5,
};

enum multi_stop_state {
	MULTI_STOP_NONE = 0,
	MULTI_STOP_PREPARE = 1,
	MULTI_STOP_DISABLE_IRQ = 2,
	MULTI_STOP_RUN = 3,
	MULTI_STOP_EXIT = 4,
};

enum mvs_event_flags {
	PHY_PLUG_EVENT = 3,
	PHY_PLUG_IN = 1,
	PHY_PLUG_OUT = 2,
	EXP_BRCT_CHG = 4,
};

enum mvs_info_flags {
	MVF_PHY_PWR_FIX = 2,
	MVF_FLAG_SOC = 4,
};

enum mvs_port_type {
	PORT_TGT_MASK = 32,
	PORT_INIT_PORT = 16,
	PORT_TGT_PORT = 8,
	PORT_INIT_TGT_PORT = 24,
	PORT_TYPE_SAS = 2,
	PORT_TYPE_SATA = 1,
};

enum mvumi_qc_result {
	MV_QUEUE_COMMAND_RESULT_SENT = 0,
	MV_QUEUE_COMMAND_RESULT_NO_RESOURCE = 1,
};

enum myrb_cmd_opcode {
	MYRB_CMD_READ_EXTENDED = 51,
	MYRB_CMD_WRITE_EXTENDED = 52,
	MYRB_CMD_READAHEAD_EXTENDED = 53,
	MYRB_CMD_READ_EXTENDED_SG = 179,
	MYRB_CMD_WRITE_EXTENDED_SG = 180,
	MYRB_CMD_READ = 54,
	MYRB_CMD_READ_SG = 182,
	MYRB_CMD_WRITE = 55,
	MYRB_CMD_WRITE_SG = 183,
	MYRB_CMD_DCDB = 4,
	MYRB_CMD_DCDB_SG = 132,
	MYRB_CMD_FLUSH = 10,
	MYRB_CMD_ENQUIRY = 83,
	MYRB_CMD_ENQUIRY2 = 28,
	MYRB_CMD_GET_LDRV_ELEMENT = 85,
	MYRB_CMD_GET_LDEV_INFO = 25,
	MYRB_CMD_IOPORTREAD = 57,
	MYRB_CMD_IOPORTWRITE = 58,
	MYRB_CMD_GET_SD_STATS = 62,
	MYRB_CMD_GET_PD_STATS = 63,
	MYRB_CMD_EVENT_LOG_OPERATION = 114,
	MYRB_CMD_START_DEVICE = 16,
	MYRB_CMD_GET_DEVICE_STATE = 80,
	MYRB_CMD_STOP_CHANNEL = 19,
	MYRB_CMD_START_CHANNEL = 18,
	MYRB_CMD_RESET_CHANNEL = 26,
	MYRB_CMD_REBUILD = 9,
	MYRB_CMD_REBUILD_ASYNC = 22,
	MYRB_CMD_CHECK_CONSISTENCY = 15,
	MYRB_CMD_CHECK_CONSISTENCY_ASYNC = 30,
	MYRB_CMD_REBUILD_STAT = 12,
	MYRB_CMD_GET_REBUILD_PROGRESS = 39,
	MYRB_CMD_REBUILD_CONTROL = 31,
	MYRB_CMD_READ_BADBLOCK_TABLE = 11,
	MYRB_CMD_READ_BADDATA_TABLE = 37,
	MYRB_CMD_CLEAR_BADDATA_TABLE = 38,
	MYRB_CMD_GET_ERROR_TABLE = 23,
	MYRB_CMD_ADD_CAPACITY_ASYNC = 42,
	MYRB_CMD_BGI_CONTROL = 43,
	MYRB_CMD_READ_CONFIG2 = 61,
	MYRB_CMD_WRITE_CONFIG2 = 60,
	MYRB_CMD_READ_CONFIG_ONDISK = 74,
	MYRB_CMD_WRITE_CONFIG_ONDISK = 75,
	MYRB_CMD_READ_CONFIG = 78,
	MYRB_CMD_READ_BACKUP_CONFIG = 77,
	MYRB_CMD_WRITE_CONFIG = 79,
	MYRB_CMD_ADD_CONFIG = 76,
	MYRB_CMD_READ_CONFIG_LABEL = 72,
	MYRB_CMD_WRITE_CONFIG_LABEL = 73,
	MYRB_CMD_LOAD_IMAGE = 32,
	MYRB_CMD_STORE_IMAGE = 33,
	MYRB_CMD_PROGRAM_IMAGE = 34,
	MYRB_CMD_SET_DIAGNOSTIC_MODE = 49,
	MYRB_CMD_RUN_DIAGNOSTIC = 50,
	MYRB_CMD_GET_SUBSYS_DATA = 112,
	MYRB_CMD_SET_SUBSYS_PARAM = 113,
	MYRB_CMD_ENQUIRY_OLD = 5,
	MYRB_CMD_GET_DEVICE_STATE_OLD = 20,
	MYRB_CMD_READ_OLD = 2,
	MYRB_CMD_WRITE_OLD = 3,
	MYRB_CMD_READ_SG_OLD = 130,
	MYRB_CMD_WRITE_SG_OLD = 131,
} __attribute__((mode(byte)));

enum myrb_devstate {
	MYRB_DEVICE_DEAD = 0,
	MYRB_DEVICE_WO = 2,
	MYRB_DEVICE_ONLINE = 3,
	MYRB_DEVICE_CRITICAL = 4,
	MYRB_DEVICE_STANDBY = 16,
	MYRB_DEVICE_OFFLINE = 255,
} __attribute__((mode(byte)));

enum myrb_raidlevel {
	MYRB_RAID_LEVEL0 = 0,
	MYRB_RAID_LEVEL1 = 1,
	MYRB_RAID_LEVEL3 = 3,
	MYRB_RAID_LEVEL5 = 5,
	MYRB_RAID_LEVEL6 = 6,
	MYRB_RAID_JBOD = 7,
} __attribute__((mode(byte)));

enum myrs_cacheline_size {
	MYRS_CACHELINE_ZERO = 0,
	MYRS_CACHELINE_512B = 1,
	MYRS_CACHELINE_1K = 2,
	MYRS_CACHELINE_2K = 3,
	MYRS_CACHELINE_4K = 4,
	MYRS_CACHELINE_8K = 5,
	MYRS_CACHELINE_16K = 6,
	MYRS_CACHELINE_32K = 7,
	MYRS_CACHELINE_64K = 8,
} __attribute__((mode(byte)));

enum myrs_cmd_opcode {
	MYRS_CMD_OP_MEMCOPY = 1,
	MYRS_CMD_OP_SCSI_10_PASSTHRU = 2,
	MYRS_CMD_OP_SCSI_255_PASSTHRU = 3,
	MYRS_CMD_OP_SCSI_10 = 4,
	MYRS_CMD_OP_SCSI_256 = 5,
	MYRS_CMD_OP_IOCTL = 32,
} __attribute__((mode(byte)));

enum myrs_cpu_type {
	MYRS_CPUTYPE_i960CA = 1,
	MYRS_CPUTYPE_i960RD = 2,
	MYRS_CPUTYPE_i960RN = 3,
	MYRS_CPUTYPE_i960RP = 4,
	MYRS_CPUTYPE_NorthBay = 5,
	MYRS_CPUTYPE_StrongArm = 6,
	MYRS_CPUTYPE_i960RM = 7,
} __attribute__((mode(byte)));

enum myrs_devstate {
	MYRS_DEVICE_UNCONFIGURED = 0,
	MYRS_DEVICE_ONLINE = 1,
	MYRS_DEVICE_REBUILD = 3,
	MYRS_DEVICE_MISSING = 4,
	MYRS_DEVICE_SUSPECTED_CRITICAL = 5,
	MYRS_DEVICE_OFFLINE = 8,
	MYRS_DEVICE_CRITICAL = 9,
	MYRS_DEVICE_SUSPECTED_DEAD = 12,
	MYRS_DEVICE_COMMANDED_OFFLINE = 16,
	MYRS_DEVICE_STANDBY = 33,
	MYRS_DEVICE_INVALID_STATE = 255,
} __attribute__((mode(byte)));

enum myrs_ioctl_opcode {
	MYRS_IOCTL_GET_CTLR_INFO = 1,
	MYRS_IOCTL_GET_LDEV_INFO_VALID = 3,
	MYRS_IOCTL_GET_PDEV_INFO_VALID = 5,
	MYRS_IOCTL_GET_HEALTH_STATUS = 17,
	MYRS_IOCTL_GET_EVENT = 21,
	MYRS_IOCTL_START_DISCOVERY = 129,
	MYRS_IOCTL_SET_DEVICE_STATE = 130,
	MYRS_IOCTL_INIT_PDEV_START = 132,
	MYRS_IOCTL_INIT_PDEV_STOP = 133,
	MYRS_IOCTL_INIT_LDEV_START = 134,
	MYRS_IOCTL_INIT_LDEV_STOP = 135,
	MYRS_IOCTL_RBLD_DEVICE_START = 136,
	MYRS_IOCTL_RBLD_DEVICE_STOP = 137,
	MYRS_IOCTL_MAKE_CONSISTENT_START = 138,
	MYRS_IOCTL_MAKE_CONSISTENT_STOP = 139,
	MYRS_IOCTL_CC_START = 140,
	MYRS_IOCTL_CC_STOP = 141,
	MYRS_IOCTL_SET_MEM_MBOX = 142,
	MYRS_IOCTL_RESET_DEVICE = 144,
	MYRS_IOCTL_FLUSH_DEVICE_DATA = 145,
	MYRS_IOCTL_PAUSE_DEVICE = 146,
	MYRS_IOCTL_UNPAUS_EDEVICE = 147,
	MYRS_IOCTL_LOCATE_DEVICE = 148,
	MYRS_IOCTL_CREATE_CONFIGURATION = 192,
	MYRS_IOCTL_DELETE_LDEV = 193,
	MYRS_IOCTL_REPLACE_INTERNALDEVICE = 194,
	MYRS_IOCTL_RENAME_LDEV = 195,
	MYRS_IOCTL_ADD_CONFIGURATION = 196,
	MYRS_IOCTL_XLATE_PDEV_TO_LDEV = 197,
	MYRS_IOCTL_CLEAR_CONFIGURATION = 202,
} __attribute__((mode(byte)));

enum myrs_opdev {
	MYRS_PHYSICAL_DEVICE = 0,
	MYRS_RAID_DEVICE = 1,
	MYRS_PHYSICAL_CHANNEL = 2,
	MYRS_RAID_CHANNEL = 3,
	MYRS_PHYSICAL_CONTROLLER = 4,
	MYRS_RAID_CONTROLLER = 5,
	MYRS_CONFIGURATION_GROUP = 16,
	MYRS_ENCLOSURE = 17,
} __attribute__((mode(byte)));

enum myrs_raid_level {
	MYRS_RAID_LEVEL0 = 0,
	MYRS_RAID_LEVEL1 = 1,
	MYRS_RAID_LEVEL3 = 3,
	MYRS_RAID_LEVEL5 = 5,
	MYRS_RAID_LEVEL6 = 6,
	MYRS_RAID_JBOD = 7,
	MYRS_RAID_NEWSPAN = 8,
	MYRS_RAID_LEVEL3F = 9,
	MYRS_RAID_LEVEL3L = 11,
	MYRS_RAID_SPAN = 12,
	MYRS_RAID_LEVEL5L = 13,
	MYRS_RAID_LEVELE = 14,
	MYRS_RAID_PHYSICAL = 15,
} __attribute__((mode(byte)));

enum myrs_stripe_size {
	MYRS_STRIPE_SIZE_0 = 0,
	MYRS_STRIPE_SIZE_512B = 1,
	MYRS_STRIPE_SIZE_1K = 2,
	MYRS_STRIPE_SIZE_2K = 3,
	MYRS_STRIPE_SIZE_4K = 4,
	MYRS_STRIPE_SIZE_8K = 5,
	MYRS_STRIPE_SIZE_16K = 6,
	MYRS_STRIPE_SIZE_32K = 7,
	MYRS_STRIPE_SIZE_64K = 8,
	MYRS_STRIPE_SIZE_128K = 9,
	MYRS_STRIPE_SIZE_256K = 10,
	MYRS_STRIPE_SIZE_512K = 11,
	MYRS_STRIPE_SIZE_1M = 12,
} __attribute__((mode(byte)));

enum nbcon_prio {
	NBCON_PRIO_NONE = 0,
	NBCON_PRIO_NORMAL = 1,
	NBCON_PRIO_EMERGENCY = 2,
	NBCON_PRIO_PANIC = 3,
	NBCON_PRIO_MAX = 4,
};

enum ncq_saw_flag_list {
	ncq_saw_d2h = 1,
	ncq_saw_dmas = 2,
	ncq_saw_sdb = 4,
	ncq_saw_backout = 8,
};

enum ncsi_nl_attrs {
	NCSI_ATTR_UNSPEC = 0,
	NCSI_ATTR_IFINDEX = 1,
	NCSI_ATTR_PACKAGE_LIST = 2,
	NCSI_ATTR_PACKAGE_ID = 3,
	NCSI_ATTR_CHANNEL_ID = 4,
	NCSI_ATTR_DATA = 5,
	NCSI_ATTR_MULTI_FLAG = 6,
	NCSI_ATTR_PACKAGE_MASK = 7,
	NCSI_ATTR_CHANNEL_MASK = 8,
	__NCSI_ATTR_AFTER_LAST = 9,
	NCSI_ATTR_MAX = 8,
};

enum ncsi_nl_channel_attrs {
	NCSI_CHANNEL_ATTR_UNSPEC = 0,
	NCSI_CHANNEL_ATTR = 1,
	NCSI_CHANNEL_ATTR_ID = 2,
	NCSI_CHANNEL_ATTR_VERSION_MAJOR = 3,
	NCSI_CHANNEL_ATTR_VERSION_MINOR = 4,
	NCSI_CHANNEL_ATTR_VERSION_STR = 5,
	NCSI_CHANNEL_ATTR_LINK_STATE = 6,
	NCSI_CHANNEL_ATTR_ACTIVE = 7,
	NCSI_CHANNEL_ATTR_FORCED = 8,
	NCSI_CHANNEL_ATTR_VLAN_LIST = 9,
	NCSI_CHANNEL_ATTR_VLAN_ID = 10,
	__NCSI_CHANNEL_ATTR_AFTER_LAST = 11,
	NCSI_CHANNEL_ATTR_MAX = 10,
};

enum ncsi_nl_commands {
	NCSI_CMD_UNSPEC = 0,
	NCSI_CMD_PKG_INFO = 1,
	NCSI_CMD_SET_INTERFACE = 2,
	NCSI_CMD_CLEAR_INTERFACE = 3,
	NCSI_CMD_SEND_CMD = 4,
	NCSI_CMD_SET_PACKAGE_MASK = 5,
	NCSI_CMD_SET_CHANNEL_MASK = 6,
	__NCSI_CMD_AFTER_LAST = 7,
	NCSI_CMD_MAX = 6,
};

enum ncsi_nl_pkg_attrs {
	NCSI_PKG_ATTR_UNSPEC = 0,
	NCSI_PKG_ATTR = 1,
	NCSI_PKG_ATTR_ID = 2,
	NCSI_PKG_ATTR_FORCED = 3,
	NCSI_PKG_ATTR_CHANNEL_LIST = 4,
	__NCSI_PKG_ATTR_AFTER_LAST = 5,
	NCSI_PKG_ATTR_MAX = 4,
};

enum nemb_type {
	nemb_mse = 1,
	nemb_hbd = 2,
};

enum net_device_flags {
	IFF_UP = 1,
	IFF_BROADCAST = 2,
	IFF_DEBUG = 4,
	IFF_LOOPBACK = 8,
	IFF_POINTOPOINT = 16,
	IFF_NOTRAILERS = 32,
	IFF_RUNNING = 64,
	IFF_NOARP = 128,
	IFF_PROMISC = 256,
	IFF_ALLMULTI = 512,
	IFF_MASTER = 1024,
	IFF_SLAVE = 2048,
	IFF_MULTICAST = 4096,
	IFF_PORTSEL = 8192,
	IFF_AUTOMEDIA = 16384,
	IFF_DYNAMIC = 32768,
	IFF_LOWER_UP = 65536,
	IFF_DORMANT = 131072,
	IFF_ECHO = 262144,
};

enum net_device_path_type {
	DEV_PATH_ETHERNET = 0,
	DEV_PATH_VLAN = 1,
	DEV_PATH_BRIDGE = 2,
	DEV_PATH_PPPOE = 3,
	DEV_PATH_DSA = 4,
	DEV_PATH_MTK_WDMA = 5,
};

enum net_xmit_qdisc_t {
	__NET_XMIT_STOLEN = 65536,
	__NET_XMIT_BYPASS = 131072,
};

enum netdev_cmd {
	NETDEV_UP = 1,
	NETDEV_DOWN = 2,
	NETDEV_REBOOT = 3,
	NETDEV_CHANGE = 4,
	NETDEV_REGISTER = 5,
	NETDEV_UNREGISTER = 6,
	NETDEV_CHANGEMTU = 7,
	NETDEV_CHANGEADDR = 8,
	NETDEV_PRE_CHANGEADDR = 9,
	NETDEV_GOING_DOWN = 10,
	NETDEV_CHANGENAME = 11,
	NETDEV_FEAT_CHANGE = 12,
	NETDEV_BONDING_FAILOVER = 13,
	NETDEV_PRE_UP = 14,
	NETDEV_PRE_TYPE_CHANGE = 15,
	NETDEV_POST_TYPE_CHANGE = 16,
	NETDEV_POST_INIT = 17,
	NETDEV_PRE_UNINIT = 18,
	NETDEV_RELEASE = 19,
	NETDEV_NOTIFY_PEERS = 20,
	NETDEV_JOIN = 21,
	NETDEV_CHANGEUPPER = 22,
	NETDEV_RESEND_IGMP = 23,
	NETDEV_PRECHANGEMTU = 24,
	NETDEV_CHANGEINFODATA = 25,
	NETDEV_BONDING_INFO = 26,
	NETDEV_PRECHANGEUPPER = 27,
	NETDEV_CHANGELOWERSTATE = 28,
	NETDEV_UDP_TUNNEL_PUSH_INFO = 29,
	NETDEV_UDP_TUNNEL_DROP_INFO = 30,
	NETDEV_CHANGE_TX_QUEUE_LEN = 31,
	NETDEV_CVLAN_FILTER_PUSH_INFO = 32,
	NETDEV_CVLAN_FILTER_DROP_INFO = 33,
	NETDEV_SVLAN_FILTER_PUSH_INFO = 34,
	NETDEV_SVLAN_FILTER_DROP_INFO = 35,
	NETDEV_OFFLOAD_XSTATS_ENABLE = 36,
	NETDEV_OFFLOAD_XSTATS_DISABLE = 37,
	NETDEV_OFFLOAD_XSTATS_REPORT_USED = 38,
	NETDEV_OFFLOAD_XSTATS_REPORT_DELTA = 39,
	NETDEV_XDP_FEAT_CHANGE = 40,
};

enum netdev_lag_hash {
	NETDEV_LAG_HASH_NONE = 0,
	NETDEV_LAG_HASH_L2 = 1,
	NETDEV_LAG_HASH_L34 = 2,
	NETDEV_LAG_HASH_L23 = 3,
	NETDEV_LAG_HASH_E23 = 4,
	NETDEV_LAG_HASH_E34 = 5,
	NETDEV_LAG_HASH_VLAN_SRCMAC = 6,
	NETDEV_LAG_HASH_UNKNOWN = 7,
};

enum netdev_lag_tx_type {
	NETDEV_LAG_TX_TYPE_UNKNOWN = 0,
	NETDEV_LAG_TX_TYPE_RANDOM = 1,
	NETDEV_LAG_TX_TYPE_BROADCAST = 2,
	NETDEV_LAG_TX_TYPE_ROUNDROBIN = 3,
	NETDEV_LAG_TX_TYPE_ACTIVEBACKUP = 4,
	NETDEV_LAG_TX_TYPE_HASH = 5,
};

enum netdev_ml_priv_type {
	ML_PRIV_NONE = 0,
	ML_PRIV_CAN = 1,
};

enum netdev_offload_xstats_type {
	NETDEV_OFFLOAD_XSTATS_TYPE_L3 = 1,
};

enum netdev_priv_flags {
	IFF_802_1Q_VLAN = 1ULL,
	IFF_EBRIDGE = 2ULL,
	IFF_BONDING = 4ULL,
	IFF_ISATAP = 8ULL,
	IFF_WAN_HDLC = 16ULL,
	IFF_XMIT_DST_RELEASE = 32ULL,
	IFF_DONT_BRIDGE = 64ULL,
	IFF_DISABLE_NETPOLL = 128ULL,
	IFF_MACVLAN_PORT = 256ULL,
	IFF_BRIDGE_PORT = 512ULL,
	IFF_OVS_DATAPATH = 1024ULL,
	IFF_TX_SKB_SHARING = 2048ULL,
	IFF_UNICAST_FLT = 4096ULL,
	IFF_TEAM_PORT = 8192ULL,
	IFF_SUPP_NOFCS = 16384ULL,
	IFF_LIVE_ADDR_CHANGE = 32768ULL,
	IFF_MACVLAN = 65536ULL,
	IFF_XMIT_DST_RELEASE_PERM = 131072ULL,
	IFF_L3MDEV_MASTER = 262144ULL,
	IFF_NO_QUEUE = 524288ULL,
	IFF_OPENVSWITCH = 1048576ULL,
	IFF_L3MDEV_SLAVE = 2097152ULL,
	IFF_TEAM = 4194304ULL,
	IFF_RXFH_CONFIGURED = 8388608ULL,
	IFF_PHONY_HEADROOM = 16777216ULL,
	IFF_MACSEC = 33554432ULL,
	IFF_NO_RX_HANDLER = 67108864ULL,
	IFF_FAILOVER = 134217728ULL,
	IFF_FAILOVER_SLAVE = 268435456ULL,
	IFF_L3MDEV_RX_HANDLER = 536870912ULL,
	IFF_NO_ADDRCONF = 1073741824ULL,
	IFF_TX_SKB_NO_LINEAR = 2147483648ULL,
	IFF_CHANGE_PROTO_DOWN = 4294967296ULL,
	IFF_SEE_ALL_HWTSTAMP_REQUESTS = 8589934592ULL,
};

enum netdev_qstats_scope {
	NETDEV_QSTATS_SCOPE_QUEUE = 1,
};

enum netdev_queue_state_t {
	__QUEUE_STATE_DRV_XOFF = 0,
	__QUEUE_STATE_STACK_XOFF = 1,
	__QUEUE_STATE_FROZEN = 2,
};

enum netdev_queue_type {
	NETDEV_QUEUE_TYPE_RX = 0,
	NETDEV_QUEUE_TYPE_TX = 1,
};

enum netdev_reg_state {
	NETREG_UNINITIALIZED = 0,
	NETREG_REGISTERED = 1,
	NETREG_UNREGISTERING = 2,
	NETREG_UNREGISTERED = 3,
	NETREG_RELEASED = 4,
	NETREG_DUMMY = 5,
};

enum netdev_stat_type {
	NETDEV_PCPU_STAT_NONE = 0,
	NETDEV_PCPU_STAT_LSTATS = 1,
	NETDEV_PCPU_STAT_TSTATS = 2,
	NETDEV_PCPU_STAT_DSTATS = 3,
};

enum netdev_state_t {
	__LINK_STATE_START = 0,
	__LINK_STATE_PRESENT = 1,
	__LINK_STATE_NOCARRIER = 2,
	__LINK_STATE_LINKWATCH_PENDING = 3,
	__LINK_STATE_DORMANT = 4,
	__LINK_STATE_TESTING = 5,
};

enum netdev_tx {
	__NETDEV_TX_MIN = -2147483648,
	NETDEV_TX_OK = 0,
	NETDEV_TX_BUSY = 16,
};

typedef enum netdev_tx netdev_tx_t;

enum netdev_xdp_act {
	NETDEV_XDP_ACT_BASIC = 1,
	NETDEV_XDP_ACT_REDIRECT = 2,
	NETDEV_XDP_ACT_NDO_XMIT = 4,
	NETDEV_XDP_ACT_XSK_ZEROCOPY = 8,
	NETDEV_XDP_ACT_HW_OFFLOAD = 16,
	NETDEV_XDP_ACT_RX_SG = 32,
	NETDEV_XDP_ACT_NDO_XMIT_SG = 64,
	NETDEV_XDP_ACT_MASK = 127,
};

enum netdev_xdp_rx_metadata {
	NETDEV_XDP_RX_METADATA_TIMESTAMP = 1,
	NETDEV_XDP_RX_METADATA_HASH = 2,
	NETDEV_XDP_RX_METADATA_VLAN_TAG = 4,
};

enum netdev_xsk_flags {
	NETDEV_XSK_FLAGS_TX_TIMESTAMP = 1,
	NETDEV_XSK_FLAGS_TX_CHECKSUM = 2,
};

enum netevent_notif_type {
	NETEVENT_NEIGH_UPDATE = 1,
	NETEVENT_REDIRECT = 2,
	NETEVENT_DELAY_PROBE_TIME_UPDATE = 3,
	NETEVENT_IPV4_MPATH_HASH_UPDATE = 4,
	NETEVENT_IPV6_MPATH_HASH_UPDATE = 5,
	NETEVENT_IPV4_FWD_UPDATE_PRIORITY_UPDATE = 6,
};

enum netkit_action {
	NETKIT_NEXT = -1,
	NETKIT_PASS = 0,
	NETKIT_DROP = 2,
	NETKIT_REDIRECT = 7,
};

enum netkit_mode {
	NETKIT_L2 = 0,
	NETKIT_L3 = 1,
};

enum netlink_attribute_type {
	NL_ATTR_TYPE_INVALID = 0,
	NL_ATTR_TYPE_FLAG = 1,
	NL_ATTR_TYPE_U8 = 2,
	NL_ATTR_TYPE_U16 = 3,
	NL_ATTR_TYPE_U32 = 4,
	NL_ATTR_TYPE_U64 = 5,
	NL_ATTR_TYPE_S8 = 6,
	NL_ATTR_TYPE_S16 = 7,
	NL_ATTR_TYPE_S32 = 8,
	NL_ATTR_TYPE_S64 = 9,
	NL_ATTR_TYPE_BINARY = 10,
	NL_ATTR_TYPE_STRING = 11,
	NL_ATTR_TYPE_NUL_STRING = 12,
	NL_ATTR_TYPE_NESTED = 13,
	NL_ATTR_TYPE_NESTED_ARRAY = 14,
	NL_ATTR_TYPE_BITFIELD32 = 15,
	NL_ATTR_TYPE_SINT = 16,
	NL_ATTR_TYPE_UINT = 17,
};

enum netlink_policy_type_attr {
	NL_POLICY_TYPE_ATTR_UNSPEC = 0,
	NL_POLICY_TYPE_ATTR_TYPE = 1,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_S = 2,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_S = 3,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_U = 4,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_U = 5,
	NL_POLICY_TYPE_ATTR_MIN_LENGTH = 6,
	NL_POLICY_TYPE_ATTR_MAX_LENGTH = 7,
	NL_POLICY_TYPE_ATTR_POLICY_IDX = 8,
	NL_POLICY_TYPE_ATTR_POLICY_MAXTYPE = 9,
	NL_POLICY_TYPE_ATTR_BITFIELD32_MASK = 10,
	NL_POLICY_TYPE_ATTR_PAD = 11,
	NL_POLICY_TYPE_ATTR_MASK = 12,
	__NL_POLICY_TYPE_ATTR_MAX = 13,
	NL_POLICY_TYPE_ATTR_MAX = 12,
};

enum netlink_skb_flags {
	NETLINK_SKB_DST = 8,
};

enum netlink_validation {
	NL_VALIDATE_LIBERAL = 0,
	NL_VALIDATE_TRAILING = 1,
	NL_VALIDATE_MAXTYPE = 2,
	NL_VALIDATE_UNSPEC = 4,
	NL_VALIDATE_STRICT_ATTRS = 8,
	NL_VALIDATE_NESTED = 16,
};

enum netns_bpf_attach_type {
	NETNS_BPF_INVALID = -1,
	NETNS_BPF_FLOW_DISSECTOR = 0,
	NETNS_BPF_SK_LOOKUP = 1,
	MAX_NETNS_BPF_ATTACH_TYPE = 2,
};

enum nexthop_event_type {
	NEXTHOP_EVENT_DEL = 0,
	NEXTHOP_EVENT_REPLACE = 1,
	NEXTHOP_EVENT_RES_TABLE_PRE_REPLACE = 2,
	NEXTHOP_EVENT_BUCKET_REPLACE = 3,
	NEXTHOP_EVENT_HW_STATS_REPORT_DELTA = 4,
};

enum nexus_wait_type {
	WAIT_HOST = 0,
	WAIT_TARGET = 1,
	WAIT_LUN = 2,
};

enum nf_ct_ext_id {
	NF_CT_EXT_HELPER = 0,
	NF_CT_EXT_NAT = 1,
	NF_CT_EXT_SEQADJ = 2,
	NF_CT_EXT_ACCT = 3,
	NF_CT_EXT_ECACHE = 4,
	NF_CT_EXT_TSTAMP = 5,
	NF_CT_EXT_TIMEOUT = 6,
	NF_CT_EXT_LABELS = 7,
	NF_CT_EXT_SYNPROXY = 8,
	NF_CT_EXT_ACT_CT = 9,
	NF_CT_EXT_NUM = 10,
};

enum nf_dev_hooks {
	NF_NETDEV_INGRESS = 0,
	NF_NETDEV_EGRESS = 1,
	NF_NETDEV_NUMHOOKS = 2,
};

enum nf_hook_ops_type {
	NF_HOOK_OP_UNDEFINED = 0,
	NF_HOOK_OP_NF_TABLES = 1,
	NF_HOOK_OP_BPF = 2,
};

enum nf_inet_hooks {
	NF_INET_PRE_ROUTING = 0,
	NF_INET_LOCAL_IN = 1,
	NF_INET_FORWARD = 2,
	NF_INET_LOCAL_OUT = 3,
	NF_INET_POST_ROUTING = 4,
	NF_INET_NUMHOOKS = 5,
	NF_INET_INGRESS = 5,
};

enum nf_ip6_hook_priorities {
	NF_IP6_PRI_FIRST = -2147483648,
	NF_IP6_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP6_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP6_PRI_RAW = -300,
	NF_IP6_PRI_SELINUX_FIRST = -225,
	NF_IP6_PRI_CONNTRACK = -200,
	NF_IP6_PRI_MANGLE = -150,
	NF_IP6_PRI_NAT_DST = -100,
	NF_IP6_PRI_FILTER = 0,
	NF_IP6_PRI_SECURITY = 50,
	NF_IP6_PRI_NAT_SRC = 100,
	NF_IP6_PRI_SELINUX_LAST = 225,
	NF_IP6_PRI_CONNTRACK_HELPER = 300,
	NF_IP6_PRI_LAST = 2147483647,
};

enum nf_ip_hook_priorities {
	NF_IP_PRI_FIRST = -2147483648,
	NF_IP_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP_PRI_RAW = -300,
	NF_IP_PRI_SELINUX_FIRST = -225,
	NF_IP_PRI_CONNTRACK = -200,
	NF_IP_PRI_MANGLE = -150,
	NF_IP_PRI_NAT_DST = -100,
	NF_IP_PRI_FILTER = 0,
	NF_IP_PRI_SECURITY = 50,
	NF_IP_PRI_NAT_SRC = 100,
	NF_IP_PRI_SELINUX_LAST = 225,
	NF_IP_PRI_CONNTRACK_HELPER = 300,
	NF_IP_PRI_CONNTRACK_CONFIRM = 2147483647,
	NF_IP_PRI_LAST = 2147483647,
};

enum nf_log_type {
	NF_LOG_TYPE_LOG = 0,
	NF_LOG_TYPE_ULOG = 1,
	NF_LOG_TYPE_MAX = 2,
};

enum nf_nat_manip_type;

enum nfs3_stable_how {
	NFS_UNSTABLE = 0,
	NFS_DATA_SYNC = 1,
	NFS_FILE_SYNC = 2,
	NFS_INVALID_STABLE_HOW = -1,
};

enum nfs4_change_attr_type {
	NFS4_CHANGE_TYPE_IS_MONOTONIC_INCR = 0,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER = 1,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER_NOPNFS = 2,
	NFS4_CHANGE_TYPE_IS_TIME_METADATA = 3,
	NFS4_CHANGE_TYPE_IS_UNDEFINED = 4,
};

enum nfs_opnum4 {
	OP_ACCESS = 3,
	OP_CLOSE = 4,
	OP_COMMIT = 5,
	OP_CREATE = 6,
	OP_DELEGPURGE = 7,
	OP_DELEGRETURN = 8,
	OP_GETATTR = 9,
	OP_GETFH = 10,
	OP_LINK = 11,
	OP_LOCK = 12,
	OP_LOCKT = 13,
	OP_LOCKU = 14,
	OP_LOOKUP = 15,
	OP_LOOKUPP = 16,
	OP_NVERIFY = 17,
	OP_OPEN = 18,
	OP_OPENATTR = 19,
	OP_OPEN_CONFIRM = 20,
	OP_OPEN_DOWNGRADE = 21,
	OP_PUTFH = 22,
	OP_PUTPUBFH = 23,
	OP_PUTROOTFH = 24,
	OP_READ = 25,
	OP_READDIR = 26,
	OP_READLINK = 27,
	OP_REMOVE = 28,
	OP_RENAME = 29,
	OP_RENEW = 30,
	OP_RESTOREFH = 31,
	OP_SAVEFH = 32,
	OP_SECINFO = 33,
	OP_SETATTR = 34,
	OP_SETCLIENTID = 35,
	OP_SETCLIENTID_CONFIRM = 36,
	OP_VERIFY = 37,
	OP_WRITE = 38,
	OP_RELEASE_LOCKOWNER = 39,
	OP_BACKCHANNEL_CTL = 40,
	OP_BIND_CONN_TO_SESSION = 41,
	OP_EXCHANGE_ID = 42,
	OP_CREATE_SESSION = 43,
	OP_DESTROY_SESSION = 44,
	OP_FREE_STATEID = 45,
	OP_GET_DIR_DELEGATION = 46,
	OP_GETDEVICEINFO = 47,
	OP_GETDEVICELIST = 48,
	OP_LAYOUTCOMMIT = 49,
	OP_LAYOUTGET = 50,
	OP_LAYOUTRETURN = 51,
	OP_SECINFO_NO_NAME = 52,
	OP_SEQUENCE = 53,
	OP_SET_SSV = 54,
	OP_TEST_STATEID = 55,
	OP_WANT_DELEGATION = 56,
	OP_DESTROY_CLIENTID = 57,
	OP_RECLAIM_COMPLETE = 58,
	OP_ALLOCATE = 59,
	OP_COPY = 60,
	OP_COPY_NOTIFY = 61,
	OP_DEALLOCATE = 62,
	OP_IO_ADVISE = 63,
	OP_LAYOUTERROR = 64,
	OP_LAYOUTSTATS = 65,
	OP_OFFLOAD_CANCEL = 66,
	OP_OFFLOAD_STATUS = 67,
	OP_READ_PLUS = 68,
	OP_SEEK = 69,
	OP_WRITE_SAME = 70,
	OP_CLONE = 71,
	OP_GETXATTR = 72,
	OP_SETXATTR = 73,
	OP_LISTXATTRS = 74,
	OP_REMOVEXATTR = 75,
	OP_ILLEGAL = 10044,
};

enum nh_notifier_info_type {
	NH_NOTIFIER_INFO_TYPE_SINGLE = 0,
	NH_NOTIFIER_INFO_TYPE_GRP = 1,
	NH_NOTIFIER_INFO_TYPE_RES_TABLE = 2,
	NH_NOTIFIER_INFO_TYPE_RES_BUCKET = 3,
	NH_NOTIFIER_INFO_TYPE_GRP_HW_STATS = 4,
};

enum nl80211_auth_type {
	NL80211_AUTHTYPE_OPEN_SYSTEM = 0,
	NL80211_AUTHTYPE_SHARED_KEY = 1,
	NL80211_AUTHTYPE_FT = 2,
	NL80211_AUTHTYPE_NETWORK_EAP = 3,
	NL80211_AUTHTYPE_SAE = 4,
	NL80211_AUTHTYPE_FILS_SK = 5,
	NL80211_AUTHTYPE_FILS_SK_PFS = 6,
	NL80211_AUTHTYPE_FILS_PK = 7,
	__NL80211_AUTHTYPE_NUM = 8,
	NL80211_AUTHTYPE_MAX = 7,
	NL80211_AUTHTYPE_AUTOMATIC = 8,
};

enum nl80211_band {
	NL80211_BAND_2GHZ = 0,
	NL80211_BAND_5GHZ = 1,
	NL80211_BAND_60GHZ = 2,
	NL80211_BAND_6GHZ = 3,
	NL80211_BAND_S1GHZ = 4,
	NL80211_BAND_LC = 5,
	NUM_NL80211_BANDS = 6,
};

enum nl80211_bss_select_attr {
	__NL80211_BSS_SELECT_ATTR_INVALID = 0,
	NL80211_BSS_SELECT_ATTR_RSSI = 1,
	NL80211_BSS_SELECT_ATTR_BAND_PREF = 2,
	NL80211_BSS_SELECT_ATTR_RSSI_ADJUST = 3,
	__NL80211_BSS_SELECT_ATTR_AFTER_LAST = 4,
	NL80211_BSS_SELECT_ATTR_MAX = 3,
};

enum nl80211_chan_width {
	NL80211_CHAN_WIDTH_20_NOHT = 0,
	NL80211_CHAN_WIDTH_20 = 1,
	NL80211_CHAN_WIDTH_40 = 2,
	NL80211_CHAN_WIDTH_80 = 3,
	NL80211_CHAN_WIDTH_80P80 = 4,
	NL80211_CHAN_WIDTH_160 = 5,
	NL80211_CHAN_WIDTH_5 = 6,
	NL80211_CHAN_WIDTH_10 = 7,
	NL80211_CHAN_WIDTH_1 = 8,
	NL80211_CHAN_WIDTH_2 = 9,
	NL80211_CHAN_WIDTH_4 = 10,
	NL80211_CHAN_WIDTH_8 = 11,
	NL80211_CHAN_WIDTH_16 = 12,
	NL80211_CHAN_WIDTH_320 = 13,
};

enum nl80211_dfs_regions {
	NL80211_DFS_UNSET = 0,
	NL80211_DFS_FCC = 1,
	NL80211_DFS_ETSI = 2,
	NL80211_DFS_JP = 3,
};

enum nl80211_dfs_state {
	NL80211_DFS_USABLE = 0,
	NL80211_DFS_UNAVAILABLE = 1,
	NL80211_DFS_AVAILABLE = 2,
};

enum nl80211_ext_feature_index {
	NL80211_EXT_FEATURE_VHT_IBSS = 0,
	NL80211_EXT_FEATURE_RRM = 1,
	NL80211_EXT_FEATURE_MU_MIMO_AIR_SNIFFER = 2,
	NL80211_EXT_FEATURE_SCAN_START_TIME = 3,
	NL80211_EXT_FEATURE_BSS_PARENT_TSF = 4,
	NL80211_EXT_FEATURE_SET_SCAN_DWELL = 5,
	NL80211_EXT_FEATURE_BEACON_RATE_LEGACY = 6,
	NL80211_EXT_FEATURE_BEACON_RATE_HT = 7,
	NL80211_EXT_FEATURE_BEACON_RATE_VHT = 8,
	NL80211_EXT_FEATURE_FILS_STA = 9,
	NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA = 10,
	NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA_CONNECTED = 11,
	NL80211_EXT_FEATURE_SCHED_SCAN_RELATIVE_RSSI = 12,
	NL80211_EXT_FEATURE_CQM_RSSI_LIST = 13,
	NL80211_EXT_FEATURE_FILS_SK_OFFLOAD = 14,
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_PSK = 15,
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_1X = 16,
	NL80211_EXT_FEATURE_FILS_MAX_CHANNEL_TIME = 17,
	NL80211_EXT_FEATURE_ACCEPT_BCAST_PROBE_RESP = 18,
	NL80211_EXT_FEATURE_OCE_PROBE_REQ_HIGH_TX_RATE = 19,
	NL80211_EXT_FEATURE_OCE_PROBE_REQ_DEFERRAL_SUPPRESSION = 20,
	NL80211_EXT_FEATURE_MFP_OPTIONAL = 21,
	NL80211_EXT_FEATURE_LOW_SPAN_SCAN = 22,
	NL80211_EXT_FEATURE_LOW_POWER_SCAN = 23,
	NL80211_EXT_FEATURE_HIGH_ACCURACY_SCAN = 24,
	NL80211_EXT_FEATURE_DFS_OFFLOAD = 25,
	NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211 = 26,
	NL80211_EXT_FEATURE_ACK_SIGNAL_SUPPORT = 27,
	NL80211_EXT_FEATURE_DATA_ACK_SIGNAL_SUPPORT = 27,
	NL80211_EXT_FEATURE_TXQS = 28,
	NL80211_EXT_FEATURE_SCAN_RANDOM_SN = 29,
	NL80211_EXT_FEATURE_SCAN_MIN_PREQ_CONTENT = 30,
	NL80211_EXT_FEATURE_CAN_REPLACE_PTK0 = 31,
	NL80211_EXT_FEATURE_ENABLE_FTM_RESPONDER = 32,
	NL80211_EXT_FEATURE_AIRTIME_FAIRNESS = 33,
	NL80211_EXT_FEATURE_AP_PMKSA_CACHING = 34,
	NL80211_EXT_FEATURE_SCHED_SCAN_BAND_SPECIFIC_RSSI_THOLD = 35,
	NL80211_EXT_FEATURE_EXT_KEY_ID = 36,
	NL80211_EXT_FEATURE_STA_TX_PWR = 37,
	NL80211_EXT_FEATURE_SAE_OFFLOAD = 38,
	NL80211_EXT_FEATURE_VLAN_OFFLOAD = 39,
	NL80211_EXT_FEATURE_AQL = 40,
	NL80211_EXT_FEATURE_BEACON_PROTECTION = 41,
	NL80211_EXT_FEATURE_CONTROL_PORT_NO_PREAUTH = 42,
	NL80211_EXT_FEATURE_PROTECTED_TWT = 43,
	NL80211_EXT_FEATURE_DEL_IBSS_STA = 44,
	NL80211_EXT_FEATURE_MULTICAST_REGISTRATIONS = 45,
	NL80211_EXT_FEATURE_BEACON_PROTECTION_CLIENT = 46,
	NL80211_EXT_FEATURE_SCAN_FREQ_KHZ = 47,
	NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211_TX_STATUS = 48,
	NL80211_EXT_FEATURE_OPERATING_CHANNEL_VALIDATION = 49,
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_AP_PSK = 50,
	NL80211_EXT_FEATURE_SAE_OFFLOAD_AP = 51,
	NL80211_EXT_FEATURE_FILS_DISCOVERY = 52,
	NL80211_EXT_FEATURE_UNSOL_BCAST_PROBE_RESP = 53,
	NL80211_EXT_FEATURE_BEACON_RATE_HE = 54,
	NL80211_EXT_FEATURE_SECURE_LTF = 55,
	NL80211_EXT_FEATURE_SECURE_RTT = 56,
	NL80211_EXT_FEATURE_PROT_RANGE_NEGO_AND_MEASURE = 57,
	NL80211_EXT_FEATURE_BSS_COLOR = 58,
	NL80211_EXT_FEATURE_FILS_CRYPTO_OFFLOAD = 59,
	NL80211_EXT_FEATURE_RADAR_BACKGROUND = 60,
	NL80211_EXT_FEATURE_POWERED_ADDR_CHANGE = 61,
	NL80211_EXT_FEATURE_PUNCT = 62,
	NL80211_EXT_FEATURE_SECURE_NAN = 63,
	NL80211_EXT_FEATURE_AUTH_AND_DEAUTH_RANDOM_TA = 64,
	NL80211_EXT_FEATURE_OWE_OFFLOAD = 65,
	NL80211_EXT_FEATURE_OWE_OFFLOAD_AP = 66,
	NL80211_EXT_FEATURE_DFS_CONCURRENT = 67,
	NL80211_EXT_FEATURE_SPP_AMSDU_SUPPORT = 68,
	NUM_NL80211_EXT_FEATURES = 69,
	MAX_NL80211_EXT_FEATURES = 68,
};

enum nl80211_iftype {
	NL80211_IFTYPE_UNSPECIFIED = 0,
	NL80211_IFTYPE_ADHOC = 1,
	NL80211_IFTYPE_STATION = 2,
	NL80211_IFTYPE_AP = 3,
	NL80211_IFTYPE_AP_VLAN = 4,
	NL80211_IFTYPE_WDS = 5,
	NL80211_IFTYPE_MONITOR = 6,
	NL80211_IFTYPE_MESH_POINT = 7,
	NL80211_IFTYPE_P2P_CLIENT = 8,
	NL80211_IFTYPE_P2P_GO = 9,
	NL80211_IFTYPE_P2P_DEVICE = 10,
	NL80211_IFTYPE_OCB = 11,
	NL80211_IFTYPE_NAN = 12,
	NUM_NL80211_IFTYPES = 13,
	NL80211_IFTYPE_MAX = 12,
};

enum nl80211_key_mode {
	NL80211_KEY_RX_TX = 0,
	NL80211_KEY_NO_TX = 1,
	NL80211_KEY_SET_TX = 2,
};

enum nl80211_mfp {
	NL80211_MFP_NO = 0,
	NL80211_MFP_REQUIRED = 1,
	NL80211_MFP_OPTIONAL = 2,
};

enum nl80211_mntr_flags {
	__NL80211_MNTR_FLAG_INVALID = 0,
	NL80211_MNTR_FLAG_FCSFAIL = 1,
	NL80211_MNTR_FLAG_PLCPFAIL = 2,
	NL80211_MNTR_FLAG_CONTROL = 3,
	NL80211_MNTR_FLAG_OTHER_BSS = 4,
	NL80211_MNTR_FLAG_COOK_FRAMES = 5,
	NL80211_MNTR_FLAG_ACTIVE = 6,
	__NL80211_MNTR_FLAG_AFTER_LAST = 7,
	NL80211_MNTR_FLAG_MAX = 6,
};

enum nl80211_reg_initiator {
	NL80211_REGDOM_SET_BY_CORE = 0,
	NL80211_REGDOM_SET_BY_USER = 1,
	NL80211_REGDOM_SET_BY_DRIVER = 2,
	NL80211_REGDOM_SET_BY_COUNTRY_IE = 3,
};

enum nl80211_sae_pwe_mechanism {
	NL80211_SAE_PWE_UNSPECIFIED = 0,
	NL80211_SAE_PWE_HUNT_AND_PECK = 1,
	NL80211_SAE_PWE_HASH_TO_ELEMENT = 2,
	NL80211_SAE_PWE_BOTH = 3,
};

enum nl80211_sar_type {
	NL80211_SAR_TYPE_POWER = 0,
	NUM_NL80211_SAR_TYPE = 1,
};

enum nl80211_user_reg_hint_type {
	NL80211_USER_REG_HINT_USER = 0,
	NL80211_USER_REG_HINT_CELL_BASE = 1,
	NL80211_USER_REG_HINT_INDOOR = 2,
};

enum nl802154_cca_modes {
	__NL802154_CCA_INVALID = 0,
	NL802154_CCA_ENERGY = 1,
	NL802154_CCA_CARRIER = 2,
	NL802154_CCA_ENERGY_CARRIER = 3,
	NL802154_CCA_ALOHA = 4,
	NL802154_CCA_UWB_SHR = 5,
	NL802154_CCA_UWB_MULTIPLEXED = 6,
	__NL802154_CCA_ATTR_AFTER_LAST = 7,
	NL802154_CCA_ATTR_MAX = 6,
};

enum nl802154_cca_opts {
	NL802154_CCA_OPT_ENERGY_CARRIER_AND = 0,
	NL802154_CCA_OPT_ENERGY_CARRIER_OR = 1,
	__NL802154_CCA_OPT_ATTR_AFTER_LAST = 2,
	NL802154_CCA_OPT_ATTR_MAX = 1,
};

enum nl802154_supported_bool_states {
	NL802154_SUPPORTED_BOOL_FALSE = 0,
	NL802154_SUPPORTED_BOOL_TRUE = 1,
	__NL802154_SUPPORTED_BOOL_INVALD = 2,
	NL802154_SUPPORTED_BOOL_BOTH = 3,
	__NL802154_SUPPORTED_BOOL_AFTER_LAST = 4,
	NL802154_SUPPORTED_BOOL_MAX = 3,
};

enum nla_policy_validation {
	NLA_VALIDATE_NONE = 0,
	NLA_VALIDATE_RANGE = 1,
	NLA_VALIDATE_RANGE_WARN_TOO_LONG = 2,
	NLA_VALIDATE_MIN = 3,
	NLA_VALIDATE_MAX = 4,
	NLA_VALIDATE_MASK = 5,
	NLA_VALIDATE_RANGE_PTR = 6,
	NLA_VALIDATE_FUNCTION = 7,
};

enum nlmsgerr_attrs {
	NLMSGERR_ATTR_UNUSED = 0,
	NLMSGERR_ATTR_MSG = 1,
	NLMSGERR_ATTR_OFFS = 2,
	NLMSGERR_ATTR_COOKIE = 3,
	NLMSGERR_ATTR_POLICY = 4,
	NLMSGERR_ATTR_MISS_TYPE = 5,
	NLMSGERR_ATTR_MISS_NEST = 6,
	__NLMSGERR_ATTR_MAX = 7,
	NLMSGERR_ATTR_MAX = 6,
};

enum node_stat_item {
	NR_LRU_BASE = 0,
	NR_INACTIVE_ANON = 0,
	NR_ACTIVE_ANON = 1,
	NR_INACTIVE_FILE = 2,
	NR_ACTIVE_FILE = 3,
	NR_UNEVICTABLE = 4,
	NR_SLAB_RECLAIMABLE_B = 5,
	NR_SLAB_UNRECLAIMABLE_B = 6,
	NR_ISOLATED_ANON = 7,
	NR_ISOLATED_FILE = 8,
	WORKINGSET_NODES = 9,
	WORKINGSET_REFAULT_BASE = 10,
	WORKINGSET_REFAULT_ANON = 10,
	WORKINGSET_REFAULT_FILE = 11,
	WORKINGSET_ACTIVATE_BASE = 12,
	WORKINGSET_ACTIVATE_ANON = 12,
	WORKINGSET_ACTIVATE_FILE = 13,
	WORKINGSET_RESTORE_BASE = 14,
	WORKINGSET_RESTORE_ANON = 14,
	WORKINGSET_RESTORE_FILE = 15,
	WORKINGSET_NODERECLAIM = 16,
	NR_ANON_MAPPED = 17,
	NR_FILE_MAPPED = 18,
	NR_FILE_PAGES = 19,
	NR_FILE_DIRTY = 20,
	NR_WRITEBACK = 21,
	NR_WRITEBACK_TEMP = 22,
	NR_SHMEM = 23,
	NR_SHMEM_THPS = 24,
	NR_SHMEM_PMDMAPPED = 25,
	NR_FILE_THPS = 26,
	NR_FILE_PMDMAPPED = 27,
	NR_ANON_THPS = 28,
	NR_VMSCAN_WRITE = 29,
	NR_VMSCAN_IMMEDIATE = 30,
	NR_DIRTIED = 31,
	NR_WRITTEN = 32,
	NR_THROTTLED_WRITTEN = 33,
	NR_KERNEL_MISC_RECLAIMABLE = 34,
	NR_FOLL_PIN_ACQUIRED = 35,
	NR_FOLL_PIN_RELEASED = 36,
	NR_KERNEL_STACK_KB = 37,
	NR_PAGETABLE = 38,
	NR_SECONDARY_PAGETABLE = 39,
	NR_IOMMU_PAGES = 40,
	NR_SWAPCACHE = 41,
	PGPROMOTE_SUCCESS = 42,
	PGPROMOTE_CANDIDATE = 43,
	PGDEMOTE_KSWAPD = 44,
	PGDEMOTE_DIRECT = 45,
	PGDEMOTE_KHUGEPAGED = 46,
	NR_VM_NODE_STAT_ITEMS = 47,
};

enum node_states {
	N_POSSIBLE = 0,
	N_ONLINE = 1,
	N_NORMAL_MEMORY = 2,
	N_HIGH_MEMORY = 2,
	N_MEMORY = 3,
	N_CPU = 4,
	N_GENERIC_INITIATOR = 5,
	NR_NODE_STATES = 6,
};

enum notify_state {
	SECCOMP_NOTIFY_INIT = 0,
	SECCOMP_NOTIFY_SENT = 1,
	SECCOMP_NOTIFY_REPLIED = 2,
};

enum numa_faults_stats {
	NUMA_MEM = 0,
	NUMA_CPU = 1,
	NUMA_MEMBUF = 2,
	NUMA_CPUBUF = 3,
};

enum numa_stat_item {
	NUMA_HIT = 0,
	NUMA_MISS = 1,
	NUMA_FOREIGN = 2,
	NUMA_INTERLEAVE_HIT = 3,
	NUMA_LOCAL = 4,
	NUMA_OTHER = 5,
	NR_VM_NUMA_EVENT_ITEMS = 6,
};

enum numa_topology_type {
	NUMA_DIRECT = 0,
	NUMA_GLUELESS_MESH = 1,
	NUMA_BACKPLANE = 2,
};

enum numa_type {
	node_has_spare = 0,
	node_fully_busy = 1,
	node_overloaded = 2,
};

enum numa_vmaskip_reason {
	NUMAB_SKIP_UNSUITABLE = 0,
	NUMAB_SKIP_SHARED_RO = 1,
	NUMAB_SKIP_INACCESSIBLE = 2,
	NUMAB_SKIP_SCAN_DELAY = 3,
	NUMAB_SKIP_PID_INACTIVE = 4,
	NUMAB_SKIP_IGNORE_PID = 5,
	NUMAB_SKIP_SEQ_COMPLETED = 6,
};

enum nv_adma_regbits {
	CMDEND = 32768,
	WNB = 16384,
	IGN = 8192,
	CS1n = 4096,
	DA2 = 1024,
	DA1 = 512,
	DA0 = 256,
};

enum nv_host_type {
	GENERIC = 0,
	NFORCE2 = 1,
	NFORCE3 = 1,
	CK804 = 2,
	ADMA = 3,
	MCP5x = 4,
	SWNCQ = 5,
};

enum nvme_admin_opcode {
	nvme_admin_delete_sq = 0,
	nvme_admin_create_sq = 1,
	nvme_admin_get_log_page = 2,
	nvme_admin_delete_cq = 4,
	nvme_admin_create_cq = 5,
	nvme_admin_identify = 6,
	nvme_admin_abort_cmd = 8,
	nvme_admin_set_features = 9,
	nvme_admin_get_features = 10,
	nvme_admin_async_event = 12,
	nvme_admin_ns_mgmt = 13,
	nvme_admin_activate_fw = 16,
	nvme_admin_download_fw = 17,
	nvme_admin_dev_self_test = 20,
	nvme_admin_ns_attach = 21,
	nvme_admin_keep_alive = 24,
	nvme_admin_directive_send = 25,
	nvme_admin_directive_recv = 26,
	nvme_admin_virtual_mgmt = 28,
	nvme_admin_nvme_mi_send = 29,
	nvme_admin_nvme_mi_recv = 30,
	nvme_admin_dbbuf = 124,
	nvme_admin_format_nvm = 128,
	nvme_admin_security_send = 129,
	nvme_admin_security_recv = 130,
	nvme_admin_sanitize_nvm = 132,
	nvme_admin_get_lba_status = 134,
	nvme_admin_vendor_start = 192,
};

enum nvme_ana_state {
	NVME_ANA_OPTIMIZED = 1,
	NVME_ANA_NONOPTIMIZED = 2,
	NVME_ANA_INACCESSIBLE = 3,
	NVME_ANA_PERSISTENT_LOSS = 4,
	NVME_ANA_CHANGE = 15,
};

enum nvme_ctrl_attr {
	NVME_CTRL_ATTR_HID_128_BIT = 1,
	NVME_CTRL_ATTR_TBKAS = 64,
	NVME_CTRL_ATTR_ELBAS = 32768,
};

enum nvme_ctrl_flags {
	NVME_CTRL_FAILFAST_EXPIRED = 0,
	NVME_CTRL_ADMIN_Q_STOPPED = 1,
	NVME_CTRL_STARTED_ONCE = 2,
	NVME_CTRL_STOPPED = 3,
	NVME_CTRL_SKIP_ID_CNS_CS = 4,
	NVME_CTRL_DIRTY_CAPABILITY = 5,
	NVME_CTRL_FROZEN = 6,
};

enum nvme_ctrl_state {
	NVME_CTRL_NEW = 0,
	NVME_CTRL_LIVE = 1,
	NVME_CTRL_RESETTING = 2,
	NVME_CTRL_CONNECTING = 3,
	NVME_CTRL_DELETING = 4,
	NVME_CTRL_DELETING_NOIO = 5,
	NVME_CTRL_DEAD = 6,
};

enum nvme_ctrl_type {
	NVME_CTRL_IO = 1,
	NVME_CTRL_DISC = 2,
	NVME_CTRL_ADMIN = 3,
};

enum nvme_dctype {
	NVME_DCTYPE_NOT_REPORTED = 0,
	NVME_DCTYPE_DDC = 1,
	NVME_DCTYPE_CDC = 2,
};

enum nvme_disposition {
	COMPLETE = 0,
	RETRY = 1,
	FAILOVER = 2,
	AUTHENTICATE = 3,
};

enum nvme_eds {
	NVME_EXTENDED_DATA_STRUCT = 1,
};

enum nvme_fc_obj_state {
	FC_OBJSTATE_UNKNOWN = 0,
	FC_OBJSTATE_NOTPRESENT = 1,
	FC_OBJSTATE_ONLINE = 2,
	FC_OBJSTATE_OFFLINE = 3,
	FC_OBJSTATE_BLOCKED = 4,
	FC_OBJSTATE_BYPASSED = 5,
	FC_OBJSTATE_DIAGNOSTICS = 6,
	FC_OBJSTATE_LINKDOWN = 7,
	FC_OBJSTATE_ERROR = 8,
	FC_OBJSTATE_LOOPBACK = 9,
	FC_OBJSTATE_DELETED = 10,
};

enum nvme_fc_queue_flags {
	NVME_FC_Q_CONNECTED = 0,
	NVME_FC_Q_LIVE = 1,
};

enum nvme_fcop_flags {
	FCOP_FLAGS_TERMIO = 1,
	FCOP_FLAGS_AEN = 2,
};

enum nvme_fcpop_state {
	FCPOP_STATE_UNINIT = 0,
	FCPOP_STATE_IDLE = 1,
	FCPOP_STATE_ACTIVE = 2,
	FCPOP_STATE_ABORTED = 3,
	FCPOP_STATE_COMPLETE = 4,
};

enum nvme_iopolicy {
	NVME_IOPOLICY_NUMA = 0,
	NVME_IOPOLICY_RR = 1,
};

enum nvme_loop_queue_flags {
	NVME_LOOP_Q_LIVE = 0,
};

enum nvme_ns_features {
	NVME_NS_EXT_LBAS = 1,
	NVME_NS_METADATA_SUPPORTED = 2,
	NVME_NS_DEAC = 4,
};

enum nvme_opcode {
	nvme_cmd_flush = 0,
	nvme_cmd_write = 1,
	nvme_cmd_read = 2,
	nvme_cmd_write_uncor = 4,
	nvme_cmd_compare = 5,
	nvme_cmd_write_zeroes = 8,
	nvme_cmd_dsm = 9,
	nvme_cmd_verify = 12,
	nvme_cmd_resv_register = 13,
	nvme_cmd_resv_report = 14,
	nvme_cmd_resv_acquire = 17,
	nvme_cmd_resv_release = 21,
	nvme_cmd_zone_mgmt_send = 121,
	nvme_cmd_zone_mgmt_recv = 122,
	nvme_cmd_zone_append = 125,
	nvme_cmd_vendor_start = 128,
};

enum nvme_pr_type {
	NVME_PR_WRITE_EXCLUSIVE = 1,
	NVME_PR_EXCLUSIVE_ACCESS = 2,
	NVME_PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	NVME_PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	NVME_PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	NVME_PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum nvme_quirks {
	NVME_QUIRK_STRIPE_SIZE = 1,
	NVME_QUIRK_IDENTIFY_CNS = 2,
	NVME_QUIRK_DEALLOCATE_ZEROES = 4,
	NVME_QUIRK_DELAY_BEFORE_CHK_RDY = 8,
	NVME_QUIRK_NO_APST = 16,
	NVME_QUIRK_NO_DEEPEST_PS = 32,
	NVME_QUIRK_MEDIUM_PRIO_SQ = 128,
	NVME_QUIRK_IGNORE_DEV_SUBNQN = 256,
	NVME_QUIRK_DISABLE_WRITE_ZEROES = 512,
	NVME_QUIRK_SIMPLE_SUSPEND = 1024,
	NVME_QUIRK_SINGLE_VECTOR = 2048,
	NVME_QUIRK_128_BYTES_SQES = 4096,
	NVME_QUIRK_SHARED_TAGS = 8192,
	NVME_QUIRK_NO_TEMP_THRESH_CHANGE = 16384,
	NVME_QUIRK_NO_NS_DESC_LIST = 32768,
	NVME_QUIRK_DMA_ADDRESS_BITS_48 = 65536,
	NVME_QUIRK_SKIP_CID_GEN = 131072,
	NVME_QUIRK_BOGUS_NID = 262144,
	NVME_QUIRK_NO_SECONDARY_TEMP_THRESH = 524288,
	NVME_QUIRK_FORCE_NO_SIMPLE_SUSPEND = 1048576,
	NVME_QUIRK_BROKEN_MSI = 2097152,
};

enum nvme_subsys_type {
	NVME_NQN_DISC = 1,
	NVME_NQN_NVME = 2,
	NVME_NQN_CURR = 3,
};

enum nvme_tcp_digest_option {
	NVME_TCP_HDR_DIGEST_ENABLE = 1,
	NVME_TCP_DATA_DIGEST_ENABLE = 2,
};

enum nvme_tcp_pdu_flags {
	NVME_TCP_F_HDGST = 1,
	NVME_TCP_F_DDGST = 2,
	NVME_TCP_F_DATA_LAST = 4,
	NVME_TCP_F_DATA_SUCCESS = 8,
};

enum nvme_tcp_pdu_type {
	nvme_tcp_icreq = 0,
	nvme_tcp_icresp = 1,
	nvme_tcp_h2c_term = 2,
	nvme_tcp_c2h_term = 3,
	nvme_tcp_cmd = 4,
	nvme_tcp_rsp = 5,
	nvme_tcp_h2c_data = 6,
	nvme_tcp_c2h_data = 7,
	nvme_tcp_r2t = 9,
};

enum nvme_tcp_pfv {
	NVME_TCP_PFV_1_0 = 0,
};

enum nvme_tcp_queue_flags {
	NVME_TCP_Q_ALLOCATED = 0,
	NVME_TCP_Q_LIVE = 1,
	NVME_TCP_Q_POLLING = 2,
};

enum nvme_tcp_recv_state {
	NVME_TCP_RECV_PDU = 0,
	NVME_TCP_RECV_DATA = 1,
	NVME_TCP_RECV_DDGST = 2,
};

enum nvme_tcp_send_state {
	NVME_TCP_SEND_CMD_PDU = 0,
	NVME_TCP_SEND_H2C_PDU = 1,
	NVME_TCP_SEND_DATA = 2,
	NVME_TCP_SEND_DDGST = 3,
};

enum nvme_tcp_tls_cipher {
	NVME_TCP_TLS_CIPHER_INVALID = 0,
	NVME_TCP_TLS_CIPHER_SHA256 = 1,
	NVME_TCP_TLS_CIPHER_SHA384 = 2,
};

enum nvme_zone_mgmt_action {
	NVME_ZONE_CLOSE = 1,
	NVME_ZONE_FINISH = 2,
	NVME_ZONE_OPEN = 3,
	NVME_ZONE_RESET = 4,
	NVME_ZONE_OFFLINE = 5,
	NVME_ZONE_SET_DESC_EXT = 16,
};

enum nvmefc_fcp_datadir {
	NVMEFC_FCP_NODATA = 0,
	NVMEFC_FCP_WRITE = 1,
	NVMEFC_FCP_READ = 2,
};

enum nvmem_type {
	NVMEM_TYPE_UNKNOWN = 0,
	NVMEM_TYPE_EEPROM = 1,
	NVMEM_TYPE_OTP = 2,
	NVMEM_TYPE_BATTERY_BACKED = 3,
	NVMEM_TYPE_FRAM = 4,
};

enum nvmet_fcp_datadir {
	NVMET_FCP_NODATA = 0,
	NVMET_FCP_WRITE = 1,
	NVMET_FCP_READ = 2,
	NVMET_FCP_ABORTED = 3,
};

enum nvmet_tcp_queue_state {
	NVMET_TCP_Q_CONNECTING = 0,
	NVMET_TCP_Q_TLS_HANDSHAKE = 1,
	NVMET_TCP_Q_LIVE = 2,
	NVMET_TCP_Q_DISCONNECTING = 3,
	NVMET_TCP_Q_FAILED = 4,
};

enum nvmet_tcp_recv_state {
	NVMET_TCP_RECV_PDU = 0,
	NVMET_TCP_RECV_DATA = 1,
	NVMET_TCP_RECV_DDGST = 2,
	NVMET_TCP_RECV_ERR = 3,
};

enum nvmet_tcp_send_state {
	NVMET_TCP_SEND_DATA_PDU = 0,
	NVMET_TCP_SEND_DATA = 1,
	NVMET_TCP_SEND_R2T = 2,
	NVMET_TCP_SEND_DDGST = 3,
	NVMET_TCP_SEND_RESPONSE = 4,
};

enum nvmf_capsule_command {
	nvme_fabrics_type_property_set = 0,
	nvme_fabrics_type_connect = 1,
	nvme_fabrics_type_property_get = 4,
	nvme_fabrics_type_auth_send = 5,
	nvme_fabrics_type_auth_receive = 6,
};

enum nvmf_fabrics_opcode {
	nvme_fabrics_command = 127,
};

enum objext_flags {
	OBJEXTS_ALLOC_FAIL = 4,
	__NR_OBJEXTS_FLAGS = 8,
};

enum of_gpio_flags {
	OF_GPIO_ACTIVE_LOW = 1,
	OF_GPIO_SINGLE_ENDED = 2,
	OF_GPIO_OPEN_DRAIN = 4,
	OF_GPIO_TRANSITORY = 8,
	OF_GPIO_PULL_UP = 16,
	OF_GPIO_PULL_DOWN = 32,
	OF_GPIO_PULL_DISABLE = 64,
};

enum of_overlay_notify_action {
	OF_OVERLAY_INIT = 0,
	OF_OVERLAY_PRE_APPLY = 1,
	OF_OVERLAY_POST_APPLY = 2,
	OF_OVERLAY_PRE_REMOVE = 3,
	OF_OVERLAY_POST_REMOVE = 4,
};

enum of_pci_prop_compatible {
	PROP_COMPAT_PCI_VVVV_DDDD = 0,
	PROP_COMPAT_PCICLASS_CCSSPP = 1,
	PROP_COMPAT_PCICLASS_CCSS = 2,
	PROP_COMPAT_NUM = 3,
};

enum of_reconfig_change {
	OF_RECONFIG_NO_CHANGE = 0,
	OF_RECONFIG_CHANGE_ADD = 1,
	OF_RECONFIG_CHANGE_REMOVE = 2,
};

enum offload_act_command {
	FLOW_ACT_REPLACE = 0,
	FLOW_ACT_DESTROY = 1,
	FLOW_ACT_STATS = 2,
};

enum oom_constraint {
	CONSTRAINT_NONE = 0,
	CONSTRAINT_CPUSET = 1,
	CONSTRAINT_MEMORY_POLICY = 2,
	CONSTRAINT_MEMCG = 3,
};

enum opal_async_token_state {
	ASYNC_TOKEN_UNALLOCATED = 0,
	ASYNC_TOKEN_ALLOCATED = 1,
	ASYNC_TOKEN_DISPATCHED = 2,
	ASYNC_TOKEN_ABANDONED = 3,
	ASYNC_TOKEN_COMPLETED = 4,
};

enum opal_atom_width {
	OPAL_WIDTH_TINY = 0,
	OPAL_WIDTH_SHORT = 1,
	OPAL_WIDTH_MEDIUM = 2,
	OPAL_WIDTH_LONG = 3,
	OPAL_WIDTH_TOKEN = 4,
};

enum opal_key_type {
	OPAL_INCLUDED = 0,
	OPAL_KEYRING = 1,
};

enum opal_lock_flags {
	OPAL_SAVE_FOR_LOCK = 1,
};

enum opal_lock_state {
	OPAL_RO = 1,
	OPAL_RW = 2,
	OPAL_LK = 4,
};

enum opal_mbr {
	OPAL_MBR_ENABLE = 0,
	OPAL_MBR_DISABLE = 1,
};

enum opal_mbr_done_flag {
	OPAL_MBR_NOT_DONE = 0,
	OPAL_MBR_DONE = 1,
};

enum opal_method {
	OPAL_PROPERTIES = 0,
	OPAL_STARTSESSION = 1,
	OPAL_REVERT = 2,
	OPAL_ACTIVATE = 3,
	OPAL_EGET = 4,
	OPAL_ESET = 5,
	OPAL_NEXT = 6,
	OPAL_EAUTHENTICATE = 7,
	OPAL_GETACL = 8,
	OPAL_GENKEY = 9,
	OPAL_REVERTSP = 10,
	OPAL_GET = 11,
	OPAL_SET = 12,
	OPAL_AUTHENTICATE = 13,
	OPAL_RANDOM = 14,
	OPAL_ERASE = 15,
};

enum opal_mpipl_ops {
	OPAL_MPIPL_ADD_RANGE = 0,
	OPAL_MPIPL_REMOVE_RANGE = 1,
	OPAL_MPIPL_REMOVE_ALL = 2,
	OPAL_MPIPL_FREE_PRESERVED_MEMORY = 3,
};

enum opal_mpipl_tags {
	OPAL_MPIPL_TAG_CPU = 0,
	OPAL_MPIPL_TAG_OPAL = 1,
	OPAL_MPIPL_TAG_KERNEL = 2,
	OPAL_MPIPL_TAG_BOOT_MEM = 3,
};

enum opal_msg_type {
	OPAL_MSG_ASYNC_COMP = 0,
	OPAL_MSG_MEM_ERR = 1,
	OPAL_MSG_EPOW = 2,
	OPAL_MSG_SHUTDOWN = 3,
	OPAL_MSG_HMI_EVT = 4,
	OPAL_MSG_DPO = 5,
	OPAL_MSG_PRD = 6,
	OPAL_MSG_OCC = 7,
	OPAL_MSG_PRD2 = 8,
	OPAL_MSG_TYPE_MAX = 9,
};

enum opal_parameter {
	OPAL_SUM_SET_LIST = 393216,
};

enum opal_response_token {
	OPAL_DTA_TOKENID_BYTESTRING = 224,
	OPAL_DTA_TOKENID_SINT = 225,
	OPAL_DTA_TOKENID_UINT = 226,
	OPAL_DTA_TOKENID_TOKEN = 227,
	OPAL_DTA_TOKENID_INVALID = 0,
};

enum opal_revert_lsp_opts {
	OPAL_PRESERVE = 1,
};

enum opal_revertlsp {
	OPAL_KEEP_GLOBAL_RANGE_KEY = 393216,
};

enum opal_table_ops {
	OPAL_READ_TABLE = 0,
	OPAL_WRITE_TABLE = 1,
};

enum opal_token {
	OPAL_TRUE = 1,
	OPAL_FALSE = 0,
	OPAL_BOOLEAN_EXPR = 3,
	OPAL_TABLE = 0,
	OPAL_STARTROW = 1,
	OPAL_ENDROW = 2,
	OPAL_STARTCOLUMN = 3,
	OPAL_ENDCOLUMN = 4,
	OPAL_VALUES = 1,
	OPAL_TABLE_UID = 0,
	OPAL_TABLE_NAME = 1,
	OPAL_TABLE_COMMON = 2,
	OPAL_TABLE_TEMPLATE = 3,
	OPAL_TABLE_KIND = 4,
	OPAL_TABLE_COLUMN = 5,
	OPAL_TABLE_COLUMNS = 6,
	OPAL_TABLE_ROWS = 7,
	OPAL_TABLE_ROWS_FREE = 8,
	OPAL_TABLE_ROW_BYTES = 9,
	OPAL_TABLE_LASTID = 10,
	OPAL_TABLE_MIN = 11,
	OPAL_TABLE_MAX = 12,
	OPAL_PIN = 3,
	OPAL_RANGESTART = 3,
	OPAL_RANGELENGTH = 4,
	OPAL_READLOCKENABLED = 5,
	OPAL_WRITELOCKENABLED = 6,
	OPAL_READLOCKED = 7,
	OPAL_WRITELOCKED = 8,
	OPAL_ACTIVEKEY = 10,
	OPAL_LIFECYCLE = 6,
	OPAL_MAXRANGES = 4,
	OPAL_MBRENABLE = 1,
	OPAL_MBRDONE = 2,
	OPAL_HOSTPROPERTIES = 0,
	OPAL_STARTLIST = 240,
	OPAL_ENDLIST = 241,
	OPAL_STARTNAME = 242,
	OPAL_ENDNAME = 243,
	OPAL_CALL = 248,
	OPAL_ENDOFDATA = 249,
	OPAL_ENDOFSESSION = 250,
	OPAL_STARTTRANSACTON = 251,
	OPAL_ENDTRANSACTON = 252,
	OPAL_EMPTYATOM = 255,
	OPAL_WHERE = 0,
};

enum opal_uid {
	OPAL_SMUID_UID = 0,
	OPAL_THISSP_UID = 1,
	OPAL_ADMINSP_UID = 2,
	OPAL_LOCKINGSP_UID = 3,
	OPAL_ENTERPRISE_LOCKINGSP_UID = 4,
	OPAL_ANYBODY_UID = 5,
	OPAL_SID_UID = 6,
	OPAL_ADMIN1_UID = 7,
	OPAL_USER1_UID = 8,
	OPAL_USER2_UID = 9,
	OPAL_PSID_UID = 10,
	OPAL_ENTERPRISE_BANDMASTER0_UID = 11,
	OPAL_ENTERPRISE_ERASEMASTER_UID = 12,
	OPAL_TABLE_TABLE = 13,
	OPAL_LOCKINGRANGE_GLOBAL = 14,
	OPAL_LOCKINGRANGE_ACE_START_TO_KEY = 15,
	OPAL_LOCKINGRANGE_ACE_RDLOCKED = 16,
	OPAL_LOCKINGRANGE_ACE_WRLOCKED = 17,
	OPAL_MBRCONTROL = 18,
	OPAL_MBR = 19,
	OPAL_AUTHORITY_TABLE = 20,
	OPAL_C_PIN_TABLE = 21,
	OPAL_LOCKING_INFO_TABLE = 22,
	OPAL_ENTERPRISE_LOCKING_INFO_TABLE = 23,
	OPAL_DATASTORE = 24,
	OPAL_C_PIN_MSID = 25,
	OPAL_C_PIN_SID = 26,
	OPAL_C_PIN_ADMIN1 = 27,
	OPAL_HALF_UID_AUTHORITY_OBJ_REF = 28,
	OPAL_HALF_UID_BOOLEAN_ACE = 29,
	OPAL_UID_HEXFF = 30,
};

enum opal_user {
	OPAL_ADMIN1 = 0,
	OPAL_USER1 = 1,
	OPAL_USER2 = 2,
	OPAL_USER3 = 3,
	OPAL_USER4 = 4,
	OPAL_USER5 = 5,
	OPAL_USER6 = 6,
	OPAL_USER7 = 7,
	OPAL_USER8 = 8,
	OPAL_USER9 = 9,
};

enum open_frame_protocol {
	PROTOCOL_SMP = 0,
	PROTOCOL_SSP = 1,
	PROTOCOL_STP = 2,
};

enum opp_table_access {
	OPP_TABLE_ACCESS_UNKNOWN = 0,
	OPP_TABLE_ACCESS_EXCLUSIVE = 1,
	OPP_TABLE_ACCESS_SHARED = 2,
};

enum osnoise_options_index {
	OSN_DEFAULTS = 0,
	OSN_WORKLOAD = 1,
	OSN_PANIC_ON_STOP = 2,
	OSN_PREEMPT_DISABLE = 3,
	OSN_IRQ_DISABLE = 4,
	OSN_MAX = 5,
};

enum owner_state {
	OWNER_NULL = 1,
	OWNER_WRITER = 2,
	OWNER_READER = 4,
	OWNER_NONSPINNABLE = 8,
};

enum packet_sock_flags {
	PACKET_SOCK_ORIGDEV = 0,
	PACKET_SOCK_AUXDATA = 1,
	PACKET_SOCK_TX_HAS_OFF = 2,
	PACKET_SOCK_TP_LOSS = 3,
	PACKET_SOCK_RUNNING = 4,
	PACKET_SOCK_PRESSURE = 5,
	PACKET_SOCK_QDISC_BYPASS = 6,
};

enum packing_op {
	PACK = 0,
	UNPACK = 1,
};

enum page_memcg_data_flags {
	MEMCG_DATA_OBJEXTS = 1,
	MEMCG_DATA_KMEM = 2,
	__NR_MEMCG_DATA_FLAGS = 4,
};

enum page_size_enum {
	__PAGE_SIZE = 65536,
};

enum page_walk_action {
	ACTION_SUBTREE = 0,
	ACTION_CONTINUE = 1,
	ACTION_AGAIN = 2,
};

enum page_walk_lock {
	PGWALK_RDLOCK = 0,
	PGWALK_WRLOCK = 1,
	PGWALK_WRLOCK_VERIFY = 2,
};

enum pageblock_bits {
	PB_migrate = 0,
	PB_migrate_end = 2,
	PB_migrate_skip = 3,
	NR_PAGEBLOCK_BITS = 4,
};

enum pageflags {
	PG_locked = 0,
	PG_writeback = 1,
	PG_referenced = 2,
	PG_uptodate = 3,
	PG_dirty = 4,
	PG_lru = 5,
	PG_head = 6,
	PG_waiters = 7,
	PG_active = 8,
	PG_workingset = 9,
	PG_error = 10,
	PG_owner_priv_1 = 11,
	PG_arch_1 = 12,
	PG_reserved = 13,
	PG_private = 14,
	PG_private_2 = 15,
	PG_mappedtodisk = 16,
	PG_reclaim = 17,
	PG_swapbacked = 18,
	PG_unevictable = 19,
	PG_mlocked = 20,
	PG_hwpoison = 21,
	PG_young = 22,
	PG_idle = 23,
	__NR_PAGEFLAGS = 24,
	PG_readahead = 17,
	PG_anon_exclusive = 16,
	PG_checked = 11,
	PG_swapcache = 11,
	PG_fscache = 15,
	PG_pinned = 11,
	PG_savepinned = 4,
	PG_foreign = 11,
	PG_xen_remapped = 11,
	PG_isolated = 17,
	PG_reported = 3,
	PG_vmemmap_self_hosted = 11,
	PG_has_hwpoisoned = 10,
	PG_large_rmappable = 9,
};

enum pagetype {
	PG_buddy = 128LL,
	PG_offline = 256LL,
	PG_table = 512LL,
	PG_guard = 1024LL,
	PG_hugetlb = 2048LL,
	PG_slab = 4096LL,
	PAGE_TYPE_BASE = 4026531840LL,
	PAGE_MAPCOUNT_RESERVE = -128LL,
};

enum palmas_external_requestor_id {
	PALMAS_EXTERNAL_REQSTR_ID_REGEN1 = 0,
	PALMAS_EXTERNAL_REQSTR_ID_REGEN2 = 1,
	PALMAS_EXTERNAL_REQSTR_ID_SYSEN1 = 2,
	PALMAS_EXTERNAL_REQSTR_ID_SYSEN2 = 3,
	PALMAS_EXTERNAL_REQSTR_ID_CLK32KG = 4,
	PALMAS_EXTERNAL_REQSTR_ID_CLK32KGAUDIO = 5,
	PALMAS_EXTERNAL_REQSTR_ID_REGEN3 = 6,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS12 = 7,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS3 = 8,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS45 = 9,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS6 = 10,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS7 = 11,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS8 = 12,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS9 = 13,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS10 = 14,
	PALMAS_EXTERNAL_REQSTR_ID_LDO1 = 15,
	PALMAS_EXTERNAL_REQSTR_ID_LDO2 = 16,
	PALMAS_EXTERNAL_REQSTR_ID_LDO3 = 17,
	PALMAS_EXTERNAL_REQSTR_ID_LDO4 = 18,
	PALMAS_EXTERNAL_REQSTR_ID_LDO5 = 19,
	PALMAS_EXTERNAL_REQSTR_ID_LDO6 = 20,
	PALMAS_EXTERNAL_REQSTR_ID_LDO7 = 21,
	PALMAS_EXTERNAL_REQSTR_ID_LDO8 = 22,
	PALMAS_EXTERNAL_REQSTR_ID_LDO9 = 23,
	PALMAS_EXTERNAL_REQSTR_ID_LDOLN = 24,
	PALMAS_EXTERNAL_REQSTR_ID_LDOUSB = 25,
	PALMAS_EXTERNAL_REQSTR_ID_MAX = 26,
};

enum palmas_irqs {
	PALMAS_CHARG_DET_N_VBUS_OVV_IRQ = 0,
	PALMAS_PWRON_IRQ = 1,
	PALMAS_LONG_PRESS_KEY_IRQ = 2,
	PALMAS_RPWRON_IRQ = 3,
	PALMAS_PWRDOWN_IRQ = 4,
	PALMAS_HOTDIE_IRQ = 5,
	PALMAS_VSYS_MON_IRQ = 6,
	PALMAS_VBAT_MON_IRQ = 7,
	PALMAS_RTC_ALARM_IRQ = 8,
	PALMAS_RTC_TIMER_IRQ = 9,
	PALMAS_WDT_IRQ = 10,
	PALMAS_BATREMOVAL_IRQ = 11,
	PALMAS_RESET_IN_IRQ = 12,
	PALMAS_FBI_BB_IRQ = 13,
	PALMAS_SHORT_IRQ = 14,
	PALMAS_VAC_ACOK_IRQ = 15,
	PALMAS_GPADC_AUTO_0_IRQ = 16,
	PALMAS_GPADC_AUTO_1_IRQ = 17,
	PALMAS_GPADC_EOC_SW_IRQ = 18,
	PALMAS_GPADC_EOC_RT_IRQ = 19,
	PALMAS_ID_OTG_IRQ = 20,
	PALMAS_ID_IRQ = 21,
	PALMAS_VBUS_OTG_IRQ = 22,
	PALMAS_VBUS_IRQ = 23,
	PALMAS_GPIO_0_IRQ = 24,
	PALMAS_GPIO_1_IRQ = 25,
	PALMAS_GPIO_2_IRQ = 26,
	PALMAS_GPIO_3_IRQ = 27,
	PALMAS_GPIO_4_IRQ = 28,
	PALMAS_GPIO_5_IRQ = 29,
	PALMAS_GPIO_6_IRQ = 30,
	PALMAS_GPIO_7_IRQ = 31,
	PALMAS_NUM_IRQ = 32,
};

enum palmas_regulators {
	PALMAS_REG_SMPS12 = 0,
	PALMAS_REG_SMPS123 = 1,
	PALMAS_REG_SMPS3 = 2,
	PALMAS_REG_SMPS45 = 3,
	PALMAS_REG_SMPS457 = 4,
	PALMAS_REG_SMPS6 = 5,
	PALMAS_REG_SMPS7 = 6,
	PALMAS_REG_SMPS8 = 7,
	PALMAS_REG_SMPS9 = 8,
	PALMAS_REG_SMPS10_OUT2 = 9,
	PALMAS_REG_SMPS10_OUT1 = 10,
	PALMAS_REG_LDO1 = 11,
	PALMAS_REG_LDO2 = 12,
	PALMAS_REG_LDO3 = 13,
	PALMAS_REG_LDO4 = 14,
	PALMAS_REG_LDO5 = 15,
	PALMAS_REG_LDO6 = 16,
	PALMAS_REG_LDO7 = 17,
	PALMAS_REG_LDO8 = 18,
	PALMAS_REG_LDO9 = 19,
	PALMAS_REG_LDOLN = 20,
	PALMAS_REG_LDOUSB = 21,
	PALMAS_REG_REGEN1 = 22,
	PALMAS_REG_REGEN2 = 23,
	PALMAS_REG_REGEN3 = 24,
	PALMAS_REG_SYSEN1 = 25,
	PALMAS_REG_SYSEN2 = 26,
	PALMAS_NUM_REGS = 27,
};

enum palmas_usb_state {
	PALMAS_USB_STATE_DISCONNECT = 0,
	PALMAS_USB_STATE_VBUS = 1,
	PALMAS_USB_STATE_ID = 2,
};

enum partition_cmd {
	partcmd_enable = 0,
	partcmd_enablei = 1,
	partcmd_disable = 2,
	partcmd_update = 3,
	partcmd_invalidate = 4,
};

enum passtype {
	PASS_SCAN = 0,
	PASS_REVOKE = 1,
	PASS_REPLAY = 2,
};

enum path_flags {
	PATH_IS_DIR = 1,
	PATH_CONNECT_PATH = 4,
	PATH_CHROOT_REL = 8,
	PATH_CHROOT_NSCONNECT = 16,
	PATH_DELEGATE_DELETED = 65536,
	PATH_MEDIATE_DELETED = 131072,
};

enum pce_status {
	PCE_STATUS_NONE = 0,
	PCE_STATUS_ACQUIRED = 1,
	PCE_STATUS_PREPARED = 2,
	PCE_STATUS_ENABLED = 3,
	PCE_STATUS_ERROR = 4,
};

enum pci_bar_type {
	pci_bar_unknown = 0,
	pci_bar_io = 1,
	pci_bar_mem32 = 2,
	pci_bar_mem64 = 3,
};

enum pci_barno {
	NO_BAR = -1,
	BAR_0 = 0,
	BAR_1 = 1,
	BAR_2 = 2,
	BAR_3 = 3,
	BAR_4 = 4,
	BAR_5 = 5,
};

enum pci_board_num_t {
	pbn_default = 0,
	pbn_b0_1_115200 = 1,
	pbn_b0_2_115200 = 2,
	pbn_b0_4_115200 = 3,
	pbn_b0_5_115200 = 4,
	pbn_b0_8_115200 = 5,
	pbn_b0_1_921600 = 6,
	pbn_b0_2_921600 = 7,
	pbn_b0_4_921600 = 8,
	pbn_b0_2_1130000 = 9,
	pbn_b0_4_1152000 = 10,
	pbn_b0_4_1250000 = 11,
	pbn_b0_2_1843200 = 12,
	pbn_b0_4_1843200 = 13,
	pbn_b0_1_15625000 = 14,
	pbn_b0_bt_1_115200 = 15,
	pbn_b0_bt_2_115200 = 16,
	pbn_b0_bt_4_115200 = 17,
	pbn_b0_bt_8_115200 = 18,
	pbn_b0_bt_1_460800 = 19,
	pbn_b0_bt_2_460800 = 20,
	pbn_b0_bt_4_460800 = 21,
	pbn_b0_bt_1_921600 = 22,
	pbn_b0_bt_2_921600 = 23,
	pbn_b0_bt_4_921600 = 24,
	pbn_b0_bt_8_921600 = 25,
	pbn_b1_1_115200 = 26,
	pbn_b1_2_115200 = 27,
	pbn_b1_4_115200 = 28,
	pbn_b1_8_115200 = 29,
	pbn_b1_16_115200 = 30,
	pbn_b1_1_921600 = 31,
	pbn_b1_2_921600 = 32,
	pbn_b1_4_921600 = 33,
	pbn_b1_8_921600 = 34,
	pbn_b1_2_1250000 = 35,
	pbn_b1_bt_1_115200 = 36,
	pbn_b1_bt_2_115200 = 37,
	pbn_b1_bt_4_115200 = 38,
	pbn_b1_bt_2_921600 = 39,
	pbn_b1_1_1382400 = 40,
	pbn_b1_2_1382400 = 41,
	pbn_b1_4_1382400 = 42,
	pbn_b1_8_1382400 = 43,
	pbn_b2_1_115200 = 44,
	pbn_b2_2_115200 = 45,
	pbn_b2_4_115200 = 46,
	pbn_b2_8_115200 = 47,
	pbn_b2_1_460800 = 48,
	pbn_b2_4_460800 = 49,
	pbn_b2_8_460800 = 50,
	pbn_b2_16_460800 = 51,
	pbn_b2_1_921600 = 52,
	pbn_b2_4_921600 = 53,
	pbn_b2_8_921600 = 54,
	pbn_b2_8_1152000 = 55,
	pbn_b2_bt_1_115200 = 56,
	pbn_b2_bt_2_115200 = 57,
	pbn_b2_bt_4_115200 = 58,
	pbn_b2_bt_2_921600 = 59,
	pbn_b2_bt_4_921600 = 60,
	pbn_b3_2_115200 = 61,
	pbn_b3_4_115200 = 62,
	pbn_b3_8_115200 = 63,
	pbn_b4_bt_2_921600 = 64,
	pbn_b4_bt_4_921600 = 65,
	pbn_b4_bt_8_921600 = 66,
	pbn_panacom = 67,
	pbn_panacom2 = 68,
	pbn_panacom4 = 69,
	pbn_plx_romulus = 70,
	pbn_oxsemi = 71,
	pbn_oxsemi_1_15625000 = 72,
	pbn_oxsemi_2_15625000 = 73,
	pbn_oxsemi_4_15625000 = 74,
	pbn_oxsemi_8_15625000 = 75,
	pbn_intel_i960 = 76,
	pbn_sgi_ioc3 = 77,
	pbn_computone_4 = 78,
	pbn_computone_6 = 79,
	pbn_computone_8 = 80,
	pbn_sbsxrsio = 81,
	pbn_pasemi_1682M = 82,
	pbn_ni8430_2 = 83,
	pbn_ni8430_4 = 84,
	pbn_ni8430_8 = 85,
	pbn_ni8430_16 = 86,
	pbn_ADDIDATA_PCIe_1_3906250 = 87,
	pbn_ADDIDATA_PCIe_2_3906250 = 88,
	pbn_ADDIDATA_PCIe_4_3906250 = 89,
	pbn_ADDIDATA_PCIe_8_3906250 = 90,
	pbn_ce4100_1_115200 = 91,
	pbn_omegapci = 92,
	pbn_NETMOS9900_2s_115200 = 93,
	pbn_brcm_trumanage = 94,
	pbn_fintek_4 = 95,
	pbn_fintek_8 = 96,
	pbn_fintek_12 = 97,
	pbn_fintek_F81504A = 98,
	pbn_fintek_F81508A = 99,
	pbn_fintek_F81512A = 100,
	pbn_wch382_2 = 101,
	pbn_wch384_4 = 102,
	pbn_wch384_8 = 103,
	pbn_sunix_pci_1s = 104,
	pbn_sunix_pci_2s = 105,
	pbn_sunix_pci_4s = 106,
	pbn_sunix_pci_8s = 107,
	pbn_sunix_pci_16s = 108,
	pbn_titan_1_4000000 = 109,
	pbn_titan_2_4000000 = 110,
	pbn_titan_4_4000000 = 111,
	pbn_titan_8_4000000 = 112,
	pbn_moxa_2 = 113,
	pbn_moxa_4 = 114,
	pbn_moxa_8 = 115,
};

enum pci_bus_flags {
	PCI_BUS_FLAGS_NO_MSI = 1,
	PCI_BUS_FLAGS_NO_MMRBC = 2,
	PCI_BUS_FLAGS_NO_AERSID = 4,
	PCI_BUS_FLAGS_NO_EXTCFG = 8,
};

enum pci_bus_speed {
	PCI_SPEED_33MHz = 0,
	PCI_SPEED_66MHz = 1,
	PCI_SPEED_66MHz_PCIX = 2,
	PCI_SPEED_100MHz_PCIX = 3,
	PCI_SPEED_133MHz_PCIX = 4,
	PCI_SPEED_66MHz_PCIX_ECC = 5,
	PCI_SPEED_100MHz_PCIX_ECC = 6,
	PCI_SPEED_133MHz_PCIX_ECC = 7,
	PCI_SPEED_66MHz_PCIX_266 = 9,
	PCI_SPEED_100MHz_PCIX_266 = 10,
	PCI_SPEED_133MHz_PCIX_266 = 11,
	AGP_UNKNOWN = 12,
	AGP_1X = 13,
	AGP_2X = 14,
	AGP_4X = 15,
	AGP_8X = 16,
	PCI_SPEED_66MHz_PCIX_533 = 17,
	PCI_SPEED_100MHz_PCIX_533 = 18,
	PCI_SPEED_133MHz_PCIX_533 = 19,
	PCIE_SPEED_2_5GT = 20,
	PCIE_SPEED_5_0GT = 21,
	PCIE_SPEED_8_0GT = 22,
	PCIE_SPEED_16_0GT = 23,
	PCIE_SPEED_32_0GT = 24,
	PCIE_SPEED_64_0GT = 25,
	PCI_SPEED_UNKNOWN = 255,
};

enum pci_cfg_register_bits {
	PCTL_PWR_OFF = 251658240,
	PCTL_COM_ON = 15728640,
	PCTL_LINK_RST = 983040,
	PCTL_LINK_OFFS = 16,
	PCTL_PHY_DSBL = 61440,
	PCTL_PHY_DSBL_OFFS = 12,
	PRD_REQ_SIZE = 16384,
	PRD_REQ_MASK = 28672,
	PLS_NEG_LINK_WD = 1008,
	PLS_NEG_LINK_WD_OFFS = 4,
	PLS_LINK_SPD = 15,
	PLS_LINK_SPD_OFFS = 0,
};

enum pci_cfg_registers {
	PCR_PHY_CTL = 64,
	PCR_PHY_CTL2 = 144,
	PCR_DEV_CTRL = 232,
	PCR_LINK_STAT = 242,
};

enum pci_cfg_registers___2 {
	PCR_PHY_CTL___2 = 64,
	PCR_PHY_CTL2___2 = 144,
	PCR_DEV_CTRL___2 = 120,
	PCR_LINK_STAT___2 = 130,
};

enum pci_dev_flags {
	PCI_DEV_FLAGS_MSI_INTX_DISABLE_BUG = 1,
	PCI_DEV_FLAGS_NO_D3 = 2,
	PCI_DEV_FLAGS_ASSIGNED = 4,
	PCI_DEV_FLAGS_ACS_ENABLED_QUIRK = 8,
	PCI_DEV_FLAG_PCIE_BRIDGE_ALIAS = 32,
	PCI_DEV_FLAGS_NO_BUS_RESET = 64,
	PCI_DEV_FLAGS_NO_PM_RESET = 128,
	PCI_DEV_FLAGS_VPD_REF_F0 = 256,
	PCI_DEV_FLAGS_BRIDGE_XLATE_ROOT = 512,
	PCI_DEV_FLAGS_NO_FLR_RESET = 1024,
	PCI_DEV_FLAGS_NO_RELAXED_ORDERING = 2048,
	PCI_DEV_FLAGS_HAS_MSI_MASKING = 4096,
};

enum pci_epc_bar_type {
	BAR_PROGRAMMABLE = 0,
	BAR_FIXED = 1,
	BAR_RESERVED = 2,
};

enum pci_epc_interface_type {
	UNKNOWN_INTERFACE = -1,
	PRIMARY_INTERFACE = 0,
	SECONDARY_INTERFACE = 1,
};

enum pci_ers_result {
	PCI_ERS_RESULT_NONE = 1,
	PCI_ERS_RESULT_CAN_RECOVER = 2,
	PCI_ERS_RESULT_NEED_RESET = 3,
	PCI_ERS_RESULT_DISCONNECT = 4,
	PCI_ERS_RESULT_RECOVERED = 5,
	PCI_ERS_RESULT_NO_AER_DRIVER = 6,
};

enum pci_fixup_pass {
	pci_fixup_early = 0,
	pci_fixup_header = 1,
	pci_fixup_final = 2,
	pci_fixup_enable = 3,
	pci_fixup_resume = 4,
	pci_fixup_suspend = 5,
	pci_fixup_resume_early = 6,
	pci_fixup_suspend_late = 7,
};

enum pci_interrupt_cause {
	MVS_IRQ_COM_IN_I2O_IOP0 = 1,
	MVS_IRQ_COM_IN_I2O_IOP1 = 2,
	MVS_IRQ_COM_IN_I2O_IOP2 = 4,
	MVS_IRQ_COM_IN_I2O_IOP3 = 8,
	MVS_IRQ_COM_OUT_I2O_HOS0 = 16,
	MVS_IRQ_COM_OUT_I2O_HOS1 = 32,
	MVS_IRQ_COM_OUT_I2O_HOS2 = 64,
	MVS_IRQ_COM_OUT_I2O_HOS3 = 128,
	MVS_IRQ_PCIF_TO_CPU_DRBL0 = 256,
	MVS_IRQ_PCIF_TO_CPU_DRBL1 = 512,
	MVS_IRQ_PCIF_TO_CPU_DRBL2 = 1024,
	MVS_IRQ_PCIF_TO_CPU_DRBL3 = 2048,
	MVS_IRQ_PCIF_DRBL0 = 4096,
	MVS_IRQ_PCIF_DRBL1 = 8192,
	MVS_IRQ_PCIF_DRBL2 = 16384,
	MVS_IRQ_PCIF_DRBL3 = 32768,
	MVS_IRQ_XOR_A = 65536,
	MVS_IRQ_XOR_B = 131072,
	MVS_IRQ_SAS_A = 262144,
	MVS_IRQ_SAS_B = 524288,
	MVS_IRQ_CPU_CNTRL = 1048576,
	MVS_IRQ_GPIO = 2097152,
	MVS_IRQ_UART = 4194304,
	MVS_IRQ_SPI = 8388608,
	MVS_IRQ_I2C = 16777216,
	MVS_IRQ_SGPIO = 33554432,
	MVS_IRQ_COM_ERR = 536870912,
	MVS_IRQ_I2O_ERR = 1073741824,
	MVS_IRQ_PCIE_ERR = -2147483648,
};

enum pci_interrupt_pin {
	PCI_INTERRUPT_UNKNOWN = 0,
	PCI_INTERRUPT_INTA = 1,
	PCI_INTERRUPT_INTB = 2,
	PCI_INTERRUPT_INTC = 3,
	PCI_INTERRUPT_INTD = 4,
};

enum pci_mmap_api {
	PCI_MMAP_SYSFS = 0,
	PCI_MMAP_PROCFS = 1,
};

enum pci_mmap_state {
	pci_mmap_io = 0,
	pci_mmap_mem = 1,
};

enum pci_p2pdma_map_type {
	PCI_P2PDMA_MAP_UNKNOWN = 0,
	PCI_P2PDMA_MAP_NOT_SUPPORTED = 1,
	PCI_P2PDMA_MAP_BUS_ADDR = 2,
	PCI_P2PDMA_MAP_THRU_HOST_BRIDGE = 3,
};

enum pcie_bus_config_types {
	PCIE_BUS_TUNE_OFF = 0,
	PCIE_BUS_DEFAULT = 1,
	PCIE_BUS_SAFE = 2,
	PCIE_BUS_PERFORMANCE = 3,
	PCIE_BUS_PEER2PEER = 4,
};

enum pcie_data_rate {
	PCIE_GEN1 = 0,
	PCIE_GEN2 = 1,
	PCIE_GEN3 = 2,
	PCIE_GEN4 = 3,
};

enum pcie_link_width {
	PCIE_LNK_WIDTH_RESRV = 0,
	PCIE_LNK_X1 = 1,
	PCIE_LNK_X2 = 2,
	PCIE_LNK_X4 = 4,
	PCIE_LNK_X8 = 8,
	PCIE_LNK_X12 = 12,
	PCIE_LNK_X16 = 16,
	PCIE_LNK_X32 = 32,
	PCIE_LNK_WIDTH_UNKNOWN = 255,
};

enum pcie_memwin {
	MEMWIN_NIC = 0,
	MEMWIN_RSVD1 = 1,
	MEMWIN_RSVD2 = 2,
	MEMWIN_RDMA = 3,
	MEMWIN_RSVD4 = 4,
	MEMWIN_FOISCSI = 5,
	MEMWIN_CSIOSTOR = 6,
	MEMWIN_RSVD7 = 7,
};

enum pcie_reset_state {
	pcie_deassert_reset = 1,
	pcie_warm_reset = 2,
	pcie_hot_reset = 3,
};

enum pcpu_fc {
	PCPU_FC_AUTO = 0,
	PCPU_FC_EMBED = 1,
	PCPU_FC_PAGE = 2,
	PCPU_FC_NR = 3,
};

enum pdc_packet_bits {
	PDC_PKT_READ = 4,
	PDC_PKT_NODATA = 8,
	PDC_PKT_SIZEMASK = 224,
	PDC_PKT_CLEAR_BSY = 16,
	PDC_PKT_WAIT_DRDY = 24,
	PDC_LAST_REG = 8,
	PDC_REG_DEVCTL = 14,
};

enum pedit_cmd {
	TCA_PEDIT_KEY_EX_CMD_SET = 0,
	TCA_PEDIT_KEY_EX_CMD_ADD = 1,
	__PEDIT_CMD_MAX = 2,
};

enum pedit_header_type {
	TCA_PEDIT_KEY_EX_HDR_TYPE_NETWORK = 0,
	TCA_PEDIT_KEY_EX_HDR_TYPE_ETH = 1,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP4 = 2,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP6 = 3,
	TCA_PEDIT_KEY_EX_HDR_TYPE_TCP = 4,
	TCA_PEDIT_KEY_EX_HDR_TYPE_UDP = 5,
	__PEDIT_HDR_TYPE_MAX = 6,
};

enum peer_app_attr {
	DCB_ATTR_CEE_PEER_APP_UNSPEC = 0,
	DCB_ATTR_CEE_PEER_APP_INFO = 1,
	DCB_ATTR_CEE_PEER_APP = 2,
	__DCB_ATTR_CEE_PEER_APP_MAX = 3,
};

enum perf_addr_filter_action_t {
	PERF_ADDR_FILTER_ACTION_STOP = 0,
	PERF_ADDR_FILTER_ACTION_START = 1,
	PERF_ADDR_FILTER_ACTION_FILTER = 2,
};

enum perf_bpf_event_type {
	PERF_BPF_EVENT_UNKNOWN = 0,
	PERF_BPF_EVENT_PROG_LOAD = 1,
	PERF_BPF_EVENT_PROG_UNLOAD = 2,
	PERF_BPF_EVENT_MAX = 3,
};

enum perf_branch_sample_type {
	PERF_SAMPLE_BRANCH_USER = 1,
	PERF_SAMPLE_BRANCH_KERNEL = 2,
	PERF_SAMPLE_BRANCH_HV = 4,
	PERF_SAMPLE_BRANCH_ANY = 8,
	PERF_SAMPLE_BRANCH_ANY_CALL = 16,
	PERF_SAMPLE_BRANCH_ANY_RETURN = 32,
	PERF_SAMPLE_BRANCH_IND_CALL = 64,
	PERF_SAMPLE_BRANCH_ABORT_TX = 128,
	PERF_SAMPLE_BRANCH_IN_TX = 256,
	PERF_SAMPLE_BRANCH_NO_TX = 512,
	PERF_SAMPLE_BRANCH_COND = 1024,
	PERF_SAMPLE_BRANCH_CALL_STACK = 2048,
	PERF_SAMPLE_BRANCH_IND_JUMP = 4096,
	PERF_SAMPLE_BRANCH_CALL = 8192,
	PERF_SAMPLE_BRANCH_NO_FLAGS = 16384,
	PERF_SAMPLE_BRANCH_NO_CYCLES = 32768,
	PERF_SAMPLE_BRANCH_TYPE_SAVE = 65536,
	PERF_SAMPLE_BRANCH_HW_INDEX = 131072,
	PERF_SAMPLE_BRANCH_PRIV_SAVE = 262144,
	PERF_SAMPLE_BRANCH_COUNTERS = 524288,
	PERF_SAMPLE_BRANCH_MAX = 1048576,
};

enum perf_branch_sample_type_shift {
	PERF_SAMPLE_BRANCH_USER_SHIFT = 0,
	PERF_SAMPLE_BRANCH_KERNEL_SHIFT = 1,
	PERF_SAMPLE_BRANCH_HV_SHIFT = 2,
	PERF_SAMPLE_BRANCH_ANY_SHIFT = 3,
	PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT = 4,
	PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT = 5,
	PERF_SAMPLE_BRANCH_IND_CALL_SHIFT = 6,
	PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT = 7,
	PERF_SAMPLE_BRANCH_IN_TX_SHIFT = 8,
	PERF_SAMPLE_BRANCH_NO_TX_SHIFT = 9,
	PERF_SAMPLE_BRANCH_COND_SHIFT = 10,
	PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT = 11,
	PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT = 12,
	PERF_SAMPLE_BRANCH_CALL_SHIFT = 13,
	PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT = 14,
	PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT = 15,
	PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT = 16,
	PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT = 17,
	PERF_SAMPLE_BRANCH_PRIV_SAVE_SHIFT = 18,
	PERF_SAMPLE_BRANCH_COUNTERS_SHIFT = 19,
	PERF_SAMPLE_BRANCH_MAX_SHIFT = 20,
};

enum perf_callchain_context {
	PERF_CONTEXT_HV = 18446744073709551584ULL,
	PERF_CONTEXT_KERNEL = 18446744073709551488ULL,
	PERF_CONTEXT_USER = 18446744073709551104ULL,
	PERF_CONTEXT_GUEST = 18446744073709549568ULL,
	PERF_CONTEXT_GUEST_KERNEL = 18446744073709549440ULL,
	PERF_CONTEXT_GUEST_USER = 18446744073709549056ULL,
	PERF_CONTEXT_MAX = 18446744073709547521ULL,
};

enum perf_event_ioc_flags {
	PERF_IOC_FLAG_GROUP = 1,
};

enum perf_event_powerpc_regs {
	PERF_REG_POWERPC_R0 = 0,
	PERF_REG_POWERPC_R1 = 1,
	PERF_REG_POWERPC_R2 = 2,
	PERF_REG_POWERPC_R3 = 3,
	PERF_REG_POWERPC_R4 = 4,
	PERF_REG_POWERPC_R5 = 5,
	PERF_REG_POWERPC_R6 = 6,
	PERF_REG_POWERPC_R7 = 7,
	PERF_REG_POWERPC_R8 = 8,
	PERF_REG_POWERPC_R9 = 9,
	PERF_REG_POWERPC_R10 = 10,
	PERF_REG_POWERPC_R11 = 11,
	PERF_REG_POWERPC_R12 = 12,
	PERF_REG_POWERPC_R13 = 13,
	PERF_REG_POWERPC_R14 = 14,
	PERF_REG_POWERPC_R15 = 15,
	PERF_REG_POWERPC_R16 = 16,
	PERF_REG_POWERPC_R17 = 17,
	PERF_REG_POWERPC_R18 = 18,
	PERF_REG_POWERPC_R19 = 19,
	PERF_REG_POWERPC_R20 = 20,
	PERF_REG_POWERPC_R21 = 21,
	PERF_REG_POWERPC_R22 = 22,
	PERF_REG_POWERPC_R23 = 23,
	PERF_REG_POWERPC_R24 = 24,
	PERF_REG_POWERPC_R25 = 25,
	PERF_REG_POWERPC_R26 = 26,
	PERF_REG_POWERPC_R27 = 27,
	PERF_REG_POWERPC_R28 = 28,
	PERF_REG_POWERPC_R29 = 29,
	PERF_REG_POWERPC_R30 = 30,
	PERF_REG_POWERPC_R31 = 31,
	PERF_REG_POWERPC_NIP = 32,
	PERF_REG_POWERPC_MSR = 33,
	PERF_REG_POWERPC_ORIG_R3 = 34,
	PERF_REG_POWERPC_CTR = 35,
	PERF_REG_POWERPC_LINK = 36,
	PERF_REG_POWERPC_XER = 37,
	PERF_REG_POWERPC_CCR = 38,
	PERF_REG_POWERPC_SOFTE = 39,
	PERF_REG_POWERPC_TRAP = 40,
	PERF_REG_POWERPC_DAR = 41,
	PERF_REG_POWERPC_DSISR = 42,
	PERF_REG_POWERPC_SIER = 43,
	PERF_REG_POWERPC_MMCRA = 44,
	PERF_REG_POWERPC_MMCR0 = 45,
	PERF_REG_POWERPC_MMCR1 = 46,
	PERF_REG_POWERPC_MMCR2 = 47,
	PERF_REG_POWERPC_MMCR3 = 48,
	PERF_REG_POWERPC_SIER2 = 49,
	PERF_REG_POWERPC_SIER3 = 50,
	PERF_REG_POWERPC_PMC1 = 51,
	PERF_REG_POWERPC_PMC2 = 52,
	PERF_REG_POWERPC_PMC3 = 53,
	PERF_REG_POWERPC_PMC4 = 54,
	PERF_REG_POWERPC_PMC5 = 55,
	PERF_REG_POWERPC_PMC6 = 56,
	PERF_REG_POWERPC_SDAR = 57,
	PERF_REG_POWERPC_SIAR = 58,
	PERF_REG_POWERPC_MAX = 45,
	PERF_REG_EXTENDED_MAX = 59,
};

enum perf_event_read_format {
	PERF_FORMAT_TOTAL_TIME_ENABLED = 1,
	PERF_FORMAT_TOTAL_TIME_RUNNING = 2,
	PERF_FORMAT_ID = 4,
	PERF_FORMAT_GROUP = 8,
	PERF_FORMAT_LOST = 16,
	PERF_FORMAT_MAX = 32,
};

enum perf_event_sample_format {
	PERF_SAMPLE_IP = 1,
	PERF_SAMPLE_TID = 2,
	PERF_SAMPLE_TIME = 4,
	PERF_SAMPLE_ADDR = 8,
	PERF_SAMPLE_READ = 16,
	PERF_SAMPLE_CALLCHAIN = 32,
	PERF_SAMPLE_ID = 64,
	PERF_SAMPLE_CPU = 128,
	PERF_SAMPLE_PERIOD = 256,
	PERF_SAMPLE_STREAM_ID = 512,
	PERF_SAMPLE_RAW = 1024,
	PERF_SAMPLE_BRANCH_STACK = 2048,
	PERF_SAMPLE_REGS_USER = 4096,
	PERF_SAMPLE_STACK_USER = 8192,
	PERF_SAMPLE_WEIGHT = 16384,
	PERF_SAMPLE_DATA_SRC = 32768,
	PERF_SAMPLE_IDENTIFIER = 65536,
	PERF_SAMPLE_TRANSACTION = 131072,
	PERF_SAMPLE_REGS_INTR = 262144,
	PERF_SAMPLE_PHYS_ADDR = 524288,
	PERF_SAMPLE_AUX = 1048576,
	PERF_SAMPLE_CGROUP = 2097152,
	PERF_SAMPLE_DATA_PAGE_SIZE = 4194304,
	PERF_SAMPLE_CODE_PAGE_SIZE = 8388608,
	PERF_SAMPLE_WEIGHT_STRUCT = 16777216,
	PERF_SAMPLE_MAX = 33554432,
};

enum perf_event_state {
	PERF_EVENT_STATE_DEAD = -4,
	PERF_EVENT_STATE_EXIT = -3,
	PERF_EVENT_STATE_ERROR = -2,
	PERF_EVENT_STATE_OFF = -1,
	PERF_EVENT_STATE_INACTIVE = 0,
	PERF_EVENT_STATE_ACTIVE = 1,
};

enum perf_event_task_context {
	perf_invalid_context = -1,
	perf_hw_context = 0,
	perf_sw_context = 1,
	perf_nr_task_contexts = 2,
};

enum perf_event_type {
	PERF_RECORD_MMAP = 1,
	PERF_RECORD_LOST = 2,
	PERF_RECORD_COMM = 3,
	PERF_RECORD_EXIT = 4,
	PERF_RECORD_THROTTLE = 5,
	PERF_RECORD_UNTHROTTLE = 6,
	PERF_RECORD_FORK = 7,
	PERF_RECORD_READ = 8,
	PERF_RECORD_SAMPLE = 9,
	PERF_RECORD_MMAP2 = 10,
	PERF_RECORD_AUX = 11,
	PERF_RECORD_ITRACE_START = 12,
	PERF_RECORD_LOST_SAMPLES = 13,
	PERF_RECORD_SWITCH = 14,
	PERF_RECORD_SWITCH_CPU_WIDE = 15,
	PERF_RECORD_NAMESPACES = 16,
	PERF_RECORD_KSYMBOL = 17,
	PERF_RECORD_BPF_EVENT = 18,
	PERF_RECORD_CGROUP = 19,
	PERF_RECORD_TEXT_POKE = 20,
	PERF_RECORD_AUX_OUTPUT_HW_ID = 21,
	PERF_RECORD_MAX = 22,
};

enum perf_hw_cache_id {
	PERF_COUNT_HW_CACHE_L1D = 0,
	PERF_COUNT_HW_CACHE_L1I = 1,
	PERF_COUNT_HW_CACHE_LL = 2,
	PERF_COUNT_HW_CACHE_DTLB = 3,
	PERF_COUNT_HW_CACHE_ITLB = 4,
	PERF_COUNT_HW_CACHE_BPU = 5,
	PERF_COUNT_HW_CACHE_NODE = 6,
	PERF_COUNT_HW_CACHE_MAX = 7,
};

enum perf_hw_cache_op_id {
	PERF_COUNT_HW_CACHE_OP_READ = 0,
	PERF_COUNT_HW_CACHE_OP_WRITE = 1,
	PERF_COUNT_HW_CACHE_OP_PREFETCH = 2,
	PERF_COUNT_HW_CACHE_OP_MAX = 3,
};

enum perf_hw_cache_op_result_id {
	PERF_COUNT_HW_CACHE_RESULT_ACCESS = 0,
	PERF_COUNT_HW_CACHE_RESULT_MISS = 1,
	PERF_COUNT_HW_CACHE_RESULT_MAX = 2,
};

enum perf_hw_id {
	PERF_COUNT_HW_CPU_CYCLES = 0,
	PERF_COUNT_HW_INSTRUCTIONS = 1,
	PERF_COUNT_HW_CACHE_REFERENCES = 2,
	PERF_COUNT_HW_CACHE_MISSES = 3,
	PERF_COUNT_HW_BRANCH_INSTRUCTIONS = 4,
	PERF_COUNT_HW_BRANCH_MISSES = 5,
	PERF_COUNT_HW_BUS_CYCLES = 6,
	PERF_COUNT_HW_STALLED_CYCLES_FRONTEND = 7,
	PERF_COUNT_HW_STALLED_CYCLES_BACKEND = 8,
	PERF_COUNT_HW_REF_CPU_CYCLES = 9,
	PERF_COUNT_HW_MAX = 10,
};

enum perf_probe_config {
	PERF_PROBE_CONFIG_IS_RETPROBE = 1,
	PERF_UPROBE_REF_CTR_OFFSET_BITS = 32,
	PERF_UPROBE_REF_CTR_OFFSET_SHIFT = 32,
};

enum perf_record_ksymbol_type {
	PERF_RECORD_KSYMBOL_TYPE_UNKNOWN = 0,
	PERF_RECORD_KSYMBOL_TYPE_BPF = 1,
	PERF_RECORD_KSYMBOL_TYPE_OOL = 2,
	PERF_RECORD_KSYMBOL_TYPE_MAX = 3,
};

enum perf_sample_regs_abi {
	PERF_SAMPLE_REGS_ABI_NONE = 0,
	PERF_SAMPLE_REGS_ABI_32 = 1,
	PERF_SAMPLE_REGS_ABI_64 = 2,
};

enum perf_sw_ids {
	PERF_COUNT_SW_CPU_CLOCK = 0,
	PERF_COUNT_SW_TASK_CLOCK = 1,
	PERF_COUNT_SW_PAGE_FAULTS = 2,
	PERF_COUNT_SW_CONTEXT_SWITCHES = 3,
	PERF_COUNT_SW_CPU_MIGRATIONS = 4,
	PERF_COUNT_SW_PAGE_FAULTS_MIN = 5,
	PERF_COUNT_SW_PAGE_FAULTS_MAJ = 6,
	PERF_COUNT_SW_ALIGNMENT_FAULTS = 7,
	PERF_COUNT_SW_EMULATION_FAULTS = 8,
	PERF_COUNT_SW_DUMMY = 9,
	PERF_COUNT_SW_BPF_OUTPUT = 10,
	PERF_COUNT_SW_CGROUP_SWITCHES = 11,
	PERF_COUNT_SW_MAX = 12,
};

enum perf_type_id {
	PERF_TYPE_HARDWARE = 0,
	PERF_TYPE_SOFTWARE = 1,
	PERF_TYPE_TRACEPOINT = 2,
	PERF_TYPE_HW_CACHE = 3,
	PERF_TYPE_RAW = 4,
	PERF_TYPE_BREAKPOINT = 5,
	PERF_TYPE_MAX = 6,
};

enum pgdat_flags {
	PGDAT_DIRTY = 0,
	PGDAT_WRITEBACK = 1,
	PGDAT_RECLAIM_LOCKED = 2,
};

enum pgt_entry {
	NORMAL_PMD = 0,
	HPAGE_PMD = 1,
	NORMAL_PUD = 2,
	HPAGE_PUD = 3,
};

enum pgtable_index {
	PTE_INDEX = 0,
	PMD_INDEX = 1,
	PUD_INDEX = 2,
	PGD_INDEX = 3,
	HTLB_16M_INDEX = 4,
	HTLB_16G_INDEX = 5,
};

enum phy_control_type {
	PHY_LINK_RESET = 1,
	PHY_HARD_RESET = 2,
	PHY_NOTIFY_ENABLE_SPINUP = 16,
};

enum phy_event {
	PHYE_LOSS_OF_SIGNAL = 0,
	PHYE_OOB_DONE = 1,
	PHYE_OOB_ERROR = 2,
	PHYE_SPINUP_HOLD = 3,
	PHYE_RESUME_TIMEOUT = 4,
	PHYE_SHUTDOWN = 5,
	PHY_NUM_EVENTS = 6,
};

enum phy_func {
	PHY_FUNC_NOP = 0,
	PHY_FUNC_LINK_RESET = 1,
	PHY_FUNC_HARD_RESET = 2,
	PHY_FUNC_DISABLE = 3,
	PHY_FUNC_CLEAR_ERROR_LOG = 5,
	PHY_FUNC_CLEAR_AFFIL = 6,
	PHY_FUNC_TX_SATA_PS_SIGNAL = 7,
	PHY_FUNC_RELEASE_SPINUP_HOLD = 16,
	PHY_FUNC_SET_LINK_RATE = 17,
	PHY_FUNC_GET_EVENTS = 18,
};

enum phy_media {
	PHY_MEDIA_DEFAULT = 0,
	PHY_MEDIA_SR = 1,
	PHY_MEDIA_DAC = 2,
};

enum phy_mode {
	PHY_MODE_INVALID = 0,
	PHY_MODE_USB_HOST = 1,
	PHY_MODE_USB_HOST_LS = 2,
	PHY_MODE_USB_HOST_FS = 3,
	PHY_MODE_USB_HOST_HS = 4,
	PHY_MODE_USB_HOST_SS = 5,
	PHY_MODE_USB_DEVICE = 6,
	PHY_MODE_USB_DEVICE_LS = 7,
	PHY_MODE_USB_DEVICE_FS = 8,
	PHY_MODE_USB_DEVICE_HS = 9,
	PHY_MODE_USB_DEVICE_SS = 10,
	PHY_MODE_USB_OTG = 11,
	PHY_MODE_UFS_HS_A = 12,
	PHY_MODE_UFS_HS_B = 13,
	PHY_MODE_PCIE = 14,
	PHY_MODE_ETHERNET = 15,
	PHY_MODE_MIPI_DPHY = 16,
	PHY_MODE_SATA = 17,
	PHY_MODE_LVDS = 18,
	PHY_MODE_DP = 19,
};

enum phy_speed {
	PHY_SPEED_15 = 1,
	PHY_SPEED_30 = 2,
	PHY_SPEED_60 = 4,
	PHY_SPEED_120 = 8,
};

enum phy_state {
	PHY_DOWN = 0,
	PHY_READY = 1,
	PHY_HALTED = 2,
	PHY_ERROR = 3,
	PHY_UP = 4,
	PHY_RUNNING = 5,
	PHY_NOLINK = 6,
	PHY_CABLETEST = 7,
};

enum phy_tunable_id {
	ETHTOOL_PHY_ID_UNSPEC = 0,
	ETHTOOL_PHY_DOWNSHIFT = 1,
	ETHTOOL_PHY_FAST_LINK_DOWN = 2,
	ETHTOOL_PHY_EDPD = 3,
	__ETHTOOL_PHY_TUNABLE_COUNT = 4,
};

enum phylink_op_type {
	PHYLINK_NETDEV = 0,
	PHYLINK_DEV = 1,
};

enum pid_type {
	PIDTYPE_PID = 0,
	PIDTYPE_TGID = 1,
	PIDTYPE_PGID = 2,
	PIDTYPE_SID = 3,
	PIDTYPE_MAX = 4,
};

enum piix_controller_ids {
	piix_pata_mwdma = 0,
	piix_pata_33 = 1,
	ich_pata_33 = 2,
	ich_pata_66 = 3,
	ich_pata_100 = 4,
	ich_pata_100_nomwdma1 = 5,
	ich5_sata = 6,
	ich6_sata = 7,
	ich6m_sata = 8,
	ich8_sata = 9,
	ich8_2port_sata = 10,
	ich8m_apple_sata = 11,
	tolapai_sata = 12,
	piix_pata_vmw = 13,
	ich8_sata_snb = 14,
	ich8_2port_sata_snb = 15,
	ich8_2port_sata_byt = 16,
};

enum pin_config_param {
	PIN_CONFIG_BIAS_BUS_HOLD = 0,
	PIN_CONFIG_BIAS_DISABLE = 1,
	PIN_CONFIG_BIAS_HIGH_IMPEDANCE = 2,
	PIN_CONFIG_BIAS_PULL_DOWN = 3,
	PIN_CONFIG_BIAS_PULL_PIN_DEFAULT = 4,
	PIN_CONFIG_BIAS_PULL_UP = 5,
	PIN_CONFIG_DRIVE_OPEN_DRAIN = 6,
	PIN_CONFIG_DRIVE_OPEN_SOURCE = 7,
	PIN_CONFIG_DRIVE_PUSH_PULL = 8,
	PIN_CONFIG_DRIVE_STRENGTH = 9,
	PIN_CONFIG_DRIVE_STRENGTH_UA = 10,
	PIN_CONFIG_INPUT_DEBOUNCE = 11,
	PIN_CONFIG_INPUT_ENABLE = 12,
	PIN_CONFIG_INPUT_SCHMITT = 13,
	PIN_CONFIG_INPUT_SCHMITT_ENABLE = 14,
	PIN_CONFIG_MODE_LOW_POWER = 15,
	PIN_CONFIG_MODE_PWM = 16,
	PIN_CONFIG_OUTPUT = 17,
	PIN_CONFIG_OUTPUT_ENABLE = 18,
	PIN_CONFIG_OUTPUT_IMPEDANCE_OHMS = 19,
	PIN_CONFIG_PERSIST_STATE = 20,
	PIN_CONFIG_POWER_SOURCE = 21,
	PIN_CONFIG_SKEW_DELAY = 22,
	PIN_CONFIG_SLEEP_HARDWARE_STATE = 23,
	PIN_CONFIG_SLEW_RATE = 24,
	PIN_CONFIG_END = 127,
	PIN_CONFIG_MAX = 255,
};

enum pinctrl_map_type {
	PIN_MAP_TYPE_INVALID = 0,
	PIN_MAP_TYPE_DUMMY_STATE = 1,
	PIN_MAP_TYPE_MUX_GROUP = 2,
	PIN_MAP_TYPE_CONFIGS_PIN = 3,
	PIN_MAP_TYPE_CONFIGS_GROUP = 4,
};

enum pkcs7_actions {
	ACT_pkcs7_check_content_type = 0,
	ACT_pkcs7_extract_cert = 1,
	ACT_pkcs7_note_OID = 2,
	ACT_pkcs7_note_certificate_list = 3,
	ACT_pkcs7_note_content = 4,
	ACT_pkcs7_note_data = 5,
	ACT_pkcs7_note_signed_info = 6,
	ACT_pkcs7_note_signeddata_version = 7,
	ACT_pkcs7_note_signerinfo_version = 8,
	ACT_pkcs7_sig_note_authenticated_attr = 9,
	ACT_pkcs7_sig_note_digest_algo = 10,
	ACT_pkcs7_sig_note_issuer = 11,
	ACT_pkcs7_sig_note_pkey_algo = 12,
	ACT_pkcs7_sig_note_serial = 13,
	ACT_pkcs7_sig_note_set_of_authattrs = 14,
	ACT_pkcs7_sig_note_signature = 15,
	ACT_pkcs7_sig_note_skid = 16,
	NR__pkcs7_actions = 17,
};

enum pkey_id_type {
	PKEY_ID_PGP = 0,
	PKEY_ID_X509 = 1,
	PKEY_ID_PKCS7 = 2,
};

enum pkt_hash_types {
	PKT_HASH_TYPE_NONE = 0,
	PKT_HASH_TYPE_L2 = 1,
	PKT_HASH_TYPE_L3 = 2,
	PKT_HASH_TYPE_L4 = 3,
};

enum pm8001_hba_info_flags {
	PM8001F_INIT_TIME = 1,
	PM8001F_RUN_TIME = 2,
};

enum pm8606_ref_gp_and_osc_clients {
	REF_GP_NO_CLIENTS = 0,
	WLED1_DUTY = 1,
	WLED2_DUTY = 2,
	WLED3_DUTY = 4,
	RGB1_ENABLE = 8,
	RGB2_ENABLE = 16,
	LDO_VBR_EN = 32,
	REF_GP_MAX_CLIENT = 65535,
};

enum pm_qos_flags_status {
	PM_QOS_FLAGS_UNDEFINED = -1,
	PM_QOS_FLAGS_NONE = 0,
	PM_QOS_FLAGS_SOME = 1,
	PM_QOS_FLAGS_ALL = 2,
};

enum pm_qos_req_action {
	PM_QOS_ADD_REQ = 0,
	PM_QOS_UPDATE_REQ = 1,
	PM_QOS_REMOVE_REQ = 2,
};

enum pm_qos_type {
	PM_QOS_UNITIALIZED = 0,
	PM_QOS_MAX = 1,
	PM_QOS_MIN = 2,
};

enum pnv_phb_model {
	PNV_PHB_MODEL_UNKNOWN = 0,
	PNV_PHB_MODEL_P7IOC = 1,
	PNV_PHB_MODEL_PHB3 = 2,
};

enum pnv_phb_type {
	PNV_PHB_IODA2 = 0,
	PNV_PHB_NPU_OCAPI = 1,
};

enum poison_cmd_enabled_bits {
	CXL_POISON_ENABLED_LIST = 0,
	CXL_POISON_ENABLED_INJECT = 1,
	CXL_POISON_ENABLED_CLEAR = 2,
	CXL_POISON_ENABLED_SCAN_CAPS = 3,
	CXL_POISON_ENABLED_SCAN_MEDIA = 4,
	CXL_POISON_ENABLED_SCAN_RESULTS = 5,
	CXL_POISON_ENABLED_MAX = 6,
};

enum poll_time_type {
	PT_TIMEVAL = 0,
	PT_OLD_TIMEVAL = 1,
	PT_TIMESPEC = 2,
	PT_OLD_TIMESPEC = 3,
};

enum polling_modes {
	CM_POLL_DISABLE = 0,
	CM_POLL_ALWAYS = 1,
	CM_POLL_EXTERNAL_POWER_ONLY = 2,
	CM_POLL_CHARGING_ONLY = 3,
};

enum pool_workqueue_stats {
	PWQ_STAT_STARTED = 0,
	PWQ_STAT_COMPLETED = 1,
	PWQ_STAT_CPU_TIME = 2,
	PWQ_STAT_CPU_INTENSIVE = 3,
	PWQ_STAT_CM_WAKEUP = 4,
	PWQ_STAT_REPATRIATED = 5,
	PWQ_STAT_MAYDAY = 6,
	PWQ_STAT_RESCUED = 7,
	PWQ_NR_STATS = 8,
};

enum port_event {
	PORTE_BYTES_DMAED = 0,
	PORTE_BROADCAST_RCVD = 1,
	PORTE_LINK_RESET_ERR = 2,
	PORTE_TIMER_EVENT = 3,
	PORTE_HARD_RESET = 4,
	PORT_NUM_EVENTS = 5,
};

enum port_fdmi_event {
	FDMISM_EVENT_PORT_ONLINE = 1,
	FDMISM_EVENT_PORT_OFFLINE = 2,
	FDMISM_EVENT_RSP_OK = 4,
	FDMISM_EVENT_RSP_ERROR = 5,
	FDMISM_EVENT_TIMEOUT = 6,
	FDMISM_EVENT_RHBA_SENT = 7,
	FDMISM_EVENT_RPRT_SENT = 8,
	FDMISM_EVENT_RPA_SENT = 9,
};

enum port_ms_event {
	MSSM_EVENT_PORT_ONLINE = 1,
	MSSM_EVENT_PORT_OFFLINE = 2,
	MSSM_EVENT_RSP_OK = 3,
	MSSM_EVENT_RSP_ERROR = 4,
	MSSM_EVENT_TIMEOUT = 5,
	MSSM_EVENT_FCXP_SENT = 6,
	MSSM_EVENT_PORT_FABRIC_RSCN = 7,
};

enum port_pkey_state {
	IB_PORT_PKEY_NOT_VALID = 0,
	IB_PORT_PKEY_VALID = 1,
	IB_PORT_PKEY_LISTED = 2,
};

enum port_scn_event {
	SCNSM_EVENT_PORT_ONLINE = 1,
	SCNSM_EVENT_PORT_OFFLINE = 2,
	SCNSM_EVENT_RSP_OK = 3,
	SCNSM_EVENT_RSP_ERROR = 4,
	SCNSM_EVENT_TIMEOUT = 5,
	SCNSM_EVENT_SCR_SENT = 6,
};

enum port_type {
	PORT_TYPE_SAS___2 = 2,
	PORT_TYPE_SATA___2 = 1,
};

enum positive_aop_returns {
	AOP_WRITEPAGE_ACTIVATE = 524288,
	AOP_TRUNCATED_PAGE = 524289,
};

enum power_desc_param_offset {
	PWR_DESC_LEN = 0,
	PWR_DESC_TYPE = 1,
	PWR_DESC_ACTIVE_LVLS_VCC_0 = 2,
	PWR_DESC_ACTIVE_LVLS_VCCQ_0 = 34,
	PWR_DESC_ACTIVE_LVLS_VCCQ2_0 = 66,
};

enum power_supply_charge_behaviour {
	POWER_SUPPLY_CHARGE_BEHAVIOUR_AUTO = 0,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE = 1,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_FORCE_DISCHARGE = 2,
};

enum power_supply_notifier_events {
	PSY_EVENT_PROP_CHANGED = 0,
};

enum power_supply_property {
	POWER_SUPPLY_PROP_STATUS = 0,
	POWER_SUPPLY_PROP_CHARGE_TYPE = 1,
	POWER_SUPPLY_PROP_HEALTH = 2,
	POWER_SUPPLY_PROP_PRESENT = 3,
	POWER_SUPPLY_PROP_ONLINE = 4,
	POWER_SUPPLY_PROP_AUTHENTIC = 5,
	POWER_SUPPLY_PROP_TECHNOLOGY = 6,
	POWER_SUPPLY_PROP_CYCLE_COUNT = 7,
	POWER_SUPPLY_PROP_VOLTAGE_MAX = 8,
	POWER_SUPPLY_PROP_VOLTAGE_MIN = 9,
	POWER_SUPPLY_PROP_VOLTAGE_MAX_DESIGN = 10,
	POWER_SUPPLY_PROP_VOLTAGE_MIN_DESIGN = 11,
	POWER_SUPPLY_PROP_VOLTAGE_NOW = 12,
	POWER_SUPPLY_PROP_VOLTAGE_AVG = 13,
	POWER_SUPPLY_PROP_VOLTAGE_OCV = 14,
	POWER_SUPPLY_PROP_VOLTAGE_BOOT = 15,
	POWER_SUPPLY_PROP_CURRENT_MAX = 16,
	POWER_SUPPLY_PROP_CURRENT_NOW = 17,
	POWER_SUPPLY_PROP_CURRENT_AVG = 18,
	POWER_SUPPLY_PROP_CURRENT_BOOT = 19,
	POWER_SUPPLY_PROP_POWER_NOW = 20,
	POWER_SUPPLY_PROP_POWER_AVG = 21,
	POWER_SUPPLY_PROP_CHARGE_FULL_DESIGN = 22,
	POWER_SUPPLY_PROP_CHARGE_EMPTY_DESIGN = 23,
	POWER_SUPPLY_PROP_CHARGE_FULL = 24,
	POWER_SUPPLY_PROP_CHARGE_EMPTY = 25,
	POWER_SUPPLY_PROP_CHARGE_NOW = 26,
	POWER_SUPPLY_PROP_CHARGE_AVG = 27,
	POWER_SUPPLY_PROP_CHARGE_COUNTER = 28,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT = 29,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT_MAX = 30,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE = 31,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE_MAX = 32,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT = 33,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT_MAX = 34,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_START_THRESHOLD = 35,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_END_THRESHOLD = 36,
	POWER_SUPPLY_PROP_CHARGE_BEHAVIOUR = 37,
	POWER_SUPPLY_PROP_INPUT_CURRENT_LIMIT = 38,
	POWER_SUPPLY_PROP_INPUT_VOLTAGE_LIMIT = 39,
	POWER_SUPPLY_PROP_INPUT_POWER_LIMIT = 40,
	POWER_SUPPLY_PROP_ENERGY_FULL_DESIGN = 41,
	POWER_SUPPLY_PROP_ENERGY_EMPTY_DESIGN = 42,
	POWER_SUPPLY_PROP_ENERGY_FULL = 43,
	POWER_SUPPLY_PROP_ENERGY_EMPTY = 44,
	POWER_SUPPLY_PROP_ENERGY_NOW = 45,
	POWER_SUPPLY_PROP_ENERGY_AVG = 46,
	POWER_SUPPLY_PROP_CAPACITY = 47,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MIN = 48,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MAX = 49,
	POWER_SUPPLY_PROP_CAPACITY_ERROR_MARGIN = 50,
	POWER_SUPPLY_PROP_CAPACITY_LEVEL = 51,
	POWER_SUPPLY_PROP_TEMP = 52,
	POWER_SUPPLY_PROP_TEMP_MAX = 53,
	POWER_SUPPLY_PROP_TEMP_MIN = 54,
	POWER_SUPPLY_PROP_TEMP_ALERT_MIN = 55,
	POWER_SUPPLY_PROP_TEMP_ALERT_MAX = 56,
	POWER_SUPPLY_PROP_TEMP_AMBIENT = 57,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MIN = 58,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MAX = 59,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_NOW = 60,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_AVG = 61,
	POWER_SUPPLY_PROP_TIME_TO_FULL_NOW = 62,
	POWER_SUPPLY_PROP_TIME_TO_FULL_AVG = 63,
	POWER_SUPPLY_PROP_TYPE = 64,
	POWER_SUPPLY_PROP_USB_TYPE = 65,
	POWER_SUPPLY_PROP_SCOPE = 66,
	POWER_SUPPLY_PROP_PRECHARGE_CURRENT = 67,
	POWER_SUPPLY_PROP_CHARGE_TERM_CURRENT = 68,
	POWER_SUPPLY_PROP_CALIBRATE = 69,
	POWER_SUPPLY_PROP_MANUFACTURE_YEAR = 70,
	POWER_SUPPLY_PROP_MANUFACTURE_MONTH = 71,
	POWER_SUPPLY_PROP_MANUFACTURE_DAY = 72,
	POWER_SUPPLY_PROP_MODEL_NAME = 73,
	POWER_SUPPLY_PROP_MANUFACTURER = 74,
	POWER_SUPPLY_PROP_SERIAL_NUMBER = 75,
};

enum power_supply_type {
	POWER_SUPPLY_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_TYPE_BATTERY = 1,
	POWER_SUPPLY_TYPE_UPS = 2,
	POWER_SUPPLY_TYPE_MAINS = 3,
	POWER_SUPPLY_TYPE_USB = 4,
	POWER_SUPPLY_TYPE_USB_DCP = 5,
	POWER_SUPPLY_TYPE_USB_CDP = 6,
	POWER_SUPPLY_TYPE_USB_ACA = 7,
	POWER_SUPPLY_TYPE_USB_TYPE_C = 8,
	POWER_SUPPLY_TYPE_USB_PD = 9,
	POWER_SUPPLY_TYPE_USB_PD_DRP = 10,
	POWER_SUPPLY_TYPE_APPLE_BRICK_ID = 11,
	POWER_SUPPLY_TYPE_WIRELESS = 12,
};

enum power_supply_usb_type {
	POWER_SUPPLY_USB_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_USB_TYPE_SDP = 1,
	POWER_SUPPLY_USB_TYPE_DCP = 2,
	POWER_SUPPLY_USB_TYPE_CDP = 3,
	POWER_SUPPLY_USB_TYPE_ACA = 4,
	POWER_SUPPLY_USB_TYPE_C = 5,
	POWER_SUPPLY_USB_TYPE_PD = 6,
	POWER_SUPPLY_USB_TYPE_PD_DRP = 7,
	POWER_SUPPLY_USB_TYPE_PD_PPS = 8,
	POWER_SUPPLY_USB_TYPE_APPLE_BRICK_ID = 9,
};

enum powerpc_pmc_type {
	PPC_PMC_DEFAULT = 0,
	PPC_PMC_IBM = 1,
	PPC_PMC_PA6T = 2,
	PPC_PMC_G4 = 3,
};

enum powerpc_regset {
	REGSET_GPR = 0,
	REGSET_FPR = 1,
	REGSET_VMX = 2,
	REGSET_VSX = 3,
	REGSET_TM_CGPR = 4,
	REGSET_TM_CFPR = 5,
	REGSET_TM_CVMX = 6,
	REGSET_TM_CVSX = 7,
	REGSET_TM_SPR = 8,
	REGSET_TM_CTAR = 9,
	REGSET_TM_CPPR = 10,
	REGSET_TM_CDSCR = 11,
	REGSET_PPR = 12,
	REGSET_DSCR = 13,
	REGSET_TAR = 14,
	REGSET_EBB = 15,
	REGSET_PMR = 16,
	REGSET_DEXCR = 17,
	REGSET_HASHKEYR = 18,
	REGSET_PKEY = 19,
};

enum ppc_dbell {
	PPC_DBELL = 0,
	PPC_DBELL_CRIT = 1,
	PPC_G_DBELL = 2,
	PPC_G_DBELL_CRIT = 3,
	PPC_G_DBELL_MC = 4,
	PPC_DBELL_SERVER = 5,
};

enum pqi_ctrl_mode {
	SIS_MODE = 0,
	PQI_MODE = 1,
};

enum pqi_ctrl_removal_state {
	PQI_CTRL_PRESENT = 0,
	PQI_CTRL_GRACEFUL_REMOVAL = 1,
	PQI_CTRL_SURPRISE_REMOVAL = 2,
};

enum pqi_ctrl_shutdown_reason {
	PQI_IQ_NOT_DRAINED_TIMEOUT = 1,
	PQI_LUN_RESET_TIMEOUT = 2,
	PQI_IO_PENDING_POST_LUN_RESET_TIMEOUT = 3,
	PQI_NO_HEARTBEAT = 4,
	PQI_FIRMWARE_KERNEL_NOT_UP = 5,
	PQI_OFA_RESPONSE_TIMEOUT = 6,
	PQI_INVALID_REQ_ID = 7,
	PQI_UNMATCHED_REQ_ID = 8,
	PQI_IO_PI_OUT_OF_RANGE = 9,
	PQI_EVENT_PI_OUT_OF_RANGE = 10,
	PQI_UNEXPECTED_IU_TYPE = 11,
};

enum pqi_find_result {
	DEVICE_NOT_FOUND = 0,
	DEVICE_CHANGED = 1,
	DEVICE_SAME = 2,
};

enum pqi_io_path {
	RAID_PATH = 0,
	AIO_PATH = 1,
};

enum pqi_irq_mode {
	IRQ_MODE_NONE = 0,
	IRQ_MODE_INTX = 1,
	IRQ_MODE_MSIX = 2,
};

enum pqi_lockup_action {
	NONE___2 = 0,
	REBOOT = 1,
	PANIC = 2,
};

enum pqi_soft_reset_status {
	RESET_INITIATE_FIRMWARE = 0,
	RESET_INITIATE_DRIVER = 1,
	RESET_ABORT = 2,
	RESET_NORESPONSE = 3,
	RESET_TIMEDOUT = 4,
};

enum pr_status {
	PR_STS_SUCCESS = 0,
	PR_STS_IOERR = 2,
	PR_STS_RESERVATION_CONFLICT = 24,
	PR_STS_RETRY_PATH_FAILURE = 917504,
	PR_STS_PATH_FAST_FAILED = 983040,
	PR_STS_PATH_FAILED = 65536,
};

enum pr_type {
	PR_WRITE_EXCLUSIVE = 1,
	PR_EXCLUSIVE_ACCESS = 2,
	PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum prefault_modes {
	CXL_PREFAULT_NONE = 0,
	CXL_PREFAULT_WED = 1,
	CXL_PREFAULT_ALL = 2,
};

enum prep_dispatch {
	PREP_DISPATCH_OK = 0,
	PREP_DISPATCH_NO_TAG = 1,
	PREP_DISPATCH_NO_BUDGET = 2,
};

enum print_line_t {
	TRACE_TYPE_PARTIAL_LINE = 0,
	TRACE_TYPE_HANDLED = 1,
	TRACE_TYPE_UNHANDLED = 2,
	TRACE_TYPE_NO_CONSUME = 3,
};

enum printk_info_flags {
	LOG_NEWLINE = 2,
	LOG_CONT = 8,
};

enum prio_policy {
	POLICY_NO_CHANGE = 0,
	POLICY_PROMOTE_TO_RT = 1,
	POLICY_RESTRICT_TO_BE = 2,
	POLICY_ALL_TO_IDLE = 3,
	POLICY_NONE_TO_RT = 4,
};

enum probe_print_type {
	PROBE_PRINT_NORMAL = 0,
	PROBE_PRINT_RETURN = 1,
	PROBE_PRINT_EVENT = 2,
};

enum probe_type {
	PROBE_DEFAULT_STRATEGY = 0,
	PROBE_PREFER_ASYNCHRONOUS = 1,
	PROBE_FORCE_SYNCHRONOUS = 2,
};

enum proc_cn_event {
	PROC_EVENT_NONE = 0,
	PROC_EVENT_FORK = 1,
	PROC_EVENT_EXEC = 2,
	PROC_EVENT_UID = 4,
	PROC_EVENT_GID = 64,
	PROC_EVENT_SID = 128,
	PROC_EVENT_PTRACE = 256,
	PROC_EVENT_COMM = 512,
	PROC_EVENT_NONZERO_EXIT = 536870912,
	PROC_EVENT_COREDUMP = 1073741824,
	PROC_EVENT_EXIT = 2147483648,
};

enum proc_cn_mcast_op {
	PROC_CN_MCAST_LISTEN = 1,
	PROC_CN_MCAST_IGNORE = 2,
};

enum proc_hidepid {
	HIDEPID_OFF = 0,
	HIDEPID_NO_ACCESS = 1,
	HIDEPID_INVISIBLE = 2,
	HIDEPID_NOT_PTRACEABLE = 4,
};

enum proc_param {
	Opt_gid___5 = 0,
	Opt_hidepid = 1,
	Opt_subset = 2,
};

enum proc_pidonly {
	PROC_PIDONLY_OFF = 0,
	PROC_PIDONLY_ON = 1,
};

enum profile_mode {
	APPARMOR_ENFORCE = 0,
	APPARMOR_COMPLAIN = 1,
	APPARMOR_KILL = 2,
	APPARMOR_UNCONFINED = 3,
	APPARMOR_USER = 4,
};

enum prs_errcode {
	PERR_NONE = 0,
	PERR_INVCPUS = 1,
	PERR_INVPARENT = 2,
	PERR_NOTPART = 3,
	PERR_NOTEXCL = 4,
	PERR_NOCPUS = 5,
	PERR_HOTPLUG = 6,
	PERR_CPUSEMPTY = 7,
	PERR_HKEEPING = 8,
};

enum ps2_disposition {
	PS2_PROCESS = 0,
	PS2_IGNORE = 1,
	PS2_ERROR = 2,
};

enum psi_aggregators {
	PSI_AVGS = 0,
	PSI_POLL = 1,
	NR_PSI_AGGREGATORS = 2,
};

enum psi_res {
	PSI_IO = 0,
	PSI_MEM = 1,
	PSI_CPU = 2,
	NR_PSI_RESOURCES = 3,
};

enum psi_states {
	PSI_IO_SOME = 0,
	PSI_IO_FULL = 1,
	PSI_MEM_SOME = 2,
	PSI_MEM_FULL = 3,
	PSI_CPU_SOME = 4,
	PSI_CPU_FULL = 5,
	PSI_NONIDLE = 6,
	NR_PSI_STATES = 7,
};

enum psi_task_count {
	NR_IOWAIT = 0,
	NR_MEMSTALL = 1,
	NR_RUNNING = 2,
	NR_MEMSTALL_RUNNING = 3,
	NR_PSI_TASK_COUNTS = 4,
};

enum ptp_pin_function {
	PTP_PF_NONE = 0,
	PTP_PF_EXTTS = 1,
	PTP_PF_PEROUT = 2,
	PTP_PF_PHYSYNC = 3,
};

enum pwm_polarity {
	PWM_POLARITY_NORMAL = 0,
	PWM_POLARITY_INVERSED = 1,
};

enum qdisc_class_ops_flags {
	QDISC_CLASS_OPS_DOIT_UNLOCKED = 1,
};

enum qdisc_state2_t {
	__QDISC_STATE2_RUNNING = 0,
};

enum qdisc_state_t {
	__QDISC_STATE_SCHED = 0,
	__QDISC_STATE_DEACTIVATED = 1,
	__QDISC_STATE_MISSED = 2,
	__QDISC_STATE_DRAINING = 3,
};

enum qe_clock {
	QE_CLK_NONE = 0,
	QE_BRG1 = 1,
	QE_BRG2 = 2,
	QE_BRG3 = 3,
	QE_BRG4 = 4,
	QE_BRG5 = 5,
	QE_BRG6 = 6,
	QE_BRG7 = 7,
	QE_BRG8 = 8,
	QE_BRG9 = 9,
	QE_BRG10 = 10,
	QE_BRG11 = 11,
	QE_BRG12 = 12,
	QE_BRG13 = 13,
	QE_BRG14 = 14,
	QE_BRG15 = 15,
	QE_BRG16 = 16,
	QE_CLK1 = 17,
	QE_CLK2 = 18,
	QE_CLK3 = 19,
	QE_CLK4 = 20,
	QE_CLK5 = 21,
	QE_CLK6 = 22,
	QE_CLK7 = 23,
	QE_CLK8 = 24,
	QE_CLK9 = 25,
	QE_CLK10 = 26,
	QE_CLK11 = 27,
	QE_CLK12 = 28,
	QE_CLK13 = 29,
	QE_CLK14 = 30,
	QE_CLK15 = 31,
	QE_CLK16 = 32,
	QE_CLK17 = 33,
	QE_CLK18 = 34,
	QE_CLK19 = 35,
	QE_CLK20 = 36,
	QE_CLK21 = 37,
	QE_CLK22 = 38,
	QE_CLK23 = 39,
	QE_CLK24 = 40,
	QE_RSYNC_PIN = 41,
	QE_TSYNC_PIN = 42,
	QE_CLK_DUMMY = 43,
};

enum qe_fltr_tbl_lookup_key_size {
	QE_FLTR_TABLE_LOOKUP_KEY_SIZE_8_BYTES = 63,
	QE_FLTR_TABLE_LOOKUP_KEY_SIZE_16_BYTES = 95,
};

enum ql_vnd_host_port_action {
	QLA_ENABLE = 0,
	QLA_DISABLE = 1,
};

enum ql_vnd_host_stat_action {
	QLA_STOP = 0,
	QLA_START = 1,
	QLA_CLEAR = 2,
};

enum qla4_work_type {
	QLA4_EVENT_AEN = 0,
	QLA4_EVENT_PING_STATUS = 1,
};

enum qla_regs {
	QLA8XXX_PEG_HALT_STATUS1 = 0,
	QLA8XXX_PEG_HALT_STATUS2 = 1,
	QLA8XXX_PEG_ALIVE_COUNTER = 2,
	QLA8XXX_CRB_DRV_ACTIVE = 3,
	QLA8XXX_CRB_DEV_STATE = 4,
	QLA8XXX_CRB_DRV_STATE = 5,
	QLA8XXX_CRB_DRV_SCRATCH = 6,
	QLA8XXX_CRB_DEV_PART_INFO = 7,
	QLA8XXX_CRB_DRV_IDC_VERSION = 8,
	QLA8XXX_FW_VERSION_MAJOR = 9,
	QLA8XXX_FW_VERSION_MINOR = 10,
	QLA8XXX_FW_VERSION_SUB = 11,
	QLA8XXX_CRB_CMDPEG_STATE = 12,
	QLA8XXX_CRB_TEMP_STATE = 13,
};

enum qla_regs___2 {
	QLA8044_PEG_HALT_STATUS1_INDEX = 0,
	QLA8044_PEG_HALT_STATUS2_INDEX = 1,
	QLA8044_PEG_ALIVE_COUNTER_INDEX = 2,
	QLA8044_CRB_DRV_ACTIVE_INDEX = 3,
	QLA8044_CRB_DEV_STATE_INDEX = 4,
	QLA8044_CRB_DRV_STATE_INDEX = 5,
	QLA8044_CRB_DRV_SCRATCH_INDEX = 6,
	QLA8044_CRB_DEV_PART_INFO_INDEX = 7,
	QLA8044_CRB_DRV_IDC_VERSION_INDEX = 8,
	QLA8044_FW_VERSION_MAJOR_INDEX = 9,
	QLA8044_FW_VERSION_MINOR_INDEX = 10,
	QLA8044_FW_VERSION_SUB_INDEX = 11,
	QLA8044_CRB_CMDPEG_STATE_INDEX = 12,
	QLA8044_CRB_TEMP_STATE_INDEX = 13,
} __attribute__((mode(byte)));

enum qla_sess_deletion {
	QLA_SESS_DELETION_NONE = 0,
	QLA_SESS_DELETION_IN_PROGRESS = 1,
	QLA_SESS_DELETED = 2,
};

enum qla_work_type {
	QLA_EVT_AEN = 0,
	QLA_EVT_IDC_ACK = 1,
	QLA_EVT_ASYNC_LOGIN = 2,
	QLA_EVT_ASYNC_LOGOUT = 3,
	QLA_EVT_ASYNC_ADISC = 4,
	QLA_EVT_UEVENT = 5,
	QLA_EVT_AENFX = 6,
	QLA_EVT_UNMAP = 7,
	QLA_EVT_NEW_SESS = 8,
	QLA_EVT_GPDB = 9,
	QLA_EVT_PRLI = 10,
	QLA_EVT_GPSC = 11,
	QLA_EVT_GNL = 12,
	QLA_EVT_NACK = 13,
	QLA_EVT_RELOGIN = 14,
	QLA_EVT_ASYNC_PRLO = 15,
	QLA_EVT_ASYNC_PRLO_DONE = 16,
	QLA_EVT_SCAN_CMD = 17,
	QLA_EVT_SCAN_FINISH = 18,
	QLA_EVT_GFPNID = 19,
	QLA_EVT_SP_RETRY = 20,
	QLA_EVT_IIDMA = 21,
	QLA_EVT_ELS_PLOGI = 22,
	QLA_EVT_SA_REPLACE = 23,
};

enum qlt_plogi_link_t {
	QLT_PLOGI_LINK_SAME_WWN = 0,
	QLT_PLOGI_LINK_CONFLICT = 1,
	QLT_PLOGI_LINK_MAX = 2,
};

enum query_opcode {
	UPIU_QUERY_OPCODE_NOP = 0,
	UPIU_QUERY_OPCODE_READ_DESC = 1,
	UPIU_QUERY_OPCODE_WRITE_DESC = 2,
	UPIU_QUERY_OPCODE_READ_ATTR = 3,
	UPIU_QUERY_OPCODE_WRITE_ATTR = 4,
	UPIU_QUERY_OPCODE_READ_FLAG = 5,
	UPIU_QUERY_OPCODE_SET_FLAG = 6,
	UPIU_QUERY_OPCODE_CLEAR_FLAG = 7,
	UPIU_QUERY_OPCODE_TOGGLE_FLAG = 8,
};

enum queue_type {
	MPI3MR_DEFAULT_QUEUE = 0,
	MPI3MR_POLL_QUEUE = 1,
};

enum quota_type {
	USRQUOTA = 0,
	GRPQUOTA = 1,
	PRJQUOTA = 2,
};

enum raid_level {
	RAID_LEVEL_UNKNOWN = 0,
	RAID_LEVEL_LINEAR = 1,
	RAID_LEVEL_0 = 2,
	RAID_LEVEL_1 = 3,
	RAID_LEVEL_10 = 4,
	RAID_LEVEL_1E = 5,
	RAID_LEVEL_3 = 6,
	RAID_LEVEL_4 = 7,
	RAID_LEVEL_5 = 8,
	RAID_LEVEL_50 = 9,
	RAID_LEVEL_6 = 10,
	RAID_LEVEL_JBOD = 11,
};

enum raid_state {
	RAID_STATE_UNKNOWN = 0,
	RAID_STATE_ACTIVE = 1,
	RAID_STATE_DEGRADED = 2,
	RAID_STATE_RESYNCING = 3,
	RAID_STATE_OFFLINE = 4,
};

enum ramfs_param {
	Opt_mode___4 = 0,
};

enum ras_state {
	INACTIVE = 0,
	REG_INPROGRESS = 1,
	ACTIVE = 2,
};

enum rc_driver_type {
	RC_DRIVER_SCANCODE = 0,
	RC_DRIVER_IR_RAW = 1,
	RC_DRIVER_IR_RAW_TX = 2,
};

enum rc_filter_type {
	RC_FILTER_NORMAL = 0,
	RC_FILTER_WAKEUP = 1,
	RC_FILTER_MAX = 2,
};

enum rc_proto {
	RC_PROTO_UNKNOWN = 0,
	RC_PROTO_OTHER = 1,
	RC_PROTO_RC5 = 2,
	RC_PROTO_RC5X_20 = 3,
	RC_PROTO_RC5_SZ = 4,
	RC_PROTO_JVC = 5,
	RC_PROTO_SONY12 = 6,
	RC_PROTO_SONY15 = 7,
	RC_PROTO_SONY20 = 8,
	RC_PROTO_NEC = 9,
	RC_PROTO_NECX = 10,
	RC_PROTO_NEC32 = 11,
	RC_PROTO_SANYO = 12,
	RC_PROTO_MCIR2_KBD = 13,
	RC_PROTO_MCIR2_MSE = 14,
	RC_PROTO_RC6_0 = 15,
	RC_PROTO_RC6_6A_20 = 16,
	RC_PROTO_RC6_6A_24 = 17,
	RC_PROTO_RC6_6A_32 = 18,
	RC_PROTO_RC6_MCE = 19,
	RC_PROTO_SHARP = 20,
	RC_PROTO_XMP = 21,
	RC_PROTO_CEC = 22,
	RC_PROTO_IMON = 23,
	RC_PROTO_RCMM12 = 24,
	RC_PROTO_RCMM24 = 25,
	RC_PROTO_RCMM32 = 26,
	RC_PROTO_XBOX_DVD = 27,
	RC_PROTO_MAX = 27,
};

enum rdma_ah_attr_type {
	RDMA_AH_ATTR_TYPE_UNDEFINED = 0,
	RDMA_AH_ATTR_TYPE_IB = 1,
	RDMA_AH_ATTR_TYPE_ROCE = 2,
	RDMA_AH_ATTR_TYPE_OPA = 3,
};

enum rdma_driver_id {
	RDMA_DRIVER_UNKNOWN = 0,
	RDMA_DRIVER_MLX5 = 1,
	RDMA_DRIVER_MLX4 = 2,
	RDMA_DRIVER_CXGB3 = 3,
	RDMA_DRIVER_CXGB4 = 4,
	RDMA_DRIVER_MTHCA = 5,
	RDMA_DRIVER_BNXT_RE = 6,
	RDMA_DRIVER_OCRDMA = 7,
	RDMA_DRIVER_NES = 8,
	RDMA_DRIVER_I40IW = 9,
	RDMA_DRIVER_IRDMA = 9,
	RDMA_DRIVER_VMW_PVRDMA = 10,
	RDMA_DRIVER_QEDR = 11,
	RDMA_DRIVER_HNS = 12,
	RDMA_DRIVER_USNIC = 13,
	RDMA_DRIVER_RXE = 14,
	RDMA_DRIVER_HFI1 = 15,
	RDMA_DRIVER_QIB = 16,
	RDMA_DRIVER_EFA = 17,
	RDMA_DRIVER_SIW = 18,
	RDMA_DRIVER_ERDMA = 19,
	RDMA_DRIVER_MANA = 20,
};

enum rdma_link_layer {
	IB_LINK_LAYER_UNSPECIFIED = 0,
	IB_LINK_LAYER_INFINIBAND = 1,
	IB_LINK_LAYER_ETHERNET = 2,
};

enum rdma_netdev_t {
	RDMA_NETDEV_OPA_VNIC = 0,
	RDMA_NETDEV_IPOIB = 1,
};

enum rdma_nl_counter_mask {
	RDMA_COUNTER_MASK_QP_TYPE = 1,
	RDMA_COUNTER_MASK_PID = 2,
};

enum rdma_nl_counter_mode {
	RDMA_COUNTER_MODE_NONE = 0,
	RDMA_COUNTER_MODE_AUTO = 1,
	RDMA_COUNTER_MODE_MANUAL = 2,
	RDMA_COUNTER_MODE_MAX = 3,
};

enum rdma_restrack_type {
	RDMA_RESTRACK_PD = 0,
	RDMA_RESTRACK_CQ = 1,
	RDMA_RESTRACK_QP = 2,
	RDMA_RESTRACK_CM_ID = 3,
	RDMA_RESTRACK_MR = 4,
	RDMA_RESTRACK_CTX = 5,
	RDMA_RESTRACK_COUNTER = 6,
	RDMA_RESTRACK_SRQ = 7,
	RDMA_RESTRACK_MAX = 8,
};

enum rdmacg_file_type {
	RDMACG_RESOURCE_TYPE_MAX = 0,
	RDMACG_RESOURCE_TYPE_STAT = 1,
};

enum rdmacg_resource_type {
	RDMACG_RESOURCE_HCA_HANDLE = 0,
	RDMACG_RESOURCE_HCA_OBJECT = 1,
	RDMACG_RESOURCE_MAX = 2,
};

enum read_status_word1 {
	RD_ST_CC = 1,
	RD_ST_XKB = 128,
};

enum read_status_word17 {
	RD_ST_XMIT_XKB_MASK = 4194303,
};

enum read_status_word18 {
	RD_ST_RCV_XKB_MASK = 4194303,
};

enum reboot_mode {
	REBOOT_UNDEFINED = -1,
	REBOOT_COLD = 0,
	REBOOT_WARM = 1,
	REBOOT_HARD = 2,
	REBOOT_SOFT = 3,
	REBOOT_GPIO = 4,
};

enum reboot_type {
	BOOT_TRIPLE = 116,
	BOOT_KBD = 107,
	BOOT_BIOS = 98,
	BOOT_ACPI = 97,
	BOOT_EFI = 101,
	BOOT_CF9_FORCE = 112,
	BOOT_CF9_SAFE = 113,
};

enum refcount_saturation_type {
	REFCOUNT_ADD_NOT_ZERO_OVF = 0,
	REFCOUNT_ADD_OVF = 1,
	REFCOUNT_ADD_UAF = 2,
	REFCOUNT_SUB_UAF = 3,
	REFCOUNT_DEC_LEAK = 4,
};

enum reg_arg_type {
	SRC_OP = 0,
	DST_OP = 1,
	DST_OP_NO_MARK = 2,
};

enum regcache_type {
	REGCACHE_NONE = 0,
	REGCACHE_RBTREE = 1,
	REGCACHE_FLAT = 2,
	REGCACHE_MAPLE = 3,
};

enum regex_type {
	MATCH_FULL = 0,
	MATCH_FRONT_ONLY = 1,
	MATCH_MIDDLE_ONLY = 2,
	MATCH_END_ONLY = 3,
	MATCH_GLOB = 4,
	MATCH_INDEX = 5,
};

enum regmap_endian {
	REGMAP_ENDIAN_DEFAULT = 0,
	REGMAP_ENDIAN_BIG = 1,
	REGMAP_ENDIAN_LITTLE = 2,
	REGMAP_ENDIAN_NATIVE = 3,
};

enum regulator_active_discharge {
	REGULATOR_ACTIVE_DISCHARGE_DEFAULT = 0,
	REGULATOR_ACTIVE_DISCHARGE_DISABLE = 1,
	REGULATOR_ACTIVE_DISCHARGE_ENABLE = 2,
};

enum regulator_detection_severity {
	REGULATOR_SEVERITY_PROT = 0,
	REGULATOR_SEVERITY_ERR = 1,
	REGULATOR_SEVERITY_WARN = 2,
};

enum regulator_get_type {
	NORMAL_GET = 0,
	EXCLUSIVE_GET = 1,
	OPTIONAL_GET = 2,
	MAX_GET_TYPE = 3,
};

enum regulator_status {
	REGULATOR_STATUS_OFF = 0,
	REGULATOR_STATUS_ON = 1,
	REGULATOR_STATUS_ERROR = 2,
	REGULATOR_STATUS_FAST = 3,
	REGULATOR_STATUS_NORMAL = 4,
	REGULATOR_STATUS_IDLE = 5,
	REGULATOR_STATUS_STANDBY = 6,
	REGULATOR_STATUS_BYPASS = 7,
	REGULATOR_STATUS_UNDEFINED = 8,
};

enum regulator_type {
	REGULATOR_VOLTAGE = 0,
	REGULATOR_CURRENT = 1,
};

enum release_type {
	leaf_only = 0,
	whole_subtree = 1,
};

enum req_flag_bits {
	__REQ_FAILFAST_DEV = 8,
	__REQ_FAILFAST_TRANSPORT = 9,
	__REQ_FAILFAST_DRIVER = 10,
	__REQ_SYNC = 11,
	__REQ_META = 12,
	__REQ_PRIO = 13,
	__REQ_NOMERGE = 14,
	__REQ_IDLE = 15,
	__REQ_INTEGRITY = 16,
	__REQ_FUA = 17,
	__REQ_PREFLUSH = 18,
	__REQ_RAHEAD = 19,
	__REQ_BACKGROUND = 20,
	__REQ_NOWAIT = 21,
	__REQ_POLLED = 22,
	__REQ_ALLOC_CACHE = 23,
	__REQ_SWAP = 24,
	__REQ_DRV = 25,
	__REQ_FS_PRIVATE = 26,
	__REQ_NOUNMAP = 27,
	__REQ_NR_BITS = 28,
};

enum req_op {
	REQ_OP_READ = 0,
	REQ_OP_WRITE = 1,
	REQ_OP_FLUSH = 2,
	REQ_OP_DISCARD = 3,
	REQ_OP_SECURE_ERASE = 5,
	REQ_OP_ZONE_APPEND = 7,
	REQ_OP_WRITE_ZEROES = 9,
	REQ_OP_ZONE_OPEN = 10,
	REQ_OP_ZONE_CLOSE = 11,
	REQ_OP_ZONE_FINISH = 12,
	REQ_OP_ZONE_RESET = 13,
	REQ_OP_ZONE_RESET_ALL = 15,
	REQ_OP_DRV_IN = 34,
	REQ_OP_DRV_OUT = 35,
	REQ_OP_LAST = 36,
};

enum res_type {
	_MEM = 0,
	_MEMSWAP = 1,
	_KMEM = 2,
	_TCP = 3,
};

enum resctrl_conf_type {
	CDP_NONE = 0,
	CDP_CODE = 1,
	CDP_DATA = 2,
};

enum reset_type {
	FORCE_BIG_HAMMER = 0,
	SOFT_RESET = 1,
};

enum resolve_mode {
	RESOLVE_TBD = 0,
	RESOLVE_PTR = 1,
	RESOLVE_STRUCT_OR_ARRAY = 2,
};

enum resource_type {
	RESOURCE_CACHED_MEMORY = 0,
	RESOURCE_UNCACHED_MEMORY = 1,
};

enum rft_word0 {
	RFT_FCP_REG = 256,
};

enum rft_word1 {
	RFT_NVME_REG = 256,
};

enum rft_word3 {
	RFT_APP_SERV_REG = 1,
};

enum ring_buffer_flags {
	RB_FL_OVERWRITE = 1,
};

enum ring_buffer_type {
	RINGBUF_TYPE_DATA_TYPE_LEN_MAX = 28,
	RINGBUF_TYPE_PADDING = 29,
	RINGBUF_TYPE_TIME_EXTEND = 30,
	RINGBUF_TYPE_TIME_STAMP = 31,
};

enum rlimit_type {
	UCOUNT_RLIMIT_NPROC = 0,
	UCOUNT_RLIMIT_MSGQUEUE = 1,
	UCOUNT_RLIMIT_SIGPENDING = 2,
	UCOUNT_RLIMIT_MEMLOCK = 3,
	UCOUNT_RLIMIT_COUNTS = 4,
};

enum rmap_level {
	RMAP_LEVEL_PTE = 0,
	RMAP_LEVEL_PMD = 1,
};

enum routing_attribute {
	DIRECT_ROUTING = 0,
	SUBTRACTIVE_ROUTING = 1,
	TABLE_ROUTING = 2,
};

enum rp_check {
	RP_CHECK_CALL = 0,
	RP_CHECK_CHAIN_CALL = 1,
	RP_CHECK_RET = 2,
};

enum rpc_display_format_t {
	RPC_DISPLAY_ADDR = 0,
	RPC_DISPLAY_PORT = 1,
	RPC_DISPLAY_PROTO = 2,
	RPC_DISPLAY_HEX_ADDR = 3,
	RPC_DISPLAY_HEX_PORT = 4,
	RPC_DISPLAY_NETID = 5,
	RPC_DISPLAY_MAX = 6,
};

enum rpf_event {
	RPFSM_EVENT_RPORT_OFFLINE = 1,
	RPFSM_EVENT_RPORT_ONLINE = 2,
	RPFSM_EVENT_FCXP_SENT = 3,
	RPFSM_EVENT_TIMEOUT = 4,
	RPFSM_EVENT_RPSC_COMP = 5,
	RPFSM_EVENT_RPSC_FAIL = 6,
	RPFSM_EVENT_RPSC_ERROR = 7,
};

enum rpm_request {
	RPM_REQ_NONE = 0,
	RPM_REQ_IDLE = 1,
	RPM_REQ_SUSPEND = 2,
	RPM_REQ_AUTOSUSPEND = 3,
	RPM_REQ_RESUME = 4,
};

enum rpm_status {
	RPM_INVALID = -1,
	RPM_ACTIVE = 0,
	RPM_RESUMING = 1,
	RPM_SUSPENDED = 2,
	RPM_SUSPENDING = 3,
};

enum rpmb_unit_desc_param {
	RPMB_UNIT_DESC_PARAM_LEN = 0,
	RPMB_UNIT_DESC_PARAM_TYPE = 1,
	RPMB_UNIT_DESC_PARAM_UNIT_INDEX = 2,
	RPMB_UNIT_DESC_PARAM_LU_ENABLE = 3,
	RPMB_UNIT_DESC_PARAM_BOOT_LUN_ID = 4,
	RPMB_UNIT_DESC_PARAM_LU_WR_PROTECT = 5,
	RPMB_UNIT_DESC_PARAM_LU_Q_DEPTH = 6,
	RPMB_UNIT_DESC_PARAM_PSA_SENSITIVE = 7,
	RPMB_UNIT_DESC_PARAM_MEM_TYPE = 8,
	RPMB_UNIT_DESC_PARAM_REGION_EN = 9,
	RPMB_UNIT_DESC_PARAM_LOGICAL_BLK_SIZE = 10,
	RPMB_UNIT_DESC_PARAM_LOGICAL_BLK_COUNT = 11,
	RPMB_UNIT_DESC_PARAM_REGION0_SIZE = 19,
	RPMB_UNIT_DESC_PARAM_REGION1_SIZE = 20,
	RPMB_UNIT_DESC_PARAM_REGION2_SIZE = 21,
	RPMB_UNIT_DESC_PARAM_REGION3_SIZE = 22,
	RPMB_UNIT_DESC_PARAM_PROVISIONING_TYPE = 23,
	RPMB_UNIT_DESC_PARAM_PHY_MEM_RSRC_CNT = 24,
};

enum rport_event {
	RPSM_EVENT_PLOGI_SEND = 1,
	RPSM_EVENT_PLOGI_RCVD = 2,
	RPSM_EVENT_PLOGI_COMP = 3,
	RPSM_EVENT_LOGO_RCVD = 4,
	RPSM_EVENT_LOGO_IMP = 5,
	RPSM_EVENT_FCXP_SENT = 6,
	RPSM_EVENT_DELETE = 7,
	RPSM_EVENT_FAB_SCN = 8,
	RPSM_EVENT_ACCEPTED = 9,
	RPSM_EVENT_FAILED = 10,
	RPSM_EVENT_TIMEOUT = 11,
	RPSM_EVENT_HCB_ONLINE = 12,
	RPSM_EVENT_HCB_OFFLINE = 13,
	RPSM_EVENT_FC4_OFFLINE = 14,
	RPSM_EVENT_ADDRESS_CHANGE = 15,
	RPSM_EVENT_ADDRESS_DISC = 16,
	RPSM_EVENT_PRLO_RCVD = 17,
	RPSM_EVENT_PLOGI_RETRY = 18,
	RPSM_EVENT_SCN_OFFLINE = 19,
	RPSM_EVENT_SCN_ONLINE = 20,
	RPSM_EVENT_FC4_FCS_ONLINE = 21,
};

enum rport_type_fcoe {
	FLOGI_VFPORT = 1,
	FDISC_VFPORT = 2,
	NS_VNPORT = 3,
	REG_FC4_VNPORT = 4,
	REG_VNPORT = 5,
	FDMI_VNPORT = 6,
	FAB_CTLR_VNPORT = 7,
};

enum rproc_crash_type {
	RPROC_MMUFAULT = 0,
	RPROC_WATCHDOG = 1,
	RPROC_FATAL_ERROR = 2,
};

enum rproc_dump_mechanism {
	RPROC_COREDUMP_DISABLED = 0,
	RPROC_COREDUMP_ENABLED = 1,
	RPROC_COREDUMP_INLINE = 2,
};

enum rproc_features {
	RPROC_FEAT_ATTACH_ON_RECOVERY = 0,
	RPROC_MAX_FEATURES = 1,
};

enum rproc_state {
	RPROC_OFFLINE = 0,
	RPROC_SUSPENDED = 1,
	RPROC_RUNNING = 2,
	RPROC_CRASHED = 3,
	RPROC_DELETED = 4,
	RPROC_ATTACHED = 5,
	RPROC_DETACHED = 6,
	RPROC_LAST = 7,
};

enum rq_end_io_ret {
	RQ_END_IO_NONE = 0,
	RQ_END_IO_FREE = 1,
};

enum rq_qos_id {
	RQ_QOS_WBT = 0,
	RQ_QOS_LATENCY = 1,
	RQ_QOS_COST = 2,
};

enum rsaprivkey_actions {
	ACT_rsa_get_d = 0,
	ACT_rsa_get_dp = 1,
	ACT_rsa_get_dq = 2,
	ACT_rsa_get_e = 3,
	ACT_rsa_get_n = 4,
	ACT_rsa_get_p = 5,
	ACT_rsa_get_q = 6,
	ACT_rsa_get_qinv = 7,
	NR__rsaprivkey_actions = 8,
};

enum rsapubkey_actions {
	ACT_rsa_get_e___2 = 0,
	ACT_rsa_get_n___2 = 1,
	NR__rsapubkey_actions = 2,
};

enum rsc_handling_status {
	RSC_HANDLED = 0,
	RSC_IGNORED = 1,
};

enum rscn_addr_format {
	RSCN_PORT_ADDR = 0,
	RSCN_AREA_ADDR = 1,
	RSCN_DOM_ADDR = 2,
	RSCN_FAB_ADDR = 3,
};

enum rseq_cpu_id_state {
	RSEQ_CPU_ID_UNINITIALIZED = -1,
	RSEQ_CPU_ID_REGISTRATION_FAILED = -2,
};

enum rseq_cs_flags {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL = 2,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE = 4,
};

enum rseq_cs_flags_bit {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT_BIT = 0,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL_BIT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE_BIT = 2,
};

enum rseq_event_mask_bits {
	RSEQ_EVENT_PREEMPT_BIT = 0,
	RSEQ_EVENT_SIGNAL_BIT = 1,
	RSEQ_EVENT_MIGRATE_BIT = 2,
};

enum rseq_flags {
	RSEQ_FLAG_UNREGISTER = 1,
};

enum rt6_nud_state {
	RT6_NUD_FAIL_HARD = -3,
	RT6_NUD_FAIL_PROBE = -2,
	RT6_NUD_FAIL_DO_RR = -1,
	RT6_NUD_SUCCEED = 1,
};

enum rt_class_t {
	RT_TABLE_UNSPEC = 0,
	RT_TABLE_COMPAT = 252,
	RT_TABLE_DEFAULT = 253,
	RT_TABLE_MAIN = 254,
	RT_TABLE_LOCAL = 255,
	RT_TABLE_MAX = 4294967295,
};

enum rt_scope_t {
	RT_SCOPE_UNIVERSE = 0,
	RT_SCOPE_SITE = 200,
	RT_SCOPE_LINK = 253,
	RT_SCOPE_HOST = 254,
	RT_SCOPE_NOWHERE = 255,
};

enum rtas_function_index {
	RTAS_FNIDX__CHECK_EXCEPTION = 0,
	RTAS_FNIDX__DISPLAY_CHARACTER = 1,
	RTAS_FNIDX__EVENT_SCAN = 2,
	RTAS_FNIDX__FREEZE_TIME_BASE = 3,
	RTAS_FNIDX__GET_POWER_LEVEL = 4,
	RTAS_FNIDX__GET_SENSOR_STATE = 5,
	RTAS_FNIDX__GET_TERM_CHAR = 6,
	RTAS_FNIDX__GET_TIME_OF_DAY = 7,
	RTAS_FNIDX__IBM_ACTIVATE_FIRMWARE = 8,
	RTAS_FNIDX__IBM_CBE_START_PTCAL = 9,
	RTAS_FNIDX__IBM_CBE_STOP_PTCAL = 10,
	RTAS_FNIDX__IBM_CHANGE_MSI = 11,
	RTAS_FNIDX__IBM_CLOSE_ERRINJCT = 12,
	RTAS_FNIDX__IBM_CONFIGURE_BRIDGE = 13,
	RTAS_FNIDX__IBM_CONFIGURE_CONNECTOR = 14,
	RTAS_FNIDX__IBM_CONFIGURE_KERNEL_DUMP = 15,
	RTAS_FNIDX__IBM_CONFIGURE_PE = 16,
	RTAS_FNIDX__IBM_CREATE_PE_DMA_WINDOW = 17,
	RTAS_FNIDX__IBM_DISPLAY_MESSAGE = 18,
	RTAS_FNIDX__IBM_ERRINJCT = 19,
	RTAS_FNIDX__IBM_EXTI2C = 20,
	RTAS_FNIDX__IBM_GET_CONFIG_ADDR_INFO = 21,
	RTAS_FNIDX__IBM_GET_CONFIG_ADDR_INFO2 = 22,
	RTAS_FNIDX__IBM_GET_DYNAMIC_SENSOR_STATE = 23,
	RTAS_FNIDX__IBM_GET_INDICES = 24,
	RTAS_FNIDX__IBM_GET_RIO_TOPOLOGY = 25,
	RTAS_FNIDX__IBM_GET_SYSTEM_PARAMETER = 26,
	RTAS_FNIDX__IBM_GET_VPD = 27,
	RTAS_FNIDX__IBM_GET_XIVE = 28,
	RTAS_FNIDX__IBM_INT_OFF = 29,
	RTAS_FNIDX__IBM_INT_ON = 30,
	RTAS_FNIDX__IBM_IO_QUIESCE_ACK = 31,
	RTAS_FNIDX__IBM_LPAR_PERFTOOLS = 32,
	RTAS_FNIDX__IBM_MANAGE_FLASH_IMAGE = 33,
	RTAS_FNIDX__IBM_MANAGE_STORAGE_PRESERVATION = 34,
	RTAS_FNIDX__IBM_NMI_INTERLOCK = 35,
	RTAS_FNIDX__IBM_NMI_REGISTER = 36,
	RTAS_FNIDX__IBM_OPEN_ERRINJCT = 37,
	RTAS_FNIDX__IBM_OPEN_SRIOV_ALLOW_UNFREEZE = 38,
	RTAS_FNIDX__IBM_OPEN_SRIOV_MAP_PE_NUMBER = 39,
	RTAS_FNIDX__IBM_OS_TERM = 40,
	RTAS_FNIDX__IBM_PARTNER_CONTROL = 41,
	RTAS_FNIDX__IBM_PHYSICAL_ATTESTATION = 42,
	RTAS_FNIDX__IBM_PLATFORM_DUMP = 43,
	RTAS_FNIDX__IBM_POWER_OFF_UPS = 44,
	RTAS_FNIDX__IBM_QUERY_INTERRUPT_SOURCE_NUMBER = 45,
	RTAS_FNIDX__IBM_QUERY_PE_DMA_WINDOW = 46,
	RTAS_FNIDX__IBM_READ_PCI_CONFIG = 47,
	RTAS_FNIDX__IBM_READ_SLOT_RESET_STATE = 48,
	RTAS_FNIDX__IBM_READ_SLOT_RESET_STATE2 = 49,
	RTAS_FNIDX__IBM_REMOVE_PE_DMA_WINDOW = 50,
	RTAS_FNIDX__IBM_RESET_PE_DMA_WINDOW = 51,
	RTAS_FNIDX__IBM_SCAN_LOG_DUMP = 52,
	RTAS_FNIDX__IBM_SET_DYNAMIC_INDICATOR = 53,
	RTAS_FNIDX__IBM_SET_EEH_OPTION = 54,
	RTAS_FNIDX__IBM_SET_SLOT_RESET = 55,
	RTAS_FNIDX__IBM_SET_SYSTEM_PARAMETER = 56,
	RTAS_FNIDX__IBM_SET_XIVE = 57,
	RTAS_FNIDX__IBM_SLOT_ERROR_DETAIL = 58,
	RTAS_FNIDX__IBM_SUSPEND_ME = 59,
	RTAS_FNIDX__IBM_TUNE_DMA_PARMS = 60,
	RTAS_FNIDX__IBM_UPDATE_FLASH_64_AND_REBOOT = 61,
	RTAS_FNIDX__IBM_UPDATE_NODES = 62,
	RTAS_FNIDX__IBM_UPDATE_PROPERTIES = 63,
	RTAS_FNIDX__IBM_VALIDATE_FLASH_IMAGE = 64,
	RTAS_FNIDX__IBM_WRITE_PCI_CONFIG = 65,
	RTAS_FNIDX__NVRAM_FETCH = 66,
	RTAS_FNIDX__NVRAM_STORE = 67,
	RTAS_FNIDX__POWER_OFF = 68,
	RTAS_FNIDX__PUT_TERM_CHAR = 69,
	RTAS_FNIDX__QUERY_CPU_STOPPED_STATE = 70,
	RTAS_FNIDX__READ_PCI_CONFIG = 71,
	RTAS_FNIDX__RTAS_LAST_ERROR = 72,
	RTAS_FNIDX__SET_INDICATOR = 73,
	RTAS_FNIDX__SET_POWER_LEVEL = 74,
	RTAS_FNIDX__SET_TIME_FOR_POWER_ON = 75,
	RTAS_FNIDX__SET_TIME_OF_DAY = 76,
	RTAS_FNIDX__START_CPU = 77,
	RTAS_FNIDX__STOP_SELF = 78,
	RTAS_FNIDX__SYSTEM_REBOOT = 79,
	RTAS_FNIDX__THAW_TIME_BASE = 80,
	RTAS_FNIDX__WRITE_PCI_CONFIG = 81,
};

enum rtas_iov_fw_value_map {
	NUM_RES_PROPERTY = 0,
	LOW_INT = 1,
	START_OF_ENTRIES = 2,
	APERTURE_PROPERTY = 2,
	WDW_SIZE_PROPERTY = 4,
	NEXT_ENTRY = 7,
};

enum rtattr_type_t {
	RTA_UNSPEC = 0,
	RTA_DST = 1,
	RTA_SRC = 2,
	RTA_IIF = 3,
	RTA_OIF = 4,
	RTA_GATEWAY = 5,
	RTA_PRIORITY = 6,
	RTA_PREFSRC = 7,
	RTA_METRICS = 8,
	RTA_MULTIPATH = 9,
	RTA_PROTOINFO = 10,
	RTA_FLOW = 11,
	RTA_CACHEINFO = 12,
	RTA_SESSION = 13,
	RTA_MP_ALGO = 14,
	RTA_TABLE = 15,
	RTA_MARK = 16,
	RTA_MFC_STATS = 17,
	RTA_VIA = 18,
	RTA_NEWDST = 19,
	RTA_PREF = 20,
	RTA_ENCAP_TYPE = 21,
	RTA_ENCAP = 22,
	RTA_EXPIRES = 23,
	RTA_PAD = 24,
	RTA_UID = 25,
	RTA_TTL_PROPAGATE = 26,
	RTA_IP_PROTO = 27,
	RTA_SPORT = 28,
	RTA_DPORT = 29,
	RTA_NH_ID = 30,
	__RTA_MAX = 31,
};

enum rtmutex_chainwalk {
	RT_MUTEX_MIN_CHAINWALK = 0,
	RT_MUTEX_FULL_CHAINWALK = 1,
};

enum rtnetlink_groups {
	RTNLGRP_NONE = 0,
	RTNLGRP_LINK = 1,
	RTNLGRP_NOTIFY = 2,
	RTNLGRP_NEIGH = 3,
	RTNLGRP_TC = 4,
	RTNLGRP_IPV4_IFADDR = 5,
	RTNLGRP_IPV4_MROUTE = 6,
	RTNLGRP_IPV4_ROUTE = 7,
	RTNLGRP_IPV4_RULE = 8,
	RTNLGRP_IPV6_IFADDR = 9,
	RTNLGRP_IPV6_MROUTE = 10,
	RTNLGRP_IPV6_ROUTE = 11,
	RTNLGRP_IPV6_IFINFO = 12,
	RTNLGRP_DECnet_IFADDR = 13,
	RTNLGRP_NOP2 = 14,
	RTNLGRP_DECnet_ROUTE = 15,
	RTNLGRP_DECnet_RULE = 16,
	RTNLGRP_NOP4 = 17,
	RTNLGRP_IPV6_PREFIX = 18,
	RTNLGRP_IPV6_RULE = 19,
	RTNLGRP_ND_USEROPT = 20,
	RTNLGRP_PHONET_IFADDR = 21,
	RTNLGRP_PHONET_ROUTE = 22,
	RTNLGRP_DCB = 23,
	RTNLGRP_IPV4_NETCONF = 24,
	RTNLGRP_IPV6_NETCONF = 25,
	RTNLGRP_MDB = 26,
	RTNLGRP_MPLS_ROUTE = 27,
	RTNLGRP_NSID = 28,
	RTNLGRP_MPLS_NETCONF = 29,
	RTNLGRP_IPV4_MROUTE_R = 30,
	RTNLGRP_IPV6_MROUTE_R = 31,
	RTNLGRP_NEXTHOP = 32,
	RTNLGRP_BRVLAN = 33,
	RTNLGRP_MCTP_IFADDR = 34,
	RTNLGRP_TUNNEL = 35,
	RTNLGRP_STATS = 36,
	__RTNLGRP_MAX = 37,
};

enum rtnl_kinds {
	RTNL_KIND_NEW = 0,
	RTNL_KIND_DEL = 1,
	RTNL_KIND_GET = 2,
	RTNL_KIND_SET = 3,
};

enum rtnl_link_flags {
	RTNL_FLAG_DOIT_UNLOCKED = 1,
	RTNL_FLAG_BULK_DEL_SUPPORTED = 2,
	RTNL_FLAG_DUMP_UNLOCKED = 4,
	RTNL_FLAG_DUMP_SPLIT_NLM_DONE = 8,
};

enum rw_hint {
	WRITE_LIFE_NOT_SET = 0,
	WRITE_LIFE_NONE = 1,
	WRITE_LIFE_SHORT = 2,
	WRITE_LIFE_MEDIUM = 3,
	WRITE_LIFE_LONG = 4,
	WRITE_LIFE_EXTREME = 5,
} __attribute__((mode(byte)));

enum rwsem_waiter_type {
	RWSEM_WAITING_FOR_WRITE = 0,
	RWSEM_WAITING_FOR_READ = 1,
};

enum rwsem_wake_type {
	RWSEM_WAKE_ANY = 0,
	RWSEM_WAKE_READERS = 1,
	RWSEM_WAKE_READ_OWNED = 2,
};

enum rx_handler_result {
	RX_HANDLER_CONSUMED = 0,
	RX_HANDLER_ANOTHER = 1,
	RX_HANDLER_EXACT = 2,
	RX_HANDLER_PASS = 3,
};

typedef enum rx_handler_result rx_handler_result_t;

enum s2idle_states {
	S2IDLE_STATE_NONE = 0,
	S2IDLE_STATE_ENTER = 1,
	S2IDLE_STATE_WAKE = 2,
};

enum s_alloc {
	sa_rootdomain = 0,
	sa_sd = 1,
	sa_sd_storage = 2,
	sa_none = 3,
};

enum sam_status {
	SAM_STAT_GOOD = 0,
	SAM_STAT_CHECK_CONDITION = 2,
	SAM_STAT_CONDITION_MET = 4,
	SAM_STAT_BUSY = 8,
	SAM_STAT_INTERMEDIATE = 16,
	SAM_STAT_INTERMEDIATE_CONDITION_MET = 20,
	SAM_STAT_RESERVATION_CONFLICT = 24,
	SAM_STAT_COMMAND_TERMINATED = 34,
	SAM_STAT_TASK_SET_FULL = 40,
	SAM_STAT_ACA_ACTIVE = 48,
	SAM_STAT_TASK_ABORTED = 64,
};

enum sas_cmd_port_registers {
	CMD_CMRST_OOB_DET = 256,
	CMD_CMWK_OOB_DET = 260,
	CMD_CMSAS_OOB_DET = 264,
	CMD_BRST_OOB_DET = 268,
	CMD_OOB_SPACE = 272,
	CMD_OOB_BURST = 276,
	CMD_PHY_TIMER = 280,
	CMD_PHY_CONFIG0 = 284,
	CMD_PHY_CONFIG1 = 288,
	CMD_SAS_CTL0 = 292,
	CMD_SAS_CTL1 = 296,
	CMD_SAS_CTL2 = 300,
	CMD_SAS_CTL3 = 304,
	CMD_ID_TEST = 308,
	CMD_PL_TIMER = 312,
	CMD_WD_TIMER = 316,
	CMD_PORT_SEL_COUNT = 320,
	CMD_APP_MEM_CTL = 324,
	CMD_XOR_MEM_CTL = 328,
	CMD_DMA_MEM_CTL = 332,
	CMD_PORT_MEM_CTL0 = 336,
	CMD_PORT_MEM_CTL1 = 340,
	CMD_SATA_PORT_MEM_CTL0 = 344,
	CMD_SATA_PORT_MEM_CTL1 = 348,
	CMD_XOR_MEM_BIST_CTL = 352,
	CMD_XOR_MEM_BIST_STAT = 356,
	CMD_DMA_MEM_BIST_CTL = 360,
	CMD_DMA_MEM_BIST_STAT = 364,
	CMD_PORT_MEM_BIST_CTL = 368,
	CMD_PORT_MEM_BIST_STAT0 = 372,
	CMD_PORT_MEM_BIST_STAT1 = 376,
	CMD_STP_MEM_BIST_CTL = 380,
	CMD_STP_MEM_BIST_STAT0 = 384,
	CMD_STP_MEM_BIST_STAT1 = 388,
	CMD_RESET_COUNT = 392,
	CMD_MONTR_DATA_SEL = 396,
	CMD_PLL_PHY_CONFIG = 400,
	CMD_PHY_CTL = 404,
	CMD_PHY_TEST_COUNT0 = 408,
	CMD_PHY_TEST_COUNT1 = 412,
	CMD_PHY_TEST_COUNT2 = 416,
	CMD_APP_ERR_CONFIG = 420,
	CMD_PND_FIFO_CTL0 = 424,
	CMD_HOST_CTL = 428,
	CMD_HOST_WR_DATA = 432,
	CMD_HOST_RD_DATA = 436,
	CMD_PHY_MODE_21 = 440,
	CMD_SL_MODE0 = 444,
	CMD_SL_MODE1 = 448,
	CMD_PND_FIFO_CTL1 = 452,
	CMD_PORT_LAYER_TIMER1 = 480,
	CMD_LINK_TIMER = 484,
};

enum sas_device_type {
	SAS_PHY_UNUSED = 0,
	SAS_END_DEVICE = 1,
	SAS_EDGE_EXPANDER_DEVICE = 2,
	SAS_FANOUT_EXPANDER_DEVICE = 3,
	SAS_HA = 4,
	SAS_SATA_DEV = 5,
	SAS_SATA_PM = 7,
	SAS_SATA_PM_PORT = 8,
	SAS_SATA_PENDING = 9,
};

enum sas_gpio_reg_type {
	SAS_GPIO_REG_CFG = 0,
	SAS_GPIO_REG_RX = 1,
	SAS_GPIO_REG_RX_GP = 2,
	SAS_GPIO_REG_TX = 3,
	SAS_GPIO_REG_TX_GP = 4,
};

enum sas_ha_state {
	SAS_HA_REGISTERED = 0,
	SAS_HA_DRAINING = 1,
	SAS_HA_ATA_EH_ACTIVE = 2,
	SAS_HA_FROZEN = 3,
	SAS_HA_RESUMING = 4,
};

enum sas_internal_abort {
	SAS_INTERNAL_ABORT_SINGLE = 0,
	SAS_INTERNAL_ABORT_DEV = 1,
};

enum sas_linkrate {
	SAS_LINK_RATE_UNKNOWN = 0,
	SAS_PHY_DISABLED = 1,
	SAS_PHY_RESET_PROBLEM = 2,
	SAS_SATA_SPINUP_HOLD = 3,
	SAS_SATA_PORT_SELECTOR = 4,
	SAS_PHY_RESET_IN_PROGRESS = 5,
	SAS_LINK_RATE_1_5_GBPS = 8,
	SAS_LINK_RATE_G1 = 8,
	SAS_LINK_RATE_3_0_GBPS = 9,
	SAS_LINK_RATE_G2 = 9,
	SAS_LINK_RATE_6_0_GBPS = 10,
	SAS_LINK_RATE_12_0_GBPS = 11,
	SAS_LINK_RATE_22_5_GBPS = 12,
	SAS_LINK_RATE_FAILED = 16,
	SAS_PHY_VIRTUAL = 17,
};

enum sas_oob_mode {
	OOB_NOT_CONNECTED = 0,
	SATA_OOB_MODE = 1,
	SAS_OOB_MODE = 2,
};

enum sas_open_rej_reason {
	SAS_OREJ_UNKNOWN = 0,
	SAS_OREJ_BAD_DEST = 1,
	SAS_OREJ_CONN_RATE = 2,
	SAS_OREJ_EPROTO = 3,
	SAS_OREJ_RESV_AB0 = 4,
	SAS_OREJ_RESV_AB1 = 5,
	SAS_OREJ_RESV_AB2 = 6,
	SAS_OREJ_RESV_AB3 = 7,
	SAS_OREJ_WRONG_DEST = 8,
	SAS_OREJ_STP_NORES = 9,
	SAS_OREJ_NO_DEST = 10,
	SAS_OREJ_PATH_BLOCKED = 11,
	SAS_OREJ_RSVD_CONT0 = 12,
	SAS_OREJ_RSVD_CONT1 = 13,
	SAS_OREJ_RSVD_INIT0 = 14,
	SAS_OREJ_RSVD_INIT1 = 15,
	SAS_OREJ_RSVD_STOP0 = 16,
	SAS_OREJ_RSVD_STOP1 = 17,
	SAS_OREJ_RSVD_RETRY = 18,
};

enum sas_phy_role {
	PHY_ROLE_NONE = 0,
	PHY_ROLE_TARGET = 64,
	PHY_ROLE_INITIATOR = 128,
};

enum sas_protocol {
	SAS_PROTOCOL_NONE = 0,
	SAS_PROTOCOL_SATA = 1,
	SAS_PROTOCOL_SMP = 2,
	SAS_PROTOCOL_STP = 4,
	SAS_PROTOCOL_SSP = 8,
	SAS_PROTOCOL_ALL = 14,
	SAS_PROTOCOL_STP_ALL = 5,
	SAS_PROTOCOL_INTERNAL_ABORT = 16,
};

enum sas_sata_config_port_regs {
	PHYR_IDENTIFY = 0,
	PHYR_ADDR_LO = 4,
	PHYR_ADDR_HI = 8,
	PHYR_ATT_DEV_INFO = 12,
	PHYR_ATT_ADDR_LO = 16,
	PHYR_ATT_ADDR_HI = 20,
	PHYR_SATA_CTL = 24,
	PHYR_PHY_STAT = 28,
	PHYR_SATA_SIG0 = 32,
	PHYR_SATA_SIG1 = 36,
	PHYR_SATA_SIG2 = 40,
	PHYR_SATA_SIG3 = 44,
	PHYR_R_ERR_COUNT = 48,
	PHYR_CRC_ERR_COUNT = 52,
	PHYR_WIDE_PORT = 56,
	PHYR_CURRENT0 = 128,
	PHYR_CURRENT1 = 132,
	PHYR_CURRENT2 = 136,
	CONFIG_ID_FRAME0 = 256,
	CONFIG_ID_FRAME1 = 260,
	CONFIG_ID_FRAME2 = 264,
	CONFIG_ID_FRAME3 = 268,
	CONFIG_ID_FRAME4 = 272,
	CONFIG_ID_FRAME5 = 276,
	CONFIG_ID_FRAME6 = 280,
	CONFIG_ATT_ID_FRAME0 = 284,
	CONFIG_ATT_ID_FRAME1 = 288,
	CONFIG_ATT_ID_FRAME2 = 292,
	CONFIG_ATT_ID_FRAME3 = 296,
	CONFIG_ATT_ID_FRAME4 = 300,
	CONFIG_ATT_ID_FRAME5 = 304,
	CONFIG_ATT_ID_FRAME6 = 308,
};

enum sas_sata_phy_regs {
	GENERATION_1_SETTING = 280,
	GENERATION_1_2_SETTING = 284,
	GENERATION_2_3_SETTING = 288,
	GENERATION_3_4_SETTING = 292,
};

enum sas_sata_vsp_regs {
	VSR_PHY_STAT = 0,
	VSR_PHY_MODE1 = 1,
	VSR_PHY_MODE2 = 2,
	VSR_PHY_MODE3 = 3,
	VSR_PHY_MODE4 = 4,
	VSR_PHY_MODE5 = 5,
	VSR_PHY_MODE6 = 6,
	VSR_PHY_MODE7 = 7,
	VSR_PHY_MODE8 = 8,
	VSR_PHY_MODE9 = 9,
	VSR_PHY_MODE10 = 10,
	VSR_PHY_MODE11 = 11,
	VSR_PHY_VS0 = 12,
	VSR_PHY_VS1 = 13,
};

enum sas_sata_vsp_regs___2 {
	VSR_PHY_STAT___2 = 0,
	VSR_PHY_MODE1___2 = 4,
	VSR_PHY_MODE2___2 = 8,
	VSR_PHY_MODE3___2 = 12,
	VSR_PHY_MODE4___2 = 16,
	VSR_PHY_MODE5___2 = 20,
	VSR_PHY_MODE6___2 = 24,
	VSR_PHY_MODE7___2 = 28,
	VSR_PHY_MODE8___2 = 32,
	VSR_PHY_MODE9___2 = 36,
	VSR_PHY_MODE10___2 = 40,
	VSR_PHY_MODE11___2 = 44,
	VSR_PHY_ACT_LED = 48,
	VSR_PHY_FFE_CONTROL = 268,
	VSR_PHY_DFE_UPDATE_CRTL = 272,
	VSR_REF_CLOCK_CRTL = 416,
};

enum scan_balance {
	SCAN_EQUAL = 0,
	SCAN_FRACT = 1,
	SCAN_ANON = 2,
	SCAN_FILE = 3,
};

enum scan_flags_t {
	SF_SCANNING = 1,
	SF_QUEUED = 2,
};

enum scan_result {
	SCAN_FAIL = 0,
	SCAN_SUCCEED = 1,
	SCAN_PMD_NULL = 2,
	SCAN_PMD_NONE = 3,
	SCAN_PMD_MAPPED = 4,
	SCAN_EXCEED_NONE_PTE = 5,
	SCAN_EXCEED_SWAP_PTE = 6,
	SCAN_EXCEED_SHARED_PTE = 7,
	SCAN_PTE_NON_PRESENT = 8,
	SCAN_PTE_UFFD_WP = 9,
	SCAN_PTE_MAPPED_HUGEPAGE = 10,
	SCAN_PAGE_RO = 11,
	SCAN_LACK_REFERENCED_PAGE = 12,
	SCAN_PAGE_NULL = 13,
	SCAN_SCAN_ABORT = 14,
	SCAN_PAGE_COUNT = 15,
	SCAN_PAGE_LRU = 16,
	SCAN_PAGE_LOCK = 17,
	SCAN_PAGE_ANON = 18,
	SCAN_PAGE_COMPOUND = 19,
	SCAN_ANY_PROCESS = 20,
	SCAN_VMA_NULL = 21,
	SCAN_VMA_CHECK = 22,
	SCAN_ADDRESS_RANGE = 23,
	SCAN_DEL_PAGE_LRU = 24,
	SCAN_ALLOC_HUGE_PAGE_FAIL = 25,
	SCAN_CGROUP_CHARGE_FAIL = 26,
	SCAN_TRUNCATED = 27,
	SCAN_PAGE_HAS_PRIVATE = 28,
	SCAN_STORE_FAILED = 29,
	SCAN_COPY_MC = 30,
	SCAN_PAGE_FILLED = 31,
};

enum scan_step {
	FAB_SCAN_START = 0,
	FAB_SCAN_GPNFT_FCP = 1,
	FAB_SCAN_GNNFT_FCP = 2,
	FAB_SCAN_GPNFT_NVME = 3,
	FAB_SCAN_GNNFT_NVME = 4,
};

enum sched_tunable_scaling {
	SCHED_TUNABLESCALING_NONE = 0,
	SCHED_TUNABLESCALING_LOG = 1,
	SCHED_TUNABLESCALING_LINEAR = 2,
	SCHED_TUNABLESCALING_END = 3,
};

enum scsi_cmnd_submitter {
	SUBMITTED_BY_BLOCK_LAYER = 0,
	SUBMITTED_BY_SCSI_ERROR_HANDLER = 1,
	SUBMITTED_BY_SCSI_RESET_IOCTL = 2,
} __attribute__((mode(byte)));

enum scsi_device_event {
	SDEV_EVT_MEDIA_CHANGE = 1,
	SDEV_EVT_INQUIRY_CHANGE_REPORTED = 2,
	SDEV_EVT_CAPACITY_CHANGE_REPORTED = 3,
	SDEV_EVT_SOFT_THRESHOLD_REACHED_REPORTED = 4,
	SDEV_EVT_MODE_PARAMETER_CHANGE_REPORTED = 5,
	SDEV_EVT_LUN_CHANGE_REPORTED = 6,
	SDEV_EVT_ALUA_STATE_CHANGE_REPORTED = 7,
	SDEV_EVT_POWER_ON_RESET_OCCURRED = 8,
	SDEV_EVT_FIRST = 1,
	SDEV_EVT_LAST = 8,
	SDEV_EVT_MAXBITS = 9,
};

enum scsi_device_state {
	SDEV_CREATED = 1,
	SDEV_RUNNING = 2,
	SDEV_CANCEL = 3,
	SDEV_DEL = 4,
	SDEV_QUIESCE = 5,
	SDEV_OFFLINE = 6,
	SDEV_TRANSPORT_OFFLINE = 7,
	SDEV_BLOCK = 8,
	SDEV_CREATED_BLOCK = 9,
};

enum scsi_devinfo_key {
	SCSI_DEVINFO_GLOBAL = 0,
	SCSI_DEVINFO_SPI = 1,
};

enum scsi_disposition {
	NEEDS_RETRY = 8193,
	SUCCESS = 8194,
	FAILED = 8195,
	QUEUED = 8196,
	SOFT_ERROR = 8197,
	ADD_TO_MLQUEUE = 8198,
	TIMEOUT_ERROR = 8199,
	SCSI_RETURN_NOT_HANDLED = 8200,
	FAST_IO_FAIL = 8201,
};

enum scsi_host_guard_type {
	SHOST_DIX_GUARD_CRC = 1,
	SHOST_DIX_GUARD_IP = 2,
};

enum scsi_host_prot_capabilities {
	SHOST_DIF_TYPE1_PROTECTION = 1,
	SHOST_DIF_TYPE2_PROTECTION = 2,
	SHOST_DIF_TYPE3_PROTECTION = 4,
	SHOST_DIX_TYPE0_PROTECTION = 8,
	SHOST_DIX_TYPE1_PROTECTION = 16,
	SHOST_DIX_TYPE2_PROTECTION = 32,
	SHOST_DIX_TYPE3_PROTECTION = 64,
};

enum scsi_host_state {
	SHOST_CREATED = 1,
	SHOST_RUNNING = 2,
	SHOST_CANCEL = 3,
	SHOST_DEL = 4,
	SHOST_RECOVERY = 5,
	SHOST_CANCEL_RECOVERY = 6,
	SHOST_DEL_RECOVERY = 7,
};

enum scsi_host_status {
	DID_OK = 0,
	DID_NO_CONNECT = 1,
	DID_BUS_BUSY = 2,
	DID_TIME_OUT = 3,
	DID_BAD_TARGET = 4,
	DID_ABORT = 5,
	DID_PARITY = 6,
	DID_ERROR = 7,
	DID_RESET = 8,
	DID_BAD_INTR = 9,
	DID_PASSTHROUGH = 10,
	DID_SOFT_ERROR = 11,
	DID_IMM_RETRY = 12,
	DID_REQUEUE = 13,
	DID_TRANSPORT_DISRUPTED = 14,
	DID_TRANSPORT_FAILFAST = 15,
	DID_TRANSPORT_MARGINAL = 20,
};

enum scsi_ml_status {
	SCSIML_STAT_OK = 0,
	SCSIML_STAT_RESV_CONFLICT = 1,
	SCSIML_STAT_NOSPC = 2,
	SCSIML_STAT_MED_ERROR = 3,
	SCSIML_STAT_TGT_FAILURE = 4,
	SCSIML_STAT_DL_TIMEOUT = 5,
};

enum scsi_msg_byte {
	COMMAND_COMPLETE = 0,
	EXTENDED_MESSAGE = 1,
	SAVE_POINTERS = 2,
	RESTORE_POINTERS = 3,
	DISCONNECT = 4,
	INITIATOR_ERROR = 5,
	ABORT_TASK_SET = 6,
	MESSAGE_REJECT = 7,
	NOP = 8,
	MSG_PARITY_ERROR = 9,
	LINKED_CMD_COMPLETE = 10,
	LINKED_FLG_CMD_COMPLETE = 11,
	TARGET_RESET = 12,
	ABORT_TASK = 13,
	CLEAR_TASK_SET = 14,
	INITIATE_RECOVERY = 15,
	RELEASE_RECOVERY = 16,
	TERMINATE_IO_PROC = 17,
	CLEAR_ACA = 22,
	LOGICAL_UNIT_RESET = 23,
	SIMPLE_QUEUE_TAG = 32,
	HEAD_OF_QUEUE_TAG = 33,
	ORDERED_QUEUE_TAG = 34,
	IGNORE_WIDE_RESIDUE = 35,
	ACA = 36,
	QAS_REQUEST = 85,
	BUS_DEVICE_RESET = 12,
	ABORT = 6,
};

enum scsi_pr_type {
	SCSI_PR_WRITE_EXCLUSIVE = 1,
	SCSI_PR_EXCLUSIVE_ACCESS = 3,
	SCSI_PR_WRITE_EXCLUSIVE_REG_ONLY = 5,
	SCSI_PR_EXCLUSIVE_ACCESS_REG_ONLY = 6,
	SCSI_PR_WRITE_EXCLUSIVE_ALL_REGS = 7,
	SCSI_PR_EXCLUSIVE_ACCESS_ALL_REGS = 8,
};

enum scsi_prot_flags {
	SCSI_PROT_TRANSFER_PI = 1,
	SCSI_PROT_GUARD_CHECK = 2,
	SCSI_PROT_REF_CHECK = 4,
	SCSI_PROT_REF_INCREMENT = 8,
	SCSI_PROT_IP_CHECKSUM = 16,
};

enum scsi_prot_operations {
	SCSI_PROT_NORMAL = 0,
	SCSI_PROT_READ_INSERT = 1,
	SCSI_PROT_WRITE_STRIP = 2,
	SCSI_PROT_READ_STRIP = 3,
	SCSI_PROT_WRITE_INSERT = 4,
	SCSI_PROT_READ_PASS = 5,
	SCSI_PROT_WRITE_PASS = 6,
};

enum scsi_prot_target_type {
	SCSI_PROT_DIF_TYPE0 = 0,
	SCSI_PROT_DIF_TYPE1 = 1,
	SCSI_PROT_DIF_TYPE2 = 2,
	SCSI_PROT_DIF_TYPE3 = 3,
};

enum scsi_scan_mode {
	SCSI_SCAN_INITIAL = 0,
	SCSI_SCAN_RESCAN = 1,
	SCSI_SCAN_MANUAL = 2,
};

enum scsi_target_state {
	STARGET_CREATED = 1,
	STARGET_RUNNING = 2,
	STARGET_REMOVE = 3,
	STARGET_CREATED_REMOVE = 4,
	STARGET_DEL = 5,
};

enum scsi_timeout_action {
	SCSI_EH_DONE = 0,
	SCSI_EH_RESET_TIMER = 1,
	SCSI_EH_NOT_HANDLED = 2,
};

enum scsi_timeouts {
	SCSI_DEFAULT_EH_TIMEOUT = 10000,
};

enum scsi_vpd_parameters {
	SCSI_VPD_HEADER_SIZE = 4,
	SCSI_VPD_LIST_SIZE = 36,
};

enum sctp_conntrack {
	SCTP_CONNTRACK_NONE = 0,
	SCTP_CONNTRACK_CLOSED = 1,
	SCTP_CONNTRACK_COOKIE_WAIT = 2,
	SCTP_CONNTRACK_COOKIE_ECHOED = 3,
	SCTP_CONNTRACK_ESTABLISHED = 4,
	SCTP_CONNTRACK_SHUTDOWN_SENT = 5,
	SCTP_CONNTRACK_SHUTDOWN_RECD = 6,
	SCTP_CONNTRACK_SHUTDOWN_ACK_SENT = 7,
	SCTP_CONNTRACK_HEARTBEAT_SENT = 8,
	SCTP_CONNTRACK_HEARTBEAT_ACKED = 9,
	SCTP_CONNTRACK_MAX = 10,
};

enum sctp_msg_flags {
	MSG_NOTIFICATION = 32768,
};

enum se_cmd_flags_table {
	SCF_SUPPORTED_SAM_OPCODE = 1,
	SCF_TRANSPORT_TASK_SENSE = 2,
	SCF_EMULATED_TASK_SENSE = 4,
	SCF_SCSI_DATA_CDB = 8,
	SCF_SCSI_TMR_CDB = 16,
	SCF_FUA = 32,
	SCF_SE_LUN_CMD = 64,
	SCF_BIDI = 128,
	SCF_SENT_CHECK_CONDITION = 256,
	SCF_OVERFLOW_BIT = 512,
	SCF_UNDERFLOW_BIT = 1024,
	SCF_ALUA_NON_OPTIMIZED = 2048,
	SCF_PASSTHROUGH_SG_TO_MEM_NOALLOC = 4096,
	SCF_COMPARE_AND_WRITE = 8192,
	SCF_PASSTHROUGH_PROT_SG_TO_MEM_NOALLOC = 16384,
	SCF_ACK_KREF = 32768,
	SCF_USE_CPUID = 65536,
	SCF_TASK_ATTR_SET = 131072,
	SCF_TREAT_READ_AS_NORMAL = 262144,
};

enum security_cmd_enabled_bits {
	CXL_SEC_ENABLED_SANITIZE = 0,
	CXL_SEC_ENABLED_SECURE_ERASE = 1,
	CXL_SEC_ENABLED_GET_SECURITY_STATE = 2,
	CXL_SEC_ENABLED_SET_PASSPHRASE = 3,
	CXL_SEC_ENABLED_DISABLE_PASSPHRASE = 4,
	CXL_SEC_ENABLED_UNLOCK = 5,
	CXL_SEC_ENABLED_FREEZE_SECURITY = 6,
	CXL_SEC_ENABLED_PASSPHRASE_SECURE_ERASE = 7,
	CXL_SEC_ENABLED_MAX = 8,
};

enum seg6_end_dt_mode {
	DT_INVALID_MODE = -22,
	DT_LEGACY_MODE = 0,
	DT_VRF_MODE = 1,
};

enum seg6_local_flv_action {
	SEG6_LOCAL_FLV_ACT_UNSPEC = 0,
	SEG6_LOCAL_FLV_ACT_END = 1,
	SEG6_LOCAL_FLV_ACT_PSP = 2,
	SEG6_LOCAL_FLV_ACT_USP = 3,
	SEG6_LOCAL_FLV_ACT_USD = 4,
	__SEG6_LOCAL_FLV_ACT_MAX = 5,
};

enum seg6_local_pktinfo {
	SEG6_LOCAL_PKTINFO_NOHDR = 0,
	SEG6_LOCAL_PKTINFO_SL_ZERO = 1,
	SEG6_LOCAL_PKTINFO_SL_ONE = 2,
	SEG6_LOCAL_PKTINFO_SL_MORE = 3,
	__SEG6_LOCAL_PKTINFO_MAX = 4,
};

enum selector_index {
	SELIND_LN0_TX = 0,
	SELIND_LN1_TX = 1,
	SELIND_LN0_RX = 4,
	SELIND_LN1_RX = 5,
};

enum sensors {
	FAN = 0,
	TEMP = 1,
	POWER_SUPPLY = 2,
	POWER_INPUT = 3,
	CURRENT = 4,
	ENERGY = 5,
	MAX_SENSOR_TYPE = 6,
};

enum serdev_parity {
	SERDEV_PARITY_NONE = 0,
	SERDEV_PARITY_EVEN = 1,
	SERDEV_PARITY_ODD = 2,
};

enum serio_event_type {
	SERIO_RESCAN_PORT = 0,
	SERIO_RECONNECT_PORT = 1,
	SERIO_RECONNECT_SUBTREE = 2,
	SERIO_REGISTER_PORT = 3,
	SERIO_ATTACH_DRIVER = 4,
};

enum service_response {
	SAS_TASK_COMPLETE = 0,
	SAS_TASK_UNDELIVERED = -1,
};

enum sge_context_type {
	SGE_CNTXT_RDMA = 0,
	SGE_CNTXT_ETH = 2,
	SGE_CNTXT_OFLD = 4,
	SGE_CNTXT_CTRL = 5,
};

enum sgp_type {
	SGP_READ = 0,
	SGP_NOALLOC = 1,
	SGP_CACHE = 2,
	SGP_WRITE = 3,
	SGP_FALLOC = 4,
};

enum sgpio_led_status {
	LED_OFF___2 = 0,
	LED_ON___2 = 1,
	LED_BLINKA = 2,
	LED_BLINKA_INV = 3,
	LED_BLINKA_SOF = 4,
	LED_BLINKA_EOF = 5,
	LED_BLINKB = 6,
	LED_BLINKB_INV = 7,
};

enum sgpio_registers {
	MVS_SGPIO_HOST_OFFSET = 256,
	MVS_SGPIO_CFG0 = 49664,
	MVS_SGPIO_CFG0_ENABLE = 1,
	MVS_SGPIO_CFG0_BLINKB = 2,
	MVS_SGPIO_CFG0_BLINKA = 4,
	MVS_SGPIO_CFG0_INVSCLK = 8,
	MVS_SGPIO_CFG0_INVSLOAD = 16,
	MVS_SGPIO_CFG0_INVSDOUT = 32,
	MVS_SGPIO_CFG0_SLOAD_FALLEDGE = 64,
	MVS_SGPIO_CFG0_SDOUT_FALLEDGE = 128,
	MVS_SGPIO_CFG0_SDIN_RISEEDGE = 256,
	MVS_SGPIO_CFG0_MAN_BITLEN_SHIFT = 18,
	MVS_SGPIO_CFG0_AUT_BITLEN_SHIFT = 24,
	MVS_SGPIO_CFG1 = 49668,
	MVS_SGPIO_CFG1_LOWA_SHIFT = 0,
	MVS_SGPIO_CFG1_HIA_SHIFT = 4,
	MVS_SGPIO_CFG1_LOWB_SHIFT = 8,
	MVS_SGPIO_CFG1_HIB_SHIFT = 12,
	MVS_SGPIO_CFG1_MAXACTON_SHIFT = 16,
	MVS_SGPIO_CFG1_FORCEACTOFF_SHIFT = 20,
	MVS_SGPIO_CFG1_STRCHACTON_SHIFT = 24,
	MVS_SGPIO_CFG1_STRCHACTOFF_SHIFT = 28,
	MVS_SGPIO_CFG2 = 49672,
	MVS_SGPIO_CFG2_CLK_SHIFT = 0,
	MVS_SGPIO_CFG2_BLINK_SHIFT = 20,
	MVS_SGPIO_CTRL = 49676,
	MVS_SGPIO_CTRL_SDOUT_AUTO = 2,
	MVS_SGPIO_CTRL_SDOUT_SHIFT = 2,
	MVS_SGPIO_DSRC = 49696,
	MVS_SGPIO_DCTRL = 49720,
	MVS_SGPIO_DCTRL_ERR_SHIFT = 0,
	MVS_SGPIO_DCTRL_LOC_SHIFT = 3,
	MVS_SGPIO_DCTRL_ACT_SHIFT = 5,
};

enum shmem_param {
	Opt_gid___6 = 0,
	Opt_huge = 1,
	Opt_mode___5 = 2,
	Opt_mpol = 3,
	Opt_nr_blocks = 4,
	Opt_nr_inodes___2 = 5,
	Opt_size___2 = 6,
	Opt_uid___5 = 7,
	Opt_inode32 = 8,
	Opt_inode64 = 9,
	Opt_noswap = 10,
	Opt_quota___2 = 11,
	Opt_usrquota___2 = 12,
	Opt_grpquota___2 = 13,
	Opt_usrquota_block_hardlimit = 14,
	Opt_usrquota_inode_hardlimit = 15,
	Opt_grpquota_block_hardlimit = 16,
	Opt_grpquota_inode_hardlimit = 17,
};

enum si_type {
	SI_TYPE_INVALID = 0,
	SI_KCS = 1,
	SI_SMIC = 2,
	SI_BT = 3,
	SI_TYPE_MAX = 4,
};

enum sig_handler {
	HANDLER_CURRENT = 0,
	HANDLER_SIG_DFL = 1,
	HANDLER_EXIT = 2,
};

enum siginfo_layout {
	SIL_KILL = 0,
	SIL_TIMER = 1,
	SIL_POLL = 2,
	SIL_FAULT = 3,
	SIL_FAULT_TRAPNO = 4,
	SIL_FAULT_MCEERR = 5,
	SIL_FAULT_BNDERR = 6,
	SIL_FAULT_PKUERR = 7,
	SIL_FAULT_PERF_EVENT = 8,
	SIL_CHLD = 9,
	SIL_RT = 10,
	SIL_SYS = 11,
};

enum sis_fw_triage_status {
	FW_TRIAGE_NOT_STARTED = 0,
	FW_TRIAGE_STARTED = 1,
	FW_TRIAGE_COND_INVALID = 2,
	FW_TRIAGE_COMPLETED = 3,
};

enum sk_action {
	SK_DROP = 0,
	SK_PASS = 1,
};

enum sk_pacing {
	SK_PACING_NONE = 0,
	SK_PACING_NEEDED = 1,
	SK_PACING_FQ = 2,
};

enum sk_psock_state_bits {
	SK_PSOCK_TX_ENABLED = 0,
	SK_PSOCK_RX_STRP_ENABLED = 1,
};

enum sk_rst_reason {
	SK_RST_REASON_NOT_SPECIFIED = 0,
	SK_RST_REASON_NO_SOCKET = 1,
	SK_RST_REASON_TCP_INVALID_ACK_SEQUENCE = 2,
	SK_RST_REASON_TCP_RFC7323_PAWS = 3,
	SK_RST_REASON_TCP_TOO_OLD_ACK = 4,
	SK_RST_REASON_TCP_ACK_UNSENT_DATA = 5,
	SK_RST_REASON_TCP_FLAGS = 6,
	SK_RST_REASON_TCP_OLD_ACK = 7,
	SK_RST_REASON_TCP_ABORT_ON_DATA = 8,
	SK_RST_REASON_TCP_TIMEWAIT_SOCKET = 9,
	SK_RST_REASON_INVALID_SYN = 10,
	SK_RST_REASON_MPTCP_RST_EUNSPEC = 11,
	SK_RST_REASON_MPTCP_RST_EMPTCP = 12,
	SK_RST_REASON_MPTCP_RST_ERESOURCE = 13,
	SK_RST_REASON_MPTCP_RST_EPROHIBIT = 14,
	SK_RST_REASON_MPTCP_RST_EWQ2BIG = 15,
	SK_RST_REASON_MPTCP_RST_EBADPERF = 16,
	SK_RST_REASON_MPTCP_RST_EMIDDLEBOX = 17,
	SK_RST_REASON_ERROR = 18,
	SK_RST_REASON_MAX = 19,
};

enum skb_drop_reason {
	SKB_NOT_DROPPED_YET = 0,
	SKB_CONSUMED = 1,
	SKB_DROP_REASON_NOT_SPECIFIED = 2,
	SKB_DROP_REASON_NO_SOCKET = 3,
	SKB_DROP_REASON_PKT_TOO_SMALL = 4,
	SKB_DROP_REASON_TCP_CSUM = 5,
	SKB_DROP_REASON_SOCKET_FILTER = 6,
	SKB_DROP_REASON_UDP_CSUM = 7,
	SKB_DROP_REASON_NETFILTER_DROP = 8,
	SKB_DROP_REASON_OTHERHOST = 9,
	SKB_DROP_REASON_IP_CSUM = 10,
	SKB_DROP_REASON_IP_INHDR = 11,
	SKB_DROP_REASON_IP_RPFILTER = 12,
	SKB_DROP_REASON_UNICAST_IN_L2_MULTICAST = 13,
	SKB_DROP_REASON_XFRM_POLICY = 14,
	SKB_DROP_REASON_IP_NOPROTO = 15,
	SKB_DROP_REASON_SOCKET_RCVBUFF = 16,
	SKB_DROP_REASON_PROTO_MEM = 17,
	SKB_DROP_REASON_TCP_AUTH_HDR = 18,
	SKB_DROP_REASON_TCP_MD5NOTFOUND = 19,
	SKB_DROP_REASON_TCP_MD5UNEXPECTED = 20,
	SKB_DROP_REASON_TCP_MD5FAILURE = 21,
	SKB_DROP_REASON_TCP_AONOTFOUND = 22,
	SKB_DROP_REASON_TCP_AOUNEXPECTED = 23,
	SKB_DROP_REASON_TCP_AOKEYNOTFOUND = 24,
	SKB_DROP_REASON_TCP_AOFAILURE = 25,
	SKB_DROP_REASON_SOCKET_BACKLOG = 26,
	SKB_DROP_REASON_TCP_FLAGS = 27,
	SKB_DROP_REASON_TCP_ABORT_ON_DATA = 28,
	SKB_DROP_REASON_TCP_ZEROWINDOW = 29,
	SKB_DROP_REASON_TCP_OLD_DATA = 30,
	SKB_DROP_REASON_TCP_OVERWINDOW = 31,
	SKB_DROP_REASON_TCP_OFOMERGE = 32,
	SKB_DROP_REASON_TCP_RFC7323_PAWS = 33,
	SKB_DROP_REASON_TCP_OLD_SEQUENCE = 34,
	SKB_DROP_REASON_TCP_INVALID_SEQUENCE = 35,
	SKB_DROP_REASON_TCP_INVALID_ACK_SEQUENCE = 36,
	SKB_DROP_REASON_TCP_RESET = 37,
	SKB_DROP_REASON_TCP_INVALID_SYN = 38,
	SKB_DROP_REASON_TCP_CLOSE = 39,
	SKB_DROP_REASON_TCP_FASTOPEN = 40,
	SKB_DROP_REASON_TCP_OLD_ACK = 41,
	SKB_DROP_REASON_TCP_TOO_OLD_ACK = 42,
	SKB_DROP_REASON_TCP_ACK_UNSENT_DATA = 43,
	SKB_DROP_REASON_TCP_OFO_QUEUE_PRUNE = 44,
	SKB_DROP_REASON_TCP_OFO_DROP = 45,
	SKB_DROP_REASON_IP_OUTNOROUTES = 46,
	SKB_DROP_REASON_BPF_CGROUP_EGRESS = 47,
	SKB_DROP_REASON_IPV6DISABLED = 48,
	SKB_DROP_REASON_NEIGH_CREATEFAIL = 49,
	SKB_DROP_REASON_NEIGH_FAILED = 50,
	SKB_DROP_REASON_NEIGH_QUEUEFULL = 51,
	SKB_DROP_REASON_NEIGH_DEAD = 52,
	SKB_DROP_REASON_TC_EGRESS = 53,
	SKB_DROP_REASON_SECURITY_HOOK = 54,
	SKB_DROP_REASON_QDISC_DROP = 55,
	SKB_DROP_REASON_CPU_BACKLOG = 56,
	SKB_DROP_REASON_XDP = 57,
	SKB_DROP_REASON_TC_INGRESS = 58,
	SKB_DROP_REASON_UNHANDLED_PROTO = 59,
	SKB_DROP_REASON_SKB_CSUM = 60,
	SKB_DROP_REASON_SKB_GSO_SEG = 61,
	SKB_DROP_REASON_SKB_UCOPY_FAULT = 62,
	SKB_DROP_REASON_DEV_HDR = 63,
	SKB_DROP_REASON_DEV_READY = 64,
	SKB_DROP_REASON_FULL_RING = 65,
	SKB_DROP_REASON_NOMEM = 66,
	SKB_DROP_REASON_HDR_TRUNC = 67,
	SKB_DROP_REASON_TAP_FILTER = 68,
	SKB_DROP_REASON_TAP_TXFILTER = 69,
	SKB_DROP_REASON_ICMP_CSUM = 70,
	SKB_DROP_REASON_INVALID_PROTO = 71,
	SKB_DROP_REASON_IP_INADDRERRORS = 72,
	SKB_DROP_REASON_IP_INNOROUTES = 73,
	SKB_DROP_REASON_PKT_TOO_BIG = 74,
	SKB_DROP_REASON_DUP_FRAG = 75,
	SKB_DROP_REASON_FRAG_REASM_TIMEOUT = 76,
	SKB_DROP_REASON_FRAG_TOO_FAR = 77,
	SKB_DROP_REASON_TCP_MINTTL = 78,
	SKB_DROP_REASON_IPV6_BAD_EXTHDR = 79,
	SKB_DROP_REASON_IPV6_NDISC_FRAG = 80,
	SKB_DROP_REASON_IPV6_NDISC_HOP_LIMIT = 81,
	SKB_DROP_REASON_IPV6_NDISC_BAD_CODE = 82,
	SKB_DROP_REASON_IPV6_NDISC_BAD_OPTIONS = 83,
	SKB_DROP_REASON_IPV6_NDISC_NS_OTHERHOST = 84,
	SKB_DROP_REASON_QUEUE_PURGE = 85,
	SKB_DROP_REASON_TC_COOKIE_ERROR = 86,
	SKB_DROP_REASON_PACKET_SOCK_ERROR = 87,
	SKB_DROP_REASON_TC_CHAIN_NOTFOUND = 88,
	SKB_DROP_REASON_TC_RECLASSIFY_LOOP = 89,
	SKB_DROP_REASON_MAX = 90,
	SKB_DROP_REASON_SUBSYS_MASK = 4294901760,
};

enum skb_drop_reason_subsys {
	SKB_DROP_REASON_SUBSYS_CORE = 0,
	SKB_DROP_REASON_SUBSYS_MAC80211_UNUSABLE = 1,
	SKB_DROP_REASON_SUBSYS_MAC80211_MONITOR = 2,
	SKB_DROP_REASON_SUBSYS_OPENVSWITCH = 3,
	SKB_DROP_REASON_SUBSYS_NUM = 4,
};

enum skb_ext_id {
	SKB_EXT_BRIDGE_NF = 0,
	SKB_EXT_SEC_PATH = 1,
	TC_SKB_EXT = 2,
	SKB_EXT_MPTCP = 3,
	SKB_EXT_MCTP = 4,
	SKB_EXT_NUM = 5,
};

enum sknetlink_groups {
	SKNLGRP_NONE = 0,
	SKNLGRP_INET_TCP_DESTROY = 1,
	SKNLGRP_INET_UDP_DESTROY = 2,
	SKNLGRP_INET6_TCP_DESTROY = 3,
	SKNLGRP_INET6_UDP_DESTROY = 4,
	__SKNLGRP_MAX = 5,
};

enum slab_stat_type {
	SL_ALL = 0,
	SL_PARTIAL = 1,
	SL_CPU = 2,
	SL_OBJECTS = 3,
	SL_TOTAL = 4,
};

enum slab_state {
	DOWN = 0,
	PARTIAL = 1,
	UP = 2,
	FULL = 3,
};

enum slb_index {
	LINEAR_INDEX = 0,
	KSTACK_INDEX = 1,
};

enum snic_disc_state {
	SNIC_DISC_NONE = 0,
	SNIC_DISC_INIT = 1,
	SNIC_DISC_PENDING = 2,
	SNIC_DISC_DONE = 3,
};

enum snic_ev_type {
	SNIC_EV_TGT_OFFLINE = 1,
	SNIC_EV_TGT_ONLINE = 2,
	SNIC_EV_LUN_OFFLINE = 3,
	SNIC_EV_LUN_ONLINE = 4,
	SNIC_EV_CONF_CHG = 5,
	SNIC_EV_TGT_ADDED = 6,
	SNIC_EV_TGT_DELTD = 7,
	SNIC_EV_LUN_ADDED = 8,
	SNIC_EV_LUN_DELTD = 9,
	SNIC_EV_DISC_CMPL = 16,
};

enum snic_io_status {
	SNIC_STAT_IO_SUCCESS = 0,
	SNIC_STAT_INVALID_HDR = 1,
	SNIC_STAT_OUT_OF_RES = 2,
	SNIC_STAT_INVALID_PARM = 3,
	SNIC_STAT_REQ_NOT_SUP = 4,
	SNIC_STAT_IO_NOT_FOUND = 5,
	SNIC_STAT_ABORTED = 6,
	SNIC_STAT_TIMEOUT = 7,
	SNIC_STAT_SGL_INVALID = 8,
	SNIC_STAT_DATA_CNT_MISMATCH = 9,
	SNIC_STAT_FW_ERR = 10,
	SNIC_STAT_ITMF_REJECT = 11,
	SNIC_STAT_ITMF_FAIL = 12,
	SNIC_STAT_ITMF_INCORRECT_LUN = 13,
	SNIC_STAT_CMND_REJECT = 14,
	SNIC_STAT_DEV_OFFLINE = 15,
	SNIC_STAT_NO_BOOTLUN = 16,
	SNIC_STAT_SCSI_ERR = 17,
	SNIC_STAT_NOT_READY = 18,
	SNIC_STAT_FATAL_ERROR = 19,
};

enum snic_io_type {
	SNIC_REQ_REPORT_TGTS = 2,
	SNIC_REQ_ICMND = 3,
	SNIC_REQ_ITMF = 4,
	SNIC_REQ_HBA_RESET = 5,
	SNIC_REQ_EXCH_VER = 6,
	SNIC_REQ_TGT_INFO = 7,
	SNIC_REQ_BOOT_LUNS = 8,
	SNIC_RSP_REPORT_TGTS_CMPL = 18,
	SNIC_RSP_ICMND_CMPL = 19,
	SNIC_RSP_ITMF_CMPL = 20,
	SNIC_RSP_HBA_RESET_CMPL = 21,
	SNIC_RSP_EXCH_VER_CMPL = 22,
	SNIC_RSP_BOOT_LUNS_CMPL = 23,
	SNIC_MSG_ACK = 128,
	SNIC_MSG_ASYNC_EVNOTIFY = 129,
};

enum snic_ioreq_state {
	SNIC_IOREQ_NOT_INITED = 0,
	SNIC_IOREQ_PENDING = 1,
	SNIC_IOREQ_ABTS_PENDING = 2,
	SNIC_IOREQ_ABTS_COMPLETE = 3,
	SNIC_IOREQ_LR_PENDING = 4,
	SNIC_IOREQ_LR_COMPLETE = 5,
	SNIC_IOREQ_COMPLETE = 6,
};

enum snic_itmf_tm_type {
	SNIC_ITMF_ABTS_TASK = 1,
	SNIC_ITMF_ABTS_TASK_SET = 2,
	SNIC_ITMF_CLR_TASK = 3,
	SNIC_ITMF_CLR_TASKSET = 4,
	SNIC_ITMF_LUN_RESET = 5,
	SNIC_ITMF_ABTS_TASK_TERM = 6,
};

enum snic_msix_intr_index {
	SNIC_MSIX_WQ = 0,
	SNIC_MSIX_IO_CMPL = 1,
	SNIC_MSIX_ERR_NOTIFY = 2,
	SNIC_MSIX_INTR_MAX = 3,
};

enum snic_req_cache_type {
	SNIC_REQ_CACHE_DFLT_SGL = 0,
	SNIC_REQ_CACHE_MAX_SGL = 1,
	SNIC_REQ_TM_CACHE = 2,
	SNIC_REQ_MAX_CACHES = 3,
};

enum snic_state {
	SNIC_INIT = 0,
	SNIC_ERROR = 1,
	SNIC_ONLINE = 2,
	SNIC_OFFLINE = 3,
	SNIC_FWRESET = 4,
};

enum snic_tgt_state {
	SNIC_TGT_STAT_NONE = 0,
	SNIC_TGT_STAT_INIT = 1,
	SNIC_TGT_STAT_ONLINE = 2,
	SNIC_TGT_STAT_OFFLINE = 3,
	SNIC_TGT_STAT_DEL = 4,
};

enum snic_tgt_type {
	SNIC_TGT_NONE = 0,
	SNIC_TGT_DAS = 1,
	SNIC_TGT_SAN = 2,
};

enum snic_type {
	SNIC_NONE = 0,
	SNIC_DAS = 1,
	SNIC_SAN = 2,
};

enum sock_flags {
	SOCK_DEAD = 0,
	SOCK_DONE = 1,
	SOCK_URGINLINE = 2,
	SOCK_KEEPOPEN = 3,
	SOCK_LINGER = 4,
	SOCK_DESTROY = 5,
	SOCK_BROADCAST = 6,
	SOCK_TIMESTAMP = 7,
	SOCK_ZAPPED = 8,
	SOCK_USE_WRITE_QUEUE = 9,
	SOCK_DBG = 10,
	SOCK_RCVTSTAMP = 11,
	SOCK_RCVTSTAMPNS = 12,
	SOCK_LOCALROUTE = 13,
	SOCK_MEMALLOC = 14,
	SOCK_TIMESTAMPING_RX_SOFTWARE = 15,
	SOCK_FASYNC = 16,
	SOCK_RXQ_OVFL = 17,
	SOCK_ZEROCOPY = 18,
	SOCK_WIFI_STATUS = 19,
	SOCK_NOFCS = 20,
	SOCK_FILTER_LOCKED = 21,
	SOCK_SELECT_ERR_QUEUE = 22,
	SOCK_RCU_FREE = 23,
	SOCK_TXTIME = 24,
	SOCK_XDP = 25,
	SOCK_TSTAMP_NEW = 26,
	SOCK_RCVMARK = 27,
};

enum sock_shutdown_cmd {
	SHUT_RD = 0,
	SHUT_WR = 1,
	SHUT_RDWR = 2,
};

enum sock_type {
	SOCK_STREAM = 1,
	SOCK_DGRAM = 2,
	SOCK_RAW = 3,
	SOCK_RDM = 4,
	SOCK_SEQPACKET = 5,
	SOCK_DCCP = 6,
	SOCK_PACKET = 10,
};

enum special_kfunc_type {
	KF_bpf_obj_new_impl = 0,
	KF_bpf_obj_drop_impl = 1,
	KF_bpf_refcount_acquire_impl = 2,
	KF_bpf_list_push_front_impl = 3,
	KF_bpf_list_push_back_impl = 4,
	KF_bpf_list_pop_front = 5,
	KF_bpf_list_pop_back = 6,
	KF_bpf_cast_to_kern_ctx = 7,
	KF_bpf_rdonly_cast = 8,
	KF_bpf_rcu_read_lock = 9,
	KF_bpf_rcu_read_unlock = 10,
	KF_bpf_rbtree_remove = 11,
	KF_bpf_rbtree_add_impl = 12,
	KF_bpf_rbtree_first = 13,
	KF_bpf_dynptr_from_skb = 14,
	KF_bpf_dynptr_from_xdp = 15,
	KF_bpf_dynptr_slice = 16,
	KF_bpf_dynptr_slice_rdwr = 17,
	KF_bpf_dynptr_clone = 18,
	KF_bpf_percpu_obj_new_impl = 19,
	KF_bpf_percpu_obj_drop_impl = 20,
	KF_bpf_throw = 21,
	KF_bpf_wq_set_callback_impl = 22,
	KF_bpf_preempt_disable = 23,
	KF_bpf_preempt_enable = 24,
	KF_bpf_iter_css_task_new = 25,
	KF_bpf_session_cookie = 26,
};

enum spi_compare_returns {
	SPI_COMPARE_SUCCESS = 0,
	SPI_COMPARE_FAILURE = 1,
	SPI_COMPARE_SKIP_TEST = 2,
};

enum spi_mem_data_dir {
	SPI_MEM_NO_DATA = 0,
	SPI_MEM_DATA_IN = 1,
	SPI_MEM_DATA_OUT = 2,
};

enum spi_signal_type {
	SPI_SIGNAL_UNKNOWN = 1,
	SPI_SIGNAL_SE = 2,
	SPI_SIGNAL_LVD = 3,
	SPI_SIGNAL_HVD = 4,
};

enum spu_utilization_state {
	SPU_UTIL_USER = 0,
	SPU_UTIL_SYSTEM = 1,
	SPU_UTIL_IOWAIT = 2,
	SPU_UTIL_IDLE_LOADED = 3,
	SPU_UTIL_MAX = 4,
};

enum srp_rport_state {
	SRP_RPORT_RUNNING = 0,
	SRP_RPORT_BLOCKED = 1,
	SRP_RPORT_FAIL_FAST = 2,
	SRP_RPORT_LOST = 3,
};

enum sta_type {
	sta_pre_addr = 1,
	sta_pos_addr = 2,
};

enum stat_group {
	STAT_READ = 0,
	STAT_WRITE = 1,
	STAT_DISCARD = 2,
	STAT_FLUSH = 3,
	NR_STAT_GROUPS = 4,
};

enum stat_item {
	ALLOC_FASTPATH = 0,
	ALLOC_SLOWPATH = 1,
	FREE_FASTPATH = 2,
	FREE_SLOWPATH = 3,
	FREE_FROZEN = 4,
	FREE_ADD_PARTIAL = 5,
	FREE_REMOVE_PARTIAL = 6,
	ALLOC_FROM_PARTIAL = 7,
	ALLOC_SLAB = 8,
	ALLOC_REFILL = 9,
	ALLOC_NODE_MISMATCH = 10,
	FREE_SLAB = 11,
	CPUSLAB_FLUSH = 12,
	DEACTIVATE_FULL = 13,
	DEACTIVATE_EMPTY = 14,
	DEACTIVATE_TO_HEAD = 15,
	DEACTIVATE_TO_TAIL = 16,
	DEACTIVATE_REMOTE_FREES = 17,
	DEACTIVATE_BYPASS = 18,
	ORDER_FALLBACK = 19,
	CMPXCHG_DOUBLE_CPU_FAIL = 20,
	CMPXCHG_DOUBLE_FAIL = 21,
	CPU_PARTIAL_ALLOC = 22,
	CPU_PARTIAL_FREE = 23,
	CPU_PARTIAL_NODE = 24,
	CPU_PARTIAL_DRAIN = 25,
	NR_SLUB_STAT_ITEMS = 26,
};

enum state {
	Start = 0,
	Collect = 1,
	GotHeader = 2,
	SkipIt = 3,
	GotName = 4,
	CopyFile = 5,
	GotSymlink = 6,
	Reset = 7,
};

enum state___2 {
	FW_INVALID_ST = 0,
	FW_STATUS_ST = 1,
	FW_COMMAND_ST = 2,
};

enum status_buffer {
	SB_EIR_OFF = 0,
	SB_RFB_OFF = 8,
	SB_RFB_MAX = 1024,
};

enum stf_barrier_type {
	STF_BARRIER_NONE = 1,
	STF_BARRIER_FALLBACK = 2,
	STF_BARRIER_EIEIO = 4,
	STF_BARRIER_SYNC_ORI = 8,
};

enum stmpe_block {
	STMPE_BLOCK_GPIO = 1,
	STMPE_BLOCK_KEYPAD = 2,
	STMPE_BLOCK_TOUCHSCREEN = 4,
	STMPE_BLOCK_ADC = 8,
	STMPE_BLOCK_PWM = 16,
	STMPE_BLOCK_ROTATOR = 32,
};

enum stmpe_partnum {
	STMPE610 = 0,
	STMPE801 = 1,
	STMPE811 = 2,
	STMPE1600 = 3,
	STMPE1601 = 4,
	STMPE1801 = 5,
	STMPE2401 = 6,
	STMPE2403 = 7,
	STMPE_NBR_PARTS = 8,
};

enum storm_id {
	USTORM_ID = 0,
	CSTORM_ID = 1,
	XSTORM_ID = 2,
	TSTORM_ID = 3,
	ATTENTION_ID = 4,
	MAX_STORM_ID = 5,
};

enum string_size_units {
	STRING_UNITS_10 = 0,
	STRING_UNITS_2 = 1,
	STRING_UNITS_MASK = 1,
	STRING_UNITS_NO_SPACE = 1073741824,
	STRING_UNITS_NO_BYTES = 2147483648,
};

enum sum_check_bits {
	SUM_CHECK_P = 0,
	SUM_CHECK_Q = 1,
};

enum sum_check_flags {
	SUM_CHECK_P_RESULT = 1,
	SUM_CHECK_Q_RESULT = 2,
};

enum support_mode {
	ALLOW_LEGACY = 0,
	DENY_LEGACY = 1,
};

enum suspend_stat_step {
	SUSPEND_WORKING = 0,
	SUSPEND_FREEZE = 1,
	SUSPEND_PREPARE = 2,
	SUSPEND_SUSPEND = 3,
	SUSPEND_SUSPEND_LATE = 4,
	SUSPEND_SUSPEND_NOIRQ = 5,
	SUSPEND_RESUME_NOIRQ = 6,
	SUSPEND_RESUME_EARLY = 7,
	SUSPEND_RESUME = 8,
};

enum svc_auth_status {
	SVC_GARBAGE = 1,
	SVC_SYSERR = 2,
	SVC_VALID = 3,
	SVC_NEGATIVE = 4,
	SVC_OK = 5,
	SVC_DROP = 6,
	SVC_CLOSE = 7,
	SVC_DENIED = 8,
	SVC_PENDING = 9,
	SVC_COMPLETE = 10,
};

enum sw_activity {
	OFF = 0,
	BLINK_ON = 1,
	BLINK_OFF = 2,
};

enum switchdev_attr_id {
	SWITCHDEV_ATTR_ID_UNDEFINED = 0,
	SWITCHDEV_ATTR_ID_PORT_STP_STATE = 1,
	SWITCHDEV_ATTR_ID_PORT_MST_STATE = 2,
	SWITCHDEV_ATTR_ID_PORT_BRIDGE_FLAGS = 3,
	SWITCHDEV_ATTR_ID_PORT_PRE_BRIDGE_FLAGS = 4,
	SWITCHDEV_ATTR_ID_PORT_MROUTER = 5,
	SWITCHDEV_ATTR_ID_BRIDGE_AGEING_TIME = 6,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_FILTERING = 7,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_PROTOCOL = 8,
	SWITCHDEV_ATTR_ID_BRIDGE_MC_DISABLED = 9,
	SWITCHDEV_ATTR_ID_BRIDGE_MROUTER = 10,
	SWITCHDEV_ATTR_ID_BRIDGE_MST = 11,
	SWITCHDEV_ATTR_ID_MRP_PORT_ROLE = 12,
	SWITCHDEV_ATTR_ID_VLAN_MSTI = 13,
};

enum switchdev_notifier_type {
	SWITCHDEV_FDB_ADD_TO_BRIDGE = 1,
	SWITCHDEV_FDB_DEL_TO_BRIDGE = 2,
	SWITCHDEV_FDB_ADD_TO_DEVICE = 3,
	SWITCHDEV_FDB_DEL_TO_DEVICE = 4,
	SWITCHDEV_FDB_OFFLOADED = 5,
	SWITCHDEV_FDB_FLUSH_TO_BRIDGE = 6,
	SWITCHDEV_PORT_OBJ_ADD = 7,
	SWITCHDEV_PORT_OBJ_DEL = 8,
	SWITCHDEV_PORT_ATTR_SET = 9,
	SWITCHDEV_VXLAN_FDB_ADD_TO_BRIDGE = 10,
	SWITCHDEV_VXLAN_FDB_DEL_TO_BRIDGE = 11,
	SWITCHDEV_VXLAN_FDB_ADD_TO_DEVICE = 12,
	SWITCHDEV_VXLAN_FDB_DEL_TO_DEVICE = 13,
	SWITCHDEV_VXLAN_FDB_OFFLOADED = 14,
	SWITCHDEV_BRPORT_OFFLOADED = 15,
	SWITCHDEV_BRPORT_UNOFFLOADED = 16,
	SWITCHDEV_BRPORT_REPLAY = 17,
};

enum switchdev_obj_id {
	SWITCHDEV_OBJ_ID_UNDEFINED = 0,
	SWITCHDEV_OBJ_ID_PORT_VLAN = 1,
	SWITCHDEV_OBJ_ID_PORT_MDB = 2,
	SWITCHDEV_OBJ_ID_HOST_MDB = 3,
	SWITCHDEV_OBJ_ID_MRP = 4,
	SWITCHDEV_OBJ_ID_RING_TEST_MRP = 5,
	SWITCHDEV_OBJ_ID_RING_ROLE_MRP = 6,
	SWITCHDEV_OBJ_ID_RING_STATE_MRP = 7,
	SWITCHDEV_OBJ_ID_IN_TEST_MRP = 8,
	SWITCHDEV_OBJ_ID_IN_ROLE_MRP = 9,
	SWITCHDEV_OBJ_ID_IN_STATE_MRP = 10,
};

enum sys_off_mode {
	SYS_OFF_MODE_POWER_OFF_PREPARE = 0,
	SYS_OFF_MODE_POWER_OFF = 1,
	SYS_OFF_MODE_RESTART_PREPARE = 2,
	SYS_OFF_MODE_RESTART = 3,
};

enum sysctl_writes_mode {
	SYSCTL_WRITES_LEGACY = -1,
	SYSCTL_WRITES_WARN = 0,
	SYSCTL_WRITES_STRICT = 1,
};

enum system_states {
	SYSTEM_BOOTING = 0,
	SYSTEM_SCHEDULING = 1,
	SYSTEM_FREEING_INITMEM = 2,
	SYSTEM_RUNNING = 3,
	SYSTEM_HALT = 4,
	SYSTEM_POWER_OFF = 5,
	SYSTEM_RESTART = 6,
	SYSTEM_SUSPEND = 7,
};

enum t10_dif_type {
	T10_PI_TYPE0_PROTECTION = 0,
	T10_PI_TYPE1_PROTECTION = 1,
	T10_PI_TYPE2_PROTECTION = 2,
	T10_PI_TYPE3_PROTECTION = 3,
};

enum t3ctype {
	T3A = 0,
	T3B = 1,
	T3C = 2,
};

enum target_prot_op {
	TARGET_PROT_NORMAL = 0,
	TARGET_PROT_DIN_INSERT = 1,
	TARGET_PROT_DOUT_INSERT = 2,
	TARGET_PROT_DIN_STRIP = 4,
	TARGET_PROT_DOUT_STRIP = 8,
	TARGET_PROT_DIN_PASS = 16,
	TARGET_PROT_DOUT_PASS = 32,
};

enum target_prot_type {
	TARGET_DIF_TYPE0_PROT = 0,
	TARGET_DIF_TYPE1_PROT = 1,
	TARGET_DIF_TYPE2_PROT = 2,
	TARGET_DIF_TYPE3_PROT = 3,
};

enum target_ua_intlck_ctrl {
	TARGET_UA_INTLCK_CTRL_CLEAR = 0,
	TARGET_UA_INTLCK_CTRL_NO_CLEAR = 1,
	TARGET_UA_INTLCK_CTRL_ESTABLISH_UA = 2,
};

enum task_attribute {
	TASK_ATTR_SIMPLE = 0,
	TASK_ATTR_HOQ = 1,
	TASK_ATTR_ORDERED = 2,
	TASK_ATTR_ACA = 4,
};

enum task_disposition {
	TASK_IS_DONE = 0,
	TASK_IS_ABORTED = 1,
	TASK_IS_AT_LU = 2,
	TASK_IS_NOT_AT_LU = 3,
	TASK_ABORT_FAILED = 4,
};

enum task_work_notify_mode {
	TWA_NONE = 0,
	TWA_RESUME = 1,
	TWA_SIGNAL = 2,
	TWA_SIGNAL_NO_IPI = 3,
};

enum tc3589x_version {
	TC3589X_TC35890 = 0,
	TC3589X_TC35892 = 1,
	TC3589X_TC35893 = 2,
	TC3589X_TC35894 = 3,
	TC3589X_TC35895 = 4,
	TC3589X_TC35896 = 5,
	TC3589X_UNKNOWN = 6,
};

enum tc_fifo_command {
	TC_FIFO_REPLACE = 0,
	TC_FIFO_DESTROY = 1,
	TC_FIFO_STATS = 2,
};

enum tc_link_layer {
	TC_LINKLAYER_UNAWARE = 0,
	TC_LINKLAYER_ETHERNET = 1,
	TC_LINKLAYER_ATM = 2,
};

enum tc_mq_command {
	TC_MQ_CREATE = 0,
	TC_MQ_DESTROY = 1,
	TC_MQ_STATS = 2,
	TC_MQ_GRAFT = 3,
};

enum tc_root_command {
	TC_ROOT_GRAFT = 0,
};

enum tc_setup_type {
	TC_QUERY_CAPS = 0,
	TC_SETUP_QDISC_MQPRIO = 1,
	TC_SETUP_CLSU32 = 2,
	TC_SETUP_CLSFLOWER = 3,
	TC_SETUP_CLSMATCHALL = 4,
	TC_SETUP_CLSBPF = 5,
	TC_SETUP_BLOCK = 6,
	TC_SETUP_QDISC_CBS = 7,
	TC_SETUP_QDISC_RED = 8,
	TC_SETUP_QDISC_PRIO = 9,
	TC_SETUP_QDISC_MQ = 10,
	TC_SETUP_QDISC_ETF = 11,
	TC_SETUP_ROOT_QDISC = 12,
	TC_SETUP_QDISC_GRED = 13,
	TC_SETUP_QDISC_TAPRIO = 14,
	TC_SETUP_FT = 15,
	TC_SETUP_QDISC_ETS = 16,
	TC_SETUP_QDISC_TBF = 17,
	TC_SETUP_QDISC_FIFO = 18,
	TC_SETUP_QDISC_HTB = 19,
	TC_SETUP_ACT = 20,
};

enum tca_id {
	TCA_ID_UNSPEC = 0,
	TCA_ID_POLICE = 1,
	TCA_ID_GACT = 5,
	TCA_ID_IPT = 6,
	TCA_ID_PEDIT = 7,
	TCA_ID_MIRRED = 8,
	TCA_ID_NAT = 9,
	TCA_ID_XT = 10,
	TCA_ID_SKBEDIT = 11,
	TCA_ID_VLAN = 12,
	TCA_ID_BPF = 13,
	TCA_ID_CONNMARK = 14,
	TCA_ID_SKBMOD = 15,
	TCA_ID_CSUM = 16,
	TCA_ID_TUNNEL_KEY = 17,
	TCA_ID_SIMP = 22,
	TCA_ID_IFE = 25,
	TCA_ID_SAMPLE = 26,
	TCA_ID_CTINFO = 27,
	TCA_ID_MPLS = 28,
	TCA_ID_CT = 29,
	TCA_ID_GATE = 30,
	__TCA_ID_MAX = 255,
};

enum tcf_proto_ops_flags {
	TCF_PROTO_OPS_DOIT_UNLOCKED = 1,
};

enum tcp_ca_ack_event_flags {
	CA_ACK_SLOWPATH = 1,
	CA_ACK_WIN_UPDATE = 2,
	CA_ACK_ECE = 4,
};

enum tcp_ca_event {
	CA_EVENT_TX_START = 0,
	CA_EVENT_CWND_RESTART = 1,
	CA_EVENT_COMPLETE_CWR = 2,
	CA_EVENT_LOSS = 3,
	CA_EVENT_ECN_NO_CE = 4,
	CA_EVENT_ECN_IS_CE = 5,
};

enum tcp_ca_state {
	TCP_CA_Open = 0,
	TCP_CA_Disorder = 1,
	TCP_CA_CWR = 2,
	TCP_CA_Recovery = 3,
	TCP_CA_Loss = 4,
};

enum tcp_chrono {
	TCP_CHRONO_UNSPEC = 0,
	TCP_CHRONO_BUSY = 1,
	TCP_CHRONO_RWND_LIMITED = 2,
	TCP_CHRONO_SNDBUF_LIMITED = 3,
	__TCP_CHRONO_MAX = 4,
};

enum tcp_conntrack {
	TCP_CONNTRACK_NONE = 0,
	TCP_CONNTRACK_SYN_SENT = 1,
	TCP_CONNTRACK_SYN_RECV = 2,
	TCP_CONNTRACK_ESTABLISHED = 3,
	TCP_CONNTRACK_FIN_WAIT = 4,
	TCP_CONNTRACK_CLOSE_WAIT = 5,
	TCP_CONNTRACK_LAST_ACK = 6,
	TCP_CONNTRACK_TIME_WAIT = 7,
	TCP_CONNTRACK_CLOSE = 8,
	TCP_CONNTRACK_LISTEN = 9,
	TCP_CONNTRACK_MAX = 10,
	TCP_CONNTRACK_IGNORE = 11,
	TCP_CONNTRACK_RETRANS = 12,
	TCP_CONNTRACK_UNACK = 13,
	TCP_CONNTRACK_TIMEOUT_MAX = 14,
};

enum tcp_fastopen_client_fail {
	TFO_STATUS_UNSPEC = 0,
	TFO_COOKIE_UNAVAILABLE = 1,
	TFO_DATA_NOT_ACKED = 2,
	TFO_SYN_RETRANSMITTED = 3,
};

enum tcp_metric_index {
	TCP_METRIC_RTT = 0,
	TCP_METRIC_RTTVAR = 1,
	TCP_METRIC_SSTHRESH = 2,
	TCP_METRIC_CWND = 3,
	TCP_METRIC_REORDERING = 4,
	TCP_METRIC_RTT_US = 5,
	TCP_METRIC_RTTVAR_US = 6,
	__TCP_METRIC_MAX = 7,
};

enum tcp_queue {
	TCP_FRAG_IN_WRITE_QUEUE = 0,
	TCP_FRAG_IN_RTX_QUEUE = 1,
};

enum tcp_seq_states {
	TCP_SEQ_STATE_LISTENING = 0,
	TCP_SEQ_STATE_ESTABLISHED = 1,
};

enum tcp_skb_cb_sacked_flags {
	TCPCB_SACKED_ACKED = 1,
	TCPCB_SACKED_RETRANS = 2,
	TCPCB_LOST = 4,
	TCPCB_TAGBITS = 7,
	TCPCB_REPAIRED = 16,
	TCPCB_EVER_RETRANS = 128,
	TCPCB_RETRANS = 146,
};

enum tcp_synack_type {
	TCP_SYNACK_NORMAL = 0,
	TCP_SYNACK_FASTOPEN = 1,
	TCP_SYNACK_COOKIE = 2,
};

enum tcp_tstorm_ooo {
	TCP_TSTORM_OOO_DROP_AND_PROC_ACK = 0,
	TCP_TSTORM_OOO_SEND_PURE_ACK = 1,
	TCP_TSTORM_OOO_SUPPORTED = 2,
	MAX_TCP_TSTORM_OOO = 3,
};

enum tcp_tw_status {
	TCP_TW_SUCCESS = 0,
	TCP_TW_RST = 1,
	TCP_TW_ACK = 2,
	TCP_TW_SYN = 3,
};

enum tcx_action_base {
	TCX_NEXT = -1,
	TCX_PASS = 0,
	TCX_DROP = 2,
	TCX_REDIRECT = 7,
};

enum tdm_framer_t {
	TDM_FRAMER_T1 = 0,
	TDM_FRAMER_E1 = 1,
};

enum tdm_mode_t {
	TDM_INTERNAL_LOOPBACK = 0,
	TDM_NORMAL = 1,
};

enum tg_state_flags {
	THROTL_TG_PENDING = 1,
	THROTL_TG_WAS_EMPTY = 2,
	THROTL_TG_CANCELING = 4,
};

enum thermal_device_mode {
	THERMAL_DEVICE_DISABLED = 0,
	THERMAL_DEVICE_ENABLED = 1,
};

enum thermal_genl_attr {
	THERMAL_GENL_ATTR_UNSPEC = 0,
	THERMAL_GENL_ATTR_TZ = 1,
	THERMAL_GENL_ATTR_TZ_ID = 2,
	THERMAL_GENL_ATTR_TZ_TEMP = 3,
	THERMAL_GENL_ATTR_TZ_TRIP = 4,
	THERMAL_GENL_ATTR_TZ_TRIP_ID = 5,
	THERMAL_GENL_ATTR_TZ_TRIP_TYPE = 6,
	THERMAL_GENL_ATTR_TZ_TRIP_TEMP = 7,
	THERMAL_GENL_ATTR_TZ_TRIP_HYST = 8,
	THERMAL_GENL_ATTR_TZ_MODE = 9,
	THERMAL_GENL_ATTR_TZ_NAME = 10,
	THERMAL_GENL_ATTR_TZ_CDEV_WEIGHT = 11,
	THERMAL_GENL_ATTR_TZ_GOV = 12,
	THERMAL_GENL_ATTR_TZ_GOV_NAME = 13,
	THERMAL_GENL_ATTR_CDEV = 14,
	THERMAL_GENL_ATTR_CDEV_ID = 15,
	THERMAL_GENL_ATTR_CDEV_CUR_STATE = 16,
	THERMAL_GENL_ATTR_CDEV_MAX_STATE = 17,
	THERMAL_GENL_ATTR_CDEV_NAME = 18,
	THERMAL_GENL_ATTR_GOV_NAME = 19,
	THERMAL_GENL_ATTR_CPU_CAPABILITY = 20,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_ID = 21,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_PERFORMANCE = 22,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_EFFICIENCY = 23,
	__THERMAL_GENL_ATTR_MAX = 24,
};

enum thermal_genl_cmd {
	THERMAL_GENL_CMD_UNSPEC = 0,
	THERMAL_GENL_CMD_TZ_GET_ID = 1,
	THERMAL_GENL_CMD_TZ_GET_TRIP = 2,
	THERMAL_GENL_CMD_TZ_GET_TEMP = 3,
	THERMAL_GENL_CMD_TZ_GET_GOV = 4,
	THERMAL_GENL_CMD_TZ_GET_MODE = 5,
	THERMAL_GENL_CMD_CDEV_GET = 6,
	__THERMAL_GENL_CMD_MAX = 7,
};

enum thermal_genl_event {
	THERMAL_GENL_EVENT_UNSPEC = 0,
	THERMAL_GENL_EVENT_TZ_CREATE = 1,
	THERMAL_GENL_EVENT_TZ_DELETE = 2,
	THERMAL_GENL_EVENT_TZ_DISABLE = 3,
	THERMAL_GENL_EVENT_TZ_ENABLE = 4,
	THERMAL_GENL_EVENT_TZ_TRIP_UP = 5,
	THERMAL_GENL_EVENT_TZ_TRIP_DOWN = 6,
	THERMAL_GENL_EVENT_TZ_TRIP_CHANGE = 7,
	THERMAL_GENL_EVENT_TZ_TRIP_ADD = 8,
	THERMAL_GENL_EVENT_TZ_TRIP_DELETE = 9,
	THERMAL_GENL_EVENT_CDEV_ADD = 10,
	THERMAL_GENL_EVENT_CDEV_DELETE = 11,
	THERMAL_GENL_EVENT_CDEV_STATE_UPDATE = 12,
	THERMAL_GENL_EVENT_TZ_GOV_CHANGE = 13,
	THERMAL_GENL_EVENT_CPU_CAPABILITY_CHANGE = 14,
	__THERMAL_GENL_EVENT_MAX = 15,
};

enum thermal_genl_multicast_groups {
	THERMAL_GENL_SAMPLING_GROUP = 0,
	THERMAL_GENL_EVENT_GROUP = 1,
	THERMAL_GENL_MAX_GROUP = 1,
};

enum thermal_genl_sampling {
	THERMAL_GENL_SAMPLING_TEMP = 0,
	__THERMAL_GENL_SAMPLING_MAX = 1,
};

enum thermal_notify_event {
	THERMAL_EVENT_UNSPECIFIED = 0,
	THERMAL_EVENT_TEMP_SAMPLE = 1,
	THERMAL_TRIP_VIOLATED = 2,
	THERMAL_TRIP_CHANGED = 3,
	THERMAL_DEVICE_DOWN = 4,
	THERMAL_DEVICE_UP = 5,
	THERMAL_DEVICE_POWER_CAPABILITY_CHANGED = 6,
	THERMAL_TABLE_CHANGED = 7,
	THERMAL_EVENT_KEEP_ALIVE = 8,
	THERMAL_TZ_BIND_CDEV = 9,
	THERMAL_TZ_UNBIND_CDEV = 10,
	THERMAL_INSTANCE_WEIGHT_CHANGED = 11,
};

enum thermal_trend {
	THERMAL_TREND_STABLE = 0,
	THERMAL_TREND_RAISING = 1,
	THERMAL_TREND_DROPPING = 2,
};

enum thermal_trip_type {
	THERMAL_TRIP_ACTIVE = 0,
	THERMAL_TRIP_PASSIVE = 1,
	THERMAL_TRIP_HOT = 2,
	THERMAL_TRIP_CRITICAL = 3,
};

enum throttle_reason_type {
	NO_THROTTLE = 0,
	POWERCAP = 1,
	CPU_OVERTEMP = 2,
	POWER_SUPPLY_FAILURE = 3,
	OVERCURRENT = 4,
	OCC_RESET_THROTTLE = 5,
	OCC_MAX_REASON = 6,
};

enum tick_broadcast_mode {
	TICK_BROADCAST_OFF = 0,
	TICK_BROADCAST_ON = 1,
	TICK_BROADCAST_FORCE = 2,
};

enum tick_broadcast_state {
	TICK_BROADCAST_EXIT = 0,
	TICK_BROADCAST_ENTER = 1,
};

enum tick_dep_bits {
	TICK_DEP_BIT_POSIX_TIMER = 0,
	TICK_DEP_BIT_PERF_EVENTS = 1,
	TICK_DEP_BIT_SCHED = 2,
	TICK_DEP_BIT_CLOCK_UNSTABLE = 3,
	TICK_DEP_BIT_RCU = 4,
	TICK_DEP_BIT_RCU_EXP = 5,
};

enum tick_device_mode {
	TICKDEV_MODE_PERIODIC = 0,
	TICKDEV_MODE_ONESHOT = 1,
};

enum timekeeping_adv_mode {
	TK_ADV_TICK = 0,
	TK_ADV_FREQ = 1,
};

enum timespec_type {
	TT_NONE = 0,
	TT_NATIVE = 1,
	TT_COMPAT = 2,
};

enum tk_offsets {
	TK_OFFS_REAL = 0,
	TK_OFFS_BOOT = 1,
	TK_OFFS_TAI = 2,
	TK_OFFS_MAX = 3,
};

enum tlb_flush_reason {
	TLB_FLUSH_ON_TASK_SWITCH = 0,
	TLB_REMOTE_SHOOTDOWN = 1,
	TLB_LOCAL_SHOOTDOWN = 2,
	TLB_LOCAL_MM_SHOOTDOWN = 3,
	TLB_REMOTE_SEND_IPI = 4,
	NR_TLB_FLUSH_REASONS = 5,
};

enum tlb_flush_type {
	FLUSH_TYPE_NONE___2 = 0,
	FLUSH_TYPE_LOCAL = 1,
	FLUSH_TYPE_GLOBAL = 2,
};

enum tls_offload_ctx_dir {
	TLS_OFFLOAD_CTX_DIR_RX = 0,
	TLS_OFFLOAD_CTX_DIR_TX = 1,
};

enum tokens {
	TOKEN_NVRAM = 0,
	TOKEN_SYNC = 1,
	TOKEN_WIDE = 2,
	TOKEN_PPR = 3,
	TOKEN_VERBOSE = 4,
	TOKEN_DEBUG = 5,
};

enum tp_func_state {
	TP_FUNC_0 = 0,
	TP_FUNC_1 = 1,
	TP_FUNC_2 = 2,
	TP_FUNC_N = 3,
};

enum tp_transition_sync {
	TP_TRANSITION_SYNC_1_0_1 = 0,
	TP_TRANSITION_SYNC_N_2_1 = 1,
	_NR_TP_TRANSITION_SYNC = 2,
};

enum tpacket_versions {
	TPACKET_V1 = 0,
	TPACKET_V2 = 1,
	TPACKET_V3 = 2,
};

enum tps65090_cells {
	PMIC = 0,
	CHARGER = 1,
};

enum tps65917_irqs {
	TPS65917_RESERVED1 = 0,
	TPS65917_PWRON_IRQ = 1,
	TPS65917_LONG_PRESS_KEY_IRQ = 2,
	TPS65917_RESERVED2 = 3,
	TPS65917_PWRDOWN_IRQ = 4,
	TPS65917_HOTDIE_IRQ = 5,
	TPS65917_VSYS_MON_IRQ = 6,
	TPS65917_RESERVED3 = 7,
	TPS65917_RESERVED4 = 8,
	TPS65917_OTP_ERROR_IRQ = 9,
	TPS65917_WDT_IRQ = 10,
	TPS65917_RESERVED5 = 11,
	TPS65917_RESET_IN_IRQ = 12,
	TPS65917_FSD_IRQ = 13,
	TPS65917_SHORT_IRQ = 14,
	TPS65917_RESERVED6 = 15,
	TPS65917_GPADC_AUTO_0_IRQ = 16,
	TPS65917_GPADC_AUTO_1_IRQ = 17,
	TPS65917_GPADC_EOC_SW_IRQ = 18,
	TPS65917_RESREVED6 = 19,
	TPS65917_RESERVED7 = 20,
	TPS65917_RESERVED8 = 21,
	TPS65917_RESERVED9 = 22,
	TPS65917_VBUS_IRQ = 23,
	TPS65917_GPIO_0_IRQ = 24,
	TPS65917_GPIO_1_IRQ = 25,
	TPS65917_GPIO_2_IRQ = 26,
	TPS65917_GPIO_3_IRQ = 27,
	TPS65917_GPIO_4_IRQ = 28,
	TPS65917_GPIO_5_IRQ = 29,
	TPS65917_GPIO_6_IRQ = 30,
	TPS65917_RESERVED10 = 31,
	TPS65917_NUM_IRQ = 32,
};

enum trace_flag_type {
	TRACE_FLAG_IRQS_OFF = 1,
	TRACE_FLAG_IRQS_NOSUPPORT = 2,
	TRACE_FLAG_NEED_RESCHED = 4,
	TRACE_FLAG_HARDIRQ = 8,
	TRACE_FLAG_SOFTIRQ = 16,
	TRACE_FLAG_PREEMPT_RESCHED = 32,
	TRACE_FLAG_NMI = 64,
	TRACE_FLAG_BH_OFF = 128,
};

enum trace_flags {
	TRC_NEW_CMD = 1,
	TRC_DO_WORK = 2,
	TRC_DO_WORK_ERR = 4,
	TRC_XFR_RDY = 8,
	TRC_XMIT_DATA = 16,
	TRC_XMIT_STATUS = 32,
	TRC_SRR_RSP = 64,
	TRC_SRR_XRDY = 128,
	TRC_SRR_TERM = 256,
	TRC_SRR_CTIO = 512,
	TRC_FLUSH = 1024,
	TRC_CTIO_ERR = 2048,
	TRC_CTIO_DONE = 4096,
	TRC_CTIO_ABORTED = 8192,
	TRC_CTIO_STRANGE = 16384,
	TRC_CMD_DONE = 32768,
	TRC_CMD_CHK_STOP = 65536,
	TRC_CMD_FREE = 131072,
	TRC_DATA_IN = 262144,
	TRC_ABORT = 524288,
	TRC_DIF_ERR = 1048576,
};

enum trace_iter_flags {
	TRACE_FILE_LAT_FMT = 1,
	TRACE_FILE_ANNOTATE = 2,
	TRACE_FILE_TIME_IN_NS = 4,
};

enum trace_iterator_bits {
	TRACE_ITER_PRINT_PARENT_BIT = 0,
	TRACE_ITER_SYM_OFFSET_BIT = 1,
	TRACE_ITER_SYM_ADDR_BIT = 2,
	TRACE_ITER_VERBOSE_BIT = 3,
	TRACE_ITER_RAW_BIT = 4,
	TRACE_ITER_HEX_BIT = 5,
	TRACE_ITER_BIN_BIT = 6,
	TRACE_ITER_BLOCK_BIT = 7,
	TRACE_ITER_FIELDS_BIT = 8,
	TRACE_ITER_PRINTK_BIT = 9,
	TRACE_ITER_ANNOTATE_BIT = 10,
	TRACE_ITER_USERSTACKTRACE_BIT = 11,
	TRACE_ITER_SYM_USEROBJ_BIT = 12,
	TRACE_ITER_PRINTK_MSGONLY_BIT = 13,
	TRACE_ITER_CONTEXT_INFO_BIT = 14,
	TRACE_ITER_LATENCY_FMT_BIT = 15,
	TRACE_ITER_RECORD_CMD_BIT = 16,
	TRACE_ITER_RECORD_TGID_BIT = 17,
	TRACE_ITER_OVERWRITE_BIT = 18,
	TRACE_ITER_STOP_ON_FREE_BIT = 19,
	TRACE_ITER_IRQ_INFO_BIT = 20,
	TRACE_ITER_MARKERS_BIT = 21,
	TRACE_ITER_EVENT_FORK_BIT = 22,
	TRACE_ITER_PAUSE_ON_TRACE_BIT = 23,
	TRACE_ITER_HASH_PTR_BIT = 24,
	TRACE_ITER_FUNCTION_BIT = 25,
	TRACE_ITER_FUNC_FORK_BIT = 26,
	TRACE_ITER_DISPLAY_GRAPH_BIT = 27,
	TRACE_ITER_STACKTRACE_BIT = 28,
	TRACE_ITER_LAST_BIT = 29,
};

enum trace_iterator_flags {
	TRACE_ITER_PRINT_PARENT = 1,
	TRACE_ITER_SYM_OFFSET = 2,
	TRACE_ITER_SYM_ADDR = 4,
	TRACE_ITER_VERBOSE = 8,
	TRACE_ITER_RAW = 16,
	TRACE_ITER_HEX = 32,
	TRACE_ITER_BIN = 64,
	TRACE_ITER_BLOCK = 128,
	TRACE_ITER_FIELDS = 256,
	TRACE_ITER_PRINTK = 512,
	TRACE_ITER_ANNOTATE = 1024,
	TRACE_ITER_USERSTACKTRACE = 2048,
	TRACE_ITER_SYM_USEROBJ = 4096,
	TRACE_ITER_PRINTK_MSGONLY = 8192,
	TRACE_ITER_CONTEXT_INFO = 16384,
	TRACE_ITER_LATENCY_FMT = 32768,
	TRACE_ITER_RECORD_CMD = 65536,
	TRACE_ITER_RECORD_TGID = 131072,
	TRACE_ITER_OVERWRITE = 262144,
	TRACE_ITER_STOP_ON_FREE = 524288,
	TRACE_ITER_IRQ_INFO = 1048576,
	TRACE_ITER_MARKERS = 2097152,
	TRACE_ITER_EVENT_FORK = 4194304,
	TRACE_ITER_PAUSE_ON_TRACE = 8388608,
	TRACE_ITER_HASH_PTR = 16777216,
	TRACE_ITER_FUNCTION = 33554432,
	TRACE_ITER_FUNC_FORK = 67108864,
	TRACE_ITER_DISPLAY_GRAPH = 134217728,
	TRACE_ITER_STACKTRACE = 268435456,
};

enum trace_reg {
	TRACE_REG_REGISTER = 0,
	TRACE_REG_UNREGISTER = 1,
	TRACE_REG_PERF_REGISTER = 2,
	TRACE_REG_PERF_UNREGISTER = 3,
	TRACE_REG_PERF_OPEN = 4,
	TRACE_REG_PERF_CLOSE = 5,
	TRACE_REG_PERF_ADD = 6,
	TRACE_REG_PERF_DEL = 7,
};

enum trace_type {
	__TRACE_FIRST_TYPE = 0,
	TRACE_FN = 1,
	TRACE_CTX = 2,
	TRACE_WAKE = 3,
	TRACE_STACK = 4,
	TRACE_PRINT = 5,
	TRACE_BPRINT = 6,
	TRACE_MMIO_RW = 7,
	TRACE_MMIO_MAP = 8,
	TRACE_BRANCH = 9,
	TRACE_GRAPH_RET = 10,
	TRACE_GRAPH_ENT = 11,
	TRACE_USER_STACK = 12,
	TRACE_BLK = 13,
	TRACE_BPUTS = 14,
	TRACE_HWLAT = 15,
	TRACE_OSNOISE = 16,
	TRACE_TIMERLAT = 17,
	TRACE_RAW_DATA = 18,
	TRACE_FUNC_REPEATS = 19,
	__TRACE_LAST_TYPE = 20,
};

enum track_item {
	TRACK_ALLOC = 0,
	TRACK_FREE = 1,
};

enum transact_state {
	TransactionUninitialized = 0,
	TransactionActive = 1,
	TransactionPrepared = 2,
	TransactionCommitted = 3,
};

enum transaction_flags {
	TF_ONE_WAY = 1,
	TF_ROOT_OBJECT = 4,
	TF_STATUS_CODE = 8,
	TF_ACCEPT_FDS = 16,
	TF_CLEAR_BUF = 32,
	TF_UPDATE_TXN = 64,
};

enum translation_map {
	LAT1_MAP = 0,
	GRAF_MAP = 1,
	IBMPC_MAP = 2,
	USER_MAP = 3,
	FIRST_MAP = 0,
	LAST_MAP = 3,
};

enum transparent_hugepage_flag {
	TRANSPARENT_HUGEPAGE_UNSUPPORTED = 0,
	TRANSPARENT_HUGEPAGE_FLAG = 1,
	TRANSPARENT_HUGEPAGE_REQ_MADV_FLAG = 2,
	TRANSPARENT_HUGEPAGE_DEFRAG_DIRECT_FLAG = 3,
	TRANSPARENT_HUGEPAGE_DEFRAG_KSWAPD_FLAG = 4,
	TRANSPARENT_HUGEPAGE_DEFRAG_KSWAPD_OR_MADV_FLAG = 5,
	TRANSPARENT_HUGEPAGE_DEFRAG_REQ_MADV_FLAG = 6,
	TRANSPARENT_HUGEPAGE_DEFRAG_KHUGEPAGED_FLAG = 7,
	TRANSPARENT_HUGEPAGE_USE_ZERO_PAGE_FLAG = 8,
};

enum transport_state_table {
	TRANSPORT_NO_STATE = 0,
	TRANSPORT_NEW_CMD = 1,
	TRANSPORT_WRITE_PENDING = 3,
	TRANSPORT_PROCESSING = 5,
	TRANSPORT_COMPLETE = 6,
	TRANSPORT_ISTATE_PROCESSING = 11,
	TRANSPORT_COMPLETE_QF_WP = 18,
	TRANSPORT_COMPLETE_QF_OK = 19,
	TRANSPORT_COMPLETE_QF_ERR = 20,
};

enum tsq_enum {
	TSQ_THROTTLED = 0,
	TSQ_QUEUED = 1,
	TCP_TSQ_DEFERRED = 2,
	TCP_WRITE_TIMER_DEFERRED = 3,
	TCP_DELACK_TIMER_DEFERRED = 4,
	TCP_MTU_REDUCED_DEFERRED = 5,
	TCP_ACK_DEFERRED = 6,
};

enum tsq_flags {
	TSQF_THROTTLED = 1,
	TSQF_QUEUED = 2,
	TCPF_TSQ_DEFERRED = 4,
	TCPF_WRITE_TIMER_DEFERRED = 8,
	TCPF_DELACK_TIMER_DEFERRED = 16,
	TCPF_MTU_REDUCED_DEFERRED = 32,
	TCPF_ACK_DEFERRED = 64,
};

enum ttu_flags {
	TTU_SPLIT_HUGE_PMD = 4,
	TTU_IGNORE_MLOCK = 8,
	TTU_SYNC = 16,
	TTU_HWPOISON = 32,
	TTU_BATCH_FLUSH = 64,
	TTU_RMAP_LOCKED = 128,
};

enum tty_flow_change {
	TTY_FLOW_NO_CHANGE = 0,
	TTY_THROTTLE_SAFE = 1,
	TTY_UNTHROTTLE_SAFE = 2,
};

enum tunable_id {
	ETHTOOL_ID_UNSPEC = 0,
	ETHTOOL_RX_COPYBREAK = 1,
	ETHTOOL_TX_COPYBREAK = 2,
	ETHTOOL_PFC_PREVENTION_TOUT = 3,
	ETHTOOL_TX_COPYBREAK_BUF_SIZE = 4,
	__ETHTOOL_TUNABLE_COUNT = 5,
};

enum tunable_type_id {
	ETHTOOL_TUNABLE_UNSPEC = 0,
	ETHTOOL_TUNABLE_U8 = 1,
	ETHTOOL_TUNABLE_U16 = 2,
	ETHTOOL_TUNABLE_U32 = 3,
	ETHTOOL_TUNABLE_U64 = 4,
	ETHTOOL_TUNABLE_STRING = 5,
	ETHTOOL_TUNABLE_S8 = 6,
	ETHTOOL_TUNABLE_S16 = 7,
	ETHTOOL_TUNABLE_S32 = 8,
	ETHTOOL_TUNABLE_S64 = 9,
};

enum twl4030_audio_res {
	TWL4030_AUDIO_RES_POWER = 0,
	TWL4030_AUDIO_RES_APLL = 1,
	TWL4030_AUDIO_RES_MAX = 2,
};

enum twl4030_module_ids {
	TWL4030_MODULE_AUDIO_VOICE = 9,
	TWL4030_MODULE_GPIO = 10,
	TWL4030_MODULE_INTBR = 11,
	TWL4030_MODULE_TEST = 12,
	TWL4030_MODULE_KEYPAD = 13,
	TWL4030_MODULE_MADC = 14,
	TWL4030_MODULE_INTERRUPTS = 15,
	TWL4030_MODULE_PRECHARGE = 16,
	TWL4030_MODULE_BACKUP = 17,
	TWL4030_MODULE_INT = 18,
	TWL5031_MODULE_ACCESSORY = 19,
	TWL5031_MODULE_INTERRUPTS = 20,
	TWL4030_MODULE_LAST = 21,
};

enum twl6030_module_ids {
	TWL6030_MODULE_ID0 = 9,
	TWL6030_MODULE_ID1 = 10,
	TWL6030_MODULE_ID2 = 11,
	TWL6030_MODULE_GPADC = 12,
	TWL6030_MODULE_GASGAUGE = 13,
	TWL6032_MODULE_CHARGE = 14,
	TWL6030_MODULE_LAST = 15,
};

enum twl_module_ids {
	TWL_MODULE_USB = 0,
	TWL_MODULE_PIH = 1,
	TWL_MODULE_MAIN_CHARGE = 2,
	TWL_MODULE_PM_MASTER = 3,
	TWL_MODULE_PM_RECEIVER = 4,
	TWL_MODULE_RTC = 5,
	TWL_MODULE_PWM = 6,
	TWL_MODULE_LED = 7,
	TWL_MODULE_SECURED_REG = 8,
	TWL_MODULE_LAST = 9,
};

enum tx3589x_block {
	TC3589x_BLOCK_GPIO = 1,
	TC3589x_BLOCK_KEYPAD = 2,
};

enum txtime_flags {
	SOF_TXTIME_DEADLINE_MODE = 1,
	SOF_TXTIME_REPORT_ERRORS = 2,
	SOF_TXTIME_FLAGS_LAST = 2,
	SOF_TXTIME_FLAGS_MASK = 3,
};

enum uart_pm_state {
	UART_PM_STATE_ON = 0,
	UART_PM_STATE_OFF = 3,
	UART_PM_STATE_UNDEFINED = 4,
};

enum ucc_fast_channel_protocol_mode {
	UCC_FAST_PROTOCOL_MODE_HDLC = 0,
	UCC_FAST_PROTOCOL_MODE_RESERVED01 = 1,
	UCC_FAST_PROTOCOL_MODE_RESERVED_QMC = 2,
	UCC_FAST_PROTOCOL_MODE_RESERVED02 = 3,
	UCC_FAST_PROTOCOL_MODE_RESERVED_UART = 4,
	UCC_FAST_PROTOCOL_MODE_RESERVED03 = 5,
	UCC_FAST_PROTOCOL_MODE_RESERVED_EX_MAC_1 = 6,
	UCC_FAST_PROTOCOL_MODE_RESERVED_EX_MAC_2 = 7,
	UCC_FAST_PROTOCOL_MODE_RESERVED_BISYNC = 8,
	UCC_FAST_PROTOCOL_MODE_RESERVED04 = 9,
	UCC_FAST_PROTOCOL_MODE_ATM = 10,
	UCC_FAST_PROTOCOL_MODE_RESERVED05 = 11,
	UCC_FAST_PROTOCOL_MODE_ETHERNET = 12,
	UCC_FAST_PROTOCOL_MODE_RESERVED06 = 13,
	UCC_FAST_PROTOCOL_MODE_POS = 14,
	UCC_FAST_PROTOCOL_MODE_RESERVED07 = 15,
};

enum ucc_fast_rx_decoding_method {
	UCC_FAST_RX_ENCODING_NRZ = 0,
	UCC_FAST_RX_ENCODING_NRZI = 2048,
	UCC_FAST_RX_ENCODING_RESERVED0 = 4096,
	UCC_FAST_RX_ENCODING_RESERVED1 = 6144,
};

enum ucc_fast_sync_len {
	UCC_FAST_SYNC_LEN_NOT_USED = 0,
	UCC_FAST_SYNC_LEN_AUTOMATIC = 16384,
	UCC_FAST_SYNC_LEN_8_BIT = 32768,
	UCC_FAST_SYNC_LEN_16_BIT = 49152,
};

enum ucc_fast_transparent_tcrc {
	UCC_FAST_16_BIT_CRC = 0,
	UCC_FAST_CRC_RESERVED0 = 64,
	UCC_FAST_32_BIT_CRC = 128,
	UCC_FAST_CRC_RESERVED1 = 192,
};

enum ucc_fast_transparent_txrx {
	UCC_FAST_GUMR_TRANSPARENT_TTX_TRX_NORMAL = 0,
	UCC_FAST_GUMR_TRANSPARENT_TTX_TRX_TRANSPARENT = 402653184,
};

enum ucc_fast_tx_encoding_method {
	UCC_FAST_TX_ENCODING_NRZ = 0,
	UCC_FAST_TX_ENCODING_NRZI = 256,
	UCC_FAST_TX_ENCODING_RESERVED0 = 512,
	UCC_FAST_TX_ENCODING_RESERVED1 = 768,
};

enum ucc_slow_channel_protocol_mode {
	UCC_SLOW_CHANNEL_PROTOCOL_MODE_QMC = 2,
	UCC_SLOW_CHANNEL_PROTOCOL_MODE_UART = 4,
	UCC_SLOW_CHANNEL_PROTOCOL_MODE_BISYNC = 8,
};

enum ucc_slow_diag_mode {
	UCC_SLOW_DIAG_MODE_NORMAL = 0,
	UCC_SLOW_DIAG_MODE_LOOPBACK = 64,
	UCC_SLOW_DIAG_MODE_ECHO = 128,
	UCC_SLOW_DIAG_MODE_LOOPBACK_ECHO = 192,
};

enum ucc_slow_rx_decoding_method {
	UCC_SLOW_RECEIVER_DECODING_METHOD_RENC_NRZ = 0,
	UCC_SLOW_RECEIVER_DECODING_METHOD_RENC_NRZI = 2048,
};

enum ucc_slow_rx_oversampling_rate {
	UCC_SLOW_OVERSAMPLING_RATE_RX_RDCR_1 = 0,
	UCC_SLOW_OVERSAMPLING_RATE_RX_RDCR_8 = 16384,
	UCC_SLOW_OVERSAMPLING_RATE_RX_RDCR_16 = 32768,
	UCC_SLOW_OVERSAMPLING_RATE_RX_RDCR_32 = 49152,
};

enum ucc_slow_transparent_tcrc {
	UCC_SLOW_TRANSPARENT_TCRC_CCITT_CRC16 = 0,
	UCC_SLOW_TRANSPARENT_TCRC_CRC16 = 16384,
	UCC_SLOW_TRANSPARENT_TCRC_CCITT_CRC32 = 32768,
};

enum ucc_slow_tx_encoding_method {
	UCC_SLOW_TRANSMITTER_ENCODING_METHOD_TENC_NRZ = 0,
	UCC_SLOW_TRANSMITTER_ENCODING_METHOD_TENC_NRZI = 256,
};

enum ucc_slow_tx_oversampling_rate {
	UCC_SLOW_OVERSAMPLING_RATE_TX_TDCR_1 = 0,
	UCC_SLOW_OVERSAMPLING_RATE_TX_TDCR_8 = 65536,
	UCC_SLOW_OVERSAMPLING_RATE_TX_TDCR_16 = 131072,
	UCC_SLOW_OVERSAMPLING_RATE_TX_TDCR_32 = 196608,
};

enum ucc_speed_type {
	UCC_SPEED_TYPE_FAST = 3,
	UCC_SPEED_TYPE_SLOW = 0,
};

enum uclamp_id {
	UCLAMP_MIN = 0,
	UCLAMP_MAX = 1,
	UCLAMP_CNT = 2,
};

enum ucount_type {
	UCOUNT_USER_NAMESPACES = 0,
	UCOUNT_PID_NAMESPACES = 1,
	UCOUNT_UTS_NAMESPACES = 2,
	UCOUNT_IPC_NAMESPACES = 3,
	UCOUNT_NET_NAMESPACES = 4,
	UCOUNT_MNT_NAMESPACES = 5,
	UCOUNT_CGROUP_NAMESPACES = 6,
	UCOUNT_TIME_NAMESPACES = 7,
	UCOUNT_INOTIFY_INSTANCES = 8,
	UCOUNT_INOTIFY_WATCHES = 9,
	UCOUNT_FANOTIFY_GROUPS = 10,
	UCOUNT_FANOTIFY_MARKS = 11,
	UCOUNT_COUNTS = 12,
};

enum udp_conntrack {
	UDP_CT_UNREPLIED = 0,
	UDP_CT_REPLIED = 1,
	UDP_CT_MAX = 2,
};

enum udp_parsable_tunnel_type {
	UDP_TUNNEL_TYPE_VXLAN = 1,
	UDP_TUNNEL_TYPE_GENEVE = 2,
	UDP_TUNNEL_TYPE_VXLAN_GPE = 4,
};

enum udp_tunnel_nic_info_flags {
	UDP_TUNNEL_NIC_INFO_MAY_SLEEP = 1,
	UDP_TUNNEL_NIC_INFO_OPEN_ONLY = 2,
	UDP_TUNNEL_NIC_INFO_IPV4_ONLY = 4,
	UDP_TUNNEL_NIC_INFO_STATIC_IANA_VXLAN = 8,
};

enum ufs_bsg_msg_code {
	UPIU_TRANSACTION_UIC_CMD = 31,
	UPIU_TRANSACTION_ARPMB_CMD = 32,
};

enum ufs_crypto_alg {
	UFS_CRYPTO_ALG_AES_XTS = 0,
	UFS_CRYPTO_ALG_BITLOCKER_AES_CBC = 1,
	UFS_CRYPTO_ALG_AES_ECB = 2,
	UFS_CRYPTO_ALG_ESSIV_AES_CBC = 3,
};

enum ufs_crypto_key_size {
	UFS_CRYPTO_KEY_SIZE_INVALID = 0,
	UFS_CRYPTO_KEY_SIZE_128 = 1,
	UFS_CRYPTO_KEY_SIZE_192 = 2,
	UFS_CRYPTO_KEY_SIZE_256 = 3,
	UFS_CRYPTO_KEY_SIZE_512 = 4,
};

enum ufs_dev_pwr_mode {
	UFS_ACTIVE_PWR_MODE = 1,
	UFS_SLEEP_PWR_MODE = 2,
	UFS_POWERDOWN_PWR_MODE = 3,
	UFS_DEEPSLEEP_PWR_MODE = 4,
};

enum ufs_event_type {
	UFS_EVT_PA_ERR = 0,
	UFS_EVT_DL_ERR = 1,
	UFS_EVT_NL_ERR = 2,
	UFS_EVT_TL_ERR = 3,
	UFS_EVT_DME_ERR = 4,
	UFS_EVT_AUTO_HIBERN8_ERR = 5,
	UFS_EVT_FATAL_ERR = 6,
	UFS_EVT_LINK_STARTUP_FAIL = 7,
	UFS_EVT_RESUME_ERR = 8,
	UFS_EVT_SUSPEND_ERR = 9,
	UFS_EVT_WL_SUSP_ERR = 10,
	UFS_EVT_WL_RES_ERR = 11,
	UFS_EVT_DEV_RESET = 12,
	UFS_EVT_HOST_RESET = 13,
	UFS_EVT_ABORT = 14,
	UFS_EVT_CNT = 15,
};

enum ufs_hs_gear_rate {
	PA_HS_MODE_A = 1,
	PA_HS_MODE_B = 2,
};

enum ufs_hs_gear_tag {
	UFS_HS_DONT_CHANGE = 0,
	UFS_HS_G1 = 1,
	UFS_HS_G2 = 2,
	UFS_HS_G3 = 3,
	UFS_HS_G4 = 4,
	UFS_HS_G5 = 5,
};

enum ufs_lanes {
	UFS_LANE_DONT_CHANGE = 0,
	UFS_LANE_1 = 1,
	UFS_LANE_2 = 2,
};

enum ufs_lu_wp_type {
	UFS_LU_NO_WP = 0,
	UFS_LU_POWER_ON_WP = 1,
	UFS_LU_PERM_WP = 2,
};

enum ufs_notify_change_status {
	PRE_CHANGE = 0,
	POST_CHANGE = 1,
};

enum ufs_pa_pwr_mode {
	FAST_MODE = 1,
	SLOW_MODE = 2,
	FASTAUTO_MODE = 4,
	SLOWAUTO_MODE = 5,
	UNCHANGED = 7,
};

enum ufs_pm_level {
	UFS_PM_LVL_0 = 0,
	UFS_PM_LVL_1 = 1,
	UFS_PM_LVL_2 = 2,
	UFS_PM_LVL_3 = 3,
	UFS_PM_LVL_4 = 4,
	UFS_PM_LVL_5 = 5,
	UFS_PM_LVL_6 = 6,
	UFS_PM_LVL_MAX = 7,
};

enum ufs_pm_op {
	UFS_RUNTIME_PM = 0,
	UFS_SYSTEM_PM = 1,
	UFS_SHUTDOWN_PM = 2,
};

enum ufs_pwm_gear_tag {
	UFS_PWM_DONT_CHANGE = 0,
	UFS_PWM_G1 = 1,
	UFS_PWM_G2 = 2,
	UFS_PWM_G3 = 3,
	UFS_PWM_G4 = 4,
	UFS_PWM_G5 = 5,
	UFS_PWM_G6 = 6,
	UFS_PWM_G7 = 7,
};

enum ufs_ref_clk_freq {
	REF_CLK_FREQ_19_2_MHZ = 0,
	REF_CLK_FREQ_26_MHZ = 1,
	REF_CLK_FREQ_38_4_MHZ = 2,
	REF_CLK_FREQ_52_MHZ = 3,
	REF_CLK_FREQ_INVAL = -1,
};

enum ufs_rpmb_op_type {
	UFS_RPMB_WRITE_KEY = 1,
	UFS_RPMB_READ_CNT = 2,
	UFS_RPMB_WRITE = 3,
	UFS_RPMB_READ = 4,
	UFS_RPMB_READ_RESP = 5,
	UFS_RPMB_SEC_CONF_WRITE = 6,
	UFS_RPMB_SEC_CONF_READ = 7,
	UFS_RPMB_PURGE_ENABLE = 8,
	UFS_RPMB_PURGE_STATUS_READ = 9,
};

enum ufs_rtc_time {
	UFS_RTC_RELATIVE = 0,
	UFS_RTC_ABSOLUTE = 1,
};

enum ufs_trace_str_t {
	UFS_CMD_SEND = 0,
	UFS_CMD_COMP = 1,
	UFS_DEV_COMP = 2,
	UFS_QUERY_SEND = 3,
	UFS_QUERY_COMP = 4,
	UFS_QUERY_ERR = 5,
	UFS_TM_SEND = 6,
	UFS_TM_COMP = 7,
	UFS_TM_ERR = 8,
};

enum ufs_trace_tsf_t {
	UFS_TSF_CDB = 0,
	UFS_TSF_OSF = 1,
	UFS_TSF_TM_INPUT = 2,
	UFS_TSF_TM_OUTPUT = 3,
};

enum ufshcd_caps {
	UFSHCD_CAP_CLK_GATING = 1,
	UFSHCD_CAP_HIBERN8_WITH_CLK_GATING = 2,
	UFSHCD_CAP_CLK_SCALING = 4,
	UFSHCD_CAP_AUTO_BKOPS_SUSPEND = 8,
	UFSHCD_CAP_INTR_AGGR = 16,
	UFSHCD_CAP_KEEP_AUTO_BKOPS_ENABLED_EXCEPT_SUSPEND = 32,
	UFSHCD_CAP_RPM_AUTOSUSPEND = 64,
	UFSHCD_CAP_WB_EN = 128,
	UFSHCD_CAP_CRYPTO = 256,
	UFSHCD_CAP_AGGR_POWER_COLLAPSE = 512,
	UFSHCD_CAP_DEEPSLEEP = 1024,
	UFSHCD_CAP_TEMP_NOTIF = 2048,
	UFSHCD_CAP_WB_WITH_CLK_SCALING = 4096,
};

enum ufshcd_mcq_opr {
	OPR_SQD = 0,
	OPR_SQIS = 1,
	OPR_CQD = 2,
	OPR_CQIS = 3,
	OPR_MAX = 4,
};

enum ufshcd_quirks {
	UFSHCD_QUIRK_BROKEN_INTR_AGGR = 1,
	UFSHCD_QUIRK_DELAY_BEFORE_DME_CMDS = 2,
	UFSHCD_QUIRK_BROKEN_LCC = 4,
	UFSHCD_QUIRK_BROKEN_PA_RXHSUNTERMCAP = 8,
	UFSHCD_QUIRK_DME_PEER_ACCESS_AUTO_MODE = 16,
	UFSHCD_QUIRK_BROKEN_UFS_HCI_VERSION = 32,
	UFSHCI_QUIRK_BROKEN_REQ_LIST_CLR = 64,
	UFSHCI_QUIRK_SKIP_RESET_INTR_AGGR = 128,
	UFSHCI_QUIRK_BROKEN_HCE = 256,
	UFSHCD_QUIRK_PRDT_BYTE_GRAN = 512,
	UFSHCD_QUIRK_BROKEN_OCS_FATAL_ERROR = 1024,
	UFSHCD_QUIRK_BROKEN_AUTO_HIBERN8 = 2048,
	UFSHCI_QUIRK_SKIP_MANUAL_WB_FLUSH_CTRL = 4096,
	UFSHCD_QUIRK_SKIP_DEF_UNIPRO_TIMEOUT_SETTING = 8192,
	UFSHCD_QUIRK_BROKEN_UIC_CMD = 32768,
	UFSHCD_QUIRK_SKIP_PH_CONFIGURATION = 65536,
	UFSHCD_QUIRK_BROKEN_64BIT_ADDRESS = 131072,
	UFSHCD_QUIRK_HIBERN_FASTAUTO = 262144,
	UFSHCD_QUIRK_REINIT_AFTER_MAX_GEAR_SWITCH = 524288,
	UFSHCD_QUIRK_MCQ_BROKEN_INTR = 1048576,
	UFSHCD_QUIRK_MCQ_BROKEN_RTC = 2097152,
};

enum ufshcd_res {
	RES_UFS = 0,
	RES_MCQ = 1,
	RES_MCQ_SQD = 2,
	RES_MCQ_SQIS = 3,
	RES_MCQ_CQD = 4,
	RES_MCQ_CQIS = 5,
	RES_MCQ_VS = 6,
	RES_MAX = 7,
};

enum ufshcd_state {
	UFSHCD_STATE_RESET = 0,
	UFSHCD_STATE_OPERATIONAL = 1,
	UFSHCD_STATE_EH_SCHEDULED_NON_FATAL = 2,
	UFSHCD_STATE_EH_SCHEDULED_FATAL = 3,
	UFSHCD_STATE_ERROR = 4,
};

enum uic_cmd_dme {
	UIC_CMD_DME_GET = 1,
	UIC_CMD_DME_SET = 2,
	UIC_CMD_DME_PEER_GET = 3,
	UIC_CMD_DME_PEER_SET = 4,
	UIC_CMD_DME_POWERON = 16,
	UIC_CMD_DME_POWEROFF = 17,
	UIC_CMD_DME_ENABLE = 18,
	UIC_CMD_DME_RESET = 20,
	UIC_CMD_DME_END_PT_RST = 21,
	UIC_CMD_DME_LINK_STARTUP = 22,
	UIC_CMD_DME_HIBER_ENTER = 23,
	UIC_CMD_DME_HIBER_EXIT = 24,
	UIC_CMD_DME_TEST_MODE = 26,
};

enum uic_link_state {
	UIC_LINK_OFF_STATE = 0,
	UIC_LINK_ACTIVE_STATE = 1,
	UIC_LINK_HIBERN8_STATE = 2,
	UIC_LINK_BROKEN_STATE = 3,
};

enum ulp_bde64_word3 {
	ULP_BDE64_SIZE_MASK = 16777215,
	ULP_BDE64_TYPE_SHIFT = 24,
	ULP_BDE64_TYPE_MASK = -16777216,
	ULP_BDE64_TYPE_BDE_64 = 0,
	ULP_BDE64_TYPE_BDE_IMMED = 16777216,
	ULP_BDE64_TYPE_BDE_64P = 33554432,
	ULP_BDE64_TYPE_BDE_64I = 134217728,
	ULP_BDE64_TYPE_BDE_64IP = 167772160,
	ULP_BDE64_TYPE_BLP_64 = 1073741824,
	ULP_BDE64_TYPE_BLP_64P = 1107296256,
};

enum umh_disable_depth {
	UMH_ENABLED = 0,
	UMH_FREEZING = 1,
	UMH_DISABLED = 2,
};

enum umount_tree_flags {
	UMOUNT_SYNC = 1,
	UMOUNT_PROPAGATE = 2,
	UMOUNT_CONNECTED = 4,
};

enum unit_desc_param {
	UNIT_DESC_PARAM_LEN = 0,
	UNIT_DESC_PARAM_TYPE = 1,
	UNIT_DESC_PARAM_UNIT_INDEX = 2,
	UNIT_DESC_PARAM_LU_ENABLE = 3,
	UNIT_DESC_PARAM_BOOT_LUN_ID = 4,
	UNIT_DESC_PARAM_LU_WR_PROTECT = 5,
	UNIT_DESC_PARAM_LU_Q_DEPTH = 6,
	UNIT_DESC_PARAM_PSA_SENSITIVE = 7,
	UNIT_DESC_PARAM_MEM_TYPE = 8,
	UNIT_DESC_PARAM_DATA_RELIABILITY = 9,
	UNIT_DESC_PARAM_LOGICAL_BLK_SIZE = 10,
	UNIT_DESC_PARAM_LOGICAL_BLK_COUNT = 11,
	UNIT_DESC_PARAM_ERASE_BLK_SIZE = 19,
	UNIT_DESC_PARAM_PROVISIONING_TYPE = 23,
	UNIT_DESC_PARAM_PHY_MEM_RSRC_CNT = 24,
	UNIT_DESC_PARAM_CTX_CAPABILITIES = 32,
	UNIT_DESC_PARAM_LARGE_UNIT_SIZE_M1 = 34,
	UNIT_DESC_PARAM_HPB_LU_MAX_ACTIVE_RGNS = 35,
	UNIT_DESC_PARAM_HPB_PIN_RGN_START_OFF = 37,
	UNIT_DESC_PARAM_HPB_NUM_PIN_RGNS = 39,
	UNIT_DESC_PARAM_WB_BUF_ALLOC_UNITS = 41,
};

enum unix_recv_queue_lock_class {
	U_RECVQ_LOCK_NORMAL = 0,
	U_RECVQ_LOCK_EMBRYO = 1,
};

enum unix_socket_lock_class {
	U_LOCK_NORMAL = 0,
	U_LOCK_SECOND = 1,
	U_LOCK_DIAG = 2,
	U_LOCK_GC_LISTENER = 3,
};

enum unix_vertex_index {
	UNIX_VERTEX_INDEX_MARK1 = 0,
	UNIX_VERTEX_INDEX_MARK2 = 1,
	UNIX_VERTEX_INDEX_START = 2,
};

enum upiu_request_transaction {
	UPIU_TRANSACTION_NOP_OUT = 0,
	UPIU_TRANSACTION_COMMAND = 1,
	UPIU_TRANSACTION_DATA_OUT = 2,
	UPIU_TRANSACTION_TASK_REQ = 4,
	UPIU_TRANSACTION_QUERY_REQ = 22,
};

enum upiu_response_transaction {
	UPIU_TRANSACTION_NOP_IN = 32,
	UPIU_TRANSACTION_RESPONSE = 33,
	UPIU_TRANSACTION_DATA_IN = 34,
	UPIU_TRANSACTION_TASK_RSP = 36,
	UPIU_TRANSACTION_READY_XFER = 49,
	UPIU_TRANSACTION_QUERY_RSP = 54,
	UPIU_TRANSACTION_REJECT_UPIU = 63,
};

enum uprobe_filter_ctx {
	UPROBE_FILTER_REGISTER = 0,
	UPROBE_FILTER_UNREGISTER = 1,
	UPROBE_FILTER_MMAP = 2,
};

enum uprobe_task_state {
	UTASK_RUNNING = 0,
	UTASK_SSTEP = 1,
	UTASK_SSTEP_ACK = 2,
	UTASK_SSTEP_TRAPPED = 3,
};

enum usb_charger_state {
	USB_CHARGER_DEFAULT = 0,
	USB_CHARGER_PRESENT = 1,
	USB_CHARGER_ABSENT = 2,
};

enum usb_charger_type {
	UNKNOWN_TYPE = 0,
	SDP_TYPE = 1,
	DCP_TYPE = 2,
	CDP_TYPE = 3,
	ACA_TYPE = 4,
};

enum usb_device_speed {
	USB_SPEED_UNKNOWN = 0,
	USB_SPEED_LOW = 1,
	USB_SPEED_FULL = 2,
	USB_SPEED_HIGH = 3,
	USB_SPEED_WIRELESS = 4,
	USB_SPEED_SUPER = 5,
	USB_SPEED_SUPER_PLUS = 6,
};

enum usb_phy_events {
	USB_EVENT_NONE = 0,
	USB_EVENT_VBUS = 1,
	USB_EVENT_ID = 2,
	USB_EVENT_CHARGER = 3,
	USB_EVENT_ENUMERATED = 4,
};

enum usb_phy_interface {
	USBPHY_INTERFACE_MODE_UNKNOWN = 0,
	USBPHY_INTERFACE_MODE_UTMI = 1,
	USBPHY_INTERFACE_MODE_UTMIW = 2,
	USBPHY_INTERFACE_MODE_ULPI = 3,
	USBPHY_INTERFACE_MODE_SERIAL = 4,
	USBPHY_INTERFACE_MODE_HSIC = 5,
};

enum usb_phy_type {
	USB_PHY_TYPE_UNDEFINED = 0,
	USB_PHY_TYPE_USB2 = 1,
	USB_PHY_TYPE_USB3 = 2,
};

enum user_reg_flag {
	USER_EVENT_REG_PERSIST = 1,
	USER_EVENT_REG_MULTI_FORMAT = 2,
	USER_EVENT_REG_MAX = 4,
};

enum utf16_endian {
	UTF16_HOST_ENDIAN = 0,
	UTF16_LITTLE_ENDIAN = 1,
	UTF16_BIG_ENDIAN = 2,
};

enum utf8_normalization {
	UTF8_NFDI = 0,
	UTF8_NFDICF = 1,
	UTF8_NMAX = 2,
};

enum utp_data_direction {
	UTP_NO_DATA_TRANSFER = 0,
	UTP_HOST_TO_DEVICE = 1,
	UTP_DEVICE_TO_HOST = 2,
};

enum utp_ocs {
	OCS_SUCCESS = 0,
	OCS_INVALID_CMD_TABLE_ATTR = 1,
	OCS_INVALID_PRDT_ATTR = 2,
	OCS_MISMATCH_DATA_BUF_SIZE = 3,
	OCS_MISMATCH_RESP_UPIU_SIZE = 4,
	OCS_PEER_COMM_FAILURE = 5,
	OCS_ABORTED = 6,
	OCS_FATAL_ERROR = 7,
	OCS_DEVICE_FATAL_ERROR = 8,
	OCS_INVALID_CRYPTO_CONFIG = 9,
	OCS_GENERAL_CRYPTO_ERROR = 10,
	OCS_INVALID_COMMAND_STATUS = 15,
};

enum uts_proc {
	UTS_PROC_ARCH = 0,
	UTS_PROC_OSTYPE = 1,
	UTS_PROC_OSRELEASE = 2,
	UTS_PROC_VERSION = 3,
	UTS_PROC_HOSTNAME = 4,
	UTS_PROC_DOMAINNAME = 5,
};

enum vas_cop_feat_type {
	VAS_GZIP_QOS_FEAT_TYPE = 0,
	VAS_GZIP_DEF_FEAT_TYPE = 1,
	VAS_MAX_FEAT_TYPE = 2,
};

enum vas_cop_type {
	VAS_COP_TYPE_FAULT = 0,
	VAS_COP_TYPE_842 = 1,
	VAS_COP_TYPE_842_HIPRI = 2,
	VAS_COP_TYPE_GZIP = 3,
	VAS_COP_TYPE_GZIP_HIPRI = 4,
	VAS_COP_TYPE_FTW = 5,
	VAS_COP_TYPE_MAX = 6,
};

enum vas_dma_type {
	VAS_DMA_TYPE_INJECT = 0,
	VAS_DMA_TYPE_WRITE = 1,
};

enum vas_migrate_action {
	VAS_SUSPEND = 0,
	VAS_RESUME = 1,
};

enum vas_notify_after_count {
	VAS_NOTIFY_AFTER_256 = 0,
	VAS_NOTIFY_NONE = 1,
	VAS_NOTIFY_AFTER_2 = 2,
};

enum vas_notify_scope {
	VAS_SCOPE_LOCAL = 0,
	VAS_SCOPE_GROUP = 1,
	VAS_SCOPE_VECTORED_GROUP = 2,
	VAS_SCOPE_UNUSED = 3,
};

enum vasi_aborting_entity {
	ORCHESTRATOR = 1,
	VSP_SOURCE = 2,
	PARTITION_FIRMWARE = 3,
	PLATFORM_FIRMWARE = 4,
	VSP_TARGET = 5,
	MIGRATING_PARTITION = 6,
};

enum vc_ctl_state {
	ESnormal = 0,
	ESesc = 1,
	ESsquare = 2,
	ESgetpars = 3,
	ESfunckey = 4,
	EShash = 5,
	ESsetG0 = 6,
	ESsetG1 = 7,
	ESpercent = 8,
	EScsiignore = 9,
	ESnonstd = 10,
	ESpalette = 11,
	ESosc = 12,
	ESANSI_first = 12,
	ESapc = 13,
	ESpm = 14,
	ESdcs = 15,
	ESANSI_last = 15,
};

enum vc_intensity {
	VCI_HALF_BRIGHT = 0,
	VCI_NORMAL = 1,
	VCI_BOLD = 2,
	VCI_MASK = 3,
};

enum vcap_action_field {
	VCAP_AF_NO_VALUE = 0,
	VCAP_AF_ACL_ID = 1,
	VCAP_AF_CLS_VID_SEL = 2,
	VCAP_AF_CNT_ID = 3,
	VCAP_AF_COPY_PORT_NUM = 4,
	VCAP_AF_COPY_QUEUE_NUM = 5,
	VCAP_AF_CPU_COPY_ENA = 6,
	VCAP_AF_CPU_QU = 7,
	VCAP_AF_CPU_QUEUE_NUM = 8,
	VCAP_AF_CUSTOM_ACE_TYPE_ENA = 9,
	VCAP_AF_DEI_A_VAL = 10,
	VCAP_AF_DEI_B_VAL = 11,
	VCAP_AF_DEI_C_VAL = 12,
	VCAP_AF_DEI_ENA = 13,
	VCAP_AF_DEI_VAL = 14,
	VCAP_AF_DLR_SEL = 15,
	VCAP_AF_DP_ENA = 16,
	VCAP_AF_DP_VAL = 17,
	VCAP_AF_DSCP_ENA = 18,
	VCAP_AF_DSCP_SEL = 19,
	VCAP_AF_DSCP_VAL = 20,
	VCAP_AF_ES2_REW_CMD = 21,
	VCAP_AF_ESDX = 22,
	VCAP_AF_FWD_KILL_ENA = 23,
	VCAP_AF_FWD_MODE = 24,
	VCAP_AF_FWD_SEL = 25,
	VCAP_AF_HIT_ME_ONCE = 26,
	VCAP_AF_HOST_MATCH = 27,
	VCAP_AF_IGNORE_PIPELINE_CTRL = 28,
	VCAP_AF_INTR_ENA = 29,
	VCAP_AF_ISDX_ADD_REPLACE_SEL = 30,
	VCAP_AF_ISDX_ADD_VAL = 31,
	VCAP_AF_ISDX_ENA = 32,
	VCAP_AF_ISDX_REPLACE_ENA = 33,
	VCAP_AF_ISDX_VAL = 34,
	VCAP_AF_LOOP_ENA = 35,
	VCAP_AF_LRN_DIS = 36,
	VCAP_AF_MAP_IDX = 37,
	VCAP_AF_MAP_KEY = 38,
	VCAP_AF_MAP_LOOKUP_SEL = 39,
	VCAP_AF_MASK_MODE = 40,
	VCAP_AF_MATCH_ID = 41,
	VCAP_AF_MATCH_ID_MASK = 42,
	VCAP_AF_MIRROR_ENA = 43,
	VCAP_AF_MIRROR_PROBE = 44,
	VCAP_AF_MIRROR_PROBE_ID = 45,
	VCAP_AF_MRP_SEL = 46,
	VCAP_AF_NXT_IDX = 47,
	VCAP_AF_NXT_IDX_CTRL = 48,
	VCAP_AF_OAM_SEL = 49,
	VCAP_AF_PAG_OVERRIDE_MASK = 50,
	VCAP_AF_PAG_VAL = 51,
	VCAP_AF_PCP_A_VAL = 52,
	VCAP_AF_PCP_B_VAL = 53,
	VCAP_AF_PCP_C_VAL = 54,
	VCAP_AF_PCP_ENA = 55,
	VCAP_AF_PCP_VAL = 56,
	VCAP_AF_PIPELINE_ACT = 57,
	VCAP_AF_PIPELINE_FORCE_ENA = 58,
	VCAP_AF_PIPELINE_PT = 59,
	VCAP_AF_POLICE_ENA = 60,
	VCAP_AF_POLICE_IDX = 61,
	VCAP_AF_POLICE_REMARK = 62,
	VCAP_AF_POLICE_VCAP_ONLY = 63,
	VCAP_AF_POP_VAL = 64,
	VCAP_AF_PORT_MASK = 65,
	VCAP_AF_PUSH_CUSTOMER_TAG = 66,
	VCAP_AF_PUSH_INNER_TAG = 67,
	VCAP_AF_PUSH_OUTER_TAG = 68,
	VCAP_AF_QOS_ENA = 69,
	VCAP_AF_QOS_VAL = 70,
	VCAP_AF_REW_OP = 71,
	VCAP_AF_RT_DIS = 72,
	VCAP_AF_SFID_ENA = 73,
	VCAP_AF_SFID_VAL = 74,
	VCAP_AF_SGID_ENA = 75,
	VCAP_AF_SGID_VAL = 76,
	VCAP_AF_SWAP_MACS_ENA = 77,
	VCAP_AF_TAG_A_DEI_SEL = 78,
	VCAP_AF_TAG_A_PCP_SEL = 79,
	VCAP_AF_TAG_A_TPID_SEL = 80,
	VCAP_AF_TAG_A_VID_SEL = 81,
	VCAP_AF_TAG_B_DEI_SEL = 82,
	VCAP_AF_TAG_B_PCP_SEL = 83,
	VCAP_AF_TAG_B_TPID_SEL = 84,
	VCAP_AF_TAG_B_VID_SEL = 85,
	VCAP_AF_TAG_C_DEI_SEL = 86,
	VCAP_AF_TAG_C_PCP_SEL = 87,
	VCAP_AF_TAG_C_TPID_SEL = 88,
	VCAP_AF_TAG_C_VID_SEL = 89,
	VCAP_AF_TYPE = 90,
	VCAP_AF_UNTAG_VID_ENA = 91,
	VCAP_AF_VID_A_VAL = 92,
	VCAP_AF_VID_B_VAL = 93,
	VCAP_AF_VID_C_VAL = 94,
	VCAP_AF_VID_REPLACE_ENA = 95,
	VCAP_AF_VID_VAL = 96,
	VCAP_AF_VLAN_POP_CNT = 97,
	VCAP_AF_VLAN_POP_CNT_ENA = 98,
};

enum vcap_actionfield_set {
	VCAP_AFS_NO_VALUE = 0,
	VCAP_AFS_BASE_TYPE = 1,
	VCAP_AFS_CLASSIFICATION = 2,
	VCAP_AFS_CLASS_REDUCED = 3,
	VCAP_AFS_ES0 = 4,
	VCAP_AFS_FULL = 5,
	VCAP_AFS_S1 = 6,
	VCAP_AFS_SMAC_SIP = 7,
	VCAP_AFS_VID = 8,
};

enum vcap_arp_opcode {
	VCAP_ARP_OP_RESERVED = 0,
	VCAP_ARP_OP_REQUEST = 1,
	VCAP_ARP_OP_REPLY = 2,
};

enum vcap_bit {
	VCAP_BIT_ANY = 0,
	VCAP_BIT_0 = 1,
	VCAP_BIT_1 = 2,
};

enum vcap_command {
	VCAP_CMD_WRITE = 0,
	VCAP_CMD_READ = 1,
	VCAP_CMD_MOVE_DOWN = 2,
	VCAP_CMD_MOVE_UP = 3,
	VCAP_CMD_INITIALIZE = 4,
};

enum vcap_field_type {
	VCAP_FIELD_BIT = 0,
	VCAP_FIELD_U32 = 1,
	VCAP_FIELD_U48 = 2,
	VCAP_FIELD_U56 = 3,
	VCAP_FIELD_U64 = 4,
	VCAP_FIELD_U72 = 5,
	VCAP_FIELD_U112 = 6,
	VCAP_FIELD_U128 = 7,
};

enum vcap_is2_arp_opcode {
	VCAP_IS2_ARP_REQUEST = 0,
	VCAP_IS2_ARP_REPLY = 1,
	VCAP_IS2_RARP_REQUEST = 2,
	VCAP_IS2_RARP_REPLY = 3,
};

enum vcap_key_field {
	VCAP_KF_NO_VALUE = 0,
	VCAP_KF_8021BR_ECID_BASE = 1,
	VCAP_KF_8021BR_ECID_EXT = 2,
	VCAP_KF_8021BR_E_TAGGED = 3,
	VCAP_KF_8021BR_GRP = 4,
	VCAP_KF_8021BR_IGR_ECID_BASE = 5,
	VCAP_KF_8021BR_IGR_ECID_EXT = 6,
	VCAP_KF_8021CB_R_TAGGED_IS = 7,
	VCAP_KF_8021Q_DEI0 = 8,
	VCAP_KF_8021Q_DEI1 = 9,
	VCAP_KF_8021Q_DEI2 = 10,
	VCAP_KF_8021Q_DEI_CLS = 11,
	VCAP_KF_8021Q_PCP0 = 12,
	VCAP_KF_8021Q_PCP1 = 13,
	VCAP_KF_8021Q_PCP2 = 14,
	VCAP_KF_8021Q_PCP_CLS = 15,
	VCAP_KF_8021Q_TPID = 16,
	VCAP_KF_8021Q_TPID0 = 17,
	VCAP_KF_8021Q_TPID1 = 18,
	VCAP_KF_8021Q_TPID2 = 19,
	VCAP_KF_8021Q_VID0 = 20,
	VCAP_KF_8021Q_VID1 = 21,
	VCAP_KF_8021Q_VID2 = 22,
	VCAP_KF_8021Q_VID_CLS = 23,
	VCAP_KF_8021Q_VLAN_DBL_TAGGED_IS = 24,
	VCAP_KF_8021Q_VLAN_TAGGED_IS = 25,
	VCAP_KF_8021Q_VLAN_TAGS = 26,
	VCAP_KF_ACL_GRP_ID = 27,
	VCAP_KF_ARP_ADDR_SPACE_OK_IS = 28,
	VCAP_KF_ARP_LEN_OK_IS = 29,
	VCAP_KF_ARP_OPCODE = 30,
	VCAP_KF_ARP_OPCODE_UNKNOWN_IS = 31,
	VCAP_KF_ARP_PROTO_SPACE_OK_IS = 32,
	VCAP_KF_ARP_SENDER_MATCH_IS = 33,
	VCAP_KF_ARP_TGT_MATCH_IS = 34,
	VCAP_KF_COSID_CLS = 35,
	VCAP_KF_ES0_ISDX_KEY_ENA = 36,
	VCAP_KF_ETYPE = 37,
	VCAP_KF_ETYPE_LEN_IS = 38,
	VCAP_KF_HOST_MATCH = 39,
	VCAP_KF_IF_EGR_PORT_MASK = 40,
	VCAP_KF_IF_EGR_PORT_MASK_RNG = 41,
	VCAP_KF_IF_EGR_PORT_NO = 42,
	VCAP_KF_IF_IGR_PORT = 43,
	VCAP_KF_IF_IGR_PORT_MASK = 44,
	VCAP_KF_IF_IGR_PORT_MASK_L3 = 45,
	VCAP_KF_IF_IGR_PORT_MASK_RNG = 46,
	VCAP_KF_IF_IGR_PORT_MASK_SEL = 47,
	VCAP_KF_IF_IGR_PORT_SEL = 48,
	VCAP_KF_IP4_IS = 49,
	VCAP_KF_IP_MC_IS = 50,
	VCAP_KF_IP_PAYLOAD_5TUPLE = 51,
	VCAP_KF_IP_PAYLOAD_S1_IP6 = 52,
	VCAP_KF_IP_SNAP_IS = 53,
	VCAP_KF_ISDX_CLS = 54,
	VCAP_KF_ISDX_GT0_IS = 55,
	VCAP_KF_L2_BC_IS = 56,
	VCAP_KF_L2_DMAC = 57,
	VCAP_KF_L2_FRM_TYPE = 58,
	VCAP_KF_L2_FWD_IS = 59,
	VCAP_KF_L2_LLC = 60,
	VCAP_KF_L2_MAC = 61,
	VCAP_KF_L2_MC_IS = 62,
	VCAP_KF_L2_PAYLOAD0 = 63,
	VCAP_KF_L2_PAYLOAD1 = 64,
	VCAP_KF_L2_PAYLOAD2 = 65,
	VCAP_KF_L2_PAYLOAD_ETYPE = 66,
	VCAP_KF_L2_SMAC = 67,
	VCAP_KF_L2_SNAP = 68,
	VCAP_KF_L3_DIP_EQ_SIP_IS = 69,
	VCAP_KF_L3_DPL_CLS = 70,
	VCAP_KF_L3_DSCP = 71,
	VCAP_KF_L3_DST_IS = 72,
	VCAP_KF_L3_FRAGMENT = 73,
	VCAP_KF_L3_FRAGMENT_TYPE = 74,
	VCAP_KF_L3_FRAG_INVLD_L4_LEN = 75,
	VCAP_KF_L3_FRAG_OFS_GT0 = 76,
	VCAP_KF_L3_IP4_DIP = 77,
	VCAP_KF_L3_IP4_SIP = 78,
	VCAP_KF_L3_IP6_DIP = 79,
	VCAP_KF_L3_IP6_DIP_MSB = 80,
	VCAP_KF_L3_IP6_SIP = 81,
	VCAP_KF_L3_IP6_SIP_MSB = 82,
	VCAP_KF_L3_IP_PROTO = 83,
	VCAP_KF_L3_OPTIONS_IS = 84,
	VCAP_KF_L3_PAYLOAD = 85,
	VCAP_KF_L3_RT_IS = 86,
	VCAP_KF_L3_TOS = 87,
	VCAP_KF_L3_TTL_GT0 = 88,
	VCAP_KF_L4_1588_DOM = 89,
	VCAP_KF_L4_1588_VER = 90,
	VCAP_KF_L4_ACK = 91,
	VCAP_KF_L4_DPORT = 92,
	VCAP_KF_L4_FIN = 93,
	VCAP_KF_L4_PAYLOAD = 94,
	VCAP_KF_L4_PSH = 95,
	VCAP_KF_L4_RNG = 96,
	VCAP_KF_L4_RST = 97,
	VCAP_KF_L4_SEQUENCE_EQ0_IS = 98,
	VCAP_KF_L4_SPORT = 99,
	VCAP_KF_L4_SPORT_EQ_DPORT_IS = 100,
	VCAP_KF_L4_SYN = 101,
	VCAP_KF_L4_URG = 102,
	VCAP_KF_LOOKUP_FIRST_IS = 103,
	VCAP_KF_LOOKUP_GEN_IDX = 104,
	VCAP_KF_LOOKUP_GEN_IDX_SEL = 105,
	VCAP_KF_LOOKUP_INDEX = 106,
	VCAP_KF_LOOKUP_PAG = 107,
	VCAP_KF_MIRROR_PROBE = 108,
	VCAP_KF_OAM_CCM_CNTS_EQ0 = 109,
	VCAP_KF_OAM_DETECTED = 110,
	VCAP_KF_OAM_FLAGS = 111,
	VCAP_KF_OAM_MEL_FLAGS = 112,
	VCAP_KF_OAM_MEPID = 113,
	VCAP_KF_OAM_OPCODE = 114,
	VCAP_KF_OAM_VER = 115,
	VCAP_KF_OAM_Y1731_IS = 116,
	VCAP_KF_PDU_TYPE = 117,
	VCAP_KF_PROT_ACTIVE = 118,
	VCAP_KF_RTP_ID = 119,
	VCAP_KF_RT_FRMID = 120,
	VCAP_KF_RT_TYPE = 121,
	VCAP_KF_RT_VLAN_IDX = 122,
	VCAP_KF_TCP_IS = 123,
	VCAP_KF_TCP_UDP_IS = 124,
	VCAP_KF_TYPE = 125,
};

enum vcap_keyfield_set {
	VCAP_KFS_NO_VALUE = 0,
	VCAP_KFS_5TUPLE_IP4 = 1,
	VCAP_KFS_5TUPLE_IP6 = 2,
	VCAP_KFS_7TUPLE = 3,
	VCAP_KFS_ARP = 4,
	VCAP_KFS_DBL_VID = 5,
	VCAP_KFS_DMAC_VID = 6,
	VCAP_KFS_ETAG = 7,
	VCAP_KFS_IP4_OTHER = 8,
	VCAP_KFS_IP4_TCP_UDP = 9,
	VCAP_KFS_IP4_VID = 10,
	VCAP_KFS_IP6_OTHER = 11,
	VCAP_KFS_IP6_STD = 12,
	VCAP_KFS_IP6_TCP_UDP = 13,
	VCAP_KFS_IP6_VID = 14,
	VCAP_KFS_IP_7TUPLE = 15,
	VCAP_KFS_ISDX = 16,
	VCAP_KFS_LL_FULL = 17,
	VCAP_KFS_MAC_ETYPE = 18,
	VCAP_KFS_MAC_LLC = 19,
	VCAP_KFS_MAC_SNAP = 20,
	VCAP_KFS_NORMAL = 21,
	VCAP_KFS_NORMAL_5TUPLE_IP4 = 22,
	VCAP_KFS_NORMAL_7TUPLE = 23,
	VCAP_KFS_NORMAL_IP6 = 24,
	VCAP_KFS_OAM = 25,
	VCAP_KFS_PURE_5TUPLE_IP4 = 26,
	VCAP_KFS_RT = 27,
	VCAP_KFS_SMAC_SIP4 = 28,
	VCAP_KFS_SMAC_SIP6 = 29,
	VCAP_KFS_VID = 30,
};

enum vcap_rule_error {
	VCAP_ERR_NONE = 0,
	VCAP_ERR_NO_ADMIN = 1,
	VCAP_ERR_NO_NETDEV = 2,
	VCAP_ERR_NO_KEYSET_MATCH = 3,
	VCAP_ERR_NO_ACTIONSET_MATCH = 4,
	VCAP_ERR_NO_PORT_KEYSET_MATCH = 5,
};

enum vcap_rule_state {
	VCAP_RS_PERMANENT = 0,
	VCAP_RS_ENABLED = 1,
	VCAP_RS_DISABLED = 2,
};

enum vcap_selection {
	VCAP_SEL_ENTRY = 1,
	VCAP_SEL_ACTION = 2,
	VCAP_SEL_COUNTER = 4,
	VCAP_SEL_ALL = 255,
};

enum vcap_type {
	VCAP_TYPE_ES0 = 0,
	VCAP_TYPE_ES2 = 1,
	VCAP_TYPE_IS0 = 2,
	VCAP_TYPE_IS1 = 3,
	VCAP_TYPE_IS2 = 4,
	VCAP_TYPE_MAX = 5,
};

enum vcap_user {
	VCAP_USER_PTP = 0,
	VCAP_USER_MRP = 1,
	VCAP_USER_CFM = 2,
	VCAP_USER_VLAN = 3,
	VCAP_USER_QOS = 4,
	VCAP_USER_VCAP_UTIL = 5,
	VCAP_USER_TC = 6,
	VCAP_USER_TC_EXTRA = 7,
	__VCAP_USER_AFTER_LAST = 8,
	VCAP_USER_MAX = 7,
};

enum vdso_clock_mode {
	VDSO_CLOCKMODE_NONE = 0,
	VDSO_CLOCKMODE_ARCHTIMER = 1,
	VDSO_CLOCKMODE_MAX = 2,
	VDSO_CLOCKMODE_TIMENS = 2147483647,
};

enum verifier_phase {
	CHECK_META = 0,
	CHECK_TYPE = 1,
};

enum vesa_blank_mode {
	VESA_NO_BLANKING = 0,
	VESA_VSYNC_SUSPEND = 1,
	VESA_HSYNC_SUSPEND = 2,
	VESA_POWERDOWN = 3,
	VESA_BLANK_MAX = 3,
};

enum vhost_task_flags {
	VHOST_TASK_FLAGS_STOP = 0,
	VHOST_TASK_FLAGS_KILLED = 1,
};

enum vio_dev_family {
	VDEVICE = 0,
	PFO = 1,
};

enum viosrp_capability_flag {
	CLIENT_MIGRATED = 1,
	CLIENT_RECONNECT = 2,
	CAP_LIST_SUPPORTED = 4,
	CAP_LIST_DATA = 8,
};

enum viosrp_capability_support {
	SERVER_DOES_NOT_SUPPORTS_CAP = 0,
	SERVER_SUPPORTS_CAP = 1,
	SERVER_CAP_DATA = 2,
};

enum viosrp_capability_type {
	MIGRATION_CAPABILITIES = 1,
	RESERVATION_CAPABILITIES = 2,
};

enum viosrp_crq_formats {
	VIOSRP_SRP_FORMAT = 1,
	VIOSRP_MAD_FORMAT = 2,
	VIOSRP_OS400_FORMAT = 3,
	VIOSRP_AIX_FORMAT = 4,
	VIOSRP_LINUX_FORMAT = 5,
	VIOSRP_INLINE_FORMAT = 6,
};

enum viosrp_crq_headers {
	VIOSRP_CRQ_FREE = 0,
	VIOSRP_CRQ_CMD_RSP = 128,
	VIOSRP_CRQ_INIT_RSP = 192,
	VIOSRP_CRQ_XPORT_EVENT = 255,
};

enum viosrp_crq_init_formats {
	VIOSRP_CRQ_INIT = 1,
	VIOSRP_CRQ_INIT_COMPLETE = 2,
};

enum viosrp_crq_status {
	VIOSRP_OK = 0,
	VIOSRP_NONRECOVERABLE_ERR = 1,
	VIOSRP_VIOLATES_MAX_XFER = 2,
	VIOSRP_PARTNER_PANIC = 3,
	VIOSRP_DEVICE_BUSY = 8,
	VIOSRP_ADAPTER_FAIL = 16,
	VIOSRP_OK2 = 153,
};

enum viosrp_mad_status {
	VIOSRP_MAD_SUCCESS = 0,
	VIOSRP_MAD_NOT_SUPPORTED = 241,
	VIOSRP_MAD_FAILED = 247,
};

enum viosrp_mad_types {
	VIOSRP_EMPTY_IU_TYPE = 1,
	VIOSRP_ERROR_LOG_TYPE = 2,
	VIOSRP_ADAPTER_INFO_TYPE = 3,
	VIOSRP_CAPABILITIES_TYPE = 5,
	VIOSRP_ENABLE_FAST_FAIL = 8,
};

enum viosrp_reserve_type {
	CLIENT_RESERVE_SCSI_2 = 1,
};

enum visit_state {
	NOT_VISITED = 0,
	VISITED = 1,
	RESOLVED = 2,
};

enum vlan_flags {
	VLAN_FLAG_REORDER_HDR = 1,
	VLAN_FLAG_GVRP = 2,
	VLAN_FLAG_LOOSE_BINDING = 4,
	VLAN_FLAG_MVRP = 8,
	VLAN_FLAG_BRIDGE_BINDING = 16,
};

enum vlan_protos {
	VLAN_PROTO_8021Q = 0,
	VLAN_PROTO_8021AD = 1,
	VLAN_PROTO_NUM = 2,
};

enum vm_event_item {
	PGPGIN = 0,
	PGPGOUT = 1,
	PSWPIN = 2,
	PSWPOUT = 3,
	PGALLOC_NORMAL = 4,
	PGALLOC_MOVABLE = 5,
	PGALLOC_DEVICE = 6,
	ALLOCSTALL_NORMAL = 7,
	ALLOCSTALL_MOVABLE = 8,
	ALLOCSTALL_DEVICE = 9,
	PGSCAN_SKIP_NORMAL = 10,
	PGSCAN_SKIP_MOVABLE = 11,
	PGSCAN_SKIP_DEVICE = 12,
	PGFREE = 13,
	PGACTIVATE = 14,
	PGDEACTIVATE = 15,
	PGLAZYFREE = 16,
	PGFAULT = 17,
	PGMAJFAULT = 18,
	PGLAZYFREED = 19,
	PGREFILL = 20,
	PGREUSE = 21,
	PGSTEAL_KSWAPD = 22,
	PGSTEAL_DIRECT = 23,
	PGSTEAL_KHUGEPAGED = 24,
	PGSCAN_KSWAPD = 25,
	PGSCAN_DIRECT = 26,
	PGSCAN_KHUGEPAGED = 27,
	PGSCAN_DIRECT_THROTTLE = 28,
	PGSCAN_ANON = 29,
	PGSCAN_FILE = 30,
	PGSTEAL_ANON = 31,
	PGSTEAL_FILE = 32,
	PGSCAN_ZONE_RECLAIM_FAILED = 33,
	PGINODESTEAL = 34,
	SLABS_SCANNED = 35,
	KSWAPD_INODESTEAL = 36,
	KSWAPD_LOW_WMARK_HIT_QUICKLY = 37,
	KSWAPD_HIGH_WMARK_HIT_QUICKLY = 38,
	PAGEOUTRUN = 39,
	PGROTATED = 40,
	DROP_PAGECACHE = 41,
	DROP_SLAB = 42,
	OOM_KILL = 43,
	NUMA_PTE_UPDATES = 44,
	NUMA_HUGE_PTE_UPDATES = 45,
	NUMA_HINT_FAULTS = 46,
	NUMA_HINT_FAULTS_LOCAL = 47,
	NUMA_PAGE_MIGRATE = 48,
	PGMIGRATE_SUCCESS = 49,
	PGMIGRATE_FAIL = 50,
	THP_MIGRATION_SUCCESS = 51,
	THP_MIGRATION_FAIL = 52,
	THP_MIGRATION_SPLIT = 53,
	COMPACTMIGRATE_SCANNED = 54,
	COMPACTFREE_SCANNED = 55,
	COMPACTISOLATED = 56,
	COMPACTSTALL = 57,
	COMPACTFAIL = 58,
	COMPACTSUCCESS = 59,
	KCOMPACTD_WAKE = 60,
	KCOMPACTD_MIGRATE_SCANNED = 61,
	KCOMPACTD_FREE_SCANNED = 62,
	HTLB_BUDDY_PGALLOC = 63,
	HTLB_BUDDY_PGALLOC_FAIL = 64,
	CMA_ALLOC_SUCCESS = 65,
	CMA_ALLOC_FAIL = 66,
	UNEVICTABLE_PGCULLED = 67,
	UNEVICTABLE_PGSCANNED = 68,
	UNEVICTABLE_PGRESCUED = 69,
	UNEVICTABLE_PGMLOCKED = 70,
	UNEVICTABLE_PGMUNLOCKED = 71,
	UNEVICTABLE_PGCLEARED = 72,
	UNEVICTABLE_PGSTRANDED = 73,
	THP_FAULT_ALLOC = 74,
	THP_FAULT_FALLBACK = 75,
	THP_FAULT_FALLBACK_CHARGE = 76,
	THP_COLLAPSE_ALLOC = 77,
	THP_COLLAPSE_ALLOC_FAILED = 78,
	THP_FILE_ALLOC = 79,
	THP_FILE_FALLBACK = 80,
	THP_FILE_FALLBACK_CHARGE = 81,
	THP_FILE_MAPPED = 82,
	THP_SPLIT_PAGE = 83,
	THP_SPLIT_PAGE_FAILED = 84,
	THP_DEFERRED_SPLIT_PAGE = 85,
	THP_SPLIT_PMD = 86,
	THP_SCAN_EXCEED_NONE_PTE = 87,
	THP_SCAN_EXCEED_SWAP_PTE = 88,
	THP_SCAN_EXCEED_SHARED_PTE = 89,
	THP_SPLIT_PUD = 90,
	THP_ZERO_PAGE_ALLOC = 91,
	THP_ZERO_PAGE_ALLOC_FAILED = 92,
	THP_SWPOUT = 93,
	THP_SWPOUT_FALLBACK = 94,
	BALLOON_INFLATE = 95,
	BALLOON_DEFLATE = 96,
	BALLOON_MIGRATE = 97,
	SWAP_RA = 98,
	SWAP_RA_HIT = 99,
	KSM_SWPIN_COPY = 100,
	COW_KSM = 101,
	ZSWPIN = 102,
	ZSWPOUT = 103,
	ZSWPWB = 104,
	NR_VM_EVENT_ITEMS = 105,
};

enum vm_fault_reason {
	VM_FAULT_OOM = 1,
	VM_FAULT_SIGBUS = 2,
	VM_FAULT_MAJOR = 4,
	VM_FAULT_HWPOISON = 16,
	VM_FAULT_HWPOISON_LARGE = 32,
	VM_FAULT_SIGSEGV = 64,
	VM_FAULT_NOPAGE = 256,
	VM_FAULT_LOCKED = 512,
	VM_FAULT_RETRY = 1024,
	VM_FAULT_FALLBACK = 2048,
	VM_FAULT_DONE_COW = 4096,
	VM_FAULT_NEEDDSYNC = 8192,
	VM_FAULT_COMPLETED = 16384,
	VM_FAULT_HINDEX_MASK = 983040,
};

enum vma_resv_mode {
	VMA_NEEDS_RESV = 0,
	VMA_COMMIT_RESV = 1,
	VMA_END_RESV = 2,
	VMA_ADD_RESV = 3,
	VMA_DEL_RESV = 4,
};

enum vme_resource_type {
	VME_MASTER = 0,
	VME_SLAVE = 1,
	VME_DMA = 2,
	VME_LM = 3,
};

enum vmpressure_levels {
	VMPRESSURE_LOW = 0,
	VMPRESSURE_MEDIUM = 1,
	VMPRESSURE_CRITICAL = 2,
	VMPRESSURE_NUM_LEVELS = 3,
};

enum vmpressure_modes {
	VMPRESSURE_NO_PASSTHROUGH = 0,
	VMPRESSURE_HIERARCHY = 1,
	VMPRESSURE_LOCAL = 2,
	VMPRESSURE_NUM_MODES = 3,
};

enum vmscan_throttle_state {
	VMSCAN_THROTTLE_WRITEBACK = 0,
	VMSCAN_THROTTLE_ISOLATED = 1,
	VMSCAN_THROTTLE_NOPROGRESS = 2,
	VMSCAN_THROTTLE_CONGESTED = 3,
	NR_VMSCAN_THROTTLE = 4,
};

enum vnic_dev_intr_mode {
	VNIC_DEV_INTR_MODE_UNKNOWN = 0,
	VNIC_DEV_INTR_MODE_INTX = 1,
	VNIC_DEV_INTR_MODE_MSI = 2,
	VNIC_DEV_INTR_MODE_MSIX = 3,
};

enum vnic_devcmd_cmd {
	CMD_NONE = 0,
	CMD_MCPU_FW_INFO = 1073856513,
	CMD_DEV_SPEC = 3221340162,
	CMD_STATS_CLEAR = 16891907,
	CMD_STATS_DUMP = 1073856516,
	CMD_NIC_CFG = 1090633744,
	CMD_NOTIFY = 3221340181,
	CMD_OPEN = 1090633751,
	CMD_OPEN_STATUS = 2147598360,
	CMD_CLOSE = 114713,
	CMD_INIT = 2164375578,
	CMD_ENABLE = 1090633756,
	CMD_ENABLE_WAIT = 1073856540,
	CMD_DISABLE = 114717,
	CMD_STATS_DUMP_ALL = 1073856542,
	CMD_INIT_STATUS = 2147598367,
	CMD_DEINIT = 16891938,
	CMD_CAPABILITY = 3221340196,
	CMD_INITIALIZE_DEVCMD2 = 1073856569,
};

enum vnic_devcmd_error {
	ERR_SUCCESS = 0,
	ERR_EINVAL = 1,
	ERR_EFAULT = 2,
	ERR_EPERM = 3,
	ERR_EBUSY = 4,
	ERR_ECMDUNKNOWN = 5,
	ERR_EBADSTATE = 6,
	ERR_ENOMEM = 7,
	ERR_ETIMEDOUT = 8,
	ERR_ELINKDOWN = 9,
};

enum vnic_res_type {
	RES_TYPE_EOL = 0,
	RES_TYPE_WQ = 1,
	RES_TYPE_RQ = 2,
	RES_TYPE_CQ = 3,
	RES_TYPE_RSVD1 = 4,
	RES_TYPE_NIC_CFG = 5,
	RES_TYPE_RSVD2 = 6,
	RES_TYPE_RSVD3 = 7,
	RES_TYPE_RSVD4 = 8,
	RES_TYPE_RSVD5 = 9,
	RES_TYPE_INTR_CTRL = 10,
	RES_TYPE_INTR_TABLE = 11,
	RES_TYPE_INTR_PBA = 12,
	RES_TYPE_INTR_PBA_LEGACY = 13,
	RES_TYPE_RSVD6 = 14,
	RES_TYPE_RSVD7 = 15,
	RES_TYPE_DEVCMD = 16,
	RES_TYPE_PASS_THRU_PAGE = 17,
	RES_TYPE_SUBVNIC = 18,
	RES_TYPE_MQ_WQ = 19,
	RES_TYPE_MQ_RQ = 20,
	RES_TYPE_MQ_CQ = 21,
	RES_TYPE_DEPRECATED1 = 22,
	RES_TYPE_DEPRECATED2 = 23,
	RES_TYPE_DEVCMD2 = 24,
	RES_TYPE_MAX = 25,
};

enum vport_ns_event {
	NSSM_EVENT_PORT_ONLINE = 1,
	NSSM_EVENT_PORT_OFFLINE = 2,
	NSSM_EVENT_PLOGI_SENT = 3,
	NSSM_EVENT_RSP_OK = 4,
	NSSM_EVENT_RSP_ERROR = 5,
	NSSM_EVENT_TIMEOUT = 6,
	NSSM_EVENT_NS_QUERY = 7,
	NSSM_EVENT_RSPNID_SENT = 8,
	NSSM_EVENT_RFTID_SENT = 9,
	NSSM_EVENT_RFFID_SENT = 10,
	NSSM_EVENT_GIDFT_SENT = 11,
	NSSM_EVENT_RNNID_SENT = 12,
	NSSM_EVENT_RSNN_NN_SENT = 13,
};

enum vtime_state {
	VTIME_INACTIVE = 0,
	VTIME_IDLE = 1,
	VTIME_SYS = 2,
	VTIME_USER = 3,
	VTIME_GUEST = 4,
};

enum vvar_pages {
	VVAR_DATA_PAGE_OFFSET = 0,
	VVAR_TIMENS_PAGE_OFFSET = 1,
	VVAR_NR_PAGES = 2,
};

enum watch_meta_notification_subtype {
	WATCH_META_REMOVAL_NOTIFICATION = 0,
	WATCH_META_LOSS_NOTIFICATION = 1,
};

enum watch_notification_type {
	WATCH_TYPE_META = 0,
	WATCH_TYPE_KEY_NOTIFY = 1,
	WATCH_TYPE__NR = 2,
};

enum wb_reason {
	WB_REASON_BACKGROUND = 0,
	WB_REASON_VMSCAN = 1,
	WB_REASON_SYNC = 2,
	WB_REASON_PERIODIC = 3,
	WB_REASON_LAPTOP_TIMER = 4,
	WB_REASON_FS_FREE_SPACE = 5,
	WB_REASON_FORKER_THREAD = 6,
	WB_REASON_FOREIGN_FLUSH = 7,
	WB_REASON_MAX = 8,
};

enum wb_stat_item {
	WB_RECLAIMABLE = 0,
	WB_WRITEBACK = 1,
	WB_DIRTIED = 2,
	WB_WRITTEN = 3,
	NR_WB_STAT_ITEMS = 4,
};

enum wb_state {
	WB_registered = 0,
	WB_writeback_running = 1,
	WB_has_dirty_io = 2,
	WB_start_all = 3,
};

enum wbt_flags {
	WBT_TRACKED = 1,
	WBT_READ = 2,
	WBT_KSWAPD = 4,
	WBT_DISCARD = 8,
	WBT_NR_BITS = 4,
};

enum wd719x_card_type {
	WD719X_TYPE_UNKNOWN = 0,
	WD719X_TYPE_7193 = 1,
	WD719X_TYPE_7197 = 2,
	WD719X_TYPE_7296 = 3,
};

enum wiphy_flags {
	WIPHY_FLAG_SUPPORTS_EXT_KEK_KCK = 1,
	WIPHY_FLAG_SUPPORTS_MLO = 2,
	WIPHY_FLAG_SPLIT_SCAN_6GHZ = 4,
	WIPHY_FLAG_NETNS_OK = 8,
	WIPHY_FLAG_PS_ON_BY_DEFAULT = 16,
	WIPHY_FLAG_4ADDR_AP = 32,
	WIPHY_FLAG_4ADDR_STATION = 64,
	WIPHY_FLAG_CONTROL_PORT_PROTOCOL = 128,
	WIPHY_FLAG_IBSS_RSN = 256,
	WIPHY_FLAG_DISABLE_WEXT = 512,
	WIPHY_FLAG_MESH_AUTH = 1024,
	WIPHY_FLAG_SUPPORTS_EXT_KCK_32 = 2048,
	WIPHY_FLAG_SUPPORTS_NSTR_NONPRIMARY = 4096,
	WIPHY_FLAG_SUPPORTS_FW_ROAM = 8192,
	WIPHY_FLAG_AP_UAPSD = 16384,
	WIPHY_FLAG_SUPPORTS_TDLS = 32768,
	WIPHY_FLAG_TDLS_EXTERNAL_SETUP = 65536,
	WIPHY_FLAG_HAVE_AP_SME = 131072,
	WIPHY_FLAG_REPORTS_OBSS = 262144,
	WIPHY_FLAG_AP_PROBE_RESP_OFFLOAD = 524288,
	WIPHY_FLAG_OFFCHAN_TX = 1048576,
	WIPHY_FLAG_HAS_REMAIN_ON_CHANNEL = 2097152,
	WIPHY_FLAG_SUPPORTS_5_10_MHZ = 4194304,
	WIPHY_FLAG_HAS_CHANNEL_SWITCH = 8388608,
	WIPHY_FLAG_NOTIFY_REGDOM_BY_DRIVER = 16777216,
	WIPHY_FLAG_CHANNEL_CHANGE_ON_BEACON = 33554432,
};

enum wm831x_auxadc {
	WM831X_AUX_CAL = 15,
	WM831X_AUX_BKUP_BATT = 10,
	WM831X_AUX_WALL = 9,
	WM831X_AUX_BATT = 8,
	WM831X_AUX_USB = 7,
	WM831X_AUX_SYSVDD = 6,
	WM831X_AUX_BATT_TEMP = 5,
	WM831X_AUX_CHIP_TEMP = 4,
	WM831X_AUX_AUX4 = 3,
	WM831X_AUX_AUX3 = 2,
	WM831X_AUX_AUX2 = 1,
	WM831X_AUX_AUX1 = 0,
};

enum wm831x_parent {
	WM8310 = 33552,
	WM8311 = 33553,
	WM8312 = 33554,
	WM8320 = 33568,
	WM8321 = 33569,
	WM8325 = 33573,
	WM8326 = 33574,
};

enum wm831x_status_src {
	WM831X_STATUS_PRESERVE = 0,
	WM831X_STATUS_OTP = 1,
	WM831X_STATUS_POWER = 2,
	WM831X_STATUS_CHARGER = 3,
	WM831X_STATUS_MANUAL = 4,
};

enum wm831x_watchdog_action {
	WM831X_WDOG_NONE = 0,
	WM831X_WDOG_INTERRUPT = 1,
	WM831X_WDOG_RESET = 2,
	WM831X_WDOG_WAKE = 3,
};

enum work_bits {
	WORK_STRUCT_PENDING_BIT = 0,
	WORK_STRUCT_INACTIVE_BIT = 1,
	WORK_STRUCT_PWQ_BIT = 2,
	WORK_STRUCT_LINKED_BIT = 3,
	WORK_STRUCT_FLAG_BITS = 4,
	WORK_STRUCT_COLOR_SHIFT = 4,
	WORK_STRUCT_COLOR_BITS = 4,
	WORK_STRUCT_PWQ_SHIFT = 8,
	WORK_OFFQ_FLAG_SHIFT = 4,
	WORK_OFFQ_BH_BIT = 4,
	WORK_OFFQ_FLAG_END = 5,
	WORK_OFFQ_FLAG_BITS = 1,
	WORK_OFFQ_DISABLE_SHIFT = 5,
	WORK_OFFQ_DISABLE_BITS = 16,
	WORK_OFFQ_POOL_SHIFT = 21,
	WORK_OFFQ_LEFT = 43,
	WORK_OFFQ_POOL_BITS = 31,
};

enum work_cancel_flags {
	WORK_CANCEL_DELAYED = 1,
	WORK_CANCEL_DISABLE = 2,
};

enum work_flags {
	WORK_STRUCT_PENDING = 1,
	WORK_STRUCT_INACTIVE = 2,
	WORK_STRUCT_PWQ = 4,
	WORK_STRUCT_LINKED = 8,
	WORK_STRUCT_STATIC = 0,
};

enum worker_flags {
	WORKER_DIE = 2,
	WORKER_IDLE = 4,
	WORKER_PREP = 8,
	WORKER_CPU_INTENSIVE = 64,
	WORKER_UNBOUND = 128,
	WORKER_REBOUND = 256,
	WORKER_NOT_RUNNING = 456,
};

enum worker_pool_flags {
	POOL_BH = 1,
	POOL_MANAGER_ACTIVE = 2,
	POOL_DISASSOCIATED = 4,
	POOL_BH_DRAINING = 8,
};

enum wq_affn_scope {
	WQ_AFFN_DFL = 0,
	WQ_AFFN_CPU = 1,
	WQ_AFFN_SMT = 2,
	WQ_AFFN_CACHE = 3,
	WQ_AFFN_NUMA = 4,
	WQ_AFFN_SYSTEM = 5,
	WQ_AFFN_NR_TYPES = 6,
};

enum wq_consts {
	WQ_MAX_ACTIVE = 512,
	WQ_UNBOUND_MAX_ACTIVE = 512,
	WQ_DFL_ACTIVE = 256,
	WQ_DFL_MIN_ACTIVE = 8,
};

enum wq_flags {
	WQ_BH = 1,
	WQ_UNBOUND = 2,
	WQ_FREEZABLE = 4,
	WQ_MEM_RECLAIM = 8,
	WQ_HIGHPRI = 16,
	WQ_CPU_INTENSIVE = 32,
	WQ_SYSFS = 64,
	WQ_POWER_EFFICIENT = 128,
	__WQ_DESTROYING = 32768,
	__WQ_DRAINING = 65536,
	__WQ_ORDERED = 131072,
	__WQ_LEGACY = 262144,
	__WQ_BH_ALLOWS = 17,
};

enum wq_internal_consts {
	NR_STD_WORKER_POOLS = 2,
	UNBOUND_POOL_HASH_ORDER = 6,
	BUSY_WORKER_HASH_ORDER = 6,
	MAX_IDLE_WORKERS_RATIO = 4,
	IDLE_WORKER_TIMEOUT = 300000,
	MAYDAY_INITIAL_TIMEOUT = 10,
	MAYDAY_INTERVAL = 100,
	CREATE_COOLDOWN = 1000,
	RESCUER_NICE_LEVEL = -20,
	HIGHPRI_NICE_LEVEL = -20,
	WQ_NAME_LEN = 32,
	WORKER_ID_LEN = 42,
};

enum wq_misc_consts {
	WORK_NR_COLORS = 16,
	WORK_CPU_UNBOUND = 2048,
	WORK_BUSY_PENDING = 1,
	WORK_BUSY_RUNNING = 2,
	WORKER_DESC_LEN = 32,
};

enum writeback_stat_item {
	NR_DIRTY_THRESHOLD = 0,
	NR_DIRTY_BG_THRESHOLD = 1,
	NR_VM_WRITEBACK_STAT_ITEMS = 2,
};

enum writeback_sync_modes {
	WB_SYNC_NONE = 0,
	WB_SYNC_ALL = 1,
};

enum x509_actions {
	ACT_x509_extract_key_data = 0,
	ACT_x509_extract_name_segment = 1,
	ACT_x509_note_OID = 2,
	ACT_x509_note_issuer = 3,
	ACT_x509_note_not_after = 4,
	ACT_x509_note_not_before = 5,
	ACT_x509_note_params = 6,
	ACT_x509_note_serial = 7,
	ACT_x509_note_sig_algo = 8,
	ACT_x509_note_signature = 9,
	ACT_x509_note_subject = 10,
	ACT_x509_note_tbs_certificate = 11,
	ACT_x509_process_extension = 12,
	NR__x509_actions = 13,
};

enum x509_akid_actions {
	ACT_x509_akid_note_kid = 0,
	ACT_x509_akid_note_name = 1,
	ACT_x509_akid_note_serial = 2,
	ACT_x509_extract_name_segment___2 = 3,
	ACT_x509_note_OID___2 = 4,
	NR__x509_akid_actions = 5,
};

enum xa_lock_type {
	XA_LOCK_IRQ = 1,
	XA_LOCK_BH = 2,
};

enum xdp_action {
	XDP_ABORTED = 0,
	XDP_DROP = 1,
	XDP_PASS = 2,
	XDP_TX = 3,
	XDP_REDIRECT = 4,
};

enum xdp_buff_flags {
	XDP_FLAGS_HAS_FRAGS = 1,
	XDP_FLAGS_FRAGS_PF_MEMALLOC = 2,
};

enum xdp_mem_type {
	MEM_TYPE_PAGE_SHARED = 0,
	MEM_TYPE_PAGE_ORDER0 = 1,
	MEM_TYPE_PAGE_POOL = 2,
	MEM_TYPE_XSK_BUFF_POOL = 3,
	MEM_TYPE_MAX = 4,
};

enum xdp_rss_hash_type {
	XDP_RSS_L3_IPV4 = 1,
	XDP_RSS_L3_IPV6 = 2,
	XDP_RSS_L3_DYNHDR = 4,
	XDP_RSS_L4 = 8,
	XDP_RSS_L4_TCP = 16,
	XDP_RSS_L4_UDP = 32,
	XDP_RSS_L4_SCTP = 64,
	XDP_RSS_L4_IPSEC = 128,
	XDP_RSS_L4_ICMP = 256,
	XDP_RSS_TYPE_NONE = 0,
	XDP_RSS_TYPE_L2 = 0,
	XDP_RSS_TYPE_L3_IPV4 = 1,
	XDP_RSS_TYPE_L3_IPV6 = 2,
	XDP_RSS_TYPE_L3_IPV4_OPT = 5,
	XDP_RSS_TYPE_L3_IPV6_EX = 6,
	XDP_RSS_TYPE_L4_ANY = 8,
	XDP_RSS_TYPE_L4_IPV4_TCP = 25,
	XDP_RSS_TYPE_L4_IPV4_UDP = 41,
	XDP_RSS_TYPE_L4_IPV4_SCTP = 73,
	XDP_RSS_TYPE_L4_IPV4_IPSEC = 137,
	XDP_RSS_TYPE_L4_IPV4_ICMP = 265,
	XDP_RSS_TYPE_L4_IPV6_TCP = 26,
	XDP_RSS_TYPE_L4_IPV6_UDP = 42,
	XDP_RSS_TYPE_L4_IPV6_SCTP = 74,
	XDP_RSS_TYPE_L4_IPV6_IPSEC = 138,
	XDP_RSS_TYPE_L4_IPV6_ICMP = 266,
	XDP_RSS_TYPE_L4_IPV6_TCP_EX = 30,
	XDP_RSS_TYPE_L4_IPV6_UDP_EX = 46,
	XDP_RSS_TYPE_L4_IPV6_SCTP_EX = 78,
};

enum xdp_rx_metadata {
	XDP_METADATA_KFUNC_RX_TIMESTAMP = 0,
	XDP_METADATA_KFUNC_RX_HASH = 1,
	XDP_METADATA_KFUNC_RX_VLAN_TAG = 2,
	MAX_XDP_METADATA_KFUNC = 3,
};

enum xen_domain_type {
	XEN_NATIVE = 0,
	XEN_PV_DOMAIN = 1,
	XEN_HVM_DOMAIN = 2,
};

enum xfrm_ae_ftype_t {
	XFRM_AE_UNSPEC = 0,
	XFRM_AE_RTHR = 1,
	XFRM_AE_RVAL = 2,
	XFRM_AE_LVAL = 4,
	XFRM_AE_ETHR = 8,
	XFRM_AE_CR = 16,
	XFRM_AE_CE = 32,
	XFRM_AE_CU = 64,
	__XFRM_AE_MAX = 65,
};

enum xfrm_attr_type_t {
	XFRMA_UNSPEC = 0,
	XFRMA_ALG_AUTH = 1,
	XFRMA_ALG_CRYPT = 2,
	XFRMA_ALG_COMP = 3,
	XFRMA_ENCAP = 4,
	XFRMA_TMPL = 5,
	XFRMA_SA = 6,
	XFRMA_POLICY = 7,
	XFRMA_SEC_CTX = 8,
	XFRMA_LTIME_VAL = 9,
	XFRMA_REPLAY_VAL = 10,
	XFRMA_REPLAY_THRESH = 11,
	XFRMA_ETIMER_THRESH = 12,
	XFRMA_SRCADDR = 13,
	XFRMA_COADDR = 14,
	XFRMA_LASTUSED = 15,
	XFRMA_POLICY_TYPE = 16,
	XFRMA_MIGRATE = 17,
	XFRMA_ALG_AEAD = 18,
	XFRMA_KMADDRESS = 19,
	XFRMA_ALG_AUTH_TRUNC = 20,
	XFRMA_MARK = 21,
	XFRMA_TFCPAD = 22,
	XFRMA_REPLAY_ESN_VAL = 23,
	XFRMA_SA_EXTRA_FLAGS = 24,
	XFRMA_PROTO = 25,
	XFRMA_ADDRESS_FILTER = 26,
	XFRMA_PAD = 27,
	XFRMA_OFFLOAD_DEV = 28,
	XFRMA_SET_MARK = 29,
	XFRMA_SET_MARK_MASK = 30,
	XFRMA_IF_ID = 31,
	XFRMA_MTIMER_THRESH = 32,
	XFRMA_SA_DIR = 33,
	__XFRMA_MAX = 34,
};

enum xfrm_nlgroups {
	XFRMNLGRP_NONE = 0,
	XFRMNLGRP_ACQUIRE = 1,
	XFRMNLGRP_EXPIRE = 2,
	XFRMNLGRP_SA = 3,
	XFRMNLGRP_POLICY = 4,
	XFRMNLGRP_AEVENTS = 5,
	XFRMNLGRP_REPORT = 6,
	XFRMNLGRP_MIGRATE = 7,
	XFRMNLGRP_MAPPING = 8,
	__XFRMNLGRP_MAX = 9,
};

enum xfrm_pol_inexact_candidate_type {
	XFRM_POL_CAND_BOTH = 0,
	XFRM_POL_CAND_SADDR = 1,
	XFRM_POL_CAND_DADDR = 2,
	XFRM_POL_CAND_ANY = 3,
	XFRM_POL_CAND_MAX = 4,
};

enum xfrm_replay_mode {
	XFRM_REPLAY_MODE_LEGACY = 0,
	XFRM_REPLAY_MODE_BMP = 1,
	XFRM_REPLAY_MODE_ESN = 2,
};

enum xfrm_sa_dir {
	XFRM_SA_DIR_IN = 1,
	XFRM_SA_DIR_OUT = 2,
};

enum xprtsec_policies {
	RPC_XPRTSEC_NONE = 0,
	RPC_XPRTSEC_TLS_ANON = 1,
	RPC_XPRTSEC_TLS_X509 = 2,
};

enum xps_map_type {
	XPS_CPUS = 0,
	XPS_RXQS = 1,
	XPS_MAPS_MAX = 2,
};

enum xz_check {
	XZ_CHECK_NONE = 0,
	XZ_CHECK_CRC32 = 1,
	XZ_CHECK_CRC64 = 4,
	XZ_CHECK_SHA256 = 10,
};

enum xz_mode {
	XZ_SINGLE = 0,
	XZ_PREALLOC = 1,
	XZ_DYNALLOC = 2,
};

enum xz_ret {
	XZ_OK = 0,
	XZ_STREAM_END = 1,
	XZ_UNSUPPORTED_CHECK = 2,
	XZ_MEM_ERROR = 3,
	XZ_MEMLIMIT_ERROR = 4,
	XZ_FORMAT_ERROR = 5,
	XZ_OPTIONS_ERROR = 6,
	XZ_DATA_ERROR = 7,
	XZ_BUF_ERROR = 8,
};

enum zbc_zone_alignment_method {
	ZBC_CONSTANT_ZONE_LENGTH = 1,
	ZBC_CONSTANT_ZONE_START_OFFSET = 8,
};

enum zbc_zone_cond {
	ZBC_ZONE_COND_NO_WP = 0,
	ZBC_ZONE_COND_EMPTY = 1,
	ZBC_ZONE_COND_IMP_OPEN = 2,
	ZBC_ZONE_COND_EXP_OPEN = 3,
	ZBC_ZONE_COND_CLOSED = 4,
	ZBC_ZONE_COND_READONLY = 13,
	ZBC_ZONE_COND_FULL = 14,
	ZBC_ZONE_COND_OFFLINE = 15,
};

enum zbc_zone_type {
	ZBC_ZONE_TYPE_CONV = 1,
	ZBC_ZONE_TYPE_SEQWRITE_REQ = 2,
	ZBC_ZONE_TYPE_SEQWRITE_PREF = 3,
	ZBC_ZONE_TYPE_SEQ_OR_BEFORE_REQ = 4,
	ZBC_ZONE_TYPE_GAP = 5,
};

enum zone_flags {
	ZONE_BOOSTED_WATERMARK = 0,
	ZONE_RECLAIM_ACTIVE = 1,
	ZONE_BELOW_HIGH = 2,
};

enum zone_stat_item {
	NR_FREE_PAGES = 0,
	NR_ZONE_LRU_BASE = 1,
	NR_ZONE_INACTIVE_ANON = 1,
	NR_ZONE_ACTIVE_ANON = 2,
	NR_ZONE_INACTIVE_FILE = 3,
	NR_ZONE_ACTIVE_FILE = 4,
	NR_ZONE_UNEVICTABLE = 5,
	NR_ZONE_WRITE_PENDING = 6,
	NR_MLOCK = 7,
	NR_BOUNCE = 8,
	NR_ZSPAGES = 9,
	NR_FREE_CMA_PAGES = 10,
	NR_VM_ZONE_STAT_ITEMS = 11,
};

enum zone_type {
	ZONE_NORMAL = 0,
	ZONE_MOVABLE = 1,
	ZONE_DEVICE = 2,
	__MAX_NR_ZONES = 3,
};

enum zone_watermarks {
	WMARK_MIN = 0,
	WMARK_LOW = 1,
	WMARK_HIGH = 2,
	WMARK_PROMO = 3,
	NR_WMARK = 4,
};

enum zpool_mapmode {
	ZPOOL_MM_RW = 0,
	ZPOOL_MM_RO = 1,
	ZPOOL_MM_WO = 2,
	ZPOOL_MM_DEFAULT = 0,
};

enum zs_mapmode {
	ZS_MM_RW = 0,
	ZS_MM_RO = 1,
	ZS_MM_WO = 2,
};

enum zswap_init_type {
	ZSWAP_UNINIT = 0,
	ZSWAP_INIT_SUCCEED = 1,
	ZSWAP_INIT_FAILED = 2,
};

typedef _Bool bool;

typedef __int128 unsigned __u128;

typedef __u128 u128;

typedef u128 freelist_full_t;

typedef char *__kernel_caddr_t;

typedef __kernel_caddr_t caddr_t;

typedef const char (* const ethnl_string_array_t)[32];

typedef char *va_list;

typedef double elf_fpreg_t;

typedef elf_fpreg_t elf_fpregset_t[33];

typedef elf_fpreg_t elf_vsrreghalf_t32[32];

typedef int TW_Cmd_State;

typedef int __kernel_clockid_t;

typedef int __kernel_daddr_t;

typedef int __kernel_ipc_pid_t;

typedef int __kernel_key_t;

typedef int __kernel_mqd_t;

typedef int __kernel_pid_t;

typedef int __kernel_rwf_t;

typedef int __kernel_timer_t;

typedef int __s32;

typedef __kernel_clockid_t clockid_t;

typedef __s32 s32;

typedef s32 compat_clock_t;

typedef s32 compat_daddr_t;

typedef s32 compat_int_t;

typedef s32 compat_key_t;

typedef s32 compat_long_t;

typedef s32 compat_off_t;

typedef s32 compat_pid_t;

typedef s32 compat_ssize_t;

typedef s32 compat_timer_t;

typedef int cydp_t;

typedef s32 dma_cookie_t;

typedef int ext4_grpblk_t;

typedef int fpb_t;

typedef int fpi_t;

typedef s32 int32_t;

typedef int32_t key_serial_t;

typedef __kernel_key_t key_t;

typedef int mhp_t;

typedef int mpi_size_t;

typedef __kernel_mqd_t mqd_t;

typedef s32 old_time32_t;

typedef int pci_power_t;

typedef __kernel_pid_t pid_t;

typedef int rmap_t;

typedef __kernel_rwf_t rwf_t;

typedef int suspend_state_t;

typedef __kernel_timer_t timer_t;

typedef long int __kernel_long_t;

typedef __kernel_long_t __kernel_clock_t;

typedef __kernel_long_t __kernel_off_t;

typedef __kernel_long_t __kernel_old_time_t;

typedef __kernel_long_t __kernel_ptrdiff_t;

typedef __kernel_long_t __kernel_ssize_t;

typedef __kernel_long_t __kernel_suseconds_t;

typedef __kernel_clock_t clock_t;

typedef long int mpi_limb_signed_t;

typedef __kernel_off_t off_t;

typedef __kernel_ptrdiff_t ptrdiff_t;

typedef __kernel_ssize_t ssize_t;

typedef __kernel_suseconds_t suseconds_t;

typedef long long int __s64;

typedef __s64 Elf64_Sxword;

typedef long long int __kernel_loff_t;

typedef long long int __kernel_time64_t;

typedef __s64 s64;

typedef s64 compat_loff_t;

typedef s64 int64_t;

typedef s64 ktime_t;

typedef __kernel_loff_t loff_t;

typedef long long int qsize_t;

typedef __s64 time64_t;

typedef long long unsigned int __u64;

typedef __u64 Elf64_Addr;

typedef __u64 Elf64_Off;

typedef __u64 Elf64_Xword;

typedef __u64 __le64;

typedef __le64 U64;

typedef __u64 u64;

typedef u64 uint64_t;

typedef uint64_t U64___2;

typedef U64___2 ZSTD_VecMask;

typedef __u64 __addrpair;

typedef __u64 __be64;

typedef __u64 __virtio64;

typedef u64 acpi_io_address;

typedef u64 async_cookie_t;

typedef __u64 binder_size_t;

typedef __u64 binder_uintptr_t;

typedef __le64 bitmap_ulong;

typedef __u64 blist_flags_t;

typedef u64 blkcnt_t;

typedef u64 dma_addr_t;

typedef dma_addr_t bus_dmamap_t;

typedef u64 compat_u64;

typedef long long unsigned int ext4_fsblk_t;

typedef __be64 fdt64_t;

typedef u64 gfn_t;

typedef u64 gpa_t;

typedef u64 io_req_flags_t;

typedef u64 netdev_features_t;

typedef u64 pci_bus_addr_t;

typedef u64 phys_addr_t;

typedef phys_addr_t resource_size_t;

typedef u64 sci_t;

typedef u64 sector_t;

typedef __u64 timeu64_t;

typedef __le64 twa_addr_t;

typedef u64 u_int64_t;

typedef u64 upf_t;

typedef uint64_t vli_type;

typedef u64 wwn_t;

typedef long unsigned int __kernel_ulong_t;

typedef __kernel_ulong_t __kernel_size_t;

typedef __kernel_size_t size_t;

typedef size_t HUF_CElt;

typedef long unsigned int mpi_limb_t;

typedef mpi_limb_t UWtype;

typedef __kernel_ulong_t __kernel_ino_t;

typedef __kernel_ulong_t aio_context_t;

typedef long unsigned int cycles_t;

typedef long unsigned int dax_entry_t;

typedef long unsigned int elf_greg_t64;

typedef elf_greg_t64 elf_gregset_t64[48];

typedef elf_gregset_t64 elf_gregset_t;

typedef long unsigned int gva_t;

typedef __kernel_ulong_t ino_t;

typedef long unsigned int irq_hw_number_t;

typedef long unsigned int kernel_ulong_t;

typedef long unsigned int kimage_entry_t;

typedef long unsigned int mm_context_id_t;

typedef mpi_limb_t *mpi_ptr_t;

typedef long unsigned int netmem_ref;

typedef long unsigned int old_sigset_t;

typedef long unsigned int perf_trace_t[1024];

typedef long unsigned int pte_basic_t;

typedef long unsigned int pte_marker;

typedef long unsigned int uLong;

typedef long unsigned int u_long;

typedef long unsigned int uintptr_t;

typedef long unsigned int ulg;

typedef long unsigned int ulong;

typedef uintptr_t uptrval;

typedef long unsigned int vm_flags_t;

typedef short int __s16;

typedef __s16 s16;

typedef s16 int16_t;

typedef int16_t S16;

typedef s16 compat_nlink_t;

typedef short unsigned int __u16;

typedef __u16 Elf32_Half;

typedef __u16 Elf64_Half;

typedef short unsigned int ush;

typedef ush Pos;

typedef short unsigned int U16;

typedef __u16 __le16;

typedef __le16 U16___2;

typedef __u16 u16;

typedef u16 uint16_t;

typedef uint16_t U16___3;

typedef __u16 __be16;

typedef short unsigned int __kernel_gid16_t;

typedef short unsigned int __kernel_sa_family_t;

typedef short unsigned int __kernel_uid16_t;

typedef __u16 __sum16;

typedef __u16 __virtio16;

typedef __u16 comp_t;

typedef u16 compat_ipc_pid_t;

typedef u16 fw_port_cap16_t;

typedef __kernel_gid16_t gid16_t;

typedef short unsigned int mifi_t;

typedef short unsigned int pci_bus_flags_t;

typedef short unsigned int pci_dev_flags_t;

typedef __u16 port_id;

typedef __kernel_sa_family_t sa_family_t;

typedef u16 u_int16_t;

typedef short unsigned int u_short;

typedef __kernel_uid16_t uid16_t;

typedef short unsigned int umode_t;

typedef short unsigned int ushort;

typedef short unsigned int vifi_t;

typedef u16 wchar_t;

typedef signed char __s8;

typedef __s8 s8;

typedef s8 int8_t;

typedef signed char unative_t[16];

typedef unsigned char __u8;

typedef __u8 u8;

typedef u8 uint8_t;

typedef uint8_t BYTE;

typedef unsigned char Byte;

typedef unsigned char U8;

typedef u8 U8___2;

typedef uint8_t U8___3;

typedef uint8_t ahd_mode_state;

typedef u8 blk_status_t;

typedef unsigned char cc_t;

typedef u8 dscp_t;

typedef __u8 dvd_challenge[10];

typedef __u8 dvd_key[5];

typedef __u8 mctp_eid_t;

typedef u8 rmap_age_t;

typedef unsigned char u8___2;

typedef unsigned char u_char;

typedef u8 u_int8_t;

typedef unsigned char uch;

typedef unsigned char uchar;

typedef const unsigned char utf8leaf_t;

typedef const unsigned char utf8trie_t;

typedef unsigned int __u32;

typedef __u32 u32;

typedef u32 CLST;

typedef __u32 DriverVer_type;

typedef __u32 Elf32_Addr;

typedef __u32 Elf32_Off;

typedef __u32 Elf32_Word;

typedef __u32 Elf64_Word;

typedef unsigned int FSE_CTable;

typedef unsigned int FSE_DTable;

typedef u32 uint32_t;

typedef uint32_t U32;

typedef U32 HUF_DTable;

typedef unsigned int IPos;

typedef __u32 __le32;

typedef __le32 U32___2;

typedef u32 u_int32_t;

typedef u_int32_t U32___3;

typedef unsigned int UHWtype;

typedef __u32 __be32;

typedef u32 __compat_gid32_t;

typedef u32 __compat_gid_t;

typedef u32 __compat_uid32_t;

typedef u32 __compat_uid_t;

typedef u32 __kernel_dev_t;

typedef unsigned int __kernel_gid32_t;

typedef unsigned int __kernel_gid_t;

typedef unsigned int __kernel_mode_t;

typedef unsigned int __kernel_uid32_t;

typedef unsigned int __kernel_uid_t;

typedef unsigned int __poll_t;

typedef __u32 __portpair;

typedef __u32 __virtio32;

typedef __u32 __wsum;

typedef u32 acpi_object_type;

typedef unsigned int blk_insert_t;

typedef unsigned int blk_mode_t;

typedef __u32 blk_mq_req_flags_t;

typedef __u32 blk_opf_t;

typedef unsigned int blk_qc_t;

typedef uint32_t bus_size_t;

typedef __be32 cell_t;

typedef u32 compat_aio_context_t;

typedef u32 compat_caddr_t;

typedef u32 compat_dev_t;

typedef unsigned int elf_greg_t32;

typedef elf_greg_t32 elf_gregset_t32[48];

typedef elf_gregset_t32 compat_elf_gregset_t;

typedef u32 compat_ino_t;

typedef u32 compat_mode_t;

typedef u32 compat_old_sigset_t;

typedef u32 compat_sigset_word;

typedef u32 compat_size_t;

typedef u32 compat_uint_t;

typedef u32 compat_ulong_t;

typedef u32 compat_uptr_t;

typedef u32 depot_flags_t;

typedef u32 depot_stack_handle_t;

typedef __kernel_dev_t dev_t;

typedef uint32_t drbg_flag_t;

typedef u32 errseq_t;

typedef unsigned int ext4_group_t;

typedef __u32 ext4_lblk_t;

typedef __be32 fdt32_t;

typedef unsigned int fgf_t;

typedef unsigned int fmode_t;

typedef unsigned int fop_flags_t;

typedef u32 fw_port_cap32_t;

typedef unsigned int gfp_t;

typedef __kernel_gid32_t gid_t;

typedef __u32 if_mask;

typedef u32 ihandle;

typedef unsigned int ioasid_t;

typedef unsigned int iov_iter_extraction_t;

typedef unsigned int isolate_mode_t;

typedef uint32_t itt_t;

typedef unsigned int kasan_vmalloc_flags_t;

typedef uint32_t key_perm_t;

typedef u32 kprobe_opcode_t;

typedef __kernel_mode_t mode_t;

typedef u32 nlink_t;

typedef u32 note_buf_t[134];

typedef __u32 nvme_submit_flags_t;

typedef unsigned int pci_channel_state_t;

typedef unsigned int pci_ers_result_t;

typedef unsigned int pcie_reset_state_t;

typedef unsigned int pgtbl_mod_mask;

typedef u32 phandle;

typedef u32 pqi_index_t;

typedef __kernel_uid32_t projid_t;

typedef u32 prom_arg_t;

typedef __kernel_uid32_t qid_t;

typedef U32 rankValCol_t[13];

typedef __u32 req_flags_t;

typedef u32 rpc_authflavor_t;

typedef __be32 rtas_arg_t;

typedef uint32_t sense_addr_t;

typedef unsigned int sense_reason_t;

typedef unsigned int sk_buff_data_t;

typedef unsigned int slab_flags_t;

typedef unsigned int speed_t;

typedef u32 ssci_t;

typedef unsigned int t_key;

typedef unsigned int tcflag_t;

typedef unsigned int tid_t;

typedef unsigned int uInt;

typedef unsigned int u_int;

typedef unsigned int uffd_flags_t;

typedef __kernel_uid32_t uid_t;

typedef unsigned int uint;

typedef u32 unicode_t;

typedef u32 uprobe_opcode_t;

typedef unsigned int upstat_t;

typedef unsigned int vm_fault_t;

typedef unsigned int xa_mark_t;

typedef u32 xdp_features_t;

typedef unsigned int zap_flags_t;

typedef struct {
	uint32_t rsvd[3];
	uint32_t abortType;
	uint32_t parm;
	uint16_t abortIoTag;
	uint16_t abortContextTag;
} AC_XRI;

typedef struct {
	uint32_t ring: 2;
	uint32_t rsvd: 30;
} ASYNCEVT_ENABLE_VAR;

typedef struct {
	uint32_t rsvd[4];
	uint32_t param;
	uint16_t sub_ctxt_tag;
	uint16_t evt_code;
} ASYNCSTAT_FIELDS;

typedef struct {
	uint32_t rsvd[3];
	uint32_t abortType;
	uint32_t parm;
	uint32_t iotag32;
} A_MXRI64;

typedef struct {
	size_t bitContainer;
	unsigned int bitPos;
	char *startPtr;
	char *ptr;
	char *endPtr;
} BIT_CStream_t;

typedef struct {
	size_t bitContainer;
	unsigned int bitsConsumed;
	const char *ptr;
	const char *start;
	const char *limitPtr;
} BIT_DStream_t;

struct ulp_bde {
	uint32_t bdeAddress;
	uint32_t bdeSize: 24;
	uint32_t bdeAddrHigh: 4;
	uint32_t bdeReserved: 4;
};

union ULP_BDE_TUS {
	uint32_t w;
	struct {
		uint32_t bdeSize: 24;
		uint32_t bdeFlags: 8;
	} f;
};

struct ulp_bde64 {
	union ULP_BDE_TUS tus;
	uint32_t addrLow;
	uint32_t addrHigh;
};

typedef struct {
	uint32_t rsvd1;
	union {
		struct {
			struct ulp_bde xmit_bde;
			struct ulp_bde rcv_bde;
		} s1;
		struct {
			struct ulp_bde64 xmit_bde64;
			struct ulp_bde64 rcv_bde64;
		} s2;
	} un;
} BIU_DIAG_VAR;

typedef struct {
	uint32_t eventTag;
	uint32_t rsvd1;
} CLEAR_LA_VAR;

typedef struct {
	uint32_t filterEnable: 1;
	uint32_t portName: 1;
	uint32_t nodeName: 1;
	uint32_t IPEnable: 1;
	uint32_t discardFarp: 1;
	uint32_t rsvd: 27;
	uint8_t portname[8];
	uint8_t nodename[8];
	uint32_t rsvd1;
	uint32_t rsvd2;
	uint32_t rsvd3;
	uint32_t IPAddress;
} CONFIG_FARP_VAR;

typedef struct {
	uint32_t MaxBBC: 8;
	uint32_t rsvd1: 8;
	uint32_t cr_count: 8;
	uint32_t cr_delay: 6;
	uint32_t ci: 1;
	uint32_t cr: 1;
	uint32_t myId;
	uint32_t rsvd2;
	uint32_t edtov;
	uint32_t arbtov;
	uint32_t ratov;
	uint32_t rttov;
	uint32_t altov;
	uint32_t crtov;
	uint32_t rsvd3: 8;
	uint32_t bbscn: 4;
	uint32_t cscn: 1;
	uint32_t rsvd4: 19;
	uint32_t ack0_enable: 1;
	uint32_t rsvd5: 29;
	uint32_t rrq_immed: 1;
	uint32_t rrq_enable: 1;
} CONFIG_LINK;

typedef struct {
	uint32_t pcbLen: 24;
	uint32_t sli_mode: 4;
	uint32_t cMA: 1;
	uint32_t cHpcb: 1;
	uint32_t cET: 1;
	uint32_t cBE: 1;
	uint32_t pcbLow;
	uint32_t pcbHigh;
	uint32_t hbainit[5];
	uint32_t rsvd: 31;
	uint32_t hps: 1;
	uint32_t cmr: 1;
	uint32_t cmx: 1;
	uint32_t cerbm: 1;
	uint32_t cinb: 1;
	uint32_t chbs: 1;
	uint32_t csah: 1;
	uint32_t ccrp: 1;
	uint32_t cmv: 1;
	uint32_t cbg: 1;
	uint32_t rsvd2: 2;
	uint32_t casabt: 1;
	uint32_t rsvd1: 20;
	uint32_t gmr: 1;
	uint32_t gmx: 1;
	uint32_t gerbm: 1;
	uint32_t ginb: 1;
	uint32_t ghbs: 1;
	uint32_t gsah: 1;
	uint32_t gcrp: 1;
	uint32_t gmv: 1;
	uint32_t gbg: 1;
	uint32_t rsvd4: 2;
	uint32_t gasabt: 1;
	uint32_t rsvd3: 20;
	uint32_t max_xri: 16;
	uint32_t max_rpi: 16;
	uint32_t rsvd5: 16;
	uint32_t max_hbq: 16;
	uint32_t rsvd6;
	uint32_t max_vpi: 16;
	uint32_t rsvd7: 16;
} CONFIG_PORT_VAR;

typedef struct {
	uint8_t rmask;
	uint8_t rval;
	uint8_t tmask;
	uint8_t tval;
} RR_REG;

typedef struct {
	uint32_t ring: 4;
	uint32_t unused1: 4;
	uint32_t profile: 8;
	uint32_t numMask: 8;
	uint32_t recvNotify: 1;
	uint32_t recvSeq: 1;
	uint32_t unused2: 6;
	uint16_t maxOrigXchg;
	uint16_t maxRespXchg;
	RR_REG rrRegs[6];
} CONFIG_RING_VAR;

typedef struct {
	uint32_t rsvd1;
} DOWN_LINK_VAR;

typedef struct {
	BYTE maxTableLog;
	BYTE tableType;
	BYTE tableLog;
	BYTE reserved;
} DTableDesc;

typedef struct {
	uint32_t type: 4;
	uint32_t cv: 1;
	uint32_t co: 1;
	uint32_t ra: 1;
	uint32_t rsvd: 25;
	uint32_t region_id: 16;
	uint32_t entry_index: 16;
	uint32_t sli4_length;
	uint32_t word_cnt;
	uint32_t resp_offset;
} DUMP_VAR;

struct ULP_BDL {
	uint32_t bdeSize: 24;
	uint32_t bdeFlags: 8;
	uint32_t addrLow;
	uint32_t addrHigh;
	uint32_t ulpIoTag32;
};

typedef struct ULP_BDL ULP_BDL;

typedef struct {
	ULP_BDL bdl;
	uint32_t myID: 24;
	uint32_t fl: 1;
	uint32_t word4Rsvd: 7;
	uint32_t remoteID: 24;
	uint32_t word5Rsvd: 8;
} ELS_REQUEST64;

typedef struct {
	struct ulp_bde fcpi_cmnd;
	struct ulp_bde fcpi_rsp;
	uint32_t fcpi_parm;
	uint32_t fcpi_XRdy;
} FCPI_FIELDS;

typedef struct {
	ULP_BDL bdl;
	uint32_t fcpi_parm;
	uint32_t fcpi_XRdy;
} FCPI_FIELDS64;

typedef struct {
	struct ulp_bde fcpt_Buffer[2];
	uint32_t fcpt_Offset;
	uint32_t fcpt_Length;
} FCPT_FIELDS;

typedef struct {
	ULP_BDL bdl;
	uint32_t fcpt_Offset;
	uint32_t fcpt_Length;
} FCPT_FIELDS64;

typedef struct {
	ptrdiff_t value;
	const void *stateTable;
	const void *symbolTT;
	unsigned int stateLog;
} FSE_CState_t;

typedef struct {
	size_t state;
	const void *table;
} FSE_DState_t;

typedef struct {
	U16___3 tableLog;
	U16___3 fastMode;
} FSE_DTableHeader;

typedef struct {
	short int ncount[256];
	FSE_DTable dtable[0];
} FSE_DecompressWksp;

typedef struct {
	short unsigned int newState;
	unsigned char symbol;
	unsigned char nbBits;
} FSE_decode_t;

typedef struct {
	int deltaFindState;
	U32 deltaNbBits;
} FSE_symbolCompressionTransform;

typedef struct {
	uint8_t statLocalError;
	uint8_t statBaExp;
	uint8_t statRsn;
	uint8_t statAction;
} PARM_ERR;

typedef struct {
	uint32_t reserved[4];
	PARM_ERR perr;
} GENERIC_RSP;

typedef union {
	struct {
		uint8_t Fctl;
		uint8_t Dfctl;
		uint8_t Type;
		uint8_t Rctl;
	} hcsw;
	uint32_t reserved;
} WORD5;

typedef struct {
	ULP_BDL bdl;
	uint32_t xrsqRo;
	WORD5 w5;
} GEN_REQUEST64;

typedef struct {
	uint32_t rsvd[4];
	uint32_t parmRo;
	uint32_t remoteID: 24;
	uint32_t word5Rsvd: 8;
} GET_RPI;

typedef struct {
	size_t bitContainer[2];
	size_t bitPos[2];
	BYTE *startPtr;
	BYTE *ptr;
	BYTE *endPtr;
} HUF_CStream_t;

typedef struct {
	FSE_CTable CTable[59];
	U32 scratchBuffer[41];
	unsigned int count[13];
	S16 norm[13];
} HUF_CompressWeightsWksp;

typedef struct {
	BYTE nbBits;
	BYTE byte;
} HUF_DEltX1;

typedef struct {
	U16___3 sequence;
	BYTE nbBits;
	BYTE length;
} HUF_DEltX2;

typedef struct {
	U32 rankVal[13];
	U32 rankStart[13];
	U32 statsWksp[218];
	BYTE symbols[256];
	BYTE huffWeight[256];
} HUF_ReadDTableX1_Workspace;

typedef struct {
	BYTE symbol;
} sortedSymbol_t;

typedef struct {
	U32 rankVal[156];
	U32 rankStats[13];
	U32 rankStart0[15];
	sortedSymbol_t sortedSymbol[256];
	BYTE weightList[256];
	U32 calleeWksp[218];
} HUF_ReadDTableX2_Workspace;

typedef struct {
	HUF_CompressWeightsWksp wksp;
	BYTE bitsToWeight[13];
	BYTE huffWeight[255];
} HUF_WriteCTableWksp;

struct nodeElt_s {
	U32 count;
	U16___3 parent;
	BYTE byte;
	BYTE nbBits;
};

typedef struct nodeElt_s nodeElt;

typedef nodeElt huffNodeTable[512];

typedef struct {
	U16___3 base;
	U16___3 curr;
} rankPos;

typedef struct {
	huffNodeTable huffNodeTbl;
	rankPos rankPosition[192];
} HUF_buildCTable_wksp_tables;

typedef struct {
	unsigned int count[256];
	HUF_CElt CTable[257];
	union {
		HUF_buildCTable_wksp_tables buildCTable_wksp;
		HUF_WriteCTableWksp writeCTable_wksp;
		U32 hist_wksp[1024];
	} wksps;
} HUF_compress_tables_t;

typedef struct {
	uint32_t lipsr_AL_PA: 8;
	uint32_t rsvd1: 24;
	uint16_t link_flags;
	uint8_t rsvd2;
	uint8_t fabric_AL_PA;
	uint32_t link_speed;
} INIT_LINK_VAR;

typedef union {
	struct {
		volatile uint8_t reserved;
		volatile uint8_t command_id;
		volatile uint8_t basic_status;
		volatile uint8_t extended_status;
	} fields;
	volatile uint32_t value;
} IPS_STATUS;

typedef union {
	struct {
		volatile uint8_t reserved;
		volatile uint8_t command_id;
		volatile uint8_t basic_status;
		volatile uint8_t extended_status;
	} fields;
	volatile uint32_t value;
} *PIPS_STATUS;

typedef struct {
	IPS_STATUS status[129];
	volatile PIPS_STATUS p_status_start;
	volatile PIPS_STATUS p_status_end;
	volatile PIPS_STATUS p_status_tail;
	volatile uint32_t hw_status_start;
	volatile uint32_t hw_status_tail;
} IPS_ADAPTER;

typedef struct {
	uint8_t ucChn;
	uint8_t ucTgt;
	uint16_t ucReserved;
	uint32_t ulStartSect;
	uint32_t ulNoOfSects;
} IPS_CHUNK;

typedef struct {
	uint8_t board_disc[8];
	uint8_t processor[8];
	uint8_t ucNoChanType;
	uint8_t ucNoHostIntType;
	uint8_t ucCompression;
	uint8_t ucNvramType;
	uint32_t ulNvramSize;
} IPS_HARDWARE;

typedef struct {
	uint16_t ucUserField;
	uint8_t ucState;
	uint8_t ucRaidCacheParam;
	uint8_t ucNoOfChunkUnits;
	uint8_t ucStripeSize;
	uint8_t ucParams;
	uint8_t ucReserved;
	uint32_t ulLogDrvSize;
	IPS_CHUNK chunk[16];
} IPS_LD;

typedef struct {
	uint8_t ucInitiator;
	uint8_t ucParameters;
	uint8_t ucMiscFlag;
	uint8_t ucState;
	uint32_t ulBlockCount;
	uint8_t ucDeviceId[28];
} IPS_DEVSTATE;

typedef struct {
	uint8_t ucLogDriveCount;
	uint8_t ucDateD;
	uint8_t ucDateM;
	uint8_t ucDateY;
	uint8_t init_id[4];
	uint8_t host_id[12];
	uint8_t time_sign[8];
	uint32_t UserOpt;
	uint16_t user_field;
	uint8_t ucRebuildRate;
	uint8_t ucReserve;
	IPS_HARDWARE hardware_disc;
	IPS_LD logical_drive[8];
	IPS_DEVSTATE dev[64];
	uint8_t reserved[512];
} IPS_CONF;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint8_t channel;
	uint8_t source_target;
	uint32_t reserved;
	uint32_t reserved2;
	uint32_t reserved3;
	uint32_t ccsar;
	uint32_t cccr;
} IPS_CS_CMD;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint16_t reserved;
	uint32_t reserved2;
	uint32_t dcdb_address;
	uint16_t reserved3;
	uint8_t segment_4G;
	uint8_t enhanced_sg;
	uint32_t ccsar;
	uint32_t cccr;
} IPS_DCDB_CMD;

typedef struct {
	uint8_t device_address;
	uint8_t cmd_attribute;
	uint16_t transfer_length;
	uint32_t buffer_pointer;
	uint8_t cdb_length;
	uint8_t sense_length;
	uint8_t sg_count;
	uint8_t reserved;
	uint8_t scsi_cdb[12];
	uint8_t sense_info[64];
	uint8_t scsi_status;
	uint8_t reserved2[3];
} IPS_DCDB_TABLE;

typedef struct {
	uint8_t device_address;
	uint8_t cmd_attribute;
	uint8_t cdb_length;
	uint8_t reserved_for_LUN;
	uint32_t transfer_length;
	uint32_t buffer_pointer;
	uint16_t sg_count;
	uint8_t sense_length;
	uint8_t scsi_status;
	uint32_t reserved;
	uint8_t scsi_cdb[16];
	uint8_t sense_info[56];
} IPS_DCDB_TABLE_TAPE;

typedef struct {
	uint8_t logical_id;
	uint8_t reserved;
	uint8_t raid_level;
	uint8_t state;
	uint32_t sector_count;
} IPS_DRIVE_INFO;

typedef struct {
	uint8_t ucLogDriveCount;
	uint8_t ucMiscFlag;
	uint8_t ucSLTFlag;
	uint8_t ucBSTFlag;
	uint8_t ucPwrChgCnt;
	uint8_t ucWrongAdrCnt;
	uint8_t ucUnidentCnt;
	uint8_t ucNVramDevChgCnt;
	uint8_t CodeBlkVersion[8];
	uint8_t BootBlkVersion[8];
	uint32_t ulDriveSize[8];
	uint8_t ucConcurrentCmdCount;
	uint8_t ucMaxPhysicalDevices;
	uint16_t usFlashRepgmCount;
	uint8_t ucDefunctDiskCount;
	uint8_t ucRebuildFlag;
	uint8_t ucOfflineLogDrvCount;
	uint8_t ucCriticalDrvCount;
	uint16_t usConfigUpdateCount;
	uint8_t ucBlkFlag;
	uint8_t reserved;
	uint16_t usAddrDeadDisk[64];
} IPS_ENQ;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint8_t reserved;
	uint8_t state;
	uint32_t reserved2;
	uint32_t reserved3;
	uint32_t reserved4;
	uint32_t ccsar;
	uint32_t cccr;
} IPS_FC_CMD;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint8_t reset_count;
	uint8_t reset_type;
	uint8_t second;
	uint8_t minute;
	uint8_t hour;
	uint8_t day;
	uint8_t reserved1[4];
	uint8_t month;
	uint8_t yearH;
	uint8_t yearL;
	uint8_t reserved2;
} IPS_FFDC_CMD;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint8_t type;
	uint8_t direction;
	uint32_t count;
	uint32_t buffer_addr;
	uint32_t offset;
} IPS_FLASHBIOS_CMD;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint8_t type;
	uint8_t direction;
	uint32_t count;
	uint32_t buffer_addr;
	uint8_t total_packets;
	uint8_t packet_num;
	uint16_t reserved;
} IPS_FLASHFW_CMD;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint8_t log_drv;
	uint8_t sg_count;
	uint32_t lba;
	uint32_t sg_addr;
	uint16_t sector_count;
	uint8_t segment_4G;
	uint8_t enhanced_sg;
	uint32_t ccsar;
	uint32_t cccr;
} IPS_IO_CMD;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint16_t reserved;
	uint32_t reserved2;
	uint32_t buffer_addr;
	uint32_t reserved3;
	uint32_t ccsar;
	uint32_t cccr;
} IPS_LD_CMD;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint8_t reserved;
	uint8_t reserved2;
	uint32_t reserved3;
	uint32_t buffer_addr;
	uint32_t reserved4;
} IPS_IOCTL_CMD;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint8_t log_drv;
	uint8_t control;
	uint32_t reserved;
	uint32_t reserved2;
	uint32_t reserved3;
	uint32_t ccsar;
	uint32_t cccr;
} IPS_US_CMD;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint8_t reserved;
	uint8_t desc;
	uint32_t reserved2;
	uint32_t buffer_addr;
	uint32_t reserved3;
	uint32_t ccsar;
	uint32_t cccr;
} IPS_STATUS_CMD;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint8_t page;
	uint8_t write;
	uint32_t reserved;
	uint32_t buffer_addr;
	uint32_t reserved2;
	uint32_t ccsar;
	uint32_t cccr;
} IPS_NVRAM_CMD;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint16_t reserved;
	uint32_t count;
	uint32_t buffer_addr;
	uint32_t reserved2;
} IPS_VERSION_INFO;

typedef struct {
	uint8_t op_code;
	uint8_t command_id;
	uint8_t channel;
	uint8_t reserved3;
	uint8_t reserved4;
	uint8_t reserved5;
	uint8_t reserved6;
	uint8_t reserved7;
	uint8_t reserved8;
	uint8_t reserved9;
	uint8_t reserved10;
	uint8_t reserved11;
	uint8_t reserved12;
	uint8_t reserved13;
	uint8_t reserved14;
	uint8_t adapter_flag;
} IPS_RESET_CMD;

typedef union {
	IPS_IO_CMD basic_io;
	IPS_LD_CMD logical_info;
	IPS_IOCTL_CMD ioctl_info;
	IPS_DCDB_CMD dcdb;
	IPS_CS_CMD config_sync;
	IPS_US_CMD unlock_stripe;
	IPS_FC_CMD flush_cache;
	IPS_STATUS_CMD status;
	IPS_NVRAM_CMD nvram;
	IPS_FFDC_CMD ffdc;
	IPS_FLASHFW_CMD flashfw;
	IPS_FLASHBIOS_CMD flashbios;
	IPS_VERSION_INFO version_info;
	IPS_RESET_CMD reset;
} IPS_HOST_COMMAND;

typedef struct {
	uint8_t no_of_log_drive;
	uint8_t reserved[3];
	IPS_DRIVE_INFO drive_info[8];
} IPS_LD_INFO;

typedef struct {
	uint32_t signature;
	uint8_t reserved1;
	uint8_t adapter_slot;
	uint16_t adapter_type;
	uint8_t ctrl_bios[8];
	uint8_t versioning;
	uint8_t version_mismatch;
	uint8_t reserved2;
	uint8_t operating_system;
	uint8_t driver_high[4];
	uint8_t driver_low[4];
	uint8_t BiosCompatibilityID[8];
	uint8_t ReservedForOS2[8];
	uint8_t bios_high[4];
	uint8_t bios_low[4];
	uint8_t adapter_order[16];
	uint8_t Filler[60];
} IPS_NVRAM_P5;

typedef struct {
	char *option_name;
	int *option_flag;
	int option_value;
} IPS_OPTION;

typedef struct {
	uint32_t lba;
	uint32_t len;
} IPS_SCSI_CAPACITY;

typedef struct {
	uint8_t DeviceType;
	uint8_t DeviceTypeQualifier;
	uint8_t Version;
	uint8_t ResponseDataFormat;
	uint8_t AdditionalLength;
	uint8_t Reserved;
	uint8_t Flags[2];
	uint8_t VendorId[8];
	uint8_t ProductId[16];
	uint8_t ProductRevisionLevel[4];
	uint8_t Reserved2;
} IPS_SCSI_INQ_DATA;

typedef struct {
	uint8_t PageCode;
	uint8_t PageLength;
	uint16_t TracksPerZone;
	uint16_t AltSectorsPerZone;
	uint16_t AltTracksPerZone;
	uint16_t AltTracksPerVolume;
	uint16_t SectorsPerTrack;
	uint16_t BytesPerSector;
	uint16_t Interleave;
	uint16_t TrackSkew;
	uint16_t CylinderSkew;
	uint8_t flags;
	uint8_t reserved[3];
} IPS_SCSI_MODE_PAGE3;

typedef struct {
	uint8_t PageCode;
	uint8_t PageLength;
	uint16_t CylindersHigh;
	uint8_t CylindersLow;
	uint8_t Heads;
	uint16_t WritePrecompHigh;
	uint8_t WritePrecompLow;
	uint16_t ReducedWriteCurrentHigh;
	uint8_t ReducedWriteCurrentLow;
	uint16_t StepRate;
	uint16_t LandingZoneHigh;
	uint8_t LandingZoneLow;
	uint8_t flags;
	uint8_t RotationalOffset;
	uint8_t Reserved;
	uint16_t MediumRotationRate;
	uint8_t Reserved2[2];
} IPS_SCSI_MODE_PAGE4;

typedef struct {
	uint8_t PageCode;
	uint8_t PageLength;
	uint8_t flags;
	uint8_t RetentPrio;
	uint16_t DisPrefetchLen;
	uint16_t MinPrefetchLen;
	uint16_t MaxPrefetchLen;
	uint16_t MaxPrefetchCeiling;
} IPS_SCSI_MODE_PAGE8;

typedef struct {
	uint32_t NumberOfBlocks;
	uint8_t DensityCode;
	uint16_t BlockLengthHigh;
	uint8_t BlockLengthLow;
} IPS_SCSI_MODE_PAGE_BLKDESC;

typedef struct {
	uint8_t DataLength;
	uint8_t MediumType;
	uint8_t Reserved;
	uint8_t BlockDescLength;
} IPS_SCSI_MODE_PAGE_HEADER;

typedef struct {
	IPS_SCSI_MODE_PAGE_HEADER hdr;
	IPS_SCSI_MODE_PAGE_BLKDESC blkdesc;
	union {
		IPS_SCSI_MODE_PAGE3 pg3;
		IPS_SCSI_MODE_PAGE4 pg4;
		IPS_SCSI_MODE_PAGE8 pg8;
	} pdata;
} IPS_SCSI_MODE_PAGE_DATA;

typedef struct {
	uint8_t ResponseCode;
	uint8_t SegmentNumber;
	uint8_t Flags;
	uint8_t Information[4];
	uint8_t AdditionalLength;
	uint8_t CommandSpecific[4];
	uint8_t AdditionalSenseCode;
	uint8_t AdditionalSenseCodeQual;
	uint8_t FRUCode;
	uint8_t SenseKeySpecific[3];
} IPS_SCSI_REQSEN;

struct ips_sglist;

typedef struct ips_sglist IPS_STD_SG_LIST;

struct ips_enh_sglist;

typedef struct ips_enh_sglist IPS_ENH_SG_LIST;

typedef union {
	void *list;
	IPS_STD_SG_LIST *std_list;
	IPS_ENH_SG_LIST *enh_list;
} IPS_SG_LIST;

struct buffer_head;

typedef struct {
	__le32 *p;
	__le32 key;
	struct buffer_head *bh;
} Indirect;

typedef struct {
	uint32_t load_cmplt: 1;
	uint32_t method: 1;
	uint32_t update_ram: 1;
	uint32_t update_flash: 1;
	uint32_t erase_or_prog: 1;
	uint32_t version: 1;
	uint32_t acknowledgment: 1;
	uint32_t rsvd2: 25;
	uint32_t dl_to_adr_low;
	uint32_t dl_to_adr_high;
	uint32_t dl_len;
	union {
		uint32_t dl_from_mbx_offset;
		struct ulp_bde dl_from_bde;
		struct ulp_bde64 dl_from_bde64;
	} un;
} LOAD_SM_VAR;

typedef struct {
	unsigned int hashTable[32768];
	short unsigned int chainTable[65536];
	const unsigned char *end;
	const unsigned char *base;
	const unsigned char *dictBase;
	unsigned int dictLimit;
	unsigned int lowLimit;
	unsigned int nextToUpdate;
	unsigned int compressionLevel;
} LZ4HC_CCtx_internal;

typedef struct {
	const uint8_t *externalDict;
	size_t extDictSize;
	const uint8_t *prefixEnd;
	size_t prefixSize;
} LZ4_streamDecode_t_internal;

typedef union {
	long long unsigned int table[4];
	LZ4_streamDecode_t_internal internal_donotuse;
} LZ4_streamDecode_t;

typedef union {
	size_t table[32774];
	LZ4HC_CCtx_internal internal_donotuse;
} LZ4_streamHC_t;

typedef struct {
	uint32_t hashTable[4096];
	uint32_t currentOffset;
	uint32_t initCheck;
	const uint8_t *dictionary;
	uint8_t *bufferStart;
	uint32_t dictSize;
} LZ4_stream_t_internal;

typedef union {
	long long unsigned int table[2052];
	LZ4_stream_t_internal internal_donotuse;
} LZ4_stream_t;

struct MAILBOX_word0 {
	union {
		struct {
			uint8_t mbxOwner: 1;
			uint8_t mbxHc: 1;
			uint8_t mbxReserved: 6;
			uint8_t mbxCommand;
			uint16_t mbxStatus;
		};
		u32 word0;
	};
};

typedef struct {
	uint32_t rsvd1[3];
	uint32_t rsvd2;
	uint32_t portname[2];
	uint32_t nodename[2];
	uint32_t hardAL_PA: 8;
	uint32_t pref_DID: 24;
	uint32_t rsvd3[21];
} READ_NV_VAR;

typedef struct {
	uint32_t rsvd1[3];
	uint32_t rsvd2;
	uint32_t portname[2];
	uint32_t nodename[2];
	uint32_t hardAL_PA: 8;
	uint32_t pref_DID: 24;
	uint32_t rsvd3[21];
} WRITE_NV_VAR;

typedef struct {
	uint16_t numCiocb;
	uint16_t offCiocb;
	uint16_t numRiocb;
	uint16_t offRiocb;
} RING_DEF;

typedef struct {
	uint32_t numRing: 8;
	uint32_t unused1: 24;
	RING_DEF ringdef[4];
	uint32_t hbainit;
} PART_SLIM_VAR;

typedef struct {
	uint32_t ring_no;
} RESET_RING_VAR;

typedef struct {
	uint32_t MaxBBC: 8;
	uint32_t InitBBC: 8;
	uint32_t cr_count: 8;
	uint32_t cr_delay: 6;
	uint32_t ci: 1;
	uint32_t cr: 1;
	uint32_t myDid: 24;
	uint32_t topology: 8;
	uint32_t ack0: 1;
	uint32_t rsvd1: 29;
	uint32_t IR: 1;
	uint32_t AR: 1;
	uint32_t edtov;
	uint32_t arbtov;
	uint32_t ratov;
	uint32_t rttov;
	uint32_t altov;
	uint32_t lmt;
	uint32_t rsvd2;
	uint32_t rsvd3;
	uint32_t max_xri;
	uint32_t max_iocb;
	uint32_t max_rpi;
	uint32_t avail_xri;
	uint32_t avail_iocb;
	uint32_t avail_rpi;
	uint32_t max_vpi;
	uint32_t rsvd4;
	uint32_t rsvd5;
	uint32_t avail_vpi;
} READ_CONFIG_VAR;

typedef struct {
	uint32_t ring: 4;
	uint32_t rsvd1: 4;
	uint32_t profile: 8;
	uint32_t numMask: 8;
	uint32_t recvNotify: 1;
	uint32_t rsvd2: 7;
	uint16_t maxOrig;
	uint16_t maxResp;
	RR_REG rrRegs[6];
	uint16_t cmdEntryCnt;
	uint16_t cmdRingOffset;
	uint16_t rspEntryCnt;
	uint16_t rspRingOffset;
	uint16_t rsvd3;
	uint16_t nextCmdOffset;
	uint16_t rsvd4;
	uint16_t nextRspOffset;
} READ_RCONF_VAR;

typedef struct {
	uint32_t rsvd1;
	uint32_t rsvd2;
	union {
		struct ulp_bde sp;
		struct ulp_bde64 sp64;
	} un;
	uint16_t vpi;
	uint16_t rsvd3;
} READ_SPARM_VAR;

typedef struct {
	u8 clear_counters;
	u8 rsvd5;
	u8 rsvd6;
	u8 xkb;
	u32 rsvd8;
	uint32_t xmitByteCnt;
	uint32_t rcvByteCnt;
	uint32_t xmitFrameCnt;
	uint32_t rcvFrameCnt;
	uint32_t xmitSeqCnt;
	uint32_t rcvSeqCnt;
	uint32_t totalOrigExchanges;
	uint32_t totalRespExchanges;
	uint32_t rcvPbsyCnt;
	uint32_t rcvFbsyCnt;
	u32 drop_frame_no_rq;
	u32 empty_rq;
	u32 drop_frame_no_xri;
	u32 empty_xri;
	u32 xmit_xkb;
	u32 rcv_xkb;
} READ_STATUS_VAR;

typedef struct {
	uint16_t reqRpi;
	uint16_t nextRpi;
	uint32_t DID: 24;
	uint32_t rsvd2: 8;
	union {
		struct ulp_bde sp;
		struct ulp_bde64 sp64;
	} un;
} READ_RPI_VAR;

typedef struct {
	uint16_t reqXri;
	uint16_t nextXri;
	uint16_t rpi;
	uint16_t rsvd1;
	uint32_t DID: 24;
	uint32_t rsvd2: 8;
	uint32_t SID: 24;
	uint32_t rsvd3: 8;
	uint32_t rsvd4;
	uint16_t seqCount;
	uint8_t rsvd5;
	uint8_t seqId;
	uint16_t rxId;
	uint16_t oxId;
	uint32_t exchOrig: 1;
	uint32_t si: 1;
	uint32_t rsvd6: 30;
} READ_XRI_VAR;

typedef struct {
	uint32_t rv: 1;
	uint32_t rsvd1: 25;
	uint32_t v3rsp: 1;
	uint32_t v3req: 1;
	uint32_t rsvd2: 2;
	uint32_t rr: 1;
	uint32_t cv: 1;
	uint32_t biuRev;
	uint32_t smRev;
	union {
		uint32_t smFwRev;
		struct {
			uint16_t DistCnt: 4;
			uint16_t ProgDistType: 2;
			uint16_t ProgFixLvl: 2;
			uint16_t ProgRev: 4;
			uint16_t ProgVer: 4;
			uint8_t ProgId;
			uint8_t ProgType;
		} b;
	} un;
	uint32_t endecRev;
	uint8_t fcphLow;
	uint8_t fcphHigh;
	uint8_t feaLevelLow;
	uint8_t feaLevelHigh;
	uint32_t postKernRev;
	uint32_t opFwRev;
	uint8_t opFwName[16];
	uint32_t sli1FwRev;
	uint8_t sli1FwName[16];
	uint32_t sli2FwRev;
	uint8_t sli2FwName[16];
	uint32_t sli3Feat;
	uint32_t RandomData[6];
} READ_REV_VAR;

typedef struct {
	uint32_t word0;
	uint32_t linkFailureCnt;
	uint32_t lossSyncCnt;
	uint32_t lossSignalCnt;
	uint32_t primSeqErrCnt;
	uint32_t invalidXmitWord;
	uint32_t crcCnt;
	uint32_t primSeqTimeout;
	uint32_t elasticOverrun;
	uint32_t arbTimeout;
	uint32_t advRecBufCredit;
	uint32_t curRecBufCredit;
	uint32_t advTransBufCredit;
	uint32_t curTransBufCredit;
	uint32_t recEofCount;
	uint32_t recEofdtiCount;
	uint32_t recEofniCount;
	uint32_t recSofcount;
	uint32_t rsvd1;
	uint32_t rsvd2;
	uint32_t recDrpXriCount;
	uint32_t fecCorrBlkCount;
	uint32_t fecUncorrBlkCount;
} READ_LNK_VAR;

typedef struct {
	uint16_t rpi;
	uint16_t rsvd1;
	uint32_t did: 24;
	uint32_t rsvd2: 8;
	union {
		struct ulp_bde sp;
		struct ulp_bde64 sp64;
	} un;
	uint16_t vpi;
	uint16_t rsvd6;
} REG_LOGIN_VAR;

typedef struct {
	uint16_t rpi;
	uint16_t rsvd1;
	uint32_t rsvd2;
	uint32_t rsvd3;
	uint32_t rsvd4;
	uint32_t rsvd5;
	uint16_t vpi;
	uint16_t rsvd6;
} UNREG_LOGIN_VAR;

typedef struct {
	uint32_t did;
	uint32_t rsvd2;
	uint32_t rsvd3;
	uint32_t rsvd4;
	uint32_t rsvd5;
	uint16_t vpi;
	uint16_t rsvd6;
} UNREG_D_ID_VAR;

struct hbq_mask {
	uint8_t rctlmask;
	uint8_t rctlmatch;
	uint8_t tmask;
	uint8_t tmatch;
};

struct config_hbq_var {
	uint32_t rsvd2: 8;
	uint32_t profile: 8;
	uint32_t numMask: 8;
	uint32_t recvNotify: 1;
	uint32_t rsvd1: 7;
	uint32_t ringMask: 4;
	uint32_t rsvd3: 12;
	uint32_t hbqId: 16;
	uint32_t headerLen: 8;
	uint32_t rsvd4: 8;
	uint32_t entry_count: 16;
	uint32_t hbqaddrLow;
	uint32_t hbqaddrHigh;
	uint32_t logEntry: 1;
	uint32_t rsvd5: 31;
	uint32_t rsvd6;
	uint32_t rsvd7;
	uint32_t rsvd8;
	struct hbq_mask hbqMasks[6];
	union {
		uint32_t allprofiles[12];
		struct {
			uint32_t maxlen: 16;
			uint32_t seqlenoff: 16;
			uint32_t seqlenbcnt: 4;
			uint32_t rsvd1: 28;
			uint32_t rsvd[10];
		} profile2;
		struct {
			uint32_t maxlen: 16;
			uint32_t seqlenoff: 16;
			uint32_t seqlenbcnt: 4;
			uint32_t rsvd1: 12;
			long: 16;
			uint32_t cmdcodeoff: 28;
			uint32_t cmdmatch[8];
			uint32_t rsvd[2];
		} profile3;
		struct {
			uint32_t maxlen: 16;
			uint32_t seqlenoff: 16;
			uint32_t seqlenbcnt: 4;
			uint32_t rsvd1: 12;
			long: 16;
			uint32_t cmdcodeoff: 28;
			uint32_t cmdmatch[8];
			uint32_t rsvd[2];
		} profile5;
	} profiles;
};

struct update_cfg_var {
	uint32_t req: 4;
	uint32_t cv: 1;
	uint32_t co: 1;
	uint32_t ra: 1;
	uint32_t rsvd: 1;
	uint32_t type: 8;
	uint32_t rsvd2: 16;
	uint32_t region_id: 16;
	uint32_t entry_length: 16;
	uint32_t resp_info;
	uint32_t byte_cnt;
	uint32_t data_offset;
};

struct lpfc_mbx_read_top {
	uint32_t eventTag;
	uint32_t word2;
	uint32_t word3;
	struct ulp_bde64 lilpBde64;
	uint32_t word7;
	uint32_t word8;
};

typedef struct {
	uint32_t rsvd1;
	uint32_t sid: 24;
	uint32_t upd: 1;
	uint32_t rsvd2: 7;
	uint32_t wwn[2];
	uint32_t rsvd5;
	uint16_t vpi;
	uint16_t vfi;
} REG_VPI_VAR;

typedef struct {
	uint32_t rsvd1;
	uint16_t sli4_vpi;
	uint16_t rsvd2;
	uint32_t rsvd3;
	uint32_t rsvd4;
	uint32_t rsvd5;
	uint16_t vpi;
	uint16_t rsvd6;
} UNREG_VPI_VAR;

struct READ_EVENT_LOG_VAR {
	uint32_t word1;
	uint32_t offset;
	struct ulp_bde64 rcv_bde64;
};

struct config_msi_var {
	uint32_t reportFlag: 1;
	uint32_t addFlag: 1;
	uint32_t dfltPresent: 1;
	uint32_t rsvd2: 5;
	uint32_t NID: 5;
	uint32_t rsvd1: 11;
	uint32_t dfltMsgNum: 8;
	uint32_t attentionConditions[2];
	uint8_t attentionId[16];
	uint8_t messageNumberByHA[64];
	uint8_t messageNumberByID[16];
	uint32_t autoClearHA[2];
	uint32_t autoClearID: 16;
	uint32_t rsvd3: 16;
	uint32_t rsvd4;
};

typedef union {
	uint32_t varWords[31];
	LOAD_SM_VAR varLdSM;
	READ_NV_VAR varRDnvp;
	WRITE_NV_VAR varWTnvp;
	BIU_DIAG_VAR varBIUdiag;
	INIT_LINK_VAR varInitLnk;
	DOWN_LINK_VAR varDwnLnk;
	CONFIG_LINK varCfgLnk;
	PART_SLIM_VAR varSlim;
	CONFIG_RING_VAR varCfgRing;
	RESET_RING_VAR varRstRing;
	READ_CONFIG_VAR varRdConfig;
	READ_RCONF_VAR varRdRConfig;
	READ_SPARM_VAR varRdSparm;
	READ_STATUS_VAR varRdStatus;
	READ_RPI_VAR varRdRPI;
	READ_XRI_VAR varRdXRI;
	READ_REV_VAR varRdRev;
	READ_LNK_VAR varRdLnk;
	REG_LOGIN_VAR varRegLogin;
	UNREG_LOGIN_VAR varUnregLogin;
	CLEAR_LA_VAR varClearLA;
	DUMP_VAR varDmp;
	UNREG_D_ID_VAR varUnregDID;
	CONFIG_FARP_VAR varCfgFarp;
	struct config_hbq_var varCfgHbq;
	struct update_cfg_var varUpdateCfg;
	CONFIG_PORT_VAR varCfgPort;
	struct lpfc_mbx_read_top varReadTop;
	REG_VPI_VAR varRegVpi;
	UNREG_VPI_VAR varUnregVpi;
	ASYNCEVT_ENABLE_VAR varCfgAsyncEvent;
	struct READ_EVENT_LOG_VAR varRdEventLog;
	struct config_msi_var varCfgMSI;
} MAILVARIANTS;

struct lpfc_hgp {
	__le32 cmdPutInx;
	__le32 rspGetInx;
};

struct lpfc_pgp {
	__le32 cmdGetInx;
	__le32 rspPutInx;
};

struct sli2_desc {
	uint32_t unused1[16];
	struct lpfc_hgp host[4];
	struct lpfc_pgp port[4];
};

struct sli3_desc {
	struct lpfc_hgp host[4];
	uint32_t reserved[8];
	uint32_t hbq_put[16];
};

struct sli3_pgp {
	struct lpfc_pgp port[4];
	uint32_t hbq_get[16];
};

union sli_var {
	struct sli2_desc s2;
	struct sli3_desc s3;
	struct sli3_pgp s3_pgp;
};

typedef struct {
	union {
		struct {
			union {
				struct {
					uint8_t mbxOwner: 1;
					uint8_t mbxHc: 1;
					uint8_t mbxReserved: 6;
					uint8_t mbxCommand;
					uint16_t mbxStatus;
				};
				u32 word0;
			};
		};
		struct MAILBOX_word0 bits;
	};
	MAILVARIANTS un;
	union sli_var us;
} MAILBOX_t;

struct list_head {
	struct list_head *next;
	struct list_head *prev;
};

typedef struct {
	int counter;
} atomic_t;

struct refcount_struct {
	atomic_t refs;
};

typedef struct refcount_struct refcount_t;

struct dentry;

struct file;

typedef struct {
	struct list_head list;
	long unsigned int flags;
	int offset;
	int size;
	char *magic;
	char *mask;
	const char *interpreter;
	char *name;
	struct dentry *dentry;
	struct file *interp_file;
	refcount_t users;
} Node;

struct lpfc_hbq_entry {
	struct ulp_bde64 bde;
	uint32_t buffer_tag;
};

typedef struct {
	struct lpfc_hbq_entry buff;
	uint32_t rsvd;
	uint32_t rsvd1;
} QUE_XRI64_CX_FIELDS;

typedef struct {
	struct ulp_bde elsReq[2];
	uint32_t parmRo;
	uint32_t remoteID: 24;
	uint32_t word5Rsvd: 8;
} RCV_ELS_REQ;

typedef struct {
	struct ulp_bde64 elsReq;
	uint32_t rcvd1;
	uint32_t parmRo;
	uint32_t remoteID: 24;
	uint32_t word5Rsvd: 8;
} RCV_ELS_REQ64;

struct folio;

typedef struct {
	struct folio *v;
} Sector;

typedef struct {
	unsigned int offset;
	unsigned int litLength;
	unsigned int matchLength;
	unsigned int rep;
} ZSTD_Sequence;

typedef struct {
	int collectSequences;
	ZSTD_Sequence *seqStart;
	size_t seqIndex;
	size_t maxSequences;
} SeqCollector;

typedef struct {
	short unsigned int table_id;
	unsigned char parameter_id;
	unsigned char parameter_size_bytes;
	unsigned char data[1];
} __attribute__((packed)) TW_Param;

typedef struct {
	short unsigned int table_id;
	short unsigned int parameter_id;
	short unsigned int parameter_size_bytes;
	short unsigned int actual_parameter_size_bytes;
	unsigned char data[0];
} TW_Param_Apache;

typedef struct {
	__le16 table_id;
	__le16 parameter_id;
	__le16 parameter_size_bytes;
	__le16 actual_parameter_size_bytes;
	u8 data[0];
} TW_Param_Apache___2;

typedef struct {
	ULP_BDL bdl;
	uint32_t xrsqRo;
	WORD5 w5;
} XMT_SEQ_FIELDS64;

typedef struct {
	struct ulp_bde xrsqbde[2];
	uint32_t xrsqRo;
	WORD5 w5;
} XR_SEQ_FIELDS;

typedef struct {
	S16 norm[53];
	U32 wksp[285];
} ZSTD_BuildCTableWksp;

struct ZSTD_DDict_s;

typedef struct ZSTD_DDict_s ZSTD_DDict;

typedef struct {
	const ZSTD_DDict **ddictPtrTable;
	size_t ddictPtrTableSize;
	size_t ddictPtrCount;
} ZSTD_DDictHashSet;

struct seqDef_s;

typedef struct seqDef_s seqDef;

typedef struct {
	seqDef *sequencesStart;
	seqDef *sequences;
	BYTE *litStart;
	BYTE *lit;
	BYTE *llCode;
	BYTE *mlCode;
	BYTE *ofCode;
	size_t maxNbSeq;
	size_t maxNbLit;
	ZSTD_longLengthType_e longLengthType;
	U32 longLengthPos;
} seqStore_t;

typedef struct {
	symbolEncodingType_e hType;
	BYTE hufDesBuffer[128];
	size_t hufDesSize;
} ZSTD_hufCTablesMetadata_t;

typedef struct {
	symbolEncodingType_e llType;
	symbolEncodingType_e ofType;
	symbolEncodingType_e mlType;
	BYTE fseTablesBuffer[133];
	size_t fseTablesSize;
	size_t lastCountSize;
} ZSTD_fseCTablesMetadata_t;

typedef struct {
	ZSTD_hufCTablesMetadata_t hufMetadata;
	ZSTD_fseCTablesMetadata_t fseMetadata;
} ZSTD_entropyCTablesMetadata_t;

typedef struct {
	seqStore_t fullSeqStoreChunk;
	seqStore_t firstHalfSeqStore;
	seqStore_t secondHalfSeqStore;
	seqStore_t currSeqStore;
	seqStore_t nextSeqStore;
	U32 partitions[196];
	ZSTD_entropyCTablesMetadata_t entropyMetadata;
} ZSTD_blockSplitCtx;

typedef struct {
	HUF_CElt CTable[257];
	HUF_repeat repeatMode;
} ZSTD_hufCTables_t;

typedef struct {
	FSE_CTable offcodeCTable[193];
	FSE_CTable matchlengthCTable[363];
	FSE_CTable litlengthCTable[329];
	FSE_repeat offcode_repeatMode;
	FSE_repeat matchlength_repeatMode;
	FSE_repeat litlength_repeatMode;
} ZSTD_fseCTables_t;

typedef struct {
	ZSTD_hufCTables_t huf;
	ZSTD_fseCTables_t fse;
} ZSTD_entropyCTables_t;

typedef struct {
	ZSTD_entropyCTables_t entropy;
	U32 rep[3];
} ZSTD_compressedBlockState_t;

typedef struct {
	const BYTE *nextSrc;
	const BYTE *base;
	const BYTE *dictBase;
	U32 dictLimit;
	U32 lowLimit;
	U32 nbOverflowCorrections;
} ZSTD_window_t;

typedef struct {
	U32 off;
	U32 len;
} ZSTD_match_t;

typedef struct {
	int price;
	U32 off;
	U32 mlen;
	U32 litlen;
	U32 rep[3];
} ZSTD_optimal_t;

typedef struct {
	unsigned int *litFreq;
	unsigned int *litLengthFreq;
	unsigned int *matchLengthFreq;
	unsigned int *offCodeFreq;
	ZSTD_match_t *matchTable;
	ZSTD_optimal_t *priceTable;
	U32 litSum;
	U32 litLengthSum;
	U32 matchLengthSum;
	U32 offCodeSum;
	U32 litSumBasePrice;
	U32 litLengthSumBasePrice;
	U32 matchLengthSumBasePrice;
	U32 offCodeSumBasePrice;
	ZSTD_OptPrice_e priceType;
	const ZSTD_entropyCTables_t *symbolCosts;
	ZSTD_paramSwitch_e literalCompressionMode;
} optState_t;

typedef struct {
	unsigned int windowLog;
	unsigned int chainLog;
	unsigned int hashLog;
	unsigned int searchLog;
	unsigned int minMatch;
	unsigned int targetLength;
	ZSTD_strategy strategy;
} ZSTD_compressionParameters;

typedef struct {
	U32 offset;
	U32 litLength;
	U32 matchLength;
} rawSeq;

typedef struct {
	rawSeq *seq;
	size_t pos;
	size_t posInSequence;
	size_t size;
	size_t capacity;
} rawSeqStore_t;

struct ZSTD_matchState_t;

typedef struct ZSTD_matchState_t ZSTD_matchState_t;

struct ZSTD_matchState_t {
	ZSTD_window_t window;
	U32 loadedDictEnd;
	U32 nextToUpdate;
	U32 hashLog3;
	U32 rowHashLog;
	U16___3 *tagTable;
	U32 hashCache[8];
	U32 *hashTable;
	U32 *hashTable3;
	U32 *chainTable;
	U32 forceNonContiguous;
	int dedicatedDictSearch;
	optState_t opt;
	const ZSTD_matchState_t *dictMatchState;
	ZSTD_compressionParameters cParams;
	const rawSeqStore_t *ldmSeqStore;
};

typedef struct {
	ZSTD_compressedBlockState_t *prevCBlock;
	ZSTD_compressedBlockState_t *nextCBlock;
	ZSTD_matchState_t matchState;
} ZSTD_blockState_t;

typedef struct {
	size_t error;
	int lowerBound;
	int upperBound;
} ZSTD_bounds;

typedef struct {
	U32 f1c;
	U32 f1d;
	U32 f7b;
	U32 f7c;
} ZSTD_cpuid_t;

typedef void * (*ZSTD_allocFunction)(void *, size_t);

typedef void (*ZSTD_freeFunction)(void *, void *);

typedef struct {
	ZSTD_allocFunction customAlloc;
	ZSTD_freeFunction customFree;
	void *opaque;
} ZSTD_customMem;

typedef struct {
	void *workspace;
	void *workspaceEnd;
	void *objectEnd;
	void *tableEnd;
	void *tableValidEnd;
	void *allocStart;
	BYTE allocFailed;
	int workspaceOversizedDuration;
	ZSTD_cwksp_alloc_phase_e phase;
	ZSTD_cwksp_static_alloc_e isStatic;
} ZSTD_cwksp;

typedef struct {
	U16___3 nextState;
	BYTE nbAdditionalBits;
	BYTE nbBits;
	U32 baseValue;
} ZSTD_seqSymbol;

typedef struct {
	ZSTD_seqSymbol LLTable[513];
	ZSTD_seqSymbol OFTable[257];
	ZSTD_seqSymbol MLTable[513];
	HUF_DTable hufTable[4097];
	U32 rep[3];
	U32 workspace[157];
} ZSTD_entropyDTables_t;

typedef struct {
	long long unsigned int frameContentSize;
	long long unsigned int windowSize;
	unsigned int blockSizeMax;
	ZSTD_frameType_e frameType;
	unsigned int headerSize;
	unsigned int dictID;
	unsigned int checksumFlag;
} ZSTD_frameHeader;

typedef struct {
	int contentSizeFlag;
	int checksumFlag;
	int noDictIDFlag;
} ZSTD_frameParameters;

typedef struct {
	long long unsigned int ingested;
	long long unsigned int consumed;
	long long unsigned int produced;
	long long unsigned int flushed;
	unsigned int currentJobID;
	unsigned int nbActiveWorkers;
} ZSTD_frameProgression;

typedef struct {
	size_t compressedSize;
	long long unsigned int decompressedBound;
} ZSTD_frameSizeInfo;

typedef struct {
	size_t state;
	const ZSTD_seqSymbol *table;
} ZSTD_fseState;

struct ZSTD_CDict_s;

typedef struct ZSTD_CDict_s ZSTD_CDict;

typedef struct {
	void *dictBuffer;
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
	ZSTD_CDict *cdict;
} ZSTD_localDict;

typedef struct {
	rawSeqStore_t seqStore;
	U32 startPosInBlock;
	U32 endPosInBlock;
	U32 offset;
} ZSTD_optLdm_t;

typedef struct {
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
} ZSTD_parameters;

typedef struct {
	U32 fastMode;
	U32 tableLog;
} ZSTD_seqSymbol_header;

typedef struct {
	U32 litLength;
	U32 matchLength;
} ZSTD_sequenceLength;

typedef struct {
	U32 idx;
	U32 posInSequence;
	size_t posInSrc;
} ZSTD_sequencePosition;

typedef struct {
	U32 LLtype;
	U32 Offtype;
	U32 MLtype;
	size_t size;
	size_t lastCountSize;
} ZSTD_symbolEncodingTypeStats_t;

typedef struct {
	long unsigned int fds_bits[16];
} __kernel_fd_set;

typedef struct {
	int val[2];
} __kernel_fsid_t;

typedef struct {
	__u32 u[4];
} __vector128;

typedef struct {
	struct {
		u8 data_length[2];
		u8 med_type;
		u8 dev_par;
		u8 rsrvd[2];
		u8 bd_length[2];
	} hd;
	struct {
		u8 dens_code;
		u8 block_count[3];
		u8 reserved;
		u8 block_length[3];
	} bd;
	u8 mpc_buf[3];
} aac_modep10_data;

typedef struct {
	struct {
		u8 data_length;
		u8 med_type;
		u8 dev_par;
		u8 bd_length;
	} hd;
	struct {
		u8 dens_code;
		u8 block_count[3];
		u8 reserved;
		u8 block_length[3];
	} bd;
	u8 mpc_buf[3];
} aac_modep_data;

struct mbox_out {
	u8 cmd;
	u8 cmdid;
	u16 numsectors;
	u32 lba;
	u32 xferaddr;
	u8 logdrv;
	u8 numsgelements;
	u8 resvd;
} __attribute__((packed));

struct mbox_in {
	volatile u8 busy;
	volatile u8 numstatus;
	volatile u8 status;
	volatile u8 completed[46];
	volatile u8 poll;
	volatile u8 ack;
};

typedef struct {
	struct mbox_out m_out;
	struct mbox_in m_in;
} mbox_t;

typedef struct {
	u32 xfer_segment_lo;
	u32 xfer_segment_hi;
	mbox_t mbox;
} __attribute__((packed)) mbox64_t;

typedef struct {
	u32 data_size;
	u32 config_signature;
	u8 fw_version[16];
	u8 bios_version[16];
	u8 product_name[80];
	u8 max_commands;
	u8 nchannels;
	u8 fc_loop_present;
	u8 mem_type;
	u32 signature;
	u16 dram_size;
	u16 subsysid;
	u16 subsysvid;
	u8 notify_counters;
	u8 pad1k[889];
} mega_product_info;

typedef struct {
	u32 address;
	u32 length;
} mega_sglist;

typedef struct {
	u64 address;
	u32 length;
} __attribute__((packed)) mega_sgl64;

typedef struct {
	u8 timeout: 3;
	u8 ars: 1;
	u8 reserved: 3;
	u8 islogical: 1;
	u8 logdrv;
	u8 channel;
	u8 target;
	u8 queuetag;
	u8 queueaction;
	u8 cdb[10];
	u8 cdblen;
	u8 reqsenselen;
	u8 reqsensearea[32];
	u8 numsgelements;
	u8 scsistatus;
	u32 dataxferaddr;
	u32 dataxferlen;
} mega_passthru;

typedef struct {
	u8 timeout: 3;
	u8 ars: 1;
	u8 rsvd1: 1;
	u8 cd_rom: 1;
	u8 rsvd2: 1;
	u8 islogical: 1;
	u8 logdrv;
	u8 channel;
	u8 target;
	u8 queuetag;
	u8 queueaction;
	u8 cdblen;
	u8 rsvd3;
	u8 cdb[16];
	u8 numsgelements;
	u8 status;
	u8 reqsenselen;
	u8 reqsensearea[32];
	u8 rsvd4;
	u32 dataxferaddr;
	u32 dataxferlen;
} mega_ext_passthru;

struct scsi_cmnd;

typedef struct {
	int idx;
	u32 state;
	struct list_head list;
	u8 raw_mbox[66];
	u32 dma_type;
	u32 dma_direction;
	struct scsi_cmnd *cmd;
	dma_addr_t dma_h_bulkdata;
	dma_addr_t dma_h_sgdata;
	mega_sglist *sgl;
	mega_sgl64 *sgl64;
	dma_addr_t sgl_dma_addr;
	mega_passthru *pthru;
	dma_addr_t pthru_dma_addr;
	mega_ext_passthru *epthru;
	dma_addr_t epthru_dma_addr;
} scb_t;

struct qspinlock {
	union {
		u32 val;
		struct {
			u16 locked;
			u8 reserved[2];
		};
	};
};

typedef struct qspinlock arch_spinlock_t;

struct raw_spinlock {
	arch_spinlock_t raw_lock;
};

struct spinlock {
	union {
		struct raw_spinlock rlock;
	};
};

typedef struct spinlock spinlock_t;

typedef struct {
	s64 counter;
} atomic64_t;

typedef atomic64_t atomic_long_t;

typedef struct raw_spinlock raw_spinlock_t;

struct optimistic_spin_queue {
	atomic_t tail;
};

struct mutex {
	atomic_long_t owner;
	raw_spinlock_t wait_lock;
	struct optimistic_spin_queue osq;
	struct list_head wait_list;
};

struct swait_queue_head {
	raw_spinlock_t lock;
	struct list_head task_list;
};

struct completion {
	unsigned int done;
	struct swait_queue_head wait;
};

struct pci_dev;

struct Scsi_Host;

struct proc_dir_entry;

typedef struct {
	int this_id;
	u32 flag;
	long unsigned int base;
	void *mmio_base;
	mbox64_t *una_mbox64;
	dma_addr_t una_mbox64_dma;
	volatile mbox64_t *mbox64;
	volatile mbox_t *mbox;
	dma_addr_t mbox_dma;
	struct pci_dev *dev;
	struct list_head free_list;
	struct list_head pending_list;
	struct list_head completed_list;
	struct Scsi_Host *host;
	u8 *mega_buffer;
	dma_addr_t buf_dma_handle;
	mega_product_info product_info;
	u8 max_cmds;
	scb_t *scb_list;
	atomic_t pend_cmds;
	u8 numldrv;
	u8 fw_version[7];
	u8 bios_version[7];
	struct proc_dir_entry *controller_proc_dir_entry;
	int has_64bit_addr;
	int support_ext_cdb;
	int boot_ldrv_enabled;
	int boot_ldrv;
	int boot_pdrv_enabled;
	int boot_pdrv_ch;
	int boot_pdrv_tgt;
	int support_random_del;
	int read_ldidmap;
	atomic_t quiescent;
	spinlock_t lock;
	u8 logdrv_chan[9];
	int mega_ch_class;
	u8 sglen;
	scb_t int_scb;
	struct mutex int_mtx;
	int int_status;
	struct completion int_waitq;
	int has_cluster;
} adapter_t;

struct tasklet_struct {
	struct tasklet_struct *next;
	long unsigned int state;
	atomic_t count;
	bool use_callback;
	union {
		void (*func)(long unsigned int);
		void (*callback)(struct tasklet_struct *);
	};
	long unsigned int data;
};

typedef struct {
	caddr_t ccb;
	struct list_head list;
	long unsigned int gp;
	unsigned int sno;
	struct scsi_cmnd *scp;
	uint32_t state;
	uint32_t dma_direction;
	uint32_t dma_type;
	uint16_t dev_channel;
	uint16_t dev_target;
	uint32_t status;
} scb_t___2;

typedef struct {
	struct tasklet_struct dpc_h;
	struct pci_dev *pdev;
	struct Scsi_Host *host;
	spinlock_t lock;
	uint8_t quiescent;
	int outstanding_cmds;
	scb_t___2 *kscb_list;
	struct list_head kscb_pool;
	spinlock_t kscb_pool_lock;
	struct list_head pend_list;
	spinlock_t pend_list_lock;
	struct list_head completed_list;
	spinlock_t completed_list_lock;
	uint16_t sglen;
	int device_ids[1040];
	caddr_t raid_device;
	uint8_t max_channel;
	uint16_t max_target;
	uint8_t max_lun;
	uint32_t unique_id;
	int irq;
	uint8_t ito;
	caddr_t ibuf;
	dma_addr_t ibuf_dma_h;
	scb_t___2 *uscb_list;
	struct list_head uscb_pool;
	spinlock_t uscb_pool_lock;
	int max_cmds;
	uint8_t fw_version[16];
	uint8_t bios_version[16];
	uint8_t max_cdb_sz;
	uint8_t ha;
	uint16_t init_id;
	uint16_t max_sectors;
	uint16_t cmd_per_lun;
	atomic_t being_detached;
} adapter_t___2;

typedef struct {
	uint16_t tag_commands[16];
} adapter_tag_info_t;

typedef struct {
	uint8_t tag_commands[16];
} adapter_tag_info_t___2;

typedef struct {
	u8 channel;
	u8 target;
} adp_device;

typedef struct {
	u32 start_blk;
	u32 num_blks;
	adp_device device[32];
} adp_span_40ld;

typedef struct {
	u32 start_blk;
	u32 num_blks;
	adp_device device[8];
} adp_span_8ld;

typedef struct {
	U32 tableTime;
	U32 decode256Time;
} algo_time_t;

typedef struct {
	char ax25_call[7];
} ax25_address;

typedef struct {
	uint8_t domain;
	uint8_t area;
	uint8_t al_pa;
} be_id_t;

typedef struct {
	blockType_e blockType;
	U32 lastBlock;
	U32 origSize;
} blockProperties_t;

typedef struct {
	union {
		void *kernel;
		void *user;
	};
	bool is_kernel: 1;
} sockptr_t;

typedef sockptr_t bpfptr_t;

typedef union {
	u_long ioport;
	volatile uint8_t *maddr;
} bus_space_handle_t;

typedef struct {
	unsigned int interval;
	unsigned int timeout;
} cisco_proto;

typedef struct {
	int *lock;
	long unsigned int flags;
} class_core_lock_t;

typedef struct {
	void *lock;
} class_cpus_read_lock_t;

typedef struct {
	raw_spinlock_t *lock;
	raw_spinlock_t *lock2;
} class_double_raw_spinlock_t;

struct rq;

typedef struct {
	struct rq *lock;
	struct rq *lock2;
} class_double_rq_lock_t;

typedef struct {
	void *lock;
} class_irq_t;

typedef struct {
	void *lock;
	long unsigned int flags;
} class_irqsave_t;

typedef struct {
	void *lock;
} class_preempt_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_irq_t;

typedef struct {
	raw_spinlock_t *lock;
	long unsigned int flags;
} class_raw_spinlock_irqsave_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_t;

typedef struct {
	void *lock;
} class_rcu_t;

struct pin_cookie {};

struct rq_flags {
	long unsigned int flags;
	struct pin_cookie cookie;
	unsigned int clock_update_flags;
};

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irq_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irqsave_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_irq_t;

typedef struct {
	spinlock_t *lock;
	long unsigned int flags;
} class_spinlock_irqsave_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_t;

struct srcu_struct;

typedef struct {
	struct srcu_struct *lock;
	int idx;
} class_srcu_t;

struct task_struct;

typedef struct {
	struct task_struct *lock;
	struct rq *rq;
	struct rq_flags rf;
} class_task_rq_lock_t;

struct qrwlock {
	union {
		atomic_t cnts;
		struct {
			u8 wlocked;
			u8 __lstate[3];
		};
	};
	arch_spinlock_t wait_lock;
};

typedef struct qrwlock arch_rwlock_t;

typedef struct {
	arch_rwlock_t raw_lock;
} rwlock_t;

typedef struct {
	rwlock_t *lock;
} class_write_lock_irq_t;

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t sys_define;
	uint8_t entry_status;
	__le32 handle;
	uint8_t lun;
	uint8_t target;
	__le16 cdb_len;
	__le16 control_flags;
	__le16 reserved;
	__le16 timeout;
	__le16 dseg_count;
	uint8_t scsi_cdb[12];
	__le32 reserved_1[2];
	__le32 dseg_0_address[2];
	__le32 dseg_0_length;
	__le32 dseg_1_address[2];
	__le32 dseg_1_length;
} cmd_a64_entry_t;

typedef union {
	__le16 extended;
	struct {
		uint8_t reserved;
		uint8_t standard;
	} id;
} target_id_t;

struct dsd32 {
	__le32 address;
	__le32 length;
};

struct dsd64 {
	__le64 address;
	__le32 length;
} __attribute__((packed));

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t sys_define;
	uint8_t entry_status;
	uint32_t handle;
	target_id_t target;
	__le16 lun;
	__le16 control_flags;
	uint16_t reserved_1;
	__le16 timeout;
	__le16 dseg_count;
	uint8_t scsi_cdb[16];
	__le32 byte_count;
	union {
		struct dsd32 dsd32[3];
		struct dsd64 dsd64[2];
	};
} cmd_entry_t;

typedef struct {
	unsigned char op;
	unsigned char bits;
	short unsigned int val;
} code;

typedef __kernel_fsid_t compat_fsid_t;

typedef struct {
	compat_sigset_word sig[2];
} compat_sigset_t;

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t sys_define;
	uint8_t entry_status;
	struct dsd64 dsd[5];
} cont_a64_entry_t;

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t sys_define;
	uint8_t entry_status;
	uint32_t reserved;
	struct dsd32 dsd[7];
} cont_entry_t;

typedef struct {
	const int x;
} cxl_p1_reg_t;

typedef struct {
	const int x;
} cxl_p1n_reg_t;

typedef struct {
	const int x;
} cxl_p2n_reg_t;

struct device_reg_2xxx {
	__le16 flash_address;
	__le16 flash_data;
	__le16 unused_1[1];
	__le16 ctrl_status;
	__le16 ictrl;
	__le16 istatus;
	__le16 semaphore;
	__le16 nvram;
	union {
		struct {
			__le16 mailbox0;
			__le16 mailbox1;
			__le16 mailbox2;
			__le16 mailbox3;
			__le16 mailbox4;
			__le16 mailbox5;
			__le16 mailbox6;
			__le16 mailbox7;
			__le16 unused_2[59];
		} isp2100;
		struct {
			__le16 req_q_in;
			__le16 req_q_out;
			__le16 rsp_q_in;
			__le16 rsp_q_out;
			__le32 host_status;
			__le16 host_semaphore;
			__le16 unused_3[17];
			__le16 mailbox0;
			__le16 mailbox1;
			__le16 mailbox2;
			__le16 mailbox3;
			__le16 mailbox4;
			__le16 mailbox5;
			__le16 mailbox6;
			__le16 mailbox7;
			__le16 mailbox8;
			__le16 mailbox9;
			__le16 mailbox10;
			__le16 mailbox11;
			__le16 mailbox12;
			__le16 mailbox13;
			__le16 mailbox14;
			__le16 mailbox15;
			__le16 mailbox16;
			__le16 mailbox17;
			__le16 mailbox18;
			__le16 mailbox19;
			__le16 mailbox20;
			__le16 mailbox21;
			__le16 mailbox22;
			__le16 mailbox23;
			__le16 mailbox24;
			__le16 mailbox25;
			__le16 mailbox26;
			__le16 mailbox27;
			__le16 mailbox28;
			__le16 mailbox29;
			__le16 mailbox30;
			__le16 mailbox31;
			__le16 fb_cmd;
			__le16 unused_4[10];
		} __attribute__((packed)) isp2300;
	} u;
	__le16 fpm_diag_config;
	__le16 unused_5[4];
	__le16 risc_hw;
	__le16 unused_5_1;
	__le16 pcr;
	__le16 unused_6[5];
	__le16 mctr;
	__le16 unused_7[3];
	__le16 fb_cmd_2100;
	__le16 unused_8[3];
	__le16 hccr;
	__le16 unused_9[5];
	__le16 gpiod;
	__le16 gpioe;
	union {
		struct {
			__le16 unused_10[8];
			__le16 mailbox8;
			__le16 mailbox9;
			__le16 mailbox10;
			__le16 mailbox11;
			__le16 mailbox12;
			__le16 mailbox13;
			__le16 mailbox14;
			__le16 mailbox15;
			__le16 mailbox16;
			__le16 mailbox17;
			__le16 mailbox18;
			__le16 mailbox19;
			__le16 mailbox20;
			__le16 mailbox21;
			__le16 mailbox22;
			__le16 mailbox23;
		} isp2200;
	} u_end;
};

struct device_reg_24xx {
	__le32 flash_addr;
	__le32 flash_data;
	__le32 ctrl_status;
	__le32 ictrl;
	__le32 istatus;
	__le32 unused_1[2];
	__le32 req_q_in;
	__le32 req_q_out;
	__le32 rsp_q_in;
	__le32 rsp_q_out;
	__le32 preq_q_in;
	__le32 preq_q_out;
	__le32 unused_2[2];
	__le32 atio_q_in;
	__le32 atio_q_out;
	__le32 host_status;
	__le32 hccr;
	__le32 gpiod;
	__le32 gpioe;
	__le32 iobase_addr;
	__le32 unused_3[10];
	__le16 mailbox0;
	__le16 mailbox1;
	__le16 mailbox2;
	__le16 mailbox3;
	__le16 mailbox4;
	__le16 mailbox5;
	__le16 mailbox6;
	__le16 mailbox7;
	__le16 mailbox8;
	__le16 mailbox9;
	__le16 mailbox10;
	__le16 mailbox11;
	__le16 mailbox12;
	__le16 mailbox13;
	__le16 mailbox14;
	__le16 mailbox15;
	__le16 mailbox16;
	__le16 mailbox17;
	__le16 mailbox18;
	__le16 mailbox19;
	__le16 mailbox20;
	__le16 mailbox21;
	__le16 mailbox22;
	__le16 mailbox23;
	__le16 mailbox24;
	__le16 mailbox25;
	__le16 mailbox26;
	__le16 mailbox27;
	__le16 mailbox28;
	__le16 mailbox29;
	__le16 mailbox30;
	__le16 mailbox31;
	__le32 iobase_window;
	__le32 iobase_c4;
	__le32 iobase_c8;
	__le32 unused_4_1[6];
	__le32 iobase_q;
	__le32 unused_5[2];
	__le32 iobase_select;
	__le32 unused_6[2];
	__le32 iobase_sdata;
};

struct device_reg_25xxmq {
	__le32 req_q_in;
	__le32 req_q_out;
	__le32 rsp_q_in;
	__le32 rsp_q_out;
	__le32 atio_q_in;
	__le32 atio_q_out;
};

struct device_reg_82xx {
	__le32 req_q_out[64];
	__le32 rsp_q_in[64];
	__le32 rsp_q_out[64];
	__le16 mailbox_in[32];
	__le16 unused_1[32];
	__le32 hint;
	__le16 unused_2[62];
	__le16 mailbox_out[32];
	__le32 unused_3[48];
	__le32 host_status;
	__le32 host_int;
};

struct device_reg_fx00 {
	__le32 mailbox0;
	__le32 mailbox1;
	__le32 mailbox2;
	__le32 mailbox3;
	__le32 mailbox4;
	__le32 mailbox5;
	__le32 mailbox6;
	__le32 mailbox7;
	__le32 mailbox8;
	__le32 mailbox9;
	__le32 mailbox10;
	__le32 mailbox11;
	__le32 mailbox12;
	__le32 mailbox13;
	__le32 mailbox14;
	__le32 mailbox15;
	__le32 mailbox16;
	__le32 mailbox17;
	__le32 mailbox18;
	__le32 mailbox19;
	__le32 mailbox20;
	__le32 mailbox21;
	__le32 mailbox22;
	__le32 mailbox23;
	__le32 mailbox24;
	__le32 mailbox25;
	__le32 mailbox26;
	__le32 mailbox27;
	__le32 mailbox28;
	__le32 mailbox29;
	__le32 mailbox30;
	__le32 mailbox31;
	__le32 aenmailbox0;
	__le32 aenmailbox1;
	__le32 aenmailbox2;
	__le32 aenmailbox3;
	__le32 aenmailbox4;
	__le32 aenmailbox5;
	__le32 aenmailbox6;
	__le32 aenmailbox7;
	__le32 req_q_in;
	__le32 req_q_out;
	__le32 rsp_q_in;
	__le32 rsp_q_out;
	__le32 initval0;
	__le32 initval1;
	__le32 initval2;
	__le32 initval3;
	__le32 initval4;
	__le32 initval5;
	__le32 initval6;
	__le32 initval7;
	__le32 fwheartbeat;
	__le32 pseudoaen;
};

typedef union {
	struct device_reg_2xxx isp;
	struct device_reg_24xx isp24;
	struct device_reg_25xxmq isp25mq;
	struct device_reg_82xx isp82;
	struct device_reg_fx00 ispfx00;
} device_reg_t;

typedef struct {
	__be16 disc_information_length;
	__u8 disc_status: 2;
	__u8 border_status: 2;
	__u8 erasable: 1;
	__u8 reserved1: 3;
	__u8 n_first_track;
	__u8 n_sessions_lsb;
	__u8 first_track_lsb;
	__u8 last_track_lsb;
	__u8 mrw_status: 2;
	__u8 dbit: 1;
	__u8 reserved2: 2;
	__u8 uru: 1;
	__u8 dbc_v: 1;
	__u8 did_v: 1;
	__u8 disc_type;
	__u8 n_sessions_msb;
	__u8 first_track_msb;
	__u8 last_track_msb;
	__u32 disc_id;
	__u32 lead_in;
	__u32 lead_out;
	__u8 disc_bar_code[8];
	__u8 reserved3;
	__u8 n_opc;
} disc_information;

typedef struct {
	u8 span_depth;
	u8 level;
	u8 read_ahead;
	u8 stripe_sz;
	u8 status;
	u8 write_mode;
	u8 direct_io;
	u8 row_size;
} logdrv_param;

typedef struct {
	logdrv_param lparam;
	adp_span_40ld span[8];
} logdrv_40ld;

typedef struct {
	u8 type;
	u8 cur_status;
	u8 tag_depth;
	u8 sync_neg;
	u32 size;
} phys_drv;

typedef struct {
	u8 nlog_drives;
	u8 resvd[3];
	logdrv_40ld ldrv[40];
	phys_drv pdrv[75];
} disk_array_40ld;

typedef struct {
	logdrv_param lparam;
	adp_span_8ld span[8];
} logdrv_8ld;

typedef struct {
	u8 nlog_drives;
	u8 resvd[3];
	logdrv_8ld ldrv[8];
	phys_drv pdrv[75];
} disk_array_8ld;

typedef struct {
	long unsigned int bits[1];
} dma_cap_mask_t;

struct dvd_lu_send_agid {
	__u8 type;
	unsigned int agid: 2;
};

struct dvd_host_send_challenge {
	__u8 type;
	unsigned int agid: 2;
	dvd_challenge chal;
};

struct dvd_send_key {
	__u8 type;
	unsigned int agid: 2;
	dvd_key key;
};

struct dvd_lu_send_challenge {
	__u8 type;
	unsigned int agid: 2;
	dvd_challenge chal;
};

struct dvd_lu_send_title_key {
	__u8 type;
	unsigned int agid: 2;
	dvd_key title_key;
	int lba;
	unsigned int cpm: 1;
	unsigned int cp_sec: 1;
	unsigned int cgms: 2;
};

struct dvd_lu_send_asf {
	__u8 type;
	unsigned int agid: 2;
	unsigned int asf: 1;
};

struct dvd_host_send_rpcstate {
	__u8 type;
	__u8 pdrc;
};

struct dvd_lu_send_rpcstate {
	__u8 type: 2;
	__u8 vra: 3;
	__u8 ucca: 3;
	__u8 region_mask;
	__u8 rpc_scheme;
};

typedef union {
	__u8 type;
	struct dvd_lu_send_agid lsa;
	struct dvd_host_send_challenge hsc;
	struct dvd_send_key lsk;
	struct dvd_lu_send_challenge lsc;
	struct dvd_send_key hsk;
	struct dvd_lu_send_title_key lstk;
	struct dvd_lu_send_asf lsasf;
	struct dvd_host_send_rpcstate hrpcs;
	struct dvd_lu_send_rpcstate lrpcs;
} dvd_authinfo;

struct dvd_layer {
	__u8 book_version: 4;
	__u8 book_type: 4;
	__u8 min_rate: 4;
	__u8 disc_size: 4;
	__u8 layer_type: 4;
	__u8 track_path: 1;
	__u8 nlayers: 2;
	char: 1;
	__u8 track_density: 4;
	__u8 linear_density: 4;
	__u8 bca: 1;
	__u32 start_sector;
	__u32 end_sector;
	__u32 end_sector_l0;
};

struct dvd_physical {
	__u8 type;
	__u8 layer_num;
	struct dvd_layer layer[4];
};

struct dvd_copyright {
	__u8 type;
	__u8 layer_num;
	__u8 cpst;
	__u8 rmi;
};

struct dvd_disckey {
	__u8 type;
	unsigned int agid: 2;
	__u8 value[2048];
};

struct dvd_bca {
	__u8 type;
	int len;
	__u8 value[188];
};

struct dvd_manufact {
	__u8 type;
	__u8 layer_num;
	int len;
	__u8 value[2048];
};

typedef union {
	__u8 type;
	struct dvd_physical physical;
	struct dvd_copyright copyright;
	struct dvd_disckey disckey;
	struct dvd_bca bca;
	struct dvd_manufact manufact;
} dvd_struct;

typedef struct {
	__u8 b[16];
} guid_t;

typedef guid_t efi_guid_t;

typedef __vector128 elf_vrreg_t;

typedef elf_vrreg_t elf_vrregset_t32[33];

typedef struct {
	__le16 e_tag;
	__le16 e_perm;
	__le32 e_id;
} ext4_acl_entry;

typedef struct {
	__le32 a_version;
} ext4_acl_header;

typedef __kernel_fd_set fd_set;

typedef struct {
	long unsigned int *in;
	long unsigned int *out;
	long unsigned int *ex;
	long unsigned int *res_in;
	long unsigned int *res_out;
	long unsigned int *res_ex;
} fd_set_bits;

typedef struct {
	unsigned int t391;
	unsigned int t392;
	unsigned int n391;
	unsigned int n392;
	unsigned int n393;
	short unsigned int lmi;
	short unsigned int dce;
} fr_proto;

typedef struct {
	unsigned int dlci;
} fr_proto_pvc;

typedef struct {
	unsigned int dlci;
	char master[16];
} fr_proto_pvc_info;

typedef union {
	struct {
		void *freelist;
		long unsigned int counter;
	};
	freelist_full_t full;
} freelist_aba_t;

typedef struct {
	long unsigned int v;
} freeptr_t;

typedef struct {
	long unsigned int addr;
} func_desc_t;

typedef struct {
	long unsigned int key[2];
} hsiphash_key_t;

typedef struct {
	__be64 pdbe;
} hugepd_t;

typedef struct {
	uint8_t version;
	uint8_t reserved_1;
	uint8_t firmware_options[2];
	__le16 frame_payload_size;
	__le16 max_iocb_allocation;
	__le16 execution_throttle;
	uint8_t retry_count;
	uint8_t retry_delay;
	uint8_t port_name[8];
	uint16_t hard_address;
	uint8_t inquiry_data;
	uint8_t login_timeout;
	uint8_t node_name[8];
	__le16 request_q_outpointer;
	__le16 response_q_inpointer;
	__le16 request_q_length;
	__le16 response_q_length;
	__le64 request_q_address;
	__le64 response_q_address;
	__le16 lun_enables;
	uint8_t command_resource_count;
	uint8_t immediate_notify_resource_count;
	__le16 timeout;
	uint8_t reserved_2[2];
	uint8_t add_firmware_options[2];
	uint8_t response_accumulation_timer;
	uint8_t interrupt_delay_timer;
	uint8_t special_options[2];
	uint8_t reserved_3[26];
} init_cb_t;

struct ips_ha;

struct ips_scb;

typedef struct {
	int (*reset)(struct ips_ha *);
	int (*issue)(struct ips_ha *, struct ips_scb *);
	int (*isinit)(struct ips_ha *);
	int (*isintr)(struct ips_ha *);
	int (*init)(struct ips_ha *);
	int (*erasebios)(struct ips_ha *);
	int (*programbios)(struct ips_ha *, char *, uint32_t, uint32_t);
	int (*verifybios)(struct ips_ha *, char *, uint32_t, uint32_t);
	void (*statinit)(struct ips_ha *);
	int (*intr)(struct ips_ha *);
	void (*enableint)(struct ips_ha *);
	uint32_t (*statupd)(struct ips_ha *);
} ips_hw_func_t;

typedef struct ips_ha ips_ha_t;

typedef void (*ips_scb_callback)(ips_ha_t *, struct ips_scb *);

struct ips_scb_pt {
	IPS_HOST_COMMAND cmd;
	IPS_DCDB_TABLE dcdb;
	uint8_t target_id;
	uint8_t bus;
	uint8_t lun;
	uint8_t cdb[12];
	uint32_t scb_busaddr;
	uint32_t data_busaddr;
	uint32_t timeout;
	uint8_t basic_status;
	uint8_t extended_status;
	uint16_t breakup;
	uint32_t data_len;
	uint32_t sg_len;
	uint32_t flags;
	uint32_t op_code;
	IPS_SG_LIST *sg_list;
	struct scsi_cmnd *scsi_cmd;
	struct ips_scb *q_next;
	ips_scb_callback callback;
};

typedef struct ips_scb_pt ips_scb_pt_t;

typedef struct {
	uint8_t CoppID[4];
	uint32_t CoppCmd;
	uint32_t PtBuffer;
	uint8_t *CmdBuffer;
	uint32_t CmdBSize;
	ips_scb_pt_t CoppCP;
	uint32_t TimeOut;
	uint8_t BasicStatus;
	uint8_t ExtendedStatus;
	uint8_t AdapterType;
	uint8_t reserved;
} ips_passthru_t;

typedef struct {
	unsigned int __softirq_pending;
	unsigned int timer_irqs_event;
	unsigned int broadcast_irqs_event;
	unsigned int timer_irqs_others;
	unsigned int pmu_irqs;
	unsigned int mce_exceptions;
	unsigned int spurious_irqs;
	unsigned int sreset_irqs;
	unsigned int doorbell_irqs;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} irq_cpustat_t;

typedef struct {
	u64 val;
} kernel_cap_t;

typedef struct {
	gid_t val;
} kgid_t;

typedef struct {
	projid_t val;
} kprojid_t;

typedef struct {
	uid_t val;
} kuid_t;

typedef struct {
	U32 offset;
	U32 checksum;
} ldmEntry_t;

typedef struct {
	const BYTE *split;
	U32 hash;
	U32 checksum;
	ldmEntry_t *bucket;
} ldmMatchCandidate_t;

typedef struct {
	ZSTD_paramSwitch_e enableLdm;
	U32 hashLog;
	U32 bucketSizeLog;
	U32 minMatchLength;
	U32 hashRateLog;
	U32 windowLog;
} ldmParams_t;

typedef struct {
	U64___2 rolling;
	U64___2 stopMask;
} ldmRollingHashState_t;

typedef struct {
	ZSTD_window_t window;
	ldmEntry_t *hashTable;
	U32 loadedDictEnd;
	BYTE *bucketOffsets;
	size_t splitIndices[64];
	ldmMatchCandidate_t matchCandidates[64];
} ldmState_t;

typedef struct {
	__le64 b;
	__le64 a;
} le128;

typedef struct {
	uint8_t al_pa;
	uint8_t area;
	uint8_t domain;
} le_id_t;

typedef struct {
	long int v;
} local_t;

typedef struct {
	local_t a;
} local64_t;

typedef struct {} local_lock_t;

typedef struct {} lockdep_map_p;

typedef struct {
	uint8_t cmd;
	uint8_t cmdid;
	uint16_t numsectors;
	uint32_t lba;
	uint32_t xferaddr;
	uint8_t logdrv;
	uint8_t numsge;
	uint8_t resvd;
	uint8_t busy;
	uint8_t numstatus;
	uint8_t status;
	uint8_t completed[46];
	uint8_t poll;
	uint8_t ack;
} __attribute__((packed)) mbox_t___2;

typedef struct {
	uint32_t xferaddr_lo;
	uint32_t xferaddr_hi;
	mbox_t___2 mbox32;
} __attribute__((packed)) mbox64_t___2;

typedef struct {
	uint64_t address;
	uint32_t length;
} __attribute__((packed)) mbox_sgl64;

typedef struct {
	uint32_t address;
	uint32_t length;
} mbox_sgl32;

typedef struct {
	uint8_t timeout: 3;
	uint8_t ars: 1;
	uint8_t reserved: 3;
	uint8_t islogical: 1;
	uint8_t logdrv;
	uint8_t channel;
	uint8_t target;
	uint8_t queuetag;
	uint8_t queueaction;
	uint8_t cdb[10];
	uint8_t cdblen;
	uint8_t reqsenselen;
	uint8_t reqsensearea[32];
	uint8_t numsge;
	uint8_t scsistatus;
	uint32_t dataxferaddr;
	uint32_t dataxferlen;
} mraid_passthru_t;

typedef struct {
	uint8_t timeout: 3;
	uint8_t ars: 1;
	uint8_t rsvd1: 1;
	uint8_t cd_rom: 1;
	uint8_t rsvd2: 1;
	uint8_t islogical: 1;
	uint8_t logdrv;
	uint8_t channel;
	uint8_t target;
	uint8_t queuetag;
	uint8_t queueaction;
	uint8_t cdblen;
	uint8_t rsvd3;
	uint8_t cdb[16];
	uint8_t numsge;
	uint8_t status;
	uint8_t reqsenselen;
	uint8_t reqsensearea[32];
	uint8_t rsvd4;
	uint32_t dataxferaddr;
	uint32_t dataxferlen;
} mraid_epassthru_t;

typedef struct {
	uint8_t *raw_mbox;
	mbox_t___2 *mbox;
	mbox64_t___2 *mbox64;
	dma_addr_t mbox_dma_h;
	mbox_sgl64 *sgl64;
	mbox_sgl32 *sgl32;
	dma_addr_t sgl_dma_h;
	mraid_passthru_t *pthru;
	dma_addr_t pthru_dma_h;
	mraid_epassthru_t *epthru;
	dma_addr_t epthru_dma_h;
	dma_addr_t buf_dma_h;
} mbox_ccb_t;

typedef struct {
	uint32_t out_mb;
	uint32_t in_mb;
	uint16_t mb[32];
	long int buf_size;
	void *bufp;
	uint32_t tov;
	uint8_t flags;
} mbx_cmd_t;

typedef struct {
	u8 max_commands;
	u8 rebuild_rate;
	u8 max_targ_per_chan;
	u8 nchannels;
	u8 fw_version[4];
	u16 age_of_flash;
	u8 chip_set_value;
	u8 dram_size;
	u8 cache_flush_interval;
	u8 bios_version[4];
	u8 board_type;
	u8 sense_alert;
	u8 write_config_count;
	u8 drive_inserted_count;
	u8 inserted_drive;
	u8 battery_status;
	u8 dec_fault_bus_info;
} mega_adp_info;

struct notify {
	u32 global_counter;
	u8 param_counter;
	u8 param_id;
	u16 param_val;
	u8 write_config_counter;
	u8 write_config_rsvd[3];
	u8 ldrv_op_counter;
	u8 ldrv_opid;
	u8 ldrv_opcmd;
	u8 ldrv_opstatus;
	u8 ldrv_state_counter;
	u8 ldrv_state_id;
	u8 ldrv_state_new;
	u8 ldrv_state_old;
	u8 pdrv_state_counter;
	u8 pdrv_state_id;
	u8 pdrv_state_new;
	u8 pdrv_state_old;
	u8 pdrv_fmt_counter;
	u8 pdrv_fmt_id;
	u8 pdrv_fmt_val;
	u8 pdrv_fmt_rsvd;
	u8 targ_xfer_counter;
	u8 targ_xfer_id;
	u8 targ_xfer_val;
	u8 targ_xfer_rsvd;
	u8 fcloop_id_chg_counter;
	u8 fcloopid_pdrvid;
	u8 fcloop_id0;
	u8 fcloop_id1;
	u8 fcloop_state_counter;
	u8 fcloop_state0;
	u8 fcloop_state1;
	u8 fcloop_state_rsvd;
};

typedef struct {
	u32 data_size;
	struct notify notify;
	u8 notify_rsvd[88];
	u8 rebuild_rate;
	u8 cache_flush_interval;
	u8 sense_alert;
	u8 drive_insert_count;
	u8 battery_status;
	u8 num_ldrv;
	u8 recon_state[5];
	u16 ldrv_op_status[5];
	u32 ldrv_size[40];
	u8 ldrv_prop[40];
	u8 ldrv_state[40];
	u8 pdrv_state[256];
	u16 pdrv_format[16];
	u8 targ_xfer[80];
	u8 pad1k[263];
} __attribute__((packed)) mega_inquiry3;

typedef struct {
	u8 num_ldrv;
	u8 rsvd[3];
	u32 ldrv_size[8];
	u8 ldrv_prop[8];
	u8 ldrv_state[8];
} mega_ldrv_info;

typedef struct {
	u8 pdrv_state[75];
	u8 rsvd;
} mega_pdrv_info;

typedef struct {
	u8 cmd;
	u8 cmdid;
	u8 opcode;
	u8 subopcode;
	u32 lba;
	u32 xferaddr;
	u8 logdrv;
	u8 rsvd[3];
	u8 numstatus;
	u8 status;
} __attribute__((packed)) megacmd_t;

struct hash_mm_context;

typedef struct {
	union {
		mm_context_id_t id;
		mm_context_id_t extended_id[8];
	};
	atomic_t active_cpus;
	atomic_t copros;
	atomic_t vas_windows;
	struct hash_mm_context *hash_context;
	void *vdso;
	void *pte_frag;
	void *pmd_frag;
	struct list_head iommu_group_mem_list;
	u32 pkey_allocation_map;
	s16 execute_only_pkey;
} mm_context_t;

struct mraid_pci_blk {
	caddr_t vaddr;
	dma_addr_t dma_addr;
};

struct wait_queue_head {
	spinlock_t lock;
	struct list_head head;
};

typedef struct wait_queue_head wait_queue_head_t;

struct dma_pool;

struct uioc;

typedef struct uioc uioc_t;

typedef struct {
	mbox64_t___2 *una_mbox64;
	dma_addr_t una_mbox64_dma;
	mbox_t___2 *mbox;
	mbox64_t___2 *mbox64;
	dma_addr_t mbox_dma;
	spinlock_t mailbox_lock;
	long unsigned int baseport;
	void *baseaddr;
	struct mraid_pci_blk mbox_pool[128];
	struct dma_pool *mbox_pool_handle;
	struct mraid_pci_blk epthru_pool[128];
	struct dma_pool *epthru_pool_handle;
	struct mraid_pci_blk sg_pool[128];
	struct dma_pool *sg_pool_handle;
	mbox_ccb_t ccb_list[128];
	mbox_ccb_t uccb_list[32];
	mbox64_t___2 umbox64[32];
	uint8_t pdrv_state[75];
	uint32_t last_disp;
	int hw_error;
	int fast_load;
	uint8_t channel_class;
	struct mutex sysfs_mtx;
	uioc_t *sysfs_uioc;
	mbox64_t___2 *sysfs_mbox64;
	caddr_t sysfs_buffer;
	dma_addr_t sysfs_buffer_dma;
	wait_queue_head_t sysfs_wait_q;
	int random_del_supported;
	uint16_t curr_ldmap[64];
} mraid_device_t;

typedef struct {
	mega_adp_info adapter_info;
	mega_ldrv_info logdrv_info;
	mega_pdrv_info pdrv_info;
} mraid_inquiry;

typedef struct {
	mraid_inquiry raid_inq;
	u16 phys_drv_format[5];
	u8 stack_attn;
	u8 modem_status;
	u8 rsvd[2];
} __attribute__((packed)) mraid_ext_inquiry;

typedef struct {
	uint32_t global_counter;
	uint8_t param_counter;
	uint8_t param_id;
	uint16_t param_val;
	uint8_t write_config_counter;
	uint8_t write_config_rsvd[3];
	uint8_t ldrv_op_counter;
	uint8_t ldrv_opid;
	uint8_t ldrv_opcmd;
	uint8_t ldrv_opstatus;
	uint8_t ldrv_state_counter;
	uint8_t ldrv_state_id;
	uint8_t ldrv_state_new;
	uint8_t ldrv_state_old;
	uint8_t pdrv_state_counter;
	uint8_t pdrv_state_id;
	uint8_t pdrv_state_new;
	uint8_t pdrv_state_old;
	uint8_t pdrv_fmt_counter;
	uint8_t pdrv_fmt_id;
	uint8_t pdrv_fmt_val;
	uint8_t pdrv_fmt_rsvd;
	uint8_t targ_xfer_counter;
	uint8_t targ_xfer_id;
	uint8_t targ_xfer_val;
	uint8_t targ_xfer_rsvd;
	uint8_t fcloop_id_chg_counter;
	uint8_t fcloopid_pdrvid;
	uint8_t fcloop_id0;
	uint8_t fcloop_id1;
	uint8_t fcloop_state_counter;
	uint8_t fcloop_state0;
	uint8_t fcloop_state1;
	uint8_t fcloop_state_rsvd;
} mraid_notify_t;

typedef struct {
	uint32_t data_size;
	mraid_notify_t notify;
	uint8_t notify_rsvd[88];
	uint8_t rebuild_rate;
	uint8_t cache_flush_int;
	uint8_t sense_alert;
	uint8_t drive_insert_count;
	uint8_t battery_status;
	uint8_t num_ldrv;
	uint8_t recon_state[5];
	uint16_t ldrv_op_status[5];
	uint32_t ldrv_size[40];
	uint8_t ldrv_prop[40];
	uint8_t ldrv_state[40];
	uint8_t pdrv_state[256];
	uint16_t pdrv_format[16];
	uint8_t targ_xfer[80];
	uint8_t pad1k[263];
} __attribute__((packed)) mraid_inquiry3_t;

typedef struct {
	uint32_t data_size;
	uint32_t config_signature;
	uint8_t fw_version[16];
	uint8_t bios_version[16];
	uint8_t product_name[80];
	uint8_t max_commands;
	uint8_t nchannels;
	uint8_t fc_loop_present;
	uint8_t mem_type;
	uint32_t signature;
	uint16_t dram_size;
	uint16_t subsysid;
	uint16_t subsysvid;
	uint8_t notify_counters;
	uint8_t pad1k[889];
} mraid_pinfo_t;

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t handle_count;
	uint8_t entry_status;
	uint32_t sys_define_2;
	target_id_t target;
	uint8_t modifier;
	uint8_t reserved_1;
	__le16 sequence_number;
	__le16 lun;
	uint8_t reserved_2[48];
} mrk_entry_t;

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t handle_count;
	uint8_t entry_status;
	uint32_t handle1;
	target_id_t loop_id;
	__le16 status;
	__le16 control_flags;
	uint16_t reserved2;
	__le16 timeout;
	__le16 cmd_dsd_count;
	__le16 total_dsd_count;
	uint8_t type;
	uint8_t r_ctl;
	__le16 rx_id;
	uint16_t reserved3;
	uint32_t handle2;
	__le32 rsp_bytecount;
	__le32 req_bytecount;
	struct dsd64 req_dsd;
	struct dsd64 rsp_dsd;
} ms_iocb_entry_t;

typedef struct {} netdevice_tracker;

typedef struct {} netns_tracker;

typedef struct {
	char data[8];
} nfs4_verifier;

typedef struct {
	char signature[8];
	u32 opcode;
	u32 adapno;
	union {
		u8 __raw_mbox[18];
		void *__uaddr;
	} __ua;
	u32 xferlen;
	u32 flags;
} nitioctl_t;

typedef struct {
	long unsigned int bits[4];
} nodemask_t;

typedef struct {
	uint8_t id[4];
	uint8_t nvram_version;
	uint8_t reserved_0;
	uint8_t parameter_block_version;
	uint8_t reserved_1;
	uint8_t firmware_options[2];
	__le16 frame_payload_size;
	__le16 max_iocb_allocation;
	__le16 execution_throttle;
	uint8_t retry_count;
	uint8_t retry_delay;
	uint8_t port_name[8];
	uint16_t hard_address;
	uint8_t inquiry_data;
	uint8_t login_timeout;
	uint8_t node_name[8];
	uint8_t add_firmware_options[2];
	uint8_t response_accumulation_timer;
	uint8_t interrupt_delay_timer;
	uint8_t special_options[2];
	uint8_t reserved_2[22];
	uint8_t seriallink_options[4];
	uint8_t host_p[2];
	uint8_t boot_node_name[8];
	uint8_t boot_lun_number;
	uint8_t reset_delay;
	uint8_t port_down_retry_count;
	uint8_t boot_id_number;
	__le16 max_luns_per_target;
	uint8_t fcode_boot_port_name[8];
	uint8_t alternate_port_name[8];
	uint8_t alternate_node_name[8];
	uint8_t efi_parameters;
	uint8_t link_down_timeout;
	uint8_t adapter_id[16];
	uint8_t alt1_boot_node_name[8];
	uint16_t alt1_boot_lun_number;
	uint8_t alt2_boot_node_name[8];
	uint16_t alt2_boot_lun_number;
	uint8_t alt3_boot_node_name[8];
	uint16_t alt3_boot_lun_number;
	uint8_t alt4_boot_node_name[8];
	uint16_t alt4_boot_lun_number;
	uint8_t alt5_boot_node_name[8];
	uint16_t alt5_boot_lun_number;
	uint8_t alt6_boot_node_name[8];
	uint16_t alt6_boot_lun_number;
	uint8_t alt7_boot_node_name[8];
	uint16_t alt7_boot_lun_number;
	uint8_t reserved_3[2];
	uint8_t model_number[16];
	uint8_t oem_specific[16];
	uint8_t adapter_features[2];
	uint8_t reserved_4[16];
	uint16_t subsystem_vendor_id_2200;
	uint16_t subsystem_device_id_2200;
	uint8_t reserved_5;
	uint8_t checksum;
} nvram_t;

typedef struct {
	__be64 pgd;
} pgd_t;

typedef struct {
	pgd_t pgd;
} p4d_t;

typedef struct {
	u64 pme;
} pagemap_entry_t;

typedef struct {
	u32 token;
} papr_sysparm_t;

typedef struct {
	u64 val;
} pfn_t;

typedef struct {
	long unsigned int pgprot;
} pgprot_t;

typedef struct {
	__be64 pte;
} pte_t;

typedef pte_t *pgtable_t;

typedef struct {
	__be64 pmd;
} pmd_t;

typedef struct {
	uint8_t options;
	uint8_t control;
	uint8_t master_state;
	uint8_t slave_state;
	uint8_t reserved[2];
	uint8_t hard_address;
	uint8_t reserved_1;
	uint8_t port_id[4];
	uint8_t node_name[8];
	uint8_t port_name[8];
	__le16 execution_throttle;
	uint16_t execution_count;
	uint8_t reset_count;
	uint8_t reserved_2;
	uint16_t resource_allocation;
	uint16_t current_allocation;
	uint16_t queue_head;
	uint16_t queue_tail;
	uint16_t transmit_execution_list_next;
	uint16_t transmit_execution_list_previous;
	uint16_t common_features;
	uint16_t total_concurrent_sequences;
	uint16_t RO_by_information_category;
	uint8_t recipient;
	uint8_t initiator;
	uint16_t receive_data_size;
	uint16_t concurrent_sequences;
	uint16_t open_sequences_per_exchange;
	uint16_t lun_abort_flags;
	uint16_t lun_stop_flags;
	uint16_t stop_queue_head;
	uint16_t stop_queue_tail;
	uint16_t port_retry_timer;
	uint16_t next_sequence_id;
	uint16_t frame_count;
	uint16_t PRLI_payload_length;
	uint8_t prli_svc_param_word_0[2];
	uint8_t prli_svc_param_word_3[2];
	uint16_t loop_id;
	uint16_t extended_lun_info_list_pointer;
	uint16_t extended_lun_stop_list_pointer;
} port_database_t;

typedef union {
	uint32_t b24: 24;
	struct {
		uint8_t al_pa;
		uint8_t area;
		uint8_t domain;
		uint8_t rsvd_1;
	} b;
} port_id_t;

struct net;

typedef struct {
	struct net *net;
} possible_net_t;

typedef struct {
	u32 val;
	u32 suffix;
} ppc_inst_t;

typedef struct {
	__be64 pud;
} pud_t;

typedef struct {
	port_id_t id;
	int cmd_count;
	struct list_head list;
} qlt_port_logo_t;

typedef struct {
	short unsigned int encoding;
	short unsigned int parity;
} raw_hdlc_proto;

typedef struct {
	atomic_t refcnt;
} rcuref_t;

typedef struct {
	size_t written;
	size_t count;
	union {
		char *buf;
		void *data;
	} arg;
	int error;
} read_descriptor_t;

typedef struct {
	pte_t pte;
	long unsigned int hidx;
} real_pte_t;

typedef union {
} release_pages_arg;

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t sys_define;
	uint8_t entry_status;
	__le32 handle;
	uint8_t lun;
	uint8_t target;
	__le16 cdb_len;
	__le16 control_flags;
	__le16 reserved;
	__le16 timeout;
	__le16 dseg_count;
	uint8_t scsi_cdb[12];
	__le32 reserved_1[2];
	__le32 dseg_0_address[2];
	__le32 dseg_0_length;
	__le32 dseg_1_address[2];
	__le32 dseg_1_length;
} request_t;

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t sys_define;
	uint8_t entry_status;
	uint32_t handle;
	target_id_t target;
	__le16 lun;
	__le16 control_flags;
	uint16_t reserved_1;
	__le16 timeout;
	__le16 dseg_count;
	uint8_t scsi_cdb[16];
	uint32_t byte_count;
	struct dsd64 dsd[2];
} request_t___2;

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t sys_define;
	uint8_t entry_status;
	uint32_t handle;
	uint8_t data[52];
	uint32_t signature;
} response_t;

typedef struct {
	__u16 report_key_length;
	__u8 reserved1;
	__u8 reserved2;
	__u8 ucca: 3;
	__u8 vra: 3;
	__u8 type_code: 2;
	__u8 region_mask;
	__u8 rpc_scheme;
	__u8 reserved3;
} rpc_state_t;

typedef struct {
	const enum rtas_function_index index;
} rtas_fn_handle_t;

struct kref {
	refcount_t refcount;
};

struct scsi_device;

typedef struct {
	struct kref ref;
	struct list_head list;
	int minor;
	char name[8];
	struct scsi_device *device;
	struct scsi_device **dt;
	u_int firsts[8];
	u_int counts[8];
	u_int voltags;
	struct mutex lock;
} scsi_changer;

typedef struct {
	BIT_DStream_t DStream;
	ZSTD_fseState stateLL;
	ZSTD_fseState stateOffb;
	ZSTD_fseState stateML;
	size_t prevOffset[3];
} seqState_t;

typedef struct {
	U32 *splitLocations;
	size_t idx;
} seqStoreSplits;

typedef struct {
	size_t litLength;
	size_t matchLength;
	size_t offset;
} seq_t;

struct seqcount {
	unsigned int sequence;
};

typedef struct seqcount seqcount_t;

typedef struct {
	seqcount_t seqcount;
} seqcount_latch_t;

struct seqcount_spinlock {
	seqcount_t seqcount;
};

typedef struct seqcount_spinlock seqcount_spinlock_t;

typedef struct {
	seqcount_spinlock_t seqcount;
	spinlock_t lock;
} seqlock_t;

typedef struct {
	long unsigned int sig[1];
} sigset_t;

typedef struct {
	u64 key[2];
} siphash_key_t;

typedef struct {
	spinlock_t slock;
	int owned;
	wait_queue_head_t wq;
} socket_lock_t;

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t handle_count;
	uint8_t entry_status;
	uint32_t handle[15];
} sts21_entry_t;

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t handle_count;
	uint8_t entry_status;
	uint16_t handle[30];
} sts22_entry_t;

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t sys_define;
	uint8_t entry_status;
	uint8_t data[60];
} sts_cont_entry_t;

typedef struct {
	uint8_t entry_type;
	uint8_t entry_count;
	uint8_t sys_define;
	uint8_t entry_status;
	uint32_t handle;
	__le16 scsi_status;
	__le16 comp_status;
	__le16 state_flags;
	__le16 status_flags;
	__le16 rsp_info_len;
	__le16 req_sense_length;
	__le32 residual_length;
	uint8_t rsp_info[8];
	uint8_t req_sense_data[32];
} sts_entry_t;

typedef struct {
	char *from;
	char *to;
} substring_t;

typedef struct {
	port_id_t d_id;
	uint8_t node_name[8];
	uint8_t port_name[8];
	uint8_t fabric_port_name[8];
	uint16_t fp_speed;
	uint8_t fc4_type;
	uint8_t fc4_features;
} sw_info_t;

typedef struct {
	long unsigned int val;
} swp_entry_t;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
} sync_serial_settings;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
	unsigned int slot_map;
} te1_settings;

typedef struct {
	__be16 track_information_length;
	__u8 track_lsb;
	__u8 session_lsb;
	__u8 reserved1;
	__u8 track_mode: 4;
	__u8 copy: 1;
	__u8 damage: 1;
	__u8 reserved2: 2;
	__u8 data_mode: 4;
	__u8 fp: 1;
	__u8 packet: 1;
	__u8 blank: 1;
	__u8 rt: 1;
	__u8 nwa_v: 1;
	__u8 lra_v: 1;
	__u8 reserved3: 6;
	__be32 track_start;
	__be32 next_writable;
	__be32 free_blocks;
	__be32 fixed_packet_size;
	__be32 track_size;
	__be32 last_rec_address;
} track_information;

typedef struct {
	int data;
	int audio;
	int cdi;
	int xa;
	long int error;
} tracktype;

typedef struct {
	local64_t v;
} u64_stats_t;

typedef struct {
	__u8 b[16];
} uuid_t;

typedef __vector128 vector128;

typedef struct {
	gid_t val;
} vfsgid_t;

typedef struct {
	uid_t val;
} vfsuid_t;

typedef struct {
	short unsigned int dce;
	unsigned int modulo;
	unsigned int window;
	unsigned int t1;
	unsigned int t2;
	unsigned int n2;
} x25_hdlc_proto;

struct in6_addr {
	union {
		__u8 u6_addr8[16];
		__be16 u6_addr16[8];
		__be32 u6_addr32[4];
	} in6_u;
};

typedef union {
	__be32 a4;
	__be32 a6[4];
	struct in6_addr in6;
} xfrm_address_t;

typedef ZSTD_compressionParameters zstd_compression_parameters;

typedef ZSTD_frameHeader zstd_frame_header;

typedef ZSTD_parameters zstd_parameters;

struct ACE_HEADER {
	u8 AceType;
	u8 AceFlags;
	__le16 AceSize;
};

struct ACL {
	u8 AclRevision;
	u8 Sbz1;
	__le16 AclSize;
	__le16 AceCount;
	__le16 Sbz2;
};

struct SG32ENTRY {
	__le32 length;
	__le32 address;
};

struct SG64ENTRY {
	__le32 length;
	__le32 address;
	__le32 addresshigh;
};

struct ARCMSR_CDB {
	uint8_t Bus;
	uint8_t TargetID;
	uint8_t LUN;
	uint8_t Function;
	uint8_t CdbLength;
	uint8_t sgcount;
	uint8_t Flags;
	uint8_t msgPages;
	uint32_t msgContext;
	uint32_t DataLength;
	uint8_t Cdb[16];
	uint8_t DeviceStatus;
	uint8_t SenseData[15];
	union {
		struct SG32ENTRY sg32entry[1];
		struct SG64ENTRY sg64entry[1];
	} u;
};

union ATTO_SAS_ADDRESS {
	U8___2 b[8];
	U16___2 w[4];
	U32___2 d[2];
	U64 q;
};

struct ATTO_SAS_NVRAM {
	u8 Signature[4];
	u8 Version;
	u8 Checksum;
	u8 Pad[10];
	u8 SasAddr[8];
	u8 Reserved[232];
};

struct ATTR_RESIDENT {
	__le32 data_size;
	__le16 data_off;
	u8 flags;
	u8 res;
};

struct ATTR_NONRESIDENT {
	__le64 svcn;
	__le64 evcn;
	__le16 run_off;
	u8 c_unit;
	u8 res1[5];
	__le64 alloc_size;
	__le64 data_size;
	__le64 valid_size;
	__le64 total_size;
};

struct ATTRIB {
	enum ATTR_TYPE type;
	__le32 size;
	u8 non_res;
	u8 name_len;
	__le16 name_off;
	__le16 flags;
	__le16 id;
	union {
		struct ATTR_RESIDENT res;
		struct ATTR_NONRESIDENT nres;
	};
};

struct ATTR_DEF_ENTRY {
	__le16 name[64];
	enum ATTR_TYPE type;
	__le32 res;
	enum COLLATION_RULE rule;
	__le32 flags;
	__le64 min_sz;
	__le64 max_sz;
};

struct MFT_REF {
	__le32 low;
	__le16 high;
	__le16 seq;
};

struct NTFS_DUP_INFO {
	__le64 cr_time;
	__le64 m_time;
	__le64 c_time;
	__le64 a_time;
	__le64 alloc_size;
	__le64 data_size;
	enum FILE_ATTRIBUTE fa;
	__le16 ea_size;
	__le16 reparse;
};

struct ATTR_FILE_NAME {
	struct MFT_REF home;
	struct NTFS_DUP_INFO dup;
	u8 name_len;
	u8 type;
	__le16 name[0];
};

struct ATTR_LIST_ENTRY {
	enum ATTR_TYPE type;
	__le16 size;
	u8 name_len;
	u8 name_off;
	__le64 vcn;
	struct MFT_REF ref;
	__le16 id;
	__le16 name[0];
};

struct ATTR_NAME_ENTRY {
	__le16 off;
	__le16 name_bytes;
	__le16 name[0];
};

struct ATTR_STD_INFO {
	__le64 cr_time;
	__le64 m_time;
	__le64 c_time;
	__le64 a_time;
	enum FILE_ATTRIBUTE fa;
	__le32 max_ver_num;
	__le32 ver_num;
	__le32 class_id;
};

struct ATTR_STD_INFO5 {
	__le64 cr_time;
	__le64 m_time;
	__le64 c_time;
	__le64 a_time;
	enum FILE_ATTRIBUTE fa;
	__le32 max_ver_num;
	__le32 ver_num;
	__le32 class_id;
	__le32 owner_id;
	__le32 security_id;
	__le64 quota_charge;
	__le64 usn;
};

struct work_struct;

typedef void (*work_func_t)(struct work_struct *);

struct work_struct {
	atomic_long_t data;
	struct list_head entry;
	work_func_t func;
};

struct hlist_node {
	struct hlist_node *next;
	struct hlist_node **pprev;
};

struct timer_list {
	struct hlist_node entry;
	long unsigned int expires;
	void (*function)(struct timer_list *);
	u32 flags;
};

struct deliver_completeQ;

typedef struct deliver_completeQ *pCompletion_Q;

struct MessageUnit_A;

struct MessageUnit_B;

struct MessageUnit_C;

struct MessageUnit_D;

struct MessageUnit_E;

struct MessageUnit_F;

struct CommandControlBlock;

struct AdapterControlBlock {
	uint32_t adapter_type;
	u32 ioqueue_size;
	struct pci_dev *pdev;
	struct Scsi_Host *host;
	long unsigned int vir2phy_offset;
	uint32_t outbound_int_enable;
	uint32_t cdb_phyaddr_hi32;
	uint32_t reg_mu_acc_handle0;
	uint64_t cdb_phyadd_hipart;
	spinlock_t eh_lock;
	spinlock_t ccblist_lock;
	spinlock_t postq_lock;
	spinlock_t doneq_lock;
	spinlock_t rqbuffer_lock;
	spinlock_t wqbuffer_lock;
	union {
		struct MessageUnit_A *pmuA;
		struct MessageUnit_B *pmuB;
		struct MessageUnit_C *pmuC;
		struct MessageUnit_D *pmuD;
		struct MessageUnit_E *pmuE;
		struct MessageUnit_F *pmuF;
	};
	void *mem_base0;
	void *mem_base1;
	uint32_t *message_wbuffer;
	uint32_t *message_rbuffer;
	uint32_t *msgcode_rwbuffer;
	uint32_t acb_flags;
	u16 dev_id;
	uint8_t adapter_index;
	struct CommandControlBlock *pccb_pool[1024];
	struct list_head ccb_free_list;
	atomic_t ccboutstandingcount;
	void *dma_coherent;
	dma_addr_t dma_coherent_handle;
	dma_addr_t dma_coherent_handle2;
	void *dma_coherent2;
	unsigned int uncache_size;
	uint8_t rqbuffer[4096];
	int32_t rqbuf_getIndex;
	int32_t rqbuf_putIndex;
	uint8_t wqbuffer[4096];
	int32_t wqbuf_getIndex;
	int32_t wqbuf_putIndex;
	uint8_t devstate[136];
	uint32_t num_resets;
	uint32_t num_aborts;
	uint32_t signature;
	uint32_t firm_request_len;
	uint32_t firm_numbers_queue;
	uint32_t firm_sdram_size;
	uint32_t firm_hd_channels;
	uint32_t firm_cfg_version;
	char firm_model[12];
	char firm_version[20];
	char device_map[20];
	uint32_t firm_PicStatus;
	struct work_struct arcmsr_do_message_isr_bh;
	struct timer_list eternal_timer;
	short unsigned int fw_flag;
	uint32_t maxOutstanding;
	int vector_count;
	int xor_mega;
	uint32_t maxFreeCCB;
	struct timer_list refresh_timer;
	uint32_t doneq_index;
	uint32_t ccbsize;
	uint32_t in_doorbell;
	uint32_t out_doorbell;
	uint32_t completionQ_entry;
	pCompletion_Q pCompletionQ;
	uint32_t completeQ_size;
	void *xorVirt;
	dma_addr_t xorPhys;
	unsigned int init2cfg_size;
	unsigned int xorVirtOffset;
};

struct DeviceCtlBlk;

struct SGentry;

struct ScsiReqBlk {
	struct list_head list;
	struct DeviceCtlBlk *dcb;
	struct scsi_cmnd *cmd;
	struct SGentry *segment_x;
	dma_addr_t sg_bus_addr;
	u8 sg_count;
	u8 sg_index;
	size_t total_xfer_length;
	size_t request_length;
	size_t xferred;
	u16 state;
	u8 msgin_buf[6];
	u8 msgout_buf[6];
	u8 adapter_status;
	u8 target_status;
	u8 msg_count;
	u8 end_message;
	u8 tag_number;
	u8 status;
	u8 retry_count;
	u8 flag;
	u8 scsi_phase;
};

struct NVRamTarget {
	u8 cfg0;
	u8 period;
	u8 cfg2;
	u8 cfg3;
};

struct NvRamType {
	u8 sub_vendor_id[2];
	u8 sub_sys_id[2];
	u8 sub_class;
	u8 vendor_id[2];
	u8 device_id[2];
	u8 reserved;
	struct NVRamTarget target[16];
	u8 scsi_id;
	u8 channel_cfg;
	u8 delay_time;
	u8 max_tag;
	u8 reserved0;
	u8 boot_target;
	u8 boot_lun;
	u8 reserved1;
	u16 reserved2[22];
	u16 cksum;
};

struct AdapterCtlBlk {
	struct Scsi_Host *scsi_host;
	long unsigned int io_port_base;
	long unsigned int io_port_len;
	struct list_head dcb_list;
	struct DeviceCtlBlk *dcb_run_robin;
	struct DeviceCtlBlk *active_dcb;
	struct list_head srb_free_list;
	struct ScsiReqBlk *tmp_srb;
	struct timer_list waiting_timer;
	struct timer_list selto_timer;
	long unsigned int last_reset;
	u16 srb_count;
	u8 sel_timeout;
	unsigned int irq_level;
	u8 tag_max_num;
	u8 acb_flag;
	u8 gmode2;
	u8 config;
	u8 lun_chk;
	u8 scan_devices;
	u8 hostid_bit;
	u8 dcb_map[16];
	struct DeviceCtlBlk *children[512];
	struct pci_dev *dev;
	u8 msg_len;
	struct ScsiReqBlk srb_array[63];
	struct ScsiReqBlk srb;
	struct NvRamType eeprom;
};

struct BITMAP_RANGE {
	__le32 bitmap_off;
	__le32 bits;
};

struct sk_buff;

struct BufferControl {
	struct sk_buff *skb;
	dma_addr_t dma;
	unsigned int len;
};

struct CLIENT_ID {
	__le16 seq_num;
	__le16 client_idx;
};

struct CLIENT_REC {
	__le64 oldest_lsn;
	__le64 restart_lsn;
	__le16 prev_client;
	__le16 next_client;
	__le16 seq_num;
	u8 align[6];
	__le32 name_bytes;
	__le16 name[32];
};

struct CMD_MESSAGE {
	uint32_t HeaderLength;
	uint8_t Signature[8];
	uint32_t Timeout;
	uint32_t ControlCode;
	uint32_t ReturnCode;
	uint32_t Length;
};

struct CMD_MESSAGE_FIELD {
	struct CMD_MESSAGE cmdmessage;
	uint8_t messagedatabuffer[1032];
};

struct HostWrite {
	__le32 TransportRequest;
	__le32 command_pool_addr_hi;
	__le32 CoalIntDelay;
	__le32 CoalIntCount;
};

struct CfgTable {
	u8 Signature[4];
	__le32 SpecValence;
	__le32 TransportSupport;
	__le32 TransportActive;
	struct HostWrite HostWrite;
	__le32 CmdsOutMax;
	__le32 BusTypes;
	__le32 TransMethodOffset;
	u8 ServerName[16];
	__le32 HeartBeat;
	__le32 driver_support;
	__le32 MaxScatterGatherElements;
	__le32 MaxLogicalUnits;
	__le32 MaxPhysicalDevices;
	__le32 MaxPhysicalDrivesPerLogicalUnit;
	__le32 MaxPerformantModeCommands;
	__le32 MaxBlockFetch;
	__le32 PowerConservationSupport;
	__le32 PowerConservationEnable;
	__le32 TMFSupportFlags;
	u8 TMFTagMask[8];
	u8 reserved[8];
	__le32 misc_fw_support;
	u8 driver_version[32];
	__le32 max_cached_write_size;
	u8 driver_scratchpad[16];
	__le32 max_error_info_length;
	__le32 io_accel_max_embedded_sg_count;
	__le32 io_accel_request_size_offset;
	__le32 event_notify;
	__le32 clear_event_notify;
};

union SCSI3Addr {
	struct {
		u8 Dev;
		u8 Bus: 6;
		u8 Mode: 2;
	} PeripDev;
	struct {
		u8 DevLSB;
		u8 DevMSB: 6;
		u8 Mode: 2;
	} LogDev;
	struct {
		u8 Dev: 5;
		u8 Bus: 3;
		u8 Targ: 6;
		u8 Mode: 2;
	} LogUnit;
};

struct PhysDevAddr {
	u32 TargetId: 24;
	u32 Bus: 6;
	u32 Mode: 2;
	union SCSI3Addr Target[2];
};

struct LogDevAddr {
	u32 VolId: 30;
	u32 Mode: 2;
	u8 reserved[4];
};

union LUNAddr {
	u8 LunAddrBytes[8];
	union SCSI3Addr SCSI3Lun[4];
	struct PhysDevAddr PhysDev;
	struct LogDevAddr LogDev;
};

struct CommandListHeader {
	u8 ReplyQueue;
	u8 SGList;
	__le16 SGTotal;
	__le64 tag;
	union LUNAddr LUN;
} __attribute__((packed));

struct RequestBlock {
	u8 CDBLen;
	u8 type_attr_dir;
	u16 Timeout;
	u8 CDB[16];
};

struct ErrDescriptor {
	__le64 Addr;
	__le32 Len;
} __attribute__((packed));

struct Command {
	struct CommandListHeader CommandHeader;
	struct RequestBlock Request;
	struct ErrDescriptor ErrorDescriptor;
};

struct CommandControlBlock {
	struct list_head list;
	struct scsi_cmnd *pcmd;
	struct AdapterControlBlock *acb;
	long unsigned int cdb_phyaddr;
	uint32_t arc_cdb_size;
	uint16_t ccb_flags;
	uint16_t startdone;
	uint32_t smid;
	uint32_t reserved[3];
	struct ARCMSR_CDB arcmsr_cdb;
};

struct SGDescriptor {
	__le64 Addr;
	__le32 Len;
	__le32 Ext;
};

struct ErrorInfo;

struct ctlr_info;

struct hpsa_scsi_dev_t;

struct CommandList {
	struct CommandListHeader Header;
	struct RequestBlock Request;
	struct ErrDescriptor ErrDesc;
	struct SGDescriptor SG[32];
	u32 busaddr;
	struct ErrorInfo *err_info;
	struct ctlr_info *h;
	int cmd_type;
	long: 0;
	long int cmdindex;
	struct completion *waiting;
	struct scsi_cmnd *scsi_cmd;
	struct work_struct work;
	struct hpsa_scsi_dev_t *phys_disk;
	bool retry_pending;
	long: 0;
	struct hpsa_scsi_dev_t *device;
	atomic_t refcount;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} __attribute__((packed));

union CtCommandResponse {
	struct {
		__be16 CmdRsp;
		__be16 Size;
	} bits;
	uint32_t word;
};

union CtRevisionId {
	struct {
		uint32_t Revision: 8;
		uint32_t InId: 24;
	} bits;
	uint32_t word;
};

struct DIAG_BUFFER_START {
	__le32 Size;
	__le32 DiagVersion;
	u8 BufferType;
	u8 Reserved[3];
	__le32 Reserved1;
	__le32 Reserved2;
	__le32 Reserved3;
};

struct DIR_PAGE_ENTRY {
	__le32 next;
	__le32 target_attr;
	__le32 transfer_len;
	__le32 lcns_follow;
	__le64 vcn;
	__le64 oldest_lsn;
	__le64 page_lcns[0];
};

struct DIR_PAGE_ENTRY_32 {
	__le32 next;
	__le32 target_attr;
	__le32 transfer_len;
	__le32 lcns_follow;
	__le32 reserved;
	__le32 vcn_low;
	__le32 vcn_hi;
	__le32 oldest_lsn_low;
	__le32 oldest_lsn_hi;
	__le32 page_lcns_low;
	__le32 page_lcns_hi;
};

struct DeviceCtlBlk {
	struct list_head list;
	struct AdapterCtlBlk *acb;
	struct list_head srb_going_list;
	struct list_head srb_waiting_list;
	struct ScsiReqBlk *active_srb;
	u32 tag_mask;
	u16 max_command;
	u8 target_id;
	u8 target_lun;
	u8 identify_msg;
	u8 dev_mode;
	u8 inquiry7;
	u8 sync_mode;
	u8 min_nego_period;
	u8 sync_period;
	u8 sync_offset;
	u8 flag;
	u8 dev_type;
	u8 init_tcq_flag;
};

struct EA_FULL {
	__le32 size;
	u8 flags;
	u8 name_len;
	__le16 elength;
	u8 name[0];
};

struct EA_INFO {
	__le16 size_pack;
	__le16 count;
	__le32 size;
};

union MoreErrInfo {
	struct {
		u8 Reserved[3];
		u8 Type;
		u32 ErrorInfo;
	} Common_Info;
	struct {
		u8 Reserved[2];
		u8 offense_size;
		u8 offense_num;
		u32 offense_value;
	} Invalid_Cmd;
};

struct ErrorInfo {
	u8 ScsiStatus;
	u8 SenseLen;
	u16 CommandStatus;
	u32 ResidualCnt;
	union MoreErrInfo MoreErrInfo;
	u8 SenseInfo[32];
};

struct GUID {
	__le32 Data1;
	__le16 Data2;
	__le16 Data3;
	u8 Data4[8];
};

struct HostRamBuf {
	uint32_t hrbSignature;
	uint32_t hrbSize;
	uint32_t hrbRes[2];
};

struct NTFS_RECORD_HEADER {
	enum NTFS_SIGNATURE sign;
	__le16 fix_off;
	__le16 fix_num;
	__le64 lsn;
};

struct INDEX_HDR {
	__le32 de_off;
	__le32 used;
	__le32 total;
	__le32 flags;
};

struct INDEX_BUFFER {
	struct NTFS_RECORD_HEADER rhdr;
	__le64 vbn;
	struct INDEX_HDR ihdr;
};

struct INDEX_NAMES {
	const __le16 *name;
	u8 name_len;
};

struct INDEX_ROOT {
	enum ATTR_TYPE type;
	enum COLLATION_RULE rule;
	__le32 index_block_size;
	u8 index_block_clst;
	u8 res[3];
	struct INDEX_HDR ihdr;
};

struct IOV_111 {
	u8 maxVFsSupported;
	u8 numVFsEnabled;
	u8 requestorId;
	u8 reserved[5];
};

struct IO_REQUEST_INFO {
	u64 ldStartBlock;
	u32 numBlocks;
	u16 ldTgtId;
	u8 isRead;
	__le16 devHandle;
	u8 pd_interface;
	u64 pdBlock;
	u8 fpOkForIo;
	u8 IoforUnevenSpan;
	u8 start_span;
	u8 do_fp_rlbypass;
	u64 start_row;
	u8 span_arm;
	u8 pd_after_lb;
	u16 r1_alt_dev_handle;
	bool ra_capable;
	u8 data_arms;
};

struct InBound_SRB {
	uint32_t addressLow;
	uint32_t addressHigh;
	uint32_t length;
	uint32_t reserved0;
};

struct LCN_RANGE {
	__le64 lcn;
	__le64 len;
};

struct LD_LOAD_BALANCE_INFO {
	u8 loadBalanceFlag;
	u8 reserved1;
	atomic_t scsi_pending_cmds[256];
	u64 last_accessed_block[256];
};

struct megasas_cmd_fusion;

struct STREAM_DETECT {
	u64 next_seq_lba;
	struct megasas_cmd_fusion *first_cmd_fusion;
	struct megasas_cmd_fusion *last_cmd_fusion;
	u32 count_cmds_in_stream;
	u16 num_sges_in_group;
	u8 is_read;
	u8 group_depth;
	bool group_flush;
	u8 reserved[7];
};

struct LD_STREAM_DETECT {
	bool write_back;
	bool fp_write_enabled;
	bool members_ssds;
	bool fp_cache_bypass_capable;
	u32 mru_bit_map;
	struct STREAM_DETECT stream_track[8];
};

struct LFS_RECORD {
	__le16 next_record_off;
	u8 align[6];
	__le64 last_end_lsn;
};

struct LFS_RECORD_HDR {
	__le64 this_lsn;
	__le64 client_prev_lsn;
	__le64 client_undo_next_lsn;
	__le32 client_data_len;
	struct CLIENT_ID client;
	__le32 record_type;
	__le32 transact_id;
	__le16 flags;
	u8 align[6];
};

struct _LD_SPAN_SET {
	u64 log_start_lba;
	u64 log_end_lba;
	u64 span_row_start;
	u64 span_row_end;
	u64 data_strip_start;
	u64 data_strip_end;
	u64 data_row_start;
	u64 data_row_end;
	u8 strip_offset[8];
	u32 span_row_data_width;
	u32 diff;
	u32 reserved[2];
};

typedef struct _LD_SPAN_SET LD_SPAN_SET;

struct LOG_BLOCK_SPAN_INFO {
	LD_SPAN_SET span_set[8];
};

typedef struct LOG_BLOCK_SPAN_INFO LD_SPAN_INFO;

typedef struct LOG_BLOCK_SPAN_INFO *PLD_SPAN_INFO;

struct LOG_REC_HDR {
	__le16 redo_op;
	__le16 undo_op;
	__le16 redo_off;
	__le16 redo_len;
	__le16 undo_off;
	__le16 undo_len;
	__le16 target_attr;
	__le16 lcns_follow;
	__le16 record_off;
	__le16 attr_off;
	__le16 cluster_off;
	__le16 reserved;
	__le64 target_vcn;
	__le64 page_lcns[0];
};

struct MEGASAS_RAID_MFA_IO_REQUEST_DESCRIPTOR {
	u32 RequestFlags: 8;
	u32 MessageAddress1: 24;
	u32 MessageAddress2;
};

struct MPI2_DEFAULT_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 DescriptorTypeDependent;
};

struct MPI2_HIGH_PRIORITY_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 Reserved1;
};

struct MPI2_SCSI_IO_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 DevHandle;
};

struct MPI2_SCSI_TARGET_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 IoIndex;
};

struct MPI2_RAID_ACCEL_REQUEST_DESCRIPTOR {
	u8 RequestFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 LMID;
	__le16 Reserved;
};

union MEGASAS_REQUEST_DESCRIPTOR_UNION {
	struct MPI2_DEFAULT_REQUEST_DESCRIPTOR Default;
	struct MPI2_HIGH_PRIORITY_REQUEST_DESCRIPTOR HighPriority;
	struct MPI2_SCSI_IO_REQUEST_DESCRIPTOR SCSIIO;
	struct MPI2_SCSI_TARGET_REQUEST_DESCRIPTOR SCSITarget;
	struct MPI2_RAID_ACCEL_REQUEST_DESCRIPTOR RAIDAccelerator;
	struct MEGASAS_RAID_MFA_IO_REQUEST_DESCRIPTOR MFAIo;
	union {
		struct {
			__le32 low;
			__le32 high;
		} u;
		__le64 Words;
	};
};

struct MFT_REC {
	struct NTFS_RECORD_HEADER rhdr;
	__le16 seq;
	__le16 hard_links;
	__le16 attr_off;
	__le16 flags;
	__le32 used;
	__le32 total;
	struct MFT_REF parent_ref;
	__le16 next_attr_id;
	__le16 res;
	__le32 mft_record;
	__le16 fixups[0];
};

struct MPI25_IEEE_SGE_CHAIN64 {
	__le64 Address;
	__le32 Length;
	__le16 Reserved1;
	u8 NextChainOffset;
	u8 Flags;
};

struct MPI2_ADDRESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le32 ReplyFrameAddress;
};

struct MPI2_DEFAULT_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 DescriptorTypeDependent1;
	__le32 DescriptorTypeDependent2;
};

struct MPI2_IEEE_SGE_CHAIN32 {
	__le32 Address;
	__le32 FlagsLength;
};

struct MPI2_IEEE_SGE_CHAIN64 {
	__le64 Address;
	__le32 Length;
	__le16 Reserved1;
	u8 Reserved2;
	u8 Flags;
};

union MPI2_IEEE_SGE_CHAIN_UNION {
	struct MPI2_IEEE_SGE_CHAIN32 Chain32;
	struct MPI2_IEEE_SGE_CHAIN64 Chain64;
};

struct MPI2_IEEE_SGE_SIMPLE32 {
	__le32 Address;
	__le32 FlagsLength;
};

struct MPI2_IEEE_SGE_SIMPLE64 {
	__le64 Address;
	__le32 Length;
	__le16 Reserved1;
	u8 Reserved2;
	u8 Flags;
};

union MPI2_IEEE_SGE_SIMPLE_UNION {
	struct MPI2_IEEE_SGE_SIMPLE32 Simple32;
	struct MPI2_IEEE_SGE_SIMPLE64 Simple64;
};

struct MPI2_IOC_INIT_RDPQ_ARRAY_ENTRY {
	u64 RDPQBaseAddress;
	u32 Reserved1;
	u32 Reserved2;
};

struct MPI2_IOC_INIT_REQUEST {
	u8 WhoInit;
	u8 Reserved1;
	u8 ChainOffset;
	u8 Function;
	__le16 Reserved2;
	u8 Reserved3;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	__le16 Reserved4;
	__le16 MsgVersion;
	__le16 HeaderVersion;
	u32 Reserved5;
	__le16 Reserved6;
	u8 HostPageSize;
	u8 HostMSIxVectors;
	__le16 Reserved8;
	__le16 SystemRequestFrameSize;
	__le16 ReplyDescriptorPostQueueDepth;
	__le16 ReplyFreeQueueDepth;
	__le32 SenseBufferAddressHigh;
	__le32 SystemReplyAddressHigh;
	__le64 SystemRequestFrameBaseAddress;
	__le64 ReplyDescriptorPostQueueAddress;
	__le64 ReplyFreeQueueAddress;
	__le64 TimeStamp;
};

struct MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le32 Reserved;
};

struct MPI2_SCSI_IO_CDB_EEDP32 {
	u8 CDB[20];
	__be32 PrimaryReferenceTag;
	__be16 PrimaryApplicationTag;
	__be16 PrimaryApplicationTagMask;
	__le32 TransferLength;
};

struct MPI2_SGE_SIMPLE_UNION {
	__le32 FlagsLength;
	union {
		__le32 Address32;
		__le64 Address64;
	} u;
};

union MPI2_SCSI_IO_CDB_UNION {
	u8 CDB32[32];
	struct MPI2_SCSI_IO_CDB_EEDP32 EEDP32;
	struct MPI2_SGE_SIMPLE_UNION SGE;
};

struct RAID_CONTEXT {
	u8 type: 4;
	u8 nseg: 4;
	u8 resvd0;
	__le16 timeout_value;
	u8 reg_lock_flags;
	u8 resvd1;
	__le16 virtual_disk_tgt_id;
	__le64 reg_lock_row_lba;
	__le32 reg_lock_length;
	__le16 next_lmid;
	u8 ex_status;
	u8 status;
	u8 raid_flags;
	u8 num_sge;
	__le16 config_seq_num;
	u8 span_arm;
	u8 priority;
	u8 num_sge_ext;
	u8 resvd2;
};

struct RAID_CONTEXT_G35 {
	u16 nseg_type;
	u16 timeout_value;
	u16 routing_flags;
	u16 virtual_disk_tgt_id;
	__le64 reg_lock_row_lba;
	u32 reg_lock_length;
	union {
		u16 rmw_op_index;
		u16 peer_smid;
		u16 r56_arm_map;
	} flow_specific;
	u8 ex_status;
	u8 status;
	u8 raid_flags;
	u8 span_arm;
	u16 config_seq_num;
	union {
		struct {
			u16 num_sge: 12;
			u16 reserved: 3;
			u16 stream_detected: 1;
		} bits;
		u8 bytes[2];
	} u;
	u8 resvd2[2];
};

union RAID_CONTEXT_UNION {
	struct RAID_CONTEXT raid_context;
	struct RAID_CONTEXT_G35 raid_context_g35;
};

struct MPI2_SGE_CHAIN_UNION {
	__le16 Length;
	u8 NextChainOffset;
	u8 Flags;
	union {
		__le32 Address32;
		__le64 Address64;
	} u;
};

union MPI2_SGE_IO_UNION {
	struct MPI2_SGE_SIMPLE_UNION MpiSimple;
	struct MPI2_SGE_CHAIN_UNION MpiChain;
	union MPI2_IEEE_SGE_SIMPLE_UNION IeeeSimple;
	union MPI2_IEEE_SGE_CHAIN_UNION IeeeChain;
};

struct MPI2_RAID_SCSI_IO_REQUEST {
	__le16 DevHandle;
	u8 ChainOffset;
	u8 Function;
	__le16 Reserved1;
	u8 Reserved2;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	__le16 Reserved3;
	__le32 SenseBufferLowAddress;
	__le16 SGLFlags;
	u8 SenseBufferLength;
	u8 Reserved4;
	u8 SGLOffset0;
	u8 SGLOffset1;
	u8 SGLOffset2;
	u8 SGLOffset3;
	__le32 SkipCount;
	__le32 DataLength;
	__le32 BidirectionalDataLength;
	__le16 IoFlags;
	__le16 EEDPFlags;
	__le32 EEDPBlockSize;
	__le32 SecondaryReferenceTag;
	__le16 SecondaryApplicationTag;
	__le16 ApplicationTagTranslationMask;
	u8 LUN[8];
	__le32 Control;
	union MPI2_SCSI_IO_CDB_UNION CDB;
	union RAID_CONTEXT_UNION RaidContext;
	union {
		union MPI2_SGE_IO_UNION SGL;
		struct {
			struct {} __empty_SGLs;
			union MPI2_SGE_IO_UNION SGLs[0];
		};
	};
};

struct MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	__le16 TaskTag;
	__le16 Reserved1;
};

struct MPI2_TARGETASSIST_SUCCESS_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	__le16 SMID;
	u8 SequenceNumber;
	u8 Reserved1;
	__le16 IoIndex;
};

struct MPI2_TARGET_COMMAND_BUFFER_REPLY_DESCRIPTOR {
	u8 ReplyFlags;
	u8 MSIxIndex;
	u8 VP_ID;
	u8 Flags;
	__le16 InitiatorDevHandle;
	__le16 IoIndex;
};

union MPI2_REPLY_DESCRIPTORS_UNION {
	struct MPI2_DEFAULT_REPLY_DESCRIPTOR Default;
	struct MPI2_ADDRESS_REPLY_DESCRIPTOR AddressReply;
	struct MPI2_SCSI_IO_SUCCESS_REPLY_DESCRIPTOR SCSIIOSuccess;
	struct MPI2_TARGETASSIST_SUCCESS_REPLY_DESCRIPTOR TargetAssistSuccess;
	struct MPI2_TARGET_COMMAND_BUFFER_REPLY_DESCRIPTOR TargetCommandBuffer;
	struct MPI2_RAID_ACCELERATOR_SUCCESS_REPLY_DESCRIPTOR RAIDAcceleratorSuccess;
	__le64 Words;
};

struct MPI2_SCSI_TASK_MANAGE_REPLY {
	u16 DevHandle;
	u8 MsgLength;
	u8 Function;
	u8 ResponseCode;
	u8 TaskType;
	u8 Reserved1;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	u16 Reserved2;
	u16 Reserved3;
	u16 IOCStatus;
	u32 IOCLogInfo;
	u32 TerminationCount;
	u32 ResponseInfo;
};

struct MPI2_SCSI_TASK_MANAGE_REQUEST {
	u16 DevHandle;
	u8 ChainOffset;
	u8 Function;
	u8 Reserved1;
	u8 TaskType;
	u8 Reserved2;
	u8 MsgFlags;
	u8 VP_ID;
	u8 VF_ID;
	u16 Reserved3;
	u8 LUN[8];
	u32 Reserved4[7];
	u16 TaskMID;
	u16 Reserved5;
};

struct workqueue_struct;

struct delayed_work {
	struct work_struct work;
	struct timer_list timer;
	struct workqueue_struct *wq;
	int cpu;
};

struct MPT3SAS_ADAPTER;

typedef void (*MPT3SAS_FLUSH_RUNNING_CMDS)(struct MPT3SAS_ADAPTER *);

struct _internal_cmd {
	struct mutex mutex;
	struct completion done;
	void *reply;
	void *sense;
	u16 status;
	u16 smid;
};

typedef void (*MPT_ADD_SGE)(void *, u32, dma_addr_t);

struct _pcie_device;

typedef int (*MPT_BUILD_SG_SCMD)(struct MPT3SAS_ADAPTER *, struct scsi_cmnd *, u16, struct _pcie_device *);

typedef void (*MPT_BUILD_SG)(struct MPT3SAS_ADAPTER *, void *, dma_addr_t, size_t, dma_addr_t, size_t);

typedef void (*MPT_BUILD_ZERO_LEN_SGE)(struct MPT3SAS_ADAPTER *, void *);

struct _MPI26_NVME_ENCAPSULATED_REQUEST;

typedef struct _MPI26_NVME_ENCAPSULATED_REQUEST Mpi26NVMeEncapsulatedRequest_t;

typedef void (*NVME_BUILD_PRP)(struct MPT3SAS_ADAPTER *, u16, Mpi26NVMeEncapsulatedRequest_t *, dma_addr_t, size_t, dma_addr_t, size_t);

struct _MPI2_VERSION_STRUCT {
	U8___2 Dev;
	U8___2 Unit;
	U8___2 Minor;
	U8___2 Major;
};

typedef struct _MPI2_VERSION_STRUCT MPI2_VERSION_STRUCT;

union mpi3_version_union {
	MPI2_VERSION_STRUCT Struct;
	u32 Word;
};

struct mpt3sas_facts {
	u16 MsgVersion;
	u16 HeaderVersion;
	u8 IOCNumber;
	u8 VP_ID;
	u8 VF_ID;
	u16 IOCExceptions;
	u16 IOCStatus;
	u32 IOCLogInfo;
	u8 MaxChainDepth;
	u8 WhoInit;
	u8 NumberOfPorts;
	u8 MaxMSIxVectors;
	u16 RequestCredit;
	u16 ProductID;
	u32 IOCCapabilities;
	union mpi3_version_union FWVersion;
	u16 IOCRequestFrameSize;
	u16 IOCMaxChainSegmentSize;
	u16 MaxInitiators;
	u16 MaxTargets;
	u16 MaxSasExpanders;
	u16 MaxEnclosures;
	u16 ProtocolFlags;
	u16 HighPriorityCredit;
	u16 MaxReplyDescriptorPostQueueDepth;
	u8 ReplyFrameSize;
	u8 MaxVolumes;
	u16 MaxDevHandle;
	u16 MaxPersistentEntries;
	u16 MinDevHandle;
	u8 CurrentHostPageSize;
};

struct _MPI2_CONFIG_PAGE_HEADER {
	U8___2 PageVersion;
	U8___2 PageLength;
	U8___2 PageNumber;
	U8___2 PageType;
};

typedef struct _MPI2_CONFIG_PAGE_HEADER MPI2_CONFIG_PAGE_HEADER;

struct _MPI2_CONFIG_PAGE_MAN_0 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U8___2 ChipName[16];
	U8___2 ChipRevision[8];
	U8___2 BoardName[16];
	U8___2 BoardAssembly[16];
	U8___2 BoardTracerNumber[16];
};

typedef struct _MPI2_CONFIG_PAGE_MAN_0 Mpi2ManufacturingPage0_t;

struct Mpi2ManufacturingPage10_t {
	MPI2_CONFIG_PAGE_HEADER Header;
	U8___2 OEMIdentifier;
	U8___2 Reserved1;
	U16___2 Reserved2;
	U32___2 Reserved3;
	U32___2 GenericFlags0;
	U32___2 GenericFlags1;
	U32___2 Reserved4;
	U32___2 OEMSpecificFlags0;
	U32___2 OEMSpecificFlags1;
	U32___2 Reserved5[18];
};

struct Mpi2ManufacturingPage11_t {
	MPI2_CONFIG_PAGE_HEADER Header;
	__le32 Reserved1;
	u8 Reserved2;
	u8 EEDPTagMode;
	u8 Reserved3;
	u8 Reserved4;
	__le32 Reserved5[8];
	u16 AddlFlags2;
	u8 AddlFlags3;
	u8 Reserved6;
	__le32 Reserved7[7];
	u8 NVMeAbortTO;
	u8 NumPerDevEvents;
	u8 HostTraceBufferDecrementSizeKB;
	u8 HostTraceBufferFlags;
	u16 HostTraceBufferMaxSizeKB;
	u16 HostTraceBufferMinSizeKB;
	u8 CoreDumpTOSec;
	u8 TimeSyncInterval;
	u16 Reserved9;
	__le32 Reserved10;
};

struct _MPI2_BOOT_DEVICE_ADAPTER_ORDER {
	U32___2 Reserved1;
	U32___2 Reserved2;
	U32___2 Reserved3;
	U32___2 Reserved4;
	U32___2 Reserved5;
	U32___2 Reserved6;
};

typedef struct _MPI2_BOOT_DEVICE_ADAPTER_ORDER MPI2_BOOT_DEVICE_ADAPTER_ORDER;

struct _MPI2_BOOT_DEVICE_SAS_WWID {
	U64 SASAddress;
	U8___2 LUN[8];
	U32___2 Reserved1;
	U32___2 Reserved2;
};

typedef struct _MPI2_BOOT_DEVICE_SAS_WWID MPI2_BOOT_DEVICE_SAS_WWID;

struct _MPI2_BOOT_DEVICE_ENCLOSURE_SLOT {
	U64 EnclosureLogicalID;
	U32___2 Reserved1;
	U32___2 Reserved2;
	U16___2 SlotNumber;
	U16___2 Reserved3;
	U32___2 Reserved4;
};

typedef struct _MPI2_BOOT_DEVICE_ENCLOSURE_SLOT MPI2_BOOT_DEVICE_ENCLOSURE_SLOT;

struct _MPI2_BOOT_DEVICE_DEVICE_NAME {
	U64 DeviceName;
	U8___2 LUN[8];
	U32___2 Reserved1;
	U32___2 Reserved2;
};

typedef struct _MPI2_BOOT_DEVICE_DEVICE_NAME MPI2_BOOT_DEVICE_DEVICE_NAME;

union _MPI2_MPI2_BIOSPAGE2_BOOT_DEVICE {
	MPI2_BOOT_DEVICE_ADAPTER_ORDER AdapterOrder;
	MPI2_BOOT_DEVICE_SAS_WWID SasWwid;
	MPI2_BOOT_DEVICE_ENCLOSURE_SLOT EnclosureSlot;
	MPI2_BOOT_DEVICE_DEVICE_NAME DeviceName;
};

typedef union _MPI2_MPI2_BIOSPAGE2_BOOT_DEVICE MPI2_BIOSPAGE2_BOOT_DEVICE;

struct _MPI2_CONFIG_PAGE_BIOS_2 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U32___2 Reserved1;
	U32___2 Reserved2;
	U32___2 Reserved3;
	U32___2 Reserved4;
	U32___2 Reserved5;
	U32___2 Reserved6;
	U8___2 ReqBootDeviceForm;
	U8___2 Reserved7;
	U16___2 Reserved8;
	MPI2_BIOSPAGE2_BOOT_DEVICE RequestedBootDevice;
	U8___2 ReqAltBootDeviceForm;
	U8___2 Reserved9;
	U16___2 Reserved10;
	MPI2_BIOSPAGE2_BOOT_DEVICE RequestedAltBootDevice;
	U8___2 CurrentBootDeviceForm;
	U8___2 Reserved11;
	U16___2 Reserved12;
	MPI2_BIOSPAGE2_BOOT_DEVICE CurrentBootDevice;
} __attribute__((packed));

typedef struct _MPI2_CONFIG_PAGE_BIOS_2 Mpi2BiosPage2_t;

struct _MPI2_ADAPTER_INFO {
	U8___2 PciBusNumber;
	U8___2 PciDeviceAndFunctionNumber;
	U16___2 AdapterFlags;
};

typedef struct _MPI2_ADAPTER_INFO MPI2_ADAPTER_INFO;

struct _MPI2_ADAPTER_ORDER_AUX {
	U64 WWID;
	U32___2 Reserved1;
	U32___2 Reserved2;
};

typedef struct _MPI2_ADAPTER_ORDER_AUX MPI2_ADAPTER_ORDER_AUX;

struct _MPI2_CONFIG_PAGE_BIOS_3 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U32___2 GlobalFlags;
	U32___2 BiosVersion;
	MPI2_ADAPTER_INFO AdapterOrder[4];
	U32___2 Reserved1;
	MPI2_ADAPTER_ORDER_AUX AdapterOrderAux[4];
};

typedef struct _MPI2_CONFIG_PAGE_BIOS_3 Mpi2BiosPage3_t;

struct _MPI2_CONFIG_PAGE_IOC_8 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U8___2 NumDevsPerEnclosure;
	U8___2 Reserved1;
	U16___2 Reserved2;
	U16___2 MaxPersistentEntries;
	U16___2 MaxNumPhysicalMappedIDs;
	U16___2 Flags;
	U16___2 Reserved3;
	U16___2 IRVolumeMappingFlags;
	U16___2 Reserved4;
	U32___2 Reserved5;
};

typedef struct _MPI2_CONFIG_PAGE_IOC_8 Mpi2IOCPage8_t;

union _MPI2_VERSION_UNION {
	MPI2_VERSION_STRUCT Struct;
	U32___2 Word;
};

typedef union _MPI2_VERSION_UNION MPI2_VERSION_UNION;

struct _MPI2_CONFIG_PAGE_IO_UNIT_0 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U64 UniqueValue;
	MPI2_VERSION_UNION NvdataVersionDefault;
	MPI2_VERSION_UNION NvdataVersionPersistent;
} __attribute__((packed));

typedef struct _MPI2_CONFIG_PAGE_IO_UNIT_0 Mpi2IOUnitPage0_t;

struct _MPI2_CONFIG_PAGE_IO_UNIT_1 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U32___2 Flags;
};

typedef struct _MPI2_CONFIG_PAGE_IO_UNIT_1 Mpi2IOUnitPage1_t;

struct _MPI2_CONFIG_PAGE_IOC_1 {
	MPI2_CONFIG_PAGE_HEADER Header;
	U32___2 Flags;
	U32___2 CoalescingTimeout;
	U8___2 CoalescingDepth;
	U8___2 PCISlotNum;
	U8___2 PCIBusNum;
	U8___2 PCIDomainSegment;
	U32___2 Reserved1;
	U32___2 ProductSpecific;
};

typedef struct _MPI2_CONFIG_PAGE_IOC_1 Mpi2IOCPage1_t;

struct _boot_device {
	int channel;
	void *device;
};

struct device;

struct hba_port;

struct _sas_phy;

struct sas_rphy;

struct _sas_node {
	struct list_head list;
	struct device *parent_dev;
	u8 num_phys;
	u64 sas_address;
	u16 handle;
	u64 sas_address_parent;
	u16 enclosure_handle;
	u64 enclosure_logical_id;
	u8 responding;
	u8 nr_phys_allocated;
	struct hba_port *port;
	struct _sas_phy *phy;
	struct list_head sas_port_list;
	struct sas_rphy *rphy;
};

struct htb_rel_query {
	u16 buffer_rel_condition;
	u16 reserved;
	u32 trigger_type;
	u32 trigger_info_dwords[2];
};

typedef u32 (*BASE_READ_REG)(const void *);

struct SL_WH_MASTER_TRIGGER_T {
	uint32_t MasterData;
};

struct SL_WH_EVENT_TRIGGER_T {
	uint16_t EventValue;
	uint16_t LogEntryQualifier;
};

struct SL_WH_EVENT_TRIGGERS_T {
	uint32_t ValidEntries;
	struct SL_WH_EVENT_TRIGGER_T EventTriggerEntry[20];
};

struct SL_WH_SCSI_TRIGGER_T {
	U8___2 ASCQ;
	U8___2 ASC;
	U8___2 SenseKey;
	U8___2 Reserved;
};

struct SL_WH_SCSI_TRIGGERS_T {
	uint32_t ValidEntries;
	struct SL_WH_SCSI_TRIGGER_T SCSITriggerEntry[20];
};

struct SL_WH_MPI_TRIGGER_T {
	uint16_t IOCStatus;
	uint16_t Reserved;
	uint32_t IocLogInfo;
};

struct SL_WH_MPI_TRIGGERS_T {
	uint32_t ValidEntries;
	struct SL_WH_MPI_TRIGGER_T MPITriggerEntry[20];
};

typedef void (*PUT_SMID_IO_FP_HIP)(struct MPT3SAS_ADAPTER *, u16, u16);

typedef void (*PUT_SMID_DEFAULT)(struct MPT3SAS_ADAPTER *, u16);

typedef u8 (*GET_MSIX_INDEX)(struct MPT3SAS_ADAPTER *, struct scsi_cmnd *);

struct _MPI2_SYSTEM_INTERFACE_REGS;

typedef struct _MPI2_SYSTEM_INTERFACE_REGS Mpi2SystemInterfaceRegs_t;

struct fw_event_work;

struct io_uring_poll_queue;

struct mpt3sas_port_facts;

struct pcie_sg_list;

struct chain_lookup;

struct request_tracker;

struct reply_post_struct;

struct _MPI2_IOC_INIT_RDPQ_ARRAY_ENTRY;

typedef struct _MPI2_IOC_INIT_RDPQ_ARRAY_ENTRY Mpi2IOCInitRDPQArrayEntry;

struct MPT3SAS_ADAPTER {
	struct list_head list;
	struct Scsi_Host *shost;
	u8 id;
	int cpu_count;
	char name[32];
	char driver_name[24];
	char tmp_string[64];
	struct pci_dev *pdev;
	Mpi2SystemInterfaceRegs_t *chip;
	phys_addr_t chip_phys;
	int logging_level;
	int fwfault_debug;
	u8 ir_firmware;
	int bars;
	u8 mask_interrupts;
	char fault_reset_work_q_name[20];
	struct workqueue_struct *fault_reset_work_q;
	struct delayed_work fault_reset_work;
	char firmware_event_name[20];
	struct workqueue_struct *firmware_event_thread;
	spinlock_t fw_event_lock;
	struct list_head fw_event_list;
	struct fw_event_work *current_event;
	u8 fw_events_cleanup;
	int aen_event_read_flag;
	u8 broadcast_aen_busy;
	u16 broadcast_aen_pending;
	u8 shost_recovery;
	u8 got_task_abort_from_ioctl;
	struct mutex reset_in_progress_mutex;
	struct mutex hostdiag_unlock_mutex;
	spinlock_t ioc_reset_in_progress_lock;
	u8 ioc_link_reset_in_progress;
	u8 ignore_loginfos;
	u8 remove_host;
	u8 pci_error_recovery;
	u8 wait_for_discovery_to_complete;
	u8 is_driver_loading;
	u8 port_enable_failed;
	u8 start_scan;
	u16 start_scan_failed;
	u8 msix_enable;
	u16 msix_vector_count;
	u8 *cpu_msix_table;
	u16 cpu_msix_table_sz;
	resource_size_t **reply_post_host_index;
	u32 ioc_reset_count;
	MPT3SAS_FLUSH_RUNNING_CMDS schedule_dead_ioc_flush_running_cmds;
	u32 non_operational_loop;
	u8 ioc_coredump_loop;
	u32 timestamp_update_count;
	u32 time_sync_interval;
	atomic64_t total_io_cnt;
	atomic64_t high_iops_outstanding;
	bool msix_load_balance;
	u16 thresh_hold;
	u8 high_iops_queues;
	u8 iopoll_q_start_index;
	u32 drv_internal_flags;
	u32 drv_support_bitmap;
	u32 dma_mask;
	bool enable_sdev_max_qd;
	bool use_32bit_dma;
	struct io_uring_poll_queue *io_uring_poll_queues;
	u8 scsi_io_cb_idx;
	u8 tm_cb_idx;
	u8 transport_cb_idx;
	u8 scsih_cb_idx;
	u8 ctl_cb_idx;
	u8 base_cb_idx;
	u8 port_enable_cb_idx;
	u8 config_cb_idx;
	u8 tm_tr_cb_idx;
	u8 tm_tr_volume_cb_idx;
	u8 tm_sas_control_cb_idx;
	struct _internal_cmd base_cmds;
	struct _internal_cmd port_enable_cmds;
	struct _internal_cmd transport_cmds;
	struct _internal_cmd scsih_cmds;
	struct _internal_cmd tm_cmds;
	struct _internal_cmd ctl_cmds;
	struct _internal_cmd config_cmds;
	MPT_ADD_SGE base_add_sg_single;
	MPT_BUILD_SG_SCMD build_sg_scmd;
	MPT_BUILD_SG build_sg;
	MPT_BUILD_ZERO_LEN_SGE build_zero_len_sge;
	u16 sge_size_ieee;
	u16 hba_mpi_version_belonged;
	MPT_BUILD_SG build_sg_mpi;
	MPT_BUILD_ZERO_LEN_SGE build_zero_len_sge_mpi;
	NVME_BUILD_PRP build_nvme_prp;
	u32 event_type[4];
	u32 event_context;
	void *event_log;
	u32 event_masks[4];
	u8 tm_custom_handling;
	u8 nvme_abort_timeout;
	u16 max_shutdown_latency;
	u16 max_wideport_qd;
	u16 max_narrowport_qd;
	u16 max_nvme_qd;
	u8 max_sata_qd;
	struct mpt3sas_facts facts;
	struct mpt3sas_facts prev_fw_facts;
	struct mpt3sas_port_facts *pfacts;
	Mpi2ManufacturingPage0_t manu_pg0;
	struct Mpi2ManufacturingPage10_t manu_pg10;
	struct Mpi2ManufacturingPage11_t manu_pg11;
	Mpi2BiosPage2_t bios_pg2;
	Mpi2BiosPage3_t bios_pg3;
	Mpi2IOCPage8_t ioc_pg8;
	Mpi2IOUnitPage0_t iounit_pg0;
	Mpi2IOUnitPage1_t iounit_pg1;
	Mpi2IOCPage1_t ioc_pg1_copy;
	struct _boot_device req_boot_device;
	struct _boot_device req_alt_boot_device;
	struct _boot_device current_boot_device;
	struct _sas_node sas_hba;
	struct list_head sas_expander_list;
	struct list_head enclosure_list;
	spinlock_t sas_node_lock;
	struct list_head sas_device_list;
	struct list_head sas_device_init_list;
	spinlock_t sas_device_lock;
	struct list_head pcie_device_list;
	struct list_head pcie_device_init_list;
	spinlock_t pcie_device_lock;
	struct list_head raid_device_list;
	spinlock_t raid_device_lock;
	u8 io_missing_delay;
	u16 device_missing_delay;
	int sas_id;
	int pcie_target_id;
	void *blocking_handles;
	void *pd_handles;
	u16 pd_handles_sz;
	void *pend_os_device_add;
	u16 pend_os_device_add_sz;
	u16 config_page_sz;
	void *config_page;
	dma_addr_t config_page_dma;
	void *config_vaddr;
	u16 hba_queue_depth;
	u16 sge_size;
	u16 scsiio_depth;
	u16 request_sz;
	u8 *request;
	dma_addr_t request_dma;
	u32 request_dma_sz;
	struct pcie_sg_list *pcie_sg_lookup;
	spinlock_t scsi_lookup_lock;
	int pending_io_count;
	wait_queue_head_t reset_wq;
	u16 *io_queue_num;
	struct dma_pool *pcie_sgl_dma_pool;
	u32 page_size;
	struct chain_lookup *chain_lookup;
	struct list_head free_chain_list;
	struct dma_pool *chain_dma_pool;
	ulong chain_pages;
	u16 max_sges_in_main_message;
	u16 max_sges_in_chain_message;
	u16 chains_needed_per_io;
	u32 chain_depth;
	u16 chain_segment_sz;
	u16 chains_per_prp_buffer;
	u16 hi_priority_smid;
	u8 *hi_priority;
	dma_addr_t hi_priority_dma;
	u16 hi_priority_depth;
	struct request_tracker *hpr_lookup;
	struct list_head hpr_free_list;
	u16 internal_smid;
	u8 *internal;
	dma_addr_t internal_dma;
	u16 internal_depth;
	struct request_tracker *internal_lookup;
	struct list_head internal_free_list;
	u8 *sense;
	dma_addr_t sense_dma;
	struct dma_pool *sense_dma_pool;
	u16 reply_sz;
	u8 *reply;
	dma_addr_t reply_dma;
	u32 reply_dma_max_address;
	u32 reply_dma_min_address;
	struct dma_pool *reply_dma_pool;
	u16 reply_free_queue_depth;
	__le32 *reply_free;
	dma_addr_t reply_free_dma;
	struct dma_pool *reply_free_dma_pool;
	u32 reply_free_host_index;
	u16 reply_post_queue_depth;
	struct reply_post_struct *reply_post;
	u8 rdpq_array_capable;
	u8 rdpq_array_enable;
	u8 rdpq_array_enable_assigned;
	struct dma_pool *reply_post_free_dma_pool;
	struct dma_pool *reply_post_free_array_dma_pool;
	Mpi2IOCInitRDPQArrayEntry *reply_post_free_array;
	dma_addr_t reply_post_free_array_dma;
	u8 reply_queue_count;
	struct list_head reply_queue_list;
	u8 combined_reply_queue;
	u8 combined_reply_index_count;
	u8 smp_affinity_enable;
	resource_size_t **replyPostRegisterIndex;
	struct list_head delayed_tr_list;
	struct list_head delayed_tr_volume_list;
	struct list_head delayed_sc_list;
	struct list_head delayed_event_ack_list;
	u8 temp_sensors_count;
	struct mutex pci_access_mutex;
	u8 *diag_buffer[3];
	u32 diag_buffer_sz[3];
	dma_addr_t diag_buffer_dma[3];
	u8 diag_buffer_status[3];
	u32 unique_id[3];
	u32 product_specific[69];
	u32 diagnostic_flags[3];
	u32 ring_buffer_offset;
	u32 ring_buffer_sz;
	struct htb_rel_query htb_rel;
	u8 reset_from_user;
	u8 is_warpdrive;
	u8 is_mcpu_endpoint;
	u8 hide_ir_msg;
	u8 mfg_pg10_hide_flag;
	u8 hide_drives;
	spinlock_t diag_trigger_lock;
	u8 diag_trigger_active;
	u8 atomic_desc_capable;
	BASE_READ_REG base_readl;
	BASE_READ_REG base_readl_ext_retry;
	struct SL_WH_MASTER_TRIGGER_T diag_trigger_master;
	struct SL_WH_EVENT_TRIGGERS_T diag_trigger_event;
	struct SL_WH_SCSI_TRIGGERS_T diag_trigger_scsi;
	struct SL_WH_MPI_TRIGGERS_T diag_trigger_mpi;
	u8 supports_trigger_pages;
	void *device_remove_in_progress;
	u16 device_remove_in_progress_sz;
	u8 is_gen35_ioc;
	u8 is_aero_ioc;
	struct dentry *debugfs_root;
	struct dentry *ioc_dump;
	PUT_SMID_IO_FP_HIP put_smid_scsi_io;
	PUT_SMID_IO_FP_HIP put_smid_fast_path;
	PUT_SMID_IO_FP_HIP put_smid_hi_priority;
	PUT_SMID_DEFAULT put_smid_default;
	GET_MSIX_INDEX get_msix_index_for_smlio;
	u8 multipath_on_hba;
	struct list_head port_table_list;
};

struct MPT3SAS_TARGET;

struct MPT3SAS_DEVICE {
	struct MPT3SAS_TARGET *sas_target;
	unsigned int lun;
	u32 flags;
	u8 configured_lun;
	u8 block;
	u8 tlr_snoop_check;
	u8 ignore_delay_remove;
	u8 ncq_prio_enable;
	long unsigned int ata_command_pending;
};

struct scsi_target;

struct _raid_device;

struct _sas_device;

struct MPT3SAS_TARGET {
	struct scsi_target *starget;
	u64 sas_address;
	struct _raid_device *raid_device;
	u16 handle;
	int num_luns;
	u32 flags;
	u8 deleted;
	u8 tm_busy;
	struct hba_port *port;
	struct _sas_device *sas_dev;
	struct _pcie_device *pcie_dev;
};

struct MPT3_IOCTL_EVENTS {
	uint32_t event;
	uint32_t context;
	uint8_t data[192];
};

struct MR_ARRAY_INFO {
	__le16 pd[32];
};

struct MR_CPU_AFFINITY_MASK {
	union {
		struct {
			u8 hw_path: 1;
			u8 cpu0: 1;
			u8 cpu1: 1;
			u8 cpu2: 1;
			u8 cpu3: 1;
			u8 reserved: 3;
		};
		u8 core_mask;
	};
};

struct MR_CTRL_HB_HOST_MEM {
	struct {
		u32 fwCounter;
		struct {
			u32 debugmode: 1;
			u32 reserved: 31;
		} debug;
		u32 reserved_fw[6];
		u32 driverCounter;
		u32 reserved_driver[7];
	} HB;
	u8 pad[960];
};

struct MR_DEV_HANDLE_INFO {
	__le16 curDevHdl;
	u8 validHandles;
	u8 interfaceType;
	__le16 devHandle[2];
};

struct MR_IO_AFFINITY {
	union {
		struct {
			struct MR_CPU_AFFINITY_MASK pdRead;
			struct MR_CPU_AFFINITY_MASK pdWrite;
			struct MR_CPU_AFFINITY_MASK ldRead;
			struct MR_CPU_AFFINITY_MASK ldWrite;
		};
		u32 word;
	};
	u8 maxCores;
	u8 reserved[3];
};

struct MR_LD_RAID {
	struct {
		u32 fpCapable: 1;
		u32 ra_capable: 1;
		u32 reserved5: 2;
		u32 ldPiMode: 4;
		u32 pdPiMode: 4;
		u32 encryptionType: 8;
		u32 fpWriteCapable: 1;
		u32 fpReadCapable: 1;
		u32 fpWriteAcrossStripe: 1;
		u32 fpReadAcrossStripe: 1;
		u32 fpNonRWCapable: 1;
		u32 tmCapable: 1;
		u32 fpBypassRegionLock: 1;
		u32 disable_coalescing: 1;
		u32 fp_rmw_capable: 1;
		u32 fp_cache_bypass_capable: 1;
		u32 reserved4: 2;
	} capability;
	__le32 reserved6;
	__le64 size;
	u8 spanDepth;
	u8 level;
	u8 stripeShift;
	u8 rowSize;
	u8 rowDataSize;
	u8 writeMode;
	u8 PRL;
	u8 SRL;
	__le16 targetId;
	u8 ldState;
	u8 regTypeReqOnWrite;
	u8 modFactor;
	u8 regTypeReqOnRead;
	__le16 seqNum;
	struct {
		u32 ldSyncRequired: 1;
		u32 regTypeReqOnReadIsValid: 1;
		u32 isEPD: 1;
		u32 enableSLDOnAllRWIOs: 1;
		u32 reserved: 28;
	} flags;
	u8 LUN[8];
	u8 fpIoTimeoutForLd;
	u8 ld_accept_priority_type;
	u8 reserved2[2];
	u32 logical_block_length;
	struct {
		u32 ld_pi_exp: 4;
		u32 ld_logical_block_exp: 4;
		u32 reserved1: 24;
	};
	struct MR_IO_AFFINITY cpuAffinity;
	u8 reserved3[64];
};

struct MR_LD_SPAN {
	__le64 startBlk;
	__le64 numBlks;
	__le16 arrayRef;
	u8 spanRowSize;
	u8 spanRowDataSize;
	u8 reserved[4];
};

struct MR_QUAD_ELEMENT {
	__le64 logStart;
	__le64 logEnd;
	__le64 offsetInSpan;
	__le32 diff;
	__le32 reserved1;
};

struct MR_SPAN_INFO {
	__le32 noElements;
	__le32 reserved1;
	struct MR_QUAD_ELEMENT quad[8];
};

struct MR_SPAN_BLOCK_INFO {
	__le64 num_rows;
	struct MR_LD_SPAN span;
	struct MR_SPAN_INFO block_span_info;
};

struct MR_LD_SPAN_MAP {
	struct MR_LD_RAID ldRaid;
	u8 dataArmMap[32];
	struct MR_SPAN_BLOCK_INFO spanBlock[8];
};

struct MR_DRV_RAID_MAP {
	__le32 totalSize;
	union {
		struct {
			__le32 maxLd;
			__le32 maxSpanDepth;
			__le32 maxRowSize;
			__le32 maxPdCount;
			__le32 maxArrays;
		} validationInfo;
		__le32 version[5];
	};
	u8 fpPdIoTimeoutSec;
	u8 reserved2[7];
	__le16 ldCount;
	__le16 arCount;
	__le16 spanCount;
	__le16 reserve3;
	struct MR_DEV_HANDLE_INFO devHndlInfo[512];
	u16 ldTgtIdToLd[512];
	struct MR_ARRAY_INFO arMapInfo[512];
	struct MR_LD_SPAN_MAP ldSpanMap[0];
};

struct MR_DRV_RAID_MAP_ALL {
	struct MR_DRV_RAID_MAP raidMap;
	struct MR_LD_SPAN_MAP ldSpanMap[512];
};

struct MR_DRV_SYSTEM_INFO {
	u8 infoVersion;
	u8 systemIdLength;
	u16 reserved0;
	u8 systemId[64];
	u8 reserved[1980];
};

struct MR_FW_RAID_MAP {
	__le32 totalSize;
	union {
		struct {
			__le32 maxLd;
			__le32 maxSpanDepth;
			__le32 maxRowSize;
			__le32 maxPdCount;
			__le32 maxArrays;
		} validationInfo;
		__le32 version[5];
	};
	__le32 ldCount;
	__le32 Reserved1;
	u8 ldTgtIdToLd[128];
	u8 fpPdIoTimeoutSec;
	u8 reserved2[7];
	struct MR_ARRAY_INFO arMapInfo[128];
	struct MR_DEV_HANDLE_INFO devHndlInfo[256];
	struct MR_LD_SPAN_MAP ldSpanMap[0];
};

struct MR_FW_RAID_MAP_ALL {
	struct MR_FW_RAID_MAP raidMap;
	struct MR_LD_SPAN_MAP ldSpanMap[64];
};

struct MR_RAID_MAP_DESC_TABLE {
	u32 raid_map_desc_type;
	u32 raid_map_desc_offset;
	u32 raid_map_desc_buffer_size;
	u32 raid_map_desc_elements;
};

struct MR_FW_RAID_MAP_DYNAMIC {
	u32 raid_map_size;
	u32 desc_table_offset;
	u32 desc_table_size;
	u32 desc_table_num_elements;
	u64 reserved1;
	u32 reserved2[3];
	u8 fp_pd_io_timeout_sec;
	u8 reserved3[3];
	u32 rmw_fp_seq_num;
	u16 ld_count;
	u16 ar_count;
	u16 span_count;
	u16 reserved4[3];
	union {
		struct {
			struct MR_DEV_HANDLE_INFO *dev_hndl_info;
			u16 *ld_tgt_id_to_ld;
			struct MR_ARRAY_INFO *ar_map_info;
			struct MR_LD_SPAN_MAP *ld_span_map;
		};
		u64 ptr_structure_size[4];
	};
	struct MR_RAID_MAP_DESC_TABLE raid_map_desc_table[4];
	u32 raid_map_desc_data[0];
};

struct MR_FW_RAID_MAP_EXT {
	u32 reserved;
	union {
		struct {
			u32 maxLd;
			u32 maxSpanDepth;
			u32 maxRowSize;
			u32 maxPdCount;
			u32 maxArrays;
		} validationInfo;
		u32 version[5];
	};
	u8 fpPdIoTimeoutSec;
	u8 reserved2[7];
	__le16 ldCount;
	__le16 arCount;
	__le16 spanCount;
	__le16 reserve3;
	struct MR_DEV_HANDLE_INFO devHndlInfo[256];
	u8 ldTgtIdToLd[256];
	struct MR_ARRAY_INFO arMapInfo[256];
	struct MR_LD_SPAN_MAP ldSpanMap[256];
};

struct MR_HOST_DEVICE_LIST_ENTRY {
	struct {
		union {
			struct {
				u8 is_sys_pd: 1;
				u8 reserved: 7;
			} bits;
			u8 byte;
		} u;
	} flags;
	u8 scsi_type;
	__le16 target_id;
	u8 reserved[4];
	__le64 sas_addr[2];
};

struct MR_HOST_DEVICE_LIST {
	__le32 size;
	__le32 count;
	__le32 reserved[2];
	struct MR_HOST_DEVICE_LIST_ENTRY host_device_list[1];
};

union MR_LD_REF {
	struct {
		u8 targetId;
		u8 reserved;
		__le16 seqNum;
	};
	__le32 ref;
};

struct MR_LD_LIST {
	__le32 ldCount;
	__le32 reserved;
	struct {
		union MR_LD_REF ref;
		u8 state;
		u8 reserved[3];
		__le64 size;
	} ldList[256];
};

struct MR_LD_TARGETID_LIST {
	__le32 size;
	__le32 count;
	u8 pad[3];
	u8 targetId[256];
};

struct MR_LD_TARGET_SYNC {
	u8 targetId;
	u8 reserved;
	__le16 seqNum;
};

struct MR_LD_VF_MAP {
	u32 size;
	union MR_LD_REF ref;
	u8 ldVfCount;
	u8 reserved[6];
	u8 policy[1];
};

struct MR_LD_VF_AFFILIATION {
	u32 size;
	u8 ldCount;
	u8 vfCount;
	u8 thisVf;
	u8 reserved[9];
	struct MR_LD_VF_MAP map[1];
};

struct MR_LD_VF_MAP_111 {
	u8 targetId;
	u8 reserved[3];
	u8 policy[8];
};

struct MR_LD_VF_AFFILIATION_111 {
	u8 vdCount;
	u8 vfCount;
	u8 thisVf;
	u8 reserved[5];
	struct MR_LD_VF_MAP_111 map[64];
};

struct MR_PD_ADDRESS {
	__le16 deviceId;
	u16 enclDeviceId;
	union {
		struct {
			u8 enclIndex;
			u8 slotNumber;
		} mrPdAddress;
		struct {
			u8 enclPosition;
			u8 enclConnectorIndex;
		} mrEnclAddress;
	};
	u8 scsiDevType;
	union {
		u8 connectedPortBitmap;
		u8 connectedPortNumbers;
	};
	u64 sasAddr[2];
};

struct MR_PD_CFG_SEQ {
	u16 seqNum;
	u16 devHandle;
	struct {
		u8 tmCapable: 1;
		u8 reserved: 7;
	} capability;
	u8 reserved;
	u16 pd_target_id;
};

struct MR_PD_CFG_SEQ_NUM_SYNC {
	__le32 size;
	__le32 count;
	struct MR_PD_CFG_SEQ seq[0];
};

union MR_PD_DDF_TYPE {
	struct {
		union {
			struct {
				u16 forcedPDGUID: 1;
				u16 inVD: 1;
				u16 isGlobalSpare: 1;
				u16 isSpare: 1;
				u16 isForeign: 1;
				u16 reserved: 7;
				u16 intf: 4;
			} pdType;
			u16 type;
		};
		u16 reserved;
	} ddf;
	struct {
		u32 reserved;
	} nonDisk;
	u32 type;
};

union MR_PD_REF {
	struct {
		u16 deviceId;
		u16 seqNum;
	} mrPdRef;
	u32 ref;
};

union MR_PROGRESS {
	struct {
		u16 progress;
		union {
			u16 elapsedSecs;
			u16 elapsedSecsForLastPercent;
		};
	} mrProgress;
	u32 w;
};

struct MR_PD_PROGRESS {
	struct {
		u32 rbld: 1;
		u32 patrol: 1;
		u32 clear: 1;
		u32 copyBack: 1;
		u32 erase: 1;
		u32 locate: 1;
		u32 reserved: 26;
	} active;
	union MR_PROGRESS rbld;
	union MR_PROGRESS patrol;
	union {
		union MR_PROGRESS clear;
		union MR_PROGRESS erase;
	};
	struct {
		u32 rbld: 1;
		u32 patrol: 1;
		u32 clear: 1;
		u32 copyBack: 1;
		u32 erase: 1;
		u32 reserved: 27;
	} pause;
	union MR_PROGRESS reserved[3];
};

struct MR_PD_INFO {
	union MR_PD_REF ref;
	u8 inquiryData[96];
	u8 vpdPage83[64];
	u8 notSupported;
	u8 scsiDevType;
	union {
		u8 connectedPortBitmap;
		u8 connectedPortNumbers;
	};
	u8 deviceSpeed;
	u32 mediaErrCount;
	u32 otherErrCount;
	u32 predFailCount;
	u32 lastPredFailEventSeqNum;
	u16 fwState;
	u8 disabledForRemoval;
	u8 linkSpeed;
	union MR_PD_DDF_TYPE state;
	struct {
		u8 count;
		u8 isPathBroken: 4;
		u8 reserved3: 3;
		u8 widePortCapable: 1;
		u8 connectorIndex[2];
		u8 reserved[4];
		u64 sasAddr[2];
		u8 reserved2[16];
	} pathInfo;
	u64 rawSize;
	u64 nonCoercedSize;
	u64 coercedSize;
	u16 enclDeviceId;
	u8 enclIndex;
	union {
		u8 slotNumber;
		u8 enclConnectorIndex;
	};
	struct MR_PD_PROGRESS progInfo;
	u8 badBlockTableFull;
	u8 unusableInCurrentConfig;
	u8 vpdPage83Ext[64];
	u8 powerState;
	u8 enclPosition;
	u32 allowedOps;
	u16 copyBackPartnerId;
	u16 enclPartnerDeviceId;
	struct {
		u16 fdeCapable: 1;
		u16 fdeEnabled: 1;
		u16 secured: 1;
		u16 locked: 1;
		u16 foreign: 1;
		u16 needsEKM: 1;
		u16 reserved: 10;
	} security;
	u8 mediaType;
	u8 notCertified;
	u8 bridgeVendor[8];
	u8 bridgeProductIdentification[16];
	u8 bridgeProductRevisionLevel[4];
	u8 satBridgeExists;
	u8 interfaceType;
	u8 temperature;
	u8 emulatedBlockSize;
	u16 userDataBlockSize;
	u16 reserved2;
	struct {
		u32 piType: 3;
		u32 piFormatted: 1;
		u32 piEligible: 1;
		u32 NCQ: 1;
		u32 WCE: 1;
		u32 commissionedSpare: 1;
		u32 emergencySpare: 1;
		u32 ineligibleForSSCD: 1;
		u32 ineligibleForLd: 1;
		u32 useSSEraseType: 1;
		u32 wceUnchanged: 1;
		u32 supportScsiUnmap: 1;
		u32 reserved: 18;
	} properties;
	u64 shieldDiagCompletionTime;
	u8 shieldCounter;
	u8 linkSpeedOther;
	u8 reserved4[2];
	struct {
		u32 bbmErrCountSupported: 1;
		u32 bbmErrCount: 31;
	} bbmErr;
	u8 reserved1[84];
} __attribute__((packed));

struct MR_PD_LIST {
	__le32 size;
	__le32 count;
	struct MR_PD_ADDRESS addr[1];
};

struct MR_PRIV_DEVICE {
	bool is_tm_capable;
	bool tm_busy;
	atomic_t sdev_priv_busy;
	atomic_t r1_ldio_hint;
	u8 interface_type;
	u8 task_abort_tmo;
	u8 target_reset_tmo;
};

struct MR_SNAPDUMP_PROPERTIES {
	u8 offload_num;
	u8 max_num_supported;
	u8 cur_num_supported;
	u8 trigger_min_num_sec_before_ocr;
	u8 reserved[12];
};

struct MR_TARGET_PROPERTIES {
	u32 max_io_size_kb;
	u32 device_qdepth;
	u32 sector_size;
	u8 reset_tmo;
	u8 reserved[499];
};

struct MR_TM_REQUEST {
	char request[128];
};

struct MR_TM_REPLY {
	char reply[128];
};

struct MR_TASK_MANAGE_REQUEST {
	struct MR_TM_REQUEST TmRequest;
	union {
		struct {
			u32 isTMForLD: 1;
			u32 isTMForPD: 1;
			u32 reserved1: 30;
			u32 reserved2;
		} tmReqFlags;
		struct MR_TM_REPLY TMReply;
	};
};

struct MessageUnit_A {
	uint32_t resrved0[4];
	uint32_t inbound_msgaddr0;
	uint32_t inbound_msgaddr1;
	uint32_t outbound_msgaddr0;
	uint32_t outbound_msgaddr1;
	uint32_t inbound_doorbell;
	uint32_t inbound_intstatus;
	uint32_t inbound_intmask;
	uint32_t outbound_doorbell;
	uint32_t outbound_intstatus;
	uint32_t outbound_intmask;
	uint32_t reserved1[2];
	uint32_t inbound_queueport;
	uint32_t outbound_queueport;
	uint32_t reserved2[2];
	uint32_t reserved3[492];
	uint32_t reserved4[128];
	uint32_t message_rwbuffer[256];
	uint32_t message_wbuffer[32];
	uint32_t reserved5[32];
	uint32_t message_rbuffer[32];
	uint32_t reserved6[32];
};

struct MessageUnit_B {
	uint32_t post_qbuffer[264];
	uint32_t done_qbuffer[264];
	uint32_t postq_index;
	uint32_t doneq_index;
	uint32_t *drv2iop_doorbell;
	uint32_t *drv2iop_doorbell_mask;
	uint32_t *iop2drv_doorbell;
	uint32_t *iop2drv_doorbell_mask;
	uint32_t *message_rwbuffer;
	uint32_t *message_wbuffer;
	uint32_t *message_rbuffer;
};

struct MessageUnit_C {
	uint32_t message_unit_status;
	uint32_t slave_error_attribute;
	uint32_t slave_error_address;
	uint32_t posted_outbound_doorbell;
	uint32_t master_error_attribute;
	uint32_t master_error_address_low;
	uint32_t master_error_address_high;
	uint32_t hcb_size;
	uint32_t inbound_doorbell;
	uint32_t diagnostic_rw_data;
	uint32_t diagnostic_rw_address_low;
	uint32_t diagnostic_rw_address_high;
	uint32_t host_int_status;
	uint32_t host_int_mask;
	uint32_t dcr_data;
	uint32_t dcr_address;
	uint32_t inbound_queueport;
	uint32_t outbound_queueport;
	uint32_t hcb_pci_address_low;
	uint32_t hcb_pci_address_high;
	uint32_t iop_int_status;
	uint32_t iop_int_mask;
	uint32_t iop_inbound_queue_port;
	uint32_t iop_outbound_queue_port;
	uint32_t inbound_free_list_index;
	uint32_t inbound_post_list_index;
	uint32_t outbound_free_list_index;
	uint32_t outbound_post_list_index;
	uint32_t inbound_doorbell_clear;
	uint32_t i2o_message_unit_control;
	uint32_t last_used_message_source_address_low;
	uint32_t last_used_message_source_address_high;
	uint32_t pull_mode_data_byte_count[4];
	uint32_t message_dest_address_index;
	uint32_t done_queue_not_empty_int_counter_timer;
	uint32_t utility_A_int_counter_timer;
	uint32_t outbound_doorbell;
	uint32_t outbound_doorbell_clear;
	uint32_t message_source_address_index;
	uint32_t message_done_queue_index;
	uint32_t reserved0;
	uint32_t inbound_msgaddr0;
	uint32_t inbound_msgaddr1;
	uint32_t outbound_msgaddr0;
	uint32_t outbound_msgaddr1;
	uint32_t inbound_queueport_low;
	uint32_t inbound_queueport_high;
	uint32_t outbound_queueport_low;
	uint32_t outbound_queueport_high;
	uint32_t iop_inbound_queue_port_low;
	uint32_t iop_inbound_queue_port_high;
	uint32_t iop_outbound_queue_port_low;
	uint32_t iop_outbound_queue_port_high;
	uint32_t message_dest_queue_port_low;
	uint32_t message_dest_queue_port_high;
	uint32_t last_used_message_dest_address_low;
	uint32_t last_used_message_dest_address_high;
	uint32_t message_done_queue_base_address_low;
	uint32_t message_done_queue_base_address_high;
	uint32_t host_diagnostic;
	uint32_t write_sequence;
	uint32_t reserved1[34];
	uint32_t reserved2[1950];
	uint32_t message_wbuffer[32];
	uint32_t reserved3[32];
	uint32_t message_rbuffer[32];
	uint32_t reserved4[32];
	uint32_t msgcode_rwbuffer[256];
};

struct OutBound_SRB {
	uint32_t addressLow;
	uint32_t addressHigh;
};

struct MessageUnit_D {
	struct InBound_SRB post_qbuffer[256];
	volatile struct OutBound_SRB done_qbuffer[257];
	u16 postq_index;
	volatile u16 doneq_index;
	u32 *chip_id;
	u32 *cpu_mem_config;
	u32 *i2o_host_interrupt_mask;
	u32 *sample_at_reset;
	u32 *reset_request;
	u32 *host_int_status;
	u32 *pcief0_int_enable;
	u32 *inbound_msgaddr0;
	u32 *inbound_msgaddr1;
	u32 *outbound_msgaddr0;
	u32 *outbound_msgaddr1;
	u32 *inbound_doorbell;
	u32 *outbound_doorbell;
	u32 *outbound_doorbell_enable;
	u32 *inboundlist_base_low;
	u32 *inboundlist_base_high;
	u32 *inboundlist_write_pointer;
	u32 *outboundlist_base_low;
	u32 *outboundlist_base_high;
	u32 *outboundlist_copy_pointer;
	u32 *outboundlist_read_pointer;
	u32 *outboundlist_interrupt_cause;
	u32 *outboundlist_interrupt_enable;
	u32 *message_wbuffer;
	u32 *message_rbuffer;
	u32 *msgcode_rwbuffer;
};

struct MessageUnit_E {
	uint32_t iobound_doorbell;
	uint32_t write_sequence_3xxx;
	uint32_t host_diagnostic_3xxx;
	uint32_t posted_outbound_doorbell;
	uint32_t master_error_attribute;
	uint32_t master_error_address_low;
	uint32_t master_error_address_high;
	uint32_t hcb_size;
	uint32_t inbound_doorbell;
	uint32_t diagnostic_rw_data;
	uint32_t diagnostic_rw_address_low;
	uint32_t diagnostic_rw_address_high;
	uint32_t host_int_status;
	uint32_t host_int_mask;
	uint32_t dcr_data;
	uint32_t dcr_address;
	uint32_t inbound_queueport;
	uint32_t outbound_queueport;
	uint32_t hcb_pci_address_low;
	uint32_t hcb_pci_address_high;
	uint32_t iop_int_status;
	uint32_t iop_int_mask;
	uint32_t iop_inbound_queue_port;
	uint32_t iop_outbound_queue_port;
	uint32_t inbound_free_list_index;
	uint32_t inbound_post_list_index;
	uint32_t reply_post_producer_index;
	uint32_t reply_post_consumer_index;
	uint32_t inbound_doorbell_clear;
	uint32_t i2o_message_unit_control;
	uint32_t last_used_message_source_address_low;
	uint32_t last_used_message_source_address_high;
	uint32_t pull_mode_data_byte_count[4];
	uint32_t message_dest_address_index;
	uint32_t done_queue_not_empty_int_counter_timer;
	uint32_t utility_A_int_counter_timer;
	uint32_t outbound_doorbell;
	uint32_t outbound_doorbell_clear;
	uint32_t message_source_address_index;
	uint32_t message_done_queue_index;
	uint32_t reserved0;
	uint32_t inbound_msgaddr0;
	uint32_t inbound_msgaddr1;
	uint32_t outbound_msgaddr0;
	uint32_t outbound_msgaddr1;
	uint32_t inbound_queueport_low;
	uint32_t inbound_queueport_high;
	uint32_t outbound_queueport_low;
	uint32_t outbound_queueport_high;
	uint32_t iop_inbound_queue_port_low;
	uint32_t iop_inbound_queue_port_high;
	uint32_t iop_outbound_queue_port_low;
	uint32_t iop_outbound_queue_port_high;
	uint32_t message_dest_queue_port_low;
	uint32_t message_dest_queue_port_high;
	uint32_t last_used_message_dest_address_low;
	uint32_t last_used_message_dest_address_high;
	uint32_t message_done_queue_base_address_low;
	uint32_t message_done_queue_base_address_high;
	uint32_t host_diagnostic;
	uint32_t write_sequence;
	uint32_t reserved1[34];
	uint32_t reserved2[1950];
	uint32_t message_wbuffer[32];
	uint32_t reserved3[32];
	uint32_t message_rbuffer[32];
	uint32_t reserved4[32];
	uint32_t msgcode_rwbuffer[256];
};

struct MessageUnit_F {
	uint32_t iobound_doorbell;
	uint32_t write_sequence_3xxx;
	uint32_t host_diagnostic_3xxx;
	uint32_t posted_outbound_doorbell;
	uint32_t master_error_attribute;
	uint32_t master_error_address_low;
	uint32_t master_error_address_high;
	uint32_t hcb_size;
	uint32_t inbound_doorbell;
	uint32_t diagnostic_rw_data;
	uint32_t diagnostic_rw_address_low;
	uint32_t diagnostic_rw_address_high;
	uint32_t host_int_status;
	uint32_t host_int_mask;
	uint32_t dcr_data;
	uint32_t dcr_address;
	uint32_t inbound_queueport;
	uint32_t outbound_queueport;
	uint32_t hcb_pci_address_low;
	uint32_t hcb_pci_address_high;
	uint32_t iop_int_status;
	uint32_t iop_int_mask;
	uint32_t iop_inbound_queue_port;
	uint32_t iop_outbound_queue_port;
	uint32_t inbound_free_list_index;
	uint32_t inbound_post_list_index;
	uint32_t reply_post_producer_index;
	uint32_t reply_post_consumer_index;
	uint32_t inbound_doorbell_clear;
	uint32_t i2o_message_unit_control;
	uint32_t last_used_message_source_address_low;
	uint32_t last_used_message_source_address_high;
	uint32_t pull_mode_data_byte_count[4];
	uint32_t message_dest_address_index;
	uint32_t done_queue_not_empty_int_counter_timer;
	uint32_t utility_A_int_counter_timer;
	uint32_t outbound_doorbell;
	uint32_t outbound_doorbell_clear;
	uint32_t message_source_address_index;
	uint32_t message_done_queue_index;
	uint32_t reserved0;
	uint32_t inbound_msgaddr0;
	uint32_t inbound_msgaddr1;
	uint32_t outbound_msgaddr0;
	uint32_t outbound_msgaddr1;
	uint32_t inbound_queueport_low;
	uint32_t inbound_queueport_high;
	uint32_t outbound_queueport_low;
	uint32_t outbound_queueport_high;
	uint32_t iop_inbound_queue_port_low;
	uint32_t iop_inbound_queue_port_high;
	uint32_t iop_outbound_queue_port_low;
	uint32_t iop_outbound_queue_port_high;
	uint32_t message_dest_queue_port_low;
	uint32_t message_dest_queue_port_high;
	uint32_t last_used_message_dest_address_low;
	uint32_t last_used_message_dest_address_high;
	uint32_t message_done_queue_base_address_low;
	uint32_t message_done_queue_base_address_high;
	uint32_t host_diagnostic;
	uint32_t write_sequence;
	uint32_t reserved1[46];
	uint32_t reply_post_producer_index1;
	uint32_t reply_post_consumer_index1;
};

struct MgmtRevInfo {
	uint32_t a_Major;
	uint32_t a_Minor;
};

struct scatterlist;

struct NCR5380_cmd {
	char *ptr;
	int this_residual;
	struct scatterlist *buffer;
	int status;
	int message;
	int phase;
	struct list_head list;
};

struct sg_table {
	struct scatterlist *sgl;
	unsigned int nents;
	unsigned int orig_nents;
};

struct scsi_data_buffer {
	struct sg_table table;
	unsigned int length;
};

struct scatterlist {
	long unsigned int page_link;
	unsigned int offset;
	unsigned int length;
	dma_addr_t dma_address;
	unsigned int dma_length;
	unsigned int dma_flags;
};

struct scsi_eh_save {
	int result;
	unsigned int resid_len;
	int eh_eflags;
	enum dma_data_direction data_direction;
	unsigned int underflow;
	unsigned char cmd_len;
	unsigned char prot_op;
	unsigned char cmnd[32];
	struct scsi_data_buffer sdb;
	struct scatterlist sense_sgl;
};

struct NCR5380_hostdata {
	u8 *io;
	u8 *pdma_io;
	long unsigned int poll_loops;
	spinlock_t lock;
	struct scsi_cmnd *connected;
	struct list_head disconnected;
	struct Scsi_Host *host;
	struct workqueue_struct *work_q;
	struct work_struct main_task;
	int flags;
	int dma_len;
	int read_overruns;
	long unsigned int io_port;
	long unsigned int base;
	struct list_head unissued;
	struct scsi_cmnd *selecting;
	struct list_head autosense;
	struct scsi_cmnd *sensing;
	struct scsi_eh_save ses;
	unsigned char busy[8];
	unsigned char id_mask;
	unsigned char id_higher_mask;
	unsigned char last_message;
	long unsigned int region_size;
	char info[168];
};

struct NEW_ATTRIBUTE_SIZES {
	__le64 alloc_size;
	__le64 valid_size;
	__le64 data_size;
	__le64 total_size;
};

struct NTFS_BOOT {
	u8 jump_code[3];
	u8 system_id[8];
	u8 bytes_per_sector[2];
	u8 sectors_per_clusters;
	u8 unused1[7];
	u8 media_type;
	u8 unused2[2];
	__le16 sct_per_track;
	__le16 heads;
	__le32 hidden_sectors;
	u8 unused3[4];
	u8 bios_drive_num;
	u8 unused4;
	u8 signature_ex;
	u8 unused5;
	__le64 sectors_per_volume;
	__le64 mft_clst;
	__le64 mft2_clst;
	s8 record_size;
	u8 unused6[3];
	s8 index_size;
	u8 unused7[3];
	__le64 serial_num;
	__le32 check_sum;
	u8 boot_code[426];
	u8 boot_magic[2];
};

struct NTFS_DE {
	union {
		struct MFT_REF ref;
		struct {
			__le16 data_off;
			__le16 data_size;
			__le32 res;
		} view;
	};
	__le16 size;
	__le16 key_size;
	__le16 flags;
	__le16 res;
};

struct REPARSE_KEY {
	__le32 ReparseTag;
	struct MFT_REF ref;
};

struct NTFS_DE_R {
	struct NTFS_DE de;
	struct REPARSE_KEY key;
	u32 zero;
};

struct SECURITY_KEY {
	__le32 hash;
	__le32 sec_id;
};

struct SECURITY_HDR {
	struct SECURITY_KEY key;
	__le64 off;
	__le32 size;
} __attribute__((packed));

struct NTFS_DE_SDH {
	struct NTFS_DE de;
	struct SECURITY_KEY key;
	struct SECURITY_HDR sec_hdr;
	__le16 magic[2];
};

struct NTFS_DE_SII {
	struct NTFS_DE de;
	__le32 sec_id;
	struct SECURITY_HDR sec_hdr;
};

struct NTFS_RESTART {
	__le32 major_ver;
	__le32 minor_ver;
	__le64 check_point_start;
	__le64 open_attr_table_lsn;
	__le64 attr_names_lsn;
	__le64 dirty_pages_table_lsn;
	__le64 transact_table_lsn;
	__le32 open_attr_len;
	__le32 attr_names_len;
	__le32 dirty_pages_len;
	__le32 transact_table_len;
};

struct OPEN_ATTR_ENRTY {
	__le32 next;
	__le32 bytes_per_index;
	enum ATTR_TYPE type;
	u8 is_dirty_pages;
	u8 is_attr_name;
	u8 name_len;
	u8 res;
	struct MFT_REF ref;
	__le64 open_record_lsn;
	void *ptr;
};

struct OPEN_ATTR_ENRTY_32 {
	__le32 next;
	__le32 ptr;
	struct MFT_REF ref;
	__le64 open_record_lsn;
	u8 is_dirty_pages;
	u8 is_attr_name;
	u8 res1[2];
	enum ATTR_TYPE type;
	u8 name_len;
	u8 res2[3];
	__le32 AttributeName;
	__le32 bytes_per_index;
};

struct OpalHMIEvent {
	uint8_t version;
	uint8_t severity;
	uint8_t type;
	uint8_t disposition;
	uint8_t reserved_1[4];
	__be64 hmer;
	__be64 tfmr;
	union {
		struct {
			uint8_t xstop_type;
			uint8_t reserved_1[3];
			__be32 xstop_reason;
			union {
				__be32 pir;
				__be32 chip_id;
			} u;
		} xstop_error;
	} u;
};

struct OpalHmiEvtNode {
	struct list_head list;
	struct OpalHMIEvent hmi_evt;
};

struct OpalIoP7IOCBiErrorData {
	__be64 biLdcp0;
	__be64 biLdcp1;
	__be64 biLdcp2;
	__be64 biFenceStatus;
	uint8_t biDownbound;
};

struct OpalIoP7IOCCiErrorData {
	__be64 ciPortStatus;
	__be64 ciPortLdcp;
	uint8_t ciPort;
};

struct OpalIoP7IOCRgcErrorData {
	__be64 rgcStatus;
	__be64 rgcLdcp;
};

struct OpalIoP7IOCErrorData {
	__be16 type;
	__be64 gemXfir;
	__be64 gemRfir;
	__be64 gemRirqfir;
	__be64 gemMask;
	__be64 gemRwof;
	__be64 lemFir;
	__be64 lemErrMask;
	__be64 lemAction0;
	__be64 lemAction1;
	__be64 lemWof;
	union {
		struct OpalIoP7IOCRgcErrorData rgc;
		struct OpalIoP7IOCBiErrorData bi;
		struct OpalIoP7IOCCiErrorData ci;
	};
};

struct OpalIoPhbErrorCommon {
	__be32 version;
	__be32 ioType;
	__be32 len;
};

struct OpalIoP7IOCPhbErrorData {
	struct OpalIoPhbErrorCommon common;
	__be32 brdgCtl;
	__be32 portStatusReg;
	__be32 rootCmplxStatus;
	__be32 busAgentStatus;
	__be32 deviceStatus;
	__be32 slotStatus;
	__be32 linkStatus;
	__be32 devCmdStatus;
	__be32 devSecStatus;
	__be32 rootErrorStatus;
	__be32 uncorrErrorStatus;
	__be32 corrErrorStatus;
	__be32 tlpHdr1;
	__be32 tlpHdr2;
	__be32 tlpHdr3;
	__be32 tlpHdr4;
	__be32 sourceId;
	__be32 rsv3;
	__be64 errorClass;
	__be64 correlator;
	__be64 p7iocPlssr;
	__be64 p7iocCsr;
	__be64 lemFir;
	__be64 lemErrorMask;
	__be64 lemWOF;
	__be64 phbErrorStatus;
	__be64 phbFirstErrorStatus;
	__be64 phbErrorLog0;
	__be64 phbErrorLog1;
	__be64 mmioErrorStatus;
	__be64 mmioFirstErrorStatus;
	__be64 mmioErrorLog0;
	__be64 mmioErrorLog1;
	__be64 dma0ErrorStatus;
	__be64 dma0FirstErrorStatus;
	__be64 dma0ErrorLog0;
	__be64 dma0ErrorLog1;
	__be64 dma1ErrorStatus;
	__be64 dma1FirstErrorStatus;
	__be64 dma1ErrorLog0;
	__be64 dma1ErrorLog1;
	__be64 pestA[128];
	__be64 pestB[128];
};

struct OpalIoPhb3ErrorData {
	struct OpalIoPhbErrorCommon common;
	__be32 brdgCtl;
	__be32 portStatusReg;
	__be32 rootCmplxStatus;
	__be32 busAgentStatus;
	__be32 deviceStatus;
	__be32 slotStatus;
	__be32 linkStatus;
	__be32 devCmdStatus;
	__be32 devSecStatus;
	__be32 rootErrorStatus;
	__be32 uncorrErrorStatus;
	__be32 corrErrorStatus;
	__be32 tlpHdr1;
	__be32 tlpHdr2;
	__be32 tlpHdr3;
	__be32 tlpHdr4;
	__be32 sourceId;
	__be32 rsv3;
	__be64 errorClass;
	__be64 correlator;
	__be64 nFir;
	__be64 nFirMask;
	__be64 nFirWOF;
	__be64 phbPlssr;
	__be64 phbCsr;
	__be64 lemFir;
	__be64 lemErrorMask;
	__be64 lemWOF;
	__be64 phbErrorStatus;
	__be64 phbFirstErrorStatus;
	__be64 phbErrorLog0;
	__be64 phbErrorLog1;
	__be64 mmioErrorStatus;
	__be64 mmioFirstErrorStatus;
	__be64 mmioErrorLog0;
	__be64 mmioErrorLog1;
	__be64 dma0ErrorStatus;
	__be64 dma0FirstErrorStatus;
	__be64 dma0ErrorLog0;
	__be64 dma0ErrorLog1;
	__be64 dma1ErrorStatus;
	__be64 dma1FirstErrorStatus;
	__be64 dma1ErrorLog0;
	__be64 dma1ErrorLog1;
	__be64 pestA[256];
	__be64 pestB[256];
};

struct OpalIoPhb4ErrorData {
	struct OpalIoPhbErrorCommon common;
	__be32 brdgCtl;
	__be32 deviceStatus;
	__be32 slotStatus;
	__be32 linkStatus;
	__be32 devCmdStatus;
	__be32 devSecStatus;
	__be32 rootErrorStatus;
	__be32 uncorrErrorStatus;
	__be32 corrErrorStatus;
	__be32 tlpHdr1;
	__be32 tlpHdr2;
	__be32 tlpHdr3;
	__be32 tlpHdr4;
	__be32 sourceId;
	__be64 nFir;
	__be64 nFirMask;
	__be64 nFirWOF;
	__be64 phbPlssr;
	__be64 phbCsr;
	__be64 lemFir;
	__be64 lemErrorMask;
	__be64 lemWOF;
	__be64 phbErrorStatus;
	__be64 phbFirstErrorStatus;
	__be64 phbErrorLog0;
	__be64 phbErrorLog1;
	__be64 phbTxeErrorStatus;
	__be64 phbTxeFirstErrorStatus;
	__be64 phbTxeErrorLog0;
	__be64 phbTxeErrorLog1;
	__be64 phbRxeArbErrorStatus;
	__be64 phbRxeArbFirstErrorStatus;
	__be64 phbRxeArbErrorLog0;
	__be64 phbRxeArbErrorLog1;
	__be64 phbRxeMrgErrorStatus;
	__be64 phbRxeMrgFirstErrorStatus;
	__be64 phbRxeMrgErrorLog0;
	__be64 phbRxeMrgErrorLog1;
	__be64 phbRxeTceErrorStatus;
	__be64 phbRxeTceFirstErrorStatus;
	__be64 phbRxeTceErrorLog0;
	__be64 phbRxeTceErrorLog1;
	__be64 phbPblErrorStatus;
	__be64 phbPblFirstErrorStatus;
	__be64 phbPblErrorLog0;
	__be64 phbPblErrorLog1;
	__be64 phbPcieDlpErrorLog1;
	__be64 phbPcieDlpErrorLog2;
	__be64 phbPcieDlpErrorStatus;
	__be64 phbRegbErrorStatus;
	__be64 phbRegbFirstErrorStatus;
	__be64 phbRegbErrorLog0;
	__be64 phbRegbErrorLog1;
	__be64 pestA[512];
	__be64 pestB[512];
};

struct OpalMemoryErrorData {
	enum OpalMemErr_Version version: 8;
	enum OpalMemErrType type: 8;
	__be16 flags;
	uint8_t reserved_1[4];
	union {
		struct {
			enum OpalMemErr_ResilErrType resil_err_type: 8;
			uint8_t reserved_1[7];
			__be64 physical_address_start;
			__be64 physical_address_end;
		} resilience;
		struct {
			enum OpalMemErr_DynErrType dyn_err_type: 8;
			uint8_t reserved_1[7];
			__be64 physical_address_start;
			__be64 physical_address_end;
		} dyn_dealloc;
	} u;
};

struct opal_msg {
	__be32 msg_type;
	__be32 reserved;
	__be64 params[8];
};

struct OpalMsgNode {
	struct list_head list;
	struct opal_msg msg;
};

struct ntfs_run;

struct runs_tree {
	struct ntfs_run *runs;
	size_t count;
	size_t allocated;
};

struct ntfs_inode;

struct OpenAttr {
	struct ATTRIB *attr;
	struct runs_tree *run1;
	struct runs_tree run0;
	struct ntfs_inode *ni;
};

struct POSTSTATUS {
	__le32 Post_Command;
	__le32 Post_Address;
};

struct ParameterData {
	int value;
	int min;
	int max;
	int def;
	int safe;
};

struct PartitionBlock {
	__be32 pb_ID;
	__be32 pb_SummedLongs;
	__be32 pb_ChkSum;
	__be32 pb_HostID;
	__be32 pb_Next;
	__be32 pb_Flags;
	__be32 pb_Reserved1[2];
	__be32 pb_DevFlags;
	__u8 pb_DriveName[32];
	__be32 pb_Reserved2[15];
	__be32 pb_Environment[17];
	__be32 pb_EReserved[15];
};

struct QBUFFER {
	uint32_t data_len;
	uint8_t data[124];
};

struct sk_buff_list {
	struct sk_buff *next;
	struct sk_buff *prev;
};

struct sk_buff_head {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
		};
		struct sk_buff_list list;
	};
	__u32 qlen;
	spinlock_t lock;
};

struct qdisc_skb_head {
	struct sk_buff *head;
	struct sk_buff *tail;
	__u32 qlen;
	spinlock_t lock;
};

struct u64_stats_sync {};

struct gnet_stats_basic_sync {
	u64_stats_t bytes;
	u64_stats_t packets;
	struct u64_stats_sync syncp;
};

struct gnet_stats_queue {
	__u32 qlen;
	__u32 backlog;
	__u32 drops;
	__u32 requeues;
	__u32 overlimits;
};

struct callback_head {
	struct callback_head *next;
	void (*func)(struct callback_head *);
};

struct lock_class_key {};

struct Qdisc_ops;

struct qdisc_size_table;

struct netdev_queue;

struct net_rate_estimator;

struct Qdisc {
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	unsigned int flags;
	u32 limit;
	const struct Qdisc_ops *ops;
	struct qdisc_size_table *stab;
	struct hlist_node hash;
	u32 handle;
	u32 parent;
	struct netdev_queue *dev_queue;
	struct net_rate_estimator *rate_est;
	struct gnet_stats_basic_sync *cpu_bstats;
	struct gnet_stats_queue *cpu_qstats;
	int pad;
	refcount_t refcnt;
	long: 64;
	long: 64;
	long: 64;
	struct sk_buff_head gso_skb;
	struct qdisc_skb_head q;
	struct gnet_stats_basic_sync bstats;
	struct gnet_stats_queue qstats;
	int owner;
	long unsigned int state;
	long unsigned int state2;
	struct Qdisc *next_sched;
	struct sk_buff_head skb_bad_txq;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t busylock;
	spinlock_t seqlock;
	struct callback_head rcu;
	netdevice_tracker dev_tracker;
	struct lock_class_key root_lock_key;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long int privdata[0];
};

struct Qdisc_class_common {
	u32 classid;
	unsigned int filter_cnt;
	struct hlist_node hnode;
};

struct hlist_head;

struct Qdisc_class_hash {
	struct hlist_head *hash;
	unsigned int hashsize;
	unsigned int hashmask;
	unsigned int hashelems;
};

struct tcmsg;

struct netlink_ext_ack;

struct nlattr;

struct qdisc_walker;

struct tcf_block;

struct gnet_dump;

struct Qdisc_class_ops {
	unsigned int flags;
	struct netdev_queue * (*select_queue)(struct Qdisc *, struct tcmsg *);
	int (*graft)(struct Qdisc *, long unsigned int, struct Qdisc *, struct Qdisc **, struct netlink_ext_ack *);
	struct Qdisc * (*leaf)(struct Qdisc *, long unsigned int);
	void (*qlen_notify)(struct Qdisc *, long unsigned int);
	long unsigned int (*find)(struct Qdisc *, u32);
	int (*change)(struct Qdisc *, u32, u32, struct nlattr **, long unsigned int *, struct netlink_ext_ack *);
	int (*delete)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	void (*walk)(struct Qdisc *, struct qdisc_walker *);
	struct tcf_block * (*tcf_block)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	long unsigned int (*bind_tcf)(struct Qdisc *, long unsigned int, u32);
	void (*unbind_tcf)(struct Qdisc *, long unsigned int);
	int (*dump)(struct Qdisc *, long unsigned int, struct sk_buff *, struct tcmsg *);
	int (*dump_stats)(struct Qdisc *, long unsigned int, struct gnet_dump *);
};

struct module;

struct Qdisc_ops {
	struct Qdisc_ops *next;
	const struct Qdisc_class_ops *cl_ops;
	char id[16];
	int priv_size;
	unsigned int static_flags;
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	struct sk_buff * (*peek)(struct Qdisc *);
	int (*init)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*reset)(struct Qdisc *);
	void (*destroy)(struct Qdisc *);
	int (*change)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*attach)(struct Qdisc *);
	int (*change_tx_queue_len)(struct Qdisc *, unsigned int);
	void (*change_real_num_tx)(struct Qdisc *, unsigned int);
	int (*dump)(struct Qdisc *, struct sk_buff *);
	int (*dump_stats)(struct Qdisc *, struct gnet_dump *);
	void (*ingress_block_set)(struct Qdisc *, u32);
	void (*egress_block_set)(struct Qdisc *, u32);
	u32 (*ingress_block_get)(struct Qdisc *);
	u32 (*egress_block_get)(struct Qdisc *);
	struct module *owner;
};

struct RECORD_PAGE_HDR {
	struct NTFS_RECORD_HEADER rhdr;
	__le32 rflags;
	__le16 page_count;
	__le16 page_pos;
	struct LFS_RECORD record_hdr;
	__le16 fixups[10];
	__le32 file_off;
};

struct REPARSE_DATA_BUFFER {
	__le32 ReparseTag;
	__le16 ReparseDataLength;
	__le16 Reserved;
	union {
		struct {
			__le16 SubstituteNameOffset;
			__le16 SubstituteNameLength;
			__le16 PrintNameOffset;
			__le16 PrintNameLength;
			__le16 PathBuffer[0];
		} MountPointReparseBuffer;
		struct {
			__le16 SubstituteNameOffset;
			__le16 SubstituteNameLength;
			__le16 PrintNameOffset;
			__le16 PrintNameLength;
			__le32 Flags;
			__le16 PathBuffer[0];
		} SymbolicLinkReparseBuffer;
		struct {
			__le32 WofVersion;
			__le32 WofProvider;
			__le32 ProviderVer;
			__le32 CompressionFormat;
		} CompressReparseBuffer;
		struct {
			u8 DataBuffer[1];
		} GenericReparseBuffer;
	};
};

struct RESTART_AREA {
	__le64 current_lsn;
	__le16 log_clients;
	__le16 client_idx[2];
	__le16 flags;
	__le32 seq_num_bits;
	__le16 ra_len;
	__le16 client_off;
	__le64 l_size;
	__le32 last_lsn_data_len;
	__le16 rec_hdr_len;
	__le16 data_off;
	__le32 open_log_count;
	__le32 align[5];
	struct CLIENT_REC clients[0];
};

struct RESTART_HDR {
	struct NTFS_RECORD_HEADER rhdr;
	__le32 sys_page_size;
	__le32 page_size;
	__le16 ra_off;
	__le16 minor_ver;
	__le16 major_ver;
	__le16 fixups[0];
};

struct RESTART_TABLE {
	__le16 size;
	__le16 used;
	__le16 total;
	__le16 res[3];
	__le32 free_goal;
	__le32 first_free;
	__le32 last_free;
};

struct RLS_RSP {
	uint32_t linkFailureCnt;
	uint32_t lossSyncCnt;
	uint32_t lossSignalCnt;
	uint32_t primSeqErrCnt;
	uint32_t invalidXmitWord;
	uint32_t crcCnt;
};

struct RRQ {
	uint32_t rrq;
	uint32_t rrq_exchg;
};

struct RTV_RSP {
	uint32_t ratov;
	uint32_t edtov;
	uint32_t qtov;
};

struct ext_report_lun_entry {
	u8 lunid[8];
	u8 wwid[8];
	u8 device_type;
	u8 device_flags;
	u8 lun_count;
	u8 redundant_paths;
	u32 ioaccel_handle;
};

struct ReportExtendedLUNdata {
	u8 LUNListLength[4];
	u8 extended_response_flag;
	u8 reserved[3];
	struct ext_report_lun_entry LUN[1024];
};

struct ReportLUNdata {
	u8 LUNListLength[4];
	u8 extended_response_flag;
	u8 reserved[3];
	u8 LUN[8192];
};

struct RigidDiskBlock {
	__be32 rdb_ID;
	__be32 rdb_SummedLongs;
	__be32 rdb_ChkSum;
	__be32 rdb_HostID;
	__be32 rdb_BlockBytes;
	__be32 rdb_Flags;
	__be32 rdb_BadBlockList;
	__be32 rdb_PartitionList;
	__be32 rdb_FileSysHeaderList;
	__be32 rdb_DriveInit;
	__be32 rdb_Reserved1[6];
	__be32 rdb_Cylinders;
	__be32 rdb_Sectors;
	__be32 rdb_Heads;
	__be32 rdb_Interleave;
	__be32 rdb_Park;
	__be32 rdb_Reserved2[3];
	__be32 rdb_WritePreComp;
	__be32 rdb_ReducedWrite;
	__be32 rdb_StepRate;
	__be32 rdb_Reserved3[5];
	__be32 rdb_RDBBlocksLo;
	__be32 rdb_RDBBlocksHi;
	__be32 rdb_LoCylinder;
	__be32 rdb_HiCylinder;
	__be32 rdb_CylBlocks;
	__be32 rdb_AutoParkSeconds;
	__be32 rdb_HighRDSKBlock;
	__be32 rdb_Reserved4;
	char rdb_DiskVendor[8];
	char rdb_DiskProduct[16];
	char rdb_DiskRevision[4];
	char rdb_ControllerVendor[8];
	char rdb_ControllerProduct[16];
	char rdb_ControllerRevision[4];
	__be32 rdb_Reserved5[10];
};

struct SASProtocolTimerConfig {
	__le32 pageCode;
	__le32 MST_MSI;
	__le32 STP_SSP_MCT_TMO;
	__le32 STP_FRM_TMO;
	__le32 STP_IDLE_TMO;
	__le32 OPNRJT_RTRY_INTVL;
	__le32 Data_Cmd_OPNRJT_RTRY_TMO;
	__le32 Data_Cmd_OPNRJT_RTRY_THR;
	__le32 MAX_AIP;
};

typedef struct SASProtocolTimerConfig SASProtocolTimerConfig_t;

struct SECURITY_DESCRIPTOR_RELATIVE {
	u8 Revision;
	u8 Sbz1;
	__le16 Control;
	__le32 Owner;
	__le32 Group;
	__le32 Sacl;
	__le32 Dacl;
};

struct SENSE_DATA {
	uint8_t ErrorCode: 7;
	uint8_t Valid: 1;
	uint8_t SegmentNumber;
	uint8_t SenseKey: 4;
	uint8_t Reserved: 1;
	uint8_t IncorrectLength: 1;
	uint8_t EndOfMedia: 1;
	uint8_t FileMark: 1;
	uint8_t Information[4];
	uint8_t AdditionalSenseLength;
	uint8_t CommandSpecificInformation[4];
	uint8_t AdditionalSenseCode;
	uint8_t AdditionalSenseCodeQualifier;
	uint8_t FieldReplaceableUnitCode;
	uint8_t SenseKeySpecific[3];
};

struct SGentry {
	u32 address;
	u32 length;
};

struct SID {
	u8 Revision;
	u8 SubAuthorityCount;
	u8 IdentifierAuthority[6];
	__le32 SubAuthority[0];
};

struct SL_WH_TRIGGERS_EVENT_DATA_T {
	uint32_t trigger_type;
	union {
		struct SL_WH_MASTER_TRIGGER_T master;
		struct SL_WH_EVENT_TRIGGER_T event;
		struct SL_WH_SCSI_TRIGGER_T scsi;
		struct SL_WH_MPI_TRIGGER_T mpi;
	} u;
};

struct ScsiInqData {
	u8 DevType;
	u8 RMB_TypeMod;
	u8 Vers;
	u8 RDF;
	u8 AddLen;
	u8 Res1;
	u8 Res2;
	u8 Flags;
	u8 VendorID[8];
	u8 ProductID[16];
	u8 ProductRev[4];
};

struct blk_mq_queue_map {
	unsigned int *mq_map;
	unsigned int nr_queues;
	unsigned int queue_offset;
};

struct blk_mq_ops;

struct blk_mq_tags;

struct blk_mq_tag_set {
	const struct blk_mq_ops *ops;
	struct blk_mq_queue_map map[3];
	unsigned int nr_maps;
	unsigned int nr_hw_queues;
	unsigned int queue_depth;
	unsigned int reserved_tags;
	unsigned int cmd_size;
	int numa_node;
	unsigned int timeout;
	unsigned int flags;
	void *driver_data;
	struct blk_mq_tags **tags;
	struct blk_mq_tags *shared_tags;
	struct mutex tag_list_lock;
	struct list_head tag_list;
	struct srcu_struct *srcu;
};

struct kset;

struct kobj_type;

struct kernfs_node;

struct kobject {
	const char *name;
	struct list_head entry;
	struct kobject *parent;
	struct kset *kset;
	const struct kobj_type *ktype;
	struct kernfs_node *sd;
	struct kref kref;
	unsigned int state_initialized: 1;
	unsigned int state_in_sysfs: 1;
	unsigned int state_add_uevent_sent: 1;
	unsigned int state_remove_uevent_sent: 1;
	unsigned int uevent_suppress: 1;
};

struct dev_links_info {
	struct list_head suppliers;
	struct list_head consumers;
	struct list_head defer_sync;
	enum dl_dev_state status;
};

struct pm_message {
	int event;
};

typedef struct pm_message pm_message_t;

struct rb_node {
	long unsigned int __rb_parent_color;
	struct rb_node *rb_right;
	struct rb_node *rb_left;
};

struct timerqueue_node {
	struct rb_node node;
	ktime_t expires;
};

struct hrtimer_clock_base;

struct hrtimer {
	struct timerqueue_node node;
	ktime_t _softexpires;
	enum hrtimer_restart (*function)(struct hrtimer *);
	struct hrtimer_clock_base *base;
	u8 state;
	u8 is_rel;
	u8 is_soft;
	u8 is_hard;
};

struct wakeup_source;

struct wake_irq;

struct pm_subsys_data;

struct dev_pm_qos;

struct dev_pm_info {
	pm_message_t power_state;
	bool can_wakeup: 1;
	bool async_suspend: 1;
	bool in_dpm_list: 1;
	bool is_prepared: 1;
	bool is_suspended: 1;
	bool is_noirq_suspended: 1;
	bool is_late_suspended: 1;
	bool no_pm: 1;
	bool early_init: 1;
	bool direct_complete: 1;
	u32 driver_flags;
	spinlock_t lock;
	struct list_head entry;
	struct completion completion;
	struct wakeup_source *wakeup;
	bool wakeup_path: 1;
	bool syscore: 1;
	bool no_pm_callbacks: 1;
	bool async_in_progress: 1;
	bool must_resume: 1;
	bool may_skip_resume: 1;
	struct hrtimer suspend_timer;
	u64 timer_expires;
	struct work_struct work;
	wait_queue_head_t wait_queue;
	struct wake_irq *wakeirq;
	atomic_t usage_count;
	atomic_t child_count;
	unsigned int disable_depth: 3;
	bool idle_notification: 1;
	bool request_pending: 1;
	bool deferred_resume: 1;
	bool needs_force_resume: 1;
	bool runtime_auto: 1;
	bool ignore_children: 1;
	bool no_callbacks: 1;
	bool irq_safe: 1;
	bool use_autosuspend: 1;
	bool timer_autosuspends: 1;
	bool memalloc_noio: 1;
	unsigned int links_count;
	enum rpm_request request;
	enum rpm_status runtime_status;
	enum rpm_status last_status;
	int runtime_error;
	int autosuspend_delay;
	u64 last_busy;
	u64 active_time;
	u64 suspended_time;
	u64 accounting_timestamp;
	struct pm_subsys_data *subsys_data;
	void (*set_latency_tolerance)(struct device *, s32);
	struct dev_pm_qos *qos;
};

struct irq_domain;

struct msi_device_data;

struct dev_msi_info {
	struct irq_domain *domain;
	struct msi_device_data *data;
};

struct iommu_table;

struct pci_dn;

struct eeh_dev;

struct cxl_context;

struct dev_archdata {
	dma_addr_t dma_offset;
	struct iommu_table *iommu_table_base;
	struct pci_dn *pci_data;
	struct eeh_dev *edev;
	struct cxl_context *cxl_ctx;
	void *iov_data;
};

struct device_private;

struct device_type;

struct bus_type;

struct device_driver;

struct dev_pm_domain;

struct em_perf_domain;

struct dev_pin_info;

struct dma_map_ops;

struct bus_dma_region;

struct device_dma_parameters;

struct dma_coherent_mem;

struct io_tlb_mem;

struct device_node;

struct fwnode_handle;

struct class;

struct attribute_group;

struct iommu_group;

struct dev_iommu;

struct device_physical_location;

struct device {
	struct kobject kobj;
	struct device *parent;
	struct device_private *p;
	const char *init_name;
	const struct device_type *type;
	const struct bus_type *bus;
	struct device_driver *driver;
	void *platform_data;
	void *driver_data;
	struct mutex mutex;
	struct dev_links_info links;
	struct dev_pm_info power;
	struct dev_pm_domain *pm_domain;
	struct em_perf_domain *em_pd;
	struct dev_pin_info *pins;
	struct dev_msi_info msi;
	const struct dma_map_ops *dma_ops;
	u64 *dma_mask;
	u64 coherent_dma_mask;
	u64 bus_dma_limit;
	const struct bus_dma_region *dma_range_map;
	struct device_dma_parameters *dma_parms;
	struct list_head dma_pools;
	struct dma_coherent_mem *dma_mem;
	struct io_tlb_mem *dma_io_tlb_mem;
	struct list_head dma_io_tlb_pools;
	spinlock_t dma_io_tlb_lock;
	bool dma_uses_io_tlb;
	struct dev_archdata archdata;
	struct device_node *of_node;
	struct fwnode_handle *fwnode;
	int numa_node;
	dev_t devt;
	u32 id;
	spinlock_t devres_lock;
	struct list_head devres_head;
	const struct class *class;
	const struct attribute_group **groups;
	void (*release)(struct device *);
	struct iommu_group *iommu_group;
	struct dev_iommu *iommu;
	struct device_physical_location *physical_location;
	enum device_removable removable;
	bool offline_disabled: 1;
	bool offline: 1;
	bool of_node_reused: 1;
	bool state_synced: 1;
	bool can_match: 1;
	bool dma_ops_bypass: 1;
	bool dma_skip_sync: 1;
};

struct scsi_host_template;

struct scsi_transport_template;

struct Scsi_Host {
	struct list_head __devices;
	struct list_head __targets;
	struct list_head starved_list;
	spinlock_t default_lock;
	spinlock_t *host_lock;
	struct mutex scan_mutex;
	struct list_head eh_abort_list;
	struct list_head eh_cmd_q;
	struct task_struct *ehandler;
	struct completion *eh_action;
	wait_queue_head_t host_wait;
	const struct scsi_host_template *hostt;
	struct scsi_transport_template *transportt;
	struct kref tagset_refcnt;
	struct completion tagset_freed;
	struct blk_mq_tag_set tag_set;
	atomic_t host_blocked;
	unsigned int host_failed;
	unsigned int host_eh_scheduled;
	unsigned int host_no;
	int eh_deadline;
	long unsigned int last_reset;
	unsigned int max_channel;
	unsigned int max_id;
	u64 max_lun;
	unsigned int unique_id;
	short unsigned int max_cmd_len;
	int this_id;
	int can_queue;
	short int cmd_per_lun;
	short unsigned int sg_tablesize;
	short unsigned int sg_prot_tablesize;
	unsigned int max_sectors;
	unsigned int opt_sectors;
	unsigned int max_segment_size;
	unsigned int dma_alignment;
	long unsigned int dma_boundary;
	long unsigned int virt_boundary_mask;
	unsigned int nr_hw_queues;
	unsigned int nr_maps;
	unsigned int active_mode: 2;
	unsigned int host_self_blocked: 1;
	unsigned int reverse_ordering: 1;
	unsigned int tmf_in_progress: 1;
	unsigned int async_scan: 1;
	unsigned int eh_noresume: 1;
	unsigned int no_write_same: 1;
	unsigned int host_tagset: 1;
	unsigned int queuecommand_may_block: 1;
	unsigned int short_inquiry: 1;
	unsigned int no_scsi2_lun_in_cdb: 1;
	unsigned int no_highmem: 1;
	char work_q_name[20];
	struct workqueue_struct *work_q;
	struct workqueue_struct *tmf_work_q;
	unsigned int max_host_blocked;
	unsigned int prot_capabilities;
	unsigned char prot_guard_type;
	long unsigned int base;
	long unsigned int io_port;
	unsigned char n_io_port;
	unsigned char dma_channel;
	unsigned int irq;
	enum scsi_host_state shost_state;
	struct device shost_gendev;
	struct device shost_dev;
	void *shost_data;
	struct device *dma_dev;
	int rpm_autosuspend_delay;
	long unsigned int hostdata[0];
};

struct Symbios_host {
	u_short type;
	u_short device_id;
	u_short vendor_id;
	u_char bus_nr;
	u_char device_fn;
	u_short word8;
	u_short flags;
	u_short io_port;
};

struct Symbios_target {
	u_char flags;
	u_char rsvd;
	u_char bus_width;
	u_char sync_offset;
	u_short sync_period;
	u_short timeout;
};

struct Symbios_scam {
	u_short id;
	u_short method;
	u_short status;
	u_char target_id;
	u_char rsvd;
};

struct Symbios_nvram {
	u_short type;
	u_short byte_count;
	u_short checksum;
	u_char v_major;
	u_char v_minor;
	u32 boot_crc;
	u_short flags;
	u_short flags1;
	u_short term_state;
	u_short rmvbl_flags;
	u_char host_id;
	u_char num_hba;
	u_char num_devices;
	u_char max_scam_devices;
	u_char num_valid_scam_devices;
	u_char flags2;
	struct Symbios_host host[4];
	struct Symbios_target target[16];
	struct Symbios_scam scam[4];
	u_char spare_devices[120];
	u_char trailer[6];
};

typedef struct Symbios_nvram Symbios_nvram;

typedef struct Symbios_target Symbios_target;

struct TAG_TW_SG_Entry_ISO {
	dma_addr_t address;
	dma_addr_t length;
};

typedef struct TAG_TW_SG_Entry_ISO TW_SG_Entry_ISO;

struct TAG_TW_Command_Apache {
	unsigned char opcode__reserved;
	unsigned char unit;
	short unsigned int request_id__lunl;
	unsigned char status;
	unsigned char sgl_offset;
	short unsigned int sgl_entries__lunh;
	unsigned char cdb[16];
	TW_SG_Entry_ISO sg_list[46];
	unsigned char padding[136];
};

struct TAG_TW_SG_Entry {
	twa_addr_t address;
	__le32 length;
} __attribute__((packed));

typedef struct TAG_TW_SG_Entry TW_SG_Entry;

struct TAG_TW_Command_Apache___2 {
	u8 opcode__reserved;
	u8 unit;
	__le16 request_id__lunl;
	u8 status;
	u8 sgl_offset;
	__le16 sgl_entries__lunh;
	u8 cdb[16];
	TW_SG_Entry sg_list[72];
	u8 padding[8];
};

typedef struct TAG_TW_Command_Apache TW_Command_Apache;

typedef struct TAG_TW_Command_Apache___2 TW_Command_Apache___2;

struct TAG_TW_Command_Apache_Header {
	unsigned char sense_data[18];
	struct {
		u8 reserved[4];
		__le16 error;
		u8 padding;
		u8 severity__reserved;
	} status_block;
	unsigned char err_specific_desc[98];
	struct {
		u8 size_header;
		u8 reserved[2];
		u8 size_sense;
	} header_desc;
};

struct TAG_TW_Command_Apache_Header___2 {
	unsigned char sense_data[18];
	struct {
		char reserved[4];
		short unsigned int error;
		unsigned char padding;
		unsigned char severity__reserved;
	} status_block;
	unsigned char err_specific_desc[98];
	struct {
		unsigned char size_header;
		short unsigned int request_id;
		unsigned char size_sense;
	} __attribute__((packed)) header_desc;
};

typedef struct TAG_TW_Command_Apache_Header TW_Command_Apache_Header;

typedef struct TAG_TW_Command_Apache_Header___2 TW_Command_Apache_Header___2;

struct TW_Command {
	u8 opcode__sgloffset;
	u8 size;
	u8 request_id;
	u8 unit__hostid;
	u8 status;
	u8 flags;
	union {
		__le16 block_count;
		__le16 parameter_count;
	} byte6_offset;
	union {
		struct {
			__le32 lba;
			TW_SG_Entry sgl[41];
			twa_addr_t padding;
		} io;
		struct {
			TW_SG_Entry sgl[41];
			__le32 padding;
			twa_addr_t padding2;
		} param;
	} byte8_offset;
};

typedef struct TW_Command TW_Command;

struct TAG_TW_Command_Full {
	TW_Command_Apache_Header header;
	union {
		TW_Command oldcommand;
		TW_Command_Apache___2 newcommand;
	} command;
};

struct TW_Command___2 {
	unsigned char opcode__sgloffset;
	unsigned char size;
	unsigned char request_id;
	unsigned char unit__hostid;
	unsigned char status;
	unsigned char flags;
	union {
		short unsigned int block_count;
		short unsigned int parameter_count;
	} byte6_offset;
	union {
		struct {
			u32 lba;
			TW_SG_Entry_ISO sgl[47];
			unsigned char padding[132];
		} __attribute__((packed)) io;
		struct {
			TW_SG_Entry_ISO sgl[47];
			u32 padding;
			unsigned char padding2[132];
		} param;
	} byte8_offset;
};

typedef struct TW_Command___2 TW_Command___2;

struct TAG_TW_Command_Full___2 {
	TW_Command_Apache_Header___2 header;
	union {
		TW_Command___2 oldcommand;
		TW_Command_Apache newcommand;
	} command;
};

typedef struct TAG_TW_Command_Full TW_Command_Full;

typedef struct TAG_TW_Command_Full___2 TW_Command_Full___2;

struct TAG_TW_Compatibility_Info {
	char driver_version[32];
	short unsigned int working_srl;
	short unsigned int working_branch;
	short unsigned int working_build;
	short unsigned int driver_srl_high;
	short unsigned int driver_branch_high;
	short unsigned int driver_build_high;
	short unsigned int driver_srl_low;
	short unsigned int driver_branch_low;
	short unsigned int driver_build_low;
	short unsigned int fw_on_ctlr_srl;
	short unsigned int fw_on_ctlr_branch;
	short unsigned int fw_on_ctlr_build;
};

typedef struct TAG_TW_Compatibility_Info TW_Compatibility_Info;

struct TAG_TW_Event;

typedef struct TAG_TW_Event TW_Event;

struct TAG_TW_Device_Extension {
	u32 *base_addr;
	long unsigned int *generic_buffer_virt[256];
	dma_addr_t generic_buffer_phys[256];
	TW_Command_Full *command_packet_virt[256];
	dma_addr_t command_packet_phys[256];
	struct pci_dev *tw_pci_dev;
	struct scsi_cmnd *srb[256];
	unsigned char free_queue[256];
	unsigned char free_head;
	unsigned char free_tail;
	unsigned char pending_queue[256];
	unsigned char pending_head;
	unsigned char pending_tail;
	int state[256];
	unsigned int posted_request_count;
	unsigned int max_posted_request_count;
	unsigned int pending_request_count;
	unsigned int max_pending_request_count;
	unsigned int max_sgl_entries;
	unsigned int sgl_entries;
	unsigned int num_resets;
	unsigned int sector_count;
	unsigned int max_sector_count;
	unsigned int aen_count;
	struct Scsi_Host *host;
	long int flags;
	int reset_print;
	TW_Event *event_queue[256];
	unsigned char error_index;
	unsigned char event_queue_wrapped;
	unsigned int error_sequence_id;
	int ioctl_sem_lock;
	ktime_t ioctl_time;
	int chrdev_request_id;
	wait_queue_head_t ioctl_wqueue;
	struct mutex ioctl_lock;
	char aen_clobber;
	TW_Compatibility_Info tw_compat_info;
};

struct TAG_TW_Device_Extension___2 {
	u32 base_addr;
	long unsigned int *alignment_virtual_address[256];
	long unsigned int alignment_physical_address[256];
	int is_unit_present[16];
	long unsigned int *command_packet_virtual_address[256];
	long unsigned int command_packet_physical_address[256];
	struct pci_dev *tw_pci_dev;
	struct scsi_cmnd *srb[256];
	unsigned char free_queue[256];
	unsigned char free_head;
	unsigned char free_tail;
	unsigned char pending_queue[256];
	unsigned char pending_head;
	unsigned char pending_tail;
	TW_Cmd_State state[256];
	u32 posted_request_count;
	u32 max_posted_request_count;
	u32 request_count_marked_pending;
	u32 pending_request_count;
	u32 max_pending_request_count;
	u32 max_sgl_entries;
	u32 sgl_entries;
	u32 num_resets;
	u32 sector_count;
	u32 max_sector_count;
	u32 aen_count;
	struct Scsi_Host *host;
	struct mutex ioctl_lock;
	short unsigned int aen_queue[256];
	unsigned char aen_head;
	unsigned char aen_tail;
	volatile long int flags;
	int reset_print;
	volatile int chrdev_request_id;
	wait_queue_head_t ioctl_wqueue;
};

struct TAG_TW_Device_Extension___3 {
	void *base_addr;
	long unsigned int *generic_buffer_virt[256];
	dma_addr_t generic_buffer_phys[256];
	TW_Command_Full___2 *command_packet_virt[256];
	dma_addr_t command_packet_phys[256];
	TW_Command_Apache_Header___2 *sense_buffer_virt[256];
	dma_addr_t sense_buffer_phys[256];
	struct pci_dev *tw_pci_dev;
	struct scsi_cmnd *srb[256];
	unsigned char free_queue[256];
	unsigned char free_head;
	unsigned char free_tail;
	int state[256];
	unsigned int posted_request_count;
	unsigned int max_posted_request_count;
	unsigned int max_sgl_entries;
	unsigned int sgl_entries;
	unsigned int num_resets;
	unsigned int sector_count;
	unsigned int max_sector_count;
	unsigned int aen_count;
	struct Scsi_Host *host;
	long int flags;
	TW_Event *event_queue[256];
	unsigned char error_index;
	unsigned int error_sequence_id;
	int chrdev_request_id;
	wait_queue_head_t ioctl_wqueue;
	struct mutex ioctl_lock;
	TW_Compatibility_Info tw_compat_info;
	char online;
};

typedef struct TAG_TW_Device_Extension___2 TW_Device_Extension;

typedef struct TAG_TW_Device_Extension___3 TW_Device_Extension___2;

typedef struct TAG_TW_Device_Extension TW_Device_Extension___3;

struct TAG_TW_Event {
	unsigned int sequence_id;
	unsigned int time_stamp_sec;
	short unsigned int aen_code;
	unsigned char severity;
	unsigned char retrieved;
	unsigned char repeat_count;
	unsigned char parameter_len;
	unsigned char parameter_data[98];
};

struct TAG_TW_Initconnect {
	u8 opcode__reserved;
	u8 size;
	u8 request_id;
	u8 res2;
	u8 status;
	u8 flags;
	__le16 message_credits;
	__le32 features;
	__le16 fw_srl;
	__le16 fw_arch_id;
	__le16 fw_branch;
	__le16 fw_build;
	__le32 result;
};

struct TAG_TW_Initconnect___2 {
	unsigned char opcode__reserved;
	unsigned char size;
	unsigned char request_id;
	unsigned char res2;
	unsigned char status;
	unsigned char flags;
	short unsigned int message_credits;
	u32 features;
	short unsigned int fw_srl;
	short unsigned int fw_arch_id;
	short unsigned int fw_branch;
	short unsigned int fw_build;
	u32 result;
};

typedef struct TAG_TW_Initconnect TW_Initconnect;

typedef struct TAG_TW_Initconnect___2 TW_Initconnect___2;

struct TAG_TW_Ioctl_Driver_Command {
	unsigned int control_code;
	unsigned int status;
	unsigned int unique_id;
	unsigned int sequence_id;
	unsigned int os_specific;
	unsigned int buffer_length;
};

typedef struct TAG_TW_Ioctl_Driver_Command TW_Ioctl_Driver_Command;

struct TAG_TW_Ioctl_Apache {
	TW_Ioctl_Driver_Command driver_command;
	char padding[488];
	TW_Command_Full firmware_command;
	char data_buffer[0];
};

struct TAG_TW_Ioctl_Apache___2 {
	TW_Ioctl_Driver_Command driver_command;
	char padding[488];
	TW_Command_Full___2 firmware_command;
	char data_buffer[0];
};

typedef struct TAG_TW_Ioctl_Apache TW_Ioctl_Buf_Apache;

typedef struct TAG_TW_Ioctl_Apache___2 TW_Ioctl_Buf_Apache___2;

struct TAG_TW_Lock {
	long unsigned int timeout_msec;
	long unsigned int time_remaining_msec;
	long unsigned int force_flag;
};

typedef struct TAG_TW_Lock TW_Lock;

struct TAG_TW_SG_Entry___2 {
	u32 address;
	u32 length;
};

typedef struct TAG_TW_SG_Entry___2 TW_SG_Entry___2;

struct TW_Command___3 {
	unsigned char opcode__sgloffset;
	unsigned char size;
	unsigned char request_id;
	unsigned char unit__hostid;
	unsigned char status;
	unsigned char flags;
	union {
		short unsigned int block_count;
		short unsigned int parameter_count;
		short unsigned int message_credits;
	} byte6;
	union {
		struct {
			u32 lba;
			TW_SG_Entry___2 sgl[62];
			u32 padding;
		} io;
		struct {
			TW_SG_Entry___2 sgl[62];
			u32 padding[2];
		} param;
		struct {
			u32 response_queue_pointer;
			u32 padding[125];
		} init_connection;
		struct {
			char version[504];
		} ioctl_miniport_version;
	} byte8;
};

typedef struct TW_Command___3 TW_Command___3;

struct TAG_TW_New_Ioctl {
	unsigned int data_buffer_length;
	unsigned char padding[508];
	TW_Command___3 firmware_command;
	char data_buffer[0];
};

typedef struct TAG_TW_New_Ioctl TW_New_Ioctl;

struct TAG_TW_Passthru {
	unsigned char opcode__sgloffset;
	unsigned char size;
	unsigned char request_id;
	unsigned char aport__hostid;
	unsigned char status;
	unsigned char flags;
	short unsigned int param;
	short unsigned int features;
	short unsigned int sector_count;
	short unsigned int sector_num;
	short unsigned int cylinder_lo;
	short unsigned int cylinder_hi;
	unsigned char drive_head;
	unsigned char command;
