package disk_bloom

import (
	"github.com/mzz2017/disk-bloom"
	"hash/fnv"
)

func doubleFNVFactory(salt []byte) func(b []byte) (uint64, uint64) {
	return func(b []byte) (uint64, uint64) {
		hx := fnv.New64()
		hx.Write(b)
		hx.Write(salt)
		x := hx.Sum64()
		hy := fnv.New64a()
		hy.Write(b)
		hy.Write(salt)
		y := hy.Sum64()
		return x, y
	}
}

const (
	n         = 1e8
	expectFPR = 1e-6
)

// NewBloom returns a bloom filter in the disk.
// The filenames are generated by taking pattern and adding a index to the end. the Pattern should includes a "*", and the index replaces the last "*".
func NewBloom(pattern string, salt []byte) (*disk_bloom.FilterGroup, error) {
	return disk_bloom.NewGroup(pattern, disk_bloom.FsyncModeEverySec, n, expectFPR, doubleFNVFactory(salt))
}
