# Changelog

## [0.18.0](https://github.com/daeuniverse/daed/compare/v0.17.0...v0.18.0) (2025-11-29)


### Features

* implement drag-and-drop functionality for input list items ([23a3a29](https://github.com/daeuniverse/daed/commit/23a3a291a19e182eb56b984d6380f64e7769c609))

## [0.17.0](https://github.com/daeuniverse/daed/compare/v0.16.0...v0.17.0) (2025-11-29)


### Features

* make children prop optional and conditionally render button for details modal ([8809a2e](https://github.com/daeuniverse/daed/commit/8809a2e97f7c086334e1f3bd6e4ebecb2e412a2e))

## [0.16.0](https://github.com/daeuniverse/daed/compare/v0.15.1...v0.16.0) (2025-11-29)


### Features

* enhance form structure and integrate actions portal for improved footer management ([1a94040](https://github.com/daeuniverse/daed/commit/1a940404631314545f1dbc827457c9ae43c0dece))

## [0.15.1](https://github.com/daeuniverse/daed/compare/v0.15.0...v0.15.1) (2025-11-29)


### Bug Fixes

* **i18n:** update labels for sensitive content visibility in English and Chinese locales ([b86188e](https://github.com/daeuniverse/daed/commit/b86188ecbcb1a99fc2efa2634a00dd3cadc5eef1))

## [0.15.0](https://github.com/daeuniverse/daed/compare/v0.14.0...v0.15.0) (2025-11-29)


### Features

* add sortable components for nodes and subscriptions ([f98f784](https://github.com/daeuniverse/daed/commit/f98f784008953eaa82bf4a8d9529fa06b722f4e8))
* enhance draggable components with grip handles ([77552d7](https://github.com/daeuniverse/daed/commit/77552d71f2744bdab653a71f50213f1c4ba0d89b))
* **monaco:** integrate Shiki for enhanced syntax highlighting and theme support ([02510f9](https://github.com/daeuniverse/daed/commit/02510f915921faa6a77e2082f92e2ba42f609cc6))

## [0.14.0](https://github.com/daeuniverse/daed/compare/v0.13.0...v0.14.0) (2025-11-29)


### Features

* add rename functionality to various components ([df74727](https://github.com/daeuniverse/daed/commit/df747275a14729475dc70d65fe9e4c8d52243724))
* **EditNodeFormModal:** refactor to support edit node configurations ([ff8e77e](https://github.com/daeuniverse/daed/commit/ff8e77e0ce2223be7a80ac00b899deb4df2c2ca4))
* **forms:** implement useNodeForm hook for streamlined form handling ([655220a](https://github.com/daeuniverse/daed/commit/655220ab39a30e6d550114667a9cfe6f07d18f52))
* **styles:** update color scheme for light and dark modes ([141d3db](https://github.com/daeuniverse/daed/commit/141d3db833c894e6c3608c1e52ae6f86840816c2))
* **theme:** refactor color scheme handling to support theme modes ([639c82c](https://github.com/daeuniverse/daed/commit/639c82c144e847fc6f9b8e6d08cc737bcab5c707))


### Bug Fixes

* **SimpleCard:** adjust border styles and class names for improved layout ([bbb1d4b](https://github.com/daeuniverse/daed/commit/bbb1d4ba46f803f584d3841c9f59a77bc984e979))

## [0.13.0](https://github.com/daeuniverse/daed/compare/v0.12.0...v0.13.0) (2025-11-29)


### Features

* **dependabot:** add daily update schedules for GitHub Actions and Git submodules ([dc03f56](https://github.com/daeuniverse/daed/commit/dc03f56400805fdf6461268ab4fd5ea5f920e9f8))
* **docs:** update build, commit message guide, and getting started documentation ([5b70612](https://github.com/daeuniverse/daed/commit/5b70612abaea61bca0522352457d43252892dcbd))
* enhance README with Docker deployment instructions and online demo section ([d78a38c](https://github.com/daeuniverse/daed/commit/d78a38c969905c9a78748a8e7bb73c85cedcfe19))
* **forms:** extract setValue logic into useSetValue hook and enhance form validation ([84810c5](https://github.com/daeuniverse/daed/commit/84810c5f8f2ed573bc436ce4e9b88eeeaf20c5e3))
* **Header:** enhance header component with new Sheet elements and improve button styles ([010119e](https://github.com/daeuniverse/daed/commit/010119ece8c87252e1388067eeb091020037b6ac))


### Bug Fixes

* **i18n:** refine endpoint setup messages for clarity and consistency ([02f5bc4](https://github.com/daeuniverse/daed/commit/02f5bc4defb51cfd0bbd0bf6c327c714c10ff522))

## [0.12.0](https://github.com/daeuniverse/daed/compare/v0.11.0...v0.12.0) (2025-11-29)


### Features

* refactor forms to use react-hook-form with zod validation ([0a13447](https://github.com/daeuniverse/daed/commit/0a13447f397fb3a75d996a594f376e58fc2b67bf))
* update Header component to handle avatar display and add APP_VERSION type definitions ([4c19631](https://github.com/daeuniverse/daed/commit/4c1963129ef8a697c70f08744aa8426a6336eb48))

## [0.11.0](https://github.com/daeuniverse/daed/compare/v0.10.0...v0.11.0) (2025-11-29)


### Features

* update Header component to use APP_VERSION from environment variables ([45866d5](https://github.com/daeuniverse/daed/commit/45866d58604c3ead4dbc709307e925491ac571e1))

## [0.10.0](https://github.com/daeuniverse/daed/compare/v0.9.3...v0.10.0) (2025-11-29)


### Features

* enhance ConfigureNodeFormModal with scrollable dialog components ([36d4d1e](https://github.com/daeuniverse/daed/commit/36d4d1efb08b7fdeff98b59a93a4f28f6fe66ed2))
* implement scrollable dialog components and update existing dialogs to use them ([e9d5b90](https://github.com/daeuniverse/daed/commit/e9d5b90dbae05e7d5afebf2efdd231176a080779))
* improve code formatting and enhance drag overlay behavior ([9448abd](https://github.com/daeuniverse/daed/commit/9448abd1a605d6922400c507c13380dd6617a28c))
* refactor modal components to improve type safety and props structure ([266282b](https://github.com/daeuniverse/daed/commit/266282b05f1834ac0571719260c483bb594b131f))

## [0.9.3](https://github.com/daeuniverse/daed/compare/v0.9.2...v0.9.3) (2025-11-29)


### Bug Fixes

* standardize formatting and improve readability across multiple files ([62e5be8](https://github.com/daeuniverse/daed/commit/62e5be8ad2f90a0f71ebd45d0899785f39ad09cf))
* update husky scripts to use pnpm for consistency ([f1637a4](https://github.com/daeuniverse/daed/commit/f1637a4b20764f80c0ed62a45c6463314089e00c))

## [0.9.2](https://github.com/daeuniverse/daed/compare/v0.9.1...v0.9.2) (2025-11-29)


### Bug Fixes

* update Dockerfile to streamline build process and remove unnecessary platforms ([deee5c1](https://github.com/daeuniverse/daed/commit/deee5c1357f2cee07ce4e4d326f58233bfb0e0f8))

## [0.9.1](https://github.com/daeuniverse/daed/compare/v0.9.0...v0.9.1) (2025-11-29)

### Bug Fixes

- disable caching for Go setup in release workflow ([b5fe59e](https://github.com/daeuniverse/daed/commit/b5fe59ebb5049a65d20ea75b21f15e3c5186f650))

## [0.9.0](https://github.com/daeuniverse/daed/compare/v0.8.1...v0.9.0) (2025-11-29)

### Features

- update pnpm workspace and vite configuration ([18d26f6](https://github.com/daeuniverse/daed/commit/18d26f68e06eba847bced47dc21a8f0f322d98fd))

### Bug Fixes

- improve code formatting and consistency in PlainTextFormModal component ([934f082](https://github.com/daeuniverse/daed/commit/934f0828ec8a5ccad4501da3e62a4bf140292cbc))
- update Go version to 1.22 and improve code formatting in form components ([585af57](https://github.com/daeuniverse/daed/commit/585af572c5ec1d6d4ebd56da267f7a36b1248eac))

## [0.8.1](https://github.com/daeuniverse/daed/compare/v0.8.0...v0.8.1) (2025-11-29)

### Bug Fixes

- standardize Dockerfile stage names to uppercase ([ce42cab](https://github.com/daeuniverse/daed/commit/ce42cabd3e055a59871b221fb03c0311de404bf5))
- update subproject commit reference in wing ([4a523db](https://github.com/daeuniverse/daed/commit/4a523db8288b5d7f85157ab9a3e210154d6167d8))

## [0.8.0](https://github.com/daeuniverse/daed/compare/v0.7.0...v0.8.0) (2025-11-29)

### Features

- **account settings:** update name ([f1897a4](https://github.com/daeuniverse/daed/commit/f1897a44c77a6309b3f0bbf6553688c42e7a56ea))
- add a basic simple mode homepage ([4460195](https://github.com/daeuniverse/daed/commit/44601957d2edb86c61f50b85714864cc60637b9d))
- add a configure node modal ([#125](https://github.com/daeuniverse/daed/issues/125)) ([fa55f7c](https://github.com/daeuniverse/daed/commit/fa55f7c8ab82aa87d67624f507293373f332dc34))
- add a modal to show node qrcode ([#99](https://github.com/daeuniverse/daed/issues/99)) ([3a3e965](https://github.com/daeuniverse/daed/commit/3a3e96521e1e65e856cbc98e3663e639105f1d38))
- add configure hysteria2 modal ([#440](https://github.com/daeuniverse/daed/issues/440)) ([ef2b4c5](https://github.com/daeuniverse/daed/commit/ef2b4c50b4fdcb5232711950d0a4c5636cc01354))
- add configure juicity modal ([#191](https://github.com/daeuniverse/daed/issues/191)) ([3f08f55](https://github.com/daeuniverse/daed/commit/3f08f55e881fea4aca65c83270216531889719c7))
- add configure tuic modal ([#157](https://github.com/daeuniverse/daed/issues/157)) ([a564445](https://github.com/daeuniverse/daed/commit/a564445456089656518b75919f2ae6d222aa994b))
- add create config `name` field ([f8fec36](https://github.com/daeuniverse/daed/commit/f8fec36b6ba9e27dae81fc0baf6bd3336177ba48))
- add description text for group policies ([d837090](https://github.com/daeuniverse/daed/commit/d837090139c3dd177e8f0649c6a3ff17a59d7c9d))
- add desktop file and icons ([#221](https://github.com/daeuniverse/daed/issues/221)) ([b05d5db](https://github.com/daeuniverse/daed/commit/b05d5db7ce68ef5f228a565d078dacaddd6cb919))
- add font source-code-pro ([a8c8ba8](https://github.com/daeuniverse/daed/commit/a8c8ba82d1fb2b8a13967fed39be81ddfb120094))
- add group and routing page ([772e240](https://github.com/daeuniverse/daed/commit/772e240812e51ecd67ca6f638449157441845dc9))
- add header icon link to github project, and a footer ([#108](https://github.com/daeuniverse/daed/issues/108)) ([dc1521c](https://github.com/daeuniverse/daed/commit/dc1521ce660e4e690544e27676c7282f2e8cd0c4))
- add icon before titles ([5b4f930](https://github.com/daeuniverse/daed/commit/5b4f930d7aad45edcf06df2922c4eaee8777fc4d))
- add juicity pinned_certchain_sha256 config ([#219](https://github.com/daeuniverse/daed/issues/219)) ([42cc5ee](https://github.com/daeuniverse/daed/commit/42cc5ee4f5eb2dd6829c7f7067485aab13b35672))
- add loading state indicators ([5de2006](https://github.com/daeuniverse/daed/commit/5de200622fb4f3e04d3ca65c7648db865616fe8f))
- add missing default resources if any ([0739d1f](https://github.com/daeuniverse/daed/commit/0739d1f4eed35bf1c98f0c489259259383a38753))
- add new UI components; enhance existing components and styles ([8d34081](https://github.com/daeuniverse/daed/commit/8d3408164d7e66c3315d097e8808d3146c64273e))
- add nodes to default group under simple mode ([407d79e](https://github.com/daeuniverse/daed/commit/407d79e598606992c77c843a0b23a380e1cb3a86))
- add pnpm workspace configuration and monaco editor integration ([a71d4ce](https://github.com/daeuniverse/daed/commit/a71d4ced3073540cd75b0c1b43661d9a06ef09d7))
- add SortableGrid ([002adcc](https://github.com/daeuniverse/daed/commit/002adcc68b1796b5f2b04711821fd4a776cbe167))
- add table component ([c32ad1b](https://github.com/daeuniverse/daed/commit/c32ad1b7baa3322138f8310c4801f967c67891a3))
- add toggle running switch ([91476d9](https://github.com/daeuniverse/daed/commit/91476d902d2d5e8adc4e82bffd7e6820fe29d541))
- add tooltip for header actions ([#97](https://github.com/daeuniverse/daed/issues/97)) ([d5bad2a](https://github.com/daeuniverse/daed/commit/d5bad2ae4f1316b1766331faf077688c07572c10))
- authentication ([11c322e](https://github.com/daeuniverse/daed/commit/11c322e80ef90d34d2f163b42f58e32a00e7f7b4))
- backend initialization ([ab4df8e](https://github.com/daeuniverse/daed/commit/ab4df8ece81aca9bfbc56e41d90d5ccc43037732))
- change editor font to `Source Code Pro` ([#218](https://github.com/daeuniverse/daed/issues/218)) ([2c5518e](https://github.com/daeuniverse/daed/commit/2c5518e0e9896adc11576aba00759b42bf1907d6))
- change icons ([#147](https://github.com/daeuniverse/daed/issues/147)) ([9c297b3](https://github.com/daeuniverse/daed/commit/9c297b3fe1ec90890f3227646732f9a60fe35f77))
- change the presentation form of certain details to `Drawer`s ([1026f92](https://github.com/daeuniverse/daed/commit/1026f9265a1753d6dc355c87c1f203eacfa1f62e))
- change toggle running button color when state change ([47a0e55](https://github.com/daeuniverse/daed/commit/47a0e555b62b66fc5799945ea1b9d0cb083e8145))
- **config:** add descriptive help texts for user inputs ([6f9bf53](https://github.com/daeuniverse/daed/commit/6f9bf53cc3131ba22e86256cc9efb201df7b1c05))
- **config:** add fallbackResolver form field ([#530](https://github.com/daeuniverse/daed/issues/530)) ([d9d4515](https://github.com/daeuniverse/daed/commit/d9d4515b605878836e1cefddd177261a3ac57caf))
- **config:** add form field ([#498](https://github.com/daeuniverse/daed/issues/498)) ([068e5a7](https://github.com/daeuniverse/daed/commit/068e5a77c1cf42a5a575215437c84beddcee30ce))
- **config:** add form field `soMarkFromDae` ([#251](https://github.com/daeuniverse/daed/issues/251)) ([736ae96](https://github.com/daeuniverse/daed/commit/736ae96521cda7337241af20ccf0feff3568a207))
- **config:** add more config related fields ([df3ed8b](https://github.com/daeuniverse/daed/commit/df3ed8bbfbad72ea63064253b78ecf8ee79de99d))
- **config:** remove tls related fields for now ([6d14e9d](https://github.com/daeuniverse/daed/commit/6d14e9d7482d803cbf501ca30dfc0a71ef56626c))
- **config:** select config ([c79ea88](https://github.com/daeuniverse/daed/commit/c79ea88b1e4f3399aee792efd93cc05554f25f9b))
- **config:** select multiple interfaces ([08afa97](https://github.com/daeuniverse/daed/commit/08afa97cec9a68504cce7450f7853479599660e8))
- **config:** show interface ip addresses in interface select ([8279137](https://github.com/daeuniverse/daed/commit/82791378ec298c22d11d979affbf557cc77be842))
- **config:** use accordion to collapse/expand sections ([c7c9cca](https://github.com/daeuniverse/daed/commit/c7c9ccac5de026f99314a9202ad97971ffc6870c))
- create dns ([563a011](https://github.com/daeuniverse/daed/commit/563a011298fa0aabd3068b74a1e09a3f2ebaa4da))
- create group form add policyParams support ([fa43a16](https://github.com/daeuniverse/daed/commit/fa43a160956d9e4e8c9e4de6f4403540dfc912da))
- create group form modal ([68657ff](https://github.com/daeuniverse/daed/commit/68657fff96a485cce8f372515c7dc13b16a1ae3b))
- create new config within modal ([35516c1](https://github.com/daeuniverse/daed/commit/35516c1f5769f349317e466fd137abce04050af7))
- create routing ([08a189c](https://github.com/daeuniverse/daed/commit/08a189c28c9d005b4a89b1e44b04e093f7347c6e))
- disable rollbackError, fixes [#207](https://github.com/daeuniverse/daed/issues/207) ([#208](https://github.com/daeuniverse/daed/issues/208)) ([29dbbcc](https://github.com/daeuniverse/daed/commit/29dbbccbc7b0104afc1c04b44d0f73f15272d87c))
- disable zooming and panning on mobile ([#113](https://github.com/daeuniverse/daed/issues/113)) ([5a9a095](https://github.com/daeuniverse/daed/commit/5a9a095f5621f94bde7552a61dfb2598a9070787))
- display daed version in header ([#132](https://github.com/daeuniverse/daed/issues/132)) ([6f9b1b8](https://github.com/daeuniverse/daed/commit/6f9b1b834ea02b4a97159faf73a356be348f748a))
- display details with modal ([932da0a](https://github.com/daeuniverse/daed/commit/932da0a15efa70eba63139eaaff7dd9ca0e367fa))
- drag nodes and subscriptions between groups ([505a2b3](https://github.com/daeuniverse/daed/commit/505a2b32afc04e612b617da71c30efcaf16c7c3d))
- **editor:** add routingA code highlight ([#105](https://github.com/daeuniverse/daed/issues/105)) ([2fbbc7a](https://github.com/daeuniverse/daed/commit/2fbbc7af6c598a3df22609c0ee1712dedbe410a1))
- **editor:** render tags ([#106](https://github.com/daeuniverse/daed/issues/106)) ([229c2c6](https://github.com/daeuniverse/daed/commit/229c2c69aa638af2b6b68591046cf473ca8180be))
- encrypt secret data ([0054597](https://github.com/daeuniverse/daed/commit/0054597c7e4b4f31134727bb33fd5518c51c83d3))
- encryptable Displayable component ([5b92c40](https://github.com/daeuniverse/daed/commit/5b92c4045fce2dc3ea793a9ecef92f1cf43a19ac))
- enhance component functionality and improve code structure ([afdafbd](https://github.com/daeuniverse/daed/commit/afdafbd11f7e99f4c8207c813fef3aa9d8fba32c))
- **experiment:** add node to groups by dnd ([6dcbb7d](https://github.com/daeuniverse/daed/commit/6dcbb7d1596f1d8549a62b6ca4202c0d329de111))
- **experiment:** change to column display ([a548b3d](https://github.com/daeuniverse/daed/commit/a548b3de965b67913a55c7252ae8e2cbf76a5b34))
- **experiment:** dns, routing ([3e63a3b](https://github.com/daeuniverse/daed/commit/3e63a3b8fc78d9c04ef5bc0737f0df4be940fc3d))
- extract a new orchestrate page from experiment ([f53b1e2](https://github.com/daeuniverse/daed/commit/f53b1e2c8a4745a87bc1a86ae21fd08999df4342))
- fancy switch toggle ([107dcbc](https://github.com/daeuniverse/daed/commit/107dcbc3a1fa2d2042f67a57e562c38b2f72f10b))
- global toast ([4b0a8e9](https://github.com/daeuniverse/daed/commit/4b0a8e910b80145f7d3afbf76ea7fdf8ce5108f8))
- **group:** add fixed policy selection ([#467](https://github.com/daeuniverse/daed/issues/467)) ([2c6593b](https://github.com/daeuniverse/daed/commit/2c6593b5426c51a8605905f5bc783d094c7d7826))
- **group:** hide nodes and subscriptions if empty ([3cb9d01](https://github.com/daeuniverse/daed/commit/3cb9d01a8a8e0deaf1edadac15ee5bda93dadc60))
- **group:** show subscription tag on node hover ([1d19f52](https://github.com/daeuniverse/daed/commit/1d19f52e851d899d4a722f18806d709bd1f7020c))
- growable input list ([ff61920](https://github.com/daeuniverse/daed/commit/ff6192083d3cd97f3d694f4a2d89c060ab4bd01f))
- **header:** add account settings ([4d28491](https://github.com/daeuniverse/daed/commit/4d28491605d03e4213958d41c711d7919a342de9))
- hide group node and subscription count indicators if list is empty ([003e366](https://github.com/daeuniverse/daed/commit/003e3660c3f2b27b83e0252a2c61b94cabf6e8ca))
- highlight droppable section ([e62cbdf](https://github.com/daeuniverse/daed/commit/e62cbdf6999c6bf8b91c47100bdf2ce2c5544f4d))
- import node list from growable input list ([5ae200e](https://github.com/daeuniverse/daed/commit/5ae200e4affc3c95f56beefe9fdadabfbfcaf7cd))
- import nodes ([03e240e](https://github.com/daeuniverse/daed/commit/03e240e2642560736427a3c8b52da109ad9e0e96))
- import subscription ([6e46730](https://github.com/daeuniverse/daed/commit/6e467301be3f46b7859a0d9d61c5be7ad1580cd5))
- initial setup ([786a4df](https://github.com/daeuniverse/daed/commit/786a4dfc001914ca62dfa226b77eea35421a44a6))
- make plaintext modal fullscreen ([#109](https://github.com/daeuniverse/daed/issues/109)) ([0bf6eb1](https://github.com/daeuniverse/daed/commit/0bf6eb16d31324d5b085bd47bcd74a3d46d43f49))
- make rules card clickable area larger ([e9b39ac](https://github.com/daeuniverse/daed/commit/e9b39acbaaca7e6b1fdabd67f9e706a63b6ed03b))
- migrate to material-ui ([5e5e729](https://github.com/daeuniverse/daed/commit/5e5e729e9e2bfbc6920de4bf21c336e4a41edcf1))
- migrate to release-please for automated releases ([#546](https://github.com/daeuniverse/daed/issues/546)) ([5e99a94](https://github.com/daeuniverse/daed/commit/5e99a94c49bf3b31a9a92e5571eb1a69671e355a))
- minor adjustments ([ad22162](https://github.com/daeuniverse/daed/commit/ad221625d806a5fdd1ecdb9a47a83b014251e8c8))
- modal reworks ([#149](https://github.com/daeuniverse/daed/issues/149)) ([0fa1572](https://github.com/daeuniverse/daed/commit/0fa1572a673ef634609f9949ab0b651c7389c275))
- multiple setup page, fixes [#9](https://github.com/daeuniverse/daed/issues/9) ([b482b0b](https://github.com/daeuniverse/daed/commit/b482b0b6ca171ad82ea020766b0e1e6a8230c3dd))
- **node:** refactor EditNodeFormModal to use Dialog component and improve form handling ([1ad92dc](https://github.com/daeuniverse/daed/commit/1ad92dc7b60541b4557ca03b78f704e95dc1b490))
- **node:** support edit node ([#540](https://github.com/daeuniverse/daed/issues/540)) ([c4c8657](https://github.com/daeuniverse/daed/commit/c4c86572771ad6dc1bc7fba2ff948fddba2b3872))
- only render NodeList inside Home when mode is simple ([8bfc534](https://github.com/daeuniverse/daed/commit/8bfc534c07b4f6566d045d42b7ed161b7e33cd71))
- only use BrowserRouter if under development mode ([cecbf6e](https://github.com/daeuniverse/daed/commit/cecbf6ed8b3362c7135ec52658171d28797ec402))
- **password:** support change password ([#538](https://github.com/daeuniverse/daed/issues/538)) ([aeaa6ac](https://github.com/daeuniverse/daed/commit/aeaa6ac1bad8786a6b53974219301d6429c9d2ea))
- prevent user from deleting default rules ([8cae50d](https://github.com/daeuniverse/daed/commit/8cae50d0346154e9e29b6825e3986b8ef6b57aff))
- query loading indicator ([130bfca](https://github.com/daeuniverse/daed/commit/130bfcadc2059b7f4a92f2138eacf0aabdae2fac))
- reduce hover card area to icon ([0496f33](https://github.com/daeuniverse/daed/commit/0496f331a8b4b32c86e38ba92859e5d6cf38a3e9))
- refine config page ([2c8fdb7](https://github.com/daeuniverse/daed/commit/2c8fdb7238aecfad62a8cb7b689221111fd29faa))
- refine node page ([57cd1df](https://github.com/daeuniverse/daed/commit/57cd1dfcc3bc16d7b0bc9c1dc37ffe5b6ffff49c))
- rename default config (global) and group (proxy) ([99a268f](https://github.com/daeuniverse/daed/commit/99a268fc12517f3cb0e8e84d663018cf26d344b6))
- rename rules ([81782b5](https://github.com/daeuniverse/daed/commit/81782b5c49e088bd9e8997007c01ad5514c8dad5))
- render data using SimpleDisplay ([73106cc](https://github.com/daeuniverse/daed/commit/73106cc469aed8cd22d05e8894fa40f6d9bfcbf0))
- render key-value pairs as List for now ([d9d1ad5](https://github.com/daeuniverse/daed/commit/d9d1ad5575317ab139a89117e08e6832068f9b80))
- render qrcode in canvas to allow user to save image ([#100](https://github.com/daeuniverse/daed/issues/100)) ([0ec1d61](https://github.com/daeuniverse/daed/commit/0ec1d615d6c29836115332b14dbdcf6db30bab8d))
- replace sidebar with header ([243f712](https://github.com/daeuniverse/daed/commit/243f712b67bb35a7bd4be23a0a8a0bdd1ee6a509))
- responsive header ([#111](https://github.com/daeuniverse/daed/issues/111)) ([274e596](https://github.com/daeuniverse/daed/commit/274e5966689b04edddc1c3b1a499091ce91c463f))
- restrict drag and drop area ([2d16909](https://github.com/daeuniverse/daed/commit/2d169098631901f0c3160802d4ebc0153d5d722c))
- **rfc:** show reload when specific mutations happen ([74bde73](https://github.com/daeuniverse/daed/commit/74bde73c35cb909471ad8c760cc86828cd12644d))
- **rfc:** show reload when specific mutations happen ([21b487d](https://github.com/daeuniverse/daed/commit/21b487de396afe7f9a8385224a4f4d7d0a9119a4))
- **Router:** add gh-pages support ([1d7143f](https://github.com/daeuniverse/daed/commit/1d7143fffcf5125e7cd4c81f74e76efbf563c8a5))
- **routing:** add dnsmasq to must_direct default routing ([#258](https://github.com/daeuniverse/daed/issues/258)) ([4823f5b](https://github.com/daeuniverse/daed/commit/4823f5b99693b937670f69e6fe5a1ab6479c0587))
- rule editing ([faf7a06](https://github.com/daeuniverse/daed/commit/faf7a06c4e05cd5ec124cd0c007f0fac3d448afe))
- **rules:** hide remove button if selected ([e1a41a1](https://github.com/daeuniverse/daed/commit/e1a41a1ded940e927eaec6f9ea1bbd91c3a8bb62))
- save sorted grid orders ([8d14950](https://github.com/daeuniverse/daed/commit/8d14950ad5a46d9e7e6bd3cb920fe461d4403ab8))
- select routing and dns ([f5ded1b](https://github.com/daeuniverse/daed/commit/f5ded1be2acc92783c9707329161b6dd020d880c))
- set `DEFAULT_AUTO_CONFIG_KERNEL_PARAMETER` to true ([fd07017](https://github.com/daeuniverse/daed/commit/fd070175be13d9b7a142d7d5adad462ee20cb068))
- set color scheme based on system preference ([#205](https://github.com/daeuniverse/daed/issues/205)) ([cc88300](https://github.com/daeuniverse/daed/commit/cc88300159dfd499421e09ab37ce45ebe89ecde0))
- set cursor type of input as pointer ([e9ad4a5](https://github.com/daeuniverse/daed/commit/e9ad4a51d9e8f2164e6333721b4a17474a8a7192))
- set default endpoint url as current `location.hostname` ([9fc3457](https://github.com/daeuniverse/daed/commit/9fc345785d7168d2687727d6a0589a45903a7d9b))
- show data item count ([a5a1e9a](https://github.com/daeuniverse/daed/commit/a5a1e9a83eeb608cdc97352c4168be6de0d6c62f))
- show node protocol in card title ([#98](https://github.com/daeuniverse/daed/issues/98)) ([9cb2aea](https://github.com/daeuniverse/daed/commit/9cb2aea4a284d388d17eb2260e2bc1f168a0177e))
- show raw routing and dns string ([08e475c](https://github.com/daeuniverse/daed/commit/08e475c23fd8faef4b1e571807583989e840e8d7))
- simple mode ([cea0ce8](https://github.com/daeuniverse/daed/commit/cea0ce837a9bf0a92330e3013d152f03df5b1cf8))
- sortable subscriptions ([05ff35d](https://github.com/daeuniverse/daed/commit/05ff35dcf8ac231345d8b7e35746bdbbd98be717))
- **subscription:** collapsible node list ([8d5b68c](https://github.com/daeuniverse/daed/commit/8d5b68c9daaaa28b15822b04254d0c4374ea3e1a))
- **subscription:** support edit subscription ([#539](https://github.com/daeuniverse/daed/issues/539)) ([5b14f2a](https://github.com/daeuniverse/daed/commit/5b14f2a9386403d302e53af0ce43a678fc315234))
- **subscription:** support for updating subscriptions in batch ([972b9bb](https://github.com/daeuniverse/daed/commit/972b9bb08b7638a2c71db0e1f9cf7503f983d190))
- support small screen devices ([#110](https://github.com/daeuniverse/daed/issues/110)) ([76f0e2f](https://github.com/daeuniverse/daed/commit/76f0e2f56b0162cd53d4e9308d0107b6820044e1))
- **tuic:** upgrade dae-wing to support tuic v5 ([#135](https://github.com/daeuniverse/daed/issues/135)) ([2ea0dcb](https://github.com/daeuniverse/daed/commit/2ea0dcb452a0b6cbe66db72f4b52ba80db32caf1))
- update home page ([5130953](https://github.com/daeuniverse/daed/commit/51309531237366b35adb4ef1fde1ba801fc0412f))
- update subscription ([cb065d3](https://github.com/daeuniverse/daed/commit/cb065d39ef62dee755faad25b6458b78bbb361db))
- upgrade dae-wing ([b6171f2](https://github.com/daeuniverse/daed/commit/b6171f20c9ac284b66f7695c2652520f6381ae2d))
- use @chakra-ui/icons ([4e11cbd](https://github.com/daeuniverse/daed/commit/4e11cbd9fc33a3092b6b0beaf9f5442530a7e3ff))
- use monaco editor for dns and routing ([#101](https://github.com/daeuniverse/daed/issues/101)) ([d4054e4](https://github.com/daeuniverse/daed/commit/d4054e42d81f154a3b1dcdf10ff71d1e6a014f1a))
- use source code pro font for dns/routing input ([b93ff0e](https://github.com/daeuniverse/daed/commit/b93ff0ec87589c51d539cda81191ba98d4ec1cf7))
- use theme `github` as default monaco editor light theme ([#102](https://github.com/daeuniverse/daed/issues/102)) ([47b49f6](https://github.com/daeuniverse/daed/commit/47b49f64e423fbd15a2a67206990993375397046))
- user setup ([6939891](https://github.com/daeuniverse/daed/commit/69398914353e2ca50f5d5b709f1fce0a3949a413))
- wan interface auto detect ([#133](https://github.com/daeuniverse/daed/issues/133)) ([4b4b099](https://github.com/daeuniverse/daed/commit/4b4b0996ce42fb28f81662cdc316ed8d854a82e4))
- wrap icon with Icon component ([de97cf3](https://github.com/daeuniverse/daed/commit/de97cf3e74c8505f36ac015adfdfe8e3b4c20722))

### Bug Fixes

- a bunch of issues ([a22addd](https://github.com/daeuniverse/daed/commit/a22addd1da85542bfe870698134935d36fc3a4e8))
- add DEFAULT_UDP_CHECK_DNS ipv6 address missing colon ([c354148](https://github.com/daeuniverse/daed/commit/c354148f1ad6aa25516c4ba5bf4921b570664d03))
- apply minior fix ([2e2c0b4](https://github.com/daeuniverse/daed/commit/2e2c0b430aebb5af9712cc7ad10bcaffe182febb))
- avoid to install husky when not in a git repo ([#185](https://github.com/daeuniverse/daed/issues/185)) ([71d9314](https://github.com/daeuniverse/daed/commit/71d93149fbc1b44a8bfa088e4df6af1fa51fbb99))
- **build-nightly:** fix broken logic ([dd6f37f](https://github.com/daeuniverse/daed/commit/dd6f37f22183073c8c8404cb25de64d85f8f93b6))
- cannot stop running ([32c2a27](https://github.com/daeuniverse/daed/commit/32c2a2701a18af2036769d093efad3365fd76053))
- card list data reorder ([9c64f4c](https://github.com/daeuniverse/daed/commit/9c64f4c0787091f0093d3e2045016e4bbca89230))
- codegen ([a0231f5](https://github.com/daeuniverse/daed/commit/a0231f5ec546434e8c87aee02edde536e7432852))
- config form may lack behind from the user inputs ([e773243](https://github.com/daeuniverse/daed/commit/e7732436b212ca9277942f818256b01e5c1e0fed))
- **config:** add missing form modal fields, fix lan interface, autoConfigKernelParameter ([1007125](https://github.com/daeuniverse/daed/commit/10071250f351638880a99e9ac36bd43a81c7f8b7))
- **config:** change `DEFAULT_TCP_CHECK_HTTP_METHOD` from `CONNECT` to `HEAD` ([76bff35](https://github.com/daeuniverse/daed/commit/76bff35afcd0b88bce99939e8cef1791fe30db0b))
- **config:** disable allow insecure by default ([c0e7079](https://github.com/daeuniverse/daed/commit/c0e7079222340d218fcff6ec70c86cca78160d62))
- **config:** properly set wan interfaces ([6580baf](https://github.com/daeuniverse/daed/commit/6580baf88d62e7d2bd97c82e2674e58cde6c8b95))
- **config:** refine default values to align with the doc ([c18e038](https://github.com/daeuniverse/daed/commit/c18e038701725d9519d5a005caf324d19abef46b))
- copy to clipboard not working when clipboard permissions not permitted ([#217](https://github.com/daeuniverse/daed/issues/217)) ([ead5445](https://github.com/daeuniverse/daed/commit/ead54453d796f87aa758bd3d38b84e803f55cc28))
- correct version format in package.json and update release type in release-please-config.json ([a9d01d6](https://github.com/daeuniverse/daed/commit/a9d01d6f7f0888443db13bd26d5f1b6f50481357))
- default googledns add tcp ([9b6e8a4](https://github.com/daeuniverse/daed/commit/9b6e8a4effb1f2c5ca33b6ad29342b79b2cf4a08))
- dialMode should be using const value ([7bdc4e0](https://github.com/daeuniverse/daed/commit/7bdc4e08f11141e0ba92e67720d114cc1cf1a954))
- disable spellCheck for DNS and Routing textarea input ([9324091](https://github.com/daeuniverse/daed/commit/93240910ff52e8f4e35f14c37b8668afc25eaa95))
- dragging not working properly ([#91](https://github.com/daeuniverse/daed/issues/91)) ([3f4d4aa](https://github.com/daeuniverse/daed/commit/3f4d4aa69ec76565f0199de73e3d794f46d86aa0))
- drop simple mode for now as its feature set is not quite there yet ([c680538](https://github.com/daeuniverse/daed/commit/c68053873ce1db9e2e5539e19dfa87e2fe0cf081))
- footer is floating above modal overlay ([#121](https://github.com/daeuniverse/daed/issues/121)) ([de14b6c](https://github.com/daeuniverse/daed/commit/de14b6cb6d10248c143b01a6a22e8125771fbdff))
- group name is required ([252347a](https://github.com/daeuniverse/daed/commit/252347a7a877433d6f191c0f9174a2d79659a6bd))
- **group:** drop policyParams for now ([2ac339c](https://github.com/daeuniverse/daed/commit/2ac339ca5f66f269a18e1a697171db7e86eb9af4))
- **group:** refine node and subscription list ([476e44b](https://github.com/daeuniverse/daed/commit/476e44b77b8359cf7ba415b176e288a3dc75979c))
- **group:** refresh after remove nodes/subs ([#96](https://github.com/daeuniverse/daed/issues/96)) ([a344329](https://github.com/daeuniverse/daed/commit/a344329238fd24d4edc0ccc05aa93578e131d5d8))
- **header:** close account settings form modal after submit ([1c6a17d](https://github.com/daeuniverse/daed/commit/1c6a17d20b30634ba16c2cb9db1069b9ac141b91))
- **hy2:** insecure parameter not work ([#493](https://github.com/daeuniverse/daed/issues/493)) ([0849a1e](https://github.com/daeuniverse/daed/commit/0849a1e122247c1a7d5019e219b4d97635ae91af))
- i18n type definitions ([0abfbf3](https://github.com/daeuniverse/daed/commit/0abfbf360fcca295b9f0e589e9f654cd2223491e))
- **i18n:** identifier mismatch & awkward English translations ([#509](https://github.com/daeuniverse/daed/issues/509)) ([1750dbe](https://github.com/daeuniverse/daed/commit/1750dbeccbff7ce7ea0399ef509031e189d2e172))
- import resource form modal ([a7f1d40](https://github.com/daeuniverse/daed/commit/a7f1d40f5d8f6212c953a46db75f2cf8c4b824b8))
- **import:** cannot import node ([#507](https://github.com/daeuniverse/daed/issues/507)) ([e485b80](https://github.com/daeuniverse/daed/commit/e485b8015b8fd767785ba6159871066c8ec5c7ae))
- init process stuck in a loop ([5f116da](https://github.com/daeuniverse/daed/commit/5f116da7c958e606e2aa06a0c8c28e54e5e2335b))
- initialization logic ([fb22f05](https://github.com/daeuniverse/daed/commit/fb22f05d37fcae47570e0fbcfb1c6cc8595ece7c))
- limit query failed toasts ([fbb64cc](https://github.com/daeuniverse/daed/commit/fbb64cca53eaf269ff159d0a38ab69df01271920))
- limit the tproxy port input range ([fa49d1d](https://github.com/daeuniverse/daed/commit/fa49d1de3ac93ec6c82f41ac08e8e4951bc7a3af))
- log user out when `access denied` occurs, fixes [#11](https://github.com/daeuniverse/daed/issues/11) ([b57ad87](https://github.com/daeuniverse/daed/commit/b57ad872ff45886236193156c8e5f5ea8976454e))
- parse duration correctly to avoid time unit response inconsistency with request ([b04d820](https://github.com/daeuniverse/daed/commit/b04d820c52310a1cb43342bbe71ad3919d36df7a))
- reload icon not showing on small size screens ([#187](https://github.com/daeuniverse/daed/issues/187)) ([7e8fc69](https://github.com/daeuniverse/daed/commit/7e8fc69e4ff3a7c895483b9d41a5390b44d89695))
- remove create config modal tabs ([4dbb755](https://github.com/daeuniverse/daed/commit/4dbb7550ba4e9d46f4ce225809b6a6ecdf470ed6))
- remove extra dns and routing spaces ([284ca83](https://github.com/daeuniverse/daed/commit/284ca832c5df14a47f88ad4f8e340e78fbd5dc1b))
- rename modal not closing after changing rule names ([#188](https://github.com/daeuniverse/daed/issues/188)) ([bfc7d3a](https://github.com/daeuniverse/daed/commit/bfc7d3a773857fa88ba13e56db68d62e85682180))
- set `DEFAULT_ENDPOINT_URL` `protocol` part the same as current url ([c76f32c](https://github.com/daeuniverse/daed/commit/c76f32cd0f043db566c819492279817196b4ca09))
- set DEFAULT_TPROXY_PORT to 12345, sync with doc ([bd972ac](https://github.com/daeuniverse/daed/commit/bd972acc25ccdc96c57999f85a6c65ebcdcadc6a))
- set notification color to red if error ([4265b59](https://github.com/daeuniverse/daed/commit/4265b59624857d52272c4cd0841c85d39a8e156f))
- **setup:** exact one admin account can be registered ([dced31f](https://github.com/daeuniverse/daed/commit/dced31fe04ba5a90821035b975ab3eb9e859b1b6))
- sortable grid layout issue ([6c4ff5c](https://github.com/daeuniverse/daed/commit/6c4ff5c24becdcf400d5498575dd7e52f472a32c))
- sortable grid sortable keys not resizing with unsorted items ([4e0b4f5](https://github.com/daeuniverse/daed/commit/4e0b4f51abcc05dbb3870af85102389ed066de99))
- sortable group ([a4d37de](https://github.com/daeuniverse/daed/commit/a4d37de1fc7c82da6218c38c5de4ff26c1e57baf))
- store imported by SortableGrid not found ([0e406d8](https://github.com/daeuniverse/daed/commit/0e406d8cc85f4367c5d4b86ee1d984806f8f652f))
- subscription drag overlay content ([31890ce](https://github.com/daeuniverse/daed/commit/31890cee04f92a8f4f1c159dac1caf8820dd788f))
- subscription drawer title ([04c5e3f](https://github.com/daeuniverse/daed/commit/04c5e3fd0ea2d673eb61ca587b802c7a5c2d6e9a))
- subscription nodes cursor should be grab ([f619c8c](https://github.com/daeuniverse/daed/commit/f619c8c700a7e34a5b3f7d23975dcef9d01169fb))
- **subscription:** importing subscription should allow partial success ([cb76e39](https://github.com/daeuniverse/daed/commit/cb76e3900da4736c32ee9d2439a3e063a80426b7))
- **subscription:** loading indicator of update should show on individual subscription ([c1533fb](https://github.com/daeuniverse/daed/commit/c1533fb224d5cf5733ad19a36050e7f596cc01d1))
- systemd service file description and service start command ([4b44321](https://github.com/daeuniverse/daed/commit/4b4432157f97e13c2c91fd73617cddae67deb0af))
- time parsing is wrong ([#171](https://github.com/daeuniverse/daed/issues/171)) ([ef08c0f](https://github.com/daeuniverse/daed/commit/ef08c0fc7d4ad2bd59f7bd9e8f068e20c1ada1e7))
- tproxyPort may be string type ([d12be19](https://github.com/daeuniverse/daed/commit/d12be1947da6f1bef7e8ca21b73a55c0b9207afd))
- try fixing caret misplacement ([#124](https://github.com/daeuniverse/daed/issues/124)) ([3ea42fa](https://github.com/daeuniverse/daed/commit/3ea42faa68e7fc04bbf50e80a5e7308d0c42b5fb))
- update form components to handle default values and error handling ([a71d4ce](https://github.com/daeuniverse/daed/commit/a71d4ced3073540cd75b0c1b43661d9a06ef09d7))
- update lint-staged configuration and improve component layout ([365fd2d](https://github.com/daeuniverse/daed/commit/365fd2dd68efbfc596037f09e8d0a430ced86ecd))
- update loading states in subscription actions and group form modal ([a71d4ce](https://github.com/daeuniverse/daed/commit/a71d4ced3073540cd75b0c1b43661d9a06ef09d7))
- update MainLayout for better container alignment ([8d34081](https://github.com/daeuniverse/daed/commit/8d3408164d7e66c3315d097e8808d3146c64273e))
- update publish-gh-pages job to trigger only on new releases ([a72d8e7](https://github.com/daeuniverse/daed/commit/a72d8e750e3c1cbf08607acb5f33c85a926a45f3))
- **v2ray:** add missing websocket path field ([#159](https://github.com/daeuniverse/daed/issues/159)) ([4932127](https://github.com/daeuniverse/daed/commit/49321273c51b1502f593c738e99bf6ac5a25f08a))
- **v2ray:** vmess websocket path emty ([#521](https://github.com/daeuniverse/daed/issues/521)) ([c4536d3](https://github.com/daeuniverse/daed/commit/c4536d38288a2816fdaccb56972dcd8e382d2275))
- val in key-val pair input fallback to null ([4095449](https://github.com/daeuniverse/daed/commit/4095449b9200bbabf0eeee23cdea33346517fa21))
- wan interface should be optional ([#156](https://github.com/daeuniverse/daed/issues/156)) ([f47abfa](https://github.com/daeuniverse/daed/commit/f47abfacc0c3f43c3b76eab5c92ddd87993bca82))

## [0.7.0](https://github.com/daeuniverse/daed/compare/v0.6.0...v0.7.0) (2025-11-29)

### Features

- **account settings:** update name ([f1897a4](https://github.com/daeuniverse/daed/commit/f1897a44c77a6309b3f0bbf6553688c42e7a56ea))
- add a basic simple mode homepage ([4460195](https://github.com/daeuniverse/daed/commit/44601957d2edb86c61f50b85714864cc60637b9d))
- add a configure node modal ([#125](https://github.com/daeuniverse/daed/issues/125)) ([fa55f7c](https://github.com/daeuniverse/daed/commit/fa55f7c8ab82aa87d67624f507293373f332dc34))
- add a modal to show node qrcode ([#99](https://github.com/daeuniverse/daed/issues/99)) ([3a3e965](https://github.com/daeuniverse/daed/commit/3a3e96521e1e65e856cbc98e3663e639105f1d38))
- add configure hysteria2 modal ([#440](https://github.com/daeuniverse/daed/issues/440)) ([ef2b4c5](https://github.com/daeuniverse/daed/commit/ef2b4c50b4fdcb5232711950d0a4c5636cc01354))
- add configure juicity modal ([#191](https://github.com/daeuniverse/daed/issues/191)) ([3f08f55](https://github.com/daeuniverse/daed/commit/3f08f55e881fea4aca65c83270216531889719c7))
- add configure tuic modal ([#157](https://github.com/daeuniverse/daed/issues/157)) ([a564445](https://github.com/daeuniverse/daed/commit/a564445456089656518b75919f2ae6d222aa994b))
- add create config `name` field ([f8fec36](https://github.com/daeuniverse/daed/commit/f8fec36b6ba9e27dae81fc0baf6bd3336177ba48))
- add description text for group policies ([d837090](https://github.com/daeuniverse/daed/commit/d837090139c3dd177e8f0649c6a3ff17a59d7c9d))
- add desktop file and icons ([#221](https://github.com/daeuniverse/daed/issues/221)) ([b05d5db](https://github.com/daeuniverse/daed/commit/b05d5db7ce68ef5f228a565d078dacaddd6cb919))
- add font source-code-pro ([a8c8ba8](https://github.com/daeuniverse/daed/commit/a8c8ba82d1fb2b8a13967fed39be81ddfb120094))
- add group and routing page ([772e240](https://github.com/daeuniverse/daed/commit/772e240812e51ecd67ca6f638449157441845dc9))
- add header icon link to github project, and a footer ([#108](https://github.com/daeuniverse/daed/issues/108)) ([dc1521c](https://github.com/daeuniverse/daed/commit/dc1521ce660e4e690544e27676c7282f2e8cd0c4))
- add icon before titles ([5b4f930](https://github.com/daeuniverse/daed/commit/5b4f930d7aad45edcf06df2922c4eaee8777fc4d))
- add juicity pinned_certchain_sha256 config ([#219](https://github.com/daeuniverse/daed/issues/219)) ([42cc5ee](https://github.com/daeuniverse/daed/commit/42cc5ee4f5eb2dd6829c7f7067485aab13b35672))
- add loading state indicators ([5de2006](https://github.com/daeuniverse/daed/commit/5de200622fb4f3e04d3ca65c7648db865616fe8f))
- add missing default resources if any ([0739d1f](https://github.com/daeuniverse/daed/commit/0739d1f4eed35bf1c98f0c489259259383a38753))
- add new UI components; enhance existing components and styles ([8d34081](https://github.com/daeuniverse/daed/commit/8d3408164d7e66c3315d097e8808d3146c64273e))
- add nodes to default group under simple mode ([407d79e](https://github.com/daeuniverse/daed/commit/407d79e598606992c77c843a0b23a380e1cb3a86))
- add pnpm workspace configuration and monaco editor integration ([a71d4ce](https://github.com/daeuniverse/daed/commit/a71d4ced3073540cd75b0c1b43661d9a06ef09d7))
- add SortableGrid ([002adcc](https://github.com/daeuniverse/daed/commit/002adcc68b1796b5f2b04711821fd4a776cbe167))
- add table component ([c32ad1b](https://github.com/daeuniverse/daed/commit/c32ad1b7baa3322138f8310c4801f967c67891a3))
- add toggle running switch ([91476d9](https://github.com/daeuniverse/daed/commit/91476d902d2d5e8adc4e82bffd7e6820fe29d541))
- add tooltip for header actions ([#97](https://github.com/daeuniverse/daed/issues/97)) ([d5bad2a](https://github.com/daeuniverse/daed/commit/d5bad2ae4f1316b1766331faf077688c07572c10))
- authentication ([11c322e](https://github.com/daeuniverse/daed/commit/11c322e80ef90d34d2f163b42f58e32a00e7f7b4))
- backend initialization ([ab4df8e](https://github.com/daeuniverse/daed/commit/ab4df8ece81aca9bfbc56e41d90d5ccc43037732))
- change editor font to `Source Code Pro` ([#218](https://github.com/daeuniverse/daed/issues/218)) ([2c5518e](https://github.com/daeuniverse/daed/commit/2c5518e0e9896adc11576aba00759b42bf1907d6))
- change icons ([#147](https://github.com/daeuniverse/daed/issues/147)) ([9c297b3](https://github.com/daeuniverse/daed/commit/9c297b3fe1ec90890f3227646732f9a60fe35f77))
- change the presentation form of certain details to `Drawer`s ([1026f92](https://github.com/daeuniverse/daed/commit/1026f9265a1753d6dc355c87c1f203eacfa1f62e))
- change toggle running button color when state change ([47a0e55](https://github.com/daeuniverse/daed/commit/47a0e555b62b66fc5799945ea1b9d0cb083e8145))
- **config:** add descriptive help texts for user inputs ([6f9bf53](https://github.com/daeuniverse/daed/commit/6f9bf53cc3131ba22e86256cc9efb201df7b1c05))
- **config:** add fallbackResolver form field ([#530](https://github.com/daeuniverse/daed/issues/530)) ([d9d4515](https://github.com/daeuniverse/daed/commit/d9d4515b605878836e1cefddd177261a3ac57caf))
- **config:** add form field ([#498](https://github.com/daeuniverse/daed/issues/498)) ([068e5a7](https://github.com/daeuniverse/daed/commit/068e5a77c1cf42a5a575215437c84beddcee30ce))
- **config:** add form field `soMarkFromDae` ([#251](https://github.com/daeuniverse/daed/issues/251)) ([736ae96](https://github.com/daeuniverse/daed/commit/736ae96521cda7337241af20ccf0feff3568a207))
- **config:** add more config related fields ([df3ed8b](https://github.com/daeuniverse/daed/commit/df3ed8bbfbad72ea63064253b78ecf8ee79de99d))
- **config:** remove tls related fields for now ([6d14e9d](https://github.com/daeuniverse/daed/commit/6d14e9d7482d803cbf501ca30dfc0a71ef56626c))
- **config:** select config ([c79ea88](https://github.com/daeuniverse/daed/commit/c79ea88b1e4f3399aee792efd93cc05554f25f9b))
- **config:** select multiple interfaces ([08afa97](https://github.com/daeuniverse/daed/commit/08afa97cec9a68504cce7450f7853479599660e8))
- **config:** show interface ip addresses in interface select ([8279137](https://github.com/daeuniverse/daed/commit/82791378ec298c22d11d979affbf557cc77be842))
- **config:** use accordion to collapse/expand sections ([c7c9cca](https://github.com/daeuniverse/daed/commit/c7c9ccac5de026f99314a9202ad97971ffc6870c))
- create dns ([563a011](https://github.com/daeuniverse/daed/commit/563a011298fa0aabd3068b74a1e09a3f2ebaa4da))
- create group form add policyParams support ([fa43a16](https://github.com/daeuniverse/daed/commit/fa43a160956d9e4e8c9e4de6f4403540dfc912da))
- create group form modal ([68657ff](https://github.com/daeuniverse/daed/commit/68657fff96a485cce8f372515c7dc13b16a1ae3b))
- create new config within modal ([35516c1](https://github.com/daeuniverse/daed/commit/35516c1f5769f349317e466fd137abce04050af7))
- create routing ([08a189c](https://github.com/daeuniverse/daed/commit/08a189c28c9d005b4a89b1e44b04e093f7347c6e))
- disable rollbackError, fixes [#207](https://github.com/daeuniverse/daed/issues/207) ([#208](https://github.com/daeuniverse/daed/issues/208)) ([29dbbcc](https://github.com/daeuniverse/daed/commit/29dbbccbc7b0104afc1c04b44d0f73f15272d87c))
- disable zooming and panning on mobile ([#113](https://github.com/daeuniverse/daed/issues/113)) ([5a9a095](https://github.com/daeuniverse/daed/commit/5a9a095f5621f94bde7552a61dfb2598a9070787))
- display daed version in header ([#132](https://github.com/daeuniverse/daed/issues/132)) ([6f9b1b8](https://github.com/daeuniverse/daed/commit/6f9b1b834ea02b4a97159faf73a356be348f748a))
- display details with modal ([932da0a](https://github.com/daeuniverse/daed/commit/932da0a15efa70eba63139eaaff7dd9ca0e367fa))
- drag nodes and subscriptions between groups ([505a2b3](https://github.com/daeuniverse/daed/commit/505a2b32afc04e612b617da71c30efcaf16c7c3d))
- draggable config ([25b9f02](https://github.com/daeuniverse/daed/commit/25b9f02af68707fc6d5c9a843219a77fbc39586e))
- **editor:** add routingA code highlight ([#105](https://github.com/daeuniverse/daed/issues/105)) ([2fbbc7a](https://github.com/daeuniverse/daed/commit/2fbbc7af6c598a3df22609c0ee1712dedbe410a1))
- **editor:** render tags ([#106](https://github.com/daeuniverse/daed/issues/106)) ([229c2c6](https://github.com/daeuniverse/daed/commit/229c2c69aa638af2b6b68591046cf473ca8180be))
- encrypt secret data ([0054597](https://github.com/daeuniverse/daed/commit/0054597c7e4b4f31134727bb33fd5518c51c83d3))
- encryptable Displayable component ([5b92c40](https://github.com/daeuniverse/daed/commit/5b92c4045fce2dc3ea793a9ecef92f1cf43a19ac))
- enhance component functionality and improve code structure ([afdafbd](https://github.com/daeuniverse/daed/commit/afdafbd11f7e99f4c8207c813fef3aa9d8fba32c))
- **experiment:** add node to groups by dnd ([6dcbb7d](https://github.com/daeuniverse/daed/commit/6dcbb7d1596f1d8549a62b6ca4202c0d329de111))
- **experiment:** change to column display ([a548b3d](https://github.com/daeuniverse/daed/commit/a548b3de965b67913a55c7252ae8e2cbf76a5b34))
- **experiment:** dns, routing ([3e63a3b](https://github.com/daeuniverse/daed/commit/3e63a3b8fc78d9c04ef5bc0737f0df4be940fc3d))
- extract a new orchestrate page from experiment ([f53b1e2](https://github.com/daeuniverse/daed/commit/f53b1e2c8a4745a87bc1a86ae21fd08999df4342))
- fancy switch toggle ([107dcbc](https://github.com/daeuniverse/daed/commit/107dcbc3a1fa2d2042f67a57e562c38b2f72f10b))
- global toast ([4b0a8e9](https://github.com/daeuniverse/daed/commit/4b0a8e910b80145f7d3afbf76ea7fdf8ce5108f8))
- **group:** add fixed policy selection ([#467](https://github.com/daeuniverse/daed/issues/467)) ([2c6593b](https://github.com/daeuniverse/daed/commit/2c6593b5426c51a8605905f5bc783d094c7d7826))
- **group:** hide nodes and subscriptions if empty ([3cb9d01](https://github.com/daeuniverse/daed/commit/3cb9d01a8a8e0deaf1edadac15ee5bda93dadc60))
- **group:** show subscription tag on node hover ([1d19f52](https://github.com/daeuniverse/daed/commit/1d19f52e851d899d4a722f18806d709bd1f7020c))
- growable input list ([ff61920](https://github.com/daeuniverse/daed/commit/ff6192083d3cd97f3d694f4a2d89c060ab4bd01f))
- **header:** add account settings ([4d28491](https://github.com/daeuniverse/daed/commit/4d28491605d03e4213958d41c711d7919a342de9))
- hide group node and subscription count indicators if list is empty ([003e366](https://github.com/daeuniverse/daed/commit/003e3660c3f2b27b83e0252a2c61b94cabf6e8ca))
- highlight droppable section ([e62cbdf](https://github.com/daeuniverse/daed/commit/e62cbdf6999c6bf8b91c47100bdf2ce2c5544f4d))
- import node list from growable input list ([5ae200e](https://github.com/daeuniverse/daed/commit/5ae200e4affc3c95f56beefe9fdadabfbfcaf7cd))
- import nodes ([03e240e](https://github.com/daeuniverse/daed/commit/03e240e2642560736427a3c8b52da109ad9e0e96))
- import subscription ([6e46730](https://github.com/daeuniverse/daed/commit/6e467301be3f46b7859a0d9d61c5be7ad1580cd5))
- initial setup ([786a4df](https://github.com/daeuniverse/daed/commit/786a4dfc001914ca62dfa226b77eea35421a44a6))
- make plaintext modal fullscreen ([#109](https://github.com/daeuniverse/daed/issues/109)) ([0bf6eb1](https://github.com/daeuniverse/daed/commit/0bf6eb16d31324d5b085bd47bcd74a3d46d43f49))
- make rules card clickable area larger ([e9b39ac](https://github.com/daeuniverse/daed/commit/e9b39acbaaca7e6b1fdabd67f9e706a63b6ed03b))
- migrate to material-ui ([5e5e729](https://github.com/daeuniverse/daed/commit/5e5e729e9e2bfbc6920de4bf21c336e4a41edcf1))
- migrate to release-please for automated releases ([#546](https://github.com/daeuniverse/daed/issues/546)) ([5e99a94](https://github.com/daeuniverse/daed/commit/5e99a94c49bf3b31a9a92e5571eb1a69671e355a))
- minor adjustments ([ad22162](https://github.com/daeuniverse/daed/commit/ad221625d806a5fdd1ecdb9a47a83b014251e8c8))
- modal reworks ([#149](https://github.com/daeuniverse/daed/issues/149)) ([0fa1572](https://github.com/daeuniverse/daed/commit/0fa1572a673ef634609f9949ab0b651c7389c275))
- multiple setup page, fixes [#9](https://github.com/daeuniverse/daed/issues/9) ([b482b0b](https://github.com/daeuniverse/daed/commit/b482b0b6ca171ad82ea020766b0e1e6a8230c3dd))
- **node:** refactor EditNodeFormModal to use Dialog component and improve form handling ([1ad92dc](https://github.com/daeuniverse/daed/commit/1ad92dc7b60541b4557ca03b78f704e95dc1b490))
- **node:** support edit node ([#540](https://github.com/daeuniverse/daed/issues/540)) ([c4c8657](https://github.com/daeuniverse/daed/commit/c4c86572771ad6dc1bc7fba2ff948fddba2b3872))
- only render NodeList inside Home when mode is simple ([8bfc534](https://github.com/daeuniverse/daed/commit/8bfc534c07b4f6566d045d42b7ed161b7e33cd71))
- only use BrowserRouter if under development mode ([cecbf6e](https://github.com/daeuniverse/daed/commit/cecbf6ed8b3362c7135ec52658171d28797ec402))
- **password:** support change password ([#538](https://github.com/daeuniverse/daed/issues/538)) ([aeaa6ac](https://github.com/daeuniverse/daed/commit/aeaa6ac1bad8786a6b53974219301d6429c9d2ea))
- prevent user from deleting default rules ([8cae50d](https://github.com/daeuniverse/daed/commit/8cae50d0346154e9e29b6825e3986b8ef6b57aff))
- query loading indicator ([130bfca](https://github.com/daeuniverse/daed/commit/130bfcadc2059b7f4a92f2138eacf0aabdae2fac))
- reduce hover card area to icon ([0496f33](https://github.com/daeuniverse/daed/commit/0496f331a8b4b32c86e38ba92859e5d6cf38a3e9))
- refine config page ([2c8fdb7](https://github.com/daeuniverse/daed/commit/2c8fdb7238aecfad62a8cb7b689221111fd29faa))
- refine node page ([57cd1df](https://github.com/daeuniverse/daed/commit/57cd1dfcc3bc16d7b0bc9c1dc37ffe5b6ffff49c))
- rename default config (global) and group (proxy) ([99a268f](https://github.com/daeuniverse/daed/commit/99a268fc12517f3cb0e8e84d663018cf26d344b6))
- rename rules ([81782b5](https://github.com/daeuniverse/daed/commit/81782b5c49e088bd9e8997007c01ad5514c8dad5))
- render data using SimpleDisplay ([73106cc](https://github.com/daeuniverse/daed/commit/73106cc469aed8cd22d05e8894fa40f6d9bfcbf0))
- render key-value pairs as List for now ([d9d1ad5](https://github.com/daeuniverse/daed/commit/d9d1ad5575317ab139a89117e08e6832068f9b80))
- render qrcode in canvas to allow user to save image ([#100](https://github.com/daeuniverse/daed/issues/100)) ([0ec1d61](https://github.com/daeuniverse/daed/commit/0ec1d615d6c29836115332b14dbdcf6db30bab8d))
- replace sidebar with header ([243f712](https://github.com/daeuniverse/daed/commit/243f712b67bb35a7bd4be23a0a8a0bdd1ee6a509))
- responsive header ([#111](https://github.com/daeuniverse/daed/issues/111)) ([274e596](https://github.com/daeuniverse/daed/commit/274e5966689b04edddc1c3b1a499091ce91c463f))
- restrict drag and drop area ([2d16909](https://github.com/daeuniverse/daed/commit/2d169098631901f0c3160802d4ebc0153d5d722c))
- **rfc:** show reload when specific mutations happen ([74bde73](https://github.com/daeuniverse/daed/commit/74bde73c35cb909471ad8c760cc86828cd12644d))
- **rfc:** show reload when specific mutations happen ([21b487d](https://github.com/daeuniverse/daed/commit/21b487de396afe7f9a8385224a4f4d7d0a9119a4))
- **Router:** add gh-pages support ([1d7143f](https://github.com/daeuniverse/daed/commit/1d7143fffcf5125e7cd4c81f74e76efbf563c8a5))
- **routing:** add dnsmasq to must_direct default routing ([#258](https://github.com/daeuniverse/daed/issues/258)) ([4823f5b](https://github.com/daeuniverse/daed/commit/4823f5b99693b937670f69e6fe5a1ab6479c0587))
- rule editing ([faf7a06](https://github.com/daeuniverse/daed/commit/faf7a06c4e05cd5ec124cd0c007f0fac3d448afe))
- **rules:** hide remove button if selected ([e1a41a1](https://github.com/daeuniverse/daed/commit/e1a41a1ded940e927eaec6f9ea1bbd91c3a8bb62))
- save sorted grid orders ([8d14950](https://github.com/daeuniverse/daed/commit/8d14950ad5a46d9e7e6bd3cb920fe461d4403ab8))
- select routing and dns ([f5ded1b](https://github.com/daeuniverse/daed/commit/f5ded1be2acc92783c9707329161b6dd020d880c))
- set `DEFAULT_AUTO_CONFIG_KERNEL_PARAMETER` to true ([fd07017](https://github.com/daeuniverse/daed/commit/fd070175be13d9b7a142d7d5adad462ee20cb068))
- set color scheme based on system preference ([#205](https://github.com/daeuniverse/daed/issues/205)) ([cc88300](https://github.com/daeuniverse/daed/commit/cc88300159dfd499421e09ab37ce45ebe89ecde0))
- set cursor type of input as pointer ([e9ad4a5](https://github.com/daeuniverse/daed/commit/e9ad4a51d9e8f2164e6333721b4a17474a8a7192))
- set default endpoint url as current `location.hostname` ([9fc3457](https://github.com/daeuniverse/daed/commit/9fc345785d7168d2687727d6a0589a45903a7d9b))
- show data item count ([a5a1e9a](https://github.com/daeuniverse/daed/commit/a5a1e9a83eeb608cdc97352c4168be6de0d6c62f))
- show node protocol in card title ([#98](https://github.com/daeuniverse/daed/issues/98)) ([9cb2aea](https://github.com/daeuniverse/daed/commit/9cb2aea4a284d388d17eb2260e2bc1f168a0177e))
- show raw routing and dns string ([08e475c](https://github.com/daeuniverse/daed/commit/08e475c23fd8faef4b1e571807583989e840e8d7))
- simple mode ([cea0ce8](https://github.com/daeuniverse/daed/commit/cea0ce837a9bf0a92330e3013d152f03df5b1cf8))
- sortable subscriptions ([05ff35d](https://github.com/daeuniverse/daed/commit/05ff35dcf8ac231345d8b7e35746bdbbd98be717))
- **subscription:** collapsible node list ([8d5b68c](https://github.com/daeuniverse/daed/commit/8d5b68c9daaaa28b15822b04254d0c4374ea3e1a))
- **subscription:** support edit subscription ([#539](https://github.com/daeuniverse/daed/issues/539)) ([5b14f2a](https://github.com/daeuniverse/daed/commit/5b14f2a9386403d302e53af0ce43a678fc315234))
- **subscription:** support for updating subscriptions in batch ([972b9bb](https://github.com/daeuniverse/daed/commit/972b9bb08b7638a2c71db0e1f9cf7503f983d190))
- support small screen devices ([#110](https://github.com/daeuniverse/daed/issues/110)) ([76f0e2f](https://github.com/daeuniverse/daed/commit/76f0e2f56b0162cd53d4e9308d0107b6820044e1))
- **tuic:** upgrade dae-wing to support tuic v5 ([#135](https://github.com/daeuniverse/daed/issues/135)) ([2ea0dcb](https://github.com/daeuniverse/daed/commit/2ea0dcb452a0b6cbe66db72f4b52ba80db32caf1))
- update home page ([5130953](https://github.com/daeuniverse/daed/commit/51309531237366b35adb4ef1fde1ba801fc0412f))
- update subscription ([cb065d3](https://github.com/daeuniverse/daed/commit/cb065d39ef62dee755faad25b6458b78bbb361db))
- upgrade dae-wing ([b6171f2](https://github.com/daeuniverse/daed/commit/b6171f20c9ac284b66f7695c2652520f6381ae2d))
- use @chakra-ui/icons ([4e11cbd](https://github.com/daeuniverse/daed/commit/4e11cbd9fc33a3092b6b0beaf9f5442530a7e3ff))
- use monaco editor for dns and routing ([#101](https://github.com/daeuniverse/daed/issues/101)) ([d4054e4](https://github.com/daeuniverse/daed/commit/d4054e42d81f154a3b1dcdf10ff71d1e6a014f1a))
- use source code pro font for dns/routing input ([b93ff0e](https://github.com/daeuniverse/daed/commit/b93ff0ec87589c51d539cda81191ba98d4ec1cf7))
- use theme `github` as default monaco editor light theme ([#102](https://github.com/daeuniverse/daed/issues/102)) ([47b49f6](https://github.com/daeuniverse/daed/commit/47b49f64e423fbd15a2a67206990993375397046))
- user setup ([6939891](https://github.com/daeuniverse/daed/commit/69398914353e2ca50f5d5b709f1fce0a3949a413))
- wan interface auto detect ([#133](https://github.com/daeuniverse/daed/issues/133)) ([4b4b099](https://github.com/daeuniverse/daed/commit/4b4b0996ce42fb28f81662cdc316ed8d854a82e4))
- wrap icon with Icon component ([de97cf3](https://github.com/daeuniverse/daed/commit/de97cf3e74c8505f36ac015adfdfe8e3b4c20722))

### Bug Fixes

- a bunch of issues ([a22addd](https://github.com/daeuniverse/daed/commit/a22addd1da85542bfe870698134935d36fc3a4e8))
- add DEFAULT_UDP_CHECK_DNS ipv6 address missing colon ([c354148](https://github.com/daeuniverse/daed/commit/c354148f1ad6aa25516c4ba5bf4921b570664d03))
- apply minior fix ([2e2c0b4](https://github.com/daeuniverse/daed/commit/2e2c0b430aebb5af9712cc7ad10bcaffe182febb))
- avoid to install husky when not in a git repo ([#185](https://github.com/daeuniverse/daed/issues/185)) ([71d9314](https://github.com/daeuniverse/daed/commit/71d93149fbc1b44a8bfa088e4df6af1fa51fbb99))
- **build-nightly:** fix broken logic ([dd6f37f](https://github.com/daeuniverse/daed/commit/dd6f37f22183073c8c8404cb25de64d85f8f93b6))
- cannot stop running ([32c2a27](https://github.com/daeuniverse/daed/commit/32c2a2701a18af2036769d093efad3365fd76053))
- card list data reorder ([9c64f4c](https://github.com/daeuniverse/daed/commit/9c64f4c0787091f0093d3e2045016e4bbca89230))
- codegen ([a0231f5](https://github.com/daeuniverse/daed/commit/a0231f5ec546434e8c87aee02edde536e7432852))
- config form may lack behind from the user inputs ([e773243](https://github.com/daeuniverse/daed/commit/e7732436b212ca9277942f818256b01e5c1e0fed))
- **config:** add missing form modal fields, fix lan interface, autoConfigKernelParameter ([1007125](https://github.com/daeuniverse/daed/commit/10071250f351638880a99e9ac36bd43a81c7f8b7))
- **config:** change `DEFAULT_TCP_CHECK_HTTP_METHOD` from `CONNECT` to `HEAD` ([76bff35](https://github.com/daeuniverse/daed/commit/76bff35afcd0b88bce99939e8cef1791fe30db0b))
- **config:** disable allow insecure by default ([c0e7079](https://github.com/daeuniverse/daed/commit/c0e7079222340d218fcff6ec70c86cca78160d62))
- **config:** properly set wan interfaces ([6580baf](https://github.com/daeuniverse/daed/commit/6580baf88d62e7d2bd97c82e2674e58cde6c8b95))
- **config:** refine default values to align with the doc ([c18e038](https://github.com/daeuniverse/daed/commit/c18e038701725d9519d5a005caf324d19abef46b))
- copy to clipboard not working when clipboard permissions not permitted ([#217](https://github.com/daeuniverse/daed/issues/217)) ([ead5445](https://github.com/daeuniverse/daed/commit/ead54453d796f87aa758bd3d38b84e803f55cc28))
- correct version format in package.json and update release type in release-please-config.json ([a9d01d6](https://github.com/daeuniverse/daed/commit/a9d01d6f7f0888443db13bd26d5f1b6f50481357))
- default googledns add tcp ([9b6e8a4](https://github.com/daeuniverse/daed/commit/9b6e8a4effb1f2c5ca33b6ad29342b79b2cf4a08))
- dialMode should be using const value ([7bdc4e0](https://github.com/daeuniverse/daed/commit/7bdc4e08f11141e0ba92e67720d114cc1cf1a954))
- disable spellCheck for DNS and Routing textarea input ([9324091](https://github.com/daeuniverse/daed/commit/93240910ff52e8f4e35f14c37b8668afc25eaa95))
- dragging not working properly ([#91](https://github.com/daeuniverse/daed/issues/91)) ([3f4d4aa](https://github.com/daeuniverse/daed/commit/3f4d4aa69ec76565f0199de73e3d794f46d86aa0))
- drop simple mode for now as its feature set is not quite there yet ([c680538](https://github.com/daeuniverse/daed/commit/c68053873ce1db9e2e5539e19dfa87e2fe0cf081))
- footer is floating above modal overlay ([#121](https://github.com/daeuniverse/daed/issues/121)) ([de14b6c](https://github.com/daeuniverse/daed/commit/de14b6cb6d10248c143b01a6a22e8125771fbdff))
- group name is required ([252347a](https://github.com/daeuniverse/daed/commit/252347a7a877433d6f191c0f9174a2d79659a6bd))
- **group:** drop policyParams for now ([2ac339c](https://github.com/daeuniverse/daed/commit/2ac339ca5f66f269a18e1a697171db7e86eb9af4))
- **group:** refine node and subscription list ([476e44b](https://github.com/daeuniverse/daed/commit/476e44b77b8359cf7ba415b176e288a3dc75979c))
- **group:** refresh after remove nodes/subs ([#96](https://github.com/daeuniverse/daed/issues/96)) ([a344329](https://github.com/daeuniverse/daed/commit/a344329238fd24d4edc0ccc05aa93578e131d5d8))
- **header:** close account settings form modal after submit ([1c6a17d](https://github.com/daeuniverse/daed/commit/1c6a17d20b30634ba16c2cb9db1069b9ac141b91))
- **hy2:** insecure parameter not work ([#493](https://github.com/daeuniverse/daed/issues/493)) ([0849a1e](https://github.com/daeuniverse/daed/commit/0849a1e122247c1a7d5019e219b4d97635ae91af))
- i18n type definitions ([0abfbf3](https://github.com/daeuniverse/daed/commit/0abfbf360fcca295b9f0e589e9f654cd2223491e))
- **i18n:** identifier mismatch & awkward English translations ([#509](https://github.com/daeuniverse/daed/issues/509)) ([1750dbe](https://github.com/daeuniverse/daed/commit/1750dbeccbff7ce7ea0399ef509031e189d2e172))
- import resource form modal ([a7f1d40](https://github.com/daeuniverse/daed/commit/a7f1d40f5d8f6212c953a46db75f2cf8c4b824b8))
- **import:** cannot import node ([#507](https://github.com/daeuniverse/daed/issues/507)) ([e485b80](https://github.com/daeuniverse/daed/commit/e485b8015b8fd767785ba6159871066c8ec5c7ae))
- init process stuck in a loop ([5f116da](https://github.com/daeuniverse/daed/commit/5f116da7c958e606e2aa06a0c8c28e54e5e2335b))
- initialization logic ([fb22f05](https://github.com/daeuniverse/daed/commit/fb22f05d37fcae47570e0fbcfb1c6cc8595ece7c))
- limit query failed toasts ([fbb64cc](https://github.com/daeuniverse/daed/commit/fbb64cca53eaf269ff159d0a38ab69df01271920))
- limit the tproxy port input range ([fa49d1d](https://github.com/daeuniverse/daed/commit/fa49d1de3ac93ec6c82f41ac08e8e4951bc7a3af))
- log user out when `access denied` occurs, fixes [#11](https://github.com/daeuniverse/daed/issues/11) ([b57ad87](https://github.com/daeuniverse/daed/commit/b57ad872ff45886236193156c8e5f5ea8976454e))
- parse duration correctly to avoid time unit response inconsistency with request ([b04d820](https://github.com/daeuniverse/daed/commit/b04d820c52310a1cb43342bbe71ad3919d36df7a))
- reload icon not showing on small size screens ([#187](https://github.com/daeuniverse/daed/issues/187)) ([7e8fc69](https://github.com/daeuniverse/daed/commit/7e8fc69e4ff3a7c895483b9d41a5390b44d89695))
- remove create config modal tabs ([4dbb755](https://github.com/daeuniverse/daed/commit/4dbb7550ba4e9d46f4ce225809b6a6ecdf470ed6))
- remove extra dns and routing spaces ([284ca83](https://github.com/daeuniverse/daed/commit/284ca832c5df14a47f88ad4f8e340e78fbd5dc1b))
- rename modal not closing after changing rule names ([#188](https://github.com/daeuniverse/daed/issues/188)) ([bfc7d3a](https://github.com/daeuniverse/daed/commit/bfc7d3a773857fa88ba13e56db68d62e85682180))
- set `DEFAULT_ENDPOINT_URL` `protocol` part the same as current url ([c76f32c](https://github.com/daeuniverse/daed/commit/c76f32cd0f043db566c819492279817196b4ca09))
- set DEFAULT_TPROXY_PORT to 12345, sync with doc ([bd972ac](https://github.com/daeuniverse/daed/commit/bd972acc25ccdc96c57999f85a6c65ebcdcadc6a))
- set notification color to red if error ([4265b59](https://github.com/daeuniverse/daed/commit/4265b59624857d52272c4cd0841c85d39a8e156f))
- **setup:** exact one admin account can be registered ([dced31f](https://github.com/daeuniverse/daed/commit/dced31fe04ba5a90821035b975ab3eb9e859b1b6))
- sortable grid layout issue ([6c4ff5c](https://github.com/daeuniverse/daed/commit/6c4ff5c24becdcf400d5498575dd7e52f472a32c))
- sortable grid sortable keys not resizing with unsorted items ([4e0b4f5](https://github.com/daeuniverse/daed/commit/4e0b4f51abcc05dbb3870af85102389ed066de99))
- sortable group ([a4d37de](https://github.com/daeuniverse/daed/commit/a4d37de1fc7c82da6218c38c5de4ff26c1e57baf))
- store imported by SortableGrid not found ([0e406d8](https://github.com/daeuniverse/daed/commit/0e406d8cc85f4367c5d4b86ee1d984806f8f652f))
- subscription drag overlay content ([31890ce](https://github.com/daeuniverse/daed/commit/31890cee04f92a8f4f1c159dac1caf8820dd788f))
- subscription drawer title ([04c5e3f](https://github.com/daeuniverse/daed/commit/04c5e3fd0ea2d673eb61ca587b802c7a5c2d6e9a))
- subscription nodes cursor should be grab ([f619c8c](https://github.com/daeuniverse/daed/commit/f619c8c700a7e34a5b3f7d23975dcef9d01169fb))
- **subscription:** importing subscription should allow partial success ([cb76e39](https://github.com/daeuniverse/daed/commit/cb76e3900da4736c32ee9d2439a3e063a80426b7))
- **subscription:** loading indicator of update should show on individual subscription ([c1533fb](https://github.com/daeuniverse/daed/commit/c1533fb224d5cf5733ad19a36050e7f596cc01d1))
- systemd service file description and service start command ([4b44321](https://github.com/daeuniverse/daed/commit/4b4432157f97e13c2c91fd73617cddae67deb0af))
- time parsing is wrong ([#171](https://github.com/daeuniverse/daed/issues/171)) ([ef08c0f](https://github.com/daeuniverse/daed/commit/ef08c0fc7d4ad2bd59f7bd9e8f068e20c1ada1e7))
- tproxyPort may be string type ([d12be19](https://github.com/daeuniverse/daed/commit/d12be1947da6f1bef7e8ca21b73a55c0b9207afd))
- try fixing caret misplacement ([#124](https://github.com/daeuniverse/daed/issues/124)) ([3ea42fa](https://github.com/daeuniverse/daed/commit/3ea42faa68e7fc04bbf50e80a5e7308d0c42b5fb))
- update form components to handle default values and error handling ([a71d4ce](https://github.com/daeuniverse/daed/commit/a71d4ced3073540cd75b0c1b43661d9a06ef09d7))
- update lint-staged configuration and improve component layout ([365fd2d](https://github.com/daeuniverse/daed/commit/365fd2dd68efbfc596037f09e8d0a430ced86ecd))
- update loading states in subscription actions and group form modal ([a71d4ce](https://github.com/daeuniverse/daed/commit/a71d4ced3073540cd75b0c1b43661d9a06ef09d7))
- update MainLayout for better container alignment ([8d34081](https://github.com/daeuniverse/daed/commit/8d3408164d7e66c3315d097e8808d3146c64273e))
- update publish-gh-pages job to trigger only on new releases ([a72d8e7](https://github.com/daeuniverse/daed/commit/a72d8e750e3c1cbf08607acb5f33c85a926a45f3))
- **v2ray:** add missing websocket path field ([#159](https://github.com/daeuniverse/daed/issues/159)) ([4932127](https://github.com/daeuniverse/daed/commit/49321273c51b1502f593c738e99bf6ac5a25f08a))
- **v2ray:** vmess websocket path emty ([#521](https://github.com/daeuniverse/daed/issues/521)) ([c4536d3](https://github.com/daeuniverse/daed/commit/c4536d38288a2816fdaccb56972dcd8e382d2275))
- val in key-val pair input fallback to null ([4095449](https://github.com/daeuniverse/daed/commit/4095449b9200bbabf0eeee23cdea33346517fa21))
- wan interface should be optional ([#156](https://github.com/daeuniverse/daed/issues/156)) ([f47abfa](https://github.com/daeuniverse/daed/commit/f47abfacc0c3f43c3b76eab5c92ddd87993bca82))
