// Theme definitions for daed color schemes
// Each theme includes both light and dark variants

export interface ThemeColors {
  // Background colors
  background: string
  foreground: string
  card: string
  cardForeground: string
  popover: string
  popoverForeground: string
  // Primary colors
  primary: string
  primaryForeground: string
  // Secondary colors
  secondary: string
  secondaryForeground: string
  // Muted colors
  muted: string
  mutedForeground: string
  // Accent colors
  accent: string
  accentForeground: string
  // Destructive colors
  destructive: string
  // Border and input
  border: string
  input: string
  ring: string
  // Chart colors
  chart1: string
  chart2: string
  chart3: string
  chart4: string
  chart5: string
  // Sidebar colors
  sidebar: string
  sidebarForeground: string
  sidebarPrimary: string
  sidebarPrimaryForeground: string
  sidebarAccent: string
  sidebarAccentForeground: string
  sidebarBorder: string
  sidebarRing: string
}

export interface ThemeDefinition {
  id: string
  name: string
  light: ThemeColors
  dark: ThemeColors
}

// Amber/Gold theme (current default)
export const amberTheme: ThemeDefinition = {
  id: 'amber',
  name: 'Amber',
  light: {
    background: 'oklch(0.99 0.008 85)',
    foreground: 'oklch(0.18 0.02 60)',
    card: 'oklch(0.99 0.008 85)',
    cardForeground: 'oklch(0.18 0.02 60)',
    popover: 'oklch(0.99 0.008 85)',
    popoverForeground: 'oklch(0.18 0.02 60)',
    primary: 'oklch(0.75 0.18 85)',
    primaryForeground: 'oklch(0.18 0.02 60)',
    secondary: 'oklch(0.96 0.015 85)',
    secondaryForeground: 'oklch(0.18 0.02 60)',
    muted: 'oklch(0.95 0.012 85)',
    mutedForeground: 'oklch(0.5 0.02 60)',
    accent: 'oklch(0.94 0.02 85)',
    accentForeground: 'oklch(0.18 0.02 60)',
    destructive: 'oklch(0.577 0.245 27.325)',
    border: 'oklch(0.92 0.015 85)',
    input: 'oklch(0.92 0.015 85)',
    ring: 'oklch(0.75 0.18 85)',
    chart1: 'oklch(0.75 0.18 85)',
    chart2: 'oklch(0.6 0.118 184.704)',
    chart3: 'oklch(0.398 0.07 227.392)',
    chart4: 'oklch(0.828 0.189 84.429)',
    chart5: 'oklch(0.769 0.188 70.08)',
    sidebar: 'oklch(0.985 0.01 85)',
    sidebarForeground: 'oklch(0.18 0.02 60)',
    sidebarPrimary: 'oklch(0.75 0.18 85)',
    sidebarPrimaryForeground: 'oklch(0.18 0.02 60)',
    sidebarAccent: 'oklch(0.94 0.02 85)',
    sidebarAccentForeground: 'oklch(0.18 0.02 60)',
    sidebarBorder: 'oklch(0.92 0.015 85)',
    sidebarRing: 'oklch(0.75 0.18 85)',
  },
  dark: {
    background: 'oklch(0.16 0.015 60)',
    foreground: 'oklch(0.95 0.015 85)',
    card: 'oklch(0.19 0.015 60)',
    cardForeground: 'oklch(0.95 0.015 85)',
    popover: 'oklch(0.19 0.015 60)',
    popoverForeground: 'oklch(0.95 0.015 85)',
    primary: 'oklch(0.82 0.165 85)',
    primaryForeground: 'oklch(0.16 0.015 60)',
    secondary: 'oklch(0.24 0.015 60)',
    secondaryForeground: 'oklch(0.95 0.015 85)',
    muted: 'oklch(0.24 0.015 60)',
    mutedForeground: 'oklch(0.65 0.02 70)',
    accent: 'oklch(0.26 0.02 65)',
    accentForeground: 'oklch(0.95 0.015 85)',
    destructive: 'oklch(0.55 0.2 25)',
    border: 'oklch(0.28 0.015 60)',
    input: 'oklch(0.3 0.015 60)',
    ring: 'oklch(0.82 0.165 85)',
    chart1: 'oklch(0.82 0.165 85)',
    chart2: 'oklch(0.696 0.17 162.48)',
    chart3: 'oklch(0.769 0.188 70.08)',
    chart4: 'oklch(0.627 0.265 303.9)',
    chart5: 'oklch(0.645 0.246 16.439)',
    sidebar: 'oklch(0.19 0.015 60)',
    sidebarForeground: 'oklch(0.95 0.015 85)',
    sidebarPrimary: 'oklch(0.82 0.165 85)',
    sidebarPrimaryForeground: 'oklch(0.16 0.015 60)',
    sidebarAccent: 'oklch(0.26 0.02 65)',
    sidebarAccentForeground: 'oklch(0.95 0.015 85)',
    sidebarBorder: 'oklch(0.28 0.015 60)',
    sidebarRing: 'oklch(0.82 0.165 85)',
  },
}

// Ocean Blue theme
export const oceanTheme: ThemeDefinition = {
  id: 'ocean',
  name: 'Ocean',
  light: {
    background: 'oklch(0.99 0.005 230)',
    foreground: 'oklch(0.18 0.02 230)',
    card: 'oklch(0.99 0.005 230)',
    cardForeground: 'oklch(0.18 0.02 230)',
    popover: 'oklch(0.99 0.005 230)',
    popoverForeground: 'oklch(0.18 0.02 230)',
    primary: 'oklch(0.6 0.18 230)',
    primaryForeground: 'oklch(0.99 0.005 230)',
    secondary: 'oklch(0.96 0.015 230)',
    secondaryForeground: 'oklch(0.18 0.02 230)',
    muted: 'oklch(0.95 0.01 230)',
    mutedForeground: 'oklch(0.5 0.02 230)',
    accent: 'oklch(0.94 0.02 230)',
    accentForeground: 'oklch(0.18 0.02 230)',
    destructive: 'oklch(0.577 0.245 27.325)',
    border: 'oklch(0.92 0.015 230)',
    input: 'oklch(0.92 0.015 230)',
    ring: 'oklch(0.6 0.18 230)',
    chart1: 'oklch(0.6 0.18 230)',
    chart2: 'oklch(0.65 0.15 180)',
    chart3: 'oklch(0.55 0.12 260)',
    chart4: 'oklch(0.7 0.14 200)',
    chart5: 'oklch(0.5 0.16 210)',
    sidebar: 'oklch(0.985 0.008 230)',
    sidebarForeground: 'oklch(0.18 0.02 230)',
    sidebarPrimary: 'oklch(0.6 0.18 230)',
    sidebarPrimaryForeground: 'oklch(0.99 0.005 230)',
    sidebarAccent: 'oklch(0.94 0.02 230)',
    sidebarAccentForeground: 'oklch(0.18 0.02 230)',
    sidebarBorder: 'oklch(0.92 0.015 230)',
    sidebarRing: 'oklch(0.6 0.18 230)',
  },
  dark: {
    background: 'oklch(0.16 0.02 230)',
    foreground: 'oklch(0.95 0.01 230)',
    card: 'oklch(0.19 0.02 230)',
    cardForeground: 'oklch(0.95 0.01 230)',
    popover: 'oklch(0.19 0.02 230)',
    popoverForeground: 'oklch(0.95 0.01 230)',
    primary: 'oklch(0.7 0.16 230)',
    primaryForeground: 'oklch(0.16 0.02 230)',
    secondary: 'oklch(0.24 0.02 230)',
    secondaryForeground: 'oklch(0.95 0.01 230)',
    muted: 'oklch(0.24 0.02 230)',
    mutedForeground: 'oklch(0.65 0.02 230)',
    accent: 'oklch(0.26 0.025 230)',
    accentForeground: 'oklch(0.95 0.01 230)',
    destructive: 'oklch(0.55 0.2 25)',
    border: 'oklch(0.28 0.02 230)',
    input: 'oklch(0.3 0.02 230)',
    ring: 'oklch(0.7 0.16 230)',
    chart1: 'oklch(0.7 0.16 230)',
    chart2: 'oklch(0.75 0.14 180)',
    chart3: 'oklch(0.65 0.12 260)',
    chart4: 'oklch(0.8 0.12 200)',
    chart5: 'oklch(0.6 0.15 210)',
    sidebar: 'oklch(0.19 0.02 230)',
    sidebarForeground: 'oklch(0.95 0.01 230)',
    sidebarPrimary: 'oklch(0.7 0.16 230)',
    sidebarPrimaryForeground: 'oklch(0.16 0.02 230)',
    sidebarAccent: 'oklch(0.26 0.025 230)',
    sidebarAccentForeground: 'oklch(0.95 0.01 230)',
    sidebarBorder: 'oklch(0.28 0.02 230)',
    sidebarRing: 'oklch(0.7 0.16 230)',
  },
}

// Rose/Pink theme
export const roseTheme: ThemeDefinition = {
  id: 'rose',
  name: 'Rose',
  light: {
    background: 'oklch(0.99 0.008 350)',
    foreground: 'oklch(0.18 0.02 350)',
    card: 'oklch(0.99 0.008 350)',
    cardForeground: 'oklch(0.18 0.02 350)',
    popover: 'oklch(0.99 0.008 350)',
    popoverForeground: 'oklch(0.18 0.02 350)',
    primary: 'oklch(0.65 0.2 350)',
    primaryForeground: 'oklch(0.99 0.008 350)',
    secondary: 'oklch(0.96 0.018 350)',
    secondaryForeground: 'oklch(0.18 0.02 350)',
    muted: 'oklch(0.95 0.015 350)',
    mutedForeground: 'oklch(0.5 0.02 350)',
    accent: 'oklch(0.94 0.02 350)',
    accentForeground: 'oklch(0.18 0.02 350)',
    destructive: 'oklch(0.577 0.245 27.325)',
    border: 'oklch(0.92 0.018 350)',
    input: 'oklch(0.92 0.018 350)',
    ring: 'oklch(0.65 0.2 350)',
    chart1: 'oklch(0.65 0.2 350)',
    chart2: 'oklch(0.6 0.15 320)',
    chart3: 'oklch(0.55 0.18 10)',
    chart4: 'oklch(0.7 0.16 340)',
    chart5: 'oklch(0.5 0.2 0)',
    sidebar: 'oklch(0.985 0.01 350)',
    sidebarForeground: 'oklch(0.18 0.02 350)',
    sidebarPrimary: 'oklch(0.65 0.2 350)',
    sidebarPrimaryForeground: 'oklch(0.99 0.008 350)',
    sidebarAccent: 'oklch(0.94 0.02 350)',
    sidebarAccentForeground: 'oklch(0.18 0.02 350)',
    sidebarBorder: 'oklch(0.92 0.018 350)',
    sidebarRing: 'oklch(0.65 0.2 350)',
  },
  dark: {
    background: 'oklch(0.16 0.02 350)',
    foreground: 'oklch(0.95 0.015 350)',
    card: 'oklch(0.19 0.02 350)',
    cardForeground: 'oklch(0.95 0.015 350)',
    popover: 'oklch(0.19 0.02 350)',
    popoverForeground: 'oklch(0.95 0.015 350)',
    primary: 'oklch(0.75 0.18 350)',
    primaryForeground: 'oklch(0.16 0.02 350)',
    secondary: 'oklch(0.24 0.02 350)',
    secondaryForeground: 'oklch(0.95 0.015 350)',
    muted: 'oklch(0.24 0.02 350)',
    mutedForeground: 'oklch(0.65 0.02 350)',
    accent: 'oklch(0.26 0.025 350)',
    accentForeground: 'oklch(0.95 0.015 350)',
    destructive: 'oklch(0.55 0.2 25)',
    border: 'oklch(0.28 0.02 350)',
    input: 'oklch(0.3 0.02 350)',
    ring: 'oklch(0.75 0.18 350)',
    chart1: 'oklch(0.75 0.18 350)',
    chart2: 'oklch(0.7 0.14 320)',
    chart3: 'oklch(0.65 0.16 10)',
    chart4: 'oklch(0.8 0.14 340)',
    chart5: 'oklch(0.6 0.18 0)',
    sidebar: 'oklch(0.19 0.02 350)',
    sidebarForeground: 'oklch(0.95 0.015 350)',
    sidebarPrimary: 'oklch(0.75 0.18 350)',
    sidebarPrimaryForeground: 'oklch(0.16 0.02 350)',
    sidebarAccent: 'oklch(0.26 0.025 350)',
    sidebarAccentForeground: 'oklch(0.95 0.015 350)',
    sidebarBorder: 'oklch(0.28 0.02 350)',
    sidebarRing: 'oklch(0.75 0.18 350)',
  },
}

// Emerald/Green theme
export const emeraldTheme: ThemeDefinition = {
  id: 'emerald',
  name: 'Emerald',
  light: {
    background: 'oklch(0.99 0.005 160)',
    foreground: 'oklch(0.18 0.02 160)',
    card: 'oklch(0.99 0.005 160)',
    cardForeground: 'oklch(0.18 0.02 160)',
    popover: 'oklch(0.99 0.005 160)',
    popoverForeground: 'oklch(0.18 0.02 160)',
    primary: 'oklch(0.6 0.17 160)',
    primaryForeground: 'oklch(0.99 0.005 160)',
    secondary: 'oklch(0.96 0.015 160)',
    secondaryForeground: 'oklch(0.18 0.02 160)',
    muted: 'oklch(0.95 0.01 160)',
    mutedForeground: 'oklch(0.5 0.02 160)',
    accent: 'oklch(0.94 0.018 160)',
    accentForeground: 'oklch(0.18 0.02 160)',
    destructive: 'oklch(0.577 0.245 27.325)',
    border: 'oklch(0.92 0.015 160)',
    input: 'oklch(0.92 0.015 160)',
    ring: 'oklch(0.6 0.17 160)',
    chart1: 'oklch(0.6 0.17 160)',
    chart2: 'oklch(0.55 0.14 130)',
    chart3: 'oklch(0.5 0.12 190)',
    chart4: 'oklch(0.65 0.15 145)',
    chart5: 'oklch(0.45 0.13 175)',
    sidebar: 'oklch(0.985 0.008 160)',
    sidebarForeground: 'oklch(0.18 0.02 160)',
    sidebarPrimary: 'oklch(0.6 0.17 160)',
    sidebarPrimaryForeground: 'oklch(0.99 0.005 160)',
    sidebarAccent: 'oklch(0.94 0.018 160)',
    sidebarAccentForeground: 'oklch(0.18 0.02 160)',
    sidebarBorder: 'oklch(0.92 0.015 160)',
    sidebarRing: 'oklch(0.6 0.17 160)',
  },
  dark: {
    background: 'oklch(0.16 0.02 160)',
    foreground: 'oklch(0.95 0.01 160)',
    card: 'oklch(0.19 0.02 160)',
    cardForeground: 'oklch(0.95 0.01 160)',
    popover: 'oklch(0.19 0.02 160)',
    popoverForeground: 'oklch(0.95 0.01 160)',
    primary: 'oklch(0.7 0.16 160)',
    primaryForeground: 'oklch(0.16 0.02 160)',
    secondary: 'oklch(0.24 0.02 160)',
    secondaryForeground: 'oklch(0.95 0.01 160)',
    muted: 'oklch(0.24 0.02 160)',
    mutedForeground: 'oklch(0.65 0.02 160)',
    accent: 'oklch(0.26 0.025 160)',
    accentForeground: 'oklch(0.95 0.01 160)',
    destructive: 'oklch(0.55 0.2 25)',
    border: 'oklch(0.28 0.02 160)',
    input: 'oklch(0.3 0.02 160)',
    ring: 'oklch(0.7 0.16 160)',
    chart1: 'oklch(0.7 0.16 160)',
    chart2: 'oklch(0.65 0.14 130)',
    chart3: 'oklch(0.6 0.12 190)',
    chart4: 'oklch(0.75 0.14 145)',
    chart5: 'oklch(0.55 0.13 175)',
    sidebar: 'oklch(0.19 0.02 160)',
    sidebarForeground: 'oklch(0.95 0.01 160)',
    sidebarPrimary: 'oklch(0.7 0.16 160)',
    sidebarPrimaryForeground: 'oklch(0.16 0.02 160)',
    sidebarAccent: 'oklch(0.26 0.025 160)',
    sidebarAccentForeground: 'oklch(0.95 0.01 160)',
    sidebarBorder: 'oklch(0.28 0.02 160)',
    sidebarRing: 'oklch(0.7 0.16 160)',
  },
}

// Violet/Purple theme
export const violetTheme: ThemeDefinition = {
  id: 'violet',
  name: 'Violet',
  light: {
    background: 'oklch(0.99 0.008 280)',
    foreground: 'oklch(0.18 0.02 280)',
    card: 'oklch(0.99 0.008 280)',
    cardForeground: 'oklch(0.18 0.02 280)',
    popover: 'oklch(0.99 0.008 280)',
    popoverForeground: 'oklch(0.18 0.02 280)',
    primary: 'oklch(0.58 0.2 280)',
    primaryForeground: 'oklch(0.99 0.008 280)',
    secondary: 'oklch(0.96 0.018 280)',
    secondaryForeground: 'oklch(0.18 0.02 280)',
    muted: 'oklch(0.95 0.015 280)',
    mutedForeground: 'oklch(0.5 0.02 280)',
    accent: 'oklch(0.94 0.02 280)',
    accentForeground: 'oklch(0.18 0.02 280)',
    destructive: 'oklch(0.577 0.245 27.325)',
    border: 'oklch(0.92 0.018 280)',
    input: 'oklch(0.92 0.018 280)',
    ring: 'oklch(0.58 0.2 280)',
    chart1: 'oklch(0.58 0.2 280)',
    chart2: 'oklch(0.55 0.18 250)',
    chart3: 'oklch(0.5 0.22 310)',
    chart4: 'oklch(0.65 0.16 265)',
    chart5: 'oklch(0.48 0.2 295)',
    sidebar: 'oklch(0.985 0.01 280)',
    sidebarForeground: 'oklch(0.18 0.02 280)',
    sidebarPrimary: 'oklch(0.58 0.2 280)',
    sidebarPrimaryForeground: 'oklch(0.99 0.008 280)',
    sidebarAccent: 'oklch(0.94 0.02 280)',
    sidebarAccentForeground: 'oklch(0.18 0.02 280)',
    sidebarBorder: 'oklch(0.92 0.018 280)',
    sidebarRing: 'oklch(0.58 0.2 280)',
  },
  dark: {
    background: 'oklch(0.16 0.025 280)',
    foreground: 'oklch(0.95 0.015 280)',
    card: 'oklch(0.19 0.025 280)',
    cardForeground: 'oklch(0.95 0.015 280)',
    popover: 'oklch(0.19 0.025 280)',
    popoverForeground: 'oklch(0.95 0.015 280)',
    primary: 'oklch(0.72 0.18 280)',
    primaryForeground: 'oklch(0.16 0.025 280)',
    secondary: 'oklch(0.24 0.025 280)',
    secondaryForeground: 'oklch(0.95 0.015 280)',
    muted: 'oklch(0.24 0.025 280)',
    mutedForeground: 'oklch(0.65 0.02 280)',
    accent: 'oklch(0.26 0.03 280)',
    accentForeground: 'oklch(0.95 0.015 280)',
    destructive: 'oklch(0.55 0.2 25)',
    border: 'oklch(0.28 0.025 280)',
    input: 'oklch(0.3 0.025 280)',
    ring: 'oklch(0.72 0.18 280)',
    chart1: 'oklch(0.72 0.18 280)',
    chart2: 'oklch(0.68 0.16 250)',
    chart3: 'oklch(0.6 0.2 310)',
    chart4: 'oklch(0.75 0.14 265)',
    chart5: 'oklch(0.58 0.18 295)',
    sidebar: 'oklch(0.19 0.025 280)',
    sidebarForeground: 'oklch(0.95 0.015 280)',
    sidebarPrimary: 'oklch(0.72 0.18 280)',
    sidebarPrimaryForeground: 'oklch(0.16 0.025 280)',
    sidebarAccent: 'oklch(0.26 0.03 280)',
    sidebarAccentForeground: 'oklch(0.95 0.015 280)',
    sidebarBorder: 'oklch(0.28 0.025 280)',
    sidebarRing: 'oklch(0.72 0.18 280)',
  },
}

// Slate/Neutral theme
export const slateTheme: ThemeDefinition = {
  id: 'slate',
  name: 'Slate',
  light: {
    background: 'oklch(0.99 0.002 260)',
    foreground: 'oklch(0.15 0.01 260)',
    card: 'oklch(0.99 0.002 260)',
    cardForeground: 'oklch(0.15 0.01 260)',
    popover: 'oklch(0.99 0.002 260)',
    popoverForeground: 'oklch(0.15 0.01 260)',
    primary: 'oklch(0.4 0.01 260)',
    primaryForeground: 'oklch(0.99 0.002 260)',
    secondary: 'oklch(0.96 0.005 260)',
    secondaryForeground: 'oklch(0.15 0.01 260)',
    muted: 'oklch(0.95 0.003 260)',
    mutedForeground: 'oklch(0.5 0.01 260)',
    accent: 'oklch(0.94 0.006 260)',
    accentForeground: 'oklch(0.15 0.01 260)',
    destructive: 'oklch(0.577 0.245 27.325)',
    border: 'oklch(0.92 0.005 260)',
    input: 'oklch(0.92 0.005 260)',
    ring: 'oklch(0.4 0.01 260)',
    chart1: 'oklch(0.5 0.08 260)',
    chart2: 'oklch(0.55 0.1 230)',
    chart3: 'oklch(0.45 0.06 290)',
    chart4: 'oklch(0.6 0.08 245)',
    chart5: 'oklch(0.4 0.07 275)',
    sidebar: 'oklch(0.985 0.003 260)',
    sidebarForeground: 'oklch(0.15 0.01 260)',
    sidebarPrimary: 'oklch(0.4 0.01 260)',
    sidebarPrimaryForeground: 'oklch(0.99 0.002 260)',
    sidebarAccent: 'oklch(0.94 0.006 260)',
    sidebarAccentForeground: 'oklch(0.15 0.01 260)',
    sidebarBorder: 'oklch(0.92 0.005 260)',
    sidebarRing: 'oklch(0.4 0.01 260)',
  },
  dark: {
    background: 'oklch(0.14 0.01 260)',
    foreground: 'oklch(0.95 0.005 260)',
    card: 'oklch(0.17 0.01 260)',
    cardForeground: 'oklch(0.95 0.005 260)',
    popover: 'oklch(0.17 0.01 260)',
    popoverForeground: 'oklch(0.95 0.005 260)',
    primary: 'oklch(0.7 0.01 260)',
    primaryForeground: 'oklch(0.14 0.01 260)',
    secondary: 'oklch(0.22 0.01 260)',
    secondaryForeground: 'oklch(0.95 0.005 260)',
    muted: 'oklch(0.22 0.01 260)',
    mutedForeground: 'oklch(0.65 0.01 260)',
    accent: 'oklch(0.24 0.012 260)',
    accentForeground: 'oklch(0.95 0.005 260)',
    destructive: 'oklch(0.55 0.2 25)',
    border: 'oklch(0.26 0.01 260)',
    input: 'oklch(0.28 0.01 260)',
    ring: 'oklch(0.7 0.01 260)',
    chart1: 'oklch(0.6 0.08 260)',
    chart2: 'oklch(0.65 0.1 230)',
    chart3: 'oklch(0.55 0.06 290)',
    chart4: 'oklch(0.7 0.08 245)',
    chart5: 'oklch(0.5 0.07 275)',
    sidebar: 'oklch(0.17 0.01 260)',
    sidebarForeground: 'oklch(0.95 0.005 260)',
    sidebarPrimary: 'oklch(0.7 0.01 260)',
    sidebarPrimaryForeground: 'oklch(0.14 0.01 260)',
    sidebarAccent: 'oklch(0.24 0.012 260)',
    sidebarAccentForeground: 'oklch(0.95 0.005 260)',
    sidebarBorder: 'oklch(0.26 0.01 260)',
    sidebarRing: 'oklch(0.7 0.01 260)',
  },
}

// Sunset/Orange theme
export const sunsetTheme: ThemeDefinition = {
  id: 'sunset',
  name: 'Sunset',
  light: {
    background: 'oklch(0.99 0.008 45)',
    foreground: 'oklch(0.18 0.02 30)',
    card: 'oklch(0.99 0.008 45)',
    cardForeground: 'oklch(0.18 0.02 30)',
    popover: 'oklch(0.99 0.008 45)',
    popoverForeground: 'oklch(0.18 0.02 30)',
    primary: 'oklch(0.65 0.2 30)',
    primaryForeground: 'oklch(0.99 0.008 45)',
    secondary: 'oklch(0.96 0.02 45)',
    secondaryForeground: 'oklch(0.18 0.02 30)',
    muted: 'oklch(0.95 0.015 45)',
    mutedForeground: 'oklch(0.5 0.02 30)',
    accent: 'oklch(0.94 0.025 45)',
    accentForeground: 'oklch(0.18 0.02 30)',
    destructive: 'oklch(0.577 0.245 27.325)',
    border: 'oklch(0.92 0.02 45)',
    input: 'oklch(0.92 0.02 45)',
    ring: 'oklch(0.65 0.2 30)',
    chart1: 'oklch(0.65 0.2 30)',
    chart2: 'oklch(0.7 0.18 50)',
    chart3: 'oklch(0.55 0.22 15)',
    chart4: 'oklch(0.75 0.15 60)',
    chart5: 'oklch(0.6 0.2 5)',
    sidebar: 'oklch(0.985 0.01 45)',
    sidebarForeground: 'oklch(0.18 0.02 30)',
    sidebarPrimary: 'oklch(0.65 0.2 30)',
    sidebarPrimaryForeground: 'oklch(0.99 0.008 45)',
    sidebarAccent: 'oklch(0.94 0.025 45)',
    sidebarAccentForeground: 'oklch(0.18 0.02 30)',
    sidebarBorder: 'oklch(0.92 0.02 45)',
    sidebarRing: 'oklch(0.65 0.2 30)',
  },
  dark: {
    background: 'oklch(0.16 0.02 30)',
    foreground: 'oklch(0.95 0.015 45)',
    card: 'oklch(0.19 0.02 30)',
    cardForeground: 'oklch(0.95 0.015 45)',
    popover: 'oklch(0.19 0.02 30)',
    popoverForeground: 'oklch(0.95 0.015 45)',
    primary: 'oklch(0.75 0.18 30)',
    primaryForeground: 'oklch(0.16 0.02 30)',
    secondary: 'oklch(0.24 0.02 30)',
    secondaryForeground: 'oklch(0.95 0.015 45)',
    muted: 'oklch(0.24 0.02 30)',
    mutedForeground: 'oklch(0.65 0.02 35)',
    accent: 'oklch(0.26 0.025 30)',
    accentForeground: 'oklch(0.95 0.015 45)',
    destructive: 'oklch(0.55 0.2 25)',
    border: 'oklch(0.28 0.02 30)',
    input: 'oklch(0.3 0.02 30)',
    ring: 'oklch(0.75 0.18 30)',
    chart1: 'oklch(0.75 0.18 30)',
    chart2: 'oklch(0.8 0.16 50)',
    chart3: 'oklch(0.65 0.2 15)',
    chart4: 'oklch(0.85 0.12 60)',
    chart5: 'oklch(0.7 0.18 5)',
    sidebar: 'oklch(0.19 0.02 30)',
    sidebarForeground: 'oklch(0.95 0.015 45)',
    sidebarPrimary: 'oklch(0.75 0.18 30)',
    sidebarPrimaryForeground: 'oklch(0.16 0.02 30)',
    sidebarAccent: 'oklch(0.26 0.025 30)',
    sidebarAccentForeground: 'oklch(0.95 0.015 45)',
    sidebarBorder: 'oklch(0.28 0.02 30)',
    sidebarRing: 'oklch(0.75 0.18 30)',
  },
}

// Teal theme
export const tealTheme: ThemeDefinition = {
  id: 'teal',
  name: 'Teal',
  light: {
    background: 'oklch(0.99 0.005 185)',
    foreground: 'oklch(0.18 0.02 185)',
    card: 'oklch(0.99 0.005 185)',
    cardForeground: 'oklch(0.18 0.02 185)',
    popover: 'oklch(0.99 0.005 185)',
    popoverForeground: 'oklch(0.18 0.02 185)',
    primary: 'oklch(0.6 0.15 185)',
    primaryForeground: 'oklch(0.99 0.005 185)',
    secondary: 'oklch(0.96 0.012 185)',
    secondaryForeground: 'oklch(0.18 0.02 185)',
    muted: 'oklch(0.95 0.01 185)',
    mutedForeground: 'oklch(0.5 0.02 185)',
    accent: 'oklch(0.94 0.015 185)',
    accentForeground: 'oklch(0.18 0.02 185)',
    destructive: 'oklch(0.577 0.245 27.325)',
    border: 'oklch(0.92 0.012 185)',
    input: 'oklch(0.92 0.012 185)',
    ring: 'oklch(0.6 0.15 185)',
    chart1: 'oklch(0.6 0.15 185)',
    chart2: 'oklch(0.55 0.13 160)',
    chart3: 'oklch(0.5 0.11 210)',
    chart4: 'oklch(0.65 0.14 175)',
    chart5: 'oklch(0.45 0.12 200)',
    sidebar: 'oklch(0.985 0.007 185)',
    sidebarForeground: 'oklch(0.18 0.02 185)',
    sidebarPrimary: 'oklch(0.6 0.15 185)',
    sidebarPrimaryForeground: 'oklch(0.99 0.005 185)',
    sidebarAccent: 'oklch(0.94 0.015 185)',
    sidebarAccentForeground: 'oklch(0.18 0.02 185)',
    sidebarBorder: 'oklch(0.92 0.012 185)',
    sidebarRing: 'oklch(0.6 0.15 185)',
  },
  dark: {
    background: 'oklch(0.16 0.02 185)',
    foreground: 'oklch(0.95 0.01 185)',
    card: 'oklch(0.19 0.02 185)',
    cardForeground: 'oklch(0.95 0.01 185)',
    popover: 'oklch(0.19 0.02 185)',
    popoverForeground: 'oklch(0.95 0.01 185)',
    primary: 'oklch(0.7 0.14 185)',
    primaryForeground: 'oklch(0.16 0.02 185)',
    secondary: 'oklch(0.24 0.02 185)',
    secondaryForeground: 'oklch(0.95 0.01 185)',
    muted: 'oklch(0.24 0.02 185)',
    mutedForeground: 'oklch(0.65 0.02 185)',
    accent: 'oklch(0.26 0.022 185)',
    accentForeground: 'oklch(0.95 0.01 185)',
    destructive: 'oklch(0.55 0.2 25)',
    border: 'oklch(0.28 0.02 185)',
    input: 'oklch(0.3 0.02 185)',
    ring: 'oklch(0.7 0.14 185)',
    chart1: 'oklch(0.7 0.14 185)',
    chart2: 'oklch(0.65 0.12 160)',
    chart3: 'oklch(0.6 0.1 210)',
    chart4: 'oklch(0.75 0.13 175)',
    chart5: 'oklch(0.55 0.11 200)',
    sidebar: 'oklch(0.19 0.02 185)',
    sidebarForeground: 'oklch(0.95 0.01 185)',
    sidebarPrimary: 'oklch(0.7 0.14 185)',
    sidebarPrimaryForeground: 'oklch(0.16 0.02 185)',
    sidebarAccent: 'oklch(0.26 0.022 185)',
    sidebarAccentForeground: 'oklch(0.95 0.01 185)',
    sidebarBorder: 'oklch(0.28 0.02 185)',
    sidebarRing: 'oklch(0.7 0.14 185)',
  },
}

// All available themes
export const themes: ThemeDefinition[] = [
  amberTheme,
  oceanTheme,
  roseTheme,
  emeraldTheme,
  violetTheme,
  slateTheme,
  sunsetTheme,
  tealTheme,
]

export const themeIds = themes.map((t) => t.id) as [string, ...string[]]

export type ThemeId = (typeof themes)[number]['id']

export const DEFAULT_THEME_ID: ThemeId = 'amber'

// Helper function to get theme by ID
export function getThemeById(id: string): ThemeDefinition | undefined {
  return themes.find((t) => t.id === id)
}

// Helper function to convert theme colors to CSS variables
export function themeColorsToCSSVars(colors: ThemeColors): Record<string, string> {
  return {
    '--background': colors.background,
    '--foreground': colors.foreground,
    '--card': colors.card,
    '--card-foreground': colors.cardForeground,
    '--popover': colors.popover,
    '--popover-foreground': colors.popoverForeground,
    '--primary': colors.primary,
    '--primary-foreground': colors.primaryForeground,
    '--secondary': colors.secondary,
    '--secondary-foreground': colors.secondaryForeground,
    '--muted': colors.muted,
    '--muted-foreground': colors.mutedForeground,
    '--accent': colors.accent,
    '--accent-foreground': colors.accentForeground,
    '--destructive': colors.destructive,
    '--border': colors.border,
    '--input': colors.input,
    '--ring': colors.ring,
    '--chart-1': colors.chart1,
    '--chart-2': colors.chart2,
    '--chart-3': colors.chart3,
    '--chart-4': colors.chart4,
    '--chart-5': colors.chart5,
    '--sidebar': colors.sidebar,
    '--sidebar-foreground': colors.sidebarForeground,
    '--sidebar-primary': colors.sidebarPrimary,
    '--sidebar-primary-foreground': colors.sidebarPrimaryForeground,
    '--sidebar-accent': colors.sidebarAccent,
    '--sidebar-accent-foreground': colors.sidebarAccentForeground,
    '--sidebar-border': colors.sidebarBorder,
    '--sidebar-ring': colors.sidebarRing,
  }
}
